/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.sortedfield;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.SortedFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SortedFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(SortedFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.SORT_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        List config = JsonUtil.parseArray((String)detailConfig.getConfig(), SortedFieldConfigModel.class);
        HussarException.throwByNull((Object)config, (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, List<SortedFieldConfigModel> config) {
        Set resultList;
        Set parentIds = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!parentIds.equals(resultList = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet())) ? 1 : 0) != 0, (String)"\u6392\u961f\u5b57\u6bb5\u524d\u540e\u53c2\u6570\u5217\u8868\u4e0d\u4e00\u81f4");
    }
}

