/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.output;

import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.model.OutPutConfigModel;
import com.jxdinfo.hussar.ds.process.constant.DataStreamConstant;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DsPatternUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.springframework.stereotype.Component;

@Component
public class OutputTaskParamParser
implements TaskParamParser {
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.OUT_PUT;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        OutPutConfigModel outPutConfigModel = (OutPutConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), OutPutConfigModel.class);
        HussarException.throwByNull((Object)outPutConfigModel, (String)String.format("\u83b7\u53d6\u8282\u70b9\uff1a%s\u53c2\u6570\u76f8\u5173\u914d\u7f6e\u5931\u8d25", this.getTaskType()));
        if (!HussarUtils.equals((Object)"db", (Object)outPutConfigModel.getSaveType())) {
            Long dataSetId = inputParamDto.getCtx().getDataSetId();
            outPutConfigModel.setTableName(String.format("DATA_STREAM_TMP_%s", dataSetId));
            outPutConfigModel.setTableComment(String.format("\u4e34\u65f6\u8868_%s", dataSetId));
        }
        this.checkParam(detailConfig, outPutConfigModel);
        return JsonUtil.toJson((Object)outPutConfigModel);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, OutPutConfigModel config) {
        if (HussarUtils.equals((Object)"db", (Object)config.getSaveType())) {
            HussarException.throwByNull((Object)config.getTableName(), (String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            HussarException.throwByNull((Object)config.getTableComment(), (String)"\u8868\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            HussarException.throwBy((!DsPatternUtil.matchesTableName((String)config.getTableName()) ? 1 : 0) != 0, (String)"\u8868\u540d\u683c\u5f0f\u9519\u8bef");
            HussarException.throwBy((config.getTableComment().length() > DataStreamConstant.DEFAULT_COLUMN_COMMEN_LENGTH ? 1 : 0) != 0, (String)"\u8868\u4e2d\u6587\u540d\u957f\u5ea6\u8fc7\u957f");
            if (config.getAutoTask().booleanValue()) {
                HussarException.throwByNull((Object)config.getFirstExecuteTime(), (String)"\u66f4\u65b0\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                HussarException.throwByNull((Object)config.getPeriodType(), (String)"\u66f4\u65b0\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                if (HussarUtils.equals((Object)"MINUTES", (Object)config.getPeriodType())) {
                    HussarException.throwByNull((Object)config.getMinutes(), (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5206\u949f\u65f6\uff0c\u8bf7\u586b\u5199\u5177\u4f53\u5206\u949f\u6570");
                    HussarException.throwBy((config.getMinutes() < 1 || config.getMinutes() > 60 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5206\u949f\u65f6\uff0c\u8bf7\u586b\u51991-60\u4e4b\u95f4\u7684\u5206\u949f\u6570");
                } else if (HussarUtils.equals((Object)"HOURS", (Object)config.getPeriodType())) {
                    HussarException.throwByNull((Object)config.getHours(), (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5c0f\u65f6\u65f6\uff0c\u8bf7\u586b\u5199\u5177\u4f53\u5c0f\u65f6\u6570");
                    HussarException.throwBy((config.getHours() < 1 || config.getHours() > 24 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5c0f\u65f6\u65f6\uff0c\u8bf7\u586b\u51991-24\u4e4b\u95f4\u7684\u5c0f\u65f6\u6570");
                } else if (HussarUtils.equals((Object)"DAYS", (Object)config.getPeriodType())) {
                    HussarException.throwByNull((Object)config.getTime(), (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5929\u65f6\uff0c\u8bf7\u586b\u5199\u5177\u4f53\u65f6\u95f4");
                } else if (HussarUtils.equals((Object)"WEEK", (Object)config.getPeriodType())) {
                    HussarException.throwByNull((Object)config.getWeek(), (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5468\u65f6\uff0c\u8bf7\u586b\u5199\u5177\u4f53\u5468\u6570");
                    HussarException.throwBy((config.getWeek() < 0 || config.getWeek() > 6 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5468\u65f6\uff0c\u8bf7\u586b\u51990-6\u4e4b\u95f4\u7684\u5468\u6570");
                    HussarException.throwByNull((Object)config.getTime(), (String)"\u66f4\u65b0\u5468\u671f\u4e3a\u5468\u65f6\uff0c\u8bf7\u586b\u5199\u5177\u4f53\u65f6\u95f4");
                } else {
                    throw new HussarException(Integer.valueOf(DpExceptionEnum.UNSUPPORTED_UPDATE_CYCLE_TYPE.getCode()), DpExceptionEnum.UNSUPPORTED_UPDATE_CYCLE_TYPE.getMessage());
                }
            }
        }
    }
}

