/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.masterfield;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.component.model.MasterFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(MasterFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.MASTER_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        MasterFieldConfigModel config = (MasterFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), MasterFieldConfigModel.class);
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, MasterFieldConfigModel config) {
        Set parentIds = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        Set addConstant = config.getDataSetList().stream().map(DataSetInputConfigModel::getFieldList).flatMap(Collection::stream).map(DataSetFieldDto::getFieldId).collect(Collectors.toSet());
        Set resultList = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        parentIds.addAll(addConstant);
        HussarException.throwBy((!parentIds.equals(resultList) ? 1 : 0) != 0, (String)"\u53c2\u6570\u5217\u8868\u5f02\u5e38");
    }
}

