/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.joinfield;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.component.model.JoinFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JoinFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(JoinFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.JOIN_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        JoinFieldConfigModel config = (JoinFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), JoinFieldConfigModel.class);
        HussarException.throwByNull((Object)config, (String)"\u83b7\u53d6\u53c2\u6570\u76f8\u5173\u914d\u7f6e\u5931\u8d25");
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, JoinFieldConfigModel config) {
        Set parentIds = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        Set addFieldIds = config.getDataSetList().stream().map(DataSetInputConfigModel::getFieldList).flatMap(Collection::stream).map(DataSetFieldDto::getFieldId).collect(Collectors.toSet());
        Set resultList = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        parentIds.addAll(addFieldIds);
        HussarException.throwBy((!parentIds.equals(resultList) ? 1 : 0) != 0, (String)"\u53c2\u6570\u5217\u8868\u5f02\u5e38");
    }
}

