/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.input;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSetInputTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(DataSetInputTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.DATA_SET_INPUT;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        DataSetInputConfigModel config = (DataSetInputConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), DataSetInputConfigModel.class);
        HussarException.throwByNull((Object)config, (String)"\u83b7\u53d6\u53c2\u6570\u76f8\u5173\u914d\u7f6e\u5931\u8d25");
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, DataSetInputConfigModel config) {
        Set parentIds = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        Set addConstant = config.getFieldList().stream().map(DataSetFieldDto::getFieldId).collect(Collectors.toSet());
        Set resultList = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        parentIds.addAll(addConstant);
        HussarException.throwBy((!parentIds.equals(resultList) ? 1 : 0) != 0, (String)"\u6570\u636e\u96c6\u5f55\u5165\u8282\u70b9\u53c2\u6570\u5f02\u5e38");
    }
}

