/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.groupfield;

import com.jxdinfo.hussar.ds.process.component.dto.AggregateFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.GroupFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.AggregateTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GroupFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(GroupFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.GROUP_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        GroupFieldConfigModel config = (GroupFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), GroupFieldConfigModel.class);
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, GroupFieldConfigModel config) {
        for (AggregateFieldDto aggregateFieldDto : config.getAggregateList()) {
            AggregateTypeEnum.getSql((String)aggregateFieldDto.getAggregateType());
        }
        List fieldIds = config.getGroupFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        Set paramSet = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!paramSet.containsAll(fieldIds) ? 1 : 0) != 0, (String)"\u539f\u59cb\u5b57\u6bb5\u5185\u4e0d\u5305\u542b\u5206\u7ec4\u5b57\u6bb5");
        Set groupResult = config.getAggregateList().stream().map(AggregateFieldDto::getFieldId).collect(Collectors.toSet());
        groupResult.addAll(fieldIds);
        Set resultSet = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!groupResult.equals(resultSet) ? 1 : 0) != 0, (String)"\u5206\u7ec4\u7ed3\u679c\u96c6\u5b57\u6bb5\u4e0e\u5206\u7ec4\u540e\u5b57\u6bb5\u4e0d\u7b26");
    }
}

