/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.filterfield;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.FilterFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FilterFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(FilterFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.FILTER_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        List config = JsonUtil.parseArray((String)detailConfig.getConfig(), FilterFieldConfigModel.class);
        boolean flag = config.stream().anyMatch(action -> HussarUtils.isEmpty((Object)action.getFieldId()) || HussarUtils.isEmpty((Object)action.getDataType()) || HussarUtils.isEmpty((Object)action.getMatch()) || HussarUtils.isEmpty((Object)action.getRule()));
        HussarException.throwBy((boolean)flag, (String)"\u7b5b\u9009\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        long count = config.stream().map(FilterFieldConfigModel::getMatch).distinct().count();
        HussarException.throwBy((count != 1L ? 1 : 0) != 0, (String)"\u5339\u914d\u6a21\u5f0f\u5fc5\u987b\u552f\u4e00");
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, List<FilterFieldConfigModel> config) {
        Set resultSet;
        Set paramSet = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!paramSet.equals(resultSet = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet())) ? 1 : 0) != 0, (String)"\u7ed3\u679c\u96c6\u5b57\u6bb5\u4e0e\u5165\u53c2\u5b57\u6bb5\u4e0d\u7b26");
    }
}

