/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.equationfield;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.EquationFieldConfigModel;
import com.jxdinfo.hussar.ds.process.constant.DataStreamConstant;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DsPatternUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EquationFieldTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(EquationFieldTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.EQUATION_FIELD;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        EquationFieldConfigModel config = (EquationFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), EquationFieldConfigModel.class);
        this.checkParam(detailConfig, config);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParam(CanvasDetailConfigDTO detailConfig, EquationFieldConfigModel config) {
        HussarException.throwByNull((Object)config.getForm(), (String)"\u516c\u5f0f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)config.getForm().getFieldName(), (String)"\u516c\u5f0f\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)config.getForm().getFieldComment(), (String)"\u516c\u5f0f\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)config.getFormula(), (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)config.getFormula().getFormulaStr(), (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((!DsPatternUtil.matchesColumnName((String)config.getForm().getFieldName()) ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        HussarException.throwBy((config.getForm().getFieldComment().length() > DataStreamConstant.DEFAULT_COLUMN_COMMEN_LENGTH ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u8fc7\u957f");
        List addColumnNames = detailConfig.getParentFieldList().stream().filter(field -> HussarUtils.isEmpty((Object)field.getGroupId())).map(ColumnFieldDto::getName).collect(Collectors.toList());
        HussarException.throwBy((boolean)addColumnNames.contains(config.getForm().getFieldName()), (String)"\u5b57\u6bb5\u7f16\u7801\u91cd\u590d");
        Set paramSet = detailConfig.getParentFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        paramSet.add(config.getForm().getFieldId());
        Set resultSet = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!paramSet.equals(resultSet) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u7ed3\u679c\u96c6\u5b57\u6bb5\u4e0e\u5206\u7ec4\u540e\u5b57\u6bb5\u4e0d\u7b26");
    }
}

