/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.function;

import com.jxdinfo.hussar.ds.common.exception.DpException;
import com.jxdinfo.hussar.ds.common.util.FileUtil;
import com.jxdinfo.hussar.ds.common.util.RenderUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;

public enum FunctionEnum {
    DEFAULT("default", "default", -1, "\u9ed8\u8ba4", false),
    REPLACE("replace", "replace", 0, "\u66ff\u6362", true),
    SUBSTRING("substring", "substring", 1, "\u622a\u53d6\u5b57\u7b26\u4e32", true),
    DATA_FORMAT("dataFormat", "dataFormat", 2, "\u65e5\u671f\u683c\u5f0f\u5316", true),
    SUBSTRING_BEFORE("substringBefore", "substringBefore", 3, "\u622a\u53d6\u7b26\u53f7\u4e4b\u524d\u7684\u5b57\u7b26", true),
    SUBSTRING_AFTER("substringAfter", "substringAfter", 4, "\u622a\u53d6\u7b26\u53f7\u4e4b\u540e\u7684\u5b57\u7b26", true),
    CLEAN_SPACE("cleanSpace", "cleanSpace", 5, "\u6e05\u9664\u7a7a\u683c", true),
    TRIM("trim", "trim", 6, "\u6e05\u9664\u5b57\u7b26\u4e32\u4e24\u7aef\u7684\u7a7a\u683c", true),
    AMOUNT_UPPER("amountUpper", "amountUpper", 7, "\u91d1\u989d\u5927\u5199", true),
    UPPER("upper", "upperCase", 8, "\u8f6c\u5927\u5199", true),
    LOWER("lower", "lowerCase", 9, "\u8f6c\u5c0f\u5199", true),
    MD5("md5", "md5", 10, "md5\u52a0\u5bc6", true),
    GET_API_DICT("getApiDict", "api/getApiDict", 1001, "\u83b7\u53d6api\u5b57\u5178", false),
    HTTP_GET("httpGet", "http/get", 2001, "http get\u8bf7\u6c42", false),
    HTTP_POST("httpPost", "http/post", 2002, "http post\u8bf7\u6c42", false),
    HTTP_POST_FORM_DATA("httpPostFormData", "http/postFormData", 2003, "http post\u8bf7\u6c42(form-data)", false),
    BOOLEAN_IN("boolean_in", "boolean/in", 3006, "\u5305\u542b", true),
    BOOLEAN_NOT_IN("boolean_not_in", "boolean/notIn", 3007, "\u4e0d\u5305\u542b", true),
    BOOLEAN_START_WITH("boolean_startWith", "boolean/startWith", 3008, "\u5f00\u5934", true),
    BOOLEAN_END_WITH("boolean_endWith", "boolean/endWith", 3009, "\u7ed3\u5c3e", true);

    public static final int BOOLEAN = 3000;
    @ApiModelProperty(value="\u65b9\u6cd5\u540d\u79f0")
    private String name;
    @ApiModelProperty(value="\u65b9\u6cd5\u5730\u5740")
    private String path;
    @ApiModelProperty(value="\u65b9\u6cd5\u4ee3\u53f7")
    private Integer type;
    @ApiModelProperty(value="\u65b9\u6cd5\u6ce8\u91ca")
    private String comment;
    @ApiModelProperty(value="\u53c2\u6570\u4e2d\u662f\u5426\u6709\u5b57\u6bb5\u672c\u8eab")
    private boolean filedParam;
    private static final String FUNCTION_FTL = "templete/function";

    private FunctionEnum(String name, String path, Integer type, String comment, boolean filedParam) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.comment = comment;
        this.filedParam = filedParam;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isFiledParam() {
        return this.filedParam;
    }

    public static FunctionEnum getFunctionEnum(Integer type) {
        for (FunctionEnum functionEnum : FunctionEnum.values()) {
            if (!functionEnum.getType().equals(type)) continue;
            return functionEnum;
        }
        return DEFAULT;
    }

    public static String getFunctions(Set<String> functionSet) {
        StringBuilder function = new StringBuilder();
        for (String functionName : functionSet) {
            String ftl = FileUtil.systemPath((String[])new String[]{FUNCTION_FTL, "/" + functionName + ".ftl"});
            try {
                function.append(RenderUtil.renderTemplate((String)ftl, null)).append("\n");
            }
            catch (DpException e) {
                throw new RuntimeException(e);
            }
        }
        return function.toString();
    }
}

