/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.utils;

import com.jxdinfo.hussar.common.exception.BaseException;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WordTemplateUtils {
    private static final Logger logger = LoggerFactory.getLogger(WordTemplateUtils.class);

    public static void export(Template template, Map<String, Object> totalMap, String fileName) {
        ServletOutputStream outputStream = null;
        OutputStreamWriter osw = null;
        Writer writer = null;
        try {
            outputStream = WordTemplateUtils.getHttpServletResponse(fileName).getOutputStream();
            osw = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
            writer = new BufferedWriter(osw);
            template.process(totalMap, writer);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new BaseException("\u8bfb\u53d6\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f\u540e\uff0c\u8d44\u6e90\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f\u540e\uff0c\u8d44\u6e90\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f\u540e\uff0c\u8d44\u6e90\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private static HttpServletResponse getHttpServletResponse(String fileName) throws Exception {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        response.setContentType("application/json;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName + ".doc", "UTF-8").replace("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        return response;
    }
}

