/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.datasource.config.rules.DbType;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.factory.SqlExecuteHandlerFactory;
import com.jxdinfo.hussar.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.DataBaseJsonService;
import com.jxdinfo.hussar.datasource.service.DataSourceService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.DataSourceServiceImpl")
@Primary
public class DataSourceServiceImpl
implements DataSourceService {
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private DataBaseJsonService dataBaseJsonService;
    @Autowired
    private Environment environment;
    @Autowired
    private DruidProperties dataSourceProperty;
    private static final String HOST_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})";
    private static final String PORT_REG = "(:\\d+)";
    private static final String SQL_SERVER_PORT_REG = "(port=\\d+)";
    private static final String DB_NAME_REG = "(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String SQL_SERVER_DB_NAME_REG = "(databaseName=|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String URL_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern HOST_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})");
    private static final Pattern PORT_PATTERN = Pattern.compile("(:\\d+)");
    private static final Pattern SLQ_SERVER_PORT_PATTERN = Pattern.compile("(port=\\d+)");
    private static final Pattern DB_NAME_PATTERN = Pattern.compile("(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern SQL_SERVER_DB_NAME_PATTERN = Pattern.compile("(databaseName=|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern URL_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+");

    @Override
    @HussarDs(value="#connName")
    public List<DsTableInfo> getDataSourceInfo(String connName, DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.selectBatch(dataSourceConfig, type);
        }
        return new ArrayList<DsTableInfo>();
    }

    @Override
    public List<DsTableInfo> getDataSourceInfoWithFieldInfo(String connName, DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.selectTableInfoWithFieldInfoBatch(dataSourceConfig, type);
        }
        return new ArrayList<DsTableInfo>();
    }

    @Override
    @HussarDs(value="#connName")
    public Optional<DsTableInfo> filterTable(String connName, DataSourceConfig dataSourceConfig, String type, String tableName) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.selectOne(dataSourceConfig, type, tableName);
        }
        return Optional.empty();
    }

    @Override
    @HussarDs(value="#connName")
    public List<DsTableInfo> getDataSourceTableInfo(String connName, DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.selectTableBatch(dataSourceConfig, type);
        }
        return new ArrayList<DsTableInfo>();
    }

    @Override
    @HussarDs(value="#connName")
    public List<DsTableInfo> filterTables(String connName, DataSourceConfig dataSourceConfig, String type, List<String> tableNames) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.selectTableInfoBatch(dataSourceConfig, type, tableNames);
        }
        return new ArrayList<DsTableInfo>();
    }

    @Override
    public String defaultDBTypeConfig() {
        return this.dataBaseJsonService.getDataSourceType();
    }

    @Override
    public List<DatasourceConfigDTO> getDataSourceList() throws IOException {
        List<DatasourceConfigDTO> configDTOList = this.getTenantList();
        return configDTOList;
    }

    public List<DatasourceConfigDTO> getTenantList() throws IOException {
        String delFlag = "0";
        ArrayList<DatasourceConfigDTO> configDTOList = new ArrayList();
        List allTenantDataSource = this.sysDataSourceService.list();
        if (HussarUtils.isNotEmpty((Object)allTenantDataSource)) {
            configDTOList = allTenantDataSource.stream().filter(e -> HussarUtils.equals((Object)delFlag, (Object)e.getDelFlag())).map(e -> this.ofBase((SysDataSource)e)).collect(Collectors.toList());
            return configDTOList;
        }
        throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u6e90\u4fe1\u606f\uff1a");
    }

    @Override
    public DatasourceConfigDTO getTenantDefault() {
        return new DatasourceConfigDTO();
    }

    @Override
    @HussarDs(value="#connName")
    public List<DsTableInfo> getTableInfoWithoutFiled(String connName, DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.getTableInfoWithoutFiled(dataSourceConfig, type);
        }
        return new ArrayList<DsTableInfo>();
    }

    @Override
    @HussarDs(value="#connName")
    public List<DsTableField> getTableFieldByTableName(String connName, DataSourceConfig dataSourceConfig, String tableName) {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandler sqlExecuteHandler = SqlExecuteHandlerFactory.getDataSourceHandler("ds.query." + dataSourceConfig.getDbTypeCustom().toLowerCase());
            return sqlExecuteHandler.getTableFieldByTableName(dataSourceConfig, tableName);
        }
        return new ArrayList<DsTableField>();
    }

    @Override
    public DatasourceConfigDTO getDatasourceConfig(SysDataSource sysDataSource) {
        return this.ofBase(sysDataSource);
    }

    private DatasourceConfigDTO ofBase(SysDataSource formDesignDataSource) {
        if (null == formDesignDataSource) {
            return new DatasourceConfigDTO();
        }
        DatasourceConfigDTO configDTO = new DatasourceConfigDTO();
        configDTO.setId(formDesignDataSource.getId());
        configDTO.setSchemaname(formDesignDataSource.getCurrentSchema());
        configDTO.setUsername(formDesignDataSource.getUserName());
        configDTO.setPassword(formDesignDataSource.getPassword());
        configDTO.setName(formDesignDataSource.getConnName());
        configDTO.setDesc(formDesignDataSource.getRemark());
        configDTO.setDbMode(formDesignDataSource.getDbMode());
        List<String> dbType = Arrays.asList("DATABASE", this.getTypeByDriverClass(formDesignDataSource.getDriverClass()));
        if (HussarUtils.isNotEmpty((Object)formDesignDataSource.getJdbcUrl()) && HussarUtils.isNotEmpty((Object)this.dataSourceProperty.getUrl())) {
            if (HussarUtils.equals((Object)formDesignDataSource.getJdbcUrl(), (Object)this.dataSourceProperty.getUrl())) {
                dbType = Arrays.asList("DATABASE", this.getTypeByDriverClass(formDesignDataSource.getDriverClass(), this.dataSourceProperty.getIsGauss()));
            } else if (HussarUtils.isNotEmpty((Object)formDesignDataSource.getDriverClass()) && HussarUtils.isNotEmpty((Object)formDesignDataSource.getDbMode()) && "org.postgresql.Driver".equals(formDesignDataSource.getDriverClass()) && "gauss_pg".equals(formDesignDataSource.getDbMode())) {
                dbType = Arrays.asList("DATABASE", this.getTypeByDriverClass(formDesignDataSource.getDriverClass(), true));
            }
        }
        configDTO.setDbType(dbType);
        String url = formDesignDataSource.getJdbcUrl();
        if (url.indexOf(63) > -1) {
            url = url.substring(0, url.indexOf(63));
        }
        String host = "";
        String port = "";
        String dbName = "";
        Matcher hostMatcher = HOST_PATTERN.matcher(url);
        if (hostMatcher.find(0)) {
            host = hostMatcher.group(0);
        }
        if (DbType.SQL_SERVER.getDriverClass().equals(formDesignDataSource.getDriverClass())) {
            Matcher urlMatcher;
            Matcher portMatcher = SLQ_SERVER_PORT_PATTERN.matcher(url);
            if (portMatcher.find(0)) {
                port = portMatcher.group(0).substring(5);
            }
            if ((urlMatcher = SQL_SERVER_DB_NAME_PATTERN.matcher(url)).find(0)) {
                dbName = urlMatcher.group(0).substring(13);
            }
        } else {
            Matcher urlMatcher;
            Matcher portMatcher = PORT_PATTERN.matcher(url);
            if (portMatcher.find(0)) {
                port = portMatcher.group(0).substring(1);
            }
            if ((urlMatcher = URL_PATTERN.matcher(url)).find()) {
                String urlName = urlMatcher.group(0);
                if (hostMatcher.find(0)) {
                    urlName = urlName.replace(hostMatcher.group(0), "");
                }
                if (portMatcher.find(0)) {
                    urlName = urlName.replace(portMatcher.group(0), "");
                }
                Matcher dbNameMatcher = DB_NAME_PATTERN.matcher(urlName);
                ArrayList<String> dbNameList = new ArrayList<String>();
                while (dbNameMatcher.find()) {
                    dbNameList.add(dbNameMatcher.group());
                }
                if (HussarUtils.isNotEmpty(dbNameList)) {
                    dbName = ((String)dbNameList.get(dbNameList.size() - 1)).substring(1);
                } else if (DbType.DM.getDriverClass().equalsIgnoreCase(formDesignDataSource.getDriverClass())) {
                    dbName = formDesignDataSource.getUserName();
                }
            }
        }
        configDTO.setDbName(dbName);
        configDTO.setHost(host);
        configDTO.setPort(port);
        return configDTO;
    }

    private String getTypeByDriverClass(String driverClass) {
        for (DbType typeEnum : DbType.values()) {
            if (!typeEnum.getDriverClass().equalsIgnoreCase(driverClass)) continue;
            return typeEnum.getValue().toUpperCase();
        }
        return "";
    }

    private String getTypeByDriverClass(String driverClass, boolean isGauss) {
        if (HussarUtils.isNotEmpty((Object)isGauss) && isGauss) {
            return DbType.GAUSS.getValue().toUpperCase();
        }
        for (DbType typeEnum : DbType.values()) {
            if (!typeEnum.getDriverClass().equalsIgnoreCase(driverClass)) continue;
            return typeEnum.getValue().toUpperCase();
        }
        return "";
    }

    private boolean isDataBaseDataSource(DatasourceConfigDTO configDTO) {
        return HussarUtils.isNotEmpty((Object)configDTO.getDbType()) && HussarUtils.equals(configDTO.getDbType().get(0), (Object)"DATABASE");
    }
}

