/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.common.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class WebServiceHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceHttpClient.class);
    private final RestTemplate restTemplate;

    public WebServiceHttpClient(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplate = restTemplateBuilder.build();
    }

    public String sendSoapRequest(String endpoint, String soapRequest, String soapAction, String soapVersion) {
        HttpHeaders headers = this.createSoapHeaders(soapAction, soapVersion);
        HttpEntity request = new HttpEntity((Object)soapRequest, (MultiValueMap)headers);
        this.logSoapRequest(endpoint, soapRequest, headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(endpoint, (Object)request, String.class, new Object[0]);
            this.logSoapResponse((ResponseEntity<String>)response);
            if (response.getStatusCode() == HttpStatus.FOUND) {
                return this.handleRedirect((ResponseEntity<String>)response, (HttpEntity<String>)request);
            }
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25: " + response.getStatusCode());
            }
            return (String)response.getBody();
        }
        catch (HttpClientErrorException e) {
            this.handleSoapError(e, soapVersion);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("SOAP\u8bf7\u6c42\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private HttpHeaders createSoapHeaders(String soapAction, String soapVersion) {
        HttpHeaders headers = new HttpHeaders();
        if ("SOAP 1.2 Protocol".equals(soapVersion)) {
            MediaType mediaType = new MediaType("application", "soap+xml", StandardCharsets.UTF_8);
            if (soapAction == null || !soapAction.isEmpty()) {
                // empty if block
            }
            headers.setContentType(mediaType);
        } else {
            headers.setContentType(new MediaType("text", "xml", StandardCharsets.UTF_8));
            if (soapAction != null && !soapAction.isEmpty()) {
                headers.add("SOAPAction", soapAction);
            } else {
                headers.add("SOAPAction", "\"\"");
            }
        }
        headers.add("Accept", "text/xml");
        headers.add("Cache-Control", "no-cache");
        return headers;
    }

    private void logSoapRequest(String endpoint, String soapRequest, HttpHeaders headers) {
        try {
            logger.debug(() -> "Sending SOAP Request to: " + endpoint);
            logger.debug(() -> "Request Headers:\n" + headers);
            logger.debug(() -> "Request Body:\n" + WebServiceHttpClient.formatXml(soapRequest));
        }
        catch (Exception e) {
            logger.warn(() -> "Failed to log SOAP request: " + e.getMessage());
        }
    }

    private void logSoapResponse(ResponseEntity<String> response) {
        try {
            logger.debug(() -> "Received SOAP Response. Status: " + response.getStatusCode());
            if (response.getBody() != null) {
                logger.debug(() -> "Response Body:\n" + WebServiceHttpClient.formatXml((String)response.getBody()));
            }
        }
        catch (Exception e) {
            logger.warn(() -> "Failed to log SOAP response: " + e.getMessage());
        }
    }

    private void handleSoapError(HttpClientErrorException e, String soapVersion) {
        String errorDetails = this.extractSoapFault(e.getResponseBodyAsString(), soapVersion);
        String errorMessage = "SOAP\u8bf7\u6c42\u9519\u8bef [" + e.getStatusCode() + "]: ";
        errorMessage = errorDetails != null ? errorMessage + errorDetails : errorMessage + "No fault details found";
        throw new RuntimeException(errorMessage, e);
    }

    private String extractSoapFault(String soapResponse, String soapVersion) {
        try {
            NodeList faultNodes;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(soapResponse)));
            String faultString = null;
            if ("SOAP 1.2 Protocol".equals(soapVersion)) {
                NodeList textNodes;
                NodeList reasonNodes = doc.getElementsByTagNameNS("*", "Reason");
                if (reasonNodes.getLength() > 0 && (textNodes = ((Element)reasonNodes.item(0)).getElementsByTagNameNS("*", "Text")).getLength() > 0) {
                    faultString = textNodes.item(0).getTextContent();
                }
            } else {
                NodeList faultStringNodes = doc.getElementsByTagNameNS("*", "faultstring");
                if (faultStringNodes.getLength() > 0) {
                    faultString = faultStringNodes.item(0).getTextContent();
                }
            }
            if (faultString == null && (faultNodes = doc.getElementsByTagNameNS("*", "Fault")).getLength() > 0) {
                faultString = faultNodes.item(0).getTextContent().trim();
            }
            return faultString;
        }
        catch (Exception ex) {
            return "\u89e3\u6790\u9519\u8bef\u65f6\u51fa\u9519: " + ex.getMessage();
        }
    }

    private String handleRedirect(ResponseEntity<String> response, HttpEntity<String> request) {
        String newLocation = response.getHeaders().getLocation().toString();
        return (String)this.restTemplate.postForEntity(newLocation, (Object)new HttpEntity(request.getBody(), (MultiValueMap)request.getHeaders()), String.class, new Object[0]).getBody();
    }

    private static String formatXml(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }
}

