/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private static OkHttpClient client = HttpUtil.client();

    private static OkHttpClient client() {
        if (client != null) {
            return client;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            return client;
        }
        catch (Exception e) {
            throw new HussarException("\u521d\u59cb\u5316 HttpClient \u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, Object> paramsMap, Map<String, Object> headersMap, Object bodyMap) {
        HttpUrl httpUrl;
        try {
            httpUrl = HttpUrl.parse((String)url);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5730\u5740\u65e0\u6548\uff1a{}", (Object)url);
            throw new HussarException("Http \u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u65e0\u6548\u3002");
        }
        if (httpUrl == null) return null;
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        HashMap<String, Object> allParams = new HashMap<String, Object>(paramsMap);
        for (Map.Entry entry : allParams.entrySet()) {
            urlBuilder.addQueryParameter((String)entry.getKey(), HttpUtil.convertToString(entry.getValue()));
        }
        String urlWithParams = urlBuilder.build().toString();
        Request.Builder requestBuilder = new Request.Builder().url(urlWithParams);
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> header : headersMap.entrySet()) {
                String headerValue = HttpUtil.convertToString(header.getValue());
                requestBuilder.addHeader(header.getKey(), headerValue);
            }
        }
        Request request = requestBuilder.build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", (Object)request.url(), (Object)request.headers());
        try (Response response = client.newCall(request).execute();){
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)responseBodyStr);
            String string = responseBodyStr;
            return string;
        }
        catch (IOException e) {
            throw new HussarException("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private static String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPost(String url, Object bodyData, Map<String, Object> paramsMap, Map<String, Object> headersMap) {
        String bodyJsonStr = JSON.toJSONString((Object)bodyData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.add("Content-Type", "application/json;charset=UTF-8");
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                headersBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Request request = new Request.Builder().url(urlBuilder.build()).post(requestBody).headers(headersBuilder.build()).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", new Object[]{request.url(), request.headers(), bodyJsonStr});
        try (Response response = client.newCall(request).execute();){
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)responseBodyStr);
            String string = responseBodyStr;
            return string;
        }
        catch (Exception exception) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostErrorNotReturn(String url, Object bodyData, Map<String, Object> paramsMap, Map<String, Object> headersMap) {
        String bodyJsonStr = JSON.toJSONString((Object)bodyData);
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.add("Content-Type", "application/json;charset=UTF-8");
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                headersBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Request request = new Request.Builder().url(urlBuilder.build()).post(requestBody).headers(headersBuilder.build()).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", new Object[]{request.url(), request.headers(), bodyJsonStr});
        try (Response response = client.newCall(request).execute();){
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)responseBodyStr);
            if (!HussarUtils.equals((Object)response.code(), (Object)200)) {
                String string = null;
                return string;
            }
            String string = responseBodyStr;
            return string;
        }
        catch (Exception exception) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostFormData(String url, Map<String, Object> formData, Map<String, Object> headersMap) {
        if (url == null) throw new IllegalArgumentException("URL \u4e0d\u80fd\u4e3a\u7a7a");
        if (url.isEmpty()) {
            throw new IllegalArgumentException("URL \u4e0d\u80fd\u4e3a\u7a7a");
        }
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (formData != null && !formData.isEmpty()) {
            for (Map.Entry<String, Object> entry : formData.entrySet()) {
                formBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        FormBody requestBody = formBuilder.build();
        Headers.Builder headersBuilder = new Headers.Builder();
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                headersBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).headers(headersBuilder.build()).build();
        HttpUtil.logRequestInfo(url, headersMap, formData);
        try (Response response = client.newCall(request).execute();){
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            HttpUtil.logResponseInfo(responseBodyStr);
            String string = responseBodyStr;
            return string;
        }
        catch (Exception e) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    private static void logRequestInfo(String url, Map<String, Object> headersMap, Map<String, Object> formData) {
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a" + url);
        logger.info("\u8bf7\u6c42\u5934\uff1a" + headersMap);
        logger.info("\u8bf7\u6c42\u4f53\uff1a" + formData);
    }

    private static void logResponseInfo(String responseBodyStr) {
        logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a" + responseBodyStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPut(String url, List<Map<String, Object>> bodyData, Map<String, Object> paramsMap, Map<String, Object> headersMap) {
        String bodyJsonStr = JSON.toJSONString(bodyData);
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        HttpUrl parsedUrl = HttpUrl.parse((String)url);
        if (parsedUrl == null) {
            throw new IllegalArgumentException("URL \u683c\u5f0f\u975e\u6cd5: " + url);
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.add("Content-Type", "application/json;charset=UTF-8");
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                headersBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Request request = new Request.Builder().url(urlBuilder.build()).put(requestBody).headers(headersBuilder.build()).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", new Object[]{request.url(), request.headers(), bodyJsonStr});
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new HussarException("\u8bf7\u6c42\u5f02\u5e38: " + response.message());
            }
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)responseBodyStr);
            String string = responseBodyStr;
            return string;
        }
        catch (Exception exception) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendDelete(String url, Map<String, Object> paramsMap, Map<String, Object> headersMap) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (paramsMap != null && !paramsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        if (headersMap != null && !headersMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                headersBuilder.add(entry.getKey(), HttpUtil.convertToString(entry.getValue()));
            }
        }
        Request request = new Request.Builder().url(urlBuilder.build()).headers(headersBuilder.build()).method("DELETE", null).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{}", (Object)request.url(), (Object)request.headers());
        try (Response response = client.newCall(request).execute();){
            String responseBodyStr = response.body() != null ? response.body().string() : "";
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)responseBodyStr);
            String string = responseBodyStr;
            return string;
        }
        catch (IOException iOException) {
            logger.error("\u7f51\u7edc\u9519\u8bef: {}", (Object)iOException.getMessage());
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)iOException);
        }
    }
}

