/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class JSExecutor {
    private JSExecutor() {
    }

    public static JSONObject executeDealReportJS(String doc, String options, String data) {
        ScriptEngine engine = null;
        try {
            engine = NashornPool.getEngine();
            Object editorDealReport = engine.get("editorDealReport");
            if (!(editorDealReport instanceof ScriptObjectMirror)) {
                throw new BaseException("editorDealReport\u672a\u6b63\u786e\u52a0\u8f7d");
            }
            ScriptObjectMirror editorMirror = (ScriptObjectMirror)editorDealReport;
            Object dealReport = editorMirror.get((Object)"DealReport");
            if (!(dealReport instanceof ScriptObjectMirror)) {
                throw new BaseException("DealReport\u672a\u6b63\u786e\u52a0\u8f7d");
            }
            Object result = ((Invocable)((Object)engine)).invokeMethod(dealReport, "handleFirstReport", doc, options, data);
            if (result instanceof ScriptObjectMirror) {
                JSONObject jSONObject = JSExecutor.scriptObjectMirrorConvert((ScriptObjectMirror)result);
                return jSONObject;
            }
            JSONObject jSONObject = null;
            return jSONObject;
        }
        catch (ScriptException e) {
            throw new BaseException("\u6267\u884cJS\u5185\u90e8\u5f02\u5e38", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BaseException("\u65b9\u6cd5\u5728JS\u4e2d\u672a\u627e\u5230", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BaseException("\u83b7\u53d6\u5f15\u64ce\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (engine != null) {
                NashornPool.releaseEngine(engine);
            }
        }
    }

    private static JSONObject scriptObjectMirrorConvert(ScriptObjectMirror mirror) {
        if (mirror == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : mirror.keySet()) {
            Object value = mirror.get((Object)key);
            if (value instanceof ScriptObjectMirror) {
                json.put(key, (Object)JSExecutor.scriptObjectMirrorConvert((ScriptObjectMirror)value));
                continue;
            }
            json.put(key, value);
        }
        return json;
    }

    private static class NashornPool {
        private static final int MAX_POOL_SIZE = 2;
        private static final BlockingQueue<ScriptEngine> ENGINE_POOL = new ArrayBlockingQueue<ScriptEngine>(2);
        private static final String JS_CODE;
        private static final ThreadLocal<ScriptEngine> threadEngine;

        private NashornPool() {
        }

        private static ScriptEngine createEngine() throws ScriptException {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.eval(JS_CODE);
            return engine;
        }

        public static ScriptEngine getEngine() throws InterruptedException {
            ScriptEngine engine = threadEngine.get();
            if (engine == null) {
                engine = ENGINE_POOL.take();
                threadEngine.set(engine);
            }
            return engine;
        }

        public static void releaseEngine(ScriptEngine engine) {
            try {
                if (!ENGINE_POOL.offer(engine, 100L, TimeUnit.MILLISECONDS)) {
                    // empty if block
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                threadEngine.remove();
            }
        }

        static {
            threadEngine = new ThreadLocal();
            try (InputStream is = JSExecutor.class.getClassLoader().getResourceAsStream("nashorn-bundle.js");){
                int bytesRead;
                if (is == null) {
                    throw new BaseException("JS\u8d44\u6e90\u672a\u627e\u5230");
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[8192];
                while ((bytesRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, bytesRead);
                }
                buffer.flush();
                JS_CODE = new String(buffer.toByteArray(), StandardCharsets.UTF_8);
                for (int i = 0; i < 2; ++i) {
                    ENGINE_POOL.add(NashornPool.createEngine());
                }
            }
            catch (Exception e) {
                throw new BaseException("JS\u8d44\u6e90\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

