/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.utils;

import com.jxdinfo.hussar.document.common.vo.DocumentSplitVo;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSplitOfUtil {
    private static Logger logger = LoggerFactory.getLogger(DocumentSplitOfUtil.class);

    public static DocumentSplitVo of(WordModelInfo parentDocument, WordEditorDetails parentDocumentDetail, List<WordModelInfo> wordModelInfos, List<WordEditorDetails> wordEditorDetails) {
        DocumentSplitVo documentSplitVo = DocumentSplitOfUtil.of(parentDocument, parentDocumentDetail);
        if (HussarUtils.isNotEmpty(wordModelInfos)) {
            ArrayList<DocumentSplitVo> child = new ArrayList<DocumentSplitVo>();
            for (WordModelInfo wordModelInfo : wordModelInfos) {
                logger.info("\u5b50\u6587\u6863id:{}", (Object)wordModelInfo.getId());
                if (!HussarUtils.isNotEmpty((Object)wordModelInfo) || !HussarUtils.isNotEmpty(wordEditorDetails) || !HussarUtils.isNotEmpty((Object)wordModelInfo.getDetailsId())) continue;
                for (WordEditorDetails wordEditorDetail : wordEditorDetails) {
                    Long detailsId;
                    if (!HussarUtils.isNotEmpty((Object)wordEditorDetail) || !HussarUtils.isNotEmpty((Object)(detailsId = Long.valueOf(wordModelInfo.getDetailsId()))) || !detailsId.equals(wordEditorDetail.getId())) continue;
                    logger.info("\u5b50\u8be6\u60c5id:{}", (Object)wordEditorDetail.getId());
                    child.add(DocumentSplitOfUtil.of(wordModelInfo, wordEditorDetail));
                }
            }
            documentSplitVo.setChildDocument(child);
        }
        return documentSplitVo;
    }

    public static DocumentSplitVo of(WordModelInfo parentDocument, WordEditorDetails parentDocumentDetail) {
        DocumentSplitVo documentSplitVo = new DocumentSplitVo();
        if (HussarUtils.isNotEmpty((Object)parentDocument)) {
            documentSplitVo.setId(parentDocument.getId());
            documentSplitVo.setModelCode(parentDocument.getModelCode());
            documentSplitVo.setModelName(parentDocument.getModelName());
            documentSplitVo.setGroupId(parentDocument.getGroupId());
            documentSplitVo.setModelVersion(parentDocument.getModelVersion());
            documentSplitVo.setModelStatus(parentDocument.getModelStatus());
            documentSplitVo.setEditStatus(parentDocument.getEditStatus());
            documentSplitVo.setValidTime(parentDocument.getValidTime());
            documentSplitVo.setDetailsId(parentDocument.getDetailsId());
            documentSplitVo.setParentModelId(parentDocument.getParentModelId());
            documentSplitVo.setDelFlag(parentDocument.getDelFlag());
            documentSplitVo.setCreateTime(parentDocument.getCreateTime());
            documentSplitVo.setLastTime(parentDocument.getLastTime());
            documentSplitVo.setCreator(parentDocument.getCreator());
            documentSplitVo.setLastEditor(parentDocument.getLastEditor());
        }
        if (HussarUtils.isNotEmpty((Object)parentDocumentDetail)) {
            documentSplitVo.setDocId(parentDocumentDetail.getDocId());
            documentSplitVo.setDetailStatus(parentDocumentDetail.getDetailStatus());
            documentSplitVo.setDetailContent(parentDocumentDetail.getDetailContent());
            documentSplitVo.setDetailOptions(parentDocumentDetail.getDetailOptions());
            documentSplitVo.setExtendedInfo(parentDocumentDetail.getExtendedInfo());
        }
        return documentSplitVo;
    }
}

