/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.editor.core.word.constant.WordConstant;
import com.jxdinfo.hussar.document.editor.core.word.util.DocumentConverter;
import com.jxdinfo.hussar.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.hussar.document.word.dto.WordEditorDetailsDto;
import com.jxdinfo.hussar.document.word.enums.OwnErrorEnum;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.date.StopWatch;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.wordEditorDetailsServiceImpl")
public class WordEditorDetailsServiceImpl
extends HussarServiceImpl<WordEditorDetailsMapper, WordEditorDetails>
implements WordEditorDetailsService {
    private static Logger logger = LoggerFactory.getLogger(WordEditorDetailsServiceImpl.class);
    @Resource
    private WordEditorDetailsMapper mapper;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Resource
    private WordEditorDetailsServiceImpl wordEditorDetailsService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Autowired
    private Executor taskExecutor;

    public ApiResponse<List<WordEditorDetails>> getList(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordEditorDetails::getId, (Object)id);
        List list = this.mapper.selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)list);
    }

    @HussarTransactional
    public ApiResponse<Integer> update(WordEditorDetails wordEditorDetails) {
        if (HussarUtils.isEmpty((Object)wordEditorDetails.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordEditorDetails::getId, (Object)wordEditorDetails.getId());
        int row = this.mapper.update(wordEditorDetails, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)row);
    }

    @HussarTransactional
    public ApiResponse<Integer> add(WordEditorDetails wordEditorDetails) {
        if (HussarUtils.isEmpty((Object)wordEditorDetails.getDocId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        wordEditorDetails.setDocId(wordEditorDetails.getDocId());
        int row = this.mapper.insert(wordEditorDetails);
        return ApiResponse.success((Object)row);
    }

    public ApiResponse<Integer> addWordEditorDetail(WordEditorDetails wordEditorDetails) {
        if (HussarUtils.isEmpty((Object)wordEditorDetails.getId())) {
            Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
            wordEditorDetails.setId(wordEditorDetailId);
        }
        int row = this.mapper.insert(wordEditorDetails);
        return ApiResponse.success((Object)row);
    }

    public ApiResponse<Long> addWordEditorDetail(Long docId, String extendedInfo, Map<String, String> parse) {
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        wordEditorDetails.setId(wordEditorDetailId);
        wordEditorDetails.setDocId(docId);
        wordEditorDetails.setExtendedInfo(extendedInfo);
        wordEditorDetails.setDetailContent(parse.get("detailContent"));
        wordEditorDetails.setDetailOptions(parse.get("detailOptions"));
        int insert = this.mapper.insert(wordEditorDetails);
        return ApiResponse.success((Object)wordEditorDetailId);
    }

    public ApiResponse<WordEditorDetails> getWordEditorDetailsById(Long businessId) {
        if (HussarUtils.isEmpty((Object)businessId)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.mapper.selectById(businessId);
        return ApiResponse.success((Object)wordEditorDetails);
    }

    public ApiResponse<WordEditorDetails> getWordEditorDetailsByDocId(Long docId) {
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getDocId, (Object)docId));
        return ApiResponse.success((Object)wordEditorDetails);
    }

    public ApiResponse<Long> updateWordEditorDetailById(Long businessId, Long docId, String extendedInfo, Map<String, String> parse) {
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            WordEditorDetails wordEditorDetails = new WordEditorDetails();
            wordEditorDetails.setDetailContent(parse.get("detailContent"));
            wordEditorDetails.setDetailOptions(parse.get("detailOptions"));
            wordEditorDetails.setDocId(docId);
            wordEditorDetails.setExtendedInfo(extendedInfo);
            LambdaQueryWrapper detailQueryWrapper = new LambdaQueryWrapper();
            detailQueryWrapper.eq(WordEditorDetails::getDocId, (Object)businessId);
            this.mapper.update(wordEditorDetails, (Wrapper)detailQueryWrapper);
            return ApiResponse.success((Object)businessId);
        }
        return this.addWordEditorDetail(docId, extendedInfo, parse);
    }

    public ApiResponse<Long> addOrUpdateDetailByDocId(Long docId, String extendedInfo, Map<String, String> parse) {
        if (HussarUtils.isNotEmpty((Object)docId)) {
            ApiResponse<WordEditorDetails> wordEditorDetailsByDocId = this.getWordEditorDetailsByDocId(docId);
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsByDocId.getData())) {
                return this.updateWordEditorDetailById(((WordEditorDetails)wordEditorDetailsByDocId.getData()).getId(), docId, extendedInfo, parse);
            }
            return this.addWordEditorDetail(docId, extendedInfo, parse);
        }
        return null;
    }

    public ApiResponse<Long> insertOrUpdate(WordEditorDetails wordEditorDetails) {
        this.saveOrUpdate((BaseEntity)wordEditorDetails);
        return ApiResponse.success((Object)wordEditorDetails.getId());
    }

    public Long creatReportDocument(WordEditorDetailsDto wordEditorDetailsDto) {
        WordModelInfo wordModelInfo = new WordModelInfo();
        if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto) && HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getWordEditorDetails())) {
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getDetailsId()) && HussarUtils.isEmpty((Object)wordEditorDetailsDto.getWordEditorDetails().getId())) {
                wordEditorDetailsDto.getWordEditorDetails().setId(wordEditorDetailsDto.getDetailsId());
            }
            ApiResponse<Long> longApiResponse = this.wordEditorDetailsService.insertOrUpdate(wordEditorDetailsDto.getWordEditorDetails());
            Map params = wordEditorDetailsDto.getParams();
            if (HussarUtils.isNotEmpty((Object)params)) {
                if (HussarUtils.isNotEmpty(params.get("docId"))) {
                    wordModelInfo.setId(Long.valueOf(params.get("docId").toString()));
                } else {
                    wordModelInfo.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
                }
                wordModelInfo.setModelName(params.get("modelName").toString());
                if (HussarUtils.isNotEmpty(params.get("groupId"))) {
                    wordModelInfo.setGroupId(Long.valueOf(params.get("groupId").toString()));
                } else {
                    wordModelInfo.setGroupId(WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
                }
                if (ToolUtil.isNotEmpty(params.get("parentModelId"))) {
                    wordModelInfo.setParentModelId(Long.valueOf(params.get("parentModelId").toString()));
                }
                wordModelInfo.setDetailsId(String.valueOf(longApiResponse.getData()));
                this.wordModelInfoService.saveOrUpdate((BaseEntity)wordModelInfo);
                String modelName = params.get("modelName").toString();
                this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordModelInfo.getId(), modelName, DocumentType.WORD_REPORT.getTypeCode());
                return wordModelInfo.getId();
            }
        }
        return -1L;
    }

    @HussarTransactional
    public void changeHistoryDocNum() {
        LambdaQueryWrapper wrapper;
        Page pageInfo;
        Page resultPage;
        List batchList;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Total Conversion");
        long totalRecords = this.count();
        int totalPages = (int)Math.ceil((double)totalRecords / 1000.0);
        for (int page = 1; page <= totalPages && !(batchList = (resultPage = (Page)this.mapper.selectPage((IPage)(pageInfo = new Page((long)page, 1000L)), (Wrapper)(wrapper = new LambdaQueryWrapper()))).getRecords()).isEmpty(); ++page) {
            this.processBatchInParallel(batchList);
            logger.info("\u5df2\u5904\u7406 {}/{} \u9875\uff0c\u5171 {} \u6761\u8bb0\u5f55", new Object[]{page, totalPages, page * 1000});
        }
        stopWatch.stop();
        logger.info("\u8f6c\u6362\u5b8c\u6210! \u8017\u65f6: " + stopWatch.getTotalTimeSeconds() + "\u79d2");
    }

    public void changeHistoryDocNumById(Long detailId) {
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.mapper.selectById(detailId);
        this.processSingleRecord(wordEditorDetails);
    }

    private void processBatchInParallel(List<WordEditorDetails> batchList) {
        CompletableFuture[] futures = (CompletableFuture[])batchList.stream().map(detail -> CompletableFuture.runAsync(() -> this.processSingleRecord((WordEditorDetails)detail), this.taskExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    private void processSingleRecord(WordEditorDetails detail) {
        try {
            String originalContent = detail.getDetailContent();
            if (HussarUtils.isEmpty((Object)originalContent)) {
                logger.error("content \u4e3anull\uff0c\u8bb0\u5f55ID: " + detail.getId());
                return;
            }
            String resultContent = DocumentConverter.convertDocumentFormat((String)originalContent);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.eq(WordEditorDetails::getId, (Object)detail.getId())).set(WordEditorDetails::getDetailContent, (Object)resultContent);
            this.mapper.update(null, (Wrapper)updateWrapper);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362\u5931\u8d25\uff0c\u8bb0\u5f55ID: " + detail.getId() + ", \u9519\u8bef: " + e.getMessage());
        }
    }

    public Long copyEditorDetails(WordEditorDetails oldWordEditorDetails) {
        if (HussarUtils.isNotEmpty((Object)oldWordEditorDetails)) {
            WordEditorDetails copyWordDetail = new WordEditorDetails();
            long detailId = IdUtil.getSnowflakeNextId();
            copyWordDetail.setId(Long.valueOf(detailId));
            copyWordDetail.setDocId(null);
            copyWordDetail.setDetailContent(oldWordEditorDetails.getDetailContent());
            copyWordDetail.setDetailOptions(oldWordEditorDetails.getDetailOptions());
            ApiResponse<Integer> integerApiResponse = this.wordEditorDetailsService.addWordEditorDetail(copyWordDetail);
            if (integerApiResponse.isSuccess()) {
                return detailId;
            }
        }
        return null;
    }
}

