/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dao.WordDocTypeInfoMapper;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.word.dto.WordModelInfoDto;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IWordDocImportService;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.WordModelInfoService;
import com.jxdinfo.hussar.document.word.service.WordParticularService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordDocImportServiceImpl")
public class WordDocImportServiceImpl
implements IWordDocImportService {
    private static Logger logger = LoggerFactory.getLogger(WordDocImportServiceImpl.class);
    @Autowired
    private WordModelInfoService wordModelInfoService;
    @Resource
    private WordParticularService wordParticularService;
    @Resource
    private WordEditorDetailsService wordEditorDetailsService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;

    public ApiResponse<Long> importDoc(MultipartFile file, Long groupId, String docName) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        try {
            Map parse = this.wordParticularService.wordParticularImport(file);
            if (parse == null || parse.isEmpty()) {
                logger.error("\u6587\u6863\u89e3\u6790\u5931\u8d25\uff1a\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a");
                return ApiResponse.fail((String)"\u6587\u6863\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
            if (parse.containsKey("error") || parse.containsKey("ERROR")) {
                String errorMsg = parse.get("error") != null ? (String)parse.get("error") : (String)parse.get("ERROR");
                logger.error("\u6587\u6863\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)errorMsg);
                return ApiResponse.fail((String)("\u6587\u6863\u89e3\u6790\u5931\u8d25\uff1a" + errorMsg));
            }
            ApiResponse longApiResponse = this.wordEditorDetailsService.addWordEditorDetail(null, "1", parse);
            if (!longApiResponse.isSuccess()) {
                logger.error("\u6587\u6863\u8be6\u60c5\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)longApiResponse.getMsg());
                return ApiResponse.fail((String)("\u6587\u6863\u8be6\u60c5\u4fdd\u5b58\u5931\u8d25\uff1a" + longApiResponse.getMsg()));
            }
            WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
            wordModelInfoDto.setModelName(docName);
            wordModelInfoDto.setGroupId(groupId);
            wordModelInfoDto.setDetailsId(((Long)longApiResponse.getData()).toString());
            ApiResponse modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
            if (!modelApiResponse.isSuccess()) {
                logger.error("\u6a21\u677f\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)modelApiResponse.getMsg());
                return ApiResponse.fail((String)("\u6a21\u677f\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a" + modelApiResponse.getMsg()));
            }
            this.wordTypeInfoService.addOrUpdateWordDocTypeInfo((Long)modelApiResponse.getData(), docName, DocumentType.WORD_MODEL.getTypeCode());
            String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
            logger.info("\u672c\u6b21({})\u5bfc\u5165\u8017\u65f6\u4e3a\uff1a{}s", (Object)docName, (Object)useTime);
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
            return modelApiResponse;
        }
        catch (Exception e) {
            logger.error("\u6587\u6863\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return ApiResponse.fail((String)("\u6587\u6863\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public void importHistoryModelInfoType() {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        List linkedIds = ((WordDocTypeInfoMapper)this.wordTypeInfoService.getBaseMapper()).selectList(null).stream().map(WordDocTypeInfo::getReportId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(linkedIds)) {
            queryWrapper.notIn(WordModelInfo::getId, linkedIds);
        } else {
            queryWrapper.isNotNull(WordModelInfo::getId);
        }
        List wordModelInfos = this.wordModelInfoService.getBaseMapper().selectList((Wrapper)queryWrapper);
        ArrayList<WordDocTypeInfo> wordDocTypeInfoList = new ArrayList<WordDocTypeInfo>();
        for (WordModelInfo modelInfo : wordModelInfos) {
            WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
            Long modelId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(modelId);
            wordDocTypeInfo.setReportId(modelInfo.getId());
            wordDocTypeInfo.setReportType(DocumentType.WORD_MODEL.getTypeCode());
            wordDocTypeInfo.setReportName(modelInfo.getModelName());
            wordDocTypeInfoList.add(wordDocTypeInfo);
        }
        this.wordTypeInfoService.saveBatch(wordDocTypeInfoList);
        String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
        logger.info("\u672c\u6b21\u6570\u636e\u66f4\u65b0\u8017\u65f6\u4e3a\uff1a" + useTime + "s");
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
    }
}

