/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Strings;
import com.jxdinfo.hussar.document.word.dao.WordDocGroupInfoMapper;
import com.jxdinfo.hussar.document.word.dto.WordDocGroupInfoDto;
import com.jxdinfo.hussar.document.word.enums.OwnErrorEnum;
import com.jxdinfo.hussar.document.word.model.WordDocGroupInfo;
import com.jxdinfo.hussar.document.word.service.WordDocGroupInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.wordDocGroupInfoServiceImpl")
public class WordDocGroupInfoServiceImpl
implements WordDocGroupInfoService {
    @Resource
    private WordDocGroupInfoMapper mapper;

    public ApiResponse<List<WordDocGroupInfo>> getList(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordDocGroupInfo::getParentId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        return ApiResponse.success((Object)list);
    }

    @HussarTransactional
    public ApiResponse<Integer> update(WordDocGroupInfo wordDocGroupInfo) {
        if (HussarUtils.isEmpty((Object)wordDocGroupInfo.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        wordDocGroupInfo.setDelFlag("0");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordDocGroupInfo::getId, (Object)wordDocGroupInfo.getId());
        int row = this.mapper.update(wordDocGroupInfo, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)row);
    }

    @HussarTransactional
    public ApiResponse<Integer> add(WordDocGroupInfoDto wordDocGroupInfoDto) {
        if (Strings.isNullOrEmpty((String)wordDocGroupInfoDto.getGroupName()) || HussarUtils.isEmpty((Object)wordDocGroupInfoDto.getParentId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordDocGroupInfo wordDocGroupInfo = new WordDocGroupInfo();
        wordDocGroupInfo.setGroupName(wordDocGroupInfoDto.getGroupName());
        wordDocGroupInfo.setParentId(wordDocGroupInfoDto.getParentId());
        int row = this.mapper.insert(wordDocGroupInfo);
        return ApiResponse.success((Object)row);
    }

    @HussarTransactional
    public ApiResponse<Integer> delete(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        int row = this.mapper.deleteById(id);
        return ApiResponse.success((Object)row);
    }
}

