/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dao.WordDocTypeInfoMapper;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.word.dto.WordModelInfoDto;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IWordDocImportService;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.WordModelInfoService;
import com.jxdinfo.hussar.document.word.service.WordParticularService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordDocImportServiceImpl")
public class WordDocImportServiceImpl
implements IWordDocImportService {
    private static Logger logger = LoggerFactory.getLogger(WordDocImportServiceImpl.class);
    @Autowired
    private WordModelInfoService wordModelInfoService;
    @Resource
    private WordParticularService wordParticularService;
    @Resource
    private WordEditorDetailsService wordEditorDetailsService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;

    public ApiResponse<Long> importDoc(MultipartFile file, Long groupId, String docName) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        Map parse = this.wordParticularService.wordParticularImport(file);
        ApiResponse longApiResponse = this.wordEditorDetailsService.addWordEditorDetail(null, "1", parse);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(docName);
        wordModelInfoDto.setGroupId(groupId);
        wordModelInfoDto.setDetailsId(((Long)longApiResponse.getData()).toString());
        ApiResponse modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo((Long)modelApiResponse.getData(), docName, DocumentType.WORD_MODEL.getTypeCode());
        String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
        logger.info("\u672c\u6b21({})\u5bfc\u5165\u8017\u65f6\u4e3a\uff1a{}s", (Object)docName, (Object)useTime);
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        return modelApiResponse;
    }

    public void importHistoryModelInfoType() {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        System.out.print("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        List linkedIds = ((WordDocTypeInfoMapper)this.wordTypeInfoService.getBaseMapper()).selectList(null).stream().map(WordDocTypeInfo::getReportId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(linkedIds)) {
            queryWrapper.notIn(WordModelInfo::getId, linkedIds);
        } else {
            queryWrapper.isNotNull(WordModelInfo::getId);
        }
        List wordModelInfos = this.wordModelInfoService.getBaseMapper().selectList((Wrapper)queryWrapper);
        ArrayList<WordDocTypeInfo> wordDocTypeInfoList = new ArrayList<WordDocTypeInfo>();
        for (WordModelInfo modelInfo : wordModelInfos) {
            WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
            Long modelId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(modelId);
            wordDocTypeInfo.setReportId(modelInfo.getId());
            wordDocTypeInfo.setReportType(DocumentType.WORD_MODEL.getTypeCode());
            wordDocTypeInfo.setReportName(modelInfo.getModelName());
            wordDocTypeInfoList.add(wordDocTypeInfo);
        }
        this.wordTypeInfoService.saveBatch(wordDocTypeInfoList);
        String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
        System.out.print("\u672c\u6b21\u6570\u636e\u66f4\u65b0\u8017\u65f6\u4e3a\uff1a" + useTime + "s");
        System.out.print("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
    }
}

