/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dao.DocumentInfoMapper;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.impl.WordDocUpdateService;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WordDocUpdateServiceImpl
extends HussarBaseServiceImpl<DocumentInfoMapper, WordDocTypeInfo>
implements WordDocUpdateService {
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;

    @Override
    public void importHistoryModelInfoType() {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        System.out.print("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        List linkedIds = ((DocumentInfoMapper)this.getBaseMapper()).selectList(null).stream().map(WordDocTypeInfo::getReportId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(linkedIds)) {
            queryWrapper.notIn(WordModelInfo::getId, linkedIds);
        } else {
            queryWrapper.isNotNull(WordModelInfo::getId);
        }
        List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)queryWrapper);
        ArrayList<WordDocTypeInfo> wordDocTypeInfoList = new ArrayList<WordDocTypeInfo>();
        for (WordModelInfo modelInfo : wordModelInfos) {
            WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
            Long modelId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(modelId);
            wordDocTypeInfo.setReportId(modelInfo.getId());
            wordDocTypeInfo.setReportType(DocumentType.WORD_MODEL.getTypeCode());
            wordDocTypeInfo.setReportName(modelInfo.getModelName());
            wordDocTypeInfoList.add(wordDocTypeInfo);
        }
        this.saveBatch(wordDocTypeInfoList);
        String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
        System.out.print("\u672c\u6b21\u6570\u636e\u66f4\u65b0\u8017\u65f6\u4e3a\uff1a" + useTime + "s");
        System.out.print("<<<<<<<<<<<<<<<<<<<<<<<<\u5386\u53f2\u6570\u636e\u66f4\u65b0\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
    }
}

