/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.jxdinfo.hussar.document.word.bean.PageRequestBody;
import com.jxdinfo.hussar.document.word.dao.WordDocInfoMapper;
import com.jxdinfo.hussar.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.hussar.document.word.dto.WordDocInfoDto;
import com.jxdinfo.hussar.document.word.enums.OwnErrorEnum;
import com.jxdinfo.hussar.document.word.model.WordDocInfo;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.service.WordDocInfoService;
import com.jxdinfo.hussar.document.word.util.PageUtils;
import com.jxdinfo.hussar.document.word.vo.WordDocInfoSearchVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.wordDocInfoServiceImpl")
public class WordDocInfoServiceImpl
extends HussarServiceImpl<WordDocInfoMapper, WordDocInfo>
implements WordDocInfoService {
    @Resource
    private WordDocInfoMapper mapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;

    public ApiResponse<Page<WordDocInfo>> hussarQueryPage(PageRequestBody<WordDocInfo> pageRequestBody) {
        Page page = PageUtils.checkAndGenPage(pageRequestBody);
        WordDocInfo wordDocInfo = (WordDocInfo)pageRequestBody.getParams();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)wordDocInfo);
        queryWrapper.ne(HussarDelflagEntity::getDelFlag, (Object)"1");
        Page list = (Page)this.mapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)list);
    }

    public ApiResponse<WordDocInfoSearchVo> getWordDocInfoById(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordDocInfo::getId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        WordDocInfoSearchVo wordDocInfoSearchVo = new WordDocInfoSearchVo();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            wordDocInfoSearchVo.setDocId(((WordDocInfo)list.get(0)).getId());
            wordDocInfoSearchVo.setDocName(((WordDocInfo)list.get(0)).getDocName());
            wordDocInfoSearchVo.setGroupId(((WordDocInfo)list.get(0)).getGroupId());
            wordDocInfoSearchVo.setDocStatus(((WordDocInfo)list.get(0)).getDocStatus());
            wordDocInfoSearchVo.setEditStatus(((WordDocInfo)list.get(0)).getEditStatus());
            wordDocInfoSearchVo.setValidTime(((WordDocInfo)list.get(0)).getValidTime());
            wordDocInfoSearchVo.setDelFlag(((WordDocInfo)list.get(0)).getDelFlag());
            wordDocInfoSearchVo.setCreator(((WordDocInfo)list.get(0)).getCreator());
            wordDocInfoSearchVo.setLastEditor(((WordDocInfo)list.get(0)).getLastEditor());
            wordDocInfoSearchVo.setCreateTime(((WordDocInfo)list.get(0)).getCreateTime());
            wordDocInfoSearchVo.setLastTime(((WordDocInfo)list.get(0)).getLastTime());
            wordDocInfoSearchVo.setModelId(((WordDocInfo)list.get(0)).getModelId());
            wordDocInfoSearchVo.setModelCode(((WordDocInfo)list.get(0)).getModelCode());
        }
        LambdaQueryWrapper detailQueryWrapper = new LambdaQueryWrapper();
        detailQueryWrapper.eq(WordEditorDetails::getDocId, (Object)id);
        List details = this.wordEditorDetailsMapper.selectList((Wrapper)detailQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)details)) {
            wordDocInfoSearchVo.setDetailContent(((WordEditorDetails)details.get(0)).getDetailContent());
            wordDocInfoSearchVo.setDetailOptions(((WordEditorDetails)details.get(0)).getDetailOptions());
        }
        return ApiResponse.success((Object)wordDocInfoSearchVo);
    }

    @HussarTransactional
    public ApiResponse<Long> update(WordDocInfoDto wordDocInfoDto) {
        if (HussarUtils.isEmpty((Object)wordDocInfoDto.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordDocInfo::getId, (Object)wordDocInfoDto.getId());
        WordDocInfo wordDocInfo = new WordDocInfo();
        wordDocInfo.setId(wordDocInfoDto.getId());
        wordDocInfo.setDocName(wordDocInfoDto.getDocName());
        wordDocInfo.setGroupId(wordDocInfoDto.getGroupId());
        int rowInfo = this.mapper.update(wordDocInfo, (Wrapper)queryWrapper);
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        wordEditorDetails.setDetailContent(wordDocInfoDto.getDetailContent());
        wordEditorDetails.setDetailOptions(wordDocInfoDto.getDetailOptions());
        LambdaQueryWrapper detailQueryWrapper = new LambdaQueryWrapper();
        detailQueryWrapper.eq(WordEditorDetails::getDocId, (Object)wordDocInfoDto.getId());
        int rowDetail = this.wordEditorDetailsMapper.update(wordEditorDetails, (Wrapper)detailQueryWrapper);
        return ApiResponse.success((Object)wordDocInfoDto.getId());
    }

    @HussarTransactional
    public ApiResponse<Long> add(WordDocInfoDto wordDocInfoDto) {
        if (Strings.isNullOrEmpty((String)wordDocInfoDto.getDocName())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordDocInfo wordDocInfo = new WordDocInfo();
        Long docId = IdUtil.getSnowflakeNextId();
        wordDocInfo.setId(docId);
        wordDocInfo.setDocName(wordDocInfoDto.getDocName());
        wordDocInfo.setGroupId(wordDocInfoDto.getGroupId());
        int row = this.mapper.insert(wordDocInfo);
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        wordEditorDetails.setDocId(docId);
        wordEditorDetails.setDetailContent(wordDocInfoDto.getDetailContent());
        wordEditorDetails.setDetailOptions(wordDocInfoDto.getDetailOptions());
        int row2 = this.wordEditorDetailsMapper.insert(wordEditorDetails);
        return ApiResponse.success((Object)docId);
    }

    @HussarTransactional
    public ApiResponse<Boolean> delete(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordDocInfo wordDocInfo = new WordDocInfo();
        wordDocInfo.setId(id);
        wordDocInfo.setDelFlag("1");
        return ApiResponse.success((Object)this.updateById((BaseEntity)wordDocInfo));
    }
}

