/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.service.IWordTypeInfoService;
import com.jxdinfo.hussar.document.word.dto.WordModelInfoDto;
import com.jxdinfo.hussar.document.word.service.IWordDocImportService;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.WordModelInfoService;
import com.jxdinfo.hussar.document.word.service.WordParticularService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Calendar;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordDocImportServiceImpl")
public class WordDocImportServiceImpl
implements IWordDocImportService {
    private static Logger logger = LoggerFactory.getLogger(WordDocImportServiceImpl.class);
    @Autowired
    private WordModelInfoService wordModelInfoService;
    @Resource
    private WordParticularService wordParticularService;
    @Resource
    private WordEditorDetailsService wordEditorDetailsService;
    @Resource
    private IWordTypeInfoService wordTypeInfoService;

    public ApiResponse<Long> importDoc(MultipartFile file, Long groupId, String docName) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        Map parse = this.wordParticularService.wordParticularImport(file);
        ApiResponse longApiResponse = this.wordEditorDetailsService.addWordEditorDetail(null, "1", parse);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(docName);
        wordModelInfoDto.setGroupId(groupId);
        wordModelInfoDto.setDetailsId(((Long)longApiResponse.getData()).toString());
        ApiResponse modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        this.wordTypeInfoService.addWordTypeInfo((Long)modelApiResponse.getData(), docName, DocumentType.WORD_MODEL.getTypeCode());
        String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
        logger.info("\u672c\u6b21({})\u5bfc\u5165\u8017\u65f6\u4e3a\uff1a{}s", (Object)docName, (Object)useTime);
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u5165\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        return modelApiResponse;
    }
}

