/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.hussar.document.common.service.IFileService;
import com.jxdinfo.hussar.document.editor.core.word.util.PdfUtil;
import com.jxdinfo.hussar.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.hussar.document.word.extend.WordDesignerExtendFactory;
import com.jxdinfo.hussar.document.word.model.WordAndPdfRelationship;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IWordDocExportService;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.WordParticularService;
import com.jxdinfo.hussar.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.wordDocExportServiceImpl")
public class WordDocExportServiceImpl
implements IWordDocExportService {
    private static Logger logger = LoggerFactory.getLogger(WordDocExportServiceImpl.class);
    @Autowired
    private WordEditorDetailsService wordEditorDetailsService;
    @Resource
    private WordParticularService wordParticularService;
    @Resource
    private IFileService fileService;
    @Autowired
    private WordPdfRelationshipService wordPdfRelationshipService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;

    @HussarTransactional
    public void exportDoc(HttpServletResponse response, Long detailsId) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getId, (Object)detailsId));
        String name = "\u65e0\u6807\u9898\u6587\u6863";
        Map resultMap = WordDesignerExtendFactory.operationRule().customExportProcessing(detailsId.toString());
        if (HussarUtils.isNotEmpty((Object)resultMap) && HussarUtils.isNotEmpty(resultMap.get("docName"))) {
            name = resultMap.get("docName").toString();
        }
        String detailContent = wordEditorDetails.getDetailContent();
        String detailOptions = wordEditorDetails.getDetailOptions();
        HashMap<String, String> configDetails = new HashMap<String, String>();
        configDetails.put("detailContent", detailContent);
        configDetails.put("detailOptions", detailOptions);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("multipart/form-data");
            String downLoadFileName = URLEncoder.encode(name + ".docx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            this.wordParticularService.exportFile(configDetails, (OutputStream)out);
            String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
            logger.info("\u672c\u6b21({})\u5bfc\u51fa\u8017\u65f6\u4e3a\uff1a{}s", (Object)name, (Object)useTime);
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @HussarTransactional
    public void exportDocument(HttpServletResponse response, Long docId) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        String detailsId = wordModelInfo.getDetailsId();
        if (HussarUtils.isNotEmpty((Object)detailsId) && HussarUtils.isNotEmpty((Object)wordModelInfo) && HussarUtils.isNotEmpty((Object)wordModelInfo.getModelName())) {
            resultMap.put("docName", wordModelInfo.getModelName());
        }
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getId, (Object)detailsId));
        String name = "\u65e0\u6807\u9898\u6587\u6863";
        if (HussarUtils.isNotEmpty(resultMap) && HussarUtils.isNotEmpty(resultMap.get("docName"))) {
            name = resultMap.get("docName").toString();
        }
        String detailContent = wordEditorDetails.getDetailContent();
        String detailOptions = wordEditorDetails.getDetailOptions();
        HashMap<String, String> configDetails = new HashMap<String, String>();
        configDetails.put("detailContent", detailContent);
        configDetails.put("detailOptions", detailOptions);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("multipart/form-data");
            String downLoadFileName = URLEncoder.encode(name + ".docx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            this.wordParticularService.exportFile(configDetails, (OutputStream)out);
            String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
            logger.info("\u672c\u6b21({})\u5bfc\u51fa\u8017\u65f6\u4e3a\uff1a{}s", (Object)name, (Object)useTime);
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public ApiResponse<Long> uploadReportPdfFile(MultipartFile fileInput, String docIdS, String fileName) {
        if (fileInput == null || docIdS == null) {
            logger.info("\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
            return ApiResponse.fail((String)"\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
        }
        Long docId = Long.parseLong(docIdS);
        String fileOriginName = fileName + ".pdf";
        try {
            InputStream fis = fileInput.getInputStream();
            byte[] fileByte = PdfUtil.imagesZipToPdf((InputStream)fis, null, null);
            MultipartFile file = WordDocExportServiceImpl.convertByteToMultipartFile(fileByte, fileOriginName);
            ApiResponse upload = this.fileService.upload(file);
            String filePath = ((AttachmentInfoDto)upload.getData()).getPath();
            Long fileId = ((AttachmentInfoDto)upload.getData()).getFileId();
            WordAndPdfRelationship wordAndPdfRelationship = new WordAndPdfRelationship();
            Long id = IdUtil.getSnowflakeNextId();
            wordAndPdfRelationship.setId(id);
            wordAndPdfRelationship.setDocId(docId);
            wordAndPdfRelationship.setPdfId(fileId);
            wordAndPdfRelationship.setPdfPath(filePath);
            this.wordPdfRelationshipService.add(wordAndPdfRelationship);
            return ApiResponse.success((Object)fileId, (String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            logger.error(e.getMessage() + "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    public static MultipartFile convertByteToMultipartFile(byte[] data, String fileName) {
        String contentType = "application/octet-stream";
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileItem fileItem = factory.createItem(fileName, contentType, true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            os.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile(fileItem);
    }
}

