/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.document.common.CommonDocumentInterface;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dao.DocumentInfoMapper;
import com.jxdinfo.hussar.document.common.factory.DocumentFactory;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.common.service.IDocumentInfoService;
import com.jxdinfo.hussar.document.editor.core.word.constant.WordConstant;
import com.jxdinfo.hussar.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.hussar.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.hussar.document.word.dto.WordModelInfoDto;
import com.jxdinfo.hussar.document.word.enums.OwnErrorEnum;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IWordDocExportService;
import com.jxdinfo.hussar.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.hussar.document.word.service.impl.WordEditorDetailsServiceImpl;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.document.word.vo.WordEditorDetailsVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordCommonDocumentImpl")
public class WordCommonDocumentImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private WordEditorDetailsServiceImpl wordEditorDetailsService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Resource
    private DocumentInfoMapper documentInfoMapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;
    @Resource
    private IWordDocExportService wordDocExportService;
    @Resource
    private WordPdfRelationshipService wordPdfRelationshipService;
    @Resource
    private IDocumentInfoService documentInfoService;

    public Object queryOffice(Long docId) {
        WordEditorDetails wordEditorDetails;
        WordEditorDetailsVo wordEditorDetailsVo = new WordEditorDetailsVo();
        HashMap<String, Object> extendResult = new HashMap<String, Object>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        if (HussarUtils.isNotEmpty((Object)wordModelInfo)) {
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
        }
        if (HussarUtils.isNotEmpty((Object)(wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsMapper.selectById((Serializable)((Object)wordModelInfo.getDetailsId()))))) {
            wordEditorDetailsVo.setWordEditorDetail(wordEditorDetails);
            wordEditorDetailsVo.setDetailsId(wordEditorDetails.getId());
        }
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo modelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(modelInfo.getDetailsId()));
            }
            List wordEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
            extendResult.put("childDetails", wordEditorDetailsList);
        }
        wordEditorDetailsVo.setExtendResult(extendResult);
        return wordEditorDetailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        String defaultName = "\u65e0\u6807\u9898\u6587\u6863";
        if (HussarUtils.isNotEmpty((Object)documentName)) {
            defaultName = documentName;
        }
        WordEditorDetails emptyWord = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        emptyWord.setId(wordEditorDetailId);
        emptyWord.setDocId(null);
        emptyWord.setExtendedInfo("1");
        emptyWord.setDetailOptions("{\"settingInfo\":{\"waterInfo\":{\"hideSelf\":false,\"selectType\":\"1\",\"waterType\":\"2\",\"waterStyle\":false,\"imageWater\":{\"checked\":false,\"zoom\":\"auto\",\"erosion\":true,\"fileId\":\"\",\"rotate\":\"horizontal\"},\"textWater\":{\"checked\":false,\"content\":\"\",\"rotate\":\"horizontal\",\"fontFamily\":\"SimSun\",\"fontSize\":\"12pt\",\"transparency\":50,\"color\":\"#8F8F8F\"}},\"shading\":\"#ffffff\",\"pagingSeal\":{\"imgSrc\":\"\"},\"threads\":[],\"showThreads\":true,\"textBoxBorderMap\":{}},\"imgStyleMap\":{\"changeState\":false},\"userAgent\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\",\"firstOpenAfterImport\":false,\"docRules\":{\"style\":[],\"visible\":[]},\"listMarkOption\":{\"marginLeftArr\":[],\"customListMark\":[{\"name\":\"none\",\"example\":\"\u65e0\u5217\u8868\"}]}}");
        emptyWord.setDetailContent("{\"type\":\"doc\",\"attrs\":{\"isBindData\":false},\"content\":[{\"type\":\"section\",\"attrs\":{\"HTMLAttributes\":null,\"id\":\"section-default\",\"pageOption\":{\"label\":\"A4\",\"width\":20.99,\"height\":29.77,\"direction\":\"vertical\",\"left\":3.18,\"right\":3.18,\"top\":2.54,\"bottom\":2.54,\"headerTop\":1.5,\"footerBottom\":1.75,\"isdefault\":true,\"gutterPlace\":\"left\",\"gutterWidth\":0},\"headerFooterState\":\"show\",\"pagesNum\":1,\"headerInfo\":{\"headerOption\":{\"first\":false,\"oddEven\":false},\"headerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"footerInfo\":{\"footerOption\":{\"first\":false,\"oddEven\":false},\"footerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"headerOption\":{\"first\":false,\"oddEven\":false},\"footerOption\":{\"first\":false,\"oddEven\":false},\"sectionOrder\":1},\"content\":[{\"type\":\"paragraph\",\"attrs\":{\"textAlign\":\"justify\",\"fontSize\":\"12pt\",\"lineHeight\":{\"label\":\"\u591a\u500d\u884c\u8ddd\",\"value\":1,\"unitLabel\":\"\u500d\",\"defaultCharValue\":12},\"position\":\"relative\",\"offsetTop\":0,\"actualLineHeight\":1.31,\"marginLeft\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginRight\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginTop\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginTop\":0,\"marginBottom\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginBottom\":0,\"marginIndent\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"indent\":{\"label\":\"\u65e0\",\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"bindData\":{\"isBindData\":false,\"dataset\":\"\"},\"paragraphBackground\":null,\"marginTopToCalcY\":0,\"marginBottomToCalcY\":0,\"styleRuleIds\":null,\"visibleRuleIds\":null,\"ruleInfo\":{\"bold\":false,\"italic\":false,\"underline\":false,\"deleteline\":false,\"ruleColor\":null,\"ruleBackground\":null,\"ruleHidden\":false},\"id\":null,\"level\":0,\"y\":0,\"height\":0,\"renderInfo\":{\"rows\":[{\"startIndex\":0,\"height\":21}],\"textNum\":0,\"totalHeight\":21},\"pageBreakPos\":{\"pos\":[],\"textNum\":0},\"tocLevel\":0,\"childDetailsId\":null,\"childDocId\":null,\"childModelName\":null}}]}]}");
        int rows = this.wordEditorDetailsMapper.insert(emptyWord);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(defaultName);
        wordModelInfoDto.setGroupId(WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
        wordModelInfoDto.setDetailsId(String.valueOf(wordEditorDetailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        if (modelApiResponse.isSuccess() && HussarUtils.isNotEmpty((Object)modelApiResponse.getData())) {
            wordDocTypeInfo.setReportId((Long)modelApiResponse.getData());
        }
        wordDocTypeInfo.setReportName(defaultName);
        wordDocTypeInfo.setReportType(DocumentType.WORD_MODEL.getTypeCode());
        int insert = this.documentInfoMapper.insert((Object)wordDocTypeInfo);
        return (Long)modelApiResponse.getData();
    }

    public Long copyDocument(Long docId) {
        WordEditorDetails copyWordDetail = new WordEditorDetails();
        if (HussarUtils.isEmpty((Object)docId)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelInfo originalWordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        WordEditorDetails originalWordEditorDetails = (WordEditorDetails)this.wordEditorDetailsMapper.selectById((Serializable)((Object)originalWordModelInfo.getDetailsId()));
        if (HussarUtils.isNotEmpty((Object)originalWordEditorDetails)) {
            long detailId = IdUtil.getSnowflakeNextId();
            copyWordDetail.setId(Long.valueOf(detailId));
            copyWordDetail.setDocId(null);
            copyWordDetail.setDetailContent(originalWordEditorDetails.getDetailContent());
            copyWordDetail.setDetailOptions(originalWordEditorDetails.getDetailOptions());
        }
        int row = this.wordEditorDetailsMapper.insert(copyWordDetail);
        WordModelInfoDto copyWordModelInfo = new WordModelInfoDto();
        copyWordModelInfo.setModelName(originalWordModelInfo.getModelName());
        copyWordModelInfo.setGroupId(originalWordModelInfo.getGroupId());
        copyWordModelInfo.setModelCode(originalWordModelInfo.getModelCode());
        copyWordModelInfo.setModelVersion(originalWordModelInfo.getModelVersion());
        copyWordModelInfo.setModelStatus(originalWordModelInfo.getModelStatus());
        copyWordModelInfo.setEditStatus(originalWordModelInfo.getEditStatus());
        copyWordModelInfo.setValidTime(originalWordModelInfo.getValidTime());
        copyWordModelInfo.setDetailsId(String.valueOf(copyWordDetail.getId()));
        ApiResponse<Long> longApiResponse = this.wordModelInfoService.addModelInfo(copyWordModelInfo);
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        if (longApiResponse.isSuccess() && HussarUtils.isNotEmpty((Object)longApiResponse.getData())) {
            wordDocTypeInfo.setReportId((Long)longApiResponse.getData());
        }
        wordDocTypeInfo.setReportName("\u65e0\u6807\u9898\u6587\u6863");
        wordDocTypeInfo.setReportType(DocumentType.WORD_MODEL.getTypeCode());
        int insert = this.documentInfoMapper.insert((Object)wordDocTypeInfo);
        return (Long)longApiResponse.getData();
    }

    public void downloadDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDoc(response, docId);
    }

    public ApiResponse<InputStream> previewPDF(Long docId) {
        Long fileId = this.wordPdfRelationshipService.getFileIdByDocId(docId);
        if (fileId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        try {
            InputStream inputStream = this.documentInfoService.getFileStreamByFileId(fileId);
            return ApiResponse.success((Object)inputStream);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        DocumentFactory.add((String)DocumentType.WORD_MODEL.getTypeName(), (CommonDocumentInterface)this);
    }
}

