/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.util;

import com.google.common.base.Strings;
import com.jxdinfo.hussar.document.word.cnst.SystemErrorEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureUtil {
    private static Logger logger = LoggerFactory.getLogger(FailureUtil.class);
    public static final String SPLIT_FLAG = "^~";

    private FailureUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getIllegalArgString(String errCode, String msg) {
        return String.format("%s%s%s", errCode, SPLIT_FLAG, msg);
    }

    public static String getIllegalArgMessage(String errorMessage) {
        if (Strings.isNullOrEmpty((String)errorMessage) || !errorMessage.contains(SPLIT_FLAG)) {
            logger.warn("\u53c2\u6570\u6821\u9a8c\u9519\u8bef\u7684\u6d88\u606f\u683c\u5f0f");
            return SystemErrorEnum.PARAM_ERROR.getMsg() + errorMessage;
        }
        return errorMessage.substring(errorMessage.indexOf(SPLIT_FLAG) + SPLIT_FLAG.length());
    }

    public static String getIllegalArgCode(String errorMessage) {
        if (Strings.isNullOrEmpty((String)errorMessage) || !errorMessage.contains(SPLIT_FLAG)) {
            logger.warn("\u53c2\u6570\u6821\u9a8c\u9519\u8bef\u7684\u6d88\u606f\u683c\u5f0f");
            return SystemErrorEnum.PARAM_ERROR.getCode();
        }
        return errorMessage.substring(0, errorMessage.indexOf(SPLIT_FLAG));
    }
}

