/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.hussar.document.common.factory.DocumentFactory;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.common.service.IDocumentInfoService;
import com.jxdinfo.hussar.document.common.service.IFileService;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.common.util.DocumentCommonUtil;
import com.jxdinfo.hussar.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.hussar.document.common.vo.DocumentSplitVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.common.service.impl.DocumentInfoServiceImpl")
public class DocumentInfoServiceImpl
implements IDocumentInfoService {
    private static Logger logger = LoggerFactory.getLogger(DocumentInfoServiceImpl.class);
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Autowired(required=false)
    private IFileService fileService;

    @Override
    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName, String type) {
        if (HussarUtils.isNotEmpty((Object)type) && DocumentType.isValid(type)) {
            return DocumentFactory.get(type).importDocument(file, groupId, docName);
        }
        return ApiResponse.fail((String)"\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b");
    }

    @Override
    public void exportDocument(HttpServletResponse response, Long docId) {
        List<WordDocTypeInfo> infoList;
        if (HussarUtils.isNotEmpty((Object)docId) && HussarUtils.isNotEmpty(infoList = this.wordTypeInfoService.queryList(docId)) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            DocumentFactory.get(type).exportDocument(response, docId);
        }
    }

    @Override
    public ApiResponse<DocumentDetailsVo> queryDocumentDetail(String docId) {
        Long id;
        List<WordDocTypeInfo> infoList;
        if (HussarUtils.isNotEmpty((Object)docId) && StringUtils.isNumeric((CharSequence)docId) && HussarUtils.isNotEmpty(infoList = this.wordTypeInfoService.queryList(id = Long.valueOf(Long.parseLong(docId)))) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            return ApiResponse.success((Object)DocumentFactory.get(type).queryDocumentDetail(id));
        }
        return ApiResponse.fail((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public ApiResponse<Object> queryOffice(String docId) {
        Long id;
        List<WordDocTypeInfo> infoList;
        if (HussarUtils.isNotEmpty((Object)docId) && StringUtils.isNumeric((CharSequence)docId) && HussarUtils.isNotEmpty(infoList = this.wordTypeInfoService.queryList(id = Long.valueOf(Long.parseLong(docId)))) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            return ApiResponse.success((Object)DocumentFactory.get(type).queryOffice(id));
        }
        return ApiResponse.fail((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public Long addBlankDocument(String documentName, String type) {
        if (HussarUtils.isNotEmpty((Object)type) && DocumentType.isValid(type)) {
            return DocumentFactory.get(type).addBlankDocument(documentName, type);
        }
        return -1L;
    }

    @Override
    public Long copyDocument(Long docId) {
        List<WordDocTypeInfo> infoList = this.wordTypeInfoService.queryList(docId);
        if (HussarUtils.isNotEmpty(infoList) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            return DocumentFactory.get(type).copyDocument(docId);
        }
        return -1L;
    }

    @Override
    public void previewPDF(HttpServletResponse response, Long docId) {
        String type = DocumentType.WORD_MODEL.getTypeName();
        List<WordDocTypeInfo> infoList = this.wordTypeInfoService.queryList(docId);
        if (HussarUtils.isNotEmpty(infoList) && infoList.size() >= 1) {
            type = this.getTypeNameByCode(infoList.get(0).getReportType());
            DocumentFactory.get(type).previewPDF(response, docId);
        }
    }

    @Override
    public ApiResponse<InputStream> previewPDF(Long docId) {
        List<WordDocTypeInfo> infoList = this.wordTypeInfoService.queryList(docId);
        if (HussarUtils.isNotEmpty(infoList) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            return DocumentFactory.get(type).previewPDF(docId);
        }
        return DocumentFactory.get(DocumentType.WORD_MODEL.getTypeName()).previewPDF(docId);
    }

    @Override
    public InputStream getFileStreamByFileId(Long fileId) {
        ApiResponse<byte[]> response = this.fileService.backgroundDownload(fileId);
        if (!response.isSuccess()) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1\u8c03\u7528\u5931\u8d25\u3002fileId: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)fileId, (Object)response.getMsg());
            return new ByteArrayInputStream(new byte[0]);
        }
        byte[] data = (byte[])response.getData();
        if (!HussarUtils.isNotEmpty((Object)data)) {
            logger.warn("\u4e0b\u8f7d\u7684\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\u3002fileId: {}", (Object)fileId);
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public void getFileStreamByFileId(HttpServletResponse response, Long fileId) {
        AttachmentInfoDto modelById = this.fileService.getModelById(fileId);
        if (modelById == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cID: " + fileId);
        }
        String attachmentName = modelById.getAttachmentName();
        String filePath = DocumentCommonUtil.getFilePath(modelById);
        Path filePathObj = Paths.get(filePath, new String[0]);
        try {
            if (!Files.exists(filePathObj, new LinkOption[0])) {
                throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728: " + filePath);
            }
            response.setContentType("application/octet-stream");
            String downLoadFileName = URLEncoder.encode(attachmentName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            response.setHeader("Content-Length", String.valueOf(Files.size(filePathObj)));
            try (InputStream in = Files.newInputStream(filePathObj, new OpenOption[0]);
                 ServletOutputStream out = response.getOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            response.setStatus(404);
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath, (Object)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Long generateReport(Long id, JSONObject reportJson) {
        List<WordDocTypeInfo> infoList;
        if (HussarUtils.isNotEmpty((Object)id) && HussarUtils.isNotEmpty(infoList = this.wordTypeInfoService.queryList(id)) && infoList.size() >= 1) {
            String type = this.getTypeNameByCode(infoList.get(0).getReportType());
            return DocumentFactory.get(type).generateReport(id, reportJson);
        }
        return null;
    }

    @Override
    public ApiResponse<JSONObject> executeJsGenerateReportJson(Long id, String data) {
        String type;
        JSONObject result;
        List<WordDocTypeInfo> infoList;
        if (HussarUtils.isNotEmpty((Object)id) && HussarUtils.isNotEmpty(infoList = this.wordTypeInfoService.queryList(id)) && infoList.size() >= 1 && HussarUtils.isNotEmpty((Object)(result = DocumentFactory.get(type = this.getTypeNameByCode(infoList.get(0).getReportType())).executeJsGenerateReportJson(id, data)))) {
            return ApiResponse.success((Object)result);
        }
        return ApiResponse.fail((String)"\u6267\u884cjs\u751f\u6210\u62a5\u544ajson\u5931\u8d25");
    }

    @Override
    public ApiResponse<DocumentSplitVo> getDocumentById(String docId) {
        if (HussarUtils.isNotEmpty((Object)docId) && StringUtils.isNumeric((CharSequence)docId)) {
            Long id = Long.parseLong(docId);
            List<WordDocTypeInfo> infoList = this.wordTypeInfoService.queryList(id);
            if (HussarUtils.isNotEmpty(infoList) && infoList.size() >= 1) {
                String type = this.getTypeNameByCode(infoList.get(0).getReportType());
                return ApiResponse.success((Object)DocumentFactory.get(type).getDocumentById(id));
            }
            return ApiResponse.fail((String)"\u65e0\u6587\u6863\u6570\u636e");
        }
        return ApiResponse.fail((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u6863ID");
    }

    private String getTypeNameByCode(int code) {
        if (code == DocumentType.WORD_MODEL.getTypeCode()) {
            return DocumentType.WORD_MODEL.getTypeName();
        }
        if (code == DocumentType.WORD_REPORT.getTypeCode()) {
            return DocumentType.WORD_REPORT.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName();
        }
        return "";
    }
}

