/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.calculate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.data.build.binddata.service.DocumentDataSetBuildService;
import com.jxdinfo.hussar.document.calculate.factory.DocumentCustomDataFactory;
import com.jxdinfo.hussar.document.calculate.service.DocumentGenerateService;
import com.jxdinfo.hussar.document.common.model.GenerateReportParam;
import com.jxdinfo.hussar.document.common.service.DocumentDataBindService;
import com.jxdinfo.hussar.document.common.service.IDocumentInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.calculate.service.impl.DocumentGenerateServiceImpl")
public class DocumentGenerateServiceImpl
implements DocumentGenerateService {
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private DocumentDataSetBuildService documentDataSetBuildService;
    @Resource
    private DocumentDataBindService documentDataBindService;

    @Override
    public ApiResponse<Object> generateReport(GenerateReportParam generateReportParam) {
        Long reportId;
        Long businessId;
        ApiResponse executeJSResponse;
        ApiResponse<Object> documentDSAPIR = this.constructDocumentDS(generateReportParam);
        Object data = null;
        if (HussarUtils.isNotEmpty(documentDSAPIR) && documentDSAPIR.isSuccess() && HussarUtils.isNotEmpty((Object)documentDSAPIR.getData())) {
            data = documentDSAPIR.getData();
        }
        if ((executeJSResponse = this.documentInfoService.executeJsGenerateReportJson(businessId = generateReportParam.getBusinessId(), data == null ? "{}" : HussarUtils.toJson((Object)data))).isSuccess() && HussarUtils.isNotEmpty((Object)executeJSResponse.getData()) && HussarUtils.isNotEmpty((Object)(reportId = this.documentInfoService.generateReport(businessId, (JSONObject)executeJSResponse.getData())))) {
            return ApiResponse.success((Object)reportId);
        }
        return ApiResponse.fail((String)"\u751f\u6210\u62a5\u544a\u5931\u8d25");
    }

    @Override
    public ApiResponse<Object> constructDocumentDS(GenerateReportParam generateReportParam) {
        Long businessId = generateReportParam.getBusinessId();
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(businessId.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        HashMap<String, Map> inputParam = new HashMap<String, Map>();
        inputParam.put("inputParam", generateReportParam.getInputParam());
        inputParam.put("customParams", generateReportParam.getCustomParams());
        JSONObject databindDetails = officeDataJson.getJSONObject("databindDetails");
        JSONArray wordDataSet = officeDataJson.getJSONArray("wordDataSet");
        JSONObject jsonObject = this.documentDataSetBuildService.buildDataSet(databindDetails, wordDataSet, inputParam);
        String dataFlag = officeDataJson.getString("interFaceName");
        if (DocumentCustomDataFactory.isContainsFlag(dataFlag)) {
            jsonObject = DocumentCustomDataFactory.get(dataFlag).generateCustomData(businessId, generateReportParam.getInputParam(), generateReportParam.getCustomParams(), jsonObject);
        }
        return ApiResponse.success((Object)jsonObject);
    }
}

