/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dispatcher.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.dispatcher.model.CustomRequest;
import com.jxdinfo.hussar.dispatcher.model.RequestParamDto;
import com.jxdinfo.hussar.dispatcher.service.HussarDispatcherService;
import com.jxdinfo.hussar.dispatcher.util.QueryStringUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;

@Service
public class HussarDispatcherServiceImpl
implements HussarDispatcherService {
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @Override
    public List<Object> dispatcher(HttpServletRequest request, List<RequestParamDto> requestParamList) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (HussarUtils.isEmpty(requestParamList)) {
            return result;
        }
        for (RequestParamDto requestParam : requestParamList) {
            Object returnValue;
            CustomRequest customRequest = this.getCustomRequest(request, requestParam);
            HandlerExecutionChain chain = this.requestMappingHandlerMapping.getHandler((HttpServletRequest)customRequest);
            if (chain == null) {
                result.add(ApiResponse.fail((String)("No mapping for " + requestParam.getMethod() + " " + requestParam.getUri())));
                continue;
            }
            HandlerMethod handlerMethod = (HandlerMethod)chain.getHandler();
            ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)customRequest, null);
            ServletInvocableHandlerMethod invocableMethod = new ServletInvocableHandlerMethod(handlerMethod);
            this.setInvocableMethodParam(handlerMethod, invocableMethod);
            try {
                returnValue = invocableMethod.invokeForRequest((NativeWebRequest)webRequest, new ModelAndViewContainer(), new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                returnValue = ApiResponse.fail((String)e.getMessage());
            }
            result.add(returnValue);
        }
        return result;
    }

    private CustomRequest getCustomRequest(HttpServletRequest request, RequestParamDto requestParam) {
        CustomRequest customRequest = new CustomRequest(request, requestParam.getMethod(), requestParam.getUri());
        String contentType = requestParam.getContentType();
        if (contentType != null) {
            customRequest.setContentType(contentType);
        }
        if (requestParam.getParamsMap() != null) {
            customRequest.setParamsMap(requestParam.getParamsMap());
        }
        String bodyStr = Optional.ofNullable(requestParam.getBodyStr()).orElse("");
        if (this.isFormPost(contentType, customRequest.getMethod()) && HussarUtils.isNotEmpty((Object)bodyStr)) {
            Map body = (Map)JSON.parseObject((String)bodyStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            Map<String, String[]> paramsMap = QueryStringUtil.convertMap(body);
            bodyStr = QueryStringUtil.getQueryString(paramsMap);
            paramsMap.putAll(Optional.ofNullable(customRequest.getParameterMap()).orElse(new HashMap()));
            customRequest.setParamsMap(paramsMap);
        }
        customRequest.setBody(bodyStr);
        return customRequest;
    }

    private boolean isFormPost(String contentType, String method) {
        return contentType != null && contentType.contains(FORM_CONTENT_TYPE) && HttpMethod.POST.name().equals(method);
    }

    private void setInvocableMethodParam(HandlerMethod handlerMethod, ServletInvocableHandlerMethod invocableMethod) {
        invocableMethod.setHandlerMethodArgumentResolvers(this.getArgumentResolvers(this.handlerAdapter));
        invocableMethod.setHandlerMethodReturnValueHandlers(this.getReturnValueHandlers(this.handlerAdapter));
        invocableMethod.setParameterNameDiscoverer(this.parameterNameDiscoverer);
        invocableMethod.setDataBinderFactory((WebDataBinderFactory)new ServletRequestDataBinderFactory(new ArrayList(), this.handlerAdapter.getWebBindingInitializer()));
    }

    private HandlerMethodReturnValueHandlerComposite getReturnValueHandlers(RequestMappingHandlerAdapter ha) {
        HandlerMethodReturnValueHandlerComposite returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
        returnValueHandlers.addHandlers(ha.getReturnValueHandlers());
        return returnValueHandlers;
    }

    private HandlerMethodArgumentResolverComposite getArgumentResolvers(RequestMappingHandlerAdapter ha) {
        HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
        argumentResolvers.addResolvers(ha.getArgumentResolvers());
        return argumentResolvers;
    }
}

