/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.deploy.util;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PathUtils {
    public static String posixPath(String ... segments) {
        if ((segments = PathUtils.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    private static String[] preprocessPathSegments(String[] segments) {
        if (segments == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(segments).filter(segment -> segment != null && !segment.isEmpty()).toArray(String[]::new);
    }

    public static String pathFomatterByOS(String oPath) {
        return oPath.replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    public static String removePrefix(String prefix, String path) {
        prefix = FilenameUtils.normalize((String)prefix);
        path = FilenameUtils.normalize((String)path);
        if (ObjectUtils.isNotEmpty((Object)prefix) && prefix.equals(path.substring(0, prefix.length()))) {
            path = path.substring(prefix.length());
        }
        return path;
    }
}

