/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.deploy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.deploy.dto.DeployGitDto;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.deploy.util.PathUtils;
import com.jxdinfo.hussar.formdesign.devtools.compile.dto.RunnerStatus;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.invocation.dto.StartVariables;
import com.jxdinfo.hussar.formdesign.devtools.invocation.service.CompileInvokeHelper;
import com.jxdinfo.hussar.operations.monitor.ServerInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.file.HussarFileUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class HussarDeployServiceImpl
implements IHussarDeployService {
    private static final Logger logger = LoggerFactory.getLogger(HussarDeployServiceImpl.class);
    @Resource
    private IGitlabService iGitlabService;
    @Value(value="${hussar-deploy.workspace:projects}")
    private String workspacePath;
    @Resource
    private CompileInvokeHelper compileInvokeService;
    private static final String GROUP_ID_PREFIX = "com.jxdinfo.hussar.cloud.";

    public ApiResponse<String> initWorkSpace(DeployGitDto dto) {
        System.out.println("initWorkSpace-dto = " + JSONObject.toJSONString((Object)dto));
        String userFolderPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
        System.out.println("userFolderPath = " + userFolderPath);
        File userNewFolder = new File(userFolderPath);
        if (!userNewFolder.exists()) {
            Boolean result = userNewFolder.mkdirs();
            if (result.booleanValue()) {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939\u6210\u529f\uff0cpath={}", (Object)userFolderPath);
            } else {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0cpath={}", (Object)userFolderPath);
                throw new BaseException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0cpath=" + userFolderPath);
            }
        }
        GitDto gitDto = new GitDto();
        gitDto.setPath(userFolderPath);
        gitDto.setTenantCode(dto.getTenantCode());
        gitDto.setBranch(dto.getBranch());
        gitDto.setGitUri(dto.getGitUri());
        gitDto.setAccessToken(dto.getAccessToken());
        return this.iGitlabService.pullToLocal(gitDto);
    }

    public ApiResponse<String> pushAppToGit(DeployGitDto dto) {
        String localGitPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
        String backPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId() + File.separator + dto.getTenantCode() + "-web" + File.separator + dto.getAppCode();
        String frontPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId() + File.separator + dto.getTenantCode() + "-front" + File.separator + "apps" + File.separator + dto.getAppCode();
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(backPath);
        filePaths.add(frontPath);
        GitDto gitDto = new GitDto();
        gitDto.setPath(localGitPath);
        gitDto.setTenantCode(dto.getTenantCode());
        gitDto.setBranch(dto.getBranch());
        gitDto.setGitUri(dto.getGitUri());
        gitDto.setAccessToken(dto.getAccessToken());
        gitDto.setCommitMsg(dto.getCommitMsg());
        gitDto.setFilesToAdd(filePaths);
        return this.iGitlabService.pushSpecifiedToGit(gitDto);
    }

    public ApiResponse<String> pushToGit(DeployGitDto dto) {
        String localGitPath = PathUtils.posixPath(this.workspacePath, dto.getTenantCode(), dto.getUserId().toString());
        GitDto gitDto = new GitDto();
        gitDto.setPath(localGitPath);
        gitDto.setTenantCode(dto.getTenantCode());
        gitDto.setBranch(dto.getBranch());
        gitDto.setGitUri(dto.getGitUri());
        gitDto.setAccessToken(dto.getAccessToken());
        gitDto.setCommitMsg(dto.getCommitMsg());
        return this.iGitlabService.pushToGit(gitDto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<String> addAppDependenceInPom(DeployGitDto dto) throws Exception {
        System.out.println("addPom-dto = " + JSONObject.toJSONString((Object)dto));
        String pomFilePath = PathUtils.posixPath(this.workspacePath, dto.getTenantCode(), dto.getUserId().toString(), dto.getTenantCode() + "-web", "web-main", "pom.xml");
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            logger.error("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath);
            return ApiResponse.fail((String)("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath));
        }
        String groupId = GROUP_ID_PREFIX + dto.getAppCode();
        String artifactId = dto.getAppCode() + "-server";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(pomFile);
        doc.getDocumentElement().normalize();
        NodeList versionList = doc.getElementsByTagName("version");
        String version = versionList.item(0).getTextContent();
        try (FileReader reader = new FileReader(pomFilePath);){
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            Model model = pomReader.read((Reader)reader);
            boolean dependencyExists = false;
            for (Dependency dep : model.getDependencies()) {
                if (!dep.getGroupId().equals(groupId) || !dep.getArtifactId().equals(artifactId)) continue;
                dependencyExists = true;
                break;
            }
            if (!dependencyExists) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(groupId);
                dependency.setArtifactId(artifactId);
                dependency.setVersion(version);
                Exclusion exclusion1 = new Exclusion();
                exclusion1.setGroupId("com.googlecode.concurrentlinkedhashmap");
                exclusion1.setArtifactId("concurrentlinkedhashmap-lru");
                Exclusion exclusion2 = new Exclusion();
                exclusion2.setGroupId("com.jxdinfo.hussar");
                exclusion2.setArtifactId("hussar-workflow-api");
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                exclusions.add(exclusion1);
                exclusions.add(exclusion2);
                dependency.setExclusions(exclusions);
                if (model.getDependencies() == null) {
                    model.setDependencies(new ArrayList());
                }
                model.getDependencies().add(dependency);
                try (FileWriter writer = new FileWriter(pomFilePath);){
                    MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                    pomWriter.write((Writer)writer, model);
                }
                String localGitPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
                ArrayList<String> filePaths = new ArrayList<String>();
                filePaths.add(pomFilePath);
                GitDto gitDto = new GitDto();
                gitDto.setPath(localGitPath);
                gitDto.setTenantCode(dto.getTenantCode());
                gitDto.setBranch(dto.getBranch());
                gitDto.setGitUri(dto.getGitUri());
                gitDto.setAccessToken(dto.getAccessToken());
                gitDto.setCommitMsg(dto.getCommitMsg());
                gitDto.setFilesToAdd(filePaths);
                this.iGitlabService.pushSpecifiedToGit(gitDto);
                logger.info("\u4f9d\u8d56\u6dfb\u52a0\u6210\u529f\uff0cpath={} , artifactId={}", (Object)pomFilePath, (Object)artifactId);
                ApiResponse apiResponse2 = ApiResponse.success((Object)"\u4f9d\u8d56\u6dfb\u52a0\u6210\u529f", (String)"");
                return apiResponse2;
            }
            logger.info("\u4f9d\u8d56\u5728pom\u6587\u4ef6\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0cpath={}\uff0cgroupId={}\uff0cartifactId={}\uff0cversion={}", new Object[]{pomFilePath, groupId, artifactId, version});
            ApiResponse apiResponse = ApiResponse.fail((String)("\u4f9d\u8d56\u5728pom\u6587\u4ef6\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0cpath=" + pomFilePath + "\uff0cgroupId=" + groupId + "\uff0cartifactId=" + artifactId + "\uff0cversion=" + version));
            return apiResponse;
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            logger.error("\u4f9d\u8d56\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage() + "path={}", (Object)pomFilePath);
            return ApiResponse.fail((String)("\u4f9d\u8d56\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<String> addAppDependencesInPomBatch(DeployGitDto dto) throws Exception {
        String pomFilePath = PathUtils.posixPath(this.workspacePath, dto.getTenantCode(), dto.getUserId().toString(), dto.getTenantCode() + "-web", "web-main", "pom.xml");
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            logger.error("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath);
            return ApiResponse.fail((String)("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath));
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(pomFile);
        doc.getDocumentElement().normalize();
        NodeList versionList = doc.getElementsByTagName("version");
        String version = versionList.item(0).getTextContent();
        try (FileReader reader = new FileReader(pomFilePath);){
            Object appCode;
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            Model model = pomReader.read((Reader)reader);
            ArrayList addArtifactIds = new ArrayList();
            ArrayList<String> resultMessages = new ArrayList<String>();
            for (int i = 0; i < dto.getAppCodeList().size(); ++i) {
                appCode = (String)dto.getAppCodeList().get(i);
                String groupId = GROUP_ID_PREFIX + (String)appCode;
                String artifactId = (String)appCode + "-server";
                Boolean dependencyExist = false;
                for (Dependency dep : model.getDependencies()) {
                    if (!dep.getGroupId().equals(groupId) || !dep.getArtifactId().equals(artifactId)) continue;
                    dependencyExist = true;
                    break;
                }
                if (!dependencyExist.booleanValue()) {
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(groupId);
                    dependency.setArtifactId(artifactId);
                    dependency.setVersion(version);
                    Exclusion exclusion1 = new Exclusion();
                    exclusion1.setGroupId("com.googlecode.concurrentlinkedhashmap");
                    exclusion1.setArtifactId("concurrentlinkedhashmap-lru");
                    Exclusion exclusion2 = new Exclusion();
                    exclusion2.setGroupId("com.jxdinfo.hussar");
                    exclusion2.setArtifactId("hussar-workflow-api");
                    ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                    exclusions.add(exclusion1);
                    exclusions.add(exclusion2);
                    dependency.setExclusions(exclusions);
                    if (model.getDependencies() == null) {
                        model.setDependencies(new ArrayList());
                    }
                    model.getDependencies().add(dependency);
                    continue;
                }
                logger.info("\u4f9d\u8d56\u5728pom\u6587\u4ef6\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0cpath={}\uff0cgroupId={}\uff0cartifactId={}\uff0cversion={}", new Object[]{pomFilePath, groupId, artifactId, version});
                resultMessages.add(artifactId + "\u4f9d\u8d56\u5728pom\u6587\u4ef6\u4e2d\u5df2\u5b58\u5728");
            }
            FileWriter writer = new FileWriter(pomFilePath);
            appCode = null;
            try {
                MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                pomWriter.write((Writer)writer, model);
                logger.info("\u4f9d\u8d56\u6dfb\u52a0\u6210\u529f\uff0cpath={} , artifactId={}", (Object)pomFilePath, (Object)String.join((CharSequence)",", addArtifactIds));
                resultMessages.add(String.join((CharSequence)"\u3001", addArtifactIds) + "\u4f9d\u8d56\u6dfb\u52a0\u6210\u529f");
            }
            catch (Throwable pomWriter) {
                appCode = pomWriter;
                throw pomWriter;
            }
            finally {
                if (writer != null) {
                    if (appCode != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable pomWriter) {
                            ((Throwable)appCode).addSuppressed(pomWriter);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
            String localGitPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
            ArrayList<String> filePaths = new ArrayList<String>();
            filePaths.add(pomFilePath);
            GitDto gitDto = new GitDto();
            gitDto.setPath(localGitPath);
            gitDto.setTenantCode(dto.getTenantCode());
            gitDto.setBranch(dto.getBranch());
            gitDto.setGitUri(dto.getGitUri());
            gitDto.setAccessToken(dto.getAccessToken());
            gitDto.setCommitMsg(dto.getCommitMsg());
            gitDto.setFilesToAdd(filePaths);
            this.iGitlabService.pushSpecifiedToGit(gitDto);
            ApiResponse apiResponse = ApiResponse.success((String)String.join((CharSequence)";", resultMessages));
            return apiResponse;
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            logger.error("\u4f9d\u8d56\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage() + "path={}", (Object)pomFilePath);
            return ApiResponse.fail((String)("\u4f9d\u8d56\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public ApiResponse<String> deleteAppDependenceInPom(DeployGitDto dto) throws Exception {
        Object dependency;
        String pomFilePath = PathUtils.posixPath(this.workspacePath, dto.getTenantCode(), dto.getUserId().toString(), dto.getTenantCode() + "-web", "web-main", "pom.xml");
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            logger.error("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath);
            return ApiResponse.fail((String)("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath));
        }
        String groupId = GROUP_ID_PREFIX + dto.getAppCode();
        String artifactId = dto.getAppCode() + "-server";
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(pomFile);
        doc.getDocumentElement().normalize();
        NodeList dependencies = doc.getElementsByTagName("dependency");
        Boolean exist = false;
        for (int i = 0; i < dependencies.getLength(); ++i) {
            dependency = (Element)dependencies.item(i);
            Element groupIdElement = (Element)dependency.getElementsByTagName("groupId").item(0);
            Element artifactIdElement = (Element)dependency.getElementsByTagName("artifactId").item(0);
            if (groupIdElement == null || artifactIdElement == null || !groupId.equals(groupIdElement.getTextContent()) || !artifactId.equals(artifactIdElement.getTextContent())) continue;
            exist = true;
            dependency.getParentNode().removeChild((Node)dependency);
            break;
        }
        if (!exist.booleanValue()) {
            logger.info("pom.xml\u4e2d\u672a\u627e\u5230\u8981\u5220\u9664\u7684\u4f9d\u8d56path={}\uff0cgroupId={}\uff0cartifactId={}", new Object[]{pomFilePath, groupId, artifactId});
            return ApiResponse.fail((String)("pom.xml\u4e2d\u672a\u627e\u5230\u8981\u5220\u9664\u7684\u4f9d\u8d56\uff0cpath=" + pomFilePath + "\uff0cgroupId=" + groupId + "\uff0cartifactId=" + artifactId));
        }
        FileOutputStream outputStream = new FileOutputStream(pomFile);
        dependency = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Throwable transformerFactory) {
            dependency = transformerFactory;
            throw transformerFactory;
        }
        finally {
            if (outputStream != null) {
                if (dependency != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable transformerFactory) {
                        ((Throwable)dependency).addSuppressed(transformerFactory);
                    }
                } else {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        logger.info("\u6307\u5b9a\u7684\u4f9d\u8d56\u5df2\u4ecepom.xml\u4e2d\u5220\u9664");
        String localGitPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(pomFilePath);
        GitDto gitDto = new GitDto();
        gitDto.setPath(localGitPath);
        gitDto.setTenantCode(dto.getTenantCode());
        gitDto.setBranch(dto.getBranch());
        gitDto.setGitUri(dto.getGitUri());
        gitDto.setAccessToken(dto.getAccessToken());
        gitDto.setCommitMsg(dto.getCommitMsg());
        gitDto.setFilesToAdd(filePaths);
        this.iGitlabService.pushSpecifiedToGit(gitDto);
        return ApiResponse.success((Object)"\u5220\u9664\u6210\u529f", (String)"");
    }

    public ApiResponse<String> deleteAppDependencesInPomBatch(DeployGitDto dto) throws Exception {
        Object appCode;
        String pomFilePath = PathUtils.posixPath(this.workspacePath, dto.getTenantCode(), dto.getUserId().toString(), dto.getTenantCode() + "-web", "web-main", "pom.xml");
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            logger.error("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath);
            return ApiResponse.fail((String)("pom.xml\u6587\u4ef6\u4e0d\u5b58\u5728\u4e8e\u6307\u5b9a\u8def\u5f84: " + pomFilePath));
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(pomFile);
        doc.getDocumentElement().normalize();
        NodeList dependencies = doc.getElementsByTagName("dependency");
        ArrayList<String> resultMessages = new ArrayList<String>();
        for (int i = 0; i < dto.getAppCodeList().size(); ++i) {
            appCode = (String)dto.getAppCodeList().get(i);
            String artifactId = (String)appCode + "-server";
            String groupId = GROUP_ID_PREFIX + (String)appCode;
            Boolean exist = false;
            for (int j = 0; j < dependencies.getLength(); ++j) {
                Element dependency = (Element)dependencies.item(j);
                Element groupIdElement = (Element)dependency.getElementsByTagName("groupId").item(0);
                Element artifactIdElement = (Element)dependency.getElementsByTagName("artifactId").item(0);
                if (groupIdElement == null || artifactIdElement == null || !groupId.equals(groupIdElement.getTextContent()) || !artifactId.equals(artifactIdElement.getTextContent())) continue;
                exist = true;
                dependency.getParentNode().removeChild(dependency);
                String message = "\u4f9d\u8d56\u5df2\u4ecepom.xml\u4e2d\u5220\u9664\uff0cpath=" + pomFilePath + ",artifactId=" + artifactId;
                logger.info(message);
                resultMessages.add(message);
                break;
            }
            if (exist.booleanValue()) continue;
            String message = "pom.xml\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u4f9d\u8d56\uff0cpath=" + pomFilePath + ",artifactId=" + artifactId;
            logger.info(message);
            resultMessages.add(message);
        }
        FileOutputStream outputStream = new FileOutputStream(pomFile);
        appCode = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Throwable transformerFactory) {
            appCode = transformerFactory;
            throw transformerFactory;
        }
        finally {
            if (outputStream != null) {
                if (appCode != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable transformerFactory) {
                        ((Throwable)appCode).addSuppressed(transformerFactory);
                    }
                } else {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        String localGitPath = this.workspacePath + File.separator + dto.getTenantCode() + File.separator + dto.getUserId();
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(pomFilePath);
        GitDto gitDto = new GitDto();
        gitDto.setPath(localGitPath);
        gitDto.setTenantCode(dto.getTenantCode());
        gitDto.setBranch(dto.getBranch());
        gitDto.setGitUri(dto.getGitUri());
        gitDto.setAccessToken(dto.getAccessToken());
        gitDto.setCommitMsg(dto.getCommitMsg());
        gitDto.setFilesToAdd(filePaths);
        this.iGitlabService.pushSpecifiedToGit(gitDto);
        return ApiResponse.success((String)String.join((CharSequence)";", resultMessages));
    }

    public ApiResponse<Boolean> start(String tenantCode, Long userId, String backPort, String frontPort, String mobilePort, String appCodes) throws HussarException {
        String pathSegments = File.separator + tenantCode + File.separator + userId.toString();
        StartVariables startVariables = new StartVariables();
        startVariables.setBackPort(backPort);
        startVariables.setFrontPort(frontPort);
        startVariables.setMobileFrontPort(mobilePort);
        startVariables.setDevUser(userId.toString());
        startVariables.setNacosGroup(tenantCode);
        startVariables.setAppCodes(appCodes);
        return this.compileInvokeService.start(pathSegments, startVariables);
    }

    public ApiResponse<Boolean> stop(String port) {
        return this.compileInvokeService.stop(port);
    }

    public ApiResponse<Boolean> deleteUserEnv(String tenantCode, Long userId) {
        String delFilePath = this.workspacePath + File.separator + tenantCode + userId.toString();
        try {
            this.deleteDirectory(delFilePath);
            HussarCacheUtil.evict((String)"gary_regular", (Object)("hussar-deploy:" + userId));
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return ApiResponse.success((Object)true);
    }

    private void deleteDirectory(String path) throws IOException {
        File directory = new File(path);
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file.getAbsolutePath());
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    public ApiResponse<Boolean> getEnvStatus(Integer frontPort, Integer backPort) {
        if ("1".equals(this.compileInvokeService.isActive(String.valueOf(frontPort)).getData()) && "1".equals(this.compileInvokeService.isActive(String.valueOf(backPort)).getData())) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    public List<Map<String, String>> runnerStatus(String tenantCode, String userId) {
        List runnerStatus = (List)this.compileInvokeService.runnerStatus(tenantCode, userId).getData();
        ArrayList<Map<String, String>> runner = new ArrayList<Map<String, String>>();
        for (RunnerStatus status : runnerStatus) {
            HashMap<String, String> runnerMap = new HashMap<String, String>();
            runnerMap.put("status", status.getStatus());
            runnerMap.put("exception", status.getException());
            runnerMap.put("type", status.getType());
            runner.add(runnerMap);
        }
        return runner;
    }

    public ApiResponse<Boolean> isInit(String tenantCode, Long userId) {
        String userFolderPath = this.workspacePath + File.separator + tenantCode + File.separator + userId.toString();
        File userNewFolder = new File(userFolderPath);
        if (userNewFolder.exists()) {
            Path path = Paths.get(userFolderPath, new String[0]);
            if (HussarFileUtil.isDirEmpty((Path)path)) {
                return ApiResponse.success((Object)false, (String)"\u9879\u76ee\u672a\u521d\u59cb\u5316");
            }
            return ApiResponse.success((Object)true, (String)"\u9879\u76ee\u521d\u59cb\u5316\u5b8c\u6210");
        }
        return ApiResponse.success((Object)false);
    }

    public ApiResponse<ServerInfo> getInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.copyTo();
        return ApiResponse.success((Object)serverInfo);
    }

    public ApiResponse<Boolean> aliveTry() {
        return this.compileInvokeService.aliveTry();
    }
}

