-- ----------------------------
-- Table structure for SYS_AD_IGNORE_SHOW
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_AD_IGNORE_SHOW]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_AD_IGNORE_SHOW]
;
CREATE TABLE [SYS_AD_IGNORE_SHOW] (
  [IGNORE_ID] NUMERIC(20)  NOT NULL,
  [AD_ID] NUMERIC(20)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
)
;

ALTER TABLE [SYS_AD_IGNORE_SHOW] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_AD_IGNORE_SHOW
-- ----------------------------
ALTER TABLE [SYS_AD_IGNORE_SHOW] ADD CONSTRAINT [PK__SYS_AD_IGNORE_SHOW__IGNORE_ID] PRIMARY KEY CLUSTERED ([IGNORE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'IGNORE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'横幅主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'AD_ID'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'横幅关闭记录表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AD_IGNORE_SHOW'
;

-- ----------------------------
-- Table structure for SYS_BUSINESS_CONFIG
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_BUSINESS_CONFIG]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_BUSINESS_CONFIG]
;
CREATE TABLE [SYS_BUSINESS_CONFIG] (
  [CONFIG_ID] NUMERIC(20)  NOT NULL,
  [CONFIG_NAME] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_SCENE] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_TAG] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_TYPE] NUMERIC(10)  NULL,
  [PERMISSION_RULE] NVARCHAR(MAX) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_KEY] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_VALUE] NVARCHAR(MAX) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMARK1] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMARK2] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMARK3] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
  [DEL_FLAG] NCHAR(1)  NULL,
)
;

ALTER TABLE [SYS_BUSINESS_CONFIG] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_BUSINESS_CONFIG
-- ----------------------------
ALTER TABLE [SYS_BUSINESS_CONFIG] ADD CONSTRAINT [PK__SYS_BUSINESS_CONFIG__CONFIG_ID] PRIMARY KEY CLUSTERED ([CONFIG_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'业务主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_ID'

EXEC sp_addextendedproperty
'MS_Description', N'配置名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'场景',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_SCENE'

EXEC sp_addextendedproperty
'MS_Description', N'标签',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_TAG'

EXEC sp_addextendedproperty
'MS_Description', N'配置类型（0系统：所有人可见，1个人：创建者可见）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'自定义配置规则',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'PERMISSION_RULE'

EXEC sp_addextendedproperty
'MS_Description', N'配置key',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_KEY'

EXEC sp_addextendedproperty
'MS_Description', N'配置值',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CONFIG_VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'扩展字段1（是否默认、排序权重等通过扩展字段配置）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'REMARK1'

EXEC sp_addextendedproperty
'MS_Description', N'扩展字段2（是否默认、排序权重等通过扩展字段配置）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'REMARK2'

EXEC sp_addextendedproperty
'MS_Description', N'扩展字段3（是否默认、排序权重等通过扩展字段配置）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'REMARK3'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'是否删除',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG',
'COLUMN', N'DEL_FLAG'

EXEC sp_addextendedproperty
'MS_Description', N'业务配置管理',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BUSINESS_CONFIG'
;


-- ----------------------------
-- Table structure for SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_COMMONLY_USE_ORGAN_USER]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_COMMONLY_USE_ORGAN_USER]
;
CREATE TABLE [SYS_COMMONLY_USE_ORGAN_USER] (
  [COMMONLY_USE_ID] NUMERIC(20)  NOT NULL,
  [COMMONLY_USE_TYPE] NUMERIC(10)  NULL,
  [ORGAN_USER_ID] NUMERIC(20)  NULL,
  [USE_COUNT] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATOR_NAME] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
  [DEL_FLAG] NCHAR(1)  NULL,
)
;

ALTER TABLE [SYS_COMMONLY_USE_ORGAN_USER] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
ALTER TABLE [SYS_COMMONLY_USE_ORGAN_USER] ADD CONSTRAINT [PK__SYS_COMMONLY_USE_ORGAN_USER__COMMONLY_USE_ID] PRIMARY KEY CLUSTERED ([COMMONLY_USE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'COMMONLY_USE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'类型(0：部门，1：用户)',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'COMMONLY_USE_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'部门/用户id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'ORGAN_USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'使用次数',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'USE_COUNT'

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'CREATOR_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'是否删除',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER',
'COLUMN', N'DEL_FLAG'

EXEC sp_addextendedproperty
'MS_Description', N'常用选人选部门',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_COMMONLY_USE_ORGAN_USER'
;
-- ----------------------------
-- Table structure for SYS_DATA_SET_GROUP
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_DATA_SET_GROUP]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_DATA_SET_GROUP]
;
CREATE TABLE [SYS_DATA_SET_GROUP] (
  [GROUP_ID] NUMERIC(20)  NOT NULL,
  [GROUP_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [GROUP_ICON] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [GROUP_ICON_TYPE] NCHAR(1)  NULL,
  [GROUP_TYPE] NCHAR(1)  NULL,
  [GROUP_ICON_COLOR] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [APP_ID] NUMERIC(20)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
)
;

ALTER TABLE [SYS_DATA_SET_GROUP] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_DATA_SET_GROUP
-- ----------------------------
ALTER TABLE [SYS_DATA_SET_GROUP] ADD CONSTRAINT [PK__SYS_DATA_SET_GROUP__GROUP_ID] PRIMARY KEY CLUSTERED ([GROUP_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'数据集分组id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_ID'

EXEC sp_addextendedproperty
'MS_Description', N'数据集分组名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'分组显示顺序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'数据集分组图标',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_ICON'

EXEC sp_addextendedproperty
'MS_Description', N'分组图标类型1：内置图标2：用户自定义',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_ICON_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'分组类型1:默认分组2:普通分组',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'分组图标颜色',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'GROUP_ICON_COLOR'

EXEC sp_addextendedproperty
'MS_Description', N'数据集应用ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'APP_ID'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'数据集分组表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_GROUP'
;


-- ----------------------------
-- Table structure for SYS_DATA_SET_INFO
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_DATA_SET_INFO]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_DATA_SET_INFO]
;
CREATE TABLE [SYS_DATA_SET_INFO] (
  [DATA_SET_ID] NUMERIC(20)  NOT NULL,
  [DATA_SET_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SET_CODE] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SET_ICON_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SET_ICON] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SET_ICON_COLOR] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [DATA_SET_DESC] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SOURCE_ID] NUMERIC(20)  NULL,
  [DATA_SOURCE_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [DATA_SOURCE_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [GROUP_ID] NUMERIC(20)  NULL,
  [APP_ID] NUMERIC(20)  NULL,
  [DATA_SET_TYPE] NCHAR(1)  NULL,
  [DATA] TEXT  NULL,
  [DEL_FLAG] NCHAR(1)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
)
;

ALTER TABLE [SYS_DATA_SET_INFO] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_DATA_SET_INFO
-- ----------------------------
ALTER TABLE [SYS_DATA_SET_INFO] ADD CONSTRAINT [PK__SYS_DATA_SET_INFO__DATA_SET_ID] PRIMARY KEY CLUSTERED ([DATA_SET_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'数据集ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_ID'

EXEC sp_addextendedproperty
'MS_Description', N'数据集名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'数据集标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_CODE'

EXEC sp_addextendedproperty
'MS_Description', N'数据集图标类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_ICON_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'数据集图标',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_ICON'

EXEC sp_addextendedproperty
'MS_Description', N'内置图标颜色',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_ICON_COLOR'

EXEC sp_addextendedproperty
'MS_Description', N'显示顺序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'数据集描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_DESC'

EXEC sp_addextendedproperty
'MS_Description', N'数据源id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SOURCE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'数据源名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SOURCE_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'数据源类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SOURCE_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'数据集分组ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'GROUP_ID'

EXEC sp_addextendedproperty
'MS_Description', N'应用ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'APP_ID'

EXEC sp_addextendedproperty
'MS_Description', N'数据集类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA_SET_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'数据集信息',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DATA'

EXEC sp_addextendedproperty
'MS_Description', N'需要逻辑删除的业务添加该字段',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'DEL_FLAG'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'数据集信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DATA_SET_INFO'
;
-- ----------------------------
-- Table structure for SYS_CUSTOMIZED_COMPONENT
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_CUSTOMIZED_COMPONENT]') AND type IN ('U') AND schema_id = SCHEMA_ID())
	DROP TABLE [SYS_CUSTOMIZED_COMPONENT]
;
CREATE TABLE [SYS_CUSTOMIZED_COMPONENT] (
  [CUSTOMIZED_COMPONENT_ID] NUMERIC(20)  NOT NULL,
  [CSS_FILE] NVARCHAR(max) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL
)
;

ALTER TABLE [SYS_CUSTOMIZED_COMPONENT] ADD CONSTRAINT [PK__SYS_CUSTOMIZED_COMPONENT__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([CUSTOMIZED_COMPONENT_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'CUSTOMIZED_COMPONENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'排序条件',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'CSS_FILE'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'定制化组件信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOMIZED_COMPONENT'
;

-- ----------------------------
-- Table structure for SYS_SORT_CONDITION_INFO
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_SORT_CONDITION_INFO]') AND type IN ('U') AND schema_id = SCHEMA_ID())
	DROP TABLE [SYS_SORT_CONDITION_INFO]
;
CREATE TABLE [SYS_SORT_CONDITION_INFO] (
  [SORT_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NOT NULL,
  [PAGE_ID] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [COMPONENT_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [SORT_CONDITION_INFO] NVARCHAR(max) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL,
  [IS_DEFAULT] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_SORT_CONDITION_INFO] ADD CONSTRAINT [PK__SYS_SORT_CONDITION_INFO__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([SORT_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'SORT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'页面ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'PAGE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'组件ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'COMPONENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'排序条件',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'SORT_CONDITION_INFO'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'是否默认，默认为1',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO',
'COLUMN', N'IS_DEFAULT'

EXEC sp_addextendedproperty
'MS_Description', N'排序条件信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_SORT_CONDITION_INFO'
;
-- ----------------------------
-- Table structure for SYS_TREE_RECORD
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_TREE_RECORD]') AND type IN ('U') AND schema_id = SCHEMA_ID())
	DROP TABLE [SYS_TREE_RECORD]
;
CREATE TABLE [SYS_TREE_RECORD] (
  [TREE_RECORD_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NOT NULL,
  [PAGE_ID] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [COMPONENT_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [TREE_RECORD_INFO] NVARCHAR(max) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL
)
;

ALTER TABLE [SYS_TREE_RECORD] ADD CONSTRAINT [PK__SYS_TREE_RECORD__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([TREE_RECORD_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'TREE_RECORD_ID'

EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'页面ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'PAGE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'组件ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'COMPONENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'历史记录信息',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'TREE_RECORD_INFO'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'树历史记录信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_TREE_RECORD'
;

CREATE TABLE [SYS_QUERY_CONDITION_INFO] (
  [CONDITION_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NOT NULL,
  [PAGE_ID] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [COMPONENT_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [QUERY_CONDITION_INFO] NVARCHAR(max) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL,
  [IS_DEFAULT] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_QUERY_CONDITION_INFO] ADD CONSTRAINT [PK__SYS_QUERY_CONDITION_INFO__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([CONDITION_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'CONDITION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'页面ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'PAGE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'组件ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'COMPONENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'查询条件',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'QUERY_CONDITION_INFO'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'是否默认，默认为1',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO',
'COLUMN', N'IS_DEFAULT'

EXEC sp_addextendedproperty
'MS_Description', N'查询条件信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_QUERY_CONDITION_INFO'
;
-- ----------------------------
-- Table structure for SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------

CREATE TABLE [SYS_CUSTOM_LIST_FIELD_INFO] (
  [INFO_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NOT NULL,
  [PAGE_ID] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [COMPONENT_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [COMPONENT_INFO] NVARCHAR(max) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL,
  [DEL_FLAG] NCHAR(1) NULL
)
;

ALTER TABLE [SYS_CUSTOM_LIST_FIELD_INFO] ADD CONSTRAINT [PK__SYS_CUSTOM_LIST_FIELD_INFO__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([INFO_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'INFO_ID'

EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'页面ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'PAGE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'组件ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'COMPONENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'页面信息',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'COMPONENT_INFO'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'删除标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO',
'COLUMN', N'DEL_FLAG'

EXEC sp_addextendedproperty
'MS_Description', N'自定义字段信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CUSTOM_LIST_FIELD_INFO'
;

-- ----------------------------
-- Table structure for SYS_APP_MENU_RESOURCE
-- ----------------------------


CREATE TABLE [SYS_APP_MENU_RESOURCE] (
  [APP_NAME] NVARCHAR(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [PAGE_ID] NVARCHAR(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [RELATION_ID] NUMERIC(20)  NULL,
  [RELATION_REF_ID] NUMERIC(20)  NULL,
  [RELATION_TYPE] NVARCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL
)
;

ALTER TABLE [SYS_APP_MENU_RESOURCE] SET (LOCK_ESCALATION = TABLE)
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'应用名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'APP_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'应用下的页面Id，用于应用页面菜单和资源的自动绑定',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'PAGE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'关联Id;菜单Id或资源Id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'RELATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能Id;当应用关联菜单时有值;用于自动关联功能和资源',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'RELATION_REF_ID'

EXEC sp_addextendedproperty
'MS_Description', N'1=应用关联的菜单；2=应用关联的资源',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'RELATION_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'应用与菜单及资源的关联关系表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_APP_MENU_RESOURCE'
;

-- ----------------------------
-- Table structure for SYS_AGENDA
-- ----------------------------

CREATE TABLE [SYS_AGENDA] (
  [AGENDA_ID] NUMERIC(20)  NOT NULL,
  [AGENDA_TITLE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS NOT NULL,
  [AGENDA_TYPE] NCHAR(1) COLLATE Chinese_PRC_CI_AS NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2 NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL,
  [AGENDA_CONTENT] NVARCHAR(1024)  COLLATE Chinese_PRC_CI_AS NULL,
  [PLACE] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [START_TIME] DATETIME2 NOT NULL,
  [END_TIME] DATETIME2 NOT NULL
)
;

ALTER TABLE [SYS_AGENDA] ADD CONSTRAINT [PK__sys_agenda__EB7305B2CC7DFDC8] PRIMARY KEY CLUSTERED ([AGENDA_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'日程id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'AGENDA_ID'

EXEC sp_addextendedproperty
'MS_Description', N'日程标题',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'AGENDA_TITLE'

EXEC sp_addextendedproperty
'MS_Description', N'日程类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'AGENDA_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑着',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'日程内容',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'AGENDA_CONTENT'

EXEC sp_addextendedproperty
'MS_Description', N'地点',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'PLACE'

EXEC sp_addextendedproperty
'MS_Description', N'开始时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'START_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'结束时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA',
'COLUMN', N'END_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'日程管理表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_AGENDA'
;

-- ----------------------------
-- Table structure for SYS_BASE_CONFIG
-- ----------------------------


CREATE TABLE [SYS_BASE_CONFIG] (
  [CONFIG_ID] NUMERIC(20)  NOT NULL,
  [NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_KEY] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CONFIG_VALUE] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [EXAMPLE] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_ID] NUMERIC(20)  NULL,
  [CONFIG_RULE] NVARCHAR(50) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_BASE_CONFIG] ADD CONSTRAINT [PK__sys_base__8AEE09EE4C5E3C21] PRIMARY KEY CLUSTERED ([CONFIG_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CONFIG_ID'

EXEC sp_addextendedproperty
'MS_Description', N'描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'NAME'

EXEC sp_addextendedproperty
'MS_Description', N'键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CONFIG_KEY'

EXEC sp_addextendedproperty
'MS_Description', N'值',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CONFIG_VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'示例',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'EXAMPLE'

EXEC sp_addextendedproperty
'MS_Description', N'上级id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'PARENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'校验规则',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG',
'COLUMN', N'CONFIG_RULE'

EXEC sp_addextendedproperty
'MS_Description', N'平台基础配置表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_BASE_CONFIG'
;

-- ----------------------------
-- Records of SYS_BASE_CONFIG
-- ----------------------------
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('111', N'账户配置', N'account_config', N'', NULL, NULL, NULL, NULL, N'账户配置项，在账户未登录天数超过配置时，账户状态会变为休眠，若没有再次被激活，则会被自动注销，账户状态变化和自动注销前都会给账户配置的邮箱发送提示短信', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('222', N'登录失败配置', N'login_fail_config', NULL, NULL, NULL, NULL, NULL, N'密码输入错误相关配置，在连续失败时间内达到了配置连续失败次数时，会对账号按锁定时间进行锁定，若配置了失败消息接收邮箱，会发送邮件提醒', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('333', N'登录时间配置', N'login_time_config', NULL, NULL, NULL, NULL, NULL, N'登录时间配置，开启后只有在允许的时间段内登录系统', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('444', N'登录ip配置', N'login_ip_config', NULL, NULL, NULL, NULL, NULL, N'登录ip配置，配置允许或禁止某些ip地址登录系统，限制外的ip地址登录时会发送邮件提醒', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('666', N'密码配置', N'password_config', N'', NULL, NULL, NULL, NULL, N'用户密码配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('777', N'创建用户配置', N'user_create_config', N'', NULL, NULL, NULL, NULL, N'创建用户配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('888', N'页面配置', N'theme_config', N'', NULL, NULL, NULL, NULL, N'页面参数配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('999', N'审核配置', N'audit_config', N'', NULL, NULL, NULL, NULL, N'审核配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1111', N'未登录天数', N'nologin_day', N'-1', NULL, NULL, NULL, NULL, N'单位天。超过配置天数账号会休眠，-1为不休眠', '111', N'checkNumber')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1112', N'账户状态', N'user_account_status', N'3', NULL, NULL, NULL, NULL, N'单选框。休眠', '111', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1113', N'休眠提醒邮件标题', N'status_change_email_title', N'账户状态变更提醒', NULL, NULL, NULL, NULL, N'自动休眠提醒邮件标题', '111', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1114', N'休眠提醒邮件内容', N'status_change_email', N'您的账号:#{user_account},由于超过#{nologin_day}天未登录，账户已被#{user_account_status}。</br>如要继续使用，请联系管理员', NULL, NULL, NULL, NULL, N'自动休眠提醒邮件模版', '111', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1115', N'休眠多久自动注销', N'logout_day', N'365', NULL, NULL, NULL, NULL, N'0或正整数，单位天。示例 ：365', '111', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1116', N'注销前多久发送邮件', N'email_before_logout_day', N'5', NULL, NULL, NULL, NULL, N'正整数，单位天。示例 ：5', '111', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1117', N'注销提醒邮件标题', N'logout_warn_email_title', N'账户注销提醒', NULL, NULL, NULL, NULL, N'自动注销提醒邮件标题', '111', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1118', N'注销提醒邮件内容', N'logout_warn_email', N'您的账号:#{user_account},将在#{email_before_logout_day}天后注销。</br>如要继续使用，请尽快联系管理员', NULL, NULL, NULL, NULL, N'自动注销提醒邮件模板', '111', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2221', N'连续失败时间', N'fail_time', N'1', NULL, NULL, NULL, NULL, N'正整数，单位：分钟，示例：3', '222', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2222', N'连续失败次数', N'fail_number', N'5', NULL, NULL, NULL, NULL, N'正整数。示例 ：3', '222', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2223', N'连续失败锁定时间', N'fail_lock_time', N'2', NULL, NULL, NULL, NULL, N'正整数，单位：分钟，示例 ：60', '222', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2224', N'失败消息接收邮箱', N'fail_email_box', N'', NULL, NULL, NULL, NULL, N'管理员邮箱，邮箱间英文逗号分隔，不填写不发送', '222', N'checkEmails')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2225', N'失败邮件标题', N'fail_email_title', N'账号连续登录失败提醒', NULL, NULL, NULL, NULL, N'账户锁定邮件标题', '222', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2226', N'失败邮件内容', N'fail_email', N'用户账号:#{user_account}密码连续输入错误#{fail_number}次，账号已被锁定', NULL, NULL, NULL, NULL, N'账户锁定邮件模板', '222', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('3331', N'登录时间限制', N'login_time_limit', N'1', NULL, NULL, NULL, NULL, N'登录限制开关', '333', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('3332', N'允许登录开始时间', N'login_start_time', N'08:00:00', NULL, NULL, NULL, NULL, N'允许登录开始时间', '333', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('3333', N'允许登录结束时间', N'login_end_time', N'20:00:00', NULL, NULL, NULL, NULL, N'允许登录结束时间', '333', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4441', N'登录ip限制', N'login_ip_limit', N'1', NULL, NULL, NULL, NULL, N'ip限制开关', '444', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4442', N'允许登录ip', N'allow_login_ip', N'', NULL, NULL, NULL, NULL, N'允许访问系统的ip,ip之间英文逗号分隔，不填写不生效', '444', N'checkIPs')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4443', N'禁止登录ip', N'forbid_login_ip', N'', NULL, NULL, NULL, NULL, N'禁止访问系统的ip,ip之间英文逗号分隔，不填写不生效', '444', N'checkIPs')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4444', N'ip预警接收邮箱', N'ip_warn_email_box', N'', NULL, NULL, NULL, NULL, N'管理员邮箱，邮箱间英文逗号分隔，不填写不发送', '444', N'checkEmails')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4445', N'ip预警邮件标题', N'ip_warn_email_title', N'ip登录预警', NULL, NULL, NULL, NULL, N'ip预警邮件标题', '444', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('4446', N'ip预警邮件模板', N'ip_warn_email', N'存在未经允许的ip登录系统，ip地址：#{ip_address}</br>用户名称：#{user_name}</br>用户账号：#{user_account}', NULL, NULL, NULL, NULL, N'ip预警邮件模板', '444', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('5551', N'会话限制', N'session_limit', N'0', NULL, NULL, NULL, NULL, N'默认开启', '555', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('5552', N'最大会话数', N'max_session_num', N'1000000', NULL, NULL, NULL, NULL, N'系统最大会话数，同时开启session_limit和kickout_after时才生效，配置为-1为不限制会话数量', '555', N'checkNumber')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('5553', N'会话超出限制时，踢出后者', N'kickout_after', N'0', NULL, NULL, NULL, NULL, N'开启时剔除后者即新登录用户不能登录，关闭时剔除最先登录的', '555', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6661', N'系统缺省密码规则', N'pwd_rule', N'8,16,3', NULL, NULL, NULL, NULL, N'系统缺省密码规则（"最小长度，最大长度，密码强度"）,缺省规则是( 8,16,3 );最小不能小于8位，最大不能大于16位，强度为3
密码强度规则分1-3级，各级的含义如下：
级别1：如果密码只由数字、小写字母、大写字母或其它特殊符号当中的一种组成,则认为这是一个弱密码.
级别2：如果密码由数字、小写字母、大写字母或其它特殊符号当中的两种组成,则认为这是一个中度安全的密码
级别3：如果密码由数字、小写字母、大写字母或其它特殊符号当中的三种以上组成,则认为这是一个比较安全的密码.', '666', N'checkStrengthRule')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6663', N'自定义密码复杂度', N'pwd_rule_custom', N'1', NULL, NULL, NULL, NULL, N'开启自定义时,pwd_complexity_regular 自定义正则表达式，unmatched_hint 自定义返回消息；不开启时使用平台自带规则', '666', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6664', N'密码复杂度正则', N'pwd_complexity_regular', N'/^[\S]{6,12}$/', NULL, NULL, NULL, NULL, N'正则校验密码规则', '666', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG]([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE]) VALUES (6665, N'自定义返回消息', N'unmatched_hint', N'新密码不符合密码规则！', NULL, NULL, NULL, NULL, N'修改密码时的自定义返回消息，开启自定义密码复杂度时生效', 666, N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6666', N'强制修改密码', N'force_change_pwd', N'0', NULL, NULL, NULL, NULL, N'是否在第一次登录或一段时间后强制用户修改密码', '666', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6667', N'密码生命周期', N'password_hist', N'90', NULL, NULL, NULL, NULL, N'正整数，多少天后强制修改密码  单位（天）', '666', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('6668', N'密码重复次数', N'pwd_repeat_time', N'2', NULL, NULL, NULL, NULL, N'正整数，密码不能和前几次相同', '666', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('7771', N'创建用户时发送邮件', N'create_user_send_email', N'1', NULL, NULL, NULL, NULL, N'创建用户时发送邮件开关', '777', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('7772', N'创建用户时使用默认密码', N'create_user_use_default_pass', N'0', NULL, NULL, NULL, NULL, N'创建用户是否使用默认密码，开启时使用默认密码，不开启时使用密码规则生成的密码。为防止生成的密码无法得知，当create_user_send_email关闭时也使用默认密码', '777', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('7773', N'用户默认密码', N'default_password', N'123456', NULL, NULL, NULL, NULL, N'用户默认密码，可输入数字、大写字母、小写字母、英文特殊字符（`~!@#$%^&*()_|+<>?:"{},./;''[]-）', '777', N'checkdefultpw')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('7775', N'操作人员同时操作用户', N'operate_staff_with_user', N'1', NULL, NULL, NULL, NULL, N'开启时操作人员同时操作用户（新增、修改、删除、转移）', '777', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('8883', N'标签页切换刷新', N'tab_switchover', N'0', NULL, NULL, NULL, NULL, N'标签页切换刷新开关，重新登录后生效', '888', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9991', N'关键操作审核', N'critical_operations_audit', N'1', NULL, NULL, NULL, NULL, N'关键操作是否需要审核，总开关，只有开启后，下面几个开关才分别生效', '999', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9992', N'组织机构审核', N'organ_audit', N'0', NULL, NULL, NULL, NULL, N'组织机构操作审核开关', '999', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9993', N'用户审核', N'user_audit', N'0', NULL, NULL, NULL, NULL, N'用户操作审核开关', '999', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9994', N'用户角色审核', N'role_audit', N'0', NULL, NULL, NULL, NULL, N'用户角色操作审核开关', '999', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9996', N'登录页背景图', N'login_view_background', N'', NULL, NULL, NULL, NULL, N'登录页背景图', '202020', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9997', N'登录框背景图', N'login_view_innerBackground', N'', NULL, NULL, NULL, NULL, N'登录框背景图', '202020', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('9998', N'浏览器页签图标的配置项', N'relation_icon', N'', NULL, NULL, NULL, NULL, N'浏览器页签图标的配置项', '212121', N'')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('101010', N'异常报警配置', N'exception_config', N'', NULL, NULL, NULL, NULL, N'异常报警配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('121212', N'登录配置', N'login_config', N'', NULL, NULL, NULL, NULL, N'登录配置', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('202020', N'登录页可视化配置', N'login_view_config', NULL, NULL, NULL, NULL, NULL, N'门户登录页可视化配置', '2', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('212121', N'首页可视化配置', N'home_page', NULL, NULL, NULL, NULL, NULL, N'首页可视化配置', '2', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1010101', N'审计日志报警条数', N'securitylog_count_alert', N'100000', NULL, NULL, NULL, NULL, N'超过此条数时报警，只能输入正整数，默认不发送，配置后才发送', '101010', N'checkPositiveNum')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1010102', N'异常报警', N'exception_alert', N'1', NULL, NULL, NULL, NULL, N'异常报警开关，权限异常时会发送告警邮件', '101010', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1010103', N'异常报警接收邮件邮箱', N'exception_alert_email', N'', NULL, NULL, NULL, NULL, N'多个邮箱使用,隔开', '101010', N'checkEmails')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1212121', N'区分登录账号大小写', N'login_upper_open', N'0', NULL, NULL, NULL, NULL, N'区分登录账号大小写开关', '121212', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1212122', N'登录验证码', N'kaptcha_open', N'1', NULL, NULL, NULL, NULL, N'console端登录验证码开关。如需配置门户验证码开关，请前往门户配置中心-登录页配置-配置项。', '121212', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1212123', N'登录时动态密码验证', N'totp_open', N'1', NULL, NULL, NULL, NULL, N'登录动态密码验证开关', '121212', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('1212124', N'动态密码验证允许时间偏差', N'totp_offset_min', N'2', NULL, NULL, NULL, NULL, N'单位 min 分钟， 默认0，无偏差验证，必须保证手机端和服务器时间误差在30s之内才能准确验证', '121212', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020201', N'登录布局', N'login_view_type', N'1', NULL, NULL, NULL, NULL, N'登录页面布局', '202020', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020202', N'系统名称', N'login_view_sysname', N'统一门户', NULL, NULL, NULL, NULL, N'登录页面显示的系统名称', '202020', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020203', N'系统LOGO', N'login_view_logo', N'', NULL, NULL, NULL, NULL, N'登录页面显示的系统logo', '202020', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020204', N'版权所有', N'login_view_copyright', N'', NULL, NULL, NULL, NULL, N'登录页面显示的版权所有信息', '202020', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020205', N'验证码', N'login_view_kaptcha', N'1', NULL, NULL, NULL, NULL, N'登录时是否进行验证码验证', '202020', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2020206', N'记住密码', N'login_rememberpwd', N'1', NULL, NULL, NULL, NULL, N'登录时是否记住密码', '202020', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2121211', N'首页布局类型', N'home_page_type', N'0', NULL, NULL, NULL, NULL, N'首页布局类型', '212121', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2121212', N'首页系统名称', N'home_page_sysname', N'统一门户', NULL, NULL, NULL, NULL, N'首页显示系统名称', '212121', N'checkNotEmpty')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('2121213', N'首页系统LOGO', N'home_page_logo', N'', NULL, NULL, NULL, NULL, N'首页显示系统LOGO', '212121', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('202202170', N'主题权限配置', N'theme_config_edit', N'1', NULL, NULL, NULL, NULL, N'主题权限配置，是否启用主题配置编辑功能', '1', NULL)
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE])VALUES ('202202171', N'主题权限配置', N'enable_theme_config_edit', N'1', NULL, NULL, NULL, NULL, N'是否启用主题配置编辑功能', '202202170', N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE]) VALUES (99910, N'岗位审核', N'post_audit', N'0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', N'岗位操作审核开关', 999, N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE]) VALUES (99911, N'人员审核', N'staff_audit', N'0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', N'人员操作审核开关', 999, N'checkRadio')
;
INSERT INTO [SYS_BASE_CONFIG] ([CONFIG_ID], [NAME], [CONFIG_KEY], [CONFIG_VALUE], [CREATE_TIME], [CREATOR], [LAST_EDITOR], [LAST_TIME], [EXAMPLE], [PARENT_ID], [CONFIG_RULE]) VALUES (1212125, N'令牌有效时间', N'access_token_valid_time', N'1800', NULL, NULL, 1450756958461300737, '2023-07-20 19:30:43', N'令牌有效时间，单位秒。', 121212, N'checkTokenValidTime')
;


-- ----------------------------
-- Table structure for SYS_CALENDAR
-- ----------------------------


CREATE TABLE [SYS_CALENDAR] (
  [CALENDAR_ID] NUMERIC(20)  NOT NULL,
  [TITLE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [START_TIME] DATETIME2  NULL,
  [END_TIME] DATETIME2  NULL,
  [CLASS_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [REMARK] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [STATUS] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_CALENDAR] ADD CONSTRAINT [PK__sys_cale__EB730BD4F77CD71B] PRIMARY KEY CLUSTERED ([CALENDAR_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'CALENDAR_ID'

EXEC sp_addextendedproperty
'MS_Description', N'事件标题',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'TITLE'

EXEC sp_addextendedproperty
'MS_Description', N'开始时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'START_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'结束时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'END_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'事件的样式',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'CLASS_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'备注',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'REMARK'

EXEC sp_addextendedproperty
'MS_Description', N'状态',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR',
'COLUMN', N'STATUS'

EXEC sp_addextendedproperty
'MS_Description', N'工作日历表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CALENDAR'
;


-- ----------------------------
-- Records of SYS_CALENDAR
-- ----------------------------
INSERT INTO [SYS_CALENDAR] ([CALENDAR_ID], [TITLE], [START_TIME], [END_TIME], [CLASS_NAME], [CREATOR], [LAST_EDITOR], [CREATE_TIME], [LAST_TIME], [REMARK], [STATUS]) VALUES ('1450383908880433153', N'班', '2018-05-01 00:00:00', NULL, N'work', NULL, NULL, '2018-05-22 00:00:00', NULL, NULL, NULL)
;

INSERT INTO [SYS_CALENDAR] ([CALENDAR_ID], [TITLE], [START_TIME], [END_TIME], [CLASS_NAME], [CREATOR], [LAST_EDITOR], [CREATE_TIME], [LAST_TIME], [REMARK], [STATUS]) VALUES ('1450384023288541185', N'休', '2018-05-04 00:00:00', NULL, N'holiday', NULL, NULL, NULL, NULL, NULL, NULL)
;

-- ----------------------------
-- Table structure for SYS_CONF_ROLES
-- ----------------------------


CREATE TABLE [SYS_CONF_ROLES] (
  [SCR_ID] NUMERIC(20)  NOT NULL,
  [ROLE_ID] NUMERIC(20)  NULL,
  [SET_ID] NUMERIC(20)  NULL,
  [SYS_SET_ID] NUMERIC(20)  NULL,
)
;

ALTER TABLE [SYS_CONF_ROLES] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_CONF_ROLES
-- ----------------------------
ALTER TABLE [SYS_CONF_ROLES] ADD CONSTRAINT [PK__SYS_CONF_ROLES__SCR_ID] PRIMARY KEY CLUSTERED ([SCR_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLES',
'COLUMN', N'SCR_ID'
EXEC sp_addextendedproperty
'MS_Description', N'角色编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLES',
'COLUMN', N'ROLE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色集编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLES',
'COLUMN', N'SET_ID'

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色集编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLES',
'COLUMN', N'SYS_SET_ID'

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLES'
;


-- ----------------------------
-- Table structure for SYS_CONF_ROLESET
-- ----------------------------


CREATE TABLE [SYS_CONF_ROLESET] (
  [SET_ID] NUMERIC(20)  NOT NULL,
  [SET_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CARDINALITY] NUMERIC(10)  NULL,
  [CORPORATION_ID] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [ROLESET_REMARK] NVARCHAR(128)
)
;

ALTER TABLE [SYS_CONF_ROLESET] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_CONF_ROLESET] ADD CONSTRAINT [PK__sys_conf__7D7B0FB5A50E1DE3] PRIMARY KEY CLUSTERED ([SET_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色集编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'SET_ID'

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色集名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'SET_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'基数',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'CARDINALITY'

EXEC sp_addextendedproperty
'MS_Description', N'所属公司结构编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'CORPORATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次更新时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次更新人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET',
'COLUMN', N'ROLESET_REMARK'

EXEC sp_addextendedproperty
'MS_Description', N'不相容角色集',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_CONF_ROLESET'
;
-- ----------------------------
-- Table structure for SYS_DICT_GROUP
-- ----------------------------


CREATE TABLE [SYS_DICT_GROUP] (
  [GROUP_ID] NUMERIC(20)  NOT NULL,
  [PARENT_ID] NUMERIC(20)  NULL,
  [GROUP_DESCRIPTION] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [RANGE_TYPE] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [SORT] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [BAK_1] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_2] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_3] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_DICT_GROUP] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_DICT_GROUP] ADD CONSTRAINT [PK__sys_dict__3EFEA3DEBBC5E427] PRIMARY KEY CLUSTERED ([GROUP_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'GROUP_ID'

EXEC sp_addextendedproperty
'MS_Description', N'父ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'PARENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'字典分组描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'GROUP_DESCRIPTION'

EXEC sp_addextendedproperty
'MS_Description', N'编辑类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'RANGE_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'SORT'

EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段1',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'BAK_1'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段2',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'BAK_2'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段3',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP',
'COLUMN', N'BAK_3'

EXEC sp_addextendedproperty
'MS_Description', N'字典分组表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_GROUP'
;


-- ----------------------------
-- Records of SYS_DICT_GROUP
-- ----------------------------
INSERT INTO [SYS_DICT_GROUP] ([GROUP_ID], [PARENT_ID], [GROUP_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES ('1450384393200865282', '11', N'系统字典', N'sys', '1', NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_GROUP] ([GROUP_ID], [PARENT_ID], [GROUP_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES ('1450384438474231809', '11', N'业务字典', N'biz', '2', NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL)
;


-- ----------------------------
-- Table structure for SYS_DICT_SINGLE
-- ----------------------------


CREATE TABLE [SYS_DICT_SINGLE] (
  [DICT_ID] NUMERIC(20)  NOT NULL,
  [TYPE_ID] NUMERIC(20)  NULL,
  [VALUE] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [LABEL] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [SORT] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [BAK_1] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_2] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_3] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_ID] NUMERIC(20)  NULL
)
;

ALTER TABLE [SYS_DICT_SINGLE] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_DICT_SINGLE] ADD CONSTRAINT [PK__sys_dict__CB0CC8406E6ED417] PRIMARY KEY CLUSTERED ([DICT_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'编号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'DICT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'类型(SYS_DICT_TYPE外键)',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'TYPE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'数据值',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'标签名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'LABEL'

EXEC sp_addextendedproperty
'MS_Description', N'排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'SORT'

EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段1',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'BAK_1'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段2',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'BAK_2'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段3',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'BAK_3'

EXEC sp_addextendedproperty
'MS_Description', N'父级主键ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE',
'COLUMN', N'PARENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'字典字段表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_SINGLE'
;


-- ----------------------------
-- Records of SYS_DICT_SINGLE
-- ----------------------------
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561655, 517670295990181889, N'dialog', N'弹窗', 1, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561656, 517670295990181889, N'browserTab', N'浏览器页签', 2, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561657, 517670295990181889, N'tab', N'系统内页签', 3, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561658, 517670295990181889, N'noCode', N'零代码', 4, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (795585252704919552, 794925156320681984, N'user', N'用户', 1, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (812013673790054400, 794925156320681984, N'client', N'客户', 2, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (812013805734469632, 794925156320681984, N'supplier', N'供应商', 3, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (806812606638858240, 676356930893258752, N'4', N'联系人导入', 4, 1450756958461300737, '2024-02-05 09:05:15', 1450756958461300737, '2024-02-05 09:05:15', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357144312029184, 676356969782845440, N'1', N'组织机构导出', 1, 1450756958461300737, '2023-02-10 09:21:49', 1450756958461300737, '2023-02-10 09:21:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357177321201664, 676356969782845440, N'2', N'用户人员导出', 2, 1450756958461300737, '2023-02-10 09:21:57', 1450756958461300737, '2023-02-10 09:21:57', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357019191746560, 676356930893258752, N'1', N'组织机构导入', 1, 1450756958461300737, '2023-02-10 09:21:19', 1450756958461300737, '2023-02-10 09:21:19', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357106202583040, 676356930893258752, N'2', N'用户人员导入', 2, 1450756958461300737, '2023-02-10 09:21:40', 1450756958461300737, '2023-02-10 09:21:40', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357106206842918, 676356930893258752, N'3', N'字典导入', 3, 1450756958461300737, '2023-06-09 10:21:40', 1450756958461300737, '2023-06-09 11:22:40', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676357177321284927, 676356969782845440, N'3', N'字典导出', 3, 1450756958461300737, '2023-06-09 09:21:57', 1450756958461300737, '2023-06-09 10:21:57', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (696315839754018816, 696315722368032768, N'0', N'导入中', 1, NULL, '2023-04-06 11:10:33', NULL, '2023-04-06 11:10:33', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (696315890861613056, 696315722368032768, N'4', N'导入成功', 2, NULL, '2023-04-06 11:10:45', NULL, '2023-04-06 11:10:45', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (696315957861425152, 696315722368032768, N'-1', N'导入失败', 3, NULL, '2023-04-06 11:11:01', NULL, '2023-04-06 11:11:01', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (700277290533396480, 696315722368032768, N'6', N'导出成功', 4, NULL, '2023-04-17 09:31:57', NULL, '2023-04-17 09:31:57', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (673842271296430080, 673842175301394432, N'2', N'覆盖更新', 2, 1450756958461300737, '2023-02-03 10:48:37', 1450756958461300737, '2023-02-10 08:56:29', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (676350515063562240, 673842175301394432, N'1', N'忽略导入', 1, 1450756958461300737, '2023-02-10 08:55:29', 1450756958461300737, '2023-02-14 15:16:44', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (677896054456459264, 673842175301394432, N'4', N'报错提醒', 4, 1450756958461300737, '2023-02-14 15:16:54', 1450756958461300737, '2023-02-14 15:16:54', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561602, 1450742089372590096, N'1', N'系统级事件', 1, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561603, 1450742089372590093, N'1', N'部门经理', 1, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561604, 1450742089372590097, N'1', N'激活', 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561605, 1450742089372590088, N'1', N'全部可见', 1, NULL, '2021-03-04 14:29:11', NULL, '2021-03-04 14:29:11', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561606, 1450742089372590083, N'tab', N'标签页', 1, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561607, 1450742089372590091, N'70', N'秘密', 3, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561608, 1450742089372590091, N'71', N'核心商业秘密', 2, NULL, '2021-04-26 11:18:31', NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561609, 1450742089372590093, N'2', N'阿米巴负责人', 2, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561610, 1450742089372590083, N'left', N'隐藏左侧', 3, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561611, 1450742089372590093, N'4', N'员工', 4, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561612, 1450742089372590087, N'2', N'驳回，请重新申请', 2, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561613, 1450742089372590082, N'res_btn', N'接口资源', 2, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561614, 1450742089372590087, N'3', N'驳回至第一节点', 3, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561615, 1450742089372590096, N'2', N'业务级事件', 2, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561616, 1450742089372590094, N'holiday', N'休', 2, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561617, 1450742089372590083, N'full', N'新页面', 2, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561618, 1450742089372590088, N'2', N'所在部门及子级可见', 2, NULL, '2021-03-04 14:30:33', NULL, '2021-03-04 14:30:33', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561619, 1450742089372590094, N'notice', N'通知', 3, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561620, 1450742089372590090, N'0', N'临时账号', 2, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561621, 1450742089372590088, N'3', N'仅所在部门可见', 3, NULL, '2021-03-04 14:30:45', NULL, '2021-03-04 14:30:45', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561622, 1450742089372590099, N'1', N'是', 1, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561623, 1450742089372590099, N'0', N'否', 2, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561624, 1450742089372590088, N'4', N'仅所属人可见', 4, NULL, '2021-03-04 14:30:58', NULL, '2021-03-04 14:30:58', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561625, 1450742089372590098, N'2', N'女', 10, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561626, 1450742089372590098, N'1', N'男', 1, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561627, 1450742089372590088, N'5', N'自定义可见范围', 5, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561628, 1450742089372590095, N'clbx', N'差旅报销', 1, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561629, 1450742089372590097, N'0', N'锁定', 3, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:09', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561630, 1450742089372590090, N'1', N'长期账号', 1, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561631, 1450742089372590086, N'0', N'未审核', 2, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561632, 1450742089372590097, N'3', N'休眠', 2, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561633, 1450742089372590091, N'61', N'普通商业秘密', 4, NULL, '2021-04-26 11:19:18', NULL, '2021-04-26 11:19:14', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561634, 1450742089372590092, N'80', N'重要', 2, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561635, 1450742089372590091, N'80', N'机密', 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561636, 1450742089372590085, N'0', N'失败', 1, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561637, 1450742089372590094, N'work', N'班', 1, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561638, 1450742089372590091, N'60', N'内部', 5, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561639, 1450742089372590086, N'2', N'驳回', 3, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561640, 1450742089372590089, N'2', N'人员', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561641, 1450742089372590082, N'res_menu', N'页面资源', 1, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561642, 1450742089372590084, N'1', N'是', 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561643, 1450742089372590092, N'90', N'核心', 1, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561644, 1450742089372590095, N'xmgl', N'项目管理', 2, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561645, 1450742089372590085, N'1', N'成功', 2, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561646, 1450742089372590086, N'1', N'通过', 1, NULL, '2018-04-14 13:39:16', NULL, '2018-04-18 09:57:14', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561647, 1450742089372590091, N'50', N'公开', 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561648, 1450742089372590089, N'1', N'角色', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561649, 1450742089372590084, N'0', N'否', 1, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561650, 1450742089372590087, N'1', N'驳回', 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561651, 1450742089372590092, N'60', N'非密', 4, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561652, 1450742089372590092, N'70', N'一般', 3, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561653, 1450742089372590093, N'3', N'项目经理', 3, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (517670394224975872, 517670295990181888, N'1', N'驳回', 1, 1450756958461300737, '2021-11-29 11:57:20', 1450756958461300737, '2021-11-29 11:57:20', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (517670664690475008, 517670295990181888, N'2', N'驳回，请重新申请', 2, 1450756958461300737, '2021-11-29 11:58:24', 1450756958461300737, '2021-11-29 11:58:24', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (517670721909170176, 517670295990181888, N'3', N'驳回至第一节点', 3, 1450756958461300737, '2021-11-29 11:58:38', 1450756958461300737, '2021-11-29 11:58:38', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (523443293179355136, 523443198920761344, N'0', N'内部组件', 1, NULL, '2021-12-15 10:16:46', NULL, '2021-12-15 10:16:46', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (523444544218603520, 523443198920761344, N'1', N'外部组件', 2, NULL, '2021-12-15 10:21:44', NULL, '2021-12-15 10:21:44', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (523444626317910016, 523443198920761344, N'3', N'URL', 4, NULL, '2021-12-15 10:22:04', NULL, '2021-12-15 10:22:04', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (524165267232923648, 524165175805485056, N'1', N'公告', 1, 1450756958461300737, '2021-12-17 10:05:38', 1450756958461300737, '2021-12-17 10:05:38', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (524611884536832000, 524165175805485056, N'2', N'通知', 2, 1450756958461300737, '2021-12-18 15:40:20', 1450756958461300737, '2021-12-18 15:40:20', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (591917296298237952, 591913311474556928, N'20', N'前20名', 4, 1450756958461300737, '2022-06-22 09:08:01', 1450756958461300737, '2022-06-22 09:08:01')
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (591913706074677248, 591913311474556928, N'15', N'前15名', 3, 1450756958461300737, '2022-06-22 08:53:45', 1450756958461300737, '2022-06-22 08:53:45')
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (591913605549793280, 591913311474556928, N'10', N'前10名', 2, 1450756958461300737, '2022-06-22 08:53:21', 1450756958461300737, '2022-06-22 08:53:21')
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (591913513669369856, 591913311474556928, N'5', N'前5名', 1, 1450756958461300737, '2022-06-22 08:52:59', 1450756958461300737, '2022-06-22 08:52:59')
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586233816600027136, 586233551075418112, N'1', N'阿里云', 1, 1450756958461300737, '2022-06-06 16:43:54', 1450756958461300737, '2022-06-06 16:43:54', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586233852901728256, 586233551075418112, N'2', N'腾讯云', 2, 1450756958461300737, '2022-06-06 16:44:02', 1450756958461300737, '2022-06-06 16:44:02', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586260304451870720, 575022217952501760, N'2', N'发送失败', 2, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586260336982892544, 575022217952501760, N'3', N'发送成功', 3, 1450756958461300737, '2022-06-06 18:29:17', 1450756958461300737, '2022-06-06 18:29:17', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586262527764340736, 586262390337970176, N'1', N'启用', 1, 1450756958461300737, '2022-06-06 18:37:59', 1450756958461300737, '2022-06-06 18:37:59', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586262557128663040, 586262390337970176, N'0', N'禁用', 2, 1450756958461300737, '2022-06-06 18:38:06', 1450756958461300737, '2022-06-06 18:38:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586658954864762880, 586658891807596544, N'1', N'SMTP', 1, 1450756958461300737, '2022-06-07 20:53:14', 1450756958461300737, '2022-06-07 20:53:14', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586658992051462144, 586658891807596544, N'2', N'EXCHANGE(微软)', 2, 1450756958461300737, '2022-06-07 20:53:23', 1450756958461300737, '2022-06-07 20:53:23', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586659341466345472, 586659288706195456, N'1', N'SSL', 1, 1450756958461300737, '2022-06-07 20:54:47', 1450756958461300737, '2022-06-07 20:54:47', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586659379760340992, 586659288706195456, N'2', N'STARTTLS', 2, 1450756958461300737, '2022-06-07 20:54:56', 1450756958461300737, '2022-06-07 20:54:56', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587690415013240832, 587690275439386624, N'0', N'App本身', 1, 1450756958461300737, '2022-06-10 17:11:54', 1450756958461300737, '2022-06-10 17:11:54', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587690459435114496, 587690275439386624, N'1', N'打开activity', 2, 1450756958461300737, '2022-06-10 17:12:04', 1450756958461300737, '2022-06-10 17:12:04', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587690502590308352, 587690275439386624, N'2', N'打开浏览器', 3, 1450756958461300737, '2022-06-10 17:12:15', 1450756958461300737, '2022-06-10 17:12:15', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587690549516181504, 587690275439386624, N'3', N'打开Intent', 4, 1450756958461300737, '2022-06-10 17:12:26', 1450756958461300737, '2022-06-10 17:12:26', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587956098712215552, 587955865517301760, N'0', N'android', 1, 1450756958461300737, '2022-06-11 10:47:38', 1450756958461300737, '2022-06-11 10:47:38', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587956198599565312, 587955865517301760, N'1', N'IOS', 2, 1450756958461300737, '2022-06-11 10:48:01', 1450756958461300737, '2022-06-11 10:48:01', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587956413003997184, 587955865517301760, N'2', N'安卓+IOS', 3, 1450756958461300737, '2022-06-11 10:48:53', 1450756958461300737, '2022-06-11 10:48:53', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587957011560538112, 587956910612029440, N'0', N'全部', 1, 1450756958461300737, '2022-06-11 10:51:15', 1450756958461300737, '2022-06-11 10:51:15', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (587957143559479296, 587956910612029440, N'1', N'token', 2, 1450756958461300737, '2022-06-11 10:51:47', 1450756958461300737, '2022-06-11 10:51:47', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (608964020338434048, 608963936091643904, N'sms', N'短信', 1, 1450756958461300737, '2022-08-08 10:05:36', 1450756958461300737, '2022-08-08 10:05:36', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (608964253302661120, 608963936091643904, N'mail', N'邮件', 2, 1450756958461300737, '2022-08-08 10:06:32', 1450756958461300737, '2022-08-08 10:06:46', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (608964420399538176, 608963936091643904, N'wx_account', N'微信公众号', 3, 1450756958461300737, '2022-08-08 10:07:12', 1450756958461300737, '2022-08-08 10:07:12', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (608964548640382976, 608963936091643904, N'app_push', N'APP通知', 4, 1450756958461300737, '2022-08-08 10:07:42', 1450756958461300737, '2022-08-08 10:09:24', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (608964730950000640, 608963936091643904, N'app_im', N'IM', 5, 1450756958461300737, '2022-08-08 10:08:26', 1450756958461300737, '2022-08-08 10:08:26', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (609025100737683456, 608963936091643904, N'notice', N'内部通知', 6, 1450756958461300737, '2022-08-08 14:08:19', 1450756958461300737, '2022-08-08 14:08:19', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (586260304451870654, 575022217952501760, N'1', N'待发送', 1, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561654, 1450742089372590082, N'res_rights', N'数据资源', 3, 1450756958461300737, '2022-11-11 10:07:39', 1450756958461300737, '2022-11-11 10:07:39', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (688027377053474816, 608963936091643904, N'cp', N'企业微信', 7, 1450756958461300737, '2023-03-14 14:15:10', 1450756958461300737, '2023-03-14 14:15:10', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (698464699389583360, 608963936091643904, N'dingTalk', N'钉钉', 8, 1450756958461300737, '2023-04-12 09:29:21', 1450756958461300737, '2023-04-12 09:29:21', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (686887028247502848, 686886958856937472, N'1', N'零代码', 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (686887115581300736, 686886958856937472, N'2', N'低代码', 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (686887316178083840, 686886958856937472, N'3', N'自建应用', 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (714082823409246208, 714082718056718336, N'1', N'单行文本', 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (714082861522886656, 714082718056718336, N'2', N'多行文本', 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (714082900894818304, 714082718056718336, N'3', N'下拉选择', 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430081, 714082718056718337, N'1', N'不重置', 1, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430082, 714082718056718337, N'2', N'按年重置', 2, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430083, 714082718056718337, N'3', N'按季度重置', 3, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430084, 714082718056718337, N'4', N'按月重置', 4, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430085, 714082718056718337, N'5', N'按周重置', 5, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1684752048320430086, 714082718056718337, N'6', N'按日重置', 6, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482817, 714082718056718338, N'yyyy', N'年', 11, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482818, 714082718056718338, N'yyyyMM', N'年月', 12, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482819, 714082718056718338, N'yyyy-MM', N'年-月', 13, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482820, 714082718056718338, N'yyyy/MM', N'年/月', 14, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482821, 714082718056718338, N'yyyyMMdd', N'年月日', 15, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482822, 714082718056718338, N'yyyy-MM-dd', N'年-月-日', 16, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482823, 714082718056718338, N'yyyy/MM/dd', N'年/月/日', 17, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482824, 714082718056718338, N'yyyyMMddHHmm', N'年月日时分', 18, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482825, 714082718056718338, N'yyyyMMddHHmmss', N'年月日时分秒', 19, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482826, 714082718056718338, N'MMdd', N'月日', 20, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482827, 714082718056718338, N'MM-dd', N'月-日', 21, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482828, 714082718056718338, N'MM/dd', N'月/日', 22, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1683383216712482829, 714082718056718338, N'HHmmss', N'时间', 23, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (736951458939019264, 736951385576448000, N'0', N'内部组件', 1, 1450756958461300737, '2023-07-27 14:22:00', 1450756958461300737, '2023-07-27 14:22:00', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (736951496494817280, 736951385576448000, N'1', N'外部组件', 2, 1450756958461300737, '2023-07-27 14:22:09', 1450756958461300737, '2023-07-27 14:22:09', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (737025783427768320, 737025163346059264, N'1', N'待办', 1, 1450756958461300737, '2023-07-27 19:17:20', 1450756958461300737, '2023-07-27 19:17:20', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (737025830928261120, 737025163346059264, N'2', N'日程', 2, 1450756958461300737, '2023-07-27 19:17:31', 1450756958461300737, '2023-07-27 19:17:31', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (737025877589893120, 737025163346059264, N'3', N'会议', 3, 1450756958461300737, '2023-07-27 19:17:42', 1450756958461300737, '2023-07-27 19:17:42', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (737025935500648448, 737025163346059264, N'4', N'其他', 4, 1450756958461300737, '2023-07-27 19:17:56', 1450756958461300737, '2023-07-27 19:17:56', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1690913474055581697, 686886958856937472, N'7', N'微应用', 7, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (1450742089393561660, 1450742089372590088, N'6', N'根据用户所属组织类型分级授予可见范围', 6, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (811895928742223872, 811895803462557696, N'1', N'否', 2, 1450756958461300737, '2024-02-19 09:44:34', 1450756958461300737, '2024-02-19 09:44:34', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (811895903979053056, 811895803462557696, N'0', N'是', 1, 1450756958461300737, '2024-02-19 09:44:28', 1450756958461300737, '2024-02-19 09:44:28', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (811895869715783680, 811895718649536512, N'1', N'停用', 2, 1450756958461300737, '2024-02-19 09:44:20', 1450756958461300737, '2024-02-19 09:44:20', NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_SINGLE] ([DICT_ID], [TYPE_ID], [VALUE], [LABEL], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3], [PARENT_ID]) VALUES (811895839013478400, 811895718649536512, N'0', N'启用', 1, 1450756958461300737, '2024-02-19 09:44:12', 1450756958461300737, '2024-02-19 09:44:12', NULL, NULL, NULL, NULL)
;

-- ----------------------------
-- Table structure for SYS_DICT_TYPE
-- ----------------------------


CREATE TABLE [SYS_DICT_TYPE] (
  [TYPE_ID] NUMERIC(20)  NOT NULL,
  [PARENT_ID] NUMERIC(20)  NULL,
  [TYPE_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [TYPE_DESCRIPTION] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [RANGE_TYPE] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [SORT] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [BAK_1] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_2] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [BAK_3] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_DICT_TYPE] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_DICT_TYPE] ADD CONSTRAINT [PK__sys_dict__41F99A5240DB9678] PRIMARY KEY CLUSTERED ([TYPE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'TYPE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'父ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'PARENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'类别名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'TYPE_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'类别描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'TYPE_DESCRIPTION'

EXEC sp_addextendedproperty
'MS_Description', N'编辑类型(系统sys/业务biz)',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'RANGE_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'SORT'

EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段1',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'BAK_1'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段2',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'BAK_2'

EXEC sp_addextendedproperty
'MS_Description', N'备用字段3',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE',
'COLUMN', N'BAK_3'

EXEC sp_addextendedproperty
'MS_Description', N'字典类型表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_DICT_TYPE'
;


-- ----------------------------
-- Records of SYS_DICT_TYPE
-- ----------------------------
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (517670295990181889, 1450384438474231809, N'openType', N'页面打开方式', N'biz', 45, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (794925156320681984, 1450384438474231809, N'msg_contact_type', N'消息服务联系人类型', N'biz', 46, NULL, '2024-01-03 13:48:46', NULL, '2024-01-03 13:48:46', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (696315722368032768, 1450384438474231809, N'imp_exp_state', N'excel导入导出状态', N'sys', 43, NULL, '2023-04-06 11:10:05', NULL, '2023-04-06 11:10:05', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (673842175301394432, 1450384393200865282, N'encode_dup_pol', N'机构编码重复策略', N'sys', 2, 1450756958461300737, '2023-02-03 10:48:14', 1450756958461300737, '2023-02-03 10:48:14', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (676356930893258752, 1450384393200865282, N'import_type', N'导入类型', N'sys', 3, 1450756958461300737, '2023-02-10 09:20:58', 1450756958461300737, '2023-02-10 09:20:58', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (676356969782845440, 1450384393200865282, N'export_type', N'导出类型', N'sys', 4, 1450756958461300737, '2023-02-10 09:21:08', 1450756958461300737, '2023-02-10 09:21:08', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590082, 1450384393200865282, N'res_type', N'资源类型', N'sys', 30, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590083, 1450384393200865282, N'menu_type', N'菜单开发方式', N'sys', 35, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590084, 1450384393200865282, N'is_sys', N'系统管理员', N'sys', 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-09 08:51:54', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590085, 1450384393200865282, N'success_fail', N'成功失败', N'sys', 37, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590086, 1450384393200865282, N'user_role_review', N'用户角色审核状态', N'sys', 31, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590087, 1450384438474231809, N'common_opinion', N'常用意见', N'biz', 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590088, 1450384393200865282, N'data_scope_type', N'数据权限类型', N'sys', 38, NULL, '2021-03-04 14:22:18', NULL, '2021-03-04 14:22:25', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590089, 1450384393200865282, N'type', N'欢迎页配置对象类型', N'sys', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590090, 1450384393200865282, N'account_property', N'账号属性', N'sys', 3, NULL, '2020-04-09 08:52:55', NULL, '2020-04-09 08:52:55', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590091, 1450384438474231809, N'security_level', N'数据密级', N'biz', 15, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590092, 1450384438474231809, N'user_security_level', N'用户密级', N'biz', 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590093, 1450384438474231809, N'staff_position', N'人员职务', N'biz', 14, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590094, 1450384393200865282, N'calendar_event_type', N'工作日历事件类型', N'sys', 36, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590095, 1450384438474231809, N'todo_type', N'待办类型', N'biz', 13, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590096, 1450384393200865282, N'levelEvent', N'系统/业务级事件', N'sys', 36, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590097, 1450384393200865282, N'account_state', N'账户状态', N'sys', 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-16 12:17:51', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590098, 1450384393200865282, N'sex', N'性别', N'sys', 18, NULL, '2018-04-11 14:10:07', NULL, '2018-04-11 14:10:07', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (1450742089372590099, 1450384393200865282, N'yes_no', N'是/否', N'sys', 29, NULL, '2018-04-11 14:10:08', NULL, '2018-04-11 14:10:08', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (517670295990181888, 1450384438474231809, N'opinion_reject', N'常用驳回意见', N'biz', 2, 1450756958461300737, '2021-11-29 11:56:56', 1450756958461300737, '2021-11-29 11:56:56', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (523443198920761344, 1450384393200865282, N'res_strategy', N'页面类型', N'sys', 41, NULL, '2021-12-15 10:16:24', NULL, '2021-12-15 10:16:24', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (524165175805485056, 1450384438474231809, N'noticeType', N'公告类型', N'biz', 3, 1450756958461300737, '2021-12-17 10:05:16', 1450756958461300737, '2021-12-17 10:05:16', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (591913311474556928, 1450384438474231809, N'statistics_top', N'统计排名数量', N'biz', 4, 1450756958461300737, '2022-06-22 08:52:11', 1450756958461300737, '2022-06-22 08:52:11')
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (575022217952501760, 1450384438474231809, N'msg_send_status', N'消息发送状态', N'biz', 4, 1450756958461300737, '2022-05-06 18:13:00', 1450756958461300737, '2022-06-06 18:28:47', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (586233551075418112, 1450384438474231809, N'sms_channel_type', N'短信服务通道类型', N'biz', 5, 1450756958461300737, '2022-06-06 16:42:50', 1450756958461300737, '2022-06-06 16:42:50', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (586262390337970176, 1450384438474231809, N'msg_is_enable', N'消息通用是否启用', N'biz', 6, 1450756958461300737, '2022-06-06 18:37:26', 1450756958461300737, '2022-06-06 18:41:39', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (586658891807596544, 1450384438474231809, N'mail_protocol', N'邮箱协议', N'biz', 7, 1450756958461300737, '2022-06-07 20:52:59', 1450756958461300737, '2022-06-07 20:52:59', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (586659288706195456, 1450384438474231809, N'mail_safe_type', N'邮箱安全类型', N'biz', 8, 1450756958461300737, '2022-06-07 20:54:34', 1450756958461300737, '2022-06-07 20:54:34', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (587690275439386624, 1450384438474231809, N'app_action_type', N'消息推送动作类型', N'biz', 9, 1450756958461300737, '2022-06-10 17:11:20', 1450756958461300737, '2022-06-10 17:11:20', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (587955865517301760, 1450384438474231809, N'platform_type', N'接收平台', N'biz', 10, 1450756958461300737, '2022-06-11 10:46:42', 1450756958461300737, '2022-06-11 10:46:42', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (587956910612029440, 1450384438474231809, N'push_scope', N'推送范围', N'biz', 11, 1450756958461300737, '2022-06-11 10:50:51', 1450756958461300737, '2022-06-11 10:50:51', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (608963936091643904, 1450384438474231809, N'msg_service_type', N'消息服务发送类型', N'biz', 12, 1450756958461300737, '2022-08-08 10:05:16', 1450756958461300737, '2022-08-08 10:05:16', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (686886958856937472, 1450384438474231809, N'app_type', N'应用类型', N'biz', 17, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (714082718056718336, 1450384393200865282, N'res_expand_type', N'资源类型扩展属性类型', N'sys', 42, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (714082718056718337, 1450384393200865282, N'reset_period', N'重置周期', N'sys', 43, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (714082718056718338, 1450384393200865282, N'date_pattern', N'日期格式', N'sys', 44, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (736951385576448000, 1450384393200865282, N'assembly_type', N'组件类型', N'sys', 44, 1450756958461300737, '2023-07-27 14:21:42', 1450756958461300737, '2023-07-27 14:21:42', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (737025163346059264, 1450384438474231809, N'message_type', N'消息类型', N'biz', 45, 1450756958461300737, '2023-07-27 19:14:52', 1450756958461300737, '2023-07-27 19:14:52', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (811895803462557696, 1450384438474231809, N'yes_no_close', N'横幅是否能关闭', N'biz', 47, 1450756958461300737, '2024-02-19 09:44:04', 1450756958461300737, '2024-02-19 09:44:04', NULL, NULL, NULL)
;
INSERT INTO [SYS_DICT_TYPE] ([TYPE_ID], [PARENT_ID], [TYPE_NAME], [TYPE_DESCRIPTION], [RANGE_TYPE], [SORT], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [BAK_1], [BAK_2], [BAK_3]) VALUES (811895718649536512, 1450384438474231809, N'advertisementStatus', N'广告启用状态', N'biz', 46, 1450756958461300737, '2024-02-19 09:43:44', 1450756958461300737, '2024-02-19 09:43:44', NULL, NULL, NULL)
;



-- ----------------------------
-- Table structure for SYS_FILE_INFO
-- ----------------------------


CREATE TABLE [SYS_FILE_INFO] (
  [FILE_ID] NUMERIC(20)  NOT NULL,
  [ATTACHMENT_NAME] NVARCHAR(512) COLLATE Chinese_PRC_CS_AS  NULL,
  [ATTACHMENT_DIR] NVARCHAR(512) COLLATE Chinese_PRC_CS_AS  NULL,
  [ATTACHMENT_TYPE] NVARCHAR(256) COLLATE Chinese_PRC_CS_AS  NULL,
  [UPLOAD_PER] NUMERIC(20)  NULL,
  [UPLOAD_DATE] DATETIME  NULL,
  [BUSINESS_ID] NUMERIC(20)  NULL,
  [FILE_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CS_AS  NULL,
  [SEQ] decimal(8)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL
)
;

ALTER TABLE [SYS_FILE_INFO] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_FILE_INFO] ADD CONSTRAINT [FILE_INFO_PK] PRIMARY KEY CLUSTERED ([FILE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'FILE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'附件名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'ATTACHMENT_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'附件路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'ATTACHMENT_DIR'

EXEC sp_addextendedproperty
'MS_Description', N'附件类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'ATTACHMENT_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'上传人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'UPLOAD_PER'

EXEC sp_addextendedproperty
'MS_Description', N'上传时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'UPLOAD_DATE'

EXEC sp_addextendedproperty
'MS_Description', N'业务ID  ',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'BUSINESS_ID'

EXEC sp_addextendedproperty
'MS_Description', N'类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'FILE_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'排序字段',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'附件信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_INFO'
;


-- ----------------------------
-- Table structure for SYS_FILE_RELATION
-- ----------------------------


CREATE TABLE [SYS_FILE_RELATION] (
  [RELATION_ID] NUMERIC(20)  NOT NULL,
  [BUSINESS_ID] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [FILE_ID] NUMERIC(20)  NOT NULL,
  [ATTACHMENT_NAME] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [ATTACHMENT_TYPE] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [TYPE] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL
)
;

ALTER TABLE [SYS_FILE_RELATION] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_FILE_RELATION] ADD CONSTRAINT [PK__sys_file__4221CD184B53769F] PRIMARY KEY CLUSTERED ([RELATION_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'关联关系ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'RELATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'业务ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'BUSINESS_ID'

EXEC sp_addextendedproperty
'MS_Description', N'文件ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'FILE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'附件名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'ATTACHMENT_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'附件类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'ATTACHMENT_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'分类类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'排序字段',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后一次修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'附件关联关系表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FILE_RELATION'
;


-- ----------------------------
-- Table structure for SYS_FUNCTION_MODULES
-- ----------------------------


CREATE TABLE [SYS_FUNCTION_MODULES] (
  [FUNCTION_MODULE_ID] NUMERIC(20)  NOT NULL,
  [FUNCTION_MODULE_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [FUNCTION_MODULE_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_MODULE_ID] NUMERIC(20)  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [APPLICATION_ID] NUMERIC(20) DEFAULT 1 NULL
)
;

ALTER TABLE [SYS_FUNCTION_MODULES] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_FUNCTION_MODULES] ADD CONSTRAINT [PK__sys_func__C6E5B0EC37DBA1D8] PRIMARY KEY CLUSTERED ([FUNCTION_MODULE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'功能模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'FUNCTION_MODULE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'模块名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'FUNCTION_MODULE_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'模块编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'FUNCTION_MODULE_CODE'

EXEC sp_addextendedproperty
'MS_Description', N'上级模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'PARENT_MODULE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'模块排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'所属应用的id，默认1：属于统一权限平台自身数据',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES',
'COLUMN', N'APPLICATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能模块表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_MODULES'
;


-- ----------------------------
-- Records of SYS_FUNCTION_MODULES
-- ----------------------------
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686146937447260160, N'应用管理', NULL, 1, 14, 1450756958461300737, '2023-03-09 09:42:58', 1450756958461300737, '2023-03-09 09:42:58', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811595767054868480, N'联系人管理', NULL, 576395008970858496, 10, 1450756958461300737, '2024-02-18 13:51:50', 1450756958461300737, '2024-02-18 13:51:50', 1);
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('521403976781144064', N'统一待办', NULL, '1', '12', '1450756958461300737', '2021-12-09 19:13:15', '1450756958461300737', '2021-12-09 19:13:15', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523176320419766272', N'组织权限中心', NULL, '1', '1', '1450756958461300737', '2021-12-14 16:35:55', '1450756958461300737', '2022-10-21 09:21:14.4460000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523198001884438528', N'用户管理', NULL, '523176320419766272', '2', '1450756958461300737', '2021-12-14 18:02:04', '1450756958461300737', '2021-12-14 18:02:04', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523209654097158144', N'门户配置中心', NULL, '1', '3', '1450756958461300737', '2021-12-14 18:48:22', '1450756958461300737', '2022-10-20 14:44:38.7770000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523213269419433984', N'开发者中心', NULL, '1', '5', '1450756958461300737', '2021-12-14 19:02:44', '1450756958461300737', '2021-12-14 19:11:34', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523213321676267520', N'功能资源', NULL, '523176320419766272', '4', '1450756958461300737', '2021-12-14 19:02:57', '1450756958461300737', '2021-12-14 19:02:57', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523213802016350208', N'系统参数', NULL, '523213269419433984', '3', '1450756958461300737', '2021-12-14 19:04:51', '1450756958461300737', '2021-12-14 19:04:51', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523215032922939392', N'运维监控中心', NULL, '1', '6', '1450756958461300737', '2021-12-14 19:09:45', '1450756958461300737', '2021-12-14 19:11:34', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523215083967619072', N'运维工具', NULL, '523215032922939392', '1', '1450756958461300737', '2021-12-14 19:09:57', '1450756958461300737', '2022-10-25 10:10:14.3110000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523215114078527488', N'平台监控', NULL, '523215032922939392', '2', '1450756958461300737', '2021-12-14 19:10:04', '1450756958461300737', '2022-10-25 10:10:14.3570000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523215142994059264', N'平台日志', NULL, '523215032922939392', '3', '1450756958461300737', '2021-12-14 19:10:11', '1450756958461300737', '2021-12-14 19:10:11', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523217792733028352', N'缓存监控', NULL, '523215114078527488', '1', '1450756958461300737', '2021-12-14 19:20:43', '1450756958461300737', '2021-12-14 19:20:43', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('526077391123259392', N'公告', NULL, '1', '11', '1450756958461300737', '2021-12-22 16:43:44', '1450756958461300737', '2021-12-22 16:43:44', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('528155915363557376', N'统一待办', NULL, '523213269419433984', '4', NULL, '2021-12-28 10:23:03', NULL, '2021-12-28 10:23:03', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('545564987515740160', N'统一日志', NULL, '523215142994059264', '13', '1450756958461300737', '2022-07-01 11:20:41', '1450756958461300737', '2022-07-01 11:20:41', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576395008970858496', N'消息中心', NULL, '1', '13', '1450756958461300737', '2022-05-10 13:07:59', '1450756958461300737', '2022-10-20 09:35:41.3420000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576447319827030016', N'短信推送', NULL, '576395008970858496', '2', '1450756958461300737', '2022-05-10 16:35:51', '1450756958461300737', '2022-10-20 15:22:19.4800000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('577911145198002176', N'邮件推送', NULL, '576395008970858496', '3', '1450756958461300737', '2022-05-14 17:32:34', '1450756958461300737', '2022-10-20 15:22:19.7200000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('578225558232768512', N'微信公众号推送', NULL, '576395008970858496', '4', '1450756958461300737', '2022-05-15 14:21:56', '1450756958461300737', '2022-10-20 15:22:19.8200000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('579402387463348224', N'IM推送', NULL, '576395008970858496', '5', '1450756958461300737', '2022-05-18 20:18:14', '1450756958461300737', '2022-10-20 15:22:19.1130000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('579407339665498112', N'APP通知推送', NULL, '576395008970858496', '6', '1450756958461300737', '2022-05-18 20:37:55', '1450756958461300737', '2022-10-20 15:22:19.1300000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('587696011380793344', N'流程分析', NULL, '1450764807862095875', '1', '1450756958461300737', '2022-06-10 17:34:08', '1450756958461300737', '2022-06-10 17:34:08', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('592400770314543104', N'日志告警', NULL, '523215114078527488', '2', '1450756958461300737', '2022-06-23 09:09:10', '1450756958461300737', '2022-06-23 09:09:10', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('595572248216346624', N'移动门户配置', NULL, '523209654097158144', '1', '1450756958461300737', '2022-07-02 11:11:29', '1450756958461300737', '2022-07-02 11:11:29', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('596353922000756736', N'应用管理', NULL, '576395008970858496', '1', '1450756958461300737', '2022-07-04 14:57:35', '1450756958461300737', '2022-10-20 15:22:19.1500000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450764807862095873', N'个人事项', N'', '1', '9', NULL, NULL, '1450756958461300737', '2021-12-14 19:11:34', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450764807862095875', N'流程中心', N'', '1', '2', NULL, '2021-06-20 14:30:57', '1450756958461300737', '2022-10-20 14:44:38.8170000', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450764807862095884', N'角色管理', N'', '523176320419766272', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450764807862095885', N'组织机构', N'', '523176320419766272', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('587709613621911552', N'内部通知推送', N'', '576395008970858496', '6', 1450756958461300737, '2022-06-10 18:28:11', 1450756958461300737, '2022-06-10 18:28:11', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('641243779856343040', N'数据迁移', NULL, '523215032922939392', '4', '1450756958461300737', '2022-11-05 11:53:51', '1450756958461300737', '2022-11-05 11:53:51', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686176268227715072, N'企业微信推送', null, 576395008970858496, 8, 1450756958461300737, N'2023-03-09 11:39:31', 1450756958461300737, N'2023-03-09 11:39:31', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (697761878826557440,  N'钉钉推送',  null,  576395008970858496,  9,  1450756958461300737,  N'2023-04-10 10:56:36',  1450756958461300737,  N'2023-04-10 10:56:36', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738862247950163968, N'新闻资讯', NULL, 1, 15, 1450756958461300737, '2023-08-01 20:54:47', 1450756958461300737, '2023-08-01 20:54:47', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815518957997137920, N'分级管理', NULL, 1, 19, 1450756958461300737, '2024-02-29 09:41:11', 1450756958461300737, '2024-02-29 09:41:11', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299436459859968, N'角色管理', NULL, 1, 18, 1450756958461300737, '2024-02-28 19:08:53', 1450756958461300737, '2024-02-28 19:08:53', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299390616117248, N'用户管理', NULL, 1, 17, 1450756958461300737, '2024-02-28 19:08:42', 1450756958461300737, '2024-02-28 19:08:42', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299121857699840, N'人员管理', NULL, 815286440933203968, 2, 1450756958461300737, '2024-02-28 19:07:38', 1450756958461300737, '2024-02-28 19:07:38', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299096469577728, N'组织管理', NULL, 815286440933203968, 1, 1450756958461300737, '2024-02-28 19:07:32', 1450756958461300737, '2024-02-28 19:07:32', 1)
;
INSERT INTO [SYS_FUNCTION_MODULES] ([FUNCTION_MODULE_ID], [FUNCTION_MODULE_NAME], [FUNCTION_MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815286440933203968, N'组织机构', NULL, 1, 16, 1450756958461300737, '2024-02-28 18:17:15', 1450756958461300737, '2024-02-28 18:17:15', 1)
;
-- ----------------------------
-- Table structure for SYS_FUNCTION_RESOURCES
-- ----------------------------


CREATE TABLE [SYS_FUNCTION_RESOURCES] (
  [SFR_ID] NUMERIC(20)  NOT NULL,
  [FUNCTION_ID] NUMERIC(20)  NULL,
  [RESOURCE_ID] NUMERIC(20)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
)
;

ALTER TABLE [SYS_FUNCTION_RESOURCES] SET (LOCK_ESCALATION = TABLE)
;
-- ----------------------------
-- Primary Key structure for table SYS_FUNCTION_RESOURCES
-- ----------------------------
ALTER TABLE [SYS_FUNCTION_RESOURCES] ADD CONSTRAINT [PK__SYS_FUNCTION_RESOURCES__SFR_ID] PRIMARY KEY CLUSTERED ([SFR_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'SFR_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'FUNCTION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'资源id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'RESOURCE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'功能资源关系表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTION_RESOURCES'
;


-- ----------------------------
-- Records of SYS_FUNCTION_RESOURCES
-- ----------------------------
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (833743802140467200, 688350053471100928, 829409027523092480, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (833743802165633024, 688350053471100928, 829409275322572800, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (833743802182410242, 688350053471100928, 829409533184188416, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (833743802207576065, 688350053471100928, 829409805990109184, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417729, 811595871216214016, 830797745085489152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417728, 811595871216214016, 830771482190946304, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207357612032, 811595871216214016, 830797989605023744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (813348971945926656, 813348971400667136, 813348818371485696, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26');
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811595871555952640, 811595871216214016, 811594293004476416, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14');
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (32237820183288250, 518460834717114368, 518451664789970944, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1722420405944111400, 521404105277841408, 521403853758013440, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3456659651549261300, 522705551881412608, 522705027572441088, 1450756958461300737, '2021-12-14 14:57:33', 1450756958461300737, '2021-12-14 14:57:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4034857885755173400, 523555260388876288, 523554762252361728, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6056936221124455000, 523555376986333184, 523555173533229056, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2675691861322455000, 1450764807862095892, 1450765592889004053, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8863128065406379000, 1450764807862095892, 1450765592889004073, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6126027114815556000, 1450764807862095892, 1450765592889004124, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7416473689547601000, 1450764807862095892, 1450765592889004134, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8439927452148045000, 1450764807862095892, 1450765592889004153, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6350019966416328000, 1450764807862095892, 1450765592889004161, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4380869385156113000, 1450764807862095892, 1450765592889004180, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2350991115796637000, 1450764807862095892, 1450765592889004198, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8012986635398130000, 1450764807862095892, 1450765592889004199, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1024815990010686600, 1450764807862095892, 1450765592889004208, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8947485567372642000, 1450764807862095892, 1450765592889004223, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104081375053000, 1450764807862095892, 1450765592889004265, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (575357532137176200, 1450764807862095892, 1450765592889004295, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3418857910558641700, 1450764807862095892, 1450765592889004342, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4576799101076076000, 1450764807862095892, 1450765592889004363, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6812247779918563000, 1450764807862095892, 1450765592889004394, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3863961531827612700, 1450764807862095892, 1450765592889004502, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5119290133561532000, 1450764807862095892, 1450765592889004508, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4308021991970837500, 1450764807862095892, 1450765592889004521, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6717269891976873000, 1450764807862095892, 1450765592889004539, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4835048994508317000, 1450764807862095892, 1450765592889004564, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4079944889739185700, 1450764807862095893, 1450765592889004145, NULL, '2021-06-23 06:14:22', NULL, '2021-06-23 06:14:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2001752727345160200, 1450764807862095895, 1450765592889004088, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2763711700881510000, 1450764807862095895, 1450765592889004115, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4730137761740278000, 1450764807862095895, 1450765592889004182, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1611428150808649200, 1450764807862095895, 1450765592889004258, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7074915702170057000, 1450764807862095895, 1450765592889004403, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5134544632455492000, 1450764807862095895, 1450765592889004470, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4979109948089132000, 1450764807862095895, 1450765592889004479, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3547068516515780600, 1450764807862095895, 1450765592889004482, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3337785656271825000, 1450764807862095895, 1450765592889004545, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6705684025738846000, 1450764807862095898, 1450765592889004351, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4200131811592521700, 1450764807862095898, 1450765592889004457, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6666537997161930000, 1450764807862095898, 1450765592889004570, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (661080598474130600, 1450764807862095900, 1450765592889004354, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6664171536439597000, 1450764807862095900, 1450765592889004413, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6404336320549082000, 1450764807862095900, 1450765592889004449, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3978095210430011400, 1450764807862095901, 1450765592889004039, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7895079182739348000, 1450764807862095901, 1450765592889004052, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6858095515455579000, 1450764807862095901, 1450765592889004098, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (759512770441751700, 1450764807862095901, 1450765592889004101, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3919369046349748000, 1450764807862095901, 1450765592889004147, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4687047599491193000, 1450764807862095901, 1450765592889004156, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1816566663599248600, 1450764807862095901, 1450765592889004214, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2053750865712595000, 1450764807862095901, 1450765592889004218, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8178708544219443000, 1450764807862095901, 1450765592889004220, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8638460920863153000, 1450764807862095901, 1450765592889004230, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3572596697533797000, 1450764807862095901, 1450765592889004247, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1535231780077067500, 1450764807862095901, 1450765592889004252, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6403442468784465000, 1450764807862095901, 1450765592889004278, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2277101967303453700, 1450764807862095901, 1450765592889004292, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8067857347671430000, 1450764807862095901, 1450765592889004307, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8918716561201663000, 1450764807862095901, 1450765592889004308, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (925046692895840500, 1450764807862095901, 1450765592889004309, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4848715528255667000, 1450764807862095901, 1450765592889004329, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6851168973091814000, 1450764807862095901, 1450765592889004337, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7559436617647481000, 1450764807862095901, 1450765592889004344, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6452163899984276000, 1450764807862095901, 1450765592889004349, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6611140817864900000, 1450764807862095901, 1450765592889004369, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (236330564504039000, 1450764807862095901, 1450765592889004397, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (318047442350762900, 1450764807862095901, 1450765592889004404, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8770056328260917000, 1450764807862095901, 1450765592889004410, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1892684453589602300, 1450764807862095901, 1450765592889004460, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (272000448824307070, 1450764807862095901, 1450765592889004465, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5200507840943897000, 1450764807862095901, 1450765592889004473, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1935980527337025300, 1450764807862095901, 1450765592889004485, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5780367496094840000, 1450764807862095901, 1450765592889004488, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7848878822335752000, 1450764807862095901, 1450765592889004529, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1508557304661880000, 1450764807862095901, 1450765592889004544, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4258920424145072600, 1450764807862095901, 1450765592889004565, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1641743113031370800, 1450764807862095901, 1450765592889004567, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3546198106165265400, 1450764807862095901, 1450765592889004572, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4661488089173200000, 1450764807862095902, 1450765592889004075, NULL, '2021-06-23 05:39:59', NULL, '2021-06-23 05:39:59')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2551110856072753000, 1450764807862095902, 1450765592889004332, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5983524870074011000, 1450764807862095902, 1450765592889004378, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1598059929234802000, 1450764807862095902, 1450765592889004434, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2261349797125141500, 1450764807862095902, 1450765592889004469, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1510738435591924000, 1450764807862095902, 1450765592889004526, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8737063662919945000, 1450764807862095902, 1450765592889004546, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7899135802588070000, 1450764807862095904, 1450765592889004453, NULL, '2021-06-23 06:14:10', NULL, '2021-06-23 06:14:10')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7913802952827491000, 1450764807862095905, 1450765592889004221, NULL, '2021-06-23 06:12:26', NULL, '2021-06-23 06:12:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (508885334026323100, 1450764807862095908, 1450765592889004059, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (163060532147892830, 1450764807862095908, 1450765592889004060, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (294649254804114900, 1450764807862095908, 1450765592889004069, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2254196369901174000, 1450764807862095908, 1450765592889004082, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7728658222107044000, 1450764807862095908, 1450765592889004121, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (494169743728983600, 1450764807862095908, 1450765592889004152, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2849541863202725000, 1450764807862095908, 1450765592889004160, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5124600442603036000, 1450764807862095908, 1450765592889004186, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8121326732469579000, 1450764807862095908, 1450765592889004222, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3882497652435606500, 1450764807862095908, 1450765592889004261, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3997485965338456600, 1450764807862095908, 1450765592889004283, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2247825399754617000, 1450764807862095908, 1450765592889004305, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4599933527961134600, 1450764807862095908, 1450765592889004348, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8414710152159558000, 1450764807862095908, 1450765592889004400, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8094061504457990000, 1450764807862095908, 1450765592889004409, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3394135695792329000, 1450764807862095908, 1450765592889004411, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1212672447438331000, 1450764807862095908, 1450765592889004440, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8560989646778335000, 1450764807862095908, 1450765592889004533, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5775284664514161000, 1450764807862095908, 1450765592889004571, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1760159323208247800, 1450764807862095909, 1450765592889004045, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6997203452672896000, 1450764807862095909, 1450765592889004062, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7256505380841301000, 1450764807862095909, 1450765592889004064, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4355312469684564000, 1450764807862095909, 1450765592889004080, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1794950929770545200, 1450764807862095909, 1450765592889004143, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7358975816373811000, 1450764807862095909, 1450765592889004144, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7385579669169596000, 1450764807862095909, 1450765592889004149, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4375738080934397000, 1450764807862095909, 1450765592889004171, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6133790374255563000, 1450764807862095909, 1450765592889004183, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7796016520957238000, 1450764807862095909, 1450765592889004189, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8362261482291111000, 1450764807862095909, 1450765592889004204, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7886632004074359000, 1450764807862095909, 1450765592889004206, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1971658812158312200, 1450764807862095909, 1450765592889004211, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1983410821071978500, 1450764807862095909, 1450765592889004237, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5279185567531117000, 1450764807862095909, 1450765592889004269, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6596951099630954000, 1450764807862095909, 1450765592889004281, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815322049257875000, 1450764807862095909, 1450765592889004311, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2910762183986358000, 1450764807862095909, 1450765592889004330, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4880598817213345000, 1450764807862095909, 1450765592889004333, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (466427385931388540, 1450764807862095909, 1450765592889004364, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7182817657769566000, 1450764807862095909, 1450765592889004368, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7389982661807500000, 1450764807862095909, 1450765592889004391, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7394145152272608000, 1450764807862095909, 1450765592889004417, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4488231002449490400, 1450764807862095909, 1450765592889004422, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5579798555817354000, 1450764807862095909, 1450765592889004432, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (778696738678466700, 1450764807862095909, 1450765592889004433, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3780467269874520600, 1450764807862095909, 1450765592889004443, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (214974206552515740, 1450764807862095909, 1450765592889004452, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5074963679667732000, 1450764807862095909, 1450765592889004472, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8118170614398197000, 1450764807862095909, 1450765592889004501, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2108797039676104200, 1450764807862095909, 1450765592889004503, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6500307152796450000, 1450764807862095909, 1450765592889004512, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6213297702754915000, 1450764807862095909, 1450765592889004516, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7649029061287673000, 1450764807862095909, 1450765592889004536, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1609518816656995000, 1450764807862095909, 1450765592889004555, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (120507322691962850, 1450764807862095909, 1450765592889004566, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (893715496294441100, 1450764807862095910, 1450765592889004239, NULL, '2021-06-23 05:47:40', NULL, '2021-06-23 05:47:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8508944291857246000, 1450764807862095911, 1450765592889004137, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8506041280497158000, 1450764807862095911, 1450765592889004407, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4542974900865503000, 1450764807862095913, 1450765592889004178, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (300339249092257150, 1450764807862095913, 1450765592889004187, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5537901247811356000, 1450764807862095913, 1450765592889004207, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6293763916192614000, 1450764807862095913, 1450765592889004212, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4563519735709766700, 1450764807862095913, 1450765592889004277, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3070615836658059300, 1450764807862095913, 1450765592889004286, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7938159816852189000, 1450764807862095913, 1450765592889004291, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5378786281442386000, 1450764807862095913, 1450765592889004310, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3716421673354175500, 1450764807862095913, 1450765592889004382, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7877986980722596000, 1450764807862095913, 1450765592889004384, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5203434114666971000, 1450764807862095913, 1450765592889004421, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5083358887821602000, 1450764807862095913, 1450765592889004530, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8685902543222044000, 1450764807862095913, 1450765592889004563, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6580298633325908000, 1450764807862095915, 1450765592889004141, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8497553308423673000, 1450764807862095915, 1450765592889004390, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7230387419835086000, 1450764807862095915, 1450765592889004486, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7141152941257222000, 1450764807862095915, 1450765592889004569, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1179074570130030800, 1450764807862095917, 1450765592889004274, NULL, '2021-08-31 16:20:43', NULL, '2021-08-31 16:20:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (690446705260763500, 1450764807862095919, 1450765592889004065, NULL, '2021-09-26 11:12:43', NULL, '2021-09-26 11:12:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3670961758260140000, 1450764807862095920, 1450765592889004293, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4470818163916753400, 1450764807862095920, 1450765592889004513, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4173951114598774000, 1450764807862095921, 1450765592889004047, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4002368119826934300, 1450764807862095921, 1450765592889004087, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6922950729674101000, 1450764807862095921, 1450765592889004120, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4033234240426174000, 1450764807862095921, 1450765592889004138, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3789118980178759700, 1450764807862095921, 1450765592889004257, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2875241465125512000, 1450764807862095921, 1450765592889004297, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6686584550031459000, 1450764807862095921, 1450765592889004313, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6479487786698256000, 1450764807862095921, 1450765592889004322, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3271590496898312700, 1450764807862095921, 1450765592889004357, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8785198093272620000, 1450764807862095921, 1450765592889004358, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5753118426347250000, 1450764807862095921, 1450765592889004395, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5539196970889990000, 1450764807862095921, 1450765592889004437, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (642422504664865500, 1450764807862095921, 1450765592889004487, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7259306706210482000, 1450764807862095922, 1450765592889004167, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5315053896876473000, 1450764807862095922, 1450765592889004270, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8954866636099882000, 1450764807862095922, 1450765592889004284, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8899633434905354000, 1450764807862095922, 1450765592889004383, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2639040774009679000, 1450764807862095922, 1450765592889004499, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8165649929085861000, 1450764807862095923, 1450765592889004037, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3471488454024111000, 1450764807862095923, 1450765592889004168, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3342881980036192000, 1450764807862095923, 1450765592889004179, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1330650432024310800, 1450764807862095923, 1450765592889004213, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1326980394770590500, 1450764807862095923, 1450765592889004338, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7888362631300701000, 1450764807862095923, 1450765592889004366, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4035590223857203700, 1450764807862095923, 1450765592889004401, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (299149563277391300, 1450764807862095923, 1450765592889004406, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1855419488169778700, 1450764807862095923, 1450765592889004477, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5932931091979795000, 1450764807862095923, 1450765592889004481, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8434139141342351000, 1450764807862095924, 1450765592889004226, NULL, '2021-06-23 06:40:15', NULL, '2021-06-23 06:40:15')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (297800635119875200, 1450764807862095925, 1450765592889004146, NULL, '2021-06-23 06:12:11', NULL, '2021-06-23 06:12:11')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1623971115387953400, 1450764807862095927, 1450765592889004150, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2926712170783723500, 1450764807862095927, 1450765592889004201, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (621819116948449000, 1450764807862095927, 1450765592889004414, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7395345460225237000, 1450764807862095927, 1450765592889004456, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5386981152578304000, 1450764807862095927, 1450765592889004558, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6667030653375144000, 1450764807862095928, 1450765592889004119, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1665473748921275000, 1450764807862095928, 1450765592889004507, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4994826914933570000, 1450764807862095929, 1450765592889004067, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7295346128432285000, 1450764807862095929, 1450765592889004159, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6444057545505071000, 1450764807862095929, 1450765592889004235, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3027745323871259000, 1450764807862095929, 1450765592889004285, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3742774354435161600, 1450764807862095929, 1450765592889004461, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4327413024116248000, 1450764807862095929, 1450765592889004515, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4511432183335675400, 1450764807862095929, 1450765592889004522, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1702621000111275000, 1450764807862095930, 1450765592889004169, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3323187159654631400, 1450764807862095930, 1450765592889004454, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7842911870199263000, 1450764807862095931, 1450765592889004089, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3818813244593985500, 1450764807862095931, 1450765592889004118, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7545485682063677000, 1450764807862095931, 1450765592889004122, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2055963100124195000, 1450764807862095931, 1450765592889004148, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3004160705449305600, 1450764807862095931, 1450765592889004181, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1183947773569380600, 1450764807862095931, 1450765592889004193, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6165537920642976000, 1450764807862095931, 1450765592889004288, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7228419466900020000, 1450764807862095931, 1450765592889004302, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1897763020833517800, 1450764807862095931, 1450765592889004427, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1936536466301772800, 1450764807862095931, 1450765592889004510, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (610834561866679300, 1450764807862095933, 1450765592889004356, NULL, '2021-06-23 06:40:33', NULL, '2021-06-23 06:40:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8159978062320227000, 1450764807862095934, 1450765592889004074, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8710185231025143000, 1450764807862095934, 1450765592889004176, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1422356362072164600, 1450764807862095934, 1450765592889004200, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2581174052246643700, 1450764807862095934, 1450765592889004347, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6633164977338520000, 1450764807862095934, 1450765592889004445, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2405765205128211500, 1450764807862095934, 1450765592889004493, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3431550087968561000, 1450764807862095934, 1450765592889004509, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6770589361246581000, 1450764807862095935, 1450765592889004240, NULL, '2021-06-23 06:13:57', NULL, '2021-06-23 06:13:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3555724846944758300, 1450764807862095936, 1450765592889004061, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4179567030624378000, 1450764807862095936, 1450765592889004066, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1892238538100658700, 1450764807862095936, 1450765592889004105, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3059897388336372700, 1450764807862095936, 1450765592889004151, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3430456294464035300, 1450764807862095936, 1450765592889004224, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4151834519846344000, 1450764807862095936, 1450765592889004325, NULL, '2021-06-23 06:04:20', NULL, '2021-06-23 06:04:20')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8587248683938692000, 1450764807862095936, 1450765592889004327, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2171968905502825500, 1450764807862095936, 1450765592889004371, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2079261246918037200, 1450764807862095936, 1450765592889004462, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4188983321143105500, 1450764807862095936, 1450765592889004466, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2203063968551473700, 1450764807862095936, 1450765592889004556, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1146973097038787500, 1450764807862095937, 1450765592889004085, NULL, '2021-06-23 06:39:32', NULL, '2021-06-23 06:39:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1984480780663197200, 1450764807862095938, 1450765592889004119, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1534132577012168200, 1450764807862095938, 1450765592889004517, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3415638094144259000, 1450764807862095939, 1450765592889004112, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8664349155821196000, 1450764807862095939, 1450765592889004173, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8704223561487048000, 1450764807862095939, 1450765592889004444, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8315259855418958000, 1450764807862095939, 1450765592889004519, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6315047255856710000, 1450764807862095940, 1450765592889004119, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4532507165374261000, 1450764807862095940, 1450765592889004334, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4316568325108646000, 1450764807862095941, 1450765592889004268, NULL, '2021-06-23 06:39:19', NULL, '2021-06-23 06:39:19')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8681688362520987000, 1450764807862095942, 1450765592889004088, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4228502463736115000, 1450764807862095942, 1450765592889004115, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8218994812766171000, 1450764807862095942, 1450765592889004182, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7624259898376632000, 1450764807862095942, 1450765592889004258, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8504726317095393000, 1450764807862095942, 1450765592889004403, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5602501897192188000, 1450764807862095942, 1450765592889004470, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2136423814104587500, 1450764807862095942, 1450765592889004482, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8533345324068517000, 1450764807862095942, 1450765592889004545, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3589446535123804000, 1450764807862095943, 1450765592889004474, NULL, '2021-06-23 06:39:44', NULL, '2021-06-23 06:39:44')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (297370733459590800, 1450764807862095944, 1450765592889004175, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2049273485948358000, 1450764807862095944, 1450765592889004495, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4485649434350541000, 1450764807862095945, 1450765592889004042, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5437011344041815000, 1450764807862095945, 1450765592889004091, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2810431123129526000, 1450764807862095945, 1450765592889004131, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6484570126183945000, 1450764807862095945, 1450765592889004157, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7067840957476540000, 1450764807862095945, 1450765592889004253, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2143435087777804300, 1450764807862095945, 1450765592889004263, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8108511052112232000, 1450764807862095945, 1450765592889004551, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (539874850424709500, 1450764807862095946, 1450765592889004092, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6058313304120828000, 1450764807862095946, 1450765592889004099, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4334206056907582500, 1450764807862095946, 1450765592889004136, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3452467247224488400, 1450764807862095946, 1450765592889004188, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2790413979090824000, 1450764807862095946, 1450765592889004190, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7492967573262157000, 1450764807862095946, 1450765592889004251, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4885699579821889000, 1450764807862095946, 1450765592889004259, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6159300264044104000, 1450764807862095946, 1450765592889004317, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7626314151277643000, 1450764807862095946, 1450765592889004323, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5630037020813018000, 1450764807862095946, 1450765592889004339, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7193923514192867000, 1450764807862095946, 1450765592889004559, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6186062082179167000, 1450764807862095947, 1450765592889004229, NULL, '2021-06-23 06:13:45', NULL, '2021-06-23 06:13:45')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3587792538161952000, 1450764807862095949, 1450765592889004114, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2639106464661535000, 1450764807862095949, 1450765592889004416, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1541761665124456700, 526356620901621760, 526356511056994304, 1450756958461300737, '2021-12-23 11:13:18', 1450756958461300737, '2021-12-23 11:13:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4746012102747882000, 526077556152344576, 526077294431969280, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5836318420422332000, 535768729024471040, 535768620278751232, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7283185533511604000, 526077556152344576, 1450765592889004432, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (919415598507028000, 526077556152344576, 1450765592889004265, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3809106649826042000, 544469147921424384, 544468972511436800, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5775995092350120000, 576438008606367744, 576437892923269120, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7800586799341336000, 576448277533433856, 576425225089196032, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6254306082990807000, 581430666475085824, 564389067157151744, NULL, '2022-05-24 11:01:57', NULL, '2022-05-24 11:01:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2613100450870835000, 581436854533103616, 581431768348106752, NULL, '2022-05-24 11:02:29', NULL, '2022-05-24 11:02:29')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5687797329544180000, 581436941229367296, 581432525403201536, NULL, '2022-05-24 11:02:49', NULL, '2022-05-24 11:02:49')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6130125695772322000, 581436993427480576, 581434143087534080, NULL, '2022-05-24 11:03:02', NULL, '2022-05-24 11:03:02')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8725110019329759000, 581437139125018624, 581434493471301632, NULL, '2022-05-24 11:03:37', NULL, '2022-05-24 11:03:37')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (623711529299158700, 581437221161410560, 581434937987833856, NULL, '2022-05-24 11:03:56', NULL, '2022-05-24 11:03:56')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2873446997914837000, 581437297606795264, 581435215210356736, NULL, '2022-05-24 11:04:14', NULL, '2022-05-24 11:04:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3748595416472010000, 581437337255550976, 581435962006183936, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5467505651327609000, 581437382767943681, 581436516656750592, NULL, '2022-05-24 11:04:35', NULL, '2022-05-24 11:04:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5146478234549692000, 581437337255550977, 586205441340743680, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7056570863506333000, 592391757124345856, 592391481915088896, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8229125286955673000, 592386778267394048, 592385945366700032, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2193320752628304100, 545565036773646336, 545564853264457728, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4944954171612911000, 546343149988225024, 546343017720848384, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3202338602762828000, 546347915988443136, 546346988292284416, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3732572515607218700, 576447430137225216, 576444545517232128, 1450756958461300737, '2022-05-13 20:15:33', 1450756958461300737, '2022-05-13 20:15:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3505141127397854000, 576447488295444480, 576445297899872256, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8708869807021034000, 576447546457858048, 576445557296603136, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8313947228812567000, 576447608743272448, 576445740617048064, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4451344080343822000, 576447666205237248, 576445901988700160, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4159744505923209700, 576447721767182336, 576446061217062912, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5592373173119617000, 577911233693622272, 577910957540646912, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1465083453944791800, 577920176742473728, 577920052196810752, 1450756958461300737, '2022-05-15 11:13:59', 1450756958461300737, '2022-05-15 11:13:59')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3825440368558890500, 578179104113958912, 578178840069939200, 1450756958461300737, '2022-05-15 11:17:21', 1450756958461300737, '2022-05-15 11:17:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6855754700695544000, 578179213245554688, 577951344581943296, 1450756958461300737, '2022-05-15 11:34:45', 1450756958461300737, '2022-05-15 11:34:45')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5566067783870530000, 578179275791015936, 577951711264776192, 1450756958461300737, '2022-05-15 14:02:19', 1450756958461300737, '2022-05-15 14:02:19')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (246336600208762600, 578179328681189376, 577951935202861056, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:18:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2242213708910559500, 578180115675226112, 578180013862690816, 1450756958461300737, '2022-05-22 10:39:31', 1450756958461300737, '2022-05-22 10:39:31')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6312453972945452000, 578225632039936000, 578224814087741440, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (339192713332864260, 578225680442204160, 578225070686871552, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3488519505439757300, 578225755054678016, 578225260298772480, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2399846630984819700, 578225803503083520, 578225470362099712, 1450756958461300737, '2022-05-15 14:22:55', 1450756958461300737, '2022-05-15 14:22:55')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6103173003479497000, 579402490307682304, 579400593928626176, 1450756958461300737, '2022-05-18 20:18:39', 1450756958461300737, '2022-05-18 20:18:39')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5770502655654679000, 579402568669863936, 579401699782041600, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5497885378355284000, 579402651498979328, 579402283595603968, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5903494431162094000, 579407434091864064, 579406581389860864, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3474746363408496000, 579407499330068480, 579406782007615488, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5495945351530107000, 579407703957577728, 579406956977201152, 1450756958461300737, '2022-05-18 20:39:22', 1450756958461300737, '2022-05-18 20:39:22')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8650379455151402000, 579407758378672128, 579407194467082240, 1450756958461300737, '2022-05-18 20:39:35', 1450756958461300737, '2022-05-18 20:39:35')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8788881801441584000, 579987015375003648, 579986784054943744, 1450756958461300737, '2022-05-20 11:07:55', 1450756958461300737, '2022-05-20 11:07:55')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4257282040156218400, 582661445364490240, 582661309611646976, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5810380497366262000, 587709681099874304, 587708514152226816, 1450756958461300737, '2022-06-10 18:28:27', 1450756958461300737, '2022-06-10 18:28:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2031345137601169000, 596354099289792512, 596353576553684992, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (103839703909204940, 608974847288287232, 608974704010862592, 1450756958461300737, '2022-08-08 11:21:18', 1450756958461300737, '2022-08-08 11:21:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5653802213703863000, 587709734606610432, 587709219764183040, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8014902152519676000, 587709787979128832, 587709399175536640, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2845395767090039300, 588042975440019456, 588042819223166976, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1024720445140427000, 1450764807862095901, 638045114752835584, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (371741593868574400, 1450764807862095901, 638042415412027392, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7872406607107538000, 1450764807862095892, 1585912362983088129, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2492898248283624400, 1450764807862095892, 1585912363037614082, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1919847628360864300, 1450764807862095892, 1585912363037614083, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2466599334579421700, 1450764807862095892, 1585912363037614084, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5920334651818401000, 1450764807862095892, 1585912363037614085, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (721537806603650200, 1450764807862095892, 1585912363037614086, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2379462716057134000, 1450764807862095892, 1585912363104722945, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3875512243111428000, 1450764807862095892, 1585912363104722946, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6472680599435335000, 1450764807862095892, 1585912363104722947, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1815740593570076000, 1450764807862095892, 1585912363104722948, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8330541447586468000, 1450764807862095892, 1585912363104722949, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (491440583011017540, 1450764807862095892, 1585912363104722950, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1059776616727542100, 1450764807862095892, 1585912363104722951, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2030370999913044500, 1450764807862095892, 1585912363104722952, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2046939736589787000, 1450764807862095892, 1585912363104722953, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6029241791333300000, 1450764807862095892, 1585912363104722954, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3134161000793497000, 1450764807862095892, 1585912363104722955, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6978572709325975000, 1450764807862095892, 1585912363104722956, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6483501243502238000, 1450764807862095915, 1585912363104722957, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1761078680350173000, 1450764807862095915, 1585912363104722958, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6574268310044485000, 1450764807862095915, 1585912363104722959, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5208171966855981000, 1450764807862095915, 1585912363104722960, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7313600775117781000, 1450764807862095892, 1585912363104722961, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4349178580745831000, 1450764807862095909, 642061362138456064, NULL, '2022-11-07 18:02:38', NULL, '2022-11-07 18:02:38')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3417138352541431000, 1450764807862095892, 643045022819950592, 1450756958461300737, '2022-11-10 11:11:59', 1450756958461300737, '2022-11-10 11:11:59')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1127718932569314000, 1450764807862095892, 651120420518633472, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5893484724022913000, 1450764807862095909, 651116365914316800, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (841733583395585000, 1450764807862095909, 651119173271035904, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (138426341898569840, 1450764807862095909, 654426928039862272, 1450756958461300737, '2022-12-11 20:59:25', 1450756958461300737, '2022-12-11 20:59:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4915610029454931000, 1450764807862095931, 1592792289372065793, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3305574599699156500, 1450764807862095931, 1592792289447563266, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1602700320237974300, 1450764807862095931, 1592792289447563267, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4164526487273307000, 1450764807862095931, 1592792289447563268, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1953231193054883000, 1450764807862095931, 1592792289447563269, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3980414475721390600, 1450764807862095931, 1592792289447563270, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7362745921457370000, 1450764807862095931, 1592792289447563271, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2355149980597098000, 1450764807862095931, 1592792289447563272, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6733810371215246000, 1450764807862095931, 1592792289447563273, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3924859900707897000, 1450764807862095931, 1592792289447563274, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7276554236861184000, 1450764807862095931, 1592792289447563275, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1994563151592332300, 1450764807862095908, 1592792289514672130, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4413676370924454000, 1450764807862095908, 1592792289514672131, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1463283875112255000, 1450764807862095908, 1592792289514672132, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1586597950604691000, 1450764807862095908, 1592792289514672133, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4227335736397070000, 1450764807862095908, 1592792289514672134, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7627685903194215000, 1450764807862095908, 1592792289514672135, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1540487633956854800, 1450764807862095908, 1592792289514672136, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8752715398724330000, 1450764807862095908, 1592792289514672137, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6998904789688797000, 1450764807862095908, 1592792289514672138, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1766802248873239600, 1450764807862095908, 1592792289514672139, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7282220251011821000, 1450764807862095908, 1592792289514672140, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4877510692375325000, 1450764807862095908, 1592792289514672141, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8264447824536478000, 1450764807862095908, 1592792289514672142, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2903139567504489000, 1450764807862095908, 1592792289514672143, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4559897181492803000, 1450764807862095908, 1592792289514672144, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1059682632397965300, 1450764807862095930, 1594592180326998018, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (970684485714062500, 1450764807862095930, 1594592180406689793, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2469917820659567600, 1450764807862095930, 1594592180406689794, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2380387672070323700, 1450764807862095930, 1594592180406689795, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5327192801078872000, 1450764807862095908, 1594592180406689797, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1877268305086430700, 1450764807862095908, 1594592180469604356, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4154471216289108000, 641244024103247872, 641241760202498048, 1450756958461300737, '2022-11-05 14:02:42', 1450756958461300737, '2022-11-05 14:02:42')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (434508535904026400, 641243926136889344, 641241962678329344, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6639339325940522000, 641244024103247872, 657533259068219392, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7926049218286810000, 641244024103247872, 657533259068219393, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4429800302236255700, 641244024103247872, 657533259068219394, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3514213070613710000, 641244024103247872, 657533259068219395, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7380330702691458000, 641244024103247872, 657533259068219396, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7316928202275750000, 641244024103247872, 657533259068219397, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (2892294995399143400, 641243926136889344, 657533259068219398, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (908518490049388200, 641243926136889344, 657533259068219399, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1764871510999710700, 641243926136889344, 657533259068219400, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3896273664635517000, 641243926136889344, 657533259068219401, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7035271792170924000, 641243926136889344, 657533259068219402, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3018331592764750000, 641243926136889344, 657533259068219403, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5738884712946972000, 641243926136889344, 657533259068219404, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5936510110699688000, 641243926136889344, 657533259068219405, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4421242331761905000, 641243926136889344, 657533259068219406, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3597641265790758000, 641244024103247872, 657533259068219501, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (960313442635173100, 641244024103247872, 657533259068219502, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5614233490237816000, 641244024103247872, 657533259068219503, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3410009148122974700, 526077556152344576, 677910413299687424, 1450756958461300737, '2023-02-14 16:13:57', 1450756958461300737, '2023-02-14 16:13:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5410124374581111000, 526077556152344576, 677910643386621952, 1450756958461300737, '2023-02-14 16:14:52', 1450756958461300737, '2023-02-14 16:14:52')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1651541065029988400, 686178119287316480, 686174839412891648, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6404024009937585000, 686178183690854400, 686175350430113792, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7528114530474617000, 686178259356098560, 686175659781005312, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8982688618777375000, 686178312292409344, 686176030305820672, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4009278443153617000, 697762187867070464, 697759569409220608, 1450756958461300737, '2023-04-10 10:58:05', 1450756958461300737, '2023-04-10 10:58:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8534212407489383000, 697762370797445120, 697760877801381888, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3885274097593552000, 697762455014875136, 697761225484017664, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (724576808453237800, 697762540020834304, 697761494317932544, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3655814096027428400, 673553074966765568, 673551263069380608, 1450756958461300737, '2023-02-02 16:21:38', 1450756958461300737, '2023-02-02 16:21:38')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1093900356360513200, 688350053471100928, 688348921973710848, 1450756958461300737, '2023-03-15 14:05:19', 1450756958461300737, '2023-03-15 14:05:19')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3409225707786483700, 1450764807862095908, 665490432775692288, 1450756958461300737, '2023-05-08 11:38:45', 1450756958461300737, '2023-05-08 11:38:45')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1055495791568105300, 713719009941659648, 713718642843590656, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6343832864896635000, 714425029546483712, 714424558668750848, 1450756958461300737, '2023-05-26 11:01:14', 1450756958461300737, '2023-05-26 11:01:14')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (652571499685910000, 714488057633710080, 714487572214325248, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5022396851955762000, 714488196960100352, 714487820982689792, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7552550508999115000, 714498812294733824, 714498499575816192, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3892889728906122000, 714503247842516992, 714503076626833408, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1949550274764263400, 706807627035975680, 706807241717850112, 707960023090995203, '2023-05-05 10:01:10', 707960023090995203, '2023-05-05 10:01:10')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6194873429919035000, 738864188277137408, 738863796810162176, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5166634273131023000, 738864017908703232, 738863554568134656, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (422025399679930100, 738862450065285120, 738861909880872960, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (4081332833452350000, 738862378363658240, 738861725461520384, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (6519291138556986000, 734833871224578048, 734832488207360000, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7412606610797002000, 734833871224578048, 734833718094733312, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7827137275325588000, 735799387355357184, 735797215649603584, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1847283721174466000, 735799387355357184, 735798877248299008, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3781178502812923000, 738862378363658240, 737341598572224512, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (7475121451587770000, 738862378363658240, 738862163959226368, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087548157000, 1450764807862095892, 707290343955243008, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087548157001, 1450764807862095892, 707287408898778429, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087548157002, 1450764807862095892, 707288922094575616, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087548157003, 1450764807862095892, 707287408898744320, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856000, 1450764807862095908, 707291432628789248, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856001, 1450764807862095908, 707290869702897456, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856002, 1450764807862095908, 707291241079119872, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856003, 1450764807862095908, 707290869702860800, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856004, 1450764807862095913, 6069473931100219001, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856005, 1450764807862095913, 6069473931100219002, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856006, 1450764807862095913, 6069473931100219003, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856007, 1450764807862095913, 6069473931100219004, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856008, 1450764807862095892, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856009, 1450764807862095908, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (8735104087574856010, 1450764807862095913, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51')
;

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (5118955034316991000, 544475799542308864, 544475544734146560, 1450756958461300737, '2022-02-11 11:12:27', 1450756958461300737, '2022-02-11 11:12:27')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (3375109022411019000, 544475707963875328, 544474404047036416, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (821056732582387715, 815518987927691264, 758695419206443008, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (821056732582387716, 815518987927691264, 758695918920015872, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (821056732582387717, 815518987927691264, 815518821438988288, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781888, 815299697123270656, 1450765592889004348, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781889, 815299697123270656, 1450765592889004152, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781890, 815299697123270656, 1450765592889004059, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781891, 815299697123270656, 1450765592889004222, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781892, 815299697123270656, 1450765592889004411, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781893, 815299697123270656, 1450765592889004121, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781894, 815299697123270656, 1450765592889004261, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781895, 815299697123270656, 1450765592889004409, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781896, 815299697123270656, 1450765592889004082, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781897, 815299697123270656, 1450765592889004069, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781898, 815299697123270656, 1450765592889004440, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781899, 815299697123270656, 1450765592889004571, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781900, 815299697123270656, 1450765592889004305, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781901, 815299697123270656, 1450765592889004533, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781902, 815299697123270656, 1450765592889004400, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781903, 815299697123270656, 1450765592889004060, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781904, 815299697123270656, 1450765592889004283, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781905, 815299697123270656, 1450765592889004160, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781906, 815299697123270656, 556508576777248768, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781907, 815299697123270656, 631784753686913024, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781908, 815299697123270656, 1592792289514672130, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781909, 815299697123270656, 1592792289514672131, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781910, 815299697123270656, 1592792289514672132, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781911, 815299697123270656, 1592792289514672133, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781912, 815299697123270656, 1592792289514672134, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781913, 815299697123270656, 1592792289514672135, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781914, 815299697123270656, 1592792289514672136, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781915, 815299697123270656, 1592792289514672137, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781916, 815299697123270656, 1592792289514672138, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781917, 815299697123270656, 1592792289514672139, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781918, 815299697123270656, 1592792289514672140, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781919, 815299697123270656, 1592792289514672141, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781920, 815299697123270656, 1592792289514672142, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781921, 815299697123270656, 1592792289514672143, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781922, 815299697123270656, 1592792289514672144, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781923, 815299697123270656, 1594592180406689797, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781924, 815299697123270656, 1594592180469604356, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781925, 815299697123270656, 707291432628789248, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781926, 815299697123270656, 707290869702897456, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781927, 815299697123270656, 707291241079119872, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781928, 815299697123270656, 707290869702860800, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781929, 815299697123270656, 665490432775692288, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815599874895781930, 815299697123270656, 815298745012068352, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577536, 815299398463660032, 1450765592889004089, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577537, 815299398463660032, 1450765592889004302, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577538, 815299398463660032, 1450765592889004510, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577539, 815299398463660032, 1450765592889004118, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577540, 815299398463660032, 1450765592889004288, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577541, 815299398463660032, 1450765592889004427, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577542, 815299398463660032, 1450765592889004193, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577543, 815299398463660032, 1450765592889004122, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577544, 815299398463660032, 1450765592889004181, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577545, 815299398463660032, 1592792289372065793, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577546, 815299398463660032, 1592792289447563266, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577547, 815299398463660032, 1592792289447563267, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577548, 815299398463660032, 1592792289447563268, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577549, 815299398463660032, 1592792289447563269, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577550, 815299398463660032, 1592792289447563270, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577551, 815299398463660032, 1592792289447563271, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577552, 815299398463660032, 1592792289447563272, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577553, 815299398463660032, 1592792289447563273, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577554, 815299398463660032, 1592792289447563274, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577555, 815299398463660032, 1592792289447563275, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591330624577556, 815299398463660032, 815298988961177600, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615936, 815300362058866688, 710441229837672448, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615937, 815300362058866688, 1450765592889004053, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615938, 815300362058866688, 1450765592889004161, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615939, 815300362058866688, 1450765592889004508, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615940, 815300362058866688, 1450765592889004124, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615941, 815300362058866688, 1450765592889004363, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615942, 815300362058866688, 1450765592889004539, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615943, 815300362058866688, 1450765592889004342, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615944, 815300362058866688, 1450765592889004208, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615945, 815300362058866688, 1450765592889004394, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615946, 815300362058866688, 1450765592889004265, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615947, 815300362058866688, 1450765592889004180, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615948, 815300362058866688, 1450765592889004073, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615949, 815300362058866688, 1450765592889004564, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615950, 815300362058866688, 1450765592889004223, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615951, 815300362058866688, 1450765592889004153, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615952, 815300362058866688, 1450765592889004502, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615953, 815300362058866688, 1450765592889004295, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615954, 815300362058866688, 1450765592889004134, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615955, 815300362058866688, 1450765592889004199, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615956, 815300362058866688, 1450765592889004521, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615957, 815300362058866688, 1585912362983088129, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615958, 815300362058866688, 1585912363037614082, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615959, 815300362058866688, 1585912363037614083, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615960, 815300362058866688, 1585912363037614084, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615961, 815300362058866688, 1585912363037614085, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615962, 815300362058866688, 1585912363037614086, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615963, 815300362058866688, 1585912363104722945, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615964, 815300362058866688, 1585912363104722946, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615965, 815300362058866688, 1585912363104722947, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615966, 815300362058866688, 1585912363104722948, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615967, 815300362058866688, 1585912363104722949, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615968, 815300362058866688, 1585912363104722950, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615969, 815300362058866688, 1585912363104722951, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273896615970, 815300362058866688, 1585912363104722952, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976064, 815300362058866688, 1585912363104722953, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976065, 815300362058866688, 1585912363104722954, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976066, 815300362058866688, 1585912363104722955, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976067, 815300362058866688, 1585912363104722956, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976068, 815300362058866688, 1585912363104722961, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976069, 815300362058866688, 643045022819950592, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976070, 815300362058866688, 651120420518633472, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976071, 815300362058866688, 707290343955243008, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976072, 815300362058866688, 707287408898778429, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976073, 815300362058866688, 707288922094575616, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273925976074, 815300362058866688, 707287408898744320, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591273930170368, 815300362058866688, 815300265334022144, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347264, 815299769068167168, 1450765592889004080, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347265, 815299769068167168, 1450765592889004144, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347266, 815299769068167168, 1450765592889004171, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347267, 815299769068167168, 1450765592889004189, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347268, 815299769068167168, 1450765592889004237, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347269, 815299769068167168, 1450765592889004269, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347270, 815299769068167168, 1450765592889004281, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347271, 815299769068167168, 1450765592889004330, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347272, 815299769068167168, 1450765592889004333, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347273, 815299769068167168, 1450765592889004391, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347274, 815299769068167168, 1450765592889004433, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347275, 815299769068167168, 1450765592889004452, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347276, 815299769068167168, 1450765592889004472, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347277, 815299769068167168, 1450765592889004501, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347278, 815299769068167168, 1450765592889004516, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347279, 815299769068167168, 1450765592889004566, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347280, 815299769068167168, 1450765592889004206, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347281, 815299769068167168, 1450765592889004536, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347282, 815299769068167168, 1450765592889004311, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347283, 815299769068167168, 1450765592889004064, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347284, 815299769068167168, 1450765592889004204, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347285, 815299769068167168, 1450765592889004062, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347286, 815299769068167168, 1450765592889004211, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347287, 815299769068167168, 1450765592889004149, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347288, 815299769068167168, 1450765592889004555, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347289, 815299769068167168, 1450765592889004432, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347290, 815299769068167168, 1450765592889004512, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347291, 815299769068167168, 1450765592889004422, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347292, 815299769068167168, 1450765592889004143, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347293, 815299769068167168, 1450765592889004368, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347294, 815299769068167168, 1450765592889004443, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347295, 815299769068167168, 1450765592889004183, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347296, 815299769068167168, 1450765592889004364, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347297, 815299769068167168, 1450765592889004417, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347298, 815299769068167168, 1450765592889004503, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347299, 815299769068167168, 642061362138456064, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347300, 815299769068167168, 657533259068219502, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347301, 815299769068167168, 657533259068219503, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347302, 815299769068167168, 651116365914316800, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347303, 815299769068167168, 651119173271035904, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347304, 815299769068167168, 654426928039862272, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (815591227998347305, 815299769068167168, 815299064513175552, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (819883353754050560, 819883353598861312, 819882932406853632, 1450756958461300737, '2024-03-12 10:43:44', 1450756958461300737, '2024-03-12 10:43:44')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (819883304802328576, 819883304701665280, 819882466553896960, 1450756958461300737, '2024-03-12 10:43:33', 1450756958461300737, '2024-03-12 10:43:33')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (819883211244183552, 819883211101577216, 819882250383663104, 1450756958461300737, '2024-03-12 10:43:10', 1450756958461300737, '2024-03-12 10:43:10')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (819883155770318848, 819883155535437824, 819881531945525248, 1450756958461300737, '2024-03-12 10:42:57', 1450756958461300737, '2024-03-12 10:42:57')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (819883084001583104, 819883083649261568, 819881890768232448, 1450756958461300737, '2024-03-12 10:42:40', 1450756958461300737, '2024-03-12 10:42:40')
;
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885297775419392, 811885297653784576, 811884652779544576, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885297779613696, 811885297653784576, 811885051469111296, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885249972936704, 811885249842913280, 811884606541537280, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885249985519616, 811885249842913280, 811884952051523584, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885197766434816, 811885197636411392, 811884562585231360, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885197766434817, 811885197636411392, 811884852453580800, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885125355970560, 811885124697464832, 811884527244025856, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (811885125355970561, 811885124697464832, 811884745641435136, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417634, 815518987927691264, 831116364617097216, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417730, 1450764807862095909, 829416135417143296, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417731, 1450764807862095909, 829418436286488576, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417732, 1450764807862095909, 829418705640497152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417733, 1450764807862095909, 829419102467792896, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417734, 1450764807862095909, 829419565481205760, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417735, 1450764807862095931, 829406184619646976, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417736, 1450764807862095931, 829405596385288192, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417737, 1450764807862095892, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417738, 1450764807862095892, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417739, 1450764807862095892, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417740, 1450764807862095908, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417741, 1450764807862095908, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417742, 1450764807862095908, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417840, 815299769068167168, 829416135417143296, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417841, 815299769068167168, 829418436286488576, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417842, 815299769068167168, 829418705640497152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417843, 815299769068167168, 829419102467792896, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417844, 815299769068167168, 829419565481205760, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417845, 815299398463660032, 829406184619646976, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417846, 815299398463660032, 829405596385288192, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417847, 815300362058866688, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417848, 815300362058866688, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417849, 815300362058866688, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417850, 815299697123270656, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');

INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417851, 815299697123270656, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO [SYS_FUNCTION_RESOURCES] ([SFR_ID], [FUNCTION_ID], [RESOURCE_ID], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (830801207353417852, 815299697123270656, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
-- ----------------------------
-- Table structure for SYS_FUNCTIONS
-- ----------------------------


CREATE TABLE [SYS_FUNCTIONS] (
  [FUNCTION_ID] NUMERIC(20)  NOT NULL,
  [FUNCTION_CODE] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [FUNCTION_MODULE_ID] NUMERIC(20)  NULL,
  [FUNCTION_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [DEFAULT_RESOURCE_ID] NUMERIC(20)  NULL,
  [IS_SYS] NCHAR(1) COLLATE Chinese_PRC_CI_AS DEFAULT ('0')  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [APPLICATION_ID] NUMERIC(20) DEFAULT 1 NULL
)
;

ALTER TABLE [SYS_FUNCTIONS] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_FUNCTIONS] ADD CONSTRAINT [PK__sys_func__05CDE349A03F56E5] PRIMARY KEY CLUSTERED ([FUNCTION_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'FUNCTION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能编号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'FUNCTION_CODE'

EXEC sp_addextendedproperty
'MS_Description', N'功能模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'FUNCTION_MODULE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'FUNCTION_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'功能默认资源ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'DEFAULT_RESOURCE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'是否系统功能',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'IS_SYS'

EXEC sp_addextendedproperty
'MS_Description', N'功能序号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'所属应用的id，默认1：属于统一权限平台自身数据',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS',
'COLUMN', N'APPLICATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_FUNCTIONS'
;


-- ----------------------------
-- Records of SYS_FUNCTIONS
-- ----------------------------
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686147054220877824, N'0201', 686146937447260160, N'应用管理', 686146166286721024, N'1', 1, 1450756958461300737, '2023-03-09 09:43:26', 1450756958461300737, '2023-03-09 09:43:26', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686147191273955328, N'0202', 686146937447260160, N'应用回收站', 686146454410240000, N'1', 2, 1450756958461300737, '2023-03-09 09:43:58', 1450756958461300737, '2023-03-09 09:43:59', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (729285499054989312, N'0201', 686146937447260160, N'分组管理', 729285380519763968, N'1', 3, 1450756958461300737, '2023-07-06 10:40:13', 1450756958461300737, '2023-07-06 10:40:13', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (1450764807862095905, N'', 523215114078527488, N'连接池监控', 1450765592889004221, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (819883353598861312, N'000000000258', 697761878826557440, N'模板管理', 819882932406853632, N'0', 5, 1450756958461300737, '2024-03-12 10:43:44', 1450756958461300737, '2024-03-12 10:43:44', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (819883304701665280, N'000000000257', 686176268227715072, N'模板管理', 819882466553896960, N'0', 5, 1450756958461300737, '2024-03-12 10:43:33', 1450756958461300737, '2024-03-12 10:43:33', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (819883211101577216, N'000000000256', 587709613621911552, N'模板管理', 819882250383663104, N'0', 5, 1450756958461300737, '2024-03-12 10:43:10', 1450756958461300737, '2024-03-12 10:43:10', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (819883155535437824, N'000000000255', 579407339665498112, N'模板管理', 819881531945525248, N'0', 5, 1450756958461300737, '2024-03-12 10:42:57', 1450756958461300737, '2024-03-12 10:42:57', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (819883083649261568, N'000000000254', 579402387463348224, N'模板管理', 819881890768232448, N'0', 5, 1450756958461300737, '2024-03-12 10:42:40', 1450756958461300737, '2024-03-12 10:42:40', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (813348971400667136, N'000000000254', 811595767054868480, N'标签管理', 813348818371485696, N'0', 2, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811595871216214016, N'000000000254', 811595767054868480, N'通讯录', 811594293004476416, N'0', 1, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (518460834717114368, N'0205', 523215083967619072, N'客户端管理', 518451664789970944, N'1', 6, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-14 19:14:19')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095892, N'', 1450764807862095885, N'机构维护', 1450765592889004198, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095893, N'', 1450764807862095873, N'我的传阅', 1450765592889004145, N'1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:48')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095895, N'', 523217792733028352, N'性能监控', 1450765592889004388, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:36')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095898, N'', 523215142994059264, N'审计日志', 1450765592889004351, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095900, N'', 523215083967619072, N'解冻密码', 1450765592889004354, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095901, N'', 523213321676267520, N'资源管理', 1450765592889004220, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:05:43')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095902, N'', 1450764807862095885, N'类型定义', 1450765592889004075, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095904, N'', 1450764807862095873, N'我的催办', 1450765592889004453, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:38')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095908, N'', 523198001884438528, N'用户维护', 1450765592889004186, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:03:24')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095909, N'', 1450764807862095884, N'角色维护', 1450765592889004045, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:39')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095910, N'0225', 523213321676267520, N'功能管理', 1450765592889004239, N'1', 6, NULL, '2021-06-21 14:33:49', 1450756958461300737, '2021-06-21 14:33:49')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095911, N'', 523215083967619072, N'重置密码', 1450765592889004407, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095913, N'', 523215083967619072, N'字典管理', 1450765592889004187, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095915, N'', 1450764807862095885, N'机构审核', 1450765592889004141, N'1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095920, N'', 523215114078527488, N'慢SQL诊断', 1450765592889004293, N'1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095921, N'', 523209654097158144, N'菜单配置', 1450765592889004395, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095922, N'', 1450764807862095885, N'规则定义', 1450765592889004167, N'1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095923, N'', 523198001884438528, N'用户审核', 1450765592889004179, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:05:08')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095924, N'', 1450764807862095875, N'任务管理', 1450765592889004226, N'1', 4, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095925, N'', 523215114078527488, N'系统监控', 1450765592889004146, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095927, N'', 523215114078527488, N'在线用户', 1450765592889004414, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095928, N'', 523209654097158144, N'快捷功能配置', 1450765592889004507, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095929, N'', 523215142994059264, N'日志下载', 1450765592889004515, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095930, N'', 1450764807862095885, N'人员审核', 1450765592889004454, N'1', 6, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095931, N'', 1450764807862095885, N'人员管理', 1450765592889004148, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095933, N'', 1450764807862095875, N'函数管理', 1450765592889004356, N'1', 5, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095934, N'', 523213802016350208, N'自定义编码规则', 1450765592889004347, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095935, N'', 1450764807862095873, N'已办任务', 1450765592889004240, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:31')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095936, N'', 523215083967619072, N'工作日维护', 1450765592889004325, N'1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095937, N'', 1450764807862095875, N'流程管理', 1450765592889004085, N'1', 2, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095938, N'', 523209654097158144, N'框架页配置', 1450765592889004517, N'1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095939, N'', 1450764807862095884, N'用户角色审核', 1450765592889004112, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:55')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095940, N'', 523209654097158144, N'登录页配置', 1450765592889004334, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095941, N'', 1450764807862095873, N'我的委托', 1450765592889004268, N'1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:55')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095942, N'', 523217792733028352, N'内容监控', 1450765592889004479, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:51')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095943, N'', 1450764807862095875, N'实例管理', 1450765592889004474, N'1', 3, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095944, N'', 523215142994059264, N'在线历史记录', 1450765592889004495, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095945, N'', 523213802016350208, N'运行参数配置', 1450765592889004131, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095946, N'', 1450764807862095884, N'不相容角色集', 1450765592889004190, N'1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:46')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095947, N'', 1450764807862095873, N'待办任务', 1450765592889004229, N'1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:24')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (1450764807862095949, N'', 523213802016350208, N'授权信息', 1450765592889004114, N'1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (521404105277841408, N'0202', 528155915363557376, N'应用注册', 521403853758013440, N'1', 1, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (522705551881412608, N'0203', 521403976781144064, N'我的待办', 522705027572441088, N'1', 2, 1450756958461300737, '2021-12-13 09:25:15', 1450756958461300737, '2021-12-13 09:25:15')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (523555260388876288, N'0201', 521403976781144064, N'我的已办', 523554762252361728, N'1', 3, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (523555376986333184, N'0202', 521403976781144064, N'我的传阅', 523555173533229056, N'1', 4, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (526077556152344576, N'0205', 526077391123259392, N'我的公告', 526077294431969280, N'1', 1, 1450756958461300737, '2021-12-22 16:44:23', 1450756958461300737, '2021-12-22 16:44:23')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (535768729024471040, N'0205', 523215142994059264, N'审计查阅', 535768620278751232, N'1', 4, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (544469147921424384, N'0201', 523213269419433984, N'主题配置', 544468972511436800, N'1', 15, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576438008606367744, N'0205', 1450764807862095873, N'委托已办', 576437892923269120, N'1', 7, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576448277533433856, N'0206', 1450764807862095873, N'委托待办', 576425225089196032, N'1', 6, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581430666475085824, N'0209', 587696011380793344, N'流程概览', 564389067157151744, N'1', 1, 1450756958461300737, '2022-05-24 10:37:53', 1450756958461300737, '2022-05-24 11:01:57')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581436854533103616, N'0210', 587696011380793344, N'流程状态分析', 581431768348106752, N'1', 2, 1450756958461300737, '2022-05-24 11:02:29', 1450756958461300737, '2022-05-24 11:02:29')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581436941229367296, N'0211', 587696011380793344, N'流程参与者分析', 581432525403201536, N'1', 3, 1450756958461300737, '2022-05-24 11:02:49', 1450756958461300737, '2022-05-24 11:02:49')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581436993427480576, N'0212', 587696011380793344, N'流程统计分析', 581434143087534080, N'1', 4, 1450756958461300737, '2022-05-24 11:03:02', 1450756958461300737, '2022-05-24 11:03:02')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437139125018624, N'0213', 587696011380793344, N'热门流程分析', 581434493471301632, N'1', 5, 1450756958461300737, '2022-05-24 11:03:37', 1450756958461300737, '2022-05-24 11:03:37')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437221161410560, N'0214', 587696011380793344, N'流程数量分析', 581434937987833856, N'1', 6, 1450756958461300737, '2022-05-24 11:03:56', 1450756958461300737, '2022-05-24 11:03:56')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437297606795264, N'0215', 587696011380793344, N'用户流程分析', 581435215210356736, N'1', 7, 1450756958461300737, '2022-05-24 11:04:14', 1450756958461300737, '2022-05-24 11:04:14')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437337255550976, N'0216', 587696011380793344, N'待办任务分析', 581435962006183936, N'1', 8, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437337255550977, N'0217', 587696011380793344, N'流程驳回分析', 586205441340743680, N'1', 9, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (581437382767943681, N'0218', 587696011380793344, N'流程耗时分析', 581436516656750592, N'1', 10, 1450756958461300737, '2022-05-24 11:04:35', 1450756958461300737, '2022-05-24 11:04:35')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (545565036773646336, N'0201', 545564987515740160, N'统一日志', 545564853264457728, N'1', 1, 1450756958461300737, '2022-02-14 11:20:41', 1450756958461300737, '2022-02-14 11:20:41')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (546343149988225024, N'0201', 545564987515740160, N'链路追踪', 546343017720848384, N'1', 2, 1450756958461300737, '2022-02-16 14:52:38', 1450756958461300737, '2022-02-16 14:52:38')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (546347915988443136, N'0202', 545564987515740160, N'错误统计', 546346988292284416, N'1', 3, 1450756958461300737, '2022-02-16 15:11:34', 1450756958461300737, '2022-02-16 15:11:34')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (592386778267394048, N'0201', 592400770314543104, N'告警设置', 592385945366700032, N'1', 1, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (592391757124345856, N'0202', 592400770314543104, N'告警记录', 592391481915088896, N'1', 2, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (595572331049656320, N'0201', 595572248216346624, N'首页配置', 595571989650087936, N'1', 1, 1450756958461300737, '2022-07-02 11:11:49', 1450756958461300737, '2022-07-02 11:11:49')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (595572392424906752, N'0202', 595572248216346624, N'三方集成', 595572170466533376, N'1', 2, 1450756958461300737, '2022-07-02 11:12:04', 1450756958461300737, '2022-07-02 11:12:04')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447430137225216, N'0203', 576447319827030016, N'通道管理', 576444545517232128, N'0', 1, 1450756958461300737, '2022-05-10 16:36:17', 1450756958461300737, '2022-05-13 20:15:33')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447488295444480, N'0204', 576447319827030016, N'签名管理', 576445297899872256, N'0', 2, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447546457858048, N'0205', 576447319827030016, N'模板管理', 576445557296603136, N'0', 3, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447608743272448, N'0206', 576447319827030016, N'发送测试', 576445740617048064, N'0', 4, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447666205237248, N'0207', 576447319827030016, N'发送记录', 576445901988700160, N'0', 5, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (576447721767182336, N'0208', 576447319827030016, N'发送统计', 576446061217062912, N'0', 6, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (577911233693622272, N'0229', 577911145198002176, N'通道管理', 577910957540646912, N'0', 1, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (577920176742473728, N'0230', 577911145198002176, N'发送记录', 577920052196810752, N'0', 6, 1450756958461300737, '2022-05-14 18:08:27', 1450756958461300737, '2022-05-15 11:19:58')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578179104113958912, N'0231', 577911145198002176, N'模板管理', 578178840069939200, N'0', 2, 1450756958461300737, '2022-05-15 11:17:20', 1450756958461300737, '2022-05-15 11:19:41')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578179213245554688, N'0232', 577911145198002176, N'单发测试', 577951344581943296, N'0', 3, 1450756958461300737, '2022-05-15 11:17:46', 1450756958461300737, '2022-05-15 11:34:45')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578179275791015936, N'0233', 577911145198002176, N'群发测试', 577951711264776192, N'0', 4, 1450756958461300737, '2022-05-15 11:18:01', 1450756958461300737, '2022-05-15 14:02:18')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578179328681189376, N'0234', 577911145198002176, N'收件人管理', 577951935202861056, N'0', 5, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:19:58')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578180115675226112, N'0235', 577911145198002176, N'发送统计', 578180013862690816, N'0', 7, 1450756958461300737, '2022-05-15 11:21:22', 1450756958461300737, '2022-05-22 10:39:31')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578225632039936000, N'0236', 578225558232768512, N'通道管理', 578224814087741440, N'0', 1, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578225680442204160, N'0237', 578225558232768512, N'模板管理', 578225070686871552, N'0', 2, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578225755054678016, N'0238', 578225558232768512, N'发送测试', 578225260298772480, N'0', 3, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (578225803503083520, N'0239', 578225558232768512, N'发送记录', 578225470362099712, N'0', 4, 1450756958461300737, '2022-05-15 14:22:54', 1450756958461300737, '2022-05-15 14:22:54')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (582661445364490240, N'0248', 578225558232768512, N'发送统计', 582661309611646976, N'0', 5, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579402490307682304, N'0240', 579402387463348224, N'通道管理', 579400593928626176, N'0', 1, 1450756958461300737, '2022-05-18 20:18:38', 1450756958461300737, '2022-05-18 20:18:38')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579402568669863936, N'0241', 579402387463348224, N'发送测试', 579401699782041600, N'0', 2, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579402651498979328, N'0242', 579402387463348224, N'发送统计', 579402283595603968, N'0', 3, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579987015375003648, N'0247', 579402387463348224, N'发送记录', 579986784054943744, N'0', 4, 1450756958461300737, '2022-05-20 11:01:20', 1450756958461300737, '2022-05-20 11:07:55')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579407434091864064, N'0243', 579407339665498112, N'通道管理', 579406581389860864, N'0', 1, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579407499330068480, N'0244', 579407339665498112, N'发送测试', 579406782007615488, N'0', 2, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579407703957577728, N'0245', 579407339665498112, N'发送记录', 579406956977201152, N'0', 3, 1450756958461300737, '2022-05-18 20:39:21', 1450756958461300737, '2022-05-18 20:39:21')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (579407758378672128, N'0246', 579407339665498112, N'发送统计', 579407194467082240, N'0', 4, 1450756958461300737, '2022-05-18 20:39:34', 1450756958461300737, '2022-05-18 20:39:34')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (596354099289792512, N'0253', 596353922000756736, N'应用管理', 596353576553684992, N'0', 1, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (608974847288287232, N'0205', 596353922000756736, N'场景管理', 608974704010862592, N'0', 2, 1450756958461300737, '2022-08-08 10:48:38', 1450756958461300737, '2022-08-08 11:21:18')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (587709734606610432, N'0250', 587709613621911552, N'发送记录', 587709219764183040, N'0', 2, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (587709787979128832, N'0251', 587709613621911552, N'发送统计', 587709399175536640, N'0', 3, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (588042975440019456, N'0252', 587709613621911552, N'发送测试', 588042819223166976, N'0', 4, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (641243926136889344, N'0201', 641243779856343040, N'数据导入', 641241962678329344, N'1', 1, 1450756958461300737, '2022-11-05 11:54:26', 1450756958461300737, '2022-11-05 11:54:26')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (641244024103247872, N'0202', 641243779856343040, N'数据导出', 641241760202498048, N'1', 2, 1450756958461300737, '2022-11-05 11:54:49', 1450756958461300737, '2022-11-05 11:54:49')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (686178119287316480, N'0203', 686176268227715072, N'通道管理', 686174839412891648, N'0', 1, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (686178183690854400, N'0204', 686176268227715072, N'发送测试', 686175350430113792, N'0', 2, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (686178259356098560, N'0205', 686176268227715072, N'发送记录', 686175659781005312, N'0', 3, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (686178312292409344, N'0206', 686176268227715072, N'发送统计', 686176030305820672, N'0', 4, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (697762187867070464, N'0201', 697761878826557440, N'通道管理', 697759569409220608, N'0', 1, 1450756958461300737, '2023-04-10 10:57:49', 1450756958461300737, '2023-04-10 10:58:05')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (697762370797445120, N'0202', 697761878826557440, N'发送测试', 697760877801381888, N'0', 2, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (697762455014875136, N'0203', 697761878826557440, N'发送记录', 697761225484017664, N'0', 3, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (697762540020834304, N'0204', 697761878826557440, N'发送统计', 697761494317932544, N'0', 4, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (673553074966765568, N'0203', 1450764807862095875, N'工作流配置项管理', 673551263069380608, N'1', 6, 1450756958461300737, '2023-02-02 15:39:27', 1450756958461300737, '2023-02-02 16:21:38')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (688350053471100928, N'0203', 1450764807862095885, N'岗位管理', 688348921973710848, N'1', 7, 1450756958461300737, '2023-03-15 11:37:22', 1450756958461300737, '2023-03-15 14:05:19', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (713719009941659648, N'0201', 523213321676267520, N'资源类型维护', 713718642843590656, N'1', 1, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714425029546483712, N'0203', 1450764807862095885, N'岗位审核', 714424558668750848, N'1', 8, 1450756958461300737, '2023-05-26 10:30:00', 1450756958461300737, '2023-05-26 11:01:14', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714488057633710080, N'0204', 1450764807862095884, N'组织角色审核', 714487572214325248, N'1', 4, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714488196960100352, N'0205', 1450764807862095884, N'岗位角色审核', 714487820982689792, N'1', 5, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714498812294733824, N'0206', 523198001884438528, N'用户组织审核', 714498499575816192, N'1', 4, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714503247842516992, N'0207', 523198001884438528, N'用户岗位审核', 714503076626833408, N'1', 5, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738864188277137408, N'0204', 526077391123259392, N'消息更多', 738863796810162176, N'1', 2, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738864017908703232, N'0203', 526077391123259392, N'通知更多', 738863554568134656, N'1', 1, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738862450065285120, N'0202', 738862247950163968, N'新闻资讯列表', 738861909880872960, N'1', 2, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738862378363658240, N'0201', 738862247950163968, N'新闻资讯维护', 738861725461520384, N'1', 1, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18', 1)
;

INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (734833871224578048, N'0202', 523209654097158144, N'工作台banner', 734833718094733312, N'1', 6, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (735799387355357184, N'0203', 523209654097158144, N'组件库维护', 735798877248299008, N'1', 7, 1450756958461300737, '2023-07-24 10:04:04', 1450756958461300737, '2023-07-24 10:34:08', 1)
;

INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (544475799542308864, N'0202', 523215083967619072, N'任务实例', 544475544734146560, N'1', 9, 1450756958461300737, '2022-02-11 11:12:26', 1450756958461300737, '2022-02-11 11:12:26')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (544475707963875328, N'0201', 523215083967619072, N'任务管理', 544474404047036416, N'1', 8, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05')
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815518987927691264, N'000000000258', 815518957997137920, N'分级管理', NULL, N'1', 1, 1450756958461300737, '2024-02-29 09:41:18', 1450756958461300737, '2024-02-29 18:41:52', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815300362058866688, N'000000000256', 815299096469577728, N'组织管理功能', 815300265334022144, N'0', 1, 1450756958461300737, '2024-02-28 19:12:34', 1450756958461300737, '2024-02-29 14:28:32', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299769068167168, N'000000000257', 815299436459859968, N'角色维护', 815299064513175552, N'0', 1, 1450756958461300737, '2024-02-28 19:10:12', 1450756958461300737, '2024-02-29 14:28:21', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299697123270656, N'000000000256', 815299390616117248, N'用户维护', 815298745012068352, N'0', 1, 1450756958461300737, '2024-02-28 19:09:55', 1450756958461300737, '2024-02-29 15:02:43', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815299398463660032, N'000000000255', 815299121857699840, N'人员管理功能', 815298988961177600, N'0', 1, 1450756958461300737, '2024-02-28 19:08:44', 1450756958461300737, '2024-02-29 14:28:46', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811885297653784576, N'000000000257', 523209654097158144, N'工具栏收纳', 811885051469111296, N'0', 11, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811885249842913280, N'000000000256', 523209654097158144, N'顶部横幅', 811884952051523584, N'0', 10, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811885197636411392, N'000000000255', 523209654097158144, N'浏览量统计', 811884852453580800, N'0', 9, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55', 1)
;
INSERT INTO [SYS_FUNCTIONS] ([FUNCTION_ID], [FUNCTION_CODE], [FUNCTION_MODULE_ID], [FUNCTION_NAME], [DEFAULT_RESOURCE_ID], [IS_SYS], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811885124697464832, N'000000000254', 523209654097158144, N'广告位配置', 811884745641435136, N'0', 8, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38', 1)
;

-- ----------------------------
-- Table structure for SYS_GET_BACK_PASSWORD
-- ----------------------------


CREATE TABLE [SYS_GET_BACK_PASSWORD] (
  [USER_ID] NUMERIC(20)  NOT NULL,
  [P_QUES] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [P_KEY] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_GET_BACK_PASSWORD] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_GET_BACK_PASSWORD] ADD CONSTRAINT [PK__sys_get___F3BEEBFFF2205D3E] PRIMARY KEY CLUSTERED ([USER_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'用户编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_GET_BACK_PASSWORD',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'找密码的问题',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_GET_BACK_PASSWORD',
'COLUMN', N'P_QUES'

EXEC sp_addextendedproperty
'MS_Description', N'找密码的答案',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_GET_BACK_PASSWORD',
'COLUMN', N'P_KEY'

EXEC sp_addextendedproperty
'MS_Description', N'账户密码找回表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_GET_BACK_PASSWORD'
;


-- ----------------------------
-- Table structure for SYS_IDTABLE
-- ----------------------------


CREATE TABLE [SYS_IDTABLE] (
  [ID_ID] NUMERIC(20)  NOT NULL,
  [ID_VALUE] NUMERIC(10)  NULL,
  [TABLE_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [FIELD_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [ID_DESC] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [CACHE_SIZE] NUMERIC(10)  NULL,
  [ID_PREFIX] NVARCHAR(10) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_PREFIX] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [ID_LENGTH] NUMERIC(10)  NULL,
  [IS_SUFFIX] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [ID_SUFFIX] NVARCHAR(16) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_GLOBAL] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_LEVEL] NVARCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_SYS] NVARCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [LAST_DATE] NVARCHAR(8) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20) NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2 NULL,
)
;

ALTER TABLE [SYS_IDTABLE] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_IDTABLE] ADD CONSTRAINT [PK__sys_idta__8B62FCC7588B5C15] PRIMARY KEY CLUSTERED ([ID_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_ID'

EXEC sp_addextendedproperty
'MS_Description', N'当前编号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'业务表名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'TABLE_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'业务名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'FIELD_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'业务中文描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_DESC'

EXEC sp_addextendedproperty
'MS_Description', N'缓存大小',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'CACHE_SIZE'

EXEC sp_addextendedproperty
'MS_Description', N'前缀',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_PREFIX'

EXEC sp_addextendedproperty
'MS_Description', N'是否使用前缀',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'IS_PREFIX'

EXEC sp_addextendedproperty
'MS_Description', N'编号长度',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_LENGTH'

EXEC sp_addextendedproperty
'MS_Description', N'是否使用后缀',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'IS_SUFFIX'


EXEC sp_addextendedproperty
'MS_Description', N'后缀',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'ID_SUFFIX'

EXEC sp_addextendedproperty
'MS_Description', N'是否全局流水',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'IS_GLOBAL'

EXEC sp_addextendedproperty
'MS_Description', N'是否层级码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'IS_LEVEL'

EXEC sp_addextendedproperty
'MS_Description', N'是否系统编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'IS_SYS'

EXEC sp_addextendedproperty
'MS_Description', N'为特殊规则前缀时\"YYYY\"码表最后日期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'LAST_DATE'

EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最大号表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE'
;


-- ----------------------------
-- Records of SYS_IDTABLE
-- ----------------------------

INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('1450754032317640706', '263', N'SYS_RESOURCE_MODULES', N'MODULE_CODE', N'模块编码', '2', N' ', '0', '4', '0', N' ', '0', N'1', N'1', N'', NULL, N'2020-08-10 18:42:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('1450754032317640708', '520', N'SYS_RESOURCES', N'RESOURCE_CODE', N'资源编码', '1', N' ', '0', '4', '0', N' ', '0', N'1', N'1', NULL, NULL, N'2020-08-10 16:42:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('1450754032317640713', '209', N'SYS_FUNCTIONS', N'FUNCTION_CODE', N'功能编码', '1', N' ', '0', '4', '0', N' ', '0', N'1', N'1', NULL, NULL, N'2020-08-10 13:42:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('1450754032317640717', '22', N'SYS_FUNCTION_MODULES', N'FUNCTION_MODULE_CODE', N'功能模块编码', '1', NULL, '0', '4', '0', NULL, '0', N'1', N'1', NULL, NULL, N'2020-08-10 11:40:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('622468560387842048', '0', N'SYS_ORGAN', N'ORGAN_CODE_4', N'组织机构编码生成规则', '1', NULL, '0', '11', '0', NULL, '0', N'0', N'1', NULL, NULL, N'2020-08-10 20:42:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES ('624170019827490816', '0', N'SYS_STAFF', N'STAFF_CODE', N'人员编码生成规则', '1', NULL, '0', '11', '0', NULL, '0', N'0', N'1', NULL, NULL, N'2020-08-10 19:42:42.0000000', NULL, NULL)
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (686205562077323264, 0, N'SYS_APPLICATION', N'APP_CODE', N'应用编码', 1, N'', N'0', 10, N'0', N'', N'0', N'0', N'1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40')
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (713774538961461248, 0, N'SYS_RESOURCE_TYPE', N'RESOURCE_TYPE_CODE', N'资源类型编码', 1, N'', N'0', 4, N'0', N'', N'0', N'0', N'1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40')
;
INSERT INTO [SYS_IDTABLE] ([ID_ID], [ID_VALUE], [TABLE_NAME], [FIELD_NAME], [ID_DESC], [CACHE_SIZE], [ID_PREFIX], [IS_PREFIX], [ID_LENGTH], [IS_SUFFIX], [ID_SUFFIX], [IS_GLOBAL], [IS_LEVEL], [IS_SYS], [LAST_DATE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME]) VALUES (713774739046539264, 0, N'SYS_RESOURCE_TYPE_EXPAND', N'RESOURCE_TYPE_EXPAND_CODE', N'资源类型拓展属性编码', 1, N'', N'0', 4, N'0', N'', N'0', N'0', N'1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40')
;

-- ----------------------------
-- Table structure for SYS_IDTABLE_INFO
-- ----------------------------


CREATE TABLE [SYS_IDTABLE_INFO] (
  [INFO_ID] NUMERIC(20)  NOT NULL,
  [IDTABLE_ID] NUMERIC(20)  NULL,
  [ID_VALUE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_NUMBER] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_IDTABLE_INFO] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_IDTABLE_INFO] ADD CONSTRAINT [PK__sys_idta__93430BF42CDD8D96] PRIMARY KEY CLUSTERED ([INFO_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE_INFO',
'COLUMN', N'INFO_ID'

EXEC sp_addextendedproperty
'MS_Description', N'字典表主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE_INFO',
'COLUMN', N'IDTABLE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'当前值',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE_INFO',
'COLUMN', N'ID_VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'父级id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE_INFO',
'COLUMN', N'PARENT_NUMBER'

EXEC sp_addextendedproperty
'MS_Description', N'最大号表信息表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_IDTABLE_INFO'
;



-- ----------------------------
-- Table structure for SYS_INTERFACE_USER
-- ----------------------------


CREATE TABLE [SYS_INTERFACE_USER] (
  [USER_ID] NUMERIC(20)  NOT NULL,
  [USER_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_LOCK] NVARCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [SYS_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [SYS_URL] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [TOKEN_STATUS] NVARCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [TOKEN_START_TIME] DATETIME2  NULL,
  [TOKEN_END_TIME] DATETIME2  NULL,
  [CONNECT_NUM] NUMERIC(10)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [TOKEN_VALUE] NVARCHAR(512) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_INTERFACE_USER] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_INTERFACE_USER] ADD CONSTRAINT [PK__sys_inte__F3BEEBFF8F2CC633] PRIMARY KEY CLUSTERED ([USER_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'接口用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'USER_ID'

EXEC sp_addextendedproperty
'MS_Description', N'接口用户名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'USER_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'是否锁定',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'IS_LOCK'

EXEC sp_addextendedproperty
'MS_Description', N'用户名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'SYS_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'应用系统地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'SYS_URL'

EXEC sp_addextendedproperty
'MS_Description', N'token状态',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'TOKEN_STATUS'

EXEC sp_addextendedproperty
'MS_Description', N'token获取时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'TOKEN_START_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'token失效时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'TOKEN_END_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'token连接次数',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'CONNECT_NUM'

EXEC sp_addextendedproperty
'MS_Description', N'应用系统地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'token值',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER',
'COLUMN', N'TOKEN_VALUE'

EXEC sp_addextendedproperty
'MS_Description', N'接口表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_INTERFACE_USER'
;

-- ----------------------------
-- Table structure for SYS_MENU
-- ----------------------------


CREATE TABLE [SYS_MENU] (
  [MENU_ID] NUMERIC(20)  NOT NULL,
  [MENU_TEXT] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [MENU_ALIAS] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [FUNCTION_MODULE_ID] NUMERIC(20)  NULL,
  [FUNCTION_ID] NUMERIC(20)  NULL,
  [PARENT_ID] NUMERIC(20)  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [IS_LEAF] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [TARGET] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [ICONS] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [OPEN_TYPE] NVARCHAR(16) COLLATE Chinese_PRC_CI_AS  NULL,
  [PATH] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [COMPONENT] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [MENU_TYPE] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] date  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] date  NULL,
  [OPEN_MODE] NVARCHAR(2) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_SYS] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_MENU] SET (LOCK_ESCALATION = TABLE)
;

ALTER TABLE [SYS_MENU] ADD CONSTRAINT [PK__SYS_MENU__6C47297925E06BD3] PRIMARY KEY CLUSTERED ([MENU_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'菜单id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'MENU_ID'

EXEC sp_addextendedproperty
'MS_Description', N'菜单编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'MENU_TEXT'

EXEC sp_addextendedproperty
'MS_Description', N'菜单别名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'MENU_ALIAS'

EXEC sp_addextendedproperty
'MS_Description', N'功能模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'FUNCTION_MODULE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'FUNCTION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'父菜单',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'PARENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'显示顺序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'SEQ'

EXEC sp_addextendedproperty
'MS_Description', N'是否是叶子节点',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'IS_LEAF'

EXEC sp_addextendedproperty
'MS_Description', N'菜单目标',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'TARGET'

EXEC sp_addextendedproperty
'MS_Description', N'菜单图标',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'ICONS'

EXEC sp_addextendedproperty
'MS_Description', N'打开方式',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'OPEN_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'组件根路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'PATH'

EXEC sp_addextendedproperty
'MS_Description', N'组件引入路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'COMPONENT'

EXEC sp_addextendedproperty
'MS_Description', N'区分菜单',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'MENU_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'CREATOR'

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'LAST_EDITOR'

EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'LAST_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'打开方式 0系统内 1系统外',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'OPEN_MODE'

EXEC sp_addextendedproperty
'MS_Description', N'是否是系统菜单',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU',
'COLUMN', N'IS_SYS'

EXEC sp_addextendedproperty
'MS_Description', N'系统菜单',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_MENU'
;


-- ----------------------------
-- Records of SYS_MENU
-- ----------------------------
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (686144725505548288, N'应用管理', N'应用管理', NULL, NULL, 1, 14, N'0', NULL, N'hussar_application', N'inside', N'', N'', N'0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (686147400720719872, N'应用管理', N'应用管理', NULL, 686147054220877824, 686144725505548288, 1, N'1', NULL, N'caidan_appManagement', N'inside', N'/appManage', N'', N'0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (686147588675870720, N'应用回收站', N'应用回收站', NULL, 686147191273955328, 686144725505548288, 2, N'1', NULL, N'caidan_recycleBin', N'inside', N'/RecycleBin', N'', N'0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (729285621608357888, N'分组管理', N'分组管理', NULL, 729285499054989312, 686144725505548288, 3, N'1', NULL, N'caidan-2Jmoren', N'inside', N'/appGroupManage', N'', N'0', 1450756958461300737, '2023-07-06', 1450756958461300737, '2023-07-06', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (1450764807862095968, N'连接池监控', N'连接池监控', -1, 1450764807862095905, 510505261149200384, 3, N'1', N'', N'left-secondary-menu', N'inside', N'/poolMonitor', N'@/views/service/poolMonitor/index', N'0', -1, NULL, -1, '2021-11-09', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (813349058159845376, N'标签管理', N'标签管理', NULL, 813348971400667136, 811594821746827264, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/contactService/TagManage', N'', N'0', 1450756958461300737, '2024-02-23', 1450756958461300737, '2024-02-23', N'0', N'0');
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811594821746827264, N'联系人管理', N'联系人管理', NULL, NULL, 576395294317748224, 11, N'0', N'', N'caidan-liucheng4', N'inside', N'', N'', N'0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', N'0', N'0');
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811596001818451968, N'通讯录', N'通讯录', NULL, 811595871216214016, 811594821746827264, 1, N'1', N'', N'caidan-3Jmoren', N'inside', N'/contactService/ContactManage', N'', N'0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', N'0', N'0');
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('510398063710576640', N'开发者中心', N'开发者中心', '-1', '-1', '1', '5', '0', N'', N'bpm-platform-management', N'inside', N'', N'', '0', '1450756958461300737', '2021-11-09', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('510503960046739456', N'运维工具', N'运维工具', '-1', '-1', '1450764807862096012', '10', '0', N'', N'icon-left-operation-and-maintenance', N'inside', N'', N'', '0', '1450756958461300737', '2021-11-09', '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('510505261149200384', N'平台监控', N'平台监控', '-1', '-1', '1450764807862096012', '11', '0', N'', N'icon-left-monitor', N'inside', N'', N'', '0', '1450756958461300737', '2021-11-09', '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('510506323742564352', N'平台日志', N'平台日志', '-1', '-1', '1450764807862096012', '12', '0', N'', N'icon-left-log', N'inside', N'', N'', '0', '1450756958461300737', '2021-11-09', '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('518461064346869760', N'客户端管理', N'客户端管理', NULL, '518460834717114368', '510503960046739456', '8', '1', NULL, N'left-secondary-menu', N'inside', N'/authClientModel', N'', '0', '1450756958461300737', '2021-12-01', '1450756958461300737', '2021-12-01', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('520237348433436672', N'插件管理', N'插件管理', NULL, '520236482527764480', '510398063710576640', '6', '1', NULL, N'left-level-menu', N'inside', N'/plugin/pluginList', N'', '0', '1450756958461300737', '2021-12-06', '1450756958461300737', '2021-12-06', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('521279919444205568', N'组织机构', N'组织机构', NULL, NULL, '1450764807862095980', '1', '0', NULL, N'icon-left-organ', N'inside', N'', N'', '0', '1450756958461300737', '2021-12-09', '1450756958461300737', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('521280546094194688', N'用户管理', N'用户管理', NULL, NULL, '1450764807862095980', '2', '0', NULL, N'icon-left-user-manage', N'inside', N'', N'', '0', '1450756958461300737', '2021-12-09', '1450756958461300737', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('521288179740057600', N'功能资源', N'功能资源', NULL, NULL, '1450764807862095980', '4', '0', NULL, N'module', N'inside', N'', N'', '0', '1450756958461300737', '2021-12-09', '1450756958461300737', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('523160324178976768', N'统一待办', N'统一待办', NULL, NULL, '1', '8', '0', NULL, N'caidan_tongyidaiban', N'inside', N'', N'', '1', '1450756958461300737', '2021-12-14', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('523160531927048192', N'我的待办', N'我的待办', NULL, '522705551881412608', '523160324178976768', '1', '1', NULL, N'caidan_wodedaiban', N'inside', N'/unifiedtodoToDoTask', N'', '1', '1450756958461300737', '2021-12-14', '1450756958461300737', '2021-12-14', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('523564187033804800', N'我的已办', N'我的已办', NULL, '523555260388876288', '523160324178976768', '2', '1', NULL, N'caidan_wodeyiban', N'inside', N'/unifiedtodoDoneTask', N'', '1', '1450756958461300737', '2021-12-15', '1450756958461300737', '2021-12-15', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('523564256034299904', N'我的传阅', N'我的传阅', NULL, '523555376986333184', '523160324178976768', '3', '1', NULL, N'caidan_wodechaosong', N'inside', N'/unifiedtodoCcTask', N'', '1', '1450756958461300737', '2021-12-15', '1450756958461300737', '2021-12-15', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('525236738705334272', N'统一待办', N'统一待办', NULL, NULL, '510398063710576640', '5', '0', NULL, N'unifiedtodo', N'inside', N'', N'', '0', '1450756958461300737', '2021-12-20', '1450756958461300737', '2021-12-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('525237452181610496', N'应用注册', N'应用注册', NULL, '521404105277841408', '525236738705334272', '1', '1', NULL, N'left-secondary-menu', N'inside', N'/unifiedtodoSystem', N'', '0', '1450756958461300737', '2021-12-20', '1450756958461300737', '2021-12-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('526077936101761024', N'我的公告', N'我的公告', '-1', '526077556152344576', '1450764807862095952', '6', '1', N'', N'caidan_wodegonggao', N'inside', N'/noticeList', N'', '1', '1450756958461300737', '2021-12-22', '-1', '2021-12-22', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('535768937116475392', N'审计查阅', N'审计查阅', NULL, '535768729024471040', '510506323742564352', '4', '1', NULL, N'left-secondary-menu', N'inside', N'/auditAccess', N'', '0', '1450756958461300737', '2022-01-18', '1450756958461300737', '2022-01-18', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('544469385839124480', N'主题配置', N'主题配置', NULL, '544469147921424384', '510398063710576640', '7', '1', NULL, N'icon-left-theme', N'inside', N'/themeConfig', N'', '0', '1450756958461300737', '2022-02-11', '1450756958461300737', '2022-02-11', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('545575465642106880', N'统一日志', N'统一日志', NULL, '545565036773646336', '592306184481153024', '1', '1', NULL, N'left-secondary-menu', N'inside', N'/unifiedLog', N'', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('546343278384259072', N'链路追踪', N'链路追踪', NULL, '546343149988225024', '592306184481153024', '2', '1', NULL, N'left-secondary-menu', N'inside', N'/linkTracking', N'', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('546348182481936384', N'错误统计', N'错误统计', NULL, '546347915988443136', '592306184481153024', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/errorStatistics', N'', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576395294317748224', N'消息中心', N'消息中心', NULL, NULL, '1', '9', '0', NULL, N'xiaoxipingtai_xiaoxitongzhi_xiaoxifuwu-01', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576446459680137216', N'短信推送', N'短信推送', NULL, NULL, '576395294317748224', '2', '0', NULL, N'xiaoxi-duanxinfuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576448392889376768', N'委托待办', N'委托待办', NULL, '576448277533433856', '579974742292045824', '2', '1', NULL, N'caidan-3Jmoren', N'inside', N'/entrustTodoList', N'', '1', NULL, '2022-05-10', NULL, '2022-05-10', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576448474900602880', N'委托已办', N'委托已办', NULL, '576438008606367744', '579974742292045824', '3', '1', NULL, N'caidan-3Jmoren', N'inside', N'/entrustDoneList', N'', '1', NULL, '2022-05-10', NULL, '2022-05-10', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576450856640323584', N'通道管理', N'通道管理', NULL, '576447430137225216', '576446459680137216', '1', '1', N'', N'left-secondary-menu', N'inside', N'/smsService/Channel', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576450925435297792', N'签名管理', N'签名管理', NULL, '576447488295444480', '576446459680137216', '2', '1', NULL, N'left-secondary-menu', N'inside', N'/smsService/signature', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576450990023385088', N'模板管理', N'模板管理', NULL, '576447546457858048', '576446459680137216', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/smsService/template', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576451066137419776', N'发送测试', N'发送测试', NULL, '576447608743272448', '576446459680137216', '4', '1', N'', N'left-secondary-menu', N'inside', N'/smsService/SendSMS', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576451140942831616', N'发送记录', N'发送记录', NULL, '576447666205237248', '576446459680137216', '5', '1', NULL, N'left-secondary-menu', N'inside', N'/smsService/sendRecord', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('576451207187668992', N'发送统计', N'发送统计', NULL, '576447721767182336', '576446459680137216', '6', '1', N'', N'left-secondary-menu', N'inside', N'/smsService/sendRateReport', N'', '0', '1450756958461300737', '2022-05-10', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('577911561352650752', N'邮件推送', N'邮件推送', NULL, NULL, '576395294317748224', '3', '0', NULL, N'xiaoxi-youjianfuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-14', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('577911671788675072', N'通道管理', N'通道管理', NULL, '577911233693622272', '577911561352650752', '1', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/mChannel', N'', '0', '1450756958461300737', '2022-05-14', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('577920288222879744', N'发送记录', N'发送记录', NULL, '577920176742473728', '577911561352650752', '7', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/mailSendRecord', N'', '0', '1450756958461300737', '2022-05-14', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578180907635318784', N'模板管理', N'模板管理', NULL, '578179104113958912', '577911561352650752', '2', '1', NULL, N'left-secondary-menu', N'inside', N'/mailService/mTemplate', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578183012341260288', N'单发测试', N'单发测试', NULL, '578179213245554688', '577911561352650752', '4', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/mSendTest', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578185499647418368', N'群发测试', N'群发测试', NULL, '578179275791015936', '577911561352650752', '5', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/groupHair', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578185579053981696', N'收件人管理', N'收件人管理', NULL, '578179328681189376', '577911561352650752', '3', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/recipient', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578185686646267904', N'发送统计', N'发送统计', NULL, '578180115675226112', '577911561352650752', '6', '1', N'', N'left-secondary-menu', N'inside', N'/mailService/readedStatistics', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578225925171453952', N'微信公众号推送', N'微信公众号推送', NULL, NULL, '576395294317748224', '4', '0', NULL, N'xiaoxi-weixingongzhonghaofuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578226039885668352', N'通道管理', N'通道管理', NULL, '578225632039936000', '578225925171453952', '1', '1', N'', N'left-secondary-menu', N'inside', N'/mpService/111publicAccount', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578226124077932544', N'模板管理', N'模板管理', NULL, '578225680442204160', '578225925171453952', '2', '1', N'', N'left-secondary-menu', N'inside', N'/mpService/mpTemplate', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578226212909096960', N'发送测试', N'发送测试', NULL, '578225755054678016', '578225925171453952', '3', '1', N'', N'left-secondary-menu', N'inside', N'/mpService/messageTesting', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('578226283117551616', N'发送记录', N'发送记录', NULL, '578225803503083520', '578225925171453952', '4', '1', N'', N'left-secondary-menu', N'inside', N'/mpService/pushRecord', N'', '0', '1450756958461300737', '2022-05-15', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579402999395524608', N'IM推送', N'IM推送', NULL, NULL, '576395294317748224', '5', '0', NULL, N'xiaoxi-Applmfuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579403112276828160', N'通道管理', N'通道管理', NULL, '579402490307682304', '579402999395524608', '1', '1', N'', N'left-secondary-menu', N'inside', N'/appImService/appImChannel', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579403203670712320', N'发送测试', N'发送测试', NULL, '579402568669863936', '579402999395524608', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/appImService/appImSendTest', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579403287988805632', N'发送统计', N'发送统计', NULL, '579402651498979328', '579402999395524608', '5', '1', N'', N'left-secondary-menu', N'inside', N'/appImService/appImDataStatistics', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579408006685663232', N'APP通知推送', N'APP通知推送', NULL, NULL, '576395294317748224', '6', '0', NULL, N'xiaoxi-APPtuisongfuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579408141658365952', N'通道管理', N'通道管理', NULL, '579407434091864064', '579408006685663232', '1', '1', NULL, N'left-secondary-menu', N'inside', N'/appPushService/appPushChannel', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579408250869653504', N'发送测试', N'发送测试', NULL, '579407499330068480', '579408006685663232', '3', '1', N'', N'left-secondary-menu', N'inside', N'/appPushService/appPushTest', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579408319811428352', N'发送记录', N'发送记录', NULL, '579407703957577728', '579408006685663232', '4', '1', N'', N'left-secondary-menu', N'inside', N'/appPushService/appPushReecorded', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579408390443507712', N'发送统计', N'发送统计', NULL, '579407758378672128', '579408006685663232', '5', '1', N'', N'left-secondary-menu', N'inside', N'/appPushService/appPushStatistics', N'', '0', '1450756958461300737', '2022-05-18', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579974742292045824', N'流程委托', N'流程委托', NULL, NULL, '1450764807862095952', '6', '0', NULL, N'caidan_liuchengweituo', N'inside', N'/entrustDoneList', N'', '1', NULL, '2022-05-10', NULL, '2022-05-10', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('579987145213878272', N'发送记录', N'发送记录', NULL, '579987015375003648', '579402999395524608', '4', '1', N'', N'left-secondary-menu', N'inside', N'/appImService/appImSendRecord', N'', '0', '1450756958461300737', '2022-05-20', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581430140240928768', N'流程分析', N'流程分析', NULL, NULL, '1450764807862095963', '11', '0', N'', N'icon-left-monitor', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-06-06', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437577991823360', N'流程概览', N'流程概览', NULL, '581430666475085824', '581430140240928768', '1', '1', N'', N'left-secondary-menu', N'inside', N'/bpa/view', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437646807769088', N'流程状态分析', N'流程状态分析', NULL, '581436854533103616', '581430140240928768', '2', '1', N'', N'left-secondary-menu', N'inside', N'/bpa/view/processStatus', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437695180677120', N'流程参与者分析', N'流程参与者分析', NULL, '581436941229367296', '581430140240928768', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/bpaProcessAssignee', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437747630448640', N'流程统计分析', N'流程统计分析', NULL, '581436993427480576', '581430140240928768', '4', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/bpaProcessStatistics', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437791045689344', N'数量分析', N'数量分析', NULL, NULL, '581430140240928768', '5', '0', N'', N'left-secondary-menu', N'inside', N'', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-06-06', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437856728489984', N'热门流程分析', N'热门流程分析', NULL, '581437139125018624', '581437791045689344', '1', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/bpaHotProcess', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437898885439488', N'流程数量分析', N'流程数量分析', NULL, '581437221161410560', '581437791045689344', '2', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/bpaProcessAmount', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437940299997184', N'用户流程分析', N'用户流程分析', NULL, '581437297606795264', '581437791045689344', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/bpaProcessUser', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581437985619451904', N'待办任务分析', N'待办任务分析', NULL, '581437337255550976', '581437791045689344', '4', '1', N'', N'left-secondary-menu', N'inside', N'/todoTaskAnalysis', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-06-06', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('581438095157895168', N'流程耗时分析', N'流程耗时分析', NULL, '581437382767943681', '581430140240928768', '6', '1', NULL, N'left-secondary-menu', N'inside', N'/bpa/view/processConsumeTime', N'', '0', '1450756958461300737', '2022-05-24', '1450756958461300737', '2022-05-24', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('582661624251555840', N'发送统计', N'发送统计', NULL, '582661445364490240', '578225925171453952', '5', '1', N'', N'left-secondary-menu', N'inside', N'/mpService/sendStatistics', N'', '0', '1450756958461300737', '2022-05-27', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('586248796225413120', N'流程驳回分析', N'流程驳回分析', NULL, '581437337255550977', '581437791045689344', '5', '1', NULL, N'left-secondary-menu', N'inside', N'/processRejectionAnalysis', N'', '0', '1450756958461300737', '2022-06-06', '1450756958461300737', '2022-06-06', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('592306184481153024', N'统一日志', N'统一日志', NULL, NULL, '510506323742564352', '6', '0', N'', N'left-secondary-menu', N'inside', N'', N'', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('592401069905289216', N'日志告警', N'日志告警', NULL, NULL, '510505261149200384', '6', '0', N'', N'left-secondary-menu', N'inside', N'', N'', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('592401214583611392', N'告警设置', N'告警设置', NULL, '592386778267394048', '592401069905289216', '1', '1', N'', N'left-secondary-menu', N'inside', N'/logSet', N'@/views/logWarn/logSet', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('592401334532317184', N'告警记录', N'告警记录', NULL, '592391757124345856', '592401069905289216', '2', '1', N'', N'left-secondary-menu', N'inside', N'/logRecord', N'@/views/logWarn/logRecord', '0', '1450756958461300737', '2022-07-01', '1450756958461300737', '2022-07-01', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('595572492354199552', N'移动门户配置', N'移动门户配置', NULL, NULL, '1450764807862095954', '11', '0', NULL, N'left-mobile-office', N'inside', N'', N'', '0', '1450756958461300737', '2022-07-02', '1450756958461300737', '2022-07-02', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('595572608519643136', N'首页配置', N'首页配置', NULL, '595572331049656320', '595572492354199552', '1', '1', N'', N'left-secondary-menu', N'inside', N'/portalConfiguration', N'', '0', '1450756958461300737', '2022-07-02', '1450756958461300737', '2022-07-11', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('595572683195031552', N'三方集成', N'三方集成', NULL, '595572392424906752', '595572492354199552', '2', '1', N'', N'left-secondary-menu', N'inside', N'/tripartiteIntegration', N'', '0', '1450756958461300737', '2022-07-02', '1450756958461300737', '2022-07-11', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('596354392677163008', N'应用管理', N'应用管理', NULL, NULL, '576395294317748224', '8', '0', NULL, N'icon-left-application-manage', N'inside', N'', N'', '0', '1450756958461300737', '2022-07-04', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('596354710630572032', N'应用管理', N'应用管理', NULL, '596354099289792512', '596354392677163008', '1', '1', NULL, N'left-secondary-menu', N'inside', N'/appService/appManage', N'', '0', '1450756958461300737', '2022-07-04', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('608975106760515584', N'场景管理', N'场景管理', NULL, '608974847288287232', '596354392677163008', '2', '1', N'', N'left-secondary-menu', N'inside', N'/appService/sceneManage', N'', '0', '1450756958461300737', '2022-08-08', '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095951', N'组织管理', N'组织管理', '-1', '1450764807862095892', '521279919444205568', '1', '1', N'', N'left-secondary-menu', N'inside', N'/OrganMaintenance', N'@/views/organ/OrganMaintenance', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095952', N'个人事项', N'个人事项', '1450764807862095873', NULL, '1', '7', '0', NULL, N'caidan_gerenshixiang', N'', N'/toDoManage', N'@/views/layout/layout', '1', NULL, NULL, '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095953', N'我的传阅', N'我的传阅', NULL, '1450764807862095893', '1450764807862095952', '4', '1', NULL, N'caidan_wodechaosong', N'', N'/ccList', N'@/views/taskmanage/ccList', '1', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095954', N'门户配置', N'门户配置', '1450764807862095874', '-1', '1', '2', '0', N'', N'bpm-portal-configuration-center', N'inside', N'', N'', '0', '-1', NULL, '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095959', N'审计日志', N'审计日志', '-1', '1450764807862095898', '510506323742564352', '1', '1', N'', N'left-secondary-menu', N'inside', N'/auditlog', N'@/views/system/auditlog/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095961', N'解冻密码', N'解冻密码', NULL, '1450764807862095900', '510503960046739456', '3', '1', NULL, N'left-secondary-menu', N'tab', N'/thawcode', N'@/views/system/thawcode/index', '0', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095962', N'资源管理', N'资源管理', '-1', '1450764807862095901', '521288179740057600', '1', '1', N'', N'left-secondary-menu', N'inside', N'/resourceManage', N'@/views/permit/resourceManage/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095963', N'流程中心', N'流程中心', '1450764807862095875', '-1', '1', '3', '0', N'', N'bpm-process-center', N'inside', N'', N'', '0', '-1', NULL, '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095965', N'类型定义', N'类型定义', '-1', '1450764807862095902', '521279919444205568', '4', '1', N'', N'left-secondary-menu', N'inside', N'/SysOrgType', N'@/views/organ/SysOrgType', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095967', N'我的催办', N'我的催办', NULL, '1450764807862095904', '1450764807862095952', '3', '1', NULL, N'caidan_wodecuiban', N'', N'/urgeList', N'@/views/taskmanage/urgeList', '1', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095972', N'用户维护', N'用户维护', '-1', '1450764807862095908', '521280546094194688', '1', '1', N'', N'left-secondary-menu', N'inside', N'/usermanage', N'@/views/permit/usermanage/user', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095974', N'角色维护', N'角色维护', '-1', '1450764807862095909', '1450764807862095998', '1', '1', N'', N'left-secondary-menu', N'inside', N'/role', N'@/views/permit/rolemanage/role/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095975', N'重置密码', N'重置密码', NULL, '1450764807862095911', '510503960046739456', '2', '1', NULL, N'left-secondary-menu', NULL, N'/resetpassword', N'@/views/system/resetpassword/index', '0', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095978', N'字典管理', N'字典管理', NULL, '1450764807862095913', '510503960046739456', '1', '1', N'', N'left-secondary-menu', N'', N'/dictionary', N'@/views/system/dictionary/index', '0', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095980', N'组织权限', N'组织权限', '523176320419766272', '-1', '1', '1', '0', N'', N'bpm-organization-authority-center', N'inside', N'', N'', '0', '-1', NULL, '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095982', N'组织审核', N'组织审核', '-1', '1450764807862095915', '521279919444205568', '6', '1', N'', N'left-secondary-menu', N'tab', N'/organAudit', N'@/views/permit/auditManage/organAudit/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095986', N'系统参数', N'系统参数', '523213802016350208', '-1', '510398063710576640', '4', '0', N'', N'icon-left-system-params', N'inside', N'/system', N'@/views/layout/layout', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095987', N'慢SQL诊断', N'慢SQL诊断', '-1', '1450764807862095920', '510505261149200384', '5', '1', N'', N'left-secondary-menu', N'inside', N'/slowsql', N'@/views/service/slowsql/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095988', N'菜单配置', N'菜单配置', '-1', '1450764807862095921', '1450764807862095954', '3', '1', N'', N'left-menu-manage', N'inside', N'/menumaintain', N'@/views/menumaintain/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095990', N'规则定义', N'规则定义', '-1', '1450764807862095922', '521279919444205568', '5', '1', N'', N'left-secondary-menu', N'inside', N'/SysOrgRule', N'@/views/organ/SysOrgRule', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095991', N'用户审核', N'用户审核', '-1', '1450764807862095923', '521280546094194688', '2', '1', N'', N'left-secondary-menu', N'tab', N'/userAudit', N'@/views/permit/auditManage/userAudit/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095993', N'任务管理', N'任务管理', '-1', '1450764807862095924', '1450764807862095963', '9', '1', N'', N'icon-left-task-manage', N'inside', N'/bpmTask', N'@/bpm/views/taskManagement/task', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095995', N'系统监控', N'系统监控', '-1', '1450764807862095925', '510505261149200384', '4', '1', N'', N'left-secondary-menu', N'inside', N'/systemMonitor', N'@/views/service/systemMonitor/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095997', N'在线用户', N'在线用户', '-1', '1450764807862095927', '510505261149200384', '1', '1', N'', N'left-secondary-menu', N'inside', N'/onlineUser', N'@/views/system/onlineuser/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095998', N'角色管理', N'角色管理', '1450764807862095884', '-1', '1450764807862095980', '3', '0', N'', N'left-role-manage', N'inside', N'/roleManage', N'@/views/permit/rolemanage/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862095999', N'快捷功能配置', N'快捷功能配置', '-1', '1450764807862095928', '1450764807862095954', '4', '1', N'', N'left-shortcut-config', N'inside', N'/shortCutConf', N'@/views/personalizedConf/shortCutConf', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096000', N'日志下载', N'日志下载', '-1', '1450764807862095929', '510506323742564352', '2', '1', N'', N'left-secondary-menu', N'inside', N'/logdownload', N'@/views/service/logdownload/index', '0', '-1', NULL, '1450756958461300737', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096001', N'人员审核', N'人员审核', '-1', '1450764807862095930', '521279919444205568', '7', '1', N'', N'left-secondary-menu', N'tab', N'/staffAudit', N'@/views/permit/auditManage/staffAudit/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096002', N'人员管理', N'人员管理', '-1', '1450764807862095931', '521279919444205568', '2', '1', N'', N'left-secondary-menu', N'inside', N'/StaffManage', N'@/views/organ/StaffManage', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096004', N'函数管理', N'函数管理', '-1', '1450764807862095933', '1450764807862095963', '10', '1', N'', N'icon-left-function-manage', N'inside', N'/bpmFunction', N'@/bpm/views/function/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096005', N'自定义编码规则', N'自定义编码规则', '-1', '1450764807862095934', '1450764807862095986', '5', '1', N'', N'left-secondary-menu', N'inside', N'/maximumTable', N'@/views/system/maximumTable/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096007', N'已办任务', N'已办任务', NULL, '1450764807862095935', '1450764807862095952', '2', '1', NULL, N'caidan_yibanrenwu', N'', N'/doneList', N'@/views/taskmanage/doneList', '1', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096008', N'工作日维护', N'工作日维护', '-1', '1450764807862095936', '510503960046739456', '6', '1', N'', N'left-secondary-menu', N'inside', N'/workcalendar', N'@/views/system/workcalendar/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096010', N'流程管理', N'流程管理', '-1', '1450764807862095937', '1450764807862095963', '2', '1', N'', N'icon-left-process-manage', N'inside', N'/bpmModelEdit', N'@/bpm/views/modeling/modelEdit', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096011', N'框架页配置', N'框架页配置', '-1', '1450764807862095938', '1450764807862095954', '8', '1', N'', N'left-layout-config', N'inside', N'/layoutConf', N'@/views/personalizedConf/layoutConf', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096012', N'运维监控', N'运维监控', '1450764807862095887', '-1', '1', '6', '0', N'', N'bpm-operation-and-maintenance-monitoring-center', N'inside', N'/service', N'@/views/layout/layout', '0', '-1', NULL, '1450756958461300737', '2022-10-20', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096014', N'用户角色审核', N'用户角色审核', '-1', '1450764807862095939', '1450764807862095998', '3', '1', N'', N'left-secondary-menu', N'inside', N'/userRoleVerify', N'@/views/permit/rolemanage/userRoleVerify/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096015', N'登录页配置', N'登录页配置', '-1', '1450764807862095940', '1450764807862095954', '7', '1', N'', N'left-login-config', N'inside', N'/loginConf', N'@/views/personalizedConf/loginConf', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096016', N'我的委托', N'我的委托', NULL, '1450764807862095941', '579974742292045824', '1', '1', NULL, N'caidan-3Jmoren', N'inside', N'/entrustList', N'@/views/taskmanage/entrustList', '1', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096019', N'实例管理', N'实例管理', '-1', '1450764807862095943', '1450764807862095963', '8', '1', N'', N'icon-left-instance-manage', N'inside', N'/bpmProcess', N'@/bpm/views/processinst/process', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096020', N'在线历史记录', N'在线历史记录', '-1', '1450764807862095944', '510506323742564352', '3', '1', N'', N'left-secondary-menu', N'inside', N'/onlinehis', N'@/views/system/onlinehistory/index', '0', '-1', NULL, '-1', '2021-11-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096021', N'运行参数配置', N'运行参数配置', NULL, '1450764807862095945', '1450764807862095986', '3', '1', N'', N'left-secondary-menu', N'tab', N'/baseConfig', N'@/views/system/baseConfig/index', '0', NULL, NULL, '1450756958461300737', '2021-11-11', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096022', N'功能管理', N'功能管理', '-1', '1450764807862095910', '521288179740057600', '2', '1', N'', N'left-secondary-menu', N'inside', N'/functionManage', N'@/pages/console/views/permit/functionManage/index', '0', '-1', '2021-06-21', '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096023', N'不相容角色集', N'不相容角色集', '-1', '1450764807862095946', '1450764807862095998', '2', '1', N'', N'left-secondary-menu', N'inside', N'/alienRole', N'@/views/permit/rolemanage/alienRole/index', '0', '-1', NULL, '-1', '2021-12-09', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096024', N'待办任务', N'待办任务', NULL, '1450764807862095947', '1450764807862095952', '1', '1', NULL, N'caidan_daibanrenwu', N'', N'/toDoList', N'@/views/taskmanage/todoList', '1', NULL, NULL, NULL, NULL, N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('1450764807862096026', N'授权信息', N'授权信息', NULL, '1450764807862095949', '1450764807862095986', '9', '1', NULL, N'left-secondary-menu', NULL, N'/license', N'@/views/system/license/index', '0', NULL, NULL, '1450756958461300737', '2021-11-11', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('587710302741864448', N'发送测试', N'发送测试', NULL, '588042975440019456', '586944248251949056', '1', '1', N'', N'left-secondary-menu', N'inside', N'/noticeService/noticePushTest', N'', '0', '1450756958461300737', '2022-06-10 18:40:42.000', '1450756958461300737', '2022-06-10 18:40:42.000', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('587710386070102016', N'发送记录', N'发送记录', NULL, '587709734606610432', '586944248251949056', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/noticeService/noticeSendRecord', N'', '0', '1450756958461300737', '2022-06-10 18:40:42.000', '1450756958461300737', '2022-06-10 18:40:42.000', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('587710464084156416', N'发送统计', N'发送统计', NULL, '587709787979128832', '586944248251949056', '4', '1', N'', N'left-secondary-menu', N'inside', N'/noticeService/noticeStatistics', N'', '0', '1450756958461300737', '2022-06-10 18:40:42.000', '1450756958461300737', '2022-06-10 18:40:42.000', N'0', '1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('586944248251949056', N'内部通知推送', N'内部通知推送', NULL, NULL, '576395294317748224', '7', '0', NULL, N'xiaoxi-neibutongzhifuwu', N'inside', N'', N'', '0', '1450756958461300737', '2022-06-10 18:40:42.000', '1450756958461300737', '2022-06-10 18:40:42.000', N'0', '1')
;
INSERT INTO [SYS_MENU]([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (641244243347906560, N'数据导出', N'数据导出', null, 641244024103247872, 641242930610446336, 2, '1', N'', N'left-secondary-menu', N'inside', N'/migrationDump', N'', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', N'0', '0')
;
INSERT INTO [SYS_MENU]([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (641244185470705664, N'数据导入', N'数据导入', null, 641243926136889344, 641242930610446336, 1, '1', N'', N'left-secondary-menu', N'inside', N'/migrationLoad', N'', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', N'0', '0')
;
INSERT INTO [SYS_MENU]([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (641242930610446336, N'数据迁移', N'数据迁移', null, null, 1450764807862096012, 13, '0', null, N'form', N'inside', N'', N'', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (686178606145347584,  N'企业微信推送',  N'企业微信推送',  null,  null,  576395294317748224,  9,  N'0',  N'',  N'caidan-2Jmoren',  N'inside',  N'',  N'',  N'0',  1450756958461300737,  N'2023-03-09',  1450756958461300737,  N'2023-03-09',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (686178943606464512,  N'通道管理',  N'通道管理',  null,  686178119287316480,  686178606145347584,  1,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/wecomService/wecomChannel',  N'',  N'0',  1450756958461300737,  N'2023-03-09',  1450756958461300737,  N'2023-03-09',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (686179008337158144,  N'发送测试',  N'发送测试',  null,  686178183690854400,  686178606145347584,  3,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/wecomService/wecomSendedTested',  N'',  N'0',  1450756958461300737,  N'2023-03-09',  1450756958461300737,  N'2023-03-09',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (686179079862624256,  N'发送记录',  N'发送记录',  null,  686178259356098560,  686178606145347584,  4,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/wecomService/wecomSendRecord',  N'',  N'0',  1450756958461300737,  N'2023-03-09',  1450756958461300737,  N'2023-03-09',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (686179134522793984,  N'发送统计',  N'发送统计',  null,  686178312292409344,  686178606145347584,  5,  N'1',  N'',  N'caidan-3Jmoren',  N'inside',  N'/wecomService/wecomDataStatistics',  N'',  N'0',  1450756958461300737,  N'2023-03-09',  1450756958461300737,  N'2023-03-09',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (697755930116497408,  N'钉钉推送',  N'钉钉推送',  null,  null,  576395294317748224,  10,  N'0',  null,  N'qingqibing_xiaoxipingtai-dingdingtuisong',  N'inside',  N'',  N'',  N'0',  1450756958461300737,'2023-04-10',1450756958461300737,  N'2023-04-10',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (697762708677992448,  N'通道管理',  N'通道管理',  null,  697762187867070464,  697755930116497408,  1,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/dingTalkService/channel',  N'',  N'0',  1450756958461300737,  N'2023-04-10',1450756958461300737,  N'2023-04-10',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (697762824432394240,  N'发送测试',  N'发送测试',  null,  697762370797445120,  697755930116497408,  3,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/dingTalkService/sendTest',  N'',  N'0',  1450756958461300737,  N'2023-04-10',1450756958461300737,  N'2023-04-10',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (697762900781309952,  N'发送记录',  N'发送记录',  null,  697762455014875136,  697755930116497408,  4,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/dingTalkService/sendRecord',  N'',  N'0',  1450756958461300737,  N'2023-04-10',1450756958461300737,  N'2023-04-10',  N'0',  N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES (697762974726889472,  N'发送统计',  N'发送统计',  null,  697762540020834304,  697755930116497408,  5,  N'1',  null,  N'caidan-3Jmoren',  N'inside',  N'/dingTalkService/sendCount',  N'',  N'0',  1450756958461300737,  N'2023-04-10',1450756958461300737,  N'2023-04-10',  N'0',  N'1')
;

INSERT INTO [SYS_MENU] ([MENU_ID],  [MENU_TEXT],  [MENU_ALIAS],  [FUNCTION_MODULE_ID],  [FUNCTION_ID],  [PARENT_ID],  [SEQ],  [IS_LEAF],  [TARGET],  [ICONS],  [OPEN_TYPE],  [PATH],  [COMPONENT],  [MENU_TYPE],  [CREATOR],  [CREATE_TIME],  [LAST_EDITOR],  [LAST_TIME],  [OPEN_MODE],  [IS_SYS]) VALUES ('673554222872272896', N'配置项管理', N'配置项管理', NULL, '673553074966765568', '1450764807862095963', '12', '1', N'', N'caidan-shezhi1', N'inside', N'/bpmConfig', N'', '0', '1450756958461300737', '2023-02-02', '679338378499727360', '2023-04-12', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (688350240998432768, N'岗位管理', N'岗位管理', NULL, 688350053471100928, 521279919444205568, 3, N'1', N'', N'caidan-3Jmoren', N'inside', N'', N'', N'0', 1450756958461300737, '2023-03-15', 1450756958461300737, '2023-03-15', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (713719440226918400, N'资源类型管理', N'资源类型管理', NULL, 713719009941659648, 521288179740057600, 3, N'1', N'', N'caidan-3Jmoren', N'inside', N'/resourceTypeManage', N'', N'0', 1450756958461300737, '2023-04-03', 1450756958461300737, '2023-04-03', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (714433614208835584, N'岗位审核', N'岗位审核', NULL, 714425029546483712, 521279919444205568, 9, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/postAudit/index', N'', N'0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (714488330313801728, N'组织角色审核', N'组织角色审核', NULL, 714488057633710080, 1450764807862095998, 4, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/struRoleVerify', N'', N'0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (714488433812447232, N'岗位角色审核', N'岗位角色审核', NULL, 714488196960100352, 1450764807862095998, 5, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/postRoleAudit', N'', N'0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (714502153053675520, N'用户组织审核', N'用户组织审核', NULL, 714498812294733824, 521280546094194688, 3, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/userOrganizationAudit/index', N'', N'0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (714503357229965312, N'用户岗位审核', N'用户岗位审核', NULL, 714503247842516992, 521280546094194688, 4, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/userPositionAudit/index', N'', N'0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', N'0', N'1')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('706807802378854400', N'表单维护', N'表单维护', NULL, '706807627035975680', '1450764807862095963', '14', '1', NULL, N'caidan-2Jmoren', N'inside', N'/formManager', N'', '0', '1450756958461300737', '2023-05-05', '1450756958461300737', '2023-05-05', '0', '0')
;

INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (734834444426551296, N'工作台banner', N'工作台banner', NULL, 734833871224578048, 1450764807862095954, 12, N'1', NULL, N'caidan_work_banner', N'inside', N'/bannerManage', N'', N'0', 1450756958461300737, '2023-07-21', 1450756958461300737, '2023-07-21', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (735799904773087232, N'组件库维护', N'组件库维护', NULL, 735799387355357184, 1450764807862095954, 13, N'1', NULL, N'caidan_work_assembly', N'inside', N'/componentsLibrary', N'', N'0', 1450756958461300737, '2023-07-24', 1450756958461300737, '2023-07-24', N'0', N'0')
;

INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('544475935899131904', N'任务管理', N'任务管理', NULL, '544475707963875328', '551360495878414336', '2', '1', NULL, N'left-secondary-menu', N'inside', N'/scheduleManagement', N'', '0', '1450756958461300737', '2022-02-11', '1450756958461300737', '2022-03-02', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('544476053125734400', N'任务实例', N'任务实例', NULL, '544475799542308864', '551360495878414336', '3', '1', NULL, N'left-secondary-menu', N'inside', N'/scheduleInstance', N'', '0', '1450756958461300737', '2022-02-11', '1450756958461300737', '2022-03-02', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES ('551360495878414336', N'任务调度', N'任务调度', '-1', '-1', '510503960046739456', '10', '0', N'', N'left-secondary-menu', N'inside', N'', N'', '0', '1450756958461300737', '2022-03-02', '-1', '2022-03-02', N'0', '0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815268878975508480, N'组织机构', N'组织机构', NULL, NULL, 1, 16, N'0', N'', N'caidan_liuchengweituo', N'inside', N'', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815268966238003200, N'组织管理', N'组织管理', NULL, 815300362058866688, 815268878975508480, 1, N'1', N'', N'caidan-2Jmoren', N'inside', N'/organMaintenance1', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815283974485319680, N'用户管理', N'用户管理', NULL, NULL, 1, 17, N'0', NULL, N'caidan-renyuanguanli2', N'inside', N'', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815284118417055744, N'用户维护', N'用户维护', NULL, 815299697123270656, 815283974485319680, 1, N'1', N'', N'caidan-2Jmoren', N'inside', N'/szslUsermanage', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815284389633335296, N'角色管理', N'角色管理', NULL, NULL, 1, 18, N'0', NULL, N'caidan-liucheng3', N'inside', N'', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815284458273120256, N'角色维护', N'角色维护', NULL, 815299769068167168, 815284389633335296, 1, N'1', N'', N'caidan-2Jmoren', N'inside', N'/szslManageRole', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (815284741749350400, N'人员管理', N'人员管理', NULL, 815299398463660032, 815268878975508480, 2, N'1', N'', N'caidan-2Jmoren', N'inside', N'/staffManageAdmin', N'', N'1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', N'0', N'0')
;

INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (819883465473531904, N'模板管理', N'模板管理', NULL, 819883083649261568, 579402999395524608, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/appImService/appImTemplate', N'', N'0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (819883548935987200, N'模板管理', N'模板管理', NULL, 819883155535437824, 579408006685663232, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/appPushService/appPushTemplate', N'', N'0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (819883588052066304, N'模板管理', N'模板管理', NULL, 819883211101577216, 586944248251949056, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/noticeService/noticeSendTemplate', N'', N'0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (819883633023393792, N'模板管理', N'模板管理', NULL, 819883304701665280, 686178606145347584, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/wecomService/wecomTemplate', N'', N'0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (819883670151372800, N'模板管理', N'模板管理', NULL, 819883353598861312, 697755930116497408, 2, N'1', NULL, N'caidan-3Jmoren', N'inside', N'/dingTalk/DingTalkTemplate', N'', N'0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', N'0', N'0')
;
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811885400942714880, N'工具栏横幅', N'工具栏横幅', NULL, 811885124697464832, 820247769980870656, 3, N'1', N'', N'caidan-3Jmoren', N'inside', N'/advertisementSet', N'', N'0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', N'0', N'0');
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811885462225690624, N'浏览量统计', N'浏览量统计', NULL, 811885197636411392, 820247769980870656, 1, N'1', N'', N'caidan-3Jmoren', N'inside', N'/advertisementStatistics', N'', N'0', 1450756958461300737, '2024-02-19', 1450756958461300737, '2024-03-15', N'0', N'0');
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811885505712234496, N'顶部横幅', N'顶部横幅', NULL, 811885249842913280, 820247769980870656, 2, N'1', N'', N'caidan-3Jmoren', N'inside', N'/bannerSet', N'', N'0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', N'0', N'0');
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (811885550977163264, N'工具栏收纳', N'工具栏收纳', NULL, 811885297653784576, 820247769980870656, 4, N'1', N'', N'caidan-3Jmoren', N'inside', N'/storageSet', N'', N'0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', N'0', N'0');
INSERT INTO [SYS_MENU] ([MENU_ID], [MENU_TEXT], [MENU_ALIAS], [FUNCTION_MODULE_ID], [FUNCTION_ID], [PARENT_ID], [SEQ], [IS_LEAF], [TARGET], [ICONS], [OPEN_TYPE], [PATH], [COMPONENT], [MENU_TYPE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [OPEN_MODE], [IS_SYS]) VALUES (820247769980870656, N'广告位配置', N'广告位配置', NULL, NULL, 1450764807862095954, 18, N'0', N'', N'caidan_guanggao', N'inside', N'', N'', N'0', 1450756958461300737, '2024-03-13', 1450756958461300737, '2024-03-13', N'0', N'1');

-- ----------------------------
-- Table structure for SYS_OFFICE
-- ----------------------------


CREATE TABLE [SYS_OFFICE] (
  [OFFICE_ID] NUMERIC(20)  NOT NULL,
  [STRU_ID] NUMERIC(20)  NULL,
  [OFFICE_ALIAS] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [OFFICE_ADDRESS] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_OFFICE] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_OFFICE
-- ----------------------------
ALTER TABLE [SYS_OFFICE] ADD CONSTRAINT [PK__sys_offi__D5DEA77EE4B53889] PRIMARY KEY CLUSTERED ([OFFICE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'组织机构id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE',
'COLUMN', N'OFFICE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'对应的组织结构id（注：不是所属）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE',
'COLUMN', N'STRU_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织机构描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE',
'COLUMN', N'OFFICE_ALIAS'


EXEC sp_addextendedproperty
'MS_Description', N'联系地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE',
'COLUMN', N'OFFICE_ADDRESS'


EXEC sp_addextendedproperty
'MS_Description', N'组织机构扩展表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE'
;


-- ----------------------------
-- Records of SYS_OFFICE
-- ----------------------------
INSERT INTO [SYS_OFFICE] ([OFFICE_ID], [STRU_ID], [OFFICE_ALIAS], [OFFICE_ADDRESS]) VALUES ('1', '1', N'', N'')
;

-- ----------------------------
-- Table structure for SYS_OFFICE_AUDIT
-- ----------------------------


CREATE TABLE [SYS_OFFICE_AUDIT] (
  [OFFICE_ID] NUMERIC(20)  NOT NULL,
  [STRU_ID] NUMERIC(20)  NULL,
  [OFFICE_ALIAS] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [OFFICE_ADDRESS] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [REAL_OFFICE_ID] NUMERIC(20)  NULL
)
;

ALTER TABLE [SYS_OFFICE_AUDIT] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_OFFICE_AUDIT
-- ----------------------------
ALTER TABLE [SYS_OFFICE_AUDIT] ADD CONSTRAINT [PK__sys_offi__D5DEA77E7871F1CA] PRIMARY KEY CLUSTERED ([OFFICE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'组织机构id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT',
'COLUMN', N'OFFICE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'对应的组织结构id（注：不是所属）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT',
'COLUMN', N'STRU_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织机构描述',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT',
'COLUMN', N'OFFICE_ALIAS'


EXEC sp_addextendedproperty
'MS_Description', N'联系地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT',
'COLUMN', N'OFFICE_ADDRESS'


EXEC sp_addextendedproperty
'MS_Description', N'关联SYS_OFFICE表OFFICE_ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT',
'COLUMN', N'REAL_OFFICE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织机构扩展表审核表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_OFFICE_AUDIT'
;


-- ----------------------------
-- Table structure for SYS_ONLINE
-- ----------------------------


CREATE TABLE [SYS_ONLINE] (
  [SESSION_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NULL,
  [USER_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CORPORATION_ID] NUMERIC(20)  NULL,
  [CORPORATION_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [LOGIN_TIME] DATETIME2  NULL,
  [LOGOFF_TIME] DATETIME2  NULL,
  [REMOTEADDR] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMOTEHOST] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMOTEPORT] NVARCHAR(8) COLLATE Chinese_PRC_CI_AS  NULL,
  [BROWSER_TYPE] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [USER_ACCOUNT] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_ONLINE] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ONLINE
-- ----------------------------
ALTER TABLE [SYS_ONLINE] ADD CONSTRAINT [PK__sys_onli__F01748743BFDD5FF] PRIMARY KEY CLUSTERED ([SESSION_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'会话标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'SESSION_ID'


EXEC sp_addextendedproperty
'MS_Description', N'用户账户',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'USER_ID'


EXEC sp_addextendedproperty
'MS_Description', N'用户名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'USER_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'公司编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'CORPORATION_ID'


EXEC sp_addextendedproperty
'MS_Description', N'公司名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'CORPORATION_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'登录时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'LOGIN_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'注销时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'LOGOFF_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'客户端地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'REMOTEADDR'


EXEC sp_addextendedproperty
'MS_Description', N'客户端主机名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'REMOTEHOST'


EXEC sp_addextendedproperty
'MS_Description', N'客户端端口号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'REMOTEPORT'


EXEC sp_addextendedproperty
'MS_Description', N'浏览器类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'BROWSER_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'用户登录账号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE',
'COLUMN', N'USER_ACCOUNT'


EXEC sp_addextendedproperty
'MS_Description', N'在线用户',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE'
;


-- ----------------------------
-- Records of SYS_ONLINE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ONLINE_HIST
-- ----------------------------


CREATE TABLE [SYS_ONLINE_HIST] (
  [HIS_ID] NUMERIC(20)  NOT NULL,
  [TOKEN_ID] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [USER_ID] NUMERIC(20)  NULL,
  [USER_NAME] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [CORPORATION_ID] NUMERIC(20)  NULL,
  [CORPORATION_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [LOGIN_TIME] DATETIME  NULL,
  [LOGOFF_TIME] DATETIME  NULL,
  [REMOTEADDR] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMOTEHOST] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [REMOTEPORT] NVARCHAR(8) COLLATE Chinese_PRC_CI_AS  NULL,
  [BROWSER_TYPE] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [USER_ACCOUNT] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_ONLINE_HIST] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ONLINE_HIST
-- ----------------------------
ALTER TABLE [SYS_ONLINE_HIST] ADD CONSTRAINT [PK__sys_onli__1C2CE46F448BFFEB] PRIMARY KEY CLUSTERED ([HIS_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'HIS_ID'


EXEC sp_addextendedproperty
'MS_Description', N'令牌标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'TOKEN_ID'


EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'USER_ID'


EXEC sp_addextendedproperty
'MS_Description', N'用户名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'USER_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'公司编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'CORPORATION_ID'


EXEC sp_addextendedproperty
'MS_Description', N'公司名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'CORPORATION_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'登录时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'LOGIN_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'注销时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'LOGOFF_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'客户端地址',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'REMOTEADDR'


EXEC sp_addextendedproperty
'MS_Description', N'客户端主机名',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'REMOTEHOST'


EXEC sp_addextendedproperty
'MS_Description', N'客户端端口号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'REMOTEPORT'


EXEC sp_addextendedproperty
'MS_Description', N'浏览器类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'BROWSER_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'用户登录账号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST',
'COLUMN', N'USER_ACCOUNT'


EXEC sp_addextendedproperty
'MS_Description', N'在线用户历史',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ONLINE_HIST'
;


-- ----------------------------
-- Table structure for SYS_ORGAN
-- ----------------------------


CREATE TABLE [SYS_ORGAN] (
  [ORGAN_ID] NUMERIC(20)  NOT NULL,
  [ORGAN_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_FCODE] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_FNAME] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [SHORT_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [WORKPLACE_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [BEGIN_DATE] NCHAR(10) COLLATE Chinese_PRC_CI_AS  NULL,
  [END_DATE] NCHAR(10) COLLATE Chinese_PRC_CI_AS  NULL,
  [SCN] NUMERIC(10)  NULL,
  [DEL_FLAG] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [PARENT_TYPE_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [VALID_TIME_LIMIT_TYPE] NCHAR(1) DEFAULT '0',
  [ORGAN_PROPERTY] NCHAR(1) DEFAULT '0',
  [ORGAN_NAME_PINYIN_FULL] NVARCHAR(200) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_NAME_PINYIN_INITIAL] NVARCHAR(200) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_ORGAN] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ORGAN
-- ----------------------------
ALTER TABLE [SYS_ORGAN] ADD CONSTRAINT [PK__sys_orga__0FD8F0A32501CA08] PRIMARY KEY CLUSTERED ([ORGAN_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'组织编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织代码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'组织名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'全机构编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_FCODE'


EXEC sp_addextendedproperty
'MS_Description', N'全路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_FNAME'

EXEC sp_addextendedproperty
'MS_Description', N'组织简称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'SHORT_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'组织类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'工作地点编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'WORKPLACE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'记录生效日期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'BEGIN_DATE'


EXEC sp_addextendedproperty
'MS_Description', N'记录失效日期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'END_DATE'


EXEC sp_addextendedproperty
'MS_Description', N'对应的系统更改号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'SCN'


EXEC sp_addextendedproperty
'MS_Description', N'使用标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'DEL_FLAG'


EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'不同组织机构类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'PARENT_TYPE_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'组织时效类型：0 长期组织 1 临时组织',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'VALID_TIME_LIMIT_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'组织属性： 0 公司内部组织 1 公司外部组织',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_PROPERTY'

EXEC sp_addextendedproperty
'MS_Description', N'组织结构名称全拼',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_NAME_PINYIN_FULL'

EXEC sp_addextendedproperty
'MS_Description', N'组织结构称首字母拼音',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN',
'COLUMN', N'ORGAN_NAME_PINYIN_INITIAL'

EXEC sp_addextendedproperty
'MS_Description', N'组织机构',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN'
;


-- ----------------------------
-- Records of SYS_ORGAN
-- ----------------------------
INSERT INTO [SYS_ORGAN] ([ORGAN_ID], [ORGAN_CODE], [ORGAN_NAME], [ORGAN_FCODE], [ORGAN_FNAME], [SHORT_NAME], [ORGAN_TYPE], [WORKPLACE_ID], [BEGIN_DATE], [END_DATE], [SCN], [DEL_FLAG], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [PARENT_TYPE_CODE], [ORGAN_NAME_PINYIN_FULL], [ORGAN_NAME_PINYIN_INITIAL]) VALUES (1, N'1', N'金现代信息产业股份有限公司', N'/1/', N'/金现代信息产业股份有限公司', N'金现代', N'1', N'1', N'2018-03-19', N'2019-03-19', -1, N'0', NULL, NULL, NULL, NULL, NULL, N'jinxiandaixinxichanyegufenyouxiangongsi', N'jxdxxcygfyxgs')
;

-- ----------------------------
-- Table structure for SYS_ASYNC_EVENT
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[SYS_ASYNC_EVENT]') AND type IN ('U') AND schema_id = SCHEMA_ID())
DROP TABLE [SYS_ASYNC_EVENT]
;
CREATE TABLE [SYS_ASYNC_EVENT] (
  [SYS_ASYNC_EVENT_ID] NUMERIC(20)  NOT NULL,
  [EVENT_TYPE] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [EVENT] NVARCHAR(2048) COLLATE Chinese_PRC_CI_AS  NULL,
  [STATUS] NCHAR(2)  NULL,
  [RETRY_NUM] NUMERIC(10)  NULL,
  [ERROR_MSG] TEXT  NULL,
  [CLASS_NAME] NVARCHAR(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATE_TIME] DATETIME  NULL,
)
;

ALTER TABLE [SYS_ASYNC_EVENT] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ASYNC_EVENT
-- ----------------------------
ALTER TABLE [SYS_ASYNC_EVENT] ADD CONSTRAINT [PK__SYS_ASYNC_EVENT__SYS_ASYNC_EVENT_ID] PRIMARY KEY CLUSTERED ([SYS_ASYNC_EVENT_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'事件表主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'SYS_ASYNC_EVENT_ID'

EXEC sp_addextendedproperty
'MS_Description', N'事件类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'EVENT_TYPE'

EXEC sp_addextendedproperty
'MS_Description', N'事件内容',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'EVENT'

EXEC sp_addextendedproperty
'MS_Description', N'事件状态，0未消费，1以消费，2消费失败',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'STATUS'

EXEC sp_addextendedproperty
'MS_Description', N'重试次数，默认为0',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'RETRY_NUM'

EXEC sp_addextendedproperty
'MS_Description', N'消费失败原因',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'ERROR_MSG'

EXEC sp_addextendedproperty
'MS_Description', N'实体类名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'CLASS_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'事件创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT',
'COLUMN', N'CREATE_TIME'

EXEC sp_addextendedproperty
'MS_Description', N'事件记录表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ASYNC_EVENT'
;

-- ----------------------------
-- Table structure for SYS_ORGAN_AUDIT
-- ----------------------------
CREATE TABLE [SYS_ORGAN_AUDIT] (
  [ORGAN_ID] NUMERIC(20)  NOT NULL,
  [ORGAN_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_FCODE] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_FNAME] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [SHORT_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [ORGAN_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [WORKPLACE_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [BEGIN_DATE] NCHAR(10) COLLATE Chinese_PRC_CI_AS  NULL,
  [END_DATE] NCHAR(10) COLLATE Chinese_PRC_CI_AS  NULL,
  [SCN] NUMERIC(10)  NULL,
  [IN_USE] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [PARENT_TYPE_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [REAL_ORGAN_ID] NUMERIC(20)  NULL,
  [VALID_TIME_LIMIT_TYPE] NCHAR(1),
  [ORGAN_PROPERTY] NCHAR(1)
)
;

ALTER TABLE [SYS_ORGAN_AUDIT] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ORGAN_AUDIT
-- ----------------------------
ALTER TABLE [SYS_ORGAN_AUDIT] ADD CONSTRAINT [PK__sys_orga__0FD8F0A3AE34B6EB] PRIMARY KEY CLUSTERED ([ORGAN_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'组织编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织代码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'组织名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'全机构编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_FCODE'


EXEC sp_addextendedproperty
'MS_Description', N'全路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_FNAME'


EXEC sp_addextendedproperty
'MS_Description', N'组织简称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'SHORT_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'组织类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'工作地点编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'WORKPLACE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'记录生效日期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'BEGIN_DATE'


EXEC sp_addextendedproperty
'MS_Description', N'记录失效日期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'END_DATE'


EXEC sp_addextendedproperty
'MS_Description', N'对应的系统更改号',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'SCN'


EXEC sp_addextendedproperty
'MS_Description', N'使用标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'IN_USE'


EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'上级类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'PARENT_TYPE_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'关联SYS_ORGAN表organ_id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'REAL_ORGAN_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织时效类型：0 长期组织 1 临时组织',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'VALID_TIME_LIMIT_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'组织属性： 0 公司内部组织 1 公司外部组织',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT',
'COLUMN', N'ORGAN_PROPERTY'


EXEC sp_addextendedproperty
'MS_Description', N'组织机构审核表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_AUDIT'
;


-- ----------------------------
-- Records of SYS_ORGAN_AUDIT
-- ----------------------------


-- ----------------------------
-- Table structure for SYS_ORGAN_TYPE
-- ----------------------------


CREATE TABLE [SYS_ORGAN_TYPE] (
  [TYPE_ID] NUMERIC(20)  NOT NULL,
  [ORGAN_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [TYPE_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_TYPE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [IN_USE] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME2  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME2  NULL,
  [IS_SYSTEM] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [IMG_URL] NVARCHAR(2000) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_ORGAN_TYPE] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_ORGAN_TYPE
-- ----------------------------
ALTER TABLE [SYS_ORGAN_TYPE] ADD CONSTRAINT [PK__sys_orga__922451C85EE2AD06] PRIMARY KEY CLUSTERED ([ORGAN_TYPE])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'TYPE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组织类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'ORGAN_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'组织类型名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'TYPE_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'上级组织类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'PARENT_TYPE'


EXEC sp_addextendedproperty
'MS_Description', N'使用标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'IN_USE'


EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'上次编辑时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'是否系统标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'IS_SYSTEM'


EXEC sp_addextendedproperty
'MS_Description', N'图片url',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE',
'COLUMN', N'IMG_URL'


EXEC sp_addextendedproperty
'MS_Description', N'组织类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_ORGAN_TYPE'
;


-- ----------------------------
-- Records of SYS_ORGAN_TYPE
-- ----------------------------
INSERT INTO [SYS_ORGAN_TYPE] ([TYPE_ID], [ORGAN_TYPE], [TYPE_NAME], [PARENT_TYPE], [IN_USE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [IS_SYSTEM], [IMG_URL]) VALUES ('1', N'1', N'单位', N'0', '1', NULL, '2018-02-27 13:20:16', '1450756958461300737', '2022-10-25 09:08:33.5830000', '1', N'tree-department')
;
INSERT INTO [SYS_ORGAN_TYPE] ([TYPE_ID], [ORGAN_TYPE], [TYPE_NAME], [PARENT_TYPE], [IN_USE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [IS_SYSTEM], [IMG_URL]) VALUES ('2', N'2', N'部门', N'1', '1', NULL, '2018-03-13 09:55:00', '1450756958461300737', '2022-10-25 09:06:07.2740000', '1', N'unit')
;

-- ----------------------------
-- Table structure for SYS_PASSWORD_HIST
-- ----------------------------


CREATE TABLE [SYS_PASSWORD_HIST] (
  [SPH_ID] NUMERIC(20)  NOT NULL,
  [USER_ID] NUMERIC(20)  NULL,
  [PASSWORD] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
)
;

ALTER TABLE [SYS_PASSWORD_HIST] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_PASSWORD_HIST
-- ----------------------------
ALTER TABLE [SYS_PASSWORD_HIST] ADD CONSTRAINT [PK__SYS_PASSWORD_HIST__SPH_ID] PRIMARY KEY CLUSTERED ([SPH_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'主键',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'SPH_ID'

EXEC sp_addextendedproperty
'MS_Description', N'用户ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'USER_ID'


EXEC sp_addextendedproperty
'MS_Description', N'密码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'PASSWORD'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'最后一次更新时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'最后一次更新人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'密码生命周期',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_PASSWORD_HIST'
;

-- ----------------------------
-- Table structure for SYS_RES_TYPE
-- ----------------------------


CREATE TABLE [SYS_RES_TYPE] (
  [RES_TYPE_ID] NUMERIC(20)  NOT NULL,
  [RES_TYPE_NAME] NVARCHAR(64) COLLATE Chinese_PRC_CI_AS  NULL
)
;

ALTER TABLE [SYS_RES_TYPE] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_RES_TYPE
-- ----------------------------
ALTER TABLE [SYS_RES_TYPE] ADD CONSTRAINT [PK__sys_res___CE60089A57CB148C] PRIMARY KEY CLUSTERED ([RES_TYPE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'资源操作类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RES_TYPE',
'COLUMN', N'RES_TYPE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'资源操作类型名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RES_TYPE',
'COLUMN', N'RES_TYPE_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'功能资源类型',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RES_TYPE'
;


-- ----------------------------
-- Records of SYS_RES_TYPE
-- ----------------------------
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('1', N'新增')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('2', N'删除')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('3', N'修改')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('4', N'查询')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('5', N'登入')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('6', N'登出')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('7', N'登录异常')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('8', N'异常日志')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('9', N'配置定制')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('10', N'审计日志维护')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('11', N'密码重置')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('12', N'连接超时')
;
INSERT INTO [SYS_RES_TYPE] ([RES_TYPE_ID], [RES_TYPE_NAME]) VALUES ('13', N'文件上传')
;

-- ----------------------------
-- Table structure for SYS_RESOURCE_MODULES
-- ----------------------------


CREATE TABLE [SYS_RESOURCE_MODULES] (
  [MODULE_ID] NUMERIC(20)  NOT NULL,
  [MODULE_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [MODULE_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [PARENT_MODULE_ID] NUMERIC(20)  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
  [APPLICATION_ID] NUMERIC(20) DEFAULT 1 NULL
)
;

ALTER TABLE [SYS_RESOURCE_MODULES] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Primary Key structure for table SYS_RESOURCE_MODULES
-- ----------------------------
ALTER TABLE [SYS_RESOURCE_MODULES] ADD CONSTRAINT [PK__sys_reso__238A8246C1F94089] PRIMARY KEY CLUSTERED ([MODULE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'MODULE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'模块名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'MODULE_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'模块编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'MODULE_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'上级模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'PARENT_MODULE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'模块排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'SEQ'


EXEC sp_addextendedproperty
'MS_Description', N'创建人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改人',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'所属应用的id，默认1：属于统一权限平台自身数据',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES',
'COLUMN', N'APPLICATION_ID'


EXEC sp_addextendedproperty
'MS_Description', N'资源模块表',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCE_MODULES'
;


-- ----------------------------
-- Records of SYS_RESOURCE_MODULES
-- ----------------------------
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686145111138246656, N'应用管理', N'0215', 1, 19, 1450756958461300737, '2023-03-09 09:35:42', 1450756958461300737, '2023-03-09 09:35:43', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686145219900743680, N'应用管理', N'0216', 686145111138246656, 1, 1450756958461300737, '2023-03-09 09:36:08', 1450756958461300737, '2023-03-09 09:36:09', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686145307951767552, N'应用回收站', N'0217', 686145111138246656, 2, 1450756958461300737, '2023-03-09 09:36:29', 1450756958461300737, '2023-03-09 09:36:30', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (523159524811743232, N'连接池监控', N'0231', 523151528153063424, 3, 1450756958461300737, '2021-12-14 15:29:11', 1450756958461300737, '2021-12-14 15:29:11', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (829675912349197984, N'租户服务注册', N'000000000275', 677468378591666176, 3, 1450756958461300737, '2024-04-08 11:15:52', 1450756958461300737, '2024-04-08 11:15:52', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (581434239535554561, N'数量分析', N'0239', 564389571845169152, 1, 1450756958461300737, '2022-05-24 10:52:05', 1450756958461300737, '2022-05-24 10:52:05', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (830015977810042880, N'流程概览', N'000000000273', 564389571845169152, 2, 1450756958461300737, '2024-04-09 09:47:10', 1450756958461300737, '2024-04-09 09:47:10', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (830016425195479040, N'流程状态分析', N'000000000274', 564389571845169152, 3, 1450756958461300737, '2024-04-09 09:48:57', 1450756958461300737, '2024-04-09 09:48:57', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (830016458288537600, N'流程参与者分析', N'000000000275', 564389571845169152, 4, 1450756958461300737, '2024-04-09 09:49:05', 1450756958461300737, '2024-04-09 09:49:05', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (830016495609454592, N'流程统计分析', N'000000000276', 564389571845169152, 5, 1450756958461300737, '2024-04-09 09:49:14', 1450756958461300737, '2024-04-09 09:49:14', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (830016532078927872, N'流程耗时分析', N'000000000277', 564389571845169152, 6, 1450756958461300737, '2024-04-09 09:49:22', 1450756958461300737, '2024-04-09 09:49:22', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811594090851606528, N'联系人管理', N'000000000273', 576393382897917952, 11, 1450756958461300737, '2024-02-18 13:45:10', 1450756958461300737, '2024-02-18 13:45:10', 1);
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (812025848596275200, N'REST_API', N'000000000274', 576393382897917952, 11, NULL, NULL, NULL, NULL, 1);
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('518447803329159168', N'客户端管理', N'0225', '523151462587703296', '6', '1450756958461300737', '2021-12-01 15:26:29.000', '1450756958461300737', '2021-12-01 15:26:29.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('520204840551587840', N'插件管理', N'0215', '523073800708038656', '11', '1450756958461300737', '2021-12-06 11:48:19.000', '1450756958461300737', '2022-10-21 09:31:33.860', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('521403268396752896', N'统一待办', N'0220', '1', '8', '1450756958461300737', '2021-12-09 19:10:26.000', '1450756958461300737', '2021-12-09 19:10:26.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523064495887884288', N'机构审核', N'0216', '1450765592889004587', '5', '1450756958461300737', '2021-12-14 09:11:34.000', '1450756958461300737', '2021-12-14 09:11:34.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523064540137791488', N'人员审核', N'0217', '1450765592889004587', '6', '1450756958461300737', '2021-12-14 09:11:44.000', '1450756958461300737', '2021-12-14 09:11:44.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523073800708038656', N'开发者中心', N'0219', '1', '5', '1450756958461300737', '2021-12-14 09:48:32.000', '1450756958461300737', '2021-12-14 09:48:32.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523073886045347840', N'功能资源', N'0220', '1450765592889004643', '4', '1450756958461300737', '2021-12-14 09:48:53.000', '1450756958461300737', '2021-12-14 09:48:53.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523074819135381504', N'功能管理', N'0221', '523073886045347840', '4', '1450756958461300737', '2021-12-14 09:52:35.000', '1450756958461300737', '2021-12-14 09:52:35.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523075074186813440', N'系统参数', N'0222', '523073800708038656', '3', '1450756958461300737', '2021-12-14 09:53:36.000', '1450756958461300737', '2021-12-14 09:53:36.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523151199034417152', N'运维监控中心', N'0224', '1', '6', '1450756958461300737', '2021-12-14 14:56:06.000', '1450756958461300737', '2021-12-14 14:56:06.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523151462587703296', N'运维工具', N'0225', '523151199034417152', '1', '1450756958461300737', '2021-12-14 14:57:08.000', '1450756958461300737', '2021-12-14 14:57:08.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523151528153063424', N'平台监控', N'0226', '523151199034417152', '2', '1450756958461300737', '2021-12-14 14:57:24.000', '1450756958461300737', '2021-12-14 14:57:24.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523151563456520192', N'平台日志', N'0227', '523151199034417152', '3', '1450756958461300737', '2021-12-14 14:57:32.000', '1450756958461300737', '2021-12-14 14:57:32.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523156050359361536', N'缓存监控', N'0229', '523151528153063424', '2', '1450756958461300737', '2021-12-14 15:15:22.000', '1450756958461300737', '2021-12-14 15:15:22.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523159993936257024', N'慢SQL诊断', N'0232', '523151528153063424', '5', '1450756958461300737', '2021-12-14 15:31:02.000', '1450756958461300737', '2021-12-14 15:31:02.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523176962186027008', N'流程中心', N'0233', '1', '3', '1450756958461300737', '2021-12-14 16:38:28.000', '1450756958461300737', '2022-10-20 10:14:51.567', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523177185453023232', N'流程管理', N'0234', '523176962186027008', '1', '1450756958461300737', '2021-12-14 16:39:21.000', '1450756958461300737', '2022-10-21 09:38:35.247', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523177216750919680', N'实例管理', N'0235', '523176962186027008', '2', '1450756958461300737', '2021-12-14 16:39:29.000', '1450756958461300737', '2022-10-20 10:14:52.523', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523177259834810368', N'任务管理', N'0236', '523176962186027008', '3', '1450756958461300737', '2021-12-14 16:39:39.000', '1450756958461300737', '2022-10-20 10:14:52.647', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523177287164895232', N'函数管理', N'0237', '523176962186027008', '4', '1450756958461300737', '2021-12-14 16:39:45.000', '1450756958461300737', '2022-10-20 10:14:52.920', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('523182161856307200', N'系统资源', N'0238', '1', '9', '1450756958461300737', '2021-12-14 16:59:08.000', '1450756958461300737', '2021-12-14 16:59:08.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('526116987680858112', N'跳转', N'0234', '1', '17', '1450756958461300737', '2021-12-22 19:21:05.000', '1450756958461300737', '2021-12-22 19:23:03.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('526117093318598656', N'跳转', N'0236', '526116987680858112', '1', '1450756958461300737', '2021-12-22 19:21:30.000', '1450756958461300737', '2021-12-22 19:21:30.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('526435626275577856', N'我的公告', N'0237', '1450765592889004662', '6', '525273972338860032', '2021-12-23 16:27:14.000', '525273972338860032', '2021-12-23 16:27:14.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('528148114998304768', N'统一待办', N'0215', '523073800708038656', '4', NULL, '2021-12-28 09:52:03.000', NULL, '2021-12-28 09:52:03.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('528148369617723392', N'应用注册', N'0217', '528148114998304768', '1', NULL, '2021-12-28 09:53:04.000', NULL, '2021-12-28 09:53:04.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('535768124604293120', N'审计查阅', N'0227', '523151563456520192', '4', '1450756958461300737', '2022-01-18 10:31:15.000', '1450756958461300737', '2022-01-18 10:31:15.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('544468727815741440', N'主题配置', N'0215', '523073800708038656', '12', '1450756958461300737', '2022-02-11 10:44:20.000', '1450756958461300737', '2022-02-11 10:44:20.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('544474526055145472', N'任务管理', N'0221', '523151462587703296', '8', '1450756958461300737', '2022-02-11 11:07:23.000', '1450756958461300737', '2022-02-11 11:07:23.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('544474679767998464', N'任务实例', N'0222', '523151462587703296', '9', '1450756958461300737', '2022-02-11 11:08:00.000', '1450756958461300737', '2022-02-11 11:08:00.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('545564576406839296', N'统一日志', N'0215', '523151563456520192', '18', '1450756958461300737', '2022-07-01 11:20:41.000', '1450756958461300737', '2022-07-01 11:20:41.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('546336605821214720', N'应用管理', N'0216', '523151462587703296', '10', '1450756958461300737', '2022-02-16 14:26:37.000', '1450756958461300737', '2022-02-16 14:26:37.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('564389571845169152', N'流程分析', N'0215', '523176962186027008', '5', '1450756958461300737', '2022-04-07 10:02:40.000', '1450756958461300737', '2022-10-20 10:14:53.400', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576393382897917952', N'消息中心', N'0217', '1', '18', '1450756958461300737', '2022-05-10 13:01:31.000', '1450756958461300737', '2022-05-10 13:01:31.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576437727940321280', N'委托已办', N'0269', '1450765592889004662', '8', NULL, '2022-05-10 00:00:00.000', NULL, '2022-05-10 00:00:00.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576443985825112064', N'短信推送', N'0220', '576393382897917952', '1', '1450756958461300737', '2022-05-10 16:22:36.000', '1450756958461300737', '2022-05-10 16:22:36.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576446323717578752', N'委托待办', N'0272', '1450765592889004662', '7', NULL, '2022-05-10 00:00:00.000', NULL, '2022-05-10 00:00:00.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('576919005307346944', N'邮件推送', N'0222', '576393382897917952', '2', '1450756958461300737', '2022-05-11 23:50:10.000', '1450756958461300737', '2022-05-11 23:50:10.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('578221171997417472', N'微信公众号推送', N'0227', '576393382897917952', '3', '1450756958461300737', '2022-05-15 14:04:30.000', '1450756958461300737', '2022-05-15 14:04:30.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('579399930809163776', N'IM推送', N'0228', '576393382897917952', '4', '1450756958461300737', '2022-05-18 20:08:28.000', '1450756958461300737', '2022-05-18 20:08:28.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('579405620386734080', N'APP通知推送', N'0229', '576393382897917952', '5', '1450756958461300737', '2022-05-18 20:31:05.000', '1450756958461300737', '2022-05-18 20:31:05.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('581434239535554560', N'数量分析', N'0239', '564389571845169152', '1', '1450756958461300737', '2022-05-24 10:52:05.000', '1450756958461300737', '2022-10-20 10:14:53.770', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('587706862284316672', N'内部通知推送', N'0236', '576393382897917952', '6', '1450756958461300737', '2022-06-10 18:17:15.000', '1450756958461300737', '2022-06-10 18:17:15.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('587942618739253248', N'统一接口', N'0237', '576393382897917952', '7', '1450756958461300737', '2022-06-11 09:54:04.000', '1450756958461300737', '2022-06-11 09:54:04.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('592385645452992512', N'日志告警', N'0217', '523151528153063424', '6', '1450756958461300737', '2022-06-23 09:04:45.000', '1450756958461300737', '2022-06-23 09:04:45.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('595571579120001024', N'移动门户配置', N'0215', '1450765592889004633', '7', '1450756958461300737', '2022-07-02 11:08:50.000', '1450756958461300737', '2022-07-02 11:08:50.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('596352625377812480', N'应用管理', N'0249', '576393382897917952', '8', '1450756958461300737', '2022-07-04 14:52:26.000', '1450756958461300737', '2022-07-04 14:52:26.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004578', N'人员管理', N'103', '1450765592889004587', '2', NULL, NULL, '1450756958461300737', '2021-12-14 09:10:05.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004583', N'日志监控', N'日志监控', '1450765592889004609', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004587', N'组织机构', N'0140', '1450765592889004643', '1', NULL, NULL, '1450756958461300737', '2021-12-14 09:05:49.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004593', N'字典管理', N'字典管理', '523151462587703296', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004597', N'我的催办', N'00250094', '1450765592889004662', '3', NULL, '2020-08-12 01:53:41.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004598', N'待办事件', N'00250012', '1450765592889004662', '1', NULL, '2018-04-20 18:02:26.000', NULL, '2018-06-11 18:19:18.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004599', N'个人信息', N'208', '1450765592889004738', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004602', N'重置密码', N'207', '523151462587703296', '2', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004603', N'已办事件', N'00250013', '1450765592889004662', '2', NULL, '2018-04-20 18:04:04.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004609', N'日志下载', N'0143', '523151563456520192', '2', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004610', N'自定义编码规则', N'10001', '523075074186813440', '2', NULL, NULL, '1450756958461300737', '2021-12-14 09:56:33.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004611', N'工作日维护', N'null0034', '523151462587703296', '5', NULL, '2018-05-17 15:24:50.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004614', N'附件监控', N'附件监控', '1450765592889004661', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004616', N'菜单配置', N'菜单维护', '1450765592889004633', '1', NULL, NULL, '1450756958461300737', '2021-12-14 09:30:56.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004621', N'性能监控', N'性能监控', '523156050359361536', '2', NULL, NULL, '1450756958461300737', '2021-12-15 11:21:07.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004623', N'快捷功能配置', N'02010208', '1450765592889004633', '2', NULL, '2021-06-23 11:37:51.000', '1450756958461300737', '2021-12-14 09:29:59.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004628', N'角色管理', N'0144', '1450765592889004643', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004630', N'资源管理', N'资源维护', '523073886045347840', '3', NULL, NULL, '1450756958461300737', '2021-12-14 09:50:25.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004631', N'授权信息', N'00700078', '523075074186813440', '3', NULL, '2018-06-26 08:54:37.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004632', N'我的委托', N'00250093', '1450765592889004662', '5', NULL, '2020-10-30 13:02:28.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004633', N'门户配置中心', N'0201', '1', '2', NULL, '2021-06-23 11:10:37.000', '1450756958461300737', '2021-12-14 09:30:42.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004643', N'组织权限中心', N'0001', '1', '1', NULL, NULL, '1450756958461300737', '2021-12-14 09:05:20.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004651', N'用户审核', N'00760090', '1450765592889004753', '2', NULL, '2019-08-16 10:12:59.000', '1450756958461300737', '2021-12-14 09:17:37.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004653', N'类型定义', N'101', '1450765592889004587', '3', NULL, NULL, '1450756958461300737', '2021-12-14 09:06:21.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004658', N'运行参数配置', N'00040094', '523075074186813440', '1', NULL, '2019-08-16 10:28:24.000', '1450756958461300737', '2021-12-14 09:55:10.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004660', N'系统监控', N'00260016', '523151528153063424', '4', NULL, '2018-04-23 13:32:11.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004661', N'附件监控', N'0146', '1450765592889004663', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004662', N'个人事项', N'0025', '1', '7', NULL, '2018-04-20 18:02:13.000', NULL, '2018-06-11 18:19:09.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004663', N'服务治理', N'0005', '523182161856307200', '9', NULL, NULL, NULL, '2018-10-25 14:56:45.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004670', N'欢迎页配置', N'02010207', '1450765592889004633', '5', NULL, '2021-06-23 11:37:35.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004671', N'系统管理', N'0004', '523182161856307200', '8', NULL, NULL, NULL, '2018-10-25 14:56:26.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004686', N'权限管理', N'0002', '523182161856307200', '7', NULL, NULL, '1450756958461300737', '2021-12-14 09:48:23.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004689', N'登录页配置', N'02010203', '1450765592889004633', '3', NULL, '2021-06-23 11:36:30.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004693', N'机构维护', N'102', '1450765592889004587', '1', NULL, NULL, '1450756958461300737', '2021-12-14 09:08:11.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004698', N'规则定义', N'104', '1450765592889004587', '4', NULL, NULL, '1450756958461300737', '2021-12-14 09:06:33.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004699', N'用户角色审核', N'204', '1450765592889004628', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004700', N'在线用户', N'505', '523151528153063424', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004701', N'日志下载', N'null0078', '1450765592889004609', '2', NULL, '2018-08-29 19:05:39.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004711', N'我的传阅', N'00250095', '1450765592889004662', '4', NULL, '2020-08-12 01:55:18.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004718', N'在线历史记录', N'506', '523151563456520192', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004725', N'不相容角色集', N'203', '1450765592889004628', '2', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004726', N'欢迎页配置', N'00040084', '1450765592889004671', '7', NULL, '2018-10-25 15:01:51.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004732', N'框架页配置', N'02010204', '1450765592889004633', '4', NULL, '2021-06-23 11:36:51.000', NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004735', N'修改密码', N'206', '1450765592889004738', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004737', N'用户维护', N'201', '1450765592889004753', '1', NULL, NULL, '1450756958461300737', '2021-12-14 09:15:35.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004738', N'自助服务', N'0147', '1450765592889004686', '3', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004740', N'角色维护', N'202', '1450765592889004628', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004746', N'解冻密码', N'null0139', '523151462587703296', '3', NULL, '2019-02-21 16:01:08.000', NULL, '2019-02-21 16:03:21.000', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004753', N'用户管理', N'0142', '1450765592889004643', '2', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('1450765592889004756', N'审计日志', N'507', '523151563456520192', '1', NULL, NULL, NULL, NULL, 1)
;
INSERT INTO [SYS_RESOURCE_MODULES]([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (641241402218651648, N'数据迁移', N'0216', 523151199034417152, 4, 1450756958461300737, '2022-11-05 11:44:24', 1450756958461300737, '2022-11-05 11:44:24', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (686174195188768768, N'企业微信推送', N'0220', 576393382897917952, 9, 1450756958461300737, N'2023-03-09 11:31:17', 1450756958461300737, N'2023-03-09 11:31:17', 1)
;

INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707894950096019456, '组件高级功能', '0217', 523073800708038656, 13, 1450756958461300737, '2023-05-08 10:01:48', 1450756958461300737, '2023-05-08 10:01:48', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707896268520955904, '数据表格', '0221', 707894950096019456, 1, 1450756958461300737, '2023-05-08 10:07:02', 1450756958461300737, '2023-05-08 10:07:02', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707896359877091328, '自定义显示方案', '0222', 707896268520955904, 1, 1450756958461300737, '2023-05-08 10:07:24', 1450756958461300737, '2023-05-08 10:07:24', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707896444421677056, '筛选方案', '0223', 707896268520955904, 2, 1450756958461300737, '2023-05-08 10:07:44', 1450756958461300737, '2023-05-08 10:07:44', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (697758207757787136,  N'钉钉推送',  N'0215',  576393382897917952,  10,  1450756958461300737,  N'2023-04-10 10:42:00',  1450756958461300737,  N'2023-04-10 10:42:00', 1)
;

INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('673548858558783488', N'工作流配置项管理', '0218', '523176962186027008', '6', '1450756958461300737', '2023-02-02 15:22:42', '1450756958461300737', '2023-02-02 15:22:42', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (688348352496279552, N'岗位管理', N'0218', 1450765592889004587, 7, 1450756958461300737, '2023-03-15 11:30:36', 1450756958461300737, '2023-03-15 11:30:36', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714502896477282304, N'用户岗位审核', N'0225', 1450765592889004753, 1, 1450756958461300737, '2023-05-26 15:39:25', 1450756958461300737, '2023-05-26 15:39:25', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714498130460286976, N'用户组织审核', N'0222', 1450765592889004753, 1, 1450756958461300737, '2023-05-26 15:20:29', 1450756958461300737, '2023-05-26 15:20:29', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714487678439268352, N'岗位角色审核', N'0221', 1450765592889004628, 1, 1450756958461300737, '2023-05-26 14:38:57', 1450756958461300737, '2023-05-26 14:38:57', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (714486973070581760, N'组织角色审核', N'0220', 1450765592889004628, 1, 1450756958461300737, '2023-05-26 14:36:09', 1450756958461300737, '2023-05-26 14:36:28', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (688348425015795712, N'岗位审核', N'0219', 1450765592889004587, 8, 1450756958461300737, '2023-03-15 11:30:53', 1450756958461300737, '2023-03-15 11:30:53', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (713718810095656960, N'资源类型管理', N'0225', 523073886045347840, 5, 1450756958461300737, '2023-06-15 18:57:40', 1450756958461300737, '2023-06-15 18:57:40', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES ('706807109840543744', N'表单维护', '0215', '523176962186027008', '8', '1450756958461300737', '2023-05-05 09:59:07', '1450756958461300737', '2023-05-05 09:59:07', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707896268520955910, '树形控件', '0221', 707894950096019456, 1, 1450756958461300737, '2023-05-08 10:07:02', 1450756958461300737, '2023-05-08 10:07:02', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (707896359877091330, '历史记录信息方案', '0222', 707896268520955910, 1, 1450756958461300737, '2023-05-08 10:07:24', 1450756958461300737, '2023-05-08 10:07:24', 1)
;

INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (738861534167703552, N'新闻资讯', N'0216', 1, 20, 1450756958461300737, '2023-08-01 20:51:57', 1450756958461300737, '2023-08-01 20:51:57', 1)
;


INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (734832488207360000, N'工作台banner', N'0223', 1450765592889004633, 8, 1450756958461300737, '2023-07-21 18:01:58', 1450756958461300737, '2023-07-21 18:01:58', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (735797215649603584, N'组件库维护', N'0224', 1450765592889004633, 9, 1450756958461300737, '2023-07-24 09:55:27', 1450756958461300737, '2023-07-24 09:55:27', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES  (707896359877091375, '排序方案', '0224', 707896268520955904, 1, 1450756958461300737, '2023-05-08 10:07:24', 1450756958461300737, '2023-05-08 10:07:24',1);
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815518757266137088, N'分级管理', N'000000000281', 1, 24, 1450756958461300737, '2024-02-29 09:40:23', 1450756958461300737, '2024-02-29 09:40:23', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815298858337968128, N'人员管理', N'000000000280', 815285382546726912, 2, 1450756958461300737, '2024-02-28 19:06:35', 1450756958461300737, '2024-02-28 19:06:35', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815298825416876032, N'组织管理', N'000000000279', 815285382546726912, 1, 1450756958461300737, '2024-02-28 19:06:27', 1450756958461300737, '2024-02-28 19:06:27', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815298111118516224, N'角色维护', N'000000000278', 815297624935768064, 1, 1450756958461300737, '2024-02-28 19:03:37', 1450756958461300737, '2024-02-28 19:03:37', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815298075383046144, N'用户维护', N'000000000277', 815289996381790208, 1, 1450756958461300737, '2024-02-28 19:03:29', 1450756958461300737, '2024-02-28 19:03:29', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815297624935768064, N'角色管理', N'000000000276', 1, 23, 1450756958461300737, '2024-02-28 19:01:41', 1450756958461300737, '2024-02-28 19:01:41', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815289996381790208, N'用户管理', N'000000000275', 1, 22, 1450756958461300737, '2024-02-28 18:31:22', 1450756958461300737, '2024-02-28 18:31:22', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (815285382546726912, N'组织机构', N'000000000274', 1, 21, 1450756958461300737, '2024-02-28 18:13:02', 1450756958461300737, '2024-02-28 18:13:02', 1)
;
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811884652779544576, N'工具栏收纳', N'000000000276', 1450765592889004633, 13, 1450756958461300737, '2024-02-19 08:59:45', 1450756958461300737, '2024-02-19 08:59:45', 1);
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811884606541537280, N'顶部横幅', N'000000000275', 1450765592889004633, 12, 1450756958461300737, '2024-02-19 08:59:34', 1450756958461300737, '2024-02-19 08:59:34', 1);
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811884562585231360, N'浏览量统计', N'000000000274', 1450765592889004633, 11, 1450756958461300737, '2024-02-19 08:59:24', 1450756958461300737, '2024-02-19 08:59:24', 1);
INSERT INTO [SYS_RESOURCE_MODULES] ([MODULE_ID], [MODULE_NAME], [MODULE_CODE], [PARENT_MODULE_ID], [SEQ], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [APPLICATION_ID]) VALUES (811884527244025856, N'广告位配置', N'000000000273', 1450765592889004633, 10, 1450756958461300737, '2024-02-19 08:59:15', 1450756958461300737, '2024-02-19 08:59:15', 1);

-- ----------------------------
-- Table structure for SYS_RESOURCES
-- ----------------------------


CREATE TABLE [SYS_RESOURCES] (
  [RESOURCE_ID] NUMERIC(20)  NOT NULL,
  [RESOURCE_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [RESOURCE_ALIAS] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [MODULE_ID] NUMERIC(20)  NULL,
  [PATH] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [COMPONENT] NVARCHAR(256) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_AUDIT] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [RES_TYPE_ID] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [SEQ] NUMERIC(10)  NULL,
  [IS_REPEAT_AUTHENTICATE] sysname  NOT NULL,
  [STRATEGY] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [KEEP_ALIVE] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [CREATOR] NUMERIC(20)  NULL,
  [CREATE_TIME] DATETIME  NULL,
  [LAST_EDITOR] NUMERIC(20)  NULL,
  [LAST_TIME] DATETIME  NULL,
  [RESOURCE_CODE] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [URL_NAMES] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [PERMISSIONS] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [IS_SYS] NCHAR(1) COLLATE Chinese_PRC_CI_AS  NULL,
  [SERVICE_NAME] NVARCHAR(128) COLLATE Chinese_PRC_CI_AS  NULL,
  [USER_RIGHTS] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [DEPT_RIGHTS] NVARCHAR(32) COLLATE Chinese_PRC_CI_AS  NULL,
  [MAPPER] NVARCHAR(1024) COLLATE Chinese_PRC_CI_AS  NULL,
  [APPLICATION_ID] NUMERIC(20) DEFAULT 1 NULL,
  [PARENT_RESOURCE_ID] NUMERIC(20) NULL
)
;

ALTER TABLE [SYS_RESOURCES] SET (LOCK_ESCALATION = TABLE)
;

-- ----------------------------
-- Indexes structure for table SYS_RESOURCES
-- ----------------------------
CREATE NONCLUSTERED INDEX [RESOURCE_ID]
ON [SYS_RESOURCES] (
  [RESOURCE_ID] ASC
)
;


-- ----------------------------
-- Primary Key structure for table SYS_RESOURCES
-- ----------------------------
ALTER TABLE [SYS_RESOURCES] ADD CONSTRAINT [PK__sys_reso__C4721CBE480A6C38] PRIMARY KEY CLUSTERED ([RESOURCE_ID])
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
ON [PRIMARY]
;

DECLARE @SCHEMA SYSNAME
SET @SCHEMA = SCHEMA_NAME()

EXEC sp_addextendedproperty
'MS_Description', N'资源编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'RESOURCE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'资源英文名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'RESOURCE_NAME'


EXEC sp_addextendedproperty
'MS_Description', N'资源业务语义',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'RESOURCE_ALIAS'


EXEC sp_addextendedproperty
'MS_Description', N'所属模块ID',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'MODULE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'组件根路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'PATH'


EXEC sp_addextendedproperty
'MS_Description', N'组件引入路径',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'COMPONENT'


EXEC sp_addextendedproperty
'MS_Description', N'是否执行审计操作',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'IS_AUDIT'


EXEC sp_addextendedproperty
'MS_Description', N'资源操作类型编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'RES_TYPE_ID'


EXEC sp_addextendedproperty
'MS_Description', N'资源排序',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'SEQ'


EXEC sp_addextendedproperty
'MS_Description', N'是否二次验证',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'IS_REPEAT_AUTHENTICATE'


EXEC sp_addextendedproperty
'MS_Description', N'使用场景（-1：重启，3：预览，2：生产）',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'STRATEGY'


EXEC sp_addextendedproperty
'MS_Description', N'页面激活状态',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'KEEP_ALIVE'


EXEC sp_addextendedproperty
'MS_Description', N'创建者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'CREATOR'


EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'CREATE_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改者',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'LAST_EDITOR'


EXEC sp_addextendedproperty
'MS_Description', N'最后修改时间',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'LAST_TIME'


EXEC sp_addextendedproperty
'MS_Description', N'资源编码',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'RESOURCE_CODE'


EXEC sp_addextendedproperty
'MS_Description', N'URL名称',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'URL_NAMES'


EXEC sp_addextendedproperty
'MS_Description', N'权限标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'PERMISSIONS'


EXEC sp_addextendedproperty
'MS_Description', N'是否是系统资源',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'IS_SYS'


EXEC sp_addextendedproperty
'MS_Description', N'服务标识',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'SERVICE_NAME'

EXEC sp_addextendedproperty
'MS_Description', N'用户权限字段',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'USER_RIGHTS'

EXEC sp_addextendedproperty
'MS_Description', N'机构权限字段',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'DEPT_RIGHTS'

EXEC sp_addextendedproperty
'MS_Description', N'数据查询方法',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'MAPPER'

EXEC sp_addextendedproperty
'MS_Description', N'所属应用的id，默认1：属于统一权限平台自身数据',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'APPLICATION_ID'

EXEC sp_addextendedproperty
'MS_Description', N'上级资源id',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES',
'COLUMN', N'PARENT_RESOURCE_ID'

EXEC sp_addextendedproperty
'MS_Description', N'功能资源',
'SCHEMA', @SCHEMA,
'TABLE', N'SYS_RESOURCES'
;



-- ----------------------------
-- Records of SYS_RESOURCES
-- ----------------------------
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (707898381187686401, N'设置默认', N'设置默认', 707896444421677056, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', N'02230506', N'/hussarBase/queryInfoTable/defaultCondition', N'hussarBase:queryInfoTable:defaultCondition', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (707899978189905921, N'取消默认', N'取消默认', 707896444421677056, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', N'02230507', N'/hussarBase/queryInfoTable/cancel', N'hussarBase:queryInfoTable:cancel', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004221, N'连接池监控', N'连接池监控', 523159524811743232, N'/poolMonitor', N'HussarOperations/src/views/service/poolMonitor/index', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-04-24 08:58:15', NULL, NULL, N'002600170044', N'/druid', N'druid:druid', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (686146166286721024, N'应用管理', N'应用管理', 686145219900743680, N'/appManage', N'HussarApplication/src/views/appManagement', N'0', N'res_menu', 1, N'0', N'1', N'0', 1450756958461300737, '2023-03-09 09:39:54', 1450756958461300737, '2023-03-09 13:47:19', N'02160502', N'', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (686146454410240000, N'应用回收站', N'应用回收站', 686145307951767552, N'/RecycleBin', N'HussarApplication/src/views/recycleBin', N'0', N'res_menu', 1, N'0', N'1', N'0', 1450756958461300737, '2023-03-09 09:41:03', 1450756958461300737, '2023-03-09 13:47:34', N'02170503', N'', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689798, N'新增微应用配置', N'新增微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 4, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160509', N'/hussarBase/application/micro/addConf', N'hussarBase:application:micro:addConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689799, N'修改微应用配置', N'修改微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 5, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160510', N'/hussarBase/application/micro/editConf', N'hussarBase:application:micro:editConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689800, N'查询微应用配置', N'查询微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 6, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160511', N'/hussarBase/application/micro/searchConf', N'hussarBase:application:micro:searchConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689801, N'删除微应用配置', N'删除微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 7, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160512', N'/hussarBase/application/micro/deleteConf', N'hussarBase:application:micro:deleteConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689802, N'查看微应用配置', N'查看微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 8, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160513', N'/hussarBase/application/micro/viewConf', N'hussarBase:application:micro:viewConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689803, N'永久删除微应用配置', N'永久删除微应用配置', 686145219900743680, N'', N'', N'0', N'res_btn', 9, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160514', N'/hussarBase/application/micro/deleteCOnfForever', N'hussarBase:application:micro:deleteCOnfForever', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1594592180406689804, N'新增操作记录', N'新增操作记录', 686145219900743680, N'', N'', N'0', N'res_btn', 10, N'0', N'0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', N'02160515', N'/hussarBase/application/micro/addRecord', N'hussarBase:application:micro:addRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (832213263382224896, N'人员流程图表查询', N'人员流程图表查询', 581434239535554561, N'', N'', N'0', N'res_btn', 15, N'0', N'0', N'0', 1450756958461300737, '2024-04-15 11:18:24', 1450756958461300737, '2024-04-15 11:18:24', N'0239000005070154', N'/bpm/processCount/queryMultiPersonProcessList', N'bpm:processCount:queryMultiPersonProcessList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (832213414490415104, N'人员下钻到对应的流程', N'人员下钻到对应的流程', 581434239535554561, N'', N'', N'0', N'res_btn', 16, N'0', N'0', N'0', 1450756958461300737, '2024-04-15 11:19:00', 1450756958461300737, '2024-04-15 11:19:00', N'0239000005070155', N'/bpm/processCount/querySinglePersonProcessList', N'bpm:processCount:querySinglePersonProcessList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (832213491925655552, N'流程下钻到节点的审批数和撤回数', N'流程下钻到节点的审批数和撤回数', 581434239535554561, N'', N'', N'0', N'res_btn', 17, N'0', N'0', N'0', 1450756958461300737, '2024-04-15 11:19:18', 1450756958461300737, '2024-04-15 11:19:18', N'0239000005070156', N'/bpm/processCount/querySinglePersonProcessTaskList', N'bpm:processCount:querySinglePersonProcessTaskList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;

INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (831116364617097216, N'模糊查询机构列表', N'模糊查询机构列表', 815518757266137088, N'', N'', N'0', N'res_rights', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-12 10:39:43', 1450756958461300737, '2024-04-12 10:39:43', N'000000000281000005070248', N'', N'', N'0', N'', N'data_holder', N'str.STRU_ID', N'com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper.searchOrganization', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830797989605023744, N'删除联系人', N'删除联系人', 811594090851606528, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-11 13:34:36', 1450756958461300737, '2024-04-11 13:34:36', N'000000000273000005070156', N'/msg/contact/deleteMsgContact', N'msg:contact:deleteMsgContact', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830797745085489152, N'修改联系人', N'修改联系人', 811594090851606528, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-11 13:33:38', 1450756958461300737, '2024-04-11 13:33:38', N'000000000273000005070155', N'/msg/contact/updateMsgContact', N'msg:contact:updateMsgContact', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830771482190946304, N'新增联系人', N'新增联系人', 811594090851606528, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-11 11:49:16', 1450756958461300737, '2024-04-11 11:49:16', N'000000000273000005070154', N'/msg/contact/addMsgContact', N'msg:contact:addMsgContact', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829396173050880000, N'excel导出导入记录保存', N'excel导出导入记录保存', 1450765592889004693, N'', N'', N'0', N'res_btn', 29, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 16:44:17', 1450756958461300737, '2024-04-07 16:44:17', N'102000005070156', N'/hussarBase/excel/newExcelTask', N'hussarBase:excel:newExcelTask', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829397564452511744, N'获取导入导出信息列表', N'获取导入导出信息列表', 1450765592889004693, N'', N'', N'0', N'res_btn', 30, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 16:49:49', 1450756958461300737, '2024-04-07 16:49:49', N'102000005070157', N'/hussarBase/excel/searchExcelTask', N'hussarBase:excel:searchExcelTask', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829397905482981376, N'excel文件下载', N'excel文件下载', 1450765592889004693, N'', N'', N'0', N'res_btn', 31, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 16:51:10', 1450756958461300737, '2024-04-07 16:51:10', N'102000005070158', N'/hussarBase/excel/downloadExcelFile', N'hussarBase:excel:downloadExcelFile', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829405596385288192, N'分页查询人员列表(表格)', N'分页查询人员列表(表格)', 1450765592889004578, N'', N'', N'0', N'res_btn', 23, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:21:44', 1450756958461300737, '2024-04-07 17:21:44', N'103000005070161', N'/hussarBase/authorization/staff/list', N'hussarBase:authorization:staff:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829406184619646976, N'保存人员排序', N'保存人员排序', 1450765592889004578, N'', N'', N'0', N'res_btn', 24, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:24:04', 1450756958461300737, '2024-04-07 17:24:04', N'103000005070162', N'/hussarBase/authorization/staff/sortUnifyStaff', N'hussarBase:authorization:staff:sortUnifyStaff', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829409027523092480, N'查询岗位列表数据', N'查询岗位列表数据', 688348352496279552, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:35:22', 1450756958461300737, '2024-04-07 17:35:22', N'0218000005070163', N'/hussarBase/authorization/post/pageList', N'hussarBase:authorization:post:pageList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829409275322572800, N'新增岗位', N'新增岗位', 688348352496279552, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:36:21', 1450756958461300737, '2024-04-07 17:36:21', N'0218000005070164', N'/hussarBase/authorization/post/add', N'hussarBase:authorization:post:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829409533184188416, N'修改岗位', N'修改岗位', 688348352496279552, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:37:22', 1450756958461300737, '2024-04-07 17:37:22', N'0218000005070165', N'/hussarBase/authorization/post/edit', N'hussarBase:authorization:post:edit', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829409805990109184, N'删除岗位', N'删除岗位', 688348352496279552, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 17:38:27', 1450756958461300737, '2024-04-07 17:38:27', N'0218000005070166', N'/hussarBase/authorization/post/delete', N'hussarBase:authorization:post:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829416135417143296, N'保存角色岗位', N'保存角色岗位', 1450765592889004740, N'', N'', N'0', N'res_btn', 26, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:03:36', 1450756958461300737, '2024-04-07 18:03:36', N'202000005070167', N'/hussarBase/authorization/permit/role/savePost', N'hussarBase:authorization:permit:role:savePost', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829418436286488576, N'保存角色组织', N'保存角色组织', 1450765592889004740, N'', N'', N'0', N'res_btn', 27, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:12:45', 1450756958461300737, '2024-04-07 18:12:45', N'202000005070168', N'/hussarBase/authorization/permit/role/saveOrgan', N'hussarBase:authorization:permit:role:saveOrgan', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829418705640497152, N'角色关联用户批量查询', N'角色关联用户批量查询', 1450765592889004740, N'', N'', N'0', N'res_btn', 28, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:13:49', 1450756958461300737, '2024-04-07 18:13:49', N'202000005070169', N'/roleManagerFront/searchUserListBatch', N'roleManagerFront:searchUserListBatch', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829419102467792896, N'保存角色功能', N'保存角色功能', 1450765592889004740, N'', N'', N'0', N'res_btn', 29, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:15:24', 1450756958461300737, '2024-04-07 18:15:24', N'202000005070170', N'/roleManagerFront/saveFunction', N'roleManagerFront:saveFunction', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829419565481205760, N'保存角色资源', N'保存角色资源', 1450765592889004740, N'', N'', N'0', N'res_btn', 30, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:17:14', 1450756958461300737, '2024-04-07 18:17:14', N'202000005070171', N'/roleManagerFront/saveRealResource', N'roleManagerFront:saveRealResource', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829420846300012544, N'保存或修改功能模块', N'保存或修改功能模块', 523074819135381504, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:22:20', 1450756958461300737, '2024-04-07 18:22:20', N'0221000005070172', N'/resourceFront/saveFunModule', N'resourceFront:saveFunModule', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829421115242979328, N'保存或修改功能和功能资源关联', N'保存或修改功能和功能资源关联', 523074819135381504, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:23:24', 1450756958461300737, '2024-04-07 18:23:24', N'0221000005070173', N'/resourceFront/saveFunRes', N'resourceFront:saveFunRes', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829421306264166400, N'功能模块下级排序', N'功能模块下级排序', 523074819135381504, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:24:09', 1450756958461300737, '2024-04-07 18:24:09', N'0221000005070174', N'/resourceFront/functionModuleTreeOrder', N'resourceFront:functionModuleTreeOrder', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829421877826166784, N'删除功能模块', N'删除功能模块', 523074819135381504, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-07 18:26:26', 1450756958461300737, '2024-04-07 18:26:26', N'0221000005070175', N'/resourceFront/delFunctionModules', N'resourceFront:delFunctionModules', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829640021417140224, N'新增快捷方式分组', N'新增快捷方式分组', 1450765592889004623, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 08:53:15', 1450756958461300737, '2024-04-08 08:53:15', N'02010208000005070176', N'/shortcutGroupConfig/add', N'shortcutGroupConfig:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829643935965257728, N'修改快捷方式分组', N'修改快捷方式分组', 1450765592889004623, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:08:48', 1450756958461300737, '2024-04-08 09:08:48', N'02010208000005070177', N'/shortcutGroupConfig/update', N'shortcutGroupConfig:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829644343521583104, N'删除快捷方式分组', N'删除快捷方式分组', 1450765592889004623, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:10:26', 1450756958461300737, '2024-04-08 09:10:26', N'02010208000005070178', N'/shortcutGroupConfig/delete', N'shortcutGroupConfig:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829644682744307712, N'控制台保存新增的快捷入口', N'控制台保存新增的快捷入口', 1450765592889004623, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:11:46', 1450756958461300737, '2024-04-08 09:11:46', N'02010208000005070179', N'/shortcutConfig/add', N'shortcutConfig:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829644897207459840, N'删除快捷入口', N'删除快捷入口', 1450765592889004623, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:12:38', 1450756958461300737, '2024-04-08 09:12:38', N'02010208000005070180', N'/shortcutConfig/delete', N'shortcutConfig:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829645143585071104, N'修改登录页/欢迎页可视化配置信息', N'修改登录页/欢迎页可视化配置信息', 1450765592889004689, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:13:36', 1450756958461300737, '2024-04-08 09:13:36', N'02010203000005070181', N'/sysBaseConfigFront/viewUpdate', N'sysBaseConfigFront:viewUpdate', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829645533818920960, N'添加应用', N'添加应用', 595571579120001024, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:15:09', 1450756958461300737, '2024-04-08 09:15:09', N'0215000005070182', N'/mobile/application/addApp', N'mobile:application:addApp', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829646158434672640, N'修改应用', N'修改应用', 595571579120001024, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:17:38', 1450756958461300737, '2024-04-08 09:17:38', N'0215000005070183', N'/mobile/application/updateApp', N'mobile:application:updateApp', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829646695037149184, N'删除应用', N'删除应用', 595571579120001024, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:19:46', 1450756958461300737, '2024-04-08 09:19:46', N'0215000005070184', N'/mobile/application/deleteApp', N'mobile:application:deleteApp', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829646829514924032, N'添加或修改分组', N'添加或修改分组', 595571579120001024, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:20:18', 1450756958461300737, '2024-04-08 09:20:18', N'0215000005070185', N'/mobile/application/group/insertOrUpdateGroup', N'mobile:application:group:insertOrUpdateGroup', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829647470169694208, N'保存三方集成配置信息', N'保存三方集成配置信息', 595571579120001024, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:22:51', 1450756958461300737, '2024-04-08 09:22:51', N'0215000005070186', N'/mobile/external/saveConfig', N'mobile:external:saveConfig', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829648871130144768, N'删除分组', N'删除分组', 595571579120001024, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:28:25', 1450756958461300737, '2024-04-08 09:28:25', N'0215000005070187', N'/mobile/application/group/delete', N'mobile:application:group:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829649753250996224, N'查询流程管理页面', N'查询流程管理页面', 523177185453023232, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:31:55', 1450756958461300737, '2024-04-08 09:31:55', N'0234000005070188', N'/bpm/model/modelQuery', N'bpm:model:modelQuery', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829650049343692800, N'展示流程定义列表', N'展示流程定义列表', 523177185453023232, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:33:06', 1450756958461300737, '2024-04-08 09:33:06', N'0234000005070189', N'/bpm/processDefinition/queryProcessDefinitionsList', N'bpm:processDefinition:queryProcessDefinitionsList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829650386460876800, N'设置主版本', N'设置主版本', 523177185453023232, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:34:26', 1450756958461300737, '2024-04-08 09:34:26', N'0234000005070190', N'/bpm/processDefinition/setMain', N'bpm:processDefinition:setMain', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829650645429788672, N'取消主版本', N'取消主版本', 523177185453023232, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:35:28', 1450756958461300737, '2024-04-08 09:35:28', N'0234000005070191', N'/bpm/processDefinition/cancelMain', N'bpm:processDefinition:cancelMain', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829650996014882816, N'删除流程模型', N'删除流程模型', 523177185453023232, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:36:52', 1450756958461300737, '2024-04-08 09:36:52', N'0234000005070192', N'/bpm/model/deleteModel', N'bpm:model:deleteModel', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829651441592573952, N'删除流程定义', N'删除流程定义', 523177185453023232, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:38:38', 1450756958461300737, '2024-04-08 09:38:38', N'0234000005070193', N'/bpm/model/deleteModelWithVersion', N'bpm:model:deleteModelWithVersion', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829652277517361152, N'展示流程实例列表', N'展示流程实例列表', 523177216750919680, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:41:57', 1450756958461300737, '2024-04-08 09:41:57', N'0235000005070194', N'/bpm/processInst/getProcessList', N'bpm:processInst:getProcessList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829652497630240768, N'查询意见列表', N'查询意见列表', 523177216750919680, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:42:50', 1450756958461300737, '2024-04-08 09:42:50', N'0235000005070195', N'/bpm/processInst/getProcessDetailList', N'bpm:processInst:getProcessDetailList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829653024451600384, N'修改意见', N'修改意见', 523177216750919680, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:44:55', 1450756958461300737, '2024-04-08 09:44:55', N'0235000005070196', N'/bpm/processInst/updateComments', N'bpm:processInst:updateComments', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829653344305029120, N'重启流程到目标节点', N'重启流程到目标节点', 523177216750919680, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:46:12', 1450756958461300737, '2024-04-08 09:46:12', N'0235000005070197', N'/bpm/processInst/reStartProcess', N'bpm:processInst:reStartProcess', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829653604154744832, N'挂起流程实例', N'挂起流程实例', 523177216750919680, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:47:13', 1450756958461300737, '2024-04-08 09:47:13', N'0235000005070198', N'/bpm/processInst/suspendProcessById', N'bpm:processInst:suspendProcessById', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829654027020279808, N'终结流程实例', N'终结流程实例', 523177216750919680, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:48:54', 1450756958461300737, '2024-04-08 09:48:54', N'0235000005070199', N'/bpm/processInst/endProcessByProcessInsId', N'bpm:processInst:endProcessByProcessInsId', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829654374266707968, N'删除选中的流程实例', N'删除选中的流程实例', 523177216750919680, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:50:17', 1450756958461300737, '2024-04-08 09:50:17', N'0235000005070200', N'/bpm/processInst/deleteProcessById', N'bpm:processInst:deleteProcessById', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829654700084436992, N'激活流程实例', N'激活流程实例', 523177216750919680, N'', N'', N'0', N'res_btn', 9, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:51:35', 1450756958461300737, '2024-04-08 09:51:35', N'0235000005070201', N'/bpm/processInst/activateProcessById', N'bpm:processInst:activateProcessById', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829655545685483520, N'查询流程任务', N'查询流程任务', 523177259834810368, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:54:56', 1450756958461300737, '2024-04-08 09:54:56', N'0236000005070202', N'/bpm/taskManager/getTaskManager', N'bpm:taskManager:getTaskManager', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829655991439335424, N'直接审批', N'直接审批', 523177259834810368, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:56:43', 1450756958461300737, '2024-04-08 09:56:43', N'0236000005070203', N'/bpm/taskManager/completeTask', N'bpm:taskManager:completeTask', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829656306565783552, N'修改参与者', N'修改参与者', 523177259834810368, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 09:57:58', 1450756958461300737, '2024-04-08 09:57:58', N'0236000005070204', N'/bpm/taskManager/entrustTaskByTaskId', N'bpm:taskManager:entrustTaskByTaskId', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829656910411341824, N'自由跳转', N'自由跳转', 523177259834810368, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:00:22', 1450756958461300737, '2024-04-08 10:00:22', N'0236000005070206', N'/bpm/taskManager/freeJump', N'bpm:taskManager:freeJump', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829656993349509120, N'自由驳回', N'自由驳回', 523177259834810368, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:00:42', 1450756958461300737, '2024-04-08 10:00:42', N'0236000005070207', N'/bpm/taskManager/rejectToLastTask', N'bpm:taskManager:rejectToLastTask', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829657336850423808, N'催办', N'催办', 523177259834810368, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:02:03', 1450756958461300737, '2024-04-08 10:02:03', N'0236000005070208', N'/bpm/taskManager/urgeTask', N'bpm:taskManager:urgeTask', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829657750480101376, N'挂起', N'挂起', 523177259834810368, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:03:42', 1450756958461300737, '2024-04-08 10:03:42', N'0236000005070209', N'/bpm/taskManager/suspendTaskById', N'bpm:taskManager:suspendTaskById', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829658073546366976, N'激活', N'激活', 523177259834810368, N'', N'', N'0', N'res_btn', 9, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:04:59', 1450756958461300737, '2024-04-08 10:04:59', N'0236000005070210', N'/bpm/taskManager/activateTaskById', N'bpm:taskManager:activateTaskById', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829661188479787008, N'获取函数列表', N'获取函数列表', 523177287164895232, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:17:22', 1450756958461300737, '2024-04-08 10:17:22', N'0237000005070211', N'/bpm/function/getList', N'bpm:function:getList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829662709275697152, N'新增函数', N'新增函数', 523177287164895232, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:23:24', 1450756958461300737, '2024-04-08 10:23:24', N'0237000005070212', N'/bpm/function/add', N'bpm:function:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829662870085312512, N'修改函数', N'修改函数', 523177287164895232, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:24:03', 1450756958461300737, '2024-04-08 10:24:03', N'0237000005070213', N'/bpm/function/update', N'bpm:function:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829663227851055104, N'删除函数', N'删除函数', 523177287164895232, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:25:28', 1450756958461300737, '2024-04-08 10:25:28', N'0237000005070214', N'/bpm/function/delete', N'bpm:function:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829663627639529472, N'工作流配置列表查询', N'工作流配置列表查询', 673548858558783488, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:27:03', 1450756958461300737, '2024-04-08 10:27:03', N'0218000005070215', N'/bpmConfigFront/getList', N'bpmConfigFront:getList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829663972935606272, N'获取所属配置项', N'获取所属配置项', 673548858558783488, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:28:26', 1450756958461300737, '2024-04-08 10:28:26', N'0218000005070216', N'/bpmConfigFront/configList', N'bpmConfigFront:configList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829664147154411520, N'修改配置', N'修改配置', 673548858558783488, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:29:07', 1450756958461300737, '2024-04-08 10:29:07', N'0218000005070217', N'/bpmConfigFront/update', N'bpmConfigFront:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829664689603747840, N'表单查询', N'表单查询', 706807109840543744, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:31:16', 1450756958461300737, '2024-04-08 10:31:16', N'0215000005070218', N'/bpm/formInfo/queryCustomFormByName', N'bpm:formInfo:queryCustomFormByName', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829664987747459072, N'分类树查询', N'分类树查询', 706807109840543744, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:32:28', 1450756958461300737, '2024-04-08 10:32:28', N'0215000005070219', N'/bpm/category/categoryTree', N'bpm:category:categoryTree', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829665433849438208, N'新增分类', N'新增分类', 706807109840543744, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:34:14', 1450756958461300737, '2024-04-08 10:34:14', N'0215000005070220', N'/bpm/category/add', N'bpm:category:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829666039490158592, N'修改分类', N'修改分类', 706807109840543744, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:36:38', 1450756958461300737, '2024-04-08 10:36:38', N'0215000005070221', N'/bpm/category/update', N'bpm:category:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829666121014845440, N'删除分类', N'删除分类', 706807109840543744, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:36:58', 1450756958461300737, '2024-04-08 10:36:58', N'0215000005070222', N'/bpm/category/delete', N'bpm:category:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829666955555512320, N'新增表单', N'新增表单', 706807109840543744, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:40:17', 1450756958461300737, '2024-04-08 10:40:17', N'0215000005070223', N'/bpm/formInfo/add', N'bpm:formInfo:add', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829667053261824000, N'修改表单', N'修改表单', 706807109840543744, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:40:40', 1450756958461300737, '2024-04-08 10:40:40', N'0215000005070224', N'/bpm/formInfo/update', N'bpm:formInfo:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829667187232088064, N'删除表单', N'删除表单', 706807109840543744, N'', N'', N'0', N'res_btn', 9, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:41:12', 1450756958461300737, '2024-04-08 10:41:12', N'0215000005070225', N'/bpm/formInfo/delete', N'bpm:formInfo:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829667364462403584, N'表单详情', N'表单详情', 706807109840543744, N'', N'', N'0', N'res_btn', 10, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:41:54', 1450756958461300737, '2024-04-08 10:41:54', N'0215000005070226', N'/bpm/formInfo/detail', N'bpm:formInfo:detail', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829669690359160832, N'设置是否灰屏', N'设置是否灰屏', 544468727815741440, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:51:09', 1450756958461300737, '2024-04-08 10:51:09', N'0215000005070227', N'/themeConfig/updateGreyScreenApplication', N'themeConfig:updateGreyScreenApplication', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829670011496046592, N'导入主题', N'导入主题', 544468727815741440, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:52:25', 1450756958461300737, '2024-04-08 10:52:25', N'0215000005070228', N'/themeConfig/importTheme', N'themeConfig:importTheme', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829670236050694144, N'根据主题ID更换当前主题', N'根据主题ID更换当前主题', 544468727815741440, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 10:53:19', 1450756958461300737, '2024-04-08 10:53:19', N'0215000005070229', N'/themeConfig/updateThemeCurrentApplication', N'themeConfig:updateThemeCurrentApplication', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829682927825854464, N'获取所有字典列表', N'获取所有字典列表', 1450765592889004593, N'', N'', N'0', N'res_btn', 21, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 11:43:45', 1450756958461300737, '2024-04-08 11:43:45', N'字典管理000005070241', N'/dicFront/getList', N'dicFront:getList', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829685650679930880, N'修改字典类别', N'修改字典类别', 1450765592889004593, N'', N'', N'0', N'res_btn', 22, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 11:54:34', 1450756958461300737, '2024-04-08 14:28:56', N'字典管理000005070243', N'/dicFront/update', N'dict:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829713899439005696, N'获取冻结密码的缓存列表', N'获取冻结密码的缓存列表', 1450765592889004746, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 13:46:49', 1450756958461300737, '2024-04-08 13:46:49', N'null0139000005070246', N'/hussarBase/operations/secure/getFreezeList', N'hussarBase:operations:secure:getFreezeList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829714279975624704, N'解冻密码', N'解冻密码', 1450765592889004746, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 13:48:20', 1450756958461300737, '2024-04-08 13:48:20', N'null0139000005070248', N'/hussarBase/operations/secure/unfreezeSecureUser', N'hussarBase:operations:secure:unfreezeSecureUser', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829717443915292672, N'客户端修改保存', N'客户端修改保存', 518447803329159168, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 14:00:54', 1450756958461300737, '2024-04-08 14:00:54', N'0225000005070249', N'/hussarBase/client/update', N'hussarBase:client:update', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829717560286257152, N'客户端新增保存', N'客户端新增保存', 518447803329159168, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 14:01:22', 1450756958461300737, '2024-04-08 14:01:22', N'0225000005070250', N'/hussarBase/client/save', N'hussarBase:client:save', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829717677168926720, N'客户端删除', N'客户端删除', 518447803329159168, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 14:01:50', 1450756958461300737, '2024-04-08 14:01:50', N'0225000005070251', N'/hussarBase/client/delete', N'hussarBase:client:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004022730825728, N'应用信息分页查询', N'应用信息分页查询', 546336605821214720, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 08:59:40', 1450756958461300737, '2024-04-09 08:59:40', N'0216000005070173', N'/appInfo/page', N'appInfo:page', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004144281755648, N'新增应用', N'新增应用', 546336605821214720, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:00:09', 1450756958461300737, '2024-04-09 09:00:09', N'0216000005070174', N'/appInfo/save', N'appInfo:save', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004255158181888, N'删除应用', N'删除应用', 546336605821214720, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:00:35', 1450756958461300737, '2024-04-09 09:00:35', N'0216000005070175', N'/appInfo/delete', N'appInfo:delete', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004361634783232, N'验证应用', N'验证应用', 546336605821214720, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:01:01', 1450756958461300737, '2024-04-09 09:01:01', N'0216000005070176', N'/appInfo/assert', N'appInfo:assert', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004507340709888, N'查询应用列表', N'查询应用列表', 544474526055145472, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:01:35', 1450756958461300737, '2024-04-09 09:01:35', N'0221000005070177', N'/appInfo/list', N'appInfo:list', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830004656615989248, N'验证appName的可用性', N'验证appName的可用性', 544474526055145472, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:02:11', 1450756958461300737, '2024-04-09 09:02:11', N'0221000005070178', N'/server/assert', N'server:assert', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830005036611543040, N'分页查询任务列表', N'分页查询任务列表', 544474526055145472, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:03:41', 1450756958461300737, '2024-04-09 09:03:41', N'0221000005070179', N'/job/list', N'job:list', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830005823991455744, N'保存任务', N'保存任务', 544474526055145472, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:06:49', 1450756958461300737, '2024-04-09 09:06:49', N'0221000005070180', N'/job/save', N'job:save', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830005916287115264, N'运行任务', N'运行任务', 544474526055145472, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:07:11', 1450756958461300737, '2024-04-09 09:07:11', N'0221000005070181', N'/job/run', N'job:run', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830005995823702016, N'验证时间表达式是否正确', N'验证时间表达式是否正确', 544474526055145472, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:07:30', 1450756958461300737, '2024-04-09 09:07:30', N'0221000005070182', N'/validate/timeExpression', N'validate:timeExpression', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006117668233216, N'停止任务', N'停止任务', 544474526055145472, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:07:59', 1450756958461300737, '2024-04-09 09:08:13', N'0221000005070183', N'/job/disable', N'job:disable', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006238078312448, N'删除任务', N'删除任务', 544474526055145472, N'', N'', N'0', N'res_btn', 9, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:08:28', 1450756958461300737, '2024-04-09 09:08:28', N'0221000005070184', N'/job/delete', N'job:delete', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006404764147712, N'查询任务实例列表', N'查询任务实例列表', 544474679767998464, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:09:08', 1450756958461300737, '2024-04-09 09:09:08', N'0222000005070185', N'/instance/list', N'instance:list', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006476339945472, N'重试任务实例', N'重试任务实例', 544474679767998464, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:09:25', 1450756958461300737, '2024-04-09 09:09:25', N'0222000005070186', N'/instance/retry', N'instance:retry', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006610553479168, N'停止任务实例', N'停止任务实例', 544474679767998464, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:09:57', 1450756958461300737, '2024-04-09 09:09:57', N'0222000005070187', N'/instance/stop', N'instance:stop', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830006682578067456, N'查询任务实例详情', N'查询任务实例详情', 544474679767998464, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 09:10:14', 1450756958461300737, '2024-04-09 09:10:14', N'0222000005070188', N'/instance/detail', N'instance:detail', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829755619782434816, N'人员审核列表', N'人员审核列表', 523064540137791488, N'', N'', N'0', N'res_btn', 23, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:32:36', 1450756958461300737, '2024-04-08 16:32:36', N'0217000005070154', N'/hussarBase/authorization/staffAudit/list', N'hussarBase:authorization:staffAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829756888681029632, N'人员审核详情接口', N'人员审核详情接口', 523064540137791488, N'', N'', N'0', N'res_btn', 24, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:37:38', 1450756958461300737, '2024-04-08 16:37:38', N'0217000005070155', N'/hussarBase/authorization/staffAudit/detail', N'hussarBase:authorization:staffAudit:detail', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829757218558844928, N'人员审核通过', N'人员审核通过', 523064540137791488, N'', N'', N'0', N'res_btn', 25, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:38:57', 1450756958461300737, '2024-04-08 16:38:57', N'0217000005070156', N'/hussarBase/authorization/staffAudit/pass', N'hussarBase:authorization:staffAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829757625855123456, N'岗位审核列表', N'岗位审核列表', 688348425015795712, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:40:34', 1450756958461300737, '2024-04-08 16:40:34', N'0219000005070157', N'/hussarBase/authorization/postAudit/list', N'hussarBase:authorization:postAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829757993632669696, N'获取岗位审核信息详情', N'获取岗位审核信息详情', 688348425015795712, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:42:02', 1450756958461300737, '2024-04-08 16:42:02', N'0219000005070158', N'/hussarBase/authorization/postAudit/detail', N'hussarBase:authorization:postAudit:detail', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829759282911387648, N'用户组织审核列表', N'用户组织审核列表', 714498130460286976, N'', N'', N'0', N'res_btn', 17, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:47:09', 1450756958461300737, '2024-04-08 16:47:09', N'00760090000005070159', N'/hussarBase/authorization/struUserAudit/list', N'hussarBase:authorization:struUserAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829759667151577088, N'用户组织审核通过', N'用户组织审核通过', 714498130460286976, N'', N'', N'0', N'res_btn', 18, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:48:41', 1450756958461300737, '2024-04-08 16:48:41', N'00760090000005070160', N'/hussarBase/authorization/struUserAudit/pass', N'hussarBase:authorization:struUserAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829759771719770112, N'用户组织审核驳回', N'用户组织审核驳回', 714498130460286976, N'', N'', N'0', N'res_btn', 19, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:49:06', 1450756958461300737, '2024-04-08 16:49:06', N'00760090000005070161', N'/hussarBase/authorization/struUserAudit/reject', N'hussarBase:authorization:struUserAudit:reject', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829761477207662592, N'用户岗位审核列表', N'用户岗位审核列表', 714502896477282304, N'', N'', N'0', N'res_btn', 20, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:55:52', 1450756958461300737, '2024-04-08 16:55:52', N'00760090000005070162', N'/hussarBase/authorization/userPostAudit/list', N'hussarBase:authorization:userPostAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829761610313900032, N'用户岗位审核通过', N'用户岗位审核通过', 714502896477282304, N'', N'', N'0', N'res_btn', 21, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:56:24', 1450756958461300737, '2024-04-08 16:56:24', N'00760090000005070163', N'/hussarBase/authorization/userPostAudit/pass', N'hussarBase:authorization:userPostAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829761705788841984, N'用户岗位审核驳回', N'用户岗位审核驳回', 714502896477282304, N'', N'', N'0', N'res_btn', 22, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 16:56:47', 1450756958461300737, '2024-04-08 16:56:47', N'00760090000005070164', N'/hussarBase/authorization/userPostAudit/reject', N'hussarBase:authorization:userPostAudit:reject', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829763516436324352, N'组织角色审核列表', N'组织角色审核列表', 714486973070581760, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:03:59', 1450756958461300737, '2024-04-08 17:03:59', N'0220000005070165', N'/hussarBase/authorization/struRoleAudit/list', N'hussarBase:authorization:struRoleAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829763853897441280, N'组织角色审核通过', N'组织角色审核通过', 714486973070581760, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:05:19', 1450756958461300737, '2024-04-08 17:05:19', N'0220000005070166', N'/hussarBase/authorization/struRoleAudit/pass', N'hussarBase:authorization:struRoleAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829763981664329728, N'组织角色审核驳回', N'组织角色审核驳回', 714486973070581760, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:05:50', 1450756958461300737, '2024-04-08 17:05:50', N'0220000005070167', N'/hussarBase/authorization/struRoleAudit/reject', N'hussarBase:authorization:struRoleAudit:reject', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829764556023930880, N'岗位角色审核列表', N'岗位角色审核列表', 714487678439268352, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:08:06', 1450756958461300737, '2024-04-08 17:08:06', N'0221000005070168', N'/hussarBase/authorization/postRoleAudit/list', N'hussarBase:authorization:postRoleAudit:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829764670033502208, N'岗位角色审核通过', N'岗位角色审核通过', 714487678439268352, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:08:34', 1450756958461300737, '2024-04-08 17:08:34', N'0221000005070169', N'/hussarBase/authorization/postRoleAudit/pass', N'hussarBase:authorization:postRoleAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829764752225083392, N'岗位角色审核驳回', N'岗位角色审核驳回', 714487678439268352, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:08:53', 1450756958461300737, '2024-04-08 17:08:53', N'0221000005070170', N'/hussarBase/authorization/postRoleAudit/reject', N'hussarBase:authorization:postRoleAudit:reject', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829765472026370048, N'岗位审核驳回', N'岗位审核驳回', 688348425015795712, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:11:45', 1450756958461300737, '2024-04-08 17:11:45', N'0219000005070171', N'/hussarBase/authorization/postAudit/reject', N'hussarBase:authorization:postAudit:reject', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (829765606491561984, N'岗位审核通过', N'岗位审核通过', 688348425015795712, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-08 17:12:17', 1450756958461300737, '2024-04-08 17:12:17', N'0219000005070172', N'/hussarBase/authorization/postAudit/pass', N'hussarBase:authorization:postAudit:pass', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021062573170688, N'获取各种流程信息数据', N'获取各种流程信息数据', 830015977810042880, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:07:22', 1450756958461300737, '2024-04-09 10:07:44', N'000000000273000005070189', N'/bpm/processCount/queryProcessCountModel', N'bpm:processCount:queryProcessCountModel', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021376315498496, N'统计最近7天每天新增及完成的任务实例数量', N'统计最近7天每天新增及完成的任务实例数量', 830015977810042880, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:08:37', 1450756958461300737, '2024-04-09 10:08:37', N'000000000273000005070190', N'/bpm/processCount/getDayChangeCountModel', N'bpm:processCount:getDayChangeCountModel', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021462655246336, N'获取所有流程实例相关统计数量', N'获取所有流程实例相关统计数量', 830015977810042880, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:08:58', 1450756958461300737, '2024-04-09 10:08:58', N'000000000273000005070191', N'/bpm/processCount/queryAllProcessCountMsg', N'bpm:processCount:queryAllProcessCountMsg', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021550685298688, N'流程统计明细', N'流程统计明细', 830015977810042880, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:09:19', 1450756958461300737, '2024-04-09 10:09:19', N'000000000273000005070192', N'/bpm/processCount/queryProcessInstanceDetail', N'bpm:processCount:queryProcessInstanceDetail', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021682168340480, N'获取流程树', N'获取流程树', 830016425195479040, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:09:50', 1450756958461300737, '2024-04-09 10:09:50', N'000000000274000005070193', N'/bpm/processCount/queryProcessTree', N'bpm:processCount:queryProcessTree', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021803991900160, N'获取流程实例状态', N'获取流程实例状态', 830016425195479040, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:10:19', 1450756958461300737, '2024-04-09 10:10:19', N'000000000274000005070194', N'/bpm/processCount/queryProcessStatusForChart', N'bpm:processCount:queryProcessStatusForChart', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021917498155008, N'查询流程实例状态列表接口', N'查询流程实例状态列表接口', 830016425195479040, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:10:46', 1450756958461300737, '2024-04-09 10:10:46', N'000000000274000005070195', N'/bpm/processCount/queryProcessStatusForList', N'bpm:processCount:queryProcessStatusForList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830021996233629696, N'流程状态分析,运行实例数下钻接口', N'流程状态分析,运行实例数下钻接口', 830016425195479040, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:11:05', 1450756958461300737, '2024-04-09 10:11:05', N'000000000274000005070196', N'/bpm/processCount/queryProcessTaskStatusList', N'bpm:processCount:queryProcessTaskStatusList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022191411372032, N'参与者流程查询柱状图、折线图接口', N'参与者流程查询柱状图、折线图接口', 830016458288537600, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:11:52', 1450756958461300737, '2024-04-09 10:11:52', N'000000000275000005070197', N'/bpm/processCount/queryParticipateProcessForChart', N'bpm:processCount:queryParticipateProcessForChart', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022276195033088, N'参与者流程查询列表接口', N'参与者流程查询列表接口', 830016458288537600, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:12:12', 1450756958461300737, '2024-04-09 10:12:12', N'000000000275000005070198', N'/bpm/processCount/queryParticipateProcessForList', N'bpm:processCount:queryParticipateProcessForList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022372546584576, N'参与者流程查询,实例数下钻接口', N'参与者流程查询,实例数下钻接口', 830016458288537600, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:12:35', 1450756958461300737, '2024-04-09 10:12:35', N'000000000275000005070199', N'/bpm/processCount/queryParticipateProcessNumberDrill', N'bpm:processCount:queryParticipateProcessNumberDrill', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022480885456896, N'流程参与者分析:操作数下钻接口', N'流程参与者分析:操作数下钻接口', 830016458288537600, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:13:01', 1450756958461300737, '2024-04-09 10:13:01', N'000000000275000005070200', N'/bpm/processCount/queryParticipateTaskNumberDrill', N'bpm:processCount:queryParticipateTaskNumberDrill', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022620929073152, N'流程统计查询列表接口', N'流程统计查询列表接口', 830016495609454592, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:13:34', 1450756958461300737, '2024-04-09 10:13:34', N'000000000276000005070201', N'/bpm/processCount/queryProcessStatisticForList', N'bpm:processCount:queryProcessStatisticForList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022710133530624, N'流程统计查询柱状图接口', N'流程统计查询柱状图接口', 830016495609454592, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:13:55', 1450756958461300737, '2024-04-09 10:13:55', N'000000000276000005070202', N'/bpm/processCount/queryProcessStatisticForChart', N'bpm:processCount:queryProcessStatisticForChart', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830022940199493632, N'热门流程查询', N'热门流程查询', 581434239535554561, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:14:50', 1450756958461300737, '2024-04-09 10:14:50', N'0239000005070203', N'/bpm/processCount/queryHotProcess', N'bpm:processCount:queryHotProcess', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023058038464512, N'流程数量查询接口', N'流程数量查询接口', 581434239535554561, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:15:18', 1450756958461300737, '2024-04-09 10:15:18', N'0239000005070204', N'/bpm/processCount/queryProcessNumberList', N'bpm:processCount:queryProcessNumberList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023536881180672, N'待办任务分析', N'待办任务分析', 581434239535554561, N'', N'', N'0', N'res_btn', 11, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:17:12', 1450756958461300737, '2024-04-09 10:17:12', N'0239000005070208', N'/bpm/processCount/queryInstanceTodoTaskCount', N'bpm:processCount:queryInstanceTodoTaskCount', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023676643778560, N'待办任务分析下钻节点待办数量', N'待办任务分析下钻节点待办数量', 581434239535554561, N'', N'', N'0', N'res_btn', 12, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:17:46', 1450756958461300737, '2024-04-09 10:17:46', N'0239000005070209', N'/bpm/processCount/queryInstanceTodoTaskCountByProcessKey', N'bpm:processCount:queryInstanceTodoTaskCountByProcessKey', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023767886667776, N'驳回次数排行流程列表', N'驳回次数排行流程列表', 581434239535554561, N'', N'', N'0', N'res_btn', 13, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:18:07', 1450756958461300737, '2024-04-09 10:18:07', N'0239000005070210', N'/bpm/processCount/queryHotRejectProcessList', N'bpm:processCount:queryHotRejectProcessList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023867467833344, N'查询任务节点驳回次数排行', N'查询任务节点驳回次数排行', 581434239535554561, N'', N'', N'0', N'res_btn', 14, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:18:31', 1450756958461300737, '2024-04-09 10:18:31', N'0239000005070211', N'/bpm/processCount/queryNodeRejectCount', N'bpm:processCount:queryNodeRejectCount', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830023991669563392, N'统计特定时间段内，平均流程完成时间', N'统计特定时间段内，平均流程完成时间', 830016532078927872, N'', N'', N'0', N'res_btn', 1, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:19:01', 1450756958461300737, '2024-04-09 10:19:01', N'000000000277000005070212', N'/bpm/processCount/queryProcessConsumeTime', N'bpm:processCount:queryProcessConsumeTime', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830024090978099200, N'统计特定时间段内指定流程各节点耗时', N'统计特定时间段内指定流程各节点耗时', 830016532078927872, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:19:24', 1450756958461300737, '2024-04-09 10:19:24', N'000000000277000005070213', N'/bpm/processCount/queryNodeConsumeTimeByProcessKey', N'bpm:processCount:queryNodeConsumeTimeByProcessKey', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830025119551463424, N'查询在线用户列表', N'查询在线用户列表', 1450765592889004700, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:23:30', 1450756958461300737, '2024-04-09 10:23:30', N'505000005070215', N'/onlineFront/getList', N'onlineFront:getList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830025211385749504, N'获取系统审计日志列表', N'获取系统审计日志列表', 1450765592889004700, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:23:52', 1450756958461300737, '2024-04-09 10:23:52', N'505000005070216', N'/baseAuditLog/getAuditLogList', N'baseAuditLog:getAuditLogList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830025591993671680, N'系统监控', N'系统监控', 1450765592889004660, N'', N'', N'0', N'res_btn', 2, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:25:22', 1450756958461300737, '2024-04-09 10:25:22', N'00260016000005070218', N'/monitor', N'monitor', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830025762240471040, N'慢SQL监控列表', N'慢SQL监控列表', 523159993936257024, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:26:03', 1450756958461300737, '2024-04-09 10:26:03', N'0232000005070219', N'/sqlMonitorFront/getList', N'sqlMonitorFront:getList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830025936044040192, N'获取日志开关状态', N'获取日志开关状态', 592385645452992512, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:26:44', 1450756958461300737, '2024-04-09 10:26:44', N'0217000005070220', N'/getLogConfig/isLogOpen', N'getLogConfig:isLogOpen', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026026829750272, N'分页查询日志告警规则', N'分页查询日志告警规则', 592385645452992512, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:27:06', 1450756958461300737, '2024-04-09 10:27:06', N'0217000005070221', N'/logWarnRule/list', N'logWarnRule:list', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026147629899776, N'保存日志告警规则', N'保存日志告警规则', 592385645452992512, N'', N'', N'0', N'res_btn', 5, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:27:35', 1450756958461300737, '2024-04-09 10:27:35', N'0217000005070222', N'/logWarnRule/save', N'logWarnRule:save', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026229305581568, N'删除日志告警规则', N'删除日志告警规则', 592385645452992512, N'', N'', N'0', N'res_btn', 6, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:27:54', 1450756958461300737, '2024-04-09 10:27:54', N'0217000005070223', N'/logWarnRule/delete', N'logWarnRule:delete', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026325371920384, N'查询', N'查询', 592385645452992512, N'', N'', N'0', N'res_btn', 7, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:28:17', 1450756958461300737, '2024-04-09 10:28:17', N'0217000005070224', N'/hussarUnifiedLog/query', N'hussarUnifiedLog:query', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026403285311488, N'清空记录', N'清空记录', 592385645452992512, N'', N'', N'0', N'res_btn', 8, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:28:36', 1450756958461300737, '2024-04-09 10:28:36', N'0217000005070225', N'/hussarUnifiedLog/deleteIndex', N'hussarUnifiedLog:deleteIndex', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830026567542644736, N'获取日志信息', N'获取日志信息', 1450765592889004756, N'', N'', N'0', N'res_btn', 4, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:29:15', 1450756958461300737, '2024-04-09 10:29:15', N'507000005070226', N'/baseAuditLog/getAuditLogInfo', N'baseAuditLog:getAuditLogInfo', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (830030534867689472, N'查询在线用户历史记录列表', N'查询在线用户历史记录列表', 1450765592889004718, N'', N'', N'0', N'res_btn', 3, N'0', N'0', N'0', 1450756958461300737, '2024-04-09 10:45:01', 1450756958461300737, '2024-04-09 10:45:01', N'506000005070230', N'/onlineHistFront/getList', N'onlineHistFront:getList', N'1', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (819882932406853632, N'模板管理', N'模板管理', 697758207757787136, N'/dingTalk/DingTalkTemplate', N'HussarMessage/src/views/dingTalk/DingTalkTemplate', N'0', N'res_menu', 5, N'0', N'1', N'0', 1450756958461300737, '2024-03-12 10:42:04', 1450756958461300737, '2024-03-12 10:42:04', N'0215000005070161', N'', N'dingTalk::DingTalkTemplate', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (819882466553896960, N'模板管理', N'模板管理', 686174195188768768, N'/wecomService/wecomTemplate', N'HussarMessage/src/views/wecomService/WecomTemplate', N'0', N'res_menu', 5, N'0', N'1', N'0', 1450756958461300737, '2024-03-12 10:40:13', 1450756958461300737, '2024-03-12 10:41:12', N'0220000005070158', N'', N'wecomService:wecomTemplate', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (819882250383663104, N'模板管理', N'模板管理', 587706862284316672, N'/noticeService/noticeSendTemplate', N'HussarMessage/src/views/noticeService/NoticeSendTemplate', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2024-03-12 10:39:21', 1450756958461300737, '2024-03-12 10:39:21', N'0236000005070157', N'', N'noticeService:noticeSendTemplate', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (819881890768232448, N'模板管理', N'模板管理', 579399930809163776, N'/appImService/appImTemplate', N'HussarMessage/src/views/appImService/AppImTemplate', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2024-03-12 10:37:55', 1450756958461300737, '2024-03-12 10:37:55', N'0228000005070156', N'', N'appImService:appImTemplate', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (819881531945525248, N'模板管理', N'模板管理', 579405620386734080, N'/appPushService/appPushTemplate', N'HussarMessage/src/views/appPushService/AppPushTemplate', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2024-03-12 10:36:30', 1450756958461300737, '2024-03-12 10:36:30', N'0229000005070155', N'', N'appPushService:appPushTemplate', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (825417701370634240, N'统一接口推送', N'统一接口推送', 587942618739253248, N'', N'', N'0', N'res_open_interface', 23, N'0', N'0', N'0', 1450756958461300737, '2024-03-27 17:15:16', 1450756958461300737, '2024-03-27 17:15:16', N'0237000005070154', N'/msg/unity/send', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (813348818371485696, N'标签管理', N'标签管理', 811594090851606528, N'/contactService/TagManage', N'HussarMessage/src/views/contactService/TagManage', N'0', N'res_menu', 2, N'0', N'1', N'0', 1450756958461300737, '2024-02-23 09:57:50', 1450756958461300737, '2024-02-23 10:29:52', N'000000000273000005070155', N'', N'contactService:TagManage', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (811594293004476416, N'通讯录', N'通讯录', 811594090851606528, N'/contactService/ContactManage', N'HussarMessage/src/views/contactService/ContactManage', N'0', N'res_menu', 1, N'0', N'1', N'0', 1450756958461300737, '2024-02-18 13:45:58', 1450756958461300737, '2024-02-18 14:08:07', N'000000000273000005070154', N'', N'contactService:ContactManage', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (812026141606158336, N'批量添加联系人', N'批量添加联系人', 812025848596275200, N'', N'', N'0', N'res_open_interface', 1, N'0', N'0', N'0', NULL, NULL, NULL, NULL, N'000000000274000005070155', N'/msg/public/contact/addMsgContactRestApi', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (812026329171238912, N'批量更新并新增', N'批量更新并新增', 812025848596275200, N'', N'', N'0', N'res_open_interface', 2, N'0', N'0', N'0', NULL, NULL, NULL, NULL, N'000000000274000005070156', N'/msg/public/contact/updateMsgContactRestApi', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (812026421143937024, N'批量删除联系人', N'批量删除联系人', 812025848596275200, N'', N'', N'0', N'res_open_interface', 3, N'0', N'0', N'0', NULL, NULL, NULL, NULL, N'000000000274000005070157', N'/msg/public/contact/delMsgContactRestApi', N'', N'0', N'', N'data_holder', N'data_organ', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (518451664789970944, N'客户端管理', N'客户端管理', 518447803329159168, N'/authClientModel', N'HussarClient/src/views/client/client', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2021-12-01 15:41:49', 1450756958461300737, '2021-12-01 15:41:49', N'02250002', N'/authClientModel', N'authClientModel:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (521403853758013440, N'应用注册', N'应用注册', 528148369617723392, N'/unifiedtodoSystem', N'HussarUnifiedtodo/src/views/system/unifiedtodoSystem', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2021-12-09 19:12:46', 1450756958461300737, '2021-12-09 19:12:46', N'02200001', N'/unifiedtodoSystem', N'unifiedtodoSystem:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (522705027572441088, N'我的待办', N'我的待办', 521403268396752896, N'/unifiedtodoToDoTask', N'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoToDoTask', N'0', N'res_menu', 2, N'0', N'1', NULL, 1450756958461300737, '2021-12-13 09:23:10', 1450756958461300737, '2021-12-13 09:23:10', N'02200005', N'/unifiedtodoToDoTask', N'unifiedtodoToDoTask:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (523554762252361728, N'我的已办', N'我的已办', 521403268396752896, N'/unifiedtodoDoneTask', N'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoDoneTask', N'0', N'res_menu', 3, N'0', N'1', NULL, 1450756958461300737, '2021-12-15 17:39:42', 1450756958461300737, '2021-12-15 17:39:42', N'02200001', N'/unifiedtodoDoneTask', N'unifiedtodoDoneTask:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (523555173533229056, N'我的传阅', N'我的传阅', 521403268396752896, N'/unifiedtodoCcTask', N'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoCcTask', N'0', N'res_menu', 4, N'0', N'1', NULL, 1450756958461300737, '2021-12-15 17:41:21', 1450756958461300737, '2021-12-15 17:41:21', N'02200002', N'/unifiedtodoCcTask', N'unifiedtodoCcTask:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (526077294431969280, N'我的公告', N'我的公告', 526435626275577856, N'/noticeList', N'HussarNotice/src/views/notice/list', N'0', N'res_menu', 1, N'0', N'1', NULL, 1450756958461300737, '2021-12-22 16:43:21', 1450756958461300737, '2021-12-22 16:43:21', N'02310008', N'/noticeList', N'notice:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (526117603765395456, N'公告列表跳转', N'公告列表跳转', 526117093318598656, N'/myNotice/list', N'', N'0', N'res_btn', 1, N'0', N'1', NULL, 1450756958461300737, '2021-12-22 19:23:32', 1450756958461300737, '2021-12-22 19:23:32', N'02360002', N'/myNotice/list', N'myNotice:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (535768620278751232, N'审计查阅', N'审计查阅', 535768124604293120, N'/auditAccess', N'HussarAudit/src/views/system/auditAccess/index', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-01-18 10:33:13', 1450756958461300737, '2022-01-18 10:33:13', N'02270001', N'/auditAccess', N'auditAccess:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (544468972511436800, N'主题配置', N'主题配置', 544468727815741440, N'/themeConfig', N'HussarThemeConfig/src/views/themeConf/ThemeConf', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-02-11 10:45:19', 1450756958461300737, '2022-02-11 10:45:19', N'02150001', N'/themeConfig', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (556508576777248768, N'休眠用户', N'休眠用户', 1450765592889004737, N'/userFront/dormancy', N'', N'0', N'res_btn', 20, N'0', N'1', NULL, 1450756958461300737, '2022-03-16 16:06:24', 1450756958461300737, '2022-03-16 16:06:24', N'2010001', N'/userFront/dormancy', N'userFront:dormancy', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004036, N'修改密码', N'修改密码', 1450765592889004735, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-27 16:36:24', NULL, NULL, N'2060257', N'/userFront/updatePwd', N'userFront:updatePwd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004037, N'用户审核修改通过', N'用户审核修改通过', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 12, N'0', N'1', NULL, NULL, '2019-08-23 11:21:44', NULL, NULL, N'007600900196', N'/sysUsersAuditFront/passEdit', N'sysUsersAuditFront:passEdit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004039, N'功能下级排序', N'功能下级排序', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 15, N'0', N'1', NULL, NULL, '2019-08-26 09:23:35', NULL, NULL, N'资源维护0206', N'/resourceFront/functionTreeOrder', N'resourceFront:functionTreeOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004042, N'新增基础配置', N'新增基础配置', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'sbc000000001', N'/sysBaseConfig/add', N'sysBaseConfig:add', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004045, N'角色维护页面', N'角色维护页面', 1450765592889004740, N'/manageRole', N'HussarAuthorization/src/views/permit/rolemanage/role/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000003', N'/roleManager/view', N'roleManager:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004047, N'菜单转移', N'菜单树转移', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 14:55:52', N'000000000004', N'/frontMenu/menuTreeChange', N'frontMenu:menuTreeChange', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004052, N'功能修改', N'功能修改', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 09:44:15', N'00002', N'/resource/functionEdit', N'resource:functionEdit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004053, N'根据组织机构类型获取下属单位组织机构类型', N'根据组织机构类型获取下属单位组织机构类型', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'org000000003', N'/orgMainFront/getOrgRoleByCode', N'orgMainFront:getOrgRoleByCode', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004059, N'删除用户', N'删除用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000005', N'/userFront/delete', N'userFront:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004060, N'激活用户', N'激活用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 17, N'0', N'1', NULL, NULL, '2021-01-14 16:06:58', NULL, NULL, N'201019201', N'/userFront/unlockUser', N'userFront:unlockUser', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004061, N'工作日历批量新增', N'工作日历新增', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-26 11:41:03', NULL, '2019-08-26 13:36:20', N'null00340224', N'/calendarFront/addEvent', N'calendar:addEvent', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004062, N'删除角色分组', N'删除角色分组', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'2020022', N'/roleManagerFront/delGroup', N'roleManagerFront:delGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004064, N'新增角色分组', N'新增角色分组', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:58', N'2020019', N'/roleManagerFront/saveGroup', N'roleManagerFront:saveGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004066, N'日历维护权限', N'日历维护权限', 1450765592889004611, NULL, NULL, N'0', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-02-18 10:57:33', NULL, NULL, N'null00340316', N'/calendar/operate', N'calendar:operate', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004067, N'日志文件下载', N'日志文件下载', 1450765592889004701, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logD00000003', N'/logDownloadFront/download', N'logDownload:download', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004069, N'用户数据导出', N'用户数据导出', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, '2020-03-12 06:03:02', NULL, NULL, N'2010178', N'/userFront/exportData', N'userFront:exportData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004073, N'组织机构数据导入', N'组织机构数据导入', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, '2020-03-11 06:45:50', NULL, NULL, N'1020174', N'/orgMainFront/importData', N'orgMainFront:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004074, N'导出', N'编码规则导出', 1450765592889004610, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 11:37:00', NULL, '2019-08-26 20:15:35', N'100010223', N'/idtableFront/exportData', N'idtable:exportData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004075, N'定义组织类型', N'定义组织类型', 1450765592889004653, N'/SysOrgType', N'HussarAuthorization/src/views/organ/SysOrgType', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000007', N'/orgType/view', N'orgType:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004080, N'新增角色分组页面', N'新增角色分组页面', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000009', N'/roleManager/roleAddGroupPage', N'roleManager:roleAddGroupPage', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004082, N'用户数据导入', N'用户数据导入', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2020-03-12 06:02:34', NULL, NULL, N'2010177', N'/userFront/importData', N'userFront:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004085, N'流程管理', N'流程管理', 523177185453023232, N'/bpmModelEdit', N'BpmManageServer/src/views/modeling/modelEdit', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-07 13:38:06', NULL, NULL, N'020202010502', N'/bpmModelEdit/view', N'bpmModelEdit:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004087, N'菜单导入', N'菜单导入', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-26 10:38:21', NULL, '2019-08-26 19:46:48', N'菜单维护0215', N'/frontMenu/importData', N'frontMenu:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004088, N'获取所有的ehcache缓存名', N'获取所有的ehcache缓存名', 1450765592889004621, NULL, NULL, N'0', N'res_btn', 3, N'0', N'1', NULL, NULL, '2020-06-05 07:09:18', NULL, NULL, N'缓存监控0179', N'/ehcacheFront/getAllCacheName', N'ehcache:getAllCacheName', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004089, N'指定机构人员树', N'指定机构人员树', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'emp000000002', N'/employeeFront/employeeTreeById', N'employeeFront:employeeTreeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004090, N'版本管理', N'版本管理', NULL, N'/bpmVersion', N'@/bpm/views/modeling/index', N'0', N'res_menu', 2, N'0', N'1', N'1', NULL, '2021-06-07 13:39:47', NULL, NULL, N'020202010503', N'/version/view', N'version:view', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004091, N'删除基础配置', N'删除基础配置', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'sbc000000002', N'/sysBaseConfig/delete', N'sysBaseConfig:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004092, N'增加不相容角色集', N'增加不相容角色集', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000009', N'/incompatibleRolesFront/addRole', N'incompatibleRolesFront:addRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004096, N'组织机构用户树', N'组织机构用户树', 1450765592889004599, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'user00000001', N'/userFront/userTree', N'userFront:userTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004098, N'模块修改', N'模块修改', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-20 17:12:58', N'3333', N'/resource/moduleEdit', N'resourceFront:moduleEditSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004099, N'获取不相容角色集信息', N'获取不相容角色集信息', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'inco00000002', N'/incompatibleRolesFront/selectInRole', N'incompatibleRoles:selectInRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004101, N'资源删除', N'资源删除', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 18, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-26 09:37:43', N'000000000012', N'/resourceFront/delResource', N'resourceFront:delResource', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004105, N'批量新增事件页面', N'批量新增事件页面', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'cal000000001', N'/calendar/addView', N'calendar:addView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004110, N'删除附件', N'删除附件', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000003', N'/attachment/delete', N'attachment:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004112, N'用户角色审核页面', N'用户角色审核页面', 1450765592889004699, N'/userRoleVerify', N'HussarAuthorization/src/views/permit/rolemanage/userRoleVerify/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000013', N'/userRoleReview/view', N'userRoleReview:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004114, N'授权信息', N'授权信息', 1450765592889004631, N'/license', N'HussarOperations/src/views/system/license/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-06-26 08:57:20', NULL, '2019-08-26 13:44:09', N'007000780149', N'/licenseFront/view', N'license:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004115, N' 获取当前数据库内存使用大小情况', N' 获取当前数据库内存使用大小情况', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000003', N'/redis/getMemeryInfo', N'redis:getMemeryInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004118, N'删除', N'员工删除', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000014', N'/employeeFront/delEmployeeById', N'employeeFront:delEmployeeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004119, N'个性化配置快捷方式菜单树', N'个性化配置快捷方式菜单树', 1450765592889004623, NULL, NULL, N'0', N'res_btn', 2, N'0', N'1', NULL, NULL, '2021-07-29 14:20:21', NULL, NULL, N'0501', N'/frontMenu/shortCutMenuTree', N'frontMenu:shortCutMenuTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004120, N'增加下级', N'增加下级', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-26 19:46:33', N'0008', N'/menu/menuAdd', N'menu:menuAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004121, N'用户排序', N'用户排序', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000015', N'/userFront/saveUserOrder', N'userFront:saveUserOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004122, N'人员数据导出', N'人员数据导出', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, '2020-03-11 10:25:37', NULL, NULL, N'1030175', N'/employeeFront/exportData', N'employeeFront:exportData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004124, N'组织机构修改', N'组织机构修改', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2019-08-26 17:17:57', NULL, '2019-08-27 09:31:25', N'1020237', N'/orgMainFront/orgInfoEditSave', N'orgMainFront:orgInfoEditSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004131, N'基础配置', N'基础配置', 1450765592889004658, N'/baseConfig', N'HussarConfig/src/views/system/baseConfig/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2019-08-16 10:28:58', NULL, '2019-08-26 13:59:10', N'000400940168', N'/sysBaseConfig/view', N'sysBaseConfig:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004134, N'根据ID获取转移组织机构树', N'根据ID获取转移组织机构树', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 19, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'org000000004', N'/orgMainFront/orgChangeById', N'orgMainFront:orgChangeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004136, N'不相容角色集查询', N'不相容角色集查询', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 09:10:54', NULL, NULL, N'2030204', N'/incompatibleRolesFront/list', N'incompatibleRolesFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004137, N'重置密码', N'重置密码', 1450765592889004602, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-21 17:09:59', NULL, '2019-08-26 20:06:24', N'2070173', N'/userFront/resetAllPwd', N'userFront:resetAllPwd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004138, N'加载菜单树', N'加载菜单树', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'menu00000001', N'/frontMenu/menuTree', N'frontMenu:menuTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004141, N'组织机构审核页面', N'组织机构审核页面', 523064495887884288, N'/organAudit', N'HussarAuthorization/src/views/organAudit/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2019-08-16 10:24:08', NULL, '2019-08-23 09:56:47', N'007600900165', N'/sysStruAudit/view', N'sysStruAudit:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004143, N'加载角色树', N'加载角色树', 1450765592889004740, NULL, NULL, N'0', N'res_btn', 15, N'0', N'1', NULL, NULL, '2020-06-05 06:45:07', NULL, NULL, N'2020170', N'/roleManagerFront/getUserRole', N'roleManager:getUserRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004144, N'角色关联用户查看树', N'角色关联用户查看树', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000010', N'/roleManagerFront/roleUserTreeView', N'roleManagerFront:roleUserTreeView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004145, N'我的传阅', N'我的传阅', 1450765592889004711, N'/ccList', N'HussarPersonalMatters/src/views/taskmanage/ccList', N'0', N'res_menu', 1, N'0', N'1', NULL, NULL, '2020-08-12 01:55:43', NULL, NULL, N'002500950193', N'/ccTask/view', N'ccTask:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004146, N'系统监控页面', N'系统监控页面', 1450765592889004660, N'/systemMonitor', N'HussarOperations/src/views/service/systemMonitor/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-04-23 13:34:18', NULL, NULL, N'002600160043', N'/smon?action=monitor', N'smon:monitor', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004147, N'模块查看', N'模块查看', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2018-04-20 16:57:04', NULL, NULL, N'资源维护0033', N'/resource/moduleView', N'resource:moduleView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004148, N'员工维护', N'员工维护', 1450765592889004578, N'/StaffManage', N'HussarAuthorization/src/views/staffManage/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000017', N'/employee/employeeList', N'employee:employeeList', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004149, N'角色分组排序', N'角色分组排序', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2019-08-23 11:43:58', NULL, NULL, N'2020202', N'/roleManagerFront/saveGroupOrder', N'roleManagerFront:saveGroupOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004150, N'会话追踪列表', N'会话追踪列表', 1450765592889004700, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-26 20:00:41', NULL, NULL, N'5050245', N'/securityLogFront/list', N'securityLogFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004151, N'工作日历修改', N'工作日历修改', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2019-08-26 13:38:11', NULL, NULL, N'null00340227', N'/calendarFront/editEvent', N'calendar:editEvent', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004152, N'修改用户', N'修改用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000018', N'/userFront/edit', N'userFront:edit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004153, N'获取本组织机构及直属组织机构', N'获取本组织机构及直属组织机构', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 16, N'0', N'1', NULL, NULL, '2020-12-02 14:37:22', NULL, NULL, N'1020189', N'/commonOrgan/directOrgList', N'commonOrgan:searchDirectOrgList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004156, N'模块转移', N'模块转移', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, '2019-08-26 09:29:42', NULL, '2019-08-26 09:30:33', N'资源维护0210', N'/resourceFront/moduleTreeChange', N'resourceFront:moduleTreeChange', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004157, N'基础配置详情', N'基础配置详情', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'sbc000000003', N'/sysBaseConfigFront/detail', N'sysBaseConfig:detail', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004159, N'系统日志查询', N'系统日志查询', 1450765592889004583, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'log000000001', N'/logMongo/find', N'logMongo:find', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004160, N'保存用户数据权限', N'保存用户数据权限', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 19, N'0', N'1', NULL, NULL, '2021-03-05 10:05:28', NULL, NULL, N'2010503', N'/userFront/saveDataScope', N'userFront:saveDataScope', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004161, N'新增', N'组织机构新增', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:19', N'0006', N'/orgMainFront/orgInfoSave', N'orgMainFront:orgInfoSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004167, N'组织机构规则页面', N'组织机构规则页面', 1450765592889004698, N'/SysOrgRule', N'HussarAuthorization/src/views/organ/SysOrgRule', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000019', N'/orgRule/view', N'orgRule:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004168, N'用户审核新增通过', N'用户审核新增通过', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, '2019-08-23 11:20:59', NULL, NULL, N'007600900195', N'/sysUsersAuditFront/passAdd', N'sysUsersAuditFront:passAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004169, N'人员审核列表', N'人员审核列表', 523064540137791488, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 10:50:49', NULL, NULL, N'007600900191', N'/sysStaffAuditFront/list', N'sysStaffAudit:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004171, N'增加角色', N'增加角色', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:49', N'000000000020', N'/roleManagerFront/addRole', N'roleManagerFront:addRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004173, N'角色审核', N'角色审核', 1450765592889004699, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000021', N'/userRoleReviewFront/reviewSubmit', N'userRoleReviewFront:reviewSubmit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004175, N'在线用户历史记录列表', N'在线用户历史记录列表', 1450765592889004718, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'online000002', N'/onlineHistFront/list', N'onlineHist:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004176, N'删除', N'编码规则删除', 1450765592889004610, N'', N'', N'1', N'res_btn', 3, N'0', N'1', N'', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:35', N'000000000022', N'/codeRuleService/deleteCodeRule', N'codeRuleService:deleteCodeRule', N'1', N'', N'', N'', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004178, N'字段修改', N'字段修改', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, '2019-08-26 11:07:52', NULL, NULL, N'字典管理0219', N'/dicFront/update_single', N'dict:update_single', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004179, N'用户审核', N'用户审核', 1450765592889004651, N'/userAudit', N'HussarAuthorization/src/views/permit/auditManage/userAudit/index', N'1', N'res_menu', 7, N'0', N'1', N'1', NULL, '2019-08-16 10:24:22', NULL, NULL, N'007600900166', N'/user/audit', N'user:audit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004180, N'组织机构数据导出', N'组织机构数据导出', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 12, N'0', N'1', NULL, NULL, '2020-03-11 06:44:58', NULL, NULL, N'1020173', N'/orgMainFront/exportData', N'orgMainFront:exportData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004181, N'人员数据导入', N'人员数据导入', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2020-03-11 10:26:17', NULL, NULL, N'1030176', N'/employeeFront/importData', N'employeeFront:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004182, N' redis管理页面', N' redis管理页面', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000004', N'/redis/manageView', N'redis:manageView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004183, N'添加删除用户角色', N'添加删除用户角色', 1450765592889004740, NULL, NULL, N'0', N'res_btn', 18, N'0', N'1', NULL, NULL, '2020-06-05 07:12:28', NULL, NULL, N'2020182', N'roleManagerFront/addOrDelUserRole', N'roleManagerFront:addOrDelUserRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004186, N'用户管理页面', N'用户管理页面', 1450765592889004737, N'/usermanage', N'HussarAuthorization/src/views/userManager/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000024', N'/user/view', N'user:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004187, N'字典管理', N'字典管理页面', 1450765592889004593, N'/dictionary', N'HussarGeneral/src/views/system/dictionary/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, '2019-08-26 10:43:39', N'000000000025', N'/sys/dic/', N'dict:dic', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004188, N'获取穿梭框的数据', N'获取穿梭框的数据', 1450765592889004725, NULL, NULL, N'0', N'res_btn', 7, N'0', N'1', NULL, NULL, '2020-06-05 06:42:22', NULL, '2020-06-05 06:43:17', N'2030169', N'/incompatibleRolesFront/transferData', N'incompatibleRoles:transferData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004189, N'角色关联用户修改树', N'角色关联用户修改树', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000011', N'/roleManagerFront/roleUserTreeEdit', N'roleManager:roleUserTreeEdit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004190, N'不相容角色集页面', N'不相容角色集页面', 1450765592889004725, N'/alienRole', N'HussarAuthorization/src/views/permit/rolemanage/alienRole/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000026', N'/incompatibleRoles/view', N'incompatibleRoles:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004193, N'转移', N'人员转移', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-23 10:39:54', NULL, NULL, N'1030189', N'/employeeFront/staffTransfer', N'employeeFront:staffTransfer', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004198, N'组织机构维护页面', N'组织机构维护页面', 1450765592889004693, N'/OrganMaintenance', N'HussarAuthorization/src/views/organMaintenance/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, '2019-08-23 10:05:02', N'000000000027', N'/orgMain/orgList', N'orgMain:orgList', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004199, N'组织机构查看', N'组织机构查看', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 20, N'0', N'1', NULL, NULL, '2019-08-27 16:25:04', NULL, NULL, N'1020250', N'/orgMainFront/orgInfo', N'orgMainFront:orgInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004200, N'编码规则列表', N'编码规则列表', 1450765592889004610, N'', N'', N'1', N'res_btn', 7, N'0', N'1', N'', NULL, '2019-08-27 16:43:25', 1450756958461300737, '2023-05-06 15:49:48', N'100010260', N'/codeRuleService/listCodeRules', N'codeRuleService:listCodeRules', N'1', N'', N'', N'', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004201, N'会话追踪', N'会话追踪', 1450765592889004700, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000028', N'/securityLog/view2', N'securityLog:view2', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004202, N'批量下载', N'批量下载', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000004', N'/attachment/BatchDownload', N'attachment:BatchDownload', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004204, N'修改角色分组', N'修改角色分组', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:32:02', N'2020021', N'/roleManagerFront/editGroup', N'roleManagerFront:editGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004206, N'修改角色', N'修改角色', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:53', N'000000000029', N'/roleManagerFront/editRole', N'roleManagerFront:editRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004207, N'字典导入', N'字典导入', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-26 19:54:07', NULL, NULL, N'字典管理0243', N'/dicFront/importData', N'dict:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004208, N'组织机构上移/下移', N'组织机构上移/下移', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-23 10:12:48', NULL, NULL, N'1020187', N'/orgMainFront/singleMove', N'orgMain:singleMove', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004211, N'角色分组信息查看', N'角色分组信息查看', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-23 11:41:09', NULL, NULL, N'2020201', N'/roleManagerFront/roleGroupViewPage', N'roleManagerFront:roleGroupViewPage', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004212, N'字段添加', N'字段添加', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 11:06:58', NULL, '2019-08-26 18:01:45', N'字典管理0218', N'/dicFront/add_single', N'dict:add_single', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004213, N'用户注销审核通过', N'用户注销审核通过', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 16, N'0', N'1', NULL, NULL, '2019-08-26 17:36:15', NULL, NULL, N'007600900241', N'/sysUsersAuditFront/passCalcel', N'sysUsersAuditFront:passCalcel', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004214, N'资源转移', N'资源转移', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 20, N'0', N'1', NULL, NULL, '2019-08-26 09:32:21', NULL, NULL, N'资源维护0212', N'/resourceFront/resourceTreeChange', N'resourceFront:resourceTreeChange', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004218, N'资源回收', N'资源回收', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 25, N'0', N'1', NULL, NULL, '2020-02-18 06:37:13', NULL, NULL, N'资源维护0169', N'/resourceFront/retrieveResource', N'resourceFront:retrieveResource', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004220, N'资源维护页面', N'资源维护页面', 1450765592889004630, N'/resourceManage', N'HussarAuthorization/src/views/permit/resourceManage/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, '2019-08-26 09:18:55', N'000000000031', N'/resource/resList', N'resource:resList', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004222, N'变更所属部门', N'变更所属部门', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000032', N'/user/changeOrg', N'user:changeOrg', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004223, N'获取负责人列表', N'获取负责人列表', 1450765592889004693, NULL, NULL, N'0', N'res_btn', 15, N'0', N'1', NULL, NULL, '2020-06-05 06:39:23', NULL, NULL, N'1020167', N'/orgMainFront/principalSelect', N'orgMainFront:principalSelect', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004224, N'批量新增事件页面', N'批量新增事件页面', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'cal000000002', N'/calendar/deleteView', N'calendar:deleteView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004226, N'任务管理', N'任务管理', 523177259834810368, N'/bpmTask', N'BpmManageServer/src/views/taskManagement/task', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-07 13:43:12', NULL, NULL, N'020202030505', N'/bpmTask/view', N'bpmTask:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004229, N'待办任务', N'待办任务', 1450765592889004598, N'/toDoList', N'HussarPersonalMatters/src/views/taskmanage/todoList', N'1', N'res_menu', 1, N'0', N'1', NULL, NULL, '2018-04-20 18:05:34', NULL, '2018-06-11 18:19:34', N'002500120034', N'/sysTodo/view', N'sysTodo:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004230, N'模块删除', N'模块删除', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-26 09:36:46', N'000000000033', N'/resourceFront/delModule', N'resourceFront:delModule', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004235, N'系统日志下载', N'系统日志下载', 1450765592889004583, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'log000000002', N'/logMongo/dowlond', N'logMongo:dowlond', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004237, N'角色关联用户新增树', N'角色关联用户新增树', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000012', N'/roleManagerFront/roleUserTreeAdd', N'roleManager:roleUserTreeAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004239, N'功能管理', N'功能管理', 523074819135381504, N'/functionManage', N'HussarAuthorization/src/views/permit/functionManage/index', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-21 14:30:47', NULL, NULL, N'00020513', N'/function/manage', N'function:manage', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004240, N'已办任务', N'已办任务', 1450765592889004603, N'/doneList', N'HussarPersonalMatters/src/views/taskmanage/doneList', N'1', N'res_menu', 1, N'0', N'1', NULL, NULL, '2018-04-20 18:06:21', NULL, '2018-04-23 10:01:57', N'002500130035', N'/sysDone/view', N'sysDone:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004247, N'功能删除', N'功能删除', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 09:44:48', N'00003', N'/resourceFront/delFunction', N'resourceFront:delFunction', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004251, N'查看不相容角色集', N'查看不相容角色集', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'inco00000003', N'/incompatibleRolesFront/roleView', N'incompatibleRolesFront:roleView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004252, N'功能新增', N'功能新增', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 09:43:47', N'00001', N'/resourceFront/functionAdd', N'resourceFront:functionAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004253, N'下级配置项', N'下级配置项', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2021-01-18 15:46:13', NULL, '2021-01-18 15:48:21', N'000400940193', N'/sysBaseConfigFront/configList', N'sysBaseConfigFront:configList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004257, N'菜单详情页面', N'菜单详情页面', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'menu00000002', N'/frontMenu/menuInfo', N'frontMenu:menuInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004258, N' 获取当前数据库中所有db的map', N' 获取当前数据库中所有db的map', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000005', N'/redisFront/getAllRedisDatabaseList', N'redis:getAllRedisDatabaseList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004259, N'修改不相容角色集', N'修改不相容角色集', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000034', N'/incompatibleRolesFront/editRole', N'incompatibleRolesFront:editRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004261, N'用户详情', N'用户详情', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2019-08-23 11:35:25', NULL, NULL, N'2010200', N'/userFront/userInfo', N'userFront:userInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004263, N'修改基础配置', N'修改基础配置', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-21 16:58:52', NULL, '2019-08-26 13:57:16', N'000400940171', N'/sysBaseConfigFront/update', N'sysBaseConfigFront:update', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004265, N'获取组织机构树', N'获取组织机构树', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, '2020-01-13 15:46:29', NULL, NULL, N'1020327', N'/orgMainFront/orgTree', N'orgMainFront:orgTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004268, N'我的委托', N'我的委托', 1450765592889004632, N'/entrustList', N'HussarPersonalMatters/src/views/taskmanage/entrustList', N'0', N'res_menu', 1, N'0', N'1', NULL, NULL, '2020-10-09 06:46:02', NULL, '2020-10-09 07:06:39', N'002501010225', N'/entrustTask/view', N'entrustTask:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004269, N'保存资源', N'保存资源', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000002', N'/roleManagerFront/saveResource', N'roleManager:saveResource', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004270, N'修改', N'组织规则修改', 1450765592889004698, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000035', N'/orgRuleFront/edit', N'orgRule:edit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004277, N'字典新增', N'字典新增', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 12, N'0', N'1', NULL, NULL, '2020-11-04 03:21:19', NULL, '2020-11-04 03:28:30', N'字典管理0205', N'/dicFront/addGroup', N'dict:addGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004278, N'模块新增', N'模块新增', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-20 17:00:18', N'122222', N'/resource/moduleAdd', N'resourceFront:moduleAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004281, N'角色新增关联用户保存', N'角色新增关联用户保存', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000013', N'/roleManagerFront/saveRoleUserAdd', N'roleManager:saveRoleUserAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004283, N'获取用户数据权限', N'获取用户数据权限', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 18, N'0', N'1', NULL, NULL, '2021-03-05 10:04:30', NULL, NULL, N'2010502', N'/userFront/dataScope', N'userFront:dataScope', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004284, N'新增', N'组织规则新增', 1450765592889004698, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000037', N'/orgRuleFront/add', N'orgRule:add', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004285, N'日志监控', N'日志监控', 1450765592889004583, NULL, NULL, N'1', N'res_btn', 1, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000038', N'/logMongo', N'logMongo:index', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004286, N'字典上移/下移', N'字典上移/下移', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, '2019-08-27 16:32:15', NULL, NULL, N'字典管理0254', N'/dicFront/singleMove', N'dicFront:singleMove', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004288, N'修改', N'员工修改', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 10:56:37', N'00011', N'/employeeFront/employeeEdit', N'employeeFront:emplInfoEditSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004291, N'删除字典类别', N'删除字典类别', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2018-04-20 13:58:30', NULL, '2019-08-26 11:01:29', N'字典管理0030', N'/dicFront/delete', N'dict:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004292, N'资源导入', N'资源导入', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 22, N'0', N'1', NULL, NULL, '2019-08-26 09:27:34', NULL, NULL, N'资源维护0208', N'/resourceFront/importData', N'resourceFront:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004293, N'慢SQL诊断', N'慢SQL诊断', 523159993936257024, N'/slowsql', N'HussarOperations/src/views/service/slowsql/index', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-09-28 13:59:56', NULL, NULL, N'002600170152', N'/SqlMonitor/sql', N'SqlMonitor:sql', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004295, N'获取本组织机构及所有下属组织机构', N'获取本组织机构及所有下属组织机构', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 18, N'0', N'1', NULL, NULL, '2020-12-02 14:39:02', NULL, NULL, N'1020191', N'/commonOrgan/list', N'commonOrgan:searchList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004297, N'菜单修改', N'菜单修改', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 17:31:39', N'0009', N'/frontMenu/menuInfoEditSave', N'frontMenu:menuInfoEditSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004302, N'新增', N'员工新增', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-24 09:04:23', N'00010', N'/employeeFront/employeeAdd', N'employeeFront:employeeAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004305, N'获取本组织机构直属上级组织机构用户', N'获取本组织机构直属上级组织机构用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 14, N'0', N'1', NULL, NULL, '2020-12-02 14:41:26', NULL, NULL, N'2010194', N'/commonUser/superiorUserList', N'commonUser:superiorUserList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004307, N'只加载当前角色的资源树', N'只加载当前角色的资源树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 31, N'0', N'1', NULL, NULL, '2020-06-05 07:13:55', NULL, NULL, N'资源维护0184', N'resourceFront/selfResourceTree', N'resourceFront:selfResourceTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004308, N'新增资源关联角色保存', N'新增资源关联角色保存', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 34, N'0', N'1', NULL, NULL, '2020-06-05 07:16:23', NULL, NULL, N'资源维护0187', N'resourceFront/resourceAddSaveRole', N'resourceFront:resourceAddSaveRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004309, N'模块转移树', N'模块转移树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 26, N'0', N'1', NULL, NULL, '2020-06-05 06:50:04', NULL, NULL, N'资源维护0174', N'resourceFront/moduleChangeById', N'resourceFront:moduleChangeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004310, N'字典导出', N'字典导出', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2019-08-26 19:54:50', NULL, NULL, N'字典管理0244', N'/dicFront/exportDict', N'dict:exportDict', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004311, N'回收权限', N'回收权限', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000039', N'/roleManagerFront/reclaimPerm', N'roleManagerFront:reclaimPerm', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004313, N'菜单导出', N'菜单导出', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2019-08-26 10:38:52', NULL, '2019-08-26 19:46:51', N'菜单维护0216', N'/frontMenu/exportMenu', N'frontMenu:exportMenu', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004317, N'删除不相容角色集', N'删除不相容角色集', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000041', N'/incompatibleRolesFront/delRole', N'incompatibleRolesFront:delRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004320, N'用户排序树', N'用户排序树', 1450765592889004599, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'user00000002', N'/userFront/orderTree', N'userFront:orderTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004322, N'菜单删除', N'菜单删除', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 14:55:45', N'000000000042', N'/frontMenu/delMenuById', N'frontMenu:delMenuById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004323, N'查询是否已有角色集', N'查询是否已有角色集', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'inco00000004', N'/incompatibleRoles/sameRolesName', N'incompatibleRoles:sameRolesName', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004325, N'工作日历页面', N'工作日历页面', 1450765592889004611, N'/workcalendar', N'HussarGeneral/src/views/system/workcalendar/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-05-17 15:26:04', NULL, '2019-08-26 11:39:37', N'null00340107', N'/calendar/view', N'calendar:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004327, N'工作日历批量删除', N'工作日历批量删除', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 13:39:22', NULL, NULL, N'null00340228', N'/calendarFront/delEvent', N'calendar:delEvent', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004328, N'角色欢迎页新增', N'角色欢迎页新增', 1450765592889004726, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-26 13:49:26', NULL, NULL, N'000400840231', N'/sysWelcome/addRole', N'sysWelcome:addRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004329, N'检验是否已存在URL', N'是否已存在URL', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 32, N'0', N'1', NULL, NULL, '2020-06-05 07:14:41', NULL, NULL, N'资源维护0185', N'resourceFront/sameUrl', N'resource:sameUrl', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004330, N'角色修改关联用户保存', N'角色修改关联用户保存', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000014', N'/roleManagerFront/saveRoleUserEdit', N'roleManager:saveRoleUserEdit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004332, N'删除', N'组织类型删除', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:05', N'000000000043', N'/sysOrganFront/delByIds', N'sysOrganFront:delByIds', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004333, N'查询是否已有角色', N'查询是否已有角色', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000003', N'/roleManagerFront/sameRoleName', N'roleManagerFront:sameRoleName', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004334, N'登录页配置', N'登录页配置', 1450765592889004689, N'/loginConf', N'HussarConfig/src/views/personalizedConf/loginConf', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-23 11:38:52', NULL, NULL, N'020102030504', N'/personalizedConf/loginConf', N'personalizedConf:loginConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004336, N'删除欢迎页', N'删除欢迎页', 1450765592889004726, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-26 13:50:16', NULL, NULL, N'000400840232', N'/sysWelcome/delete', N'sysWelcome:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004337, N'获取资源转移树', N'获取资源转移树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 27, N'0', N'1', NULL, NULL, '2020-06-05 07:03:01', NULL, NULL, N'资源维护0175', N'resourceFront/resourceChangeById', N'resourceFront:resourceChangeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004338, N'用户审核转移通过', N'用户审核转移通过', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 14, N'0', N'1', NULL, NULL, '2019-08-23 11:23:32', NULL, NULL, N'007600900198', N'/sysUsersAuditFront/passTrans', N'sysUsersAuditFront:passTrans', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004339, N'操作', N'添加不相容角色', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'2030023', N'/incompatibleRolesFront/saveInRoles', N'incompatibleRolesFront:saveInRoles', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004342, N'组织机构转移', N'组织机构转移', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2019-08-23 10:09:20', NULL, NULL, N'1020186', N'/orgMainFront/orgTreeChange', N'orgMainFront:orgTreeChange', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004344, N'资源保存', N'资源保存', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 19, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 10:41:19', N'0005', N'/resource/resourceEditSave', N'resourceFront:resourceSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004345, N'文件下载', N'文件下载', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000005', N'/attachment/fileDownload', N'attachment:fileDownload', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004347, N'编码规则维护页面', N'编码规则维护页面', 1450765592889004610, N'/customCodingRules', N'HussarCodePlus/src/views/customCodingRules/index', N'1', N'res_menu', 2, N'0', N'1', N'1', NULL, '2019-08-23 09:44:27', 1450756958461300737, '2023-04-28 11:30:15', N'id0000000001', N'', N'idtable:idtableManage', N'0', N'', N'', N'', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004348, N'新增用户', N'新增用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000044', N'/userFront/add', N'userFront:add', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004349, N'获取某个资源关联的角色树', N'获取某个资源关联的角色树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 33, N'0', N'1', NULL, NULL, '2020-06-05 07:15:29', NULL, NULL, N'资源维护0186', N'resourceFront/roleTreeView', N'resourceFront:roleTreeView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004351, N'审计日志页面', N'审计日志页面', 1450765592889004756, N'/auditlog', N'HussarAudit/src/views/system/auditlog/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000045', N'/securityLog/view', N'securityLog:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004354, N'解冻密码', N'解冻密码', 1450765592889004746, N'/thawcode', N'HussarOperations/src/views/system/thawcode/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2019-02-21 16:02:11', NULL, '2019-08-26 11:27:00', N'null01390318', N'/thawPwd/view', N'thawPwd:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004356, N'函数管理', N'函数管理', 523177287164895232, N'/bpmFunction', N'BpmManageServer/src/views/function/index', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-07 13:54:48', NULL, NULL, N'020202040507', N'/bpmFunction/view', N'bpmFunction:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004357, N'下级排序', N'菜单树下级排序', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-26 19:46:36', N'000000000046', N'/frontMenu/menuTreeOrder', N'frontMenu:menuTreeOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004358, N'根据父ID获取下级菜单树', N'根据父ID获取下级菜单树', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'menu00000003', N'/frontMenu/menuTreeById', N'frontMenu:menuTreeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004363, N'组织机构修改页面', N'组织机构修改页面', 1450765592889004693, NULL, NULL, N'0', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 17:21:47', NULL, NULL, N'1020239', N'/orgMainFront/orgInfoEdit', N'orgMain:edit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004364, N'检查重复权限', N'检查重复权限', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 19, N'0', N'1', NULL, NULL, '2021-01-18 17:57:02', NULL, NULL, N'2020194', N'/roleManagerFront/checkResource', N'roleManagerFront:checkResource', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004366, N'用户审核详情', N'用户审核详情', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2019-08-23 11:17:32', NULL, NULL, N'007600900192', N'/sysUsersAuditFront/detail', N'sysUsersAuditFront:detail', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004368, N'懒加载获取角色用户树', N'懒加载获取角色用户树', 1450765592889004740, NULL, NULL, N'0', N'res_btn', 16, N'0', N'1', NULL, NULL, '2020-06-05 07:10:24', NULL, NULL, N'202018002', N'roleManagerFront/lazyRoleUserTreeView', N'roleManager:lazyRoleUserTreeView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004369, N'根据模块ID获取下级功能树', N'根据模块ID获取下级功能树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 29, N'0', N'1', NULL, NULL, '2020-06-05 06:47:14', NULL, NULL, N'2020171', N'resourceFront/functionTreeById', N'resourceFront:functionTreeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004371, N'获取日历事件类型下拉框', N'获取日历事件类型下拉框', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'cal000000003', N'/calendar/calendarEventTypeOption', N'calendar:calendarEventTypeOption', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004378, N'新增', N'组织类型新增', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:30:59', N'000000000049', N'/sysOrganFront/add', N'sysOrganFront:add', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004380, N'显示图片', N'显示图片', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000001', N'/attachment/showPicture', N'attachment:showPicture', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004382, N'新增字典类别', N'新增字典类别', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2018-04-20 13:55:35', NULL, '2019-08-26 18:02:32', N'字典管理0027', N'/dicFront/add', N'dict:add', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004383, N'查询', N'组织规则查询', 1450765592889004698, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000050', N'/orgRuleFront/list', N'orgRule:search', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004384, N'字典修改', N'字典修改', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, '2020-11-04 13:43:57', NULL, NULL, N'字典管理0206', N'/dicFront/editGroup', N'dict:editGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004390, N'组织机构操作审核详情', N'组织机构操作审核详情', 523064495887884288, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'007600900182', N'/sysStruAuditFront/detail', N'sysStruAudit:detail', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004391, N'查询是否已有分组', N'查询是否已有分组', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000004', N'/roleManagerFront/sameGroupName', N'roleManagerFront:sameGroupName', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004393, N'文件上传回显', N'文件上传回显', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2020-12-07 11:36:05', NULL, NULL, N'附件监控0201', N'/attachment/uploadFileQuery', N'attachment:uploadFileQuery', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004394, N'组织机构排序', N'组织机构人员排序', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2019-08-23 10:13:54', NULL, '2019-08-23 10:41:54', N'1020188', N'/orgMainFront/orgTreeOrder', N'orgMainFront:orgTreeOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004395, N'菜单维护', N'菜单维护', 1450765592889004616, N'/menumaintain', N'HussarAuthorization/src/views/menumaintain/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000052', N'/menu/menuList', N'menu:menuList', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004397, N'资源下级排序', N'资源下级排序', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 21, N'0', N'1', NULL, NULL, '2019-08-26 09:24:59', NULL, NULL, N'资源维护0207', N'/resourceFront/resourceTreeOrder', N'resourceFront:resourceTreeOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004400, N'获取本级用户列表', N'获取本级用户列表', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 16, N'0', N'1', NULL, NULL, '2021-01-14 16:05:52', NULL, '2021-01-14 16:08:13', N'2010191', N'/userFront/accountList', N'userFront:accountList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004401, N'用户审核修改详情', N'用户审核修改详情', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-23 11:18:53', NULL, NULL, N'007600900193', N'/sysUsersAuditFront/editDetail', N'sysUsersAuditFront:editDetail', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004403, N' 删除redis key', N' 删除redis key', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000007', N'/redisFront/deleteNoSQLKeys', N'redis:deleteNoSQLKeys', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004404, N'资源新增', N'资源新增', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 16, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-26 09:37:18', N'000000000053', N'/resourceFront/resourceAdd', N'resourceFront:resourceAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004406, N'用户审核删除通过', N'用户审核删除通过', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, '2019-08-23 11:23:01', NULL, NULL, N'007600900197', N'/sysUsersAuditFront/passDel', N'sysUsersAuditFront:passDel', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004407, N'重置密码页面', N'重置密码页面', 1450765592889004602, N'/resetpassword', N'HussarOperations/src/views/system/resetpassword/index', N'1', N'res_menu', 2, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000054', N'/user/pageResetAllPwd', N'user:pageResetAllPwd', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004409, N'注销用户', N'注销用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 9, N'0', N'1', NULL, NULL, '2019-08-26 16:59:51', NULL, NULL, N'2010236', N'/userFront/cancelUser', N'userFront:cancelUser', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004410, N'根据功能ID获取资源树', N'根据功能ID获取资源树', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 28, N'0', N'1', NULL, NULL, '2020-06-05 06:48:03', NULL, NULL, N'2020172', N'resourceFront/resourceTreeById', N'resourceFront:resourceTreeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004411, N'角色复制', N'角色复制', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000055', N'/userFront/copyRole', N'userFront:copyRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004413, N'解冻', N'删除缓存', 1450765592889004746, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-26 11:28:11', NULL, '2019-08-27 17:51:38', N'null01390221', N'/ehcacheFront/deleteByKeys', N'ehcache:deleteByKeys', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004414, N'在线用户页面', N'在线用户页面', 1450765592889004700, N'/onlineuser', N'HussarAudit/src/views/system/onlineuser/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000056', N'/online/view', N'online:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004416, N'授权文件上传', N'授权文件上传', 1450765592889004631, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'lic000000001', N'/licenseFront/upload', N'license:upload', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004417, N'获取角色数据权限', N'获取角色数据权限', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 20, N'0', N'1', NULL, NULL, '2021-03-05 11:30:07', NULL, NULL, N'2020504', N'/roleManagerFront/dataScope', N'roleManager:dataScope', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004421, N'字段删除', N'字段删除', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2019-08-26 11:11:48', NULL, NULL, N'字典管理0220', N'/dicFront/delete_single', N'dict:delete_single', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004422, N'角色数据导入', N'角色数据导入', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 14, N'0', N'1', NULL, NULL, '2020-03-13 10:02:32', NULL, NULL, N'202018001', N'/roleManagerFront/importData', N'roleManagerFront:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004427, N'查看', N'员工查看', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000057', N'/employeeFront/employeeInfo', N'employeeFront:employeeInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004429, N'多文件上传', N'多文件上传', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000006', N'/attachment/uploadfilewithdrag', N'attachment:uploadfilewithdrag', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004432, N'加载角色树', N'加载角色树', 1450765592889004740, NULL, NULL, N'0', N'res_btn', 12, N'0', N'1', NULL, NULL, '2020-01-13 15:45:06', NULL, NULL, N'2020326', N'/roleManagerFront/roleTree', N'roleManagerFront:roleTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004433, N'查询角色分组下的角色', N'查询角色分组下的角色', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000005', N'/roleManagerFront/searchRoleToGroup', N'roleManagerFront:searchRoleToGroup', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004434, N'修改', N'组织类型修改', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:03', N'000000000058', N'/sysOrganFront/edit', N'sysOrganFront:edit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004437, N'菜单新增', N'菜单新增', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-26 19:50:14', NULL, '2019-08-26 19:52:05', N'菜单维护0242', N'/frontMenu/menuInfoSave', N'frontMenu:menuInfoSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004440, N'根据组织机构的stru_id ，获取本组织机构用户', N'根据组织机构的stru_id ，获取本组织机构用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 12, N'0', N'1', NULL, NULL, '2020-12-02 14:40:16', NULL, NULL, N'201019202', N'/commonUser/userList', N'commonUser:userList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004443, N'获取当前部门下的用户关联角色的信息', N'获取当前部门下的用户关联角色的信息', 1450765592889004740, NULL, NULL, N'0', N'res_btn', 17, N'0', N'1', NULL, NULL, '2020-06-05 07:11:14', NULL, NULL, N'2020181', N'roleManagerFront/getRoleOrgUser', N'roleManagerFront:getRoleOrgUser', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004444, N'用户角色列表', N'用户角色列表', 1450765592889004699, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-27 16:28:36', NULL, NULL, N'2040252', N'/userRoleReviewFront/list', N'userRoleReviewFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004445, N'新增', N'编码规则新增', 1450765592889004610, N'', N'', N'1', N'res_btn', 2, N'0', N'1', N'', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:01', N'000000000061', N'/codeRuleService/saveCodeRule', N'codeRuleService:saveCodeRule', N'1', N'', N'', N'', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004449, N'解冻密码列表', N'获取缓存列表', 1450765592889004746, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-27 16:42:04', NULL, '2019-08-27 16:59:03', N'null01390259', N'/ehcacheFront/list', N'ehcache:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004450, N'重置密码用户列表', N'重置密码用户列表', 1450765592889004735, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-27 16:40:39', NULL, NULL, N'2060258', N'/userFront/userList', N'userFront:userList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004452, N'加载角色分组排序树', N'加载角色分组排序树', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000015', N'/roleManagerFront/groupOrderTree', N'roleManager:groupOrderTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004453, N'我的催办', N'我的催办', 1450765592889004597, N'/urgeList', N'HussarPersonalMatters/src/views/taskmanage/urgeList', N'0', N'res_menu', 1, N'0', N'1', NULL, NULL, '2020-08-12 01:55:01', NULL, NULL, N'002500940192', N'/sysActUrgeTask/view', N'sysActUrgeTask:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004454, N'人员审核', N'人员审核页面', 523064540137791488, N'/staffAudit', N'HussarAuthorization/src/views/staffAudit/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, '2019-08-16 10:25:03', NULL, '2019-08-23 11:12:26', N'007600900167', N'/sysStaffAuditFront/view', N'sysStaffAudit:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004456, N'在线用户列表', N'在线用户列表', 1450765592889004700, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'online000001', N'/onlineFront/list', N'online:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004457, N'审计日志明细', N'审计日志明细', 1450765592889004756, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000062', N'/securityLogFront/cmdDetail', N'securityLogFront:cmdDetail', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004460, N'资源导出', N'资源导出', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 23, N'0', N'1', NULL, NULL, '2019-08-26 09:28:06', NULL, NULL, N'资源维护0209', N'/resourceFront/exportRes', N'resourceFront:exportRes', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004461, N'获取日志目录树', N'获取日志目录树', 1450765592889004701, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logD00000001', N'/logDownloadFront/logTree', N'logDownload:logTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004462, N'获取日历事件', N'获取日历事件', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'cal000000004', N'/calendarFront/list', N'calendar:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004464, N'欢迎页列表权限', N'欢迎页列表权限', 1450765592889004726, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, '2019-08-26 13:52:18', NULL, NULL, N'000400840234', N'/sysWelcome/list', N'sysWelcome:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004465, N'修改资源关联角色保存', N'修改资源关联角色保存', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 35, N'0', N'1', NULL, NULL, '2020-06-05 07:17:09', NULL, NULL, N'资源维护0188', N'resourceFront/resourceEditSaveRole', N'resourceFront:resourceEditSaveRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004466, N'工作日历单日删除', N'工作日历单日删除', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, '2019-08-26 13:40:36', NULL, NULL, N'null00340229', N'/calendarFront/delOneEvent', N'calendar:delOneEvent', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004469, N'组织类型列表', N'组织类型列表', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'orgtype00001', N'/orgType/orgTypeOption', N'orgType:orgTypeOption', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004470, N'  清空日志', N'  清空日志', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000001', N'/redis/logEmpty', N'redis:logEmpty', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004472, N'角色查看页面', N'角色查看页面', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000006', N'/roleManager/roleViewPage', N'roleManager:roleViewPage', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004473, N'资源下放', N'资源下放', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 24, N'0', N'1', NULL, NULL, '2020-02-18 06:36:11', NULL, NULL, N'资源维护0168', N'/resourceFront/delegateResource', N'resourceFront:delegateResource', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004474, N'实例管理', N'实例管理', 523177216750919680, N'/bpmProcess', N'BpmManageServer/src/views/processinst/process', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-07 13:42:36', NULL, NULL, N'020202020504', N'/bpmProcess/view', N'bpmProcess:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004477, N'用户审核驳回', N'用户审核驳回', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 15, N'0', N'1', NULL, NULL, '2019-08-23 11:24:16', NULL, NULL, N'007600900199', N'/sysUsersAuditFront/reject', N'sysUsersAuditFront:reject', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004481, N'用户审核列表', N'用户审核列表', 1450765592889004651, NULL, NULL, N'1', N'res_btn', 10, N'0', N'1', NULL, NULL, '2019-08-23 11:19:52', NULL, NULL, N'007600900194', N'/sysUsersAuditFront/listAudit', N'sysUsersAuditFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004482, N' 模糊查询', N' 模糊查询', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000006', N'/redisFront/showRedisDBValue', N'redis:showRedisDBValue', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004485, N'功能查看', N'功能查看', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 12, N'0', N'1', NULL, NULL, '2019-08-26 09:35:34', NULL, NULL, N'资源维护0213', N'/resourceFront/functionView', N'resourceFront:functionView', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004486, N'组织机构操作审核列表', N'组织机构操作审核列表', 523064495887884288, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 10:00:11', NULL, NULL, N'007600900185', N'/sysStruAuditFront/list', N'sysStruAudit:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004487, N'菜单上移/下移', N'菜单上移/下移', 1450765592889004616, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, '2019-08-27 14:55:08', NULL, '2019-08-27 19:12:56', N'菜单维护0249', N'/frontMenu/singleMove', N'frontMenu:singleMove', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004488, N'功能转移', N'功能转移', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 14, N'0', N'1', NULL, NULL, '2019-08-26 09:31:32', NULL, NULL, N'资源维护0211', N'/resourceFront/functionTreeChange', N'resourceFront:functionTreeChange', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004492, N'文件上传', N'文件上传', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000007', N'/attachment/attachment:upload', N'attachment:upload', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004493, N'修改', N'编码规则修改', 1450765592889004610, N'', N'', N'1', N'res_btn', 4, N'0', N'1', N'', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:14', N'000000000064', N'/codeRuleService/updateCodeRule', N'codeRuleService:updateCodeRule', N'1', N'', N'', N'', N'', 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004495, N'在线历史记录页面', N'在线历史记录页面', 1450765592889004718, N'/onlinehistory', N'HussarAudit/src/views/system/onlinehistory/index', N'1', N'res_menu', 1, N'0', N'1', N'1', NULL, NULL, NULL, NULL, N'000000000065', N'/onlineHist/view', N'onlineHist:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004497, N'修改用户欢迎页配置', N'修改用户欢迎页配置', 1450765592889004726, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'wel000000002', N'/sysWelcome/sysWelcome_update', N'sysWelcome:sysWelcome_update', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004499, N'删除', N'组织规则删除', 1450765592889004698, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000066', N'/orgRuleFront/delete', N'orgRule:delete', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004501, N'加载角色排序树', N'加载角色排序树', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000016', N'/roleManagerFront/roleOrderTree', N'roleManagerFront:roleOrderTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004502, N'获取本组织机构所有下属组织机构的用户', N'获取本组织机构所有下属组织机构的用户', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 17, N'0', N'1', NULL, NULL, '2020-12-02 14:38:09', NULL, NULL, N'1020190', N'/commonOrgan/directList', N'commonOrgan:searchDirectList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004503, N'保存角色数据权限', N'保存角色数据权限', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 21, N'0', N'1', NULL, NULL, '2021-03-05 11:31:07', NULL, NULL, N'2020505', N'/roleManagerFront/saveDataScope', N'roleManager:saveDataScope', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004507, N'快捷入口配置', N'快捷入口配置', 1450765592889004623, N'/shortCutConf', N'HussarConfig/src/views/personalizedConf/shortCutConf', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-23 11:54:08', NULL, NULL, N'020102080510', N'/personalizedConf/shortCurConf', N'personalizedConf:shortCutConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004508, N'组织机构新增页面', N'组织机构新增页面', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-27 09:28:18', NULL, NULL, N'1020247', N'/orgMainFront/orgInfoAdd', N'orgMainFront:orgInfoAdd', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004509, N'导入', N'编码规则导入', 1450765592889004610, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2019-08-26 11:36:14', NULL, '2019-08-26 20:14:40', N'100010222', N'/idtableFront/importData', N'idtable:importData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004510, N'组织机构人员树', N'组织机构人员树', 1450765592889004578, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'emp000000001', N'/employeeFront/employeeTree', N'employeeFront:employeeTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004512, N'角色数据导出', N'角色数据导出', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, '2020-03-13 10:02:05', NULL, NULL, N'2020179', N'/roleManagerFront/exportData', N'roleManagerFront:exportData', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004513, N'慢SQL列表', N'慢SQL列表', 523159993936257024, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'sql000000001', N'/sqlMonitorFront/list', N'SqlMonitor:list', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004514, N'附件信息列表', N'附件信息列表', 1450765592889004614, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'atta00000002', N'/attachment/getAttachmentList', N'attachment:getAttachmentList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004515, N'日志下载', N'日志下载', 1450765592889004701, N'/logdownload', N'HussarOperations/src/views/service/logdownload/index', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2018-08-29 19:09:12', NULL, NULL, N'null00780148', N'/logDownload/view', N'logDownload:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004516, N'角色新增页面', N'角色新增页面', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000007', N'/roleManager/roleAddPage', N'roleManager:roleAddPage', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004517, N'框架页配置', N'框架页配置', 1450765592889004732, N'/layoutConf', N'HussarConfig/src/views/personalizedConf/layoutConf', N'0', N'res_menu', 1, N'0', N'1', N'1', NULL, '2021-06-23 11:40:01', NULL, NULL, N'020102040506', N'/personalizedConf/layoutConf', N'personalizedConf:layoutConf', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004519, N'驳回', N'角色审核驳回', 1450765592889004699, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'2040024', N'/userRoleReviewFront/refuseSubmit', N'userRoleReviewFront:refuseSubmit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004521, N'组织机构ID获取组织机构树', N'组织机构ID获取组织机构树', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 21, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'org000000002', N'/orgMainFront/orgTreeById', N'orgMainFront:orgTreeById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004522, N'获取日志文件列表', N'获取日志文件列表', 1450765592889004701, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logD00000002', N'/logDownloadFront/logTable', N'logDownload:logTable', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004526, N'查询', N'组织类型查询', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000067', N'/sysOrganFront/list', N'sysOrganFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004529, N'资源修改', N'资源修改', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 17, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-27 16:19:47', N'000034', N'/resource/resourceEdit', N'resourceFront:resourceEditSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004530, N'字典下级排序', N'字典下级排序', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2018-04-20 13:59:43', NULL, '2019-08-26 11:04:57', N'字典管理0031', N'/dicFront/sort', N'dicFront:sort', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004533, N'当前用户所在的组织机构', N'当前用户所在的组织机构', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 15, N'0', N'1', NULL, NULL, '2020-12-02 14:42:50', NULL, NULL, N'2010195', N'/commonUser/currentUserInfo', N'commonUser:currentUserInfo', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004536, N'删除角色', N'删除角色', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000068', N'/roleManagerFront/delRole', N'roleManagerFront:delRole', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004539, N'删除', N'组织机构删除', 1450765592889004693, NULL, NULL, N'1', N'res_btn', 7, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000069', N'/orgMainFront/delOrgById', N'orgMainFront:delOrgById', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004544, N'模块保存', N'模块保存', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 6, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-20 17:05:49', N'mod401370313', N'/resourceFront/moduleSave', N'resourceFront:moduleSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004545, N' 获取当前数据库中key的数量', N' 获取当前数据库中key的数量', 1450765592889004621, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'logR00000002', N'/redisFront/getKeysSize', N'redis:getKeysSize', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004546, N'组织类型详情', N'组织类型详情', 1450765592889004653, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'orgtype00002', N'/sysOrganFront/selectOrg', N'sysOrganFront:selectOrg', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004551, N'基础配置列表权限', N'基础配置列表权限', 1450765592889004658, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-26 13:58:06', NULL, NULL, N'000400940235', N'/sysBaseConfigFront/list', N'sysBaseConfigFront:getList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004554, N'修改欢迎页', N'修改欢迎页', 1450765592889004726, NULL, NULL, N'1', N'res_btn', 5, N'0', N'1', NULL, NULL, '2019-08-26 13:51:01', NULL, NULL, N'000400840233', N'/sysWelcome/update', N'sysWelcome:update', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004555, N'角色排序', N'角色排序', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 11, N'0', N'1', NULL, NULL, '2019-08-23 11:46:02', NULL, NULL, N'2020203', N'/roleManagerFront/saveRoleOrder', N'roleManagerFront:saveRoleOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004556, N'工作日历单日新增', N'工作日历单日新增', 1450765592889004611, NULL, NULL, N'1', N'res_btn', 4, N'0', N'1', NULL, NULL, '2019-08-26 13:36:50', NULL, NULL, N'null00340226', N'/calendarFront/addOneEvent', N'calendar:addOneEvent', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004558, N'终止会话', N'终止会话', 1450765592889004700, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, NULL, NULL, NULL, N'000000000002', N'/onlineFront/stopSession', N'online:stopSession', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004559, N'获取不相容角色资源', N'获取不相容角色资源', 1450765592889004725, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'inco00000001', N'/incompatibleRolesFront/selectInRoles', N'incompatibleRoles:selectInRoles', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004563, N'修改字典类别', N'修改字典类别', 1450765592889004593, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2018-04-20 13:57:13', NULL, '2019-08-26 10:58:24', N'字典管理0029', N'/dicFront/edit', N'dict:edit', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004564, N'查询回收下放树', N'查询回收下放树', 1450765592889004693, NULL, NULL, N'0', N'res_btn', 14, N'0', N'1', NULL, NULL, '2020-06-05 06:36:52', NULL, NULL, N'1020166', N'/orgMainFront/getDelegateRetrieveTree', N'orgMainFront:getDeReTree', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004565, N'根据code获取字典', N'根据code获取字典', 1450765592889004630, NULL, NULL, N'0', N'res_btn', 30, N'0', N'1', NULL, NULL, '2020-06-05 07:07:33', NULL, NULL, N'资源维护0177', N'/dicFront/getDictByCode', N'dict:getDictByCode', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004566, N'角色修改页面', N'角色修改页面', 1450765592889004740, NULL, NULL, N'1', N'res_btn', 2, N'0', N'1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, N'role00000008', N'/roleManager/roleEditPage', N'roleManager:roleEditPage', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004567, N'模块下级排序', N'资源模块下级排序', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 8, N'0', N'1', NULL, NULL, '2019-08-26 09:22:21', NULL, NULL, N'资源维护0205', N'/resourceFront/moduleTreeOrder', N'resourceFront:moduleTreeOrder', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004569, N'组织机构操作审核', N'组织机构操作审核', 523064495887884288, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2019-08-23 09:43:51', NULL, NULL, N'007600900181', N'/sysStruAuditFront/verify', N'sysStruAudit:verify', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004570, N'登陆统计', N'登陆统计页面', 1450765592889004756, NULL, NULL, N'1', N'res_btn', 3, N'0', N'1', NULL, NULL, '2018-09-28 14:15:44', NULL, '2019-08-26 11:20:23', N'5070153', N'/loginStatistics/view', N'loginStatistics:view', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004571, N'获取本组织机构直接下级组织机构用户', N'获取本组织机构直接下级组织机构用户', 1450765592889004737, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, '2020-12-02 14:40:48', NULL, NULL, N'2010193', N'/commonUser/juniorUserList', N'commonUser:juniorUserList', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (1450765592889004572, N'功能保存', N'功能保存', 1450765592889004630, NULL, NULL, N'1', N'res_btn', 13, N'0', N'1', NULL, NULL, NULL, NULL, '2018-04-23 09:51:51', N'00012', N'/resourceFront/functionSave', N'resourceFront:functionSave', N'1', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581431768348106752, N'流程状态分析', N'流程状态分析', 564389571845169152, N'/processStatus', N'BpmBPA/src/views/processAnalysis/processStatus', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:42:16', 1450756958461300737, '2022-05-26 15:55:09', N'02150540', N'', N'bpa:processStatus', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581432525403201536, N'流程参与者分析', N'流程参与者分析', 564389571845169152, N'/processParticipantAnalysis', N'BpmBPA/src/views/processAnalysis/processParticipantAnalysis', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:45:17', 1450756958461300737, '2022-05-31 15:07:23', N'02150542', N'', N'bpa:processParticipantAnalysis', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581434143087534080, N'流程统计分析', N'流程统计分析', 564389571845169152, N'/processStatisticalAnalysis', N'BpmBPA/src/views/processAnalysis/processStatisticalAnalysis', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:51:42', 1450756958461300737, '2022-06-02 09:06:32', N'02150544', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581434493471301632, N'热门流程分析', N'热门流程分析', 581434239535554560, N'/popularProcessAnalysis', N'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/popularProcessAnalysis', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:53:06', 1450756958461300737, '2022-05-26 15:55:20', N'02390545', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581434937987833856, N'流程数量分析', N'流程数量分析', 581434239535554560, N'/processQuantityAnalysis', N'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processQuantityAnalysis', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:54:52', 1450756958461300737, '2022-06-06 14:07:46', N'02390548', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581435215210356736, N'用户流程分析', N'用户流程分析', 581434239535554560, N'/personProcessAnalysis', N'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/personProcessAnalysis', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:55:58', 1450756958461300737, '2022-05-31 16:48:16', N'02390550', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581435962006183936, N'待办任务分析', N'待办任务分析', 581434239535554560, N'/todoTaskAnalysis', N'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/todoTaskAnalysis', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 10:58:56', 1450756958461300737, '2022-06-01 17:02:52', N'02390551', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (581436516656750592, N'流程耗时分析', N'流程耗时分析', 564389571845169152, N'/processTimeAnalysis', N'BpmBPA/src/views/processAnalysis/timeAnalysis/processTimeAnalysis', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2022-05-24 11:01:08', 1450756958461300737, '2022-06-02 09:58:19', N'02400554', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (586205441340743680, N'流程驳回分析', N'流程驳回分析', 581434239535554560, N'/processRejectAnalysis', N'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processRejectAnalysis', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2022-06-06 14:51:08', 1450756958461300737, '2022-06-06 18:01:02', N'02390555', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (564389067157151744, N'流程概览', N'流程概览', 564389571845169152, N'/processOverview', N'BpmBPA/src/views/processAnalysis/processOverview', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-04-07 10:00:39', 1450756958461300737, '2022-05-26 15:51:56', N'02340002', N'', N'bpa:view', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576425225089196032, N'委托待办', N'委托待办', 576446323717578752, N'/entrustTodoList', N'HussarPersonalMatters/src/views/taskmanage/entrustTodoList', N'1', N'res_menu', 1, N'0', N'1', NULL, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', N'00250645', N'/entrustTodo', N'entrustTodo:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576437892923269120, N'委托已办', N'委托已办', 576437727940321280, N'/entrustDoneList', N'HussarPersonalMatters/src/views/taskmanage/entrustDoneList', N'1', N'res_menu', 1, N'0', N'1', NULL, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', N'02690646', N'/entrustDone', N'entrustDone:list', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (545564853264457728, N'统一日志', N'统一日志', 545564576406839296, N'/unifiedLog', N'HussarUnifiedLog/src/views/unifiedLog/unifiedLog', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', N'02150001', N'/unifiedLog', N'unifiedLog:View', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (546343017720848384, N'链路追踪', N'链路追踪', 545564576406839296, N'/linkTracking', N'HussarUnifiedLog/src/views/linkTracking/linkTracking', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', N'02160001', N'/linkTracking', N'linkTracking:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (546346988292284416, N'错误统计', N'错误统计', 545564576406839296, N'/errorStatistics', N'HussarUnifiedLog/src/views/errorStatistics/errorStatistics', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', N'02170002', N'/errorStatistics', N'errorStatistics:view', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (592385945366700032, N'告警设置', N'告警设置', 592385645452992512, N'/logSet', N'HussarUnifiedLog/src/views/logWarn/logSet', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', N'02160501', N'', N'logSet:view', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (592391481915088896, N'告警记录', N'告警记录', 592385645452992512, N'/logRecord', N'HussarUnifiedLog/src/views/logWarn/logRecord', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', N'02160502', N'', N'logRecord:view', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (595571989650087936, N'首页配置', N'首页配置', 595571579120001024, N'/portalConfiguration', N'HussarMobileConfig/src/views/mobileConfig/portalConfiguration', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-07-02 11:10:28', 1450756958461300737, '2022-07-02 11:26:39', N'02150502', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (595572170466533376, N'三方集成', N'三方集成', 595571579120001024, N'/tripartiteIntegration', N'HussarMobileConfig/src/views/mobileConfig/tripartiteIntegration', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-07-02 11:11:11', 1450756958461300737, '2022-07-02 11:28:14', N'02150503', N'', N'', N'0', N'', NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576444545517232128, N'通道管理', N'通道管理', 576443985825112064, N'/msg/smsSend/sendMsgSms', N'HussarMessage/src/views/smsService/SmsChannel', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:24:49', 1450756958461300737, '2022-05-15 14:30:43', N'02200006', N'/smsService/smsChannel', N'smsService:smsChannel', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576445297899872256, N'签名管理', N'签名管理', 576443985825112064, N'/smsService/Signature', N'HussarMessage/src/views/smsService/Signature', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:27:49', 1450756958461300737, '2022-05-11 14:43:43', N'02200007', N'/smsService/Signature', N'smsService:Signature', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576445557296603136, N'模板管理', N'模板管理', 576443985825112064, N'/smsService/smsTemplate', N'HussarMessage/src/views/smsService/SmsTemplate', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:28:51', 1450756958461300737, '2022-05-15 16:53:08', N'02200008', N'/smsService/smsTemplate', N'smsService:smsTemplate', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576445740617048064, N'发送测试', N'发送测试', 576443985825112064, N'/smsService/SendSMS', N'HussarMessage/src/views/smsService/SendSMS', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:29:34', 1450756958461300737, '2022-05-11 14:44:07', N'02200009', N'/smsService/SendSMS', N'smsService:SendSMS', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576445901988700160, N'发送记录', N'发送记录', 576443985825112064, N'/smsService/smsSendRecord', N'HussarMessage/src/views/smsService/SendRecord', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:30:13', 1450756958461300737, '2022-05-15 17:58:23', N'02200010', N'/smsService/smsSendRecord', N'smsService:smsSendRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (576446061217062912, N'发送统计', N'发送统计', 576443985825112064, N'/smsService/sendRateReport', N'HussarMessage/src/views/smsService/SendRateReport', N'0', N'res_menu', 6, N'0', N'1', N'1', 1450756958461300737, '2022-05-10 16:30:51', 1450756958461300737, '2022-05-11 13:49:45', N'02200011', N'/smsService/sendRateReport', N'smsService:sendRateReport', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (577910957540646912, N'通道管理', N'通道管理', 576919005307346944, N'/mailService/mChannel', N'HussarMessage/src/views/mailService/MChannel', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-14 17:31:49', 1450756958461300737, '2022-05-15 11:16:41', N'02220010', N'/mailService/mChannel', N'mailService:mChannel', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (577920052196810752, N'发送记录', N'发送记录', 576919005307346944, N'/mailService/mailSendRecord', N'HussarMessage/src/views/mailService/MailSendRecord', N'0', N'res_menu', 6, N'0', N'1', N'1', 1450756958461300737, '2022-05-14 18:07:58', 1450756958461300737, '2022-05-15 11:16:42', N'02220011', N'/mailService/mailSendRecord', N'mailService:mailSendRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (577951344581943296, N'单发测试', N'单发测试', 576919005307346944, N'/mailService/mSendTest', N'HussarMessage/src/views/mailService/SendTest', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-14 20:12:18', 1450756958461300737, '2022-05-19 17:55:46', N'02220012', N'/mailService/mSendTest', N'mailService:mSendTest', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (577951711264776192, N'群发测试', N'群发测试', 576919005307346944, N'/mailService/groupHair', N'HussarMessage/src/views/mailService/GroupHair', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-14 20:13:46', 1450756958461300737, '2022-05-15 11:44:26', N'02220013', N'/mailService/groupHair', N'mailService:groupHair', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (577951935202861056, N'收件人管理', N'收件人管理', 576919005307346944, N'/mailService/recipient', N'HussarMessage/src/views/mailService/Recipient', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2022-05-14 20:14:39', 1450756958461300737, '2022-05-15 11:16:42', N'02220014', N'/mailService/recipient', N'mailService:recipient', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578178840069939200, N'模板管理', N'模板管理', 576919005307346944, N'/mailService/mTemplate', N'HussarMessage/src/views/mailService/MTemplate', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 11:16:18', 1450756958461300737, '2022-05-15 11:16:41', N'02220015', N'/mailService/mTemplate', N'mailService:mTemplate', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578180013862690816, N'发送统计', N'发送统计', 576919005307346944, N'/mailService/readedStatistics', N'HussarMessage/src/views/mailService/ReadedStatistics', N'0', N'res_menu', 7, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 11:20:57', 1450756958461300737, '2022-05-22 10:39:09', N'02220016', N'/mailService/readedStatistics', N'mailService:readedStatistics', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578224814087741440, N'通道管理', N'通道管理', 578221171997417472, N'/mpService/111publicAccount', N'HussarMessage/src/views/mpService/PublicAccount', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 14:18:59', 1450756958461300737, '2022-05-15 14:18:59', N'02270003', N'/mpService/111publicAccount', N'mpService:publicAccount', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578225070686871552, N'模板管理', N'模板管理', 578221171997417472, N'/mpService/mpTemplate', N'HussarMessage/src/views/mpService/MPTemplate', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 14:20:00', 1450756958461300737, '2022-05-15 14:20:00', N'02270004', N'/mpService/mpTemplate', N'mpService:mpTemplate', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578225260298772480, N'发送测试', N'发送测试', 578221171997417472, N'/mpService/messageTesting', N'HussarMessage/src/views/mpService/MessageTesting', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 14:20:45', 1450756958461300737, '2022-05-15 14:20:45', N'02270005', N'/mpService/messageTesting', N'mpService:messageTesting', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (578225470362099712, N'发送记录', N'发送记录', 578221171997417472, N'/mpService/pushRecord', N'HussarMessage/src/views/mpService/PushRecord', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-15 14:21:35', 1450756958461300737, '2022-05-15 14:21:35', N'02270006', N'/mpService/pushRecord', N'mpService:pushRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (582661309611646976, N'发送统计', N'发送统计', 578221171997417472, N'/mpService/sendStatistics', N'HussarMessage/src/views/mpService/SendedStatisticss', N'0', N'res_menu', 5, N'0', N'1', N'1', 1450756958461300737, '2022-05-27 20:08:02', 1450756958461300737, '2022-05-29 18:26:46', N'02270008', N'/mpService/sendStatistics', N'mpService:SendedStatisticss', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579400593928626176, N'通道管理', N'通道管理', 579399930809163776, N'/appImService/appImChannel', N'HussarMessage/src/views/appImService/AppImChannel', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:11:06', 1450756958461300737, '2022-05-20 11:00:38', N'02280002', N'/appImService/appImChannel', N'appImService:appImChannel', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579401699782041600, N'发送测试', N'发送测试', 579399930809163776, N'/appImService/appImSendedTested', N'HussarMessage/src/views/appImService/AppImSendedTested', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:15:30', 1450756958461300737, '2022-05-20 11:16:40', N'02280005', N'/appImService/appImSendedTested', N'appImService:appImSendedTested', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579402283595603968, N'发送统计', N'发送统计', 579399930809163776, N'/appImService/appImDataStatistics', N'HussarMessage/src/views/appImService/AppImDataStatistics', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:17:49', 1450756958461300737, '2022-05-20 11:00:38', N'02280007', N'/appImService/appImDataStatistics', N'appImService:appImDataStatistics', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579986784054943744, N'发送记录', N'发送记录', 579399930809163776, N'/appImService/appImSendRecord', N'HussarMessage/src/views/appImService/AppImSendRecord', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-20 11:00:25', 1450756958461300737, '2022-05-20 11:00:38', N'02280011', N'/appImService/appImSendRecord', N'appImService:appImSendRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579406581389860864, N'通道管理', N'通道管理', 579405620386734080, N'/appPushService/appPushChannel', N'HussarMessage/src/views/appPushService/AppPushChannel', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:34:54', 1450756958461300737, '2022-05-18 20:34:54', N'02290001', N'/appPushService/appPushChannel', N'appPushService:appPushChannel', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579406782007615488, N'发送测试', N'发送测试', 579405620386734080, N'/appPushService/appPushTest', N'HussarMessage/src/views/appPushService/AppPushTest', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:35:42', 1450756958461300737, '2022-05-20 17:17:28', N'02290002', N'/appPushService/appPushTest', N'appPushService:appPushTest', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579406956977201152, N'发送记录', N'发送记录', 579405620386734080, N'/appPushService/appPushReecorded', N'HussarMessage/src/views/appPushService/AppPushReecorded', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:36:23', 1450756958461300737, '2022-05-20 18:14:35', N'02290003', N'/appPushService/appPushReecorded', N'appPushService:appPushReecorded', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (579407194467082240, N'发送统计', N'发送统计', 579405620386734080, N'/appPushService/appPushStatistics', N'HussarMessage/src/views/appPushService/AppPushStatistics', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-05-18 20:37:20', 1450756958461300737, '2022-05-21 14:10:21', N'02290004', N'/appPushService/appPushStatistics', N'appPushService:appPushStatistics', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587709219764183040, N'发送记录', N'发送记录', 587706862284316672, N'/noticeService/noticeSendRecord', N'HussarMessage/src/views/noticeService/NoticeSendRecord', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-06-10 18:26:37', 1450756958461300737, '2022-06-10 18:26:37', N'02360005', N'/noticeService/noticeSendRecord', N'noticeService:noticeSendRecord', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587709399175536640, N'发送统计', N'发送统计', 587706862284316672, N'/noticeService/noticeStatistics', N'HussarMessage/src/views/noticeService/NoticeStatistics', N'0', N'res_menu', 3, N'0', N'1', N'1', 1450756958461300737, '2022-06-10 18:27:20', 1450756958461300737, '2022-06-10 18:27:20', N'02360006', N'/noticeService/noticeStatistics', N'noticeService:noticeStatistics', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (588042819223166976, N'发送测试', N'发送测试', 587706862284316672, N'/noticeService/noticePushTest', N'HussarMessage/src/views/noticeService/NoticePushTest', N'0', N'res_menu', 4, N'0', N'1', N'1', 1450756958461300737, '2022-06-11 16:32:13', 1450756958461300737, '2022-06-11 16:32:13', N'02360008', N'/noticeService/noticePushTest', N'noticeService:noticePushTest', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587942765325983744, N'短信', N'短信', 587942618739253248, N'/msg/sms/sendSmsMsg', N'', N'0', N'res_btn', 1, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:54:39', 1450756958461300737, '2022-06-23 14:04:21', N'02370001', N'/msg/sms/sendSmsMsg', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587942870816923648, N'公众号', N'公众号', 587942618739253248, N'/msg/mp/sendMpMsg', N'', N'0', N'res_btn', 2, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:55:04', 1450756958461300737, '2022-06-23 14:04:36', N'02370002', N'/msg/mp/sendMpMsg', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943035611127808, N'AppImText', N'AppImText', 587942618739253248, N'/msg/appIm/send/text', N'', N'0', N'res_btn', 3, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:55:43', 1450756958461300737, '2022-06-11 09:55:43', N'02370003', N'/msg/appIm/send/text', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943112647909376, N'AppImArticle', N'AppImArticle', 587942618739253248, N'/msg/appIm/send/article', N'', N'0', N'res_btn', 4, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:56:02', 1450756958461300737, '2022-06-11 09:56:02', N'02370004', N'/msg/appIm/send/article', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943196252971008, N'AppImImg', N'AppImImg', 587942618739253248, N'/msg/appIm/send/img', N'', N'0', N'res_btn', 5, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:56:21', 1450756958461300737, '2022-06-11 09:56:21', N'02370005', N'/msg/appIm/send/img', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943277567942656, N'AppImFile', N'AppImFile', 587942618739253248, N'/msg/appIm/send/file', N'', N'0', N'res_btn', 6, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:56:41', 1450756958461300737, '2022-06-11 09:56:41', N'02370006', N'/msg/appIm/send/file', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943412431593472, N'邮件单发', N'邮件单发', 587942618739253248, N'/msg/msgMail/send', N'', N'0', N'res_btn', 7, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:57:13', 1450756958461300737, '2022-06-11 09:57:13', N'02370007', N'/msg/msgMail/send', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943534536171520, N'邮件批量发送', N'邮件批量发送', 587942618739253248, N'/msg/msgMail/bathsend', N'', N'0', N'res_btn', 8, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:57:42', 1450756958461300737, '2022-06-11 09:57:42', N'02370008', N'/msg/msgMail/bathsend', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (587943645634895872, N'App推送', N'App推送', 587942618739253248, N'/msg/appPushInfo/add', N'', N'0', N'res_btn', 9, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 09:58:09', 1450756958461300737, '2022-06-11 09:58:09', N'02370009', N'/msg/appPushInfo/add', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (588023442222358528, N'内部消息', N'内部消息', 587942618739253248, N'/msg/notice/send/insertOrUpdate', N'', N'0', N'res_btn', 10, N'0', N'0', NULL, 1450756958461300737, '2022-06-11 15:15:14', 1450756958461300737, '2022-06-11 15:15:14', N'02370010', N'/msg/notice/send/insertOrUpdate', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (588788708602552320, N'短信获取通道列表', N'短信获取通道列表', 587942618739253248, N'/msg/smsSend/getChannelList', N'', N'0', N'res_btn', 11, N'0', N'0', NULL, 1450756958461300737, '2022-06-13 17:56:07', 1450756958461300737, '2022-06-13 17:56:07', N'02370011', N'/msg/smsSend/getChannelList', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (588788977285472256, N'短信获取签名列表', N'短信获取签名列表', 587942618739253248, N'/msg/smsSend/getSignListByChannelId', N'', N'0', N'res_btn', 12, N'0', N'0', NULL, 1450756958461300737, '2022-06-13 17:57:11', 1450756958461300737, '2022-06-13 17:57:11', N'02370012', N'/msg/smsSend/getSignListByChannelId', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (588796112652214272, N'短信获取模板列表', N'短信获取模板列表', 587942618739253248, N'/msg/smsSend/getTemplateListByChannelId', N'', N'0', N'res_btn', 13, N'0', N'0', NULL, 1450756958461300737, '2022-06-13 18:25:33', 1450756958461300737, '2022-06-13 18:25:33', N'02370013', N'/msg/smsSend/getTemplateListByChannelId', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (589368589979754496, N'获取邮件模板列表', N'获取邮件模板列表', 587942618739253248, N'/msg/msgMail/getTemplateList', N'', N'0', N'res_btn', 14, N'0', N'0', NULL, 1450756958461300737, '2022-06-15 08:20:22', 1450756958461300737, '2022-06-15 08:20:22', N'02370015', N'/msg/msgMail/getTemplateList', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (589368748763521024, N'获取公众号通道列表', N'获取公众号通道列表', 587942618739253248, N'/msg/mp/send/getChannelList', N'', N'0', N'res_btn', 15, N'0', N'0', NULL, 1450756958461300737, '2022-06-15 08:21:00', 1450756958461300737, '2022-06-15 08:21:00', N'02370016', N'/msg/mp/send/getChannelList', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (589369116763365376, N'获取微信公众号模板列表', N'获取微信公众号模板列表', 587942618739253248, N'/msg/mp/send/getTemplateListByChannelId', N'', N'0', N'res_btn', 16, N'0', N'0', NULL, 1450756958461300737, '2022-06-15 08:22:27', 1450756958461300737, '2022-06-15 08:22:27', N'02370018', N'/msg/mp/send/getTemplateListByChannelId', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (589369233557954560, N'获取APPIM通道列表', N'获取APPIM通道列表', 587942618739253248, N'/msg/appIm/send/getChannelList', N'', N'0', N'res_btn', 17, N'0', N'0', NULL, 1450756958461300737, '2022-06-15 08:22:55', 1450756958461300737, '2022-06-15 08:22:55', N'02370019', N'/msg/appIm/send/getChannelList', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (589369324108783616, N'获取APP推送通道列表', N'获取APP推送通道列表', 587942618739253248, N'/msg/appPushInfo/getChannelList', N'', N'0', N'res_btn', 18, N'0', N'0', NULL, 1450756958461300737, '2022-06-15 08:23:17', 1450756958461300737, '2022-06-15 08:23:17', N'02370020', N'/msg/appPushInfo/getChannelList', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (596648540198150144, N'上传文件', N'上传文件', 587942618739253248, N'/msg/attachment/uploadfilewithdrag', N'', N'0', N'res_btn', 19, N'0', N'0', NULL, 1450756958461300737, '2022-07-05 10:28:17', 1450756958461300737, '2022-07-05 10:28:17', N'02370022', N'/msg/attachment/uploadfilewithdrag', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (609687682360287232, N'服务类型', N'服务类型', 587942618739253248, N'/msg/app/access/getAppService', N'', N'0', N'res_btn', 20, N'0', N'0', NULL, 1450756958461300737, '2022-08-10 10:01:11', 1450756958461300737, '2022-08-10 10:01:11', N'02370524', N'/msg/app/access/getAppService', N'', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (596353576553684992, N'应用管理', N'应用管理', 596352625377812480, N'/appService/appManage', N'HussarMessage/src/views/appService/AppManage', N'0', N'res_menu', 1, N'0', N'1', N'1', 1450756958461300737, '2022-07-04 14:56:12', 1450756958461300737, '2022-07-04 14:56:12', N'02490002', N'/appService/appManage', N'appService:appManage', N'0', NULL, NULL, NULL, NULL, 1, NULL)
;
INSERT INTO [SYS_RESOURCES] ([RESOURCE_ID], [RESOURCE_NAME], [RESOURCE_ALIAS], [MODULE_ID], [PATH], [COMPONENT], [IS_AUDIT], [RES_TYPE_ID], [SEQ], [IS_REPEAT_AUTHENTICATE], [STRATEGY], [KEEP_ALIVE], [CREATOR], [CREATE_TIME], [LAST_EDITOR], [LAST_TIME], [RESOURCE_CODE], [URL_NAMES], [PERMISSIONS], [IS_SYS], [SERVICE_NAME], [USER_RIGHTS], [DEPT_RIGHTS], [MAPPER], [APPLICATION_ID], [PARENT_RESOURCE_ID]) VALUES (608974704010862592, N'场景管理', N'场景管理', 596352625377812480, N'/appService/sceneManage', N'HussarMessage/src/views/appService/SceneManage', N'0', N'res_menu', 2, N'0', N'1', N'1', 1450756958461300737, '2022-08-08 10:48:04', 1450756958461300737, '2022-08-08 11:25:22', N'02490523', N'/appService/sceneManage', N'appService:sceneMa