

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for SYS_AD_IGNORE_SHOW
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AD_IGNORE_SHOW`;
CREATE TABLE `SYS_AD_IGNORE_SHOW` (
    `IGNORE_ID` BIGINT(20) NOT NULL COMMENT 'id',
    `AD_ID` BIGINT(20) DEFAULT NULL COMMENT '横幅主键',
    `CREATOR` BIGINT(20) DEFAULT NULL COMMENT '创建人',
    `CREATE_TIME` DATETIME DEFAULT NULL COMMENT '创建时间',
    `LAST_EDITOR` BIGINT(20) DEFAULT NULL COMMENT '最后一次修改人',
    `LAST_TIME` DATETIME DEFAULT NULL COMMENT '最后一次修改时间',
    PRIMARY KEY (`IGNORE_ID`)
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '横幅关闭记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for BPM_ACT_ASSIGNEE
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ASSIGNEE`;
CREATE TABLE `BPM_ACT_ASSIGNEE`  (
  `ACT_ASSIGNEE_ID` bigint(20) NOT NULL COMMENT '主键',
  `PROC_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程标识',
  `TASK_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `CONTENT` longblob NULL COMMENT '内容',
  `CONTENT_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型  defaultAssign 默认参与者  conditionAssign 条件参与者  defaultCcAssign 默认传阅人  conditionCcAssign 条件传阅人  defaultCcEndAssign 默认节点结束传阅人  conditionCcEndAssign 条件节点结束传阅人  assign_model 参与者配置  cc_assign_model 传阅人配置  cc_end_assign_model 节点结束传阅人配置  defaultCallAssignee 外部子流程默认参与者  defaultCallProcessKey 外部子流程默认流程标识  conditionCallAssign 外部子流程条件参与者  conditionCallProcessKey 外部子流程条件流程标识',
  `MESSAGE_TYPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息提醒方式',
  `PROCESS_VERSION` int(11) NULL DEFAULT NULL COMMENT '流程版本',
  PRIMARY KEY (`ACT_ASSIGNEE_ID`) USING BTREE,
  INDEX `IDX_BPM_ACT_ASSIGNEE`(`PROC_DEF_KEY` ASC, `TASK_DEF_KEY` ASC, `CONTENT_TYPE` ASC, `PROCESS_VERSION` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程模型参与者表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ASSIGNEE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_BUSINESS_CONFIG
-- ----------------------------

DROP TABLE IF EXISTS `SYS_BUSINESS_CONFIG`;
CREATE TABLE `SYS_BUSINESS_CONFIG` (
  `CONFIG_ID` bigint(19) NOT NULL COMMENT '业务主键',
  `CONFIG_NAME` varchar(255) DEFAULT NULL COMMENT '配置名称',
  `CONFIG_SCENE` varchar(255) DEFAULT NULL COMMENT '场景',
  `CONFIG_TAG` varchar(255) DEFAULT NULL COMMENT '标签',
  `CONFIG_TYPE` int(11) DEFAULT NULL COMMENT '配置类型（0系统：所有人可见，1个人：创建者可见）',
  `PERMISSION_RULE` text NULL COMMENT '自定义配置规则',
  `CONFIG_KEY` varchar(255) DEFAULT NULL COMMENT '配置key',
  `CONFIG_VALUE` longtext NULL COMMENT '配置值',
  `REMARK1` varchar(255) DEFAULT NULL COMMENT '扩展字段1（是否默认、排序权重等通过扩展字段配置）',
  `REMARK2` varchar(255) DEFAULT NULL COMMENT '扩展字段2（是否默认、排序权重等通过扩展字段配置）',
  `REMARK3` varchar(255) DEFAULT NULL COMMENT '扩展字段3（是否默认、排序权重等通过扩展字段配置）',
  `CREATOR` bigint(20) DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) DEFAULT NULL COMMENT '是否删除',
  PRIMARY KEY (`CONFIG_ID`)
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务配置管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_COMMONLY_USE_ORGAN_USER`;
CREATE TABLE `SYS_COMMONLY_USE_ORGAN_USER` (
  `COMMONLY_USE_ID` bigint(19) NOT NULL COMMENT '主键id',
  `COMMONLY_USE_TYPE` int(11) DEFAULT NULL COMMENT '类型(0：部门，1：用户)',
  `ORGAN_USER_ID` bigint(19) DEFAULT NULL COMMENT '部门/用户id',
  `USE_COUNT` int(11) DEFAULT NULL COMMENT '使用次数',
  `CREATOR` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) DEFAULT NULL COMMENT '是否删除',
  PRIMARY KEY (`COMMONLY_USE_ID`)
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '常用选人选部门' ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for BPM_ACT_CANDIDATE_USER
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CANDIDATE_USER`;
CREATE TABLE `BPM_ACT_CANDIDATE_USER`  (
  `CANDIDATE_USER_ID` bigint(20) NOT NULL COMMENT '主键',
  `TASK_ID` bigint(20) NOT NULL COMMENT '任务id',
  `ASSIGNEE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '参与者',
  PRIMARY KEY (`CANDIDATE_USER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '节点候选人信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CANDIDATE_USER
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_CC_TASK
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CC_TASK`;
CREATE TABLE `BPM_ACT_CC_TASK`  (
  `CC_TASK_ID` bigint(20) NOT NULL COMMENT '主键',
  `TASK_ID` bigint(20) NULL DEFAULT NULL COMMENT '任务ID',
  `PROC_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '实例ID',
  `PROC_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `TASK_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务名称',
  `SEND_USER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人',
  `RECEIVE_USER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收人',
  `SEND_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '发送时间',
  `END_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '阅读时间',
  `FORM_KEY` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `PROC_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `BUSINESS_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `TASK_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `TASK_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '传阅状态 0 未读 1 已读',
  `CC_MOMENT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '传阅时机 0节点启动时 1节点结束时 2手动传阅',
  `TEXT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '待办配置',
  `FORM_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  PRIMARY KEY (`CC_TASK_ID`) USING BTREE,
  INDEX `ACT_IDX_CC_TASK_RECEIVE_USER`(`RECEIVE_USER` ASC) USING BTREE,
  INDEX `ACT_IDX_CC_TASK_TASK_ID`(`TASK_ID` ASC) USING BTREE,
  INDEX `CC_TASK_PROC_INS_ID`(`PROC_INST_ID` ASC) USING BTREE,
  INDEX `TIMESORT`(`SEND_TIME` ASC, `END_TIME` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '传阅表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CC_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CONFIG`;
CREATE TABLE `BPM_ACT_CONFIG`  (
  `CONFIG_ID` bigint(20) NOT NULL COMMENT '主键',
  `NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置名',
  `CONFIG_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '键',
  `CONFIG_VALUE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值',
  `OPTION_VALUE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可选值',
  `CALL_BACK_ADDRESS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求地址',
  `LAST_EDITOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DESCRIPTION` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '上级ID',
  `CONFIG_RULE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '校验规则',
  PRIMARY KEY (`CONFIG_ID`) USING BTREE,
  UNIQUE INDEX `CONFIG_KEY_UNIQUE`(`CONFIG_KEY` ASC) USING BTREE COMMENT '配置项唯一'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作流配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CONFIG
-- ----------------------------
INSERT INTO `BPM_ACT_CONFIG` VALUES (10000, '基础配置', 'bpm_basic_config', NULL, NULL, NULL, NULL, NULL, '工作流基础配置项', 1, NULL);
INSERT INTO `BPM_ACT_CONFIG` VALUES (10001, '是否启用密级', 'use_security_level', 'false', NULL, NULL, NULL, NULL, '使用流程密级需满足如下两个条件：<br>1、启动流程时指定该流程密级。<br>2、开启密级配置项。<br>满足条件后则该流程只为密级大于等于自身密级的参与者分配待办。<br>注：可通过如下参数为流程指定密级variables.put(BpmConstant.SECURITY_LEVEL, 3)', 10000, 'checkRadio');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10002, '办理历史排序规则', 'complete_history_ordering_rule', 'todo-in-front', 'todo-in-front:待办在前，已办按照办理时间升序,create-time-asc:按接收时间升序,create-time-desc:按接收时间降序,todo-in-front-desc:待办在前，已办按办理时间降序', NULL, NULL, NULL, '办理历史排序规则', 10000, 'checkOption');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10003, '请求建立连接超时时间', 'connection_timeout', '6000', NULL, NULL, NULL, NULL, '工作流调用http请求建立连接超时时间，单位为ms。<br>函数、监听器的远程模式；远程接口模式获取参与者；流程平台推送统一待办需调用http请求', 10000, 'checkNum');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10004, '请求传递数据超时时间', 'read_timeout', '6000', NULL, NULL, NULL, NULL, '工作流调用http请求传递数据超时时间，单位为ms。<br>函数、监听器的远程模式；远程接口模式获取参与者；流程平台推送统一待办需调用http请求', 10000, 'checkNum');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10005, '是否推送统一待办', 'use_data_push', 'false', NULL, NULL, NULL, NULL, '是否推送统一待办。', 10000, 'checkRadio');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10006, '统一待办服务', 'unified_todo_server_name', 'hussarUnifiedToDoDataPush', NULL, NULL, NULL, NULL, '请选择将任务推送至哪方统一待办服务中', 10000, 'checkOption');
INSERT INTO `BPM_ACT_CONFIG` VALUES (10007, '是否开启远程推送', 'remote_data_push', 'false', NULL, NULL, NULL, NULL, '如果开启远程推送则需要配置统一待办数据推送地址', 10000, 'checkRadio');
INSERT INTO `BPM_ACT_CONFIG` VALUES (20000, '轻骑兵统一待办', 'hussar_unified_todo', NULL, NULL, NULL, NULL, NULL, '工作流对接轻骑兵统一待办相关配置', 1, NULL);
INSERT INTO `BPM_ACT_CONFIG` VALUES (20001, '统一待办应用编码', 'unified_system_id', '524168298611613696', NULL, NULL, NULL, NULL, '统一待办应用编码', 20000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (20002, '客户端ID', 'client_id', 'unified_server', NULL, NULL, NULL, NULL, '客户端ID', 20000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (20003, '客户端秘钥', 'client_secret', 'unified_server', NULL, NULL, NULL, NULL, '客户端秘钥', 20000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (20004, '统一待办推送地址', 'unified_to_do_call_address', 'http://127.0.0.1:8280', NULL, NULL, NULL, NULL, '统一待办推送地址。', 20000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30000, '消息中心', 'bpm_msg', NULL, NULL, NULL, NULL, NULL, '工作流对接消息中心相关配置', 1, NULL);
INSERT INTO `BPM_ACT_CONFIG` VALUES (30001, '消息中心应用编码', 'msg_app_id', 'workflow', NULL, NULL, NULL, NULL, '消息中心应用编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30002, '消息中心应用秘钥', 'msg_app_secret', '426bd4e7571f0bc777bbc48545582313', NULL, NULL, NULL, NULL, '消息中心应用秘钥', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30003, '待办场景代码', 'todo_scene_code', 'todo', NULL, NULL, NULL, NULL, '消息中心待办场景代码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30004, '驳回场景编码', 'reject_scene_code', 'reject', NULL, NULL, NULL, NULL, '消息中心驳回场景编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30005, '催办场景编码', 'reminders_scene_code', 'reminders', NULL, NULL, NULL, NULL, '消息中心催办场景编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30006, '委托场景编码', 'entrust_scene_code', 'entrust', NULL, NULL, NULL, NULL, '消息中心委托场景编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30007, '流程完成编码', 'complete_scene_code', 'complete', NULL, NULL, NULL, NULL, '消息中心流程完成编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30008, '流程终止编码', 'terminated_scene_code', 'terminated', NULL, NULL, NULL, NULL, '消息中心流程终止编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (30009, '流程异常编码', 'exception_scene_code', 'exception', NULL, NULL, NULL, NULL, '消息中心流程异常编码', 30000, 'checkNotEmpty');
INSERT INTO `BPM_ACT_CONFIG` VALUES (40000, '租户配置信息', 'tenant_info', NULL, NULL, NULL, NULL, NULL, '租户相关配置信息', 1, NULL);
INSERT INTO `BPM_ACT_CONFIG` VALUES (40001, '参与者获取模式', 'assignee_mode', 'import', 'import:本地模式,remote-datasource:外部数据源', NULL, NULL, NULL, '参与者获取模式', 40000, 'checkOption');
INSERT INTO `BPM_ACT_CONFIG` VALUES (40002, '外部数据源名称', 'remote_db_name', NULL, NULL, '/datasource/queryDBNameListUncorrelated', NULL, NULL, '外部数据源名称', 40000, 'checkCallBack');
INSERT INTO `BPM_ACT_CONFIG` VALUES (40003, '表名前缀', 'table_prefix', NULL, NULL, NULL, NULL, NULL, '当时多个租户使用同一个外部数据源模式时，可通过前缀控制数据查询范围。', 40000, 'notCheck');
INSERT INTO `BPM_ACT_CONFIG` VALUES (40004, '回调地址', 'tenant_call_address', 'http://127.0.0.1:8280', NULL, NULL, NULL, NULL, '回调地址。<br>函数、监听器的远程模式；远程接口模式获取参与者；工作流获取变量等功能需要回调特定接口，在此指定服务ip端口号用以回调。', 40000, 'checkNotEmpty');

-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_CATEGORY
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CUSTOM_CATEGORY`;
CREATE TABLE `BPM_ACT_CUSTOM_CATEGORY`  (
  `CATEGORY_ID` bigint(20) NOT NULL COMMENT '分类id',
  `CATEGORY_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类名',
  `CATEGORY_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父级id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `EXTRA_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`CATEGORY_ID`) USING BTREE,
  INDEX `PARENT_ID_IDX`(`PARENT_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '分类维护表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CUSTOM_CATEGORY
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_COMMENT
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CUSTOM_COMMENT`;
CREATE TABLE `BPM_ACT_CUSTOM_COMMENT`  (
  `COMMENT_ID` bigint(20) NOT NULL COMMENT '主键',
  `COMMENT_INFO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '意见内容',
  `COMMENT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '意见类型，1为驳回',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间	',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `COMMENT_SORT` int(11) NULL DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`COMMENT_ID`) USING BTREE,
  INDEX `IDX_CREATE`(`CREATOR` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义意见表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CUSTOM_COMMENT
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_FORM
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CUSTOM_FORM`;
CREATE TABLE `BPM_ACT_CUSTOM_FORM`  (
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `FORM_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单名称',
  `FORM_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `FORM_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序',
  `FORM_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型 Web：Web端 Mobile：移动端',
  `CATEGORY_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属分类',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `EXTRA_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`FORM_ID`) USING BTREE,
  INDEX `CATEGORY_ID_IDX`(`CATEGORY_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '三方表单维护表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CUSTOM_FORM
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_FORM_INFO
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_CUSTOM_FORM_INFO`;
CREATE TABLE `BPM_ACT_CUSTOM_FORM_INFO`  (
  `FORM_INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `COMPONENT_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件编码',
  `COMPONENT_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件名',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父级组件',
  `FORM_INFO_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `EXTRA_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `EXTRA_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`FORM_INFO_ID`) USING BTREE,
  INDEX `FORM_ID_IDX`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_CUSTOM_FORM_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_ENTRUST
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ENTRUST`;
CREATE TABLE `BPM_ACT_ENTRUST`  (
  `ENTRUST_ID` bigint(20) NOT NULL COMMENT 'ID主键',
  `MANDATOR` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '委托人',
  `PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程ID',
  `MANDATARY` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被委托人ID',
  `START_TIME` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `END_TIME` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态  1 启用  0 禁用',
  `TASK_DEF_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `IS_TRANSFER` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否移交任务  1 移交  0 不移交',
  `MESSAGE_TYPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息提醒方式  sms 短信  mail 邮件  wx_account 微信公众号  app_im IM  app_push APP通知  notice 内部通知 cp 企业微信',
  `ENTRUST_TASK_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '委托类型',
  PRIMARY KEY (`ENTRUST_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '委托表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ENTRUST
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_EVT_LOG
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_EVT_LOG`;
CREATE TABLE `BPM_ACT_EVT_LOG`  (
  `LOG_NR_` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `TYPE_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `TIME_STAMP_` timestamp NULL DEFAULT NULL COMMENT '时间',
  `USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `DATA_` longblob NULL COMMENT '数据',
  `LOCK_OWNER_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '锁定人',
  `LOCK_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '锁定时间',
  `IS_PROCESSED_` tinyint NULL DEFAULT 0 COMMENT '是否处理',
  PRIMARY KEY (`LOG_NR_`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '事件日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_EVT_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_EXTEND_PROPERTIES
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_EXTEND_PROPERTIES`;
CREATE TABLE `BPM_ACT_EXTEND_PROPERTIES`  (
  `EXTEND_PROPERTIES_ID` bigint(20) NOT NULL COMMENT '主键',
  `PROC_DEF_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  `TASK_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点ID',
  `TASK_DEF_NAME` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点名称',
  `FORM_DETAIL_KEY` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `ASSIST_FORM_DETAIL_KEY` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '协办表单详情',
  `CC_FORM_DETAIL_KEY` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '传阅表单详情',
  `ATTRIBUTE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标识扩展的属性类型',
  `FORM_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  PRIMARY KEY (`EXTEND_PROPERTIES_ID`) USING BTREE,
  UNIQUE INDEX `IDX_BPM_ACT_EXTEND_PROPERTIES`(`PROC_DEF_ID` ASC, `TASK_DEF_KEY` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程拓展信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_EXTEND_PROPERTIES
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_FORM_AUTH
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_FORM_AUTH`;
CREATE TABLE `BPM_ACT_FORM_AUTH`  (
  `FORM_AUTH_ID` bigint(20) NOT NULL COMMENT '主键',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `FORM_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单名称',
  `PROCESS_DEFINITION_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `TASK_DEFINITION_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点ID',
  `PROCESS_VERSION` int(11) NULL DEFAULT NULL COMMENT '流程版本',
  `INS_DISABLED` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '禁用组件',
  `INS_HIDDEN` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '隐藏组件',
  `SLOT_HIDDEN` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '组件隐藏配置',
  `FORM_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型的标识  1 参与者已办表单  2 参与者待办表单  4 协办人待办表单  5 协办人已办表单  6  传阅人待办表单  7 传阅人已办表单',
  `FORM_STATE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型 (WebPage/MobilePage)',
  `INS_NOT_CHECK` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '无需校验组件',
  `FORM_CHECK_PARAM` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表单校验相关配置参数',
  `INS_WRITE` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '可编辑组件',
  `INS_REQUIRED` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '必填组件',
  `SINGLE_SELECT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '指定审批人单选',
  `DEFAULT_OPINION` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '默认意见',
  `INS_SHOW` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '显示组件',
  `INS_ONLY_DOWNLOAD` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '下载组件',
  `INS_AUTO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '智能获取组件',
  PRIMARY KEY (`FORM_AUTH_ID`) USING BTREE,
  INDEX `PROCESS_INDEX`(`PROCESS_DEFINITION_KEY` ASC, `TASK_DEFINITION_KEY` ASC) USING BTREE,
  INDEX `PROCESS_VERSION_INDEX`(`PROCESS_VERSION` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作流权限配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_FORM_AUTH
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_FUNCTION
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_FUNCTION`;
CREATE TABLE `BPM_ACT_FUNCTION`  (
  `FUNCTION_ID` bigint(20) NOT NULL COMMENT '主键',
  `FUNCTION_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '函数名称',
  `FUNCTION_BEAN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '函数BEANID',
  `FUNCTION_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '函数类型 local：本地调用 remote：远程调用',
  `REQUEST_METHOD` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '远程调用请求类型 GET POST',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `UPDATE_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属应用Id',
  PRIMARY KEY (`FUNCTION_ID`) USING BTREE,
  UNIQUE INDEX `BPM_ACT_FUNTION_BEAN_ID_INDEX`(`FUNCTION_BEAN` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '函数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_FUNCTION
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_FUNCTION_PARM
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_FUNCTION_PARM`;
CREATE TABLE `BPM_ACT_FUNCTION_PARM`  (
  `PARM_ID` bigint(20) NOT NULL COMMENT '主键',
  `FUNCTION_ID` bigint(20) NULL DEFAULT NULL COMMENT '函数主键',
  `PARM_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数名称',
  `PARM_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数标识',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `UPDATE_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PARM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '函数参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_FUNCTION_PARM
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_GE_BYTEARRAY
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_GE_BYTEARRAY`;
CREATE TABLE `BPM_ACT_GE_BYTEARRAY`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `DEPLOYMENT_ID_` bigint(20) NULL DEFAULT NULL COMMENT '部署id',
  `BYTES_` longblob NULL COMMENT '数据',
  `GENERATED_` tinyint NULL DEFAULT NULL COMMENT '是否是引擎生成',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_FK_BYTEARR_DEPL`(`DEPLOYMENT_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '二进制数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_GE_BYTEARRAY
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_GE_PROPERTY
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_GE_PROPERTY`;
CREATE TABLE `BPM_ACT_GE_PROPERTY`  (
  `NAME_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `VALUE_` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '乐观锁',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '值',
  PRIMARY KEY (`NAME_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '属性数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO `BPM_ACT_GE_PROPERTY` VALUES ('next.dbid', '447501', 180);
INSERT INTO `BPM_ACT_GE_PROPERTY` VALUES ('schema.history', 'create(5.22.0.0)', 1);
INSERT INTO `BPM_ACT_GE_PROPERTY` VALUES ('schema.version', '5.22.0.0', 1);

-- ----------------------------
-- Table structure for BPM_ACT_HANDLE_AUTH
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HANDLE_AUTH`;
CREATE TABLE `BPM_ACT_HANDLE_AUTH`  (
  `HANDLE_AUTH_ID` bigint(20) NOT NULL COMMENT '主键',
  `PROCESS_DEFINITION_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `TASK_DEFINITION_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点ID',
  `PROCESS_VERSION` int(11) NULL DEFAULT NULL COMMENT '流程版本',
  `HANDLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作名称',
  `HANDLE_ICON` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图标',
  `HANDLE_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作类型  Save：保存Submit提交  RejectLast：驳回上一  RejectFirst：驳回发起  EndProcess：终结  EntrustTask：转办  Revoke：撤回',
  `FORM_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型的标识  1 参与者已办表单  2 参与者待办表单  4 协办人待办表单  5 协办人已办表单  6  传阅人待办表单  7 传阅人已办表单',
  `EXTEND_CONFIGURATION` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展配置',
  PRIMARY KEY (`HANDLE_AUTH_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '操作权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HANDLE_AUTH
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_ACTINST
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_ACTINST`;
CREATE TABLE `BPM_ACT_HI_ACTINST`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程定义id',
  `PROC_INST_ID_` bigint(20) NOT NULL COMMENT '流程实例id',
  `EXECUTION_ID_` bigint(20) NOT NULL COMMENT '执行实例id',
  `ACT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '节点实例id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `CALL_PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '子流程实例id',
  `ACT_NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点名',
  `ACT_TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '节点类型',
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参与者',
  `START_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '开始时间',
  `END_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '结束时间',
  `DURATION_` bigint(20) NULL DEFAULT NULL COMMENT '持续时间',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程标识',
  `CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '内部子流程节点执行次数',
  `PROCESS_CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '外部子流程执行次数',
  `DUE_DATE` datetime(3) NULL DEFAULT NULL COMMENT '到期时间',
  `SUB_PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程实例名',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_START`(`START_TIME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_END`(`END_TIME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_PROCINST`(`PROC_INST_ID_` ASC, `ACT_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_ACT_INST_EXEC`(`EXECUTION_ID_` ASC, `ACT_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史节点表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_ACTINST
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_ATTACHMENT`;
CREATE TABLE `BPM_ACT_HI_ATTACHMENT`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `URL_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'url',
  `CONTENT_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容id',
  `TIME_` datetime(3) NULL DEFAULT NULL COMMENT '时间',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史附件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_COMMENT
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_COMMENT`;
CREATE TABLE `BPM_ACT_HI_COMMENT`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `TIME_` datetime(3) NULL DEFAULT NULL COMMENT '时间',
  `USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `ACTION_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '行为类型',
  `MESSAGE_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '基本内容',
  `FULL_MSG_` longblob NULL COMMENT '全部内容',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `COMMENT_TASK_ID`(`TASK_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_COMMENT_PROC_INS`(`PROC_INST_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史意见表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_COMMENT
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_DETAIL`;
CREATE TABLE `BPM_ACT_HI_DETAIL`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类型',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `ACT_INST_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点实例id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '名',
  `VAR_TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `TIME_` datetime(3) NULL DEFAULT NULL COMMENT '时间',
  `BYTEARRAY_ID_` bigint(20) NULL DEFAULT NULL COMMENT '二进制数据id',
  `DOUBLE_` double NULL DEFAULT NULL COMMENT 'double类型数据',
  `LONG_` bigint(20) NULL DEFAULT NULL COMMENT 'long类型数据',
  `TEXT_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'string类型数据',
  `TEXT2_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'jpa对象id',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_DETAIL_PROC_INST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_DETAIL_ACT_INST`(`ACT_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_DETAIL_TIME`(`TIME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_DETAIL_NAME`(`NAME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_DETAIL_TASK_ID`(`TASK_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_DETAIL
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_IDENTITYLINK`;
CREATE TABLE `BPM_ACT_HI_IDENTITYLINK`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `GROUP_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户组id',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_IDENT_LNK_USER`(`USER_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_IDENT_LNK_TASK`(`TASK_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_IDENT_LNK_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史流程人员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_LINE
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_LINE`;
CREATE TABLE `BPM_ACT_HI_LINE`  (
  `HI_LINE_ID` bigint(20) NOT NULL COMMENT '主键',
  `PROC_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程实例ID',
  `PROC_DEF_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  `PROC_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义KEY',
  `LINE_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连线ID',
  `COMPLETE_TIME` datetime NULL DEFAULT NULL COMMENT '办理时间',
  `COMPLETE_USER` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理人',
  `LINE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连线名称',
  `PROCESS_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `OUT_NODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出线节点',
  `OUT_NODE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出线节点名称',
  `IN_NODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入线节点',
  `IN_NODE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入线节点名称',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程标识',
  `CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '内部子流程节点执行次数',
  PRIMARY KEY (`HI_LINE_ID`) USING BTREE,
  INDEX `ACT_IDX_HI_LINE_PINST`(`PROC_INST_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史线表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_LINE
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_PROCINST
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_PROCINST`;
CREATE TABLE `BPM_ACT_HI_PROCINST`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `PROC_INST_ID_` bigint(20) NOT NULL COMMENT '流程实例id',
  `BUSINESS_KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程定义id',
  `START_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '开始时间',
  `END_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '结束时间',
  `DURATION_` bigint(20) NULL DEFAULT NULL COMMENT '持续时间',
  `START_USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程发起人',
  `START_ACT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '起始节点id',
  `END_ACT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束节点id',
  `SUPER_PROCESS_INSTANCE_ID_` bigint(20) NULL DEFAULT NULL COMMENT '上级流程实例id',
  `DELETE_REASON_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束原因',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `PROCESS_TITLE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程级业务描述',
  `DATA_DETAIL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '流程级业务详细信息',
  `DUE_DATE` datetime(3) NULL DEFAULT NULL COMMENT '到期时间',
  `FIRST_USER_TASK_ACTIVITY_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第一个人工活动节点',
  `COMPLETE_FROM` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主流程前一节点',
  `COMPLETE_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主流程来源',
  `JUMP_INFO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主流程跳转信息',
  `MAIN_ACT_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主流程节点',
  `PROCESS_CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '流程循环次数',
  `SECURITY_LEVEL` int(11) NULL DEFAULT NULL COMMENT '密级',
  `IS_EMULATION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否是测试流程0否，1是',
  `PROCESS_TAG` varchar(36) NULL DEFAULT NULL COMMENT '流程标签',
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE INDEX `PROC_INST_ID_`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_PRO_INST_END`(`END_TIME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_PRO_I_BUSKEY`(`BUSINESS_KEY_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_PROC_SUPER_PROCINST`(`SUPER_PROCESS_INSTANCE_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史流程实例表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_PROCINST
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_TASKINST
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_TASKINST`;
CREATE TABLE `BPM_ACT_HI_TASKINST`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `TASK_DEF_KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `PARENT_TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '父节点实例id',
  `DESCRIPTION_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `OWNER_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实际签收人',
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参与者',
  `RECEIVER_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收人',
  `START_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '开始时间',
  `CLAIM_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '签收时间',
  `END_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '结束时间',
  `DURATION_` bigint(20) NULL DEFAULT NULL COMMENT '持续时间',
  `DELETE_REASON_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束原因',
  `PRIORITY_` int(11) NULL DEFAULT NULL COMMENT '优先级',
  `DUE_DATE_` datetime(3) NULL DEFAULT NULL COMMENT '过期时间',
  `FORM_KEY_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `CATEGORY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `TASK_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '委托类型  空 无委托关系  1 事前委托',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程标识',
  `TASK_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务类型  空 普通已办  2 协办已办  4 发起协办的已办',
  `ASSIST_INITIATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务发起人',
  `CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '内部子流程节点执行次数',
  `PROCESS_CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '外部子流程执行次数',
  `CREATE_HISTORY_TASK_ID` bigint(20) NULL DEFAULT NULL COMMENT '协办来源id',
  `FORM_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  `SEND_USER` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人',
  `MULTI_ID` bigint(20) NULL DEFAULT NULL COMMENT '会签ID',
  `APPOINT_ASSIGNEE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '指定人',
  `TODO_CONFIGURATION` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '待办配置',
  `COMPLETE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源方式',
  `TASK_SOURCE_FLAG` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理方式',
  `JUMP_INFO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '跳转信息',
  `ALL_PREV_NODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '前一节点',
  `PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名',
  `BUSINESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `SUBMIT_TO_REJECT_NODE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否提交至驳回节点。空：否；1：是。',
  `SEQ_MULTI_COUNT` INT(11) DEFAULT NULL COMMENT '串行会签执行次序',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_TASK_INST_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_TASK_INST_END_TIME`(`END_TIME_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_TASK_INST_PROCDEF`(`PROC_DEF_ID_` ASC) USING BTREE,
  INDEX `TASKINST_PARENT_TASK_ID`(`PARENT_TASK_ID_` ASC) USING BTREE,
  INDEX `IDX_HI_TASK_ASSIGNEE_END_TIME`(`ASSIGNEE_` ASC, `END_TIME_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史任务实例表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_TASKINST
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_HI_VARINST
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_HI_VARINST`;
CREATE TABLE `BPM_ACT_HI_VARINST`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '变量名  sendUser 发送人  todoConfiguration 业务描述  complete_type 上一节点办理方式  taskSourceFlag 办理方式  all_prev_node 所有上一节点  bpm_submit_source 提交来源  complete_from 上一节点',
  `VAR_TYPE_` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '变量类型',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `BYTEARRAY_ID_` bigint(20) NULL DEFAULT NULL COMMENT '二进制数据id',
  `DOUBLE_` double NULL DEFAULT NULL COMMENT 'double类型数据',
  `LONG_` bigint(20) NULL DEFAULT NULL COMMENT 'long类型数据',
  `TEXT_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'string类型数据',
  `TEXT2_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'jpa对象id',
  `CREATE_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_UPDATED_TIME_` datetime(3) NULL DEFAULT NULL COMMENT '最后更新时间',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_HI_PROCVAR_PROC_INST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_PROCVAR_NAME_TYPE`(`NAME_` ASC, `VAR_TYPE_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_PROCVAR_TASK_ID`(`TASK_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_HI_VAR_EXECUTION_ID`(`EXECUTION_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '历史变量表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_HI_VARINST
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_ID_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ID_GROUP`;
CREATE TABLE `BPM_ACT_ID_GROUP`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户组信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ID_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_ID_INFO
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ID_INFO`;
CREATE TABLE `BPM_ACT_ID_INFO`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `USER_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `TYPE_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标识',
  `VALUE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值',
  `PASSWORD_` longblob NULL COMMENT '密码',
  `PARENT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户id',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户拓展信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ID_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_ID_MEMBERSHIP
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ID_MEMBERSHIP`;
CREATE TABLE `BPM_ACT_ID_MEMBERSHIP`  (
  `USER_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户id',
  `GROUP_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户组id',
  PRIMARY KEY (`USER_ID_`) USING BTREE,
  INDEX `ACT_FK_MEMB_GROUP`(`GROUP_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户与分组对应信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ID_MEMBERSHIP
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_ID_USER
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_ID_USER`;
CREATE TABLE `BPM_ACT_ID_USER`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `FIRST_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名',
  `LAST_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓',
  `EMAIL_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `PWD_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
  `PICTURE_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片id',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_ID_USER
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_PROCDEF_INFO
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_PROCDEF_INFO`;
CREATE TABLE `BPM_ACT_PROCDEF_INFO`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程定义id',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `INFO_JSON_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '二进制数据id',
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE INDEX `ACT_UNIQ_INFO_PROCDEF`(`PROC_DEF_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_INFO_PROCDEF`(`PROC_DEF_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_INFO_JSON_BA`(`INFO_JSON_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程定义信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_PROCDEF_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_PROCESS_FILE
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_PROCESS_FILE`;
CREATE TABLE `BPM_ACT_PROCESS_FILE`  (
  `FILE_ID` bigint(20) NOT NULL COMMENT '文件ID',
  `PROCESS_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `PROCESS_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程ID',
  `FILE_VERSION` int(11) NULL DEFAULT NULL COMMENT '版本号',
  `FILE_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件类型',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `CONTENT` longblob NULL COMMENT '文件内容',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '模块ID',
  `TENANT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `WORKFLOW_STYLE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程风格',
  PRIMARY KEY (`FILE_ID`) USING BTREE,
  INDEX `ACT_IDX_PFILE_PROCESS_KEY`(`PROCESS_KEY` ASC) USING BTREE,
  INDEX `ACT_IDX_PFILE_PROCESS_ID`(`PROCESS_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作流文件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_PROCESS_FILE
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RE_DEPLOYMENT
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RE_DEPLOYMENT`;
CREATE TABLE `BPM_ACT_RE_DEPLOYMENT`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `CATEGORY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `DEPLOY_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '部署时间',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '部署信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RE_DEPLOYMENT
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RE_MODEL`;
CREATE TABLE `BPM_ACT_RE_MODEL`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名',
  `KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程表示',
  `CATEGORY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `CREATE_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_UPDATE_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '更新时间',
  `VERSION_` int(11) NULL DEFAULT NULL COMMENT '版本号',
  `META_INFO_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细信息',
  `DEPLOYMENT_ID_` bigint(20) NULL DEFAULT NULL COMMENT '部署id',
  `EDITOR_SOURCE_VALUE_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编辑器源值id',
  `EDITOR_SOURCE_EXTRA_VALUE_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编辑器源额外值id',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `WORKFLOW_STYLE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程风格',
  `PROCESS_TAG` varchar(36) DEFAULT NULL COMMENT '流程标签',
  `MODEL_STATUS` char(1) DEFAULT NULL COMMENT '模型状态',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_FK_MODEL_SOURCE`(`EDITOR_SOURCE_VALUE_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_MODEL_SOURCE_EXTRA`(`EDITOR_SOURCE_EXTRA_VALUE_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_MODEL_DEPLOYMENT`(`DEPLOYMENT_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程设计模型部署表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RE_MODEL
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RE_PROCDEF
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RE_PROCDEF`;
CREATE TABLE `BPM_ACT_RE_PROCDEF`  (
  `ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `CATEGORY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程标识',
  `VERSION_` int(11) NOT NULL COMMENT '版本',
  `DEPLOYMENT_ID_` bigint(20) NULL DEFAULT NULL COMMENT '部署id',
  `RESOURCE_NAME_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '部署名',
  `DGRM_RESOURCE_NAME_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片名',
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `HAS_START_FORM_KEY_` tinyint NULL DEFAULT NULL COMMENT '是否存在开始节点formKey',
  `HAS_GRAPHICAL_NOTATION_` tinyint NULL DEFAULT NULL COMMENT '是否具有图形表示法',
  `SUSPENSION_STATE_` int(11) NULL DEFAULT NULL COMMENT '挂起状态  1 激活  2 挂起',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `MAIN_PROCESS` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '1主版本 0 不是主版本 2 临时版本',
  `REAL_VERSION` int(11) NULL DEFAULT NULL COMMENT '临时版本流程真实版本号',
  `WORKFLOW_STYLE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程风格',
  `PROCESS_TAG` varchar(36) DEFAULT NULL COMMENT '流程标签',
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE INDEX `ACT_UNIQ_PROCDEF`(`KEY_` ASC, `VERSION_` ASC, `TENANT_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程定义数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RE_PROCDEF
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_EVENT_SUBSCR
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_EVENT_SUBSCR`;
CREATE TABLE `BPM_ACT_RU_EVENT_SUBSCR`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `EVENT_TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类型',
  `EVENT_NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `ACTIVITY_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '活动实例id',
  `CONFIGURATION_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置',
  `CREATED_` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '是否创建',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_EVENT_SUBSCR_CONFIG_`(`CONFIGURATION_` ASC) USING BTREE,
  INDEX `ACT_FK_EVENT_EXEC`(`EXECUTION_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '监听表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_EVENT_SUBSCR
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_EXECUTION
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_EXECUTION`;
CREATE TABLE `BPM_ACT_RU_EXECUTION`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `BUSINESS_KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `PARENT_ID_` bigint(20) NULL DEFAULT NULL COMMENT '父执行实例id',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `SUPER_EXEC_` bigint(20) NULL DEFAULT NULL COMMENT '上级执行实例',
  `ACT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点实例id',
  `IS_ACTIVE_` tinyint NULL DEFAULT NULL COMMENT '是否存活',
  `IS_CONCURRENT_` tinyint NULL DEFAULT NULL COMMENT '是否并行',
  `IS_SCOPE_` tinyint NULL DEFAULT NULL COMMENT '是否节点',
  `IS_EVENT_SCOPE_` tinyint NULL DEFAULT NULL COMMENT '是否事件范围',
  `SUSPENSION_STATE_` int(11) NULL DEFAULT NULL COMMENT '挂起状态  1 激活  2 挂起',
  `CACHED_ENT_STATE_` int(11) NULL DEFAULT NULL COMMENT '缓存状态',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `LOCK_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '锁定时间',
  `ALL_PREV_NODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '前一节点',
  `PROCESS_CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '流程循环次数',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '子流程标识',
  `CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '子流程循环次数',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_EXEC_BUSKEY`(`BUSINESS_KEY_` ASC) USING BTREE,
  INDEX `ACT_FK_EXE_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_EXE_PARENT`(`PARENT_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_EXE_SUPER`(`SUPER_EXEC_` ASC) USING BTREE,
  INDEX `ACT_FK_EXE_PROCDEF`(`PROC_DEF_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运行时流程执行实例表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_EXECUTION
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_IDENTITYLINK`;
CREATE TABLE `BPM_ACT_RU_IDENTITYLINK`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `GROUP_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户组id',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `USER_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参与者id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `MANDATOR` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '委托人',
  `TASK_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '委托类型  空 无委托关系  1 事前委托',
  `ASSIST_INITIATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务发起人',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_IDENT_LNK_USER`(`USER_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_IDENT_LNK_GROUP`(`GROUP_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_ATHRZ_PROCEDEF`(`PROC_DEF_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_TSKASS_TASK`(`TASK_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_IDL_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_IDENT_LNK_USER_TYPE`(`TYPE_` ASC, `USER_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运行时流程人员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_JOB
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_JOB`;
CREATE TABLE `BPM_ACT_RU_JOB`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类型',
  `LOCK_EXP_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '锁定释放时间',
  `LOCK_OWNER_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '挂起者',
  `EXCLUSIVE_` tinyint(1) NULL DEFAULT NULL COMMENT '专属',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `PROCESS_INSTANCE_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `RETRIES_` int(11) NULL DEFAULT NULL COMMENT '重试',
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常信息id',
  `EXCEPTION_MSG_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常信息',
  `DUEDATE_` timestamp(3) NULL DEFAULT NULL COMMENT '到期时间',
  `REPEAT_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重复',
  `HANDLER_TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处理类型',
  `HANDLER_CFG_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处理标识',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_FK_JOB_EXCEPTION`(`EXCEPTION_STACK_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运行时定时任务数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_JOB
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_TASK
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_TASK`;
CREATE TABLE `BPM_ACT_RU_TASK`  (
  `ID_` bigint(20) NOT NULL COMMENT '任务id',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义id',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点名',
  `PARENT_TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '父节点实例id',
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TASK_DEF_KEY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `OWNER_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实际签收人',
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参与者',
  `DELEGATION_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `PRIORITY_` int(11) NULL DEFAULT NULL COMMENT '优先级',
  `CREATE_TIME_` timestamp(3) NULL DEFAULT NULL COMMENT '创建时间',
  `DUE_DATE_` datetime(3) NULL DEFAULT NULL COMMENT '超时时间',
  `CATEGORY_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `SUSPENSION_STATE_` int(11) NULL DEFAULT NULL COMMENT '挂起状态  1 激活  2 挂起',
  `TENANT_ID_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '租户id',
  `FORM_KEY_` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `PREEMPTED` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否已抢单  空 未被抢单  1 已抢单',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程标识',
  `TASK_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务类型  空 普通待办  2 协办待办',
  `CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '内部子流程节点执行次数',
  `PROCESS_CYCLE_COUNT` int(11) NULL DEFAULT NULL COMMENT '外部子流程执行次数',
  `CREATE_HISTORY_TASK_ID` bigint(20) NULL DEFAULT NULL COMMENT '协办来源id',
  `URGE_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '催办状态 1 被催办 null 未被催办',
  `FORM_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单ID',
  `SEND_USER` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人',
  `MULTI_ID` bigint(20) NULL DEFAULT NULL COMMENT '会签ID',
  `APPOINT_ASSIGNEE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '指定人',
  `TODO_CONFIGURATION` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '待办配置',
  `COMPLETE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源方式',
  `JUMP_INFO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '跳转信息',
  `ALL_PREV_NODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '前一节点',
  `PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名',
  `BUSINESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `SUBMIT_TO_REJECT_NODE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否提交至驳回节点。空：否；1：是。',
  `SEQ_MULTI_COUNT` INT(11) DEFAULT NULL COMMENT '串行会签执行次序',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_TASK_CREATE`(`CREATE_TIME_` ASC) USING BTREE,
  INDEX `ACT_FK_TASK_EXE`(`EXECUTION_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_TASK_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_TASK_PROCDEF`(`PROC_DEF_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_RU_TASK_PARENT_TASK_ID`(`PARENT_TASK_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运行时任务节点表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_RU_MULT_USER
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_MULT_USER`;
CREATE TABLE `BPM_ACT_RU_MULT_USER` (
                                        `MULTI_USER_ID` BIGINT(20) NOT NULL COMMENT '主键',
                                        `MULTI_ID` BIGINT(20) DEFAULT NULL COMMENT '会签id',
                                        `USER_ID` VARCHAR(255) DEFAULT NULL COMMENT '参与者id',
                                        `OWNER_ID` VARCHAR(255) DEFAULT NULL COMMENT '任务所有人id',
                                        `SEQ_MULTI_COUNT` INT(11) NULL DEFAULT NULL COMMENT '串行会签执行次序',
                                        PRIMARY KEY (`MULTI_USER_ID`) USING BTREE,
                                        INDEX `ACT_IDX_MULTI_ID`(`MULTI_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会签多实例人员信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for BPM_ACT_RU_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_RU_VARIABLE`;
CREATE TABLE `BPM_ACT_RU_VARIABLE`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `REV_` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `TYPE_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类型',
  `NAME_` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '变量名  sendUser 发送人  todoConfiguration 业务描述  complete_type 上一节点办理方式  taskSourceFlag 办理方式  all_prev_node 所有上一节点  bpm_submit_source 提交来源  complete_from 上一节点',
  `EXECUTION_ID_` bigint(20) NULL DEFAULT NULL COMMENT '执行实例id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `BYTEARRAY_ID_` bigint(20) NULL DEFAULT NULL COMMENT '二进制数据表对应id',
  `DOUBLE_` double NULL DEFAULT NULL COMMENT 'double类型存储信息',
  `LONG_` bigint(20) NULL DEFAULT NULL COMMENT 'long类型存储信息',
  `TEXT_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'string类型存储信息',
  `TEXT2_` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'jpa持久化对象对应id',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `ACT_IDX_VARIABLE_TASK_ID`(`TASK_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_VAR_EXE`(`EXECUTION_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_VAR_PROCINST`(`PROC_INST_ID_` ASC) USING BTREE,
  INDEX `ACT_FK_VAR_BYTEARRAY`(`BYTEARRAY_ID_` ASC) USING BTREE,
  INDEX `ACT_IDX_RU_VARIABLE_NAME`(`NAME_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运行时流程变量数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_RU_VARIABLE
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_TEST_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_TEST_DETAILS`;
CREATE TABLE `BPM_ACT_TEST_DETAILS`  (
  `DETAIL_ID` bigint(20) NOT NULL COMMENT '主键',
  `LOG_ID` bigint(20) NOT NULL COMMENT '测试记录主键',
  `PROC_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程实例ID',
  `PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `PROC_DEF_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  `BUSINESS_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `TASK_DEF_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点类型',
  `TASK_DEF_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点名称',
  `TASK_DEF_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点ID',
  `TASK_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务ID',
  `USER_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理人ID',
  `USER_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理人名称',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '接收时间',
  `END_TIME` datetime(3) NULL DEFAULT NULL COMMENT '办理时间',
  `SUB_PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部子流程标识',
  `TEST_RESULT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理结果',
  `TEST_CONTENT` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志信息',
  `OPERATION_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作类型',
  PRIMARY KEY (`DETAIL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程仿真测试详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_TEST_DETAILS
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_TEST_LOG
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_TEST_LOG`;
CREATE TABLE `BPM_ACT_TEST_LOG`  (
  `LOG_ID` bigint(20) NOT NULL COMMENT '主键',
  `PROCESS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `PROC_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程实例ID',
  `BUSINESS_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `PROC_DEF_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程定义ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '测试时间',
  `CREATE_USER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理人ID',
  `CREATE_USER_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理人名称',
  `TEST_RESULT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测试结果（0失败1成功2测试终止）',
  `CONFIG_DETAIL` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置信息，如测试时维护的变量值',
  `TEST_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测试类型（0自动测试1手动测试）',
  `TASK_DEFINIITION_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点ID',
  `PARENT_NODE_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父节点ID',
  `TASK_DEF_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前节点ID',
  PRIMARY KEY (`LOG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程仿真测试日志记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_TEST_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_TEST_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_TEST_VARIABLE`;
CREATE TABLE `BPM_ACT_TEST_VARIABLE`  (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `VARIABLE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '变量',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '测试变量表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_TEST_VARIABLE
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_TIMEOUT_ACTIVITY
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_TIMEOUT_ACTIVITY`;
CREATE TABLE `BPM_ACT_TIMEOUT_ACTIVITY`  (
  `TIMEOUT_ID` bigint(20) NOT NULL COMMENT '主键',
  `TASK_ID` bigint(20) NOT NULL COMMENT '任务id',
  `ASSIGNEE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参与者',
  `DUE_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '到期时间',
  `CREATE_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '开始时间',
  `TIME_OUT_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超时处理类型',
  `TENANT_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户id',
  `MAP` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口类型额外参数',
  `MESSAGE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '信息类型 0 节点任务超时处理信息 1 流程超时处理信息',
  PRIMARY KEY (`TIMEOUT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '超时信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_TIMEOUT_ACTIVITY
-- ----------------------------

-- ----------------------------
-- Table structure for BPM_ACT_URGE_TASK
-- ----------------------------
DROP TABLE IF EXISTS `BPM_ACT_URGE_TASK`;
CREATE TABLE `BPM_ACT_URGE_TASK`  (
  `URGE_ID` bigint(20) NOT NULL COMMENT '主键',
  `TASK_ID` bigint(20) NULL DEFAULT NULL COMMENT '任务ID',
  `PROC_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '实例ID',
  `PROC_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `TASK_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务名称',
  `SEND_USER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人',
  `RECEIVE_USER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收人',
  `SEND_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '发送时间',
  `FORM_KEY` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单地址',
  `PROC_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `BUSINESS_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务主键',
  `TASK_DEF_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点id',
  `TEXT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '待办配置',
  `OWNER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务拥有者',
  `TASK_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务类型  空 无委托关系  1 事前委托',
  PRIMARY KEY (`URGE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '催办表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of BPM_ACT_URGE_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_API_CALL_SPECIFICATION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_API_CALL_SPECIFICATION`;
CREATE TABLE `EAI_API_CALL_SPECIFICATION`  (
  `SPECIFICAT_ID` bigint(20) NOT NULL COMMENT '规范ID',
  `SHOW_PARAM_NAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用成功规范显示参数名称(格式：body.codeOpen)',
  `PARAM_NAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用成功规范参数名称(格式：$BODY.code)',
  `PARAM_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型',
  `API_ID` bigint(20) NULL DEFAULT NULL COMMENT '接口基本信息ID/接口版本基本信息ID',
  `JUDGE_CONDITION` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '判断条件(00-等于；01-不等于；02-在...之内)',
  `CONDITION_VALUE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条件值 ',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`SPECIFICAT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口调用成功规范信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_API_CALL_SPECIFICATION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_API_CLASSIFICATION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_API_CLASSIFICATION`;
CREATE TABLE `EAI_API_CLASSIFICATION`  (
  `CLASSIFIC_ID` bigint(20) NOT NULL COMMENT '主键',
  `CLASSIFIC_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类名称',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`CLASSIFIC_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口分类信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_API_CLASSIFICATION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_API_INFO
-- ----------------------------
DROP TABLE IF EXISTS `EAI_API_INFO`;
CREATE TABLE `EAI_API_INFO`  (
  `API_ID` bigint(20) NOT NULL COMMENT '接口ID',
  `API_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `API_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口标识',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `API_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口地址',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参信息',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参信息',
  `DATA_FORMAT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据格式(0 JSON,1XML)',
  `ENCODING_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码方式（0 UTF8）',
  `REQUEST_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求方式(0 POST)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TEST_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测试状态（1通过测试，0未通过测试）',
  `PUBLIC_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否公开(1是，0否)',
  `API_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上架状态（1已上架，0未上架）',
  `APPLY_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核状态（1审核中，0正常）',
  `DRAFT_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核状态（1审核中，0正常）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `CLASSIFIC_ID` bigint(20) NULL DEFAULT NULL COMMENT '分类ID',
  `API_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原接口类型,0:http,1:webservice',
  PRIMARY KEY (`API_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口基本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_API_INFO
-- ----------------------------
-- ----------------------------
-- Table structure for SYS_ASYNC_EVENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ASYNC_EVENT`;
CREATE TABLE `SYS_ASYNC_EVENT` (
  `SYS_ASYNC_EVENT_ID` BIGINT NOT NULL COMMENT '事件表主键',
  `EVENT_TYPE` VARCHAR(255) DEFAULT NULL COMMENT '事件类型',
  `EVENT` VARCHAR(2048) DEFAULT NULL COMMENT '事件内容',
  `STATUS` CHAR(2)  DEFAULT NULL COMMENT '事件状态，0未消费，1以消费，2消费失败',
  `RETRY_NUM` INT DEFAULT NULL COMMENT '重试次数，默认为0',
  `ERROR_MSG` text DEFAULT NULL COMMENT '消费失败原因',
  `CLASS_NAME` VARCHAR(255) DEFAULT NULL COMMENT '实体类名称',
  `CREATE_TIME` DATETIME DEFAULT NULL COMMENT '事件创建时间',
  PRIMARY KEY (`SYS_ASYNC_EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='事件记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for EAI_API_LOG
-- ----------------------------
DROP TABLE IF EXISTS `EAI_API_LOG`;
CREATE TABLE `EAI_API_LOG`  (
  `CONN_ID` bigint(20) NOT NULL COMMENT 'ID',
  `FROM_APP_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用方应用标识',
  `TO_APP_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被调用方应用标识',
  `API_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口标识',
  `API_PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口PATH',
  `HOST_IP` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用方ip',
  `CONN_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态(1失败，0成功)',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参',
  `IN_PARAMS_REAL` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '转换后入参',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参',
  `OUT_PARAMS_REAL` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '转换后出参',
  `CONN_ERROR` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '异常信息',
  `CONN_DURATION` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用耗时',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `FROM_APP_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用方',
  `TO_APP_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `API_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  PRIMARY KEY (`CONN_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口调用日志' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_API_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_API_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_API_VERSION`;
CREATE TABLE `EAI_API_VERSION`  (
  `API_VERSION_ID` bigint(20) NOT NULL COMMENT '接口版本ID',
  `API_ID` bigint(20) NULL DEFAULT NULL COMMENT '接口ID',
  `API_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `API_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口标识',
  `API_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口版本号',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `API_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口地址',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参信息',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参信息',
  `DATA_FORMAT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据格式(0 JSON,1XML)',
  `ENCODING_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码方式（0 UTF8）',
  `REQUEST_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求方式(0 POST)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `API_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原接口类型,0:http,1:webservice',
  PRIMARY KEY (`API_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口版本基本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_API_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APPLICATION_AUTH
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APPLICATION_AUTH`;
CREATE TABLE `EAI_APPLICATION_AUTH`  (
  `PARAMS_ID` bigint(20) NOT NULL COMMENT 'ID',
  `PARAMS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入参名称',
  `PARAMS_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `PARAMS_TYPE` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型(基础数据类型)',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PARAMS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用鉴权入参信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APPLICATION_AUTH
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APPLY
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APPLY`;
CREATE TABLE `EAI_APPLY`  (
  `APPLY_ID` bigint(20) NOT NULL COMMENT 'ID',
  `RESOURCE_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联信息表ID',
  `APPLY_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请应用名称',
  `APPLY_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请应用标识',
  `RESOURCE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态（3撤销，2驳回，1已通过，0申请中）',
  `APPLY_TYPE` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请类型(01接口申请,02事件申请，03应用创建，04应用删除，05应用启用，06应用禁用，07应用编辑，08应用发布)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `APPROVE_REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批意见',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `APPLY_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `APPROVED_ID` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `APPROVED_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批人',
  `PROCESS_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程状态',
  `PROCESS_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程标识',
  `PROCESS_INST_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程实例ID',
  `START_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '流程发起时间',
  `FINISH_TIME` timestamp(3) NULL DEFAULT NULL COMMENT '流程完成时间',
  PRIMARY KEY (`APPLY_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '申请记录信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APPLY
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APPLY_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APPLY_RECORD`;
CREATE TABLE `EAI_APPLY_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT 'ID',
  `RESOURCE_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口/事件ID',
  `RESOURCE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口/事件名称',
  `RESOURCE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口/事件标识',
  `APPLICATION_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用名称',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `LOG_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用版本号',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用资源申请记录信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APPLY_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APP_DATA
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APP_DATA`;
CREATE TABLE `EAI_APP_DATA`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT 'ID',
  `RECORD_DATA` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '申请内容',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资源修改内容' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APP_DATA
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APP_RESOURCES
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APP_RESOURCES`;
CREATE TABLE `EAI_APP_RESOURCES`  (
  `RESOURCES_ID` bigint(20) NOT NULL COMMENT 'RESOURCES_ID',
  `RESOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '资源ID',
  `RESOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源类型（1接口，0事件）',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`RESOURCES_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用-已获得权限接口/事件信息关联' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APP_RESOURCES
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APP_WSDL
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APP_WSDL`;
CREATE TABLE `EAI_APP_WSDL`  (
  `WSDL_ID` bigint(20) NOT NULL COMMENT '主键',
  `WSDL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'WSDL文件名称',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识',
  `WSDL_VERSION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'wsdl版本1:1.1，2:2.0',
  `WSDL_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '转为JSON格式的wsdl信息',
  `WSDL_SOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1：Wsdl文件id，2：wsdl地址',
  `WSDL_PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'wsdl原文件id/地址',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`WSDL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'wsdl文件信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APP_WSDL
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_APP_WSDL_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_APP_WSDL_VERSION`;
CREATE TABLE `EAI_APP_WSDL_VERSION`  (
  `WSDL_VERSION_ID` bigint(20) NOT NULL COMMENT '主键',
  `APPLICATION_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本',
  `WSDL_ID` bigint(20) NOT NULL COMMENT 'WSDL_ID',
  `WSDL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'WSDL文件名称',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识',
  `WSDL_VERSION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'wsdl版本1:1.1，2:2.0',
  `WSDL_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '转为JSON格式的wsdl信息',
  `WSDL_SOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1：Wsdl文件id，2：wsdl地址',
  `WSDL_PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'wsdl原文件id/地址',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`WSDL_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'wsdl文件版本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_APP_WSDL_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_AUTH_WSDL_INFO
-- ----------------------------
DROP TABLE IF EXISTS `EAI_AUTH_WSDL_INFO`;
CREATE TABLE `EAI_AUTH_WSDL_INFO`  (
  `WSDL_AUTH_INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `WSDL_ID` bigint(20) NOT NULL COMMENT '接口/接口版本主键id',
  `APPLICATION_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本号',
  `WSDL_ADDRESS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实际调用的接口地址',
  `WSDL_SERVICE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `SERVICE_PORT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口实现名称',
  `WSDL_OPERATION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法名',
  `SOAP_VERSION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'soap版本1:1.1,2:1.2',
  `SOAP_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '拼接的SOAP xml信息，不含参数信息',
  `WSDL_SOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1：Wsdl文件id，2：wsdl地址',
  `WSDL_PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Wsdl文件id/wsdl地址',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`WSDL_AUTH_INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '存储webservice鉴权配置信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_AUTH_WSDL_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_CANVAS_INFO
-- ----------------------------
DROP TABLE IF EXISTS `EAI_CANVAS_INFO`;
CREATE TABLE `EAI_CANVAS_INFO`  (
  `CANVAS_ID` bigint(20) NOT NULL COMMENT '画布ID',
  `CANVAS_CONTENT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '画布内容',
  `API_CODES` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用接口/事件标识集合',
  `CANVAS_RESOURCES` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '使用的公共资源信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`CANVAS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '画布信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_CANVAS_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_COMMON_CONN
-- ----------------------------
DROP TABLE IF EXISTS `EAI_COMMON_CONN`;
CREATE TABLE `EAI_COMMON_CONN`  (
  `CONNECTION_ID` bigint(20) NOT NULL COMMENT '连接ID',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `CONNECTION_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接名称',
  `CONNECTION_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类（0开放，1集成）',
  `CONNECTION_CLASSIFY` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接分类（00应用鉴权，01数据库，02MQ）',
  `CLASSIFY_CHILD` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接二级分类（code）',
  `CONNECTION_CONFIG` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '连接配置',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`CONNECTION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共连接' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_COMMON_CONN
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_COMMON_CONSTANT
-- ----------------------------
DROP TABLE IF EXISTS `EAI_COMMON_CONSTANT`;
CREATE TABLE `EAI_COMMON_CONSTANT`  (
  `CONSTANT_ID` bigint(20) NOT NULL COMMENT '常量ID',
  `CONSTANT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量名称',
  `CONSTANT_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `PARAMS_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `CONSTANT_VALUE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量值',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `CONSTANT_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量分类（0开放管理，1集成流管理）',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`CONSTANT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共常量' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_COMMON_CONSTANT
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_COMMON_LOGIC
-- ----------------------------
DROP TABLE IF EXISTS `EAI_COMMON_LOGIC`;
CREATE TABLE `EAI_COMMON_LOGIC`  (
  `LOGIC_ID` bigint(20) NOT NULL COMMENT '逻辑ID',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `LOGIC_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑名称',
  `LOGIC_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑标识',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '逻辑入参',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '逻辑出参',
  `LOGIC_TEST` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测试状态(1通过，0未通过)',
  `LOGIC_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类（0开放，1集成）',
  `CANVAS_ID` bigint(20) NULL DEFAULT NULL COMMENT '画布ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`LOGIC_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共逻辑' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_COMMON_LOGIC
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_COMMON_STRUCTURE
-- ----------------------------
DROP TABLE IF EXISTS `EAI_COMMON_STRUCTURE`;
CREATE TABLE `EAI_COMMON_STRUCTURE`  (
  `STRUCTURE_ID` bigint(20) NOT NULL COMMENT '数据结构ID',
  `PARAMS_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `STRUCTURE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构标识',
  `STRUCTURE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构名称',
  `STRUCTURE_VALUES` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参数信息(数据结构)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `STRUCTURE_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构分类（0开放，1集成）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据结构' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_COMMON_STRUCTURE
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_CONN_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_CONN_VERSION`;
CREATE TABLE `EAI_CONN_VERSION`  (
  `CONN_VERSION_ID` bigint(20) NOT NULL COMMENT '连接版本ID',
  `CONNECTION_ID` bigint(20) NOT NULL COMMENT '连接ID',
  `CONN_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接版本号',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `CONNECTION_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接名称',
  `CONNECTION_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类（0开放，1集成）',
  `CONNECTION_CLASSIFY` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接分类（00应用鉴权，01数据库，02MQ）',
  `CLASSIFY_CHILD` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接二级分类（code）',
  `CONNECTION_CONFIG` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '连接配置',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`CONN_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共连接版本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_CONN_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_CONSTANT_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_CONSTANT_VERSION`;
CREATE TABLE `EAI_CONSTANT_VERSION`  (
  `CONSTANT_VERSION_ID` bigint(20) NOT NULL COMMENT '常量版本id',
  `CONSTANT_ID` bigint(20) NOT NULL COMMENT '常量ID',
  `CONSTANT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量名称',
  `CONSTANT_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `CONSTANT_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量版本号',
  `PARAMS_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `CONSTANT_VALUE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量值',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `CONSTANT_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量分类（0开放管理，1集成流管理）',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`CONSTANT_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共常量版本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_CONSTANT_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_CUSTOMIZE_AUTH
-- ----------------------------
DROP TABLE IF EXISTS `EAI_CUSTOMIZE_AUTH`;
CREATE TABLE `EAI_CUSTOMIZE_AUTH`  (
  `CUSTOMIZE_ID` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主键',
  `EXTEND_ID` int(11) NOT NULL COMMENT 'EXTEND_ID',
  `CANVAS_ID` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '画布id',
  `CREATOR` int(11) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` int(11) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`EXTEND_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义鉴权信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_CUSTOMIZE_AUTH
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_EDIT_API
-- ----------------------------
DROP TABLE IF EXISTS `EAI_EDIT_API`;
CREATE TABLE `EAI_EDIT_API`  (
  `EDIT_API_ID` bigint(20) NOT NULL COMMENT '接口配置信息ID',
  `API_ID` bigint(20) NULL DEFAULT NULL COMMENT '接口ID',
  `API_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口地址',
  `ENCODING_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码方式（0 UTF8,1 GBK,2 ISO-8859-1,3 GB2312）',
  `HTTP_METHOD` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求方式（POST/GET/PUT...）',
  `CONTENT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容类型（0 NONE,1 APPLICATION/JSON,2 FORM-DATA,3 X-WWW-FORM-URLENCODING）',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参信息(数据结构)',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参信息(数据结构)',
  `CANVAS_ID` bigint(20) NULL DEFAULT NULL COMMENT '画布ID',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`EDIT_API_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '快速配置接口信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_EDIT_API
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_EDIT_API_WSDL
-- ----------------------------
DROP TABLE IF EXISTS `EAI_EDIT_API_WSDL`;
CREATE TABLE `EAI_EDIT_API_WSDL`  (
  `API_WSDL_ID` bigint(20) NOT NULL COMMENT '主键',
  `API_ID` bigint(20) NULL DEFAULT NULL COMMENT '接口/接口版本主键id',
  `WSDL_ID` bigint(20) NULL DEFAULT NULL COMMENT 'wsdl信息表主键',
  `WSDL_ADDRESS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实际调用的接口地址',
  `WSDL_SERVICE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `SERVICE_PORT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口实现名称',
  `WSDL_OPERATION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法名',
  `SOAP_VERSION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'soap版本1:1.1,2:1.2',
  `SOAP_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '拼接的SOAP xml信息，不含参数信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`API_WSDL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'webservice编辑信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_EDIT_API_WSDL
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_EVENT_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_EVENT_VERSION`;
CREATE TABLE `EAI_EVENT_VERSION`  (
  `EVENT_VERSION_ID` bigint(20) NOT NULL COMMENT 'ID',
  `EVENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '事件ID',
  `EVENT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件名称',
  `EVENT_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件英文名称',
  `EVENT_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件版本号',
  `EVENT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件类型（0webhook,1定时，2触发器）',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参信息',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`EVENT_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '事件开放版本基本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_EVENT_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_HTTP_AUTH_TOKEN_EXPIRE
-- ----------------------------
DROP TABLE IF EXISTS `EAI_HTTP_AUTH_TOKEN_EXPIRE`;
CREATE TABLE `EAI_HTTP_AUTH_TOKEN_EXPIRE`  (
  `INVALIDATION_ID` bigint(20) NOT NULL COMMENT '主键',
  `EXTEND_ID` bigint(20) NULL DEFAULT NULL COMMENT 'EXTEND_ID',
  `PARAM_NAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数名称',
  `JUDGE_CONDITION` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '判断条件：00-等于；01-不等于；02-在...之内；03...',
  `CONDITION_VALUE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条件值',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`INVALIDATION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'token失效条件' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_HTTP_AUTH_TOKEN_EXPIRE
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_HTTP_EXTEND
-- ----------------------------
DROP TABLE IF EXISTS `EAI_HTTP_EXTEND`;
CREATE TABLE `EAI_HTTP_EXTEND`  (
  `EXTEND_ID` bigint(20) NOT NULL COMMENT 'ID',
  `STEP_CODE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '步骤编号',
  `TEMPLATE_ID` bigint(20) NULL DEFAULT NULL COMMENT 'http鉴权模板ID',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`EXTEND_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'http鉴权步骤扩展信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_HTTP_EXTEND
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_HTTP_PARAMS
-- ----------------------------
DROP TABLE IF EXISTS `EAI_HTTP_PARAMS`;
CREATE TABLE `EAI_HTTP_PARAMS`  (
  `PARAMS_ID` bigint(20) NOT NULL COMMENT 'ID',
  `PARAMS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入参名称',
  `PARAMS_NAME_EN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `PARAMS_TYPE` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `PARAMS_POSITION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数位置 header-0,body-1,queryParams-2',
  `PARAMS_FROM` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源(2鉴权参数，1公用常量，0表达式)',
  `PARAMS_VALUE` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参数值(来源是2或1时存来源的ID)',
  `HTTP_ID` bigint(20) NULL DEFAULT NULL COMMENT 'HTTP_BASE_ID',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PARAMS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'http参数及值' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_HTTP_PARAMS
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_HTTP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `EAI_HTTP_TEMPLATE`;
CREATE TABLE `EAI_HTTP_TEMPLATE`  (
  `TEMPLATE_ID` bigint(20) NOT NULL COMMENT 'ID',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识',
  `APPLICATION_VERSION` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本号',
  `HAS_CERT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否添加证书（1是，0否）',
  `TEMPLATE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类（2，禁用，1发布，0草稿）',
  `CERT_PATH` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证书存放地址',
  `HTTP_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '鉴权类型（0无鉴权，1TOKEN鉴权，2BASIC AUHT,3简单认证鉴权，4自定义）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`TEMPLATE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'http鉴权模板' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_HTTP_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_HTTP_VERIFY_BASE
-- ----------------------------
DROP TABLE IF EXISTS `EAI_HTTP_VERIFY_BASE`;
CREATE TABLE `EAI_HTTP_VERIFY_BASE`  (
  `HTTP_BASE_ID` bigint(20) NOT NULL COMMENT 'ID',
  `EXTEND_ID` bigint(20) NULL DEFAULT NULL COMMENT 'EXTEND_ID',
  `HTTP_URL` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求地址',
  `HTTP_METHOD` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求方式（POST/GET/PUT...）',
  `HTTP_RESULT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '返回结果数据结构',
  `CONTENT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容类型（0 none,1 application/json,2 form-data,3 x-www-form-urlencoding）',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`HTTP_BASE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'http鉴权验证请求基本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_HTTP_VERIFY_BASE
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_LOGIC_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_LOGIC_VERSION`;
CREATE TABLE `EAI_LOGIC_VERSION`  (
  `LOGIC_VERSION_ID` bigint(20) NOT NULL COMMENT '逻辑版本ID',
  `LOGIC_ID` bigint(20) NOT NULL COMMENT '逻辑ID',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `LOGIC_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑名称',
  `LOGIC_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑标识',
  `IN_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '逻辑入参',
  `OUT_PARAMS` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '逻辑出参',
  `LOGIC_TEST` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测试状态(1通过，0未通过)',
  `LOGIC_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类（0开放，1集成）',
  `LOGIC_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑版本号',
  `CANVAS_ID` bigint(20) NULL DEFAULT NULL COMMENT '画布ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`LOGIC_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共逻辑版本信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_LOGIC_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_PARAMS_POSITION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_PARAMS_POSITION`;
CREATE TABLE `EAI_PARAMS_POSITION`  (
  `POSITION_ID` bigint(20) NOT NULL COMMENT 'POSITION_ID',
  `PARAMS_POSITION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数位置',
  `EFFECTIVE` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参数信息（数据结构）',
  `EXTEND_ID` bigint(20) NULL DEFAULT NULL COMMENT 'EXTEND_ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`POSITION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '鉴权参数位置信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_PARAMS_POSITION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_PUBLISH_LOG
-- ----------------------------
DROP TABLE IF EXISTS `EAI_PUBLISH_LOG`;
CREATE TABLE `EAI_PUBLISH_LOG`  (
  `PUBLISH_ID` bigint(20) NOT NULL COMMENT 'ID',
  `LOG_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志摘要',
  `LOG_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本号',
  `REMARK` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '应用发布描述信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PUBLISH_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用发布日志' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_PUBLISH_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_RESOURCES_INFO
-- ----------------------------
DROP TABLE IF EXISTS `EAI_RESOURCES_INFO`;
CREATE TABLE `EAI_RESOURCES_INFO`  (
  `RESOURCE_ID` bigint(20) NOT NULL COMMENT 'ID',
  `RESOURCE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源编码',
  `RESOURCE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源名称',
  `RESOURCE_RELATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '资源ID',
  `RESOURCE_VERSION_ID` bigint(20) NULL DEFAULT NULL COMMENT '资源版本ID',
  `APPLICATION_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本号',
  `RESOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源类型（1接口，0事件）',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `DELETE_STATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '逻辑删除，1删除，0未删除',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`RESOURCE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用开放信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_RESOURCES_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_STRUCTURE_ITEM_TAG
-- ----------------------------
DROP TABLE IF EXISTS `EAI_STRUCTURE_ITEM_TAG`;
CREATE TABLE `EAI_STRUCTURE_ITEM_TAG`  (
  `TAG_ITEM_ID` bigint(20) NOT NULL COMMENT '关联ID',
  `TAG_ID` bigint(20) NOT NULL COMMENT '标签ID',
  `STRUCTURE_ID` bigint(20) NOT NULL COMMENT '数据结构ID',
  `ITEM_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据结构参数标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`TAG_ITEM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据结构字段标签关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_STRUCTURE_ITEM_TAG
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_STRUCTURE_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `EAI_STRUCTURE_VERSION`;
CREATE TABLE `EAI_STRUCTURE_VERSION`  (
  `STRUCTURE_VERSION_ID` bigint(20) NOT NULL COMMENT 'ID',
  `STRUCTURE_ID` bigint(20) NOT NULL COMMENT '数据结构ID',
  `PARAMS_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `APPLICATION_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用标识',
  `STRUCTURE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构标识',
  `STRUCTURE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构名称',
  `STRUCTURE_VERSION` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构版本号',
  `STRUCTURE_VALUES` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '参数信息(JSONSCHEMA)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `STRUCTURE_CLASSIFY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据结构分类（0开放，1集成）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `EDIT_BY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`STRUCTURE_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据结构版本id' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_STRUCTURE_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for EAI_TAG_INFO
-- ----------------------------
DROP TABLE IF EXISTS `EAI_TAG_INFO`;
CREATE TABLE `EAI_TAG_INFO`  (
  `TAG_ID` bigint(20) NOT NULL COMMENT '标签ID',
  `TAG_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标签名',
  `TAG_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标签标识',
  `REMARK` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`TAG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据结构标签表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of EAI_TAG_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_APP_ACCESS
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_ACCESS`;
CREATE TABLE `MSG_APP_ACCESS`  (
  `APP_ACCESS_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密码',
  `SERVICE_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务类型',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否对外开放 0：禁用。 1：启用',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  PRIMARY KEY (`APP_ACCESS_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 622900765396312065 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_ACCESS
-- ----------------------------
INSERT INTO `MSG_APP_ACCESS` VALUES (622900765396312064, 'workflow', '工作流', '426bd4e7571f0bc777bbc48545582313', 'sms,mail,app_push,app_im,cp,dingTalk', 1, '2022-09-15 21:05:15', 1450756958461300737, '2022-09-16 17:01:37', 1450756958461300737, '0', NULL);

-- ----------------------------
-- Table structure for MSG_APP_IM_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_IM_CHANNEL`;
CREATE TABLE `MSG_APP_IM_CHANNEL`  (
  `APP_IM_CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道标识',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `SERVER` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'server地址',
  `PUB_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用ID',
  `PUB_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用名称',
  `PUB_PASSWORD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用密码',
  `COMPANY_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用公司ID',
  `COMPANY_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用公司名称',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否对外开放 0：禁用。 1：启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`APP_IM_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'AppIm通道' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_IM_CHANNEL
-- ----------------------------
INSERT INTO `MSG_APP_IM_CHANNEL` VALUES (3, 'APPIM00001', '系统通知', 'http://127.0.0.1:1234', 'XXXXXXXXXXXXX', '系统通知', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', '金企信试用企业', 1, NULL, '2022-05-13 09:49:38', NULL, '2022-09-14 11:15:00', 1450756958461300737, '0');

-- ----------------------------
-- Table structure for MSG_APP_IM_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_IM_SEND_RECORD`;
CREATE TABLE `MSG_APP_IM_SEND_RECORD`  (
  `MSG_APP_IM_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模版标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模版名字',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`URL` VARCHAR(255) NULL COMMENT '点击后添加的地址',
	`IM_PARAMS` TEXT NULL COMMENT 'IM的模版参数',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，TEXT：文本消息，TEXTCARD：文本卡片消息',
  `SERVER` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务器地址',
  `USER_IDS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户ID',
  `PUB_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布ID',
  `PUB_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布名称',
  `PUB_PASSWORD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布密码',
  `COMPANY_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司ID',
  `COMPANY_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `SEND_TYPE` int(11) NULL DEFAULT NULL COMMENT '发送类型（1-纯文本 2-图文 3-图片 4-文件）',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `FILE_NAMES` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态（1：未发送，2：发送失败，3：发送成功）',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  PRIMARY KEY (`MSG_APP_IM_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心APPIM发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_IM_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_APP_PUSH_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_PUSH_CHANNEL`;
CREATE TABLE `MSG_APP_PUSH_CHANNEL`  (
  `APP_PUSH_CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识',
  `CHANNEL_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'APP_ID',
  `SECRET_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SECRET_KEY',
  `ASSESS_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ASSESS_ID',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`APP_PUSH_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 23 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'App推送通道' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_PUSH_CHANNEL
-- ----------------------------
INSERT INTO `MSG_APP_PUSH_CHANNEL` VALUES (22, 'APP00001', '系统通知', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', 1, NULL, '2022-05-18 15:51:06', NULL, '2022-07-07 21:55:40', 1450756958461300737, '0');

-- ----------------------------
-- Table structure for MSG_APP_PUSH_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_PUSH_SEND_RECORD`;
CREATE TABLE `MSG_APP_PUSH_SEND_RECORD`  (
  `MSG_APP_PUSH_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_PUSH_PARAMS` TEXT NULL COMMENT 'appPsuh模版参数',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
  `SECRET_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密钥',
  `ASSESS_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评估ID',
  `TITLE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标题',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `ANGLE_MARK` int(11) NULL DEFAULT NULL COMMENT '角标数',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1：未发送，2：发送失败，3：发送成功',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `AUDIENCE_TYPE` int(11) NULL DEFAULT NULL COMMENT '目标类型 0：全部 1：token',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `PLATFORM` int(11) NULL DEFAULT NULL COMMENT '平台类型 0：安卓 1：IOS 2：安卓+IOS',
  `TOKEN_LIST` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'token 目标类型为1时必填',
  `ACTION_TYPE` int(11) NULL DEFAULT NULL COMMENT '点击动作类型，0:App 本身，1：打开 activity，2：打开浏览器 3：打开 Intent',
  `INTENT` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义页面中 intent 的实现，动作类型为 3 时必填',
  `URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设置打开特定 URL，动作类型为 2 时必填',
  `ACTIVITY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开自定义 activity，动作类型为 1 时必填',
  `ACTION_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `MSG_APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息应用ID',
  `MSG_APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息应用名称',
  `MSG_APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息应用密钥',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  PRIMARY KEY (`MSG_APP_PUSH_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心App推送发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_PUSH_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_APP_SCENE_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_SCENE_CONFIG`;
CREATE TABLE `MSG_APP_SCENE_CONFIG`  (
  `APP_SCENE_ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_PK_ID` bigint(20) NULL DEFAULT NULL COMMENT 'App主键id',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_DESC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景说明',
  `TAG_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`APP_SCENE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用场景配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_SCENE_CONFIG
-- ----------------------------
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202142492303360, 622900765396312064, 'todo', '任务待办', NULL, NULL, '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202324848058368, 622900765396312064, 'reject', '任务驳回', NULL, NULL, '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202474509213696, 622900765396312064, 'reminders', '任务催办', NULL, NULL, '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202602129301504, 622900765396312064, 'entrust', '流程委托', NULL, NULL, '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202731083177984, 622900765396312064, 'complete', '流程完成', NULL, NULL, '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (623202854248914944, 622900765396312064, 'terminated', '流程终止', NULL, NULL, '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO `MSG_APP_SCENE_CONFIG` VALUES (653555293984399360, 622900765396312064, 'exception', '流程异常', NULL, NULL, '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');

-- ----------------------------
-- Table structure for MSG_CONTACT
-- ----------------------------
DROP TABLE IF EXISTS `MSG_CONTACT`;
CREATE TABLE `MSG_CONTACT`  (
  `MSG_CONTACT_ID` bigint(20) NOT NULL COMMENT '主键',
  `CONTACT_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人标识',
  `CONTACT_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人类型',
  `CONTACT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人名称',
  `CONTACT_ID_AND_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人标识+类型',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MSG_CONTACT_ID`) USING BTREE,
  UNIQUE INDEX `CONTACT_ID_TYPE_IDX`(`CONTACT_ID` ASC, `CONTACT_TYPE` ASC) USING BTREE,
  INDEX `CONTACT_ID_AND_TYPE_IDX`(`CONTACT_ID_AND_TYPE` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '联系人表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_CONTACT
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_CONTACT_INFO
-- ----------------------------
DROP TABLE IF EXISTS `MSG_CONTACT_INFO`;
CREATE TABLE `MSG_CONTACT_INFO`  (
  `MSG_CONTACT_INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `CONTACT_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人标识',
  `CONTACT_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人类型',
  `CONTACT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人名称',
  `SEND_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送方式',
  `TAG_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `RECEIVE_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通讯地址',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道标识',
  `CONTACT_ID_AND_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人标识+类型',
  `MSG_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序字段',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MSG_CONTACT_INFO_ID`) USING BTREE,
  INDEX `INFO_CONTACT_ID_TYPE_IDX`(`CONTACT_ID` ASC, `CONTACT_TYPE` ASC) USING BTREE,
  INDEX `INFO_CONTACT_ID_AND_TYPE_IDX`(`CONTACT_ID_AND_TYPE` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '联系人通讯信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_CONTACT_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_CP_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_CP_CHANNEL`;
CREATE TABLE `MSG_CP_CHANNEL`  (
  `CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道id',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信标识',
  `CHANNEL_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `CORPID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信id',
  `CORP_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业名称',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '启用/禁用标识:0禁用；1启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识:0正常;1已删除',
  `AGENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用id',
  `AGENT_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `AGENT_SECRET` varchar(192) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信应用密钥',
  PRIMARY KEY (`CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '企业微信通道表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_CP_CHANNEL
-- ----------------------------
INSERT INTO `MSG_CP_CHANNEL` VALUES (1, 'CPC230310tjk34V9E30815', '轻骑兵示例通道', 'XXXXXXXXXXXXX', '轻骑兵示例企业', 1, '无', '2023-03-10 14:05:04', 1450756958461300737, '2023-03-10 14:05:03', NULL, '0', '1', '轻骑兵示例应用', 'XXXXXXXXXXXXX');

-- ----------------------------
-- Table structure for MSG_CP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_CP_TEMPLATE`;
CREATE TABLE `MSG_CP_TEMPLATE` (
	`CP_TEMPLATE_ID` BIGINT(20) NOT NULL COMMENT '主键',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`CONTENT` TEXT NULL COMMENT '模板内容',
	`URL` VARCHAR(255) NULL COMMENT '点击后跳转的链接',
	`TEMPLATE_PARAMS` TEXT NULL COMMENT '模板参数',
	`REMARK` VARCHAR(255) NULL COMMENT '说明',
	`ENABLE_DUPLICATE_CHECK` TINYINT NULL COMMENT '是否开启重复消息检查',
	`DUPLICATE_CHECK_INTERVAL` INT NULL COMMENT '重复消息检查的时间间隔',
	`OPEN_STATUS` INT(1) NULL COMMENT '状态 0：禁用。 1：启用。',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，text：文本消息，textcard：文本卡片消息，markdown：Markdown消息',
	`CREATOR` BIGINT(20) NULL COMMENT '创建人',
	`CREATE_TIME` DATETIME NULL COMMENT '创建时间',
	`LAST_EDITOR` BIGINT(20) NULL COMMENT '最后一次修改人',
	`LAST_TIME` DATETIME NULL COMMENT '最后一次修改时间',
	`DEL_FLAG` CHAR(1) NULL COMMENT '删除标识，1删除',
	PRIMARY KEY (`CP_TEMPLATE_ID`) USING BTREE
)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '企业微信推送模板表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_CP_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820261541030141952, 'CPT240313xPYSnZcG94761', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 'processName,expType,processKey,taskKey,taskName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:46:31', 1450756958461300737, '2024-03-13 11:47:02', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820262208016752640, 'CPT240313ySq1XPAm46958', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 'currentTime,processName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:49:10', 1450756958461300737, '2024-03-13 11:49:10', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820262744644395008, 'CPT240313zQdeei4i52826', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 'currentTime,processName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:51:18', 1450756958461300737, '2024-03-13 11:51:18', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820262832712196096, 'CPT240313x9yRpKFt28331', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 'currentTime,processName,taskName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:51:39', 1450756958461300737, '2024-03-13 11:51:39', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820262936533803008, 'CPT2403131Ekz6NYL00066', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 'currentTime,processName,startTime,endTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:04', 1450756958461300737, '2024-03-13 11:52:04', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263044105117696, 'CPT240313g17inv1a22864', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 'processName,currentTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:29', 1450756958461300737, '2024-03-13 11:52:29', '0');
INSERT INTO `MSG_CP_TEMPLATE` (`CP_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `TEMPLATE_PARAMS`, `REMARK`, `ENABLE_DUPLICATE_CHECK`, `DUPLICATE_CHECK_INTERVAL`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263104620535808, 'CPT240313fHPmQNk287578', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 'processName,currentTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:44', 1450756958461300737, '2024-03-13 11:52:44', '0');

-- ----------------------------
-- Table structure for MSG_APP_IM_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_IM_TEMPLATE`;
CREATE TABLE `MSG_APP_IM_TEMPLATE` (
	`APP_IM_TEMPLATE_ID` BIGINT(20) NOT NULL COMMENT '模板主键ID',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`CONTENT` TEXT NULL COMMENT '模板内容',
	`URL` VARCHAR(255) NULL COMMENT '点击后跳转的链接',
	`OPEN_STATUS` INT(1) NULL COMMENT '启用状态 0：禁用。 1：启用',
	`REMARK` VARCHAR(255) NULL COMMENT '说明',
	`TEMPLATE_PARAMS` TEXT NULL COMMENT '模板参数',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，text：文本消息，textcard：文本卡片消息',
	`CREATOR` BIGINT(20) NULL COMMENT '创建人',
	`CREATE_TIME` DATETIME NULL COMMENT '创建时间',
	`LAST_EDITOR` BIGINT(20) NULL COMMENT '最后一次修改人',
	`LAST_TIME` DATETIME NULL COMMENT '最后一次修改时间',
	`DEL_FLAG` CHAR(1) NULL COMMENT '删除标识，1删除',
	PRIMARY KEY (APP_IM_TEMPLATE_ID) USING BTREE
)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'IM推送模板表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_IM_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820250685147979776, 'APPIMT240313EX1mlG8u03780', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, NULL, 'processName,expType,processKey,taskKey,taskName', 'text', 1450756958461300737, '2024-03-13 11:03:23', 1450756958461300737, '2024-03-13 11:03:23', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820256871364698112, 'APPIMT240313fTFjiyaF87564', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, NULL, 'currentTime,processName', 'text', 1450756958461300737, '2024-03-13 11:27:58', 1450756958461300737, '2024-03-13 11:27:58', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820256968324423680, 'APPIMT240313bmeVCh1r34757', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, NULL, 'currentTime,processName', 'text', 1450756958461300737, '2024-03-13 11:28:21', 1450756958461300737, '2024-03-13 11:28:21', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820257043540877312, 'APPIMT240313gcBsklyf46844', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, NULL, 'currentTime,processName,taskName', 'text', 1450756958461300737, '2024-03-13 11:28:39', 1450756958461300737, '2024-03-13 11:28:39', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820257144128675840, 'APPIMT240313Vz7g3zyu13111', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, NULL, 'currentTime,processName,startTime,endTime', 'text', 1450756958461300737, '2024-03-13 11:29:03', 1450756958461300737, '2024-03-13 11:29:03', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820257460123344896, 'APPIMT2403134fynMRYu98152', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, NULL, 'processName,currentTime', 'text', 1450756958461300737, '2024-03-13 11:30:18', 1450756958461300737, '2024-03-13 11:30:18', '0');
INSERT INTO `MSG_APP_IM_TEMPLATE` (`APP_IM_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `URL`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820257564389548032, 'APPIMT240313jAt6KlRG81148', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, NULL, 'processName,currentTime', 'text', 1450756958461300737, '2024-03-13 11:30:43', 1450756958461300737, '2024-03-13 11:30:43', '0');

-- ----------------------------
-- Table structure for MSG_APP_PUSH_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_APP_PUSH_TEMPLATE`;
CREATE TABLE `MSG_APP_PUSH_TEMPLATE` (
	`APP_PUSH_TEMPLATE_ID` BIGINT(20) NOT NULL COMMENT '模板主键ID',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`CONTENT` TEXT NULL COMMENT '模板内容',
	`OPEN_STATUS` INT(1) NULL COMMENT '启用状态 0：禁用。 1：启用',
	`REMARK` VARCHAR(255) NULL COMMENT '说明',
	`TEMPLATE_PARAMS` TEXT NULL COMMENT '模板参数',
	`CREATOR` BIGINT(20) NULL COMMENT '创建人',
	`CREATE_TIME` DATETIME NULL COMMENT '创建时间',
	`LAST_EDITOR` BIGINT(20) NULL COMMENT '最后一次修改人',
	`LAST_TIME` DATETIME NULL COMMENT '最后一次修改时间',
	`DEL_FLAG` CHAR(1) NULL COMMENT '删除标识，1删除',
	PRIMARY KEY (APP_PUSH_TEMPLATE_ID) USING BTREE
)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'APP通知推送模板表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_APP_PUSH_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820259777669242880, 'APPPUSHT240313Jlnp782t32655', '流程异常提醒', '异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', 1, NULL, 'processName,expType,processKey,taskKey,taskName', 1450756958461300737, '2024-03-13 11:39:31', 1450756958461300737, '2024-03-13 11:39:31', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820259847881891840, 'APPPUSHT240313eviqlKeX23539', '流程待办提醒', '待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:39:47', 1450756958461300737, '2024-03-13 11:39:47', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820259935530262528, 'APPPUSHT2403138IdjYts663860', '流程驳回提醒', '驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:40:08', 1450756958461300737, '2024-03-13 11:40:08', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260027624595456, 'APPPUSHT2403137BGMf6G287636', '流程催办提醒', '催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', 1, NULL, 'currentTime,processName,taskName', 1450756958461300737, '2024-03-13 11:40:30', 1450756958461300737, '2024-03-13 11:40:30', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260198429237248, 'APPPUSHT240313Yau2N3BQ26358', '流程委托提醒', '委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', 1, NULL, 'currentTime,processName,startTime,endTime', 1450756958461300737, '2024-03-13 11:41:11', 1450756958461300737, '2024-03-13 11:41:11', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260277319901184, 'APPPUSHT240313XiaZPoRp13555', '流程完成提醒', '完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:41:30', 1450756958461300737, '2024-03-13 11:41:30', '0');
INSERT INTO `MSG_APP_PUSH_TEMPLATE` (`APP_PUSH_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260349638090752, 'APPPUSHT240313tbEIyD1206710', '流程终止提醒', '终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:41:47', 1450756958461300737, '2024-03-13 11:41:47', '0');

-- ----------------------------
-- Table structure for MSG_NOTICE_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_NOTICE_TEMPLATE`;
CREATE TABLE `MSG_NOTICE_TEMPLATE` (
	`NOTICE_TEMPLATE_ID` BIGINT(20) NOT NULL COMMENT '模板主键ID',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`CONTENT` TEXT NULL COMMENT '模板内容',
	`OPEN_STATUS` INT(1) NULL COMMENT '启用状态 0：禁用。 1：启用',
	`REMARK` VARCHAR(255) NULL COMMENT '说明',
	`TEMPLATE_PARAMS` TEXT NULL COMMENT '模板参数',
	`CREATOR` BIGINT(20) NULL COMMENT '创建人',
	`CREATE_TIME` DATETIME NULL COMMENT '创建时间',
	`LAST_EDITOR` BIGINT(20) NULL COMMENT '最后一次修改人',
	`LAST_TIME` DATETIME NULL COMMENT '最后一次修改时间',
	`DEL_FLAG` CHAR(1) NULL COMMENT '删除标识，1删除',
	PRIMARY KEY (NOTICE_TEMPLATE_ID) USING BTREE
)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '内部通知推送模板表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_NOTICE_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260723249913856, 'NOTICET240313Nj2H0FqW96127', '流程异常提醒', '异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', 1, NULL, 'processName,expType,processKey,taskKey,taskName', 1450756958461300737, '2024-03-13 11:43:16', 1450756958461300737, '2024-03-13 11:43:16', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260799313616896, 'NOTICET240313KIeE4dj376383', '流程待办提醒', '待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:43:34', 1450756958461300737, '2024-03-13 11:43:34', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260862790213632, 'NOTICET2403134jX9HVe619424', '流程驳回提醒', '驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:43:49', 1450756958461300737, '2024-03-13 11:43:49', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820260926833041408, 'NOTICET240313dGAvFE4A53346', '流程催办提醒', '催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', 1, NULL, 'currentTime,processName,taskName', 1450756958461300737, '2024-03-13 11:44:05', 1450756958461300737, '2024-03-13 11:44:05', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820261008022183936, 'NOTICET240313OH6rnoPQ31873', '流程委托提醒', '委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', 1, NULL, 'currentTime,processName,startTime,endTime', 1450756958461300737, '2024-03-13 11:44:24', 1450756958461300737, '2024-03-13 11:44:24', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820261088670261248, 'NOTICET240313ADBSgqAc91004', '流程完成提醒', '完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:44:43', 1450756958461300737, '2024-03-13 11:44:43', '0');
INSERT INTO `MSG_NOTICE_TEMPLATE` (`NOTICE_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `OPEN_STATUS`, `REMARK`, `TEMPLATE_PARAMS`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820261155477135360, 'NOTICET240313p3IDRCos59334', '流程终止提醒', '终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:44:59', 1450756958461300737, '2024-03-13 11:44:59', '0');

-- ----------------------------
-- Table structure for MSG_DING_TALK_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_DING_TALK_TEMPLATE`;
CREATE TABLE `MSG_DING_TALK_TEMPLATE` (
	`DING_TALK_TEMPLATE_ID` BIGINT(20) NOT NULL COMMENT '主键',
	`TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`CONTENT` TEXT NULL COMMENT '模板内容',
	`BTN_JSON_LIST` VARCHAR(1000) NULL COMMENT '卡片消息时，按钮标题和点击跳转地址',
	`BTN_ORIENTATION` CHAR(1) NULL COMMENT '卡片消息时，按钮标题和点击跳转地址',
	`SINGLE_TITLE` VARCHAR(128) NULL COMMENT 'single卡片下标题',
	`SINGLE_URL` VARCHAR(255) NULL COMMENT 'single卡片下标题跳转地址',
	`TEMPLATE_PARAMS` TEXT NULL COMMENT '模板参数',
	`REMARK` VARCHAR(255) NULL COMMENT '说明',
	`OPEN_STATUS` INT(1) NULL COMMENT '状态 0：禁用。 1：启用。',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，text：文本消息，action_card_single：卡片消息（按钮），action_card_btn：卡片消息（按钮），markdown：Markdown消息',
	`CREATOR` BIGINT(20) NULL COMMENT '创建人',
	`CREATE_TIME` DATETIME NULL COMMENT '创建时间',
	`LAST_EDITOR` BIGINT(20) NULL COMMENT '最后一次修改人',
	`LAST_TIME` DATETIME NULL COMMENT '最后一次修改时间',
	`DEL_FLAG` CHAR(1) NULL COMMENT '删除标识，1删除',
	PRIMARY KEY (`DING_TALK_TEMPLATE_ID`) USING BTREE
)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '钉钉推送模板表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_DING_TALK_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263212330262528, 'DINGTALKT240313SjW5sjcS80369', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, NULL, NULL, NULL, 'processName,expType,processKey,taskKey,taskName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:10', 1450756958461300737, '2024-03-13 11:53:10', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263279778865152, 'DINGTALKT240313DfjAutzt03959', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:26', 1450756958461300737, '2024-03-13 11:53:26', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263366026338304, 'DINGTALKT2403133LrM2V8M88003', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:46', 1450756958461300737, '2024-03-13 11:53:46', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263427544195072, 'DINGTALKT24031309RZLURF04157', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName,taskName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:01', 1450756958461300737, '2024-03-13 11:54:01', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263498000113664, 'DINGTALKT240313RKPCXmnf66552', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName,startTime,endTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:18', 1450756958461300737, '2024-03-13 11:54:18', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263579810013184, 'DINGTALKT240313mg6oHZgA18501', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, NULL, NULL, NULL, 'processName,currentTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:37', 1450756958461300737, '2024-03-13 11:54:37', '0');
INSERT INTO `MSG_DING_TALK_TEMPLATE` (`DING_TALK_TEMPLATE_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TITLE`, `CONTENT`, `BTN_JSON_LIST`, `BTN_ORIENTATION`, `SINGLE_TITLE`, `SINGLE_URL`, `TEMPLATE_PARAMS`, `REMARK`, `OPEN_STATUS`, `MESSAGE_TYPE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `DEL_FLAG`) VALUES(820263640468037632, 'DINGTALKT240313WCspHRt714521', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, NULL, NULL, NULL, 'processName,currentTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:52', 1450756958461300737, '2024-03-13 11:54:52', '0');

-- ----------------------------
-- Table structure for MSG_CP_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_CP_SEND_RECORD`;
CREATE TABLE `MSG_CP_SEND_RECORD`  (
  `MSG_CP_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模版标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模版名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`URL` VARCHAR(255) NULL COMMENT '点击后跳转的链接',
	`CP_PARAMS` TEXT NULL COMMENT 'CP的模版参数',
	`ENABLE_DUPLICATE_CHECK` TINYINT NULL COMMENT '是否开启重复消息检查',
	`DUPLICATE_CHECK_INTERVAL` INT NULL COMMENT '重复消息检查的时间间隔',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，text：文本消息，textcard：文本卡片消息，markdown：Markdown消息',
  `TO_USER` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收用户',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `CORP_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信标识',
  `CORP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业名称',
  `AGENT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信应用名称',
  `AGENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信应用标识',
  `AGENT_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业微信应用密钥',
  `MSG_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1：发送中。2：发送失败。3：发送成功',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  `MSG_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息ID',
  PRIMARY KEY (`MSG_CP_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心企业微信发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_CP_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_DINGTALK_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_DINGTALK_CHANNEL`;
CREATE TABLE `MSG_DINGTALK_CHANNEL`  (
  `CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道id',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道标识',
  `CHANNEL_NAME` varchar(192) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `CORP_NAME` varchar(192) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业名称',
  `APP_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用名称',
  `APP_SECRET` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用密钥',
  `AGENT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用id',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '启用/禁用状态',
  `REMARK` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `APP_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用KEY',
  PRIMARY KEY (`CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '钉钉通道表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_DINGTALK_CHANNEL
-- ----------------------------
INSERT INTO `MSG_DINGTALK_CHANNEL` VALUES (1, 'DINGTALK23041113Z3qHCp55143', '轻骑兵示例通道', '轻骑兵示例企业', '轻骑兵示例应用', 'XXXXXXXXXXXXX', '12345678', 1, '', '2023-04-11 09:20:21', 1450756958461300737, '2023-04-11 09:34:07', 1450756958461300737, '0', 'XXXXXXXXXXXXX');

-- ----------------------------
-- Table structure for MSG_DING_TALK_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_DING_TALK_SEND_RECORD`;
CREATE TABLE `MSG_DING_TALK_SEND_RECORD`  (
  `MSG_DING_TALK_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '通道id',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道编码',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
	`TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
	`TITLE` VARCHAR(128) NULL COMMENT '标题',
	`BTN_JSON_LIST` VARCHAR(1000) NULL COMMENT '卡片消息时，按钮标题和点击跳转地址',
	`BTN_ORIENTATION` CHAR(1) NULL COMMENT '按钮排列方式: 0：竖直排列 1：横向排列',
	`SINGLE_TITLE` VARCHAR(128) NULL COMMENT 'single卡片下标题',
	`SINGLE_URL` VARCHAR(255) NULL COMMENT 'single卡片下标题跳转地址',
	`DING_TALK_PARAMS` TEXT NULL COMMENT 'dingTalk模版参数',
	`MESSAGE_TYPE` VARCHAR(128) NULL COMMENT '消息类型，text：文本消息，action_card_single：卡片消息（子标题），action_card_btn：卡片消息（按钮），markdown：Markdown消息',
  `TO_USER` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收用户',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `CORP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '企业名称',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用名称',
  `AGENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用标识',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钉钉应用密钥',
  `APP_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'appKey',
  `MSG_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1：发送中。2：发送失败。3：发送成功',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `DING_APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `DING_APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  `MSG_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息ID',
  PRIMARY KEY (`MSG_DING_TALK_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心钉钉发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_DING_TALK_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MAIL_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MAIL_CHANNEL`;
CREATE TABLE `MSG_MAIL_CHANNEL`  (
  `MAIL_CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `MAIL_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱地址',
  `MAIL_PROTOCOL` int(11) NULL DEFAULT NULL COMMENT '邮箱协议(1:SMTP 2:EXCHANGE)',
  `MAIL_PASSWORD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱密码',
  `SENDER_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人名称',
  `MAIL_SERVER_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱服务器地址',
  `MAIL_PORT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱端口',
  `SAFE_TYPE` int(11) NULL DEFAULT NULL COMMENT '安全类型（1:SSL 2：STARTTLS）',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  `CHANNEL_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公众号标识',
  PRIMARY KEY (`MAIL_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '邮箱通道' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MAIL_CHANNEL
-- ----------------------------
INSERT INTO `MSG_MAIL_CHANNEL` VALUES (2, '轻骑兵163邮箱信道', 'hussar_base_2022@163.com', 1, 'XXXXXXXXXXXXX', '轻骑兵', 'smtp.163.com', '465', 1, 1, NULL, '2022-05-09 17:53:24', NULL, '2022-08-30 11:18:35', 1450756958461300737, '0', 'MAILC2206180000140');

-- ----------------------------
-- Table structure for MSG_MAIL_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MAIL_GROUP`;
CREATE TABLE `MSG_MAIL_GROUP`  (
  `MAIL_GROUP_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '分组id',
  `GROUP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`MAIL_GROUP_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '邮箱分组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MAIL_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MAIL_RECIVER
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MAIL_RECIVER`;
CREATE TABLE `MSG_MAIL_RECIVER`  (
  `MAIL_RECIVER_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '收件人ID',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  `RECIVER_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人姓名',
  `RECIVER_MAIL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人邮箱',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `GROUP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `GROUP_ID` bigint(20) NULL DEFAULT NULL COMMENT '分组ID',
  PRIMARY KEY (`MAIL_RECIVER_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '邮箱接收人管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MAIL_RECIVER
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MAIL_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MAIL_SEND_RECORD`;
CREATE TABLE `MSG_MAIL_SEND_RECORD`  (
  `MSG_MAIL_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `MAIL_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱地址',
  `MAIL_PROTOCOL` int(11) NULL DEFAULT NULL COMMENT '邮箱协议：1SMTP；2EXCHANGE',
  `MAIL_PASSWORD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱密码',
  `SENDER_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发件人名称',
  `MAIL_SERVER_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱服务器地址',
  `MAIL_PORT` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱端口',
  `SAFE_TYPE` int(11) NULL DEFAULT NULL COMMENT '安全类型：1SSL；2STARTTLS',
  `MAIL_TEMPLATE_ID` bigint(20) NULL DEFAULT NULL COMMENT '邮件模板ID',
  `TEMPLATE_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板标识',
  `TEMPLATE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `RECIVER_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人名称',
  `RECIVER_MAIL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人邮箱',
  `MAIL_CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮件内容',
  `MAIL_SUBJECT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮件主题',
  `FILE_IDS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件ids,多个用逗号分隔',
  `GROPU_IDS` bigint(20) NULL DEFAULT NULL COMMENT '组id',
  `RECIVER_ID` bigint(20) NULL DEFAULT NULL COMMENT '收件人ID',
  `CC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '抄送人',
  `IS_BATH` tinyint(1) NULL DEFAULT NULL COMMENT '是否批量',
  `MAIL_PARAMS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮件参数',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1：未发送，2：发送失败，3：发送成功',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  PRIMARY KEY (`MSG_MAIL_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心邮件发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MAIL_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MAIL_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MAIL_TEMPLATE`;
CREATE TABLE `MSG_MAIL_TEMPLATE` (
  `MAIL_TEMPLATE_ID` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `CHANNEL_ID` BIGINT(20) DEFAULT NULL COMMENT '通道ID',
  `TEMPLATE_NO` VARCHAR(50) DEFAULT NULL COMMENT '模板标识',
  `TEMPLATE_NAME` VARCHAR(128) DEFAULT NULL COMMENT '模板名称',
  `TEMPLATE_CONTENT` TEXT DEFAULT NULL COMMENT '模板内容',
  `MAIL_SUBJECT` VARCHAR(128) NULL COMMENT '邮件主题',
  `REMARK` VARCHAR(255) DEFAULT NULL COMMENT '说明',
  `OPEN_STATUS` INT(1) DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `CREATE_TIME` DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` BIGINT(20) DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` BIGINT(20) DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` CHAR(1) DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  `FILE_IDS` VARCHAR(255) DEFAULT NULL,
  `TEMPLATE_PARAMS` VARCHAR(255) DEFAULT NULL COMMENT '模板参数',
  PRIMARY KEY (`MAIL_TEMPLATE_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 653554652889227265 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '邮箱模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MAIL_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624171659833901238, NULL, 'MAILT2206210000154', '流程待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, '2022-06-21 10:07:40', NULL, '2022-06-21 10:07:40', NULL, '0', NULL, 'currentTime,processName', '待办提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624171659833909248, NULL, 'MAILT220919AAS3qozY11174', '流程驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, '2022-09-19 09:15:20', 1450756958461300737, '2022-09-19 09:15:20', NULL, '0', NULL, 'currentTime,processName', '驳回提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624171810195513344, NULL, 'MAILT220919JmKL4FNg49717', '流程催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, '2022-09-19 09:15:56', 1450756958461300737, '2022-09-19 09:15:56', NULL, '0', NULL, 'currentTime,processName,taskName', '催办提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624171921201963008, NULL, 'MAILT220919l56aADks17501', '流程委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, '2022-09-19 09:16:23', 1450756958461300737, '2022-09-19 09:16:22', NULL, '0', NULL, 'currentTime,processName,startTime,endTime', '委托提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624172132531970048, NULL, 'MAILT220919bGCjleJO70191', '流程完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, '2022-09-19 09:17:13', 1450756958461300737, '2022-09-19 09:17:12', NULL, '0', NULL, 'processName,currentTime', '完成提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (624172273125040128, NULL, 'MAILT220919HzpMkf9J91595', '流程终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, '2022-09-19 09:17:46', 1450756958461300737, '2022-09-19 09:17:46', NULL, '0', NULL, 'processName,currentTime', '终止提醒');
INSERT INTO `MSG_MAIL_TEMPLATE` (`MAIL_TEMPLATE_ID`, `CHANNEL_ID`, `TEMPLATE_NO`, `TEMPLATE_NAME`, `TEMPLATE_CONTENT`, `REMARK`, `OPEN_STATUS`, `CREATE_TIME`, `CREATOR`, `LAST_TIME`, `LAST_EDITOR`, `DEL_FLAG`, `FILE_IDS`, `TEMPLATE_PARAMS`, `MAIL_SUBJECT`) VALUES (653554652889227264, NULL, 'MAILT221209sx0JH2vc45290', '流程异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, '2022-12-15 14:47:32', NULL, '2022-12-15 14:47:32', NULL, '0', NULL, 'processName,expType,processKey,taskKey,taskName', '异常提醒');

-- ----------------------------
-- Table structure for MSG_MP_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MP_CHANNEL`;
CREATE TABLE `MSG_MP_CHANNEL`  (
  `MP_CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公众号标识',
  `CHANNEL_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公众号名称',
  `KEY_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'KEY_ID',
  `KEY_SECRET` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'KEY_SECRET',
  `TOKEN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TOKEN',
  `AESKEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EncodingAESKey',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`MP_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公众号通道' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MP_CHANNEL
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MP_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MP_SEND_RECORD`;
CREATE TABLE `MSG_MP_SEND_RECORD`  (
  `MSG_MP_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `TEMPLATE_ID` bigint(20) NULL DEFAULT NULL COMMENT '模板ID',
  `TEMPLATE_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板编号',
  `TEMPLATE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `TEMPLATE_BIZ_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板业务ID',
  `TO_USER` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收用户',
  `URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '跳转链接',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `KEY_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密钥ID',
  `KEY_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密钥密码',
  `TOKEN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'token',
  `AESKEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码AESKey',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1：发送中。2：发送失败。3：发送成功',
  `ERR_MSG` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `MSG_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息记录id',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  PRIMARY KEY (`MSG_MP_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心微信公众号发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MP_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_MP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_MP_TEMPLATE`;
CREATE TABLE `MSG_MP_TEMPLATE`  (
  `MP_TEMPLATE_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '公众号ID',
  `TEMPLATE_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板标识',
  `TEMPLATE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `TEMPLATE_BIZ_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板业务ID',
  `TITLE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板标题',
  `CONTENT` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板内容',
  `EXAMPLE` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板示例',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`MP_TEMPLATE_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公众号模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_MP_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_NOTICE_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_NOTICE_SEND_RECORD`;
CREATE TABLE `MSG_NOTICE_SEND_RECORD` (
  `MSG_NOTICE_SEND_RECORD_ID` BIGINT(20) NOT NULL COMMENT '主键',
  `NOTICE_TYPE_ID` BIGINT(20) DEFAULT NULL COMMENT '通知类型ID',
  `NOTICE_TITLE` VARCHAR(255) DEFAULT NULL COMMENT '通知标题',
  `TEMPLATE_NO` VARCHAR(64) NULL COMMENT '模板标识',
  `TEMPLATE_NAME` VARCHAR(128) NULL COMMENT '模板名称',
  `NOTICE_PARAMS` TEXT NULL COMMENT 'notice模版参数',
  `APPROVER_ID` BIGINT(20) DEFAULT NULL COMMENT '审批人ID',
  `RELEASE_DATE` DATETIME(3) DEFAULT NULL COMMENT '发布日期',
  `CREATE_TIME` DATETIME(3) DEFAULT NULL COMMENT '创建时间',
  `NOTICE_CONTENT` VARCHAR(4000) DEFAULT NULL COMMENT '通知内容',
  `DEPARTMENT_ID` TEXT DEFAULT NULL COMMENT '部门ID',
  `ROLE_ID` TEXT  DEFAULT NULL COMMENT '角色ID',
  `CREATOE_DEPARTMENT_ID` BIGINT(20) DEFAULT NULL COMMENT '创建者部门ID',
  `NOTICE_ISSUE` VARCHAR(64) DEFAULT NULL COMMENT '通知发布人',
  `CREATOR` BIGINT(20) DEFAULT NULL COMMENT '公告创建者(ID)',
  `DEPT_ROLE_NAME` TEXT  DEFAULT NULL COMMENT '部门角色名称',
  `CREATE_DATE_NOT_HOUR` VARCHAR(64) DEFAULT NULL COMMENT '创建日期（不含小时）',
  `RELEASE_DATE_NOT_HOUR` VARCHAR(64) DEFAULT NULL COMMENT '发布日期YYYY-MM-DD',
  `STATUS` INT(1) DEFAULT NULL COMMENT '发送状态 1:发送中 2：发送失败。 3：发送成功。',
  `SEND_TIME` DATETIME(3) DEFAULT NULL COMMENT '发送时间',
  `ERR_MSG` VARCHAR(4000) DEFAULT NULL COMMENT '错误信息',
  `APP_ID` VARCHAR(64) DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` VARCHAR(255) DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` VARCHAR(255) DEFAULT NULL COMMENT '应用密钥',
  `SCENE_CODE` VARCHAR(32) DEFAULT NULL COMMENT '场景编码',
  `SCENE_NAME` VARCHAR(32) DEFAULT NULL COMMENT '场景名称',
  PRIMARY KEY (`MSG_NOTICE_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心内部通知发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_NOTICE_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_SCENE_CHANNEL_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SCENE_CHANNEL_CONFIG`;
CREATE TABLE `MSG_SCENE_CHANNEL_CONFIG`  (
  `SCENE_CHANNEL_ID` bigint(20) NOT NULL COMMENT '主键',
  `SCENE_ID` bigint(20) NULL DEFAULT NULL COMMENT '场景主键id',
  `CHANNEL_CONFIG_JSON` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道配置json',
  `CHANNEL_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道类型：sms,mail,app_im,app_push,wx_account,cp',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`SCENE_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '场景渠道配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SCENE_CHANNEL_CONFIG
-- ----------------------------
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202142513274881, 623202142492303360, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT220920Ievepju977469\"}', 'sms', '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202142525857792, 623202142492303360, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT2206210000154\"}', 'mail', '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202324864835584, 623202324848058368, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT220920AZMRpnyO17411\"}', 'sms', '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202324881612800, 623202324848058368, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT220919AAS3qozY11174\"}', 'mail', '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202474534379520, 623202474509213696, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT2209200FTTVhW965856\"}', 'sms', '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202474551156736, 623202474509213696, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT220919JmKL4FNg49717\"}', 'mail', '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202602150273024, 623202602129301504, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT220920tFARf9vH09538\"}', 'sms', '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202602162855936, 623202602129301504, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT220919l56aADks17501\"}', 'mail', '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202731112538112, 623202731083177984, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT220920YofTEuCJ31349\"}', 'sms', '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202731125121024, 623202731083177984, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT220919bGCjleJO70191\"}', 'mail', '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202854269886464, 623202854248914944, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT2209202ZHfgc1290781\"}', 'sms', '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (623202854282469376, 623202854248914944, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT220919HzpMkf9J91595\"}', 'mail', '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624557728551149568, 623202854248914944, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624557728572121088, 623202854248914944, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558475082735616, 623202324848058368, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558475099512832, 623202324848058368, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558490903650306, 623202602129301504, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558490920427520, 623202602129301504, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558507437596673, 623202731083177984, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624558507458568192, 623202731083177984, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624559763648421889, 623202474509213696, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (624559763665199104, 623202474509213696, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189270847488, 623202142492303360, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430400, 623202142492303360, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430401, 623202854248914944, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430402, 623202324848058368, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430403, 623202602129301504, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430404, 623202731083177984, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430405, 623202474509213696, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430406, 623202142492303360, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430407, 653555293984399360, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (625043189283430408, 653555293984399360, '{\"channelNo\":\"CPC230310tjk34V9E30815\"}', 'cp', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (653555294001176577, 653555293984399360, '{\"channelNo\":\"MSMC2206180000423\",\"signNo\":\"MSMS2206180000127\",\"templateNo\":\"MSMT221209TqYKwH9t52990\"}', 'sms', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (653555294013759488, 653555293984399360, '{\"channelNo\":\"MAILC2206180000140\",\"templateNo\":\"MAILT221209sx0JH2vc45290\"}', 'mail', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (653555294022148097, 653555293984399360, '{\"channelNo\":\"APPIM00001\"}', 'app_im', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (653555294034731009, 653555293984399360, '{\"channelNo\":\"APP00001\"}', 'app_push', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698528951165001728, 623202854248914944, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:44:40', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698529010921250816, 623202731083177984, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:44:54', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698529113744613376, 623202602129301504, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:19', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698529215745892353, 623202474509213696, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:43', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698529269504286721, 623202324848058368, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:56', 1450756958461300737, '0');
INSERT INTO `MSG_SCENE_CHANNEL_CONFIG` VALUES (698529295920013313, 623202142492303360, '{\"channelNo\":\"DINGTALK23041113Z3qHCp55143\"}', 'dingTalk', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');

-- ----------------------------
-- Table structure for MSG_SCENE_CONTACT
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SCENE_CONTACT`;
CREATE TABLE `MSG_SCENE_CONTACT`  (
  `MSG_SCENE_CONTACT_ID` bigint(20) NOT NULL COMMENT '主键',
  `SCENE_ID` bigint(20) NULL DEFAULT NULL COMMENT '场景主键',
  `MSG_CONTACT_ID` bigint(20) NULL DEFAULT NULL COMMENT '联系人表主键',
  `CONTACT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人名字',
  `SEND_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送类型',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MSG_SCENE_CONTACT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '场景联系人关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SCENE_CONTACT
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_SMS_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SMS_CHANNEL`;
CREATE TABLE `MSG_SMS_CHANNEL`  (
  `SMS_CHANNEL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '通道ID',
  `CHANNEL_TYPE` int(11) NULL DEFAULT NULL COMMENT '通道类型：1阿里云；2腾讯云',
  `CHANNEL_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道标识',
  `CHANNEL_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道名称',
  `KEY_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'KEY_ID',
  `KEY_SECRET` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'KEY_SECRET',
  `APP_KEY` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '短信 SdkAppId(腾讯云专用)',
  `REGION` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地域(腾讯云专用)',
  `OPEN_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否给用户开放0：禁用。 1：启用',
  `REMARK` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`SMS_CHANNEL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 57 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '短信通道' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SMS_CHANNEL
-- ----------------------------
INSERT INTO `MSG_SMS_CHANNEL` VALUES (56, 1, 'MSMC2206180000423', '轻骑兵', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', NULL, NULL, 1, NULL, '2022-05-23 18:07:24', NULL, '2022-05-23 18:07:24', NULL, '0');

-- ----------------------------
-- Table structure for MSG_SMS_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SMS_SEND_RECORD`;
CREATE TABLE `MSG_SMS_SEND_RECORD`  (
  `MSG_SMS_SEND_RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '渠道ID',
  `SIGN_ID` bigint(20) NULL DEFAULT NULL COMMENT '签名ID',
  `TEMPLATE_ID` bigint(20) NULL DEFAULT NULL COMMENT '模板ID',
  `CHANNEL_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编号',
  `SIGN_NO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名编号',
  `TEMPLATE_NO` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板编号',
  `CHANNEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道名称',
  `SIGN_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名名称',
  `TEMPLATE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `CHANNEL_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道类型',
  `TEMPLATE_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板编码',
  `PHONE_NUMBER` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `PARAMS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数',
  `CONTENT` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容',
  `ACCESS_KEY_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '访问密钥ID',
  `ACCESS_KEY_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '访问密钥密钥',
  `SMS_SDK_APP_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SdkAppId',
  `REGION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地域',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '发送状态 1:发送中 2：发送失败。 3：发送成功。',
  `ERR_MSG` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误消息',
  `BIZ_ID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务ID',
  `CREATE_TIME` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `SEND_TIME` datetime(3) NULL DEFAULT NULL COMMENT '发送时间',
  `CREATE_DATE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建日期',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `TIM` tinyint(1) NULL DEFAULT NULL COMMENT '是否定时',
  `JOB_TIME` datetime(3) NULL DEFAULT NULL COMMENT '定时时间',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `APP_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APP_SECRET` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用密钥',
  `SCENE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `SCENE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景编码',
  `MSG_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息ID',
  PRIMARY KEY (`MSG_SMS_SEND_RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心消息短信发送记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SMS_SEND_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_SMS_SIGN
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SMS_SIGN`;
CREATE TABLE `MSG_SMS_SIGN`  (
  `SMS_SIGN_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '签名ID',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '通道ID',
  `SIGN_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名标识',
  `SIGN_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名名称',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `OPEN_STATUS` int(11) NULL DEFAULT 0 COMMENT '状态 0：禁用。 1：启用',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`SMS_SIGN_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '短信签名' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SMS_SIGN
-- ----------------------------
INSERT INTO `MSG_SMS_SIGN` VALUES (15, 56, 'MSMS2206180000127', '轻骑兵低代码开发平台', '', 1, '2022-05-23 18:10:15', NULL, NULL, NULL, '0');

-- ----------------------------
-- Table structure for MSG_SMS_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SMS_TEMPLATE`;
CREATE TABLE `MSG_SMS_TEMPLATE`  (
  `SMS_TEMPLATE_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `CHANNEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '通道ID',
  `TEMPLATE_NO` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板标识',
  `TEMPLATE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `TEMPLATE_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板code',
  `TEMPLATE_CONTENT` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板内容',
  `REMARK` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `OPEN_STATUS` int(11) NULL DEFAULT 0 COMMENT '状态 * 0：禁用。 *1：启用。',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`SMS_TEMPLATE_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 653555115957166081 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '短信模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SMS_TEMPLATE
-- ----------------------------
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546443612659712, 56, 'MSMT2209202ZHfgc1290781', '流程终止提醒', 'SMS_464250694', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, '2022-09-20 10:04:36', 1450756958461300737, '2022-09-20 10:04:35', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546521500884992, 56, 'MSMT220920YofTEuCJ31349', '流程完成提醒', 'SMS_464195728', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, '2022-09-20 10:04:54', 1450756958461300737, '2022-09-20 10:04:54', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546603465973760, 56, 'MSMT220920tFARf9vH09538', '流程委托提醒', 'SMS_464160771', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, '2022-09-20 10:05:14', 1450756958461300737, '2022-09-20 10:05:13', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546686194425856, 56, 'MSMT2209200FTTVhW965856', '流程催办提醒', 'SMS_464165676', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, '2022-09-20 10:05:34', 1450756958461300737, '2022-09-20 10:05:33', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546766557290496, 56, 'MSMT220920AZMRpnyO17411', '流程驳回提醒', 'SMS_464165675', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, '2022-09-20 10:05:53', 1450756958461300737, '2022-09-20 10:05:52', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (624546838124699648, 56, 'MSMT220920Ievepju977469', '流程待办提醒', 'SMS_464190694', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, '2022-09-20 10:06:10', 1450756958461300737, '2022-09-20 10:06:09', NULL, '0');
INSERT INTO `MSG_SMS_TEMPLATE` VALUES (653555115957166080, 56, 'MSMT221209TqYKwH9t52990', '流程异常提醒', 'SMS_264190139', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, '2022-12-15 14:47:32', NULL, '2022-12-15 14:47:32', NULL, '0');

-- ----------------------------
-- Table structure for MSG_SUPPORTED_SEND_TYPE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_SUPPORTED_SEND_TYPE`;
CREATE TABLE `MSG_SUPPORTED_SEND_TYPE`  (
  `MSG_SUPPORTED_SEND_TYPE_ID` bigint(20) NOT NULL COMMENT '主键',
  `SEND_TYPE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送类型编码',
  `SEND_TYPE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送类型名称',
  `RECEIVE_MODEL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收方式',
  `RECEIVE_ADDRESS_EXAMPLE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收地址示例',
  `CHANNEL_NO` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通道编码',
  `NEED_FRONT_DISPLAY` tinyint NULL DEFAULT NULL COMMENT '是否需要前台显示',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MSG_SUPPORTED_SEND_TYPE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息中心支持的发送类型列表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_SUPPORTED_SEND_TYPE
-- ----------------------------
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (1, 'sms', '短信', '请输入手机号', '13255555555', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (2, 'mail', '邮件', '请输入邮箱地址', '123@163.com', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (3, 'wx_account', '微信公众号', 'OpenId', '请输入微信公众号OpenId', NULL, 0, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (4, 'app_im', 'IM推送', 'UserId', '请输入UserId', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (5, 'app_push', 'APP通知推送', 'Token', '请输入Token', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (6, 'notice', '内部通知推送', 'UserId', '请输入UserId', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (7, 'cp', '企业微信推送', 'UserId', '请输入企业微信UserId', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO `MSG_SUPPORTED_SEND_TYPE` VALUES (8, 'dingTalk', '钉钉推送', 'UserId', '请输入钉钉UserId', NULL, 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for MSG_TAG
-- ----------------------------
DROP TABLE IF EXISTS `MSG_TAG`;
CREATE TABLE `MSG_TAG`  (
  `MSG_TAG_ID` bigint(20) NOT NULL COMMENT '主键',
  `TAG_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标签名(唯一)',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MSG_TAG_ID`) USING BTREE,
  UNIQUE INDEX `TAG_NAME_UNIQUE`(`TAG_NAME` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '标签表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_TAG
-- ----------------------------

-- ----------------------------
-- Table structure for MSG_USER_SERVICE
-- ----------------------------
DROP TABLE IF EXISTS `MSG_USER_SERVICE`;
CREATE TABLE `MSG_USER_SERVICE`  (
  `USER_SERVICE_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `MESSAGE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `OTHER_USER_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三方用户标识（openId,token等）',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  PRIMARY KEY (`USER_SERVICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户服务关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of MSG_USER_SERVICE
-- ----------------------------

-- ----------------------------
-- Table structure for NOCODE_BPM_EXTEND_DATA
-- ----------------------------
DROP TABLE IF EXISTS `NOCODE_BPM_EXTEND_DATA`;
CREATE TABLE `NOCODE_BPM_EXTEND_DATA`  (
  `ID_` bigint(20) NOT NULL COMMENT '主键',
  `TASK_ID_` bigint(20) NULL DEFAULT NULL COMMENT '任务id',
  `PROC_INST_ID_` bigint(20) NULL DEFAULT NULL COMMENT '流程实例id',
  `SIGNATURE_` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '签名',
  PRIMARY KEY (`ID_`) USING BTREE,
  INDEX `NOCODE_BPM_EXTEND_DATA_TASK_ID__IDX`(`TASK_ID_` ASC) USING BTREE,
  INDEX `NOCODE_BPM_EXTEND_DATA_PROC_INST_ID__IDX`(`PROC_INST_ID_` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '零代码扩展数据表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of NOCODE_BPM_EXTEND_DATA
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_AGENDA
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AGENDA`;
CREATE TABLE `SYS_AGENDA`  (
  `AGENDA_ID` bigint(20) NOT NULL COMMENT '日程id',
  `AGENDA_TITLE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '日程标题',
  `AGENDA_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日程类型',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑着',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次修改时间',
  `AGENDA_CONTENT` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日程内容',
  `PLACE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地点',
  `START_TIME` datetime NOT NULL COMMENT '开始时间',
  `END_TIME` datetime NOT NULL COMMENT '结束时间',
  PRIMARY KEY (`AGENDA_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '日程管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AGENDA
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APPLICATION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APPLICATION`;
CREATE TABLE `SYS_APPLICATION`  (
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID 主键字段',
  `APP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用名称',
  `APP_GROUP_ID` bigint(20) NOT NULL COMMENT '应用分组ID',
  `APP_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用编码',
  `APP_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用类型 1：零代码 2：低代码 3：自建应用 7：微前端子应用',
  `APP_ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用图标类型\r\n1：内置图标\r\n2：用户自定义',
  `APP_ICON` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用图标\r\n内置图标：图标标识\r\n用户自定义：图片ID',
  `APP_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内置图标颜色',
  `SECRET_KEY` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用密钥，统一待办、统一认证需要',
  `APP_DESCRIBE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用描述',
  `WEB_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Web访问地址',
  `MOBILE_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机访问地址',
  `APP_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用状态\r\n0：禁用\r\n1：启用\r\n默认值：1',
  `RELEASE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用发布状态\r\n1：已上架\r\n0：未上架\r\n默认值：0',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `STATUS_DESCRIBE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '禁用状态描述',
  `DEVELOP_ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '开发者角色ID',
  `APP_VERSION` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本',
  `APP_SEQ` int(11) NULL DEFAULT NULL COMMENT '应用排序',
  `I18N_KEYS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '多语言引用关系',
  PRIMARY KEY (`APP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APPLICATION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APPLICATION_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APPLICATION_RECORD`;
CREATE TABLE `SYS_APPLICATION_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT '记录主键',
  `RECORD_TYPE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录类型，0：导入，1：导出',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用id',
  `APP_MODE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用类型，0：零代码，1：低代码',
  `RECORD_STATUS` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录状态，1：进行中 2：成功 3：失败',
  `SHOW_MSG` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '展示信息',
  `RECORD_FILE_ID` bigint(20) NULL DEFAULT NULL COMMENT '导入或导出附件id',
  `RECORD_FILE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入或导出附件名称',
  `RECORD_FILE_PASSWORD` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '加密后的密码',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '导出记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APPLICATION_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APPLICATION_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APPLICATION_VERSION`;
CREATE TABLE `SYS_APPLICATION_VERSION`  (
  `APP_VERSION_ID` bigint(20) NOT NULL COMMENT '应用版本id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `VERSION_NUMBER` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本号',
  `PACKAGE_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用包存储路径',
  `CURRENT_FLAG` tinyint NULL DEFAULT NULL COMMENT '是否是当前版本',
  `UPGRADE_MAPPING` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '升级映射关系',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`APP_VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用版本' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_APPLICATION_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_CLIENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_CLIENT`;
CREATE TABLE `SYS_APP_CLIENT`  (
  `APP_CLIENT_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID',
  `CLIENT_MODEL_ID` bigint(20) NOT NULL COMMENT '客户端ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`APP_CLIENT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用操作记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_CLIENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_COMMON
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_COMMON`;
CREATE TABLE `SYS_APP_COMMON`  (
  `COMMON_ID` bigint(20) NOT NULL COMMENT '常用应用id',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用id',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `PLATFORM` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '平台\r\n1、web 2、移动',
  `SEQ` int(11) NOT NULL COMMENT '显示顺序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`COMMON_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '常用应用表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_COMMON
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_DEVELOP_TEAM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_DEVELOP_TEAM`;
CREATE TABLE `SYS_APP_DEVELOP_TEAM`  (
  `TEAM_ID` bigint(20) NOT NULL COMMENT '主键',
  `TEAM_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '团队名称',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`TEAM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用开发团队表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_DEVELOP_TEAM
-- ----------------------------
INSERT INTO `SYS_APP_DEVELOP_TEAM` VALUES (1, '统一权限平台开发团队', 1, '2023-06-01 17:41:02', '2023-06-01 17:41:02', 1450756958461300737, 1450756958461300737, '0');

-- ----------------------------
-- Table structure for SYS_APP_DEVELOP_TEAM_MEMBER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_DEVELOP_TEAM_MEMBER`;
CREATE TABLE `SYS_APP_DEVELOP_TEAM_MEMBER`  (
  `TEAM_MEMBER_ID` bigint(20) NOT NULL COMMENT '主键',
  `TEAM_ID` bigint(20) NULL DEFAULT NULL COMMENT '团队id',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  `MEMBER_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0',
  PRIMARY KEY (`TEAM_MEMBER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '开发团队成员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_DEVELOP_TEAM_MEMBER
-- ----------------------------
INSERT INTO `SYS_APP_DEVELOP_TEAM_MEMBER` VALUES (1, 1, 1450756958461300737, '2023-06-01 17:41:02', '2023-06-01 17:41:02', 1450756958461300737, 1450756958461300737, '0', '1');

-- ----------------------------
-- Table structure for SYS_APP_EXPORT_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_EXPORT_RECORD`;
CREATE TABLE `SYS_APP_EXPORT_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT '记录主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `EXPORT_USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '导出人id',
  `EXPORT_TIME` datetime NULL DEFAULT NULL COMMENT '导出时间',
  `PASSWORD` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '加密后的密码',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `EXPORT_FILE_ID` bigint(20) NULL DEFAULT NULL COMMENT '导出附件id',
  `TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '类型',
  `NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  PRIMARY KEY (`RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '导出记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_EXPORT_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_GROUP`;
CREATE TABLE `SYS_APP_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '分组ID',
  `GROUP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '分组名称',
  `SEQ` int(11) NOT NULL COMMENT '显示顺序',
  `GROUP_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组类型\r\n1:默认分组\r\n2:普通分组',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `I18N_KEYS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '多语言引用关系',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用分组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_GROUP
-- ----------------------------
INSERT INTO `SYS_APP_GROUP` VALUES (1, '默认分组', 0, '1', 1450756958461300737, '2017-02-10 11:57:33', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_APP_LINK_INNER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_LINK_INNER`;
CREATE TABLE `SYS_APP_LINK_INNER`  (
  `LINK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `INNER_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '应用内链接参数',
  `INNER_SHORT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用内短链接',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`LINK_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用访问链接' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_LINK_INNER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_MENU_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_MENU_RESOURCE`;
CREATE TABLE `SYS_APP_MENU_RESOURCE`  (
  `APP_NAME` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `PAGE_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用下的页面Id，用于应用页面菜单和资源的自动绑定',
  `RELATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '关联Id;菜单Id或资源Id',
  `RELATION_REF_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能Id;当应用关联菜单时有值;用于自动关联功能和资源',
  `RELATION_TYPE` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1=应用关联的菜单；2=应用关联的资源',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用与菜单及资源的关联关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_MENU_RESOURCE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_OAUTH_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_OAUTH_CONFIG`;
CREATE TABLE `SYS_APP_OAUTH_CONFIG`  (
  `APP_AUTH_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `APP_CODE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证ID',
  `APP_SECRET` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证密钥',
  `CLIENT_ID` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `GRANT_TYPE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仪表盘删除标识',
  PRIMARY KEY (`APP_AUTH_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用认证信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_APP_OAUTH_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_OPERATION_LOG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_OPERATION_LOG`;
CREATE TABLE `SYS_APP_OPERATION_LOG`  (
  `APP_OPERATION_ID` bigint(20) NOT NULL COMMENT '主键Id',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `OPERATION_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作标识 1-删除，2-其他操作',
  PRIMARY KEY (`APP_OPERATION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用操作记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_OPERATION_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_RECYCLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_RECYCLE`;
CREATE TABLE `SYS_APP_RECYCLE`  (
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID 主键字段',
  `APP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用名称',
  `APP_GROUP_ID` bigint(20) NOT NULL COMMENT '应用分组ID',
  `APP_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用编码',
  `APP_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用类型\r\n1：零代码\r\n2：低代码\r\n3：自建应用',
  `APP_ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用图标类型\r\n1：内置图标\r\n2：用户自定义',
  `APP_ICON` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用图标\r\n内置图标：图标标识\r\n用户自定义：图片ID',
  `APP_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内置图标颜色',
  `SECRET_KEY` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用密钥，统一待办、统一认证需要',
  `APP_DESCRIBE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用描述',
  `WEB_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Web访问地址',
  `MOBILE_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机访问地址',
  `APP_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用状态\r\n0：禁用\r\n1：启用\r\n默认值：1',
  `RELEASE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用发布状态\r\n1：已上架\r\n0：未上架\r\n默认值：1',
  `DELETE_USER` bigint(20) NOT NULL COMMENT '删除人',
  `CREATE_USER` bigint(20) NOT NULL COMMENT '应用创建人',
  `DELETE_TIME` datetime NOT NULL COMMENT '删除时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEVELOP_ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '开发者角色ID',
  `APP_VERSION` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用版本',
  `STATUS_DESCRIBE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '禁用状态描述',
  `APP_SEQ` int(11) NULL DEFAULT NULL COMMENT '应用排序',
  PRIMARY KEY (`APP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用回收站表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_RECYCLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_TEMPLATE`;
CREATE TABLE `SYS_APP_TEMPLATE`  (
  `TEMPLATE_ID` bigint(20) NOT NULL COMMENT '模板ID 主键字段',
  `TEMPLATE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板名称',
  `TEMPLATE_PROFESSION_ID` bigint(20) NOT NULL COMMENT '模板行业ID',
  `TEMPLATE_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板编码',
  `TEMPLATE_DESCRIBE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板描述',
  `TEMPLATE_ICON` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '应用图标',
  `TEMPLATE_ICON_TYPE` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICON类型',
  `TEMPLATE_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'ICON颜色',
  `WEB_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'Web访问地址',
  `MOBILE_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机访问地址',
  `TEMPLATE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板状态\r\n0：禁用\r\n1：启用\r\n默认值：1',
  `RELEASE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板发布状态\r\n1：已上架\r\n0：未上架\r\n默认值：0',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATOR_NAME` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人名称',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `STATUS_DESCRIBE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '禁用状态描述',
  `DEVELOP_ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '开发者角色ID',
  `TEMPLATE_VERSION` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模板版本',
  `USE_TYPE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用方式',
  `TEMPLATE_SEQ` int(11) NULL DEFAULT NULL COMMENT '模板排序',
  `INSTALLED_NUMBS` int(11) NULL DEFAULT NULL COMMENT '模板安装量',
  `VIEW_NUMBS` int(11) NULL DEFAULT NULL COMMENT '模板浏览量',
  PRIMARY KEY (`TEMPLATE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用模板表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_APP_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_TEMPLATE_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_TEMPLATE_ATTACHMENT`;
CREATE TABLE `SYS_APP_TEMPLATE_ATTACHMENT`  (
  `ATTACHMENT_ID` bigint(20) NOT NULL COMMENT '附件id',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用id',
  `FILE_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '文件路径',
  `FILE_TYPE` int(11) NOT NULL COMMENT '1：应用文件；2：缩略图；3：pc端图片；4：移动端图片',
  `FILE_SEQ` int(11) NULL DEFAULT NULL COMMENT 'pc端、移动端的图片显示顺序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`ATTACHMENT_ID`) USING BTREE,
  INDEX `SYS_APP_TEMPLATE_ATTACHMENT_APP_ID_index`(`APP_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用模板附件记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_APP_TEMPLATE_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_VISIT_AUTHORITY
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_VISIT_AUTHORITY`;
CREATE TABLE `SYS_APP_VISIT_AUTHORITY`  (
  `APP_ROLE_ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色id',
  `CREATE_TIME` datetime NULL DEFAULT NULL,
  `LAST_TIME` datetime NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL,
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL,
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `AUTHORIZATION_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用授权类型。1-组织，2-角色，3-岗位，4-用户'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用访问授权表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_VISIT_AUTHORITY
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_VISIT_DATA_LOGIC
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_VISIT_DATA_LOGIC`;
CREATE TABLE `SYS_APP_VISIT_DATA_LOGIC`  (
  `ROLE_DATA_LOGIC_ID` bigint(20) NOT NULL COMMENT '主键',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `COMBINE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '筛选条件组合关系：0 任一、 1 所有',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`ROLE_DATA_LOGIC_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表单数据逻辑权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_VISIT_DATA_LOGIC
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_VISIT_ROLE_BUTTON
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_VISIT_ROLE_BUTTON`;
CREATE TABLE `SYS_APP_VISIT_ROLE_BUTTON`  (
  `ROLE_BUTTON_ID` bigint(20) NOT NULL COMMENT '主键',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `BUTTON_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮编码',
  `BUTTON_NAME` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮名',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '需要逻辑删除的业务添加该字段',
  PRIMARY KEY (`ROLE_BUTTON_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表单按钮权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_VISIT_ROLE_BUTTON
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_VISIT_ROLE_FIELD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_VISIT_ROLE_FIELD`;
CREATE TABLE `SYS_APP_VISIT_ROLE_FIELD`  (
  `ROLE_FIELD_ID` bigint(20) NOT NULL COMMENT '主键',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `FIELD_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单内字段ID',
  `FIELD_NAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段名',
  `CAN_READ` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可读 :0 否 1 是',
  `CAN_WRITE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可写:0 否 1 是',
  `CREATE_TIME` datetime NULL DEFAULT NULL,
  `LAST_TIME` datetime NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL,
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL,
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PARENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级字段id',
  PRIMARY KEY (`ROLE_FIELD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表单字段权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_VISIT_ROLE_FIELD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_APP_WATERMARK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_APP_WATERMARK`;
CREATE TABLE `SYS_APP_WATERMARK`  (
  `WATERMARK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `APP_WATERMARK` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用水印',
  `PRINT_WATERMARK` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打印水印',
  `DATA_WATERMARK` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据水印',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`WATERMARK_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用水印配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_APP_WATERMARK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AUTH_CLIENT_MODEL`;
CREATE TABLE `SYS_AUTH_CLIENT_MODEL`  (
  `CLIENT_MODEL_ID` bigint(20) NOT NULL COMMENT '主键',
  `CLIENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端id',
  `CLIENT_SECRET` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端密码，需要加密',
  `CONTRACT_SCOPE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用签约的所有权限, 多个用逗号隔开',
  `ALLOW_URL` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用允许授权的所有URL, 多个用逗号隔开',
  `AUTHORIZED_GRANT_TYPE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证类型',
  `WEB_SERVER_REDIRECT_URI` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '回调地址',
  `AUTHORITIES` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限',
  `ACCESS_TOKEN_VALID_TIME` int(11) NULL DEFAULT NULL COMMENT 'token有效时间',
  `REFRESH_TOKEN_VALID_TIME` int(11) NULL DEFAULT NULL COMMENT '刷新token有效时间',
  `AUTO_APPROVE` tinyint(1) NULL DEFAULT NULL COMMENT '是否自动放行',
  `ADDITIONAL_INFORMATION` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展信息',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `PUBLIC_KEY` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公钥',
  `PRIVATE_KEY` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '私钥对',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`CLIENT_MODEL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '认证服务客户端信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_MODEL
-- ----------------------------
INSERT INTO `SYS_AUTH_CLIENT_MODEL` VALUES (742382395743019009, 'hussar-base', 'hussar-base', 'server', '*', 'password', '', '', 1800, 86400, -1, '', -1, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCfREYwkGHyZhEGUxn6G1DIykoB1wJE5njW2cLmb6TLDdJlCI5Mq0afeDmY/fZz4jIveJZqcL7IGVLeDaZOd27/9PBcTrmO2I3tIRlFpWlCPV8bGPbI2na92zmdSjqqrNpkS707nn2n6pzhgOO10bGg9yywK+qm/xQA02qv5rdvUwIDAQAB', 'MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAJ9ERjCQYfJmEQZTGfobUMjKSgHXAkTmeNbZwuZvpMsN0mUIjkyrRp94OZj99nPiMi94lmpwvsgZUt4Npk53bv/08FxOuY7Yje0hGUWlaUI9XxsY9sjadr3bOZ1KOqqs2mRLvTuefafqnOGA47XRsaD3LLAr6qb/FADTaq/mt29TAgMBAAECgYEAnz4NjAsg09O3nAJFC+x55nlUa+iFzUw/cFrE49CnDZuhTQGz/faWo2X6+PyciZuVoB9LDdvy9XFUiM9PBE+oe86zywQOvccLnWmsaCliy/Hy/XovIIfjZEI/h5Ve9FJtpTiiuYHGZYw94wW23qi7/1mSt6eAC76+0XOLvKr8IYkCQQDj7bB71IMNEuBXJGiR9125XfqAEqDYjws/Mxc3dE6B30DG4KhEF4xWnI9UPtrZitMGb3NDdbyMchBCu9hqbCBnAkEAsuHC8ttpnv4X8A9iLFTPKYICs6p+Q+wYnfjNwmT/DVMg9n2f31bguEspip1EVEBiwWaBoae5/SM+6hLLySk2NQJBAJUtAt3495C98wB1vs8R9FCXFpVuG8HA1V6WxLIxuBQ+FvpTHS37r4kcTJ6ZyMiqmHTUyr6zNyVAni3fHcSBYi8CQFt+sAkqAwcorjPCmpNUObXgYuNk1DqHmzvJ0+yXXgGBwH1zWf+RX1XEVBYrRJTXbevAM5Psx2vbyEVPod5dbvUCQQCAavG4AX43+MCDDps4+p4+zlvo9dus+GX6D79ZtDxda/RsHIBCOHyFkalMVTM8EWq1CCzu+aL6lJ4VDry3QGDw', '2021-11-25 07:29:59', '2021-12-20 15:39:17', -1, -1, '0');
INSERT INTO `SYS_AUTH_CLIENT_MODEL` VALUES (742436133195227136, 'unified_server', 'unified_server', 'permission_list', '*', 'client_credentials', '', '', 1800, 86400, NULL, '', NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCS0JJzyV2b1tn35AmIsBoUuVUjecq9/BFjODGe823ToHcAIZFvxydWGAd8hzU1yJUGT1DZGgAzvDRtNNMDUnYkCbATDvz7QpPxsheAcZkCYeSXefpT/f15eQZdVgcTcrRDR7KEqUJDLzYwupE5YsSlDsPTubh7TXuc+eAX7l4xiQIDAQAB', 'MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJLQknPJXZvW2ffkCYiwGhS5VSN5yr38EWM4MZ7zbdOgdwAhkW/HJ1YYB3yHNTXIlQZPUNkaADO8NG000wNSdiQJsBMO/PtCk/GyF4BxmQJh5Jd5+lP9/Xl5Bl1WBxNytENHsoSpQkMvNjC6kTlixKUOw9O5uHtNe5z54BfuXjGJAgMBAAECgYAoZa22oHTaea72T8/zxYkXpLtxjISl7CMYqxC0TQUuUxwLdDEhkaoYPXpp4IZaqzueRdrYMhhWI/ZFCmD5rAoHi9ZGljvSLhK1Tw7s15qexZfSgTD1oK8j9aHqC2Sq/iaKNocXYTZzzoHXlFbOSlVMKaB6Zj4p27LNQ/KIvp22gQJBAMIQHP0Ao0cs3o/UTdCl/Su3O1+DtIXsXGgdb5B7sKR7FTilq8DT4PeCvwo/HFiWjUzqiDri+vvSMOq2NtG0CfECQQDBrAzj+FWggYfxhgyPqnyVnBpYrb/Tw2w90HHnzdGUv+WLLWooumdtm+CO9+qDdsjT04fnevh940Wpfke0q8kZAkEAlemiqyOJ/pq/13YXIr6Hg/TJTfDNTMOZYuiSXZffjkBy1U7ODmjfGfULpVu5hwnOYAOxd2QOpOfr1/UpBfhB0QJAHqvrwrLShL/e0q5DEQGUB3GYbpDdv2DEpKl9UJO07FTTuo3vsRGMTbyQ/LNgjX9jYMCwVkWQUweKQcSBAKjwCQJANrnlQfT/iQcj/ABPXRUamTqHD03A1qGNYLGb2GqbwO8dc8PBZ9WPqqDCSimtvM2eTo2rbJnfulV3OULK9CSTyA==', NULL, NULL, -1, -1, '0');
INSERT INTO `SYS_AUTH_CLIENT_MODEL` VALUES (812022820434616320, 'message_server', 'message_server', 'permission_list', '*', 'client_credentials', NULL, NULL, 1800, 86400, NULL, NULL, NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHLpAFClRrA3Pk4nkRzDsfUjbnQo3WtQdfg9sf/6fZlDZtWaEfczW/nJU3rkHs8eT6gXaFFSvxoUKVJFhMKvXgTiWVOcCR96UdmeOc8OnUB7z/kEMXdarfZ5X9zB4xFih6FR5lG2FwOZyNqRc9DRBIgjRgxOddnLidlAjJ8d711wIDAQAB', 'MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMcukAUKVGsDc+TieRHMOx9SNudCjda1B1+D2x//p9mUNm1ZoR9zNb+clTeuQezx5PqBdoUVK/GhQpUkWEwq9eBOJZU5wJH3pR2Z45zw6dQHvP+QQxd1qt9nlf3MHjEWKHoVHmUbYXA5nI2pFz0NEEiCNGDE512cuJ2UCMnx3vXXAgMBAAECgYEAvCx+PXTL2inx5KwdCzZyKJ4IZqUW0WBHbfJpIyrpjYIbhWVm9gpnHfY1dtw3Rj4lQJDswsAEuwvJlpM2pAb2L91zKkggdE2g/zOvXJJ97Vl6GLy+NU1QOgP1sjkV5mqVpCQ2sjz1uxrnFGcF6u6f9KK7s1na+OA64anqTY7WRWkCQQD5oyXT0G8Sb35554OvVYLUJifaHhjVUD6v40+R+dPvd9FCCDtIigHa39Py04IgHsg/uQZosCcbePTXo7rQ/pzdAkEAzEIzFYgWw4f04lNlzXAMWlq19eoKuOyimA1akyMHycmI82REGM8ev+kBvw26HwX4iQj1NfKbX8u6CD7479kIQwJBAMMzjaq5O4Eg6bcND22U4f5d75+hFS4H11zV1CyDO/PurxSBN0obkCPEDgm81e2j5FXfqmFGDO5wgJP2FWjDD4kCQE+U405aTXQ1PmYH1DwskcOKYCbF3xOZrufLHCUDmv81tFQQFrAL0pE2+WU0tfVsYB8UDGXOdlbmiz63OkpIpv0CQAs8UXamDvy4GHkq6knuD5dZT1B3ieBnTp+4Eo4qpTe8hqdBaJnINfMOqAyshH/dTN0FmJ9Ogd4VxjlTbrYRskg=', NULL, NULL, 1450756958461300737, 1450756958461300737, '0');

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_OPENID
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AUTH_CLIENT_OPENID`;
CREATE TABLE `SYS_AUTH_CLIENT_OPENID`  (
  `CLIENT_OPEN_ID` bigint(20) NOT NULL COMMENT '主键',
  `CLIENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端id',
  `LOGIN_ID` bigint(20) NULL DEFAULT NULL COMMENT '登录人id',
  `OPEN_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开放id',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`CLIENT_OPEN_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'openid 和client id loginid 对应的关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_OPENID
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_SCOPE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AUTH_CLIENT_SCOPE`;
CREATE TABLE `SYS_AUTH_CLIENT_SCOPE`  (
  `SCOPE_ID` bigint(20) NOT NULL COMMENT '客户端权限id',
  `SCOPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端权限名称',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`SCOPE_ID`) USING BTREE,
  UNIQUE INDEX `AUTH_SCOPE_PERMISSION_INDEX`(`SCOPE` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户端权限标识表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_SCOPE
-- ----------------------------
INSERT INTO `SYS_AUTH_CLIENT_SCOPE` VALUES (662981304710864897, 'unified_server', '统一待办', NULL, NULL, NULL, NULL, NULL, '0');

-- ----------------------------
-- Table structure for SYS_AUTH_SCOPE_PERMISSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AUTH_SCOPE_PERMISSION`;
CREATE TABLE `SYS_AUTH_SCOPE_PERMISSION`  (
  `SCOPE_PERMISSION_ID` bigint(20) NOT NULL COMMENT '主键',
  `SCOPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '客户端权限id',
  `PERMISSION_ID` bigint(20) NULL DEFAULT NULL COMMENT '权限id',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`SCOPE_PERMISSION_ID`) USING BTREE,
  INDEX `SYS_AUTH_CLIENT_SCOPE_PERMISSION_INDEX`(`SCOPE_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户端权限标识关联权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AUTH_SCOPE_PERMISSION
-- ----------------------------
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864902, 662981304710864897, 690528754686238720, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864903, 662981304710864897, 690528390436102144, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864904, 662981304710864897, 690528302003396608, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864905, 662981304710864897, 690525973787189248, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864906, 662981304710864897, 690525700498923520, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864907, 662981304710864897, 690525592055193600, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864908, 662981304710864897, 690525462312787968, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864909, 662981304710864897, 690525353298632704, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864910, 662981304710864897, 690525197148889088, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864911, 662981304710864897, 690525099648098304, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864912, 662981304710864897, 690525019226513408, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864913, 662981304710864897, 690524899974062080, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864915, 662981304710864897, 690522779594006528, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864916, 662981304710864897, 690522261102534656, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864917, 662981304710864897, 690641814235127808, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864918, 662981304710864897, 690641909710069760, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO `SYS_AUTH_SCOPE_PERMISSION` VALUES (662981304710864919, 662981304710864897, 697104639711256576, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_AUTH_SOCIAL_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_AUTH_SOCIAL_DETAILS`;
CREATE TABLE `SYS_AUTH_SOCIAL_DETAILS`  (
  `SOCIAL_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主鍵',
  `TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '社交登录类型',
  `REMARK` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请社交三方appId',
  `APP_SECRET` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请社交三方app密码',
  `REDIRECT_URL` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三方回调url',
  `TENANT_ID` int(11) NOT NULL DEFAULT 0 COMMENT '所属租户',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`SOCIAL_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统社交登录账号表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_AUTH_SOCIAL_DETAILS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_BASE_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_BASE_CONFIG`;
CREATE TABLE `SYS_BASE_CONFIG`  (
  `CONFIG_ID` bigint(20) NOT NULL COMMENT '主键',
  `NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `CONFIG_KEY` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '键',
  `CONFIG_VALUE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `EXAMPLE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '示例',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '上级id',
  `CONFIG_RULE` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '校验规则',
  PRIMARY KEY (`CONFIG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '平台基础配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_BASE_CONFIG
-- ----------------------------
INSERT INTO `SYS_BASE_CONFIG` VALUES (111, '账户配置', 'account_config', '', NULL, NULL, NULL, NULL, '账户配置项，在账户未登录天数超过配置时，账户状态会变为休眠，若没有再次被激活，则会被自动注销，账户状态变化和自动注销前都会给账户配置的邮箱发送提示短信', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (222, '登录失败配置', 'login_fail_config', NULL, NULL, NULL, NULL, NULL, '密码输入错误相关配置，在连续失败时间内达到了配置连续失败次数时，会对账号按锁定时间进行锁定，若配置了失败消息接收邮箱，会发送邮件提醒', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (333, '登录时间配置', 'login_time_config', NULL, NULL, NULL, NULL, NULL, '登录时间配置，开启后只有在允许的时间段内登录系统', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (444, '登录ip配置', 'login_ip_config', NULL, NULL, NULL, NULL, NULL, '登录ip配置，配置允许或禁止某些ip地址登录系统，限制外的ip地址登录时会发送邮件提醒', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (666, '密码配置', 'password_config', '', NULL, NULL, NULL, NULL, '用户密码配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (777, '创建用户配置', 'user_create_config', '', NULL, NULL, NULL, NULL, '创建用户配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (888, '页面配置', 'theme_config', '', NULL, NULL, NULL, NULL, '页面参数配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (999, '审核配置', 'audit_config', '', NULL, NULL, NULL, NULL, '审核配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (1111, '未登录天数', 'nologin_day', '-1', NULL, NULL, NULL, NULL, '单位天。超过配置天数账号会休眠，-1为不休眠', 111, 'checkNumber');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1112, '账户状态', 'user_account_status', '3', NULL, NULL, NULL, NULL, '单选框。休眠', 111, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1113, '休眠提醒邮件标题', 'status_change_email_title', '账户状态变更提醒', NULL, NULL, NULL, NULL, '自动休眠提醒邮件标题', 111, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1114, '休眠提醒邮件内容', 'status_change_email', '您的账号:#{user_account},由于超过#{nologin_day}天未登录，账户已被#{user_account_status}。</br>如要继续使用，请联系管理员', NULL, NULL, NULL, NULL, '自动休眠提醒邮件模版', 111, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1115, '休眠多久自动注销', 'logout_day', '365', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：365', 111, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1116, '注销前多久发送邮件', 'email_before_logout_day', '5', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：5', 111, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1117, '注销提醒邮件标题', 'logout_warn_email_title', '账户注销提醒', NULL, NULL, NULL, NULL, '自动注销提醒邮件标题', 111, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1118, '注销提醒邮件内容', 'logout_warn_email', '您的账号:#{user_account},将在#{email_before_logout_day}天后注销。</br>如要继续使用，请尽快联系管理员', NULL, NULL, NULL, NULL, '自动注销提醒邮件模板', 111, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2221, '连续失败时间', 'fail_time', '1', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例：3', 222, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2222, '连续失败次数', 'fail_number', '5', NULL, NULL, NULL, NULL, '正整数。示例 ：3', 222, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2223, '连续失败锁定时间', 'fail_lock_time', '2', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例 ：60', 222, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2224, '失败消息接收邮箱', 'fail_email_box', '', NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', 222, 'checkEmails');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2225, '失败邮件标题', 'fail_email_title', '账号连续登录失败提醒', NULL, NULL, NULL, NULL, '账户锁定邮件标题', 222, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2226, '失败邮件内容', 'fail_email', '用户账号:#{user_account}密码连续输入错误#{fail_number}次，账号已被锁定', NULL, NULL, NULL, NULL, '账户锁定邮件模板', 222, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (3331, '登录时间限制', 'login_time_limit', '1', NULL, NULL, NULL, NULL, '登录限制开关', 333, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (3332, '允许登录开始时间', 'login_start_time', '08:00:00', NULL, NULL, NULL, NULL, '允许登录开始时间', 333, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (3333, '允许登录结束时间', 'login_end_time', '20:00:00', NULL, NULL, NULL, NULL, '允许登录结束时间', 333, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4441, '登录ip限制', 'login_ip_limit', '1', NULL, NULL, NULL, NULL, 'ip限制开关', 444, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4442, '允许登录ip', 'allow_login_ip', '', NULL, NULL, NULL, NULL, '允许访问系统的ip,ip之间英文逗号分隔，不填写不生效', 444, 'checkIPs');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4443, '禁止登录ip', 'forbid_login_ip', '', NULL, NULL, NULL, NULL, '禁止访问系统的ip,ip之间英文逗号分隔，不填写不生效', 444, 'checkIPs');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4444, 'ip预警接收邮箱', 'ip_warn_email_box', '', NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', 444, 'checkEmails');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4445, 'ip预警邮件标题', 'ip_warn_email_title', 'ip登录预警', NULL, NULL, NULL, NULL, 'ip预警邮件标题', 444, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (4446, 'ip预警邮件模板', 'ip_warn_email', '存在未经允许的ip登录系统，ip地址：#{ip_address}</br>用户名称：#{user_name}</br>用户账号：#{user_account}', NULL, NULL, NULL, NULL, 'ip预警邮件模板', 444, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (5551, '会话限制', 'session_limit', '0', NULL, NULL, NULL, NULL, '默认开启', 555, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (5552, '最大会话数', 'max_session_num', '1000000', NULL, NULL, NULL, NULL, '系统最大会话数，同时开启session_limit和kickout_after时才生效，配置为-1为不限制会话数量', 555, 'checkNumber');
INSERT INTO `SYS_BASE_CONFIG` VALUES (5553, '会话超出限制时，踢出后者', 'kickout_after', '0', NULL, NULL, NULL, NULL, '开启时剔除后者即新登录用户不能登录，关闭时剔除最先登录的', 555, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6661, '系统缺省密码规则', 'pwd_rule', '8,16,3', NULL, NULL, NULL, NULL, '系统缺省密码规则（\"最小长度，最大长度，密码强度\"）,缺省规则是( 8,16,3 )最小不能小于8位，最大不能大于16位，强度为3\r\n密码强度规则分1-3级，各级的含义如下：\r\n级别1：如果密码只由数字、小写字母、大写字母或其它特殊符号当中的一种组成,则认为这是一个弱密码.\r\n级别2：如果密码由数字、小写字母、大写字母或其它特殊符号当中的两种组成,则认为这是一个中度安全的密码\r\n级别3：如果密码由数字、小写字母、大写字母或其它特殊符号当中的三种以上组成,则认为这是一个比较安全的密码.', 666, 'checkStrengthRule');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6663, '自定义密码复杂度', 'pwd_rule_custom', '1', NULL, NULL, NULL, NULL, '开启自定义时,pwd_complexity_regular 自定义正则表达式，unmatched_hint 自定义返回消息；不开启时使用平台自带规则', 666, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6664, '密码复杂度正则', 'pwd_complexity_regular', '/^[\\S]{6,12}$/', NULL, NULL, NULL, NULL, '正则校验密码规则', 666, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6665, '自定义返回消息', 'unmatched_hint', '新密码不符合密码规则！', NULL, NULL, NULL, NULL, '修改密码时的自定义返回消息，开启自定义密码复杂度时生效', 666, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6666, '强制修改密码', 'force_change_pwd', '1', NULL, NULL, NULL, NULL, '是否在第一次登录或一段时间后强制用户修改密码', 666, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6667, '密码生命周期', 'password_hist', '90', NULL, NULL, NULL, NULL, '正整数，多少天后强制修改密码  单位（天）', 666, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (6668, '密码重复次数', 'pwd_repeat_time', '2', NULL, NULL, NULL, NULL, '正整数，密码不能和前几次相同', 666, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (7771, '创建用户时发送邮件', 'create_user_send_email', '1', NULL, NULL, NULL, NULL, '创建用户时发送邮件开关', 777, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (7772, '创建用户时使用默认密码', 'create_user_use_default_pass', '0', NULL, NULL, NULL, NULL, '创建用户是否使用默认密码，开启时使用默认密码，不开启时使用密码规则生成的密码。为防止生成的密码无法得知，当create_user_send_email关闭时也使用默认密码', 777, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (7773, '用户默认密码', 'default_password', '123456', NULL, NULL, NULL, NULL, '用户默认密码，可输入数字、大写字母、小写字母、英文特殊字符（`~!@#$%^&*()_|+<>?:\"{},./;\'[]-）', 777, 'checkdefultpw');
INSERT INTO `SYS_BASE_CONFIG` VALUES (7775, '操作人员同时操作用户', 'operate_staff_with_user', '1', NULL, NULL, NULL, NULL, '开启时操作人员同时操作用户（新增、修改、删除、转移）', 777, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (8883, '标签页切换刷新', 'tab_switchover', '0', NULL, NULL, NULL, NULL, '标签页切换刷新开关，重新登录后生效', 888, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (9991, '关键操作审核', 'critical_operations_audit', '1', NULL, NULL, NULL, NULL, '关键操作是否需要审核，总开关，只有开启后，下面几个开关才分别生效', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (9992, '组织机构审核', 'organ_audit', '0', NULL, NULL, NULL, NULL, '组织机构操作审核开关', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (9993, '用户审核', 'user_audit', '0', NULL, NULL, NULL, NULL, '用户操作审核开关', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (9994, '用户角色审核', 'role_audit', '0', NULL, NULL, NULL, NULL, '用户角色操作审核开关', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (9996, '登录页背景图', 'login_view_background', '', NULL, NULL, NULL, NULL, '登录页背景图', 202020, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (9997, '登录框背景图', 'login_view_innerBackground', '', NULL, NULL, NULL, NULL, '登录框背景图', 202020, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (9998, '浏览器页签图标的配置项', 'relation_icon', '', NULL, NULL, NULL, NULL, '浏览器页签图标的配置项', 212121, '');
INSERT INTO `SYS_BASE_CONFIG` VALUES (99910, '岗位审核', 'post_audit', '0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', '岗位操作审核开关', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (99911, '人员审核', 'staff_audit', '0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', '人员操作审核开关', 999, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (101010, '异常报警配置', 'exception_config', '', NULL, NULL, NULL, NULL, '异常报警配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (121212, '登录配置', 'login_config', '', NULL, NULL, NULL, NULL, '登录配置', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (202020, '登录页可视化配置', 'login_view_config', NULL, NULL, NULL, NULL, NULL, '门户登录页可视化配置', 2, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (212121, '首页可视化配置', 'home_page', NULL, NULL, NULL, NULL, NULL, '首页可视化配置', 2, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (1010101, '审计日志报警条数', 'securitylog_count_alert', '100000', NULL, NULL, NULL, NULL, '超过此条数时报警，只能输入正整数，默认不发送，配置后才发送', 101010, 'checkPositiveNum');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1010102, '异常报警', 'exception_alert', '1', NULL, NULL, NULL, NULL, '异常报警开关，权限异常时会发送告警邮件', 101010, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1010103, '异常报警接收邮件邮箱', 'exception_alert_email', '', NULL, NULL, NULL, NULL, '多个邮箱使用,隔开', 101010, 'checkEmails');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1212121, '区分登录账号大小写', 'login_upper_open', '0', NULL, NULL, NULL, NULL, '区分登录账号大小写开关', 121212, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1212122, '登录验证码', 'kaptcha_open', '1', NULL, NULL, NULL, NULL, 'console端登录验证码开关。如需配置门户验证码开关，请前往门户配置中心-登录页配置-配置项。', 121212, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1212123, '登录时动态密码验证', 'totp_open', '1', NULL, NULL, NULL, NULL, '登录动态密码验证开关', 121212, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1212124, '动态密码验证允许时间偏差', 'totp_offset_min', '2', NULL, NULL, NULL, NULL, '单位 min 分钟， 默认0，无偏差验证，必须保证手机端和服务器时间误差在30s之内才能准确验证', 121212, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (1212125, '令牌有效时间', 'access_token_valid_time', '1800', NULL, NULL, 1450756958461300737, '2023-07-20 19:30:43', '令牌有效时间，单位秒。', 121212, 'checkTokenValidTime');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020201, '登录布局', 'login_view_type', '1', NULL, NULL, NULL, NULL, '登录页面布局', 202020, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020202, '系统名称', 'login_view_sysname', '统一门户', NULL, NULL, NULL, NULL, '登录页面显示的系统名称', 202020, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020203, '系统LOGO', 'login_view_logo', '', NULL, NULL, NULL, NULL, '登录页面显示的系统logo', 202020, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020204, '版权所有', 'login_view_copyright', '', NULL, NULL, NULL, NULL, '登录页面显示的版权所有信息', 202020, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020205, '验证码', 'login_view_kaptcha', '1', NULL, NULL, NULL, NULL, '登录时是否进行验证码验证', 202020, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2020206, '记住密码', 'login_rememberpwd', '1', NULL, NULL, NULL, NULL, '登录时是否记住密码', 202020, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2121211, '首页布局类型', 'home_page_type', '0', NULL, NULL, NULL, NULL, '首页布局类型', 212121, 'checkRadio');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2121212, '首页系统名称', 'home_page_sysname', '统一门户', NULL, NULL, NULL, NULL, '首页显示系统名称', 212121, 'checkNotEmpty');
INSERT INTO `SYS_BASE_CONFIG` VALUES (2121213, '首页系统LOGO', 'home_page_logo', '', NULL, NULL, NULL, NULL, '首页显示系统LOGO', 212121, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (202202170, '主题权限配置', 'theme_config_edit', '1', NULL, NULL, NULL, NULL, '主题权限配置，是否启用主题配置编辑功能', 1, NULL);
INSERT INTO `SYS_BASE_CONFIG` VALUES (202202171, '主题权限配置', 'enable_theme_config_edit', '1', NULL, NULL, NULL, NULL, '是否启用主题配置编辑功能', 202202170, 'checkRadio');

-- ----------------------------
-- Table structure for SYS_BATCH_DOWNLOAD_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_BATCH_DOWNLOAD_TASK`;
CREATE TABLE `SYS_BATCH_DOWNLOAD_TASK`  (
  `TASK_ID` bigint(20) NOT NULL COMMENT '任务id',
  `TASK_STATUS` int(11) NULL DEFAULT NULL COMMENT '任务状态 0.开始下载 1.下载成功 -1.失败',
  `FILE_ID` bigint(20) NULL DEFAULT NULL COMMENT '文件id',
  `CREATE_TIME` datetime NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL,
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL,
  `LAST_TIME` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`TASK_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_BATCH_DOWNLOAD_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CALENDAR
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CALENDAR`;
CREATE TABLE `SYS_CALENDAR`  (
  `CALENDAR_ID` bigint(20) NOT NULL COMMENT '主键',
  `TITLE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件标题',
  `START_TIME` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `END_TIME` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `CLASS_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '事件的样式',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `REMARK` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`CALENDAR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作日历表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CALENDAR
-- ----------------------------
INSERT INTO `SYS_CALENDAR` VALUES (1450383908880433153, '班', '2018-05-01 00:00:00', NULL, 'work', NULL, NULL, '2018-05-22 00:00:00', NULL, NULL, NULL);
INSERT INTO `SYS_CALENDAR` VALUES (1450384023288541185, '休', '2018-05-04 00:00:00', NULL, 'holiday', NULL, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_CLIENT_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CLIENT_MODEL`;
CREATE TABLE `SYS_CLIENT_MODEL`  (
  `CLIENT_MODEL_ID` bigint(20) NOT NULL COMMENT '主键',
  `CLIENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端id',
  `CLIENT_SECRET` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端密码，需要加密',
  `CONTRACT_SCOPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用签约的所有权限, 多个用逗号隔开',
  `ALLOW_URL` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用允许授权的所有URL, 多个用逗号隔开',
  `AUTHORIZED_GRANT_TYPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证类型',
  `WEB_SERVER_REDIRECT_URI` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '回调地址',
  `AUTHORITIES` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限',
  `ACCESS_TOKEN_VALID_TIME` int(11) NULL DEFAULT NULL COMMENT 'token有效时间',
  `REFRESH_TOKEN_VALID_TIME` int(11) NULL DEFAULT NULL COMMENT '刷新token有效时间',
  `AUTO_APPROVE` tinyint(1) NULL DEFAULT NULL COMMENT '是否自动放行',
  `ADDITIONAL_INFORMATION` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展信息',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `PUBLIC_KEY` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公钥',
  `PRIVATE_KEY` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '私钥对',
  `APPLICATION_ID` bigint(20) NOT NULL DEFAULT 1 COMMENT '应用ID',
  `CLIENT_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端状态（0：禁用，1：启用）',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人ID',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`CLIENT_MODEL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户端信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CLIENT_MODEL
-- ----------------------------
INSERT INTO `SYS_CLIENT_MODEL` VALUES (737637974124273664, 'unified_server', 'unified_server', 'permission_list', '*', 'client_credentials', '', '', 1800, 86400, NULL, '', NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCaBvKGkCJWCfbBtlAFAc55yqCcs9fUHh5RyL/5FZ2XetZCuPPJD4/WJofKNW+KSGUK2Gfvxlqe55Ynmp6kFh02E0LWOejr3QaV97Y6zWCYoVEnKIBey3qAeQwR6+5kXPdGwRJ4Gl9l0kdH5DXChTWno96LE/xHMkBLY1Ozvo506QIDAQAB', 'MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAJoG8oaQIlYJ9sG2UAUBznnKoJyz19QeHlHIv/kVnZd61kK488kPj9Ymh8o1b4pIZQrYZ+/GWp7nlieanqQWHTYTQtY56OvdBpX3tjrNYJihUScogF7LeoB5DBHr7mRc90bBEngaX2XSR0fkNcKFNaej3osT/EcyQEtjU7O+jnTpAgMBAAECgYAsBuJaHmcCKvTyqBc1Zy/K1mWUhT+jLTzDadud6lTSkNUf21gr15vovbjAzwdkAo+HSxZijlMm6tGb3nGMO5n7gi9ayjUpoD4Cb0lfBHdBYKEsWMuZsEDsc0QGsz809MF02Ib1E1twCsEDJpZqCBLBJKzaHd751cpCQN7GXLx4EQJBANXJFJVVgiaVrmySKoTAvl66YA0i8yjKdApLIGl1w7GYvKaMl0wSpVdKUFKss9crgWnUSPKyRF+27qnR7UGEH4UCQQC4cRC7fnA2RnMRBtCXCNy1NaRh+ffnCQe3Im9lAlkWv7jMswj+EXNqsqd3Kp5lRciY01ovfI0G7f7528LOLRMVAkBMCQl+F3yD1qbDzLS8pITQ0j7JTU3oiyD8bD3p5E2mw6kNH2HMV7Fgu3iX/v6zn7CWgD81unuhA0IdOiHFNIW1AkBhT34FfhsT961j8VWCKjHQBYI6ExlBMtl4PNnK0CdSwkps7ZSz/18Gj0WdsMWrJttEDlaJsUvyuQSKrPCluNBVAkB66fFNW6wd1w5ELdZuPI2ErEsrf9x7cxTMl99OYctIr1U+E/Hr/3aVuSpsPeVwuv9gFNLjNhM9F/iIP34HO1X7', 1, '1', NULL, NULL, -1, -1, '0');
INSERT INTO `SYS_CLIENT_MODEL` VALUES (812022819872579584, 'message_server', 'message_server', NULL, NULL, NULL, NULL, NULL, 1800, 0, NULL, NULL, NULL, NULL, NULL, 1, '1', NULL, NULL, 1450756958461300737, 1450756958461300737, '0');

-- ----------------------------
-- Table structure for SYS_CLIENT_PERMISSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CLIENT_PERMISSION`;
CREATE TABLE `SYS_CLIENT_PERMISSION`  (
  `CLIENT_PERMISSION_ID` bigint(20) NOT NULL COMMENT '主键',
  `SCOPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限范围',
  `CLIENT_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户端ID',
  `PERMISSION_ID` bigint(20) NOT NULL COMMENT '权限ID',
  `TENANT_ID` bigint(20) NOT NULL COMMENT '租户ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`CLIENT_PERMISSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户端关联资源表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CLIENT_PERMISSION
-- ----------------------------
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864903, 'permission_list', 'unified_server', 690528390436102144, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864904, 'permission_list', 'unified_server', 690528302003396608, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864905, 'permission_list', 'unified_server', 690525973787189248, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864906, 'permission_list', 'unified_server', 690525700498923520, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864907, 'permission_list', 'unified_server', 690525592055193600, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864908, 'permission_list', 'unified_server', 690525462312787968, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864909, 'permission_list', 'unified_server', 690525353298632704, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864910, 'permission_list', 'unified_server', 690525197148889088, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864911, 'permission_list', 'unified_server', 690525099648098304, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864912, 'permission_list', 'unified_server', 690525019226513408, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864913, 'permission_list', 'unified_server', 690524899974062080, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864915, 'permission_list', 'unified_server', 690522779594006528, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864916, 'permission_list', 'unified_server', 690522261102534656, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864917, 'permission_list', 'unified_server', 690641814235127808, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864918, 'permission_list', 'unified_server', 690641909710069760, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864919, 'permission_list', 'unified_server', 697104639711256576, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864920, 'permission_list', 'unified_server', 697104639711256577, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864921, 'permission_list', 'unified_server', 697104639711256578, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864922, 'permission_list', 'unified_server', 697104639711256579, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864923, 'permission_list', 'unified_server', 697104639711256583, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864924, 'permission_list', 'unified_server', 697104639711256584, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864925, 'permission_list', 'unified_server', 697104639711256585, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864926, 'permission_list', 'unified_server', 697104639711256580, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864927, 'permission_list', 'unified_server', 697104639711256581, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (662981304710864928, 'permission_list', 'unified_server', 697104639711256582, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (812248181407752192, 'permission_list', 'message_server', 576393382897917952, 0, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (812248181432918016, 'permission_list', 'message_server', 812025848596275200, 0, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (812248181445500928, 'permission_list', 'message_server', 812026141606158336, 0, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (812248181458083840, 'permission_list', 'message_server', 812026329171238912, 0, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_CLIENT_PERMISSION` VALUES (812248181470666752, 'permission_list', 'message_server', 812026421143937024, 0, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_CODE_RULE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CODE_RULE`;
CREATE TABLE `SYS_CODE_RULE`  (
  `CODE_RULE_ID` bigint(20) NOT NULL COMMENT '编码规则ID',
  `CODE_RULE_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编码规则CODE(唯一)',
  `CODE_RULE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中文名',
  `CODE_RULE_DESC` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '简介',
  `IS_SYS` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否系统编码',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `IS_LEVEL` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否层级编码',
  PRIMARY KEY (`CODE_RULE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编码规则信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CODE_RULE
-- ----------------------------
INSERT INTO `SYS_CODE_RULE` VALUES (622468560387842048, 'SYS_ORGAN:ORGAN_CODE_4', '组织机构编码生成规则', '组织机构编码生成规则', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '0');
INSERT INTO `SYS_CODE_RULE` VALUES (624170019827490816, 'SYS_STAFF:STAFF_CODE', '人员编码生成规则', '人员编码生成规则', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '0');
INSERT INTO `SYS_CODE_RULE` VALUES (723599456163078144, 'SYS_POST:POST_CODE', '岗位编码', '岗位编码', '1', NULL, '2023-06-20 18:05:54', 1450756958461300737, '2023-06-20 18:05:54', 1450756958461300737, '0');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640706, 'SYS_RESOURCE_MODULES:MODULE_CODE', '模块编码', '模块编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640708, 'SYS_RESOURCES:RESOURCE_CODE', '资源编码', '资源编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640713, 'SYS_FUNCTIONS:FUNCTION_CODE', '功能编码', '功能编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640717, 'SYS_FUNCTION_MODULES:FUNCTION_MODULE_CODE', '功能模块编码', '功能模块编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640718, 'SYS_APPLICATION:APP_CODE', '应用编码', '应用编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640719, 'SYS_RESOURCE_TYPE:RESOURCE_TYPE_CODE', '资源类型编码', '资源类型编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO `SYS_CODE_RULE` VALUES (1450754032317640720, 'SYS_RESOURCE_TYPE_EXPAND:RESOURCE_TYPE_EXPAND_CODE', '资源类型拓展属性编码', '资源类型拓展属性编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');

-- ----------------------------
-- Table structure for SYS_CODE_RULE_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CODE_RULE_INFO`;
CREATE TABLE `SYS_CODE_RULE_INFO`  (
  `CODE_RULE_INFO_ID` bigint(20) NOT NULL COMMENT '编码配置信息表ID',
  `CODE_RULE_ID` bigint(20) NOT NULL COMMENT '编码规则ID',
  `CODE_RULE_SORT` int(11) NULL DEFAULT NULL COMMENT '排序码',
  `ELEMENT_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '元素类型',
  `ELEMENT_PATTERN` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '元素格式',
  `SERIAL_NUMBER_LENGTH` int(11) NULL DEFAULT NULL COMMENT '流水号长度',
  `SERIAL_NUMBER_CODE` bigint(20) NULL DEFAULT NULL COMMENT '流水号当前编码',
  `SERIAL_NUMBER_START` bigint(20) NULL DEFAULT NULL COMMENT '流水号初始值',
  `NOW_PERIOD` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前周期',
  `RESET_PERIOD` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重置周期',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`CODE_RULE_INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编码配置信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CODE_RULE_INFO
-- ----------------------------
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312342302720, 622468560387842048, 1, 'serialNumber', '1', 11, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312438771712, 624170019827490816, 1, 'serialNumber', '1', 11, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312572989440, 1450754032317640706, 1, 'serialNumber', '1', 12, 272, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312694624256, 1450754032317640708, 1, 'serialNumber', '1', 12, 5070153, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312828841984, 1450754032317640713, 1, 'serialNumber', '1', 12, 253, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312828841985, 1450754032317640718, 1, 'serialNumber', '1', 10, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312958865408, 1450754032317640715, 1, 'serialNumber', '1', 8, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701312958865409, 1450754032317640719, 1, 'serialNumber', '1', 4, 5, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701313093083136, 1450754032317640717, 1, 'serialNumber', '1', 4, 37, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (708701313093083137, 1450754032317640720, 1, 'serialNumber', '1', 4, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO `SYS_CODE_RULE_INFO` VALUES (723599456225992704, 723599456163078144, 1, 'serialNumber', '1', 11, 0, 1, '', '1', '2023-06-20 18:05:54', 1450756958461300737, '2023-06-20 18:05:54', 1450756958461300737);

-- ----------------------------
-- Table structure for SYS_CODE_RULE_LEVEL_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CODE_RULE_LEVEL_INFO`;
CREATE TABLE `SYS_CODE_RULE_LEVEL_INFO`  (
  `LEVEL_INFO_ID` bigint(20) NOT NULL COMMENT '层级码ID',
  `CODE_RULE_ID` bigint(20) NULL DEFAULT NULL COMMENT '编码规则ID',
  `ID_VALUE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前值',
  `PARENT_NUMBER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级ID',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`LEVEL_INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编码层级信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CODE_RULE_LEVEL_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CONF_ROLES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CONF_ROLES`;
CREATE TABLE `SYS_CONF_ROLES`  (
  `SCR_ID` bigint(20) NOT NULL COMMENT '主键',
  `ROLE_ID` bigint(20) NOT NULL COMMENT '角色编码',
  `SET_ID` bigint(20) NOT NULL COMMENT '不相容角色集编码',
  `SYS_SET_ID` bigint(20) NULL DEFAULT NULL COMMENT '不相容角色集编码',
  PRIMARY KEY (`SCR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '不相容角色' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CONF_ROLES
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CONF_ROLESET
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CONF_ROLESET`;
CREATE TABLE `SYS_CONF_ROLESET`  (
  `SET_ID` bigint(20) NOT NULL COMMENT '不相容角色集编码',
  `SET_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '不相容角色集名称',
  `CARDINALITY` int(11) NULL DEFAULT NULL COMMENT '基数',
  `CORPORATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属公司结构编码',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次更新时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次更新人',
  `ROLESET_REMARK` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`SET_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '不相容角色集' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CONF_ROLESET
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CUSTOMIZED_COMPONENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CUSTOMIZED_COMPONENT`;
CREATE TABLE `SYS_CUSTOMIZED_COMPONENT`  (
  `CUSTOMIZED_COMPONENT_ID` bigint(20) NOT NULL COMMENT '主键',
  `CSS_FILE` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'css文件',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`CUSTOMIZED_COMPONENT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '定制化组件信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CUSTOMIZED_COMPONENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CUSTOM_BUTTON
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CUSTOM_BUTTON`;
CREATE TABLE `SYS_CUSTOM_BUTTON`  (
  `BUTTON_ID` bigint(20) NOT NULL COMMENT '自定义按钮id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '自定义按钮所属表单id',
  `BUTTON_NAME` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义按钮名称',
  `BUTTON_ALIAS` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义按钮别名',
  `TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮类型, custom：自定义按钮',
  `BUTTON_DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义按钮说明',
  `BUTTON_ACTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮的权限标识',
  `BUTTON_ICON` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮图标',
  `BUTTON_STYLE` int(11) NULL DEFAULT NULL COMMENT '按钮风格，1:主要按钮，2:次要按钮',
  `BUTTON_COLOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮字体颜色',
  `BACKGROUND_COLOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '按钮背景颜色',
  `BUTTON_EVENT` int(11) NULL DEFAULT NULL COMMENT '自定义按钮动作类型,1:填写指定内容,2:更新数据,3:打开自定义页面',
  `BUTTON_POSITION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义按钮显示位置，1：详情页，2：表格页，逗号分隔',
  `BUTTON_FILTER` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '自定义按钮的可用条件',
  `NOT_SATISFIED_HIDDEN` tinyint NULL DEFAULT NULL COMMENT '是否隐藏不满足条件的按钮',
  `BUTTON_FILL_ACTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '自定义按钮执行填写指定内容动作参数',
  `BUTTON_UPDATE_ACTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '自定义按钮执行更新数据动作参数',
  `CUSTOM_PAGE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '自定义按钮打开自定义页面动作参数',
  `SECOND_CONFIRM` tinyint NULL DEFAULT NULL COMMENT '自定义按钮是否需要二次确认',
  `SECOND_CONFIRM_SETTING` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '二次确认信息',
  `BUTTON_SEQ` int(11) NULL DEFAULT NULL COMMENT '自定义按钮显示顺序的序号',
  `BUTTON_DATA_PULL_ACTION_ID` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`BUTTON_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义按钮表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CUSTOM_BUTTON
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CUSTOM_LIST_FIELD_INFO`;
CREATE TABLE `SYS_CUSTOM_LIST_FIELD_INFO`  (
  `INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `PAGE_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面ID',
  `COMPONENT_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件ID',
  `COMPONENT_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '组件信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否已删除(0 正常 1 已删除)',
  PRIMARY KEY (`INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义字段信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CUSTOM_VIEW
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CUSTOM_VIEW`;
CREATE TABLE `SYS_CUSTOM_VIEW`  (
  `VIEW_ID` bigint(20) NOT NULL COMMENT '主键id',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用id',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `VIEW_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图名称',
  `ALIAS` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图别名',
  `CATEGORY` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图种类',
  `VIEW_TYPE` smallint NULL DEFAULT NULL COMMENT '视图类型',
  `TAB_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签类型',
  `STYLES` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表格样式',
  `BUTTONS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表格操作按钮',
  `TOOLS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表格工具按钮',
  `FILTERS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '数据过滤',
  `ORDER_BY` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '排序',
  `SHOW_FIELDS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '显示字段',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑删除字段',
  `VISIBLE` char(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图显隐',
  `VIEW_PERMISSION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '可见范围',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `SHOW_FIELDS_MULTI` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '多级表头',
  PRIMARY KEY (`VIEW_ID`) USING BTREE,
  INDEX `FORM_ID`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义视图表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CUSTOM_VIEW
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_CUSTOM_VIEW_HIDE_ORDER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_CUSTOM_VIEW_HIDE_ORDER`;
CREATE TABLE `SYS_CUSTOM_VIEW_HIDE_ORDER`  (
  `ID` bigint(20) NOT NULL COMMENT '主键id',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `USER_ID` bigint(20) NOT NULL COMMENT '用户id',
  `VIEW_ORDER` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '视图排序',
  `VIEW_HIDE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '视图显隐',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑删除字段',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `FORM_ID`(`FORM_ID` ASC, `USER_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义视图顺序表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_CUSTOM_VIEW_HIDE_ORDER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DASHBOARD_ENTRY
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DASHBOARD_ENTRY`;
CREATE TABLE `SYS_DASHBOARD_ENTRY`  (
  `ENTRY_ID` bigint(20) NOT NULL COMMENT '主键',
  `ENTRY_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用ID',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `APP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用ID',
  `GROUP_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组ID',
  `ICON` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '排序',
  `DATASOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源ID',
  `DATASOURCE_NAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '数据源名称',
  `DATASOURCE_TYPE` int(11) NULL DEFAULT NULL COMMENT '数据源类型',
  `ENTRY_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图表类型',
  `ENTRY_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `ENTRY_OPTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '配置信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  PRIMARY KEY (`ENTRY_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仪表盘信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_DASHBOARD_ENTRY
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_LOGIC_FILTER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_LOGIC_FILTER`;
CREATE TABLE `SYS_DATA_LOGIC_FILTER`  (
  `FILTER_ID` bigint(20) NOT NULL COMMENT '主键',
  `ROLE_DATA_LOGIC_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属数据逻辑ID',
  `FIELD_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单内字段ID',
  `FIELD_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段名',
  `FILTER_CONDITION_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '过滤条件编码',
  `FILTER_CONDITION_NAME` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '过滤条件名',
  `FILTER_VALUE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '过滤条件值',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`FILTER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单数据逻辑过滤条件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_LOGIC_FILTER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_OPERATE_LOG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_OPERATE_LOG`;
CREATE TABLE `SYS_DATA_OPERATE_LOG`  (
  `OPERATE_ID` bigint(20) NOT NULL COMMENT '操作日志id',
  `DATA_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据id',
  `OLD_RECORD` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '旧数据',
  `NEW_RECORD` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '新数据',
  `CHILD_RECORD` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '子表操作记录',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `COUNT` int(11) NULL DEFAULT NULL COMMENT '修改条数',
  `OP_TYPE` int(11) NULL DEFAULT NULL COMMENT '操作类型0：新增1：修改2：删除',
  `OP_MODE` int(11) NULL DEFAULT NULL COMMENT '操作方式0：手动修改1：表格导入2：自定义按钮3：业务规则4：应用导入5：表单导入',
  `TRIGGER_FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务规则触发表单id，非业务规则方式则为空',
  `CHILD_COUNT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '子表操作条数，ADD新增，UPDATE:修改，DEL删除',
  `DEVICE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作设备，PC电脑端，Mobile移动端，Unknown未知设备',
  `BUTTON_ID` bigint(20) NULL DEFAULT NULL COMMENT '自定义按钮触发按钮id，非自定义按钮触发则为空',
  `WIDGET` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '画布属性',
  PRIMARY KEY (`OPERATE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据操作日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_OPERATE_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PULL_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PULL_CONFIG`;
CREATE TABLE `SYS_DATA_PULL_CONFIG`  (
  `ID` bigint(20) NOT NULL COMMENT '数据拉取主键id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用 ID',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据拉取规则名称',
  `TRIGGER_ACTION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '0为定时触发,1为主动触发',
  `TRIGGER_BEGIN_TIME` datetime NULL DEFAULT NULL COMMENT '触发开始时间',
  `TRIGGER_END_TIME_SET` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否设置触发结束时间1设置0不设置',
  `TRIGGER_END_TIME` datetime NULL DEFAULT NULL COMMENT '触发结束时间',
  `REPEAT_MODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重复模式1为每天触发一次',
  `PULL_MODE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '0为全量1为增量',
  `URL` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'api地址',
  `PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参',
  `FIELD_MAPS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段映射配置',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '开启状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0',
  `LAST_EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '上一次执行时间',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `formId_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据拉取规则表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PULL_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PULL_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PULL_RECORD`;
CREATE TABLE `SYS_DATA_PULL_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT '数据推送拉取记录主键id',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `PULL_ID` bigint(20) NULL DEFAULT NULL COMMENT '推送规则id',
  `PULL_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拉取规则名称',
  `URL` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'API调用地址',
  `HTTP_STATUS` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'http状态码',
  `SUCCESS` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '结果1成功0失败',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `RESULT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '返回结果',
  `PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求参数',
  PRIMARY KEY (`RECORD_ID`) USING BTREE,
  INDEX `formId_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据拉取日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PULL_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PULL_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PULL_TASK`;
CREATE TABLE `SYS_DATA_PULL_TASK`  (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用 ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单 ID',
  `CONFIG_ID` bigint(20) NULL DEFAULT NULL COMMENT '配置 ID',
  `FIRST_EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '首次执行时间',
  `REPEAT_RULE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重复规则',
  `NEXT_EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '下次执行时间',
  `END_EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '结束执行时间',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '执行状态',
  `EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '执行时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标志',
  `URL` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'api地址',
  `PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参',
  `FIELD_MAPS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段映射配置',
  `END_EXECUTE_TIME_SET` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否设置执行结束时间',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PULL_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PUSH_CONFIG`;
CREATE TABLE `SYS_DATA_PUSH_CONFIG`  (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用 ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单 ID',
  `NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则名称',
  `TRIGGER_ACTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '触发动作',
  `TRIGGER_CONDITION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '触发条件',
  `URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '推送地址',
  `FIELD_MAPS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段映射',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '开启状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标志',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `formId_index`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据推送规则表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PUSH_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_MAP_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PUSH_MAP_CONFIG`;
CREATE TABLE `SYS_DATA_PUSH_MAP_CONFIG`  (
  `ID` bigint(20) NOT NULL COMMENT 'ID',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单ID',
  `FIELD_MAP` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '映射关系',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `formId_index`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单全局字段映射' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PUSH_MAP_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_PUSH_RECORD`;
CREATE TABLE `SYS_DATA_PUSH_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT '数据推送拉取记录主键id',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `PUSH_ID` bigint(20) NULL DEFAULT NULL COMMENT '推送规则id',
  `PUSH_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '推送规则名称',
  `URL` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'API调用地址',
  `PARAM` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参',
  `HTTP_STATUS` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'http状态码',
  `SUCCESS` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标志',
  `RESULT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '返回结果',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`RECORD_ID`) USING BTREE,
  INDEX `formId_index`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据推送日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_PUSH_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_SET_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_SET_GROUP`;
CREATE TABLE `SYS_DATA_SET_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '数据集分组id',
  `GROUP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集分组名称',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '分组显示顺序',
  `GROUP_ICON` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集分组图标',
  `GROUP_ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组图标类型1：内置图标2：用户自定义',
  `GROUP_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组类型1:默认分组2:普通分组',
  `GROUP_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组图标颜色',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据集应用ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据集分组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_SET_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DATA_SET_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DATA_SET_INFO`;
CREATE TABLE `SYS_DATA_SET_INFO`  (
  `DATA_SET_ID` bigint(20) NOT NULL COMMENT '数据集ID',
  `DATA_SET_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集名称',
  `DATA_SET_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集标识',
  `DATA_SET_ICON_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集图标类型',
  `DATA_SET_ICON` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集图标',
  `DATA_SET_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内置图标颜色',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  `DATA_SET_DESC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集描述',
  `DATA_SOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源id',
  `DATA_SOURCE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源名称',
  `DATA_SOURCE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源类型',
  `GROUP_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据集分组ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `DATA_SET_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据集类型',
  `DATA` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '数据集信息',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '需要逻辑删除的业务添加该字段',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`DATA_SET_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据集信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DATA_SET_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_DICT_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DICT_GROUP`;
CREATE TABLE `SYS_DICT_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '主键',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `GROUP_DESCRIPTION` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字典分组描述',
  `RANGE_TYPE` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编辑类型',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属应用id',
  `SORT` int(11) NULL DEFAULT NULL COMMENT '排序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `BAK_1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段1',
  `BAK_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段2',
  `BAK_3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段3',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '字典分组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DICT_GROUP
-- ----------------------------
INSERT INTO `SYS_DICT_GROUP` VALUES (1450384393200865282, 11, '系统字典', 'sys', NULL, 1, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_GROUP` VALUES (1450384438474231809, 11, '业务字典', 'biz', NULL, 2, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_DICT_SINGLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DICT_SINGLE`;
CREATE TABLE `SYS_DICT_SINGLE`  (
  `DICT_ID` bigint(20) NOT NULL COMMENT '编号',
  `TYPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '类型(SYS_DICT_TYPE外键)',
  `VALUE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据值',
  `LABEL` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签名',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属应用id',
  `SORT` int(11) NULL DEFAULT NULL COMMENT '排序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `BAK_1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段1',
  `BAK_2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段2',
  `BAK_3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段3',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父级主键ID',
  PRIMARY KEY (`DICT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '字典字段表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DICT_SINGLE
-- ----------------------------
INSERT INTO `SYS_DICT_SINGLE` VALUES (517670394224975872, 517670295990181888, '1', '驳回', NULL, 1, 1450756958461300737, '2021-11-29 11:57:20', 1450756958461300737, '2021-11-29 11:57:20', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (517670664690475008, 517670295990181888, '2', '驳回，请重新申请', NULL, 2, 1450756958461300737, '2021-11-29 11:58:24', 1450756958461300737, '2021-11-29 11:58:24', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (517670721909170176, 517670295990181888, '3', '驳回至第一节点', NULL, 3, 1450756958461300737, '2021-11-29 11:58:38', 1450756958461300737, '2021-11-29 11:58:38', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (523443293179355136, 523443198920761344, '0', '内部组件', NULL, 1, NULL, '2021-12-15 10:16:46', NULL, '2021-12-15 10:16:46', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (523444544218603520, 523443198920761344, '1', '外部组件', NULL, 2, NULL, '2021-12-15 10:21:44', NULL, '2021-12-15 10:21:44', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (523444626317910016, 523443198920761344, '3', 'URL', NULL, 4, NULL, '2021-12-15 10:22:04', NULL, '2021-12-15 10:22:04', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (524165267232923648, 524165175805485056, '1', '公告', NULL, 1, 1450756958461300737, '2021-12-17 10:05:38', 1450756958461300737, '2021-12-17 10:05:38', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (524611884536832000, 524165175805485056, '2', '通知', NULL, 2, 1450756958461300737, '2021-12-18 15:40:20', 1450756958461300737, '2021-12-18 15:40:20', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586233816600027136, 586233551075418112, '1', '阿里云', NULL, 1, 1450756958461300737, '2022-06-06 16:43:54', 1450756958461300737, '2022-06-06 16:43:54', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586233852901728256, 586233551075418112, '2', '腾讯云', NULL, 2, 1450756958461300737, '2022-06-06 16:44:02', 1450756958461300737, '2022-06-06 16:44:02', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586260304451870654, 575022217952501760, '1', '待发送', NULL, 1, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586260304451870720, 575022217952501760, '2', '发送失败', NULL, 2, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586260336982892544, 575022217952501760, '3', '发送成功', NULL, 3, 1450756958461300737, '2022-06-06 18:29:17', 1450756958461300737, '2022-06-06 18:29:17', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586262527764340736, 586262390337970176, '1', '启用', NULL, 1, 1450756958461300737, '2022-06-06 18:37:59', 1450756958461300737, '2022-06-06 18:37:59', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586262557128663040, 586262390337970176, '0', '禁用', NULL, 2, 1450756958461300737, '2022-06-06 18:38:06', 1450756958461300737, '2022-06-06 18:38:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586658954864762880, 586658891807596544, '1', 'SMTP', NULL, 1, 1450756958461300737, '2022-06-07 20:53:14', 1450756958461300737, '2022-06-07 20:53:14', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586658992051462144, 586658891807596544, '2', 'EXCHANGE(微软)', NULL, 2, 1450756958461300737, '2022-06-07 20:53:23', 1450756958461300737, '2022-06-07 20:53:23', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586659341466345472, 586659288706195456, '1', 'SSL', NULL, 1, 1450756958461300737, '2022-06-07 20:54:47', 1450756958461300737, '2022-06-07 20:54:47', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (586659379760340992, 586659288706195456, '2', 'STARTTLS', NULL, 2, 1450756958461300737, '2022-06-07 20:54:56', 1450756958461300737, '2022-06-07 20:54:56', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587690415013240832, 587690275439386624, '0', 'App本身', NULL, 1, 1450756958461300737, '2022-06-10 17:11:54', 1450756958461300737, '2022-06-10 17:11:54', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587690459435114496, 587690275439386624, '1', '打开activity', NULL, 2, 1450756958461300737, '2022-06-10 17:12:04', 1450756958461300737, '2022-06-10 17:12:04', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587690502590308352, 587690275439386624, '2', '打开浏览器', NULL, 3, 1450756958461300737, '2022-06-10 17:12:15', 1450756958461300737, '2022-06-10 17:12:15', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587690549516181504, 587690275439386624, '3', '打开Intent', NULL, 4, 1450756958461300737, '2022-06-10 17:12:26', 1450756958461300737, '2022-06-10 17:12:26', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587956098712215552, 587955865517301760, '0', 'android', NULL, 1, 1450756958461300737, '2022-06-11 10:47:38', 1450756958461300737, '2022-06-11 10:47:38', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587956198599565312, 587955865517301760, '1', 'IOS', NULL, 2, 1450756958461300737, '2022-06-11 10:48:01', 1450756958461300737, '2022-06-11 10:48:01', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587956413003997184, 587955865517301760, '2', '安卓+IOS', NULL, 3, 1450756958461300737, '2022-06-11 10:48:53', 1450756958461300737, '2022-06-11 10:48:53', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587957011560538112, 587956910612029440, '0', '全部', NULL, 1, 1450756958461300737, '2022-06-11 10:51:15', 1450756958461300737, '2022-06-11 10:51:15', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (587957143559479296, 587956910612029440, '1', 'token', NULL, 2, 1450756958461300737, '2022-06-11 10:51:47', 1450756958461300737, '2022-06-11 10:51:47', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (591913513669369856, 591913311474556928, '5', '前5名', NULL, 1, 1450756958461300737, '2022-06-22 08:52:59', 1450756958461300737, '2022-06-22 08:52:59', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (591913605549793280, 591913311474556928, '10', '前10名', NULL, 2, 1450756958461300737, '2022-06-22 08:53:21', 1450756958461300737, '2022-06-22 08:53:21', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (591913706074677248, 591913311474556928, '15', '前15名', NULL, 3, 1450756958461300737, '2022-06-22 08:53:45', 1450756958461300737, '2022-06-22 08:53:45', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (591917296298237952, 591913311474556928, '20', '前20名', NULL, 4, 1450756958461300737, '2022-06-22 09:08:01', 1450756958461300737, '2022-06-22 09:08:01', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (608964020338434048, 608963936091643904, 'sms', '短信', NULL, 1, 1450756958461300737, '2022-08-08 10:05:36', 1450756958461300737, '2022-08-08 10:05:36', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (608964253302661120, 608963936091643904, 'mail', '邮件', NULL, 2, 1450756958461300737, '2022-08-08 10:06:32', 1450756958461300737, '2022-08-08 10:06:46', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (608964420399538176, 608963936091643904, 'wx_account', '微信公众号', NULL, 3, 1450756958461300737, '2022-08-08 10:07:12', 1450756958461300737, '2022-08-08 10:07:12', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (608964548640382976, 608963936091643904, 'app_push', 'APP通知', NULL, 4, 1450756958461300737, '2022-08-08 10:07:42', 1450756958461300737, '2022-08-08 10:09:24', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (608964730950000640, 608963936091643904, 'app_im', 'IM', NULL, 5, 1450756958461300737, '2022-08-08 10:08:26', 1450756958461300737, '2022-08-08 10:08:26', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (609025100737683456, 608963936091643904, 'notice', '内部通知', NULL, 6, 1450756958461300737, '2022-08-08 14:08:19', 1450756958461300737, '2022-08-08 14:08:19', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (673842271296430080, 673842175301394432, '2', '覆盖更新', NULL, 2, 1450756958461300737, '2023-02-03 10:48:37', 1450756958461300737, '2023-02-10 08:56:29', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676350515063562240, 673842175301394432, '1', '忽略导入', NULL, 1, 1450756958461300737, '2023-02-10 08:55:29', 1450756958461300737, '2023-02-14 15:16:44', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357019191746560, 676356930893258752, '1', '组织机构导入', NULL, 1, 1450756958461300737, '2023-02-10 09:21:19', 1450756958461300737, '2023-02-10 09:21:19', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357106202583040, 676356930893258752, '2', '用户人员导入', NULL, 2, 1450756958461300737, '2023-02-10 09:21:40', 1450756958461300737, '2023-02-10 09:21:40', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357106206842918, 676356930893258752, '3', '字典导入', NULL, 3, 1450756958461300737, '2023-06-09 10:21:40', 1450756958461300737, '2023-06-09 11:22:40', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357144312029184, 676356969782845440, '1', '组织机构导出', NULL, 1, 1450756958461300737, '2023-02-10 09:21:49', 1450756958461300737, '2023-02-10 09:21:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357177321201664, 676356969782845440, '2', '用户人员导出', NULL, 2, 1450756958461300737, '2023-02-10 09:21:57', 1450756958461300737, '2023-02-10 09:21:57', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (676357177321284927, 676356969782845440, '3', '字典导出', NULL, 3, 1450756958461300737, '2023-06-09 09:21:57', 1450756958461300737, '2023-06-09 10:21:57', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (677896054456459264, 673842175301394432, '4', '报错提醒', NULL, 4, 1450756958461300737, '2023-02-14 15:16:54', 1450756958461300737, '2023-02-14 15:16:54', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (686887028247502848, 686886958856937472, '1', '零代码', NULL, 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (686887115581300736, 686886958856937472, '2', '低代码', NULL, 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (686887316178083840, 686886958856937472, '3', '自建应用', NULL, 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (688027377053474816, 608963936091643904, 'cp', '企业微信', NULL, 7, 1450756958461300737, '2023-03-14 14:15:10', 1450756958461300737, '2023-03-14 14:15:10', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (696315839754018816, 696315722368032768, '0', '导入中', NULL, 1, NULL, '2023-04-06 11:10:33', NULL, '2023-04-06 11:10:33', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (696315890861613056, 696315722368032768, '4', '导入成功', NULL, 2, NULL, '2023-04-06 11:10:45', NULL, '2023-04-06 11:10:45', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (696315957861425152, 696315722368032768, '-1', '导入失败', NULL, 3, NULL, '2023-04-06 11:11:01', NULL, '2023-04-06 11:11:01', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (698464699389583360, 608963936091643904, 'dingTalk', '钉钉', NULL, 8, 1450756958461300737, '2023-04-12 09:29:21', 1450756958461300737, '2023-04-12 09:29:21', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (700277290533396480, 696315722368032768, '6', '导出成功', NULL, 4, NULL, '2023-04-17 09:31:57', NULL, '2023-04-17 09:31:57', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (714082823409246208, 714082718056718336, '1', '单行文本', NULL, 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (714082861522886656, 714082718056718336, '2', '多行文本', NULL, 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (714082900894818304, 714082718056718336, '3', '下拉选择', NULL, 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (736951458939019264, 736951385576448000, '0', '内部组件', NULL, 1, 1450756958461300737, '2023-07-27 14:22:00', 1450756958461300737, '2023-07-27 14:22:00', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (736951496494817280, 736951385576448000, '1', '外部组件', NULL, 2, 1450756958461300737, '2023-07-27 14:22:09', 1450756958461300737, '2023-07-27 14:22:09', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (737025783427768320, 737025163346059264, '1', '待办', NULL, 1, 1450756958461300737, '2023-07-27 19:17:20', 1450756958461300737, '2023-07-27 19:17:20', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (737025830928261120, 737025163346059264, '2', '日程', NULL, 2, 1450756958461300737, '2023-07-27 19:17:31', 1450756958461300737, '2023-07-27 19:17:31', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (737025877589893120, 737025163346059264, '3', '会议', NULL, 3, 1450756958461300737, '2023-07-27 19:17:42', 1450756958461300737, '2023-07-27 19:17:42', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (737025935500648448, 737025163346059264, '4', '其他', NULL, 4, 1450756958461300737, '2023-07-27 19:17:56', 1450756958461300737, '2023-07-27 19:17:56', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (795585252704919552, 794925156320681984, 'user', '用户', NULL, 1, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (806812606638858240, 676356930893258752, '4', '联系人导入', NULL, 4, 1450756958461300737, '2024-02-05 09:05:15', 1450756958461300737, '2024-02-05 09:05:15', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (812013673790054400, 794925156320681984, 'client', '客户', NULL, 2, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (812013805734469632, 794925156320681984, 'supplier', '供应商', NULL, 3, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561602, 1450742089372590096, '1', '系统级事件', NULL, 1, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561603, 1450742089372590093, '1', '部门经理', NULL, 1, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561604, 1450742089372590097, '1', '激活', NULL, 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561605, 1450742089372590088, '1', '全部可见', NULL, 1, NULL, '2021-03-04 14:29:11', NULL, '2021-03-04 14:29:11', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561606, 1450742089372590083, 'tab', '标签页', NULL, 1, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561607, 1450742089372590091, '70', '秘密', NULL, 3, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561608, 1450742089372590091, '71', '核心商业秘密', NULL, 2, NULL, '2021-04-26 11:18:31', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561609, 1450742089372590093, '2', '阿米巴负责人', NULL, 2, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561610, 1450742089372590083, 'left', '隐藏左侧', NULL, 3, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561611, 1450742089372590093, '4', '员工', NULL, 4, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561612, 1450742089372590087, '2', '驳回，请重新申请', NULL, 2, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561613, 1450742089372590082, 'res_btn', '接口资源', NULL, 2, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561614, 1450742089372590087, '3', '驳回至第一节点', NULL, 3, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561615, 1450742089372590096, '2', '业务级事件', NULL, 2, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561616, 1450742089372590094, 'holiday', '休', NULL, 2, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561617, 1450742089372590083, 'full', '新页面', NULL, 2, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561618, 1450742089372590088, '2', '所在部门及子级可见', NULL, 2, NULL, '2021-03-04 14:30:33', NULL, '2021-03-04 14:30:33', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561619, 1450742089372590094, 'notice', '通知', NULL, 3, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561620, 1450742089372590090, '0', '临时账号', NULL, 2, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561621, 1450742089372590088, '3', '仅所在部门可见', NULL, 3, NULL, '2021-03-04 14:30:45', NULL, '2021-03-04 14:30:45', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561622, 1450742089372590099, '1', '是', NULL, 1, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561623, 1450742089372590099, '0', '否', NULL, 2, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561624, 1450742089372590088, '4', '仅所属人可见', NULL, 4, NULL, '2021-03-04 14:30:58', NULL, '2021-03-04 14:30:58', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561625, 1450742089372590098, '2', '女', NULL, 10, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561626, 1450742089372590098, '1', '男', NULL, 1, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561627, 1450742089372590088, '5', '自定义可见范围', NULL, 5, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561628, 1450742089372590095, 'clbx', '差旅报销', NULL, 1, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561629, 1450742089372590097, '0', '锁定', NULL, 3, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:09', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561630, 1450742089372590090, '1', '长期账号', NULL, 1, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561631, 1450742089372590086, '0', '未审核', NULL, 2, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561632, 1450742089372590097, '3', '休眠', NULL, 2, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561633, 1450742089372590091, '61', '普通商业秘密', NULL, 4, NULL, '2021-04-26 11:19:18', NULL, '2021-04-26 11:19:14', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561634, 1450742089372590092, '80', '重要', NULL, 2, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561635, 1450742089372590091, '80', '机密', NULL, 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561636, 1450742089372590085, '0', '失败', NULL, 1, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561637, 1450742089372590094, 'work', '班', NULL, 1, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561638, 1450742089372590091, '60', '内部', NULL, 5, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561639, 1450742089372590086, '2', '驳回', NULL, 3, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561640, 1450742089372590089, '2', '人员', NULL, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561641, 1450742089372590082, 'res_menu', '页面资源', NULL, 1, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561642, 1450742089372590084, '1', '是', NULL, 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561643, 1450742089372590092, '90', '核心', NULL, 1, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561644, 1450742089372590095, 'xmgl', '项目管理', NULL, 2, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561645, 1450742089372590085, '1', '成功', NULL, 2, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561646, 1450742089372590086, '1', '通过', NULL, 1, NULL, '2018-04-14 13:39:16', NULL, '2018-04-18 09:57:14', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561647, 1450742089372590091, '50', '公开', NULL, 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561648, 1450742089372590089, '1', '角色', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561649, 1450742089372590084, '0', '否', NULL, 1, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561650, 1450742089372590087, '1', '驳回', NULL, 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561651, 1450742089372590092, '60', '非密', NULL, 4, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561652, 1450742089372590092, '70', '一般', NULL, 3, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561653, 1450742089372590093, '3', '项目经理', NULL, 3, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1450742089393561654, 1450742089372590082, 'res_rights', '数据资源', NULL, 3, 1450756958461300737, '2022-11-11 10:07:39', 1450756958461300737, '2022-11-11 10:07:39', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482817, 714082718056718338, 'yyyy', '年', NULL, 11, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482818, 714082718056718338, 'yyyyMM', '年月', NULL, 12, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482819, 714082718056718338, 'yyyy-MM', '年-月', NULL, 13, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482820, 714082718056718338, 'yyyy/MM', '年/月', NULL, 14, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482821, 714082718056718338, 'yyyyMMdd', '年月日', NULL, 15, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482822, 714082718056718338, 'yyyy-MM-dd', '年-月-日', NULL, 16, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482823, 714082718056718338, 'yyyy/MM/dd', '年/月/日', NULL, 17, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482824, 714082718056718338, 'yyyyMMddHHmm', '年月日时分', NULL, 18, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482825, 714082718056718338, 'yyyyMMddHHmmss', '年月日时分秒', NULL, 19, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482826, 714082718056718338, 'MMdd', '月日', NULL, 20, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482827, 714082718056718338, 'MM-dd', '月-日', NULL, 21, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482828, 714082718056718338, 'MM/dd', '月/日', NULL, 22, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1683383216712482829, 714082718056718338, 'HHmmss', '时间', NULL, 23, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430081, 714082718056718337, '1', '不重置', NULL, 1, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430082, 714082718056718337, '2', '按年重置', NULL, 2, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430083, 714082718056718337, '3', '按季度重置', NULL, 3, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430084, 714082718056718337, '4', '按月重置', NULL, 4, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430085, 714082718056718337, '5', '按周重置', NULL, 5, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1684752048320430086, 714082718056718337, '6', '按日重置', NULL, 6, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` VALUES (1690913474055581697, 686886958856937472, '7', '微应用', NULL, 7, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` (`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES(1450742089393561660, 1450742089372590088, '6', '根据用户所属组织类型分级授予可见范围', 6, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE`(`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES (811895928742223872, 811895803462557696, '1', '否', 2, 1450756958461300737, '2024-02-19 09:44:34', 1450756958461300737, '2024-02-19 09:44:34', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE`(`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES (811895903979053056, 811895803462557696, '0', '是', 1, 1450756958461300737, '2024-02-19 09:44:28', 1450756958461300737, '2024-02-19 09:44:28', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE`(`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES (811895869715783680, 811895718649536512, '1', '停用', 2, 1450756958461300737, '2024-02-19 09:44:20', 1450756958461300737, '2024-02-19 09:44:20', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE`(`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES (811895839013478400, 811895718649536512, '0', '启用', 1, 1450756958461300737, '2024-02-19 09:44:12', 1450756958461300737, '2024-02-19 09:44:12', NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` (`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES(1450742089393561655, 517670295990181889, 'dialog', '弹窗', 1, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` (`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES(1450742089393561656, 517670295990181889, 'browserTab', '浏览器页签', 2, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` (`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES(1450742089393561657, 517670295990181889, 'tab', '系统内页签', 3, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_SINGLE` (`DICT_ID`, `TYPE_ID`, `VALUE`, `LABEL`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`, `PARENT_ID`) VALUES(1450742089393561658, 517670295990181889, 'noCode', '零代码', 4, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_DICT_TYPE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DICT_TYPE`;
CREATE TABLE `SYS_DICT_TYPE`  (
  `TYPE_ID` bigint(20) NOT NULL COMMENT '主键',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `TYPE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别名',
  `TYPE_DESCRIPTION` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别描述',
  `RANGE_TYPE` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编辑类型(系统sys/业务biz)',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属应用id',
  `SORT` int(11) NULL DEFAULT NULL COMMENT '排序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `BAK_1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段1',
  `BAK_2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段2',
  `BAK_3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备用字段3',
  PRIMARY KEY (`TYPE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_DICT_TYPE
-- ----------------------------
INSERT INTO `SYS_DICT_TYPE` VALUES (517670295990181888, 1450384438474231809, 'opinion_reject', '常用驳回意见', 'biz', NULL, 2, 1450756958461300737, '2021-11-29 11:56:56', 1450756958461300737, '2021-11-29 11:56:56', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (523443198920761344, 1450384393200865282, 'res_strategy', '页面类型', 'sys', NULL, 41, NULL, '2021-12-15 10:16:24', NULL, '2021-12-15 10:16:24', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (524165175805485056, 1450384438474231809, 'noticeType', '公告类型', 'biz', NULL, 3, 1450756958461300737, '2021-12-17 10:05:16', 1450756958461300737, '2021-12-17 10:05:16', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (575022217952501760, 1450384438474231809, 'msg_send_status', '消息发送状态', 'biz', NULL, 4, 1450756958461300737, '2022-05-06 18:13:00', 1450756958461300737, '2022-06-06 18:28:47', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (586233551075418112, 1450384438474231809, 'sms_channel_type', '短信服务通道类型', 'biz', NULL, 5, 1450756958461300737, '2022-06-06 16:42:50', 1450756958461300737, '2022-06-06 16:42:50', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (586262390337970176, 1450384438474231809, 'msg_is_enable', '消息通用是否启用', 'biz', NULL, 6, 1450756958461300737, '2022-06-06 18:37:26', 1450756958461300737, '2022-06-06 18:41:39', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (586658891807596544, 1450384438474231809, 'mail_protocol', '邮箱协议', 'biz', NULL, 7, 1450756958461300737, '2022-06-07 20:52:59', 1450756958461300737, '2022-06-07 20:52:59', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (586659288706195456, 1450384438474231809, 'mail_safe_type', '邮箱安全类型', 'biz', NULL, 8, 1450756958461300737, '2022-06-07 20:54:34', 1450756958461300737, '2022-06-07 20:54:34', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (587690275439386624, 1450384438474231809, 'app_action_type', '消息推送动作类型', 'biz', NULL, 9, 1450756958461300737, '2022-06-10 17:11:20', 1450756958461300737, '2022-06-10 17:11:20', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (587955865517301760, 1450384438474231809, 'platform_type', '接收平台', 'biz', NULL, 10, 1450756958461300737, '2022-06-11 10:46:42', 1450756958461300737, '2022-06-11 10:46:42', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (587956910612029440, 1450384438474231809, 'push_scope', '推送范围', 'biz', NULL, 11, 1450756958461300737, '2022-06-11 10:50:51', 1450756958461300737, '2022-06-11 10:50:51', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (591913311474556928, 1450384438474231809, 'statistics_top', '统计排名数量', 'biz', NULL, 4, 1450756958461300737, '2022-06-22 08:52:11', 1450756958461300737, '2022-06-22 08:52:11', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (608963936091643904, 1450384438474231809, 'msg_service_type', '消息服务发送类型', 'biz', NULL, 12, 1450756958461300737, '2022-08-08 10:05:16', 1450756958461300737, '2022-08-08 10:05:16', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (673842175301394432, 1450384393200865282, 'encode_dup_pol', '机构编码重复策略', 'sys', NULL, 2, 1450756958461300737, '2023-02-03 10:48:14', 1450756958461300737, '2023-02-03 10:48:14', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (676356930893258752, 1450384393200865282, 'import_type', '导入类型', 'sys', NULL, 3, 1450756958461300737, '2023-02-10 09:20:58', 1450756958461300737, '2023-02-10 09:20:58', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (676356969782845440, 1450384393200865282, 'export_type', '导出类型', 'sys', NULL, 4, 1450756958461300737, '2023-02-10 09:21:08', 1450756958461300737, '2023-02-10 09:21:08', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (686886958856937472, 1450384438474231809, 'app_type', '应用类型', 'biz', NULL, 17, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (696315722368032768, 1450384393200865282, 'imp_exp_state', 'excel导入导出状态', 'sys', NULL, 43, NULL, '2023-04-06 11:10:05', NULL, '2023-04-06 11:10:05', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (714082718056718336, 1450384393200865282, 'res_expand_type', '资源类型扩展属性类型', 'sys', NULL, 42, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (714082718056718337, 1450384393200865282, 'reset_period', '重置周期', 'sys', NULL, 43, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (714082718056718338, 1450384393200865282, 'date_pattern', '日期格式', 'sys', NULL, 44, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (736951385576448000, 1450384393200865282, 'assembly_type', '组件类型', 'sys', NULL, 44, 1450756958461300737, '2023-07-27 14:21:42', 1450756958461300737, '2023-07-27 14:21:42', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (737025163346059264, 1450384393200865282, 'message_type', '消息类型', 'sys', NULL, 45, 1450756958461300737, '2023-07-27 19:14:52', 1450756958461300737, '2023-07-27 19:14:52', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (794925156320681984, 1450384438474231809, 'msg_contact_type', '消息服务联系人类型', 'biz', NULL, 46, NULL, '2024-01-03 13:48:46', NULL, '2024-01-03 13:48:46', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590082, 1450384393200865282, 'res_type', '资源类型', 'sys', NULL, 30, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590083, 1450384393200865282, 'menu_type', '菜单开发方式', 'sys', NULL, 35, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590084, 1450384393200865282, 'is_sys', '系统管理员', 'sys', NULL, 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-09 08:51:54', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590085, 1450384393200865282, 'success_fail', '成功失败', 'sys', NULL, 37, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590086, 1450384393200865282, 'user_role_review', '用户角色审核状态', 'sys', NULL, 31, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590087, 1450384438474231809, 'common_opinion', '常用意见', 'biz', NULL, 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590088, 1450384393200865282, 'data_scope_type', '数据权限类型', 'sys', NULL, 38, NULL, '2021-03-04 14:22:18', NULL, '2021-03-04 14:22:25', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590089, 1450384393200865282, 'type', '欢迎页配置对象类型', 'sys', NULL, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590090, 1450384393200865282, 'account_property', '账号属性', 'sys', NULL, 3, NULL, '2020-04-09 08:52:55', NULL, '2020-04-09 08:52:55', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590091, 1450384438474231809, 'security_level', '数据密级', 'biz', NULL, 15, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590092, 1450384438474231809, 'user_security_level', '用户密级', 'biz', NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590093, 1450384438474231809, 'staff_position', '人员职务', 'biz', NULL, 14, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590094, 1450384393200865282, 'calendar_event_type', '工作日历事件类型', 'sys', NULL, 36, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590095, 1450384438474231809, 'todo_type', '待办类型', 'biz', NULL, 13, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590096, 1450384393200865282, 'levelEvent', '系统/业务级事件', 'sys', NULL, 36, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590097, 1450384393200865282, 'account_state', '账户状态', 'sys', NULL, 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-16 12:17:51', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590098, 1450384393200865282, 'sex', '性别', 'sys', NULL, 18, NULL, '2018-04-11 14:10:07', NULL, '2018-04-11 14:10:07', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` VALUES (1450742089372590099, 1450384393200865282, 'yes_no', '是/否', 'sys', NULL, 29, NULL, '2018-04-11 14:10:08', NULL, '2018-04-11 14:10:08', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE` (`TYPE_ID`, `PARENT_ID`, `TYPE_NAME`, `TYPE_DESCRIPTION`, `RANGE_TYPE`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`) VALUES(517670295990181889, 1450384438474231809, 'openType', '页面打开方式', 'biz', 45, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE`(`TYPE_ID`, `PARENT_ID`, `TYPE_NAME`, `TYPE_DESCRIPTION`, `RANGE_TYPE`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`) VALUES (811895803462557696, 1450384438474231809, 'yes_no_close', '横幅是否能关闭', 'biz', 47, 1450756958461300737, '2024-02-19 09:44:04', 1450756958461300737, '2024-02-19 09:44:04', NULL, NULL, NULL);
INSERT INTO `SYS_DICT_TYPE`(`TYPE_ID`, `PARENT_ID`, `TYPE_NAME`, `TYPE_DESCRIPTION`, `RANGE_TYPE`, `SORT`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `BAK_1`, `BAK_2`, `BAK_3`) VALUES (811895718649536512, 1450384438474231809, 'advertisementStatus', '广告启用状态', 'biz', 46, 1450756958461300737, '2024-02-19 09:43:44', 1450756958461300737, '2024-02-19 09:43:44', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_DONE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_DONE`;
CREATE TABLE `SYS_DONE`  (
  `DONE_ID` bigint(20) NOT NULL COMMENT '已办主键',
  `SEND_USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '发送人编码',
  `SEND_USER_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人名称',
  `RECEIVE_USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '接收人编码',
  `RECEIVE_USER_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收人名称',
  `ORGAN_ID` bigint(20) NULL DEFAULT NULL COMMENT '发送人单位编码',
  `ORGAN_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人单位名称',
  `TASK_TYPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务类型编码',
  `TASK_TYPE_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务类型名称',
  `TASK_DETAIL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '已办详情',
  `TASK_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程任务主键',
  `BUSINESS_ID` bigint(20) NULL DEFAULT NULL COMMENT '对应业务主键',
  `FLOW_EXAMPLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '流程实例ID',
  `URL` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '待办URL',
  `RECEIVE_TIME` datetime NULL DEFAULT NULL COMMENT '签收时间',
  `DEAL_TIME` datetime NULL DEFAULT NULL COMMENT '办理时间',
  `BAK1` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留字段1',
  `BAK2` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留字段2',
  `DONE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '已办名称',
  PRIMARY KEY (`DONE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '已办事项表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_DONE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_EIM_NEWS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EIM_NEWS`;
CREATE TABLE `SYS_EIM_NEWS`  (
  `NEWS_ID` bigint(20) NOT NULL COMMENT '消息ID',
  `NEWS_TITLE` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '新闻标题',
  `NEWS_SUBTITLE` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '副标题',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除',
  `CREATOR_DEPT` bigint(20) NULL DEFAULT NULL COMMENT '创建人部门id',
  `CREATOR_DEPT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人部门',
  `TYPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '类型id',
  `NEWS_TOP` tinyint NULL DEFAULT NULL COMMENT '是否置顶',
  `NEWS_CONTENT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '新闻内容',
  `URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部链接',
  `FROM_RESOURCE` bigint(20) NULL DEFAULT NULL COMMENT '新闻来源',
  `NEWS_TYPE` tinyint NULL DEFAULT NULL COMMENT '新闻类型（0 普通新闻 \r\n1 图片新闻 \r\n2 视频新闻）',
  `READ_COUNT` int(11) NULL DEFAULT NULL COMMENT '阅读次数',
  `SHOW_TYPE` tinyint NULL DEFAULT NULL COMMENT '封面图展示方式',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  `COVER_IMAGE` bigint(20) NULL DEFAULT NULL COMMENT '封面图',
  `PUBLISH_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布状态',
  `PUBLISH_TIME` datetime NULL DEFAULT NULL COMMENT '发布时间',
  PRIMARY KEY (`NEWS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '新闻资讯表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_EIM_NEWS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_FILE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EIM_NEWS_FILE`;
CREATE TABLE `SYS_EIM_NEWS_FILE`  (
  `FILE_ID` bigint(20) NOT NULL COMMENT '文件id',
  `NEWS_ID` bigint(20) NULL DEFAULT NULL COMMENT '新闻id',
  `FILE_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件类型',
  `FILE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  `FILE_SIZE` int(11) NULL DEFAULT NULL COMMENT '文件大小',
  `FILE_STATUS` int(11) NULL DEFAULT NULL COMMENT '文件状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除',
  `DEPICT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '文件描述',
  `MD5` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'MD5',
  `TYPE` int(11) NULL DEFAULT NULL COMMENT '类型',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  PRIMARY KEY (`FILE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '新闻文件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_EIM_NEWS_FILE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_FROMRESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EIM_NEWS_FROMRESOURCE`;
CREATE TABLE `SYS_EIM_NEWS_FROMRESOURCE`  (
  `NEWS_SOURCE_ID` bigint(20) NOT NULL COMMENT '新闻来源id',
  `SOURCE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源名称',
  `SOURCE_URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '链接地址',
  `SOURCE_HEAD` bigint(20) NULL DEFAULT NULL COMMENT '图标base64',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  `DEPICT` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '简介',
  PRIMARY KEY (`NEWS_SOURCE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '新闻来源表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_EIM_NEWS_FROMRESOURCE
-- ----------------------------
INSERT INTO `SYS_EIM_NEWS_FROMRESOURCE` VALUES (785085207605944320, '媒体记者', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:20', 1450756958461300737, '2023-12-07 10:08:20', '0', NULL, '');
INSERT INTO `SYS_EIM_NEWS_FROMRESOURCE` VALUES (785085248051617792, '专门机构', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:29', 1450756958461300737, '2023-12-07 10:08:29', '0', NULL, '');
INSERT INTO `SYS_EIM_NEWS_FROMRESOURCE` VALUES (785085280800743424, '公众个人', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:37', 1450756958461300737, '2023-12-07 10:08:37', '0', NULL, '');
INSERT INTO `SYS_EIM_NEWS_FROMRESOURCE` VALUES (785085317987442688, '其他媒体', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:46', 1450756958461300737, '2023-12-07 10:08:46', '0', NULL, '');

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_READ
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EIM_NEWS_READ`;
CREATE TABLE `SYS_EIM_NEWS_READ`  (
  `READ_ID` bigint(20) NOT NULL COMMENT '阅读记录id',
  `NEWS_ID` bigint(20) NULL DEFAULT NULL COMMENT '新闻id',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除',
  PRIMARY KEY (`READ_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '新闻阅读量表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_EIM_NEWS_READ
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_TYPE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EIM_NEWS_TYPE`;
CREATE TABLE `SYS_EIM_NEWS_TYPE`  (
  `NEWS_TYPE_ID` bigint(20) NOT NULL COMMENT '新闻类型id',
  `NEWS_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '新闻类型',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人id',
  `CREATOR_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  PRIMARY KEY (`NEWS_TYPE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '新闻类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_EIM_NEWS_TYPE
-- ----------------------------
INSERT INTO `SYS_EIM_NEWS_TYPE` VALUES (785085356717645824, '动态新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:08:55', 1450756958461300737, '2023-12-07 10:08:55', '0', NULL);
INSERT INTO `SYS_EIM_NEWS_TYPE` VALUES (785085393677852672, '综合新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:09:04', 1450756958461300737, '2023-12-07 10:09:04', '0', NULL);
INSERT INTO `SYS_EIM_NEWS_TYPE` VALUES (785085421486088192, '经验新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:09:11', 1450756958461300737, '2023-12-07 10:09:11', '0', NULL);
INSERT INTO `SYS_EIM_NEWS_TYPE` VALUES (785085448723898368, '新闻评述', 1450756958461300737, '超级管理员', '2023-12-07 10:09:17', 1450756958461300737, '2023-12-07 10:09:17', '0', NULL);

-- ----------------------------
-- Table structure for SYS_EXCEL_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_EXCEL_TASK`;
CREATE TABLE `SYS_EXCEL_TASK`  (
  `TASK_ID` bigint(20) NOT NULL COMMENT '任务ID',
  `EXCEL_TYPE` int(11) NULL DEFAULT NULL COMMENT 'Excel业务类型：1.组织机构 2.人员 3.字典 4.联系人',
  `TASK_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务类型: 1.导入 2.导出',
  `TASK_STATUS` int(11) NULL DEFAULT NULL COMMENT '任务状态: 1.校验中 2.校验通过 3.校验未通过  4.导入中  5.导入完成 6.导入失败 7.导出中 8.导出完成 9.导出失败',
  `TASK_FILE` bigint(20) NULL DEFAULT NULL COMMENT '导入/导出文件oss地址',
  `FILE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入/导出文件名称',
  `CHECK_SCENARIO` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入校验场景：1.新增数据 2.更新和新增数据',
  `CHECK_FILE` bigint(20) NULL DEFAULT NULL COMMENT '导入校验结果文件oss地址',
  `CHECK_RESULT` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入校验结果',
  `SHOW_MSG` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入校验未通过/导入失败/导出失败信息等展示信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `CREATE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人姓名',
  `DATA_TOTAL` int(11) NULL DEFAULT NULL COMMENT '数据总条数',
  `DATA_SUCCESS` int(11) NULL DEFAULT NULL COMMENT '校验成功条数',
  `DATA_ERROR` int(11) NULL DEFAULT NULL COMMENT '校验失败条数',
  `ERROR_FILE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '校验错误文件下载地址',
  `ERROR_MSG` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '错误原因',
  `EXCEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  PRIMARY KEY (`TASK_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'EXCEL任务日志表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_EXCEL_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FILE_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FILE_INFO`;
CREATE TABLE `SYS_FILE_INFO`  (
  `FILE_ID` bigint(20) NOT NULL COMMENT '主键',
  `ATTACHMENT_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件名称',
  `ATTACHMENT_DIR` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件路径',
  `ATTACHMENT_TYPE` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件类型',
  `ATTACHMENT_SIZE` bigint(20) NULL DEFAULT NULL COMMENT '附件大小',
  `UPLOAD_PER` bigint(20) NULL DEFAULT NULL COMMENT '上传人',
  `UPLOAD_DATE` datetime NULL DEFAULT NULL COMMENT '上传时间',
  `BUSINESS_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务ID  ',
  `FILE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '排序字段',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`FILE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '附件信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FILE_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FILE_RELATION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FILE_RELATION`;
CREATE TABLE `SYS_FILE_RELATION`  (
  `RELATION_ID` bigint(20) NOT NULL COMMENT '关联关系ID',
  `BUSINESS_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务ID',
  `FILE_ID` bigint(20) NOT NULL COMMENT '文件ID',
  `ATTACHMENT_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件名称',
  `ATTACHMENT_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件类型',
  `TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类类型',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '排序字段',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`RELATION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '附件关联关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FILE_RELATION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM`;
CREATE TABLE `SYS_FORM`  (
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单ID',
  `TABLE_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单表名',
  `FORM_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单名称',
  `FORM_GROUP_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单分组',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `FORM_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型 普通表单是0 流程表单是1',
  `FORM_ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单图标类型',
  `FORM_ICON` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单图标',
  `FORM_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内置图标颜色',
  `FORM_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单状态',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '需要逻辑删除的业务添加该字段',
  PRIMARY KEY (`FORM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_AUTHORIZE_ROLES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_AUTHORIZE_ROLES`;
CREATE TABLE `SYS_FORM_AUTHORIZE_ROLES`  (
  `FORM_ROLE_ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '需要逻辑删除的业务添加该字段',
  PRIMARY KEY (`FORM_ROLE_ID`) USING BTREE,
  UNIQUE INDEX `AK_unique_form_id_role_id`(`FORM_ID` ASC, `ROLE_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单可授访问权限的角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_AUTHORIZE_ROLES
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_CHECK_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_CHECK_CONFIG`;
CREATE TABLE `SYS_FORM_CHECK_CONFIG`  (
  `CHECK_CONFIG_ID` bigint(20) NOT NULL COMMENT '校验配置主键id',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单id',
  `CHECK_CONFIG` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '校验配置',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`CHECK_CONFIG_ID`) USING BTREE,
  UNIQUE INDEX `formId_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单提交校验配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_CHECK_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_CONVERT_HISTORY
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_CONVERT_HISTORY`;
CREATE TABLE `SYS_FORM_CONVERT_HISTORY`  (
  `CONVERT_ID` bigint(20) NOT NULL COMMENT '表单转换历史记录主键',
  `FORM_ID` bigint(20) NOT NULL COMMENT '表单ID',
  `FORM_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表单类型',
  `CONVERT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表单转换后类型',
  `OPERATOR` bigint(20) NULL DEFAULT NULL COMMENT '操作人',
  `OPERATION_TIME` datetime NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`CONVERT_ID`) USING BTREE,
  INDEX `ind_formId`(`FORM_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单转换历史' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_CONVERT_HISTORY
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_GROUP`;
CREATE TABLE `SYS_FORM_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '分组ID',
  `GROUP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `SEQ` int(11) NULL DEFAULT 1 COMMENT '分组显示顺序',
  `GROUP_ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组图标类型\r\n1：内置图标\n2：用户自定义',
  `GROUP_ICON` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组图标\r\n内置图标：图标标识\n用户自定义：图片ID',
  `GROUP_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组类型\r\n1:默认分组\n2:普通分组',
  `GROUP_ICON_COLOR` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内置图标颜色',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `APP_ID` bigint(20) NOT NULL COMMENT '应用ID',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单分组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK`;
CREATE TABLE `SYS_FORM_LINK`  (
  `LINK_ID` bigint(20) NOT NULL COMMENT '表单外链id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `LINK_STATUS` int(11) NULL DEFAULT NULL COMMENT '表单外链状态',
  `LINK_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单外链地址',
  `LINK_SHORT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '短链接',
  `LINK_PASS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单外链密码',
  `HAS_PASS` int(11) NULL DEFAULT NULL COMMENT '是否开启密码',
  `WECHAT_STATUS` int(11) NULL DEFAULT NULL COMMENT '是否开启微信增强',
  `WECHAT_TYPE` int(11) NULL DEFAULT NULL COMMENT '微信增强获取用户信息的方式',
  `WECHAT_SUBMIT_ONE` int(11) NULL DEFAULT NULL COMMENT '微信用户是否只能提交一次',
  `WECHAT_SUBMIT_REMIND` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义提示语',
  `HAS_EXT_PARAMS` int(11) NULL DEFAULT NULL COMMENT '是否有外链扩展',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `FIELD_CONTROL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段控制配置',
  `RESULT_PAGE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '结果页配置',
  `HAS_FIELD_CONTROL` int(11) NULL DEFAULT NULL COMMENT '是否配置字段控制',
  `FORM_SHEET` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表单样式',
  PRIMARY KEY (`LINK_ID`) USING BTREE,
  UNIQUE INDEX `form_id_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单外链表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK_EXTEND
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK_EXTEND`;
CREATE TABLE `SYS_FORM_LINK_EXTEND`  (
  `EXTEND_ID` bigint(20) NOT NULL COMMENT '主键',
  `LINK_ID` bigint(20) NULL DEFAULT NULL COMMENT '外链id',
  `EXTEND_VALUE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展值',
  `LINK_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展后的链接地址',
  PRIMARY KEY (`EXTEND_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单外链扩展表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK_EXTEND
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK_OPEN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK_OPEN`;
CREATE TABLE `SYS_FORM_LINK_OPEN`  (
  `LINK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `LINK_SHORT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '短链接',
  `LINK_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外链地址',
  `LINK_STATUS` int(11) NULL DEFAULT NULL COMMENT '表单外链状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人  ',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LINK_PASS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '链接密码',
  `HAS_PASS` int(11) NULL DEFAULT NULL COMMENT '是否设置链接密码',
  `LINK_QUERY` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '查询条件',
  `LINK_SHOW` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '展示字段',
  `LINK_TITLE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面标题',
  `HAS_FIELD_CONTROL` int(11) NULL DEFAULT 0 COMMENT '是否配置展示字段',
  `PRINT_ID_ARR` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '打印模板id数组',
  PRIMARY KEY (`LINK_ID`) USING BTREE,
  UNIQUE INDEX `form_id_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单公开查询外链表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK_OPEN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK_SINGLE`;
CREATE TABLE `SYS_FORM_LINK_SINGLE`  (
  `LINK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `DATA_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `LINK_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外链地址',
  `LINK_SHORT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '短链接',
  `LINK_STATUS` int(11) NULL DEFAULT NULL COMMENT '表单外链状态',
  `LINK_PASS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外链密码',
  `HAS_PASS` int(11) NULL DEFAULT NULL COMMENT '是否有密码',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `EXPIRY_TIME` datetime NULL DEFAULT NULL COMMENT '过期时间',
  PRIMARY KEY (`LINK_ID`) USING BTREE,
  UNIQUE INDEX `dataId_formId`(`DATA_ID` ASC, `FORM_ID` ASC) USING BTREE COMMENT '数据id，表单id联合唯一索引',
  UNIQUE INDEX `dataIdIndex`(`DATA_ID` ASC) USING BTREE COMMENT '数据id索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单单条数据外链表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE_INNER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK_SINGLE_INNER`;
CREATE TABLE `SYS_FORM_LINK_SINGLE_INNER`  (
  `LINK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `DATA_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `INNER_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '应用内链接参数',
  `INNER_SHORT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用内短链接',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`LINK_ID`) USING BTREE,
  UNIQUE INDEX `dataId_formId`(`DATA_ID` ASC, `FORM_ID` ASC) USING BTREE COMMENT '数据id，表单id联合唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用内单条数据分享链接' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE_INNER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE_STATUS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_LINK_SINGLE_STATUS`;
CREATE TABLE `SYS_FORM_LINK_SINGLE_STATUS`  (
  `SINGLE_ID` bigint(20) NOT NULL COMMENT '主键id',
  `SINGLE_STATUS` int(11) NULL DEFAULT NULL COMMENT '表单单条数据外链状态',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `FIELD_CONTROL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段控制',
  `HAS_FIELD_CONTROL` int(11) NULL DEFAULT NULL COMMENT '是否配置字段控制',
  `FORM_SHEET` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '表单样式配置',
  `RESULT_PAGE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '结果页配置',
  `PRINT_ID_ARR` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '打印模板id数组',
  PRIMARY KEY (`SINGLE_ID`) USING BTREE,
  UNIQUE INDEX `form_id_index`(`FORM_ID` ASC) USING BTREE COMMENT '表单id唯一索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '表单单条数据外链状态表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE_STATUS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_MSG_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_MSG_CONFIG`;
CREATE TABLE `SYS_FORM_MSG_CONFIG`  (
  `ID` bigint(20) NOT NULL,
  `APP_ID` bigint(20) NULL DEFAULT NULL,
  `FORM_ID` bigint(20) NULL DEFAULT NULL,
  `REMINDER_TEXT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `TRIGGER_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REMIND` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REPEAT_RULE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `END_TIME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `TRIGGER_CONDITION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REMINDERS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REMINDER_MODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL,
  `CREATE_TIME` datetime NULL DEFAULT NULL,
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL,
  `LAST_TIME` datetime NULL DEFAULT NULL,
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_FORM_MSG_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FORM_PUSH_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FORM_PUSH_TASK`;
CREATE TABLE `SYS_FORM_PUSH_TASK`  (
  `ID` bigint(20) NOT NULL,
  `FORM_ID` bigint(20) NULL DEFAULT NULL,
  `DATA_ID` bigint(20) NULL DEFAULT NULL,
  `CONTENT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `FIRST_REMINDER_TIME` bigint(20) NULL DEFAULT NULL,
  `NEXT_REMINDER_TIME` bigint(20) NULL DEFAULT NULL,
  `REPEAT_RULE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `END_TIME` bigint(20) NULL DEFAULT NULL,
  `REMINDERS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REMINDER_MODE` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CREATOR` bigint(20) NULL DEFAULT NULL,
  `CREATE_TIME` datetime NULL DEFAULT NULL,
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL,
  `LAST_TIME` datetime NULL DEFAULT NULL,
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_FORM_PUSH_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_FUNCTIONS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FUNCTIONS`;
CREATE TABLE `SYS_FUNCTIONS`  (
  `FUNCTION_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `FUNCTION_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '功能编号',
  `FUNCTION_MODULE_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能模块ID',
  `FUNCTION_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '功能名称',
  `DEFAULT_RESOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能默认资源ID',
  `IS_SYS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否系统功能',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '功能序号',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `APPLICATION_ID` bigint(20) NULL DEFAULT 1 COMMENT '所属应用的id，默认1：属于统一权限平台自身数据',
  PRIMARY KEY (`FUNCTION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FUNCTIONS
-- ----------------------------
INSERT INTO `SYS_FUNCTIONS` VALUES (518460834717114368, '0205', 523215083967619072, '客户端管理', 518451664789970944, '1', 6, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (520236482527764480, '0201', 523213269419433984, '插件管理', 520236254294712320, '1', 14, 1450756958461300737, '2021-12-06 13:54:03', 1450756958461300737, '2021-12-06 13:54:03', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (521404105277841408, '0202', 528155915363557376, '应用注册', 521403853758013440, '1', 1, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (522705551881412608, '0203', 521403976781144064, '我的待办', 522705027572441088, '1', 2, 1450756958461300737, '2021-12-13 09:25:15', 1450756958461300737, '2021-12-13 09:25:15', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (523555260388876288, '0201', 521403976781144064, '我的已办', 523554762252361728, '1', 3, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (523555376986333184, '0202', 521403976781144064, '我的传阅', 523555173533229056, '1', 4, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (526077556152344576, '0205', 526077391123259392, '我的公告', 526077294431969280, '1', 1, 1450756958461300737, '2021-12-22 16:44:23', 1450756958461300737, '2021-12-22 16:44:23', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (535768729024471040, '0205', 523215142994059264, '审计查阅', 535768620278751232, '1', 4, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (544469147921424384, '0201', 523213269419433984, '主题配置', 544468972511436800, '1', 15, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (544475707963875328, '0201', 523215083967619072, '任务管理', 544474404047036416, '1', 8, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (544475799542308864, '0202', 523215083967619072, '任务实例', 544475544734146560, '1', 9, 1450756958461300737, '2022-02-11 11:12:26', 1450756958461300737, '2022-02-11 11:12:26', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (545565036773646336, '0201', 545564987515740160, '统一日志', 545564853264457728, '1', 1, 1450756958461300737, '2022-02-14 11:20:41', 1450756958461300737, '2022-02-14 11:20:41', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (546343149988225024, '0201', 545564987515740160, '链路追踪', 546343017720848384, '1', 2, 1450756958461300737, '2022-02-16 14:52:38', 1450756958461300737, '2022-02-16 14:52:38', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (546347915988443136, '0202', 545564987515740160, '错误统计', 546346988292284416, '1', 3, 1450756958461300737, '2022-02-16 15:11:34', 1450756958461300737, '2022-02-16 15:11:34', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576438008606367744, '0205', 1450764807862095873, '委托已办', 576437892923269120, '1', 7, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447430137225216, '0203', 576447319827030016, '通道管理', 576444545517232128, '1', 1, 1450756958461300737, '2022-05-10 16:36:17', 1450756958461300737, '2022-05-13 20:15:33', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447488295444480, '0204', 576447319827030016, '签名管理', 576445297899872256, '1', 2, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447546457858048, '0205', 576447319827030016, '模板管理', 576445557296603136, '1', 3, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447608743272448, '0206', 576447319827030016, '发送测试', 576445740617048064, '1', 4, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447666205237248, '0207', 576447319827030016, '发送记录', 576445901988700160, '1', 5, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576447721767182336, '0208', 576447319827030016, '发送统计', 576446061217062912, '1', 6, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (576448277533433856, '0206', 1450764807862095873, '委托待办', 576425225089196032, '1', 6, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (577911233693622272, '0229', 577911145198002176, '通道管理', 577910957540646912, '1', 1, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (577920176742473728, '0230', 577911145198002176, '发送记录', 577920052196810752, '1', 6, 1450756958461300737, '2022-05-14 18:08:27', 1450756958461300737, '2022-05-15 11:19:58', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578179104113958912, '0231', 577911145198002176, '模板管理', 578178840069939200, '1', 2, 1450756958461300737, '2022-05-15 11:17:20', 1450756958461300737, '2022-05-15 11:19:41', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578179213245554688, '0232', 577911145198002176, '单发测试', 577951344581943296, '1', 3, 1450756958461300737, '2022-05-15 11:17:46', 1450756958461300737, '2022-05-15 11:34:45', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578179275791015936, '0233', 577911145198002176, '群发测试', 577951711264776192, '1', 4, 1450756958461300737, '2022-05-15 11:18:01', 1450756958461300737, '2022-05-15 14:02:18', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578179328681189376, '0234', 577911145198002176, '收件人管理', 577951935202861056, '1', 5, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:19:58', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578180115675226112, '0235', 577911145198002176, '发送统计', 578180013862690816, '1', 7, 1450756958461300737, '2022-05-15 11:21:22', 1450756958461300737, '2022-05-22 10:39:31', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578225632039936000, '0236', 578225558232768512, '通道管理', 578224814087741440, '1', 1, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578225680442204160, '0237', 578225558232768512, '模板管理', 578225070686871552, '1', 2, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578225755054678016, '0238', 578225558232768512, '发送测试', 578225260298772480, '1', 3, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (578225803503083520, '0239', 578225558232768512, '发送记录', 578225470362099712, '1', 4, 1450756958461300737, '2022-05-15 14:22:54', 1450756958461300737, '2022-05-15 14:22:54', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579402490307682304, '0240', 579402387463348224, '通道管理', 579400593928626176, '1', 1, 1450756958461300737, '2022-05-18 20:18:38', 1450756958461300737, '2022-05-18 20:18:38', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579402568669863936, '0241', 579402387463348224, '发送测试', 579401699782041600, '1', 2, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579402651498979328, '0242', 579402387463348224, '发送统计', 579402283595603968, '1', 3, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579407434091864064, '0243', 579407339665498112, '通道管理', 579406581389860864, '1', 1, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579407499330068480, '0244', 579407339665498112, '发送测试', 579406782007615488, '1', 2, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579407703957577728, '0245', 579407339665498112, '发送记录', 579406956977201152, '1', 3, 1450756958461300737, '2022-05-18 20:39:21', 1450756958461300737, '2022-05-18 20:39:21', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579407758378672128, '0246', 579407339665498112, '发送统计', 579407194467082240, '1', 4, 1450756958461300737, '2022-05-18 20:39:34', 1450756958461300737, '2022-05-18 20:39:34', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (579987015375003648, '0247', 579402387463348224, '发送记录', 579986784054943744, '1', 4, 1450756958461300737, '2022-05-20 11:01:20', 1450756958461300737, '2022-05-20 11:07:55', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581430666475085824, '0209', 587696011380793344, '流程概览', 564389067157151744, '1', 1, 1450756958461300737, '2022-05-24 10:37:53', 1450756958461300737, '2022-05-24 11:01:57', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581436854533103616, '0210', 587696011380793344, '流程状态分析', 581431768348106752, '1', 2, 1450756958461300737, '2022-05-24 11:02:29', 1450756958461300737, '2022-05-24 11:02:29', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581436941229367296, '0211', 587696011380793344, '流程参与者分析', 581432525403201536, '1', 3, 1450756958461300737, '2022-05-24 11:02:49', 1450756958461300737, '2022-05-24 11:02:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581436993427480576, '0212', 587696011380793344, '流程统计分析', 581434143087534080, '1', 4, 1450756958461300737, '2022-05-24 11:03:02', 1450756958461300737, '2022-05-24 11:03:02', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437139125018624, '0213', 587696011380793344, '热门流程分析', 581434493471301632, '1', 5, 1450756958461300737, '2022-05-24 11:03:37', 1450756958461300737, '2022-05-24 11:03:37', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437221161410560, '0214', 587696011380793344, '流程数量分析', 581434937987833856, '1', 6, 1450756958461300737, '2022-05-24 11:03:56', 1450756958461300737, '2022-05-24 11:03:56', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437297606795264, '0215', 587696011380793344, '用户流程分析', 581435215210356736, '1', 7, 1450756958461300737, '2022-05-24 11:04:14', 1450756958461300737, '2022-05-24 11:04:14', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437337255550976, '0216', 587696011380793344, '待办任务分析', 581435962006183936, '1', 8, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437337255550977, '0217', 587696011380793344, '流程驳回分析', 586205441340743680, '1', 9, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (581437382767943681, '0218', 587696011380793344, '流程耗时分析', 581436516656750592, '1', 10, 1450756958461300737, '2022-05-24 11:04:35', 1450756958461300737, '2022-05-24 11:04:35', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (582661445364490240, '0248', 578225558232768512, '发送统计', 582661309611646976, '1', 5, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (587709734606610432, '0250', 587709613621911552, '发送记录', 587709219764183040, '1', 2, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (587709787979128832, '0251', 587709613621911552, '发送统计', 587709399175536640, '1', 3, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (588042975440019456, '0252', 587709613621911552, '发送测试', 588042819223166976, '1', 4, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (592386778267394048, '0201', 592400770314543104, '告警设置', 592385945366700032, '1', 1, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (592391757124345856, '0202', 592400770314543104, '告警记录', 592391481915088896, '1', 2, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (595572331049656320, '0201', 595572248216346624, '首页配置', 595571989650087936, '1', 1, 1450756958461300737, '2022-07-02 11:11:49', 1450756958461300737, '2022-07-02 11:11:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (595572392424906752, '0202', 595572248216346624, '三方集成', 595572170466533376, '1', 2, 1450756958461300737, '2022-07-02 11:12:04', 1450756958461300737, '2022-07-02 11:12:04', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (596354099289792512, '0253', 596353922000756736, '应用管理', 596353576553684992, '1', 1, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (608974847288287232, '0205', 596353922000756736, '场景管理', 608974704010862592, '1', 2, 1450756958461300737, '2022-08-08 10:48:38', 1450756958461300737, '2022-08-08 11:21:18', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (641243926136889344, '0201', 641243779856343040, '数据导入', 641241962678329344, '1', 1, 1450756958461300737, '2022-11-05 11:54:26', 1450756958461300737, '2022-11-05 11:54:26', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (641244024103247872, '0202', 641243779856343040, '数据导出', 641241760202498048, '1', 2, 1450756958461300737, '2022-11-05 11:54:49', 1450756958461300737, '2022-11-05 11:54:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (673553074966765568, '0203', 1450764807862095875, '工作流配置项管理', 673551263069380608, '1', 6, 1450756958461300737, '2023-02-02 15:39:27', 1450756958461300737, '2023-02-02 16:21:38', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686147054220877824, '0201', 686146937447260160, '应用管理', 686146166286721024, '1', 1, 1450756958461300737, '2023-03-09 09:43:26', 1450756958461300737, '2023-03-09 09:43:26', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686147191273955328, '0202', 686146937447260160, '应用回收站', 686146454410240000, '1', 2, 1450756958461300737, '2023-03-09 09:43:58', 1450756958461300737, '2023-03-09 09:43:59', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686178119287316480, '0203', 686176268227715072, '通道管理', 686174839412891648, '1', 1, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686178183690854400, '0204', 686176268227715072, '发送测试', 686175350430113792, '1', 2, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686178259356098560, '0205', 686176268227715072, '发送记录', 686175659781005312, '1', 3, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (686178312292409344, '0206', 686176268227715072, '发送统计', 686176030305820672, '1', 4, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (688350053471100928, '0203', 1450764807862095885, '岗位管理', 688348921973710848, '1', 7, 1450756958461300737, '2023-03-15 11:37:22', 1450756958461300737, '2023-03-15 14:05:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (697762187867070464, '0201', 697761878826557440, '通道管理', 697759569409220608, '1', 1, 1450756958461300737, '2023-04-10 10:57:49', 1450756958461300737, '2023-04-10 10:58:05', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (697762370797445120, '0202', 697761878826557440, '发送测试', 697760877801381888, '1', 2, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (697762455014875136, '0203', 697761878826557440, '发送记录', 697761225484017664, '1', 3, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (697762540020834304, '0204', 697761878826557440, '发送统计', 697761494317932544, '1', 4, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (713719009941659648, '0201', 523213321676267520, '资源类型维护', 713718642843590656, '1', 1, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (714425029546483712, '0203', 1450764807862095885, '岗位审核', 714424558668750848, '1', 8, 1450756958461300737, '2023-05-26 10:30:00', 1450756958461300737, '2023-05-26 11:01:14', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (714488057633710080, '0204', 1450764807862095884, '组织角色审核', 714487572214325248, '1', 4, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (714488196960100352, '0205', 1450764807862095884, '岗位角色审核', 714487820982689792, '1', 5, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (714498812294733824, '0206', 523198001884438528, '用户组织审核', 714498499575816192, '1', 4, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (714503247842516992, '0207', 523198001884438528, '用户岗位审核', 714503076626833408, '1', 5, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (729285499054989312, '0201', 686146937447260160, '分组管理', 729285380519763968, '1', 3, 1450756958461300737, '2023-07-06 10:40:13', 1450756958461300737, '2023-07-06 10:40:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (734833871224578048, '0202', 523209654097158144, '工作台banner', 734833718094733312, '1', 6, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (735799387355357184, '0203', 523209654097158144, '组件库维护', 735798877248299008, '1', 7, 1450756958461300737, '2023-07-24 10:04:04', 1450756958461300737, '2023-07-24 10:34:08', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (738862378363658240, '0201', 738862247950163968, '新闻资讯维护', 738861725461520384, '1', 1, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (738862450065285120, '0202', 738862247950163968, '新闻资讯列表', 738861909880872960, '1', 2, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (738864017908703232, '0203', 526077391123259392, '通知更多', 738863554568134656, '1', 1, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (738864188277137408, '0204', 526077391123259392, '消息更多', 738863796810162176, '1', 2, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (811595871216214016, '000000000254', 811595767054868480, '通讯录', 811594293004476416, '0', 1, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (813348971400667136, '000000000254', 811595767054868480, '标签管理', 813348818371485696, '0', 2, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (825443949341843456, '000000000254', 686146937447260160, '个人环境管理', 825443817938493440, '0', 4, 679338378499727360, '2024-03-27 18:59:34', 679338378499727360, '2024-04-03 16:44:24', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (846427189661671424, '000000000255', 523215083967619072, '环境管理', 846426754422939648, '0', 11, 844891795166076928, '2024-05-24 16:39:28', 844891795166076928, '2024-05-24 16:39:28', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095892, '', 1450764807862095885, '机构维护', 1450765592889004198, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095893, '', 1450764807862095873, '我的传阅', 1450765592889004145, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:48', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095895, '', 523217792733028352, '性能监控', 1450765592889004388, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:36', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095898, '', 523215142994059264, '审计日志', 1450765592889004351, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095900, '', 523215083967619072, '解冻密码', 1450765592889004354, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095901, '', 523213321676267520, '资源管理', 1450765592889004220, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:05:43', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095902, '', 1450764807862095885, '类型定义', 1450765592889004075, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095904, '', 1450764807862095873, '我的催办', 1450765592889004453, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:38', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095908, '', 523198001884438528, '用户维护', 1450765592889004186, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:03:24', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095909, '', 1450764807862095884, '角色维护', 1450765592889004045, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:39', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095910, '0225', 523213321676267520, '功能管理', 1450765592889004239, '1', 6, NULL, '2021-06-21 14:33:49', 1450756958461300737, '2021-06-21 14:33:49', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095911, '', 523215083967619072, '重置密码', 1450765592889004407, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095913, '', 523215083967619072, '字典管理', 1450765592889004187, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095915, '', 1450764807862095885, '机构审核', 1450765592889004141, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095917, '', 523215314100690944, '可视化设计器', 1450765592889004274, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:47:02', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095920, '', 523215114078527488, '慢SQL诊断', 1450765592889004293, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095921, '', 523209654097158144, '菜单配置', 1450765592889004395, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095922, '', 1450764807862095885, '规则定义', 1450765592889004167, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095923, '', 523198001884438528, '用户审核', 1450765592889004179, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:05:08', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095924, '', 1450764807862095875, '任务管理', 1450765592889004226, '1', 4, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095925, '', 523215114078527488, '系统监控', 1450765592889004146, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095927, '', 523215114078527488, '在线用户', 1450765592889004414, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095928, '', 523209654097158144, '快捷功能配置', 1450765592889004507, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095929, '', 523215142994059264, '日志下载', 1450765592889004515, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095930, '', 1450764807862095885, '人员审核', 1450765592889004454, '1', 6, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095931, '', 1450764807862095885, '人员管理', 1450765592889004148, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095933, '', 1450764807862095875, '函数管理', 1450765592889004356, '1', 5, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095934, '', 523213802016350208, '自定义编码规则', 1450765592889004347, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095935, '', 1450764807862095873, '已办任务', 1450765592889004240, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:31', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095936, '', 523215083967619072, '工作日维护', 1450765592889004325, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095937, '', 1450764807862095875, '流程管理', 1450765592889004085, '1', 2, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095938, '', 523209654097158144, '框架页配置', 1450765592889004517, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095939, '', 1450764807862095884, '用户角色审核', 1450765592889004112, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:55', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095940, '', 523209654097158144, '登录页配置', 1450765592889004334, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095941, '', 1450764807862095873, '我的委托', 1450765592889004268, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:55', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095942, '', 523217792733028352, '内容监控', 1450765592889004479, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:51', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095943, '', 1450764807862095875, '实例管理', 1450765592889004474, '1', 3, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095944, '', 523215142994059264, '在线历史记录', 1450765592889004495, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095945, '', 523213802016350208, '运行参数配置', 1450765592889004131, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095946, '', 1450764807862095884, '不相容角色集', 1450765592889004190, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:46', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095947, '', 1450764807862095873, '待办任务', 1450765592889004229, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:24', 1);
INSERT INTO `SYS_FUNCTIONS` VALUES (1450764807862095949, '', 523213802016350208, '授权信息', 1450765592889004114, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);

-- ----------------------------
-- Table structure for SYS_FUNCTION_MODULES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FUNCTION_MODULES`;
CREATE TABLE `SYS_FUNCTION_MODULES`  (
  `FUNCTION_MODULE_ID` bigint(20) NOT NULL COMMENT '功能模块ID',
  `FUNCTION_MODULE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模块名称',
  `FUNCTION_MODULE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模块编码',
  `PARENT_MODULE_ID` bigint(20) NULL DEFAULT NULL COMMENT '上级模块ID',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '模块排序',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `APPLICATION_ID` bigint(20) NULL DEFAULT 1 COMMENT '所属应用的id，默认1：属于统一权限平台自身数据',
  PRIMARY KEY (`FUNCTION_MODULE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能模块表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FUNCTION_MODULES
-- ----------------------------
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (521403976781144064, '统一待办', NULL, 1, 12, 1450756958461300737, '2021-12-09 19:13:15', 1450756958461300737, '2021-12-09 19:13:15', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523176320419766272, '组织权限中心', NULL, 1, 1, 1450756958461300737, '2021-12-14 16:35:55', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523198001884438528, '用户管理', NULL, 523176320419766272, 2, 1450756958461300737, '2021-12-14 18:02:04', 1450756958461300737, '2021-12-14 18:02:04', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523209654097158144, '门户配置中心', NULL, 1, 2, 1450756958461300737, '2021-12-14 18:48:22', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523213269419433984, '开发者中心', NULL, 1, 5, 1450756958461300737, '2021-12-14 19:02:44', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523213321676267520, '功能资源', NULL, 523176320419766272, 4, 1450756958461300737, '2021-12-14 19:02:57', 1450756958461300737, '2021-12-14 19:02:57', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523213802016350208, '系统参数', NULL, 523213269419433984, 3, 1450756958461300737, '2021-12-14 19:04:51', 1450756958461300737, '2021-12-14 19:04:51', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523215032922939392, '运维监控中心', NULL, 1, 6, 1450756958461300737, '2021-12-14 19:09:45', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523215083967619072, '运维工具', NULL, 523215032922939392, 1, 1450756958461300737, '2021-12-14 19:09:57', 1450756958461300737, '2021-12-14 19:09:57', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523215114078527488, '平台监控', NULL, 523215032922939392, 2, 1450756958461300737, '2021-12-14 19:10:04', 1450756958461300737, '2021-12-14 19:10:04', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523215142994059264, '平台日志', NULL, 523215032922939392, 3, 1450756958461300737, '2021-12-14 19:10:11', 1450756958461300737, '2021-12-14 19:10:11', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523215314100690944, '可视化设计器', NULL, 1, 4, 1450756958461300737, '2021-12-14 19:10:52', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (523217792733028352, '缓存监控', NULL, 523215114078527488, 1, 1450756958461300737, '2021-12-14 19:20:43', 1450756958461300737, '2021-12-14 19:20:43', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (526077391123259392, '公告', NULL, 1, 11, 1450756958461300737, '2021-12-22 16:43:44', 1450756958461300737, '2021-12-22 16:43:44', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (528155915363557376, '统一待办', NULL, 523213269419433984, 4, NULL, '2021-12-28 10:23:03', NULL, '2021-12-28 10:23:03', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (545564987515740160, '统一日志', NULL, 523215142994059264, 13, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (576395008970858496, '消息中心', NULL, 1, 13, 1450756958461300737, '2022-05-10 13:07:59', 1450756958461300737, '2022-05-10 13:07:59', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (576447319827030016, '短信推送', NULL, 576395008970858496, 1, 1450756958461300737, '2022-05-10 16:35:51', 1450756958461300737, '2022-05-10 16:35:51', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (577911145198002176, '邮件推送', NULL, 576395008970858496, 2, 1450756958461300737, '2022-05-14 17:32:34', 1450756958461300737, '2022-05-14 17:32:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (578225558232768512, '微信公众号推送', NULL, 576395008970858496, 3, 1450756958461300737, '2022-05-15 14:21:56', 1450756958461300737, '2022-05-15 14:21:56', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (579402387463348224, 'IM推送', NULL, 576395008970858496, 4, 1450756958461300737, '2022-05-18 20:18:14', 1450756958461300737, '2022-05-18 20:18:14', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (579407339665498112, 'APP通知推送', NULL, 576395008970858496, 5, 1450756958461300737, '2022-05-18 20:37:55', 1450756958461300737, '2022-05-18 20:37:55', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (587696011380793344, '流程分析', NULL, 1450764807862095875, 1, 1450756958461300737, '2022-06-10 17:34:08', 1450756958461300737, '2022-06-10 17:34:08', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (587709613621911552, '内部通知推送', NULL, 576395008970858496, 6, 1450756958461300737, '2022-06-10 18:28:11', 1450756958461300737, '2022-06-10 18:28:11', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (592400770314543104, '日志告警', NULL, 523215114078527488, 2, 1450756958461300737, '2022-06-23 09:09:10', 1450756958461300737, '2022-06-23 09:09:10', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (595572248216346624, '移动门户配置', NULL, 523209654097158144, 1, 1450756958461300737, '2022-07-02 11:11:29', 1450756958461300737, '2022-07-02 11:11:29', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (596353922000756736, '应用管理', NULL, 576395008970858496, 7, 1450756958461300737, '2022-07-04 14:57:35', 1450756958461300737, '2022-07-04 14:57:35', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (641243779856343040, '数据迁移', NULL, 523215032922939392, 4, 1450756958461300737, '2022-11-05 11:53:51', 1450756958461300737, '2022-11-05 11:53:51', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (686146937447260160, '应用管理', NULL, 1, 14, 1450756958461300737, '2023-03-09 09:42:58', 1450756958461300737, '2023-03-09 09:42:58', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (686176268227715072, '企业微信推送', NULL, 576395008970858496, 8, 1450756958461300737, '2023-03-09 11:39:31', 1450756958461300737, '2023-03-09 11:39:31', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (697761878826557440, '钉钉推送', NULL, 576395008970858496, 9, 1450756958461300737, '2023-04-10 10:56:36', 1450756958461300737, '2023-04-10 10:56:36', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (738862247950163968, '新闻资讯', NULL, 1, 15, 1450756958461300737, '2023-08-01 20:54:47', 1450756958461300737, '2023-08-01 20:54:47', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (811595767054868480, '联系人管理', NULL, 576395008970858496, 10, 1450756958461300737, '2024-02-18 13:51:50', 1450756958461300737, '2024-02-18 13:51:50', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (1450764807862095873, '个人事项', '', 1, 9, NULL, NULL, 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (1450764807862095875, '流程中心', '', 1, 3, NULL, '2021-06-20 14:30:57', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (1450764807862095884, '角色管理', '', 523176320419766272, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO `SYS_FUNCTION_MODULES` VALUES (1450764807862095885, '组织机构', '', 523176320419766272, 1, NULL, NULL, NULL, NULL, 1);

-- ----------------------------
-- Table structure for SYS_FUNCTION_RESOURCES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_FUNCTION_RESOURCES`;
CREATE TABLE `SYS_FUNCTION_RESOURCES`  (
  `SFR_ID` bigint(20) NOT NULL COMMENT '主键',
  `FUNCTION_ID` bigint(20) NOT NULL COMMENT '功能id',
  `RESOURCE_ID` bigint(20) NOT NULL COMMENT '资源id',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`SFR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能资源关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_FUNCTION_RESOURCES
-- ----------------------------
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (32237820183288250, 518460834717114368, 518451664789970944, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (103839703909204940, 608974847288287232, 608974704010862592, 1450756958461300737, '2022-08-08 11:21:18', 1450756958461300737, '2022-08-08 11:21:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (120507322691962850, 1450764807862095909, 1450765592889004566, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (138426341898569840, 1450764807862095909, 654426928039862272, 1450756958461300737, '2022-12-11 20:59:25', 1450756958461300737, '2022-12-11 20:59:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (163060532147892830, 1450764807862095908, 1450765592889004060, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (214974206552515740, 1450764807862095909, 1450765592889004452, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (236330564504039000, 1450764807862095901, 1450765592889004397, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (246336600208762600, 578179328681189376, 577951935202861056, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:18:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (272000448824307070, 1450764807862095901, 1450765592889004465, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (294649254804114900, 1450764807862095908, 1450765592889004069, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (297370733459590800, 1450764807862095944, 1450765592889004175, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (297800635119875200, 1450764807862095925, 1450765592889004146, NULL, '2021-06-23 06:12:11', NULL, '2021-06-23 06:12:11');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (299149563277391300, 1450764807862095923, 1450765592889004406, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (300339249092257150, 1450764807862095913, 1450765592889004187, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (318047442350762900, 1450764807862095901, 1450765592889004404, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (339192713332864260, 578225680442204160, 578225070686871552, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (371741593868574400, 1450764807862095901, 638042415412027392, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (422025399679930100, 738862450065285120, 738861909880872960, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (434508535904026400, 641243926136889344, 641241962678329344, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (466427385931388540, 1450764807862095909, 1450765592889004364, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (491440583011017540, 1450764807862095892, 1585912363104722950, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (494169743728983600, 1450764807862095908, 1450765592889004152, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (508885334026323100, 1450764807862095908, 1450765592889004059, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (539874850424709500, 1450764807862095946, 1450765592889004092, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (550577406580406800, 729285499054989312, 729285380519763968, 1450756958461300737, '2023-07-06 10:40:13', 1450756958461300737, '2023-07-06 10:40:13');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (575357532137176200, 1450764807862095892, 1450765592889004295, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (610834561866679300, 1450764807862095933, 1450765592889004356, NULL, '2021-06-23 06:40:33', NULL, '2021-06-23 06:40:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (621819116948449000, 1450764807862095927, 1450765592889004414, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (623711529299158700, 581437221161410560, 581434937987833856, NULL, '2022-05-24 11:03:56', NULL, '2022-05-24 11:03:56');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (642422504664865500, 1450764807862095921, 1450765592889004487, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (652571499685910000, 714488057633710080, 714487572214325248, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (661080598474130600, 1450764807862095900, 1450765592889004354, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (690446705260763500, 1450764807862095919, 1450765592889004065, NULL, '2021-09-26 11:12:43', NULL, '2021-09-26 11:12:43');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (721537806603650200, 1450764807862095892, 1585912363037614086, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (724576808453237800, 697762540020834304, 697761494317932544, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046465, 686147054220877824, 1594592180406689798, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046466, 686147054220877824, 1594592180406689799, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046467, 686147054220877824, 1594592180406689800, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046468, 686147054220877824, 1594592180406689801, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046469, 686147054220877824, 1594592180406689802, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046470, 686147054220877824, 1594592180406689803, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (757637280986046471, 686147054220877824, 1594592180406689804, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (759512770441751700, 1450764807862095901, 1450765592889004101, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (778696738678466700, 1450764807862095909, 1450765592889004433, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (811595871555952640, 811595871216214016, 811594293004476416, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (813348971945926656, 813348971400667136, 813348818371485696, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (815322049257875000, 1450764807862095909, 1450765592889004311, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (827946650596286464, 825443949341843456, 825443817938493440, 679338378499727360, '2024-04-03 16:44:24', 679338378499727360, '2024-04-03 16:44:24');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (841733583395585000, 1450764807862095909, 651119173271035904, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (846427193759506432, 846427189661671424, 846426754422939648, 844891795166076928, '2024-05-24 16:39:29', 844891795166076928, '2024-05-24 16:39:29');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (893715496294441100, 1450764807862095910, 1450765592889004239, NULL, '2021-06-23 05:47:40', NULL, '2021-06-23 05:47:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (908518490049388200, 641243926136889344, 657533259068219399, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (919415598507028000, 526077556152344576, 1450765592889004265, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (925046692895840500, 1450764807862095901, 1450765592889004309, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (960313442635173100, 641244024103247872, 657533259068219502, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (970684485714062500, 1450764807862095930, 1594592180406689793, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1024720445140427000, 1450764807862095901, 638045114752835584, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1024815990010686600, 1450764807862095892, 1450765592889004208, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1036890509374718700, 520236482527764480, 520236254294712320, 1450756958461300737, '2021-12-06 13:55:31', 1450756958461300737, '2021-12-06 13:55:31');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1055495791568105300, 713719009941659648, 713718642843590656, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1059682632397965300, 1450764807862095930, 1594592180326998018, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1059776616727542100, 1450764807862095892, 1585912363104722951, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1093900356360513200, 688350053471100928, 688348921973710848, 1450756958461300737, '2023-03-15 14:05:19', 1450756958461300737, '2023-03-15 14:05:19');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1127718932569314000, 1450764807862095892, 651120420518633472, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1146973097038787500, 1450764807862095937, 1450765592889004085, NULL, '2021-06-23 06:39:32', NULL, '2021-06-23 06:39:32');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1179074570130030800, 1450764807862095917, 1450765592889004274, NULL, '2021-08-31 16:20:43', NULL, '2021-08-31 16:20:43');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1183947773569380600, 1450764807862095931, 1450765592889004193, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1212672447438331000, 1450764807862095908, 1450765592889004440, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1326980394770590500, 1450764807862095923, 1450765592889004338, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1330650432024310800, 1450764807862095923, 1450765592889004213, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1422356362072164600, 1450764807862095934, 1450765592889004200, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1463283875112255000, 1450764807862095908, 1592792289514672132, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1465083453944791800, 577920176742473728, 577920052196810752, 1450756958461300737, '2022-05-15 11:13:59', 1450756958461300737, '2022-05-15 11:13:59');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1508557304661880000, 1450764807862095901, 1450765592889004544, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1510738435591924000, 1450764807862095902, 1450765592889004526, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1534132577012168200, 1450764807862095938, 1450765592889004517, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1535231780077067500, 1450764807862095901, 1450765592889004252, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1540487633956854800, 1450764807862095908, 1592792289514672136, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1541761665124456700, 526356620901621760, 526356511056994304, 1450756958461300737, '2021-12-23 11:13:18', 1450756958461300737, '2021-12-23 11:13:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1586597950604691000, 1450764807862095908, 1592792289514672133, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1598059929234802000, 1450764807862095902, 1450765592889004434, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1602700320237974300, 1450764807862095931, 1592792289447563267, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1609518816656995000, 1450764807862095909, 1450765592889004555, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1611428150808649200, 1450764807862095895, 1450765592889004258, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1623971115387953400, 1450764807862095927, 1450765592889004150, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1641743113031370800, 1450764807862095901, 1450765592889004567, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1651541065029988400, 686178119287316480, 686174839412891648, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1665473748921275000, 1450764807862095928, 1450765592889004507, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1702621000111275000, 1450764807862095930, 1450765592889004169, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1722420405944111400, 521404105277841408, 521403853758013440, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1760159323208247800, 1450764807862095909, 1450765592889004045, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1761078680350173000, 1450764807862095915, 1585912363104722958, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1764871510999710700, 641243926136889344, 657533259068219400, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1766802248873239600, 1450764807862095908, 1592792289514672139, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1794950929770545200, 1450764807862095909, 1450765592889004143, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1815740593570076000, 1450764807862095892, 1585912363104722948, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1816566663599248600, 1450764807862095901, 1450765592889004214, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1847283721174466000, 735799387355357184, 735798877248299008, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1855419488169778700, 1450764807862095923, 1450765592889004477, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1877268305086430700, 1450764807862095908, 1594592180469604356, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1892238538100658700, 1450764807862095936, 1450765592889004105, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1892684453589602300, 1450764807862095901, 1450765592889004460, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1897763020833517800, 1450764807862095931, 1450765592889004427, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1919847628360864300, 1450764807862095892, 1585912363037614083, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1935980527337025300, 1450764807862095901, 1450765592889004485, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1936536466301772800, 1450764807862095931, 1450765592889004510, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1949550274764263400, 706807627035975680, 706807241717850112, 707960023090995203, '2023-05-05 10:01:10', 707960023090995203, '2023-05-05 10:01:10');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1953231193054883000, 1450764807862095931, 1592792289447563269, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1971658812158312200, 1450764807862095909, 1450765592889004211, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1983410821071978500, 1450764807862095909, 1450765592889004237, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1984480780663197200, 1450764807862095938, 1450765592889004119, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (1994563151592332300, 1450764807862095908, 1592792289514672130, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2001752727345160200, 1450764807862095895, 1450765592889004088, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2030370999913044500, 1450764807862095892, 1585912363104722952, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2031345137601169000, 596354099289792512, 596353576553684992, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2046939736589787000, 1450764807862095892, 1585912363104722953, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2049273485948358000, 1450764807862095944, 1450765592889004495, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2053750865712595000, 1450764807862095901, 1450765592889004218, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2055963100124195000, 1450764807862095931, 1450765592889004148, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2079261246918037200, 1450764807862095936, 1450765592889004462, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2108797039676104200, 1450764807862095909, 1450765592889004503, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2136423814104587500, 1450764807862095942, 1450765592889004482, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2143435087777804300, 1450764807862095945, 1450765592889004263, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2171968905502825500, 1450764807862095936, 1450765592889004371, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2193320752628304100, 545565036773646336, 545564853264457728, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2203063968551473700, 1450764807862095936, 1450765592889004556, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2242213708910559500, 578180115675226112, 578180013862690816, 1450756958461300737, '2022-05-22 10:39:31', 1450756958461300737, '2022-05-22 10:39:31');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2247825399754617000, 1450764807862095908, 1450765592889004305, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2254196369901174000, 1450764807862095908, 1450765592889004082, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2261349797125141500, 1450764807862095902, 1450765592889004469, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2277101967303453700, 1450764807862095901, 1450765592889004292, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2350991115796637000, 1450764807862095892, 1450765592889004198, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2355149980597098000, 1450764807862095931, 1592792289447563272, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2379462716057134000, 1450764807862095892, 1585912363104722945, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2380387672070323700, 1450764807862095930, 1594592180406689795, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2399846630984819700, 578225803503083520, 578225470362099712, 1450756958461300737, '2022-05-15 14:22:55', 1450756958461300737, '2022-05-15 14:22:55');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2405765205128211500, 1450764807862095934, 1450765592889004493, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2466599334579421700, 1450764807862095892, 1585912363037614084, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2469917820659567600, 1450764807862095930, 1594592180406689794, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2492898248283624400, 1450764807862095892, 1585912363037614082, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2551110856072753000, 1450764807862095902, 1450765592889004332, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2581174052246643700, 1450764807862095934, 1450765592889004347, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2613100450870835000, 581436854533103616, 581431768348106752, NULL, '2022-05-24 11:02:29', NULL, '2022-05-24 11:02:29');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2639040774009679000, 1450764807862095922, 1450765592889004499, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2639106464661535000, 1450764807862095949, 1450765592889004416, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2675691861322455000, 1450764807862095892, 1450765592889004053, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2763711700881510000, 1450764807862095895, 1450765592889004115, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2790413979090824000, 1450764807862095946, 1450765592889004190, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2810431123129526000, 1450764807862095945, 1450765592889004131, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2845395767090039300, 588042975440019456, 588042819223166976, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2849541863202725000, 1450764807862095908, 1450765592889004160, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2873446997914837000, 581437297606795264, 581435215210356736, NULL, '2022-05-24 11:04:14', NULL, '2022-05-24 11:04:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2875241465125512000, 1450764807862095921, 1450765592889004297, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2892294995399143400, 641243926136889344, 657533259068219398, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2903139567504489000, 1450764807862095908, 1592792289514672143, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2910762183986358000, 1450764807862095909, 1450765592889004330, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (2926712170783723500, 1450764807862095927, 1450765592889004201, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3004160705449305600, 1450764807862095931, 1450765592889004181, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3018331592764750000, 641243926136889344, 657533259068219403, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3027745323871259000, 1450764807862095929, 1450765592889004285, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3059897388336372700, 1450764807862095936, 1450765592889004151, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3070615836658059300, 1450764807862095913, 1450765592889004286, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3134161000793497000, 1450764807862095892, 1585912363104722955, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3202338602762828000, 546347915988443136, 546346988292284416, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3271590496898312700, 1450764807862095921, 1450765592889004357, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3305574599699156500, 1450764807862095931, 1592792289447563266, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3323187159654631400, 1450764807862095930, 1450765592889004454, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3337785656271825000, 1450764807862095895, 1450765592889004545, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3342881980036192000, 1450764807862095923, 1450765592889004179, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3375109022411019000, 544475707963875328, 544474404047036416, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3394135695792329000, 1450764807862095908, 1450765592889004411, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3409225707786483700, 1450764807862095908, 665490432775692288, 1450756958461300737, '2023-05-08 11:38:45', 1450756958461300737, '2023-05-08 11:38:45');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3410009148122974700, 526077556152344576, 677910413299687424, 1450756958461300737, '2023-02-14 16:13:57', 1450756958461300737, '2023-02-14 16:13:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3415638094144259000, 1450764807862095939, 1450765592889004112, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3417138352541431000, 1450764807862095892, 643045022819950592, 1450756958461300737, '2022-11-10 11:11:59', 1450756958461300737, '2022-11-10 11:11:59');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3418857910558641700, 1450764807862095892, 1450765592889004342, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3430456294464035300, 1450764807862095936, 1450765592889004224, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3431550087968561000, 1450764807862095934, 1450765592889004509, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3452467247224488400, 1450764807862095946, 1450765592889004188, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3456659651549261300, 522705551881412608, 522705027572441088, 1450756958461300737, '2021-12-14 14:57:33', 1450756958461300737, '2021-12-14 14:57:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3471488454024111000, 1450764807862095923, 1450765592889004168, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3474746363408496000, 579407499330068480, 579406782007615488, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3488519505439757300, 578225755054678016, 578225260298772480, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3505141127397854000, 576447488295444480, 576445297899872256, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3514213070613710000, 641244024103247872, 657533259068219395, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3546198106165265400, 1450764807862095901, 1450765592889004572, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3547068516515780600, 1450764807862095895, 1450765592889004482, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3555724846944758300, 1450764807862095936, 1450765592889004061, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3572596697533797000, 1450764807862095901, 1450765592889004247, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3587792538161952000, 1450764807862095949, 1450765592889004114, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3589446535123804000, 1450764807862095943, 1450765592889004474, NULL, '2021-06-23 06:39:44', NULL, '2021-06-23 06:39:44');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3597641265790758000, 641244024103247872, 657533259068219501, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3655814096027428400, 673553074966765568, 673551263069380608, 1450756958461300737, '2023-02-02 16:21:38', 1450756958461300737, '2023-02-02 16:21:38');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3670961758260140000, 1450764807862095920, 1450765592889004293, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3716421673354175500, 1450764807862095913, 1450765592889004382, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3732572515607218700, 576447430137225216, 576444545517232128, 1450756958461300737, '2022-05-13 20:15:33', 1450756958461300737, '2022-05-13 20:15:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3742774354435161600, 1450764807862095929, 1450765592889004461, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3748595416472010000, 581437337255550976, 581435962006183936, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3780467269874520600, 1450764807862095909, 1450765592889004443, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3781178502812923000, 738862378363658240, 737341598572224512, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3789118980178759700, 1450764807862095921, 1450765592889004257, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3809106649826042000, 544469147921424384, 544468972511436800, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3818813244593985500, 1450764807862095931, 1450765592889004118, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3825440368558890500, 578179104113958912, 578178840069939200, 1450756958461300737, '2022-05-15 11:17:21', 1450756958461300737, '2022-05-15 11:17:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3863961531827612700, 1450764807862095892, 1450765592889004502, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3875512243111428000, 1450764807862095892, 1585912363104722946, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3882497652435606500, 1450764807862095908, 1450765592889004261, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3885274097593552000, 697762455014875136, 697761225484017664, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3892889728906122000, 714503247842516992, 714503076626833408, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3896273664635517000, 641243926136889344, 657533259068219401, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3919369046349748000, 1450764807862095901, 1450765592889004147, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3924859900707897000, 1450764807862095931, 1592792289447563274, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3978095210430011400, 1450764807862095901, 1450765592889004039, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3980414475721390600, 1450764807862095931, 1592792289447563270, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (3997485965338456600, 1450764807862095908, 1450765592889004283, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4002368119826934300, 1450764807862095921, 1450765592889004087, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4009278443153617000, 697762187867070464, 697759569409220608, 1450756958461300737, '2023-04-10 10:58:05', 1450756958461300737, '2023-04-10 10:58:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4033234240426174000, 1450764807862095921, 1450765592889004138, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4034857885755173400, 523555260388876288, 523554762252361728, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4035590223857203700, 1450764807862095923, 1450765592889004401, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4079944889739185700, 1450764807862095893, 1450765592889004145, NULL, '2021-06-23 06:14:22', NULL, '2021-06-23 06:14:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4081332833452350000, 738862378363658240, 738861725461520384, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4151834519846344000, 1450764807862095936, 1450765592889004325, NULL, '2021-06-23 06:04:20', NULL, '2021-06-23 06:04:20');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4154471216289108000, 641244024103247872, 641241760202498048, 1450756958461300737, '2022-11-05 14:02:42', 1450756958461300737, '2022-11-05 14:02:42');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4159744505923209700, 576447721767182336, 576446061217062912, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4164526487273307000, 1450764807862095931, 1592792289447563268, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4173951114598774000, 1450764807862095921, 1450765592889004047, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4179567030624378000, 1450764807862095936, 1450765592889004066, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4188983321143105500, 1450764807862095936, 1450765592889004466, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4200131811592521700, 1450764807862095898, 1450765592889004457, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4227335736397070000, 1450764807862095908, 1592792289514672134, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4228502463736115000, 1450764807862095942, 1450765592889004115, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4257282040156218400, 582661445364490240, 582661309611646976, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4258920424145072600, 1450764807862095901, 1450765592889004565, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4308021991970837500, 1450764807862095892, 1450765592889004521, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4316568325108646000, 1450764807862095941, 1450765592889004268, NULL, '2021-06-23 06:39:19', NULL, '2021-06-23 06:39:19');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4327413024116248000, 1450764807862095929, 1450765592889004515, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4334206056907582500, 1450764807862095946, 1450765592889004136, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4349178580745831000, 1450764807862095909, 642061362138456064, NULL, '2022-11-07 18:02:38', NULL, '2022-11-07 18:02:38');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4355312469684564000, 1450764807862095909, 1450765592889004080, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4375738080934397000, 1450764807862095909, 1450765592889004171, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4380869385156113000, 1450764807862095892, 1450765592889004180, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4413676370924454000, 1450764807862095908, 1592792289514672131, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4421242331761905000, 641243926136889344, 657533259068219406, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4429800302236255700, 641244024103247872, 657533259068219394, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4451344080343822000, 576447666205237248, 576445901988700160, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4470818163916753400, 1450764807862095920, 1450765592889004513, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4485649434350541000, 1450764807862095945, 1450765592889004042, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4488231002449490400, 1450764807862095909, 1450765592889004422, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4511432183335675400, 1450764807862095929, 1450765592889004522, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4532507165374261000, 1450764807862095940, 1450765592889004334, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4542974900865503000, 1450764807862095913, 1450765592889004178, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4559897181492803000, 1450764807862095908, 1592792289514672144, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4563519735709766700, 1450764807862095913, 1450765592889004277, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4576799101076076000, 1450764807862095892, 1450765592889004363, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4599933527961134600, 1450764807862095908, 1450765592889004348, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4661488089173200000, 1450764807862095902, 1450765592889004075, NULL, '2021-06-23 05:39:59', NULL, '2021-06-23 05:39:59');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4687047599491193000, 1450764807862095901, 1450765592889004156, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4730137761740278000, 1450764807862095895, 1450765592889004182, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4746012102747882000, 526077556152344576, 526077294431969280, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4835048994508317000, 1450764807862095892, 1450765592889004564, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4848715528255667000, 1450764807862095901, 1450765592889004329, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4877510692375325000, 1450764807862095908, 1592792289514672141, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4880598817213345000, 1450764807862095909, 1450765592889004333, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4885699579821889000, 1450764807862095946, 1450765592889004259, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4915610029454931000, 1450764807862095931, 1592792289372065793, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4944954171612911000, 546343149988225024, 546343017720848384, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4979109948089132000, 1450764807862095895, 1450765592889004479, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (4994826914933570000, 1450764807862095929, 1450765592889004067, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5022396851955762000, 714488196960100352, 714487820982689792, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5074963679667732000, 1450764807862095909, 1450765592889004472, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5083358887821602000, 1450764807862095913, 1450765592889004530, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5118955034316991000, 544475799542308864, 544475544734146560, 1450756958461300737, '2022-02-11 11:12:27', 1450756958461300737, '2022-02-11 11:12:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5119290133561532000, 1450764807862095892, 1450765592889004508, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5124600442603036000, 1450764807862095908, 1450765592889004186, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5134544632455492000, 1450764807862095895, 1450765592889004470, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5146478234549692000, 581437337255550977, 586205441340743680, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5166634273131023000, 738864017908703232, 738863554568134656, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5200507840943897000, 1450764807862095901, 1450765592889004473, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5203434114666971000, 1450764807862095913, 1450765592889004421, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5208171966855981000, 1450764807862095915, 1585912363104722960, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5279185567531117000, 1450764807862095909, 1450765592889004269, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5315053896876473000, 1450764807862095922, 1450765592889004270, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5327192801078872000, 1450764807862095908, 1594592180406689797, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5378786281442386000, 1450764807862095913, 1450765592889004310, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5386981152578304000, 1450764807862095927, 1450765592889004558, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5410124374581111000, 526077556152344576, 677910643386621952, 1450756958461300737, '2023-02-14 16:14:52', 1450756958461300737, '2023-02-14 16:14:52');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5437011344041815000, 1450764807862095945, 1450765592889004091, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5467505651327609000, 581437382767943681, 581436516656750592, NULL, '2022-05-24 11:04:35', NULL, '2022-05-24 11:04:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5495945351530107000, 579407703957577728, 579406956977201152, 1450756958461300737, '2022-05-18 20:39:22', 1450756958461300737, '2022-05-18 20:39:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5497885378355284000, 579402651498979328, 579402283595603968, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5537901247811356000, 1450764807862095913, 1450765592889004207, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5539196970889990000, 1450764807862095921, 1450765592889004437, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5566067783870530000, 578179275791015936, 577951711264776192, 1450756958461300737, '2022-05-15 14:02:19', 1450756958461300737, '2022-05-15 14:02:19');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5579798555817354000, 1450764807862095909, 1450765592889004432, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5592373173119617000, 577911233693622272, 577910957540646912, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5602501897192188000, 1450764807862095942, 1450765592889004470, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5614233490237816000, 641244024103247872, 657533259068219503, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5630037020813018000, 1450764807862095946, 1450765592889004339, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5653802213703863000, 587709734606610432, 587709219764183040, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5687797329544180000, 581436941229367296, 581432525403201536, NULL, '2022-05-24 11:02:49', NULL, '2022-05-24 11:02:49');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5738884712946972000, 641243926136889344, 657533259068219404, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5753118426347250000, 1450764807862095921, 1450765592889004395, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5770502655654679000, 579402568669863936, 579401699782041600, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5775284664514161000, 1450764807862095908, 1450765592889004571, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5775995092350120000, 576438008606367744, 576437892923269120, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5780367496094840000, 1450764807862095901, 1450765592889004488, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5810380497366262000, 587709681099874304, 587708514152226816, 1450756958461300737, '2022-06-10 18:28:27', 1450756958461300737, '2022-06-10 18:28:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5836318420422332000, 535768729024471040, 535768620278751232, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5893484724022913000, 1450764807862095909, 651116365914316800, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5903494431162094000, 579407434091864064, 579406581389860864, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5920334651818401000, 1450764807862095892, 1585912363037614085, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5932931091979795000, 1450764807862095923, 1450765592889004481, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5936510110699688000, 641243926136889344, 657533259068219405, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (5983524870074011000, 1450764807862095902, 1450765592889004378, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6029241791333300000, 1450764807862095892, 1585912363104722954, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6056936221124455000, 523555376986333184, 523555173533229056, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6058313304120828000, 1450764807862095946, 1450765592889004099, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6103173003479497000, 579402490307682304, 579400593928626176, 1450756958461300737, '2022-05-18 20:18:39', 1450756958461300737, '2022-05-18 20:18:39');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6126027114815556000, 1450764807862095892, 1450765592889004124, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6130125695772322000, 581436993427480576, 581434143087534080, NULL, '2022-05-24 11:03:02', NULL, '2022-05-24 11:03:02');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6133790374255563000, 1450764807862095909, 1450765592889004183, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6159300264044104000, 1450764807862095946, 1450765592889004317, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6165537920642976000, 1450764807862095931, 1450765592889004288, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6186062082179167000, 1450764807862095947, 1450765592889004229, NULL, '2021-06-23 06:13:45', NULL, '2021-06-23 06:13:45');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6194873429919035000, 738864188277137408, 738863796810162176, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6213297702754915000, 1450764807862095909, 1450765592889004516, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6254306082990807000, 581430666475085824, 564389067157151744, NULL, '2022-05-24 11:01:57', NULL, '2022-05-24 11:01:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6293763916192614000, 1450764807862095913, 1450765592889004212, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6312453972945452000, 578225632039936000, 578224814087741440, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6315047255856710000, 1450764807862095940, 1450765592889004119, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6343832864896635000, 714425029546483712, 714424558668750848, 1450756958461300737, '2023-05-26 11:01:14', 1450756958461300737, '2023-05-26 11:01:14');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6350019966416328000, 1450764807862095892, 1450765592889004161, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6403442468784465000, 1450764807862095901, 1450765592889004278, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6404024009937585000, 686178183690854400, 686175350430113792, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6404336320549082000, 1450764807862095900, 1450765592889004449, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6444057545505071000, 1450764807862095929, 1450765592889004235, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6452163899984276000, 1450764807862095901, 1450765592889004349, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6472680599435335000, 1450764807862095892, 1585912363104722947, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6479487786698256000, 1450764807862095921, 1450765592889004322, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6483501243502238000, 1450764807862095915, 1585912363104722957, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6484570126183945000, 1450764807862095945, 1450765592889004157, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6500307152796450000, 1450764807862095909, 1450765592889004512, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6519291138556986000, 734833871224578048, 734832488207360000, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6574268310044485000, 1450764807862095915, 1585912363104722959, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6580298633325908000, 1450764807862095915, 1450765592889004141, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6596951099630954000, 1450764807862095909, 1450765592889004281, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6611140817864900000, 1450764807862095901, 1450765592889004369, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6633164977338520000, 1450764807862095934, 1450765592889004445, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6639339325940522000, 641244024103247872, 657533259068219392, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6664171536439597000, 1450764807862095900, 1450765592889004413, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6666537997161930000, 1450764807862095898, 1450765592889004570, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6667030653375144000, 1450764807862095928, 1450765592889004119, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6686584550031459000, 1450764807862095921, 1450765592889004313, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6705684025738846000, 1450764807862095898, 1450765592889004351, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6717269891976873000, 1450764807862095892, 1450765592889004539, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6733810371215246000, 1450764807862095931, 1592792289447563273, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6770589361246581000, 1450764807862095935, 1450765592889004240, NULL, '2021-06-23 06:13:57', NULL, '2021-06-23 06:13:57');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6812247779918563000, 1450764807862095892, 1450765592889004394, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6851168973091814000, 1450764807862095901, 1450765592889004337, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6855754700695544000, 578179213245554688, 577951344581943296, 1450756958461300737, '2022-05-15 11:34:45', 1450756958461300737, '2022-05-15 11:34:45');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6858095515455579000, 1450764807862095901, 1450765592889004098, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6922950729674101000, 1450764807862095921, 1450765592889004120, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6978572709325975000, 1450764807862095892, 1585912363104722956, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6997203452672896000, 1450764807862095909, 1450765592889004062, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (6998904789688797000, 1450764807862095908, 1592792289514672138, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7035271792170924000, 641243926136889344, 657533259068219402, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7056570863506333000, 592391757124345856, 592391481915088896, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7067840957476540000, 1450764807862095945, 1450765592889004253, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7074915702170057000, 1450764807862095895, 1450765592889004403, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7141152941257222000, 1450764807862095915, 1450765592889004569, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7182817657769566000, 1450764807862095909, 1450765592889004368, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7193923514192867000, 1450764807862095946, 1450765592889004559, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7206064217642280000, 686147054220877824, 686146166286721024, 1450756958461300737, '2023-03-11 10:39:58', 1450756958461300737, '2023-03-11 10:39:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7228419466900020000, 1450764807862095931, 1450765592889004302, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7230387419835086000, 1450764807862095915, 1450765592889004486, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7256505380841301000, 1450764807862095909, 1450765592889004064, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7259306706210482000, 1450764807862095922, 1450765592889004167, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7276554236861184000, 1450764807862095931, 1592792289447563275, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7282220251011821000, 1450764807862095908, 1592792289514672140, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7283185533511604000, 526077556152344576, 1450765592889004432, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7295346128432285000, 1450764807862095929, 1450765592889004159, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7313600775117781000, 1450764807862095892, 1585912363104722961, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7316928202275750000, 641244024103247872, 657533259068219397, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7358975816373811000, 1450764807862095909, 1450765592889004144, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7362745921457370000, 1450764807862095931, 1592792289447563271, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7380330702691458000, 641244024103247872, 657533259068219396, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7385579669169596000, 1450764807862095909, 1450765592889004149, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7389982661807500000, 1450764807862095909, 1450765592889004391, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7394145152272608000, 1450764807862095909, 1450765592889004417, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7395345460225237000, 1450764807862095927, 1450765592889004456, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7412606610797002000, 734833871224578048, 734833718094733312, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7416473689547601000, 1450764807862095892, 1450765592889004134, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7457310851623937000, 686147191273955328, 686146454410240000, 1450756958461300737, '2023-03-11 10:40:12', 1450756958461300737, '2023-03-11 10:40:12');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7475121451587770000, 738862378363658240, 738862163959226368, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7492967573262157000, 1450764807862095946, 1450765592889004251, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7528114530474617000, 686178259356098560, 686175659781005312, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7545485682063677000, 1450764807862095931, 1450765592889004122, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7552550508999115000, 714498812294733824, 714498499575816192, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7559436617647481000, 1450764807862095901, 1450765592889004344, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7624259898376632000, 1450764807862095942, 1450765592889004258, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7626314151277643000, 1450764807862095946, 1450765592889004323, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7627685903194215000, 1450764807862095908, 1592792289514672135, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7649029061287673000, 1450764807862095909, 1450765592889004536, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7728658222107044000, 1450764807862095908, 1450765592889004121, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7796016520957238000, 1450764807862095909, 1450765592889004189, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7800586799341336000, 576448277533433856, 576425225089196032, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7827137275325588000, 735799387355357184, 735797215649603584, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7842911870199263000, 1450764807862095931, 1450765592889004089, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7848878822335752000, 1450764807862095901, 1450765592889004529, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7872406607107538000, 1450764807862095892, 1585912362983088129, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7877986980722596000, 1450764807862095913, 1450765592889004384, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7886632004074359000, 1450764807862095909, 1450765592889004206, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7888362631300701000, 1450764807862095923, 1450765592889004366, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7895079182739348000, 1450764807862095901, 1450765592889004052, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7899135802588070000, 1450764807862095904, 1450765592889004453, NULL, '2021-06-23 06:14:10', NULL, '2021-06-23 06:14:10');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7913802952827491000, 1450764807862095905, 1450765592889004221, NULL, '2021-06-23 06:12:26', NULL, '2021-06-23 06:12:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7926049218286810000, 641244024103247872, 657533259068219393, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (7938159816852189000, 1450764807862095913, 1450765592889004291, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8012986635398130000, 1450764807862095892, 1450765592889004199, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8014902152519676000, 587709787979128832, 587709399175536640, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8067857347671430000, 1450764807862095901, 1450765592889004307, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8094061504457990000, 1450764807862095908, 1450765592889004409, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8108511052112232000, 1450764807862095945, 1450765592889004551, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8118170614398197000, 1450764807862095909, 1450765592889004501, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8121326732469579000, 1450764807862095908, 1450765592889004222, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8159978062320227000, 1450764807862095934, 1450765592889004074, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8165649929085861000, 1450764807862095923, 1450765592889004037, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8178708544219443000, 1450764807862095901, 1450765592889004220, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8218994812766171000, 1450764807862095942, 1450765592889004182, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8229125286955673000, 592386778267394048, 592385945366700032, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8264447824536478000, 1450764807862095908, 1592792289514672142, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8313947228812567000, 576447608743272448, 576445740617048064, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8315259855418958000, 1450764807862095939, 1450765592889004519, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8330541447586468000, 1450764807862095892, 1585912363104722949, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8362261482291111000, 1450764807862095909, 1450765592889004204, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8414710152159558000, 1450764807862095908, 1450765592889004400, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8434139141342351000, 1450764807862095924, 1450765592889004226, NULL, '2021-06-23 06:40:15', NULL, '2021-06-23 06:40:15');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8439927452148045000, 1450764807862095892, 1450765592889004153, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8497553308423673000, 1450764807862095915, 1450765592889004390, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8504726317095393000, 1450764807862095942, 1450765592889004403, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8506041280497158000, 1450764807862095911, 1450765592889004407, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8508944291857246000, 1450764807862095911, 1450765592889004137, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8533345324068517000, 1450764807862095942, 1450765592889004545, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8534212407489383000, 697762370797445120, 697760877801381888, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8560989646778335000, 1450764807862095908, 1450765592889004533, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8587248683938692000, 1450764807862095936, 1450765592889004327, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8638460920863153000, 1450764807862095901, 1450765592889004230, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8650379455151402000, 579407758378672128, 579407194467082240, 1450756958461300737, '2022-05-18 20:39:35', 1450756958461300737, '2022-05-18 20:39:35');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8664349155821196000, 1450764807862095939, 1450765592889004173, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8681688362520987000, 1450764807862095942, 1450765592889004088, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8685902543222044000, 1450764807862095913, 1450765592889004563, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8704223561487048000, 1450764807862095939, 1450765592889004444, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8708869807021034000, 576447546457858048, 576445557296603136, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8710185231025143000, 1450764807862095934, 1450765592889004176, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8725110019329759000, 581437139125018624, 581434493471301632, NULL, '2022-05-24 11:03:37', NULL, '2022-05-24 11:03:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104081375053000, 1450764807862095892, 1450765592889004265, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087548157000, 1450764807862095892, 707290343955243008, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087548157001, 1450764807862095892, 707287408898778429, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087548157002, 1450764807862095892, 707288922094575616, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087548157003, 1450764807862095892, 707287408898744320, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856000, 1450764807862095908, 707291432628789248, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856001, 1450764807862095908, 707290869702897456, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856002, 1450764807862095908, 707291241079119872, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856003, 1450764807862095908, 707290869702860800, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856004, 1450764807862095913, 6069473931100219001, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856005, 1450764807862095913, 6069473931100219002, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856006, 1450764807862095913, 6069473931100219003, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856007, 1450764807862095913, 6069473931100219004, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856008, 1450764807862095892, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856009, 1450764807862095908, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8735104087574856010, 1450764807862095913, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8737063662919945000, 1450764807862095902, 1450765592889004546, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8752715398724330000, 1450764807862095908, 1592792289514672137, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8770056328260917000, 1450764807862095901, 1450765592889004410, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8785198093272620000, 1450764807862095921, 1450765592889004358, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8788881801441584000, 579987015375003648, 579986784054943744, 1450756958461300737, '2022-05-20 11:07:55', 1450756958461300737, '2022-05-20 11:07:55');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8863128065406379000, 1450764807862095892, 1450765592889004073, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8899633434905354000, 1450764807862095922, 1450765592889004383, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8918716561201663000, 1450764807862095901, 1450765592889004308, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8947485567372642000, 1450764807862095892, 1450765592889004223, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8954866636099882000, 1450764807862095922, 1450765592889004284, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO `SYS_FUNCTION_RESOURCES` VALUES (8982688618777375000, 686178312292409344, 686176030305820672, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38');

-- ----------------------------
-- Table structure for SYS_GET_BACK_PASSWORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_GET_BACK_PASSWORD`;
CREATE TABLE `SYS_GET_BACK_PASSWORD`  (
  `USER_ID` bigint(20) NOT NULL COMMENT '用户编码',
  `P_QUES` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '找密码的问题',
  `P_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '找密码的答案',
  PRIMARY KEY (`USER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '账户密码找回表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_GET_BACK_PASSWORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HAND_SIGN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HAND_SIGN`;
CREATE TABLE `SYS_HAND_SIGN`  (
  `BUSINESS_ID` bigint(20) NOT NULL COMMENT '主键id',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `IMAGE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '签名信息',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`BUSINESS_ID`) USING BTREE,
  UNIQUE INDEX `handwritten_signature_UN`(`USER_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HAND_SIGN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_API_NAMING
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_API_NAMING`;
CREATE TABLE `SYS_HE_API_NAMING`  (
  `API_ID` bigint(20) NOT NULL COMMENT 'API 短标识',
  `BUSINESS_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '业务类型标识',
  `BUSINESS_ID` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '全长业务标识',
  `SERVICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务服务ID',
  `SERVER_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点/编排类型',
  `SERVICE_NAME` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点/编排服务名',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '租户 ID',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据逻辑删除标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `IS_NEW_VERSION` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否新版本',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`API_ID`) USING BTREE,
  UNIQUE INDEX `idx_naming`(`BUSINESS_TYPE` ASC, `BUSINESS_ID` ASC, `TENANT_ID` ASC) USING BTREE,
  INDEX `idx_service_name`(`SERVICE_NAME` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HE_API_NAMING
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_BPM_SERVICE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_BPM_SERVICE`;
CREATE TABLE `SYS_HE_BPM_SERVICE`  (
  `SERVICE_ID` bigint(20) NOT NULL COMMENT '流程服务ID',
  `SERVICE_ACTION` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程服务动作',
  `ENGINE_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引擎name',
  `ENGINE_SERVICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '引擎业务id',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户id'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作流数据引擎' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_BPM_SERVICE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_CLASS_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_CLASS_INFO`;
CREATE TABLE `SYS_HE_CLASS_INFO`  (
  `CLASS_ID` bigint(20) NOT NULL COMMENT '类主键',
  `CLASS_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类名称',
  `CLASS_PATH` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类全路径',
  `CLASS_DESCRIPTION` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类描述',
  `IN_USE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否可用',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`CLASS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编译类信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_CLASS_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_CLASS_METHOD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_CLASS_METHOD`;
CREATE TABLE `SYS_HE_CLASS_METHOD`  (
  `METHOD_ID` bigint(20) NOT NULL COMMENT '方法主键',
  `METHOD_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法名称',
  `VERSION_ID` bigint(20) NULL DEFAULT NULL COMMENT '版本ID',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`METHOD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编译类方法信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_CLASS_METHOD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_CLASS_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_CLASS_VERSION`;
CREATE TABLE `SYS_HE_CLASS_VERSION`  (
  `VERSION_ID` bigint(20) NOT NULL COMMENT '版本ID',
  `CLASS_VERSION` int(11) NULL DEFAULT NULL COMMENT '版本',
  `CLASS_ID` bigint(20) NULL DEFAULT NULL COMMENT '类ID',
  `CLASS_PATH` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类的全路径',
  `CLASS_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类的类型',
  `IN_USE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否可用',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '编译类版本信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_CLASS_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_AUTOCONF
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_DATASERVICE_AUTOCONF`;
CREATE TABLE `SYS_HE_DATASERVICE_AUTOCONF`  (
  `CONFIG_ID` bigint(20) NOT NULL COMMENT '主键',
  `DATASERVICE_ID` bigint(20) NOT NULL COMMENT '数据服务ID',
  `COLUMN_ID` bigint(20) NOT NULL COMMENT '列ID',
  `TABLE_ID` bigint(20) NOT NULL COMMENT '表编号ID',
  `PUT_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '参数类型',
  `DIC_ID` bigint(20) NULL DEFAULT NULL COMMENT '特殊处理类型',
  `DICT_CODE` bigint(20) NULL DEFAULT NULL COMMENT '特殊处理方式',
  `INPUT_WHERE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '00：是更新条件输入',
  `COLUMN_ALIAS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出入参别名',
  `COLUMN_ALIAS_DEFINED` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '用户自定义出入参别名',
  `CONNECT_FLAG` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'WHERE字段连接条件(AND或OR)',
  `SORT` int(11) NULL DEFAULT NULL COMMENT '入参字段顺序',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `DATASOURCE_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`CONFIG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据服务自动化配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_AUTOCONF
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_SQL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_DATASERVICE_SQL`;
CREATE TABLE `SYS_HE_DATASERVICE_SQL`  (
  `SQL_ID` bigint(20) NOT NULL COMMENT '主键',
  `DATASERVICE_ID` bigint(20) NOT NULL COMMENT '数据服务ID',
  `DATASERVICE_SQL` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'SQL',
  `TABLE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名',
  `WHERE_SQL` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条件',
  `WHERE_CHILDREN` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '查询WHERE 嵌套条件信息',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `DATASOURCE_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`SQL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据服务配置SQL存储表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_SQL
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_DATASERVICE_TABLE`;
CREATE TABLE `SYS_HE_DATASERVICE_TABLE`  (
  `DATASERVICE_ID` bigint(20) NOT NULL COMMENT '数据服务ID',
  `DATASOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源ID',
  `MAPPER_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SQL方式',
  `DATASERVICE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据服务名称',
  `DATASERVICE_CHNAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据服务中文名称',
  `DATASERVICE_VERSION` bigint(20) NOT NULL COMMENT '服务版本号',
  `DATASERVICE_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据服务状态RN1：未配置（默认）RN2：已配置（可发布）RN3：已发布RN4：已升级（已升级的不可在升级）',
  `OPER_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置方式',
  `RESULT_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '返回类型，单条还是集合。00:单条,01:集合',
  `PAGE_SIZE` int(11) NULL DEFAULT NULL COMMENT '分页显示条数',
  `PAGINATION` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否支持分页RN0：否；1：是',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `DATASOURCE_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `RSV1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留1',
  `RSV2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留2',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '主从表模型ID',
  `MASTER_DATASERVICE_FALG` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1：主从表管理主表发布的数据服务标志',
  `TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '主从模型从表ID',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`DATASERVICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据服务配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_IMPLEMENTS_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_IMPLEMENTS_TABLE`;
CREATE TABLE `SYS_HE_IMPLEMENTS_TABLE`  (
  `IMP_ID` bigint(20) NOT NULL COMMENT '接口地址ID',
  `IMP_FLAG` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口标识',
  `IMP_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口名称',
  `SERVICE_ID` bigint(20) NOT NULL COMMENT '业务服务ID',
  `URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '访问地址',
  `REQUEST_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '访问方式',
  `IMP_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '接口版本号',
  `IMP_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口状态',
  `REMARK` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `UPT_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '更新版本号',
  `RSV1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留1',
  `RSV2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留2',
  `RELEASE_SOURCE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布来源：1-表管理；2-数据服务；3-业务服务',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`IMP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口地址配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_IMPLEMENTS_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_MASTERSLAVE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_MASTERSLAVE_MODEL`;
CREATE TABLE `SYS_HE_MASTERSLAVE_MODEL`  (
  `MODEL_ID` bigint(20) NOT NULL COMMENT '主键',
  `MODEL_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主子表模型名称',
  `MASTER_TABLEID` bigint(20) NULL DEFAULT NULL COMMENT '主表ID',
  `MASTER_TABLENAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主表表名',
  `MODEL_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模型状态：2-已配置；3-已发布',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `RSV1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '预留',
  `RSV2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '预留',
  `MODEL_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '回显',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`MODEL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '主从模型' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_MASTERSLAVE_MODEL
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_METADATA_DETAIL_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_METADATA_DETAIL_TABLE`;
CREATE TABLE `SYS_HE_METADATA_DETAIL_TABLE`  (
  `COLUMN_ID` bigint(20) NOT NULL COMMENT '列ID',
  `TABLE_ID` bigint(20) NOT NULL COMMENT '表编号ID',
  `COLUMN_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '列名称',
  `COLUMN_CHNAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '列中文名',
  `COLUMN_COMMENT` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '列描述',
  `COLUMN_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '列类型',
  `COLUMN_LENGTH` bigint(20) NOT NULL COMMENT '列长度',
  `POINT_LENGTH` int(11) NULL DEFAULT NULL COMMENT '列小数点',
  `IS_PK` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '是否主键',
  `IS_INCRE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '是否自增',
  `IS_REQUIRED` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '是否必填',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEFAULT_VALUE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认值',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `PURPOSE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字段用途 “createUser” 代表创建人   “createTime”代表创建时间   “updateUser”代表修改人“updateTime”  代表修改时间   “delDefFlag”代表删除标记',
  PRIMARY KEY (`COLUMN_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据表详情表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_METADATA_DETAIL_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_METADATA_MANAGE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_METADATA_MANAGE_TABLE`;
CREATE TABLE `SYS_HE_METADATA_MANAGE_TABLE`  (
  `TABLE_ID` bigint(20) NOT NULL COMMENT '表编号ID',
  `TABLE_NAME` varchar(125) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表英文名',
  `TABLE_CHNAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表中文名',
  `TABLE_COMMENT` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表描述',
  `COUNT_COLUMN` int(11) NOT NULL COMMENT '字段数量',
  `DATASOURCE_ID` bigint(20) NOT NULL COMMENT '数据源ID',
  `CHARACTER_SET` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字符集',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `REMARK` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `VERSION` bigint(20) NOT NULL COMMENT '更新版本号',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `RSV1` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留1',
  `RSV2` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留2',
  `RELEASE_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '表一键发布的版本号',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `VIEW_FLAG` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图标志',
  `VIEW_SQL` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '视图SQL',
  PRIMARY KEY (`TABLE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据表管理表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_METADATA_MANAGE_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_RVM_CONTENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_RVM_CONTENT`;
CREATE TABLE `SYS_HE_RVM_CONTENT`  (
  `CONTENT_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '版本内容主键',
  `REF_COUNT` bigint(20) NULL DEFAULT NULL COMMENT '数据引用计数',
  `DATA` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '版本内容数据',
  PRIMARY KEY (`CONTENT_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '版本内容信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_RVM_CONTENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_RVM_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_RVM_RESOURCE`;
CREATE TABLE `SYS_HE_RVM_RESOURCE`  (
  `RESOURCE_ID` bigint(20) NOT NULL COMMENT '业务服务id',
  `TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '资源类型标识',
  `NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '资源标识符',
  `LABEL` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '资源分支标签',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '租户 ID',
  PRIMARY KEY (`RESOURCE_ID`) USING BTREE,
  UNIQUE INDEX `idx_resource_coords`(`TENANT_ID` ASC, `TYPE` ASC, `NAME` ASC, `LABEL` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '版本资源信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_RVM_RESOURCE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_RVM_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_RVM_VERSION`;
CREATE TABLE `SYS_HE_RVM_VERSION`  (
  `VERSION_ID` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '资源版本主键',
  `RESOURCE_ID` bigint(20) NOT NULL COMMENT '从属资源主键',
  `CONTENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '对应资源内容引用',
  `MAJOR` int(11) NOT NULL COMMENT '大版本号',
  `MINOR` int(11) NOT NULL COMMENT '小版本号',
  `PATCH` int(11) NOT NULL COMMENT '修订版本号',
  `DESCRIPTION` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本描述',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本状态，0 正常，1 已删除',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`VERSION_ID`) USING BTREE,
  UNIQUE INDEX `idx_version_coords`(`RESOURCE_ID` ASC, `MAJOR` ASC, `MINOR` ASC, `PATCH` ASC) USING BTREE,
  INDEX `idx_resource_id`(`RESOURCE_ID` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '版本信息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_RVM_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_DETAIL_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_SERVICE_DETAIL_TABLE`;
CREATE TABLE `SYS_HE_SERVICE_DETAIL_TABLE`  (
  `DETAIL_ID` bigint(20) NOT NULL COMMENT 'DETAIL_ID',
  `SERVICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务服务ID',
  `DATASERVICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据服务ID',
  `SORT_NUMBER` int(11) NULL DEFAULT NULL COMMENT '顺序号',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `TREE_SORT` int(11) NULL DEFAULT NULL COMMENT '说明：组合与拆分配置时配置多个无关的树RN数据服务所属树的执行顺序',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`DETAIL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务服务详细表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_SERVICE_DETAIL_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_OUTPUT_INPUT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_SERVICE_OUTPUT_INPUT`;
CREATE TABLE `SYS_HE_SERVICE_OUTPUT_INPUT`  (
  `RELATE_ID` bigint(20) NOT NULL COMMENT 'RELATE_ID',
  `SERVICE_ID` bigint(20) NOT NULL COMMENT '业务服务ID',
  `OUT_DATASERVICE_ID` bigint(20) NOT NULL COMMENT '出参数据服务ID',
  `OUT_COLUMN_ID` bigint(20) NOT NULL COMMENT '数据服务出参列ID',
  `IN_DATASERVICE_ID` bigint(20) NOT NULL COMMENT '入参数据服务ID',
  `IN_COLUMN_ID` bigint(20) NOT NULL COMMENT '数据服务入参参列ID',
  `IN_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入参类型：0-单条；1-集合',
  `IN_SIZE` bigint(20) NULL DEFAULT NULL COMMENT '入参长度',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`RELATE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务服务入出参字段对应关系表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_SERVICE_OUTPUT_INPUT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_SERVICE_TABLE`;
CREATE TABLE `SYS_HE_SERVICE_TABLE`  (
  `SERVICE_ID` bigint(20) NOT NULL COMMENT '业务服务ID',
  `DATASOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源ID',
  `SERVICE_NAME` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '业务名称',
  `SERVICE_CHNAME` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务中文名称',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `SERVICE_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `SERVICE_TYPE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置方式',
  `SERVICE_STATUTS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务服务状态',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `RSV1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留1',
  `RSV2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留2',
  `MAKEUP_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '组合与拆分连线信息，用于拆分升级时回显',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`SERVICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_SERVICE_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HE_TABLE_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HE_TABLE_RELATIONSHIP`;
CREATE TABLE `SYS_HE_TABLE_RELATIONSHIP`  (
  `RELATION_ID` bigint(20) NOT NULL COMMENT '列ID',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '主从表主键ID',
  `MASTER_TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '主表ID',
  `MASTER_COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '主表字段ID',
  `SLAVE_TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '从表ID',
  `SLAVE_COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '从表字段ID',
  `RELATION_TYPE` bigint(20) NULL DEFAULT NULL COMMENT '关系类型',
  `DATA_STATUS` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `RSV1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '预留1',
  `RSV2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '预留2',
  `TABLE_NAME_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1:N 时 OBJECT名称',
  `TENANT_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`RELATION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '主从模型对应关系' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_HE_TABLE_RELATIONSHIP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_API_PM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_API_PM`;
CREATE TABLE `SYS_HPE_API_PM`  (
  `PARAMETER_ID` bigint(20) NOT NULL COMMENT '参数ID',
  `BUSINESS_ID` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口全长业务标识',
  `IN_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参',
  `IN_MAPPING` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参映射',
  `OUT_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '出参',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`PARAMETER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_API_PM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_AUTH_INTERFACE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_AUTH_INTERFACE`;
CREATE TABLE `SYS_HPE_AUTH_INTERFACE`  (
  `AUTH_RMI_ID` bigint(20) NOT NULL COMMENT '接口id',
  `AUTH_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证标识',
  `AUTH_RMI_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `AUTH_RMI_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口标识',
  `AUTH_RMI_URI` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口uri',
  `AUTH_RMI_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口类型',
  `REQUEST_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求类型',
  `CONTENT_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容类型',
  `RETRY_NUM` tinyint NULL DEFAULT NULL COMMENT '重试次数',
  `RETRY_INTERVAL` tinyint NULL DEFAULT NULL COMMENT '重试间隔',
  `AUTH_CLASS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证固化逻辑',
  `AUTH_METHOD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证固化方法名',
  `REMARK` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口描述',
  `HTTP_CONFIG` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'http配置',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`AUTH_RMI_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '认证模板接口表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_AUTH_INTERFACE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_AUTH_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_AUTH_TEMPLATE`;
CREATE TABLE `SYS_HPE_AUTH_TEMPLATE`  (
  `AUTH_ID` bigint(20) NOT NULL COMMENT '认证id',
  `AUTH_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证名称',
  `AUTH_METHOD` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证方式',
  `AUTH_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证标识',
  `AUTH_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证类型',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`AUTH_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '认证模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_AUTH_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_BPM_PM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_BPM_PM`;
CREATE TABLE `SYS_HPE_BPM_PM`  (
  `BPM_PM_ID` bigint(20) NOT NULL COMMENT '工作流参数ID',
  `BPM_PM_KEY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作流参数key',
  `BPM_PM_VALUE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作流参数value',
  `NODE_ID` bigint(20) NULL DEFAULT NULL COMMENT '节点ID',
  `NODE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点服务名称',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`BPM_PM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '工作流参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_BPM_PM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_DATASERVICE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_DATASERVICE`;
CREATE TABLE `SYS_HPE_DATASERVICE`  (
  `DATASERVICE_ID` bigint(20) NOT NULL COMMENT '固化服务ID',
  `DATASERVICE_TYPE` tinyint NULL DEFAULT NULL COMMENT '固化类型(关系数据库 service 扩展 编排)',
  `UNIQUE_CODE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法唯一码l类名+方法名',
  `CLASS_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固化服务bean名(编排类型为空)',
  `CLASS_DES` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固化服务bean描述(编排类型为空)',
  `METHOD_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法名/编排方法名',
  `METHOD_DES` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法/编排方法说明',
  `XML_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编排xml路径(仅编排类型)',
  `SERVICE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型(链/单独)(仅编排类型)',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `HPE_VERSION` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`DATASERVICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固化服务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_DATASERVICE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_DATASERVICE_INOUT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_DATASERVICE_INOUT`;
CREATE TABLE `SYS_HPE_DATASERVICE_INOUT`  (
  `INOUT_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `DATA_SERVICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '固化服务ID',
  `INOUT_TYPE` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出入参分类',
  `INOUT_JAVA_TYPE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型',
  `INOUT_ALIES` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '形参名称',
  `ORDER_ROW` tinyint NULL DEFAULT NULL COMMENT '顺序',
  `INOUT_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` bigint(20) NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`INOUT_ID`) USING BTREE,
  INDEX `FK_Reference_47`(`DATA_SERVICE_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固化服务出入参表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_DATASERVICE_INOUT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_LOGIC_BUSINESS`;
CREATE TABLE `SYS_HPE_LOGIC_BUSINESS`  (
  `BUSINESS_ID` bigint(20) NOT NULL COMMENT '业务ID',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '模型id',
  `BUSINESS_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务服务名称',
  `XML_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编排xml路径',
  `EXECUTE_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '执行类型(同步、异步、混合)',
  `BUSINESS_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务服务说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`BUSINESS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务服务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS_INOUT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_LOGIC_BUSINESS_INOUT`;
CREATE TABLE `SYS_HPE_LOGIC_BUSINESS_INOUT`  (
  `INOUT_ID` bigint(20) NOT NULL COMMENT '出入参ID',
  `INOUT_TYPE` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出入参分类(入/出)',
  `INOUT_JAVA_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型',
  `INOUT_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '形参名称',
  `ORDER_ROW` tinyint NULL DEFAULT NULL COMMENT '顺序',
  `BUSINESS_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务服务ID',
  `IS_ENTITY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否持久化数据',
  `IS_PAGE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否分页',
  `INOUT_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`INOUT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务服务出入参表(用来配置外层服务的出入参信息)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS_INOUT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS_PM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_LOGIC_BUSINESS_PM`;
CREATE TABLE `SYS_HPE_LOGIC_BUSINESS_PM`  (
  `PARAMETER_ID` bigint(20) NOT NULL COMMENT '属性ID',
  `INOUT_ID` bigint(20) NULL DEFAULT NULL COMMENT '出入参ID',
  `BUSINESS_ID` bigint(20) NULL DEFAULT NULL COMMENT '业务服务ID',
  `PARAMETER_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型(where,column,order,set,values)',
  `OPERATOR_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运算符类型(where,values,set)',
  `MATCH_TYPE` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接类型(where[and  or])',
  `ORDER_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '排序类型(order  [asc,desc])',
  `COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '列id',
  `PARAMETER_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数名(属性名)',
  `PARAMETER_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`PARAMETER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务服务出入参属性表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS_PM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_METADATA_COLUMN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_METADATA_COLUMN`;
CREATE TABLE `SYS_HPE_METADATA_COLUMN`  (
  `COLUMN_ID` bigint(20) NOT NULL COMMENT '列id',
  `COLUMN_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '列名',
  `COLUMN_ALIAS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列别名',
  `COLUMN_COMMENT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列注释',
  `TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '表id',
  `JDBC_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'jdbc类型',
  `JAVA_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'java类型',
  `PURPOSE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段用途',
  `TABLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名',
  `DATA_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段类型',
  `PRIMARYS` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主键',
  `DATA_LENGTH` bigint(20) NULL DEFAULT NULL COMMENT '字段长度',
  `DATA_DOT` int(11) NULL DEFAULT NULL COMMENT '字段精度',
  `DATA_DEFAULT_VALUE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '默认值',
  `DATA_IS_EMPTY` tinyint(1) NULL DEFAULT NULL COMMENT '是否空值',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  `PURPOSE_RULE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '特殊字段值规则',
  PRIMARY KEY (`COLUMN_ID`) USING BTREE,
  INDEX `idx_table_id`(`TABLE_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据列信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_METADATA_COLUMN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_METADATA_TABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_METADATA_TABLE`;
CREATE TABLE `SYS_HPE_METADATA_TABLE`  (
  `TABLE_ID` bigint(20) NOT NULL COMMENT '表id',
  `TABLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名',
  `TABLE_ALIAS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表别名',
  `TABLE_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '说明',
  `TABLE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表类型系统表/业务表',
  `DATASOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源ID',
  `POLL_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'pollName',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`TABLE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据表信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_METADATA_TABLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_COLUMNS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_MODEL_COLUMNS`;
CREATE TABLE `SYS_HPE_MODEL_COLUMNS`  (
  `MODEL_COLUMN_ID` bigint(20) NOT NULL COMMENT '模型元数据列ID',
  `COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '元数据列的ID',
  `COLUMN_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列名',
  `COLUMN_ALIAS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列别名',
  `RELATED_ID` bigint(20) NULL DEFAULT NULL COMMENT '模型与元数据关联ID',
  `TFMODEL_COLUMN_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天斧模型列ID',
  `TFMODEL_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天斧模型ID',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  `COLUMN_REMARK` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段备注',
  PRIMARY KEY (`MODEL_COLUMN_ID`) USING BTREE,
  INDEX `idx_related_id`(`RELATED_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据列信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_MODEL_COLUMNS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_COLUMNS_RULES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_MODEL_COLUMNS_RULES`;
CREATE TABLE `SYS_HPE_MODEL_COLUMNS_RULES`  (
  `RULE_ID` bigint(20) NOT NULL COMMENT '规则ID',
  `TFMODEL_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天斧模型ID',
  `RULE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '1:脱敏 2:字段翻译',
  `RELATED_ID` bigint(20) NULL DEFAULT NULL COMMENT '模型与元数据关联ID',
  `MODEL_COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '模型列ID',
  `COLUMN_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列名',
  `COLUMN_ALIAS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列别名',
  `RULE_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '类型是脱敏,存储脱敏表达式;类型是字段翻译,存储翻译的json结构',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`RULE_ID`) USING BTREE,
  INDEX `idx_related_id`(`RELATED_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '模型字段字典规则' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_MODEL_COLUMNS_RULES
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_MODEL_RELATIONSHIP`;
CREATE TABLE `SYS_HPE_MODEL_RELATIONSHIP`  (
  `RELATED_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `TFMODEL_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天斧模型的ID',
  `TFMODEL_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天斧的模型名',
  `TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型分为:单表(single)，主子表(master),单表流程(singleflow),主子表流程(masterflow),api模型（api）',
  `PARENT_PATH` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '父路径',
  `TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '表ID',
  `RELATION` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关系1-1 1-N N-1',
  `PARAM_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表别名',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`RELATED_ID`) USING BTREE,
  INDEX `ind_tfmodel_id`(`TFMODEL_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '模型信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_MODEL_RELATIONSHIP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_NODE_BUSINESS`;
CREATE TABLE `SYS_HPE_NODE_BUSINESS`  (
  `NODE_ID` bigint(20) NOT NULL COMMENT '节点ID',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '表/模型id',
  `NODE_NAME` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点服务名称',
  `ACTION_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方法名称',
  `NODE_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务说明',
  `DATA_SERVICE_CODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固化服务CODE',
  `DATA_SERVICE_ACTION_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固化服务方法名',
  `NODE_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点类型（single:单表 master:主子 flow:工作流）',
  `NODE_CLASS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑单元标识',
  `BUSINESS_CODE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务方法标识（发布是流程时使用）',
  `IN_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '节点入参',
  `IN_MAPPING` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参映射',
  `JSON_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '入参格式json',
  `OUT_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '节点出参',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`NODE_ID`) USING BTREE,
  UNIQUE INDEX `sys_hpe_node_business_un`(`NODE_NAME` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '节点业务服务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS_INOUT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_NODE_BUSINESS_INOUT`;
CREATE TABLE `SYS_HPE_NODE_BUSINESS_INOUT`  (
  `INOUT_ID` bigint(20) NOT NULL COMMENT '出入参ID',
  `INOUT_TYPE` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出入参分类(入/出)',
  `INOUT_JAVA_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型',
  `INOUT_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '形参名称',
  `ORDER_ROW` tinyint NULL DEFAULT NULL COMMENT '顺序',
  `NODE_ID` bigint(20) NULL DEFAULT NULL COMMENT '结点服务ID',
  `IS_ENTITY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否持久化数据(0:非持久化 1:持久化数据)',
  `IS_PAGE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否分页',
  `INOUT_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`INOUT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '节点业务服务出入参表(用来配置出入参信息)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS_INOUT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS_PM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_NODE_BUSINESS_PM`;
CREATE TABLE `SYS_HPE_NODE_BUSINESS_PM`  (
  `PARAMETER_ID` bigint(20) NOT NULL COMMENT '属性ID',
  `INOUT_ID` bigint(20) NULL DEFAULT NULL COMMENT '出入参ID',
  `NODE_ID` bigint(20) NULL DEFAULT NULL COMMENT '节点业务服务ID',
  `PARAMETER_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数类型(where,column,order,set,values)',
  `OPERATOR_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运算符类型(where,values,set)',
  `MATCH_TYPE` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接类型(where[and  or])',
  `ORDER_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '排序类型(order  [asc,desc])',
  `COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '列id',
  `PARAMETER_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数名(属性名)',
  `PARAMETER_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父级ID',
  PRIMARY KEY (`PARAMETER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '节点业务服务出入参属性表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS_PM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_PUB_VAR
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_PUB_VAR`;
CREATE TABLE `SYS_HPE_PUB_VAR`  (
  `PUB_VAR_ID` bigint(20) NOT NULL COMMENT '公共变量id',
  `BELONG_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属id',
  `BELONG_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属类型',
  `PUB_VAR_EXPRESS` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公共变量表达式',
  `PUB_VAR_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公共变量名称',
  `PUB_VAR_KEY` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公共变量key',
  `PUB_VAR_VALUE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公共变量value',
  `IS_BUILT_IN` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否内置',
  `EXPIRE_TIME` datetime NULL DEFAULT NULL COMMENT '失效时间',
  `APP_ID` bigint(20) NULL DEFAULT 0 COMMENT '应用id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`PUB_VAR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公共变量表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_PUB_VAR
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RECYCLE_BIN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RECYCLE_BIN`;
CREATE TABLE `SYS_HPE_RECYCLE_BIN`  (
  `MC_ID` bigint(20) NOT NULL COMMENT '主键',
  `TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '元数据表ID',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '模型ID',
  `TABLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名',
  `COLUMN_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列名',
  `COLUMN_JSON` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '删除的列JSON',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`MC_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '列回收站信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RECYCLE_BIN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RELATIONSHIP`;
CREATE TABLE `SYS_HPE_RELATIONSHIP`  (
  `MODEL_ID` bigint(20) NOT NULL COMMENT '模型id',
  `MODEL_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模型名称',
  `MODEL_DEC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模型说明',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  `MASTER_TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '主表表ID',
  PRIMARY KEY (`MODEL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据主从关联关系信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP_JOIN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RELATIONSHIP_JOIN`;
CREATE TABLE `SYS_HPE_RELATIONSHIP_JOIN`  (
  `JOIN_ID` bigint(20) NOT NULL COMMENT 'JOIN关系id',
  `MODEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '关联关系模型id',
  `LEFT_TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '左表id',
  `RIGHT_TABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '右表id',
  `JOIN_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接条件',
  `PARAM_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联列属性名',
  `RELATION` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关系1-1 1-N N-1',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`JOIN_ID`) USING BTREE,
  INDEX `idx_model_id`(`MODEL_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据主从关联关系JOIN表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP_JOIN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP_ON
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RELATIONSHIP_ON`;
CREATE TABLE `SYS_HPE_RELATIONSHIP_ON`  (
  `ON_ID` bigint(20) NOT NULL COMMENT '连接条件id',
  `JOIN_ID` bigint(20) NOT NULL COMMENT 'JOIN关系id',
  `LEFT_COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '左表列id',
  `RIGHT_COLUMN_ID` bigint(20) NULL DEFAULT NULL COMMENT '右表列id',
  `OPERATOR_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接运算符',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`ON_ID`) USING BTREE,
  INDEX `idx_join_id`(`JOIN_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '元数据主从关联关系ON表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP_ON
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RMI_CONNECTOR
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RMI_CONNECTOR`;
CREATE TABLE `SYS_HPE_RMI_CONNECTOR`  (
  `CONNECTOR_ID` bigint(20) NOT NULL COMMENT '连接器id',
  `CONNECTOR_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器名称',
  `CONNECTOR_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器标识',
  `CONNECTOR_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器类型',
  `IS_AUTH` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否认证',
  `AUTH_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '认证模板',
  `HOST_URL` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主机地址/域名',
  `PROTOCOL` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '协议',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器描述',
  `CONNECTOR_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器状态(0未启用,1启用,2禁用)',
  `APP_ID` bigint(20) NULL DEFAULT 0 COMMENT '应用id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`CONNECTOR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API连接器信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RMI_CONNECTOR
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_RMI_INTERFACE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_RMI_INTERFACE`;
CREATE TABLE `SYS_HPE_RMI_INTERFACE`  (
  `RMI_ID` bigint(20) NOT NULL COMMENT '接口id',
  `CONNECTOR_CODE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接器标识',
  `RMI_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口名称',
  `RMI_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口标识',
  `RMI_URI` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口URI',
  `RMI_CLASSIFY` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口分类',
  `RMI_CLASS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口固化逻辑',
  `RMI_METHOD` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口固化方法名',
  `RMI_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口状态(0未启用,1启用,2禁用)',
  `REQUEST_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求类型',
  `CONTENT_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内容类型',
  `IS_AUTH` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否认证',
  `REMARK` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口描述',
  `APP_ID` bigint(20) NULL DEFAULT 0 COMMENT '应用id',
  `IN_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接口入参',
  `OUT_PARAMS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接口出参',
  `HTTP_CONFIG` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'http配置',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`RMI_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API连接器接口信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_RMI_INTERFACE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_HPE_UPGRADE_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_HPE_UPGRADE_RECORD`;
CREATE TABLE `SYS_HPE_UPGRADE_RECORD`  (
  `UPGRADE_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `VERSION` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本号',
  `SUCCESS` smallint NULL DEFAULT NULL COMMENT '是否成功：0失败；1成功',
  `EXCEPTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '异常信息',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `HPE_VERSION` smallint NULL DEFAULT NULL COMMENT '版本标识',
  PRIMARY KEY (`UPGRADE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '升级记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_HPE_UPGRADE_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_IDTABLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_IDTABLE`;
CREATE TABLE `SYS_IDTABLE`  (
  `ID_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `ID_VALUE` int(11) NULL DEFAULT NULL COMMENT '当前编号',
  `TABLE_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务表名',
  `FIELD_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务名称',
  `ID_DESC` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务中文描述',
  `CACHE_SIZE` int(11) NULL DEFAULT NULL COMMENT '缓存大小',
  `ID_PREFIX` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '前缀',
  `IS_PREFIX` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否使用前缀',
  `ID_LENGTH` int(11) NULL DEFAULT NULL COMMENT '编号长度',
  `IS_SUFFIX` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否使用后缀',
  `ID_SUFFIX` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '后缀',
  `IS_GLOBAL` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否全局流水',
  `IS_LEVEL` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否层级码',
  `IS_SYS` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否系统编码',
  `LAST_DATE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '为特殊规则前缀时\\\"YYYY\\\"码表最后日期',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  PRIMARY KEY (`ID_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '最大号表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_IDTABLE
-- ----------------------------
INSERT INTO `SYS_IDTABLE` VALUES (622468560387842048, 0, 'SYS_ORGAN', 'ORGAN_CODE_4', '组织机构编码生成规则', 1, NULL, '0', 11, '0', NULL, '0', '0', '1', NULL, NULL, '2020-08-10 20:42:42', NULL, NULL);
INSERT INTO `SYS_IDTABLE` VALUES (624170019827490816, 0, 'SYS_STAFF', 'STAFF_CODE', '人员编码生成规则', 1, NULL, '0', 11, '0', NULL, '0', '0', '1', NULL, NULL, '2020-08-10 19:42:42', NULL, NULL);
INSERT INTO `SYS_IDTABLE` VALUES (686205562077323264, 0, 'SYS_APPLICATION', 'APP_CODE', '应用编码', 1, '', '0', 10, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO `SYS_IDTABLE` VALUES (713774538961461248, 0, 'SYS_RESOURCE_TYPE', 'RESOURCE_TYPE_CODE', '资源类型编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO `SYS_IDTABLE` VALUES (713774739046539264, 0, 'SYS_RESOURCE_TYPE_EXPAND', 'RESOURCE_TYPE_EXPAND_CODE', '资源类型拓展属性编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO `SYS_IDTABLE` VALUES (1450754032317640706, 214, 'SYS_RESOURCE_MODULES', 'MODULE_CODE', '模块编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 18:42:42', NULL, NULL);
INSERT INTO `SYS_IDTABLE` VALUES (1450754032317640708, 500, 'SYS_RESOURCES', 'RESOURCE_CODE', '资源编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 16:42:42', NULL, NULL);
INSERT INTO `SYS_IDTABLE` VALUES (1450754032317640713, 200, 'SYS_FUNCTIONS', 'FUNCTION_CODE', '功能编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 13:42:42', NULL, NULL);
INSERT INTO `SYS_IDTABLE` VALUES (1450754032317640717, 18, 'SYS_FUNCTION_MODULES', 'FUNCTION_MODULE_CODE', '功能模块编码', 1, NULL, '0', 4, '0', NULL, '0', '1', '1', NULL, NULL, '2020-08-10 11:40:42', NULL, NULL);

-- ----------------------------
-- Table structure for SYS_IDTABLE_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_IDTABLE_INFO`;
CREATE TABLE `SYS_IDTABLE_INFO`  (
  `INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `IDTABLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '字典表主键',
  `ID_VALUE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前值',
  `PARENT_NUMBER` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级id',
  PRIMARY KEY (`INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '最大号表信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_IDTABLE_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ID_CONVERTS
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ID_CONVERTS`;
CREATE TABLE `SYS_ID_CONVERTS`  (
  `NUM_ID` bigint(20) NOT NULL COMMENT '数字型id',
  `STR_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字符串型id',
  `IAM_USER` bigint(20) NOT NULL COMMENT 'IAM用户id',
  UNIQUE INDEX `sys_id_converts_ID_IDX`(`NUM_ID` ASC, `STR_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'uuid对应的long类型的id' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_ID_CONVERTS
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_INTERFACE_USER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_INTERFACE_USER`;
CREATE TABLE `SYS_INTERFACE_USER`  (
  `USER_ID` bigint(20) NOT NULL COMMENT '接口用户ID',
  `USER_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口用户名称',
  `IS_LOCK` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否锁定',
  `SYS_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名称',
  `SYS_URL` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用系统地址',
  `TOKEN_STATUS` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'token状态',
  `TOKEN_START_TIME` datetime NULL DEFAULT NULL COMMENT 'token获取时间',
  `TOKEN_END_TIME` datetime NULL DEFAULT NULL COMMENT 'token失效时间',
  `CONNECT_NUM` int(11) NULL DEFAULT NULL COMMENT 'token连接次数',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '应用系统地址',
  `TOKEN_VALUE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'token值',
  PRIMARY KEY (`USER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '接口表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_INTERFACE_USER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_LOGIN_USER_IDENTITY
-- ----------------------------
DROP TABLE IF EXISTS `SYS_LOGIN_USER_IDENTITY`;
CREATE TABLE `SYS_LOGIN_USER_IDENTITY`  (
  `IDENTITY_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `STAFF_ID` bigint(20) NULL DEFAULT NULL COMMENT '人员ID',
  `STRU_ID` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `POST_ID` bigint(20) NULL DEFAULT NULL COMMENT '岗位ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否已删除(0 正常 1 已删除)',
  PRIMARY KEY (`IDENTITY_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '登录用户身份信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_LOGIN_USER_IDENTITY
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_LOG_WARN_RULE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_LOG_WARN_RULE`;
CREATE TABLE `SYS_LOG_WARN_RULE`  (
  `RULE_ID` bigint(20) NOT NULL COMMENT '规则id',
  `RULE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '规则名称',
  `SERVER_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '服务名称',
  `SERVER_ENV` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务环境',
  `CLASS_NAME` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模块名称(类路径)',
  `ERROR_NUM` int(11) NOT NULL COMMENT '错误数量',
  `TIME_INTERVAL` int(11) NOT NULL COMMENT '时间间隔',
  `WARN_CLIENT` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '告警平台',
  `WEBHOOK_URL` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钩子地址',
  `RECEIVER` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接收人',
  `RULE_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '规则状态(0开启，1关闭)',
  `REMARK` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `TENANT_ID` bigint(20) NULL DEFAULT NULL COMMENT '租户id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`RULE_ID`) USING BTREE,
  UNIQUE INDEX `RULE_NAME_INDEX`(`RULE_NAME` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '日志告警规则表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_LOG_WARN_RULE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MENU
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MENU`;
CREATE TABLE `SYS_MENU`  (
  `MENU_ID` bigint(20) NOT NULL COMMENT '菜单id',
  `MENU_TEXT` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单编码',
  `MENU_ALIAS` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单别名',
  `FUNCTION_MODULE_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能模块ID',
  `FUNCTION_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能ID',
  `PARENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '父菜单',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '显示顺序',
  `IS_LEAF` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否是叶子节点',
  `TARGET` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单目标',
  `ICONS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单图标',
  `OPEN_TYPE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开方式',
  `PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件根路径',
  `COMPONENT` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件引入路径',
  `MENU_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区分菜单',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` date NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` date NULL DEFAULT NULL COMMENT '最后修改时间',
  `OPEN_MODE` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开方式 0系统内 1系统外',
  `IS_SYS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否是系统菜单',
  PRIMARY KEY (`MENU_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统菜单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MENU
-- ----------------------------
INSERT INTO `SYS_MENU` VALUES (510398063710576640, '开发者中心', '开发者中心', -1, -1, 1, 5, '0', '', 'bpm-platform-management', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (510503960046739456, '运维工具', '运维工具', -1, -1, 1450764807862096012, 10, '0', '', 'icon-left-operation-and-maintenance', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (510505261149200384, '平台监控', '平台监控', -1, -1, 1450764807862096012, 11, '0', '', 'icon-left-monitor', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (510506323742564352, '平台日志', '平台日志', -1, -1, 1450764807862096012, 12, '0', '', 'icon-left-log', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (518461064346869760, '客户端管理', '客户端管理', NULL, 518460834717114368, 510503960046739456, 8, '1', NULL, 'left-secondary-menu', 'inside', '/authClientModel', '', '0', 1450756958461300737, '2021-12-01', 1450756958461300737, '2021-12-01', '0', '1');
INSERT INTO `SYS_MENU` VALUES (520237348433436672, '插件管理', '插件管理', NULL, 520236482527764480, 510398063710576640, 6, '1', NULL, 'left-level-menu', 'inside', '/plugin/pluginList', '', '0', 1450756958461300737, '2021-12-06', 1450756958461300737, '2021-12-06', '0', '1');
INSERT INTO `SYS_MENU` VALUES (521279919444205568, '组织机构', '组织机构', NULL, NULL, 1450764807862095980, 1, '0', NULL, 'icon-left-organ', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (521280546094194688, '用户管理', '用户管理', NULL, NULL, 1450764807862095980, 2, '0', NULL, 'icon-left-user-manage', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (521288179740057600, '功能资源', '功能资源', NULL, NULL, 1450764807862095980, 4, '0', NULL, 'module', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (523160324178976768, '统一待办', '统一待办', NULL, NULL, 1, 12, '0', NULL, 'caidan_tongyidaiban', 'inside', '', '', '1', 1450756958461300737, '2021-12-14', 1450756958461300737, '2021-12-14', '0', '1');
INSERT INTO `SYS_MENU` VALUES (523160531927048192, '我的待办', '我的待办', NULL, 522705551881412608, 523160324178976768, 1, '1', NULL, 'caidan_wodedaiban', 'inside', '/unifiedtodoToDoTask', '', '1', 1450756958461300737, '2021-12-14', 1450756958461300737, '2021-12-14', '0', '1');
INSERT INTO `SYS_MENU` VALUES (523564187033804800, '我的已办', '我的已办', NULL, 523555260388876288, 523160324178976768, 2, '1', NULL, 'caidan_wodeyiban', 'inside', '/unifiedtodoDoneTask', '', '1', 1450756958461300737, '2021-12-15', 1450756958461300737, '2021-12-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (523564256034299904, '我的传阅', '我的传阅', NULL, 523555376986333184, 523160324178976768, 3, '1', NULL, 'caidan_wodechaosong', 'inside', '/unifiedtodoCcTask', '', '1', 1450756958461300737, '2021-12-15', 1450756958461300737, '2021-12-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (525236738705334272, '统一待办', '统一待办', NULL, NULL, 510398063710576640, 5, '0', NULL, 'unifiedtodo', 'inside', '', '', '0', 1450756958461300737, '2021-12-20', 1450756958461300737, '2021-12-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (525237452181610496, '应用注册', '应用注册', NULL, 521404105277841408, 525236738705334272, 1, '1', NULL, 'left-secondary-menu', 'inside', '/unifiedtodoSystem', '', '0', 1450756958461300737, '2021-12-20', 1450756958461300737, '2021-12-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (526077936101761024, '我的公告', '我的公告', -1, 526077556152344576, 1450764807862095952, 6, '1', '', 'caidan_wodegonggao', 'inside', '/noticeList', '', '1', 1450756958461300737, '2021-12-22', -1, '2021-12-22', '0', '1');
INSERT INTO `SYS_MENU` VALUES (535768937116475392, '审计查阅', '审计查阅', NULL, 535768729024471040, 510506323742564352, 4, '1', NULL, 'left-secondary-menu', 'inside', '/auditAccess', '', '0', 1450756958461300737, '2022-01-18', 1450756958461300737, '2022-01-18', '0', '0');
INSERT INTO `SYS_MENU` VALUES (544469385839124480, '主题配置', '主题配置', NULL, 544469147921424384, 510398063710576640, 7, '1', NULL, 'icon-left-theme', 'inside', '/themeConfig', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-02-11', '0', '0');
INSERT INTO `SYS_MENU` VALUES (544475935899131904, '任务管理', '任务管理', NULL, 544475707963875328, 551360495878414336, 2, '1', NULL, 'left-secondary-menu', 'inside', '/scheduleManagement', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-03-02', '0', '0');
INSERT INTO `SYS_MENU` VALUES (544476053125734400, '任务实例', '任务实例', NULL, 544475799542308864, 551360495878414336, 3, '1', NULL, 'left-secondary-menu', 'inside', '/scheduleInstance', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-03-02', '0', '0');
INSERT INTO `SYS_MENU` VALUES (545575465642106880, '统一日志', '统一日志', NULL, 545565036773646336, 592306184481153024, 1, '1', NULL, 'left-secondary-menu', 'inside', '/unifiedLog', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (546343278384259072, '链路追踪', '链路追踪', NULL, 546343149988225024, 592306184481153024, 2, '1', NULL, 'left-secondary-menu', 'inside', '/linkTracking', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (546348182481936384, '错误统计', '错误统计', NULL, 546347915988443136, 592306184481153024, 3, '1', NULL, 'left-secondary-menu', 'inside', '/errorStatistics', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (551360495878414336, '任务调度', '任务调度', -1, -1, 510503960046739456, 10, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-03-02', -1, '2022-03-02', '0', '0');
INSERT INTO `SYS_MENU` VALUES (576395294317748224, '消息中心', '消息中心', NULL, NULL, 1, 13, '0', NULL, 'xiaoxipingtai_xiaoxitongzhi_xiaoxifuwu-01', 'inside', '', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576446459680137216, '短信推送', '短信推送', NULL, NULL, 576395294317748224, 2, '0', NULL, 'xiaoxi-duanxinfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576448392889376768, '委托待办', '委托待办', NULL, 576448277533433856, 579974742292045824, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustTodoList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576448474900602880, '委托已办', '委托已办', NULL, 576438008606367744, 579974742292045824, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustDoneList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576450856640323584, '通道管理', '通道管理', NULL, 576447430137225216, 576446459680137216, 1, '1', '', 'left-secondary-menu', 'inside', '/smsService/Channel', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-13', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576450925435297792, '签名管理', '签名管理', NULL, 576447488295444480, 576446459680137216, 2, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/signature', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576450990023385088, '模板管理', '模板管理', NULL, 576447546457858048, 576446459680137216, 3, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/template', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576451066137419776, '发送测试', '发送测试', NULL, 576447608743272448, 576446459680137216, 4, '1', '', 'left-secondary-menu', 'inside', '/smsService/SendSMS', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576451140942831616, '发送记录', '发送记录', NULL, 576447666205237248, 576446459680137216, 5, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/sendRecord', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (576451207187668992, '发送统计', '发送统计', NULL, 576447721767182336, 576446459680137216, 6, '1', '', 'left-secondary-menu', 'inside', '/smsService/sendRateReport', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (577911561352650752, '邮件推送', '邮件推送', NULL, NULL, 576395294317748224, 3, '0', NULL, 'xiaoxi-youjianfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-05-14', '0', '1');
INSERT INTO `SYS_MENU` VALUES (577911671788675072, '通道管理', '通道管理', NULL, 577911233693622272, 577911561352650752, 1, '1', '', 'left-secondary-menu', 'inside', '/mailService/mChannel', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (577920288222879744, '发送记录', '发送记录', NULL, 577920176742473728, 577911561352650752, 6, '1', '', 'left-secondary-menu', 'inside', '/mailService/mailSendRecord', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578180907635318784, '模板管理', '模板管理', NULL, 578179104113958912, 577911561352650752, 2, '1', NULL, 'left-secondary-menu', 'inside', '/mailService/mTemplate', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578183012341260288, '单发测试', '单发测试', NULL, 578179213245554688, 577911561352650752, 4, '1', '', 'left-secondary-menu', 'inside', '/mailService/mSendTest', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578185499647418368, '群发测试', '群发测试', NULL, 578179275791015936, 577911561352650752, 5, '1', '', 'left-secondary-menu', 'inside', '/mailService/groupHair', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578185579053981696, '收件人管理', '收件人管理', NULL, 578179328681189376, 577911561352650752, 3, '1', '', 'left-secondary-menu', 'inside', '/mailService/recipient', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-23', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578185686646267904, '发送统计', '发送统计', NULL, 578180115675226112, 577911561352650752, 7, '1', '', 'left-secondary-menu', 'inside', '/mailService/readedStatistics', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578225925171453952, '微信公众号推送', '微信公众号推送', NULL, NULL, 576395294317748224, 4, '0', NULL, 'xiaoxi-weixingongzhonghaofuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578226039885668352, '通道管理', '通道管理', NULL, 578225632039936000, 578225925171453952, 1, '1', '', 'left-secondary-menu', 'inside', '/mpService/111publicAccount', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578226124077932544, '模板管理', '模板管理', NULL, 578225680442204160, 578225925171453952, 2, '1', '', 'left-secondary-menu', 'inside', '/mpService/mpTemplate', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578226212909096960, '发送测试', '发送测试', NULL, 578225755054678016, 578225925171453952, 3, '1', '', 'left-secondary-menu', 'inside', '/mpService/messageTesting', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (578226283117551616, '发送记录', '发送记录', NULL, 578225803503083520, 578225925171453952, 4, '1', '', 'left-secondary-menu', 'inside', '/mpService/pushRecord', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579402999395524608, 'IM推送', 'IM推送', NULL, NULL, 576395294317748224, 5, '0', NULL, 'xiaoxi-Applmfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579403112276828160, '通道管理', '通道管理', NULL, 579402490307682304, 579402999395524608, 1, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImChannel', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579403203670712320, '发送测试', '发送测试', NULL, 579402568669863936, 579402999395524608, 2, '1', NULL, 'left-secondary-menu', 'inside', '/appImService/appImSendTest', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579403287988805632, '发送统计', '发送统计', NULL, 579402651498979328, 579402999395524608, 4, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImDataStatistics', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579408006685663232, 'APP通知推送', 'APP通知推送', NULL, NULL, 576395294317748224, 6, '0', NULL, 'xiaoxi-APPtuisongfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579408141658365952, '通道管理', '通道管理', NULL, 579407434091864064, 579408006685663232, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appPushService/appPushChannel', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579408250869653504, '发送测试', '发送测试', NULL, 579407499330068480, 579408006685663232, 2, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushTest', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579408319811428352, '发送记录', '发送记录', NULL, 579407703957577728, 579408006685663232, 3, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushReecorded', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579408390443507712, '发送统计', '发送统计', NULL, 579407758378672128, 579408006685663232, 4, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushStatistics', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579974742292045824, '流程委托', '流程委托', NULL, NULL, 1450764807862095952, 6, '0', NULL, 'caidan_liuchengweituo', 'inside', '/entrustDoneList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (579987145213878272, '发送记录', '发送记录', NULL, 579987015375003648, 579402999395524608, 3, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImSendRecord', '', '0', 1450756958461300737, '2022-05-20', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (581430140240928768, '流程分析', '流程分析', NULL, NULL, 1450764807862095963, 11, '0', '', 'icon-left-monitor', 'inside', '', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437577991823360, '流程概览', '流程概览', NULL, 581430666475085824, 581430140240928768, 1, '1', '', 'left-secondary-menu', 'inside', '/bpa/view', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437646807769088, '流程状态分析', '流程状态分析', NULL, 581436854533103616, 581430140240928768, 2, '1', '', 'left-secondary-menu', 'inside', '/bpa/view/processStatus', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437695180677120, '流程参与者分析', '流程参与者分析', NULL, 581436941229367296, 581430140240928768, 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAssignee', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437747630448640, '流程统计分析', '流程统计分析', NULL, 581436993427480576, 581430140240928768, 4, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessStatistics', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437791045689344, '数量分析', '数量分析', NULL, NULL, 581430140240928768, 5, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437856728489984, '热门流程分析', '热门流程分析', NULL, 581437139125018624, 581437791045689344, 1, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaHotProcess', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437898885439488, '流程数量分析', '流程数量分析', NULL, 581437221161410560, 581437791045689344, 2, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAmount', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437940299997184, '用户流程分析', '用户流程分析', NULL, 581437297606795264, 581437791045689344, 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessUser', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581437985619451904, '待办任务分析', '待办任务分析', NULL, 581437337255550976, 581437791045689344, 4, '1', '', 'left-secondary-menu', 'inside', '/todoTaskAnalysis', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO `SYS_MENU` VALUES (581438095157895168, '流程耗时分析', '流程耗时分析', NULL, 581437382767943681, 581430140240928768, 6, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/processConsumeTime', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (582661624251555840, '发送统计', '发送统计', NULL, 582661445364490240, 578225925171453952, 5, '1', '', 'left-secondary-menu', 'inside', '/mpService/sendStatistics', '', '0', 1450756958461300737, '2022-05-27', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO `SYS_MENU` VALUES (586248796225413120, '流程驳回分析', '流程驳回分析', NULL, 581437337255550977, 581437791045689344, 5, '1', NULL, 'left-secondary-menu', 'inside', '/processRejectionAnalysis', '', '0', 1450756958461300737, '2022-06-06', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO `SYS_MENU` VALUES (586944248251949056, '内部通知推送', '内部通知推送', NULL, NULL, 576395294317748224, 7, '0', NULL, 'xiaoxi-neibutongzhifuwu', 'inside', '', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (587710302741864448, '发送测试', '发送测试', NULL, 588042975440019456, 586944248251949056, 1, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticePushTest', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (587710386070102016, '发送记录', '发送记录', NULL, 587709734606610432, 586944248251949056, 2, '1', NULL, 'left-secondary-menu', 'inside', '/noticeService/noticeSendRecord', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (587710464084156416, '发送统计', '发送统计', NULL, 587709787979128832, 586944248251949056, 3, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticeStatistics', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (592306184481153024, '统一日志', '统一日志', NULL, NULL, 510506323742564352, 6, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (592401069905289216, '日志告警', '日志告警', NULL, NULL, 510505261149200384, 6, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (592401214583611392, '告警设置', '告警设置', NULL, 592386778267394048, 592401069905289216, 1, '1', '', 'left-secondary-menu', 'inside', '/logSet', '@/views/logWarn/logSet', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (592401334532317184, '告警记录', '告警记录', NULL, 592391757124345856, 592401069905289216, 2, '1', '', 'left-secondary-menu', 'inside', '/logRecord', '@/views/logWarn/logRecord', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO `SYS_MENU` VALUES (595572492354199552, '移动门户配置', '移动门户配置', NULL, NULL, 1450764807862095954, 11, '0', NULL, 'left-mobile-office', 'inside', '', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-02', '0', '0');
INSERT INTO `SYS_MENU` VALUES (595572608519643136, '首页配置', '首页配置', NULL, 595572331049656320, 595572492354199552, 1, '1', '', 'left-secondary-menu', 'inside', '/portalConfiguration', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-11', '0', '0');
INSERT INTO `SYS_MENU` VALUES (595572683195031552, '三方集成', '三方集成', NULL, 595572392424906752, 595572492354199552, 2, '1', '', 'left-secondary-menu', 'inside', '/tripartiteIntegration', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-11', '0', '0');
INSERT INTO `SYS_MENU` VALUES (596354392677163008, '应用管理', '应用管理', NULL, NULL, 576395294317748224, 8, '0', NULL, 'icon-left-application-manage', 'inside', '', '', '0', 1450756958461300737, '2022-07-04', 1450756958461300737, '2022-07-04', '0', '1');
INSERT INTO `SYS_MENU` VALUES (596354710630572032, '应用管理', '应用管理', NULL, 596354099289792512, 596354392677163008, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appService/appManage', '', '0', 1450756958461300737, '2022-07-04', 1450756958461300737, '2022-07-04', '0', '1');
INSERT INTO `SYS_MENU` VALUES (608975106760515584, '场景管理', '场景管理', NULL, 608974847288287232, 596354392677163008, 2, '1', '', 'left-secondary-menu', 'inside', '/appService/sceneManage', '', '0', 1450756958461300737, '2022-08-08', 1450756958461300737, '2022-08-08', '0', '1');
INSERT INTO `SYS_MENU` VALUES (641242930610446336, '数据迁移', '数据迁移', NULL, NULL, 1450764807862096012, 13, '0', NULL, 'shujuqianyi', 'inside', '', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO `SYS_MENU` VALUES (641244185470705664, '数据导入', '数据导入', NULL, 641243926136889344, 641242930610446336, 1, '1', '', 'left-secondary-menu', 'inside', '/migrationLoad', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO `SYS_MENU` VALUES (641244243347906560, '数据导出', '数据导出', NULL, 641244024103247872, 641242930610446336, 2, '1', '', 'left-secondary-menu', 'inside', '/migrationDump', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO `SYS_MENU` VALUES (673554222872272896, '配置项管理', '配置项管理', NULL, 673553074966765568, 1450764807862095963, 12, '1', '', 'caidan-shezhi1', 'inside', '/bpmConfig', '', '0', 1450756958461300737, '2023-02-02', 1450756958461300737, '2023-02-02', '0', '0');
INSERT INTO `SYS_MENU` VALUES (686144725505548288, '应用管理', '应用管理', NULL, NULL, 1, 14, '0', NULL, 'hussar_application', 'inside', '', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686147400720719872, '应用管理', '应用管理', NULL, 686147054220877824, 686144725505548288, 1, '1', NULL, 'caidan_appManagement', 'inside', '/appManage', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686147588675870720, '应用回收站', '应用回收站', NULL, 686147191273955328, 686144725505548288, 2, '1', NULL, 'caidan_recycleBin', 'inside', '/RecycleBin', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686178606145347584, '企业微信推送', '企业微信推送', NULL, NULL, 576395294317748224, 9, '0', '', 'a-qingqibing_xiaoxizhong-qiyeweixintuisong', 'inside', '', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686178943606464512, '通道管理', '通道管理', NULL, 686178119287316480, 686178606145347584, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomChannel', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686179008337158144, '发送测试', '发送测试', NULL, 686178183690854400, 686178606145347584, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendedTested', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686179079862624256, '发送记录', '发送记录', NULL, 686178259356098560, 686178606145347584, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendRecord', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (686179134522793984, '发送统计', '发送统计', NULL, 686178312292409344, 686178606145347584, 4, '1', '', 'caidan-3Jmoren', 'inside', '/wecomService/wecomDataStatistics', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (688350240998432768, '岗位管理', '岗位管理', NULL, 688350053471100928, 521279919444205568, 3, '1', '', 'caidan-3Jmoren', 'inside', '', '', '0', 1450756958461300737, '2023-03-15', 1450756958461300737, '2023-03-15', '0', '1');
INSERT INTO `SYS_MENU` VALUES (697755930116497408, '钉钉推送', '钉钉推送', NULL, NULL, 576395294317748224, 10, '0', NULL, 'qingqibing_xiaoxipingtai-dingdingtuisong', 'inside', '', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (697762708677992448, '通道管理', '通道管理', NULL, 697762187867070464, 697755930116497408, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/channel', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (697762824432394240, '发送测试', '发送测试', NULL, 697762370797445120, 697755930116497408, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendTest', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (697762900781309952, '发送记录', '发送记录', NULL, 697762455014875136, 697755930116497408, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendRecord', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (697762974726889472, '发送统计', '发送统计', NULL, 697762540020834304, 697755930116497408, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendCount', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO `SYS_MENU` VALUES (706807802378854400, '表单维护', '表单维护', NULL, 706807627035975680, 1450764807862095963, 14, '1', NULL, 'caidan-2Jmoren', 'inside', '/formManager', '', '0', 1450756958461300737, '2023-05-05', 1450756958461300737, '2023-05-05', '0', '0');
INSERT INTO `SYS_MENU` VALUES (713719440226918400, '资源类型管理', '资源类型管理', NULL, 713719009941659648, 521288179740057600, 3, '1', '', 'caidan-3Jmoren', 'inside', '/resourceTypeManage', '', '0', 1450756958461300737, '2023-04-03', 1450756958461300737, '2023-04-03', '0', '1');
INSERT INTO `SYS_MENU` VALUES (714433614208835584, '岗位审核', '岗位审核', NULL, 714425029546483712, 521279919444205568, 9, '1', NULL, 'caidan-3Jmoren', 'inside', '/postAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO `SYS_MENU` VALUES (714488330313801728, '组织角色审核', '组织角色审核', NULL, 714488057633710080, 1450764807862095998, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/struRoleVerify', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO `SYS_MENU` VALUES (714488433812447232, '岗位角色审核', '岗位角色审核', NULL, 714488196960100352, 1450764807862095998, 5, '1', NULL, 'caidan-3Jmoren', 'inside', '/postRoleAudit', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO `SYS_MENU` VALUES (714502153053675520, '用户组织审核', '用户组织审核', NULL, 714498812294733824, 521280546094194688, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/userOrganizationAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO `SYS_MENU` VALUES (714503357229965312, '用户岗位审核', '用户岗位审核', NULL, 714503247842516992, 521280546094194688, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/userPositionAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO `SYS_MENU` VALUES (729285621608357888, '分组管理', '分组管理', NULL, 729285499054989312, 686144725505548288, 3, '1', NULL, 'caidan-2Jmoren', 'inside', '/appGroupManage', '', '0', 1450756958461300737, '2023-07-06', 1450756958461300737, '2023-07-06', '0', '0');
INSERT INTO `SYS_MENU` VALUES (734834444426551296, '工作台banner', '工作台banner', NULL, 734833871224578048, 1450764807862095954, 12, '1', NULL, 'caidan_work_banner', 'inside', '/bannerManage', '', '0', 1450756958461300737, '2023-07-21', 1450756958461300737, '2023-07-21', '0', '0');
INSERT INTO `SYS_MENU` VALUES (735799904773087232, '组件库维护', '组件库维护', NULL, 735799387355357184, 1450764807862095954, 13, '1', NULL, 'caidan_work_assembly', 'inside', '/componentsLibrary', '', '0', 1450756958461300737, '2023-07-24', 1450756958461300737, '2023-07-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (811594821746827264, '联系人管理', '联系人管理', NULL, NULL, 576395294317748224, 11, '0', '', 'caidan-liucheng4', 'inside', '', '', '0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', '0', '0');
INSERT INTO `SYS_MENU` VALUES (811596001818451968, '通讯录', '通讯录', NULL, 811595871216214016, 811594821746827264, 1, '1', '', 'caidan-3Jmoren', 'inside', '/contactService/ContactManage', '', '0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', '0', '0');
INSERT INTO `SYS_MENU` VALUES (813349058159845376, '标签管理', '标签管理', NULL, 813348971400667136, 811594821746827264, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/contactService/TagManage', '', '0', 1450756958461300737, '2024-02-23', 1450756958461300737, '2024-02-23', '0', '0');
INSERT INTO `SYS_MENU` VALUES (825444013086875648, '个人环境管理', '个人环境管理', NULL, 825443949341843456, 686144725505548288, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/personalEnvManagement', '', '0', 679338378499727360, '2024-03-27', 679338378499727360, '2024-03-27', '0', '0');
INSERT INTO `SYS_MENU` VALUES (846427851380236288, '环境管理', '环境管理', NULL, 846427189661671424, 510503960046739456, 11, '1', NULL, 'caidan-3Jmoren', 'inside', '/environment', '', '0', 844891795166076928, '2024-05-24', 844891795166076928, '2024-05-24', '0', '0');
INSERT INTO `SYS_MENU` VALUES (1450764807862095951, '组织管理', '组织管理', -1, 1450764807862095892, 521279919444205568, 1, '1', '', 'left-secondary-menu', 'inside', '/OrganMaintenance', '@/views/organ/OrganMaintenance', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095952, '个人事项', '个人事项', 1450764807862095873, NULL, 1, 10, '0', NULL, 'caidan_gerenshixiang', '', '/toDoManage', '@/views/layout/layout', '1', NULL, NULL, 1450756958461300737, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095953, '我的传阅', '我的传阅', NULL, 1450764807862095893, 1450764807862095952, 4, '1', NULL, 'caidan_wodechaosong', '', '/ccList', '@/views/taskmanage/ccList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095954, '门户配置', '门户配置', 1450764807862095874, -1, 1, 2, '0', '', 'bpm-portal-configuration-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095959, '审计日志', '审计日志', -1, 1450764807862095898, 510506323742564352, 1, '1', '', 'left-secondary-menu', 'inside', '/auditlog', '@/views/system/auditlog/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095961, '解冻密码', '解冻密码', NULL, 1450764807862095900, 510503960046739456, 3, '1', NULL, 'left-secondary-menu', 'tab', '/thawcode', '@/views/system/thawcode/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095962, '资源管理', '资源管理', -1, 1450764807862095901, 521288179740057600, 1, '1', '', 'left-secondary-menu', 'inside', '/resourceManage', '@/views/permit/resourceManage/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095963, '流程中心', '流程中心', 1450764807862095875, -1, 1, 3, '0', '', 'bpm-process-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095965, '类型定义', '类型定义', -1, 1450764807862095902, 521279919444205568, 4, '1', '', 'left-secondary-menu', 'inside', '/SysOrgType', '@/views/organ/SysOrgType', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095967, '我的催办', '我的催办', NULL, 1450764807862095904, 1450764807862095952, 3, '1', NULL, 'caidan_wodecuiban', '', '/urgeList', '@/views/taskmanage/urgeList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095972, '用户维护', '用户维护', -1, 1450764807862095908, 521280546094194688, 1, '1', '', 'left-secondary-menu', 'inside', '/usermanage', '@/views/permit/usermanage/user', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095974, '角色维护', '角色维护', -1, 1450764807862095909, 1450764807862095998, 1, '1', '', 'left-secondary-menu', 'inside', '/role', '@/views/permit/rolemanage/role/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095975, '重置密码', '重置密码', NULL, 1450764807862095911, 510503960046739456, 2, '1', NULL, 'left-secondary-menu', NULL, '/resetpassword', '@/views/system/resetpassword/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095978, '字典管理', '字典管理', NULL, 1450764807862095913, 510503960046739456, 1, '1', '', 'left-secondary-menu', '', '/dictionary', '@/views/system/dictionary/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095980, '组织权限', '组织权限', 523176320419766272, -1, 1, 1, '0', '', 'bpm-organization-authority-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095982, '组织审核', '组织审核', -1, 1450764807862095915, 521279919444205568, 6, '1', '', 'left-secondary-menu', 'tab', '/organAudit', '@/views/permit/auditManage/organAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095984, '设计器', '设计器', -1, 1450764807862095917, 1, 4, '1', '', 'bpm-visual-designer', 'outside', '/static/formdesign/index.html', '', '0', -1, NULL, -1, '2021-11-09', '1', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095986, '系统参数', '系统参数', 523213802016350208, -1, 510398063710576640, 4, '0', '', 'icon-left-system-params', 'inside', '/system', '@/views/layout/layout', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095987, '慢SQL诊断', '慢SQL诊断', -1, 1450764807862095920, 510505261149200384, 5, '1', '', 'left-secondary-menu', 'inside', '/slowsql', '@/views/service/slowsql/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095988, '菜单配置', '菜单配置', -1, 1450764807862095921, 1450764807862095954, 3, '1', '', 'left-menu-manage', 'inside', '/menumaintain', '@/views/menumaintain/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095990, '规则定义', '规则定义', -1, 1450764807862095922, 521279919444205568, 5, '1', '', 'left-secondary-menu', 'inside', '/SysOrgRule', '@/views/organ/SysOrgRule', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095991, '用户审核', '用户审核', -1, 1450764807862095923, 521280546094194688, 2, '1', '', 'left-secondary-menu', 'tab', '/userAudit', '@/views/permit/auditManage/userAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095993, '任务管理', '任务管理', -1, 1450764807862095924, 1450764807862095963, 9, '1', '', 'icon-left-task-manage', 'inside', '/bpmTask', '@/bpm/views/taskManagement/task', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095995, '系统监控', '系统监控', -1, 1450764807862095925, 510505261149200384, 4, '1', '', 'left-secondary-menu', 'inside', '/systemMonitor', '@/views/service/systemMonitor/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095997, '在线用户', '在线用户', -1, 1450764807862095927, 510505261149200384, 1, '1', '', 'left-secondary-menu', 'inside', '/onlineUser', '@/views/system/onlineuser/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095998, '角色管理', '角色管理', 1450764807862095884, -1, 1450764807862095980, 3, '0', '', 'left-role-manage', 'inside', '/roleManage', '@/views/permit/rolemanage/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862095999, '快捷功能配置', '快捷功能配置', -1, 1450764807862095928, 1450764807862095954, 4, '1', '', 'left-shortcut-config', 'inside', '/shortCutConf', '@/views/personalizedConf/shortCutConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096000, '日志下载', '日志下载', -1, 1450764807862095929, 510506323742564352, 2, '1', '', 'left-secondary-menu', 'inside', '/logdownload', '@/views/service/logdownload/index', '0', -1, NULL, 1450756958461300737, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096001, '人员审核', '人员审核', -1, 1450764807862095930, 521279919444205568, 7, '1', '', 'left-secondary-menu', 'tab', '/staffAudit', '@/views/permit/auditManage/staffAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096002, '人员管理', '人员管理', -1, 1450764807862095931, 521279919444205568, 2, '1', '', 'left-secondary-menu', 'inside', '/StaffManage', '@/views/organ/StaffManage', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096004, '函数管理', '函数管理', -1, 1450764807862095933, 1450764807862095963, 10, '1', '', 'icon-left-function-manage', 'inside', '/bpmFunction', '@/bpm/views/function/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096005, '自定义编码规则', '自定义编码规则', -1, 1450764807862095934, 1450764807862095986, 5, '1', '', 'left-secondary-menu', 'inside', '/maximumTable', '@/views/system/maximumTable/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096007, '已办任务', '已办任务', NULL, 1450764807862095935, 1450764807862095952, 2, '1', NULL, 'caidan_yibanrenwu', '', '/doneList', '@/views/taskmanage/doneList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096008, '工作日维护', '工作日维护', -1, 1450764807862095936, 510503960046739456, 6, '1', '', 'left-secondary-menu', 'inside', '/workcalendar', '@/views/system/workcalendar/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096010, '流程管理', '流程管理', -1, 1450764807862095937, 1450764807862095963, 2, '1', '', 'icon-left-process-manage', 'inside', '/bpmModelEdit', '@/bpm/views/modeling/modelEdit', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096011, '框架页配置', '框架页配置', -1, 1450764807862095938, 1450764807862095954, 8, '1', '', 'left-layout-config', 'inside', '/layoutConf', '@/views/personalizedConf/layoutConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096012, '运维监控', '运维监控', 1450764807862095887, -1, 1, 6, '0', '', 'bpm-operation-and-maintenance-monitoring-center', 'inside', '/service', '@/views/layout/layout', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096014, '用户角色审核', '用户角色审核', -1, 1450764807862095939, 1450764807862095998, 3, '1', '', 'left-secondary-menu', 'inside', '/userRoleVerify', '@/views/permit/rolemanage/userRoleVerify/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096015, '登录页配置', '登录页配置', -1, 1450764807862095940, 1450764807862095954, 7, '1', '', 'left-login-config', 'inside', '/loginConf', '@/views/personalizedConf/loginConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096016, '我的委托', '我的委托', NULL, 1450764807862095941, 579974742292045824, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustList', '@/views/taskmanage/entrustList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096019, '实例管理', '实例管理', -1, 1450764807862095943, 1450764807862095963, 8, '1', '', 'icon-left-instance-manage', 'inside', '/bpmProcess', '@/bpm/views/processinst/process', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096020, '在线历史记录', '在线历史记录', -1, 1450764807862095944, 510506323742564352, 3, '1', '', 'left-secondary-menu', 'inside', '/onlinehis', '@/views/system/onlinehistory/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096021, '运行参数配置', '运行参数配置', NULL, 1450764807862095945, 1450764807862095986, 3, '1', '', 'left-secondary-menu', 'tab', '/baseConfig', '@/views/system/baseConfig/index', '0', NULL, NULL, 1450756958461300737, '2021-11-11', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096022, '功能管理', '功能管理', -1, 1450764807862095910, 521288179740057600, 2, '1', '', 'left-secondary-menu', 'inside', '/functionManage', '@/pages/console/views/permit/functionManage/index', '0', -1, '2021-06-21', -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096023, '不相容角色集', '不相容角色集', -1, 1450764807862095946, 1450764807862095998, 2, '1', '', 'left-secondary-menu', 'inside', '/alienRole', '@/views/permit/rolemanage/alienRole/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096024, '待办任务', '待办任务', NULL, 1450764807862095947, 1450764807862095952, 1, '1', NULL, 'caidan_daibanrenwu', '', '/toDoList', '@/views/taskmanage/todoList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO `SYS_MENU` VALUES (1450764807862096026, '授权信息', '授权信息', NULL, 1450764807862095949, 1450764807862095986, 9, '1', NULL, 'left-secondary-menu', NULL, '/license', '@/views/system/license/index', '0', NULL, NULL, 1450756958461300737, '2021-11-11', '0', '1');

-- ----------------------------
-- Table structure for SYS_MESSAGE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MESSAGE`;
CREATE TABLE `SYS_MESSAGE`  (
  `MESSAGE_ID` bigint(20) NOT NULL COMMENT '消息ID',
  `MESSAGE_TYPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '消息类型ID',
  `MESSAGE_TITLE` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息标题',
  `APPROVER_ID` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `RELEASE_DATE` datetime NULL DEFAULT NULL COMMENT '发布日期',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `MESSAGE_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '消息内容',
  `DEPARTMENT_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(部门ID)',
  `POST_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(岗位id)',
  `ROLE_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(角色ID)',
  `USER_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(用户id)',
  `CREATOE_DEPARTMENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '创建者部门ID',
  `MESSAGE_ISSUE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布者(公司或部门名称)',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '消息创建者(ID)',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `DEPT_ROLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围名称',
  `BUSINESS_ADDRESS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务地址',
  `MOBILE_BUSINESS_ADDRESS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端业务地址',
  `OPEN_WAY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开方式',
  PRIMARY KEY (`MESSAGE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MESSAGE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MESSAGE_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MESSAGE_ATTACHMENT`;
CREATE TABLE `SYS_MESSAGE_ATTACHMENT`  (
  `MESSAGE_ATT_ID` bigint(20) NOT NULL COMMENT '消息与附件关系id',
  `MESSAGE_ID` bigint(20) NOT NULL DEFAULT 0 COMMENT '消息id',
  `MESSAGE_ATTACHMENT_URL` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '附件地址',
  `MESSAGE_ATTACHMENT_TITLE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '附件名称',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '	创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`MESSAGE_ATT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息附件关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MESSAGE_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MESSAGE_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MESSAGE_DETAIL`;
CREATE TABLE `SYS_MESSAGE_DETAIL`  (
  `MESSAGE_DETAIL_ID` bigint(20) NOT NULL COMMENT '消息详情id',
  `MESSAGE_ID` bigint(20) NOT NULL COMMENT '消息ID',
  `MESSAGE_TYPE_ID` bigint(20) NULL DEFAULT NULL COMMENT '消息类型ID',
  `MESSAGE_TITLE` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息标题',
  `APPROVER_ID` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `RELEASE_DATE` datetime NULL DEFAULT NULL COMMENT '发布日期',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `MESSAGE_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '消息内容',
  `DEPARTMENT_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(部门ID)',
  `ROLE_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(角色ID)',
  `USER_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `CREATOE_DEPARTMENT_ID` bigint(20) NULL DEFAULT NULL COMMENT '创建者部门ID',
  `MESSAGE_ISSUE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布者(公司或部门名称)',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '消息创建者(ID)',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `DEPT_ROLE_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围名称',
  `BUSINESS_ADDRESS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务地址',
  `READ_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息状态（1：已读 0：未读）',
  `OPEN_WAY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开方式',
  `PEOPLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '个人id',
  `MOBILE_BUSINESS_ADDRESS` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端业务地址',
  PRIMARY KEY (`MESSAGE_DETAIL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MESSAGE_DETAIL
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MICRO_APPLICATION_CONF
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MICRO_APPLICATION_CONF`;
CREATE TABLE `SYS_MICRO_APPLICATION_CONF`  (
  `MA_ID` bigint(20) NOT NULL,
  `MA_ACTIVE_RULE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '匹配路由',
  `MA_PRELOAD` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否一登录就加载子应用(0代表不开启预加载，1代表开启,默认是1)',
  `NEED_VFG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否需要可视化设计器0代表不需要，1代表需要,默认是1',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人ID',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `MA_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置状态：0，禁用1启用,默认是1',
  `MA_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微应用标识',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属应用',
  `MA_ENTRY` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '挂载入口',
  `MA_CONTAINER` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '挂载容器',
  PRIMARY KEY (`MA_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '微应用配置信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MICRO_APPLICATION_CONF
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MIGRATION_DUMP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MIGRATION_DUMP`;
CREATE TABLE `SYS_MIGRATION_DUMP`  (
  `DUMP_ID` bigint(20) NOT NULL COMMENT '主键任务 ID',
  `DUMP_STATUS` int(11) NULL DEFAULT NULL COMMENT '导出任务状态 (1 就绪, 2 队列中, 3 执行中, 0 成功, -1 失败)',
  `DUMP_DESCRIPTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导出任务附加说明信息',
  `DUMP_PARAMETERS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导出任务参数 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `DUMP_FILE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导出成功后存储的文件',
  `DUMP_RESULT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导出任务结果 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `DUMP_ERROR` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导出任务失败简要说明信息',
  `DUMP_START` timestamp NULL DEFAULT NULL COMMENT '导出实际开始时间',
  `DUMP_END` timestamp NULL DEFAULT NULL COMMENT '导出实际结束时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`DUMP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据迁移导出任务记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MIGRATION_DUMP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MIGRATION_LOAD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MIGRATION_LOAD`;
CREATE TABLE `SYS_MIGRATION_LOAD`  (
  `LOAD_ID` bigint(20) NOT NULL COMMENT '主键任务 ID',
  `LOAD_STATUS` int(11) NULL DEFAULT NULL COMMENT '导入任务状态 (1 检查就绪, 2 检查队列中, 3 执行检查中, 4 导入就绪, 5 导入队列中, 6 执行导入中, 0 成功, -1 校验失败, -2 导入失败)',
  `ARCHIVE_FILE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入上传阶段成功后存储的文件',
  `ARCHIVE_UUID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '导入包 UUID',
  `ARCHIVE_DESCRIPTION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入包说明信息',
  `ARCHIVE_DETAIL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入包解析结果 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `LOAD_ERROR` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入任务失败简要说明信息',
  `LOAD_EXPLANATION` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入操作的备注信息',
  `PRELOAD_PARAMETERS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '检查参数 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `PRELOAD_RESULT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '检查结果 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `PRELOAD_START` timestamp NULL DEFAULT NULL COMMENT '检查实际开始时间',
  `PRELOAD_END` timestamp NULL DEFAULT NULL COMMENT '检查实际结束时间',
  `LOAD_PARAMETERS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入任务参数 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `LOAD_RESULT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '导入结果 JSON 日志 (EMBED: 内嵌数据, EXTERNAL: 外部存储)',
  `LOAD_START` timestamp NULL DEFAULT NULL COMMENT '导入实际开始时间',
  `LOAD_END` timestamp NULL DEFAULT NULL COMMENT '导入实际结束时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`LOAD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据迁移导入任务记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MIGRATION_LOAD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_APP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_APP`;
CREATE TABLE `SYS_MOBILE_APP`  (
  `APP_ID` bigint(20) NOT NULL COMMENT '移动应用id',
  `APP_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `RESOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用类型 1内部应用 2外部应用',
  `ICON_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留 图标 1内部图标 2外部图标',
  `ICON_URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图标地址\r 若无，则为默认图标。\r系统图标时，图标路径地址。自定义图标时，图标上传地址。',
  `LINK_URL` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '内部应用时，为页面路由地址。\r外部应用时，为外部H5链接地址\r',
  `GROUP_ID` bigint(20) NULL DEFAULT NULL COMMENT '分组id',
  `DEFAULT_APP` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否默认 0：否\r1：是\r',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`APP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动应用表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_APP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_APP_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_APP_GROUP`;
CREATE TABLE `SYS_MOBILE_APP_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '分组id',
  `GROUP_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动应用分组表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_APP_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_APP_PERMISSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_APP_PERMISSION`;
CREATE TABLE `SYS_MOBILE_APP_PERMISSION`  (
  `PERMISSION_ID` bigint(20) NOT NULL COMMENT '移动门户应用权限id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '移动门户应用id',
  `TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限类型0人员 1部门 2角色',
  `RELATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '权限关联的人员id或部门id或角色id',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`PERMISSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '门户应用权限管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_APP_PERMISSION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_EXTERNAL_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_EXTERNAL_CONFIG`;
CREATE TABLE `SYS_MOBILE_EXTERNAL_CONFIG`  (
  `CONFIG_ID` bigint(20) NOT NULL COMMENT '移动端三方集成id',
  `APP_KEY` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'appkey',
  `APP_SECRET` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'appSecret',
  `PLATFORM` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '平台类型 ',
  `SERVER_URL` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留（对接金企信使用）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间\r\n',
  PRIMARY KEY (`CONFIG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动三方集成配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_EXTERNAL_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_FRAMEWORK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_FRAMEWORK`;
CREATE TABLE `SYS_MOBILE_FRAMEWORK`  (
  `MOBILE_FRAMEWORK_ID` bigint(20) NOT NULL COMMENT '主键id',
  `LAYOUT_FORM` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '布局形式',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`MOBILE_FRAMEWORK_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动端框架页配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_FRAMEWORK
-- ----------------------------
INSERT INTO `SYS_MOBILE_FRAMEWORK` VALUES (744979918357798912, '0', 1450756958461300737, '2023-08-18 18:04:14', 1450756958461300737, '2023-08-18 18:04:14', NULL);

-- ----------------------------
-- Table structure for SYS_MOBILE_FRAMEWORK_MENU
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_FRAMEWORK_MENU`;
CREATE TABLE `SYS_MOBILE_FRAMEWORK_MENU`  (
  `FRAMEWORK_MENU_ID` bigint(20) NOT NULL COMMENT '主键id',
  `MOBILE_FRAMEWORK_ID` bigint(20) NULL DEFAULT NULL COMMENT '框架页配置表ID',
  `SYSTEM_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '系统名称',
  `SYSTEM_ICON_ID` bigint(20) NULL DEFAULT NULL COMMENT '系统图标ID',
  `SYSTEM_ICON_SELECT_ID` bigint(20) NULL DEFAULT NULL COMMENT '选中系统图标ID',
  `PAGE_CONTENT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面内容',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`FRAMEWORK_MENU_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动端框架页配置菜单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_FRAMEWORK_MENU
-- ----------------------------
INSERT INTO `SYS_MOBILE_FRAMEWORK_MENU` VALUES (744979918613651456, 744979918357798912, '首页', 744979806621540352, 744979823763660800, '0', 1450756958461300737, '2023-08-18 18:04:14', 1450756958461300737, '2023-08-18 18:04:14', NULL);
INSERT INTO `SYS_MOBILE_FRAMEWORK_MENU` VALUES (744979918634622976, 744979918357798912, '新闻资讯', 744979881481478144, 744979900045467648, '0', 1450756958461300737, '2023-08-18 18:04:14', 1450756958461300737, '2023-08-18 18:04:14', NULL);

-- ----------------------------
-- Table structure for SYS_MOBILE_FRAMEWORK_PARAM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_FRAMEWORK_PARAM`;
CREATE TABLE `SYS_MOBILE_FRAMEWORK_PARAM`  (
  `FRAMEWORK_PARAM_ID` bigint(20) NOT NULL COMMENT '主键id',
  `FRAMEWORK_RESOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '框架页配置资源表ID',
  `PARAM_CONFIG_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数配置名称',
  `PARAM_CONFIG_VALUE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数配置值',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`FRAMEWORK_PARAM_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动端框架页配置参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_FRAMEWORK_PARAM
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_FRAMEWORK_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_FRAMEWORK_RESOURCE`;
CREATE TABLE `SYS_MOBILE_FRAMEWORK_RESOURCE`  (
  `FRAMEWORK_RESOURCE_ID` bigint(20) NOT NULL COMMENT '主键id',
  `FRAMEWORK_MENU_ID` bigint(20) NULL DEFAULT NULL COMMENT '框架页配置菜单表ID',
  `OPEN_WAY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '打开方式',
  `CONNECT_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '连接地址',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`FRAMEWORK_RESOURCE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动端框架页配置资源表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_FRAMEWORK_RESOURCE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MOBILE_LOGIN_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MOBILE_LOGIN_CONFIG`;
CREATE TABLE `SYS_MOBILE_LOGIN_CONFIG`  (
  `LOGIN_CONFIG_ID` bigint(20) NOT NULL COMMENT '主键id',
  `LAYOUT_FORM` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '布局形式',
  `SYSTEM_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '系统名称',
  `SYSTEM_ICON_ID` bigint(20) NULL DEFAULT NULL COMMENT '系统图标ID',
  `WELCOME_MESSAGE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '欢迎语',
  `BACKGROUND_PICTURE_ID` bigint(20) NULL DEFAULT NULL COMMENT '背景图ID',
  `REGISTER_SHOW` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册是否显示',
  `PASSWORD_SHOW` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记住密码是否显示',
  `SAVE_DAYS` int(11) NULL DEFAULT NULL COMMENT '保存天数',
  `THIRD_PARTY_SHOW` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '第三方登录是否显示',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`LOGIN_CONFIG_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '移动端登录页配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_MOBILE_LOGIN_CONFIG
-- ----------------------------
INSERT INTO `SYS_MOBILE_LOGIN_CONFIG` VALUES (744979653969846272, '0', '智能工作台', 744979203438682112, '欢迎使用智能工作台!', NULL, '0', '0', 7, '0', 1450756958461300737, '2023-08-18 18:03:11', 1450756958461300737, '2023-08-18 18:03:11', NULL);

-- ----------------------------
-- Table structure for SYS_MSG_PUSH_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MSG_PUSH_CONFIG`;
CREATE TABLE `SYS_MSG_PUSH_CONFIG`  (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用 ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单 ID',
  `REMINDER_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒类型',
  `FIRST_REMINDER_TIME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '首次提醒时间',
  `REPEAT_RULE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重复规则',
  `END_REMINDER_TIME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束提醒时间',
  `MODIFIED_FIELDS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改字段范围',
  `REMINDER_CONDITION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒条件',
  `REMINDER_CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '提醒文字',
  `REMINDERS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被提醒人',
  `REMINDER_MODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒方式',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开启状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标志',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_MSG_PUSH_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_MSG_PUSH_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_MSG_PUSH_TASK`;
CREATE TABLE `SYS_MSG_PUSH_TASK`  (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用 ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单 ID',
  `CONFIG_ID` bigint(20) NULL DEFAULT NULL COMMENT '配置 ID',
  `DATA_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据 ID',
  `REMINDER_TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒类型',
  `FIRST_REMINDER_TIME` datetime NULL DEFAULT NULL COMMENT '首次提醒时间',
  `REPEAT_RULE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '重复规则',
  `NEXT_REMINDER_TIME` datetime NULL DEFAULT NULL COMMENT '下次提醒时间',
  `END_REMINDER_TIME` datetime NULL DEFAULT NULL COMMENT '结束提醒时间',
  `REMINDER_CONTENT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒文字',
  `REMINDERS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被提醒人',
  `REMINDER_MODE` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '提醒方式',
  `STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '执行状态',
  `EXECUTE_TIME` datetime NULL DEFAULT NULL COMMENT '执行时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标志',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_MSG_PUSH_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_NOCODE_CONDITION_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_NOCODE_CONDITION_INFO`;
CREATE TABLE `SYS_NOCODE_CONDITION_INFO`  (
  `CONDITION_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `VIEW_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图ID',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `FIELD_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段信息',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`CONDITION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '零代码查询条件信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_NOCODE_CONDITION_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_NOCODE_CUSTOM_FIELD_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_NOCODE_CUSTOM_FIELD_INFO`;
CREATE TABLE `SYS_NOCODE_CUSTOM_FIELD_INFO`  (
  `INFO_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `VIEW_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图ID',
  `FIELD_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '字段信息',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义字段信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_NOCODE_CUSTOM_FIELD_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_NOTICE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_NOTICE`;
CREATE TABLE `SYS_NOTICE`  (
  `NOTICE_ID` bigint(20) NOT NULL COMMENT '通知公告ID',
  `NOTICE_TYPE_ID` bigint(20) NOT NULL COMMENT '公告类型ID',
  `NOTICE_TITLE` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '公告标题',
  `APPROVER_ID` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `RELEASE_DATE` datetime NOT NULL COMMENT '发布日期',
  `CREATE_TIME` datetime NOT NULL COMMENT '创建时间',
  `NOTICE_CONTENT` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '公告内容',
  `DEPARTMENT_ID` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布范围(部门ID)',
  `ROLE_ID` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '发布范围(角色ID)',
  `CREATOE_DEPARTMENT_ID` bigint(20) NOT NULL DEFAULT 111 COMMENT '创建者部门ID',
  `NOTICE_ISSUE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布者(公司或部门名称)',
  `CREATOR` bigint(20) NOT NULL DEFAULT 111 COMMENT '公告创建者(ID)',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  `DEPT_ROLE_NAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '发布范围名称',
  PRIMARY KEY (`NOTICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '通知公告详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_NOTICE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_NOTICE_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_NOTICE_ATTACHMENT`;
CREATE TABLE `SYS_NOTICE_ATTACHMENT`  (
  `NOTICE_ATT_ID` bigint(20) NOT NULL COMMENT '通知公告与附件关系id',
  `NOTICE_ID` bigint(20) NOT NULL DEFAULT 0 COMMENT '通知公告id',
  `NOTICE_ATTACHMENT_ID` bigint(20) NOT NULL DEFAULT 0 COMMENT '附件id',
  `NOTICE_ATTACHMENT_TITLE` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '附件名称',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '	创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`NOTICE_ATT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '通知公告附件关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_NOTICE_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_NOTICE_ROLE_DEPARTMENT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_NOTICE_ROLE_DEPARTMENT`;
CREATE TABLE `SYS_NOTICE_ROLE_DEPARTMENT`  (
  `NOTICE_DEPARTMENT_ROLE_ID` bigint(20) NOT NULL COMMENT '通知公告部门角色关系id',
  `NOTICE_ID` bigint(20) NOT NULL COMMENT '通知公告id',
  `NOTICE_SCOPE_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '发布范围(department,role)',
  `NOTICE_BUSINESS_ID` bigint(20) NOT NULL COMMENT '业务id(部门id或角色id)',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  PRIMARY KEY (`NOTICE_DEPARTMENT_ROLE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '通知公告角色部门关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_NOTICE_ROLE_DEPARTMENT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_OFFICE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_OFFICE`;
CREATE TABLE `SYS_OFFICE`  (
  `OFFICE_ID` bigint(20) NOT NULL COMMENT '组织机构id',
  `STRU_ID` bigint(20) NULL DEFAULT NULL COMMENT '对应的组织结构id（注：不是所属）',
  `OFFICE_ALIAS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构描述',
  `OFFICE_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系地址',
  PRIMARY KEY (`OFFICE_ID`) USING BTREE,
  INDEX `SYS_OFFICE_STRU_ID_IDX`(`STRU_ID` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织机构扩展表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_OFFICE
-- ----------------------------
INSERT INTO `SYS_OFFICE` VALUES (1, 1, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_OFFICE_AUDIT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_OFFICE_AUDIT`;
CREATE TABLE `SYS_OFFICE_AUDIT`  (
  `OFFICE_ID` bigint(20) NOT NULL COMMENT '组织机构id',
  `STRU_ID` bigint(20) NULL DEFAULT NULL COMMENT '对应的组织结构id（注：不是所属）',
  `OFFICE_ALIAS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构描述',
  `OFFICE_ADDRESS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系地址',
  `REAL_OFFICE_ID` bigint(20) NULL DEFAULT NULL COMMENT '关联SYS_OFFICE表OFFICE_ID',
  PRIMARY KEY (`OFFICE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织机构扩展表审核表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_OFFICE_AUDIT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ONLINE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ONLINE`;
CREATE TABLE `SYS_ONLINE`  (
  `SESSION_ID` bigint(20) NOT NULL COMMENT '会话标识',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户账户',
  `USER_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名称',
  `CORPORATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '公司编码',
  `CORPORATION_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `LOGIN_TIME` datetime NULL DEFAULT NULL COMMENT '登录时间',
  `LOGOFF_TIME` datetime NULL DEFAULT NULL COMMENT '注销时间',
  `REMOTEADDR` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端地址',
  `REMOTEHOST` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端主机名',
  `REMOTEPORT` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端端口号',
  `BROWSER_TYPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '浏览器类型',
  `USER_ACCOUNT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户登录账号',
  PRIMARY KEY (`SESSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '在线用户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_ONLINE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ONLINE_HIST
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ONLINE_HIST`;
CREATE TABLE `SYS_ONLINE_HIST`  (
  `HIS_ID` bigint(20) NOT NULL COMMENT '主键',
  `TOKEN_ID` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '令牌标识',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `USER_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名称',
  `CORPORATION_ID` bigint(20) NULL DEFAULT NULL COMMENT '公司编码',
  `CORPORATION_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `LOGIN_TIME` datetime NULL DEFAULT NULL COMMENT '登录时间',
  `LOGOFF_TIME` datetime NULL DEFAULT NULL COMMENT '注销时间',
  `REMOTEADDR` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端地址',
  `REMOTEHOST` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端主机名',
  `REMOTEPORT` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户端端口号',
  `BROWSER_TYPE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '浏览器类型',
  `USER_ACCOUNT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户登录账号',
  PRIMARY KEY (`HIS_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '在线用户历史' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_ONLINE_HIST
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ORGAN
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ORGAN`;
CREATE TABLE `SYS_ORGAN`  (
  `ORGAN_ID` bigint(20) NOT NULL COMMENT '组织编码',
  `ORGAN_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织代码',
  `ORGAN_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `ORGAN_FCODE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全机构编码',
  `ORGAN_FNAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全路径',
  `SHORT_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织简称',
  `ORGAN_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型编码',
  `WORKPLACE_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作地点编码',
  `BEGIN_DATE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录生效日期',
  `END_DATE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录失效日期',
  `SCN` int(11) NULL DEFAULT NULL COMMENT '对应的系统更改号',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `PARENT_TYPE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '不同组织机构类型编码',
  `ORGAN_PROPERTY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '组织属性： 0 公司内部组织 1 公司外部组织',
  `VALID_TIME_LIMIT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '组织时效类型：0 长期组织 1 临时组织',
  `ORGAN_NAME_PINYIN_FULL` VARCHAR(200)  NULL COMMENT '组织结构名称全拼',
  `ORGAN_NAME_PINYIN_INITIAL` VARCHAR(200)  NULL COMMENT '组织结构称首字母拼音',
  PRIMARY KEY (`ORGAN_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织机构' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_ORGAN
-- ----------------------------
INSERT INTO `SYS_ORGAN`(`ORGAN_ID`, `ORGAN_CODE`, `ORGAN_NAME`, `ORGAN_FCODE`, `ORGAN_FNAME`, `SHORT_NAME`, `ORGAN_TYPE`, `WORKPLACE_ID`, `BEGIN_DATE`, `END_DATE`, `SCN`, `DEL_FLAG`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `PARENT_TYPE_CODE`, `ORGAN_NAME_PINYIN_FULL`, `ORGAN_NAME_PINYIN_INITIAL`) VALUES (1, '1', '金现代信息产业股份有限公司', '/1/', '/金现代信息产业股份有限公司','金现代', '1', '1', '2018-03-19', '2019-03-19', -1, '0', NULL, NULL, NULL, NULL, NULL, 'jinxiandaixinxichanyegufenyouxiangongsi', 'jxdxxcygfyxgs');
INSERT INTO `SYS_ORGAN` VALUES (841342784861642753, '00000000001', '开发团队', '/00000000001/', '/开发团队', '开发团队', '1', NULL, NULL, NULL, NULL, '0', 679338378499727360, '2024-05-10 15:55:51', 679338378499727360, '2024-05-10 15:55:52', NULL, '1', '0','','');

-- ----------------------------
-- Table structure for SYS_ORGAN_AUDIT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ORGAN_AUDIT`;
CREATE TABLE `SYS_ORGAN_AUDIT`  (
  `ORGAN_ID` bigint(20) NOT NULL COMMENT '组织编码',
  `ORGAN_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织代码',
  `ORGAN_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `ORGAN_FCODE` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全机构编码',
  `ORGAN_FNAME` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全路径',
  `SHORT_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织简称',
  `ORGAN_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型编码',
  `WORKPLACE_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作地点编码',
  `BEGIN_DATE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录生效日期',
  `END_DATE` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录失效日期',
  `SCN` int(11) NULL DEFAULT NULL COMMENT '对应的系统更改号',
  `IN_USE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `PARENT_TYPE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级类型编码',
  `REAL_ORGAN_ID` bigint(20) NULL DEFAULT NULL COMMENT '关联SYS_ORGAN表organ_id',
  `ORGAN_PROPERTY` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '组织属性： 0 公司内部组织 1 公司外部组织',
  `VALID_TIME_LIMIT_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '组织时效类型：0 长期组织 1 临时组织',
  PRIMARY KEY (`ORGAN_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织机构审核表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_ORGAN_AUDIT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ORGAN_TYPE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ORGAN_TYPE`;
CREATE TABLE `SYS_ORGAN_TYPE`  (
  `TYPE_ID` bigint(20) NOT NULL COMMENT '主键',
  `ORGAN_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '组织类型编码',
  `TYPE_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型名称',
  `PARENT_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级组织类型',
  `IN_USE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用标识',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '上次编辑者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '上次编辑时间',
  `IS_SYSTEM` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否系统标识',
  `IMG_URL` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片url',
  PRIMARY KEY (`ORGAN_TYPE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组织类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_ORGAN_TYPE
-- ----------------------------
INSERT INTO `SYS_ORGAN_TYPE` VALUES (1, '1', '单位', '0', '1', NULL, '2018-02-27 13:20:16', NULL, '2018-04-08 15:48:20', '1', 'tree-department');
INSERT INTO `SYS_ORGAN_TYPE` VALUES (2, '2', '部门', '1', '1', NULL, '2018-03-13 09:55:00', NULL, '2018-03-19 14:27:27', '1', 'unit');

-- ----------------------------
-- Table structure for SYS_PAGE_EXPAND
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PAGE_EXPAND`;
CREATE TABLE `SYS_PAGE_EXPAND`  (
  `ID` bigint(20) NOT NULL COMMENT '页面ID',
  `NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面英文名',
  `TITLE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面名称或页面名称',
  `TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面类型',
  `LOGO` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '页面图标',
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面描述文字',
  `AUTHOR` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面作者',
  `VERSION` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面版本',
  `OPTIONS` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '页面内容描述',
  `FILE_ID` bigint(20) NULL DEFAULT NULL COMMENT '页面上传附件ID',
  `GROUP_ID` bigint(20) NULL DEFAULT NULL COMMENT '页面分组ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑删除字段',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '拓展页面信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PAGE_EXPAND
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PAGE_EXPAND_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PAGE_EXPAND_GROUP`;
CREATE TABLE `SYS_PAGE_EXPAND_GROUP`  (
  `GROUP_ID` bigint(20) NOT NULL COMMENT '分组ID',
  `GROUP_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `GROUP_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组类型 1:默认分组 2：普通分组',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '逻辑删除',
  PRIMARY KEY (`GROUP_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '拓展页面分组信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PAGE_EXPAND_GROUP
-- ----------------------------
INSERT INTO `SYS_PAGE_EXPAND_GROUP` VALUES (1, '默认分组', '1', 1450756958461300737, '2023-10-11 10:43:37', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_PANEL
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PANEL`;
CREATE TABLE `SYS_PANEL`  (
  `PANEL_ID` bigint(20) NOT NULL COMMENT '仪表盘id,与sys_form中的id一致',
  `PANEL_FILTER` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '仪表盘筛选条件',
  `PANEL_LAYOUT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '仪表盘布局配置',
  `PANEL_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仪表盘状态',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '仪表盘所属应用ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仪表盘删除标识',
  `PANEL_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仪表盘名称',
  PRIMARY KEY (`PANEL_ID`) USING BTREE,
  INDEX `sys_panel-app_idkey`(`APP_ID` ASC) USING BTREE COMMENT 'appid索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仪表盘信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_PANEL
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PANEL_CHART
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PANEL_CHART`;
CREATE TABLE `SYS_PANEL_CHART`  (
  `CHART_ID` bigint(20) NOT NULL COMMENT '图表id',
  `CHART_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图表名称',
  `CHART_FILTER` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图表筛选条件',
  `CHART_LAYOUT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图表布局配置',
  `CHART_DIMENSION1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图表维度1',
  `CHART_DIMENSION2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图表维度2',
  `CHART_TARGET` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图表指标',
  `CHART_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图表状态',
  `PANEL_ID` bigint(20) NULL DEFAULT NULL COMMENT '图表所述仪表盘ID',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '图表所属应用ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图表删除标识',
  `DATASOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '数据源ID',
  `DATASOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源类型',
  `CHART_TYPE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图表类型',
  `DATASOURCE_NAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '数据源名称',
  PRIMARY KEY (`CHART_ID`) USING BTREE,
  INDEX `sys_panel_chart-panel_id-key`(`PANEL_ID` ASC) USING BTREE COMMENT '仪表盘id索引',
  INDEX `sys_panel_chart-app_id-key`(`APP_ID` ASC) USING BTREE COMMENT 'app_id索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仪表盘的图表信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_PANEL_CHART
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PASSWORD_HIST
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PASSWORD_HIST`;
CREATE TABLE `SYS_PASSWORD_HIST`  (
  `SPH_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NOT NULL COMMENT '用户ID',
  `PASSWORD` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '密码',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次更新时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次更新人',
  PRIMARY KEY (`SPH_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '密码生命周期' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PASSWORD_HIST
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PLUGIN_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PLUGIN_INFO`;
CREATE TABLE `SYS_PLUGIN_INFO`  (
  `INFO_ID` bigint(20) NOT NULL COMMENT '插件信息id',
  `VERSION_ID` bigint(20) NULL DEFAULT NULL COMMENT '插件版本id',
  `PLUGIN_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件名称',
  `PLUGIN_DESCRIPTOR` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件描述',
  `PLUGIN_STATE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件状态（enabled已启用，unistall 已卸载）',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `CURRENT_VERSION` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前版本号',
  `PLUGIN_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件配置文件中的id (是字符串，不是主键)',
  PRIMARY KEY (`INFO_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '插件信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PLUGIN_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PLUGIN_VERSION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PLUGIN_VERSION`;
CREATE TABLE `SYS_PLUGIN_VERSION`  (
  `VERSION_ID` bigint(20) NOT NULL COMMENT '插件版本id',
  `INFO_ID` bigint(20) NULL DEFAULT NULL COMMENT '插件信息id',
  `PLUGIN_VERSION` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件版本号名称',
  `FILE_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上传文件名称',
  `JAR_PATH` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '插件存放路径',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `VERSION_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前版本标识（0未启用，1已启用）',
  PRIMARY KEY (`VERSION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '插件版本信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PLUGIN_VERSION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_POST
-- ----------------------------
DROP TABLE IF EXISTS `SYS_POST`;
CREATE TABLE `SYS_POST`  (
  `POST_ID` bigint(20) NOT NULL COMMENT '主键',
  `POST_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位编码',
  `POST_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '岗位名',
  `ORGAN_TYPE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位类型编码',
  `POST_DESC` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位描述',
  `POST_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序编号',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`POST_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_POST
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_POST_AUDIT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_POST_AUDIT`;
CREATE TABLE `SYS_POST_AUDIT`  (
  `AUDIT_ID` bigint(20) NOT NULL COMMENT '审核单ID',
  `AUDIT_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批状态：状态 0  待审核 1 审核通过 2 审核驳回',
  `POST_ID` bigint(20) NULL DEFAULT NULL COMMENT '岗位ID',
  `POST_CODE` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位编码',
  `POST_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '岗位名',
  `ORGAN_TYPE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织类型编码',
  `POST_DESC` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位描述',
  `POST_ORDER` int(11) NULL DEFAULT NULL COMMENT '排序',
  `STRU_ID_LIST` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '岗位关联组织ID列表，以逗号分隔',
  `STAFF_ID_LIST` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '岗位关联人员ID列表，以逗号分隔',
  `ROLE_ID_LIST` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '岗位关联角色ID列表，以逗号分隔',
  `OPERATE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作类型：增 1 改 2 删 3',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`AUDIT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位审核表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_POST_AUDIT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_POST_ROLE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_POST_ROLE`;
CREATE TABLE `SYS_POST_ROLE`  (
  `POST_ROLE_ID` bigint(20) NOT NULL COMMENT '主键',
  `POST_ID` bigint(20) NULL DEFAULT NULL COMMENT '岗位id',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色id',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标识',
  PRIMARY KEY (`POST_ROLE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位角色关联关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_POST_ROLE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_POST_ROLE_AUDIT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_POST_ROLE_AUDIT`;
CREATE TABLE `SYS_POST_ROLE_AUDIT`  (
  `AUDIT_ID` bigint(20) NOT NULL COMMENT '审核单ID',
  `POST_ID` bigint(20) NULL DEFAULT NULL COMMENT '岗位id',
  `ROLE_ID` bigint(20) NULL DEFAULT NULL COMMENT '角色id',
  `AUDIT_STATUS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批状态：状态 0  待审核 1 审核通过 2 审核驳回',
  `OPERATE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作类型：增 1 删 2',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改人',
  `DEL_FLAG` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除标识',
  PRIMARY KEY (`AUDIT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位角色审核表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_POST_ROLE_AUDIT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PRINT_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PRINT_TEMPLATE`;
CREATE TABLE `SYS_PRINT_TEMPLATE`  (
  `PRINT_ID` bigint(20) NOT NULL COMMENT '打印模版id',
  `APP_ID` bigint(20) NULL DEFAULT NULL COMMENT '应用id',
  `FORM_ID` bigint(20) NULL DEFAULT NULL COMMENT '表单id',
  `NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模版名称',
  `TYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '模版类型:excel/word',
  `CONTENT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'excel模版内容/word模版路径',
  `ENABLED` smallint NULL DEFAULT NULL COMMENT '模版是否启用，1:启用，0:禁用',
  `FILE_NAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '生成文件名',
  `USING_SCOPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用范围：1:查看详情时,2:公开查询,3:单条数据分享',
  `VISIBLE_SCOPE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '可见范围',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`PRINT_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '打印模板表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_PRINT_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PUBLISH_RECORD
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PUBLISH_RECORD`;
CREATE TABLE `SYS_PUBLISH_RECORD`  (
  `RECORD_ID` bigint(20) NOT NULL COMMENT '主键',
  `SOURCE_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面/方法ID',
  `SOURCE_TYPE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源类型',
  `MENU_ID` bigint(20) NULL DEFAULT NULL COMMENT '菜单ID',
  `FUNCTION_ID` bigint(20) NULL DEFAULT NULL COMMENT '功能ID',
  `RESOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '资源ID',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次更新人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次更新时间',
  PRIMARY KEY (`RECORD_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '管理菜单资源功能与天斧页面、接口资源表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_PUBLISH_RECORD
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_PUBLISH_SERVER
-- ----------------------------
DROP TABLE IF EXISTS `SYS_PUBLISH_SERVER`;
CREATE TABLE `SYS_PUBLISH_SERVER`  (
  `SERVER_ID` bigint(20) NOT NULL COMMENT '环境id，主键',
  `SERVER_IP` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '环境ip地址',
  `SERVER_PORT` int(11) NULL DEFAULT NULL COMMENT '环境端口号',
  `SERVER_NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '环境名称',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  PRIMARY KEY (`SERVER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_PUBLISH_SERVER
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_QUERY_CONDITION_INFO
-- ----------------------------
DROP TABLE IF EXISTS `SYS_QUERY_CONDITION_INFO`;
CREATE TABLE `SYS_QUERY_CONDITION_INFO`  (
  `CONDITION_ID` bigint(20) NOT NULL COMMENT '主键',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `PAGE_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面ID',
  `COMPONENT_ID` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件ID',
  `QUERY_CONDITION_INFO` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '查询条件',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  `IS_DEFAULT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否默认，默认为1',
  PRIMARY KEY (`CONDITION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '查询条件信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_QUERY_CONDITION_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_QUOTE_RELATION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_QUOTE_RELATION`;
CREATE TABLE `SYS_QUOTE_RELATION`  (
  `QUOTE_ID` bigint(20) NOT NULL COMMENT '主键ID',
  `RES_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被引用资源id',
  `REFER_RES_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用资源id',
  `REFER_TYPE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用类型',
  `INSTANCE_KEY` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用组件',
  `REFER_POS_ID` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存放actionId、conditionId等\n',
  `REFER_FIELD` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用字段',
  `REFER_FIELD_DESC` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用字段描述',
  `REFER_PATH` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用路径',
  `EVENT_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动作类引用',
  `USE_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用途类型，page资源，template我的模板，combination自定义组件',
  `MODULE_TYPE` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '引用模块类型',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`QUOTE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '组件引用关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_QUOTE_RELATION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_REGION_INFORMATION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_REGION_INFORMATION`;
CREATE TABLE `SYS_REGION_INFORMATION`  (
  `REGION_ID` bigint(20) NOT NULL COMMENT '地区id（地区行政编号）',
  `REGION_NAME` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '地区名称',
  `REGION_SHORT_NAME` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地区名称缩写',
  `REGION_PARENT_ID` bigint(20) NOT NULL COMMENT '地区父id（无父级为0）',
  `REGION_LEVEL` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '地区级别',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后一次修改人',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后一次修改时间',
  PRIMARY KEY (`REGION_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '地区信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_REGION_INFORMATION
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_REPORT
-- ----------------------------
DROP TABLE IF EXISTS `SYS_REPORT`;
CREATE TABLE `SYS_REPORT`  (
  `ID_` bigint(20) NOT NULL COMMENT '报表',
  `NAME_` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报表名称',
  `CONTENT_` mediumblob NULL COMMENT '报表内容',
  `CREATE_TIME_` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '创建时间',
  `UPDATE_TIME_` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) COMMENT '更新时间',
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '报表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of SYS_REPORT
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_RESOURCES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_RESOURCES`;
CREATE TABLE `SYS_RESOURCES`  (
  `RESOURCE_ID` bigint(20) NOT NULL COMMENT '资源编码',
  `RESOURCE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源英文名称',
  `RESOURCE_ALIAS` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源业务语义',
  `MODULE_ID` bigint(20) NULL DEFAULT NULL COMMENT '所属模块ID',
  `PATH` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件根路径',
  `COMPONENT` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件引入路径',
  `IS_AUDIT` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否执行审计操作',
  `RES_TYPE_ID` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源操作类型编码',
  `SEQ` int(11) NULL DEFAULT NULL COMMENT '资源排序',
  `IS_REPEAT_AUTHENTICATE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否二次验证',
  `STRATEGY` char(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '使用场景（-1：重启，3：预览，2：生产）',
  `KEEP_ALIVE` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面激活状态',
  `CREATOR` bigint(20) NULL DEFAULT NULL COMMENT '创建者',
  `CREATE_TIME` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `LAST_EDITOR` bigint(20) NULL DEFAULT NULL COMMENT '最后修改者',
  `LAST_TIME` datetime NULL DEFAULT NULL COMMENT '最后修改时间',
  `RESOURCE_CODE` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资源编码',
  `URL_NAMES` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'URL名称',
  `PERMISSIONS` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限标识',
  `IS_SYS` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否是系统资源',
  `SERVICE_NAME` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务标识',
  `USER_RIGHTS` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户权限字段',
  `DEPT_RIGHTS` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '部门权限字段',
  `MAPPER` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据查询方法',
  `APPLICATION_ID` bigint(20) NULL DEFAULT 1 COMMENT '所属应用的id，默认1：属于统一权限平台自身数据',
  `PARENT_RESOURCE_ID` bigint(20) NULL DEFAULT NULL COMMENT '上级资源id',
  PRIMARY KEY (`RESOURCE_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能资源' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of SYS_RESOURCES
-- ----------------------------
INSERT INTO `SYS_RESOURCES` VALUES (518451664789970944, '客户端管理', '客户端管理', 518447803329159168, '/authClientModel', 'HussarClient/src/views/client/client', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2021-12-01 15:41:49', 1450756958461300737, '2021-12-01 15:41:49', '02250002', '/authClientModel', 'authClientModel:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (520236254294712320, '插件管理', '插件管理', 520204840551587840, '/pluginsManage', 'HussarPlugin/src/views/pluginsManage/pluginList', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2021-12-06 13:53:09', 1450756958461300737, '2021-12-06 13:53:09', '02150001', '/plugin/pluginList', 'plugin:pluginList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (521403853758013440, '应用注册', '应用注册', 528148369617723392, '/unifiedtodoSystem', 'HussarUnifiedtodo/src/views/system/unifiedtodoSystem', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2021-12-09 19:12:46', 1450756958461300737, '2021-12-09 19:12:46', '02200001', '/unifiedtodoSystem', 'unifiedtodoSystem:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (522705027572441088, '我的待办', '我的待办', 521403268396752896, '/unifiedtodoToDoTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoToDoTask', '0', 'res_menu', 2, '0', '1', NULL, 1450756958461300737, '2021-12-13 09:23:10', 1450756958461300737, '2021-12-13 09:23:10', '02200005', '/unifiedtodoToDoTask', 'unifiedtodoToDoTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (523554762252361728, '我的已办', '我的已办', 521403268396752896, '/unifiedtodoDoneTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoDoneTask', '0', 'res_menu', 3, '0', '1', NULL, 1450756958461300737, '2021-12-15 17:39:42', 1450756958461300737, '2021-12-15 17:39:42', '02200001', '/unifiedtodoDoneTask', 'unifiedtodoDoneTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (523555173533229056, '我的传阅', '我的传阅', 521403268396752896, '/unifiedtodoCcTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoCcTask', '0', 'res_menu', 4, '0', '1', NULL, 1450756958461300737, '2021-12-15 17:41:21', 1450756958461300737, '2021-12-15 17:41:21', '02200002', '/unifiedtodoCcTask', 'unifiedtodoCcTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (526077294431969280, '我的公告', '我的公告', 526435626275577856, '/noticeList', 'HussarNotice/src/views/notice/list', '0', 'res_menu', 1, '0', '1', NULL, 1450756958461300737, '2021-12-22 16:43:21', 1450756958461300737, '2021-12-22 16:43:21', '02310008', '/noticeList', 'notice:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (526117603765395456, '公告列表跳转', '公告列表跳转', 526117093318598656, '/myNotice/list', '', '0', 'res_btn', 1, '0', '1', NULL, 1450756958461300737, '2021-12-22 19:23:32', 1450756958461300737, '2021-12-22 19:23:32', '02360002', '/myNotice/list', 'myNotice:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (535768620278751232, '审计查阅', '审计查阅', 535768124604293120, '/auditAccess', 'HussarAudit/src/views/system/auditAccess/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-01-18 10:33:13', 1450756958461300737, '2022-01-18 10:33:13', '02270001', '/auditAccess', 'auditAccess:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (544468972511436800, '主题配置', '主题配置', 544468727815741440, '/themeConfig', 'HussarThemeConfig/src/views/themeConf/ThemeConf', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-02-11 10:45:19', 1450756958461300737, '2022-02-11 10:45:19', '02150001', '/themeConfig', '', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (544474404047036416, '任务管理', '任务管理', 544474526055145472, '/scheduleManagement', 'HussarSchedule/src/views/schedule/scheduleManagement', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-02-11 11:06:54', 1450756958461300737, '2022-02-11 11:07:30', '02250001', '/scheduleManagement', 'schedule:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (544475544734146560, '任务实例', '任务实例', 544474679767998464, '/scheduleInstance', 'HussarSchedule/src/views/scheduleInstance/scheduleInstance', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-02-11 11:11:26', 1450756958461300737, '2022-02-11 11:29:24', '02220001', '/scheduleInstance', 'scheduleInstance:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (545564853264457728, '统一日志', '统一日志', 545564576406839296, '/unifiedLog', 'HussarUnifiedLog/src/views/unifiedLog/unifiedLog', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', '02150001', '/unifiedLog', 'unifiedLog:View', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (546343017720848384, '链路追踪', '链路追踪', 545564576406839296, '/linkTracking', 'HussarUnifiedLog/src/views/linkTracking/linkTracking', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', '02160001', '/linkTracking', 'linkTracking:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (546346988292284416, '错误统计', '错误统计', 545564576406839296, '/errorStatistics', 'HussarUnifiedLog/src/views/errorStatistics/errorStatistics', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', '02170002', '/errorStatistics', 'errorStatistics:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (556508576777248768, '休眠用户', '休眠用户', 1450765592889004737, '/userFront/dormancy', '', '0', 'res_btn', 20, '0', '1', NULL, 1450756958461300737, '2022-03-16 16:06:24', 1450756958461300737, '2022-03-16 16:06:24', '2010001', '/userFront/dormancy', 'userFront:dormancy', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (564389067157151744, '流程概览', '流程概览', 564389571845169152, '/processOverview', 'BpmBPA/src/views/processAnalysis/processOverview', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-04-07 10:00:39', 1450756958461300737, '2022-05-26 15:51:56', '02340002', '', 'bpa:view', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576425225089196032, '委托待办', '委托待办', 576446323717578752, '/entrustTodoList', 'HussarPersonalMatters/src/views/taskmanage/entrustTodoList', '1', 'res_menu', 1, '0', '1', NULL, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', '00250645', '/entrustTodo', 'entrustTodo:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576437892923269120, '委托已办', '委托已办', 576437727940321280, '/entrustDoneList', 'HussarPersonalMatters/src/views/taskmanage/entrustDoneList', '1', 'res_menu', 1, '0', '1', NULL, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', '02690646', '/entrustDone', 'entrustDone:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576444545517232128, '通道管理', '通道管理', 576443985825112064, '/msg/smsSend/sendMsgSms', 'HussarMessage/src/views/smsService/SmsChannel', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-10 16:24:49', 1450756958461300737, '2022-05-15 14:30:43', '02200006', '/smsService/smsChannel', 'smsService:smsChannel', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576445297899872256, '签名管理', '签名管理', 576443985825112064, '/smsService/Signature', 'HussarMessage/src/views/smsService/Signature', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-10 16:27:49', 1450756958461300737, '2022-05-11 14:43:43', '02200007', '/smsService/Signature', 'smsService:Signature', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576445557296603136, '模板管理', '模板管理', 576443985825112064, '/smsService/smsTemplate', 'HussarMessage/src/views/smsService/SmsTemplate', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-10 16:28:51', 1450756958461300737, '2022-05-15 16:53:08', '02200008', '/smsService/smsTemplate', 'smsService:smsTemplate', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576445740617048064, '发送测试', '发送测试', 576443985825112064, '/smsService/SendSMS', 'HussarMessage/src/views/smsService/SendSMS', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-10 16:29:34', 1450756958461300737, '2022-05-11 14:44:07', '02200009', '/smsService/SendSMS', 'smsService:SendSMS', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576445901988700160, '发送记录', '发送记录', 576443985825112064, '/smsService/smsSendRecord', 'HussarMessage/src/views/smsService/SendRecord', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, '2022-05-10 16:30:13', 1450756958461300737, '2022-05-15 17:58:23', '02200010', '/smsService/smsSendRecord', 'smsService:smsSendRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (576446061217062912, '发送统计', '发送统计', 576443985825112064, '/smsService/sendRateReport', 'HussarMessage/src/views/smsService/SendRateReport', '0', 'res_menu', 6, '0', '1', '1', 1450756958461300737, '2022-05-10 16:30:51', 1450756958461300737, '2022-05-11 13:49:45', '02200011', '/smsService/sendRateReport', 'smsService:sendRateReport', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (577910957540646912, '通道管理', '通道管理', 576919005307346944, '/mailService/mChannel', 'HussarMessage/src/views/mailService/MChannel', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-14 17:31:49', 1450756958461300737, '2022-05-15 11:16:41', '02220010', '/mailService/mChannel', 'mailService:mChannel', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (577920052196810752, '发送记录', '发送记录', 576919005307346944, '/mailService/mailSendRecord', 'HussarMessage/src/views/mailService/MailSendRecord', '0', 'res_menu', 6, '0', '1', '1', 1450756958461300737, '2022-05-14 18:07:58', 1450756958461300737, '2022-05-15 11:16:42', '02220011', '/mailService/mailSendRecord', 'mailService:mailSendRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (577951344581943296, '单发测试', '单发测试', 576919005307346944, '/mailService/mSendTest', 'HussarMessage/src/views/mailService/SendTest', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-14 20:12:18', 1450756958461300737, '2022-05-19 17:55:46', '02220012', '/mailService/mSendTest', 'mailService:mSendTest', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (577951711264776192, '群发测试', '群发测试', 576919005307346944, '/mailService/groupHair', 'HussarMessage/src/views/mailService/GroupHair', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-14 20:13:46', 1450756958461300737, '2022-05-15 11:44:26', '02220013', '/mailService/groupHair', 'mailService:groupHair', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (577951935202861056, '收件人管理', '收件人管理', 576919005307346944, '/mailService/recipient', 'HussarMessage/src/views/mailService/Recipient', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, '2022-05-14 20:14:39', 1450756958461300737, '2022-05-15 11:16:42', '02220014', '/mailService/recipient', 'mailService:recipient', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578178840069939200, '模板管理', '模板管理', 576919005307346944, '/mailService/mTemplate', 'HussarMessage/src/views/mailService/MTemplate', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-15 11:16:18', 1450756958461300737, '2022-05-15 11:16:41', '02220015', '/mailService/mTemplate', 'mailService:mTemplate', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578180013862690816, '发送统计', '发送统计', 576919005307346944, '/mailService/readedStatistics', 'HussarMessage/src/views/mailService/ReadedStatistics', '0', 'res_menu', 7, '0', '1', '1', 1450756958461300737, '2022-05-15 11:20:57', 1450756958461300737, '2022-05-22 10:39:09', '02220016', '/mailService/readedStatistics', 'mailService:readedStatistics', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578224814087741440, '通道管理', '通道管理', 578221171997417472, '/mpService/111publicAccount', 'HussarMessage/src/views/mpService/PublicAccount', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-15 14:18:59', 1450756958461300737, '2022-05-15 14:18:59', '02270003', '/mpService/111publicAccount', 'mpService:publicAccount', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578225070686871552, '模板管理', '模板管理', 578221171997417472, '/mpService/mpTemplate', 'HussarMessage/src/views/mpService/MPTemplate', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-15 14:20:00', 1450756958461300737, '2022-05-15 14:20:00', '02270004', '/mpService/mpTemplate', 'mpService:mpTemplate', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578225260298772480, '发送测试', '发送测试', 578221171997417472, '/mpService/messageTesting', 'HussarMessage/src/views/mpService/MessageTesting', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-15 14:20:45', 1450756958461300737, '2022-05-15 14:20:45', '02270005', '/mpService/messageTesting', 'mpService:messageTesting', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (578225470362099712, '发送记录', '发送记录', 578221171997417472, '/mpService/pushRecord', 'HussarMessage/src/views/mpService/PushRecord', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-15 14:21:35', 1450756958461300737, '2022-05-15 14:21:35', '02270006', '/mpService/pushRecord', 'mpService:pushRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579400593928626176, '通道管理', '通道管理', 579399930809163776, '/appImService/appImChannel', 'HussarMessage/src/views/appImService/AppImChannel', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-18 20:11:06', 1450756958461300737, '2022-05-20 11:00:38', '02280002', '/appImService/appImChannel', 'appImService:appImChannel', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579401699782041600, '发送测试', '发送测试', 579399930809163776, '/appImService/appImSendedTested', 'HussarMessage/src/views/appImService/AppImSendedTested', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-18 20:15:30', 1450756958461300737, '2022-05-20 11:16:40', '02280005', '/appImService/appImSendedTested', 'appImService:appImSendedTested', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579402283595603968, '发送统计', '发送统计', 579399930809163776, '/appImService/appImDataStatistics', 'HussarMessage/src/views/appImService/AppImDataStatistics', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-18 20:17:49', 1450756958461300737, '2022-05-20 11:00:38', '02280007', '/appImService/appImDataStatistics', 'appImService:appImDataStatistics', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579406581389860864, '通道管理', '通道管理', 579405620386734080, '/appPushService/appPushChannel', 'HussarMessage/src/views/appPushService/AppPushChannel', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-18 20:34:54', 1450756958461300737, '2022-05-18 20:34:54', '02290001', '/appPushService/appPushChannel', 'appPushService:appPushChannel', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579406782007615488, '发送测试', '发送测试', 579405620386734080, '/appPushService/appPushTest', 'HussarMessage/src/views/appPushService/AppPushTest', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-18 20:35:42', 1450756958461300737, '2022-05-20 17:17:28', '02290002', '/appPushService/appPushTest', 'appPushService:appPushTest', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579406956977201152, '发送记录', '发送记录', 579405620386734080, '/appPushService/appPushReecorded', 'HussarMessage/src/views/appPushService/AppPushReecorded', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-18 20:36:23', 1450756958461300737, '2022-05-20 18:14:35', '02290003', '/appPushService/appPushReecorded', 'appPushService:appPushReecorded', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579407194467082240, '发送统计', '发送统计', 579405620386734080, '/appPushService/appPushStatistics', 'HussarMessage/src/views/appPushService/AppPushStatistics', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-18 20:37:20', 1450756958461300737, '2022-05-21 14:10:21', '02290004', '/appPushService/appPushStatistics', 'appPushService:appPushStatistics', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (579986784054943744, '发送记录', '发送记录', 579399930809163776, '/appImService/appImSendRecord', 'HussarMessage/src/views/appImService/AppImSendRecord', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-20 11:00:25', 1450756958461300737, '2022-05-20 11:00:38', '02280011', '/appImService/appImSendRecord', 'appImService:appImSendRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581431768348106752, '流程状态分析', '流程状态分析', 564389571845169152, '/processStatus', 'BpmBPA/src/views/processAnalysis/processStatus', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-24 10:42:16', 1450756958461300737, '2022-05-26 15:55:09', '02150540', '', 'bpa:processStatus', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581432525403201536, '流程参与者分析', '流程参与者分析', 564389571845169152, '/processParticipantAnalysis', 'BpmBPA/src/views/processAnalysis/processParticipantAnalysis', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-24 10:45:17', 1450756958461300737, '2022-05-31 15:07:23', '02150542', '', 'bpa:processParticipantAnalysis', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581434143087534080, '流程统计分析', '流程统计分析', 564389571845169152, '/processStatisticalAnalysis', 'BpmBPA/src/views/processAnalysis/processStatisticalAnalysis', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-24 10:51:42', 1450756958461300737, '2022-06-02 09:06:32', '02150544', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581434493471301632, '热门流程分析', '热门流程分析', 581434239535554560, '/popularProcessAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/popularProcessAnalysis', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-05-24 10:53:06', 1450756958461300737, '2022-05-26 15:55:20', '02390545', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581434937987833856, '流程数量分析', '流程数量分析', 581434239535554560, '/processQuantityAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processQuantityAnalysis', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-05-24 10:54:52', 1450756958461300737, '2022-06-06 14:07:46', '02390548', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581435215210356736, '用户流程分析', '用户流程分析', 581434239535554560, '/personProcessAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/personProcessAnalysis', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-05-24 10:55:58', 1450756958461300737, '2022-05-31 16:48:16', '02390550', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581435962006183936, '待办任务分析', '待办任务分析', 581434239535554560, '/todoTaskAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/todoTaskAnalysis', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-05-24 10:58:56', 1450756958461300737, '2022-06-01 17:02:52', '02390551', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (581436516656750592, '流程耗时分析', '流程耗时分析', 564389571845169152, '/processTimeAnalysis', 'BpmBPA/src/views/processAnalysis/timeAnalysis/processTimeAnalysis', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, '2022-05-24 11:01:08', 1450756958461300737, '2022-06-02 09:58:19', '02400554', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (582661309611646976, '发送统计', '发送统计', 578221171997417472, '/mpService/sendStatistics', 'HussarMessage/src/views/mpService/SendedStatisticss', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, '2022-05-27 20:08:02', 1450756958461300737, '2022-05-29 18:26:46', '02270008', '/mpService/sendStatistics', 'mpService:SendedStatisticss', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (586205441340743680, '流程驳回分析', '流程驳回分析', 581434239535554560, '/processRejectAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processRejectAnalysis', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, '2022-06-06 14:51:08', 1450756958461300737, '2022-06-06 18:01:02', '02390555', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587709219764183040, '发送记录', '发送记录', 587706862284316672, '/noticeService/noticeSendRecord', 'HussarMessage/src/views/noticeService/NoticeSendRecord', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-06-10 18:26:37', 1450756958461300737, '2022-06-10 18:26:37', '02360005', '/noticeService/noticeSendRecord', 'noticeService:noticeSendRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587709399175536640, '发送统计', '发送统计', 587706862284316672, '/noticeService/noticeStatistics', 'HussarMessage/src/views/noticeService/NoticeStatistics', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, '2022-06-10 18:27:20', 1450756958461300737, '2022-06-10 18:27:20', '02360006', '/noticeService/noticeStatistics', 'noticeService:noticeStatistics', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587942765325983744, '短信', '短信', 587942618739253248, '/msg/sms/sendSmsMsg', '', '0', 'res_btn', 1, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:54:39', 1450756958461300737, '2022-06-23 14:04:21', '02370001', '/msg/sms/sendSmsMsg', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587942870816923648, '公众号', '公众号', 587942618739253248, '/msg/mp/sendMpMsg', '', '0', 'res_btn', 2, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:55:04', 1450756958461300737, '2022-06-23 14:04:36', '02370002', '/msg/mp/sendMpMsg', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943035611127808, 'AppImText', 'AppImText', 587942618739253248, '/msg/appIm/send/text', '', '0', 'res_btn', 3, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:55:43', 1450756958461300737, '2022-06-11 09:55:43', '02370003', '/msg/appIm/send/text', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943112647909376, 'AppImArticle', 'AppImArticle', 587942618739253248, '/msg/appIm/send/article', '', '0', 'res_btn', 4, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:56:02', 1450756958461300737, '2022-06-11 09:56:02', '02370004', '/msg/appIm/send/article', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943196252971008, 'AppImImg', 'AppImImg', 587942618739253248, '/msg/appIm/send/img', '', '0', 'res_btn', 5, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:56:21', 1450756958461300737, '2022-06-11 09:56:21', '02370005', '/msg/appIm/send/img', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943277567942656, 'AppImFile', 'AppImFile', 587942618739253248, '/msg/appIm/send/file', '', '0', 'res_btn', 6, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:56:41', 1450756958461300737, '2022-06-11 09:56:41', '02370006', '/msg/appIm/send/file', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943412431593472, '邮件单发', '邮件单发', 587942618739253248, '/msg/msgMail/send', '', '0', 'res_btn', 7, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:57:13', 1450756958461300737, '2022-06-11 09:57:13', '02370007', '/msg/msgMail/send', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943534536171520, '邮件批量发送', '邮件批量发送', 587942618739253248, '/msg/msgMail/bathsend', '', '0', 'res_btn', 8, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:57:42', 1450756958461300737, '2022-06-11 09:57:42', '02370008', '/msg/msgMail/bathsend', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (587943645634895872, 'App推送', 'App推送', 587942618739253248, '/msg/appPushInfo/add', '', '0', 'res_btn', 9, '0', '0', NULL, 1450756958461300737, '2022-06-11 09:58:09', 1450756958461300737, '2022-06-11 09:58:09', '02370009', '/msg/appPushInfo/add', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (588023442222358528, '内部消息', '内部消息', 587942618739253248, '/msg/notice/send/insertOrUpdate', '', '0', 'res_btn', 10, '0', '0', NULL, 1450756958461300737, '2022-06-11 15:15:14', 1450756958461300737, '2022-06-11 15:15:14', '02370010', '/msg/notice/send/insertOrUpdate', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (588042819223166976, '发送测试', '发送测试', 587706862284316672, '/noticeService/noticePushTest', 'HussarMessage/src/views/noticeService/NoticePushTest', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, '2022-06-11 16:32:13', 1450756958461300737, '2022-06-11 16:32:13', '02360008', '/noticeService/noticePushTest', 'noticeService:noticePushTest', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (588788708602552320, '短信获取通道列表', '短信获取通道列表', 587942618739253248, '/msg/smsSend/getChannelList', '', '0', 'res_btn', 11, '0', '0', NULL, 1450756958461300737, '2022-06-13 17:56:07', 1450756958461300737, '2022-06-13 17:56:07', '02370011', '/msg/smsSend/getChannelList', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (588788977285472256, '短信获取签名列表', '短信获取签名列表', 587942618739253248, '/msg/smsSend/getSignListByChannelId', '', '0', 'res_btn', 12, '0', '0', NULL, 1450756958461300737, '2022-06-13 17:57:11', 1450756958461300737, '2022-06-13 17:57:11', '02370012', '/msg/smsSend/getSignListByChannelId', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (588796112652214272, '短信获取模板列表', '短信获取模板列表', 587942618739253248, '/msg/smsSend/getTemplateListByChannelId', '', '0', 'res_btn', 13, '0', '0', NULL, 1450756958461300737, '2022-06-13 18:25:33', 1450756958461300737, '2022-06-13 18:25:33', '02370013', '/msg/smsSend/getTemplateListByChannelId', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (589368589979754496, '获取邮件模板列表', '获取邮件模板列表', 587942618739253248, '/msg/msgMail/getTemplateList', '', '0', 'res_btn', 14, '0', '0', NULL, 1450756958461300737, '2022-06-15 08:20:22', 1450756958461300737, '2022-06-15 08:20:22', '02370015', '/msg/msgMail/getTemplateList', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (589368748763521024, '获取公众号通道列表', '获取公众号通道列表', 587942618739253248, '/msg/mp/send/getChannelList', '', '0', 'res_btn', 15, '0', '0', NULL, 1450756958461300737, '2022-06-15 08:21:00', 1450756958461300737, '2022-06-15 08:21:00', '02370016', '/msg/mp/send/getChannelList', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (589369116763365376, '获取微信公众号模板列表', '获取微信公众号模板列表', 587942618739253248, '/msg/mp/send/getTemplateListByChannelId', '', '0', 'res_btn', 16, '0', '0', NULL, 1450756958461300737, '2022-06-15 08:22:27', 1450756958461300737, '2022-06-15 08:22:27', '02370018', '/msg/mp/send/getTemplateListByChannelId', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (589369233557954560, '获取APPIM通道列表', '获取APPIM通道列表', 587942618739253248, '/msg/appIm/send/getChannelList', '', '0', 'res_btn', 17, '0', '0', NULL, 1450756958461300737, '2022-06-15 08:22:55', 1450756958461300737, '2022-06-15 08:22:55', '02370019', '/msg/appIm/send/getChannelList', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (589369324108783616, '获取APP推送通道列表', '获取APP推送通道列表', 587942618739253248, '/msg/appPushInfo/getChannelList', '', '0', 'res_btn', 18, '0', '0', NULL, 1450756958461300737, '2022-06-15 08:23:17', 1450756958461300737, '2022-06-15 08:23:17', '02370020', '/msg/appPushInfo/getChannelList', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (592385945366700032, '告警设置', '告警设置', 592385645452992512, '/logSet', 'HussarUnifiedLog/src/views/logWarn/logSet', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', '02160501', '', 'logSet:view', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (592391481915088896, '告警记录', '告警记录', 592385645452992512, '/logRecord', 'HussarUnifiedLog/src/views/logWarn/logRecord', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', '02160502', '', 'logRecord:view', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (595571989650087936, '首页配置', '首页配置', 595571579120001024, '/portalConfiguration', 'HussarMobileConfig/src/views/mobileConfig/portalConfiguration', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-07-02 11:10:28', 1450756958461300737, '2022-07-02 11:26:39', '02150502', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (595572170466533376, '三方集成', '三方集成', 595571579120001024, '/tripartiteIntegration', 'HussarMobileConfig/src/views/mobileConfig/tripartiteIntegration', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-07-02 11:11:11', 1450756958461300737, '2022-07-02 11:28:14', '02150503', '', '', '1', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (596353576553684992, '应用管理', '应用管理', 596352625377812480, '/appService/appManage', 'HussarMessage/src/views/appService/AppManage', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-07-04 14:56:12', 1450756958461300737, '2022-07-04 14:56:12', '02490002', '/appService/appManage', 'appService:appManage', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (596648540198150144, '上传文件', '上传文件', 587942618739253248, '/msg/attachment/uploadfilewithdrag', '', '0', 'res_btn', 19, '0', '0', NULL, 1450756958461300737, '2022-07-05 10:28:17', 1450756958461300737, '2022-07-05 10:28:17', '02370022', '/msg/attachment/uploadfilewithdrag', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (608974704010862592, '场景管理', '场景管理', 596352625377812480, '/appService/sceneManage', 'HussarMessage/src/views/appService/SceneManage', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-08-08 10:48:04', 1450756958461300737, '2022-08-08 11:25:22', '02490523', '/appService/sceneManage', 'appService:sceneManage', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (609687682360287232, '服务类型', '服务类型', 587942618739253248, '/msg/app/access/getAppService', '', '0', 'res_btn', 20, '0', '0', NULL, 1450756958461300737, '2022-08-10 10:01:11', 1450756958461300737, '2022-08-10 10:01:11', '02370524', '/msg/app/access/getAppService', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (631784753686913024, '查询用户数据', '查询用户数据', 1450765592889004737, '', '', '0', 'res_btn', 21, '0', '0', NULL, 1450756958461300737, '2022-10-10 09:27:03', 1450756958461300737, '2022-10-10 09:27:03', '2010502', '/userFront/searchUsers', 'userFront:searchUsers', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (638042415412027392, '功能导出', '功能导出', 1450765592889004630, '', '', '0', 'res_btn', 36, '0', '0', NULL, 1450756958461300737, '2022-10-27 15:52:46', 1450756958461300737, '2022-10-27 15:53:32', '资源维护0501', '/resourceFront/exportFunction', 'resourceFront:exportFunction', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (638045114752835584, '功能导入', '功能导入', 1450765592889004630, '', '', '0', 'res_btn', 37, '0', '0', NULL, 1450756958461300737, '2022-10-27 16:03:30', 1450756958461300737, '2022-10-27 16:03:30', '资源维护0502', '/resourceFront/importFunction', 'resourceFront:importFunction', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (641241760202498048, '数据导出', '数据导出', 641241402218651648, '/migrationDump', 'HussarMigration/src/views/migrationDump/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2022-11-05 11:45:49', 1450756958461300737, '2022-11-05 12:11:51', '02160501', '', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (641241962678329344, '数据导入', '数据导入', 641241402218651648, '/migrationLoad', 'HussarMigration/src/views/migrationLoad/index', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, '2022-11-05 11:46:38', 1450756958461300737, '2022-11-05 12:11:55', '02160503', '', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (642061362138456064, '全加载角色树', '全加载角色树', 1450765592889004740, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-07 18:02:38', 1450756958461300737, '2022-11-07 18:02:38', '2020507', '/hussarBase/authorization/permit/role/roleTree', 'hussarBase:authorization:permit:role:roleTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (643045022819950592, '获取当前组织机构全路径', '获取当前组织机构全路径', 1450765592889004693, '', '', '0', 'res_btn', 23, '0', '0', NULL, 1450756958461300737, '2022-11-10 11:11:21', 1450756958461300737, '2022-11-10 11:11:21', '1020502', '/hussarBase/authorization/organ/getOrganFname', 'hussarBase:authorization:organ:getOrganFname', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (651116365914316800, '保存数据权限信息', '保存数据权限信息', 1450765592889004740, '', '', '0', 'res_btn', 23, '0', '0', NULL, 1450756958461300737, '2022-12-02 17:43:59', 1450756958461300737, '2022-12-02 17:43:59', '2020559', '/hussarBase/authorization/permit/dataRight/saveOrUpdateDataRight', '', '0', '', 'creator', 'deptId', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (651119173271035904, '获取数据权限树', '获取数据权限树', 1450765592889004740, '', '', '0', 'res_btn', 24, '0', '0', NULL, 1450756958461300737, '2022-12-02 17:55:08', 1450756958461300737, '2022-12-02 17:55:08', '2020560', '/hussarBase/authorization/permit/role/getFuncDataRightByRoleId', '', '0', '', 'creator', 'deptId', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (651120420518633472, '获取自定义组织机构树', '获取自定义组织机构树', 1450765592889004693, '', '', '0', 'res_btn', 24, '0', '0', NULL, 1450756958461300737, '2022-12-02 18:00:05', 1450756958461300737, '2022-12-02 18:00:05', '1020561', '/hussarBase/authorization/organ/getCustomOrgTree', '', '0', '', 'creator', 'deptId', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (654426928039862272, '删除数据权限信息', '删除数据权限信息', 1450765592889004740, '', '', '0', 'res_btn', 25, '0', '0', NULL, 1450756958461300737, '2022-12-11 20:58:58', 1450756958461300737, '2022-12-11 20:58:58', '2020511', '/hussarBase/authorization/permit/dataRight/deleteDataRight', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219392, '数据迁移导出开始', '数据迁移导出开始', 641241402218651648, '', '', '0', 'res_btn', 3, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160503', '/hussarBase/migration/dump/start', 'hussarBase:migration:dump:start', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219393, '数据迁移导出阶段执行状态查询', '数据迁移导出阶段执行状态查询', 641241402218651648, '', '', '0', 'res_btn', 4, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160504', '/hussarBase/migration/dump/report', 'hussarBase:migration:dump:report', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219394, '数据迁移导出包下载', '数据迁移导出包下载', 641241402218651648, '', '', '0', 'res_btn', 5, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160505', '/hussarBase/migration/dump/download', 'hussarBase:migration:dump:download', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219395, '数据迁移单条导出任务信息查询', '数据迁移单条导出任务信息查询', 641241402218651648, '', '', '0', 'res_btn', 6, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160506', '/hussarBase/migration/dump/query', 'hussarBase:migration:dump:query', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219396, '数据迁移多条导出任务分页查询', '数据迁移多条导出任务分页查询', 641241402218651648, '', '', '0', 'res_btn', 7, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160507', '/hussarBase/migration/dump/list', 'hussarBase:migration:dump:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219397, '数据迁移导出任务删除', '数据迁移导出任务删除', 641241402218651648, '', '', '0', 'res_btn', 8, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160508', '/hussarBase/migration/dump/remove', 'hussarBase:migration:dump:remove', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219398, '数据迁移上传创建导入任务', '数据迁移上传创建导入任务', 641241402218651648, '', '', '0', 'res_btn', 9, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160509', '/hussarBase/migration/load/upload', 'hussarBase:migration:load:upload', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219399, '数据迁移导入前校验开始', '数据迁移导入前校验开始', 641241402218651648, '', '', '0', 'res_btn', 10, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160510', '/hussarBase/migration/load/preloadStart', 'hussarBase:migration:load:preloadStart', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219400, '数据迁移导入前校验阶段执行状态查询', '数据迁移导入前校验阶段执行状态查询', 641241402218651648, '', '', '0', 'res_btn', 11, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160511', '/hussarBase/migration/load/preloadReport', 'hussarBase:migration:load:preloadReport', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219401, '数据迁移导入开始', '数据迁移导入开始', 641241402218651648, '', '', '0', 'res_btn', 12, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160512', '/hussarBase/migration/load/loadStart', 'hussarBase:migration:load:loadStart', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219402, '数据迁移导入阶段执行状态查询', '数据迁移导入阶段执行状态查询', 641241402218651648, '', '', '0', 'res_btn', 13, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160513', '/hussarBase/migration/load/loadReport', 'hussarBase:migration:load:loadReport', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219403, '数据迁移导入包结构信息查询', '数据迁移导入包结构信息查询', 641241402218651648, '', '', '0', 'res_btn', 14, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160514', '/hussarBase/migration/load/detail', 'hussarBase:migration:load:detail', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219404, '数据迁移单条导入任务信息查询', '数据迁移单条导入任务信息查询', 641241402218651648, '', '', '0', 'res_btn', 15, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160515', '/hussarBase/migration/load/query', 'hussarBase:migration:load:query', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219405, '数据迁移多条导入任务分页查询', '数据迁移多条导入任务分页查询', 641241402218651648, '', '', '0', 'res_btn', 16, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160516', '/hussarBase/migration/load/list', 'hussarBase:migration:load:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219406, '数据迁移导入任务删除', '数据迁移导入任务删除', 641241402218651648, '', '', '0', 'res_btn', 17, '0', '0', NULL, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25', '02160517', '/hussarBase/migration/load/remove', 'hussarBase:migration:load:remove', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219501, '获取功能迁出向导树', '获取功能迁出向导树', 1450765592889004630, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 15:52:46', 1450756958461300737, '2022-10-27 15:53:32', '1020504118', '/resourceFront/migratExportFunction', 'resourceFront:migratExportFunction', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219502, '加载角色树', '加载角色树', 1450765592889004740, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-07 18:02:38', 1450756958461300737, '2022-11-07 18:02:38', '2020508', '/hussarBase/authorization/permit/role/getRoleTree', 'hussarBase:authorization:permit:role:getRoleTree', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (657533259068219503, '载入关联角色', '载入关联角色', 1450765592889004740, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-07 18:02:38', 1450756958461300737, '2022-11-07 18:02:38', '2020509', '/hussarBase/authorization/permit/role/loadRelatedRole', 'hussarBase:authorization:permit:role:loadRelatedRole', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (665490432775692288, '获取登录动态密码验证配置值', '获取登录动态密码验证配置值', 1450765592889004658, '', '', '0', 'res_btn', 5, '0', '0', NULL, 1450756958461300737, '2023-01-11 09:41:23', 1450756958461300737, '2023-01-11 09:41:23', '000400940502', '/sysBaseConfigFront/getTotpOpen', 'sysBaseConfigFront:getTotpOpen', '0', NULL, 'data_holder', 'data_organ', NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (673551263069380608, '工作流配置项管理', '工作流配置项管理', 673548858558783488, '/bpmConfig', 'BpmManageServer/src/views/bpmConfig/index', '0', 'res_menu', 1, '0', '1', NULL, 1450756958461300737, '2023-02-02 15:32:15', 1450756958461300737, '2023-02-02 16:18:48', '02180508', '', 'bpmConfig:vue', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (677910413299687424, '新增我的公告', '新增我的公告', 526435626275577856, '', '', '0', 'res_btn', 2, '0', '0', NULL, 1450756958461300737, '2023-02-14 16:13:57', 1450756958461300737, '2023-02-14 16:13:57', '02370501', '/myNotice/SysNotice/addSysNotice', 'addSysNotice', '0', NULL, 'data_holder', 'data_organ', NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (677910643386621952, '修改我的公告', '修改我的公告', 526435626275577856, '', '', '0', 'res_btn', 3, '0', '0', NULL, 1450756958461300737, '2023-02-14 16:14:52', 1450756958461300737, '2023-02-14 16:14:52', '02370502', '/myNotice/SysNotice/editSysNotice', '', '0', NULL, 'data_holder', 'data_organ', NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686146166286721024, '应用管理', '应用管理', 686145219900743680, '/appManage', 'HussarApplication/src/views/appManagement', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-03-09 09:39:54', 1450756958461300737, '2023-03-09 13:47:19', '02160502', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686146454410240000, '应用回收站', '应用回收站', 686145307951767552, '/RecycleBin', 'HussarApplication/src/views/recycleBin', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-03-09 09:41:03', 1450756958461300737, '2023-03-09 13:47:34', '02170503', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686174839412891648, '通道管理', '通道管理', 686174195188768768, '/wecomService/wecomChannel', 'HussarMessage/src/views/wecomService/WecomChannel', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-03-09 11:33:50', 1450756958461300737, '2023-03-09 11:52:11', '02200510', '', 'wecomService:wecomChannel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686175350430113792, '发送测试', '发送测试', 686174195188768768, '/wecomService/wecomSendedTested', 'HussarMessage/src/views/wecomService/WecomSendedTested', '0', 'res_menu', 2, '0', '1', '0', 1450756958461300737, '2023-03-09 11:35:52', 1450756958461300737, '2023-03-09 11:35:52', '02200511', '', 'wecomService:wecomSendedTested', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686175659781005312, '发送记录', '发送记录', 686174195188768768, '/wecomService/wecomSendRecord', 'HussarMessage/src/views/wecomService/WecomSendRecord', '0', 'res_menu', 3, '0', '1', '0', 1450756958461300737, '2023-03-09 11:37:06', 1450756958461300737, '2023-03-09 11:37:06', '02200512', '', 'wecomService:wecomSendRecord', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (686176030305820672, '发送统计', '发送统计', 686174195188768768, '/wecomService/wecomDataStatistics', 'HussarMessage/src/views/wecomService/WecomDataStatistics', '0', 'res_menu', 4, '0', '1', '0', 1450756958461300737, '2023-03-09 11:38:34', 1450756958461300737, '2023-03-09 11:38:34', '02200513', '', 'wecomService:wecomDataStatistics', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (688075091652911104, '企业微信', '企业微信', 587942618739253248, '/msg/cp/sendCpMsg', '', '0', 'res_btn', 21, '0', '0', '0', 1450756958461300737, '2023-03-14 17:24:46', 1450756958461300737, '2023-03-14 17:24:46', '02370517', '/msg/cp/sendCpMsg', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (688348921973710848, '岗位管理页面', '岗位管理页面', 688348352496279552, '/postIndex', 'HussarAuthorization/src/views/post/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2023-03-15 11:32:52', 1450756958461300737, '2023-03-15 14:12:59', '02180508', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690522261102534656, '创建待办', '创建待办', 521403268396752896, '', '', '0', 'res_open_interface', 5, '0', '0', '0', 1450756958461300737, '2023-03-21 11:28:56', 1450756958461300737, '2023-03-21 11:28:56', '02200508', '/unified/unifiedtodo/saveTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690522779594006528, '新增催办任务', '新增催办任务', 521403268396752896, '', '', '0', 'res_open_interface', 6, '0', '0', '0', 1450756958461300737, '2023-03-21 11:31:00', 1450756958461300737, '2023-03-21 11:31:00', '02200509', '/unified/unifiedtodo/addUrgeTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690524899974062080, '新增我发起的', '新增我发起的', 521403268396752896, '', '', '0', 'res_open_interface', 8, '0', '0', '0', 1450756958461300737, '2023-03-21 11:39:25', 1450756958461300737, '2023-03-21 11:39:25', '02200512', '/unified/unifiedtodo/addStartProcess', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525019226513408, '更新待办', '更新待办', 521403268396752896, '', '', '0', 'res_open_interface', 9, '0', '0', '0', 1450756958461300737, '2023-03-21 11:39:54', 1450756958461300737, '2023-03-21 11:39:54', '02200513', '/unified/unifiedtodo/updateTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525099648098304, '删除待办', '删除待办', 521403268396752896, '', '', '0', 'res_open_interface', 10, '0', '0', '0', 1450756958461300737, '2023-03-21 11:40:13', 1450756958461300737, '2023-03-21 11:40:13', '02200514', '/unified/unifiedtodo/deleteTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525197148889088, '更新待办状态', '更新待办状态', 521403268396752896, '', '', '0', '690525700498923520', 11, '0', '0', '0', 1450756958461300737, '2023-03-21 11:40:36', 1450756958461300737, '2023-03-21 11:40:46', '02200515', '/unified/unifiedtodo/updateTaskStatus', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525353298632704, '更新执行人/抄送人待办任务完成状态', '更新执行人/抄送人待办任务完成状态', 521403268396752896, '', '', '0', '690525700498923520', 12, '0', '0', '0', 1450756958461300737, '2023-03-21 11:41:14', 1450756958461300737, '2023-03-21 11:41:14', '02200516', '/unified/unifiedtodo/updateUserStatus', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525462312787968, '更新执行人/抄送人', '更新执行人/抄送人', 521403268396752896, '', '', '0', '690525700498923520', 13, '0', '0', '0', 1450756958461300737, '2023-03-21 11:41:40', 1450756958461300737, '2023-03-21 11:41:40', '02200517', '/unified/unifiedtodo/updateTaskUser', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525592055193600, '添加执行人/抄送人', '添加执行人/抄送人', 521403268396752896, '', '', '0', '690525700498923520', 14, '0', '0', '0', 1450756958461300737, '2023-03-21 11:42:10', 1450756958461300737, '2023-03-21 11:42:10', '02200518', '/unified/unifiedtodo/addTaskUser', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525700498923520, '查询任务数据', '查询任务数据', 521403268396752896, '', '', '0', '690525700498923520', 15, '0', '0', '0', 1450756958461300737, '2023-03-21 11:42:36', 1450756958461300737, '2023-03-21 11:42:36', '02200520', '/unified/unifiedtodo/queryTaskList', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690525973787189248, '查询待办任务详情', '查询待办任务详情', 521403268396752896, '', '', '0', 'res_open_interface', 16, '0', '0', '0', 1450756958461300737, '2023-03-21 11:43:42', 1450756958461300737, '2023-03-21 11:43:42', '02200522', '/unified/unifiedtodo/queryTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690528302003396608, '获取任务数量', '获取任务数量', 521403268396752896, '', '', '0', 'res_open_interface', 17, '0', '0', '0', 1450756958461300737, '2023-03-21 11:52:57', 1450756958461300737, '2023-03-21 11:52:57', '02200523', '/unified/unifiedtodo/countAllTotal', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690528390436102144, '删除执行人/抄送人', '删除执行人/抄送人', 521403268396752896, '', '', '0', 'res_open_interface', 18, '0', '0', '0', 1450756958461300737, '2023-03-21 11:53:18', 1450756958461300737, '2023-03-21 11:53:18', '02200524', '/unified/unifiedtodo/deleteTaskUser', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690641814235127808, '修改我发起的', '修改我发起的', 521403268396752896, '', '', '0', 'res_open_interface', 9, '0', '0', '0', 1450756958461300737, '2023-03-21 19:24:00', 1450756958461300737, '2023-03-21 19:25:15', '02200519', '/unified/unifiedtodo/updateStartProcess', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (690641909710069760, '删除我发起的', '删除我发起的', 521403268396752896, '', '', '0', 'res_open_interface', 9, '0', '0', '0', 1450756958461300737, '2023-03-21 19:24:23', 1450756958461300737, '2023-03-21 19:26:13', '02200521', '/unified/unifiedtodo/deleteStartProcess', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256576, '更新待办状态', '更新待办状态', 521403268396752896, '', '', '0', 'res_open_interface', 20, '0', '0', '0', 1450756958461300737, '2023-03-21 11:54:45', 1450756958461300737, '2023-03-21 11:54:45', '02200526', '/unified/unifiedtodo/updateTaskStatusWithOutFollowers', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256577, '任务转办', '任务转办', 521403268396752896, '', '', '0', 'res_open_interface', 21, '0', '1', '0', 1450756958461300737, '2023-07-06 10:39:44', 1450756958461300737, '2023-07-06 10:39:44', '02200527', '/unified/unifiedtodo/transferUserTask', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256578, '修改任务表中字段', '修改任务表中字段', 521403268396752896, '', '', '0', 'res_open_interface', 22, '0', '0', '0', 1450756958461300737, '2023-03-21 11:54:45', 1450756958461300737, '2023-03-21 11:54:45', '02200528', '/unified/unifiedtodo/updateBusinessInfo', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256579, '移交代办删除执行人/抄送人', '移交代办删除执行人/抄送人', 521403268396752896, '', '', '0', 'res_open_interface', 23, '0', '0', '0', 1450756958461300737, '2023-03-21 11:54:45', 1450756958461300737, '2023-03-21 11:54:45', '02200529', '/unified/unifiedtodo/transferTaskDeleteTaskUser', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256580, '删除统一待办分类', '删除统一待办分类', 521403268396752896, '', '', '0', 'res_open_interface', 24, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200534', '/unified/unifiedtodo/deleteCategory', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256581, '查询应用名称列表', '查询应用名称列表', 521403268396752896, '', '', '0', 'res_open_interface', 25, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200535', '/unified/unifiedtodo/querySystemNameList', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256582, '查询已办待办数量', '查询已办待办数量', 521403268396752896, '', '', '0', 'res_open_interface', 26, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200536', '/unified/unifiedtodo/countTotal', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256583, '查询所有统一待办分类', '查询所有统一待办分类', 521403268396752896, '', '', '0', 'res_open_interface', 21, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200531', '/unified/unifiedtodo/queryAllCategory', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256584, '新增统一待办分类', '新增统一待办分类', 521403268396752896, '', '', '0', 'res_open_interface', 22, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200532', '/unified/unifiedtodo/saveCategory', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697104639711256585, '更新统一待办分类', '更新统一待办分类', 521403268396752896, '', '', '0', 'res_open_interface', 23, '0', '0', '0', 1450756958461300737, '2023-03-20 14:47:32', 1450756958461300737, '2023-03-20 14:47:32', '02200533', '/unified/unifiedtodo/updateCategory', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697759499108491264, '消息中心', '消息中心', 576393382897917952, '/messageCompList', 'HussarConfig/src/components/personalComponents/components/messageCompList', '0', 'res_menu', 10, '0', '1', '0', 1450756958461300737, '2023-04-10 10:47:08', 1450756958461300737, '2023-04-10 10:47:08', '00250539', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697759569409220608, '通道管理', '通道管理', 697758207757787136, '/dingTalk/DingTalkChannel', 'HussarMessage/src/views/dingTalk/DingTalkChannel', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-04-10 10:47:25', 1450756958461300737, '2023-04-10 12:24:04', '02150503', '', 'dingTalk::DingTalkChannel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697760877801381888, '发送测试', '发送测试', 697758207757787136, '/dingTalk/DingTalkSendedTested', 'HussarMessage/src/views/dingTalk/DingTalkSendedTested', '0', 'res_menu', 2, '0', '1', '0', 1450756958461300737, '2023-04-10 10:52:37', 1450756958461300737, '2023-04-12 11:19:01', '02150505', '', 'dingTalk::DingTalkSendedTested', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697761225484017664, '发送记录', '发送记录', 697758207757787136, '/dingTalk/DingTalkSendRecord', 'HussarMessage/src/views/dingTalk/DingTalkSendRecord', '0', 'res_menu', 3, '0', '1', '0', 1450756958461300737, '2023-04-10 10:54:00', 1450756958461300737, '2023-04-12 11:19:16', '02150506', '', 'dingTalk::DingTalkSendRecord', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (697761494317932544, '发送统计', '发送统计', 697758207757787136, '/dingTalk/DingTalkDataStatistics', 'HussarMessage/src/views/dingTalk/DingTalkDataStatistics', '0', 'res_menu', 4, '0', '1', '0', 1450756958461300737, '2023-04-10 10:55:04', 1450756958461300737, '2023-04-10 12:13:28', '02150507', '', 'dingTalk::DingTalkDataStatistics', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (698221272777367552, '钉钉', '钉钉', 587942618739253248, '/msg/dingtalk/send/sendMsg', '', '0', 'res_btn', 22, '0', '0', '0', 1450756958461300737, '2023-04-11 17:22:04', 1450756958461300737, '2023-04-11 17:22:04', '02370514', '/msg/dingtalk/send/sendMsg', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (706807241717850112, '表单维护', '表单维护', 706807109840543744, '/formManager', 'BpmManageServer/src/views/formManager/index', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-05-05 09:59:38', 1450756958461300737, '2023-05-05 10:00:35', '02150501', '', 'formManager:view', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707287408898744320, '组织机构excel文件导出', '组织机构excel文件导出', 1450765592889004693, '', '', '0', 'res_btn', 28, '0', '0', '0', 1450756958461300737, '2023-05-06 17:47:39', 1450756958461300737, '2023-05-08 09:22:11', '1020628', '/hussarBase/authorization/organ/exportOrganExcel', 'hussarBase:authorization:organ:exportOrganExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707287408898778429, '组织机构excel导入数据校验', '组织机构excel导入数据校验', 1450765592889004693, '', '', '0', 'res_btn', 26, '0', '0', '0', 1450756958461300737, '2023-05-06 17:47:33', 1450756958461300737, '2023-05-08 09:22:17', '1020626', '/hussarBase/authorization/organ/checkOrganExcel', 'hussarBase:authorization:organ:checkOrganExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707288922094575616, '组织机构excel文件导入', '组织机构excel文件导入', 1450765592889004693, '', '', '0', 'res_btn', 27, '0', '0', '0', 1450756958461300737, '2023-05-06 17:53:40', 1450756958461300737, '2023-05-08 09:22:18', '1020627', '/hussarBase/authorization/organ/importOrganExcel', 'hussarBase:authorization:organ:importOrganExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707290343955243008, '组织机构excel导入模板下载', '组织机构excel导入模板下载', 1450765592889004693, '', '', '0', 'res_btn', 25, '0', '0', '0', 1450756958461300737, '2023-05-06 17:59:19', 1450756958461300737, '2023-05-08 09:22:26', '1020625', '/hussarBase/authorization/organ/downloadOrganExcelImpTpl', 'hussarBase:authorization:organ:downloadOrganExcelImpTpl', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707290869702860800, '用户人员excel文件导出', '用户人员excel文件导出', 1450765592889004737, '', '', '0', 'res_btn', 42, '0', '0', '0', 1450756958461300737, '2023-05-06 18:01:24', 1450756958461300737, '2023-05-08 09:22:37', '1030630', '/hussarBase/authorization/permit/user/exportUserExcel', 'hussarBase:authorization:user:exportUserExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707290869702897456, '用户人员excel导入数据校验', '用户人员excel导入数据校验', 1450765592889004737, '', '', '0', 'res_btn', 40, '0', '0', '0', 1450756958461300737, '2023-05-06 18:01:24', 1450756958461300737, '2023-05-08 09:22:37', '1030630', '/hussarBase/authorization/permit/user/checkUserExcel', 'hussarBase:authorization:user:checkUserExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707291241079119872, '用户人员excel文件导入', '用户人员excel文件导入', 1450765592889004737, '', '', '0', 'res_btn', 41, '0', '0', '0', 1450756958461300737, '2023-05-06 18:02:53', 1450756958461300737, '2023-05-08 09:22:44', '1030631', '/hussarBase/authorization/permit/user/importUserExcel', 'hussarBase:authorization:user:importUserExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707291432628789248, '用户人员excel导入模板下载', '用户人员excel导入模板下载', 1450765592889004737, '', '', '0', 'res_btn', 39, '0', '0', '0', 1450756958461300737, '2023-05-06 18:03:38', 1450756958461300737, '2023-05-08 09:22:51', '1030632', '/hussarBase/authorization/permit/user/downloadUserExcelImpTpl', 'hussarBase:authorization:user:downloadUserExcelImpTpl', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707898381187635643, '查询', '查询', 707896359877091375, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', '02240503', '/hussarBase/sortInfoTable/getSortInfo', 'hussarBase:sortInfoTable:getSortInfo', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707898381187686400, '查询', '查询', 707896444421677056, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', '02230506', '/hussarBase/queryInfoTable/getQueryInfo', 'hussarBase:queryInfoTable:getQueryInfo', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707898381187686401, '设置默认', '设置默认', 707896444421677056, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', '02230506', '/hussarBase/queryInfoTable/defaultCondition', 'hussarBase:queryInfoTable:defaultCondition', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707898381187686402, '获取记录', '获取记录', 707896359877091330, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', '02230506', '/hussarBase/treeRecord/getTreeRecordInfo', 'hussarBase:treeRecord:getTreeRecordInfo', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707898381187686654, '设置默认', '设置默认', 707896359877091375, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2023-05-08 10:15:26', 1450756958461300737, '2023-05-08 10:15:26', '02240501', '/hussarBase/sortInfoTable/defaultCondition', 'hussarBase:sortInfoTable:defaultCondition', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189632456, '新增', '新增', 707896359877091375, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02240504', '/hussarBase/sortInfoTable/insert', 'hussarBase:sortInfoTable:insert', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189905920, '新增', '新增', 707896444421677056, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02230507', '/hussarBase/queryInfoTable/insert', 'hussarBase:queryInfoTable:insert', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189905921, '取消默认', '取消默认', 707896444421677056, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02230507', '/hussarBase/queryInfoTable/cancel', 'hussarBase:queryInfoTable:cancel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189905922, '新增记录', '新增记录', 707896359877091330, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02230507', '/hussarBase/treeRecord/insert', 'hussarBase:treeRecord:insert', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189905923, '修改记录', '修改记录', 707896359877091330, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02230507', '/hussarBase/treeRecord/update', 'hussarBase:treeRecord:update', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707899978189976547, '取消默认', '取消默认', 707896359877091375, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2023-05-08 10:21:47', 1450756958461300737, '2023-05-08 10:21:47', '02240502', '/hussarBase/sortInfoTable/cancel', 'hussarBase:sortInfoTable:cancel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707901098325645625, '修改', '修改', 707896359877091375, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2023-05-08 10:26:14', 1450756958461300737, '2023-05-08 10:26:14', '02240505', '/hussarBase/sortInfoTable/update', 'hussarBase:sortInfoTable:update', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707901098366869504, '修改', '修改', 707896444421677056, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2023-05-08 10:26:14', 1450756958461300737, '2023-05-08 10:26:14', '02230508', '/hussarBase/queryInfoTable/update', 'hussarBase:queryInfoTable:update', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707906129686162562, '删除', '删除', 707896359877091375, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2023-05-08 10:46:14', 1450756958461300737, '2023-05-08 10:46:14', '02240506', '/hussarBase/sortInfoTable/del', 'hussarBase:sortInfoTable:del', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707906129686175744, '删除', '删除', 707896444421677056, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2023-05-08 10:46:14', 1450756958461300737, '2023-05-08 10:46:14', '02230509', '/hussarBase/queryInfoTable/del', 'hussarBase:queryInfoTable:del', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707908557944922112, '查询', '查询', 707896359877091328, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, '2023-05-08 10:55:53', 1450756958461300737, '2023-05-08 10:55:53', '02220510', '/hussarBase/customTable/queryList', 'hussarBase:customTable:queryList', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (707913562093527040, '新增或修改', '新增或修改', 707896359877091328, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-08 11:15:46', 1450756958461300737, '2023-05-08 11:15:46', '02220513', '/hussarBase/customTable/insertOrUpdate', 'hussarBase:customTable:insertOrUpdate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (710441229837672448, '导入导出记录新增', '导入导出记录新增', 1450765592889004693, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-05-15 10:39:49', 1450756958461300737, '2023-05-15 10:39:49', '02720501', '/hussarBase/excel/excelExportAdd', 'hussarBase:excel:excelExportAdd', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (713718642843590656, '资源类型管理', '资源类型管理', 713718810095656960, '/resourceTypeManage', 'HussarAuthorization/src/views/appManage/resourceTypeManage/index', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-04-10 10:47:08', 1450756958461300737, '2023-04-10 10:47:08', '02160508', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (714424558668750848, '岗位审核页面', '岗位审核页面', 688348425015795712, '/postAudit/index', 'HussarAuthorization/src/views/postAudit/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2023-05-26 10:28:08', 1450756958461300737, '2023-05-26 10:28:08', '02190510', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (714487572214325248, '组织角色审核页面', '组织角色审核页面', 714486973070581760, '/struRoleVerify', 'HussarAuthorization/src/views/permit/auditManage/organAudit/struRoleVerify/index', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-05-26 14:38:32', 1450756958461300737, '2023-05-26 14:38:32', '02200515', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (714487820982689792, '岗位角色审核页面', '岗位角色审核页面', 714487678439268352, '/postRoleAudit', 'HussarAuthorization/src/views/permit/auditManage/postRoleAudit/index', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-05-26 14:39:31', 1450756958461300737, '2023-05-26 14:39:31', '02210516', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (714498499575816192, '用户组织审核页面', '用户组织审核页面', 714498130460286976, '/userOrganizationAudit/index', 'HussarAuthorization/src/views/userOrganizationAudit/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2023-05-26 15:21:57', 1450756958461300737, '2023-05-26 15:40:20', '02220518', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (714503076626833408, '用户岗位审核页面', '用户岗位审核页面', 714502896477282304, '/userPositionAudit/index', 'HussarAuthorization/src/views/userPositionAudit/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, '2023-05-26 15:40:08', 1450756958461300737, '2023-05-26 15:40:08', '02250520', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (729285380519763968, '分组管理', '分组管理', 729285186902302720, '/appGroupManage', 'HussarApplication/src/views/appGroupMangage', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-07-06 10:39:44', 1450756958461300737, '2023-07-06 10:39:44', '02150501', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (734737492670160896, '个人事项', '个人事项', 1450765592889004662, '/personalMatterList', 'HussarWorkstationConfig/src/views/personalMatter/personalMatterList', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-07-21 11:44:29', 1450756958461300737, '2023-08-01 16:00:29', '02210506', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (734833718094733312, '工作台banner', '工作台banner', 734832488207360000, '/bannerManage', 'HussarWorkstationConfig/src/views/bannerManage/bannerManage', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-07-21 18:06:51', 1450756958461300737, '2023-07-21 18:06:51', '02230508', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (735798877248299008, '组件库维护', '组件库维护', 735797215649603584, '/componentsLibrary', 'HussarWorkstationConfig/src/views/componentsLibrary/index', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-07-24 10:02:03', 1450756958461300737, '2023-07-24 10:44:19', '02240510', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (737341598572224512, '新闻维护', '新闻维护', 738861534167703552, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2023-07-28 16:12:16', 1450756958461300737, '2023-08-04 14:41:40', '02170524', '/newsList', 'newsList1', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (738861725461520384, '新闻维护', '新闻维护', 738861534167703552, '/news/news', '/news/news', '0', 'res_menu', 1, '0', '0', '0', 1450756958461300737, '2023-08-01 20:52:43', 1450756958461300737, '2023-08-01 20:52:43', '02160502', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (738861909880872960, '新闻列表', '新闻列表', 738861534167703552, '/news/newsList', '/news/newsList', '0', 'res_menu', 2, '0', '0', '0', 1450756958461300737, '2023-08-01 20:53:27', 1450756958461300737, '2023-08-01 20:53:27', '02160503', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (738862163959226368, '新闻新增', '新闻新增', 738861534167703552, '/news/addNews', '/news/addNews', '0', 'res_menu', 3, '0', '0', '0', 1450756958461300737, '2023-08-01 20:54:27', 1450756958461300737, '2023-08-01 20:54:27', '02160504', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (738863554568134656, '通知更多', '通知更多', 526435626275577856, '/noticeLists', 'HussarWorkstationConfig/src/views/messageComp/noticeLists', '0', 'res_menu', 11, '0', '1', '0', 1450756958461300737, '2023-08-01 20:59:59', 1450756958461300737, '2023-08-01 21:04:20', '02170505', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (738863796810162176, '消息更多', '消息更多', 526435626275577856, '/msgLists', 'HussarWorkstationConfig/src/views/messageComp/msgLists', '0', 'res_menu', 12, '0', '1', '0', 1450756958461300737, '2023-08-01 21:00:57', 1450756958461300737, '2023-08-01 21:04:25', '02170506', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (740248186802937856, '新闻详情', '新闻详情', 738861534167703552, '/newsGrid/newsGridDetailOpen', 'HussarWorkstationConfig/src/views/newsGrid/newsGridDetailOpen', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2023-08-05 16:42:01', 1450756958461300737, '2023-08-05 16:42:01', '02300525', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (740257128702550016, '新闻详情富文本', '新闻详情富文本', 738861534167703552, '/newsGrid/richTextDetailOpen', 'HussarWorkstationConfig/src/views/newsGrid/richTextDetailOpen', '0', 'res_menu', 2, '0', '1', '0', 1450756958461300737, '2023-08-05 17:17:33', 1450756958461300737, '2023-08-05 17:17:33', '02300527', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (740257265600438272, '新闻详情视频', '新闻详情视频', 738861534167703552, '/newsGrid/videoDetailOpen', 'HussarWorkstationConfig/src/views/newsGrid/videoDetailOpen', '0', 'res_menu', 3, '0', '1', '0', 1450756958461300737, '2023-08-05 17:18:05', 1450756958461300737, '2023-08-05 17:18:05', '02300528', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (758695419206443008, '个人信息页面', '个人信息页面', 1450765592889004599, '/jumpConsole', 'HussarLayout/src/components/Index/HeadRight/index', '0', 'res_menu', 3, '0', '0', '0', 1450756958461300737, '2023-09-25 14:24:44', 1450756958461300737, '2023-09-25 14:44:11', '208000005070158', '', '', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (758695918920015872, '访问控制台', '访问控制台', 1450765592889004599, '', '', '0', 'res_element', 4, '0', '0', '0', 1450756958461300737, '2023-09-25 14:26:43', 1450756958461300737, '2023-09-25 14:42:58', '208000005070159', '', 'jumpConsole', '1', '', 'data_holder', 'data_organ', '', 1, 758695419206443008);
INSERT INTO `SYS_RESOURCES` VALUES (811594293004476416, '通讯录', '通讯录', 811594090851606528, '/contactService/ContactManage', 'HussarMessage/src/views/contactService/ContactManage', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, '2024-02-18 13:45:58', 1450756958461300737, '2024-02-18 14:08:07', '000000000273000005070154', '', 'contactService:ContactManage', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (812026141606158336, '批量添加联系人', '批量添加联系人', 812025848596275200, '', '', '0', 'res_open_interface', 1, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070155', '/msg/public/contact/addMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (812026329171238912, '批量更新并新增', '批量更新并新增', 812025848596275200, '', '', '0', 'res_open_interface', 2, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070156', '/msg/public/contact/updateMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (812026421143937024, '批量删除联系人', '批量删除联系人', 812025848596275200, '', '', '0', 'res_open_interface', 3, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070157', '/msg/public/contact/delMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (813348818371485696, '标签管理', '标签管理', 811594090851606528, '/contactService/TagManage', 'HussarMessage/src/views/contactService/TagManage', '0', 'res_menu', 2, '0', '1', '0', 1450756958461300737, '2024-02-23 09:57:50', 1450756958461300737, '2024-02-23 10:29:52', '000000000273000005070155', '', 'contactService:TagManage', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (825443817938493440, '个人环境管理页面', '个人环境管理页面', 825443695917801472, '/personalEnvManagement', 'HussarPersonalEnvManagement/src/views/personalEnvManagement.vue', '0', 'res_menu', 1, '0', '1', '0', 679338378499727360, '2024-03-27 18:59:02', 679338378499727360, '2024-04-03 16:53:58', '000000000275000005070155', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (835251997698695168, '表单', '表单', 686145219900743680, '/appForm', 'HussarModeNocodeApp/src/views/JXDApplicationDesign/appForm.vue', '0', 'res_menu', 11, '0', '1', '0', 679338378499727360, '2024-04-23 20:33:15', 679338378499727360, '2024-04-23 20:40:14', '0216000005070173', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (835454071162019840, '应用授权', '应用授权', 686145219900743680, '/noCodeAppAuthorize', 'HussarModeNocodeApp/src/views/NAppAuthorize/index.vue', '0', 'res_menu', 12, '0', '1', '0', 679338378499727360, '2024-04-24 09:56:13', 679338378499727360, '2024-04-24 09:56:13', '0216000005070174', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (846426754422939648, '环境管理', '环境管理', 850433927125671936, '/environment', 'HussarClient/src/views/environment/environment', '0', 'res_menu', 1, '0', '1', '1', 844891795166076928, '2024-05-24 16:37:44', 844891795166076928, '2024-05-27 09:26:42', '000000000299000005070163', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004036, '修改密码', '修改密码', 1450765592889004735, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-27 16:36:24', NULL, NULL, '2060257', '/userFront/updatePwd', 'userFront:updatePwd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004037, '用户审核修改通过', '用户审核修改通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, '2019-08-23 11:21:44', NULL, NULL, '007600900196', '/sysUsersAuditFront/passEdit', 'sysUsersAuditFront:passEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004039, '功能下级排序', '功能下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, '2019-08-26 09:23:35', NULL, NULL, '资源维护0206', '/resourceFront/functionTreeOrder', 'resourceFront:functionTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004042, '新增基础配置', '新增基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'sbc000000001', '/sysBaseConfig/add', 'sysBaseConfig:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004045, '角色维护页面', '角色维护页面', 1450765592889004740, '/manageRole', 'HussarAuthorization/src/views/permit/rolemanage/role/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000003', '/roleManager/view', 'roleManager:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004047, '菜单转移', '菜单树转移', 1450765592889004616, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 14:55:52', '000000000004', '/frontMenu/menuTreeChange', 'frontMenu:menuTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004052, '功能修改', '功能修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 09:44:15', '00002', '/resource/functionEdit', 'resource:functionEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004053, '根据组织机构类型获取下属单位组织机构类型', '根据组织机构类型获取下属单位组织机构类型', 1450765592889004693, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'org000000003', '/orgMainFront/getOrgRoleByCode', 'orgMainFront:getOrgRoleByCode', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004059, '删除用户', '删除用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000005', '/userFront/delete', 'userFront:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004060, '激活用户', '激活用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, '2021-01-14 16:06:58', NULL, NULL, '201019201', '/userFront/unlockUser', 'userFront:unlockUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004061, '工作日历批量新增', '工作日历新增', 1450765592889004611, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-26 11:41:03', NULL, '2019-08-26 13:36:20', 'null00340224', '/calendarFront/addEvent', 'calendar:addEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004062, '删除角色分组', '删除角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, NULL, NULL, NULL, '2020022', '/roleManagerFront/delGroup', 'roleManagerFront:delGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004064, '新增角色分组', '新增角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:58', '2020019', '/roleManagerFront/saveGroup', 'roleManagerFront:saveGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004066, '日历维护权限', '日历维护权限', 1450765592889004611, NULL, NULL, '0', 'res_btn', 2, '0', '1', NULL, NULL, '2019-02-18 10:57:33', NULL, NULL, 'null00340316', '/calendar/operate', 'calendar:operate', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004067, '日志文件下载', '日志文件下载', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logD00000003', '/logDownloadFront/download', 'logDownload:download', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004069, '用户数据导出', '用户数据导出', 1450765592889004737, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, '2020-03-12 06:03:02', NULL, NULL, '2010178', '/userFront/exportData', 'userFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004073, '组织机构数据导入', '组织机构数据导入', 1450765592889004693, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, '2020-03-11 06:45:50', NULL, NULL, '1020174', '/orgMainFront/importData', 'orgMainFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004074, '导出', '编码规则导出', 1450765592889004610, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 11:37:00', NULL, '2019-08-26 20:15:35', '100010223', '/idtableFront/exportData', 'idtable:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004075, '定义组织类型', '定义组织类型', 1450765592889004653, '/SysOrgType', 'HussarAuthorization/src/views/organ/SysOrgType', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000007', '/orgType/view', 'orgType:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004080, '新增角色分组页面', '新增角色分组页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000009', '/roleManager/roleAddGroupPage', 'roleManager:roleAddGroupPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004082, '用户数据导入', '用户数据导入', 1450765592889004737, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2020-03-12 06:02:34', NULL, NULL, '2010177', '/userFront/importData', 'userFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004085, '流程管理', '流程管理', 523177185453023232, '/bpmModelEdit', 'BpmManageServer/src/views/modeling/modelEdit', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-07 13:38:06', NULL, NULL, '020202010502', '/bpmModelEdit/view', 'bpmModelEdit:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004087, '菜单导入', '菜单导入', 1450765592889004616, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-26 10:38:21', NULL, '2019-08-26 19:46:48', '菜单维护0215', '/frontMenu/importData', 'frontMenu:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004088, '获取所有的ehcache缓存名', '获取所有的ehcache缓存名', 1450765592889004621, NULL, NULL, '0', 'res_btn', 3, '0', '1', NULL, NULL, '2020-06-05 07:09:18', NULL, NULL, '缓存监控0179', '/ehcacheFront/getAllCacheName', 'ehcache:getAllCacheName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004089, '指定机构人员树', '指定机构人员树', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'emp000000002', '/employeeFront/employeeTreeById', 'employeeFront:employeeTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004090, '版本管理', '版本管理', NULL, '/bpmVersion', '@/bpm/views/modeling/index', '0', 'res_menu', 2, '0', '1', '1', NULL, '2021-06-07 13:39:47', NULL, NULL, '020202010503', '/version/view', 'version:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004091, '删除基础配置', '删除基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'sbc000000002', '/sysBaseConfig/delete', 'sysBaseConfig:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004092, '增加不相容角色集', '增加不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000009', '/incompatibleRolesFront/addRole', 'incompatibleRolesFront:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004096, '组织机构用户树', '组织机构用户树', 1450765592889004599, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'user00000001', '/userFront/userTree', 'userFront:userTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004098, '模块修改', '模块修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, '2018-04-20 17:12:58', '3333', '/resource/moduleEdit', 'resourceFront:moduleEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004099, '获取不相容角色集信息', '获取不相容角色集信息', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'inco00000002', '/incompatibleRolesFront/selectInRole', 'incompatibleRoles:selectInRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004101, '资源删除', '资源删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, NULL, NULL, '2019-08-26 09:37:43', '000000000012', '/resourceFront/delResource', 'resourceFront:delResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004105, '批量新增事件页面', '批量新增事件页面', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'cal000000001', '/calendar/addView', 'calendar:addView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004110, '删除附件', '删除附件', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000003', '/attachment/delete', 'attachment:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004112, '用户角色审核页面', '用户角色审核页面', 1450765592889004699, '/userRoleVerify', 'HussarAuthorization/src/views/permit/rolemanage/userRoleVerify/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000013', '/userRoleReview/view', 'userRoleReview:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004114, '授权信息', '授权信息', 1450765592889004631, '/license', 'HussarOperations/src/views/system/license/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2018-06-26 08:57:20', NULL, '2019-08-26 13:44:09', '007000780149', '/licenseFront/view', 'license:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004115, ' 获取当前数据库内存使用大小情况', ' 获取当前数据库内存使用大小情况', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000003', '/redis/getMemeryInfo', 'redis:getMemeryInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004118, '删除', '员工删除', 1450765592889004578, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000014', '/employeeFront/delEmployeeById', 'employeeFront:delEmployeeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004119, '个性化配置快捷方式菜单树', '个性化配置快捷方式菜单树', 1450765592889004623, NULL, NULL, '0', 'res_btn', 2, '0', '1', NULL, NULL, '2021-07-29 14:20:21', NULL, NULL, '0501', '/frontMenu/shortCutMenuTree', 'frontMenu:shortCutMenuTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004120, '增加下级', '增加下级', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, '2019-08-26 19:46:33', '0008', '/menu/menuAdd', 'menu:menuAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004121, '用户排序', '用户排序', 1450765592889004737, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000015', '/userFront/saveUserOrder', 'userFront:saveUserOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004122, '人员数据导出', '人员数据导出', 1450765592889004578, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, '2020-03-11 10:25:37', NULL, NULL, '1030175', '/employeeFront/exportData', 'employeeFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004124, '组织机构修改', '组织机构修改', 1450765592889004693, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2019-08-26 17:17:57', NULL, '2019-08-27 09:31:25', '1020237', '/orgMainFront/orgInfoEditSave', 'orgMainFront:orgInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004131, '基础配置', '基础配置', 1450765592889004658, '/baseConfig', 'HussarConfig/src/views/system/baseConfig/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2019-08-16 10:28:58', NULL, '2019-08-26 13:59:10', '000400940168', '/sysBaseConfig/view', 'sysBaseConfig:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004134, '根据ID获取转移组织机构树', '根据ID获取转移组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'org000000004', '/orgMainFront/orgChangeById', 'orgMainFront:orgChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004136, '不相容角色集查询', '不相容角色集查询', 1450765592889004725, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 09:10:54', NULL, NULL, '2030204', '/incompatibleRolesFront/list', 'incompatibleRolesFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004137, '重置密码', '重置密码', 1450765592889004602, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-21 17:09:59', NULL, '2019-08-26 20:06:24', '2070173', '/userFront/resetAllPwd', 'userFront:resetAllPwd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004138, '加载菜单树', '加载菜单树', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'menu00000001', '/frontMenu/menuTree', 'frontMenu:menuTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004141, '组织机构审核页面', '组织机构审核页面', 523064495887884288, '/organAudit', 'HussarAuthorization/src/views/organAudit/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2019-08-16 10:24:08', NULL, '2019-08-23 09:56:47', '007600900165', '/sysStruAudit/view', 'sysStruAudit:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004143, '加载角色树', '加载角色树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 15, '0', '1', NULL, NULL, '2020-06-05 06:45:07', NULL, NULL, '2020170', '/roleManagerFront/getUserRole', 'roleManager:getUserRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004144, '角色关联用户查看树', '角色关联用户查看树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000010', '/roleManagerFront/roleUserTreeView', 'roleManagerFront:roleUserTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004145, '我的传阅', '我的传阅', 1450765592889004711, '/ccList', 'HussarPersonalMatters/src/views/taskmanage/ccList', '0', 'res_menu', 1, '0', '1', NULL, NULL, '2020-08-12 01:55:43', NULL, NULL, '002500950193', '/ccTask/view', 'ccTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004146, '系统监控页面', '系统监控页面', 1450765592889004660, '/systemMonitor', 'HussarOperations/src/views/service/systemMonitor/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2018-04-23 13:34:18', NULL, NULL, '002600160043', '/smon?action=monitor', 'smon:monitor', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004147, '模块查看', '模块查看', 1450765592889004630, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2018-04-20 16:57:04', NULL, NULL, '资源维护0033', '/resource/moduleView', 'resource:moduleView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004148, '员工维护', '员工维护', 1450765592889004578, '/StaffManage', 'HussarAuthorization/src/views/staffManage/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000017', '/employee/employeeList', 'employee:employeeList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004149, '角色分组排序', '角色分组排序', 1450765592889004740, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2019-08-23 11:43:58', NULL, NULL, '2020202', '/roleManagerFront/saveGroupOrder', 'roleManagerFront:saveGroupOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004150, '会话追踪列表', '会话追踪列表', 1450765592889004700, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-26 20:00:41', NULL, NULL, '5050245', '/securityLogFront/list', 'securityLogFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004151, '工作日历修改', '工作日历修改', 1450765592889004611, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2019-08-26 13:38:11', NULL, NULL, 'null00340227', '/calendarFront/editEvent', 'calendar:editEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004152, '修改用户', '修改用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000018', '/userFront/edit', 'userFront:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004153, '获取本组织机构及直属组织机构', '获取本组织机构及直属组织机构', 1450765592889004693, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, '2020-12-02 14:37:22', NULL, NULL, '1020189', '/commonOrgan/directOrgList', 'commonOrgan:searchDirectOrgList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004156, '模块转移', '模块转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, '2019-08-26 09:29:42', NULL, '2019-08-26 09:30:33', '资源维护0210', '/resourceFront/moduleTreeChange', 'resourceFront:moduleTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004157, '基础配置详情', '基础配置详情', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'sbc000000003', '/sysBaseConfigFront/detail', 'sysBaseConfig:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004159, '系统日志查询', '系统日志查询', 1450765592889004583, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'log000000001', '/logMongo/find', 'logMongo:find', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004160, '保存用户数据权限', '保存用户数据权限', 1450765592889004737, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, '2021-03-05 10:05:28', NULL, NULL, '2010503', '/userFront/saveDataScope', 'userFront:saveDataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004161, '新增', '组织机构新增', 1450765592889004693, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:19', '0006', '/orgMainFront/orgInfoSave', 'orgMainFront:orgInfoSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004167, '组织机构规则页面', '组织机构规则页面', 1450765592889004698, '/SysOrgRule', 'HussarAuthorization/src/views/organ/SysOrgRule', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000019', '/orgRule/view', 'orgRule:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004168, '用户审核新增通过', '用户审核新增通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, '2019-08-23 11:20:59', NULL, NULL, '007600900195', '/sysUsersAuditFront/passAdd', 'sysUsersAuditFront:passAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004169, '人员审核列表', '人员审核列表', 523064540137791488, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 10:50:49', NULL, NULL, '007600900191', '/sysStaffAuditFront/list', 'sysStaffAudit:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004171, '增加角色', '增加角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:49', '000000000020', '/roleManagerFront/addRole', 'roleManagerFront:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004173, '角色审核', '角色审核', 1450765592889004699, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000021', '/userRoleReviewFront/reviewSubmit', 'userRoleReviewFront:reviewSubmit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004175, '在线用户历史记录列表', '在线用户历史记录列表', 1450765592889004718, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'online000002', '/onlineHistFront/list', 'onlineHist:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004176, '删除', '编码规则删除', 1450765592889004610, '', '', '1', 'res_btn', 3, '0', '1', '', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:35', '000000000022', '/codeRuleService/deleteCodeRule', 'codeRuleService:deleteCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004178, '字段修改', '字段修改', 1450765592889004593, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, '2019-08-26 11:07:52', NULL, NULL, '字典管理0219', '/dicFront/update_single', 'dict:update_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004179, '用户审核', '用户审核', 1450765592889004651, '/userAudit', 'HussarAuthorization/src/views/permit/auditManage/userAudit/index', '1', 'res_menu', 7, '0', '1', '1', NULL, '2019-08-16 10:24:22', NULL, NULL, '007600900166', '/user/audit', 'user:audit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004180, '组织机构数据导出', '组织机构数据导出', 1450765592889004693, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, '2020-03-11 06:44:58', NULL, NULL, '1020173', '/orgMainFront/exportData', 'orgMainFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004181, '人员数据导入', '人员数据导入', 1450765592889004578, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2020-03-11 10:26:17', NULL, NULL, '1030176', '/employeeFront/importData', 'employeeFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004182, ' redis管理页面', ' redis管理页面', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000004', '/redis/manageView', 'redis:manageView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004183, '添加删除用户角色', '添加删除用户角色', 1450765592889004740, NULL, NULL, '0', 'res_btn', 18, '0', '1', NULL, NULL, '2020-06-05 07:12:28', NULL, NULL, '2020182', 'roleManagerFront/addOrDelUserRole', 'roleManagerFront:addOrDelUserRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004186, '用户管理页面', '用户管理页面', 1450765592889004737, '/usermanage', 'HussarAuthorization/src/views/userManager/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000024', '/user/view', 'user:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004187, '字典管理', '字典管理页面', 1450765592889004593, '/dictionary', 'HussarGeneral/src/views/system/dictionary/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, '2019-08-26 10:43:39', '000000000025', '/sys/dic/', 'dict:dic', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004188, '获取穿梭框的数据', '获取穿梭框的数据', 1450765592889004725, NULL, NULL, '0', 'res_btn', 7, '0', '1', NULL, NULL, '2020-06-05 06:42:22', NULL, '2020-06-05 06:43:17', '2030169', '/incompatibleRolesFront/transferData', 'incompatibleRoles:transferData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004189, '角色关联用户修改树', '角色关联用户修改树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000011', '/roleManagerFront/roleUserTreeEdit', 'roleManager:roleUserTreeEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004190, '不相容角色集页面', '不相容角色集页面', 1450765592889004725, '/alienRole', 'HussarAuthorization/src/views/permit/rolemanage/alienRole/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000026', '/incompatibleRoles/view', 'incompatibleRoles:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004193, '转移', '人员转移', 1450765592889004578, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-23 10:39:54', NULL, NULL, '1030189', '/employeeFront/staffTransfer', 'employeeFront:staffTransfer', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004198, '组织机构维护页面', '组织机构维护页面', 1450765592889004693, '/OrganMaintenance', 'HussarAuthorization/src/views/organMaintenance/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, '2019-08-23 10:05:02', '000000000027', '/orgMain/orgList', 'orgMain:orgList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004199, '组织机构查看', '组织机构查看', 1450765592889004693, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, '2019-08-27 16:25:04', NULL, NULL, '1020250', '/orgMainFront/orgInfo', 'orgMainFront:orgInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004200, '编码规则列表', '编码规则列表', 1450765592889004610, '', '', '1', 'res_btn', 7, '0', '1', '', NULL, '2019-08-27 16:43:25', 1450756958461300737, '2023-05-06 15:49:48', '100010260', '/codeRuleService/listCodeRules', 'codeRuleService:listCodeRules', '1', '', '', '', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004201, '会话追踪', '会话追踪', 1450765592889004700, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000028', '/securityLog/view2', 'securityLog:view2', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004202, '批量下载', '批量下载', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000004', '/attachment/BatchDownload', 'attachment:BatchDownload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004204, '修改角色分组', '修改角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:32:02', '2020021', '/roleManagerFront/editGroup', 'roleManagerFront:editGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004206, '修改角色', '修改角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:53', '000000000029', '/roleManagerFront/editRole', 'roleManagerFront:editRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004207, '字典导入', '字典导入', 1450765592889004593, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-26 19:54:07', NULL, NULL, '字典管理0243', '/dicFront/importData', 'dict:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004208, '组织机构上移/下移', '组织机构上移/下移', 1450765592889004693, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-23 10:12:48', NULL, NULL, '1020187', '/orgMainFront/singleMove', 'orgMain:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004211, '角色分组信息查看', '角色分组信息查看', 1450765592889004740, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-23 11:41:09', NULL, NULL, '2020201', '/roleManagerFront/roleGroupViewPage', 'roleManagerFront:roleGroupViewPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004212, '字段添加', '字段添加', 1450765592889004593, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 11:06:58', NULL, '2019-08-26 18:01:45', '字典管理0218', '/dicFront/add_single', 'dict:add_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004213, '用户注销审核通过', '用户注销审核通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, '2019-08-26 17:36:15', NULL, NULL, '007600900241', '/sysUsersAuditFront/passCalcel', 'sysUsersAuditFront:passCalcel', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004214, '资源转移', '资源转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, '2019-08-26 09:32:21', NULL, NULL, '资源维护0212', '/resourceFront/resourceTreeChange', 'resourceFront:resourceTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004218, '资源回收', '资源回收', 1450765592889004630, NULL, NULL, '1', 'res_btn', 25, '0', '1', NULL, NULL, '2020-02-18 06:37:13', NULL, NULL, '资源维护0169', '/resourceFront/retrieveResource', 'resourceFront:retrieveResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004220, '资源维护页面', '资源维护页面', 1450765592889004630, '/resourceManage', 'HussarAuthorization/src/views/permit/resourceManage/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, '2019-08-26 09:18:55', '000000000031', '/resource/resList', 'resource:resList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004222, '变更所属部门', '变更所属部门', 1450765592889004737, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000032', '/user/changeOrg', 'user:changeOrg', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004223, '获取负责人列表', '获取负责人列表', 1450765592889004693, NULL, NULL, '0', 'res_btn', 15, '0', '1', NULL, NULL, '2020-06-05 06:39:23', NULL, NULL, '1020167', '/orgMainFront/principalSelect', 'orgMainFront:principalSelect', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004224, '批量新增事件页面', '批量新增事件页面', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'cal000000002', '/calendar/deleteView', 'calendar:deleteView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004226, '任务管理', '任务管理', 523177259834810368, '/bpmTask', 'BpmManageServer/src/views/taskManagement/task', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-07 13:43:12', NULL, NULL, '020202030505', '/bpmTask/view', 'bpmTask:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004229, '待办任务', '待办任务', 1450765592889004598, '/toDoList', 'HussarPersonalMatters/src/views/taskmanage/todoList', '1', 'res_menu', 1, '0', '1', NULL, NULL, '2018-04-20 18:05:34', NULL, '2018-06-11 18:19:34', '002500120034', '/sysTodo/view', 'sysTodo:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004230, '模块删除', '模块删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, '2019-08-26 09:36:46', '000000000033', '/resourceFront/delModule', 'resourceFront:delModule', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004235, '系统日志下载', '系统日志下载', 1450765592889004583, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'log000000002', '/logMongo/dowlond', 'logMongo:dowlond', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004237, '角色关联用户新增树', '角色关联用户新增树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000012', '/roleManagerFront/roleUserTreeAdd', 'roleManager:roleUserTreeAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004239, '功能管理', '功能管理', 523074819135381504, '/functionManage', 'HussarAuthorization/src/views/permit/functionManage/index', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-21 14:30:47', NULL, NULL, '00020513', '/function/manage', 'function:manage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004240, '已办任务', '已办任务', 1450765592889004603, '/doneList', 'HussarPersonalMatters/src/views/taskmanage/doneList', '1', 'res_menu', 1, '0', '1', NULL, NULL, '2018-04-20 18:06:21', NULL, '2018-04-23 10:01:57', '002500130035', '/sysDone/view', 'sysDone:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004247, '功能删除', '功能删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 09:44:48', '00003', '/resourceFront/delFunction', 'resourceFront:delFunction', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004251, '查看不相容角色集', '查看不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'inco00000003', '/incompatibleRolesFront/roleView', 'incompatibleRolesFront:roleView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004252, '功能新增', '功能新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 09:43:47', '00001', '/resourceFront/functionAdd', 'resourceFront:functionAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004253, '下级配置项', '下级配置项', 1450765592889004658, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2021-01-18 15:46:13', NULL, '2021-01-18 15:48:21', '000400940193', '/sysBaseConfigFront/configList', 'sysBaseConfigFront:configList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004257, '菜单详情页面', '菜单详情页面', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'menu00000002', '/frontMenu/menuInfo', 'frontMenu:menuInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004258, ' 获取当前数据库中所有db的map', ' 获取当前数据库中所有db的map', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000005', '/redisFront/getAllRedisDatabaseList', 'redis:getAllRedisDatabaseList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004259, '修改不相容角色集', '修改不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000034', '/incompatibleRolesFront/editRole', 'incompatibleRolesFront:editRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004261, '用户详情', '用户详情', 1450765592889004737, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2019-08-23 11:35:25', NULL, NULL, '2010200', '/userFront/userInfo', 'userFront:userInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004263, '修改基础配置', '修改基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-21 16:58:52', NULL, '2019-08-26 13:57:16', '000400940171', '/sysBaseConfigFront/update', 'sysBaseConfigFront:update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004265, '获取组织机构树', '获取组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, '2020-01-13 15:46:29', NULL, NULL, '1020327', '/orgMainFront/orgTree', 'orgMainFront:orgTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004268, '我的委托', '我的委托', 1450765592889004632, '/entrustList', 'HussarPersonalMatters/src/views/taskmanage/entrustList', '0', 'res_menu', 1, '0', '1', NULL, NULL, '2020-10-09 06:46:02', NULL, '2020-10-09 07:06:39', '002501010225', '/entrustTask/view', 'entrustTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004269, '保存资源', '保存资源', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000002', '/roleManagerFront/saveResource', 'roleManager:saveResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004270, '修改', '组织规则修改', 1450765592889004698, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000035', '/orgRuleFront/edit', 'orgRule:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004274, '可视化设计器', '可视化设计器', 1450765592889004620, '/hussarvfg/index', '/hussarvfg/', '0', 'res_menu', 1, '0', '3', '1', NULL, '2019-08-29 03:38:13', NULL, NULL, '000600910166', '/static/design/index.html', 'static:design', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004277, '字典新增', '字典新增', 1450765592889004593, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, '2020-11-04 03:21:19', NULL, '2020-11-04 03:28:30', '字典管理0205', '/dicFront/addGroup', 'dict:addGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004278, '模块新增', '模块新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, '2018-04-20 17:00:18', '122222', '/resource/moduleAdd', 'resourceFront:moduleAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004281, '角色新增关联用户保存', '角色新增关联用户保存', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000013', '/roleManagerFront/saveRoleUserAdd', 'roleManager:saveRoleUserAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004283, '获取用户数据权限', '获取用户数据权限', 1450765592889004737, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, '2021-03-05 10:04:30', NULL, NULL, '2010502', '/userFront/dataScope', 'userFront:dataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004284, '新增', '组织规则新增', 1450765592889004698, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000037', '/orgRuleFront/add', 'orgRule:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004285, '日志监控', '日志监控', 1450765592889004583, NULL, NULL, '1', 'res_btn', 1, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000038', '/logMongo', 'logMongo:index', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004286, '字典上移/下移', '字典上移/下移', 1450765592889004593, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, '2019-08-27 16:32:15', NULL, NULL, '字典管理0254', '/dicFront/singleMove', 'dicFront:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004288, '修改', '员工修改', 1450765592889004578, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 10:56:37', '00011', '/employeeFront/employeeEdit', 'employeeFront:emplInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004291, '删除字典类别', '删除字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2018-04-20 13:58:30', NULL, '2019-08-26 11:01:29', '字典管理0030', '/dicFront/delete', 'dict:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004292, '资源导入', '资源导入', 1450765592889004630, NULL, NULL, '1', 'res_btn', 22, '0', '1', NULL, NULL, '2019-08-26 09:27:34', NULL, NULL, '资源维护0208', '/resourceFront/importData', 'resourceFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004293, '慢SQL诊断', '慢SQL诊断', 523159993936257024, '/slowsql', 'HussarOperations/src/views/service/slowsql/index', '0', 'res_menu', 1, '0', '1', '1', NULL, '2018-09-28 13:59:56', NULL, NULL, '002600170152', '/SqlMonitor/sql', 'SqlMonitor:sql', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004295, '获取本组织机构及所有下属组织机构', '获取本组织机构及所有下属组织机构', 1450765592889004693, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, '2020-12-02 14:39:02', NULL, NULL, '1020191', '/commonOrgan/list', 'commonOrgan:searchList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004297, '菜单修改', '菜单修改', 1450765592889004616, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 17:31:39', '0009', '/frontMenu/menuInfoEditSave', 'frontMenu:menuInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004302, '新增', '员工新增', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, '2018-04-24 09:04:23', '00010', '/employeeFront/employeeAdd', 'employeeFront:employeeAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004305, '获取本组织机构直属上级组织机构用户', '获取本组织机构直属上级组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, '2020-12-02 14:41:26', NULL, NULL, '2010194', '/commonUser/superiorUserList', 'commonUser:superiorUserList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004307, '只加载当前角色的资源树', '只加载当前角色的资源树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 31, '0', '1', NULL, NULL, '2020-06-05 07:13:55', NULL, NULL, '资源维护0184', 'resourceFront/selfResourceTree', 'resourceFront:selfResourceTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004308, '新增资源关联角色保存', '新增资源关联角色保存', 1450765592889004630, NULL, NULL, '0', 'res_btn', 34, '0', '1', NULL, NULL, '2020-06-05 07:16:23', NULL, NULL, '资源维护0187', 'resourceFront/resourceAddSaveRole', 'resourceFront:resourceAddSaveRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004309, '模块转移树', '模块转移树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 26, '0', '1', NULL, NULL, '2020-06-05 06:50:04', NULL, NULL, '资源维护0174', 'resourceFront/moduleChangeById', 'resourceFront:moduleChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004310, '字典导出', '字典导出', 1450765592889004593, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2019-08-26 19:54:50', NULL, NULL, '字典管理0244', '/dicFront/exportDict', 'dict:exportDict', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004311, '回收权限', '回收权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000039', '/roleManagerFront/reclaimPerm', 'roleManagerFront:reclaimPerm', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004313, '菜单导出', '菜单导出', 1450765592889004616, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2019-08-26 10:38:52', NULL, '2019-08-26 19:46:51', '菜单维护0216', '/frontMenu/exportMenu', 'frontMenu:exportMenu', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004317, '删除不相容角色集', '删除不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000041', '/incompatibleRolesFront/delRole', 'incompatibleRolesFront:delRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004320, '用户排序树', '用户排序树', 1450765592889004599, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'user00000002', '/userFront/orderTree', 'userFront:orderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004322, '菜单删除', '菜单删除', 1450765592889004616, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 14:55:45', '000000000042', '/frontMenu/delMenuById', 'frontMenu:delMenuById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004323, '查询是否已有角色集', '查询是否已有角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'inco00000004', '/incompatibleRoles/sameRolesName', 'incompatibleRoles:sameRolesName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004325, '工作日历页面', '工作日历页面', 1450765592889004611, '/workcalendar', 'HussarGeneral/src/views/system/workcalendar/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2018-05-17 15:26:04', NULL, '2019-08-26 11:39:37', 'null00340107', '/calendar/view', 'calendar:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004327, '工作日历批量删除', '工作日历批量删除', 1450765592889004611, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 13:39:22', NULL, NULL, 'null00340228', '/calendarFront/delEvent', 'calendar:delEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004328, '角色欢迎页新增', '角色欢迎页新增', 1450765592889004726, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-26 13:49:26', NULL, NULL, '000400840231', '/sysWelcome/addRole', 'sysWelcome:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004329, '检验是否已存在URL', '是否已存在URL', 1450765592889004630, NULL, NULL, '0', 'res_btn', 32, '0', '1', NULL, NULL, '2020-06-05 07:14:41', NULL, NULL, '资源维护0185', 'resourceFront/sameUrl', 'resource:sameUrl', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004330, '角色修改关联用户保存', '角色修改关联用户保存', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000014', '/roleManagerFront/saveRoleUserEdit', 'roleManager:saveRoleUserEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004332, '删除', '组织类型删除', 1450765592889004653, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:05', '000000000043', '/sysOrganFront/delByIds', 'sysOrganFront:delByIds', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004333, '查询是否已有角色', '查询是否已有角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000003', '/roleManagerFront/sameRoleName', 'roleManagerFront:sameRoleName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004334, '登录页配置', '登录页配置', 1450765592889004689, '/loginConf', 'HussarConfig/src/views/personalizedConf/loginConf', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-23 11:38:52', NULL, NULL, '020102030504', '/personalizedConf/loginConf', 'personalizedConf:loginConf', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004336, '删除欢迎页', '删除欢迎页', 1450765592889004726, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-26 13:50:16', NULL, NULL, '000400840232', '/sysWelcome/delete', 'sysWelcome:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004337, '获取资源转移树', '获取资源转移树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 27, '0', '1', NULL, NULL, '2020-06-05 07:03:01', NULL, NULL, '资源维护0175', 'resourceFront/resourceChangeById', 'resourceFront:resourceChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004338, '用户审核转移通过', '用户审核转移通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, '2019-08-23 11:23:32', NULL, NULL, '007600900198', '/sysUsersAuditFront/passTrans', 'sysUsersAuditFront:passTrans', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004339, '操作', '添加不相容角色', 1450765592889004725, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '2030023', '/incompatibleRolesFront/saveInRoles', 'incompatibleRolesFront:saveInRoles', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004342, '组织机构转移', '组织机构转移', 1450765592889004693, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2019-08-23 10:09:20', NULL, NULL, '1020186', '/orgMainFront/orgTreeChange', 'orgMainFront:orgTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004344, '资源保存', '资源保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 10:41:19', '0005', '/resource/resourceEditSave', 'resourceFront:resourceSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004345, '文件下载', '文件下载', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000005', '/attachment/fileDownload', 'attachment:fileDownload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004347, '编码规则维护页面', '编码规则维护页面', 1450765592889004610, '/customCodingRules', 'HussarCodePlus/src/views/customCodingRules/index', '1', 'res_menu', 2, '0', '1', '1', NULL, '2019-08-23 09:44:27', 1450756958461300737, '2023-04-28 11:30:15', 'id0000000001', '', 'idtable:idtableManage', '1', '', '', '', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004348, '新增用户', '新增用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000044', '/userFront/add', 'userFront:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004349, '获取某个资源关联的角色树', '获取某个资源关联的角色树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 33, '0', '1', NULL, NULL, '2020-06-05 07:15:29', NULL, NULL, '资源维护0186', 'resourceFront/roleTreeView', 'resourceFront:roleTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004351, '审计日志页面', '审计日志页面', 1450765592889004756, '/auditlog', 'HussarAudit/src/views/system/auditlog/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000045', '/securityLog/view', 'securityLog:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004354, '解冻密码', '解冻密码', 1450765592889004746, '/thawcode', 'HussarOperations/src/views/system/thawcode/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2019-02-21 16:02:11', NULL, '2019-08-26 11:27:00', 'null01390318', '/thawPwd/view', 'thawPwd:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004356, '函数管理', '函数管理', 523177287164895232, '/bpmFunction', 'BpmManageServer/src/views/function/index', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-07 13:54:48', NULL, NULL, '020202040507', '/bpmFunction/view', 'bpmFunction:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004357, '下级排序', '菜单树下级排序', 1450765592889004616, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, '2019-08-26 19:46:36', '000000000046', '/frontMenu/menuTreeOrder', 'frontMenu:menuTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004358, '根据父ID获取下级菜单树', '根据父ID获取下级菜单树', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'menu00000003', '/frontMenu/menuTreeById', 'frontMenu:menuTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004363, '组织机构修改页面', '组织机构修改页面', 1450765592889004693, NULL, NULL, '0', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 17:21:47', NULL, NULL, '1020239', '/orgMainFront/orgInfoEdit', 'orgMain:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004364, '检查重复权限', '检查重复权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, '2021-01-18 17:57:02', NULL, NULL, '2020194', '/roleManagerFront/checkResource', 'roleManagerFront:checkResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004366, '用户审核详情', '用户审核详情', 1450765592889004651, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2019-08-23 11:17:32', NULL, NULL, '007600900192', '/sysUsersAuditFront/detail', 'sysUsersAuditFront:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004368, '懒加载获取角色用户树', '懒加载获取角色用户树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 16, '0', '1', NULL, NULL, '2020-06-05 07:10:24', NULL, NULL, '202018002', 'roleManagerFront/lazyRoleUserTreeView', 'roleManager:lazyRoleUserTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004369, '根据模块ID获取下级功能树', '根据模块ID获取下级功能树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 29, '0', '1', NULL, NULL, '2020-06-05 06:47:14', NULL, NULL, '2020171', 'resourceFront/functionTreeById', 'resourceFront:functionTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004371, '获取日历事件类型下拉框', '获取日历事件类型下拉框', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'cal000000003', '/calendar/calendarEventTypeOption', 'calendar:calendarEventTypeOption', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004378, '新增', '组织类型新增', 1450765592889004653, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:30:59', '000000000049', '/sysOrganFront/add', 'sysOrganFront:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004380, '显示图片', '显示图片', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000001', '/attachment/showPicture', 'attachment:showPicture', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004382, '新增字典类别', '新增字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2018-04-20 13:55:35', NULL, '2019-08-26 18:02:32', '字典管理0027', '/dicFront/add', 'dict:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004383, '查询', '组织规则查询', 1450765592889004698, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000050', '/orgRuleFront/list', 'orgRule:search', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004384, '字典修改', '字典修改', 1450765592889004593, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, '2020-11-04 13:43:57', NULL, NULL, '字典管理0206', '/dicFront/editGroup', 'dict:editGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004390, '组织机构操作审核详情', '组织机构操作审核详情', 523064495887884288, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, '007600900182', '/sysStruAuditFront/detail', 'sysStruAudit:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004391, '查询是否已有分组', '查询是否已有分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000004', '/roleManagerFront/sameGroupName', 'roleManagerFront:sameGroupName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004393, '文件上传回显', '文件上传回显', 1450765592889004614, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2020-12-07 11:36:05', NULL, NULL, '附件监控0201', '/attachment/uploadFileQuery', 'attachment:uploadFileQuery', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004394, '组织机构排序', '组织机构人员排序', 1450765592889004693, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2019-08-23 10:13:54', NULL, '2019-08-23 10:41:54', '1020188', '/orgMainFront/orgTreeOrder', 'orgMainFront:orgTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004395, '菜单维护', '菜单维护', 1450765592889004616, '/menumaintain', 'HussarAuthorization/src/views/menumaintain/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000052', '/menu/menuList', 'menu:menuList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004397, '资源下级排序', '资源下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, '2019-08-26 09:24:59', NULL, NULL, '资源维护0207', '/resourceFront/resourceTreeOrder', 'resourceFront:resourceTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004400, '获取本级用户列表', '获取本级用户列表', 1450765592889004737, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, '2021-01-14 16:05:52', NULL, '2021-01-14 16:08:13', '2010191', '/userFront/accountList', 'userFront:accountList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004401, '用户审核修改详情', '用户审核修改详情', 1450765592889004651, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-23 11:18:53', NULL, NULL, '007600900193', '/sysUsersAuditFront/editDetail', 'sysUsersAuditFront:editDetail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004403, ' 删除redis key', ' 删除redis key', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000007', '/redisFront/deleteNoSQLKeys', 'redis:deleteNoSQLKeys', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004404, '资源新增', '资源新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, NULL, NULL, '2019-08-26 09:37:18', '000000000053', '/resourceFront/resourceAdd', 'resourceFront:resourceAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004406, '用户审核删除通过', '用户审核删除通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, '2019-08-23 11:23:01', NULL, NULL, '007600900197', '/sysUsersAuditFront/passDel', 'sysUsersAuditFront:passDel', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004407, '重置密码页面', '重置密码页面', 1450765592889004602, '/resetpassword', 'HussarOperations/src/views/system/resetpassword/index', '1', 'res_menu', 2, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000054', '/user/pageResetAllPwd', 'user:pageResetAllPwd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004409, '注销用户', '注销用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, '2019-08-26 16:59:51', NULL, NULL, '2010236', '/userFront/cancelUser', 'userFront:cancelUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004410, '根据功能ID获取资源树', '根据功能ID获取资源树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 28, '0', '1', NULL, NULL, '2020-06-05 06:48:03', NULL, NULL, '2020172', 'resourceFront/resourceTreeById', 'resourceFront:resourceTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004411, '角色复制', '角色复制', 1450765592889004737, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000055', '/userFront/copyRole', 'userFront:copyRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004413, '解冻', '删除缓存', 1450765592889004746, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-26 11:28:11', NULL, '2019-08-27 17:51:38', 'null01390221', '/ehcacheFront/deleteByKeys', 'ehcache:deleteByKeys', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004414, '在线用户页面', '在线用户页面', 1450765592889004700, '/onlineuser', 'HussarAudit/src/views/system/onlineuser/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000056', '/online/view', 'online:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004416, '授权文件上传', '授权文件上传', 1450765592889004631, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'lic000000001', '/licenseFront/upload', 'license:upload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004417, '获取角色数据权限', '获取角色数据权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, '2021-03-05 11:30:07', NULL, NULL, '2020504', '/roleManagerFront/dataScope', 'roleManager:dataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004421, '字段删除', '字段删除', 1450765592889004593, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2019-08-26 11:11:48', NULL, NULL, '字典管理0220', '/dicFront/delete_single', 'dict:delete_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004422, '角色数据导入', '角色数据导入', 1450765592889004740, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, '2020-03-13 10:02:32', NULL, NULL, '202018001', '/roleManagerFront/importData', 'roleManagerFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004427, '查看', '员工查看', 1450765592889004578, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000057', '/employeeFront/employeeInfo', 'employeeFront:employeeInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004429, '多文件上传', '多文件上传', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000006', '/attachment/uploadfilewithdrag', 'attachment:uploadfilewithdrag', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004432, '加载角色树', '加载角色树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 12, '0', '1', NULL, NULL, '2020-01-13 15:45:06', NULL, NULL, '2020326', '/roleManagerFront/roleTree', 'roleManagerFront:roleTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004433, '查询角色分组下的角色', '查询角色分组下的角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000005', '/roleManagerFront/searchRoleToGroup', 'roleManagerFront:searchRoleToGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004434, '修改', '组织类型修改', 1450765592889004653, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, '2019-08-27 09:31:03', '000000000058', '/sysOrganFront/edit', 'sysOrganFront:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004437, '菜单新增', '菜单新增', 1450765592889004616, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-26 19:50:14', NULL, '2019-08-26 19:52:05', '菜单维护0242', '/frontMenu/menuInfoSave', 'frontMenu:menuInfoSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004440, '根据组织机构的stru_id ，获取本组织机构用户', '根据组织机构的stru_id ，获取本组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, '2020-12-02 14:40:16', NULL, NULL, '201019202', '/commonUser/userList', 'commonUser:userList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004443, '获取当前部门下的用户关联角色的信息', '获取当前部门下的用户关联角色的信息', 1450765592889004740, NULL, NULL, '0', 'res_btn', 17, '0', '1', NULL, NULL, '2020-06-05 07:11:14', NULL, NULL, '2020181', 'roleManagerFront/getRoleOrgUser', 'roleManagerFront:getRoleOrgUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004444, '用户角色列表', '用户角色列表', 1450765592889004699, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-27 16:28:36', NULL, NULL, '2040252', '/userRoleReviewFront/list', 'userRoleReviewFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004445, '新增', '编码规则新增', 1450765592889004610, '', '', '1', 'res_btn', 2, '0', '1', '', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:01', '000000000061', '/codeRuleService/saveCodeRule', 'codeRuleService:saveCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004449, '解冻密码列表', '获取缓存列表', 1450765592889004746, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-27 16:42:04', NULL, '2019-08-27 16:59:03', 'null01390259', '/ehcacheFront/list', 'ehcache:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004450, '重置密码用户列表', '重置密码用户列表', 1450765592889004735, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-27 16:40:39', NULL, NULL, '2060258', '/userFront/userList', 'userFront:userList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004452, '加载角色分组排序树', '加载角色分组排序树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000015', '/roleManagerFront/groupOrderTree', 'roleManager:groupOrderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004453, '我的催办', '我的催办', 1450765592889004597, '/urgeList', 'HussarPersonalMatters/src/views/taskmanage/urgeList', '0', 'res_menu', 1, '0', '1', NULL, NULL, '2020-08-12 01:55:01', NULL, NULL, '002500940192', '/sysActUrgeTask/view', 'sysActUrgeTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004454, '人员审核', '人员审核页面', 523064540137791488, '/staffAudit', 'HussarAuthorization/src/views/staffAudit/index', '1', 'res_menu', 1, '0', '1', '1', NULL, '2019-08-16 10:25:03', NULL, '2019-08-23 11:12:26', '007600900167', '/sysStaffAuditFront/view', 'sysStaffAudit:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004456, '在线用户列表', '在线用户列表', 1450765592889004700, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'online000001', '/onlineFront/list', 'online:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004457, '审计日志明细', '审计日志明细', 1450765592889004756, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000062', '/securityLogFront/cmdDetail', 'securityLogFront:cmdDetail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004460, '资源导出', '资源导出', 1450765592889004630, NULL, NULL, '1', 'res_btn', 23, '0', '1', NULL, NULL, '2019-08-26 09:28:06', NULL, NULL, '资源维护0209', '/resourceFront/exportRes', 'resourceFront:exportRes', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004461, '获取日志目录树', '获取日志目录树', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logD00000001', '/logDownloadFront/logTree', 'logDownload:logTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004462, '获取日历事件', '获取日历事件', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'cal000000004', '/calendarFront/list', 'calendar:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004464, '欢迎页列表权限', '欢迎页列表权限', 1450765592889004726, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, '2019-08-26 13:52:18', NULL, NULL, '000400840234', '/sysWelcome/list', 'sysWelcome:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004465, '修改资源关联角色保存', '修改资源关联角色保存', 1450765592889004630, NULL, NULL, '0', 'res_btn', 35, '0', '1', NULL, NULL, '2020-06-05 07:17:09', NULL, NULL, '资源维护0188', 'resourceFront/resourceEditSaveRole', 'resourceFront:resourceEditSaveRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004466, '工作日历单日删除', '工作日历单日删除', 1450765592889004611, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, '2019-08-26 13:40:36', NULL, NULL, 'null00340229', '/calendarFront/delOneEvent', 'calendar:delOneEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004469, '组织类型列表', '组织类型列表', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'orgtype00001', '/orgType/orgTypeOption', 'orgType:orgTypeOption', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004470, '  清空日志', '  清空日志', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000001', '/redis/logEmpty', 'redis:logEmpty', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004472, '角色查看页面', '角色查看页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000006', '/roleManager/roleViewPage', 'roleManager:roleViewPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004473, '资源下放', '资源下放', 1450765592889004630, NULL, NULL, '1', 'res_btn', 24, '0', '1', NULL, NULL, '2020-02-18 06:36:11', NULL, NULL, '资源维护0168', '/resourceFront/delegateResource', 'resourceFront:delegateResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004474, '实例管理', '实例管理', 523177216750919680, '/bpmProcess', 'BpmManageServer/src/views/processinst/process', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-07 13:42:36', NULL, NULL, '020202020504', '/bpmProcess/view', 'bpmProcess:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004477, '用户审核驳回', '用户审核驳回', 1450765592889004651, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, '2019-08-23 11:24:16', NULL, NULL, '007600900199', '/sysUsersAuditFront/reject', 'sysUsersAuditFront:reject', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004481, '用户审核列表', '用户审核列表', 1450765592889004651, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, '2019-08-23 11:19:52', NULL, NULL, '007600900194', '/sysUsersAuditFront/listAudit', 'sysUsersAuditFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004482, ' 模糊查询', ' 模糊查询', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000006', '/redisFront/showRedisDBValue', 'redis:showRedisDBValue', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004485, '功能查看', '功能查看', 1450765592889004630, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, '2019-08-26 09:35:34', NULL, NULL, '资源维护0213', '/resourceFront/functionView', 'resourceFront:functionView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004486, '组织机构操作审核列表', '组织机构操作审核列表', 523064495887884288, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 10:00:11', NULL, NULL, '007600900185', '/sysStruAuditFront/list', 'sysStruAudit:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004487, '菜单上移/下移', '菜单上移/下移', 1450765592889004616, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, '2019-08-27 14:55:08', NULL, '2019-08-27 19:12:56', '菜单维护0249', '/frontMenu/singleMove', 'frontMenu:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004488, '功能转移', '功能转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, '2019-08-26 09:31:32', NULL, NULL, '资源维护0211', '/resourceFront/functionTreeChange', 'resourceFront:functionTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004492, '文件上传', '文件上传', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000007', '/attachment/attachment:upload', 'attachment:upload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004493, '修改', '编码规则修改', 1450765592889004610, '', '', '1', 'res_btn', 4, '0', '1', '', NULL, NULL, 1450756958461300737, '2023-05-06 15:50:14', '000000000064', '/codeRuleService/updateCodeRule', 'codeRuleService:updateCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004495, '在线历史记录页面', '在线历史记录页面', 1450765592889004718, '/onlinehistory', 'HussarAudit/src/views/system/onlinehistory/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000065', '/onlineHist/view', 'onlineHist:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004497, '修改用户欢迎页配置', '修改用户欢迎页配置', 1450765592889004726, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'wel000000002', '/sysWelcome/sysWelcome_update', 'sysWelcome:sysWelcome_update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004499, '删除', '组织规则删除', 1450765592889004698, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000066', '/orgRuleFront/delete', 'orgRule:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004501, '加载角色排序树', '加载角色排序树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000016', '/roleManagerFront/roleOrderTree', 'roleManagerFront:roleOrderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004502, '获取本组织机构所有下属组织机构的用户', '获取本组织机构所有下属组织机构的用户', 1450765592889004693, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, '2020-12-02 14:38:09', NULL, NULL, '1020190', '/commonOrgan/directList', 'commonOrgan:searchDirectList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004503, '保存角色数据权限', '保存角色数据权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, '2021-03-05 11:31:07', NULL, NULL, '2020505', '/roleManagerFront/saveDataScope', 'roleManager:saveDataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004507, '快捷入口配置', '快捷入口配置', 1450765592889004623, '/shortCutConf', 'HussarConfig/src/views/personalizedConf/shortCutConf', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-23 11:54:08', NULL, NULL, '020102080510', '/personalizedConf/shortCurConf', 'personalizedConf:shortCutConf', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004508, '组织机构新增页面', '组织机构新增页面', 1450765592889004693, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-27 09:28:18', NULL, NULL, '1020247', '/orgMainFront/orgInfoAdd', 'orgMainFront:orgInfoAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004509, '导入', '编码规则导入', 1450765592889004610, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2019-08-26 11:36:14', NULL, '2019-08-26 20:14:40', '100010222', '/idtableFront/importData', 'idtable:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004510, '组织机构人员树', '组织机构人员树', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'emp000000001', '/employeeFront/employeeTree', 'employeeFront:employeeTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004512, '角色数据导出', '角色数据导出', 1450765592889004740, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, '2020-03-13 10:02:05', NULL, NULL, '2020179', '/roleManagerFront/exportData', 'roleManagerFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004513, '慢SQL列表', '慢SQL列表', 523159993936257024, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'sql000000001', '/sqlMonitorFront/list', 'SqlMonitor:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004514, '附件信息列表', '附件信息列表', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'atta00000002', '/attachment/getAttachmentList', 'attachment:getAttachmentList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004515, '日志下载', '日志下载', 1450765592889004701, '/logdownload', 'HussarOperations/src/views/service/logdownload/index', '0', 'res_menu', 1, '0', '1', '1', NULL, '2018-08-29 19:09:12', NULL, NULL, 'null00780148', '/logDownload/view', 'logDownload:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004516, '角色新增页面', '角色新增页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000007', '/roleManager/roleAddPage', 'roleManager:roleAddPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004517, '框架页配置', '框架页配置', 1450765592889004732, '/layoutConf', 'HussarConfig/src/views/personalizedConf/layoutConf', '0', 'res_menu', 1, '0', '1', '1', NULL, '2021-06-23 11:40:01', NULL, NULL, '020102040506', '/personalizedConf/layoutConf', 'personalizedConf:layoutConf', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004519, '驳回', '角色审核驳回', 1450765592889004699, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '2040024', '/userRoleReviewFront/refuseSubmit', 'userRoleReviewFront:refuseSubmit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004521, '组织机构ID获取组织机构树', '组织机构ID获取组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'org000000002', '/orgMainFront/orgTreeById', 'orgMainFront:orgTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004522, '获取日志文件列表', '获取日志文件列表', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logD00000002', '/logDownloadFront/logTable', 'logDownload:logTable', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004526, '查询', '组织类型查询', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000067', '/sysOrganFront/list', 'sysOrganFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004529, '资源修改', '资源修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, NULL, NULL, '2018-04-27 16:19:47', '000034', '/resource/resourceEdit', 'resourceFront:resourceEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004530, '字典下级排序', '字典下级排序', 1450765592889004593, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2018-04-20 13:59:43', NULL, '2019-08-26 11:04:57', '字典管理0031', '/dicFront/sort', 'dicFront:sort', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004533, '当前用户所在的组织机构', '当前用户所在的组织机构', 1450765592889004737, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, '2020-12-02 14:42:50', NULL, NULL, '2010195', '/commonUser/currentUserInfo', 'commonUser:currentUserInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004536, '删除角色', '删除角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000068', '/roleManagerFront/delRole', 'roleManagerFront:delRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004539, '删除', '组织机构删除', 1450765592889004693, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000069', '/orgMainFront/delOrgById', 'orgMainFront:delOrgById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004544, '模块保存', '模块保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, '2018-04-20 17:05:49', 'mod401370313', '/resourceFront/moduleSave', 'resourceFront:moduleSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004545, ' 获取当前数据库中key的数量', ' 获取当前数据库中key的数量', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'logR00000002', '/redisFront/getKeysSize', 'redis:getKeysSize', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004546, '组织类型详情', '组织类型详情', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'orgtype00002', '/sysOrganFront/selectOrg', 'sysOrganFront:selectOrg', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004551, '基础配置列表权限', '基础配置列表权限', 1450765592889004658, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-26 13:58:06', NULL, NULL, '000400940235', '/sysBaseConfigFront/list', 'sysBaseConfigFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004554, '修改欢迎页', '修改欢迎页', 1450765592889004726, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, '2019-08-26 13:51:01', NULL, NULL, '000400840233', '/sysWelcome/update', 'sysWelcome:update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004555, '角色排序', '角色排序', 1450765592889004740, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, '2019-08-23 11:46:02', NULL, NULL, '2020203', '/roleManagerFront/saveRoleOrder', 'roleManagerFront:saveRoleOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004556, '工作日历单日新增', '工作日历单日新增', 1450765592889004611, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, '2019-08-26 13:36:50', NULL, NULL, 'null00340226', '/calendarFront/addOneEvent', 'calendar:addOneEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004558, '终止会话', '终止会话', 1450765592889004700, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000002', '/onlineFront/stopSession', 'online:stopSession', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004559, '获取不相容角色资源', '获取不相容角色资源', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'inco00000001', '/incompatibleRolesFront/selectInRoles', 'incompatibleRoles:selectInRoles', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004563, '修改字典类别', '修改字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2018-04-20 13:57:13', NULL, '2019-08-26 10:58:24', '字典管理0029', '/dicFront/edit', 'dict:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004564, '查询回收下放树', '查询回收下放树', 1450765592889004693, NULL, NULL, '0', 'res_btn', 14, '0', '1', NULL, NULL, '2020-06-05 06:36:52', NULL, NULL, '1020166', '/orgMainFront/getDelegateRetrieveTree', 'orgMainFront:getDeReTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004565, '根据code获取字典', '根据code获取字典', 1450765592889004630, NULL, NULL, '0', 'res_btn', 30, '0', '1', NULL, NULL, '2020-06-05 07:07:33', NULL, NULL, '资源维护0177', '/dicFront/getDictByCode', 'dict:getDictByCode', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004566, '角色修改页面', '角色修改页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, '2019-08-23 09:44:27', NULL, NULL, 'role00000008', '/roleManager/roleEditPage', 'roleManager:roleEditPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004567, '模块下级排序', '资源模块下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, '2019-08-26 09:22:21', NULL, NULL, '资源维护0205', '/resourceFront/moduleTreeOrder', 'resourceFront:moduleTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004569, '组织机构操作审核', '组织机构操作审核', 523064495887884288, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2019-08-23 09:43:51', NULL, NULL, '007600900181', '/sysStruAuditFront/verify', 'sysStruAudit:verify', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004570, '登陆统计', '登陆统计页面', 1450765592889004756, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, '2018-09-28 14:15:44', NULL, '2019-08-26 11:20:23', '5070153', '/loginStatistics/view', 'loginStatistics:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004571, '获取本组织机构直接下级组织机构用户', '获取本组织机构直接下级组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, '2020-12-02 14:40:48', NULL, NULL, '2010193', '/commonUser/juniorUserList', 'commonUser:juniorUserList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1450765592889004572, '功能保存', '功能保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, NULL, NULL, '2018-04-23 09:51:51', '00012', '/resourceFront/functionSave', 'resourceFront:functionSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912362983088129, '组织树的级联加载-无权限数据', '组织树的级联加载-无权限数据', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504100', '/hussarBase/authorization/organ/lazyLoadingOrganizationTreeNoPermissions', 'hussarBase:authorization:organ:lazyLoadingOrganizationTreeNoPermissions', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363037614082, '组织机构信息修改保存', '组织机构信息修改保存', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504101', '/hussarBase/authorization/organ/editOrganization', 'hussarBase:authorization:organ:editOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363037614083, '保存组织机构树排序', '保存组织机构树排序', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504102', '/hussarBase/authorization/organ/sortOrganization', 'hussarBase:authorization:organ:sortOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363037614084, '组织机构信息查看', '组织机构信息查看', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504103', '/hussarBase/authorization/organ/viewOrganization', 'hussarBase:authorization:organ:viewOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363037614085, '组织机构信息新增保存', '组织机构信息新增保存', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504104', '/hussarBase/authorization/organ/addOrganization', 'hussarBase:authorization:organ:addOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363037614086, '组织树的级联加载', '组织树的级联加载', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504105', '/hussarBase/authorization/organ/lazyLoadingOrganizationTree', 'hussarBase:authorization:organ:lazyLoadingOrganizationTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722945, '根据ID获取转移左侧组织机构树', '根据ID获取转移左侧组织机构树', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504106', '/hussarBase/authorization/organ/getTransferOrganizationTree', 'hussarBase:authorization:organ:getTransferOrganizationTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722946, '根据ID删除组织机构', '根据ID删除组织机构', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504107', '/hussarBase/authorization/organ/deleteOrganization', 'hussarBase:authorization:organ:deleteOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722947, '点击组织机构返回组织机构树', '点击组织机构返回组织机构树', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504108', '/hussarBase/authorization/organ/backOrganizationTree', 'hussarBase:authorization:organ:backOrganizationTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722948, '查询需要排序的组织机构树', '查询需要排序的组织机构树', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504109', '/hussarBase/authorization/organ/getOrderOrganizationTree', 'hussarBase:authorization:organ:getOrderOrganizationTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722949, '根据组织机构类型获取下属单位组织机构类型', '根据组织机构类型获取下属单位组织机构类型', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504110', '/hussarBase/authorization/organ/getOrganizationTypeByParentId', 'hussarBase:authorization:organ:getOrganizationTypeByParentId', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722950, '获取指定节点下的所有转移节点基本信息列表', '获取指定节点下的所有转移节点基本信息列表', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504111', '/hussarBase/authorization/organ/transferOrganizationList', 'hussarBase:authorization:organ:transferOrganizationList', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722951, '转移组织机构', '转移组织机构', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504112', '/hussarBase/authorization/organ/transferOrganization', 'hussarBase:authorization:organ:transferOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722952, '组织树获取单个', '组织树获取单个', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504113', '/hussarBase/authorization/organ/lazyOrganizationById', 'hussarBase:authorization:organ:lazyOrganizationById', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722953, '模糊查询机构列表', '模糊查询机构列表', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504114', '/hussarBase/authorization/organ/searchOrganization', 'hussarBase:authorization:organ:searchOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722954, '根据ID获取组织机构详细信息', '根据ID获取组织机构详细信息', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504115', '/hussarBase/authorization/organ/loadOrganization', 'hussarBase:authorization:organ:loadOrganization', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722955, '获取指定节点下的所有节点基本信息列表', '获取指定节点下的所有节点基本信息列表', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504116', '/hussarBase/authorization/organ/organizationList', 'hussarBase:authorization:organ:organizationList', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722956, '组织机构是否审核', '组织机构是否审核', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504117', '/hussarBase/authorization/organ/isAudit', 'hussarBase:authorization:organ:isAudit', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722957, '组织机构审核通过', '组织机构审核通过', 523064495887884288, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504100', '/hussarBase/authorization/organAudit/approved', 'hussarBase:authorization:organAudit:approved', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722958, '组织机构审核列表', '组织机构审核列表', 523064495887884288, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504101', '/hussarBase/authorization/organAudit/auditList', 'hussarBase:authorization:organAudit:auditList', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722959, '查看组织机构审核详情', '查看组织机构审核详情', 523064495887884288, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504102', '/hussarBase/authorization/organAudit/viewOrganAudit', 'hussarBase:authorization:organAudit:viewOrganAudit', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722960, '组织机构审核驳回', '组织机构审核驳回', 523064495887884288, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504103', '/hussarBase/authorization/organAudit/reject', 'hussarBase:authorization:organAudit:reject', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1585912363104722961, '查询用户数据', '查询用户数据', 1450765592889004693, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-10-27 17:26:40', 1450756958461300737, '2022-10-27 17:26:40', '1020504100', '/hussarBase/authorization/permit/user/searchUsers', 'hussarBase:authorization:permit:user:searchUsers', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289372065793, '懒加载人员部门的下级部门', '懒加载人员部门的下级部门', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504100', '/hussarBase/authorization/staff/lazyLoadingStaffTree', 'hussarBase:authorization:staff:lazyLoadingStaffTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563266, '查询需要排序的人员树', '查询需要排序的人员树', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504101', '/hussarBase/authorization/staff/getOrderStaffTree', 'hussarBase:authorization:staff:getOrderStaffTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563267, '点击组织机构返回人员组织机构树', '点击组织机构返回人员组织机构树', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504102', '/hussarBase/authorization/staff/backStaffTree', 'hussarBase:authorization:staff:backStaffTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563268, '新增人员', '新增人员', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504103', '/hussarBase/authorization/staff/addStaff', 'hussarBase:authorization:staff:addStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563269, '获取当前员工信息列表', '获取当前员工信息列表', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504104', '/hussarBase/authorization/staff/staffList', 'hussarBase:authorization:staff:staffList', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563270, '根据ID获取人员详细信息', '根据ID获取人员详细信息', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504105', '/hussarBase/authorization/staff/loadStaff', 'hussarBase:authorization:staff:loadStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563271, '修改人员', '修改人员', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504106', '/hussarBase/authorization/staff/editStaff', 'hussarBase:authorization:staff:editStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563272, '保存人员排序', '保存人员排序', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504107', '/hussarBase/authorization/staff/sortStaff', 'hussarBase:authorization:staff:sortStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563273, '转移人员', '转移人员', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504108', '/hussarBase/authorization/staff/transferStaff', 'hussarBase:authorization:staff:transferStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563274, '根据ID删除人员', '根据ID删除人员', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504109', '/hussarBase/authorization/staff/deleteStaff', 'hussarBase:authorization:staff:deleteStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289447563275, '人员信息查看', '人员信息查看', 1450765592889004578, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504110', '/hussarBase/authorization/staff/viewStaff', 'hussarBase:authorization:staff:viewStaff', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672130, '懒加载用户组织机构树', '懒加载用户组织机构树', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504100', '/hussarBase/authorization/permit/user/lazyLoadingUserTree', 'hussarBase:authorization:permit:user:lazyLoadingUserTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672131, '查询重置用户列表数据', '查询重置用户列表数据', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504101', '/hussarBase/authorization/permit/user/searchResetSecureUsers', 'hussarBase:authorization:permit:user:searchResetSecureUsers', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672132, '点击组织机构返回用户组织机构树', '点击组织机构返回用户组织机构树', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504102', '/hussarBase/authorization/permit/user/backUserTree', 'hussarBase:authorization:permit:user:backUserTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672133, '删除用户', '删除用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504103', '/hussarBase/authorization/permit/user/deleteUser', 'hussarBase:authorization:permit:user:deleteUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672134, '根据ID获取用户详细信息', '根据ID获取用户详细信息', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504104', '/hussarBase/authorization/permit/user/loadUser', 'hussarBase:authorization:permit:user:loadUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672135, '新增用户', '新增用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504105', '/hussarBase/authorization/permit/user/addUser', 'hussarBase:authorization:permit:user:addUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672136, '查询需要排序的用户树', '查询需要排序的用户树', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504106', '/hussarBase/authorization/permit/user/getOrderUserTree', 'hussarBase:authorization:permit:user:getOrderUserTree', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672137, '查看用户信息', '查看用户信息', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504107', '/hussarBase/authorization/permit/user/viewUser', 'hussarBase:authorization:permit:user:viewUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672138, '修改用户', '修改用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504108', '/hussarBase/authorization/permit/user/editUser', 'hussarBase:authorization:permit:user:editUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672139, '查询用户列表数据', '查询用户列表数据', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504109', '/hussarBase/authorization/permit/user/searchUsers', 'hussarBase:authorization:permit:user:searchUsers', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672140, '保存用户排序', '保存用户排序', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504110', '/hussarBase/authorization/permit/user/sortUser', 'hussarBase:authorization:permit:user:sortUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672141, '注销用户', '注销用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504111', '/hussarBase/authorization/permit/user/cancelUser', 'hussarBase:authorization:permit:user:cancelUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672142, '制用户角色', '制用户角色', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504112', '/hussarBase/authorization/permit/user/copyUserRole', 'hussarBase:authorization:permit:user:copyUserRole', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672143, '休眠用户', '休眠用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504113', '/hussarBase/authorization/permit/user/dormancyUser', 'hussarBase:authorization:permit:user:dormancyUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1592792289514672144, '重置所有用户密码', '重置所有用户密码', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-16 15:44:40', 1450756958461300737, '2022-11-16 15:44:40', '1030504114', '/hussarBase/authorization/permit/user/resetUserSecure', 'hussarBase:authorization:permit:user:resetUserSecure', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180326998018, '查看审核人员详情', '查看审核人员详情', 523064540137791488, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505100', '/hussarBase/authorization/staffAudit/viewStaffAudit', 'hussarBase:authorization:staffAudit:viewStaffAudit', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689793, '人员审核驳回', '人员审核驳回', 523064540137791488, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505101', '/hussarBase/authorization/staffAudit/reject', 'hussarBase:authorization:staffAudit:reject', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689794, '人员审核列表', '人员审核列表', 523064540137791488, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505102', '/hussarBase/authorization/staffAudit/auditList', 'hussarBase:authorization:staffAudit:auditList', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689795, '人员审核通过', '人员审核通过', 523064540137791488, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505103', '/hussarBase/authorization/staffAudit/approved', 'hussarBase:authorization:staffAudit:approved', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689797, '查询复制角色用户列表数据', '查询复制角色用户列表数据', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505101', '/hussarBase/authorization/permit/user/searchCopyRoleUsers', 'hussarBase:authorization:permit:user:searchCopyRoleUsers', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689798, '新增微应用配置', '新增微应用配置', 686145219900743680, '', '', '0', 'res_btn', 4, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160509', '/hussarBase/application/micro/addConf', 'hussarBase:application:micro:addConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689799, '修改微应用配置', '修改微应用配置', 686145219900743680, '', '', '0', 'res_btn', 5, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160510', '/hussarBase/application/micro/editConf', 'hussarBase:application:micro:editConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689800, '查询微应用配置', '查询微应用配置', 686145219900743680, '', '', '0', 'res_btn', 6, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160511', '/hussarBase/application/micro/searchConf', 'hussarBase:application:micro:searchConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689801, '删除微应用配置', '删除微应用配置', 686145219900743680, '', '', '0', 'res_btn', 7, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160512', '/hussarBase/application/micro/deleteConf', 'hussarBase:application:micro:deleteConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689802, '查看微应用配置', '查看微应用配置', 686145219900743680, '', '', '0', 'res_btn', 8, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160513', '/hussarBase/application/micro/viewConf', 'hussarBase:application:micro:viewConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689803, '永久删除微应用配置', '永久删除微应用配置', 686145219900743680, '', '', '0', 'res_btn', 9, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160514', '/hussarBase/application/micro/deleteCOnfForever', 'hussarBase:application:micro:deleteCOnfForever', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180406689804, '新增操作记录', '新增操作记录', 686145219900743680, '', '', '0', 'res_btn', 10, '0', '0', NULL, 1450756958461300737, '2023-07-21 10:42:25', 1450756958461300737, '2023-07-21 10:42:25', '02160515', '/hussarBase/application/micro/addRecord', 'hussarBase:application:micro:addRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (1594592180469604356, '激活用户', '激活用户', 1450765592889004737, '', '', '0', 'res_btn', 22, '0', '0', NULL, 1450756958461300737, '2022-11-21 09:00:00', 1450756958461300737, '2022-11-21 09:00:00', '1030505107', '/hussarBase/authorization/permit/user/activateUser', 'hussarBase:authorization:permit:user:activateUser', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (6069473931100219001, '字典Excel导入模板下载', '字典Excel导入模板下载', 1450765592889004593, '', '', '0', 'res_btn', 17, '0', '0', '0', 1450756958461300737, '2023-05-06 17:59:19', 1450756958461300737, '2023-05-08 09:22:26', '字典管理000005070544', '/hussarBase/general/dict/dictFront/downloadDictExcelImpTpl', 'hussarBase:general:dict:dictFront:downloadDictExcelImpTpl', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (6069473931100219002, '字典Excel导入数据校验', '字典Excel导入数据校验', 1450765592889004593, '', '', '0', 'res_btn', 18, '0', '0', '0', 1450756958461300737, '2023-05-06 17:47:33', 1450756958461300737, '2023-05-08 09:22:17', '字典管理000005070545', '/hussarBase/general/dict/dictFront/checkDictExcel', 'hussarBase:general:dict:dictFront:checkDictExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (6069473931100219003, '字典Excel文件导入', '字典Excel文件导入', 1450765592889004593, '', '', '0', 'res_btn', 19, '0', '0', '0', 1450756958461300737, '2023-05-06 17:53:40', 1450756958461300737, '2023-05-08 09:22:18', '字典管理000005070546', '/hussarBase/general/dict/dictFront/importDictExcel', 'hussarBase:general:dict:dictFront:importDictExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES` VALUES (6069473931100219004, '字典Excel文件导出', '字典Excel文件导出', 1450765592889004593, '', '', '0', 'res_btn', 20, '0', '0', '0', 1450756958461300737, '2023-05-06 17:47:39', 1450756958461300737, '2023-05-08 09:22:11', '字典管理000005070547', '/hussarBase/general/dict/dictFront/exportDictExcel', 'hussarBase:general:dict:dictFront:exportDictExcel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829396173050880000, 'excel导出导入记录保存', 'excel导出导入记录保存', 1450765592889004693, '', '', '0', 'res_btn', 29, '0', '0', '0', 1450756958461300737, '2024-04-07 16:44:17', 1450756958461300737, '2024-04-07 16:44:17', '102000005070156', '/hussarBase/excel/newExcelTask', 'hussarBase:excel:newExcelTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829397564452511744, '获取导入导出信息列表', '获取导入导出信息列表', 1450765592889004693, '', '', '0', 'res_btn', 30, '0', '0', '0', 1450756958461300737, '2024-04-07 16:49:49', 1450756958461300737, '2024-04-07 16:49:49', '102000005070157', '/hussarBase/excel/searchExcelTask', 'hussarBase:excel:searchExcelTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829397905482981376, 'excel文件下载', 'excel文件下载', 1450765592889004693, '', '', '0', 'res_btn', 31, '0', '0', '0', 1450756958461300737, '2024-04-07 16:51:10', 1450756958461300737, '2024-04-07 16:51:10', '102000005070158', '/hussarBase/excel/downloadExcelFile', 'hussarBase:excel:downloadExcelFile', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829405596385288192, '分页查询人员列表(表格)', '分页查询人员列表(表格)', 1450765592889004578, '', '', '0', 'res_btn', 23, '0', '0', '0', 1450756958461300737, '2024-04-07 17:21:44', 1450756958461300737, '2024-04-07 17:21:44', '103000005070161', '/hussarBase/authorization/staff/list', 'hussarBase:authorization:staff:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829406184619646976, '保存人员排序', '保存人员排序', 1450765592889004578, '', '', '0', 'res_btn', 24, '0', '0', '0', 1450756958461300737, '2024-04-07 17:24:04', 1450756958461300737, '2024-04-07 17:24:04', '103000005070162', '/hussarBase/authorization/staff/sortUnifyStaff', 'hussarBase:authorization:staff:sortUnifyStaff', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829409027523092480, '查询岗位列表数据', '查询岗位列表数据', 688348352496279552, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-07 17:35:22', 1450756958461300737, '2024-04-07 17:35:22', '0218000005070163', '/hussarBase/authorization/post/pageList', 'hussarBase:authorization:post:pageList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829409275322572800, '新增岗位', '新增岗位', 688348352496279552, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-07 17:36:21', 1450756958461300737, '2024-04-07 17:36:21', '0218000005070164', '/hussarBase/authorization/post/add', 'hussarBase:authorization:post:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829409533184188416, '修改岗位', '修改岗位', 688348352496279552, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-07 17:37:22', 1450756958461300737, '2024-04-07 17:37:22', '0218000005070165', '/hussarBase/authorization/post/edit', 'hussarBase:authorization:post:edit', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829409805990109184, '删除岗位', '删除岗位', 688348352496279552, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-07 17:38:27', 1450756958461300737, '2024-04-07 17:38:27', '0218000005070166', '/hussarBase/authorization/post/delete', 'hussarBase:authorization:post:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829416135417143296, '保存角色岗位', '保存角色岗位', 1450765592889004740, '', '', '0', 'res_btn', 26, '0', '0', '0', 1450756958461300737, '2024-04-07 18:03:36', 1450756958461300737, '2024-04-07 18:03:36', '202000005070167', '/hussarBase/authorization/permit/role/savePost', 'hussarBase:authorization:permit:role:savePost', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829418436286488576, '保存角色组织', '保存角色组织', 1450765592889004740, '', '', '0', 'res_btn', 27, '0', '0', '0', 1450756958461300737, '2024-04-07 18:12:45', 1450756958461300737, '2024-04-07 18:12:45', '202000005070168', '/hussarBase/authorization/permit/role/saveOrgan', 'hussarBase:authorization:permit:role:saveOrgan', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829418705640497152, '角色关联用户批量查询', '角色关联用户批量查询', 1450765592889004740, '', '', '0', 'res_btn', 28, '0', '0', '0', 1450756958461300737, '2024-04-07 18:13:49', 1450756958461300737, '2024-04-07 18:13:49', '202000005070169', '/roleManagerFront/searchUserListBatch', 'roleManagerFront:searchUserListBatch', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829419102467792896, '保存角色功能', '保存角色功能', 1450765592889004740, '', '', '0', 'res_btn', 29, '0', '0', '0', 1450756958461300737, '2024-04-07 18:15:24', 1450756958461300737, '2024-04-07 18:15:24', '202000005070170', '/roleManagerFront/saveFunction', 'roleManagerFront:saveFunction', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829419565481205760, '保存角色资源', '保存角色资源', 1450765592889004740, '', '', '0', 'res_btn', 30, '0', '0', '0', 1450756958461300737, '2024-04-07 18:17:14', 1450756958461300737, '2024-04-07 18:17:14', '202000005070171', '/roleManagerFront/saveRealResource', 'roleManagerFront:saveRealResource', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829420846300012544, '保存或修改功能模块', '保存或修改功能模块', 523074819135381504, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-07 18:22:20', 1450756958461300737, '2024-04-07 18:22:20', '0221000005070172', '/resourceFront/saveFunModule', 'resourceFront:saveFunModule', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829421115242979328, '保存或修改功能和功能资源关联', '保存或修改功能和功能资源关联', 523074819135381504, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-07 18:23:24', 1450756958461300737, '2024-04-07 18:23:24', '0221000005070173', '/resourceFront/saveFunRes', 'resourceFront:saveFunRes', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829421306264166400, '功能模块下级排序', '功能模块下级排序', 523074819135381504, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-07 18:24:09', 1450756958461300737, '2024-04-07 18:24:09', '0221000005070174', '/resourceFront/functionModuleTreeOrder', 'resourceFront:functionModuleTreeOrder', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829421877826166784, '删除功能模块', '删除功能模块', 523074819135381504, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-07 18:26:26', 1450756958461300737, '2024-04-07 18:26:26', '0221000005070175', '/resourceFront/delFunctionModules', 'resourceFront:delFunctionModules', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829640021417140224, '新增快捷方式分组', '新增快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 08:53:15', 1450756958461300737, '2024-04-08 08:53:15', '02010208000005070176', '/shortcutGroupConfig/add', 'shortcutGroupConfig:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829643935965257728, '修改快捷方式分组', '修改快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 09:08:48', 1450756958461300737, '2024-04-08 09:08:48', '02010208000005070177', '/shortcutGroupConfig/update', 'shortcutGroupConfig:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829644343521583104, '删除快捷方式分组', '删除快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 09:10:26', 1450756958461300737, '2024-04-08 09:10:26', '02010208000005070178', '/shortcutGroupConfig/delete', 'shortcutGroupConfig:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829644682744307712, '控制台保存新增的快捷入口', '控制台保存新增的快捷入口', 1450765592889004623, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 09:11:46', 1450756958461300737, '2024-04-08 09:11:46', '02010208000005070179', '/shortcutConfig/add', 'shortcutConfig:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829644897207459840, '删除快捷入口', '删除快捷入口', 1450765592889004623, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 09:12:38', 1450756958461300737, '2024-04-08 09:12:38', '02010208000005070180', '/shortcutConfig/delete', 'shortcutConfig:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829645143585071104, '修改登录页/欢迎页可视化配置信息', '修改登录页/欢迎页可视化配置信息', 1450765592889004689, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 09:13:36', 1450756958461300737, '2024-04-08 09:13:36', '02010203000005070181', '/sysBaseConfigFront/viewUpdate', 'sysBaseConfigFront:viewUpdate', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829645533818920960, '添加应用', '添加应用', 595571579120001024, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 09:15:09', 1450756958461300737, '2024-04-08 09:15:09', '0215000005070182', '/mobile/application/addApp', 'mobile:application:addApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829646158434672640, '修改应用', '修改应用', 595571579120001024, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 09:17:38', 1450756958461300737, '2024-04-08 09:17:38', '0215000005070183', '/mobile/application/updateApp', 'mobile:application:updateApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829646695037149184, '删除应用', '删除应用', 595571579120001024, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 09:19:46', 1450756958461300737, '2024-04-08 09:19:46', '0215000005070184', '/mobile/application/deleteApp', 'mobile:application:deleteApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829646829514924032, '添加或修改分组', '添加或修改分组', 595571579120001024, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 09:20:18', 1450756958461300737, '2024-04-08 09:20:18', '0215000005070185', '/mobile/application/group/insertOrUpdateGroup', 'mobile:application:group:insertOrUpdateGroup', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829647470169694208, '保存三方集成配置信息', '保存三方集成配置信息', 595571579120001024, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 09:22:51', 1450756958461300737, '2024-04-08 09:22:51', '0215000005070186', '/mobile/external/saveConfig', 'mobile:external:saveConfig', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829648871130144768, '删除分组', '删除分组', 595571579120001024, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, '2024-04-08 09:28:25', 1450756958461300737, '2024-04-08 09:28:25', '0215000005070187', '/mobile/application/group/delete', 'mobile:application:group:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829649753250996224, '查询流程管理页面', '查询流程管理页面', 523177185453023232, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 09:31:55', 1450756958461300737, '2024-04-08 09:31:55', '0234000005070188', '/bpm/model/modelQuery', 'bpm:model:modelQuery', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829650049343692800, '展示流程定义列表', '展示流程定义列表', 523177185453023232, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 09:33:06', 1450756958461300737, '2024-04-08 09:33:06', '0234000005070189', '/bpm/processDefinition/queryProcessDefinitionsList', 'bpm:processDefinition:queryProcessDefinitionsList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829650386460876800, '设置主版本', '设置主版本', 523177185453023232, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 09:34:26', 1450756958461300737, '2024-04-08 09:34:26', '0234000005070190', '/bpm/processDefinition/setMain', 'bpm:processDefinition:setMain', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829650645429788672, '取消主版本', '取消主版本', 523177185453023232, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 09:35:28', 1450756958461300737, '2024-04-08 09:35:28', '0234000005070191', '/bpm/processDefinition/cancelMain', 'bpm:processDefinition:cancelMain', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829650996014882816, '删除流程模型', '删除流程模型', 523177185453023232, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 09:36:52', 1450756958461300737, '2024-04-08 09:36:52', '0234000005070192', '/bpm/model/deleteModel', 'bpm:model:deleteModel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829651441592573952, '删除流程定义', '删除流程定义', 523177185453023232, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 09:38:38', 1450756958461300737, '2024-04-08 09:38:38', '0234000005070193', '/bpm/model/deleteModelWithVersion', 'bpm:model:deleteModelWithVersion', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829652277517361152, '展示流程实例列表', '展示流程实例列表', 523177216750919680, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 09:41:57', 1450756958461300737, '2024-04-08 09:41:57', '0235000005070194', '/bpm/processInst/getProcessList', 'bpm:processInst:getProcessList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829652497630240768, '查询意见列表', '查询意见列表', 523177216750919680, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 09:42:50', 1450756958461300737, '2024-04-08 09:42:50', '0235000005070195', '/bpm/processInst/getProcessDetailList', 'bpm:processInst:getProcessDetailList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829653024451600384, '修改意见', '修改意见', 523177216750919680, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 09:44:55', 1450756958461300737, '2024-04-08 09:44:55', '0235000005070196', '/bpm/processInst/updateComments', 'bpm:processInst:updateComments', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829653344305029120, '重启流程到目标节点', '重启流程到目标节点', 523177216750919680, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 09:46:12', 1450756958461300737, '2024-04-08 09:46:12', '0235000005070197', '/bpm/processInst/reStartProcess', 'bpm:processInst:reStartProcess', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829653604154744832, '挂起流程实例', '挂起流程实例', 523177216750919680, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 09:47:13', 1450756958461300737, '2024-04-08 09:47:13', '0235000005070198', '/bpm/processInst/suspendProcessById', 'bpm:processInst:suspendProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829654027020279808, '终结流程实例', '终结流程实例', 523177216750919680, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 09:48:54', 1450756958461300737, '2024-04-08 09:48:54', '0235000005070199', '/bpm/processInst/endProcessByProcessInsId', 'bpm:processInst:endProcessByProcessInsId', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829654374266707968, '删除选中的流程实例', '删除选中的流程实例', 523177216750919680, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, '2024-04-08 09:50:17', 1450756958461300737, '2024-04-08 09:50:17', '0235000005070200', '/bpm/processInst/deleteProcessById', 'bpm:processInst:deleteProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829654700084436992, '激活流程实例', '激活流程实例', 523177216750919680, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, '2024-04-08 09:51:35', 1450756958461300737, '2024-04-08 09:51:35', '0235000005070201', '/bpm/processInst/activateProcessById', 'bpm:processInst:activateProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829655545685483520, '查询流程任务', '查询流程任务', 523177259834810368, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 09:54:56', 1450756958461300737, '2024-04-08 09:54:56', '0236000005070202', '/bpm/taskManager/getTaskManager', 'bpm:taskManager:getTaskManager', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829655991439335424, '直接审批', '直接审批', 523177259834810368, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 09:56:43', 1450756958461300737, '2024-04-08 09:56:43', '0236000005070203', '/bpm/taskManager/completeTask', 'bpm:taskManager:completeTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829656306565783552, '修改参与者', '修改参与者', 523177259834810368, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 09:57:58', 1450756958461300737, '2024-04-08 09:57:58', '0236000005070204', '/bpm/taskManager/entrustTaskByTaskId', 'bpm:taskManager:entrustTaskByTaskId', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829656910411341824, '自由跳转', '自由跳转', 523177259834810368, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 10:00:22', 1450756958461300737, '2024-04-08 10:00:22', '0236000005070206', '/bpm/taskManager/freeJump', 'bpm:taskManager:freeJump', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829656993349509120, '自由驳回', '自由驳回', 523177259834810368, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 10:00:42', 1450756958461300737, '2024-04-08 10:00:42', '0236000005070207', '/bpm/taskManager/rejectToLastTask', 'bpm:taskManager:rejectToLastTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829657336850423808, '催办', '催办', 523177259834810368, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 10:02:03', 1450756958461300737, '2024-04-08 10:02:03', '0236000005070208', '/bpm/taskManager/urgeTask', 'bpm:taskManager:urgeTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829657750480101376, '挂起', '挂起', 523177259834810368, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, '2024-04-08 10:03:42', 1450756958461300737, '2024-04-08 10:03:42', '0236000005070209', '/bpm/taskManager/suspendTaskById', 'bpm:taskManager:suspendTaskById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829658073546366976, '激活', '激活', 523177259834810368, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, '2024-04-08 10:04:59', 1450756958461300737, '2024-04-08 10:04:59', '0236000005070210', '/bpm/taskManager/activateTaskById', 'bpm:taskManager:activateTaskById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829661188479787008, '获取函数列表', '获取函数列表', 523177287164895232, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 10:17:22', 1450756958461300737, '2024-04-08 10:17:22', '0237000005070211', '/bpm/function/getList', 'bpm:function:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829662709275697152, '新增函数', '新增函数', 523177287164895232, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 10:23:24', 1450756958461300737, '2024-04-08 10:23:24', '0237000005070212', '/bpm/function/add', 'bpm:function:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829662870085312512, '修改函数', '修改函数', 523177287164895232, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 10:24:03', 1450756958461300737, '2024-04-08 10:24:03', '0237000005070213', '/bpm/function/update', 'bpm:function:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829663227851055104, '删除函数', '删除函数', 523177287164895232, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 10:25:28', 1450756958461300737, '2024-04-08 10:25:28', '0237000005070214', '/bpm/function/delete', 'bpm:function:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829663627639529472, '工作流配置列表查询', '工作流配置列表查询', 673548858558783488, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 10:27:03', 1450756958461300737, '2024-04-08 10:27:03', '0218000005070215', '/bpmConfigFront/getList', 'bpmConfigFront:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829663972935606272, '获取所属配置项', '获取所属配置项', 673548858558783488, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 10:28:26', 1450756958461300737, '2024-04-08 10:28:26', '0218000005070216', '/bpmConfigFront/configList', 'bpmConfigFront:configList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829664147154411520, '修改配置', '修改配置', 673548858558783488, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 10:29:07', 1450756958461300737, '2024-04-08 10:29:07', '0218000005070217', '/bpmConfigFront/update', 'bpmConfigFront:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829664689603747840, '表单查询', '表单查询', 706807109840543744, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 10:31:16', 1450756958461300737, '2024-04-08 10:31:16', '0215000005070218', '/bpm/formInfo/queryCustomFormByName', 'bpm:formInfo:queryCustomFormByName', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829664987747459072, '分类树查询', '分类树查询', 706807109840543744, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, '2024-04-08 10:32:28', 1450756958461300737, '2024-04-08 10:32:28', '0215000005070219', '/bpm/category/categoryTree', 'bpm:category:categoryTree', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829665433849438208, '新增分类', '新增分类', 706807109840543744, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, '2024-04-08 10:34:14', 1450756958461300737, '2024-04-08 10:34:14', '0215000005070220', '/bpm/category/add', 'bpm:category:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829666039490158592, '修改分类', '修改分类', 706807109840543744, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, '2024-04-08 10:36:38', 1450756958461300737, '2024-04-08 10:36:38', '0215000005070221', '/bpm/category/update', 'bpm:category:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829666121014845440, '删除分类', '删除分类', 706807109840543744, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, '2024-04-08 10:36:58', 1450756958461300737, '2024-04-08 10:36:58', '0215000005070222', '/bpm/category/delete', 'bpm:category:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829666955555512320, '新增表单', '新增表单', 706807109840543744, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, '2024-04-08 10:40:17', 1450756958461300737, '2024-04-08 10:40:17', '0215000005070223', '/bpm/formInfo/add', 'bpm:formInfo:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829667053261824000, '修改表单', '修改表单', 706807109840543744, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, '2024-04-08 10:40:40', 1450756958461300737, '2024-04-08 10:40:40', '0215000005070224', '/bpm/formInfo/update', 'bpm:formInfo:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829667187232088064, '删除表单', '删除表单', 706807109840543744, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, '2024-04-08 10:41:12', 1450756958461300737, '2024-04-08 10:41:12', '0215000005070225', '/bpm/formInfo/delete', 'bpm:formInfo:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829667364462403584, '表单详情', '表单详情', 706807109840543744, '', '', '0', 'res_btn', 10, '0', '0', '0', 1450756958461300737, '2024-04-08 10:41:54', 1450756958461300737, '2024-04-08 10:41:54', '0215000005070226', '/bpm/formInfo/detail', 'bpm:formInfo:detail', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_RIGHTS, `MAPPER`, `APPLICATION_ID`, `PARENT_RESOURCE_ID`)
VALUES(829669690359160832, '设置是否灰屏', '设置是否灰屏', 544468727815741440, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, '2024-04-08 10:51:09', 1450756958461300737, '2024-04-08 10:51:09', '0215000005070227', '/themeConfig/updateGreyScreenApplication', 'themeConfig:updateGreyScreenApplication', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO `SYS_RESOURCES`(`RESOURCE_ID`, `RESOURCE_NAME`, `RESOURCE_ALIAS`, `MODULE_ID`, `PATH`, `COMPONENT`, `IS_AUDIT`, `RES_TYPE_ID`, `SEQ`, `IS_REPEAT_AUTHENTICATE`, `STRATEGY`, `KEEP_ALIVE`, `CREATOR`, `CREATE_TIME`, `LAST_EDITOR`, `LAST_TIME`, `RESOURCE_CODE`, `URL_NAMES`, `PERMISSIONS`, `IS_SYS`, `SERVICE_NAME`, `USER_RIGHTS`, DEPT_