-- ----------------------------
-- Table structure for bpm_act_ru_mult_user
-- ----------------------------
CREATE TABLE "bpm_act_ru_mult_user" (
										"multi_user_id" NUMERIC(20)  NOT NULL,
										"multi_id" NUMERIC(20)  NULL DEFAULT NULL,
										"user_id" VARCHAR(255)  NULL DEFAULT NULL,
										"owner_id" VARCHAR(255)  NULL DEFAULT NULL,
										"seq_multi_count" NUMERIC(10)  NULL DEFAULT NULL,
										PRIMARY KEY ("multi_user_id")
);
CREATE INDEX ACT_IDX_MULTI_ID ON bpm_act_ru_mult_user ("multi_id");
COMMENT ON COLUMN "bpm_act_ru_mult_user"."multi_user_id" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_mult_user"."multi_id" IS '会签id';
COMMENT ON COLUMN "bpm_act_ru_mult_user"."user_id" IS '参与者id';
COMMENT ON COLUMN "bpm_act_ru_mult_user"."owner_id" IS '任务所属人id';
COMMENT ON COLUMN "bpm_act_ru_mult_user"."seq_multi_count" IS '串行会签执行次序';
COMMENT ON TABLE "bpm_act_ru_mult_user" IS '会签多实例人员信息表';

-- ----------------------------
-- Table structure for bpm_act_evt_log
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_evt_log" CASCADE;
CREATE TABLE "bpm_act_evt_log" (
  "log_nr_" NUMERIC(20) NOT NULL,
  "type_" VARCHAR(192) DEFAULT NULL ,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "time_stamp_" TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "user_id_" VARCHAR(765) DEFAULT NULL ,
  "data_" bytea,
  "lock_owner_" VARCHAR(765) DEFAULT NULL ,
  "lock_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "is_processed_" NUMERIC(4) DEFAULT '0',
  PRIMARY KEY ("log_nr_")
);
COMMENT ON COLUMN "bpm_act_evt_log"."log_nr_" IS '主键';
COMMENT ON COLUMN "bpm_act_evt_log"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_evt_log"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_evt_log"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_evt_log"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_evt_log"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_evt_log"."time_stamp_" IS '时间';
COMMENT ON COLUMN "bpm_act_evt_log"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_evt_log"."data_" IS '数据';
COMMENT ON COLUMN "bpm_act_evt_log"."lock_owner_" IS '锁定人';
COMMENT ON COLUMN "bpm_act_evt_log"."lock_time_" IS '锁定时间';
COMMENT ON COLUMN "bpm_act_evt_log"."is_processed_" IS '是否处理';
COMMENT ON TABLE "bpm_act_evt_log" IS '事件日志表';

-- ----------------------------
-- Records of bpm_act_evt_log
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ge_bytearray
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ge_bytearray" CASCADE;
CREATE TABLE "bpm_act_ge_bytearray" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "deployment_id_" NUMERIC(20) DEFAULT NULL,
  "bytes_" bytea,
  "generated_" NUMERIC(4) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_FK_BYTEARR_DEPL ON bpm_act_ge_bytearray ("deployment_id_");
COMMENT ON COLUMN "bpm_act_ge_bytearray"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ge_bytearray"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ge_bytearray"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_ge_bytearray"."deployment_id_" IS '部署id';
COMMENT ON COLUMN "bpm_act_ge_bytearray"."bytes_" IS '数据';
COMMENT ON COLUMN "bpm_act_ge_bytearray"."generated_" IS '是否是引擎生成';
COMMENT ON TABLE "bpm_act_ge_bytearray" IS '二进制数据表';

-- ----------------------------
-- Records of bpm_act_ge_bytearray
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ge_property
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ge_property" CASCADE;
CREATE TABLE "bpm_act_ge_property" (
  "name_" VARCHAR(192)  NOT NULL,
  "value_" VARCHAR(300) DEFAULT NULL ,
  "rev_" NUMERIC(11) DEFAULT NULL,
  PRIMARY KEY ("name_")
);
COMMENT ON COLUMN "bpm_act_ge_property"."name_" IS '主键';
COMMENT ON COLUMN "bpm_act_ge_property"."value_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ge_property"."rev_" IS '值';
COMMENT ON TABLE "bpm_act_ge_property" IS '属性数据表';

-- ----------------------------
-- Records of bpm_act_ge_property
-- ----------------------------
INSERT INTO "bpm_act_ge_property"("name_", "value_", "rev_") VALUES ('next.dbid', '447501', 180);
INSERT INTO "bpm_act_ge_property"("name_", "value_", "rev_") VALUES ('schema.history', 'create(5.22.0.0)', 1);
INSERT INTO "bpm_act_ge_property"("name_", "value_", "rev_") VALUES ('schema.version', '5.22.0.0', 1);

-- ----------------------------
-- Table structure for bpm_act_hi_actinst
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_actinst" CASCADE;
CREATE TABLE "bpm_act_hi_actinst" (
  "id_" NUMERIC(20) NOT NULL,
  "proc_def_id_" VARCHAR(192)  NOT NULL,
  "proc_inst_id_" NUMERIC(20) NOT NULL,
  "execution_id_" NUMERIC(20) NOT NULL,
  "act_id_" VARCHAR(765)  NOT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "call_proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "act_name_" VARCHAR(765) DEFAULT NULL ,
  "act_type_" VARCHAR(765)  NOT NULL,
  "assignee_" VARCHAR(765) DEFAULT NULL ,
  "start_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "end_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "duration_" NUMERIC(20) DEFAULT NULL,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "sub_process_key" VARCHAR(765) DEFAULT NULL,
  "cycle_count" NUMERIC(11) DEFAULT NULL,
  "process_cycle_count" NUMERIC(10) DEFAULT NULL,
  "due_date" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "sub_process_name" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_ACT_INST_START ON bpm_act_hi_actinst ("start_time_");
CREATE INDEX ACT_IDX_HI_ACT_INST_END ON bpm_act_hi_actinst ("end_time_");
CREATE INDEX ACT_IDX_HI_ACT_INST_PROCINST ON bpm_act_hi_actinst ("proc_inst_id_","act_id_");
CREATE INDEX ACT_IDX_HI_ACT_INST_EXEC ON bpm_act_hi_actinst ("execution_id_","act_id_");
COMMENT ON COLUMN "bpm_act_hi_actinst"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_actinst"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."act_id_" IS '节点实例id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."call_proc_inst_id_" IS '子流程实例id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."act_name_" IS '节点名';
COMMENT ON COLUMN "bpm_act_hi_actinst"."act_type_" IS '节点类型';
COMMENT ON COLUMN "bpm_act_hi_actinst"."assignee_" IS '参与者';
COMMENT ON COLUMN "bpm_act_hi_actinst"."start_time_" IS '开始时间';
COMMENT ON COLUMN "bpm_act_hi_actinst"."end_time_" IS '结束时间';
COMMENT ON COLUMN "bpm_act_hi_actinst"."duration_" IS '持续时间';
COMMENT ON COLUMN "bpm_act_hi_actinst"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_hi_actinst"."sub_process_key" IS '内部子流程标识';
COMMENT ON COLUMN "bpm_act_hi_actinst"."cycle_count" IS '内部子流程节点执行次数';
COMMENT ON COLUMN "bpm_act_hi_actinst"."process_cycle_count" IS '外部子流程执行次数';
COMMENT ON COLUMN "bpm_act_hi_actinst"."due_date" IS '到期时间';
COMMENT ON COLUMN "bpm_act_hi_actinst"."sub_process_name" IS '内部子流程实例名';
COMMENT ON TABLE "bpm_act_hi_actinst" IS '历史节点表';

-- ----------------------------
-- Records of bpm_act_hi_actinst
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_attachment
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_attachment" CASCADE;
CREATE TABLE "bpm_act_hi_attachment" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "user_id_" VARCHAR(765) DEFAULT NULL ,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "description_" VARCHAR(4000) DEFAULT NULL ,
  "type_" VARCHAR(765) DEFAULT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "url_" VARCHAR(4000) DEFAULT NULL ,
  "content_id_" VARCHAR(192) DEFAULT NULL ,
  "time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  PRIMARY KEY ("id_")
);
COMMENT ON COLUMN "bpm_act_hi_attachment"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_attachment"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_hi_attachment"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_hi_attachment"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_hi_attachment"."description_" IS '描述';
COMMENT ON COLUMN "bpm_act_hi_attachment"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_hi_attachment"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_attachment"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_attachment"."url_" IS 'url';
COMMENT ON COLUMN "bpm_act_hi_attachment"."content_id_" IS '内容id';
COMMENT ON COLUMN "bpm_act_hi_attachment"."time_" IS '时间';
COMMENT ON TABLE "bpm_act_hi_attachment" IS '历史附件表';

-- ----------------------------
-- Records of bpm_act_hi_attachment
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_comment
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_comment" CASCADE;
CREATE TABLE "bpm_act_hi_comment" (
  "id_" NUMERIC(20) NOT NULL,
  "type_" VARCHAR(765) DEFAULT NULL ,
  "time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "user_id_" VARCHAR(765) DEFAULT NULL ,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "action_" VARCHAR(765) DEFAULT NULL ,
  "message_" VARCHAR(4000) DEFAULT NULL ,
  "full_msg_" bytea,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_COMMENT_TASK_ID ON bpm_act_hi_comment ("proc_inst_id_");
CREATE INDEX ACT_COMMENT_TASK_ID ON bpm_act_hi_comment ("task_id_" );
COMMENT ON COLUMN "bpm_act_hi_comment"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_comment"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_hi_comment"."time_" IS '时间';
COMMENT ON COLUMN "bpm_act_hi_comment"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_hi_comment"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_comment"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_comment"."action_" IS '行为类型';
COMMENT ON COLUMN "bpm_act_hi_comment"."message_" IS '基本内容';
COMMENT ON COLUMN "bpm_act_hi_comment"."full_msg_" IS '全部内容';
COMMENT ON TABLE "bpm_act_hi_comment" IS '历史意见表';

-- ----------------------------
-- Records of bpm_act_hi_comment
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_detail
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_detail" CASCADE;
CREATE TABLE "bpm_act_hi_detail" (
  "id_" NUMERIC(20) NOT NULL,
  "type_" VARCHAR(765)  NOT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "act_inst_id_" VARCHAR(192) DEFAULT NULL ,
  "name_" VARCHAR(765)  NOT NULL,
  "var_type_" VARCHAR(765) DEFAULT NULL ,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "bytearray_id_" NUMERIC(20) DEFAULT NULL,
  "double_" float4 DEFAULT NULL,
  "long_" NUMERIC(20) DEFAULT NULL,
  "text_" VARCHAR(4000) DEFAULT NULL ,
  "text2_" VARCHAR(4000) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_DETAIL_PROC_INST ON bpm_act_hi_detail ("proc_inst_id_");
CREATE INDEX ACT_IDX_HI_DETAIL_ACT_INST ON bpm_act_hi_detail ("act_inst_id_");
CREATE INDEX ACT_IDX_HI_DETAIL_TIME ON bpm_act_hi_detail ("time_");
CREATE INDEX ACT_IDX_HI_DETAIL_NAME ON bpm_act_hi_detail ("name_");
CREATE INDEX ACT_IDX_HI_DETAIL_TASK_ID ON bpm_act_hi_detail ("task_id_");
COMMENT ON COLUMN "bpm_act_hi_detail"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_detail"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_hi_detail"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_detail"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_hi_detail"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_detail"."act_inst_id_" IS '节点实例id';
COMMENT ON COLUMN "bpm_act_hi_detail"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_hi_detail"."var_type_" IS '类型';
COMMENT ON COLUMN "bpm_act_hi_detail"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_hi_detail"."time_" IS '时间';
COMMENT ON COLUMN "bpm_act_hi_detail"."bytearray_id_" IS '二进制数据id';
COMMENT ON COLUMN "bpm_act_hi_detail"."double_" IS 'double类型数据';
COMMENT ON COLUMN "bpm_act_hi_detail"."long_" IS 'long类型数据';
COMMENT ON COLUMN "bpm_act_hi_detail"."text_" IS 'string类型数据';
COMMENT ON COLUMN "bpm_act_hi_detail"."text2_" IS 'jpa对象id';
COMMENT ON TABLE "bpm_act_hi_detail" IS '历史详情表';

-- ----------------------------
-- Records of bpm_act_hi_detail
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_identitylink
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_identitylink" CASCADE;
CREATE TABLE "bpm_act_hi_identitylink" (
  "id_" NUMERIC(20) NOT NULL,
  "group_id_" VARCHAR(765) DEFAULT NULL ,
  "type_" VARCHAR(765) DEFAULT NULL ,
  "user_id_" VARCHAR(765) DEFAULT NULL ,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_IDENT_LNK_USER ON bpm_act_hi_identitylink ("user_id_");
CREATE INDEX ACT_IDX_HI_IDENT_LNK_TASK ON bpm_act_hi_identitylink ("task_id_");
CREATE INDEX ACT_IDX_HI_IDENT_LNK_PROCINST ON bpm_act_hi_identitylink ("proc_inst_id_");
COMMENT ON COLUMN "bpm_act_hi_identitylink"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_identitylink"."group_id_" IS '用户组id';
COMMENT ON COLUMN "bpm_act_hi_identitylink"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_hi_identitylink"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_hi_identitylink"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_identitylink"."proc_inst_id_" IS '流程实例id';
COMMENT ON TABLE "bpm_act_hi_identitylink" IS '历史流程人员表';

-- ----------------------------
-- Records of bpm_act_hi_identitylink
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_procinst
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_procinst" CASCADE;
CREATE TABLE "bpm_act_hi_procinst" (
  "id_" NUMERIC(20) NOT NULL,
  "proc_inst_id_" NUMERIC(20) NOT NULL,
  "business_key_" VARCHAR(765) DEFAULT NULL ,
  "proc_def_id_" VARCHAR(192)  NOT NULL,
  "start_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "end_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "duration_" NUMERIC(20) DEFAULT NULL,
  "start_user_id_" VARCHAR(765) DEFAULT NULL ,
  "start_act_id_" VARCHAR(765) DEFAULT NULL ,
  "end_act_id_" VARCHAR(765) DEFAULT NULL ,
  "super_process_instance_id_" NUMERIC(20) DEFAULT NULL,
  "delete_reason_" VARCHAR(4000) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "name_" VARCHAR(765) DEFAULT NULL,
  "process_title" VARCHAR(1024) DEFAULT NULL,
  "data_detail" TEXT  DEFAULT NULL,
  "due_date" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "first_user_task_activity_id" VARCHAR(765)  DEFAULT NULL,
  "complete_from" VARCHAR(765) DEFAULT NULL,
  "complete_type" VARCHAR(765) DEFAULT NULL,
  "jump_info" VARCHAR(765) DEFAULT NULL,
  "main_act_id" VARCHAR(765) DEFAULT NULL,
  "process_cycle_count" NUMERIC(11) DEFAULT NULL,
  "security_level" NUMERIC(11) DEFAULT NULL,
  "is_emulation" CHAR(1) DEFAULT NULL,
  "process_tag" VARCHAR(108) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE UNIQUE INDEX uk_proc_inst_id_ ON bpm_act_hi_procinst(proc_inst_id_);
CREATE INDEX ACT_IDX_HI_PRO_INST_END ON bpm_act_hi_procinst ("end_time_");
CREATE INDEX ACT_IDX_HI_PRO_I_BUSKEY ON bpm_act_hi_procinst ("business_key_");
CREATE INDEX ACT_IDX_HI_PROC_SUPER_PROCINST ON bpm_act_hi_procinst ("super_process_instance_id_");
COMMENT ON COLUMN "bpm_act_hi_procinst"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_procinst"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."business_key_" IS '业务主键';
COMMENT ON COLUMN "bpm_act_hi_procinst"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."start_time_" IS '开始时间';
COMMENT ON COLUMN "bpm_act_hi_procinst"."end_time_" IS '结束时间';
COMMENT ON COLUMN "bpm_act_hi_procinst"."duration_" IS '持续时间';
COMMENT ON COLUMN "bpm_act_hi_procinst"."start_user_id_" IS '流程发起人';
COMMENT ON COLUMN "bpm_act_hi_procinst"."start_act_id_" IS '起始节点id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."end_act_id_" IS '结束节点id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."super_process_instance_id_" IS '上级流程实例id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."delete_reason_" IS '结束原因';
COMMENT ON COLUMN "bpm_act_hi_procinst"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_hi_procinst"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_hi_procinst"."process_title" IS '流程级业务描述';
COMMENT ON COLUMN "bpm_act_hi_procinst"."data_detail" IS '流程级业务详细信息';
COMMENT ON COLUMN "bpm_act_hi_procinst"."due_date" IS '到期时间';
COMMENT ON COLUMN "bpm_act_hi_procinst"."first_user_task_activity_id" IS '第一个人工活动节点';
COMMENT ON COLUMN "bpm_act_hi_procinst"."complete_from" IS '主流程前一节点';
COMMENT ON COLUMN "bpm_act_hi_procinst"."complete_type" IS '主流程来源';
COMMENT ON COLUMN "bpm_act_hi_procinst"."jump_info" IS '主流程跳转信息';
COMMENT ON COLUMN "bpm_act_hi_procinst"."main_act_id" IS '主流程节点';
COMMENT ON COLUMN "bpm_act_hi_procinst"."process_cycle_count" IS '流程循环次数';
COMMENT ON COLUMN "bpm_act_hi_procinst"."security_level" IS '密级';
COMMENT ON COLUMN "bpm_act_hi_procinst"."is_emulation" IS '是否是测试流程0否，1是';
COMMENT ON COLUMN "bpm_act_hi_procinst"."process_tag" IS '流程标签';
COMMENT ON TABLE "bpm_act_hi_procinst" IS '历史流程实例表';

-- ----------------------------
-- Records of bpm_act_hi_procinst
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_taskinst
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_taskinst" CASCADE;
CREATE TABLE "bpm_act_hi_taskinst" (
  "id_" NUMERIC(20) NOT NULL,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "task_def_key_" VARCHAR(765) DEFAULT NULL ,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "parent_task_id_" NUMERIC(20) DEFAULT NULL,
  "description_" VARCHAR(765) DEFAULT NULL ,
  "owner_" VARCHAR(765) DEFAULT NULL ,
  "assignee_" VARCHAR(765) DEFAULT NULL ,
  "receiver_" VARCHAR(765) DEFAULT NULL ,
  "start_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "claim_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "end_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "duration_" NUMERIC(20) DEFAULT NULL,
  "delete_reason_" VARCHAR(765) DEFAULT NULL ,
  "priority_" NUMERIC(11) DEFAULT NULL,
  "due_date_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "form_key_" VARCHAR(2000) DEFAULT NULL ,
  "category_" VARCHAR(765) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "task_state" CHAR(1) NULL DEFAULT NULL,
  "sub_process_key" VARCHAR(765) NULL DEFAULT NULL,
  "task_type" VARCHAR(765) DEFAULT NULL,
  "assist_initiator" VARCHAR(765) DEFAULT NULL,
  "cycle_count" NUMERIC(11) DEFAULT NULL,
  "process_cycle_count" NUMERIC(10) DEFAULT NULL,
  "create_history_task_id"  NUMERIC(20) DEFAULT NULL,
  "form_id" VARCHAR(192) DEFAULT NULL,
  "send_user" VARCHAR(108) DEFAULT NULL,
  "multi_id" NUMERIC(20) DEFAULT NULL,
  "appoint_assignee" VARCHAR(1024) DEFAULT NULL,
  "todo_configuration" VARCHAR(1024) DEFAULT NULL,
  "complete_type" VARCHAR(96) DEFAULT NULL,
  "task_source_flag" VARCHAR(96) DEFAULT NULL,
  "jump_info" VARCHAR(765) DEFAULT NULL,
  "all_prev_node" VARCHAR(765) DEFAULT NULL,
  "process_key" VARCHAR(765) DEFAULT NULL,
  "process_name" VARCHAR(765) DEFAULT NULL,
  "business_key" VARCHAR(765) DEFAULT NULL,
  "seq_multi_count" NUMERIC(10) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_TASK_INST_PROCINST ON bpm_act_hi_taskinst ("proc_inst_id_");
CREATE INDEX ACT_IDX_HI_TASK_INST_END_TIME ON bpm_act_hi_taskinst ("end_time_");
CREATE INDEX ACT_IDX_HI_TASK_INST_PROCDEF ON bpm_act_hi_taskinst ("proc_def_id_");
CREATE INDEX ACT_PARENT_TASK_ID ON bpm_act_hi_taskinst ("parent_task_id_" );
CREATE INDEX IDX_HI_TASK_ASSIGNEE_END_TIME ON bpm_act_hi_taskinst ("assignee_" , "end_time_" );
COMMENT ON COLUMN "bpm_act_hi_taskinst"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."task_def_key_" IS '节点id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."parent_task_id_" IS '父节点实例id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."description_" IS '描述';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."owner_" IS '实际签收人';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."assignee_" IS '参与者';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."receiver_" IS '接收人';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."start_time_" IS '开始时间';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."claim_time_" IS '签收时间';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."end_time_" IS '结束时间';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."duration_" IS '持续时间';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."delete_reason_" IS '结束原因';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."priority_" IS '优先级';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."due_date_" IS '过期时间';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."form_key_" IS '表单地址';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."category_" IS '分类';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."task_state" IS '委托类型  空 无委托关系  1 事前委托';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."sub_process_key" IS '内部子流程标识';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."task_type" IS '任务类型  空 普通已办  2 协办已办  4 发起协办的已办';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."assist_initiator" IS '任务发起人';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."cycle_count" IS '内部子流程节点执行次数';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."process_cycle_count" IS '外部子流程执行次数';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."create_history_task_id" IS '协办来源id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."form_id" IS '表单ID';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."send_user" IS '发送人';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."multi_id" IS '会签id';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."appoint_assignee" IS '指定人';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."todo_configuration" IS '待办配置';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."complete_type" IS '来源方式';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."task_source_flag" IS '办理方式';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."jump_info" IS '跳转信息';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."all_prev_node" IS '前一节点';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."process_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."process_name" IS '流程名';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."business_key" IS '业务主键';
COMMENT ON COLUMN "bpm_act_hi_taskinst"."seq_multi_count" IS '串行会签执行次序';
COMMENT ON TABLE "bpm_act_hi_taskinst" IS '历史任务实例表';

-- ----------------------------
-- Records of bpm_act_hi_taskinst
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_varinst
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_varinst" CASCADE;
CREATE TABLE "bpm_act_hi_varinst" (
  "id_" NUMERIC(20) NOT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "name_" VARCHAR(765) NOT NULL,
  "var_type_" VARCHAR(300) DEFAULT NULL ,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "bytearray_id_" NUMERIC(20) DEFAULT NULL,
  "double_" float4 DEFAULT NULL,
  "long_" NUMERIC(20) DEFAULT NULL,
  "text_" VARCHAR(4000) DEFAULT NULL ,
  "text2_" VARCHAR(4000) DEFAULT NULL ,
  "create_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "last_updated_time_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_HI_PROCVAR_PROC_INST ON bpm_act_hi_varinst ("proc_inst_id_");
CREATE INDEX ACT_IDX_HI_PROCVAR_NAME_TYPE ON bpm_act_hi_varinst ("name_","var_type_");
CREATE INDEX ACT_IDX_HI_PROCVAR_TASK_ID ON bpm_act_hi_varinst ("task_id_");
CREATE INDEX ACT_IDX_HI_VAR_EXECUTION_ID ON bpm_act_hi_varinst ("execution_id_");
COMMENT ON COLUMN "bpm_act_hi_varinst"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_varinst"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_hi_varinst"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_hi_varinst"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_hi_varinst"."name_" IS '变量名  sendUser 发送人  todoConfiguration 业务描述  complete_type 上一节点办理方式  taskSourceFlag 办理方式  all_prev_node 所有上一节点  bpm_submit_source 提交来源  complete_from 上一节点';
COMMENT ON COLUMN "bpm_act_hi_varinst"."var_type_" IS '变量类型';
COMMENT ON COLUMN "bpm_act_hi_varinst"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_hi_varinst"."bytearray_id_" IS '二进制数据id';
COMMENT ON COLUMN "bpm_act_hi_varinst"."double_" IS 'double类型数据';
COMMENT ON COLUMN "bpm_act_hi_varinst"."long_" IS 'long类型数据';
COMMENT ON COLUMN "bpm_act_hi_varinst"."text_" IS 'string类型数据';
COMMENT ON COLUMN "bpm_act_hi_varinst"."text2_" IS 'jpa对象id';
COMMENT ON COLUMN "bpm_act_hi_varinst"."create_time_" IS '创建时间';
COMMENT ON COLUMN "bpm_act_hi_varinst"."last_updated_time_" IS '最后更新时间';
COMMENT ON TABLE "bpm_act_hi_varinst" IS '历史变量表';

-- ----------------------------
-- Records of bpm_act_hi_varinst
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_id_group
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_id_group" CASCADE;
CREATE TABLE "bpm_act_id_group" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "type_" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
COMMENT ON COLUMN "bpm_act_id_group"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_id_group"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_id_group"."name_" IS '名';
COMMENT ON COLUMN "bpm_act_id_group"."type_" IS '类型';
COMMENT ON TABLE "bpm_act_id_group" IS '用户组信息表';

-- ----------------------------
-- Records of bpm_act_id_group
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_id_info
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_id_info" CASCADE;
CREATE TABLE "bpm_act_id_info" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "user_id_" VARCHAR(192) DEFAULT NULL ,
  "type_" VARCHAR(192) DEFAULT NULL ,
  "key_" VARCHAR(765) DEFAULT NULL ,
  "value_" VARCHAR(765) DEFAULT NULL ,
  "password_" bytea,
  "parent_id_" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
COMMENT ON COLUMN "bpm_act_id_info"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_id_info"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_id_info"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_id_info"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_id_info"."key_" IS '标识';
COMMENT ON COLUMN "bpm_act_id_info"."value_" IS '值';
COMMENT ON COLUMN "bpm_act_id_info"."password_" IS '密码';
COMMENT ON COLUMN "bpm_act_id_info"."parent_id_" IS '租户id';
COMMENT ON TABLE "bpm_act_id_info" IS '用户拓展信息表';

-- ----------------------------
-- Records of bpm_act_id_info
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_id_membership
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_id_membership" CASCADE;
CREATE TABLE "bpm_act_id_membership" (
  "user_id_" VARCHAR(192)  NOT NULL,
  "group_id_" VARCHAR(192)  NOT NULL,
  PRIMARY KEY ("user_id_")
);
CREATE INDEX ACT_FK_MEMB_GROUP ON bpm_act_id_membership ( "group_id_");
COMMENT ON COLUMN "bpm_act_id_membership"."user_id_" IS '用户id';
COMMENT ON COLUMN "bpm_act_id_membership"."group_id_" IS '用户组id';
COMMENT ON TABLE "bpm_act_id_membership" IS '用户与分组对应信息表';

-- ----------------------------
-- Records of bpm_act_id_membership
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_id_user
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_id_user" CASCADE;
CREATE TABLE "bpm_act_id_user" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "first_" VARCHAR(765) DEFAULT NULL ,
  "last_" VARCHAR(765) DEFAULT NULL ,
  "email_" VARCHAR(765) DEFAULT NULL ,
  "pwd_" VARCHAR(765) DEFAULT NULL ,
  "picture_id_" VARCHAR(192) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
COMMENT ON COLUMN "bpm_act_id_user"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_id_user"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_id_user"."first_" IS '名';
COMMENT ON COLUMN "bpm_act_id_user"."last_" IS '姓';
COMMENT ON COLUMN "bpm_act_id_user"."email_" IS '邮箱';
COMMENT ON COLUMN "bpm_act_id_user"."pwd_" IS '密码';
COMMENT ON COLUMN "bpm_act_id_user"."picture_id_" IS '图片id';
COMMENT ON TABLE "bpm_act_id_user" IS '用户信息表';

-- ----------------------------
-- Records of bpm_act_id_user
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_procdef_info
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_procdef_info" CASCADE;
CREATE TABLE "bpm_act_procdef_info" (
  "id_" NUMERIC(20) NOT NULL,
  "proc_def_id_" VARCHAR(192)  NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "info_json_id_" VARCHAR(192) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_INFO_PROCDEF ON bpm_act_procdef_info ("proc_def_id_");
CREATE INDEX ACT_FK_INFO_JSON_BA ON bpm_act_procdef_info ("info_json_id_");
COMMENT ON COLUMN "bpm_act_procdef_info"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_procdef_info"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_procdef_info"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_procdef_info"."info_json_id_" IS '二进制数据id';
COMMENT ON TABLE "bpm_act_procdef_info" IS '流程定义信息表';

-- ----------------------------
-- Records of bpm_act_procdef_info
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_re_deployment
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_re_deployment" CASCADE;
CREATE TABLE "bpm_act_re_deployment" (
  "id_" NUMERIC(20) NOT NULL,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "category_" VARCHAR(765) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '' ,
  "deploy_time_" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  PRIMARY KEY ("id_")
);
COMMENT ON COLUMN "bpm_act_re_deployment"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_re_deployment"."name_" IS '名称';
COMMENT ON COLUMN "bpm_act_re_deployment"."category_" IS '分类';
COMMENT ON COLUMN "bpm_act_re_deployment"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_re_deployment"."deploy_time_" IS '部署时间';
COMMENT ON TABLE "bpm_act_re_deployment" IS '部署信息表';

-- ----------------------------
-- Records of bpm_act_re_deployment
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_re_model
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_re_model" CASCADE;
CREATE TABLE "bpm_act_re_model" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "key_" VARCHAR(765) DEFAULT NULL ,
  "category_" VARCHAR(765) DEFAULT NULL ,
  "create_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_update_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "version_" NUMERIC(11) DEFAULT NULL,
  "meta_info_" VARCHAR(4000) DEFAULT NULL ,
  "deployment_id_" NUMERIC(20) DEFAULT NULL,
  "editor_source_value_id_" VARCHAR(192) DEFAULT NULL ,
  "editor_source_extra_value_id_" VARCHAR(192) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "app_id" NUMERIC(20)  DEFAULT NULL ,
  "app_name" VARCHAR(765) DEFAULT NULL ,
  "workflow_style" VARCHAR(48) DEFAULT NULL,
  "process_tag" VARCHAR(108) DEFAULT NULL,
  "model_status" CHAR(1) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_FK_MODEL_SOURCE ON bpm_act_re_model ("editor_source_value_id_");
CREATE INDEX ACT_FK_MODEL_SOURCE_EXTRA ON bpm_act_re_model ("editor_source_extra_value_id_");
CREATE INDEX ACT_FK_MODEL_DEPLOYMENT ON bpm_act_re_model ("deployment_id_");
COMMENT ON COLUMN "bpm_act_re_model"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_re_model"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_re_model"."name_" IS '流程名';
COMMENT ON COLUMN "bpm_act_re_model"."key_" IS '流程表示';
COMMENT ON COLUMN "bpm_act_re_model"."category_" IS '分类';
COMMENT ON COLUMN "bpm_act_re_model"."create_time_" IS '创建时间';
COMMENT ON COLUMN "bpm_act_re_model"."last_update_time_" IS '更新时间';
COMMENT ON COLUMN "bpm_act_re_model"."version_" IS '版本号';
COMMENT ON COLUMN "bpm_act_re_model"."meta_info_" IS '详细信息';
COMMENT ON COLUMN "bpm_act_re_model"."deployment_id_" IS '部署id';
COMMENT ON COLUMN "bpm_act_re_model"."editor_source_value_id_" IS '编辑器源值id';
COMMENT ON COLUMN "bpm_act_re_model"."editor_source_extra_value_id_" IS '编辑器源额外值id';
COMMENT ON COLUMN "bpm_act_re_model"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_re_model"."app_id" IS '应用ID';
COMMENT ON COLUMN "bpm_act_re_model"."app_name" IS '应用名称';
COMMENT ON COLUMN "bpm_act_re_model"."workflow_style" IS '流程风格';
COMMENT ON COLUMN "bpm_act_re_model"."process_tag" IS '流程标签';
COMMENT ON COLUMN "bpm_act_re_model"."model_status" IS '模型状态';
COMMENT ON TABLE "bpm_act_re_model" IS '流程设计模型部署表';

-- ----------------------------
-- Records of bpm_act_re_model
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_re_procdef
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_re_procdef" CASCADE;
CREATE TABLE "bpm_act_re_procdef" (
  "id_" VARCHAR(765) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "category_" VARCHAR(765) DEFAULT NULL ,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "key_" VARCHAR(765)  NOT NULL,
  "version_" NUMERIC(11) NOT NULL,
  "deployment_id_" NUMERIC(20) DEFAULT NULL,
  "resource_name_" VARCHAR(4000) DEFAULT NULL ,
  "dgrm_resource_name_" VARCHAR(4000) DEFAULT NULL ,
  "description_" VARCHAR(4000) DEFAULT NULL ,
  "has_start_form_key_" NUMERIC(4)DEFAULT NULL,
  "has_graphical_notation_" NUMERIC(4) DEFAULT NULL,
  "suspension_state_" NUMERIC(11) DEFAULT NULL,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "main_process" VARCHAR(12) DEFAULT '0',
  "real_version" NUMERIC(11) DEFAULT NULL,
  "workflow_style" VARCHAR(48) DEFAULT NULL,
  "process_tag" VARCHAR(108) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE UNIQUE INDEX ACT_UNIQ_PROCDEF ON bpm_act_re_procdef ("key_","version_","tenant_id_");
COMMENT ON COLUMN "bpm_act_re_procdef"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_re_procdef"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_re_procdef"."category_" IS '分类';
COMMENT ON COLUMN "bpm_act_re_procdef"."name_" IS '名称';
COMMENT ON COLUMN "bpm_act_re_procdef"."key_" IS '流程标识';
COMMENT ON COLUMN "bpm_act_re_procdef"."version_" IS '版本';
COMMENT ON COLUMN "bpm_act_re_procdef"."deployment_id_" IS '部署id';
COMMENT ON COLUMN "bpm_act_re_procdef"."resource_name_" IS '部署名';
COMMENT ON COLUMN "bpm_act_re_procdef"."dgrm_resource_name_" IS '图片名';
COMMENT ON COLUMN "bpm_act_re_procdef"."description_" IS '描述';
COMMENT ON COLUMN "bpm_act_re_procdef"."has_start_form_key_" IS '是否存在开始节点formKey';
COMMENT ON COLUMN "bpm_act_re_procdef"."has_graphical_notation_" IS '是否具有图形表示法';
COMMENT ON COLUMN "bpm_act_re_procdef"."suspension_state_" IS '挂起状态  1 激活  2 挂起';
COMMENT ON COLUMN "bpm_act_re_procdef"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_re_procdef"."main_process" IS '1主版本 0 不是主版本 2 临时版本';
COMMENT ON COLUMN "bpm_act_re_procdef"."real_version" IS '临时版本流程真实版本号';
COMMENT ON COLUMN "bpm_act_re_procdef"."workflow_style" IS '流程风格';
COMMENT ON COLUMN "bpm_act_re_procdef"."process_tag" IS '流程标签';
COMMENT ON TABLE "bpm_act_re_procdef" IS '流程定义数据表';

-- ----------------------------
-- Records of bpm_act_re_procdef
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ru_event_subscr
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_event_subscr" CASCADE;
CREATE TABLE "bpm_act_ru_event_subscr" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "event_type_" VARCHAR(765) NOT NULL,
  "event_name_" VARCHAR(765) DEFAULT NULL ,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "activity_id_" VARCHAR(192) DEFAULT NULL ,
  "configuration_" VARCHAR(765) DEFAULT NULL ,
  "created_" TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_EVENT_SUBSCR_CONFIG_ ON bpm_act_ru_event_subscr ("configuration_");
CREATE INDEX ACT_FK_EVENT_EXEC ON bpm_act_ru_event_subscr ("execution_id_");
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."event_type_" IS '类型';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."event_name_" IS '名称';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."activity_id_" IS '活动实例id';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."configuration_" IS '配置';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."created_" IS '是否创建';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_ru_event_subscr"."tenant_id_" IS '租户id';
COMMENT ON TABLE "bpm_act_ru_event_subscr" IS '监听表';

-- ----------------------------
-- Records of bpm_act_ru_event_subscr
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ru_execution
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_execution" CASCADE;
CREATE TABLE "bpm_act_ru_execution" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "business_key_" VARCHAR(765) DEFAULT NULL ,
  "parent_id_" NUMERIC(20) DEFAULT NULL ,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "super_exec_" NUMERIC(20) DEFAULT NULL ,
  "act_id_" VARCHAR(765) DEFAULT NULL ,
  "is_active_" NUMERIC(4) DEFAULT NULL,
  "is_concurrent_" NUMERIC(4) DEFAULT NULL,
  "is_scope_" NUMERIC(4) DEFAULT NULL,
  "is_event_scope_" NUMERIC(4) DEFAULT NULL,
  "suspension_state_" NUMERIC(11) DEFAULT NULL,
  "cached_ent_state_" NUMERIC(11) DEFAULT NULL,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  "name_" VARCHAR(765) DEFAULT NULL ,
  "lock_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "all_prev_node" VARCHAR(765) DEFAULT NULL,
  "process_cycle_count" NUMERIC(11) DEFAULT NULL,
  "sub_process_key" VARCHAR(765) DEFAULT NULL,
  "cycle_count" NUMERIC(11) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_EXEC_BUSKEY ON bpm_act_ru_execution ("business_key_");
CREATE INDEX ACT_FK_EXE_PROCINST ON bpm_act_ru_execution ("proc_inst_id_");
CREATE INDEX ACT_FK_EXE_PARENT ON bpm_act_ru_execution ("parent_id_");
CREATE INDEX ACT_FK_EXE_SUPER ON bpm_act_ru_execution ("super_exec_");
CREATE INDEX ACT_FK_EXE_PROCDEF ON bpm_act_ru_execution ("proc_def_id_");
COMMENT ON COLUMN "bpm_act_ru_execution"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_execution"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_execution"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_execution"."business_key_" IS '业务主键';
COMMENT ON COLUMN "bpm_act_ru_execution"."parent_id_" IS '父执行实例id';
COMMENT ON COLUMN "bpm_act_ru_execution"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_ru_execution"."super_exec_" IS '上级执行实例';
COMMENT ON COLUMN "bpm_act_ru_execution"."act_id_" IS '节点实例id';
COMMENT ON COLUMN "bpm_act_ru_execution"."is_active_" IS '是否存活';
COMMENT ON COLUMN "bpm_act_ru_execution"."is_concurrent_" IS '是否并行';
COMMENT ON COLUMN "bpm_act_ru_execution"."is_scope_" IS '是否节点';
COMMENT ON COLUMN "bpm_act_ru_execution"."is_event_scope_" IS '是否事件范围';
COMMENT ON COLUMN "bpm_act_ru_execution"."suspension_state_" IS '挂起状态  1 激活  2 挂起';
COMMENT ON COLUMN "bpm_act_ru_execution"."cached_ent_state_" IS '缓存状态';
COMMENT ON COLUMN "bpm_act_ru_execution"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_ru_execution"."name_" IS '名称';
COMMENT ON COLUMN "bpm_act_ru_execution"."lock_time_" IS '锁定时间';
COMMENT ON COLUMN "bpm_act_ru_execution"."all_prev_node" IS '前一节点';
COMMENT ON COLUMN "bpm_act_ru_execution"."process_cycle_count" IS '流程循环次数';
COMMENT ON COLUMN "bpm_act_ru_execution"."sub_process_key" IS '子流程标识';
COMMENT ON COLUMN "bpm_act_ru_execution"."cycle_count" IS '子流程循环次数';
COMMENT ON TABLE "bpm_act_ru_execution" IS '运行时流程执行实例表';

-- ----------------------------
-- Records of bpm_act_ru_execution
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ru_identitylink
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_identitylink" CASCADE;
CREATE TABLE "bpm_act_ru_identitylink" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "group_id_" VARCHAR(765) DEFAULT NULL ,
  "type_" VARCHAR(765) DEFAULT NULL ,
  "user_id_" VARCHAR(765) DEFAULT NULL ,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "mandator" VARCHAR(108) DEFAULT NULL ,
  "task_state" CHAR(1) DEFAULT NULL,
  "assist_initiator" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_IDENT_LNK_USER ON bpm_act_ru_identitylink ("user_id_");
CREATE INDEX ACT_IDX_IDENT_LNK_GROUP ON bpm_act_ru_identitylink ("group_id_");
CREATE INDEX ACT_IDX_ATHRZ_PROCEDEF ON bpm_act_ru_identitylink ("proc_def_id_");
CREATE INDEX ACT_FK_TSKASS_TASK ON bpm_act_ru_identitylink ("task_id_");
CREATE INDEX ACT_FK_IDL_PROCINST ON bpm_act_ru_identitylink ("proc_inst_id_");
CREATE INDEX ACT_IDX_IDENT_LNK_USER_TYPE ON bpm_act_ru_identitylink ("type_", "user_id_");
COMMENT ON COLUMN "bpm_act_ru_identitylink"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."group_id_" IS '用户组id';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."user_id_" IS '参与者id';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."mandator" IS '委托人';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."task_state" IS '委托类型  空 无委托关系  1 事前委托';
COMMENT ON COLUMN "bpm_act_ru_identitylink"."assist_initiator" IS '任务发起人';
COMMENT ON TABLE "bpm_act_ru_identitylink" IS '运行时流程人员表';

-- ----------------------------
-- Records of bpm_act_ru_identitylink
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ru_job
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_job" CASCADE;
CREATE TABLE "bpm_act_ru_job" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "type_" VARCHAR(765)  NOT NULL,
  "lock_exp_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "lock_owner_" VARCHAR(765) DEFAULT NULL ,
  "exclusive_" NUMERIC(1) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "process_instance_id_" NUMERIC(20) DEFAULT NULL,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "retries_" NUMERIC(11) DEFAULT NULL,
  "exception_stack_id_" VARCHAR(192) DEFAULT NULL ,
  "exception_msg_" VARCHAR(4000) DEFAULT NULL ,
  "duedate_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL ,
  "repeat_" VARCHAR(765) DEFAULT NULL ,
  "handler_type_" VARCHAR(765) DEFAULT NULL ,
  "handler_cfg_" VARCHAR(4000) DEFAULT NULL ,
  "tenant_id_" VARCHAR(765) DEFAULT '',
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_FK_JOB_EXCEPTION ON bpm_act_ru_job ("exception_stack_id_");
COMMENT ON COLUMN "bpm_act_ru_job"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_job"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_job"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_ru_job"."lock_exp_time_" IS '锁定释放时间';
COMMENT ON COLUMN "bpm_act_ru_job"."lock_owner_" IS '挂起者';
COMMENT ON COLUMN "bpm_act_ru_job"."exclusive_" IS '专属';
COMMENT ON COLUMN "bpm_act_ru_job"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_ru_job"."process_instance_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_job"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_ru_job"."retries_" IS '重试';
COMMENT ON COLUMN "bpm_act_ru_job"."exception_stack_id_" IS '异常信息id';
COMMENT ON COLUMN "bpm_act_ru_job"."exception_msg_" IS '异常信息';
COMMENT ON COLUMN "bpm_act_ru_job"."duedate_" IS '到期时间';
COMMENT ON COLUMN "bpm_act_ru_job"."repeat_" IS '重复';
COMMENT ON COLUMN "bpm_act_ru_job"."handler_type_" IS '处理类型';
COMMENT ON COLUMN "bpm_act_ru_job"."handler_cfg_" IS '处理标识';
COMMENT ON COLUMN "bpm_act_ru_job"."tenant_id_" IS '租户id';
COMMENT ON TABLE "bpm_act_ru_job" IS '运行时定时任务数据表';

-- ----------------------------
-- Records of bpm_act_ru_job
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_ru_task
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_task" CASCADE;
CREATE TABLE "bpm_act_ru_task" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "proc_def_id_" VARCHAR(192) DEFAULT NULL ,
  "name_" VARCHAR(765) DEFAULT NULL ,
  "parent_task_id_" NUMERIC(20) DEFAULT NULL,
  "description_" VARCHAR(4000) DEFAULT NULL ,
  "task_def_key_" VARCHAR(765) DEFAULT NULL ,
  "owner_" VARCHAR(765) DEFAULT NULL ,
  "assignee_" VARCHAR(765) DEFAULT NULL ,
  "delegation_" VARCHAR(192) DEFAULT NULL ,
  "priority_" NUMERIC(11) DEFAULT NULL,
  "create_time_" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "due_date_" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "category_" VARCHAR(765) DEFAULT NULL ,
  "suspension_state_" NUMERIC(11) DEFAULT NULL,
  "tenant_id_" VARCHAR(765) DEFAULT '' ,
  "form_key_" VARCHAR(2000) DEFAULT NULL,
  "preempted" CHAR(1) DEFAULT NULL,
  "sub_process_key" VARCHAR(765) DEFAULT NULL,
  "task_type" VARCHAR(765) DEFAULT NULL,
  "cycle_count" NUMERIC(20) DEFAULT NULL,
  "process_cycle_count" NUMERIC(10) DEFAULT NULL,
  "create_history_task_id"  NUMERIC(20) DEFAULT NULL,
  "urge_state" CHAR(1) DEFAULT NULL,
  "form_id" VARCHAR(192) DEFAULT NULL,
  "send_user" VARCHAR(108) DEFAULT NULL,
  "multi_id" NUMERIC(20) DEFAULT NULL,
  "appoint_assignee" VARCHAR(1024) DEFAULT NULL,
  "todo_configuration" VARCHAR(1024) DEFAULT NULL,
  "complete_type" VARCHAR(96) DEFAULT NULL,
  "jump_info" VARCHAR(765) DEFAULT NULL,
  "all_prev_node" VARCHAR(765) DEFAULT NULL,
  "process_key" VARCHAR(765) DEFAULT NULL,
  "process_name" VARCHAR(765) DEFAULT NULL,
  "business_key" VARCHAR(765) DEFAULT NULL,
  "seq_multi_count" NUMERIC(10) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_TASK_CREATE ON bpm_act_ru_task ("create_time_");
CREATE INDEX ACT_FK_TASK_EXE ON bpm_act_ru_task ("execution_id_");
CREATE INDEX ACT_FK_TASK_PROCINST ON bpm_act_ru_task ("proc_inst_id_");
CREATE INDEX ACT_FK_TASK_PROCDEF ON bpm_act_ru_task ("proc_def_id_");
CREATE INDEX ACT_IDX_RU_TASK_PARENT_TASK_ID ON bpm_act_ru_task ("parent_task_id_");
COMMENT ON COLUMN "bpm_act_ru_task"."id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_ru_task"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_task"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_ru_task"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_task"."proc_def_id_" IS '流程定义id';
COMMENT ON COLUMN "bpm_act_ru_task"."name_" IS '节点名';
COMMENT ON COLUMN "bpm_act_ru_task"."parent_task_id_" IS '父节点实例id';
COMMENT ON COLUMN "bpm_act_ru_task"."description_" IS '描述';
COMMENT ON COLUMN "bpm_act_ru_task"."task_def_key_" IS '节点id';
COMMENT ON COLUMN "bpm_act_ru_task"."owner_" IS '实际签收人';
COMMENT ON COLUMN "bpm_act_ru_task"."assignee_" IS '参与者';
COMMENT ON COLUMN "bpm_act_ru_task"."delegation_" IS '类型';
COMMENT ON COLUMN "bpm_act_ru_task"."priority_" IS '优先级';
COMMENT ON COLUMN "bpm_act_ru_task"."create_time_" IS '创建时间';
COMMENT ON COLUMN "bpm_act_ru_task"."due_date_" IS '超时时间';
COMMENT ON COLUMN "bpm_act_ru_task"."category_" IS '分类';
COMMENT ON COLUMN "bpm_act_ru_task"."suspension_state_" IS '挂起状态  1 激活  2 挂起';
COMMENT ON COLUMN "bpm_act_ru_task"."tenant_id_" IS '租户id';
COMMENT ON COLUMN "bpm_act_ru_task"."form_key_" IS '表单地址';
COMMENT ON COLUMN "bpm_act_ru_task"."preempted" IS '是否已抢单  空 未被抢单  1 已抢单';
COMMENT ON COLUMN "bpm_act_ru_task"."sub_process_key" IS '内部子流程标识';
COMMENT ON COLUMN "bpm_act_ru_task"."task_type" IS '任务类型  空 普通待办  2 协办待办';
COMMENT ON COLUMN "bpm_act_ru_task"."cycle_count" IS '内部子流程节点执行次数';
COMMENT ON COLUMN "bpm_act_ru_task"."process_cycle_count" IS '外部子流程执行次数';
COMMENT ON COLUMN "bpm_act_ru_task"."create_history_task_id" IS '协办来源id';
COMMENT ON COLUMN "bpm_act_ru_task"."urge_state" IS '催办状态 1 被催办 null 未被催办';
COMMENT ON COLUMN "bpm_act_ru_task"."form_id" IS '表单ID';
COMMENT ON COLUMN "bpm_act_ru_task"."send_user" IS '发送人';
COMMENT ON COLUMN "bpm_act_ru_task"."multi_id" IS '会签id';
COMMENT ON COLUMN "bpm_act_ru_task"."appoint_assignee" IS '指定人';
COMMENT ON COLUMN "bpm_act_ru_task"."todo_configuration" IS '待办配置';
COMMENT ON COLUMN "bpm_act_ru_task"."complete_type" IS '来源方式';
COMMENT ON COLUMN "bpm_act_ru_task"."jump_info" IS '跳转信息';
COMMENT ON COLUMN "bpm_act_ru_task"."all_prev_node" IS '前一节点';
COMMENT ON COLUMN "bpm_act_ru_task"."process_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_ru_task"."process_name" IS '流程名';
COMMENT ON COLUMN "bpm_act_ru_task"."business_key" IS '业务主键';
COMMENT ON COLUMN "bpm_act_ru_task"."seq_multi_count" IS '串行会签执行次序';
COMMENT ON TABLE "bpm_act_ru_task" IS '运行时任务节点表';

-- ----------------------------
-- Records of bpm_act_ru_task
-- ----------------------------


-- ----------------------------
-- Table structure for bpm_act_ru_variable
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_ru_variable" CASCADE;
CREATE TABLE "bpm_act_ru_variable" (
  "id_" NUMERIC(20) NOT NULL,
  "rev_" NUMERIC(11) DEFAULT NULL,
  "type_" VARCHAR(765)  NOT NULL,
  "name_" VARCHAR(765)  NOT NULL,
  "execution_id_" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id_" NUMERIC(20) DEFAULT NULL,
  "task_id_" NUMERIC(20) DEFAULT NULL,
  "bytearray_id_" NUMERIC(20) DEFAULT NULL,
  "double_" float4 DEFAULT NULL,
  "long_" NUMERIC(20) DEFAULT NULL,
  "text_" VARCHAR(4000) DEFAULT NULL ,
  "text2_" VARCHAR(4000) DEFAULT NULL,
  PRIMARY KEY ("id_")
);
CREATE INDEX ACT_IDX_VARIABLE_TASK_ID ON bpm_act_ru_variable ("task_id_");
CREATE INDEX ACT_FK_VAR_EXE ON bpm_act_ru_variable ("execution_id_");
CREATE INDEX ACT_FK_VAR_PROCINST ON bpm_act_ru_variable ("proc_inst_id_");
CREATE INDEX ACT_FK_VAR_BYTEARRAY ON bpm_act_ru_variable ("bytearray_id_");
CREATE INDEX ACT_IDX_RU_VARIABLE_NAME ON bpm_act_ru_variable ("name_");
COMMENT ON COLUMN "bpm_act_ru_variable"."id_" IS '主键';
COMMENT ON COLUMN "bpm_act_ru_variable"."rev_" IS '乐观锁';
COMMENT ON COLUMN "bpm_act_ru_variable"."type_" IS '类型';
COMMENT ON COLUMN "bpm_act_ru_variable"."name_" IS '变量名  sendUser 发送人  todoConfiguration 业务描述  complete_type 上一节点办理方式  taskSourceFlag 办理方式  all_prev_node 所有上一节点  bpm_submit_source 提交来源  complete_from 上一节点';
COMMENT ON COLUMN "bpm_act_ru_variable"."execution_id_" IS '执行实例id';
COMMENT ON COLUMN "bpm_act_ru_variable"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "bpm_act_ru_variable"."task_id_" IS '任务id';
COMMENT ON COLUMN "bpm_act_ru_variable"."bytearray_id_" IS '二进制数据表对应id';
COMMENT ON COLUMN "bpm_act_ru_variable"."double_" IS 'double类型存储信息';
COMMENT ON COLUMN "bpm_act_ru_variable"."long_" IS 'long类型存储信息';
COMMENT ON COLUMN "bpm_act_ru_variable"."text_" IS 'string类型存储信息';
COMMENT ON COLUMN "bpm_act_ru_variable"."text2_" IS 'jpa持久化对象对应id';
COMMENT ON TABLE "bpm_act_ru_variable" IS '运行时流程变量数据表';

-- ----------------------------
-- Records of bpm_act_ru_variable
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_cc_task
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_cc_task" CASCADE;
CREATE TABLE "bpm_act_cc_task" (
  "cc_task_id" NUMERIC(20) NOT NULL,
  "task_id" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id" NUMERIC(20) DEFAULT NULL,
  "proc_name" VARCHAR(765) DEFAULT NULL ,
  "task_name" VARCHAR(765) DEFAULT NULL ,
  "send_user" VARCHAR(96) DEFAULT NULL ,
  "receive_user" VARCHAR(96) DEFAULT NULL ,
  "send_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "end_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "form_key" VARCHAR(1000) DEFAULT NULL ,
  "proc_def_key" VARCHAR(192) DEFAULT NULL ,
  "business_id" VARCHAR(765) DEFAULT NULL ,
  "task_def_key" VARCHAR(192)  DEFAULT NULL,
  "task_state" CHAR(1)  DEFAULT NULL,
  "cc_moment" CHAR(1)  DEFAULT NULL,
  "text" text  DEFAULT NULL,
  "form_id" VARCHAR(192)  DEFAULT NULL,
  "proc_def_id_" VARCHAR(164) DEFAULT NULL,
  PRIMARY KEY ("cc_task_id")
);
CREATE INDEX ACT_IDX_CC_TASK_RECEIVE_USER ON bpm_act_cc_task ("receive_user");
CREATE INDEX ACT_IDX_CC_TASK_TASK_ID ON bpm_act_cc_task ("task_id");
CREATE INDEX ACT_PROC_INS_ID ON bpm_act_cc_task ("proc_inst_id" );
CREATE INDEX TIMESORT ON bpm_act_cc_task("send_time" ,"end_time" );
COMMENT ON COLUMN "bpm_act_cc_task"."cc_task_id" IS '主键';
COMMENT ON COLUMN "bpm_act_cc_task"."task_id" IS '任务ID';
COMMENT ON COLUMN "bpm_act_cc_task"."proc_inst_id" IS '实例ID';
COMMENT ON COLUMN "bpm_act_cc_task"."proc_name" IS '流程名称';
COMMENT ON COLUMN "bpm_act_cc_task"."task_name" IS '任务名称';
COMMENT ON COLUMN "bpm_act_cc_task"."send_user" IS '发送人';
COMMENT ON COLUMN "bpm_act_cc_task"."receive_user" IS '接收人';
COMMENT ON COLUMN "bpm_act_cc_task"."send_time" IS '发送时间';
COMMENT ON COLUMN "bpm_act_cc_task"."end_time" IS '阅读时间';
COMMENT ON COLUMN "bpm_act_cc_task"."form_key" IS '表单地址';
COMMENT ON COLUMN "bpm_act_cc_task"."proc_def_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_cc_task"."business_id" IS '业务主键';
COMMENT ON COLUMN "bpm_act_cc_task"."task_def_key" IS '节点id';
COMMENT ON COLUMN "bpm_act_cc_task"."task_state" IS '传阅状态 0 未读 1 已读';
COMMENT ON COLUMN "bpm_act_cc_task"."cc_moment" IS '传阅时机 0节点启动时 1节点结束时 2手动传阅';
COMMENT ON COLUMN "bpm_act_cc_task"."text" IS '待办配置';
COMMENT ON COLUMN "bpm_act_cc_task"."form_id" IS '表单ID';
COMMENT ON COLUMN "bpm_act_cc_task"."proc_def_id_" IS '流程定义id';
COMMENT ON TABLE "bpm_act_cc_task" IS '传阅表';

-- ----------------------------
-- Records of bpm_act_cc_task
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_config
-- ----------------------------
-- ----------------------------
-- Table structure for BPM_ACT_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_config" CASCADE;
CREATE TABLE "bpm_act_config"  (
  "config_id"    NUMERIC(20)   NOT NULL,
  "name"         VARCHAR(765)  NULL,
  "config_key"   VARCHAR(765)  NOT NULL,
  "config_value" VARCHAR(1024) NULL,
  "option_value" VARCHAR(1024) NULL,
  "call_back_address" VARCHAR(1024) NULL,
  "last_editor"  VARCHAR(765)  NULL,
  "last_time"    TIMESTAMP WITHOUT TIME ZONE      NULL,
  "description"  VARCHAR(1024) NULL,
  "parent_id"    NUMERIC(20)   NULL,
  "config_rule"  VARCHAR(192)   NULL,
   PRIMARY KEY ("config_id")
);


COMMENT ON COLUMN "bpm_act_config"."config_id"        IS '主键';
COMMENT ON COLUMN "bpm_act_config"."name"             IS '配置名';
COMMENT ON COLUMN "bpm_act_config"."config_key"       IS  '键';
COMMENT ON COLUMN "bpm_act_config"."config_value"     IS '值';
COMMENT ON COLUMN "bpm_act_config"."option_value"     IS '可选值';
COMMENT ON COLUMN "bpm_act_config"."call_back_address" IS '请求地址';
COMMENT ON COLUMN "bpm_act_config"."last_editor"      IS '最后一次修改人';
COMMENT ON COLUMN "bpm_act_config"."last_time"        IS '最后一次修改时间';
COMMENT ON COLUMN "bpm_act_config"."description"      IS '描述';
COMMENT ON COLUMN "bpm_act_config"."parent_id"        IS '上级ID';
COMMENT ON TABLE "bpm_act_config" IS '工作流配置表';

CREATE UNIQUE INDEX CONFIG_KEY_UNIQUE ON bpm_act_config("config_key");



-- ----------------------------
-- Records of "BPM_ACT_CONFIG"
-- ----------------------------
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10000,'基础配置','bpm_basic_config',NULL,NULL,NULL,NULL,NULL,'工作流基础配置项',1,NULL);
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10002,'办理历史排序规则','complete_history_ordering_rule','todo-in-front','todo-in-front:待办在前，已办按照办理时间升序,create-time-asc:按接收时间升序,create-time-desc:按接收时间降序,todo-in-front-desc:待办在前，已办按办理时间降序',NULL,NULL,NULL,'办理历史排序规则',10000,'checkOption');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10003,'请求建立连接超时时间','connection_timeout','6000',NULL,NULL,NULL,NULL,'工作流调用http请求建立连接超时时间，单位为ms。<br>函数、监听器的远程模式；远程接口模式获取参与者；流程平台推送统一待办需调用http请求',10000,'checkNum');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10004,'请求传递数据超时时间','read_timeout','6000',NULL,NULL,NULL,NULL,'工作流调用http请求传递数据超时时间，单位为ms。<br>函数、监听器的远程模式；远程接口模式获取参与者；流程平台推送统一待办需调用http请求',10000,'checkNum');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10005,'是否推送统一待办','use_data_push','false',NULL,NULL,NULL,NULL,'是否推送统一待办。',10000,'checkRadio');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10006,'统一待办服务','unified_todo_server_name','hussarUnifiedToDoDataPush',NULL,NULL,NULL,NULL,'请选择将任务推送至哪方统一待办服务中',10000,'checkOption');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (10007, '是否开启远程推送', 'remote_data_push', 'true', NULL, NULL, NULL, NULL, '如果开启远程推送则需要配置统一待办数据推送地址', 10000, 'checkRadio');
INSERT INTO "bpm_act_config"("config_id", "name", "config_key", "config_value", "option_value", "call_back_address", "last_editor", "last_time", "description", "parent_id", "config_rule") VALUES (10008, '是否使用部门流程', 'use_organ_process', 'false', NULL, NULL, NULL, NULL, '是否使用部门流程。<br>使用部门流程时，可在天斧画布及流程管理、版本管理发布修改部门流程，启动流程时会根据传递的userId/organId启动对应的部门流程', 10000, 'checkRadio');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (20000,'轻骑兵统一待办','hussar_unified_todo',NULL,NULL,NULL,NULL,NULL,'工作流对接轻骑兵统一待办相关配置',1,NULL);
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (20001,'统一待办应用编码','unified_system_id','524168298611613696',NULL,NULL,NULL,NULL,'统一待办应用编码',20000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (20002,'客户端ID','client_id','unified_server',NULL,NULL,NULL,NULL,'客户端ID',20000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (20003,'客户端秘钥','client_secret','unified_server',NULL,NULL,NULL,NULL,'客户端秘钥',20000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (20004,'统一待办推送地址','unified_to_do_call_address','http://127.0.0.1:8280',NULL,NULL,NULL,NULL,'统一待办推送地址。',20000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30000,'消息中心','bpm_msg',NULL,NULL,NULL,NULL,NULL,'工作流对接消息中心相关配置',1,NULL);
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30001,'消息中心应用编码','msg_app_id','workflow',NULL,NULL,NULL,NULL,'消息中心应用编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30002,'消息中心应用秘钥','msg_app_secret','426bd4e7571f0bc777bbc48545582313',NULL,NULL,NULL,NULL,'消息中心应用秘钥',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30003,'待办场景代码','todo_scene_code','todo',NULL,NULL,NULL,NULL,'消息中心待办场景代码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30004,'驳回场景编码','reject_scene_code','reject',NULL,NULL,NULL,NULL,'消息中心驳回场景编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30005,'催办场景编码','reminders_scene_code','reminders',NULL,NULL,NULL,NULL,'消息中心催办场景编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30006,'委托场景编码','entrust_scene_code','entrust',NULL,NULL,NULL,NULL,'消息中心委托场景编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30007,'流程完成编码','complete_scene_code','complete',NULL,NULL,NULL,NULL,'消息中心流程完成编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30008,'流程终止编码','terminated_scene_code','terminated',NULL,NULL,NULL,NULL,'消息中心流程终止编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (30009,'流程异常编码','exception_scene_code','exception',NULL,NULL,NULL,NULL,'消息中心流程异常编码',30000,'checkNotEmpty');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (40000,'租户配置信息','tenant_info',NULL,NULL,NULL,NULL,NULL,'租户相关配置信息',1,NULL);
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (40001,'参与者获取模式','assignee_mode','import','import:本地模式,remote-datasource:外部数据源',NULL,NULL,NULL,'参与者获取模式',40000,'checkOption');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (40002,'外部数据源名称','remote_db_name',NULL,NULL,'/datasource/queryDBNameListUncorrelated',NULL,NULL,'外部数据源名称',40000,'checkCallBack');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (40003,'表名前缀','table_prefix',NULL,NULL,NULL,NULL,NULL,'当时多个租户使用同一个外部数据源模式时，可通过前缀控制数据查询范围。',40000,'notCheck');
INSERT INTO "bpm_act_config" ("config_id","name","config_key","config_value","option_value","call_back_address","last_editor","last_time","description","parent_id","config_rule") VALUES (40004,'回调地址','tenant_call_address','http://127.0.0.1:8280',NULL,NULL,NULL,NULL,'回调地址。<br>函数、监听器的远程模式；远程接口模式获取参与者；工作流获取变量等功能需要回调特定接口，在此指定服务ip端口号用以回调。',40000,'checkNotEmpty');

----------------------------
-- Table structure for bpm_act_entrust
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_entrust" CASCADE;
CREATE TABLE "bpm_act_entrust" (
  "entrust_id" NUMERIC(20) NOT NULL,
  "mandator" VARCHAR(108) DEFAULT NULL ,
  "process_key" VARCHAR(765) DEFAULT NULL ,
  "mandatary" VARCHAR(108) DEFAULT NULL ,
  "start_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "end_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "state" CHAR(1) DEFAULT NULL ,
  "task_def_key" VARCHAR(765) DEFAULT NULL ,
  "create_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "creator" NUMERIC(20) DEFAULT NULL,
  "last_editor" NUMERIC(20) DEFAULT NULL,
  "is_transfer" CHAR(1) DEFAULT NULL,
  "message_type" VARCHAR(384) DEFAULT NULL,
  "entrust_task_type" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("entrust_id")
);
COMMENT ON COLUMN "bpm_act_entrust"."entrust_id" IS 'ID主键';
COMMENT ON COLUMN "bpm_act_entrust"."mandator" IS '委托人';
COMMENT ON COLUMN "bpm_act_entrust"."process_key" IS '流程ID';
COMMENT ON COLUMN "bpm_act_entrust"."mandatary" IS '被委托人ID';
COMMENT ON COLUMN "bpm_act_entrust"."start_time" IS '开始时间';
COMMENT ON COLUMN "bpm_act_entrust"."end_time" IS '结束时间';
COMMENT ON COLUMN "bpm_act_entrust"."state" IS '状态  1 启用  0 禁用';
COMMENT ON COLUMN "bpm_act_entrust"."task_def_key" IS '节点id';
COMMENT ON COLUMN "bpm_act_entrust"."create_time" IS '创建时间';
COMMENT ON COLUMN "bpm_act_entrust"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "bpm_act_entrust"."creator" IS '创建人';
COMMENT ON COLUMN "bpm_act_entrust"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "bpm_act_entrust"."is_transfer" IS '是否移交任务  1 移交  0 不移交';
COMMENT ON COLUMN "bpm_act_entrust"."message_type" IS '消息提醒方式  sms 短信  mail 邮件  wx_account 微信公众号  app_im IM  app_push APP通知  notice 内部通知  cp 企业微信';
COMMENT ON COLUMN "bpm_act_entrust"."entrust_task_type" IS '委托类型';
COMMENT ON TABLE "bpm_act_entrust" IS '委托表';
-- ----------------------------
-- Table structure for bpm_act_extend_properties
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_extend_properties" CASCADE;
CREATE TABLE "bpm_act_extend_properties" (
  "extend_properties_id" NUMERIC(20) NOT NULL,
  "proc_def_id" VARCHAR(192) DEFAULT NULL ,
  "task_def_key" VARCHAR(192) DEFAULT NULL,
  "task_def_name" VARCHAR(1000) DEFAULT NULL ,
  "form_detail_key" VARCHAR(512) DEFAULT NULL,
  "assist_form_detail_key" VARCHAR(512) DEFAULT NULL,
  "cc_form_detail_key" VARCHAR(512) DEFAULT NULL,
  "form_id" VARCHAR(192) DEFAULT NULL,
  "attribute" VARCHAR(96) DEFAULT NULL,
  PRIMARY KEY ("extend_properties_id")
);
CREATE UNIQUE INDEX IDX_BPM_ACT_EXTEND_PROPERTIES ON bpm_act_extend_properties ("proc_def_id","task_def_key");
COMMENT ON COLUMN "bpm_act_extend_properties"."extend_properties_id" IS '主键';
COMMENT ON COLUMN "bpm_act_extend_properties"."proc_def_id" IS '流程定义ID';
COMMENT ON COLUMN "bpm_act_extend_properties"."task_def_key" IS '节点ID';
COMMENT ON COLUMN "bpm_act_extend_properties"."task_def_name" IS '节点名称';
COMMENT ON COLUMN "bpm_act_extend_properties"."form_detail_key" IS '表单地址';
COMMENT ON COLUMN "bpm_act_extend_properties"."assist_form_detail_key" IS '协办表单详情';
COMMENT ON COLUMN "bpm_act_extend_properties"."cc_form_detail_key" IS '传阅表单详情';
COMMENT ON COLUMN "bpm_act_extend_properties"."form_id" IS '表单ID';
COMMENT ON COLUMN "bpm_act_extend_properties"."attribute" IS '标识扩展的属性类型';
COMMENT ON TABLE "bpm_act_extend_properties" IS '流程拓展信息表';

-- ----------------------------
-- Records of bpm_act_extend_properties
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_hi_line
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_hi_line" CASCADE;
CREATE TABLE "bpm_act_hi_line" (
  "hi_line_id" NUMERIC(20) NOT NULL,
  "proc_inst_id" NUMERIC(20) DEFAULT NULL,
  "proc_def_id" VARCHAR(192) DEFAULT NULL ,
  "proc_def_key" VARCHAR(192) DEFAULT NULL ,
  "line_id" VARCHAR(192)  DEFAULT NULL,
  "complete_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "complete_user" VARCHAR(192) DEFAULT NULL ,
  "line_name" VARCHAR(768) DEFAULT NULL ,
  "process_name" VARCHAR(768) DEFAULT NULL ,
  "out_node" VARCHAR(192) DEFAULT NULL ,
  "out_node_name" VARCHAR(768) DEFAULT NULL ,
  "in_node" VARCHAR(192) DEFAULT NULL ,
  "in_node_name" VARCHAR(768) DEFAULT NULL,
  "sub_process_key" VARCHAR(765) DEFAULT NULL ,
  "cycle_count" NUMERIC(11) DEFAULT NULL,
  PRIMARY KEY ("hi_line_id")
);
CREATE INDEX ACT_IDX_HI_LINE_PINST ON bpm_act_hi_line ("proc_inst_id");
COMMENT ON COLUMN "bpm_act_hi_line"."hi_line_id" IS '主键';
COMMENT ON COLUMN "bpm_act_hi_line"."proc_inst_id" IS '流程实例ID';
COMMENT ON COLUMN "bpm_act_hi_line"."proc_def_id" IS '流程定义ID';
COMMENT ON COLUMN "bpm_act_hi_line"."proc_def_key" IS '流程定义KEY';
COMMENT ON COLUMN "bpm_act_hi_line"."line_id" IS '连线ID';
COMMENT ON COLUMN "bpm_act_hi_line"."complete_time" IS '办理时间';
COMMENT ON COLUMN "bpm_act_hi_line"."complete_user" IS '办理人';
COMMENT ON COLUMN "bpm_act_hi_line"."line_name" IS '连线名称';
COMMENT ON COLUMN "bpm_act_hi_line"."process_name" IS '流程名称';
COMMENT ON COLUMN "bpm_act_hi_line"."out_node" IS '出线节点';
COMMENT ON COLUMN "bpm_act_hi_line"."out_node_name" IS '出线节点名称';
COMMENT ON COLUMN "bpm_act_hi_line"."in_node" IS '入线节点';
COMMENT ON COLUMN "bpm_act_hi_line"."in_node_name" IS '入线节点名称';
COMMENT ON COLUMN "bpm_act_hi_line"."sub_process_key" IS '内部子流程标识';
COMMENT ON COLUMN "bpm_act_hi_line"."cycle_count" IS '内部子流程节点执行次数';
COMMENT ON TABLE "bpm_act_hi_line" IS '历史线表';

-- ----------------------------
-- Records of bpm_act_hi_line
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_urge_task
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_urge_task" CASCADE;
CREATE TABLE "bpm_act_urge_task" (
  "urge_id" NUMERIC(20) NOT NULL,
  "task_id" NUMERIC(20) DEFAULT NULL,
  "proc_inst_id" NUMERIC(20) DEFAULT NULL,
  "proc_name" VARCHAR(765) DEFAULT NULL ,
  "task_name" VARCHAR(765) DEFAULT NULL ,
  "send_user" VARCHAR(96) DEFAULT NULL ,
  "receive_user" VARCHAR(96) DEFAULT NULL ,
  "send_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "form_key" VARCHAR(1000) DEFAULT NULL ,
  "proc_def_key" VARCHAR(192) DEFAULT NULL ,
  "business_id" VARCHAR(765) DEFAULT NULL ,
  "task_def_key" VARCHAR(192) DEFAULT NULL ,
  "text" text DEFAULT NULL ,
  "owner" VARCHAR(96) DEFAULT NULL ,
  "task_state" CHAR(1) DEFAULT NULL,
  PRIMARY KEY ("urge_id")
);
COMMENT ON COLUMN "bpm_act_urge_task"."urge_id" IS '主键';
COMMENT ON COLUMN "bpm_act_urge_task"."task_id" IS '任务ID';
COMMENT ON COLUMN "bpm_act_urge_task"."proc_inst_id" IS '实例ID';
COMMENT ON COLUMN "bpm_act_urge_task"."proc_name" IS '流程名称';
COMMENT ON COLUMN "bpm_act_urge_task"."task_name" IS '任务名称';
COMMENT ON COLUMN "bpm_act_urge_task"."send_user" IS '发送人';
COMMENT ON COLUMN "bpm_act_urge_task"."receive_user" IS '接收人';
COMMENT ON COLUMN "bpm_act_urge_task"."send_time" IS '发送时间';
COMMENT ON COLUMN "bpm_act_urge_task"."form_key" IS '表单地址';
COMMENT ON COLUMN "bpm_act_urge_task"."proc_def_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_urge_task"."business_id" IS '业务主键';
COMMENT ON COLUMN "bpm_act_urge_task"."task_def_key" IS '节点id';
COMMENT ON COLUMN "bpm_act_urge_task"."text" IS '待办配置';
COMMENT ON COLUMN "bpm_act_urge_task"."owner" IS '任务拥有者';
COMMENT ON COLUMN "bpm_act_urge_task"."task_state" IS '任务类型  空 无委托关系  1 事前委托';
COMMENT ON TABLE "bpm_act_urge_task" IS '催办表';

-- ----------------------------
-- Records of bpm_act_urge_task
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_process_file
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_process_file" CASCADE;
CREATE TABLE "bpm_act_process_file" (
  "file_id" NUMERIC(20) NOT NULL,
  "process_key" VARCHAR(192) DEFAULT NULL ,
  "process_id" VARCHAR(192) DEFAULT NULL ,
  "file_version" NUMERIC(11) DEFAULT NULL,
  "file_type" VARCHAR(24) DEFAULT NULL ,
  "content" bytea NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE NULL,
  "process_name" VARCHAR(765) NULL,
  "model_id" NUMERIC(20) DEFAULT NULL,
  "tenant_id" VARCHAR(192) DEFAULT NULL ,
  "create_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "workflow_style" VARCHAR(48) DEFAULT NULL,
  PRIMARY KEY ("file_id")
);
CREATE INDEX ACT_IDX_PFILE_PROCESS_KEY ON bpm_act_process_file ("process_key");
CREATE INDEX ACT_IDX_PFILE_PROCESS_ID ON bpm_act_process_file ("process_id");
COMMENT ON COLUMN "bpm_act_process_file"."file_id" IS '文件ID';
COMMENT ON COLUMN "bpm_act_process_file"."process_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_process_file"."process_id" IS '流程ID';
COMMENT ON COLUMN "bpm_act_process_file"."file_version" IS '版本号';
COMMENT ON COLUMN "bpm_act_process_file"."file_type" IS '文件类型';
COMMENT ON COLUMN "bpm_act_process_file"."content" IS '文件内容';
COMMENT ON COLUMN "bpm_act_process_file"."last_time" IS  '修改时间';
COMMENT ON COLUMN "bpm_act_process_file"."process_name" IS  '流程名称';
COMMENT ON COLUMN "bpm_act_process_file"."model_id" IS '模块ID';
COMMENT ON COLUMN "bpm_act_process_file"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "bpm_act_process_file"."create_time" IS '创建时间';
COMMENT ON COLUMN "bpm_act_process_file"."workflow_style" IS '流程风格';
COMMENT ON TABLE "bpm_act_process_file" IS '工作流文件表';

-- ----------------------------
-- Records of bpm_act_process_file
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_function
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_function" CASCADE;
CREATE TABLE "bpm_act_function" (
  "function_id" NUMERIC(20) NOT NULL,
  "function_name" VARCHAR(765) NULL DEFAULT NULL ,
  "function_type" VARCHAR(96) NOT NULL,
  "function_bean" VARCHAR(765) NULL DEFAULT NULL,
  "request_method" VARCHAR(96) NULL,
  "app_id" NUMERIC(20)  DEFAULT NULL ,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "update_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  PRIMARY KEY ("function_id")
);
CREATE UNIQUE INDEX BPM_ACT_FUNTION_BEAN_ID_INDEX ON bpm_act_function("function_bean");
COMMENT ON COLUMN "bpm_act_function"."function_id" IS '主键';
COMMENT ON COLUMN "bpm_act_function"."function_name" IS '函数名称';
COMMENT ON COLUMN "bpm_act_function"."function_type" IS  '函数类型 local：本地调用 remote：远程调用';
COMMENT ON COLUMN "bpm_act_function"."function_bean" IS '函数BEANID';
COMMENT ON COLUMN "bpm_act_function"."request_method" IS  '远程调用请求类型 GET POST';
COMMENT ON COLUMN "bpm_act_re_model"."app_id" IS '应用ID';
COMMENT ON COLUMN "bpm_act_function"."create_time" IS '创建时间';
COMMENT ON COLUMN "bpm_act_function"."update_time" IS '修改时间';
COMMENT ON TABLE "bpm_act_function" IS '函数表';

-- ----------------------------
-- Records of bpm_act_function
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_function_parm
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_function_parm" CASCADE;
CREATE TABLE "bpm_act_function_parm" (
  "parm_id" NUMERIC(20) NOT NULL,
  "function_id" NUMERIC(20) NULL DEFAULT NULL,
  "parm_name" VARCHAR(765) NULL DEFAULT NULL ,
  "parm_key" VARCHAR(765) NULL DEFAULT NULL ,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "update_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  PRIMARY KEY ("parm_id")
);
COMMENT ON COLUMN "bpm_act_function_parm"."parm_id" IS '主键';
COMMENT ON COLUMN "bpm_act_function_parm"."function_id" IS '函数主键';
COMMENT ON COLUMN "bpm_act_function_parm"."parm_name" IS '参数名称';
COMMENT ON COLUMN "bpm_act_function_parm"."parm_key" IS '参数标识';
COMMENT ON COLUMN "bpm_act_function_parm"."create_time" IS '创建时间';
COMMENT ON COLUMN "bpm_act_function_parm"."update_time" IS '修改时间';
COMMENT ON TABLE "bpm_act_function_parm" IS '函数参数表';

-- ----------------------------
-- Records of bpm_act_function_parm
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_timeout_activity
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_timeout_activity" CASCADE;
CREATE TABLE "bpm_act_timeout_activity" (
  "timeout_id" NUMERIC(20) NOT NULL,
  "task_id" NUMERIC(20) NOT NULL,
  "assignee" text NULL DEFAULT NULL ,
  "due_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "time_out_type" VARCHAR(765) NULL DEFAULT NULL ,
  "tenant_id" VARCHAR(765) NULL DEFAULT NULL ,
  "map" VARCHAR(2000) NULL DEFAULT NULL,
  "message_type" CHAR(1) NOT NULL DEFAULT '0',
  PRIMARY KEY ("timeout_id")
);
COMMENT ON COLUMN "bpm_act_timeout_activity"."timeout_id" IS '主键';
COMMENT ON COLUMN "bpm_act_timeout_activity"."task_id" IS '任务id';
COMMENT ON COLUMN "bpm_act_timeout_activity"."assignee" IS '参与者';
COMMENT ON COLUMN "bpm_act_timeout_activity"."due_time" IS '到期时间';
COMMENT ON COLUMN "bpm_act_timeout_activity"."create_time" IS '开始时间';
COMMENT ON COLUMN "bpm_act_timeout_activity"."time_out_type" IS '超时处理类型';
COMMENT ON COLUMN "bpm_act_timeout_activity"."tenant_id" IS '租户id';
COMMENT ON COLUMN "bpm_act_timeout_activity"."map" IS '接口类型额外参数';
COMMENT ON COLUMN "bpm_act_timeout_activity"."message_type" IS '信息类型 0 节点任务超时处理信息 1 流程超时处理信息';
COMMENT ON TABLE "bpm_act_timeout_activity" IS '超时信息表';

-- ----------------------------
-- Records of bpm_act_timeout_activity
-- ----------------------------


-- ----------------------------
-- Table structure for bpm_act_form_auth
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_form_auth" CASCADE;
CREATE TABLE "bpm_act_form_auth" (
  "form_auth_id" NUMERIC(20) NOT NULL,
   "form_id" NUMERIC(20) NULL,
  "process_version" NUMERIC(11) NULL,
  "form_name" VARCHAR(765) NULL DEFAULT NULL ,
  "process_definition_key" VARCHAR(765)  NULL DEFAULT NULL,
  "task_definition_key" VARCHAR(765) NULL DEFAULT NULL ,
  "ins_disabled" text NULL DEFAULT NULL ,
  "ins_hidden" text NULL DEFAULT NULL ,
  "slot_hidden" text NULL DEFAULT NULL ,
  "form_type" VARCHAR(765) NULL DEFAULT NULL ,
  "form_state" VARCHAR(765) NULL DEFAULT NULL ,
  "ins_not_check" text NULL DEFAULT NULL ,
  "form_check_param" text NULL DEFAULT NULL ,
   "ins_write" text NULL,
  "ins_required" text NULL,
  "single_select" text NULL ,
  "default_opinion" text NULL ,
  "ins_show" text NULL ,
  "ins_only_download" text  NULL,
  PRIMARY KEY ("form_auth_id")
);
CREATE INDEX "bpm_form_auth_process_index" ON "bpm_act_form_auth"("process_definition_key", "task_definition_key");
CREATE INDEX "bpm_form_auth_process_version_index" ON "bpm_act_form_auth"("process_version");
COMMENT ON COLUMN "bpm_act_form_auth"."form_auth_id" IS '主键';
COMMENT ON COLUMN "bpm_act_form_auth"."form_id" IS'表单ID';
COMMENT ON COLUMN "bpm_act_form_auth"."form_name" IS '表单名称';
COMMENT ON COLUMN "bpm_act_form_auth"."process_version" IS'流程版本';
COMMENT ON COLUMN "bpm_act_form_auth"."process_definition_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_form_auth"."task_definition_key" IS '节点ID';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_disabled" IS '禁用组件';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_hidden" IS '隐藏组件';
COMMENT ON COLUMN "bpm_act_form_auth"."slot_hidden" IS '组件隐藏配置';
COMMENT ON COLUMN "bpm_act_form_auth"."form_type" IS '表单类型的标识  1 参与者已办表单  2 参与者待办表单  4 协办人待办表单  5 协办人已办表单  6  传阅人待办表单  7 传阅人已办表单';
COMMENT ON COLUMN "bpm_act_form_auth"."form_state" IS '表单类型 (WebPage/MobilePage)';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_not_check" IS '无需校验组件';
COMMENT ON COLUMN "bpm_act_form_auth"."form_check_param" IS '表单校验相关配置参数';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_write" IS '可编辑组件';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_required" IS '必填组件';
COMMENT ON COLUMN "bpm_act_form_auth"."single_select" IS '指定审批人单选';
COMMENT ON COLUMN "bpm_act_form_auth"."default_opinion" IS '默认意见';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_show" IS '显示组件';
COMMENT ON COLUMN "bpm_act_form_auth"."ins_only_download" IS '下载组件';
COMMENT ON TABLE "bpm_act_form_auth" IS '工作流权限配置表';

-- ----------------------------
-- Records of bpm_act_form_auth
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_assignee
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_assignee" CASCADE;
CREATE TABLE "bpm_act_assignee" (
  "act_assignee_id" NUMERIC(20) NOT NULL,
  "proc_def_key" VARCHAR(192)  NOT NULL,
  "task_def_key" VARCHAR(192)  NULL DEFAULT NULL,
  "process_version" NUMERIC(11) NULL DEFAULT NULL,
  "content" bytea NULL DEFAULT NULL,
  "content_type" VARCHAR(192) NULL DEFAULT NULL,
  "message_type" VARCHAR(384) NULL DEFAULT NULL,
  PRIMARY KEY ("act_assignee_id")
);
CREATE INDEX IDX_BPM_ACT_ASSIGNEE ON bpm_act_assignee("proc_def_key", "task_def_key", "content_type", "process_version");
COMMENT ON COLUMN "bpm_act_assignee"."act_assignee_id" IS '主键';
COMMENT ON COLUMN "bpm_act_assignee"."proc_def_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_assignee"."task_def_key" IS '节点id';
COMMENT ON COLUMN "bpm_act_assignee"."process_version" IS '流程版本';
COMMENT ON COLUMN "bpm_act_assignee"."content" IS '内容';
COMMENT ON COLUMN "bpm_act_assignee"."content_type" IS '类型  defaultAssign 默认参与者  conditionAssign 条件参与者  defaultCcAssign 默认传阅人  conditionCcAssign 条件传阅人  defaultCcEndAssign 默认节点结束传阅人  conditionCcEndAssign 条件节点结束传阅人  assign_model 参与者配置  cc_assign_model 传阅人配置  cc_end_assign_model 节点结束传阅人配置  defaultCallAssignee 外部子流程默认参与者  defaultCallProcessKey 外部子流程默认流程标识  conditionCallAssign 外部子流程条件参与者  conditionCallProcessKey 外部子流程条件流程标识';
COMMENT ON COLUMN "bpm_act_assignee"."message_type" IS '消息提醒方式';
COMMENT ON TABLE "bpm_act_assignee" IS '流程模型参与者表';

-- ----------------------------
-- Records of bpm_act_assignee
-- ----------------------------
-- ----------------------------
-- Table structure for bpm_act_candidate_user
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_candidate_user" CASCADE;
CREATE TABLE "bpm_act_candidate_user" (
  "candidate_user_id" NUMERIC(20) NOT NULL,
  "task_id" NUMERIC(20) NOT NULL,
  "assignee" VARCHAR(765)  NOT NULL,
  PRIMARY KEY ("candidate_user_id")
);
COMMENT ON COLUMN "bpm_act_candidate_user"."candidate_user_id" IS '主键';
COMMENT ON COLUMN "bpm_act_candidate_user"."task_id" IS '任务id';
COMMENT ON COLUMN "bpm_act_candidate_user"."assignee" IS '参与者';
COMMENT ON TABLE "bpm_act_candidate_user" IS '节点候选人信息表';

-- ----------------------------
-- Records of bpm_act_candidate_user
-- ----------------------------



-- ----------------------------
-- Table structure for BPM_ACT_HANDLE_AUTH
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_handle_auth" CASCADE;
CREATE TABLE "bpm_act_handle_auth" (
	"handle_auth_id" NUMERIC(20) NOT NULL,
	"process_definition_key" VARCHAR(765) NULL,
	"task_definition_key" VARCHAR(765) NULL ,
	"process_version" NUMERIC(11) NULL ,
	"handle_name" VARCHAR(765) NULL,
	"handle_icon" VARCHAR(765) NULL,
	"handle_type" VARCHAR(765) NULL,
    "form_type" VARCHAR(765)  NULL ,
	"extend_configuration" VARCHAR(1024) NULL,
	  PRIMARY KEY ("handle_auth_id")
);

COMMENT ON COLUMN "bpm_act_handle_auth"."handle_auth_id"  IS '主键';
COMMENT ON COLUMN "bpm_act_handle_auth"."process_definition_key"   IS '流程标识';
COMMENT ON COLUMN "bpm_act_handle_auth"."task_definition_key"   IS  '节点ID';
COMMENT ON COLUMN "bpm_act_handle_auth"."process_version"   IS '流程版本';
COMMENT ON COLUMN "bpm_act_handle_auth"."handle_name"   IS '操作名称';
COMMENT ON COLUMN "bpm_act_handle_auth"."handle_icon"     IS '图标';
COMMENT ON COLUMN "bpm_act_handle_auth"."handle_type"    IS '操作类型  Save：保存Submit提交  RejectLast：驳回上一  RejectFirst：驳回发起  EndProcess：终结  EntrustTask：转办  Revoke：撤回';
COMMENT ON COLUMN "bpm_act_handle_auth"."form_type"    IS '表单类型的标识  1 参与者已办表单  2 参与者待办表单  4 协办人待办表单  5 协办人已办表单  6  传阅人待办表单  7 传阅人已办表单';
COMMENT ON COLUMN "bpm_act_handle_auth"."extend_configuration"    IS '扩展配置';
COMMENT ON TABLE "bpm_act_handle_auth" IS '操作权限表';


-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_CATEGORY
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_custom_category" CASCADE;
CREATE TABLE "bpm_act_custom_category"(
    "category_id" NUMERIC(20) NOT NULL ,
    "category_name" VARCHAR(765) NULL DEFAULT NULL ,
    "category_order" NUMERIC(11) NULL DEFAULT NULL ,
    "parent_id" NUMERIC(20) NULL DEFAULT NULL ,
    "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
    "creator" NUMERIC(20) NULL DEFAULT NULL,
    "last_editor" NUMERIC(20) NULL DEFAULT NULL,
    "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
    "extra_1" VARCHAR(765) NULL DEFAULT NULL,
    "extra_2" VARCHAR(765) NULL DEFAULT NULL,
    "extra_3" VARCHAR(765) NULL DEFAULT NULL,
    "extra_4" VARCHAR(765) NULL DEFAULT NULL,
    "extra_5" VARCHAR(765) NULL DEFAULT NULL,
     PRIMARY KEY ("category_id")
);

CREATE INDEX "bpm_act_custom_category_parent_id_index" ON "bpm_act_custom_category"("parent_id");
COMMENT ON COLUMN "bpm_act_custom_category"."category_id"  IS '分类id';
COMMENT ON COLUMN "bpm_act_custom_category"."category_name"     IS '分类名';
COMMENT ON COLUMN "bpm_act_custom_category"."category_order"     IS  '排序';
COMMENT ON COLUMN "bpm_act_custom_category"."parent_id"     IS '父级id';
COMMENT ON COLUMN "bpm_act_custom_category"."create_time"      IS '创建时间';
COMMENT ON COLUMN "bpm_act_custom_category"."creator"        IS '创建人';
COMMENT ON COLUMN "bpm_act_custom_category"."last_editor"      IS '最后修改人';
COMMENT ON COLUMN "bpm_act_custom_category"."last_time"     IS '最后修改时间';
COMMENT ON TABLE "bpm_act_custom_category" IS '分类维护表';



-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_FORM
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_custom_form" CASCADE;
CREATE TABLE "bpm_act_custom_form"  (
    "form_id" NUMERIC(20) NOT NULL,
    "form_name" VARCHAR(765) NULL DEFAULT NULL ,
    "form_path" VARCHAR(765) NULL DEFAULT NULL ,
    "form_order" NUMERIC(11) NULL DEFAULT NULL ,
    "form_type" VARCHAR(765)NULL DEFAULT NULL ,
    "category_id" NUMERIC(20) NULL DEFAULT NULL,
    "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL  ,
    "creator" NUMERIC(20) NULL DEFAULT NULL    ,
    "last_editor" NUMERIC(20) NULL DEFAULT NULL,
    "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL    ,
    "extra_1" VARCHAR(765) NULL DEFAULT NULL,
    "extra_2" VARCHAR(765) NULL DEFAULT NULL,
    "extra_3" VARCHAR(765) NULL DEFAULT NULL,
    "extra_4" VARCHAR(765) NULL DEFAULT NULL,
    "extra_5" VARCHAR(765) NULL DEFAULT NULL,
       PRIMARY KEY ("form_id")
);

CREATE INDEX "bpm_act_custom_form_category_id_index" ON "bpm_act_custom_form"("category_id");
COMMENT ON COLUMN "bpm_act_custom_form"."form_id"    IS '表单id';
COMMENT ON COLUMN "bpm_act_custom_form"."form_name"  IS '表单名称';
COMMENT ON COLUMN "bpm_act_custom_form"."form_path"  IS '表单地址';
COMMENT ON COLUMN "bpm_act_custom_form"."form_order" IS '排序';
COMMENT ON COLUMN "bpm_act_custom_form"."form_type"  IS '表单类型 Web：Web端 Mobile：移动端';
COMMENT ON COLUMN "bpm_act_custom_form"."category_id"IS  '所属分类';
COMMENT ON COLUMN "bpm_act_custom_form"."create_time"IS '创建时间';
COMMENT ON COLUMN "bpm_act_custom_form"."creator"    IS '创建人';
COMMENT ON COLUMN "bpm_act_custom_form"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "bpm_act_custom_form"."last_time" IS  '最后修改时间';
COMMENT ON TABLE "bpm_act_handle_auth" IS '三方表单维护表';


-- ----------------------------
-- Table structure for BPM_ACT_CUSTOM_FORM_INFO
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_custom_form_info" CASCADE;
CREATE TABLE "bpm_act_custom_form_info"  (
    "form_info_id" NUMERIC(20) NOT NULL,
    "form_id" NUMERIC(20) NULL DEFAULT NULL ,
    "component_code" VARCHAR(96)NULL DEFAULT NULL ,
    "component_name" VARCHAR(192)NULL DEFAULT NULL ,
    "parent_id" NUMERIC(20) NULL DEFAULT NULL ,
    "form_info_order" NUMERIC(11) NULL DEFAULT NULL ,
    "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL ,
    "creator" NUMERIC(20) NULL DEFAULT NULL ,
    "last_editor" NUMERIC(20) NULL DEFAULT NULL ,
    "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
    "extra_1" VARCHAR(765)NULL DEFAULT NULL,
    "extra_2" VARCHAR(765)NULL DEFAULT NULL,
    "extra_3" VARCHAR(765)NULL DEFAULT NULL,
    "extra_4" VARCHAR(765)NULL DEFAULT NULL,
    "extra_5" VARCHAR(765)NULL DEFAULT NULL,
    PRIMARY KEY ("form_info_id")
);

CREATE INDEX "bpm_act_custom_info_form_id_index" ON "bpm_act_custom_form_info"("form_id");
COMMENT ON COLUMN "bpm_act_custom_form_info"."form_info_id"    IS '主键';
COMMENT ON COLUMN "bpm_act_custom_form_info"."form_id"         IS '表单id';
COMMENT ON COLUMN "bpm_act_custom_form_info"."component_code"  IS  '组件编码';
COMMENT ON COLUMN "bpm_act_custom_form_info"."component_name"  IS '组件名';
COMMENT ON COLUMN "bpm_act_custom_form_info"."parent_id"       IS '父级组件';
COMMENT ON COLUMN "bpm_act_custom_form_info"."form_info_order" IS '分类名';
COMMENT ON COLUMN "bpm_act_custom_form_info"."create_time"     IS '创建时间';
COMMENT ON COLUMN "bpm_act_custom_form_info"."creator"        IS '创建人';
COMMENT ON COLUMN "bpm_act_custom_form_info"."last_editor"     IS '最后修改人';
COMMENT ON COLUMN "bpm_act_custom_form_info"."last_time"     IS '最后修改时间';
COMMENT ON TABLE "bpm_act_handle_auth" IS '表单详情';

-- ----------------------------
-- Table structure for BPM_ACT_TEST_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_test_variable";
CREATE TABLE "bpm_act_test_variable" (
  "proc_inst_id" NUMERIC(20) NOT NULL ,
  "process_key" VARCHAR(765) DEFAULT NULL,
  "variable" text DEFAULT NULL,
  PRIMARY KEY ("proc_inst_id")
);
COMMENT ON COLUMN "bpm_act_test_variable"."proc_inst_id" IS '主键';
COMMENT ON COLUMN "bpm_act_test_variable"."process_key" IS '流程标识';
COMMENT ON COLUMN "bpm_act_test_variable"."variable" IS '变量';
COMMENT ON TABLE "bpm_act_test_variable" IS '测试变量表';

-- ----------------------------
-- Table structure for BPM_ACT_TEST_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_test_details";
CREATE TABLE "bpm_act_test_details" (
  "detail_id" NUMERIC(20) NOT NULL,
  "log_id" NUMERIC(20) NOT NULL,
  "proc_inst_id" NUMERIC(20) DEFAULT NULL,
  "process_name" VARCHAR(765) DEFAULT NULL,
  "proc_def_id" VARCHAR(765) DEFAULT NULL,
  "business_id" VARCHAR(192) DEFAULT NULL,
  "task_def_type" VARCHAR(96) DEFAULT NULL,
  "task_def_name" VARCHAR(765) DEFAULT NULL,
  "task_def_id" VARCHAR(192) DEFAULT NULL,
  "task_id" VARCHAR(765) DEFAULT NULL,
  "user_id" VARCHAR(96) DEFAULT NULL,
  "user_name" VARCHAR(192) DEFAULT NULL,
  "create_time" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "end_time" TIMESTAMP(3) WITHOUT TIME ZONE DEFAULT NULL,
  "sub_process_key" VARCHAR(765) DEFAULT NULL,
  "test_result" CHAR(1) DEFAULT NULL,
  "test_content" VARCHAR(3072) DEFAULT NULL,
  "operation_type" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("detail_id")
);
COMMENT ON COLUMN "bpm_act_test_details"."detail_id" IS '主键';
COMMENT ON COLUMN "bpm_act_test_details"."log_id" IS '测试记录主键';
COMMENT ON COLUMN "bpm_act_test_details"."proc_inst_id" IS '流程实例ID';
COMMENT ON COLUMN "bpm_act_test_details"."process_name" IS '流程名称';
COMMENT ON COLUMN "bpm_act_test_details"."proc_def_id" IS '流程定义ID';
COMMENT ON COLUMN "bpm_act_test_details"."business_id" IS '业务主键';
COMMENT ON COLUMN "bpm_act_test_details"."task_def_type" IS '节点类型';
COMMENT ON COLUMN "bpm_act_test_details"."task_def_name" IS '节点名称';
COMMENT ON COLUMN "bpm_act_test_details"."task_def_id" IS '节点ID';
COMMENT ON COLUMN "bpm_act_test_details"."task_id" IS '任务ID';
COMMENT ON COLUMN "bpm_act_test_details"."user_id" IS '办理人ID';
COMMENT ON COLUMN "bpm_act_test_details"."user_name" IS '办理人名称';
COMMENT ON COLUMN "bpm_act_test_details"."create_time" IS '接收时间';
COMMENT ON COLUMN "bpm_act_test_details"."end_time" IS '办理时间';
COMMENT ON COLUMN "bpm_act_test_details"."sub_process_key" IS '内部子流程标识';
COMMENT ON COLUMN "bpm_act_test_details"."test_result" IS '办理结果';
COMMENT ON COLUMN "bpm_act_test_details"."test_content" IS '日志信息';
COMMENT ON COLUMN "bpm_act_test_details"."operation_type" IS '操作类型';
COMMENT ON TABLE "bpm_act_test_details" IS '流程仿真测试详情表';

-- ----------------------------
-- Table structure for BPM_ACT_TEST_LOG
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_test_log";
CREATE TABLE "bpm_act_test_log" (
  "log_id" NUMERIC(20) NOT NULL,
  "process_name" VARCHAR(765) DEFAULT NULL,
  "proc_inst_id" NUMERIC(20) DEFAULT NULL,
  "business_id" VARCHAR(192) DEFAULT NULL,
  "proc_def_id" VARCHAR(765) DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
  "create_user" VARCHAR(96) DEFAULT NULL,
  "create_user_name" VARCHAR(192) DEFAULT NULL,
  "test_result" CHAR(1) DEFAULT NULL,
  "config_detail" VARCHAR(3072) DEFAULT NULL,
  "test_type" CHAR(1) DEFAULT NULL,
  "task_definiition_id" VARCHAR(765) DEFAULT NULL,
  "parent_node_id" VARCHAR(192) DEFAULT NULL,
  "task_def_id" VARCHAR(192) DEFAULT NULL,
  PRIMARY KEY ("log_id")
);
COMMENT ON COLUMN "bpm_act_test_log"."log_id" IS '主键';
COMMENT ON COLUMN "bpm_act_test_log"."process_name" IS '流程名称';
COMMENT ON COLUMN "bpm_act_test_log"."proc_inst_id" IS '流程实例ID';
COMMENT ON COLUMN "bpm_act_test_log"."business_id" IS '业务主键';
COMMENT ON COLUMN "bpm_act_test_log"."proc_def_id" IS '流程定义ID';
COMMENT ON COLUMN "bpm_act_test_log"."create_time" IS '测试时间';
COMMENT ON COLUMN "bpm_act_test_log"."create_user" IS '办理人ID';
COMMENT ON COLUMN "bpm_act_test_log"."create_user_name" IS '办理人名称';
COMMENT ON COLUMN "bpm_act_test_log"."test_result" IS '测试结果（0失败1成功2测试终止）';
COMMENT ON COLUMN "bpm_act_test_log"."config_detail" IS '配置信息，如测试时维护的变量值';
COMMENT ON COLUMN "bpm_act_test_log"."test_type" IS '测试类型（0自动测试1手动测试）';
COMMENT ON COLUMN "bpm_act_test_log"."task_definiition_id" IS '节点ID';
COMMENT ON COLUMN "bpm_act_test_log"."parent_node_id" IS '父节点ID';
COMMENT ON COLUMN "bpm_act_test_log"."task_def_id" IS '当前节点ID';
COMMENT ON TABLE "bpm_act_test_log" IS '流程仿真测试日志记录表';

-- ----------------------------
-- Table structure for SYS_UNIFIED_CATEGORY_TYPE
-- ----------------------------
DROP TABLE IF EXISTS "sys_unified_category_type";
CREATE TABLE "sys_unified_category_type" (
  "category_type_id" NUMERIC(20)  NOT NULL ,
  "user_id" VARCHAR(108) NULL DEFAULT NULL,
  "category_name" VARCHAR(765) NULL DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "category_seq" NUMERIC(11) NULL DEFAULT NULL,
  PRIMARY KEY ("category_type_id")
);
COMMENT ON COLUMN "sys_unified_category_type"."category_type_id" IS '主键';
COMMENT ON COLUMN "sys_unified_category_type"."user_id" IS '人员ID';
COMMENT ON COLUMN "sys_unified_category_type"."category_name" IS '分类名称';
COMMENT ON COLUMN "sys_unified_category_type"."category_name" IS '创建时间';
COMMENT ON COLUMN "sys_unified_category_type"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_unified_category_type"."category_seq" IS '排序';
COMMENT ON TABLE "sys_unified_category_type" IS '统一待办分类表';

-- ----------------------------
-- Table structure for sys_unified_category_info
-- ----------------------------
DROP TABLE IF EXISTS "sys_unified_category_info";
CREATE TABLE "sys_unified_category_info" (
  "category_info_id" NUMERIC(20)  NOT NULL ,
  "category_type_id" NUMERIC(20)  NOT NULL,
  "category_attribute" VARCHAR(192) NULL DEFAULT NULL,
  PRIMARY KEY ("category_info_id")
);
CREATE INDEX "category_info_category_type_id_index" ON "sys_unified_category_info"("category_type_id");
COMMENT ON COLUMN "sys_unified_category_info"."category_info_id" IS '主键';
COMMENT ON COLUMN "sys_unified_category_info"."category_type_id" IS '分类ID';
COMMENT ON COLUMN "sys_unified_category_info"."category_attribute" IS '分类属性';
COMMENT ON TABLE "sys_unified_category_info" IS '统一待办分类详情表';
-- ----------------------------
-- Table structure for sys_unified_system_info
-- ----------------------------
DROP TABLE IF EXISTS "sys_unified_system_info" CASCADE;
CREATE TABLE "sys_unified_system_info" (
  "system_id" NUMERIC(20) NOT NULL,
  "system_cipher" VARCHAR(108) NULL DEFAULT NULL ,
  "system_name" VARCHAR(768) NULL DEFAULT NULL ,
  "system_address" VARCHAR(768) NULL DEFAULT NULL ,
  "tenant_id" VARCHAR(96) NULL DEFAULT NULL ,
  "creator" NUMERIC(20) NULL DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_editor" NUMERIC(20) NULL DEFAULT NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "system_source" CHAR(1)  NULL DEFAULT NULL,
  "open_type" VARCHAR(108) NULL DEFAULT NULL,
  "system_remark" VARCHAR(768) NULL DEFAULT NULL,
  PRIMARY KEY ("system_id")
);
COMMENT ON COLUMN "sys_unified_system_info"."system_id" IS '主键';
COMMENT ON COLUMN "sys_unified_system_info"."system_cipher" IS '应用密钥';
COMMENT ON COLUMN "sys_unified_system_info"."system_name" IS '应用名称';
COMMENT ON COLUMN "sys_unified_system_info"."system_address" IS '外部应用的访问地址';
COMMENT ON COLUMN "sys_unified_system_info"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_unified_system_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_unified_system_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_unified_system_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_unified_system_info"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_unified_system_info"."system_source" IS '应用来源, 决定任务打开方式(0:内部应用,可直接使用BASE平台打开;
1：外部应用,通过新标签页打开外部链接)';
COMMENT ON COLUMN "sys_unified_system_info"."open_type" IS '打开方式（dialog：弹窗，browserTab：浏览器页签，tab：系统内页签）';
COMMENT ON COLUMN "sys_unified_system_info"."system_remark" IS '备注';
COMMENT ON TABLE "sys_unified_system_info" IS '统一待办应用注册详情表';

-- ----------------------------
-- Records of sys_unified_system_info
-- ----------------------------
INSERT INTO "sys_unified_system_info"("system_id", "system_cipher", "system_name", "system_address", "tenant_id", "creator", "create_time", "last_editor", "last_time", "system_source", "system_remark") VALUES (524168298611613696, '79251d50db609cd723e56d5d4fe92753', '轻骑兵工作流', '', '0', NULL, NULL, NULL, NULL, '0', '轻骑兵工作流默认应用');

-- ----------------------------
-- Table structure for sys_unified_task_info
-- ----------------------------
DROP TABLE IF EXISTS "sys_unified_task_info" CASCADE;
CREATE TABLE "sys_unified_task_info" (
  "todo_id" NUMERIC(20) NOT NULL,
  "task_id" VARCHAR(108) NULL DEFAULT NULL ,
  "system_id" NUMERIC(20) NULL DEFAULT NULL,
  "gategory" VARCHAR(765) NULL DEFAULT NULL ,
  "category_info" VARCHAR(765) NULL DEFAULT NULL ,
  "subject" VARCHAR(1024) NULL DEFAULT NULL ,
  "process_title" VARCHAR(1024) NULL DEFAULT NULL ,
  "data_detail" TEXT NULL DEFAULT NULL ,
  "create_time" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_time" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "dead_line" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "create_user_id" VARCHAR(765) NULL DEFAULT NULL ,
  "create_user_name" VARCHAR(765) NULL DEFAULT NULL ,
  "send_user_id" VARCHAR(108) NULL DEFAULT NULL ,
  "send_user_name" VARCHAR(765) NULL DEFAULT NULL ,
  "urge_user_id" VARCHAR(108) NULL DEFAULT NULL ,
  "urge_user_name" VARCHAR(765) NULL DEFAULT NULL ,
  "app_id" VARCHAR(108)  NULL DEFAULT NULL ,
  "app_info" VARCHAR(765) NULL DEFAULT NULL ,
  "web_linkurl" VARCHAR(1024) NULL DEFAULT NULL ,
  "mobile_linkurl" VARCHAR(1024) NULL DEFAULT NULL ,
  "businessid" VARCHAR(108) NULL DEFAULT NULL ,
  "process_name" VARCHAR(192) NULL DEFAULT NULL ,
  "task_definitionkey" VARCHAR(192) NULL DEFAULT NULL ,
  "task_name" VARCHAR(192) NULL DEFAULT NULL ,
  "process_instanceid" VARCHAR(192) NULL DEFAULT NULL ,
  "process_definitionkey" VARCHAR(192) NULL DEFAULT NULL ,
  "process_version" NUMERIC(10)  NULL DEFAULT NULL ,
  "task_status" CHAR(1) NULL DEFAULT NULL ,
  "task_type" VARCHAR(765) DEFAULT NULL ,
  "form_id" VARCHAR(192) DEFAULT NULL ,
  "extra_1" text NULL ,
  "extra_2" text NULL ,
  "extra_3" text NULL ,
  PRIMARY KEY ("todo_id")
);
CREATE UNIQUE INDEX UNIFIED_TASK_INFO ON sys_unified_task_info("task_id","system_id");
CREATE INDEX SYS_IDX_UNIFIED_TINFO_PINST ON sys_unified_task_info("process_instanceid");
COMMENT ON COLUMN "sys_unified_task_info"."todo_id" IS '主键';
COMMENT ON COLUMN "sys_unified_task_info"."task_id" IS '待办ID';
COMMENT ON COLUMN "sys_unified_task_info"."system_id" IS '应用ID';
COMMENT ON COLUMN "sys_unified_task_info"."gategory" IS '分类';
COMMENT ON COLUMN "sys_unified_task_info"."category_info" IS '分类描述';
COMMENT ON COLUMN "sys_unified_task_info"."subject" IS '待办事项';
COMMENT ON COLUMN "sys_unified_task_info"."process_title" IS '流程业务描述';
COMMENT ON COLUMN "sys_unified_task_info"."data_detail" IS '数据详情';
COMMENT ON COLUMN "sys_unified_task_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_unified_task_info"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_unified_task_info"."dead_line" IS '截至时间';
COMMENT ON COLUMN "sys_unified_task_info"."create_user_id" IS '发起人ID';
COMMENT ON COLUMN "sys_unified_task_info"."create_user_name" IS '发起人姓名';
COMMENT ON COLUMN "sys_unified_task_info"."send_user_id" IS '发送人ID';
COMMENT ON COLUMN "sys_unified_task_info"."send_user_name" IS '发送人姓名';
COMMENT ON COLUMN "sys_unified_task_info"."urge_user_id" IS '催办人ID';
COMMENT ON COLUMN "sys_unified_task_info"."urge_user_name" IS '催办人姓名';
COMMENT ON COLUMN "sys_unified_task_info"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_unified_task_info"."app_info" IS '应用名称';
COMMENT ON COLUMN "sys_unified_task_info"."web_linkurl" IS 'web端表单地址';
COMMENT ON COLUMN "sys_unified_task_info"."mobile_linkurl" IS '移动端表单地址';
COMMENT ON COLUMN "sys_unified_task_info"."businessid" IS '业务ID';
COMMENT ON COLUMN "sys_unified_task_info"."process_name" IS '流程名称';
COMMENT ON COLUMN "sys_unified_task_info"."task_definitionkey" IS '节点ID';
COMMENT ON COLUMN "sys_unified_task_info"."task_name" IS '节点名称';
COMMENT ON COLUMN "sys_unified_task_info"."process_instanceid" IS '流程实ID';
COMMENT ON COLUMN "sys_unified_task_info"."process_definitionkey" IS '流程标识';
COMMENT ON COLUMN "sys_unified_task_info"."process_version" IS '流程版本';
COMMENT ON COLUMN "sys_unified_task_info"."task_status" IS '待办状态（0：待办，1：已完成）';
COMMENT ON COLUMN "sys_unified_task_info"."task_type" IS '任务类型';
COMMENT ON COLUMN "sys_unified_task_info"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_unified_task_info"."extra_1" IS '预留字段';
COMMENT ON COLUMN "sys_unified_task_info"."extra_2" IS '预留字段';
COMMENT ON COLUMN "sys_unified_task_info"."extra_3" IS '预留字段';
COMMENT ON TABLE "sys_unified_task_info" IS '统一待办任务表';

-- ----------------------------
-- Records of sys_unified_task_info
-- ----------------------------

-- ----------------------------
-- Table structure for sys_unified_task_user
-- ----------------------------
DROP TABLE IF EXISTS "sys_unified_task_user" CASCADE;
CREATE TABLE "sys_unified_task_user" (
  "unified_id" NUMERIC(20) NOT NULL,
  "todo_id" NUMERIC(20) NULL DEFAULT NULL,
  "system_id" NUMERIC(20) NULL DEFAULT NULL,
  "task_id" VARCHAR(108) NULL DEFAULT NULL ,
  "user_id" VARCHAR(108) NULL DEFAULT NULL ,
  "user_name" VARCHAR(765) NULL DEFAULT NULL ,
  "receive_time" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "complete_time" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL,
  "execute_status" CHAR(1) NULL DEFAULT NULL ,
  "user_type" CHAR(1) NULL DEFAULT NULL ,
  "urge_status" CHAR(1) NULL DEFAULT NULL ,
  "urge_time" TIMESTAMP(3) WITHOUT TIME ZONE NULL DEFAULT NULL ,
  "cc_moment" CHAR(1) NULL DEFAULT NULL ,
  "extra" VARCHAR(765) NULL DEFAULT NULL ,
  "task_state" CHAR(1) DEFAULT NULL,
  "mandator" VARCHAR(765) DEFAULT NULL,
  "mandator_name" VARCHAR(765) DEFAULT NULL,
  PRIMARY KEY ("unified_id")
);
CREATE INDEX "unified_task_user_task_id_idx" ON "sys_unified_task_user" ("task_id");
CREATE INDEX "unifie_task_user_task_user_idx" ON "sys_unified_task_user" ("system_id" ASC, "task_id" ASC, "user_type" ASC);
COMMENT ON COLUMN "sys_unified_task_user"."unified_id" IS '主键';
COMMENT ON COLUMN "sys_unified_task_user"."todo_id" IS '任务表主键';
COMMENT ON COLUMN "sys_unified_task_user"."system_id" IS '应用ID';
COMMENT ON COLUMN "sys_unified_task_user"."task_id" IS '任务ID';
COMMENT ON COLUMN "sys_unified_task_user"."user_id" IS '用户ID';
COMMENT ON COLUMN "sys_unified_task_user"."user_name" IS '用户名';
COMMENT ON COLUMN "sys_unified_task_user"."receive_time" IS '传阅接收时间';
COMMENT ON COLUMN "sys_unified_task_user"."complete_time" IS '办理时间';
COMMENT ON COLUMN "sys_unified_task_user"."execute_status" IS '完成状态(0：未完成，1：已完成)';
COMMENT ON COLUMN "sys_unified_task_user"."user_type" IS '人员类型（0：关注人，1：执行人）';
COMMENT ON COLUMN "sys_unified_task_user"."urge_status" IS '催办状态（0：未催办，1：已催办）';
COMMENT ON COLUMN "sys_unified_task_user"."urge_time" IS '催办时间';
COMMENT ON COLUMN "sys_unified_task_user"."cc_moment" IS '传阅时机 0节点启动时 1节点结束时 2手动传阅';
COMMENT ON COLUMN "sys_unified_task_user"."extra" IS '额外信息';
COMMENT ON COLUMN "sys_unified_task_user"."task_state" IS '委托类型';
COMMENT ON COLUMN "sys_unified_task_user"."mandator" IS '委托人';
COMMENT ON COLUMN "sys_unified_task_user"."mandator_name" IS '委托人姓名';
COMMENT ON TABLE "sys_unified_task_user" IS '统一待办执行人表';

-- ----------------------------
-- Records of sys_unified_task_user
-- ----------------------------

-- ----------------------------
-- Table structure for bpm_act_custom_comment
-- ----------------------------
DROP TABLE IF EXISTS "bpm_act_custom_comment" CASCADE;
CREATE TABLE "bpm_act_custom_comment" (
  "comment_id" NUMERIC(20) NOT NULL,
  "comment_info" VARCHAR(765) NULL DEFAULT NULL ,
  "comment_type" CHAR(1) NULL DEFAULT NULL ,
  "creator" NUMERIC(20) NULL DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_editor" NUMERIC(20) NULL DEFAULT NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "comment_sort" NUMERIC(20) NULL DEFAULT NULL,
  PRIMARY KEY ("comment_id")
);

CREATE INDEX "idx_create" ON "bpm_act_custom_comment"("creator");
COMMENT ON COLUMN "bpm_act_custom_comment"."comment_id" IS '主键';
COMMENT ON COLUMN "bpm_act_custom_comment"."comment_info" IS '意见内容';
COMMENT ON COLUMN "bpm_act_custom_comment"."comment_type" IS '意见类型，1为驳回';
COMMENT ON COLUMN "bpm_act_custom_comment"."creator" IS '创建人';
COMMENT ON COLUMN "bpm_act_custom_comment"."create_time" IS '创建时间	';
COMMENT ON COLUMN "bpm_act_custom_comment"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "bpm_act_custom_comment"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "bpm_act_custom_comment"."comment_sort" IS '排序';
COMMENT ON TABLE "bpm_act_custom_comment" IS '自定义意见表';

BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_API_CALL_SPECIFICATION
-- ----------------------------
DROP TABLE IF EXISTS "eai_api_call_specification";
CREATE TABLE "eai_api_call_specification" (
  "specificat_id" int8 NOT NULL,
  "show_param_name" varchar(1024),
  "param_name" varchar(1024),
  "param_type" char(1),
  "api_id" int8,
  "judge_condition" char(2),
  "condition_value" varchar(1024),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_api_call_specification"."specificat_id" IS '规范ID';
COMMENT ON COLUMN "eai_api_call_specification"."show_param_name" IS '调用成功规范显示参数名称(格式：body.codeOpen)';
COMMENT ON COLUMN "eai_api_call_specification"."param_name" IS '调用成功规范参数名称(格式：$BODY.code)';
COMMENT ON COLUMN "eai_api_call_specification"."param_type" IS '参数类型';
COMMENT ON COLUMN "eai_api_call_specification"."api_id" IS '接口基本信息ID/接口版本基本信息ID';
COMMENT ON COLUMN "eai_api_call_specification"."judge_condition" IS '判断条件(00-等于；01-不等于；02-在...之内)';
COMMENT ON COLUMN "eai_api_call_specification"."condition_value" IS '条件值 ';
COMMENT ON COLUMN "eai_api_call_specification"."creator" IS '创建人';
COMMENT ON COLUMN "eai_api_call_specification"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_api_call_specification"."last_editor" IS '修改人';
COMMENT ON COLUMN "eai_api_call_specification"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_api_call_specification" IS '接口调用成功规范信息';

-- ----------------------------
-- Records of EAI_API_CALL_SPECIFICATION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_API_CLASSIFICATION
-- ----------------------------
DROP TABLE IF EXISTS "eai_api_classification";
CREATE TABLE "eai_api_classification" (
  "classific_id" int8 NOT NULL,
  "classific_name" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "application_code" varchar(255),
  "remark" varchar(255)
)
;
COMMENT ON COLUMN "eai_api_classification"."classific_id" IS '主键';
COMMENT ON COLUMN "eai_api_classification"."classific_name" IS '分类名称';
COMMENT ON COLUMN "eai_api_classification"."creator" IS '创建人';
COMMENT ON COLUMN "eai_api_classification"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_api_classification"."last_editor" IS '修改人';
COMMENT ON COLUMN "eai_api_classification"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_api_classification" IS '接口分类信息';

-- ----------------------------
-- Records of EAI_API_CLASSIFICATION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_API_INFO
-- ----------------------------
DROP TABLE IF EXISTS "eai_api_info";
CREATE TABLE "eai_api_info" (
  "api_id" int8 NOT NULL,
  "api_name" varchar(255),
  "api_code" varchar(255),
  "application_code" varchar(255),
  "api_path" varchar(255),
  "in_params" text,
  "out_params" text,
  "data_format" char(1),
  "encoding_type" char(1),
  "request_type" char(1),
  "remark" varchar(512),
  "test_state" char(1),
  "public_state" char(1),
  "api_state" char(1),
  "apply_state" char(1),
  "draft_state" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "classific_id" int8,
  "api_type" char(1)
)
;
COMMENT ON COLUMN "eai_api_info"."api_id" IS '接口ID';
COMMENT ON COLUMN "eai_api_info"."api_name" IS '接口名称';
COMMENT ON COLUMN "eai_api_info"."api_code" IS '接口标识';
COMMENT ON COLUMN "eai_api_info"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_api_info"."api_path" IS '接口地址';
COMMENT ON COLUMN "eai_api_info"."in_params" IS '入参信息';
COMMENT ON COLUMN "eai_api_info"."out_params" IS '出参信息';
COMMENT ON COLUMN "eai_api_info"."data_format" IS '数据格式(0 JSON,1XML)';
COMMENT ON COLUMN "eai_api_info"."encoding_type" IS '编码方式（0 UTF8）';
COMMENT ON COLUMN "eai_api_info"."request_type" IS '请求方式(0 POST)';
COMMENT ON COLUMN "eai_api_info"."remark" IS '描述';
COMMENT ON COLUMN "eai_api_info"."test_state" IS '测试状态（1通过测试，0未通过测试）';
COMMENT ON COLUMN "eai_api_info"."public_state" IS '是否公开(1是，0否)';
COMMENT ON COLUMN "eai_api_info"."api_state" IS '上架状态（1已上架，0未上架）';
COMMENT ON COLUMN "eai_api_info"."apply_state" IS '审核状态（1审核中，0正常）';
COMMENT ON COLUMN "eai_api_info"."draft_state" IS '审核状态（1审核中，0正常）';
COMMENT ON COLUMN "eai_api_info"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_api_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_api_info"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_api_info"."last_time" IS '修改时间';
COMMENT ON COLUMN "eai_api_info"."classific_id" IS '分类ID';
COMMENT ON COLUMN "eai_api_info"."api_type" IS '原接口类型,0:http,1:webservice';
COMMENT ON TABLE "eai_api_info" IS '接口基本信息';

-- ----------------------------
-- Records of EAI_API_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_API_LOG
-- ----------------------------
DROP TABLE IF EXISTS "eai_api_log";
CREATE TABLE "eai_api_log" (
  "conn_id" int8 NOT NULL,
  "from_app_code" varchar(255),
  "to_app_code" varchar(255),
  "api_code" varchar(255),
  "api_path" varchar(1024),
  "host_ip" varchar(128),
  "conn_state" char(1),
  "in_params" text,
  "in_params_real" text,
  "out_params" text,
  "out_params_real" text,
  "conn_error" text,
  "conn_duration" varchar(10),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "from_app_name" varchar(128),
  "to_app_name" varchar(128),
  "api_name" varchar(128)
)
;
COMMENT ON COLUMN "eai_api_log"."conn_id" IS 'ID';
COMMENT ON COLUMN "eai_api_log"."from_app_code" IS '调用方应用标识';
COMMENT ON COLUMN "eai_api_log"."to_app_code" IS '被调用方应用标识';
COMMENT ON COLUMN "eai_api_log"."api_code" IS '接口标识';
COMMENT ON COLUMN "eai_api_log"."api_path" IS '接口PATH';
COMMENT ON COLUMN "eai_api_log"."host_ip" IS '调用方ip';
COMMENT ON COLUMN "eai_api_log"."conn_state" IS '状态(1失败，0成功)';
COMMENT ON COLUMN "eai_api_log"."in_params" IS '入参';
COMMENT ON COLUMN "eai_api_log"."in_params_real" IS '转换后入参';
COMMENT ON COLUMN "eai_api_log"."out_params" IS '出参';
COMMENT ON COLUMN "eai_api_log"."out_params_real" IS '转换后出参';
COMMENT ON COLUMN "eai_api_log"."conn_error" IS '异常信息';
COMMENT ON COLUMN "eai_api_log"."conn_duration" IS '调用耗时';
COMMENT ON COLUMN "eai_api_log"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_api_log"."create_time" IS '开始时间';
COMMENT ON COLUMN "eai_api_log"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_api_log"."last_time" IS '结束时间';
COMMENT ON COLUMN "eai_api_log"."from_app_name" IS '调用方';
COMMENT ON COLUMN "eai_api_log"."to_app_name" IS '应用名称';
COMMENT ON COLUMN "eai_api_log"."api_name" IS '接口名称';
COMMENT ON TABLE "eai_api_log" IS '接口调用日志';

-- ----------------------------
-- Records of EAI_API_LOG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_API_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_api_version";
CREATE TABLE "eai_api_version" (
  "api_version_id" int8 NOT NULL,
  "api_id" int8,
  "api_name" varchar(255),
  "api_code" varchar(255),
  "api_version" varchar(128),
  "application_code" varchar(255),
  "api_path" varchar(255),
  "in_params" text,
  "out_params" text,
  "data_format" char(1),
  "encoding_type" char(1),
  "request_type" char(1),
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "create_by" varchar(255),
  "edit_by" varchar(255),
  "api_type" char(1)
)
;
COMMENT ON COLUMN "eai_api_version"."api_version_id" IS '接口版本ID';
COMMENT ON COLUMN "eai_api_version"."api_id" IS '接口ID';
COMMENT ON COLUMN "eai_api_version"."api_name" IS '接口名称';
COMMENT ON COLUMN "eai_api_version"."api_code" IS '接口标识';
COMMENT ON COLUMN "eai_api_version"."api_version" IS '接口版本号';
COMMENT ON COLUMN "eai_api_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_api_version"."api_path" IS '接口地址';
COMMENT ON COLUMN "eai_api_version"."in_params" IS '入参信息';
COMMENT ON COLUMN "eai_api_version"."out_params" IS '出参信息';
COMMENT ON COLUMN "eai_api_version"."data_format" IS '数据格式(0 JSON,1XML)';
COMMENT ON COLUMN "eai_api_version"."encoding_type" IS '编码方式（0 UTF8）';
COMMENT ON COLUMN "eai_api_version"."request_type" IS '请求方式(0 POST)';
COMMENT ON COLUMN "eai_api_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_api_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_api_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_api_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_api_version"."last_time" IS '修改时间';
COMMENT ON COLUMN "eai_api_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_api_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_api_version"."api_type" IS '原接口类型,0:http,1:webservice';
COMMENT ON TABLE "eai_api_version" IS '接口版本基本信息';

-- ----------------------------
-- Records of EAI_API_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APPLICATION_AUTH
-- ----------------------------
DROP TABLE IF EXISTS "eai_application_auth";
CREATE TABLE "eai_application_auth" (
  "params_id" int8 NOT NULL,
  "params_name" varchar(255),
  "params_name_en" varchar(255),
  "params_type" char(2),
  "application_code" varchar(255),
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_application_auth"."params_id" IS 'ID';
COMMENT ON COLUMN "eai_application_auth"."params_name" IS '入参名称';
COMMENT ON COLUMN "eai_application_auth"."params_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_application_auth"."params_type" IS '数据类型(基础数据类型)';
COMMENT ON COLUMN "eai_application_auth"."application_code" IS '应用标识';
COMMENT ON COLUMN "eai_application_auth"."remark" IS '描述';
COMMENT ON COLUMN "eai_application_auth"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_application_auth"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_application_auth"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_application_auth"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_application_auth" IS '应用鉴权入参信息';

-- ----------------------------
-- Records of EAI_APPLICATION_AUTH
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APPLY
-- ----------------------------
DROP TABLE IF EXISTS "eai_apply";
CREATE TABLE "eai_apply" (
  "apply_id" int8 NOT NULL,
  "resource_id" varchar(255),
  "apply_name" varchar(255),
  "apply_code" varchar(255),
  "resource_status" char(1),
  "apply_type" char(2),
  "remark" varchar(512),
  "approve_remark" varchar(512),
  "creator" int8,
  "apply_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone,
  "approved_id" int8,
  "approved_by" varchar(255),
  "process_state" char(1),
  "process_key" varchar(255),
  "process_inst_id" int8,
  "start_time" timestamp without time zone,
  "finish_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_apply"."apply_id" IS 'ID';
COMMENT ON COLUMN "eai_apply"."resource_id" IS '关联信息表ID';
COMMENT ON COLUMN "eai_apply"."apply_name" IS '申请应用名称';
COMMENT ON COLUMN "eai_apply"."apply_code" IS '申请应用标识';
COMMENT ON COLUMN "eai_apply"."resource_status" IS '状态（3撤销，2驳回，1已通过，0申请中）';
COMMENT ON COLUMN "eai_apply"."apply_type" IS '申请类型(01接口申请,02事件申请，03应用创建，04应用删除，05应用启用，06应用禁用，07应用编辑，08应用发布)';
COMMENT ON COLUMN "eai_apply"."remark" IS '描述';
COMMENT ON COLUMN "eai_apply"."approve_remark" IS '审批意见';
COMMENT ON COLUMN "eai_apply"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_apply"."apply_by" IS '创建人';
COMMENT ON COLUMN "eai_apply"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_apply"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_apply"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_apply"."last_time" IS '修改时间';
COMMENT ON COLUMN "eai_apply"."approved_id" IS '审批人ID';
COMMENT ON COLUMN "eai_apply"."approved_by" IS '审批人';
COMMENT ON COLUMN "eai_apply"."process_state" IS '流程状态';
COMMENT ON COLUMN "eai_apply"."process_key" IS '流程标识';
COMMENT ON COLUMN "eai_apply"."process_inst_id" IS '流程实例ID';
COMMENT ON COLUMN "eai_apply"."start_time" IS '流程发起时间';
COMMENT ON COLUMN "eai_apply"."finish_time" IS '流程完成时间';
COMMENT ON TABLE "eai_apply" IS '申请记录信息';

-- ----------------------------
-- Records of EAI_APPLY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APPLY_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "eai_apply_record";
CREATE TABLE "eai_apply_record" (
  "record_id" int8 NOT NULL,
  "resource_id" varchar(255),
  "resource_name" varchar(255),
  "resource_code" varchar(255),
  "application_name" varchar(255),
  "application_code" varchar(255),
  "log_version" varchar(128),
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_apply_record"."record_id" IS 'ID';
COMMENT ON COLUMN "eai_apply_record"."resource_id" IS '接口/事件ID';
COMMENT ON COLUMN "eai_apply_record"."resource_name" IS '接口/事件名称';
COMMENT ON COLUMN "eai_apply_record"."resource_code" IS '接口/事件标识';
COMMENT ON COLUMN "eai_apply_record"."application_name" IS '所属应用名称';
COMMENT ON COLUMN "eai_apply_record"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_apply_record"."log_version" IS '所属应用版本号';
COMMENT ON COLUMN "eai_apply_record"."remark" IS '描述';
COMMENT ON COLUMN "eai_apply_record"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_apply_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_apply_record"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_apply_record"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_apply_record" IS '应用资源申请记录信息';

-- ----------------------------
-- Records of EAI_APPLY_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APP_DATA
-- ----------------------------
DROP TABLE IF EXISTS "eai_app_data";
CREATE TABLE "eai_app_data" (
  "record_id" int8 NOT NULL,
  "record_data" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_app_data"."record_id" IS 'ID';
COMMENT ON COLUMN "eai_app_data"."record_data" IS '申请内容';
COMMENT ON COLUMN "eai_app_data"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_app_data"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_app_data"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_app_data"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_app_data" IS '资源修改内容';

-- ----------------------------
-- Records of EAI_APP_DATA
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APP_RESOURCES
-- ----------------------------
DROP TABLE IF EXISTS "eai_app_resources";
CREATE TABLE "eai_app_resources" (
  "resources_id" int8 NOT NULL,
  "resource_id" int8,
  "resource_type" char(1),
  "application_code" varchar(255),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_app_resources"."resources_id" IS 'RESOURCES_ID';
COMMENT ON COLUMN "eai_app_resources"."resource_id" IS '资源ID';
COMMENT ON COLUMN "eai_app_resources"."resource_type" IS '资源类型（1接口，0事件）';
COMMENT ON COLUMN "eai_app_resources"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_app_resources"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_app_resources"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_app_resources"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_app_resources"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_app_resources"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_app_resources"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_app_resources" IS '应用-已获得权限接口/事件信息关联';

-- ----------------------------
-- Records of EAI_APP_RESOURCES
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APP_WSDL
-- ----------------------------
DROP TABLE IF EXISTS "eai_app_wsdl";
CREATE TABLE "eai_app_wsdl" (
  "wsdl_id" int8 NOT NULL,
  "wsdl_name" varchar(255),
  "application_code" varchar(255),
  "wsdl_version" char(1),
  "wsdl_content" text,
  "wsdl_source_type" char(1),
  "wsdl_path" varchar(1024),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_id" IS '主键';
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_name" IS 'WSDL文件名称';
COMMENT ON COLUMN "eai_app_wsdl"."application_code" IS '应用标识';
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_version" IS 'wsdl版本1:1.1，2:2.0';
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_content" IS '转为JSON格式的wsdl信息';
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_source_type" IS '1：Wsdl文件id，2：wsdl地址';
COMMENT ON COLUMN "eai_app_wsdl"."wsdl_path" IS 'wsdl原文件id/地址';
COMMENT ON COLUMN "eai_app_wsdl"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_app_wsdl"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_app_wsdl"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_app_wsdl"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_app_wsdl" IS 'wsdl文件信息';

-- ----------------------------
-- Records of EAI_APP_WSDL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_APP_WSDL_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_app_wsdl_version";
CREATE TABLE "eai_app_wsdl_version" (
  "wsdl_version_id" int8 NOT NULL,
  "application_version" varchar(128),
  "wsdl_id" int8 NOT NULL,
  "wsdl_name" varchar(255),
  "application_code" varchar(255),
  "wsdl_version" char(1),
  "wsdl_content" text,
  "wsdl_source_type" char(1),
  "wsdl_path" varchar(1024),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_version_id" IS '主键';
COMMENT ON COLUMN "eai_app_wsdl_version"."application_version" IS '应用版本';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_id" IS 'WSDL_ID';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_name" IS 'WSDL文件名称';
COMMENT ON COLUMN "eai_app_wsdl_version"."application_code" IS '应用标识';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_version" IS 'wsdl版本1:1.1，2:2.0';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_content" IS '转为JSON格式的wsdl信息';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_source_type" IS '1：Wsdl文件id，2：wsdl地址';
COMMENT ON COLUMN "eai_app_wsdl_version"."wsdl_path" IS 'wsdl原文件id/地址';
COMMENT ON COLUMN "eai_app_wsdl_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_app_wsdl_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_app_wsdl_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_app_wsdl_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_app_wsdl_version" IS 'wsdl文件版本信息';

-- ----------------------------
-- Records of EAI_APP_WSDL_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_AUTH_WSDL_INFO
-- ----------------------------
DROP TABLE IF EXISTS "eai_auth_wsdl_info";
CREATE TABLE "eai_auth_wsdl_info" (
  "wsdl_auth_info_id" int8 NOT NULL,
  "wsdl_id" int8 NOT NULL,
  "application_version" varchar(128),
  "wsdl_address" varchar(1024),
  "wsdl_service" varchar(255),
  "service_port" varchar(255),
  "wsdl_operation" varchar(255),
  "soap_version" char(1),
  "soap_content" text,
  "wsdl_source_type" char(1),
  "wsdl_path" varchar(1024),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_auth_info_id" IS '主键';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_id" IS '接口/接口版本主键id';
COMMENT ON COLUMN "eai_auth_wsdl_info"."application_version" IS '应用版本号';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_address" IS '实际调用的接口地址';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_service" IS '接口名称';
COMMENT ON COLUMN "eai_auth_wsdl_info"."service_port" IS '接口实现名称';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_operation" IS '方法名';
COMMENT ON COLUMN "eai_auth_wsdl_info"."soap_version" IS 'soap版本1:1.1,2:1.2';
COMMENT ON COLUMN "eai_auth_wsdl_info"."soap_content" IS '拼接的SOAP xml信息，不含参数信息';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_source_type" IS '1：Wsdl文件id，2：wsdl地址';
COMMENT ON COLUMN "eai_auth_wsdl_info"."wsdl_path" IS 'Wsdl文件id/wsdl地址';
COMMENT ON COLUMN "eai_auth_wsdl_info"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_auth_wsdl_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_auth_wsdl_info"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_auth_wsdl_info"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_auth_wsdl_info" IS '存储webservice鉴权配置信息';

-- ----------------------------
-- Records of EAI_AUTH_WSDL_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_CANVAS_INFO
-- ----------------------------
DROP TABLE IF EXISTS "eai_canvas_info";
CREATE TABLE "eai_canvas_info" (
  "canvas_id" int8 NOT NULL,
  "canvas_content" text,
  "api_codes" varchar(4000),
  "canvas_resources" text,
  "creator" int8,
  "create_by" varchar(200),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_canvas_info"."canvas_id" IS '画布ID';
COMMENT ON COLUMN "eai_canvas_info"."canvas_content" IS '画布内容';
COMMENT ON COLUMN "eai_canvas_info"."api_codes" IS '使用接口/事件标识集合';
COMMENT ON COLUMN "eai_canvas_info"."canvas_resources" IS '使用的公共资源信息';
COMMENT ON COLUMN "eai_canvas_info"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_canvas_info"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_canvas_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_canvas_info"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_canvas_info"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_canvas_info"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_canvas_info" IS '画布信息';

-- ----------------------------
-- Records of EAI_CANVAS_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_COMMON_CONN
-- ----------------------------
DROP TABLE IF EXISTS "eai_common_conn";
CREATE TABLE "eai_common_conn" (
  "connection_id" int8 NOT NULL,
  "application_code" varchar(255),
  "connection_name" varchar(255),
  "connection_name_en" varchar(255),
  "classify" char(1),
  "connection_classify" char(2),
  "classify_child" varchar(64),
  "connection_config" text,
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_common_conn"."connection_id" IS '连接ID';
COMMENT ON COLUMN "eai_common_conn"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_common_conn"."connection_name" IS '连接名称';
COMMENT ON COLUMN "eai_common_conn"."connection_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_common_conn"."classify" IS '分类（0开放，1集成）';
COMMENT ON COLUMN "eai_common_conn"."connection_classify" IS '连接分类（00应用鉴权，01数据库，02MQ）';
COMMENT ON COLUMN "eai_common_conn"."classify_child" IS '连接二级分类（code）';
COMMENT ON COLUMN "eai_common_conn"."connection_config" IS '连接配置';
COMMENT ON COLUMN "eai_common_conn"."remark" IS '描述';
COMMENT ON COLUMN "eai_common_conn"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_common_conn"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_common_conn"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_common_conn"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_common_conn"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_common_conn"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_common_conn" IS '公共连接';

-- ----------------------------
-- Records of EAI_COMMON_CONN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_COMMON_CONSTANT
-- ----------------------------
DROP TABLE IF EXISTS "eai_common_constant";
CREATE TABLE "eai_common_constant" (
  "constant_id" int8 NOT NULL,
  "constant_name" varchar(255),
  "constant_name_en" varchar(255),
  "params_type" char(1),
  "constant_value" varchar(512),
  "application_code" varchar(255),
  "constant_classify" char(1),
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_common_constant"."constant_id" IS '常量ID';
COMMENT ON COLUMN "eai_common_constant"."constant_name" IS '常量名称';
COMMENT ON COLUMN "eai_common_constant"."constant_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_common_constant"."params_type" IS '数据类型';
COMMENT ON COLUMN "eai_common_constant"."constant_value" IS '常量值';
COMMENT ON COLUMN "eai_common_constant"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_common_constant"."constant_classify" IS '常量分类（0开放管理，1集成流管理）';
COMMENT ON COLUMN "eai_common_constant"."remark" IS '描述';
COMMENT ON COLUMN "eai_common_constant"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_common_constant"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_common_constant"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_common_constant"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_common_constant"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_common_constant"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_common_constant" IS '公共常量';

-- ----------------------------
-- Records of EAI_COMMON_CONSTANT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_COMMON_LOGIC
-- ----------------------------
DROP TABLE IF EXISTS "eai_common_logic";
CREATE TABLE "eai_common_logic" (
  "logic_id" int8 NOT NULL,
  "application_code" varchar(255),
  "logic_name" varchar(255),
  "logic_code" varchar(255),
  "in_params" text,
  "out_params" text,
  "logic_test" char(1),
  "logic_classify" char(1),
  "canvas_id" int8,
  "creator" int8,
  "remark" varchar(512),
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_common_logic"."logic_id" IS '逻辑ID';
COMMENT ON COLUMN "eai_common_logic"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_common_logic"."logic_name" IS '逻辑名称';
COMMENT ON COLUMN "eai_common_logic"."logic_code" IS '逻辑标识';
COMMENT ON COLUMN "eai_common_logic"."in_params" IS '逻辑入参';
COMMENT ON COLUMN "eai_common_logic"."out_params" IS '逻辑出参';
COMMENT ON COLUMN "eai_common_logic"."logic_test" IS '测试状态(1通过，0未通过)';
COMMENT ON COLUMN "eai_common_logic"."logic_classify" IS '分类（0开放，1集成）';
COMMENT ON COLUMN "eai_common_logic"."canvas_id" IS '画布ID';
COMMENT ON COLUMN "eai_common_logic"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_common_logic"."remark" IS '描述';
COMMENT ON COLUMN "eai_common_logic"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_common_logic"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_common_logic"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_common_logic"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_common_logic"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_common_logic" IS '公共逻辑';

-- ----------------------------
-- Records of EAI_COMMON_LOGIC
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_COMMON_STRUCTURE
-- ----------------------------
DROP TABLE IF EXISTS "eai_common_structure";
CREATE TABLE "eai_common_structure" (
  "structure_id" int8 NOT NULL,
  "params_type" char(1),
  "application_code" varchar(255),
  "structure_code" varchar(255),
  "structure_name" varchar(255),
  "structure_values" text,
  "remark" varchar(512),
  "structure_classify" char(1),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_common_structure"."structure_id" IS '数据结构ID';
COMMENT ON COLUMN "eai_common_structure"."params_type" IS '数据类型';
COMMENT ON COLUMN "eai_common_structure"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_common_structure"."structure_code" IS '数据结构标识';
COMMENT ON COLUMN "eai_common_structure"."structure_name" IS '数据结构名称';
COMMENT ON COLUMN "eai_common_structure"."structure_values" IS '参数信息(数据结构)';
COMMENT ON COLUMN "eai_common_structure"."remark" IS '描述';
COMMENT ON COLUMN "eai_common_structure"."structure_classify" IS '数据结构分类（0开放，1集成）';
COMMENT ON COLUMN "eai_common_structure"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_common_structure"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_common_structure"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_common_structure"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_common_structure"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_common_structure"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_common_structure" IS '数据结构';

-- ----------------------------
-- Records of EAI_COMMON_STRUCTURE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_CONN_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_conn_version";
CREATE TABLE "eai_conn_version" (
  "conn_version_id" int8 NOT NULL,
  "connection_id" int8 NOT NULL,
  "conn_version" varchar(128),
  "application_code" varchar(255),
  "connection_name" varchar(255),
  "connection_name_en" varchar(255),
  "classify" char(1),
  "connection_classify" char(2),
  "classify_child" varchar(64),
  "connection_config" text,
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_conn_version"."conn_version_id" IS '连接版本ID';
COMMENT ON COLUMN "eai_conn_version"."connection_id" IS '连接ID';
COMMENT ON COLUMN "eai_conn_version"."conn_version" IS '连接版本号';
COMMENT ON COLUMN "eai_conn_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_conn_version"."connection_name" IS '连接名称';
COMMENT ON COLUMN "eai_conn_version"."connection_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_conn_version"."classify" IS '分类（0开放，1集成）';
COMMENT ON COLUMN "eai_conn_version"."connection_classify" IS '连接分类（00应用鉴权，01数据库，02MQ）';
COMMENT ON COLUMN "eai_conn_version"."classify_child" IS '连接二级分类（code）';
COMMENT ON COLUMN "eai_conn_version"."connection_config" IS '连接配置';
COMMENT ON COLUMN "eai_conn_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_conn_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_conn_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_conn_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_conn_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_conn_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_conn_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_conn_version" IS '公共连接版本信息';

-- ----------------------------
-- Records of EAI_CONN_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_CONSTANT_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_constant_version";
CREATE TABLE "eai_constant_version" (
  "constant_version_id" int8 NOT NULL,
  "constant_id" int8 NOT NULL,
  "constant_name" varchar(255),
  "constant_name_en" varchar(255),
  "constant_version" varchar(128),
  "params_type" char(1),
  "constant_value" varchar(512),
  "application_code" varchar(255),
  "constant_classify" char(1),
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_constant_version"."constant_version_id" IS '常量版本id';
COMMENT ON COLUMN "eai_constant_version"."constant_id" IS '常量ID';
COMMENT ON COLUMN "eai_constant_version"."constant_name" IS '常量名称';
COMMENT ON COLUMN "eai_constant_version"."constant_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_constant_version"."constant_version" IS '常量版本号';
COMMENT ON COLUMN "eai_constant_version"."params_type" IS '数据类型';
COMMENT ON COLUMN "eai_constant_version"."constant_value" IS '常量值';
COMMENT ON COLUMN "eai_constant_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_constant_version"."constant_classify" IS '常量分类（0开放管理，1集成流管理）';
COMMENT ON COLUMN "eai_constant_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_constant_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_constant_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_constant_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_constant_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_constant_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_constant_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_constant_version" IS '公共常量版本信息';

-- ----------------------------
-- Records of EAI_CONSTANT_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_CUSTOMIZE_AUTH
-- ----------------------------
DROP TABLE IF EXISTS "eai_customize_auth";
CREATE TABLE "eai_customize_auth" (
  "customize_id" char(10),
  "extend_id" int4 NOT NULL,
  "canvas_id" char(1),
  "creator" int4,
  "create_time" timestamp without time zone,
  "last_editor" int4,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_customize_auth"."customize_id" IS '主键';
COMMENT ON COLUMN "eai_customize_auth"."extend_id" IS 'EXTEND_ID';
COMMENT ON COLUMN "eai_customize_auth"."canvas_id" IS '画布id';
COMMENT ON COLUMN "eai_customize_auth"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_customize_auth"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_customize_auth"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_customize_auth"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_customize_auth" IS '自定义鉴权信息';

-- ----------------------------
-- Records of EAI_CUSTOMIZE_AUTH
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_EDIT_API
-- ----------------------------
DROP TABLE IF EXISTS "eai_edit_api";
CREATE TABLE "eai_edit_api" (
  "edit_api_id" int8 NOT NULL,
  "api_id" int8,
  "api_path" varchar(255),
  "encoding_type" char(1),
  "http_method" varchar(8),
  "content_type" char(1),
  "in_params" text,
  "out_params" text,
  "canvas_id" int8,
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_edit_api"."edit_api_id" IS '接口配置信息ID';
COMMENT ON COLUMN "eai_edit_api"."api_id" IS '接口ID';
COMMENT ON COLUMN "eai_edit_api"."api_path" IS '接口地址';
COMMENT ON COLUMN "eai_edit_api"."encoding_type" IS '编码方式（0 UTF8,1 GBK,2 ISO-8859-1,3 GB2312）';
COMMENT ON COLUMN "eai_edit_api"."http_method" IS '请求方式（POST/GET/PUT...）';
COMMENT ON COLUMN "eai_edit_api"."content_type" IS '内容类型（0 NONE,1 APPLICATION/JSON,2 FORM-DATA,3 X-WWW-FORM-URLENCODING）';
COMMENT ON COLUMN "eai_edit_api"."in_params" IS '入参信息(数据结构)';
COMMENT ON COLUMN "eai_edit_api"."out_params" IS '出参信息(数据结构)';
COMMENT ON COLUMN "eai_edit_api"."canvas_id" IS '画布ID';
COMMENT ON COLUMN "eai_edit_api"."remark" IS '描述';
COMMENT ON COLUMN "eai_edit_api"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_edit_api"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_edit_api"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_edit_api"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_edit_api"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_edit_api"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_edit_api" IS '快速配置接口信息';

-- ----------------------------
-- Records of EAI_EDIT_API
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_EDIT_API_WSDL
-- ----------------------------
DROP TABLE IF EXISTS "eai_edit_api_wsdl";
CREATE TABLE "eai_edit_api_wsdl" (
  "api_wsdl_id" int8 NOT NULL,
  "api_id" int8,
  "wsdl_id" int8,
  "wsdl_address" varchar(1024),
  "wsdl_service" varchar(255),
  "service_port" varchar(255),
  "wsdl_operation" varchar(255),
  "soap_version" char(1),
  "soap_content" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_edit_api_wsdl"."api_wsdl_id" IS '主键';
COMMENT ON COLUMN "eai_edit_api_wsdl"."api_id" IS '接口/接口版本主键id';
COMMENT ON COLUMN "eai_edit_api_wsdl"."wsdl_id" IS 'wsdl信息表主键';
COMMENT ON COLUMN "eai_edit_api_wsdl"."wsdl_address" IS '实际调用的接口地址';
COMMENT ON COLUMN "eai_edit_api_wsdl"."wsdl_service" IS '接口名称';
COMMENT ON COLUMN "eai_edit_api_wsdl"."service_port" IS '接口实现名称';
COMMENT ON COLUMN "eai_edit_api_wsdl"."wsdl_operation" IS '方法名';
COMMENT ON COLUMN "eai_edit_api_wsdl"."soap_version" IS 'soap版本1:1.1,2:1.2';
COMMENT ON COLUMN "eai_edit_api_wsdl"."soap_content" IS '拼接的SOAP xml信息，不含参数信息';
COMMENT ON COLUMN "eai_edit_api_wsdl"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_edit_api_wsdl"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_edit_api_wsdl"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_edit_api_wsdl"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_edit_api_wsdl" IS 'webservice编辑信息';

-- ----------------------------
-- Records of EAI_EDIT_API_WSDL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_EVENT_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_event_version";
CREATE TABLE "eai_event_version" (
  "event_version_id" int8 NOT NULL,
  "event_id" int8,
  "event_name" varchar(255),
  "event_name_en" varchar(255),
  "event_version" varchar(128),
  "event_type" char(1),
  "application_code" varchar(255),
  "out_params" text,
  "remark" varchar(512),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_event_version"."event_version_id" IS 'ID';
COMMENT ON COLUMN "eai_event_version"."event_id" IS '事件ID';
COMMENT ON COLUMN "eai_event_version"."event_name" IS '事件名称';
COMMENT ON COLUMN "eai_event_version"."event_name_en" IS '事件英文名称';
COMMENT ON COLUMN "eai_event_version"."event_version" IS '事件版本号';
COMMENT ON COLUMN "eai_event_version"."event_type" IS '事件类型（0webhook,1定时，2触发器）';
COMMENT ON COLUMN "eai_event_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_event_version"."out_params" IS '出参信息';
COMMENT ON COLUMN "eai_event_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_event_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_event_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_event_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_event_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_event_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_event_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_event_version" IS '事件开放版本基本信息';

-- ----------------------------
-- Records of EAI_EVENT_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_HTTP_AUTH_TOKEN_EXPIRE
-- ----------------------------
DROP TABLE IF EXISTS "eai_http_auth_token_expire";
CREATE TABLE "eai_http_auth_token_expire" (
  "invalidation_id" int8 NOT NULL,
  "extend_id" int8,
  "param_name" varchar(1024),
  "judge_condition" char(2),
  "condition_value" varchar(1024),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_http_auth_token_expire"."invalidation_id" IS '主键';
COMMENT ON COLUMN "eai_http_auth_token_expire"."extend_id" IS 'EXTEND_ID';
COMMENT ON COLUMN "eai_http_auth_token_expire"."param_name" IS '参数名称';
COMMENT ON COLUMN "eai_http_auth_token_expire"."judge_condition" IS '判断条件：00-等于；01-不等于；02-在...之内；03...';
COMMENT ON COLUMN "eai_http_auth_token_expire"."condition_value" IS '条件值';
COMMENT ON COLUMN "eai_http_auth_token_expire"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_http_auth_token_expire"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_http_auth_token_expire"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_http_auth_token_expire"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_http_auth_token_expire" IS 'token失效条件';

-- ----------------------------
-- Records of EAI_HTTP_AUTH_TOKEN_EXPIRE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_HTTP_EXTEND
-- ----------------------------
DROP TABLE IF EXISTS "eai_http_extend";
CREATE TABLE "eai_http_extend" (
  "extend_id" int8 NOT NULL,
  "step_code" char(1),
  "template_id" int8,
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_http_extend"."extend_id" IS 'ID';
COMMENT ON COLUMN "eai_http_extend"."step_code" IS '步骤编号';
COMMENT ON COLUMN "eai_http_extend"."template_id" IS 'http鉴权模板ID';
COMMENT ON COLUMN "eai_http_extend"."remark" IS '描述';
COMMENT ON COLUMN "eai_http_extend"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_http_extend"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_http_extend"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_http_extend"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_http_extend" IS 'http鉴权步骤扩展信息';

-- ----------------------------
-- Records of EAI_HTTP_EXTEND
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_HTTP_PARAMS
-- ----------------------------
DROP TABLE IF EXISTS "eai_http_params";
CREATE TABLE "eai_http_params" (
  "params_id" int8 NOT NULL,
  "params_name" varchar(255),
  "params_name_en" varchar(255),
  "params_type" char(2),
  "params_position" char(1),
  "params_from" varchar(255),
  "params_value" text,
  "http_id" int8,
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_http_params"."params_id" IS 'ID';
COMMENT ON COLUMN "eai_http_params"."params_name" IS '入参名称';
COMMENT ON COLUMN "eai_http_params"."params_name_en" IS '英文名称';
COMMENT ON COLUMN "eai_http_params"."params_type" IS '数据类型';
COMMENT ON COLUMN "eai_http_params"."params_position" IS '参数位置 header-0,body-1,queryParams-2';
COMMENT ON COLUMN "eai_http_params"."params_from" IS '值来源(2鉴权参数，1公用常量，0表达式)';
COMMENT ON COLUMN "eai_http_params"."params_value" IS '参数值(来源是2或1时存来源的ID)';
COMMENT ON COLUMN "eai_http_params"."http_id" IS 'HTTP_BASE_ID';
COMMENT ON COLUMN "eai_http_params"."remark" IS '描述';
COMMENT ON COLUMN "eai_http_params"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_http_params"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_http_params"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_http_params"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_http_params" IS 'http参数及值';

-- ----------------------------
-- Records of EAI_HTTP_PARAMS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_HTTP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "eai_http_template";
CREATE TABLE "eai_http_template" (
  "template_id" int8 NOT NULL,
  "application_code" varchar(255),
  "application_version" char(10),
  "has_cert" char(1),
  "template_type" char(1),
  "cert_path" varchar(512),
  "http_type" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_http_template"."template_id" IS 'ID';
COMMENT ON COLUMN "eai_http_template"."application_code" IS '应用标识';
COMMENT ON COLUMN "eai_http_template"."application_version" IS '应用版本号';
COMMENT ON COLUMN "eai_http_template"."has_cert" IS '是否添加证书（1是，0否）';
COMMENT ON COLUMN "eai_http_template"."template_type" IS '分类（2，禁用，1发布，0草稿）';
COMMENT ON COLUMN "eai_http_template"."cert_path" IS '证书存放地址';
COMMENT ON COLUMN "eai_http_template"."http_type" IS '鉴权类型（0无鉴权，1TOKEN鉴权，2BASIC AUHT,3简单认证鉴权，4自定义）';
COMMENT ON COLUMN "eai_http_template"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_http_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_http_template"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_http_template"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_http_template" IS 'http鉴权模板';

-- ----------------------------
-- Records of EAI_HTTP_TEMPLATE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_HTTP_VERIFY_BASE
-- ----------------------------
DROP TABLE IF EXISTS "eai_http_verify_base";
CREATE TABLE "eai_http_verify_base" (
  "http_base_id" int8 NOT NULL,
  "extend_id" int8,
  "http_url" varchar(4000),
  "http_method" varchar(8),
  "http_result" text,
  "content_type" char(1),
  "remark" varchar(512),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_http_verify_base"."http_base_id" IS 'ID';
COMMENT ON COLUMN "eai_http_verify_base"."extend_id" IS 'EXTEND_ID';
COMMENT ON COLUMN "eai_http_verify_base"."http_url" IS '请求地址';
COMMENT ON COLUMN "eai_http_verify_base"."http_method" IS '请求方式（POST/GET/PUT...）';
COMMENT ON COLUMN "eai_http_verify_base"."http_result" IS '返回结果数据结构';
COMMENT ON COLUMN "eai_http_verify_base"."content_type" IS '内容类型（0 none,1 application/json,2 form-data,3 x-www-form-urlencoding）';
COMMENT ON COLUMN "eai_http_verify_base"."remark" IS '描述';
COMMENT ON COLUMN "eai_http_verify_base"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_http_verify_base"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_http_verify_base"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_http_verify_base"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_http_verify_base" IS 'http鉴权验证请求基本信息';

-- ----------------------------
-- Records of EAI_HTTP_VERIFY_BASE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_LOGIC_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_logic_version";
CREATE TABLE "eai_logic_version" (
  "logic_version_id" int8 NOT NULL,
  "logic_id" int8 NOT NULL,
  "application_code" varchar(255),
  "logic_name" varchar(255),
  "logic_code" varchar(255),
  "in_params" text,
  "out_params" text,
  "logic_test" char(1),
  "logic_classify" char(1),
  "logic_version" varchar(128),
  "canvas_id" int8,
  "creator" int8,
  "remark" varchar(512),
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_logic_version"."logic_version_id" IS '逻辑版本ID';
COMMENT ON COLUMN "eai_logic_version"."logic_id" IS '逻辑ID';
COMMENT ON COLUMN "eai_logic_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_logic_version"."logic_name" IS '逻辑名称';
COMMENT ON COLUMN "eai_logic_version"."logic_code" IS '逻辑标识';
COMMENT ON COLUMN "eai_logic_version"."in_params" IS '逻辑入参';
COMMENT ON COLUMN "eai_logic_version"."out_params" IS '逻辑出参';
COMMENT ON COLUMN "eai_logic_version"."logic_test" IS '测试状态(1通过，0未通过)';
COMMENT ON COLUMN "eai_logic_version"."logic_classify" IS '分类（0开放，1集成）';
COMMENT ON COLUMN "eai_logic_version"."logic_version" IS '逻辑版本号';
COMMENT ON COLUMN "eai_logic_version"."canvas_id" IS '画布ID';
COMMENT ON COLUMN "eai_logic_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_logic_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_logic_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_logic_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_logic_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_logic_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_logic_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_logic_version" IS '公共逻辑版本信息';

-- ----------------------------
-- Records of EAI_LOGIC_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_PARAMS_POSITION
-- ----------------------------
DROP TABLE IF EXISTS "eai_params_position";
CREATE TABLE "eai_params_position" (
  "position_id" int8 NOT NULL,
  "params_position" char(1),
  "effective" text,
  "extend_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_params_position"."position_id" IS 'POSITION_ID';
COMMENT ON COLUMN "eai_params_position"."params_position" IS '参数位置';
COMMENT ON COLUMN "eai_params_position"."effective" IS '参数信息（数据结构）';
COMMENT ON COLUMN "eai_params_position"."extend_id" IS 'EXTEND_ID';
COMMENT ON COLUMN "eai_params_position"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_params_position"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_params_position"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_params_position"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_params_position" IS '鉴权参数位置信息';

-- ----------------------------
-- Records of EAI_PARAMS_POSITION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_PUBLISH_LOG
-- ----------------------------
DROP TABLE IF EXISTS "eai_publish_log";
CREATE TABLE "eai_publish_log" (
  "publish_id" int8 NOT NULL,
  "log_name" varchar(255),
  "log_version" varchar(128),
  "remark" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_publish_log"."publish_id" IS 'ID';
COMMENT ON COLUMN "eai_publish_log"."log_name" IS '日志摘要';
COMMENT ON COLUMN "eai_publish_log"."log_version" IS '版本号';
COMMENT ON COLUMN "eai_publish_log"."remark" IS '应用发布描述信息';
COMMENT ON COLUMN "eai_publish_log"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_publish_log"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_publish_log"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_publish_log"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_publish_log" IS '应用发布日志';

-- ----------------------------
-- Records of EAI_PUBLISH_LOG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_RESOURCES_INFO
-- ----------------------------
DROP TABLE IF EXISTS "eai_resources_info";
CREATE TABLE "eai_resources_info" (
  "resource_id" int8 NOT NULL,
  "resource_code" varchar(255),
  "resource_name" varchar(255),
  "resource_relation_id" int8,
  "resource_version_id" int8,
  "application_version" varchar(128),
  "resource_type" char(1),
  "application_code" varchar(255),
  "delete_state" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_resources_info"."resource_id" IS 'ID';
COMMENT ON COLUMN "eai_resources_info"."resource_code" IS '资源编码';
COMMENT ON COLUMN "eai_resources_info"."resource_name" IS '资源名称';
COMMENT ON COLUMN "eai_resources_info"."resource_relation_id" IS '资源ID';
COMMENT ON COLUMN "eai_resources_info"."resource_version_id" IS '资源版本ID';
COMMENT ON COLUMN "eai_resources_info"."application_version" IS '应用版本号';
COMMENT ON COLUMN "eai_resources_info"."resource_type" IS '资源类型（1接口，0事件）';
COMMENT ON COLUMN "eai_resources_info"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_resources_info"."delete_state" IS '逻辑删除，1删除，0未删除';
COMMENT ON COLUMN "eai_resources_info"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_resources_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_resources_info"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_resources_info"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_resources_info" IS '应用开放信息';

-- ----------------------------
-- Records of EAI_RESOURCES_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_STRUCTURE_ITEM_TAG
-- ----------------------------
DROP TABLE IF EXISTS "eai_structure_item_tag";
CREATE TABLE "eai_structure_item_tag" (
  "tag_item_id" int8 NOT NULL,
  "tag_id" int8 NOT NULL,
  "structure_id" int8 NOT NULL,
  "item_name" varchar(256) NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_structure_item_tag"."tag_item_id" IS '关联ID';
COMMENT ON COLUMN "eai_structure_item_tag"."tag_id" IS '标签ID';
COMMENT ON COLUMN "eai_structure_item_tag"."structure_id" IS '数据结构ID';
COMMENT ON COLUMN "eai_structure_item_tag"."item_name" IS '数据结构参数标识';
COMMENT ON COLUMN "eai_structure_item_tag"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_structure_item_tag"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_structure_item_tag"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_structure_item_tag"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_structure_item_tag" IS '数据结构字段标签关联表';

-- ----------------------------
-- Records of EAI_STRUCTURE_ITEM_TAG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_STRUCTURE_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "eai_structure_version";
CREATE TABLE "eai_structure_version" (
  "structure_version_id" int8 NOT NULL,
  "structure_id" int8 NOT NULL,
  "params_type" char(1),
  "application_code" varchar(255),
  "structure_code" varchar(255),
  "structure_name" varchar(255),
  "structure_version" varchar(128),
  "structure_values" text,
  "remark" varchar(512),
  "structure_classify" char(1),
  "creator" int8,
  "create_by" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "edit_by" varchar(255),
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_structure_version"."structure_version_id" IS 'ID';
COMMENT ON COLUMN "eai_structure_version"."structure_id" IS '数据结构ID';
COMMENT ON COLUMN "eai_structure_version"."params_type" IS '数据类型';
COMMENT ON COLUMN "eai_structure_version"."application_code" IS '所属应用标识';
COMMENT ON COLUMN "eai_structure_version"."structure_code" IS '数据结构标识';
COMMENT ON COLUMN "eai_structure_version"."structure_name" IS '数据结构名称';
COMMENT ON COLUMN "eai_structure_version"."structure_version" IS '数据结构版本号';
COMMENT ON COLUMN "eai_structure_version"."structure_values" IS '参数信息(JSONSCHEMA)';
COMMENT ON COLUMN "eai_structure_version"."remark" IS '描述';
COMMENT ON COLUMN "eai_structure_version"."structure_classify" IS '数据结构分类（0开放，1集成）';
COMMENT ON COLUMN "eai_structure_version"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_structure_version"."create_by" IS '创建人';
COMMENT ON COLUMN "eai_structure_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_structure_version"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_structure_version"."edit_by" IS '修改人';
COMMENT ON COLUMN "eai_structure_version"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_structure_version" IS '数据结构版本id';

-- ----------------------------
-- Records of EAI_STRUCTURE_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for EAI_TAG_INFO
-- ----------------------------
DROP TABLE IF EXISTS "eai_tag_info";
CREATE TABLE "eai_tag_info" (
  "tag_id" int8 NOT NULL,
  "tag_name" varchar(64) NOT NULL,
  "tag_code" varchar(64) NOT NULL,
  "remark" varchar(256),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "eai_tag_info"."tag_id" IS '标签ID';
COMMENT ON COLUMN "eai_tag_info"."tag_name" IS '标签名';
COMMENT ON COLUMN "eai_tag_info"."tag_code" IS '标签标识';
COMMENT ON COLUMN "eai_tag_info"."remark" IS '备注';
COMMENT ON COLUMN "eai_tag_info"."creator" IS '创建人ID';
COMMENT ON COLUMN "eai_tag_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "eai_tag_info"."last_editor" IS '修改人ID';
COMMENT ON COLUMN "eai_tag_info"."last_time" IS '修改时间';
COMMENT ON TABLE "eai_tag_info" IS '数据结构标签表';

-- ----------------------------
-- Records of EAI_TAG_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_ACCESS
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_access";
CREATE TABLE "msg_app_access" (
  "app_access_id" int8 NOT NULL,
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "service_type" varchar(255),
  "open_status" int4,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "remark" varchar(255)
)
;
COMMENT ON COLUMN "msg_app_access"."app_access_id" IS '主键ID';
COMMENT ON COLUMN "msg_app_access"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_app_access"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_app_access"."app_secret" IS '应用密码';
COMMENT ON COLUMN "msg_app_access"."service_type" IS '服务类型';
COMMENT ON COLUMN "msg_app_access"."open_status" IS '是否对外开放 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_app_access"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_access"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_app_access"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_app_access"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_app_access"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON COLUMN "msg_app_access"."remark" IS '说明';
COMMENT ON TABLE "msg_app_access" IS '应用管理';

-- ----------------------------
-- Records of MSG_APP_ACCESS
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_access" ("app_access_id", "app_id", "app_name", "app_secret", "service_type", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "remark") VALUES (622900765396312064, 'workflow', '工作流', '426bd4e7571f0bc777bbc48545582313', 'sms,mail,app_push,app_im,cp,dingTalk', 1, '2022-09-15 21:05:15', 1450756958461300737, '2022-09-16 17:01:37', 1450756958461300737, '0', NULL);
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_IM_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_im_channel";
CREATE TABLE "msg_app_im_channel" (
  "app_im_channel_id" int8 NOT NULL,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "server" varchar(255),
  "pub_id" varchar(64),
  "pub_name" varchar(255),
  "pub_password" varchar(255),
  "company_id" varchar(64),
  "company_name" varchar(255),
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_app_im_channel"."app_im_channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_app_im_channel"."channel_no" IS '通道标识';
COMMENT ON COLUMN "msg_app_im_channel"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_app_im_channel"."server" IS 'server地址';
COMMENT ON COLUMN "msg_app_im_channel"."pub_id" IS '微应用ID';
COMMENT ON COLUMN "msg_app_im_channel"."pub_name" IS '微应用名称';
COMMENT ON COLUMN "msg_app_im_channel"."pub_password" IS '微应用密码';
COMMENT ON COLUMN "msg_app_im_channel"."company_id" IS '微应用公司ID';
COMMENT ON COLUMN "msg_app_im_channel"."company_name" IS '微应用公司名称';
COMMENT ON COLUMN "msg_app_im_channel"."open_status" IS '是否对外开放 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_app_im_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_app_im_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_im_channel"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_app_im_channel"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_app_im_channel"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_app_im_channel"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_app_im_channel" IS 'AppIm通道';

-- ----------------------------
-- Records of MSG_APP_IM_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_im_channel" ("app_im_channel_id", "channel_no", "channel_name", "server", "pub_id", "pub_name", "pub_password", "company_id", "company_name", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (3, 'APPIM00001', '系统通知', 'http://127.0.0.1:1234', 'XXXXXXXXXXXXX', '系统通知', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', '金企信试用企业', 1, NULL, '2022-05-13 09:49:38', NULL, '2022-09-14 11:15:00', 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_IM_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_im_send_record";
CREATE TABLE "msg_app_im_send_record" (
  "msg_app_im_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "url" varchar(255),
  "im_params" text,
  "message_type" varchar(128),
  "server" varchar(255),
  "user_ids" varchar(1024),
  "pub_id" varchar(64),
  "pub_name" varchar(255),
  "pub_password" varchar(255),
  "company_id" varchar(64),
  "company_name" varchar(255),
  "send_type" int4,
  "content" varchar(4000),
  "file_names" varchar(64),
  "status" int4,
  "err_msg" varchar(4000),
  "create_date" varchar(64),
  "create_time" timestamp without time zone,
  "send_time" timestamp without time zone,
  "tim" int2,
  "job_time" timestamp without time zone,
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "scene_name" varchar(32),
  "scene_code" varchar(32)
)
;
COMMENT ON COLUMN "msg_app_im_send_record"."msg_app_im_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_app_im_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_app_im_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_app_im_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_app_im_send_record"."template_no" IS '模版标识';
COMMENT ON COLUMN "msg_app_im_send_record"."template_name" IS '模版名字';
COMMENT ON COLUMN "msg_app_im_send_record"."title" IS '标题';
COMMENT ON COLUMN "msg_app_im_send_record"."url" IS '点击后添加的地址';
COMMENT ON COLUMN "msg_app_im_send_record"."im_params" IS 'IM的模版参数';
COMMENT ON COLUMN "msg_app_im_send_record"."message_type" IS '消息类型，TEXT：文本消息，TEXTCARD：文本卡片消息';
COMMENT ON COLUMN "msg_app_im_send_record"."server" IS '服务器地址';
COMMENT ON COLUMN "msg_app_im_send_record"."user_ids" IS '用户ID';
COMMENT ON COLUMN "msg_app_im_send_record"."pub_id" IS '发布ID';
COMMENT ON COLUMN "msg_app_im_send_record"."pub_name" IS '发布名称';
COMMENT ON COLUMN "msg_app_im_send_record"."pub_password" IS '发布密码';
COMMENT ON COLUMN "msg_app_im_send_record"."company_id" IS '公司ID';
COMMENT ON COLUMN "msg_app_im_send_record"."company_name" IS '公司名称';
COMMENT ON COLUMN "msg_app_im_send_record"."send_type" IS '发送类型（1-纯文本 2-图文 3-图片 4-文件）';
COMMENT ON COLUMN "msg_app_im_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_app_im_send_record"."file_names" IS '文件名称';
COMMENT ON COLUMN "msg_app_im_send_record"."status" IS '发送状态（1：未发送，2：发送失败，3：发送成功）';
COMMENT ON COLUMN "msg_app_im_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_app_im_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_app_im_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_im_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_app_im_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_app_im_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_app_im_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_app_im_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_app_im_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_app_im_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_app_im_send_record"."scene_code" IS '场景编码';
COMMENT ON TABLE "msg_app_im_send_record" IS '消息中心APPIM发送记录';

-- ----------------------------
-- Records of MSG_APP_IM_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_IM_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_im_template";
CREATE TABLE "msg_app_im_template" (
  "app_im_template_id" int8 NOT NULL,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "content" text,
  "url" varchar(255),
  "open_status" int4,
  "remark" varchar(255),
  "template_params" text,
  "message_type" varchar(128),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_app_im_template"."app_im_template_id" IS '模板主键ID';
COMMENT ON COLUMN "msg_app_im_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_app_im_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_app_im_template"."title" IS '标题';
COMMENT ON COLUMN "msg_app_im_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_app_im_template"."url" IS '点击后跳转的链接';
COMMENT ON COLUMN "msg_app_im_template"."open_status" IS '启用状态 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_app_im_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_app_im_template"."template_params" IS '模板参数';
COMMENT ON COLUMN "msg_app_im_template"."message_type" IS '消息类型，text：文本消息，textcard：文本卡片消息';
COMMENT ON COLUMN "msg_app_im_template"."creator" IS '创建人';
COMMENT ON COLUMN "msg_app_im_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_im_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_app_im_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_app_im_template"."del_flag" IS '删除标识，1删除';
COMMENT ON TABLE "msg_app_im_template" IS 'IM推送模板表';

-- ----------------------------
-- Records of MSG_APP_IM_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820250685147979776, 'APPIMT240313EX1mlG8u03780', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, NULL, 'processName,expType,processKey,taskKey,taskName', 'text', 1450756958461300737, '2024-03-13 11:03:23', 1450756958461300737, '2024-03-13 11:03:23', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820256871364698112, 'APPIMT240313fTFjiyaF87564', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, NULL, 'currentTime,processName', 'text', 1450756958461300737, '2024-03-13 11:27:58', 1450756958461300737, '2024-03-13 11:27:58', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820256968324423680, 'APPIMT240313bmeVCh1r34757', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, NULL, 'currentTime,processName', 'text', 1450756958461300737, '2024-03-13 11:28:21', 1450756958461300737, '2024-03-13 11:28:21', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820257043540877312, 'APPIMT240313gcBsklyf46844', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, NULL, 'currentTime,processName,taskName', 'text', 1450756958461300737, '2024-03-13 11:28:39', 1450756958461300737, '2024-03-13 11:28:39', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820257144128675840, 'APPIMT240313Vz7g3zyu13111', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, NULL, 'currentTime,processName,startTime,endTime', 'text', 1450756958461300737, '2024-03-13 11:29:03', 1450756958461300737, '2024-03-13 11:29:03', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820257460123344896, 'APPIMT2403134fynMRYu98152', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, NULL, 'processName,currentTime', 'text', 1450756958461300737, '2024-03-13 11:30:18', 1450756958461300737, '2024-03-13 11:30:18', '0');
INSERT INTO "msg_app_im_template" ("app_im_template_id", "template_no", "template_name", "title", "content", "url", "open_status", "remark", "template_params", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820257564389548032, 'APPIMT240313jAt6KlRG81148', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, NULL, 'processName,currentTime', 'text', 1450756958461300737, '2024-03-13 11:30:43', 1450756958461300737, '2024-03-13 11:30:43', '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_PUSH_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_push_channel";
CREATE TABLE "msg_app_push_channel" (
  "app_push_channel_id" int8 NOT NULL,
  "channel_no" varchar(50),
  "channel_name" varchar(128),
  "app_id" varchar(128),
  "secret_key" varchar(255),
  "assess_id" varchar(255),
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_app_push_channel"."app_push_channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_app_push_channel"."channel_no" IS '应用标识';
COMMENT ON COLUMN "msg_app_push_channel"."channel_name" IS '应用名称';
COMMENT ON COLUMN "msg_app_push_channel"."app_id" IS 'APP_ID';
COMMENT ON COLUMN "msg_app_push_channel"."secret_key" IS 'SECRET_KEY';
COMMENT ON COLUMN "msg_app_push_channel"."assess_id" IS 'ASSESS_ID';
COMMENT ON COLUMN "msg_app_push_channel"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_app_push_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_app_push_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_push_channel"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_app_push_channel"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_app_push_channel"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_app_push_channel"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_app_push_channel" IS 'App推送通道';

-- ----------------------------
-- Records of MSG_APP_PUSH_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_push_channel" ("app_push_channel_id", "channel_no", "channel_name", "app_id", "secret_key", "assess_id", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (22, 'APP00001', '系统通知', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', 1, NULL, '2022-05-18 15:51:06', NULL, '2022-07-07 21:55:40', 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_PUSH_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_push_send_record";
CREATE TABLE "msg_app_push_send_record" (
  "msg_app_push_send_record_id" int8 NOT NULL,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "app_id" varchar(64),
  "app_push_params" text,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "secret_key" varchar(255),
  "assess_id" varchar(255),
  "title" varchar(255),
  "content" varchar(4000),
  "angle_mark" int4,
  "status" int4,
  "err_msg" varchar(4000),
  "create_time" timestamp without time zone,
  "create_date" varchar(64),
  "send_time" timestamp without time zone,
  "tim" int2,
  "job_time" timestamp without time zone,
  "audience_type" int4,
  "channel_id" int8,
  "platform" int4,
  "token_list" varchar(255),
  "action_type" int4,
  "intent" varchar(64),
  "url" varchar(255),
  "activity" varchar(64),
  "action_address" varchar(255),
  "msg_app_id" varchar(64),
  "msg_app_name" varchar(255),
  "msg_app_secret" varchar(255),
  "scene_name" varchar(32),
  "scene_code" varchar(32)
)
;
COMMENT ON COLUMN "msg_app_push_send_record"."msg_app_push_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_app_push_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_app_push_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_app_push_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_app_push_send_record"."app_push_params" IS 'appPsuh模版参数';
COMMENT ON COLUMN "msg_app_push_send_record"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_app_push_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_app_push_send_record"."secret_key" IS '密钥';
COMMENT ON COLUMN "msg_app_push_send_record"."assess_id" IS '评估ID';
COMMENT ON COLUMN "msg_app_push_send_record"."title" IS '标题';
COMMENT ON COLUMN "msg_app_push_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_app_push_send_record"."angle_mark" IS '角标数';
COMMENT ON COLUMN "msg_app_push_send_record"."status" IS '发送状态 1：未发送，2：发送失败，3：发送成功';
COMMENT ON COLUMN "msg_app_push_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_app_push_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_push_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_app_push_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_app_push_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_app_push_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_app_push_send_record"."audience_type" IS '目标类型 0：全部 1：token';
COMMENT ON COLUMN "msg_app_push_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_app_push_send_record"."platform" IS '平台类型 0：安卓 1：IOS 2：安卓+IOS';
COMMENT ON COLUMN "msg_app_push_send_record"."token_list" IS 'token 目标类型为1时必填';
COMMENT ON COLUMN "msg_app_push_send_record"."action_type" IS '点击动作类型，0:App 本身，1：打开 activity，2：打开浏览器 3：打开 Intent';
COMMENT ON COLUMN "msg_app_push_send_record"."intent" IS '自定义页面中 intent 的实现，动作类型为 3 时必填';
COMMENT ON COLUMN "msg_app_push_send_record"."url" IS '设置打开特定 URL，动作类型为 2 时必填';
COMMENT ON COLUMN "msg_app_push_send_record"."activity" IS '打开自定义 activity，动作类型为 1 时必填';
COMMENT ON COLUMN "msg_app_push_send_record"."msg_app_id" IS '消息应用ID';
COMMENT ON COLUMN "msg_app_push_send_record"."msg_app_name" IS '消息应用名称';
COMMENT ON COLUMN "msg_app_push_send_record"."msg_app_secret" IS '消息应用密钥';
COMMENT ON COLUMN "msg_app_push_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_app_push_send_record"."scene_code" IS '场景编码';
COMMENT ON TABLE "msg_app_push_send_record" IS '消息中心App推送发送记录';

-- ----------------------------
-- Records of MSG_APP_PUSH_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_PUSH_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_push_template";
CREATE TABLE "msg_app_push_template" (
  "app_push_template_id" int8 NOT NULL,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "content" text,
  "open_status" int4,
  "remark" varchar(255),
  "template_params" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_app_push_template"."app_push_template_id" IS '模板主键ID';
COMMENT ON COLUMN "msg_app_push_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_app_push_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_app_push_template"."title" IS '标题';
COMMENT ON COLUMN "msg_app_push_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_app_push_template"."open_status" IS '启用状态 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_app_push_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_app_push_template"."template_params" IS '模板参数';
COMMENT ON COLUMN "msg_app_push_template"."creator" IS '创建人';
COMMENT ON COLUMN "msg_app_push_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_push_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_app_push_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_app_push_template"."del_flag" IS '删除标识，1删除';
COMMENT ON TABLE "msg_app_push_template" IS 'APP通知推送模板表';

-- ----------------------------
-- Records of MSG_APP_PUSH_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820259777669242880, 'APPPUSHT240313Jlnp782t32655', '流程异常提醒', '异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', 1, NULL, 'processName,expType,processKey,taskKey,taskName', 1450756958461300737, '2024-03-13 11:39:31', 1450756958461300737, '2024-03-13 11:39:31', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820259847881891840, 'APPPUSHT240313eviqlKeX23539', '流程待办提醒', '待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:39:47', 1450756958461300737, '2024-03-13 11:39:47', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820259935530262528, 'APPPUSHT2403138IdjYts663860', '流程驳回提醒', '驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:40:08', 1450756958461300737, '2024-03-13 11:40:08', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260027624595456, 'APPPUSHT2403137BGMf6G287636', '流程催办提醒', '催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', 1, NULL, 'currentTime,processName,taskName', 1450756958461300737, '2024-03-13 11:40:30', 1450756958461300737, '2024-03-13 11:40:30', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260198429237248, 'APPPUSHT240313Yau2N3BQ26358', '流程委托提醒', '委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', 1, NULL, 'currentTime,processName,startTime,endTime', 1450756958461300737, '2024-03-13 11:41:11', 1450756958461300737, '2024-03-13 11:41:11', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260277319901184, 'APPPUSHT240313XiaZPoRp13555', '流程完成提醒', '完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:41:30', 1450756958461300737, '2024-03-13 11:41:30', '0');
INSERT INTO "msg_app_push_template" ("app_push_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260349638090752, 'APPPUSHT240313tbEIyD1206710', '流程终止提醒', '终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:41:47', 1450756958461300737, '2024-03-13 11:41:47', '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_APP_SCENE_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "msg_app_scene_config";
CREATE TABLE "msg_app_scene_config" (
  "app_scene_id" int8 NOT NULL,
  "app_pk_id" int8,
  "scene_code" varchar(32),
  "scene_name" varchar(32),
  "scene_desc" varchar(255),
  "tag_name" varchar(255),
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_app_scene_config"."app_scene_id" IS '主键';
COMMENT ON COLUMN "msg_app_scene_config"."app_pk_id" IS 'App主键id';
COMMENT ON COLUMN "msg_app_scene_config"."scene_code" IS '场景编码';
COMMENT ON COLUMN "msg_app_scene_config"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_app_scene_config"."scene_desc" IS '场景说明';
COMMENT ON COLUMN "msg_app_scene_config"."tag_name" IS '标签';
COMMENT ON COLUMN "msg_app_scene_config"."last_time" IS '更新时间';
COMMENT ON COLUMN "msg_app_scene_config"."last_editor" IS '修改人id';
COMMENT ON COLUMN "msg_app_scene_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_app_scene_config"."creator" IS '创建人';
COMMENT ON COLUMN "msg_app_scene_config"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_app_scene_config" IS '应用场景配置表';

-- ----------------------------
-- Records of MSG_APP_SCENE_CONFIG
-- ----------------------------
BEGIN;
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202142492303360, 622900765396312064, 'todo', '任务待办', NULL, NULL, '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202324848058368, 622900765396312064, 'reject', '任务驳回', NULL, NULL, '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202474509213696, 622900765396312064, 'reminders', '任务催办', NULL, NULL, '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202602129301504, 622900765396312064, 'entrust', '流程委托', NULL, NULL, '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202731083177984, 622900765396312064, 'complete', '流程完成', NULL, NULL, '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202854248914944, 622900765396312064, 'terminated', '流程终止', NULL, NULL, '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO "msg_app_scene_config" ("app_scene_id", "app_pk_id", "scene_code", "scene_name", "scene_desc", "tag_name", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (653555293984399360, 622900765396312064, 'exception', '流程异常', NULL, NULL, '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_CONTACT
-- ----------------------------
DROP TABLE IF EXISTS "msg_contact";
CREATE TABLE "msg_contact" (
  "msg_contact_id" int8 NOT NULL,
  "contact_id" varchar(255),
  "contact_type" varchar(255),
  "contact_name" varchar(255),
  "contact_id_and_type" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "msg_contact"."msg_contact_id" IS '主键';
COMMENT ON COLUMN "msg_contact"."contact_id" IS '联系人标识';
COMMENT ON COLUMN "msg_contact"."contact_type" IS '联系人类型';
COMMENT ON COLUMN "msg_contact"."contact_name" IS '联系人名称';
COMMENT ON COLUMN "msg_contact"."contact_id_and_type" IS '联系人标识+类型';
COMMENT ON COLUMN "msg_contact"."creator" IS '创建人';
COMMENT ON COLUMN "msg_contact"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_contact"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_contact"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "msg_contact" IS '联系人表';

-- ----------------------------
-- Records of MSG_CONTACT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_CONTACT_INFO
-- ----------------------------
DROP TABLE IF EXISTS "msg_contact_info";
CREATE TABLE "msg_contact_info" (
  "msg_contact_info_id" int8 NOT NULL,
  "contact_id" varchar(255),
  "contact_type" varchar(255),
  "contact_name" varchar(255),
  "send_type" varchar(255),
  "tag_name" varchar(32),
  "receive_address" varchar(255),
  "channel_no" varchar(64),
  "contact_id_and_type" varchar(255),
  "msg_order" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "msg_contact_info"."msg_contact_info_id" IS '主键';
COMMENT ON COLUMN "msg_contact_info"."contact_id" IS '联系人标识';
COMMENT ON COLUMN "msg_contact_info"."contact_type" IS '联系人类型';
COMMENT ON COLUMN "msg_contact_info"."contact_name" IS '联系人名称';
COMMENT ON COLUMN "msg_contact_info"."send_type" IS '发送方式';
COMMENT ON COLUMN "msg_contact_info"."tag_name" IS '标签';
COMMENT ON COLUMN "msg_contact_info"."receive_address" IS '通讯地址';
COMMENT ON COLUMN "msg_contact_info"."channel_no" IS '通道标识';
COMMENT ON COLUMN "msg_contact_info"."contact_id_and_type" IS '联系人标识+类型';
COMMENT ON COLUMN "msg_contact_info"."msg_order" IS '排序字段';
COMMENT ON COLUMN "msg_contact_info"."creator" IS '创建人';
COMMENT ON COLUMN "msg_contact_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_contact_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_contact_info"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "msg_contact_info" IS '联系人通讯信息表';

-- ----------------------------
-- Records of MSG_CONTACT_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_CP_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_cp_channel";
CREATE TABLE "msg_cp_channel" (
  "channel_id" int8 NOT NULL,
  "channel_no" varchar(64),
  "channel_name" varchar(64),
  "corpid" varchar(64),
  "corp_name" varchar(64),
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "agent_id" varchar(64),
  "agent_name" varchar(64),
  "agent_secret" varchar(192)
)
;
COMMENT ON COLUMN "msg_cp_channel"."channel_id" IS '通道id';
COMMENT ON COLUMN "msg_cp_channel"."channel_no" IS '企业微信标识';
COMMENT ON COLUMN "msg_cp_channel"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_cp_channel"."corpid" IS '企业微信id';
COMMENT ON COLUMN "msg_cp_channel"."corp_name" IS '企业名称';
COMMENT ON COLUMN "msg_cp_channel"."open_status" IS '启用/禁用标识:0禁用；1启用';
COMMENT ON COLUMN "msg_cp_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_cp_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_cp_channel"."creator" IS '创建人';
COMMENT ON COLUMN "msg_cp_channel"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_cp_channel"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_cp_channel"."del_flag" IS '删除标识:0正常;1已删除';
COMMENT ON COLUMN "msg_cp_channel"."agent_id" IS '应用id';
COMMENT ON COLUMN "msg_cp_channel"."agent_name" IS '应用名称';
COMMENT ON COLUMN "msg_cp_channel"."agent_secret" IS '企业微信应用密钥';
COMMENT ON TABLE "msg_cp_channel" IS '企业微信通道表';

-- ----------------------------
-- Records of MSG_CP_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_cp_channel" ("channel_id", "channel_no", "channel_name", "corpid", "corp_name", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag", "agent_id", "agent_name", "agent_secret") VALUES (1, 'CPC230310tjk34V9E30815', '轻骑兵示例通道', 'XXXXXXXXXXXXX', '轻骑兵示例企业', 1, '无', '2023-03-10 14:05:04', 1450756958461300737, '2023-03-10 14:05:03', NULL, '0', '1', '轻骑兵示例应用', 'XXXXXXXXXXXXX');
COMMIT;

-- ----------------------------
-- Table structure for MSG_CP_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_cp_send_record";
CREATE TABLE "msg_cp_send_record" (
  "msg_cp_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "url" varchar(255),
  "cp_params" text,
  "enable_duplicate_check" int2,
  "duplicate_check_interval" int4,
  "message_type" varchar(128),
  "to_user" varchar(1024),
  "content" varchar(4000),
  "corp_id" varchar(255),
  "corp_name" varchar(255),
  "agent_name" varchar(255),
  "agent_id" varchar(64),
  "agent_secret" varchar(255),
  "msg_type" varchar(64),
  "status" int4,
  "err_msg" varchar(4000),
  "send_time" timestamp without time zone,
  "create_date" varchar(64),
  "create_time" timestamp without time zone,
  "tim" int2,
  "job_time" timestamp without time zone,
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "scene_name" varchar(255),
  "scene_code" varchar(32),
  "msg_id" varchar(32)
)
;
COMMENT ON COLUMN "msg_cp_send_record"."msg_cp_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_cp_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_cp_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_cp_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_cp_send_record"."template_no" IS '模版标识';
COMMENT ON COLUMN "msg_cp_send_record"."template_name" IS '模版名称';
COMMENT ON COLUMN "msg_cp_send_record"."title" IS '标题';
COMMENT ON COLUMN "msg_cp_send_record"."url" IS '点击后跳转的链接';
COMMENT ON COLUMN "msg_cp_send_record"."cp_params" IS 'CP的模版参数';
COMMENT ON COLUMN "msg_cp_send_record"."enable_duplicate_check" IS '是否开启重复消息检查';
COMMENT ON COLUMN "msg_cp_send_record"."duplicate_check_interval" IS '重复消息检查的时间间隔';
COMMENT ON COLUMN "msg_cp_send_record"."message_type" IS '消息类型，text：文本消息，textcard：文本卡片消息，markdown：Markdown消息';
COMMENT ON COLUMN "msg_cp_send_record"."to_user" IS '接收用户';
COMMENT ON COLUMN "msg_cp_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_cp_send_record"."corp_id" IS '企业微信标识';
COMMENT ON COLUMN "msg_cp_send_record"."corp_name" IS '企业名称';
COMMENT ON COLUMN "msg_cp_send_record"."agent_name" IS '企业微信应用名称';
COMMENT ON COLUMN "msg_cp_send_record"."agent_id" IS '企业微信应用标识';
COMMENT ON COLUMN "msg_cp_send_record"."agent_secret" IS '企业微信应用密钥';
COMMENT ON COLUMN "msg_cp_send_record"."msg_type" IS '消息类型';
COMMENT ON COLUMN "msg_cp_send_record"."status" IS '发送状态 1：发送中。2：发送失败。3：发送成功';
COMMENT ON COLUMN "msg_cp_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_cp_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_cp_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_cp_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_cp_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_cp_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_cp_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_cp_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_cp_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_cp_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_cp_send_record"."scene_code" IS '场景编码';
COMMENT ON COLUMN "msg_cp_send_record"."msg_id" IS '消息ID';
COMMENT ON TABLE "msg_cp_send_record" IS '消息中心企业微信发送记录';

-- ----------------------------
-- Records of MSG_CP_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_CP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_cp_template";
CREATE TABLE "msg_cp_template" (
  "cp_template_id" int8 NOT NULL,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "content" text,
  "url" varchar(255),
  "template_params" text,
  "remark" varchar(255),
  "enable_duplicate_check" int2,
  "duplicate_check_interval" int4,
  "open_status" int4,
  "message_type" varchar(128),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_cp_template"."cp_template_id" IS '主键';
COMMENT ON COLUMN "msg_cp_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_cp_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_cp_template"."title" IS '标题';
COMMENT ON COLUMN "msg_cp_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_cp_template"."url" IS '点击后跳转的链接';
COMMENT ON COLUMN "msg_cp_template"."template_params" IS '模板参数';
COMMENT ON COLUMN "msg_cp_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_cp_template"."enable_duplicate_check" IS '是否开启重复消息检查';
COMMENT ON COLUMN "msg_cp_template"."duplicate_check_interval" IS '重复消息检查的时间间隔';
COMMENT ON COLUMN "msg_cp_template"."open_status" IS '状态 0：禁用。 1：启用。';
COMMENT ON COLUMN "msg_cp_template"."message_type" IS '消息类型，text：文本消息，textcard：文本卡片消息，markdown：Markdown消息';
COMMENT ON COLUMN "msg_cp_template"."creator" IS '创建人';
COMMENT ON COLUMN "msg_cp_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_cp_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_cp_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_cp_template"."del_flag" IS '删除标识，1删除';
COMMENT ON TABLE "msg_cp_template" IS '企业微信推送模板表';

-- ----------------------------
-- Records of MSG_CP_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820261541030141952, 'CPT240313xPYSnZcG94761', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 'processName,expType,processKey,taskKey,taskName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:46:31', 1450756958461300737, '2024-03-13 11:47:02', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820262208016752640, 'CPT240313ySq1XPAm46958', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 'currentTime,processName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:49:10', 1450756958461300737, '2024-03-13 11:49:10', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820262744644395008, 'CPT240313zQdeei4i52826', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 'currentTime,processName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:51:18', 1450756958461300737, '2024-03-13 11:51:18', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820262832712196096, 'CPT240313x9yRpKFt28331', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 'currentTime,processName,taskName', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:51:39', 1450756958461300737, '2024-03-13 11:51:39', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820262936533803008, 'CPT2403131Ekz6NYL00066', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 'currentTime,processName,startTime,endTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:04', 1450756958461300737, '2024-03-13 11:52:04', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263044105117696, 'CPT240313g17inv1a22864', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 'processName,currentTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:29', 1450756958461300737, '2024-03-13 11:52:29', '0');
INSERT INTO "msg_cp_template" ("cp_template_id", "template_no", "template_name", "title", "content", "url", "template_params", "remark", "enable_duplicate_check", "duplicate_check_interval", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263104620535808, 'CPT240313fHPmQNk287578', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 'processName,currentTime', NULL, 0, NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:52:44', 1450756958461300737, '2024-03-13 11:52:44', '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_DINGTALK_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_dingtalk_channel";
CREATE TABLE "msg_dingtalk_channel" (
  "channel_id" int8 NOT NULL,
  "channel_no" varchar(64),
  "channel_name" varchar(192),
  "corp_name" varchar(192),
  "app_name" varchar(64),
  "app_secret" varchar(128),
  "agent_id" varchar(32),
  "open_status" int4,
  "remark" varchar(256),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "app_key" varchar(64)
)
;
COMMENT ON COLUMN "msg_dingtalk_channel"."channel_id" IS '通道id';
COMMENT ON COLUMN "msg_dingtalk_channel"."channel_no" IS '通道标识';
COMMENT ON COLUMN "msg_dingtalk_channel"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_dingtalk_channel"."corp_name" IS '企业名称';
COMMENT ON COLUMN "msg_dingtalk_channel"."app_name" IS '钉钉应用名称';
COMMENT ON COLUMN "msg_dingtalk_channel"."app_secret" IS '钉钉应用密钥';
COMMENT ON COLUMN "msg_dingtalk_channel"."agent_id" IS '钉钉应用id';
COMMENT ON COLUMN "msg_dingtalk_channel"."open_status" IS '启用/禁用状态';
COMMENT ON COLUMN "msg_dingtalk_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_dingtalk_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_dingtalk_channel"."creator" IS '创建人';
COMMENT ON COLUMN "msg_dingtalk_channel"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_dingtalk_channel"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_dingtalk_channel"."del_flag" IS '删除标识';
COMMENT ON COLUMN "msg_dingtalk_channel"."app_key" IS '钉钉应用KEY';
COMMENT ON TABLE "msg_dingtalk_channel" IS '钉钉通道表';

-- ----------------------------
-- Records of MSG_DINGTALK_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_dingtalk_channel" ("channel_id", "channel_no", "channel_name", "corp_name", "app_name", "app_secret", "agent_id", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag", "app_key") VALUES (1, 'DINGTALK23041113Z3qHCp55143', '轻骑兵示例通道', '轻骑兵示例企业', '轻骑兵示例应用', 'XXXXXXXXXXXXX', '12345678', 1, '', '2023-04-11 09:20:21', 1450756958461300737, '2023-04-11 09:34:07', 1450756958461300737, '0', 'XXXXXXXXXXXXX');
COMMIT;

-- ----------------------------
-- Table structure for MSG_DING_TALK_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_ding_talk_send_record";
CREATE TABLE "msg_ding_talk_send_record" (
  "msg_ding_talk_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "btn_json_list" varchar(1000),
  "btn_orientation" char(1),
  "single_title" varchar(128),
  "single_url" varchar(255),
  "ding_talk_params" text,
  "message_type" varchar(128),
  "to_user" varchar(1024),
  "content" varchar(4000),
  "corp_name" varchar(255),
  "app_name" varchar(255),
  "agent_id" varchar(64),
  "app_secret" varchar(255),
  "app_key" varchar(255),
  "msg_type" varchar(64),
  "status" int4,
  "err_msg" varchar(4000),
  "send_time" timestamp without time zone,
  "create_date" varchar(64),
  "create_time" timestamp without time zone,
  "tim" int2,
  "job_time" timestamp without time zone,
  "app_id" varchar(64),
  "ding_app_name" varchar(255),
  "ding_app_secret" varchar(255),
  "scene_name" varchar(255),
  "scene_code" varchar(32),
  "msg_id" varchar(32)
)
;
COMMENT ON COLUMN "msg_ding_talk_send_record"."msg_ding_talk_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_ding_talk_send_record"."channel_id" IS '通道id';
COMMENT ON COLUMN "msg_ding_talk_send_record"."channel_no" IS '通道编码';
COMMENT ON COLUMN "msg_ding_talk_send_record"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_ding_talk_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."title" IS '标题';
COMMENT ON COLUMN "msg_ding_talk_send_record"."btn_json_list" IS '卡片消息时，按钮标题和点击跳转地址';
COMMENT ON COLUMN "msg_ding_talk_send_record"."btn_orientation" IS '按钮排列方式: 0：竖直排列 1：横向排列';
COMMENT ON COLUMN "msg_ding_talk_send_record"."single_title" IS 'single卡片下标题';
COMMENT ON COLUMN "msg_ding_talk_send_record"."single_url" IS 'single卡片下标题跳转地址';
COMMENT ON COLUMN "msg_ding_talk_send_record"."ding_talk_params" IS 'dingTalk模版参数';
COMMENT ON COLUMN "msg_ding_talk_send_record"."message_type" IS '消息类型，text：文本消息，action_card_single：卡片消息（子标题），action_card_btn：卡片消息（按钮），markdown：Markdown消息';
COMMENT ON COLUMN "msg_ding_talk_send_record"."to_user" IS '接收用户';
COMMENT ON COLUMN "msg_ding_talk_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_ding_talk_send_record"."corp_name" IS '企业名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."app_name" IS '钉钉应用名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."agent_id" IS '钉钉应用标识';
COMMENT ON COLUMN "msg_ding_talk_send_record"."app_secret" IS '钉钉应用密钥';
COMMENT ON COLUMN "msg_ding_talk_send_record"."app_key" IS 'appKey';
COMMENT ON COLUMN "msg_ding_talk_send_record"."msg_type" IS '消息类型';
COMMENT ON COLUMN "msg_ding_talk_send_record"."status" IS '发送状态 1：发送中。2：发送失败。3：发送成功';
COMMENT ON COLUMN "msg_ding_talk_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_ding_talk_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_ding_talk_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_ding_talk_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_ding_talk_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_ding_talk_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_ding_talk_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_ding_talk_send_record"."ding_app_name" IS '应用名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."ding_app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_ding_talk_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_ding_talk_send_record"."scene_code" IS '场景编码';
COMMENT ON COLUMN "msg_ding_talk_send_record"."msg_id" IS '消息ID';
COMMENT ON TABLE "msg_ding_talk_send_record" IS '消息中心钉钉发送记录';

-- ----------------------------
-- Records of MSG_DING_TALK_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_DING_TALK_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_ding_talk_template";
CREATE TABLE "msg_ding_talk_template" (
  "ding_talk_template_id" int8 NOT NULL,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "content" text,
  "btn_json_list" varchar(1000),
  "btn_orientation" char(1),
  "single_title" varchar(128),
  "single_url" varchar(255),
  "template_params" text,
  "remark" varchar(255),
  "open_status" int4,
  "message_type" varchar(128),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_ding_talk_template"."ding_talk_template_id" IS '主键';
COMMENT ON COLUMN "msg_ding_talk_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_ding_talk_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_ding_talk_template"."title" IS '标题';
COMMENT ON COLUMN "msg_ding_talk_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_ding_talk_template"."btn_json_list" IS '卡片消息时，按钮标题和点击跳转地址';
COMMENT ON COLUMN "msg_ding_talk_template"."btn_orientation" IS '卡片消息时，按钮标题和点击跳转地址';
COMMENT ON COLUMN "msg_ding_talk_template"."single_title" IS 'single卡片下标题';
COMMENT ON COLUMN "msg_ding_talk_template"."single_url" IS 'single卡片下标题跳转地址';
COMMENT ON COLUMN "msg_ding_talk_template"."template_params" IS '模板参数';
COMMENT ON COLUMN "msg_ding_talk_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_ding_talk_template"."open_status" IS '状态 0：禁用。 1：启用。';
COMMENT ON COLUMN "msg_ding_talk_template"."message_type" IS '消息类型，text：文本消息，action_card_single：卡片消息（按钮），action_card_btn：卡片消息（按钮），markdown：Markdown消息';
COMMENT ON COLUMN "msg_ding_talk_template"."creator" IS '创建人';
COMMENT ON COLUMN "msg_ding_talk_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_ding_talk_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_ding_talk_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_ding_talk_template"."del_flag" IS '删除标识，1删除';
COMMENT ON TABLE "msg_ding_talk_template" IS '钉钉推送模板表';

-- ----------------------------
-- Records of MSG_DING_TALK_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263212330262528, 'DINGTALKT240313SjW5sjcS80369', '流程异常提醒', '', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, NULL, NULL, NULL, 'processName,expType,processKey,taskKey,taskName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:10', 1450756958461300737, '2024-03-13 11:53:10', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263279778865152, 'DINGTALKT240313DfjAutzt03959', '流程待办提醒', '', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:26', 1450756958461300737, '2024-03-13 11:53:26', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263366026338304, 'DINGTALKT2403133LrM2V8M88003', '流程驳回提醒', '', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:53:46', 1450756958461300737, '2024-03-13 11:53:46', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263427544195072, 'DINGTALKT24031309RZLURF04157', '流程催办提醒', '', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName,taskName', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:01', 1450756958461300737, '2024-03-13 11:54:01', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263498000113664, 'DINGTALKT240313RKPCXmnf66552', '流程委托提醒', '', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, NULL, NULL, NULL, 'currentTime,processName,startTime,endTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:18', 1450756958461300737, '2024-03-13 11:54:18', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263579810013184, 'DINGTALKT240313mg6oHZgA18501', '流程完成提醒', '', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, NULL, NULL, NULL, 'processName,currentTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:37', 1450756958461300737, '2024-03-13 11:54:37', '0');
INSERT INTO "msg_ding_talk_template" ("ding_talk_template_id", "template_no", "template_name", "title", "content", "btn_json_list", "btn_orientation", "single_title", "single_url", "template_params", "remark", "open_status", "message_type", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820263640468037632, 'DINGTALKT240313WCspHRt714521', '流程终止提醒', '', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, NULL, NULL, NULL, 'processName,currentTime', NULL, 1, 'text', 1450756958461300737, '2024-03-13 11:54:52', 1450756958461300737, '2024-03-13 11:54:52', '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_MAIL_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_mail_channel";
CREATE TABLE "msg_mail_channel" (
  "mail_channel_id" int8 NOT NULL,
  "channel_name" varchar(255),
  "mail_address" varchar(255),
  "mail_protocol" int4,
  "mail_password" varchar(255),
  "sender_name" varchar(255),
  "mail_server_address" varchar(255),
  "mail_port" varchar(255),
  "safe_type" int4,
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "channel_no" varchar(50)
)
;
COMMENT ON COLUMN "msg_mail_channel"."mail_channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_mail_channel"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_mail_channel"."mail_address" IS '邮箱地址';
COMMENT ON COLUMN "msg_mail_channel"."mail_protocol" IS '邮箱协议(1:SMTP 2:EXCHANGE)';
COMMENT ON COLUMN "msg_mail_channel"."mail_password" IS '邮箱密码';
COMMENT ON COLUMN "msg_mail_channel"."sender_name" IS '发送人名称';
COMMENT ON COLUMN "msg_mail_channel"."mail_server_address" IS '邮箱服务器地址';
COMMENT ON COLUMN "msg_mail_channel"."mail_port" IS '邮箱端口';
COMMENT ON COLUMN "msg_mail_channel"."safe_type" IS '安全类型（1:SSL 2：STARTTLS）';
COMMENT ON COLUMN "msg_mail_channel"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_mail_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_mail_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mail_channel"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mail_channel"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mail_channel"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mail_channel"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON COLUMN "msg_mail_channel"."channel_no" IS '公众号标识';
COMMENT ON TABLE "msg_mail_channel" IS '邮箱通道';

-- ----------------------------
-- Records of MSG_MAIL_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_mail_channel" ("mail_channel_id", "channel_name", "mail_address", "mail_protocol", "mail_password", "sender_name", "mail_server_address", "mail_port", "safe_type", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag", "channel_no") VALUES (2, '轻骑兵163邮箱信道', 'hussar_base_2022@163.com', 1, 'XXXXXXXXXXXXX', '轻骑兵', 'smtp.163.com', '465', 1, 1, NULL, '2022-05-09 17:53:24', NULL, '2022-08-30 11:18:35', 1450756958461300737, '0', 'MAILC2206180000140');
COMMIT;

-- ----------------------------
-- Table structure for MSG_MAIL_GROUP
-- ----------------------------
DROP TABLE IF EXISTS "msg_mail_group";
CREATE TABLE "msg_mail_group" (
  "mail_group_id" int8 NOT NULL,
  "group_name" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_mail_group"."mail_group_id" IS '分组id';
COMMENT ON COLUMN "msg_mail_group"."group_name" IS '分组名称';
COMMENT ON COLUMN "msg_mail_group"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mail_group"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mail_group"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mail_group"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mail_group"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_mail_group" IS '邮箱分组';

-- ----------------------------
-- Records of MSG_MAIL_GROUP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_MAIL_RECIVER
-- ----------------------------
DROP TABLE IF EXISTS "msg_mail_reciver";
CREATE TABLE "msg_mail_reciver" (
  "mail_reciver_id" int8 NOT NULL,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "reciver_name" varchar(255),
  "reciver_mail" varchar(255),
  "remark" varchar(255),
  "group_name" varchar(255),
  "group_id" int8
)
;
COMMENT ON COLUMN "msg_mail_reciver"."mail_reciver_id" IS '收件人ID';
COMMENT ON COLUMN "msg_mail_reciver"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mail_reciver"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mail_reciver"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mail_reciver"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mail_reciver"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON COLUMN "msg_mail_reciver"."reciver_name" IS '收件人姓名';
COMMENT ON COLUMN "msg_mail_reciver"."reciver_mail" IS '收件人邮箱';
COMMENT ON COLUMN "msg_mail_reciver"."remark" IS '说明';
COMMENT ON COLUMN "msg_mail_reciver"."group_name" IS '分组名称';
COMMENT ON COLUMN "msg_mail_reciver"."group_id" IS '分组ID';
COMMENT ON TABLE "msg_mail_reciver" IS '邮箱接收人管理表';

-- ----------------------------
-- Records of MSG_MAIL_RECIVER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_MAIL_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_mail_send_record";
CREATE TABLE "msg_mail_send_record" (
  "msg_mail_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "mail_address" varchar(255),
  "mail_protocol" int4,
  "mail_password" varchar(255),
  "sender_name" varchar(255),
  "mail_server_address" varchar(255),
  "mail_port" varchar(64),
  "safe_type" int4,
  "mail_template_id" int8,
  "template_no" varchar(64),
  "template_name" varchar(255),
  "reciver_name" varchar(255),
  "reciver_mail" varchar(255),
  "mail_content" varchar(4000),
  "mail_subject" varchar(255),
  "file_ids" varchar(1024),
  "gropu_ids" int8,
  "reciver_id" int8,
  "cc" varchar(255),
  "is_bath" int2,
  "mail_params" varchar(1024),
  "tim" int2,
  "job_time" timestamp without time zone,
  "status" int4,
  "err_msg" varchar(4000),
  "create_time" timestamp without time zone,
  "send_time" timestamp without time zone,
  "create_date" varchar(64),
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "scene_name" varchar(32),
  "scene_code" varchar(32)
)
;
COMMENT ON COLUMN "msg_mail_send_record"."msg_mail_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_mail_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_mail_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_mail_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_mail_send_record"."mail_address" IS '邮箱地址';
COMMENT ON COLUMN "msg_mail_send_record"."mail_protocol" IS '邮箱协议：1SMTP；2EXCHANGE';
COMMENT ON COLUMN "msg_mail_send_record"."mail_password" IS '邮箱密码';
COMMENT ON COLUMN "msg_mail_send_record"."sender_name" IS '发件人名称';
COMMENT ON COLUMN "msg_mail_send_record"."mail_server_address" IS '邮箱服务器地址';
COMMENT ON COLUMN "msg_mail_send_record"."mail_port" IS '邮箱端口';
COMMENT ON COLUMN "msg_mail_send_record"."safe_type" IS '安全类型：1SSL；2STARTTLS';
COMMENT ON COLUMN "msg_mail_send_record"."mail_template_id" IS '邮件模板ID';
COMMENT ON COLUMN "msg_mail_send_record"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_mail_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_mail_send_record"."reciver_name" IS '收件人名称';
COMMENT ON COLUMN "msg_mail_send_record"."reciver_mail" IS '收件人邮箱';
COMMENT ON COLUMN "msg_mail_send_record"."mail_content" IS '邮件内容';
COMMENT ON COLUMN "msg_mail_send_record"."mail_subject" IS '邮件主题';
COMMENT ON COLUMN "msg_mail_send_record"."file_ids" IS '附件ids,多个用逗号分隔';
COMMENT ON COLUMN "msg_mail_send_record"."gropu_ids" IS '组id';
COMMENT ON COLUMN "msg_mail_send_record"."reciver_id" IS '收件人ID';
COMMENT ON COLUMN "msg_mail_send_record"."cc" IS '抄送人';
COMMENT ON COLUMN "msg_mail_send_record"."is_bath" IS '是否批量';
COMMENT ON COLUMN "msg_mail_send_record"."mail_params" IS '邮件参数';
COMMENT ON COLUMN "msg_mail_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_mail_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_mail_send_record"."status" IS '发送状态 1：未发送，2：发送失败，3：发送成功';
COMMENT ON COLUMN "msg_mail_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_mail_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mail_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_mail_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_mail_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_mail_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_mail_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_mail_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_mail_send_record"."scene_code" IS '场景编码';
COMMENT ON TABLE "msg_mail_send_record" IS '消息中心邮件发送记录';

-- ----------------------------
-- Records of MSG_MAIL_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for msg_mail_template
-- ----------------------------
DROP TABLE IF EXISTS "msg_mail_template";
CREATE TABLE "msg_mail_template" (
  "mail_template_id" NUMERIC(20) NOT NULL,
  "channel_id" NUMERIC(20) NULL DEFAULT NULL,
  "template_no" VARCHAR(150) NULL DEFAULT NULL,
  "template_name" VARCHAR(384) NULL DEFAULT NULL,
  "mail_subject" VARCHAR(384) NULL DEFAULT NULL,
  "template_content" TEXT NULL DEFAULT NULL,
  "remark" VARCHAR(765) NULL DEFAULT NULL,
  "open_status" NUMERIC(10) NULL DEFAULT NULL,
  "create_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "creator" NUMERIC(20) NULL DEFAULT NULL,
  "last_time" TIMESTAMP WITHOUT TIME ZONE NULL DEFAULT NULL,
  "last_editor" NUMERIC(20) NULL DEFAULT NULL,
  "del_flag" CHAR(1) NULL DEFAULT NULL,
  "file_ids" VARCHAR(765) NULL DEFAULT NULL,
  "template_params" VARCHAR(765) NULL DEFAULT NULL
)
;
COMMENT ON COLUMN "msg_mail_template"."mail_template_id" IS '模板ID';
COMMENT ON COLUMN "msg_mail_template"."channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_mail_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_mail_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_mail_template"."template_content" IS '模板内容';
COMMENT ON COLUMN "msg_mail_template"."mail_subject" IS '邮件主题';
COMMENT ON COLUMN "msg_mail_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_mail_template"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_mail_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mail_template"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mail_template"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mail_template"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mail_template"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON COLUMN "msg_mail_template"."template_params" IS '模板参数';
COMMENT ON TABLE "msg_mail_template" IS '邮箱模板';

-- ----------------------------
-- Records of MSG_MAIL_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624171659833901238, NULL, 'MAILT2206210000154', '流程待办提醒', '待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, '2022-06-21 10:07:40', NULL, '2022-06-21 10:07:40', NULL, '0', NULL, 'currentTime,processName');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624171659833909248, NULL, 'MAILT220919AAS3qozY11174', '流程驳回提醒', '驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, '2022-09-19 09:15:20', 1450756958461300737, '2022-09-19 09:15:20', NULL, '0', NULL, 'currentTime,processName');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624171810195513344, NULL, 'MAILT220919JmKL4FNg49717', '流程催办提醒', '催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, '2022-09-19 09:15:56', 1450756958461300737, '2022-09-19 09:15:56', NULL, '0', NULL, 'currentTime,processName,taskName');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624171921201963008, NULL, 'MAILT220919l56aADks17501', '流程委托提醒', '委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, '2022-09-19 09:16:23', 1450756958461300737, '2022-09-19 09:16:22', NULL, '0', NULL, 'currentTime,processName,startTime,endTime');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624172132531970048, NULL, 'MAILT220919bGCjleJO70191', '流程完成提醒', '完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, '2022-09-19 09:17:13', 1450756958461300737, '2022-09-19 09:17:12', NULL, '0', NULL, 'processName,currentTime');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (624172273125040128, NULL, 'MAILT220919HzpMkf9J91595', '流程终止提醒', '终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, '2022-09-19 09:17:46', 1450756958461300737, '2022-09-19 09:17:46', NULL, '0', NULL, 'processName,currentTime');
INSERT INTO "msg_mail_template" ("mail_template_id", "channel_id", "template_no", "template_name", "mail_subject", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag", "file_ids", "template_params") VALUES (653554652889227264, NULL, 'MAILT221209sx0JH2vc45290', '流程异常提醒', '异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, '2022-12-15 14:47:32', NULL, '2022-12-15 14:47:32', NULL, '0', NULL, 'processName,expType,processKey,taskKey,taskName');
COMMIT;

-- ----------------------------
-- Table structure for MSG_MP_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_mp_channel";
CREATE TABLE "msg_mp_channel" (
  "mp_channel_id" int8 NOT NULL,
  "channel_no" varchar(50),
  "channel_name" varchar(128),
  "key_id" varchar(128),
  "key_secret" varchar(128),
  "token" varchar(255),
  "aeskey" varchar(255),
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_mp_channel"."mp_channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_mp_channel"."channel_no" IS '公众号标识';
COMMENT ON COLUMN "msg_mp_channel"."channel_name" IS '公众号名称';
COMMENT ON COLUMN "msg_mp_channel"."key_id" IS 'KEY_ID';
COMMENT ON COLUMN "msg_mp_channel"."key_secret" IS 'KEY_SECRET';
COMMENT ON COLUMN "msg_mp_channel"."token" IS 'TOKEN';
COMMENT ON COLUMN "msg_mp_channel"."aeskey" IS 'EncodingAESKey';
COMMENT ON COLUMN "msg_mp_channel"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_mp_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_mp_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mp_channel"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mp_channel"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mp_channel"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mp_channel"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_mp_channel" IS '公众号通道';

-- ----------------------------
-- Records of MSG_MP_CHANNEL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_MP_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_mp_send_record";
CREATE TABLE "msg_mp_send_record" (
  "msg_mp_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "channel_no" varchar(64),
  "channel_name" varchar(255),
  "template_id" int8,
  "template_no" varchar(64),
  "template_name" varchar(255),
  "template_biz_id" varchar(255),
  "to_user" varchar(255),
  "url" varchar(255),
  "content" varchar(4000),
  "key_id" varchar(64),
  "key_secret" varchar(255),
  "token" varchar(255),
  "aeskey" varchar(255),
  "status" int4,
  "err_msg" varchar(64),
  "create_date" varchar(64),
  "create_time" timestamp without time zone,
  "send_time" timestamp without time zone,
  "creator" int8,
  "tim" int2,
  "job_time" timestamp without time zone,
  "msg_id" varchar(64),
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "scene_name" varchar(32),
  "scene_code" varchar(32)
)
;
COMMENT ON COLUMN "msg_mp_send_record"."msg_mp_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_mp_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_mp_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_mp_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_mp_send_record"."template_id" IS '模板ID';
COMMENT ON COLUMN "msg_mp_send_record"."template_no" IS '模板编号';
COMMENT ON COLUMN "msg_mp_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_mp_send_record"."template_biz_id" IS '模板业务ID';
COMMENT ON COLUMN "msg_mp_send_record"."to_user" IS '接收用户';
COMMENT ON COLUMN "msg_mp_send_record"."url" IS '跳转链接';
COMMENT ON COLUMN "msg_mp_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_mp_send_record"."key_id" IS '密钥ID';
COMMENT ON COLUMN "msg_mp_send_record"."key_secret" IS '密钥密码';
COMMENT ON COLUMN "msg_mp_send_record"."token" IS 'token';
COMMENT ON COLUMN "msg_mp_send_record"."aeskey" IS '编码AESKey';
COMMENT ON COLUMN "msg_mp_send_record"."status" IS '发送状态 1：发送中。2：发送失败。3：发送成功';
COMMENT ON COLUMN "msg_mp_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_mp_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_mp_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mp_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_mp_send_record"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mp_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_mp_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_mp_send_record"."msg_id" IS '消息记录id';
COMMENT ON COLUMN "msg_mp_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_mp_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_mp_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_mp_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_mp_send_record"."scene_code" IS '场景编码';
COMMENT ON TABLE "msg_mp_send_record" IS '消息中心微信公众号发送记录';

-- ----------------------------
-- Records of MSG_MP_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_MP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_mp_template";
CREATE TABLE "msg_mp_template" (
  "mp_template_id" int8 NOT NULL,
  "channel_id" int8,
  "template_no" varchar(50),
  "template_name" varchar(128),
  "template_biz_id" varchar(128),
  "title" varchar(255),
  "content" varchar(1000),
  "example" varchar(2000),
  "open_status" int4,
  "remark" varchar(255),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_mp_template"."mp_template_id" IS '通道ID';
COMMENT ON COLUMN "msg_mp_template"."channel_id" IS '公众号ID';
COMMENT ON COLUMN "msg_mp_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_mp_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_mp_template"."template_biz_id" IS '模板业务ID';
COMMENT ON COLUMN "msg_mp_template"."title" IS '模板标题';
COMMENT ON COLUMN "msg_mp_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_mp_template"."example" IS '模板示例';
COMMENT ON COLUMN "msg_mp_template"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_mp_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_mp_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_mp_template"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_mp_template"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_mp_template"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_mp_template"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_mp_template" IS '公众号模板';

-- ----------------------------
-- Records of MSG_MP_TEMPLATE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_NOTICE_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_notice_send_record" CASCADE;
CREATE TABLE "msg_notice_send_record" (
  "msg_notice_send_record_id" NUMERIC(20)  NOT NULL,
  "notice_type_id" NUMERIC(20)  NULL DEFAULT NULL,
  "notice_title" VARCHAR(765)  NULL DEFAULT NULL,
  "approver_id" NUMERIC(20)  NULL DEFAULT NULL,
  "release_date" TIMESTAMP  NULL DEFAULT NULL,
  "create_time" TIMESTAMP  NULL DEFAULT NULL,
  "notice_content" VARCHAR(4000)  NULL DEFAULT NULL,
  "department_id" TEXT  NULL DEFAULT NULL,
  "role_id" TEXT  NULL DEFAULT NULL,
  "creatoe_department_id" NUMERIC(20)  NULL DEFAULT NULL,
  "notice_issue" VARCHAR(192)  NULL DEFAULT NULL,
  "creator" NUMERIC(20)  NULL DEFAULT NULL,
  "dept_role_name" TEXT  NULL DEFAULT NULL,
  "create_date_not_hour" VARCHAR(192)  NULL DEFAULT NULL,
  "release_date_not_hour" VARCHAR(192)  NULL DEFAULT NULL,
  "status" NUMERIC(10)  NULL DEFAULT NULL,
  "send_time" TIMESTAMP  NULL DEFAULT NULL,
  "err_msg" VARCHAR(4000)  NULL DEFAULT NULL,
  "app_id" VARCHAR(192)  NULL DEFAULT NULL,
  "app_name" VARCHAR(765)  NULL DEFAULT NULL,
  "app_secret" VARCHAR(765)  NULL DEFAULT NULL,
  "scene_code" VARCHAR(96)  NULL DEFAULT NULL,
  "scene_name" VARCHAR(96)  NULL DEFAULT NULL,
  "template_no" VARCHAR(192)  NULL DEFAULT NULL,
  "template_name" VARCHAR(384)  NULL DEFAULT NULL,
  "notice_params" TEXT  NULL DEFAULT NULL
);
COMMENT ON COLUMN "msg_notice_send_record"."msg_notice_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_notice_send_record"."notice_type_id" IS '通知类型ID';
COMMENT ON COLUMN "msg_notice_send_record"."notice_title" IS '通知标题';
COMMENT ON COLUMN "msg_notice_send_record"."approver_id" IS '审批人ID';
COMMENT ON COLUMN "msg_notice_send_record"."release_date" IS '发布日期';
COMMENT ON COLUMN "msg_notice_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_notice_send_record"."notice_content" IS '通知内容';
COMMENT ON COLUMN "msg_notice_send_record"."department_id" IS '部门ID';
COMMENT ON COLUMN "msg_notice_send_record"."role_id" IS '角色ID';
COMMENT ON COLUMN "msg_notice_send_record"."creatoe_department_id" IS '创建者部门ID';
COMMENT ON COLUMN "msg_notice_send_record"."notice_issue" IS '通知发布人';
COMMENT ON COLUMN "msg_notice_send_record"."creator" IS '公告创建者(ID)';
COMMENT ON COLUMN "msg_notice_send_record"."dept_role_name" IS '部门角色名称';
COMMENT ON COLUMN "msg_notice_send_record"."create_date_not_hour" IS '创建日期（不含小时）';
COMMENT ON COLUMN "msg_notice_send_record"."release_date_not_hour" IS '发布日期YYYY-MM-DD';
COMMENT ON COLUMN "msg_notice_send_record"."status" IS '发送状态 1:发送中 2：发送失败。 3：发送成功。';
COMMENT ON COLUMN "msg_notice_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_notice_send_record"."err_msg" IS '错误信息';
COMMENT ON COLUMN "msg_notice_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_notice_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_notice_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_notice_send_record"."scene_code" IS '场景编码';
COMMENT ON COLUMN "msg_notice_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_notice_send_record"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_notice_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_notice_send_record"."notice_params" IS 'notice模版参数';
COMMENT ON TABLE "msg_notice_send_record" IS '消息中心内部通知发送记录';

-- ----------------------------
-- Records of MSG_NOTICE_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_NOTICE_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_notice_template";
CREATE TABLE "msg_notice_template" (
  "notice_template_id" int8 NOT NULL,
  "template_no" varchar(64),
  "template_name" varchar(128),
  "title" varchar(128),
  "content" text,
  "open_status" int4,
  "remark" varchar(255),
  "template_params" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_notice_template"."notice_template_id" IS '模板主键ID';
COMMENT ON COLUMN "msg_notice_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_notice_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_notice_template"."title" IS '标题';
COMMENT ON COLUMN "msg_notice_template"."content" IS '模板内容';
COMMENT ON COLUMN "msg_notice_template"."open_status" IS '启用状态 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_notice_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_notice_template"."template_params" IS '模板参数';
COMMENT ON COLUMN "msg_notice_template"."creator" IS '创建人';
COMMENT ON COLUMN "msg_notice_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_notice_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_notice_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "msg_notice_template"."del_flag" IS '删除标识，1删除';
COMMENT ON TABLE "msg_notice_template" IS '内部通知推送模板表';

-- ----------------------------
-- Records of MSG_NOTICE_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260723249913856, 'NOTICET240313Nj2H0FqW96127', '流程异常提醒', '异常提醒', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', 1, NULL, 'processName,expType,processKey,taskKey,taskName', 1450756958461300737, '2024-03-13 11:43:16', 1450756958461300737, '2024-03-13 11:43:16', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260799313616896, 'NOTICET240313KIeE4dj376383', '流程待办提醒', '待办提醒', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:43:34', 1450756958461300737, '2024-03-13 11:43:34', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260862790213632, 'NOTICET2403134jX9HVe619424', '流程驳回提醒', '驳回提醒', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', 1, NULL, 'currentTime,processName', 1450756958461300737, '2024-03-13 11:43:49', 1450756958461300737, '2024-03-13 11:43:49', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820260926833041408, 'NOTICET240313dGAvFE4A53346', '流程催办提醒', '催办提醒', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', 1, NULL, 'currentTime,processName,taskName', 1450756958461300737, '2024-03-13 11:44:05', 1450756958461300737, '2024-03-13 11:44:05', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820261008022183936, 'NOTICET240313OH6rnoPQ31873', '流程委托提醒', '委托提醒', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', 1, NULL, 'currentTime,processName,startTime,endTime', 1450756958461300737, '2024-03-13 11:44:24', 1450756958461300737, '2024-03-13 11:44:24', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820261088670261248, 'NOTICET240313ADBSgqAc91004', '流程完成提醒', '完成提醒', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:44:43', 1450756958461300737, '2024-03-13 11:44:43', '0');
INSERT INTO "msg_notice_template" ("notice_template_id", "template_no", "template_name", "title", "content", "open_status", "remark", "template_params", "creator", "create_time", "last_editor", "last_time", "del_flag") VALUES (820261155477135360, 'NOTICET240313p3IDRCos59334', '流程终止提醒', '终止提醒', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', 1, NULL, 'processName,currentTime', 1450756958461300737, '2024-03-13 11:44:59', 1450756958461300737, '2024-03-13 11:44:59', '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_SCENE_CHANNEL_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "msg_scene_channel_config";
CREATE TABLE "msg_scene_channel_config" (
  "scene_channel_id" int8 NOT NULL,
  "scene_id" int8,
  "channel_config_json" varchar(4000),
  "channel_type" varchar(32),
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_scene_channel_config"."scene_channel_id" IS '主键';
COMMENT ON COLUMN "msg_scene_channel_config"."scene_id" IS '场景主键id';
COMMENT ON COLUMN "msg_scene_channel_config"."channel_config_json" IS '通道配置json';
COMMENT ON COLUMN "msg_scene_channel_config"."channel_type" IS '通道类型：sms,mail,app_im,app_push,wx_account,cp';
COMMENT ON COLUMN "msg_scene_channel_config"."last_time" IS '更新时间';
COMMENT ON COLUMN "msg_scene_channel_config"."last_editor" IS '修改人id';
COMMENT ON COLUMN "msg_scene_channel_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_scene_channel_config"."creator" IS '创建人';
COMMENT ON COLUMN "msg_scene_channel_config"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_scene_channel_config" IS '场景渠道配置表';

-- ----------------------------
-- Records of MSG_SCENE_CHANNEL_CONFIG
-- ----------------------------
BEGIN;
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202142513274881, 623202142492303360, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT220920Ievepju977469"}', 'sms', '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202142525857792, 623202142492303360, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT2206210000154"}', 'mail', '2022-09-20 10:08:20', 1450756958461300737, '2022-09-16 17:02:49', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202324864835584, 623202324848058368, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT220920AZMRpnyO17411"}', 'sms', '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202324881612800, 623202324848058368, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT220919AAS3qozY11174"}', 'mail', '2022-09-20 10:08:04', 1450756958461300737, '2022-09-16 17:03:33', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202474534379520, 623202474509213696, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT2209200FTTVhW965856"}', 'sms', '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202474551156736, 623202474509213696, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT220919JmKL4FNg49717"}', 'mail', '2022-09-20 10:07:52', 1450756958461300737, '2022-09-16 17:04:08', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202602150273024, 623202602129301504, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT220920tFARf9vH09538"}', 'sms', '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202602162855936, 623202602129301504, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT220919l56aADks17501"}', 'mail', '2022-09-20 10:07:40', 1450756958461300737, '2022-09-16 17:04:39', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202731112538112, 623202731083177984, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT220920YofTEuCJ31349"}', 'sms', '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202731125121024, 623202731083177984, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT220919bGCjleJO70191"}', 'mail', '2022-09-20 10:07:11', 1450756958461300737, '2022-09-16 17:05:10', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202854269886464, 623202854248914944, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT2209202ZHfgc1290781"}', 'sms', '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (623202854282469376, 623202854248914944, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT220919HzpMkf9J91595"}', 'mail', '2022-09-20 10:06:59', 1450756958461300737, '2022-09-16 17:05:39', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624557728551149568, 623202854248914944, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313jAt6KlRG81148"}', 'app_im', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624557728572121088, 623202854248914944, '{"channelNo":"APP00001","templateNo":"APPPUSHT240313tbEIyD1206710"}', 'app_push', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558475082735616, 623202324848058368, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313bmeVCh1r34757"}', 'app_im', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558475099512832, 623202324848058368, '{"channelNo":"APP00001","templateNo":"APPPUSHT2403138IdjYts663860"}', 'app_push', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558490903650306, 623202602129301504, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313Vz7g3zyu13111"}', 'app_im', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558490920427520, 623202602129301504, '{"channelNo":"APP00001","templateNo":"APPPUSHT240313Yau2N3BQ26358"}', 'app_push', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558507437596673, 623202731083177984, '{"channelNo":"APPIM00001","templateNo":"APPIMT2403134fynMRYu98152"}', 'app_im', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624558507458568192, 623202731083177984, '{"channelNo":"APP00001","templateNo":"APPPUSHT240313XiaZPoRp13555"}', 'app_push', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624559763648421889, 623202474509213696, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313gcBsklyf46844"}', 'app_im', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (624559763665199104, 623202474509213696, '{"channelNo":"APP00001","templateNo":"APPPUSHT2403137BGMf6G287636"}', 'app_push', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189270847488, 623202142492303360, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313fTFjiyaF87564"}', 'app_im', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430400, 623202142492303360, '{"channelNo":"APP00001","templateNo":"APPPUSHT240313eviqlKeX23539"}', 'app_push', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430401, 623202854248914944, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313fHPmQNk287578"}', 'cp', '2022-09-20 10:52:51', 1450756958461300737, '2022-09-20 10:49:26', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430402, 623202324848058368, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313zQdeei4i52826"}', 'cp', '2022-09-20 10:57:49', 1450756958461300737, '2022-09-20 10:52:24', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430403, 623202602129301504, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT2403131Ekz6NYL00066"}', 'cp', '2022-09-20 10:54:33', 1450756958461300737, '2022-09-20 10:52:28', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430404, 623202731083177984, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313g17inv1a22864"}', 'cp', '2022-09-20 10:54:36', 1450756958461300737, '2022-09-20 10:52:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430405, 623202474509213696, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313x9yRpKFt28331"}', 'cp', '2022-09-20 10:57:59', 1450756958461300737, '2022-09-20 10:57:31', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430406, 623202142492303360, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313ySq1XPAm46958"}', 'cp', '2022-09-27 14:10:30', 1450756958461300737, '2022-09-21 18:58:29', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430407, 653555293984399360, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT240313SjW5sjcS80369"}', 'dingTalk', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (625043189283430408, 653555293984399360, '{"channelNo":"CPC230310tjk34V9E30815","templateNo":"CPT240313xPYSnZcG94761"}', 'cp', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (653555294001176577, 653555293984399360, '{"channelNo":"MSMC2206180000423","signNo":"MSMS2206180000127","templateNo":"MSMT221209TqYKwH9t52990"}', 'sms', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (653555294013759488, 653555293984399360, '{"channelNo":"MAILC2206180000140","templateNo":"MAILT221209sx0JH2vc45290"}', 'mail', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (653555294022148097, 653555293984399360, '{"channelNo":"APPIM00001","templateNo":"APPIMT240313EX1mlG8u03780"}', 'app_im', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (653555294034731009, 653555293984399360, '{"channelNo":"APP00001","templateNo":"APPPUSHT240313Jlnp782t32655"}', 'app_push', '2022-12-15 14:47:32', 1450756958461300737, '2022-12-15 14:47:32', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698528951165001728, 623202854248914944, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT240313WCspHRt714521"}', 'dingTalk', NULL, NULL, '2023-04-12 13:44:40', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698529010921250816, 623202731083177984, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT240313mg6oHZgA18501"}', 'dingTalk', NULL, NULL, '2023-04-12 13:44:54', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698529113744613376, 623202602129301504, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT240313RKPCXmnf66552"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:19', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698529215745892353, 623202474509213696, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT24031309RZLURF04157"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:43', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698529269504286721, 623202324848058368, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT2403133LrM2V8M88003"}', 'dingTalk', NULL, NULL, '2023-04-12 13:45:56', 1450756958461300737, '0');
INSERT INTO "msg_scene_channel_config" ("scene_channel_id", "scene_id", "channel_config_json", "channel_type", "last_time", "last_editor", "create_time", "creator", "del_flag") VALUES (698529295920013313, 623202142492303360, '{"channelNo":"DINGTALK23041113Z3qHCp55143","templateNo":"DINGTALKT240313DfjAutzt03959"}', 'dingTalk', NULL, NULL, '2023-04-12 13:46:02', 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_SCENE_CONTACT
-- ----------------------------
DROP TABLE IF EXISTS "msg_scene_contact";
CREATE TABLE "msg_scene_contact" (
  "msg_scene_contact_id" int8 NOT NULL,
  "scene_id" int8,
  "msg_contact_id" int8,
  "contact_name" varchar(255),
  "send_type" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "msg_scene_contact"."msg_scene_contact_id" IS '主键';
COMMENT ON COLUMN "msg_scene_contact"."scene_id" IS '场景主键';
COMMENT ON COLUMN "msg_scene_contact"."msg_contact_id" IS '联系人表主键';
COMMENT ON COLUMN "msg_scene_contact"."contact_name" IS '联系人名字';
COMMENT ON COLUMN "msg_scene_contact"."send_type" IS '发送类型';
COMMENT ON COLUMN "msg_scene_contact"."creator" IS '创建人';
COMMENT ON COLUMN "msg_scene_contact"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_scene_contact"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_scene_contact"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "msg_scene_contact" IS '场景联系人关联表';

-- ----------------------------
-- Records of MSG_SCENE_CONTACT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_SMS_CHANNEL
-- ----------------------------
DROP TABLE IF EXISTS "msg_sms_channel";
CREATE TABLE "msg_sms_channel" (
  "sms_channel_id" int8 NOT NULL,
  "channel_type" int4,
  "channel_no" varchar(50),
  "channel_name" varchar(128),
  "key_id" varchar(128),
  "key_secret" varchar(128),
  "app_key" varchar(128),
  "region" varchar(50),
  "open_status" int4,
  "remark" varchar(256),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_sms_channel"."sms_channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_sms_channel"."channel_type" IS '通道类型：1阿里云；2腾讯云';
COMMENT ON COLUMN "msg_sms_channel"."channel_no" IS '通道标识';
COMMENT ON COLUMN "msg_sms_channel"."channel_name" IS '通道名称';
COMMENT ON COLUMN "msg_sms_channel"."key_id" IS 'KEY_ID';
COMMENT ON COLUMN "msg_sms_channel"."key_secret" IS 'KEY_SECRET';
COMMENT ON COLUMN "msg_sms_channel"."app_key" IS '短信 SdkAppId(腾讯云专用)';
COMMENT ON COLUMN "msg_sms_channel"."region" IS '地域(腾讯云专用)';
COMMENT ON COLUMN "msg_sms_channel"."open_status" IS '是否给用户开放0：禁用。 1：启用';
COMMENT ON COLUMN "msg_sms_channel"."remark" IS '说明';
COMMENT ON COLUMN "msg_sms_channel"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_sms_channel"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_sms_channel"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_sms_channel"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_sms_channel"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_sms_channel" IS '短信通道';

-- ----------------------------
-- Records of MSG_SMS_CHANNEL
-- ----------------------------
BEGIN;
INSERT INTO "msg_sms_channel" ("sms_channel_id", "channel_type", "channel_no", "channel_name", "key_id", "key_secret", "app_key", "region", "open_status", "remark", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (56, 1, 'MSMC2206180000423', '轻骑兵', 'XXXXXXXXXXXXX', 'XXXXXXXXXXXXX', NULL, NULL, 1, NULL, '2022-05-23 18:07:24', NULL, '2022-05-23 18:07:24', NULL, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_SMS_SEND_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "msg_sms_send_record";
CREATE TABLE "msg_sms_send_record" (
  "msg_sms_send_record_id" int8 NOT NULL,
  "channel_id" int8,
  "sign_id" int8,
  "template_id" int8,
  "channel_no" varchar(64),
  "sign_no" varchar(255),
  "template_no" varchar(64),
  "channel_name" varchar(255),
  "sign_name" varchar(255),
  "template_name" varchar(255),
  "channel_type" varchar(64),
  "template_code" varchar(64),
  "phone_number" varchar(64),
  "params" varchar(1024),
  "content" varchar(4000),
  "access_key_id" varchar(255),
  "access_key_secret" varchar(255),
  "sms_sdk_app_id" varchar(255),
  "region" varchar(255),
  "status" int4,
  "err_msg" varchar(4000),
  "biz_id" varchar(255),
  "create_time" timestamp without time zone,
  "send_time" timestamp without time zone,
  "create_date" varchar(64),
  "creator" int8,
  "tim" int2,
  "job_time" timestamp without time zone,
  "app_id" varchar(64),
  "app_name" varchar(255),
  "app_secret" varchar(255),
  "scene_name" varchar(32),
  "scene_code" varchar(32),
  "msg_id" varchar(64)
)
;
COMMENT ON COLUMN "msg_sms_send_record"."msg_sms_send_record_id" IS '主键';
COMMENT ON COLUMN "msg_sms_send_record"."channel_id" IS '渠道ID';
COMMENT ON COLUMN "msg_sms_send_record"."sign_id" IS '签名ID';
COMMENT ON COLUMN "msg_sms_send_record"."template_id" IS '模板ID';
COMMENT ON COLUMN "msg_sms_send_record"."channel_no" IS '渠道编号';
COMMENT ON COLUMN "msg_sms_send_record"."sign_no" IS '签名编号';
COMMENT ON COLUMN "msg_sms_send_record"."template_no" IS '模板编号';
COMMENT ON COLUMN "msg_sms_send_record"."channel_name" IS '渠道名称';
COMMENT ON COLUMN "msg_sms_send_record"."sign_name" IS '签名名称';
COMMENT ON COLUMN "msg_sms_send_record"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_sms_send_record"."channel_type" IS '渠道类型';
COMMENT ON COLUMN "msg_sms_send_record"."template_code" IS '模板编码';
COMMENT ON COLUMN "msg_sms_send_record"."phone_number" IS '手机号码';
COMMENT ON COLUMN "msg_sms_send_record"."params" IS '参数';
COMMENT ON COLUMN "msg_sms_send_record"."content" IS '内容';
COMMENT ON COLUMN "msg_sms_send_record"."access_key_id" IS '访问密钥ID';
COMMENT ON COLUMN "msg_sms_send_record"."access_key_secret" IS '访问密钥密钥';
COMMENT ON COLUMN "msg_sms_send_record"."sms_sdk_app_id" IS 'SdkAppId';
COMMENT ON COLUMN "msg_sms_send_record"."region" IS '地域';
COMMENT ON COLUMN "msg_sms_send_record"."status" IS '发送状态 1:发送中 2：发送失败。 3：发送成功。';
COMMENT ON COLUMN "msg_sms_send_record"."err_msg" IS '错误消息';
COMMENT ON COLUMN "msg_sms_send_record"."biz_id" IS '业务ID';
COMMENT ON COLUMN "msg_sms_send_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_sms_send_record"."send_time" IS '发送时间';
COMMENT ON COLUMN "msg_sms_send_record"."create_date" IS '创建日期';
COMMENT ON COLUMN "msg_sms_send_record"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_sms_send_record"."tim" IS '是否定时';
COMMENT ON COLUMN "msg_sms_send_record"."job_time" IS '定时时间';
COMMENT ON COLUMN "msg_sms_send_record"."app_id" IS '应用ID';
COMMENT ON COLUMN "msg_sms_send_record"."app_name" IS '应用名称';
COMMENT ON COLUMN "msg_sms_send_record"."app_secret" IS '应用密钥';
COMMENT ON COLUMN "msg_sms_send_record"."scene_name" IS '场景名称';
COMMENT ON COLUMN "msg_sms_send_record"."scene_code" IS '场景编码';
COMMENT ON COLUMN "msg_sms_send_record"."msg_id" IS '消息ID';
COMMENT ON TABLE "msg_sms_send_record" IS '消息中心消息短信发送记录';

-- ----------------------------
-- Records of MSG_SMS_SEND_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_SMS_SIGN
-- ----------------------------
DROP TABLE IF EXISTS "msg_sms_sign";
CREATE TABLE "msg_sms_sign" (
  "sms_sign_id" int8 NOT NULL,
  "channel_id" int8,
  "sign_no" varchar(50),
  "sign_name" varchar(128),
  "remark" varchar(255),
  "open_status" int4,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_sms_sign"."sms_sign_id" IS '签名ID';
COMMENT ON COLUMN "msg_sms_sign"."channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_sms_sign"."sign_no" IS '签名标识';
COMMENT ON COLUMN "msg_sms_sign"."sign_name" IS '签名名称';
COMMENT ON COLUMN "msg_sms_sign"."remark" IS '说明';
COMMENT ON COLUMN "msg_sms_sign"."open_status" IS '状态 0：禁用。 1：启用';
COMMENT ON COLUMN "msg_sms_sign"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_sms_sign"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_sms_sign"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_sms_sign"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_sms_sign"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_sms_sign" IS '短信签名';

-- ----------------------------
-- Records of MSG_SMS_SIGN
-- ----------------------------
BEGIN;
INSERT INTO "msg_sms_sign" ("sms_sign_id", "channel_id", "sign_no", "sign_name", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (15, 56, 'MSMS2206180000127', '轻骑兵低代码开发平台', '', 1, '2022-05-23 18:10:15', NULL, NULL, NULL, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_SMS_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "msg_sms_template";
CREATE TABLE "msg_sms_template" (
  "sms_template_id" int8 NOT NULL,
  "channel_id" int8,
  "template_no" varchar(50),
  "template_name" varchar(128),
  "template_code" varchar(128),
  "template_content" varchar(350),
  "remark" varchar(350),
  "open_status" int4,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_sms_template"."sms_template_id" IS '模板ID';
COMMENT ON COLUMN "msg_sms_template"."channel_id" IS '通道ID';
COMMENT ON COLUMN "msg_sms_template"."template_no" IS '模板标识';
COMMENT ON COLUMN "msg_sms_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "msg_sms_template"."template_code" IS '模板code';
COMMENT ON COLUMN "msg_sms_template"."template_content" IS '模板内容';
COMMENT ON COLUMN "msg_sms_template"."remark" IS '说明';
COMMENT ON COLUMN "msg_sms_template"."open_status" IS '状态 * 0：禁用。 *1：启用。';
COMMENT ON COLUMN "msg_sms_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_sms_template"."creator" IS '创建人ID';
COMMENT ON COLUMN "msg_sms_template"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "msg_sms_template"."last_editor" IS '最后修改人ID';
COMMENT ON COLUMN "msg_sms_template"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_sms_template" IS '短信模板';

-- ----------------------------
-- Records of MSG_SMS_TEMPLATE
-- ----------------------------
BEGIN;
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546443612659712, 56, 'MSMT2209202ZHfgc1290781', '流程终止提醒', 'SMS_464250694', '您提交的#{processName}流程已于#{currentTime}终止，请及时查看流程结果。', NULL, 1, '2022-09-20 10:04:36', 1450756958461300737, '2022-09-20 10:04:35', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546521500884992, 56, 'MSMT220920YofTEuCJ31349', '流程完成提醒', 'SMS_464195728', '您提交的#{processName}流程已于#{currentTime}审批完成，请及时查看流程结果。', NULL, 1, '2022-09-20 10:04:54', 1450756958461300737, '2022-09-20 10:04:54', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546603465973760, 56, 'MSMT220920tFARf9vH09538', '流程委托提醒', 'SMS_464160771', '您于#{currentTime}收到#{processName}流程的委托，委托时间#{startTime}至#{endTime}，后续相关任务请及时处理。', NULL, 1, '2022-09-20 10:05:14', 1450756958461300737, '2022-09-20 10:05:13', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546686194425856, 56, 'MSMT2209200FTTVhW965856', '流程催办提醒', 'SMS_464165676', '您于#{currentTime}收到#{processName}流程，#{taskName}任务的催办消息，请及时处理。', NULL, 1, '2022-09-20 10:05:34', 1450756958461300737, '2022-09-20 10:05:33', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546766557290496, 56, 'MSMT220920AZMRpnyO17411', '流程驳回提醒', 'SMS_464165675', '您于#{currentTime}收到#{processName}流程的驳回任务，请及时处理。', NULL, 1, '2022-09-20 10:05:53', 1450756958461300737, '2022-09-20 10:05:52', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (624546838124699648, 56, 'MSMT220920Ievepju977469', '流程待办提醒', 'SMS_464190694', '您于#{currentTime}收到#{processName}流程的待办任务，请及时处理。', NULL, 1, '2022-09-20 10:06:10', 1450756958461300737, '2022-09-20 10:06:09', NULL, '0');
INSERT INTO "msg_sms_template" ("sms_template_id", "channel_id", "template_no", "template_name", "template_code", "template_content", "remark", "open_status", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (653555115957166080, 56, 'MSMT221209TqYKwH9t52990', '流程异常提醒', 'SMS_264190139', '#{processName} 流程在运行时发生异常，异常类型：#{expType}，流程标识：#{processKey}，节点标识：#{taskKey}， 节点名：#{taskName}，请及时排查处理。', NULL, 1, '2022-12-15 14:47:32', NULL, '2022-12-15 14:47:32', NULL, '0');
COMMIT;

-- ----------------------------
-- Table structure for MSG_SUPPORTED_SEND_TYPE
-- ----------------------------
DROP TABLE IF EXISTS "msg_supported_send_type";
CREATE TABLE "msg_supported_send_type" (
  "msg_supported_send_type_id" int8 NOT NULL,
  "send_type_code" varchar(255),
  "send_type_name" varchar(255),
  "receive_model" varchar(255),
  "receive_address_example" varchar(255),
  "channel_no" varchar(255),
  "need_front_display" int2,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "msg_supported_send_type"."msg_supported_send_type_id" IS '主键';
COMMENT ON COLUMN "msg_supported_send_type"."send_type_code" IS '发送类型编码';
COMMENT ON COLUMN "msg_supported_send_type"."send_type_name" IS '发送类型名称';
COMMENT ON COLUMN "msg_supported_send_type"."receive_model" IS '接收方式';
COMMENT ON COLUMN "msg_supported_send_type"."receive_address_example" IS '接收地址示例';
COMMENT ON COLUMN "msg_supported_send_type"."channel_no" IS '通道编码';
COMMENT ON COLUMN "msg_supported_send_type"."need_front_display" IS '是否需要前台显示';
COMMENT ON COLUMN "msg_supported_send_type"."creator" IS '创建人';
COMMENT ON COLUMN "msg_supported_send_type"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_supported_send_type"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_supported_send_type"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "msg_supported_send_type" IS '消息中心支持的发送类型列表';

-- ----------------------------
-- Records of MSG_SUPPORTED_SEND_TYPE
-- ----------------------------
BEGIN;
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (1, 'sms', '短信', '请输入手机号', '13255555555', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (2, 'mail', '邮件', '请输入邮箱地址', '123@163.com', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (3, 'wx_account', '微信公众号', 'OpenId', '请输入微信公众号OpenId', NULL, 0, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (4, 'app_im', 'IM推送', 'UserId', '请输入UserId', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (5, 'app_push', 'APP通知推送', 'Token', '请输入Token', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (6, 'notice', '内部通知推送', 'UserId', '请输入UserId', NULL, 0, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (7, 'cp', '企业微信推送', 'UserId', '请输入企业微信UserId', NULL, 1, NULL, NULL, NULL, NULL);
INSERT INTO "msg_supported_send_type" ("msg_supported_send_type_id", "send_type_code", "send_type_name", "receive_model", "receive_address_example", "channel_no", "need_front_display", "creator", "create_time", "last_editor", "last_time") VALUES (8, 'dingTalk', '钉钉推送', 'UserId', '请输入钉钉UserId', NULL, 1, NULL, NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for MSG_TAG
-- ----------------------------
DROP TABLE IF EXISTS "msg_tag";
CREATE TABLE "msg_tag" (
  "msg_tag_id" int8 NOT NULL,
  "tag_name" varchar(255) NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "msg_tag"."msg_tag_id" IS '主键';
COMMENT ON COLUMN "msg_tag"."tag_name" IS '标签名(唯一)';
COMMENT ON COLUMN "msg_tag"."creator" IS '创建人';
COMMENT ON COLUMN "msg_tag"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_tag"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "msg_tag"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "msg_tag" IS '标签表';

-- ----------------------------
-- Records of MSG_TAG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for MSG_USER_SERVICE
-- ----------------------------
DROP TABLE IF EXISTS "msg_user_service";
CREATE TABLE "msg_user_service" (
  "user_service_id" int8 NOT NULL,
  "user_id" varchar(32),
  "message_type" varchar(32),
  "other_user_id" varchar(128),
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "msg_user_service"."user_service_id" IS '主键';
COMMENT ON COLUMN "msg_user_service"."user_id" IS '用户id';
COMMENT ON COLUMN "msg_user_service"."message_type" IS '消息类型';
COMMENT ON COLUMN "msg_user_service"."other_user_id" IS '三方用户标识（openId,token等）';
COMMENT ON COLUMN "msg_user_service"."last_time" IS '更新时间';
COMMENT ON COLUMN "msg_user_service"."last_editor" IS '修改人id';
COMMENT ON COLUMN "msg_user_service"."create_time" IS '创建时间';
COMMENT ON COLUMN "msg_user_service"."creator" IS '创建人';
COMMENT ON COLUMN "msg_user_service"."del_flag" IS '删除状态（0，正常，1已删除）';
COMMENT ON TABLE "msg_user_service" IS '用户服务关联表';

-- ----------------------------
-- Records of MSG_USER_SERVICE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for NOCODE_BPM_EXTEND_DATA
-- ----------------------------
DROP TABLE IF EXISTS "nocode_bpm_extend_data";
CREATE TABLE "nocode_bpm_extend_data" (
  "id_" int8 NOT NULL,
  "task_id_" int8,
  "proc_inst_id_" int8,
  "signature_" text
)
;
COMMENT ON COLUMN "nocode_bpm_extend_data"."id_" IS '主键';
COMMENT ON COLUMN "nocode_bpm_extend_data"."task_id_" IS '任务id';
COMMENT ON COLUMN "nocode_bpm_extend_data"."proc_inst_id_" IS '流程实例id';
COMMENT ON COLUMN "nocode_bpm_extend_data"."signature_" IS '签名';
COMMENT ON TABLE "nocode_bpm_extend_data" IS '零代码扩展数据表';

-- ----------------------------
-- Records of NOCODE_BPM_EXTEND_DATA
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_AD_BROWSING_HISTORY
-- ----------------------------
DROP TABLE IF EXISTS "sys_ad_browsing_history";
CREATE TABLE "sys_ad_browsing_history" (
  "browse_id" int8 NOT NULL,
  "business_id" int8,
  "ad_type" char(1),
  "browsers" int8,
  "browsers_dept" int8,
  "browse_time" timestamp without time zone,
  "browse_day" timestamp without time zone,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_ad_browsing_history"."browse_id" IS 'id';
COMMENT ON COLUMN "sys_ad_browsing_history"."business_id" IS '横幅/广告主键';
COMMENT ON COLUMN "sys_ad_browsing_history"."ad_type" IS '广告类型：1-横幅广告，2-工具栏广告';
COMMENT ON COLUMN "sys_ad_browsing_history"."browsers" IS '浏览人';
COMMENT ON COLUMN "sys_ad_browsing_history"."browsers_dept" IS '浏览人部门';
COMMENT ON COLUMN "sys_ad_browsing_history"."browse_time" IS '浏览时间';
COMMENT ON COLUMN "sys_ad_browsing_history"."browse_day" IS '浏览日期-日';
COMMENT ON COLUMN "sys_ad_browsing_history"."creator" IS '创建人';
COMMENT ON COLUMN "sys_ad_browsing_history"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_ad_browsing_history"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_ad_browsing_history"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_ad_browsing_history" IS '首页广告浏览记录表';

-- ----------------------------
-- Records of SYS_AD_BROWSING_HISTORY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_AD_IGNORE_SHOW
-- ----------------------------
DROP TABLE IF EXISTS "sys_ad_ignore_show";
CREATE TABLE "sys_ad_ignore_show" (
  "ignore_id" int8 NOT NULL,
  "ad_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_ad_ignore_show"."ignore_id" IS 'id';
COMMENT ON COLUMN "sys_ad_ignore_show"."ad_id" IS '横幅主键';
COMMENT ON COLUMN "sys_ad_ignore_show"."creator" IS '创建人';
COMMENT ON COLUMN "sys_ad_ignore_show"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_ad_ignore_show"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_ad_ignore_show"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_ad_ignore_show" IS '横幅关闭记录表';

-- ----------------------------
-- Records of SYS_AD_IGNORE_SHOW
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_AGENDA
-- ----------------------------
DROP TABLE IF EXISTS "sys_agenda";
CREATE TABLE "sys_agenda" (
  "agenda_id" int8 NOT NULL,
  "agenda_title" varchar(32) NOT NULL,
  "agenda_type" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "agenda_content" varchar(1024),
  "place" varchar(128),
  "start_time" timestamp without time zone NOT NULL,
  "end_time" timestamp without time zone NOT NULL
)
;
COMMENT ON COLUMN "sys_agenda"."agenda_id" IS '日程id';
COMMENT ON COLUMN "sys_agenda"."agenda_title" IS '日程标题';
COMMENT ON COLUMN "sys_agenda"."agenda_type" IS '日程类型';
COMMENT ON COLUMN "sys_agenda"."creator" IS '创建人';
COMMENT ON COLUMN "sys_agenda"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_agenda"."last_editor" IS '上次编辑着';
COMMENT ON COLUMN "sys_agenda"."last_time" IS '上次修改时间';
COMMENT ON COLUMN "sys_agenda"."agenda_content" IS '日程内容';
COMMENT ON COLUMN "sys_agenda"."place" IS '地点';
COMMENT ON COLUMN "sys_agenda"."start_time" IS '开始时间';
COMMENT ON COLUMN "sys_agenda"."end_time" IS '结束时间';
COMMENT ON TABLE "sys_agenda" IS '日程管理表';

-- ----------------------------
-- Records of SYS_AGENDA
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APPLICATION
-- ----------------------------
DROP TABLE IF EXISTS "sys_application";
CREATE TABLE "sys_application" (
  "app_id" int8 NOT NULL,
  "app_name" varchar(32) NOT NULL,
  "app_group_id" int8 NOT NULL,
  "app_code" varchar(64) NOT NULL,
  "app_type" varchar(2) NOT NULL,
  "app_icon_type" char(1) NOT NULL,
  "app_icon" varchar(255) NOT NULL,
  "app_icon_color" varchar(32),
  "secret_key" varchar(32) NOT NULL,
  "app_describe" varchar(255),
  "web_url" varchar(512),
  "mobile_url" varchar(512),
  "app_status" char(1) NOT NULL,
  "release_status" char(1) NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "status_describe" varchar(512),
  "develop_role_id" int8,
  "app_version" varchar(32),
  "app_seq" int4,
  "i18n_keys" text
)
;
COMMENT ON COLUMN "sys_application"."app_id" IS '应用ID 主键字段';
COMMENT ON COLUMN "sys_application"."app_name" IS '应用名称';
COMMENT ON COLUMN "sys_application"."app_group_id" IS '应用分组ID';
COMMENT ON COLUMN "sys_application"."app_code" IS '应用编码';
COMMENT ON COLUMN "sys_application"."app_type" IS '应用类型 1：零代码 2：低代码 3：自建应用 7：微前端子应用';
COMMENT ON COLUMN "sys_application"."app_icon_type" IS '应用图标类型
1：内置图标
2：用户自定义';
COMMENT ON COLUMN "sys_application"."app_icon" IS '应用图标
内置图标：图标标识
用户自定义：图片ID';
COMMENT ON COLUMN "sys_application"."app_icon_color" IS '内置图标颜色';
COMMENT ON COLUMN "sys_application"."secret_key" IS '应用密钥，统一待办、统一认证需要';
COMMENT ON COLUMN "sys_application"."app_describe" IS '应用描述';
COMMENT ON COLUMN "sys_application"."web_url" IS 'Web访问地址';
COMMENT ON COLUMN "sys_application"."mobile_url" IS '手机访问地址';
COMMENT ON COLUMN "sys_application"."app_status" IS '应用状态
0：禁用
1：启用
默认值：1';
COMMENT ON COLUMN "sys_application"."release_status" IS '应用发布状态
1：已上架
0：未上架
默认值：0';
COMMENT ON COLUMN "sys_application"."creator" IS '创建人';
COMMENT ON COLUMN "sys_application"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_application"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_application"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_application"."status_describe" IS '禁用状态描述';
COMMENT ON COLUMN "sys_application"."develop_role_id" IS '开发者角色ID';
COMMENT ON COLUMN "sys_application"."app_version" IS '应用版本';
COMMENT ON COLUMN "sys_application"."app_seq" IS '应用排序';
COMMENT ON COLUMN "sys_application"."i18n_keys" IS '多语言引用关系';
COMMENT ON TABLE "sys_application" IS '应用表';

-- ----------------------------
-- Records of SYS_APPLICATION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APPLICATION_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_application_record";
CREATE TABLE "sys_application_record" (
  "record_id" int8 NOT NULL,
  "record_type" varchar(10),
  "app_id" int8 NOT NULL,
  "app_mode" varchar(10),
  "record_status" varchar(10),
  "show_msg" varchar(255),
  "record_file_id" int8,
  "record_file_name" varchar(255),
  "record_file_password" varchar(128),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_application_record"."record_id" IS '记录主键';
COMMENT ON COLUMN "sys_application_record"."record_type" IS '记录类型，0：导入，1：导出';
COMMENT ON COLUMN "sys_application_record"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_application_record"."app_mode" IS '应用类型，0：零代码，1：低代码';
COMMENT ON COLUMN "sys_application_record"."record_status" IS '记录状态，1：进行中 2：成功 3：失败';
COMMENT ON COLUMN "sys_application_record"."show_msg" IS '展示信息';
COMMENT ON COLUMN "sys_application_record"."record_file_id" IS '导入或导出附件id';
COMMENT ON COLUMN "sys_application_record"."record_file_name" IS '导入或导出附件名称';
COMMENT ON COLUMN "sys_application_record"."record_file_password" IS '加密后的密码';
COMMENT ON COLUMN "sys_application_record"."creator" IS '创建人';
COMMENT ON COLUMN "sys_application_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_application_record"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_application_record"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_application_record" IS '导出记录表';

-- ----------------------------
-- Records of SYS_APPLICATION_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APPLICATION_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "sys_application_version" CASCADE;
CREATE TABLE "sys_application_version" (
  "app_version_id" int8 NOT NULL,
  "app_id" int8 NULL DEFAULT NULL,
  "version_number" varchar(255) NULL DEFAULT NULL,
  "package_path" varchar(255) NULL DEFAULT NULL,
  "current_flag" int2 NULL DEFAULT NULL,
  "upgrade_mapping" text NULL DEFAULT NULL,
  "create_time" timestamp NULL DEFAULT NULL,
  "last_time" timestamp NULL DEFAULT NULL,
  "creator" int8 NULL DEFAULT NULL,
  "last_editor" int8 NULL DEFAULT NULL
)
;
COMMENT ON COLUMN "sys_application_version"."app_version_id" IS '应用版本id';
COMMENT ON COLUMN "sys_application_version"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_application_version"."version_number" IS '应用版本号';
COMMENT ON COLUMN "sys_application_version"."package_path" IS '应用包存储路径';
COMMENT ON COLUMN "sys_application_version"."current_flag" IS '是否是当前版本';
COMMENT ON COLUMN "sys_application_version"."upgrade_mapping" IS '升级映射关系';
COMMENT ON COLUMN "sys_application_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_application_version"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_application_version"."creator" IS '创建人';
COMMENT ON COLUMN "sys_application_version"."last_editor" IS '最后一次修改人';
COMMENT ON TABLE "sys_application_version" IS '应用版本';

-- ----------------------------
-- Records of SYS_APPLICATION_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_CLIENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_client";
CREATE TABLE "sys_app_client" (
  "app_client_id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "client_model_id" int8 NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_app_client"."app_client_id" IS '主键ID';
COMMENT ON COLUMN "sys_app_client"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_client"."client_model_id" IS '客户端ID';
COMMENT ON COLUMN "sys_app_client"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_client"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_client"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_app_client"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_app_client"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_app_client" IS '应用操作记录表';

-- ----------------------------
-- Records of SYS_APP_CLIENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_COMMON
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_common";
CREATE TABLE "sys_app_common" (
  "common_id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "user_id" int8,
  "platform" char(1),
  "seq" int4 NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_app_common"."common_id" IS '常用应用id';
COMMENT ON COLUMN "sys_app_common"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_common"."user_id" IS '用户id';
COMMENT ON COLUMN "sys_app_common"."platform" IS '平台
1、web 2、移动';
COMMENT ON COLUMN "sys_app_common"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_app_common"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_common"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_common"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_common"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_app_common" IS '常用应用表';

-- ----------------------------
-- Records of SYS_APP_COMMON
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_DEVELOP_TEAM
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_develop_team";
CREATE TABLE "sys_app_develop_team" (
  "team_id" int8 NOT NULL,
  "team_name" varchar(64),
  "app_id" int8,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_app_develop_team"."team_id" IS '主键';
COMMENT ON COLUMN "sys_app_develop_team"."team_name" IS '团队名称';
COMMENT ON COLUMN "sys_app_develop_team"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_develop_team"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_develop_team"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_app_develop_team"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_develop_team"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_app_develop_team"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_app_develop_team" IS '应用开发团队表';

-- ----------------------------
-- Records of SYS_APP_DEVELOP_TEAM
-- ----------------------------
BEGIN;
INSERT INTO "sys_app_develop_team" ("team_id", "team_name", "app_id", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (1, '统一权限平台开发团队', 1, '2023-06-01 17:41:02', '2023-06-01 17:41:02', 1450756958461300737, 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_DEVELOP_TEAM_MEMBER
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_develop_team_member";
CREATE TABLE "sys_app_develop_team_member" (
  "team_member_id" int8 NOT NULL,
  "team_id" int8,
  "user_id" int8,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1),
  "member_type" char(1)
)
;
COMMENT ON COLUMN "sys_app_develop_team_member"."team_member_id" IS '主键';
COMMENT ON COLUMN "sys_app_develop_team_member"."team_id" IS '团队id';
COMMENT ON COLUMN "sys_app_develop_team_member"."user_id" IS '用户id';
COMMENT ON COLUMN "sys_app_develop_team_member"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_develop_team_member"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_app_develop_team_member"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_develop_team_member"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_app_develop_team_member"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_app_develop_team_member" IS '开发团队成员表';

-- ----------------------------
-- Records of SYS_APP_DEVELOP_TEAM_MEMBER
-- ----------------------------
BEGIN;
INSERT INTO "sys_app_develop_team_member" ("team_member_id", "team_id", "user_id", "create_time", "last_time", "creator", "last_editor", "del_flag", "member_type") VALUES (1, 1, 1450756958461300737, '2023-06-01 17:41:02', '2023-06-01 17:41:02', 1450756958461300737, 1450756958461300737, '0', '1');
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_EXPORT_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_export_record";
CREATE TABLE "sys_app_export_record" (
  "record_id" int8 NOT NULL,
  "app_id" int8,
  "export_user_id" int8,
  "export_time" timestamp without time zone,
  "password" varchar(128),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "export_file_id" int8,
  "type" char(1),
  "name" varchar(255)
)
;
COMMENT ON COLUMN "sys_app_export_record"."record_id" IS '记录主键';
COMMENT ON COLUMN "sys_app_export_record"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_export_record"."export_user_id" IS '导出人id';
COMMENT ON COLUMN "sys_app_export_record"."export_time" IS '导出时间';
COMMENT ON COLUMN "sys_app_export_record"."password" IS '加密后的密码';
COMMENT ON COLUMN "sys_app_export_record"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_export_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_export_record"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_export_record"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_export_record"."export_file_id" IS '导出附件id';
COMMENT ON COLUMN "sys_app_export_record"."type" IS '类型';
COMMENT ON COLUMN "sys_app_export_record"."name" IS '名称';
COMMENT ON TABLE "sys_app_export_record" IS '导出记录表';

-- ----------------------------
-- Records of SYS_APP_EXPORT_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_GROUP
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_group";
CREATE TABLE "sys_app_group" (
  "group_id" int8 NOT NULL,
  "group_name" varchar(32) NOT NULL,
  "seq" int4 NOT NULL,
  "group_type" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "i18n_keys" text
)
;
COMMENT ON COLUMN "sys_app_group"."group_id" IS '分组ID';
COMMENT ON COLUMN "sys_app_group"."group_name" IS '分组名称';
COMMENT ON COLUMN "sys_app_group"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_app_group"."group_type" IS '分组类型
1:默认分组
2:普通分组';
COMMENT ON COLUMN "sys_app_group"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_group"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_group"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_group"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_group"."i18n_keys" IS '多语言引用关系';
COMMENT ON TABLE "sys_app_group" IS '应用分组表';

-- ----------------------------
-- Records of SYS_APP_GROUP
-- ----------------------------
BEGIN;
INSERT INTO "sys_app_group" ("group_id", "group_name", "seq", "group_type", "creator", "create_time", "last_editor", "last_time", "i18n_keys") VALUES (1, '默认分组', 0, '1', 1450756958461300737, '2017-02-10 11:57:33', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_LINK_INNER
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_link_inner";
CREATE TABLE "sys_app_link_inner" (
  "link_id" int8 NOT NULL,
  "app_id" int8,
  "inner_params" text,
  "inner_short_address" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_app_link_inner"."link_id" IS '主键id';
COMMENT ON COLUMN "sys_app_link_inner"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_link_inner"."inner_params" IS '应用内链接参数';
COMMENT ON COLUMN "sys_app_link_inner"."inner_short_address" IS '应用内短链接';
COMMENT ON COLUMN "sys_app_link_inner"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_link_inner"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_link_inner"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_app_link_inner"."last_time" IS '修改时间';
COMMENT ON TABLE "sys_app_link_inner" IS '应用访问链接';

-- ----------------------------
-- Records of SYS_APP_LINK_INNER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_MENU_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_menu_resource";
CREATE TABLE "sys_app_menu_resource" (
  "app_name" varchar(36),
  "page_id" varchar(36),
  "relation_id" int8,
  "relation_ref_id" int8,
  "relation_type" varchar(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_app_menu_resource"."app_name" IS '应用名称';
COMMENT ON COLUMN "sys_app_menu_resource"."page_id" IS '应用下的页面Id，用于应用页面菜单和资源的自动绑定';
COMMENT ON COLUMN "sys_app_menu_resource"."relation_id" IS '关联Id;菜单Id或资源Id';
COMMENT ON COLUMN "sys_app_menu_resource"."relation_ref_id" IS '功能Id;当应用关联菜单时有值;用于自动关联功能和资源';
COMMENT ON COLUMN "sys_app_menu_resource"."relation_type" IS '1=应用关联的菜单；2=应用关联的资源';
COMMENT ON COLUMN "sys_app_menu_resource"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_menu_resource"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_menu_resource"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_menu_resource"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_app_menu_resource" IS '应用与菜单及资源的关联关系表';

-- ----------------------------
-- Records of SYS_APP_MENU_RESOURCE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_OAUTH_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_oauth_config";
CREATE TABLE "sys_app_oauth_config" (
  "app_auth_id" int8 NOT NULL,
  "app_id" int8,
  "app_code" varchar(100),
  "app_secret" varchar(100),
  "client_id" varchar(100),
  "grant_type" varchar(100),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_app_oauth_config"."app_auth_id" IS '主键ID';
COMMENT ON COLUMN "sys_app_oauth_config"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_oauth_config"."app_code" IS '认证ID';
COMMENT ON COLUMN "sys_app_oauth_config"."app_secret" IS '认证密钥';
COMMENT ON COLUMN "sys_app_oauth_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_oauth_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_oauth_config"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_oauth_config"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_oauth_config"."del_flag" IS '仪表盘删除标识';
COMMENT ON TABLE "sys_app_oauth_config" IS '应用认证信息表';

-- ----------------------------
-- Records of SYS_APP_OAUTH_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_OPERATION_LOG
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_operation_log";
CREATE TABLE "sys_app_operation_log" (
  "app_operation_id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "operation_type" char(1)
)
;
COMMENT ON COLUMN "sys_app_operation_log"."app_operation_id" IS '主键Id';
COMMENT ON COLUMN "sys_app_operation_log"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_operation_log"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_operation_log"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_operation_log"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_app_operation_log"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_app_operation_log"."operation_type" IS '操作标识 1-删除，2-其他操作';
COMMENT ON TABLE "sys_app_operation_log" IS '应用操作记录表';

-- ----------------------------
-- Records of SYS_APP_OPERATION_LOG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_RECYCLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_recycle";
CREATE TABLE "sys_app_recycle" (
  "app_id" int8 NOT NULL,
  "app_name" varchar(32) NOT NULL,
  "app_group_id" int8 NOT NULL,
  "app_code" varchar(64) NOT NULL,
  "app_type" varchar(2) NOT NULL,
  "app_icon_type" char(1) NOT NULL,
  "app_icon" varchar(255) NOT NULL,
  "app_icon_color" varchar(32),
  "secret_key" varchar(32) NOT NULL,
  "app_describe" varchar(255),
  "web_url" varchar(512),
  "mobile_url" varchar(512),
  "app_status" char(1) NOT NULL,
  "release_status" char(1) NOT NULL,
  "delete_user" int8 NOT NULL,
  "create_user" int8 NOT NULL,
  "delete_time" timestamp without time zone NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "develop_role_id" int8,
  "app_version" varchar(32),
  "status_describe" varchar(512),
  "app_seq" int4
)
;
COMMENT ON COLUMN "sys_app_recycle"."app_id" IS '应用ID 主键字段';
COMMENT ON COLUMN "sys_app_recycle"."app_name" IS '应用名称';
COMMENT ON COLUMN "sys_app_recycle"."app_group_id" IS '应用分组ID';
COMMENT ON COLUMN "sys_app_recycle"."app_code" IS '应用编码';
COMMENT ON COLUMN "sys_app_recycle"."app_type" IS '应用类型
1：零代码
2：低代码
3：自建应用';
COMMENT ON COLUMN "sys_app_recycle"."app_icon_type" IS '应用图标类型
1：内置图标
2：用户自定义';
COMMENT ON COLUMN "sys_app_recycle"."app_icon" IS '应用图标
内置图标：图标标识
用户自定义：图片ID';
COMMENT ON COLUMN "sys_app_recycle"."app_icon_color" IS '内置图标颜色';
COMMENT ON COLUMN "sys_app_recycle"."secret_key" IS '应用密钥，统一待办、统一认证需要';
COMMENT ON COLUMN "sys_app_recycle"."app_describe" IS '应用描述';
COMMENT ON COLUMN "sys_app_recycle"."web_url" IS 'Web访问地址';
COMMENT ON COLUMN "sys_app_recycle"."mobile_url" IS '手机访问地址';
COMMENT ON COLUMN "sys_app_recycle"."app_status" IS '应用状态
0：禁用
1：启用
默认值：1';
COMMENT ON COLUMN "sys_app_recycle"."release_status" IS '应用发布状态
1：已上架
0：未上架
默认值：1';
COMMENT ON COLUMN "sys_app_recycle"."delete_user" IS '删除人';
COMMENT ON COLUMN "sys_app_recycle"."create_user" IS '应用创建人';
COMMENT ON COLUMN "sys_app_recycle"."delete_time" IS '删除时间';
COMMENT ON COLUMN "sys_app_recycle"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_recycle"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_recycle"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_recycle"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_recycle"."develop_role_id" IS '开发者角色ID';
COMMENT ON COLUMN "sys_app_recycle"."app_version" IS '应用版本';
COMMENT ON COLUMN "sys_app_recycle"."status_describe" IS '禁用状态描述';
COMMENT ON COLUMN "sys_app_recycle"."app_seq" IS '应用排序';
COMMENT ON TABLE "sys_app_recycle" IS '应用回收站表';

-- ----------------------------
-- Records of SYS_APP_RECYCLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_template";
CREATE TABLE "sys_app_template" (
  "template_id" int8 NOT NULL,
  "template_name" varchar(32) NOT NULL,
  "template_profession_id" int8 NOT NULL,
  "template_code" varchar(64) NOT NULL,
  "template_describe" varchar(255),
  "template_icon" varchar(255) NOT NULL,
  "template_icon_type" varchar(1),
  "template_icon_color" varchar(32) NOT NULL,
  "web_url" varchar(512),
  "mobile_url" varchar(512),
  "template_status" char(1) NOT NULL,
  "release_status" char(1) NOT NULL,
  "creator" int8,
  "creator_name" varchar(10) NOT NULL,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "status_describe" varchar(512),
  "develop_role_id" int8,
  "template_version" varchar(32),
  "use_type" varchar(512),
  "template_seq" int4,
  "installed_numbs" int4,
  "view_numbs" int4
)
;
COMMENT ON COLUMN "sys_app_template"."template_id" IS '模板ID 主键字段';
COMMENT ON COLUMN "sys_app_template"."template_name" IS '模板名称';
COMMENT ON COLUMN "sys_app_template"."template_profession_id" IS '模板行业ID';
COMMENT ON COLUMN "sys_app_template"."template_code" IS '模板编码';
COMMENT ON COLUMN "sys_app_template"."template_describe" IS '模板描述';
COMMENT ON COLUMN "sys_app_template"."template_icon" IS '应用图标';
COMMENT ON COLUMN "sys_app_template"."template_icon_type" IS 'ICON类型';
COMMENT ON COLUMN "sys_app_template"."template_icon_color" IS 'ICON颜色';
COMMENT ON COLUMN "sys_app_template"."web_url" IS 'Web访问地址';
COMMENT ON COLUMN "sys_app_template"."mobile_url" IS '手机访问地址';
COMMENT ON COLUMN "sys_app_template"."template_status" IS '模板状态
0：禁用
1：启用
默认值：1';
COMMENT ON COLUMN "sys_app_template"."release_status" IS '模板发布状态
1：已上架
0：未上架
默认值：0';
COMMENT ON COLUMN "sys_app_template"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_template"."creator_name" IS '创建人名称';
COMMENT ON COLUMN "sys_app_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_template"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_template"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_template"."status_describe" IS '禁用状态描述';
COMMENT ON COLUMN "sys_app_template"."develop_role_id" IS '开发者角色ID';
COMMENT ON COLUMN "sys_app_template"."template_version" IS '模板版本';
COMMENT ON COLUMN "sys_app_template"."use_type" IS '使用方式';
COMMENT ON COLUMN "sys_app_template"."template_seq" IS '模板排序';
COMMENT ON COLUMN "sys_app_template"."installed_numbs" IS '模板安装量';
COMMENT ON COLUMN "sys_app_template"."view_numbs" IS '模板浏览量';
COMMENT ON TABLE "sys_app_template" IS '应用模板表';

-- ----------------------------
-- Records of SYS_APP_TEMPLATE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_TEMPLATE_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_template_attachment";
CREATE TABLE "sys_app_template_attachment" (
  "attachment_id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "file_path" varchar(255) NOT NULL,
  "file_type" int4 NOT NULL,
  "file_seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_app_template_attachment"."attachment_id" IS '附件id';
COMMENT ON COLUMN "sys_app_template_attachment"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_template_attachment"."file_path" IS '文件路径';
COMMENT ON COLUMN "sys_app_template_attachment"."file_type" IS '1：应用文件；2：缩略图；3：pc端图片；4：移动端图片';
COMMENT ON COLUMN "sys_app_template_attachment"."file_seq" IS 'pc端、移动端的图片显示顺序';
COMMENT ON COLUMN "sys_app_template_attachment"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_template_attachment"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_template_attachment"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_template_attachment"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_app_template_attachment" IS '应用模板附件记录表';

-- ----------------------------
-- Records of SYS_APP_TEMPLATE_ATTACHMENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_VISIT_AUTHORITY
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_visit_authority";
CREATE TABLE "sys_app_visit_authority" (
  "app_role_id" int8 NOT NULL,
  "app_id" int8,
  "role_id" int8,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1),
  "authorization_type" char(1)
)
;
COMMENT ON COLUMN "sys_app_visit_authority"."app_role_id" IS '主键';
COMMENT ON COLUMN "sys_app_visit_authority"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_visit_authority"."role_id" IS '角色id';
COMMENT ON COLUMN "sys_app_visit_authority"."authorization_type" IS '应用授权类型。1-组织，2-角色，3-岗位，4-用户';
COMMENT ON TABLE "sys_app_visit_authority" IS '应用访问授权表';

-- ----------------------------
-- Records of SYS_APP_VISIT_AUTHORITY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_VISIT_DATA_LOGIC
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_visit_data_logic";
CREATE TABLE "sys_app_visit_data_logic" (
  "role_data_logic_id" int8 NOT NULL,
  "role_id" int8,
  "app_id" int8,
  "form_id" int8,
  "combine_type" char(1),
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_app_visit_data_logic"."role_data_logic_id" IS '主键';
COMMENT ON COLUMN "sys_app_visit_data_logic"."role_id" IS '角色ID';
COMMENT ON COLUMN "sys_app_visit_data_logic"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_visit_data_logic"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_app_visit_data_logic"."combine_type" IS '筛选条件组合关系：0 任一、 1 所有';
COMMENT ON COLUMN "sys_app_visit_data_logic"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_visit_data_logic"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_visit_data_logic"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_visit_data_logic"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_visit_data_logic"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_app_visit_data_logic" IS '角色表单数据逻辑权限表';

-- ----------------------------
-- Records of SYS_APP_VISIT_DATA_LOGIC
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_VISIT_ROLE_BUTTON
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_visit_role_button";
CREATE TABLE "sys_app_visit_role_button" (
  "role_button_id" int8 NOT NULL,
  "role_id" int8,
  "app_id" int8,
  "form_id" int8,
  "button_code" varchar(32),
  "button_name" varchar(20),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_app_visit_role_button"."role_button_id" IS '主键';
COMMENT ON COLUMN "sys_app_visit_role_button"."role_id" IS '角色ID';
COMMENT ON COLUMN "sys_app_visit_role_button"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_visit_role_button"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_app_visit_role_button"."button_code" IS '按钮编码';
COMMENT ON COLUMN "sys_app_visit_role_button"."button_name" IS '按钮名';
COMMENT ON COLUMN "sys_app_visit_role_button"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_visit_role_button"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_visit_role_button"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_app_visit_role_button"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_visit_role_button"."del_flag" IS '需要逻辑删除的业务添加该字段';
COMMENT ON TABLE "sys_app_visit_role_button" IS '角色表单按钮权限表';

-- ----------------------------
-- Records of SYS_APP_VISIT_ROLE_BUTTON
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_VISIT_ROLE_FIELD
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_visit_role_field";
CREATE TABLE "sys_app_visit_role_field" (
  "role_field_id" int8 NOT NULL,
  "role_id" int8,
  "app_id" int8,
  "form_id" int8,
  "field_id" varchar(64),
  "field_name" varchar(1024),
  "can_read" char(1),
  "can_write" char(1),
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1),
  "parent_id" varchar(64)
)
;
COMMENT ON COLUMN "sys_app_visit_role_field"."role_field_id" IS '主键';
COMMENT ON COLUMN "sys_app_visit_role_field"."role_id" IS '角色ID';
COMMENT ON COLUMN "sys_app_visit_role_field"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_app_visit_role_field"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_app_visit_role_field"."field_id" IS '表单内字段ID';
COMMENT ON COLUMN "sys_app_visit_role_field"."field_name" IS '字段名';
COMMENT ON COLUMN "sys_app_visit_role_field"."can_read" IS '可读 :0 否 1 是';
COMMENT ON COLUMN "sys_app_visit_role_field"."can_write" IS '可写:0 否 1 是';
COMMENT ON COLUMN "sys_app_visit_role_field"."parent_id" IS '父级字段id';
COMMENT ON TABLE "sys_app_visit_role_field" IS '角色表单字段权限表';

-- ----------------------------
-- Records of SYS_APP_VISIT_ROLE_FIELD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_APP_WATERMARK
-- ----------------------------
DROP TABLE IF EXISTS "sys_app_watermark";
CREATE TABLE "sys_app_watermark" (
  "watermark_id" int8 NOT NULL,
  "app_id" int8,
  "app_watermark" char(1),
  "print_watermark" char(1),
  "data_watermark" char(1),
  "del_flag" char(1),
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8
)
;
COMMENT ON COLUMN "sys_app_watermark"."watermark_id" IS '主键id';
COMMENT ON COLUMN "sys_app_watermark"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_app_watermark"."app_watermark" IS '应用水印';
COMMENT ON COLUMN "sys_app_watermark"."print_watermark" IS '打印水印';
COMMENT ON COLUMN "sys_app_watermark"."data_watermark" IS '数据水印';
COMMENT ON COLUMN "sys_app_watermark"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_app_watermark"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_app_watermark"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_app_watermark"."creator" IS '创建人';
COMMENT ON COLUMN "sys_app_watermark"."last_editor" IS '最后一次修改人';
COMMENT ON TABLE "sys_app_watermark" IS '应用水印配置';

-- ----------------------------
-- Records of SYS_APP_WATERMARK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_ASYNC_EVENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_async_event";
CREATE TABLE "sys_async_event" (
  "sys_async_event_id" int8 NOT NULL,
  "event_type" varchar(255),
  "event" varchar(2048),
  "status" char(2),
  "retry_num" int4,
  "error_msg" text,
  "class_name" varchar(255),
  "create_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_async_event"."sys_async_event_id" IS '事件表主键';
COMMENT ON COLUMN "sys_async_event"."event_type" IS '事件类型';
COMMENT ON COLUMN "sys_async_event"."event" IS '事件内容';
COMMENT ON COLUMN "sys_async_event"."status" IS '事件状态，0未消费，1以消费，2消费失败';
COMMENT ON COLUMN "sys_async_event"."retry_num" IS '重试次数，默认为0';
COMMENT ON COLUMN "sys_async_event"."error_msg" IS '消费失败原因';
COMMENT ON COLUMN "sys_async_event"."class_name" IS '实体类名称';
COMMENT ON COLUMN "sys_async_event"."create_time" IS '事件创建时间';
COMMENT ON TABLE "sys_async_event" IS '事件记录表';

-- ----------------------------
-- Records of SYS_ASYNC_EVENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_MODEL
-- ----------------------------
DROP TABLE IF EXISTS "sys_auth_client_model";
CREATE TABLE "sys_auth_client_model" (
  "client_model_id" int8 NOT NULL,
  "client_id" varchar(64) NOT NULL,
  "client_secret" varchar(64) NOT NULL,
  "contract_scope" varchar(100),
  "allow_url" varchar(1000),
  "authorized_grant_type" varchar(100),
  "web_server_redirect_uri" varchar(100),
  "authorities" varchar(100),
  "access_token_valid_time" int4,
  "refresh_token_valid_time" int4,
  "auto_approve" int2,
  "additional_information" varchar(4096),
  "tenant_id" int8,
  "public_key" varchar(1024),
  "private_key" varchar(1024),
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_auth_client_model"."client_model_id" IS '主键';
COMMENT ON COLUMN "sys_auth_client_model"."client_id" IS '客户端id';
COMMENT ON COLUMN "sys_auth_client_model"."client_secret" IS '客户端密码，需要加密';
COMMENT ON COLUMN "sys_auth_client_model"."contract_scope" IS '应用签约的所有权限, 多个用逗号隔开';
COMMENT ON COLUMN "sys_auth_client_model"."allow_url" IS '应用允许授权的所有URL, 多个用逗号隔开';
COMMENT ON COLUMN "sys_auth_client_model"."authorized_grant_type" IS '认证类型';
COMMENT ON COLUMN "sys_auth_client_model"."web_server_redirect_uri" IS '回调地址';
COMMENT ON COLUMN "sys_auth_client_model"."authorities" IS '权限';
COMMENT ON COLUMN "sys_auth_client_model"."access_token_valid_time" IS 'token有效时间';
COMMENT ON COLUMN "sys_auth_client_model"."refresh_token_valid_time" IS '刷新token有效时间';
COMMENT ON COLUMN "sys_auth_client_model"."auto_approve" IS '是否自动放行';
COMMENT ON COLUMN "sys_auth_client_model"."additional_information" IS '扩展信息';
COMMENT ON COLUMN "sys_auth_client_model"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_auth_client_model"."public_key" IS '公钥';
COMMENT ON COLUMN "sys_auth_client_model"."private_key" IS '私钥对';
COMMENT ON COLUMN "sys_auth_client_model"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_auth_client_model"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_auth_client_model"."creator" IS '创建人ID';
COMMENT ON COLUMN "sys_auth_client_model"."last_editor" IS '最后一次修改人ID';
COMMENT ON COLUMN "sys_auth_client_model"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_auth_client_model" IS '认证服务客户端信息';

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_MODEL
-- ----------------------------
BEGIN;
INSERT INTO "sys_auth_client_model" ("client_model_id", "client_id", "client_secret", "contract_scope", "allow_url", "authorized_grant_type", "web_server_redirect_uri", "authorities", "access_token_valid_time", "refresh_token_valid_time", "auto_approve", "additional_information", "tenant_id", "public_key", "private_key", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (742382395743019009, 'hussar-base', 'hussar-base', 'server', '*', 'password', '', '', 1800, 86400, -1, '', -1, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCfREYwkGHyZhEGUxn6G1DIykoB1wJE5njW2cLmb6TLDdJlCI5Mq0afeDmY/fZz4jIveJZqcL7IGVLeDaZOd27/9PBcTrmO2I3tIRlFpWlCPV8bGPbI2na92zmdSjqqrNpkS707nn2n6pzhgOO10bGg9yywK+qm/xQA02qv5rdvUwIDAQAB', 'MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAJ9ERjCQYfJmEQZTGfobUMjKSgHXAkTmeNbZwuZvpMsN0mUIjkyrRp94OZj99nPiMi94lmpwvsgZUt4Npk53bv/08FxOuY7Yje0hGUWlaUI9XxsY9sjadr3bOZ1KOqqs2mRLvTuefafqnOGA47XRsaD3LLAr6qb/FADTaq/mt29TAgMBAAECgYEAnz4NjAsg09O3nAJFC+x55nlUa+iFzUw/cFrE49CnDZuhTQGz/faWo2X6+PyciZuVoB9LDdvy9XFUiM9PBE+oe86zywQOvccLnWmsaCliy/Hy/XovIIfjZEI/h5Ve9FJtpTiiuYHGZYw94wW23qi7/1mSt6eAC76+0XOLvKr8IYkCQQDj7bB71IMNEuBXJGiR9125XfqAEqDYjws/Mxc3dE6B30DG4KhEF4xWnI9UPtrZitMGb3NDdbyMchBCu9hqbCBnAkEAsuHC8ttpnv4X8A9iLFTPKYICs6p+Q+wYnfjNwmT/DVMg9n2f31bguEspip1EVEBiwWaBoae5/SM+6hLLySk2NQJBAJUtAt3495C98wB1vs8R9FCXFpVuG8HA1V6WxLIxuBQ+FvpTHS37r4kcTJ6ZyMiqmHTUyr6zNyVAni3fHcSBYi8CQFt+sAkqAwcorjPCmpNUObXgYuNk1DqHmzvJ0+yXXgGBwH1zWf+RX1XEVBYrRJTXbevAM5Psx2vbyEVPod5dbvUCQQCAavG4AX43+MCDDps4+p4+zlvo9dus+GX6D79ZtDxda/RsHIBCOHyFkalMVTM8EWq1CCzu+aL6lJ4VDry3QGDw', '2021-11-25 07:29:59', '2021-12-20 15:39:17', -1, -1, '0');
INSERT INTO "sys_auth_client_model" ("client_model_id", "client_id", "client_secret", "contract_scope", "allow_url", "authorized_grant_type", "web_server_redirect_uri", "authorities", "access_token_valid_time", "refresh_token_valid_time", "auto_approve", "additional_information", "tenant_id", "public_key", "private_key", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (742436133195227136, 'unified_server', 'unified_server', 'permission_list', '*', 'client_credentials', '', '', 1800, 86400, NULL, '', NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCS0JJzyV2b1tn35AmIsBoUuVUjecq9/BFjODGe823ToHcAIZFvxydWGAd8hzU1yJUGT1DZGgAzvDRtNNMDUnYkCbATDvz7QpPxsheAcZkCYeSXefpT/f15eQZdVgcTcrRDR7KEqUJDLzYwupE5YsSlDsPTubh7TXuc+eAX7l4xiQIDAQAB', 'MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJLQknPJXZvW2ffkCYiwGhS5VSN5yr38EWM4MZ7zbdOgdwAhkW/HJ1YYB3yHNTXIlQZPUNkaADO8NG000wNSdiQJsBMO/PtCk/GyF4BxmQJh5Jd5+lP9/Xl5Bl1WBxNytENHsoSpQkMvNjC6kTlixKUOw9O5uHtNe5z54BfuXjGJAgMBAAECgYAoZa22oHTaea72T8/zxYkXpLtxjISl7CMYqxC0TQUuUxwLdDEhkaoYPXpp4IZaqzueRdrYMhhWI/ZFCmD5rAoHi9ZGljvSLhK1Tw7s15qexZfSgTD1oK8j9aHqC2Sq/iaKNocXYTZzzoHXlFbOSlVMKaB6Zj4p27LNQ/KIvp22gQJBAMIQHP0Ao0cs3o/UTdCl/Su3O1+DtIXsXGgdb5B7sKR7FTilq8DT4PeCvwo/HFiWjUzqiDri+vvSMOq2NtG0CfECQQDBrAzj+FWggYfxhgyPqnyVnBpYrb/Tw2w90HHnzdGUv+WLLWooumdtm+CO9+qDdsjT04fnevh940Wpfke0q8kZAkEAlemiqyOJ/pq/13YXIr6Hg/TJTfDNTMOZYuiSXZffjkBy1U7ODmjfGfULpVu5hwnOYAOxd2QOpOfr1/UpBfhB0QJAHqvrwrLShL/e0q5DEQGUB3GYbpDdv2DEpKl9UJO07FTTuo3vsRGMTbyQ/LNgjX9jYMCwVkWQUweKQcSBAKjwCQJANrnlQfT/iQcj/ABPXRUamTqHD03A1qGNYLGb2GqbwO8dc8PBZ9WPqqDCSimtvM2eTo2rbJnfulV3OULK9CSTyA==', NULL, NULL, -1, -1, '0');
INSERT INTO "sys_auth_client_model" ("client_model_id", "client_id", "client_secret", "contract_scope", "allow_url", "authorized_grant_type", "web_server_redirect_uri", "authorities", "access_token_valid_time", "refresh_token_valid_time", "auto_approve", "additional_information", "tenant_id", "public_key", "private_key", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (812022820434616320, 'message_server', 'message_server', 'permission_list', '*', 'client_credentials', NULL, NULL, 1800, 86400, NULL, NULL, NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHLpAFClRrA3Pk4nkRzDsfUjbnQo3WtQdfg9sf/6fZlDZtWaEfczW/nJU3rkHs8eT6gXaFFSvxoUKVJFhMKvXgTiWVOcCR96UdmeOc8OnUB7z/kEMXdarfZ5X9zB4xFih6FR5lG2FwOZyNqRc9DRBIgjRgxOddnLidlAjJ8d711wIDAQAB', 'MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMcukAUKVGsDc+TieRHMOx9SNudCjda1B1+D2x//p9mUNm1ZoR9zNb+clTeuQezx5PqBdoUVK/GhQpUkWEwq9eBOJZU5wJH3pR2Z45zw6dQHvP+QQxd1qt9nlf3MHjEWKHoVHmUbYXA5nI2pFz0NEEiCNGDE512cuJ2UCMnx3vXXAgMBAAECgYEAvCx+PXTL2inx5KwdCzZyKJ4IZqUW0WBHbfJpIyrpjYIbhWVm9gpnHfY1dtw3Rj4lQJDswsAEuwvJlpM2pAb2L91zKkggdE2g/zOvXJJ97Vl6GLy+NU1QOgP1sjkV5mqVpCQ2sjz1uxrnFGcF6u6f9KK7s1na+OA64anqTY7WRWkCQQD5oyXT0G8Sb35554OvVYLUJifaHhjVUD6v40+R+dPvd9FCCDtIigHa39Py04IgHsg/uQZosCcbePTXo7rQ/pzdAkEAzEIzFYgWw4f04lNlzXAMWlq19eoKuOyimA1akyMHycmI82REGM8ev+kBvw26HwX4iQj1NfKbX8u6CD7479kIQwJBAMMzjaq5O4Eg6bcND22U4f5d75+hFS4H11zV1CyDO/PurxSBN0obkCPEDgm81e2j5FXfqmFGDO5wgJP2FWjDD4kCQE+U405aTXQ1PmYH1DwskcOKYCbF3xOZrufLHCUDmv81tFQQFrAL0pE2+WU0tfVsYB8UDGXOdlbmiz63OkpIpv0CQAs8UXamDvy4GHkq6knuD5dZT1B3ieBnTp+4Eo4qpTe8hqdBaJnINfMOqAyshH/dTN0FmJ9Ogd4VxjlTbrYRskg=', NULL, NULL, 1450756958461300737, 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_OPENID
-- ----------------------------
DROP TABLE IF EXISTS "sys_auth_client_openid";
CREATE TABLE "sys_auth_client_openid" (
  "client_open_id" int8 NOT NULL,
  "client_id" varchar(64),
  "login_id" int8,
  "open_id" varchar(64),
  "tenant_id" int8,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_auth_client_openid"."client_open_id" IS '主键';
COMMENT ON COLUMN "sys_auth_client_openid"."client_id" IS '客户端id';
COMMENT ON COLUMN "sys_auth_client_openid"."login_id" IS '登录人id';
COMMENT ON COLUMN "sys_auth_client_openid"."open_id" IS '开放id';
COMMENT ON COLUMN "sys_auth_client_openid"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_auth_client_openid"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_auth_client_openid"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_auth_client_openid"."creator" IS '创建人ID';
COMMENT ON COLUMN "sys_auth_client_openid"."last_editor" IS '最后一次修改人ID';
COMMENT ON COLUMN "sys_auth_client_openid"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_auth_client_openid" IS 'openid 和client id loginid 对应的关系';

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_OPENID
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_AUTH_CLIENT_SCOPE
-- ----------------------------
DROP TABLE IF EXISTS "sys_auth_client_scope";
CREATE TABLE "sys_auth_client_scope" (
  "scope_id" int8 NOT NULL,
  "scope" varchar(64) NOT NULL,
  "description" varchar(255),
  "tenant_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_auth_client_scope"."scope_id" IS '客户端权限id';
COMMENT ON COLUMN "sys_auth_client_scope"."scope" IS '客户端权限名称';
COMMENT ON COLUMN "sys_auth_client_scope"."description" IS '描述';
COMMENT ON COLUMN "sys_auth_client_scope"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_auth_client_scope"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_auth_client_scope"."creator" IS '创建人';
COMMENT ON COLUMN "sys_auth_client_scope"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_auth_client_scope"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_auth_client_scope"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_auth_client_scope" IS '客户端权限标识表';

-- ----------------------------
-- Records of SYS_AUTH_CLIENT_SCOPE
-- ----------------------------
BEGIN;
INSERT INTO "sys_auth_client_scope" ("scope_id", "scope", "description", "tenant_id", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (111111111111111111, 'hussar-workflow', '流程平台', NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO "sys_auth_client_scope" ("scope_id", "scope", "description", "tenant_id", "create_time", "creator", "last_time", "last_editor", "del_flag") VALUES (662981304710864897, 'unified_server', '统一待办', NULL, NULL, NULL, NULL, NULL, '0');
COMMIT;

-- ----------------------------
-- Table structure for SYS_AUTH_SCOPE_PERMISSION
-- ----------------------------
DROP TABLE IF EXISTS "sys_auth_scope_permission";
CREATE TABLE "sys_auth_scope_permission" (
  "scope_permission_id" int8 NOT NULL,
  "scope_id" int8,
  "permission_id" int8,
  "tenant_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8
)
;
COMMENT ON COLUMN "sys_auth_scope_permission"."scope_permission_id" IS '主键';
COMMENT ON COLUMN "sys_auth_scope_permission"."scope_id" IS '客户端权限id';
COMMENT ON COLUMN "sys_auth_scope_permission"."permission_id" IS '权限id';
COMMENT ON COLUMN "sys_auth_scope_permission"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_auth_scope_permission"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_auth_scope_permission"."creator" IS '创建人';
COMMENT ON COLUMN "sys_auth_scope_permission"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_auth_scope_permission"."last_editor" IS '修改人';
COMMENT ON TABLE "sys_auth_scope_permission" IS '客户端权限标识关联权限表';

-- ----------------------------
-- Records of SYS_AUTH_SCOPE_PERMISSION
-- ----------------------------
BEGIN;
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864902, 662981304710864897, 690528754686238720, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864903, 662981304710864897, 690528390436102144, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864904, 662981304710864897, 690528302003396608, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864905, 662981304710864897, 690525973787189248, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864906, 662981304710864897, 690525700498923520, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864907, 662981304710864897, 690525592055193600, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864908, 662981304710864897, 690525462312787968, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864909, 662981304710864897, 690525353298632704, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864910, 662981304710864897, 690525197148889088, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864911, 662981304710864897, 690525099648098304, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864912, 662981304710864897, 690525019226513408, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864913, 662981304710864897, 690524899974062080, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864915, 662981304710864897, 690522779594006528, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864916, 662981304710864897, 690522261102534656, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864917, 662981304710864897, 690641814235127808, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864918, 662981304710864897, 690641909710069760, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
INSERT INTO "sys_auth_scope_permission" ("scope_permission_id", "scope_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864919, 662981304710864897, 697104639711256576, NULL, '2023-03-20 19:59:32', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_AUTH_SOCIAL_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS "sys_auth_social_details";
CREATE TABLE "sys_auth_social_details" (
  "social_id" int8 NOT NULL,
  "type" varchar(16),
  "remark" varchar(64),
  "app_id" varchar(64),
  "app_secret" varchar(64),
  "redirect_url" varchar(128),
  "tenant_id" int4 NOT NULL,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_auth_social_details"."social_id" IS '主鍵';
COMMENT ON COLUMN "sys_auth_social_details"."type" IS '社交登录类型';
COMMENT ON COLUMN "sys_auth_social_details"."remark" IS '备注';
COMMENT ON COLUMN "sys_auth_social_details"."app_id" IS '申请社交三方appId';
COMMENT ON COLUMN "sys_auth_social_details"."app_secret" IS '申请社交三方app密码';
COMMENT ON COLUMN "sys_auth_social_details"."redirect_url" IS '三方回调url';
COMMENT ON COLUMN "sys_auth_social_details"."tenant_id" IS '所属租户';
COMMENT ON COLUMN "sys_auth_social_details"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_auth_social_details"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_auth_social_details"."creator" IS '创建人';
COMMENT ON COLUMN "sys_auth_social_details"."last_editor" IS '修改时间';
COMMENT ON COLUMN "sys_auth_social_details"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_auth_social_details" IS '系统社交登录账号表';

-- ----------------------------
-- Records of SYS_AUTH_SOCIAL_DETAILS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_BANNER_ADVERTISEMENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_banner_advertisement";
CREATE TABLE "sys_banner_advertisement" (
  "ad_id" int8 NOT NULL,
  "ad_title" varchar(32),
  "picture_id" int8,
  "image_background" varchar(255),
  "ad_link" varchar(512),
  "ad_outside" char(1),
  "ad_status" char(1),
  "ad_due_time" timestamp without time zone,
  "closed_status" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_banner_advertisement"."ad_id" IS 'id';
COMMENT ON COLUMN "sys_banner_advertisement"."ad_title" IS '横幅标题';
COMMENT ON COLUMN "sys_banner_advertisement"."picture_id" IS '图片链接';
COMMENT ON COLUMN "sys_banner_advertisement"."image_background" IS '背景';
COMMENT ON COLUMN "sys_banner_advertisement"."ad_link" IS '跳转链接';
COMMENT ON COLUMN "sys_banner_advertisement"."ad_outside" IS '是否外链，0-内部；1-外部';
COMMENT ON COLUMN "sys_banner_advertisement"."ad_status" IS '广告状态：0-启用，1-停用';
COMMENT ON COLUMN "sys_banner_advertisement"."ad_due_time" IS '广告过期时间';
COMMENT ON COLUMN "sys_banner_advertisement"."closed_status" IS '是否可关闭：0-是，1-否';
COMMENT ON COLUMN "sys_banner_advertisement"."creator" IS '创建人';
COMMENT ON COLUMN "sys_banner_advertisement"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_banner_advertisement"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_banner_advertisement"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_banner_advertisement" IS '横幅广告表';

-- ----------------------------
-- Records of SYS_BANNER_ADVERTISEMENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_BASE_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_base_config";
CREATE TABLE "sys_base_config" (
  "config_id" int8 NOT NULL,
  "name" varchar(32),
  "config_key" varchar(32),
  "config_value" varchar(1024),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "example" varchar(1024),
  "parent_id" int8,
  "config_rule" varchar(50)
)
;
COMMENT ON COLUMN "sys_base_config"."config_id" IS '主键';
COMMENT ON COLUMN "sys_base_config"."name" IS '描述';
COMMENT ON COLUMN "sys_base_config"."config_key" IS '键';
COMMENT ON COLUMN "sys_base_config"."config_value" IS '值';
COMMENT ON COLUMN "sys_base_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_base_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_base_config"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_base_config"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_base_config"."example" IS '示例';
COMMENT ON COLUMN "sys_base_config"."parent_id" IS '上级id';
COMMENT ON COLUMN "sys_base_config"."config_rule" IS '校验规则';
COMMENT ON TABLE "sys_base_config" IS '平台基础配置表';

-- ----------------------------
-- Records of SYS_BASE_CONFIG
-- ----------------------------
BEGIN;
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (111, '账户配置', 'account_config', '', NULL, NULL, NULL, NULL, '账户配置项，在账户未登录天数超过配置时，账户状态会变为休眠，若没有再次被激活，则会被自动注销，账户状态变化和自动注销前都会给账户配置的邮箱发送提示短信', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (222, '登录失败配置', 'login_fail_config', NULL, NULL, NULL, NULL, NULL, '密码输入错误相关配置，在连续失败时间内达到了配置连续失败次数时，会对账号按锁定时间进行锁定，若配置了失败消息接收邮箱，会发送邮件提醒', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (333, '登录时间配置', 'login_time_config', NULL, NULL, NULL, NULL, NULL, '登录时间配置，开启后只有在允许的时间段内登录系统', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (444, '登录ip配置', 'login_ip_config', NULL, NULL, NULL, NULL, NULL, '登录ip配置，配置允许或禁止某些ip地址登录系统，限制外的ip地址登录时会发送邮件提醒', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (666, '密码配置', 'password_config', '', NULL, NULL, NULL, NULL, '用户密码配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (777, '创建用户配置', 'user_create_config', '', NULL, NULL, NULL, NULL, '创建用户配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (888, '页面配置', 'theme_config', '', NULL, NULL, NULL, NULL, '页面参数配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (999, '审核配置', 'audit_config', '', NULL, NULL, NULL, NULL, '审核配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1111, '未登录天数', 'nologin_day', '-1', NULL, NULL, NULL, NULL, '单位天。超过配置天数账号会休眠，-1为不休眠', 111, 'checkNumber');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1112, '账户状态', 'user_account_status', '3', NULL, NULL, NULL, NULL, '单选框。休眠', 111, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1113, '休眠提醒邮件标题', 'status_change_email_title', '账户状态变更提醒', NULL, NULL, NULL, NULL, '自动休眠提醒邮件标题', 111, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1114, '休眠提醒邮件内容', 'status_change_email', '您的账号:#{user_account},由于超过#{nologin_day}天未登录，账户已被#{user_account_status}。</br>如要继续使用，请联系管理员', NULL, NULL, NULL, NULL, '自动休眠提醒邮件模版', 111, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1115, '休眠多久自动注销', 'logout_day', '365', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：365', 111, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1116, '注销前多久发送邮件', 'email_before_logout_day', '5', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：5', 111, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1117, '注销提醒邮件标题', 'logout_warn_email_title', '账户注销提醒', NULL, NULL, NULL, NULL, '自动注销提醒邮件标题', 111, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1118, '注销提醒邮件内容', 'logout_warn_email', '您的账号:#{user_account},将在#{email_before_logout_day}天后注销。</br>如要继续使用，请尽快联系管理员', NULL, NULL, NULL, NULL, '自动注销提醒邮件模板', 111, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2221, '连续失败时间', 'fail_time', '1', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例：3', 222, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2222, '连续失败次数', 'fail_number', '5', NULL, NULL, NULL, NULL, '正整数。示例 ：3', 222, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2223, '连续失败锁定时间', 'fail_lock_time', '2', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例 ：60', 222, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2224, '失败消息接收邮箱', 'fail_email_box', '', NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', 222, 'checkEmails');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2225, '失败邮件标题', 'fail_email_title', '账号连续登录失败提醒', NULL, NULL, NULL, NULL, '账户锁定邮件标题', 222, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2226, '失败邮件内容', 'fail_email', '用户账号:#{user_account}密码连续输入错误#{fail_number}次，账号已被锁定', NULL, NULL, NULL, NULL, '账户锁定邮件模板', 222, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (3331, '登录时间限制', 'login_time_limit', '1', NULL, NULL, NULL, NULL, '登录限制开关', 333, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (3332, '允许登录开始时间', 'login_start_time', '08:00:00', NULL, NULL, NULL, NULL, '允许登录开始时间', 333, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (3333, '允许登录结束时间', 'login_end_time', '20:00:00', NULL, NULL, NULL, NULL, '允许登录结束时间', 333, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4441, '登录ip限制', 'login_ip_limit', '1', NULL, NULL, NULL, NULL, 'ip限制开关', 444, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4442, '允许登录ip', 'allow_login_ip', '', NULL, NULL, NULL, NULL, '允许访问系统的ip,ip之间英文逗号分隔，不填写不生效', 444, 'checkIPs');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4443, '禁止登录ip', 'forbid_login_ip', '', NULL, NULL, NULL, NULL, '禁止访问系统的ip,ip之间英文逗号分隔，不填写不生效', 444, 'checkIPs');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4444, 'ip预警接收邮箱', 'ip_warn_email_box', '', NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', 444, 'checkEmails');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4445, 'ip预警邮件标题', 'ip_warn_email_title', 'ip登录预警', NULL, NULL, NULL, NULL, 'ip预警邮件标题', 444, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (4446, 'ip预警邮件模板', 'ip_warn_email', '存在未经允许的ip登录系统，ip地址：#{ip_address}</br>用户名称：#{user_name}</br>用户账号：#{user_account}', NULL, NULL, NULL, NULL, 'ip预警邮件模板', 444, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (5551, '会话限制', 'session_limit', '0', NULL, NULL, NULL, NULL, '默认开启', 555, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (5552, '最大会话数', 'max_session_num', '1000000', NULL, NULL, NULL, NULL, '系统最大会话数，同时开启session_limit和kickout_after时才生效，配置为-1为不限制会话数量', 555, 'checkNumber');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (5553, '会话超出限制时，踢出后者', 'kickout_after', '0', NULL, NULL, NULL, NULL, '开启时剔除后者即新登录用户不能登录，关闭时剔除最先登录的', 555, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6661, '系统缺省密码规则', 'pwd_rule', '8,16,3', NULL, NULL, NULL, NULL, '系统缺省密码规则（"最小长度，最大长度，密码强度"）,缺省规则是( 8,16,3 )最小不能小于8位，最大不能大于16位，强度为3
密码强度规则分1-3级，各级的含义如下：
级别1：如果密码只由数字、小写字母、大写字母或其它特殊符号当中的一种组成,则认为这是一个弱密码.
级别2：如果密码由数字、小写字母、大写字母或其它特殊符号当中的两种组成,则认为这是一个中度安全的密码
级别3：如果密码由数字、小写字母、大写字母或其它特殊符号当中的三种以上组成,则认为这是一个比较安全的密码.', 666, 'checkStrengthRule');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6663, '自定义密码复杂度', 'pwd_rule_custom', '1', NULL, NULL, NULL, NULL, '开启自定义时,pwd_complexity_regular 自定义正则表达式，unmatched_hint 自定义返回消息；不开启时使用平台自带规则', 666, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6664, '密码复杂度正则', 'pwd_complexity_regular', '/^[\\S]{6,12}$/', NULL, NULL, NULL, NULL, '正则校验密码规则', 666, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6665, '自定义返回消息', 'unmatched_hint', '新密码不符合密码规则！', NULL, NULL, NULL, NULL, '修改密码时的自定义返回消息，开启自定义密码复杂度时生效', 666, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6666, '强制修改密码', 'force_change_pwd', '0', NULL, NULL, NULL, NULL, '是否在第一次登录或一段时间后强制用户修改密码', 666, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6667, '密码生命周期', 'password_hist', '90', NULL, NULL, NULL, NULL, '正整数，多少天后强制修改密码  单位（天）', 666, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (6668, '密码重复次数', 'pwd_repeat_time', '2', NULL, NULL, NULL, NULL, '正整数，密码不能和前几次相同', 666, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (7771, '创建用户时发送邮件', 'create_user_send_email', '1', NULL, NULL, NULL, NULL, '创建用户时发送邮件开关', 777, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (7772, '创建用户时使用默认密码', 'create_user_use_default_pass', '0', NULL, NULL, NULL, NULL, '创建用户是否使用默认密码，开启时使用默认密码，不开启时使用密码规则生成的密码。为防止生成的密码无法得知，当create_user_send_email关闭时也使用默认密码', 777, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (7773, '用户默认密码', 'default_password', '123456', NULL, NULL, NULL, NULL, '用户默认密码，可输入数字、大写字母、小写字母、英文特殊字符（`~!@#$%^&*()_|+<>?:"{},./;''[]-）', 777, 'checkdefultpw');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (7775, '操作人员同时操作用户', 'operate_staff_with_user', '1', NULL, NULL, NULL, NULL, '开启时操作人员同时操作用户（新增、修改、删除、转移）', 777, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (8883, '标签页切换刷新', 'tab_switchover', '0', NULL, NULL, NULL, NULL, '标签页切换刷新开关，重新登录后生效', 888, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9991, '关键操作审核', 'critical_operations_audit', '1', NULL, NULL, NULL, NULL, '关键操作是否需要审核，总开关，只有开启后，下面几个开关才分别生效', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9992, '组织机构审核', 'organ_audit', '0', NULL, NULL, NULL, NULL, '组织机构操作审核开关', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9993, '用户审核', 'user_audit', '0', NULL, NULL, NULL, NULL, '用户操作审核开关', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9994, '用户角色审核', 'role_audit', '0', NULL, NULL, NULL, NULL, '用户角色操作审核开关', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9996, '登录页背景图', 'login_view_background', '', NULL, NULL, NULL, NULL, '登录页背景图', 202020, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9997, '登录框背景图', 'login_view_innerBackground', '', NULL, NULL, NULL, NULL, '登录框背景图', 202020, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (9998, '浏览器页签图标的配置项', 'relation_icon', '', NULL, NULL, NULL, NULL, '浏览器页签图标的配置项', 212121, '');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (99910, '岗位审核', 'post_audit', '0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', '岗位操作审核开关', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (99911, '人员审核', 'staff_audit', '0', NULL, NULL, 1450756958461300737, '2023-05-26 10:03:27', '人员操作审核开关', 999, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (101010, '异常报警配置', 'exception_config', '', NULL, NULL, NULL, NULL, '异常报警配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (121212, '登录配置', 'login_config', '', NULL, NULL, NULL, NULL, '登录配置', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (202020, '登录页可视化配置', 'login_view_config', NULL, NULL, NULL, NULL, NULL, '门户登录页可视化配置', 2, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (212121, '首页可视化配置', 'home_page', NULL, NULL, NULL, NULL, NULL, '首页可视化配置', 2, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1010101, '审计日志报警条数', 'securitylog_count_alert', '100000', NULL, NULL, NULL, NULL, '超过此条数时报警，只能输入正整数，默认不发送，配置后才发送', 101010, 'checkPositiveNum');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1010102, '异常报警', 'exception_alert', '1', NULL, NULL, NULL, NULL, '异常报警开关，权限异常时会发送告警邮件', 101010, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1010103, '异常报警接收邮件邮箱', 'exception_alert_email', '', NULL, NULL, NULL, NULL, '多个邮箱使用,隔开', 101010, 'checkEmails');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1212121, '区分登录账号大小写', 'login_upper_open', '0', NULL, NULL, NULL, NULL, '区分登录账号大小写开关', 121212, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1212122, '登录验证码', 'kaptcha_open', '1', NULL, NULL, NULL, NULL, 'console端登录验证码开关。如需配置门户验证码开关，请前往门户配置中心-登录页配置-配置项。', 121212, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1212123, '登录时动态密码验证', 'totp_open', '1', NULL, NULL, NULL, NULL, '登录动态密码验证开关', 121212, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1212124, '动态密码验证允许时间偏差', 'totp_offset_min', '2', NULL, NULL, NULL, NULL, '单位 min 分钟， 默认0，无偏差验证，必须保证手机端和服务器时间误差在30s之内才能准确验证', 121212, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (1212125, '令牌有效时间', 'access_token_valid_time', '1800', NULL, NULL, 1450756958461300737, '2023-07-20 19:30:43', '令牌有效时间，单位秒。', 121212, 'checkTokenValidTime');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020201, '登录布局', 'login_view_type', '1', NULL, NULL, NULL, NULL, '登录页面布局', 202020, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020202, '系统名称', 'login_view_sysname', '统一门户', NULL, NULL, NULL, NULL, '登录页面显示的系统名称', 202020, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020203, '系统LOGO', 'login_view_logo', '', NULL, NULL, NULL, NULL, '登录页面显示的系统logo', 202020, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020204, '版权所有', 'login_view_copyright', '', NULL, NULL, NULL, NULL, '登录页面显示的版权所有信息', 202020, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020205, '验证码', 'login_view_kaptcha', '1', NULL, NULL, NULL, NULL, '登录时是否进行验证码验证', 202020, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2020206, '记住密码', 'login_rememberpwd', '1', NULL, NULL, NULL, NULL, '登录时是否记住密码', 202020, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2121211, '首页布局类型', 'home_page_type', '0', NULL, NULL, NULL, NULL, '首页布局类型', 212121, 'checkRadio');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2121212, '首页系统名称', 'home_page_sysname', '统一门户', NULL, NULL, NULL, NULL, '首页显示系统名称', 212121, 'checkNotEmpty');
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (2121213, '首页系统LOGO', 'home_page_logo', '', NULL, NULL, NULL, NULL, '首页显示系统LOGO', 212121, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (202202170, '主题权限配置', 'theme_config_edit', '1', NULL, NULL, NULL, NULL, '主题权限配置，是否启用主题配置编辑功能', 1, NULL);
INSERT INTO "sys_base_config" ("config_id", "name", "config_key", "config_value", "create_time", "creator", "last_editor", "last_time", "example", "parent_id", "config_rule") VALUES (202202171, '主题权限配置', 'enable_theme_config_edit', '1', NULL, NULL, NULL, NULL, '是否启用主题配置编辑功能', 202202170, 'checkRadio');
COMMIT;

-- ----------------------------
-- Table structure for SYS_BATCH_DOWNLOAD_TASK
-- ----------------------------
DROP TABLE IF EXISTS "sys_batch_download_task";
CREATE TABLE "sys_batch_download_task" (
  "task_id" int8 NOT NULL,
  "task_status" int4,
  "file_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_batch_download_task"."task_id" IS '任务id';
COMMENT ON COLUMN "sys_batch_download_task"."task_status" IS '任务状态 0.开始下载 1.下载成功 -1.失败';
COMMENT ON COLUMN "sys_batch_download_task"."file_id" IS '文件id';

-- ----------------------------
-- Records of SYS_BATCH_DOWNLOAD_TASK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_BUSINESS_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_business_config";
CREATE TABLE "sys_business_config" (
  "config_id" int8 NOT NULL,
  "config_name" varchar(255),
  "config_scene" varchar(255),
  "config_tag" varchar(255),
  "config_type" int4,
  "permission_rule" text,
  "config_key" varchar(255),
  "config_value" text,
  "remark1" varchar(255),
  "remark2" varchar(255),
  "remark3" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_business_config"."config_id" IS '业务主键';
COMMENT ON COLUMN "sys_business_config"."config_name" IS '配置名称';
COMMENT ON COLUMN "sys_business_config"."config_scene" IS '场景';
COMMENT ON COLUMN "sys_business_config"."config_tag" IS '标签';
COMMENT ON COLUMN "sys_business_config"."config_type" IS '配置类型（0系统：所有人可见，1个人：创建者可见）';
COMMENT ON COLUMN "sys_business_config"."permission_rule" IS '自定义配置规则';
COMMENT ON COLUMN "sys_business_config"."config_key" IS '配置key';
COMMENT ON COLUMN "sys_business_config"."config_value" IS '配置值';
COMMENT ON COLUMN "sys_business_config"."remark1" IS '扩展字段1（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "sys_business_config"."remark2" IS '扩展字段2（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "sys_business_config"."remark3" IS '扩展字段3（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "sys_business_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_business_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_business_config"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_business_config"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_business_config"."del_flag" IS '是否删除';
COMMENT ON TABLE "sys_business_config" IS '业务配置管理';

-- ----------------------------
-- Records of SYS_BUSINESS_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CALENDAR
-- ----------------------------
DROP TABLE IF EXISTS "sys_calendar";
CREATE TABLE "sys_calendar" (
  "calendar_id" int8 NOT NULL,
  "title" varchar(32),
  "start_time" timestamp without time zone,
  "end_time" timestamp without time zone,
  "class_name" varchar(32),
  "creator" int8,
  "last_editor" int8,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "remark" varchar(256),
  "status" char(1)
)
;
COMMENT ON COLUMN "sys_calendar"."calendar_id" IS '主键';
COMMENT ON COLUMN "sys_calendar"."title" IS '事件标题';
COMMENT ON COLUMN "sys_calendar"."start_time" IS '开始时间';
COMMENT ON COLUMN "sys_calendar"."end_time" IS '结束时间';
COMMENT ON COLUMN "sys_calendar"."class_name" IS '事件的样式';
COMMENT ON COLUMN "sys_calendar"."creator" IS '创建人';
COMMENT ON COLUMN "sys_calendar"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_calendar"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_calendar"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_calendar"."remark" IS '备注';
COMMENT ON COLUMN "sys_calendar"."status" IS '状态';
COMMENT ON TABLE "sys_calendar" IS '工作日历表';

-- ----------------------------
-- Records of SYS_CALENDAR
-- ----------------------------
BEGIN;
INSERT INTO "sys_calendar" ("calendar_id", "title", "start_time", "end_time", "class_name", "creator", "last_editor", "create_time", "last_time", "remark", "status") VALUES (1450383908880433153, '班', '2018-05-01 00:00:00', NULL, 'work', NULL, NULL, '2018-05-22 00:00:00', NULL, NULL, NULL);
INSERT INTO "sys_calendar" ("calendar_id", "title", "start_time", "end_time", "class_name", "creator", "last_editor", "create_time", "last_time", "remark", "status") VALUES (1450384023288541185, '休', '2018-05-04 00:00:00', NULL, 'holiday', NULL, NULL, NULL, NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_CLIENT_MODEL
-- ----------------------------
DROP TABLE IF EXISTS "sys_client_model";
CREATE TABLE "sys_client_model" (
  "client_model_id" int8 NOT NULL,
  "client_id" varchar(64) NOT NULL,
  "client_secret" varchar(64) NOT NULL,
  "contract_scope" varchar(128),
  "allow_url" varchar(1024),
  "authorized_grant_type" varchar(128),
  "web_server_redirect_uri" varchar(128),
  "authorities" varchar(128),
  "access_token_valid_time" int4,
  "refresh_token_valid_time" int4,
  "auto_approve" int2,
  "additional_information" varchar(4096),
  "tenant_id" int8,
  "public_key" varchar(1024),
  "private_key" varchar(1024),
  "application_id" int8 NOT NULL,
  "client_status" char(1),
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_client_model"."client_model_id" IS '主键';
COMMENT ON COLUMN "sys_client_model"."client_id" IS '客户端id';
COMMENT ON COLUMN "sys_client_model"."client_secret" IS '客户端密码，需要加密';
COMMENT ON COLUMN "sys_client_model"."contract_scope" IS '应用签约的所有权限, 多个用逗号隔开';
COMMENT ON COLUMN "sys_client_model"."allow_url" IS '应用允许授权的所有URL, 多个用逗号隔开';
COMMENT ON COLUMN "sys_client_model"."authorized_grant_type" IS '认证类型';
COMMENT ON COLUMN "sys_client_model"."web_server_redirect_uri" IS '回调地址';
COMMENT ON COLUMN "sys_client_model"."authorities" IS '权限';
COMMENT ON COLUMN "sys_client_model"."access_token_valid_time" IS 'token有效时间';
COMMENT ON COLUMN "sys_client_model"."refresh_token_valid_time" IS '刷新token有效时间';
COMMENT ON COLUMN "sys_client_model"."auto_approve" IS '是否自动放行';
COMMENT ON COLUMN "sys_client_model"."additional_information" IS '扩展信息';
COMMENT ON COLUMN "sys_client_model"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_client_model"."public_key" IS '公钥';
COMMENT ON COLUMN "sys_client_model"."private_key" IS '私钥对';
COMMENT ON COLUMN "sys_client_model"."application_id" IS '应用ID';
COMMENT ON COLUMN "sys_client_model"."client_status" IS '客户端状态（0：禁用，1：启用）';
COMMENT ON COLUMN "sys_client_model"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_client_model"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_client_model"."creator" IS '创建人ID';
COMMENT ON COLUMN "sys_client_model"."last_editor" IS '最后一次修改人ID';
COMMENT ON COLUMN "sys_client_model"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_client_model" IS '客户端信息表';

-- ----------------------------
-- Records of SYS_CLIENT_MODEL
-- ----------------------------
BEGIN;
INSERT INTO "sys_client_model" ("client_model_id", "client_id", "client_secret", "contract_scope", "allow_url", "authorized_grant_type", "web_server_redirect_uri", "authorities", "access_token_valid_time", "refresh_token_valid_time", "auto_approve", "additional_information", "tenant_id", "public_key", "private_key", "application_id", "client_status", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (737637974124273664, 'unified_server', 'unified_server', 'permission_list', '*', 'client_credentials', '', '', 1800, 86400, NULL, '', NULL, 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCaBvKGkCJWCfbBtlAFAc55yqCcs9fUHh5RyL/5FZ2XetZCuPPJD4/WJofKNW+KSGUK2Gfvxlqe55Ynmp6kFh02E0LWOejr3QaV97Y6zWCYoVEnKIBey3qAeQwR6+5kXPdGwRJ4Gl9l0kdH5DXChTWno96LE/xHMkBLY1Ozvo506QIDAQAB', 'MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAJoG8oaQIlYJ9sG2UAUBznnKoJyz19QeHlHIv/kVnZd61kK488kPj9Ymh8o1b4pIZQrYZ+/GWp7nlieanqQWHTYTQtY56OvdBpX3tjrNYJihUScogF7LeoB5DBHr7mRc90bBEngaX2XSR0fkNcKFNaej3osT/EcyQEtjU7O+jnTpAgMBAAECgYAsBuJaHmcCKvTyqBc1Zy/K1mWUhT+jLTzDadud6lTSkNUf21gr15vovbjAzwdkAo+HSxZijlMm6tGb3nGMO5n7gi9ayjUpoD4Cb0lfBHdBYKEsWMuZsEDsc0QGsz809MF02Ib1E1twCsEDJpZqCBLBJKzaHd751cpCQN7GXLx4EQJBANXJFJVVgiaVrmySKoTAvl66YA0i8yjKdApLIGl1w7GYvKaMl0wSpVdKUFKss9crgWnUSPKyRF+27qnR7UGEH4UCQQC4cRC7fnA2RnMRBtCXCNy1NaRh+ffnCQe3Im9lAlkWv7jMswj+EXNqsqd3Kp5lRciY01ovfI0G7f7528LOLRMVAkBMCQl+F3yD1qbDzLS8pITQ0j7JTU3oiyD8bD3p5E2mw6kNH2HMV7Fgu3iX/v6zn7CWgD81unuhA0IdOiHFNIW1AkBhT34FfhsT961j8VWCKjHQBYI6ExlBMtl4PNnK0CdSwkps7ZSz/18Gj0WdsMWrJttEDlaJsUvyuQSKrPCluNBVAkB66fFNW6wd1w5ELdZuPI2ErEsrf9x7cxTMl99OYctIr1U+E/Hr/3aVuSpsPeVwuv9gFNLjNhM9F/iIP34HO1X7', 1, '1', NULL, NULL, -1, -1, '0');
INSERT INTO "sys_client_model" ("client_model_id", "client_id", "client_secret", "contract_scope", "allow_url", "authorized_grant_type", "web_server_redirect_uri", "authorities", "access_token_valid_time", "refresh_token_valid_time", "auto_approve", "additional_information", "tenant_id", "public_key", "private_key", "application_id", "client_status", "create_time", "last_time", "creator", "last_editor", "del_flag") VALUES (812022819872579584, 'message_server', 'message_server', NULL, NULL, NULL, NULL, NULL, 1800, 0, NULL, NULL, NULL, NULL, NULL, 1, '1', NULL, NULL, 1450756958461300737, 1450756958461300737, '0');
COMMIT;

-- ----------------------------
-- Table structure for SYS_CLIENT_PERMISSION
-- ----------------------------
DROP TABLE IF EXISTS "sys_client_permission";
CREATE TABLE "sys_client_permission" (
  "client_permission_id" int8 NOT NULL,
  "scope" varchar(64),
  "client_id" varchar(64) NOT NULL,
  "permission_id" int8 NOT NULL,
  "tenant_id" int8 NOT NULL,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8
)
;
COMMENT ON COLUMN "sys_client_permission"."client_permission_id" IS '主键';
COMMENT ON COLUMN "sys_client_permission"."scope" IS '权限范围';
COMMENT ON COLUMN "sys_client_permission"."client_id" IS '客户端ID';
COMMENT ON COLUMN "sys_client_permission"."permission_id" IS '权限ID';
COMMENT ON COLUMN "sys_client_permission"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_client_permission"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_client_permission"."creator" IS '创建人';
COMMENT ON COLUMN "sys_client_permission"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_client_permission"."last_editor" IS '修改人';
COMMENT ON TABLE "sys_client_permission" IS '客户端关联资源表';

-- ----------------------------
-- Records of SYS_CLIENT_PERMISSION
-- ----------------------------
BEGIN;
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864903, 'permission_list', 'unified_server', 690528390436102144, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864904, 'permission_list', 'unified_server', 690528302003396608, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864905, 'permission_list', 'unified_server', 690525973787189248, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864906, 'permission_list', 'unified_server', 690525700498923520, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864907, 'permission_list', 'unified_server', 690525592055193600, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864908, 'permission_list', 'unified_server', 690525462312787968, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864909, 'permission_list', 'unified_server', 690525353298632704, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864910, 'permission_list', 'unified_server', 690525197148889088, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864911, 'permission_list', 'unified_server', 690525099648098304, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864912, 'permission_list', 'unified_server', 690525019226513408, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864913, 'permission_list', 'unified_server', 690524899974062080, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864915, 'permission_list', 'unified_server', 690522779594006528, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864916, 'permission_list', 'unified_server', 690522261102534656, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864917, 'permission_list', 'unified_server', 690641814235127808, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864918, 'permission_list', 'unified_server', 690641909710069760, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864919, 'permission_list', 'unified_server', 697104639711256576, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864920, 'permission_list', 'unified_server', 697104639711256577, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864921, 'permission_list', 'unified_server', 697104639711256578, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864922, 'permission_list', 'unified_server', 697104639711256579, 0, '2023-06-07 15:35:00', 1450756958461300737, '2023-06-07 15:35:00', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864923, 'permission_list', 'unified_server', 697104639711256583, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864924, 'permission_list', 'unified_server', 697104639711256584, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864925, 'permission_list', 'unified_server', 697104639711256585, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864926, 'permission_list', 'unified_server', 697104639711256580, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864927, 'permission_list', 'unified_server', 697104639711256581, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (662981304710864928, 'permission_list', 'unified_server', 697104639711256582, 0, '2020-08-10 16:42:42', 1450756958461300737, '2020-08-10 16:42:42', 1450756958461300737);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (812248181407752192, 'permission_list', 'message_server', 576393382897917952, 0, NULL, NULL, NULL, NULL);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (812248181432918016, 'permission_list', 'message_server', 812025848596275200, 0, NULL, NULL, NULL, NULL);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (812248181445500928, 'permission_list', 'message_server', 812026141606158336, 0, NULL, NULL, NULL, NULL);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (812248181458083840, 'permission_list', 'message_server', 812026329171238912, 0, NULL, NULL, NULL, NULL);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (812248181470666752, 'permission_list', 'message_server', 812026421143937024, 0, NULL, NULL, NULL, NULL);
INSERT INTO "sys_client_permission" ("client_permission_id", "scope", "client_id", "permission_id", "tenant_id", "create_time", "creator", "last_time", "last_editor") VALUES (825419437611163649, 'permission_list', 'message_server', 825417701370634240, 0, '2024-03-27 17:22:09', 1450756958461300737, '2024-03-27 17:22:09', 1450756958461300737);
COMMIT;

-- ----------------------------
-- Table structure for SYS_CODE_RULE
-- ----------------------------
DROP TABLE IF EXISTS "sys_code_rule";
CREATE TABLE "sys_code_rule" (
  "code_rule_id" int8 NOT NULL,
  "code_rule_code" varchar(128) NOT NULL,
  "code_rule_name" varchar(128),
  "code_rule_desc" varchar(128),
  "is_sys" varchar(1),
  "app_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "is_level" varchar(1)
)
;
COMMENT ON COLUMN "sys_code_rule"."code_rule_id" IS '编码规则ID';
COMMENT ON COLUMN "sys_code_rule"."code_rule_code" IS '编码规则CODE(唯一)';
COMMENT ON COLUMN "sys_code_rule"."code_rule_name" IS '中文名';
COMMENT ON COLUMN "sys_code_rule"."code_rule_desc" IS '简介';
COMMENT ON COLUMN "sys_code_rule"."is_sys" IS '是否系统编码';
COMMENT ON COLUMN "sys_code_rule"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_code_rule"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_code_rule"."creator" IS '创建人';
COMMENT ON COLUMN "sys_code_rule"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_code_rule"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_code_rule"."is_level" IS '是否层级编码';
COMMENT ON TABLE "sys_code_rule" IS '编码规则信息表';

-- ----------------------------
-- Records of SYS_CODE_RULE
-- ----------------------------
BEGIN;
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (622468560387842048, 'SYS_ORGAN:ORGAN_CODE_4', '组织机构编码生成规则', '组织机构编码生成规则', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '0');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (624170019827490816, 'SYS_STAFF:STAFF_CODE', '人员编码生成规则', '人员编码生成规则', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '0');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (723599456163078144, 'SYS_POST:POST_CODE', '岗位编码', '岗位编码', '1', NULL, '2023-06-20 18:05:54', 1450756958461300737, '2023-06-20 18:05:54', 1450756958461300737, '0');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640706, 'SYS_RESOURCE_MODULES:MODULE_CODE', '模块编码', '模块编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640708, 'SYS_RESOURCES:RESOURCE_CODE', '资源编码', '资源编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640713, 'SYS_FUNCTIONS:FUNCTION_CODE', '功能编码', '功能编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640717, 'SYS_FUNCTION_MODULES:FUNCTION_MODULE_CODE', '功能模块编码', '功能模块编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640718, 'SYS_APPLICATION:APP_CODE', '应用编码', '应用编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640719, 'SYS_RESOURCE_TYPE:RESOURCE_TYPE_CODE', '资源类型编码', '资源类型编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
INSERT INTO "sys_code_rule" ("code_rule_id", "code_rule_code", "code_rule_name", "code_rule_desc", "is_sys", "app_id", "create_time", "creator", "last_time", "last_editor", "is_level") VALUES (1450754032317640720, 'SYS_RESOURCE_TYPE_EXPAND:RESOURCE_TYPE_EXPAND_CODE', '资源类型拓展属性编码', '资源类型拓展属性编码', '1', NULL, '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0, '1');
COMMIT;

-- ----------------------------
-- Table structure for SYS_CODE_RULE_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_code_rule_info";
CREATE TABLE "sys_code_rule_info" (
  "code_rule_info_id" int8 NOT NULL,
  "code_rule_id" int8 NOT NULL,
  "code_rule_sort" int4,
  "element_type" varchar(32),
  "element_pattern" varchar(128),
  "serial_number_length" int4,
  "serial_number_code" int8,
  "serial_number_start" int8,
  "now_period" varchar(32),
  "reset_period" varchar(32),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8
)
;
COMMENT ON COLUMN "sys_code_rule_info"."code_rule_info_id" IS '编码配置信息表ID';
COMMENT ON COLUMN "sys_code_rule_info"."code_rule_id" IS '编码规则ID';
COMMENT ON COLUMN "sys_code_rule_info"."code_rule_sort" IS '排序码';
COMMENT ON COLUMN "sys_code_rule_info"."element_type" IS '元素类型';
COMMENT ON COLUMN "sys_code_rule_info"."element_pattern" IS '元素格式';
COMMENT ON COLUMN "sys_code_rule_info"."serial_number_length" IS '流水号长度';
COMMENT ON COLUMN "sys_code_rule_info"."serial_number_code" IS '流水号当前编码';
COMMENT ON COLUMN "sys_code_rule_info"."serial_number_start" IS '流水号初始值';
COMMENT ON COLUMN "sys_code_rule_info"."now_period" IS '当前周期';
COMMENT ON COLUMN "sys_code_rule_info"."reset_period" IS '重置周期';
COMMENT ON COLUMN "sys_code_rule_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_code_rule_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_code_rule_info"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_code_rule_info"."last_editor" IS '最后一次修改人';
COMMENT ON TABLE "sys_code_rule_info" IS '编码配置信息表';

-- ----------------------------
-- Records of SYS_CODE_RULE_INFO
-- ----------------------------
BEGIN;
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312342302720, 622468560387842048, 1, 'serialNumber', '1', 11, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312438771712, 624170019827490816, 1, 'serialNumber', '1', 11, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312572989440, 1450754032317640706, 1, 'serialNumber', '1', 12, 272, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312694624256, 1450754032317640708, 1, 'serialNumber', '1', 12, 5070153, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312828841984, 1450754032317640713, 1, 'serialNumber', '1', 12, 253, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312828841985, 1450754032317640718, 1, 'serialNumber', '1', 10, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312958865408, 1450754032317640715, 1, 'serialNumber', '1', 8, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701312958865409, 1450754032317640719, 1, 'serialNumber', '1', 4, 5, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701313093083136, 1450754032317640717, 1, 'serialNumber', '1', 4, 37, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (708701313093083137, 1450754032317640720, 1, 'serialNumber', '1', 4, 0, 1, NULL, '1', '2023-05-10 15:26:00', 0, '2023-05-10 15:26:00', 0);
INSERT INTO "sys_code_rule_info" ("code_rule_info_id", "code_rule_id", "code_rule_sort", "element_type", "element_pattern", "serial_number_length", "serial_number_code", "serial_number_start", "now_period", "reset_period", "create_time", "creator", "last_time", "last_editor") VALUES (723599456225992704, 723599456163078144, 1, 'serialNumber', '1', 11, 0, 1, '', '1', '2023-06-20 18:05:54', 1450756958461300737, '2023-06-20 18:05:54', 1450756958461300737);
COMMIT;

-- ----------------------------
-- Table structure for SYS_CODE_RULE_LEVEL_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_code_rule_level_info";
CREATE TABLE "sys_code_rule_level_info" (
  "level_info_id" int8 NOT NULL,
  "code_rule_id" int8,
  "id_value" varchar(32),
  "parent_number" varchar(32),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8
)
;
COMMENT ON COLUMN "sys_code_rule_level_info"."level_info_id" IS '层级码ID';
COMMENT ON COLUMN "sys_code_rule_level_info"."code_rule_id" IS '编码规则ID';
COMMENT ON COLUMN "sys_code_rule_level_info"."id_value" IS '当前值';
COMMENT ON COLUMN "sys_code_rule_level_info"."parent_number" IS '父级ID';
COMMENT ON COLUMN "sys_code_rule_level_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_code_rule_level_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_code_rule_level_info"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_code_rule_level_info"."last_editor" IS '最后一次修改人';
COMMENT ON TABLE "sys_code_rule_level_info" IS '编码层级信息表';

-- ----------------------------
-- Records of SYS_CODE_RULE_LEVEL_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
DROP TABLE IF EXISTS "sys_commonly_use_organ_user";
CREATE TABLE "sys_commonly_use_organ_user" (
  "commonly_use_id" int8 NOT NULL,
  "commonly_use_type" int4,
  "organ_user_id" int8,
  "use_count" int4,
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_commonly_use_organ_user"."commonly_use_id" IS '主键id';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."commonly_use_type" IS '类型(0：部门，1：用户)';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."organ_user_id" IS '部门/用户id';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."use_count" IS '使用次数';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_commonly_use_organ_user"."del_flag" IS '是否删除';
COMMENT ON TABLE "sys_commonly_use_organ_user" IS '常用选人选部门';

-- ----------------------------
-- Records of SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CONF_ROLES
-- ----------------------------
DROP TABLE IF EXISTS "sys_conf_roles";
CREATE TABLE "sys_conf_roles" (
  "scr_id" int8 NOT NULL,
  "role_id" int8 NOT NULL,
  "set_id" int8 NOT NULL,
  "sys_set_id" int8
)
;
COMMENT ON COLUMN "sys_conf_roles"."scr_id" IS '主键';
COMMENT ON COLUMN "sys_conf_roles"."role_id" IS '角色编码';
COMMENT ON COLUMN "sys_conf_roles"."set_id" IS '不相容角色集编码';
COMMENT ON COLUMN "sys_conf_roles"."sys_set_id" IS '不相容角色集编码';
COMMENT ON TABLE "sys_conf_roles" IS '不相容角色';

-- ----------------------------
-- Records of SYS_CONF_ROLES
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CONF_ROLESET
-- ----------------------------
DROP TABLE IF EXISTS "sys_conf_roleset";
CREATE TABLE "sys_conf_roleset" (
  "set_id" int8 NOT NULL,
  "set_name" varchar(32),
  "cardinality" int4,
  "corporation_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "roleset_remark" varchar(128)
)
;
COMMENT ON COLUMN "sys_conf_roleset"."set_id" IS '不相容角色集编码';
COMMENT ON COLUMN "sys_conf_roleset"."set_name" IS '不相容角色集名称';
COMMENT ON COLUMN "sys_conf_roleset"."cardinality" IS '基数';
COMMENT ON COLUMN "sys_conf_roleset"."corporation_id" IS '所属公司结构编码';
COMMENT ON COLUMN "sys_conf_roleset"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_conf_roleset"."creator" IS '创建人';
COMMENT ON COLUMN "sys_conf_roleset"."last_time" IS '最后一次更新时间';
COMMENT ON COLUMN "sys_conf_roleset"."last_editor" IS '最后一次更新人';
COMMENT ON COLUMN "sys_conf_roleset"."roleset_remark" IS '描述';
COMMENT ON TABLE "sys_conf_roleset" IS '不相容角色集';

-- ----------------------------
-- Records of SYS_CONF_ROLESET
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CUSTOMIZED_COMPONENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_customized_component";
CREATE TABLE "sys_customized_component" (
  "customized_component_id" int8 NOT NULL,
  "css_file" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_customized_component"."customized_component_id" IS '主键';
COMMENT ON COLUMN "sys_customized_component"."css_file" IS 'css文件';
COMMENT ON COLUMN "sys_customized_component"."creator" IS '创建人';
COMMENT ON COLUMN "sys_customized_component"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_customized_component"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_customized_component"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_customized_component" IS '定制化组件信息表';

-- ----------------------------
-- Records of SYS_CUSTOMIZED_COMPONENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CUSTOM_BUTTON
-- ----------------------------
DROP TABLE IF EXISTS "sys_custom_button";
CREATE TABLE "sys_custom_button" (
  "button_id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8,
  "button_name" varchar(20),
  "button_alias" varchar(20),
  "type" varchar(255),
  "button_description" varchar(255),
  "button_action" varchar(255),
  "button_icon" varchar(255),
  "button_style" int4,
  "button_color" varchar(255),
  "background_color" varchar(255),
  "button_event" int4,
  "button_position" varchar(255),
  "button_filter" text,
  "not_satisfied_hidden" int2,
  "button_fill_action" text,
  "button_update_action" text,
  "custom_page" text,
  "second_confirm" int2,
  "second_confirm_setting" text,
  "button_seq" int4,
  "button_data_pull_action_id" int8
)
;
COMMENT ON COLUMN "sys_custom_button"."button_id" IS '自定义按钮id';
COMMENT ON COLUMN "sys_custom_button"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_custom_button"."form_id" IS '自定义按钮所属表单id';
COMMENT ON COLUMN "sys_custom_button"."button_name" IS '自定义按钮名称';
COMMENT ON COLUMN "sys_custom_button"."button_alias" IS '自定义按钮别名';
COMMENT ON COLUMN "sys_custom_button"."type" IS '按钮类型, custom：自定义按钮';
COMMENT ON COLUMN "sys_custom_button"."button_description" IS '自定义按钮说明';
COMMENT ON COLUMN "sys_custom_button"."button_action" IS '按钮的权限标识';
COMMENT ON COLUMN "sys_custom_button"."button_icon" IS '按钮图标';
COMMENT ON COLUMN "sys_custom_button"."button_style" IS '按钮风格，1:主要按钮，2:次要按钮';
COMMENT ON COLUMN "sys_custom_button"."button_color" IS '按钮字体颜色';
COMMENT ON COLUMN "sys_custom_button"."background_color" IS '按钮背景颜色';
COMMENT ON COLUMN "sys_custom_button"."button_event" IS '自定义按钮动作类型,1:填写指定内容,2:更新数据,3:打开自定义页面';
COMMENT ON COLUMN "sys_custom_button"."button_position" IS '自定义按钮显示位置，1：详情页，2：表格页，逗号分隔';
COMMENT ON COLUMN "sys_custom_button"."button_filter" IS '自定义按钮的可用条件';
COMMENT ON COLUMN "sys_custom_button"."not_satisfied_hidden" IS '是否隐藏不满足条件的按钮';
COMMENT ON COLUMN "sys_custom_button"."button_fill_action" IS '自定义按钮执行填写指定内容动作参数';
COMMENT ON COLUMN "sys_custom_button"."button_update_action" IS '自定义按钮执行更新数据动作参数';
COMMENT ON COLUMN "sys_custom_button"."custom_page" IS '自定义按钮打开自定义页面动作参数';
COMMENT ON COLUMN "sys_custom_button"."second_confirm" IS '自定义按钮是否需要二次确认';
COMMENT ON COLUMN "sys_custom_button"."second_confirm_setting" IS '二次确认信息';
COMMENT ON COLUMN "sys_custom_button"."button_seq" IS '自定义按钮显示顺序的序号';
COMMENT ON TABLE "sys_custom_button" IS '自定义按钮表';

-- ----------------------------
-- Records of SYS_CUSTOM_BUTTON
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_custom_list_field_info";
CREATE TABLE "sys_custom_list_field_info" (
  "info_id" int8 NOT NULL,
  "user_id" int8,
  "page_id" varchar(36),
  "component_id" varchar(36),
  "component_info" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" varchar(1)
)
;
COMMENT ON COLUMN "sys_custom_list_field_info"."info_id" IS '主键';
COMMENT ON COLUMN "sys_custom_list_field_info"."user_id" IS '用户ID';
COMMENT ON COLUMN "sys_custom_list_field_info"."page_id" IS '页面ID';
COMMENT ON COLUMN "sys_custom_list_field_info"."component_id" IS '组件ID';
COMMENT ON COLUMN "sys_custom_list_field_info"."component_info" IS '组件信息';
COMMENT ON COLUMN "sys_custom_list_field_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_custom_list_field_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_custom_list_field_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_custom_list_field_info"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_custom_list_field_info"."del_flag" IS '是否已删除(0 正常 1 已删除)';
COMMENT ON TABLE "sys_custom_list_field_info" IS '自定义字段信息表';

-- ----------------------------
-- Records of SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CUSTOM_VIEW
-- ----------------------------
DROP TABLE IF EXISTS "sys_custom_view";
CREATE TABLE "sys_custom_view" (
  "view_id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "view_name" varchar(32),
  "alias" varchar(32),
  "category" varchar(32),
  "view_type" int2,
  "tab_type" varchar(16),
  "styles" text,
  "buttons" text,
  "tools" text,
  "filters" text,
  "order_by" text,
  "show_fields" text,
  "del_flag" char(1),
  "visible" char(8),
  "view_permission" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "show_fields_multi" text
)
;
COMMENT ON COLUMN "sys_custom_view"."view_id" IS '主键id';
COMMENT ON COLUMN "sys_custom_view"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_custom_view"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_custom_view"."view_name" IS '视图名称';
COMMENT ON COLUMN "sys_custom_view"."alias" IS '视图别名';
COMMENT ON COLUMN "sys_custom_view"."category" IS '视图种类';
COMMENT ON COLUMN "sys_custom_view"."view_type" IS '视图类型';
COMMENT ON COLUMN "sys_custom_view"."tab_type" IS '标签类型';
COMMENT ON COLUMN "sys_custom_view"."styles" IS '表格样式';
COMMENT ON COLUMN "sys_custom_view"."buttons" IS '表格操作按钮';
COMMENT ON COLUMN "sys_custom_view"."tools" IS '表格工具按钮';
COMMENT ON COLUMN "sys_custom_view"."filters" IS '数据过滤';
COMMENT ON COLUMN "sys_custom_view"."order_by" IS '排序';
COMMENT ON COLUMN "sys_custom_view"."show_fields" IS '显示字段';
COMMENT ON COLUMN "sys_custom_view"."del_flag" IS '逻辑删除字段';
COMMENT ON COLUMN "sys_custom_view"."visible" IS '视图显隐';
COMMENT ON COLUMN "sys_custom_view"."view_permission" IS '可见范围';
COMMENT ON COLUMN "sys_custom_view"."creator" IS '创建人';
COMMENT ON COLUMN "sys_custom_view"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_custom_view"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_custom_view"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_custom_view"."show_fields_multi" IS '多级表头';
COMMENT ON TABLE "sys_custom_view" IS '自定义视图表';

-- ----------------------------
-- Records of SYS_CUSTOM_VIEW
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_CUSTOM_VIEW_HIDE_ORDER
-- ----------------------------
DROP TABLE IF EXISTS "sys_custom_view_hide_order";
CREATE TABLE "sys_custom_view_hide_order" (
  "id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "user_id" int8 NOT NULL,
  "view_order" text,
  "view_hide" text,
  "del_flag" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_custom_view_hide_order"."id" IS '主键id';
COMMENT ON COLUMN "sys_custom_view_hide_order"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_custom_view_hide_order"."user_id" IS '用户id';
COMMENT ON COLUMN "sys_custom_view_hide_order"."view_order" IS '视图排序';
COMMENT ON COLUMN "sys_custom_view_hide_order"."view_hide" IS '视图显隐';
COMMENT ON COLUMN "sys_custom_view_hide_order"."del_flag" IS '逻辑删除字段';
COMMENT ON COLUMN "sys_custom_view_hide_order"."creator" IS '创建人';
COMMENT ON COLUMN "sys_custom_view_hide_order"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_custom_view_hide_order"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_custom_view_hide_order"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_custom_view_hide_order" IS '自定义视图顺序表';

-- ----------------------------
-- Records of SYS_CUSTOM_VIEW_HIDE_ORDER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DASHBOARD_ENTRY
-- ----------------------------
DROP TABLE IF EXISTS "sys_dashboard_entry";
CREATE TABLE "sys_dashboard_entry" (
  "entry_id" int8 NOT NULL,
  "entry_name" varchar(128),
  "parent_id" int8,
  "app_id" varchar(64),
  "group_id" varchar(64),
  "icon" varchar(64),
  "datasource_id" int8,
  "datasource_name" text,
  "datasource_type" int4,
  "entry_type" varchar(64),
  "entry_status" char(1),
  "entry_option" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_dashboard_entry"."entry_id" IS '主键';
COMMENT ON COLUMN "sys_dashboard_entry"."entry_name" IS '所属应用ID';
COMMENT ON COLUMN "sys_dashboard_entry"."parent_id" IS '父ID';
COMMENT ON COLUMN "sys_dashboard_entry"."app_id" IS '所属应用ID';
COMMENT ON COLUMN "sys_dashboard_entry"."group_id" IS '分组ID';
COMMENT ON COLUMN "sys_dashboard_entry"."icon" IS '排序';
COMMENT ON COLUMN "sys_dashboard_entry"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "sys_dashboard_entry"."datasource_name" IS '数据源名称';
COMMENT ON COLUMN "sys_dashboard_entry"."datasource_type" IS '数据源类型';
COMMENT ON COLUMN "sys_dashboard_entry"."entry_type" IS '图表类型';
COMMENT ON COLUMN "sys_dashboard_entry"."entry_status" IS '状态';
COMMENT ON COLUMN "sys_dashboard_entry"."entry_option" IS '配置信息';
COMMENT ON COLUMN "sys_dashboard_entry"."creator" IS '创建者';
COMMENT ON COLUMN "sys_dashboard_entry"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_dashboard_entry"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_dashboard_entry"."last_time" IS '上次编辑时间';
COMMENT ON TABLE "sys_dashboard_entry" IS '仪表盘信息表';

-- ----------------------------
-- Records of SYS_DASHBOARD_ENTRY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_LOGIC_FILTER
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_logic_filter";
CREATE TABLE "sys_data_logic_filter" (
  "filter_id" int8 NOT NULL,
  "role_data_logic_id" int8,
  "field_id" varchar(64),
  "field_name" varchar(64),
  "filter_condition_code" varchar(64),
  "filter_condition_name" varchar(10),
  "filter_value" text,
  "create_time" timestamp without time zone,
  "last_time" timestamp without time zone,
  "creator" int8,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_data_logic_filter"."filter_id" IS '主键';
COMMENT ON COLUMN "sys_data_logic_filter"."role_data_logic_id" IS '所属数据逻辑ID';
COMMENT ON COLUMN "sys_data_logic_filter"."field_id" IS '表单内字段ID';
COMMENT ON COLUMN "sys_data_logic_filter"."field_name" IS '字段名';
COMMENT ON COLUMN "sys_data_logic_filter"."filter_condition_code" IS '过滤条件编码';
COMMENT ON COLUMN "sys_data_logic_filter"."filter_condition_name" IS '过滤条件名';
COMMENT ON COLUMN "sys_data_logic_filter"."filter_value" IS '过滤条件值';
COMMENT ON COLUMN "sys_data_logic_filter"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_logic_filter"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_data_logic_filter"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_logic_filter"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_logic_filter"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_data_logic_filter" IS '表单数据逻辑过滤条件表';

-- ----------------------------
-- Records of SYS_DATA_LOGIC_FILTER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_OPERATE_LOG
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_operate_log";
CREATE TABLE "sys_data_operate_log" (
  "operate_id" int8 NOT NULL,
  "data_id" int8,
  "old_record" text,
  "new_record" text,
  "child_record" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "form_id" int8,
  "app_id" int8,
  "count" int4,
  "op_type" int4,
  "op_mode" int4,
  "trigger_form_id" int8,
  "child_count" text,
  "device" varchar(255),
  "button_id" int8,
  "widget" text
)
;
COMMENT ON COLUMN "sys_data_operate_log"."operate_id" IS '操作日志id';
COMMENT ON COLUMN "sys_data_operate_log"."data_id" IS '数据id';
COMMENT ON COLUMN "sys_data_operate_log"."old_record" IS '旧数据';
COMMENT ON COLUMN "sys_data_operate_log"."new_record" IS '新数据';
COMMENT ON COLUMN "sys_data_operate_log"."child_record" IS '子表操作记录';
COMMENT ON COLUMN "sys_data_operate_log"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_operate_log"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_operate_log"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_data_operate_log"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_data_operate_log"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_data_operate_log"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_data_operate_log"."count" IS '修改条数';
COMMENT ON COLUMN "sys_data_operate_log"."op_type" IS '操作类型0：新增1：修改2：删除';
COMMENT ON COLUMN "sys_data_operate_log"."op_mode" IS '操作方式0：手动修改1：表格导入2：自定义按钮3：业务规则4：应用导入5：表单导入';
COMMENT ON COLUMN "sys_data_operate_log"."trigger_form_id" IS '业务规则触发表单id，非业务规则方式则为空';
COMMENT ON COLUMN "sys_data_operate_log"."child_count" IS '子表操作条数，ADD新增，UPDATE:修改，DEL删除';
COMMENT ON COLUMN "sys_data_operate_log"."device" IS '操作设备，PC电脑端，Mobile移动端，Unknown未知设备';
COMMENT ON COLUMN "sys_data_operate_log"."button_id" IS '自定义按钮触发按钮id，非自定义按钮触发则为空';
COMMENT ON COLUMN "sys_data_operate_log"."widget" IS '画布属性';
COMMENT ON TABLE "sys_data_operate_log" IS '数据操作日志表';

-- ----------------------------
-- Records of SYS_DATA_OPERATE_LOG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PULL_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_pull_config";
CREATE TABLE "sys_data_pull_config" (
  "id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8 NOT NULL,
  "name" varchar(200) NOT NULL,
  "trigger_action" char(1) NOT NULL,
  "trigger_begin_time" timestamp without time zone,
  "trigger_end_time_set" char(1),
  "trigger_end_time" timestamp without time zone,
  "repeat_mode" varchar(255),
  "pull_mode" char(1),
  "url" varchar(500) NOT NULL,
  "params" text,
  "field_maps" text,
  "status" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "last_execute_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_data_pull_config"."id" IS '数据拉取主键id';
COMMENT ON COLUMN "sys_data_pull_config"."app_id" IS '应用 ID';
COMMENT ON COLUMN "sys_data_pull_config"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_data_pull_config"."name" IS '数据拉取规则名称';
COMMENT ON COLUMN "sys_data_pull_config"."trigger_action" IS '0为定时触发,1为主动触发';
COMMENT ON COLUMN "sys_data_pull_config"."trigger_begin_time" IS '触发开始时间';
COMMENT ON COLUMN "sys_data_pull_config"."trigger_end_time_set" IS '是否设置触发结束时间1设置0不设置';
COMMENT ON COLUMN "sys_data_pull_config"."trigger_end_time" IS '触发结束时间';
COMMENT ON COLUMN "sys_data_pull_config"."repeat_mode" IS '重复模式1为每天触发一次';
COMMENT ON COLUMN "sys_data_pull_config"."pull_mode" IS '0为全量1为增量';
COMMENT ON COLUMN "sys_data_pull_config"."url" IS 'api地址';
COMMENT ON COLUMN "sys_data_pull_config"."params" IS '入参';
COMMENT ON COLUMN "sys_data_pull_config"."field_maps" IS '字段映射配置';
COMMENT ON COLUMN "sys_data_pull_config"."status" IS '开启状态';
COMMENT ON COLUMN "sys_data_pull_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_pull_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_pull_config"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_pull_config"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_data_pull_config"."last_execute_time" IS '上一次执行时间';
COMMENT ON TABLE "sys_data_pull_config" IS '数据拉取规则表';

-- ----------------------------
-- Records of SYS_DATA_PULL_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PULL_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_pull_record";
CREATE TABLE "sys_data_pull_record" (
  "record_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "pull_id" int8,
  "pull_name" varchar(200),
  "url" varchar(200),
  "http_status" varchar(8),
  "success" varchar(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "result" text,
  "params" text
)
;
COMMENT ON COLUMN "sys_data_pull_record"."record_id" IS '数据推送拉取记录主键id';
COMMENT ON COLUMN "sys_data_pull_record"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_data_pull_record"."pull_id" IS '推送规则id';
COMMENT ON COLUMN "sys_data_pull_record"."pull_name" IS '拉取规则名称';
COMMENT ON COLUMN "sys_data_pull_record"."url" IS 'API调用地址';
COMMENT ON COLUMN "sys_data_pull_record"."http_status" IS 'http状态码';
COMMENT ON COLUMN "sys_data_pull_record"."success" IS '结果1成功0失败';
COMMENT ON COLUMN "sys_data_pull_record"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_pull_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_pull_record"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_pull_record"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_data_pull_record"."result" IS '返回结果';
COMMENT ON COLUMN "sys_data_pull_record"."params" IS '请求参数';
COMMENT ON TABLE "sys_data_pull_record" IS '数据拉取日志';

-- ----------------------------
-- Records of SYS_DATA_PULL_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PULL_TASK
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_pull_task";
CREATE TABLE "sys_data_pull_task" (
  "id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8,
  "config_id" int8,
  "first_execute_time" timestamp without time zone,
  "repeat_rule" varchar(255),
  "next_execute_time" timestamp without time zone,
  "end_execute_time" timestamp without time zone,
  "status" char(1),
  "execute_time" timestamp without time zone,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "url" varchar(500) NOT NULL,
  "params" text,
  "field_maps" text,
  "end_execute_time_set" char(1)
)
;
COMMENT ON COLUMN "sys_data_pull_task"."id" IS '主键';
COMMENT ON COLUMN "sys_data_pull_task"."app_id" IS '应用 ID';
COMMENT ON COLUMN "sys_data_pull_task"."form_id" IS '表单 ID';
COMMENT ON COLUMN "sys_data_pull_task"."config_id" IS '配置 ID';
COMMENT ON COLUMN "sys_data_pull_task"."first_execute_time" IS '首次执行时间';
COMMENT ON COLUMN "sys_data_pull_task"."repeat_rule" IS '重复规则';
COMMENT ON COLUMN "sys_data_pull_task"."next_execute_time" IS '下次执行时间';
COMMENT ON COLUMN "sys_data_pull_task"."end_execute_time" IS '结束执行时间';
COMMENT ON COLUMN "sys_data_pull_task"."status" IS '执行状态';
COMMENT ON COLUMN "sys_data_pull_task"."execute_time" IS '执行时间';
COMMENT ON COLUMN "sys_data_pull_task"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_pull_task"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_pull_task"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_data_pull_task"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_data_pull_task"."del_flag" IS '删除标志';
COMMENT ON COLUMN "sys_data_pull_task"."url" IS 'api地址';
COMMENT ON COLUMN "sys_data_pull_task"."params" IS '入参';
COMMENT ON COLUMN "sys_data_pull_task"."field_maps" IS '字段映射配置';
COMMENT ON COLUMN "sys_data_pull_task"."end_execute_time_set" IS '是否设置执行结束时间';

-- ----------------------------
-- Records of SYS_DATA_PULL_TASK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_push_config";
CREATE TABLE "sys_data_push_config" (
  "id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8,
  "name" varchar(255),
  "trigger_action" varchar(255),
  "trigger_condition" text,
  "url" varchar(255),
  "field_maps" text,
  "status" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_data_push_config"."id" IS '主键';
COMMENT ON COLUMN "sys_data_push_config"."app_id" IS '应用 ID';
COMMENT ON COLUMN "sys_data_push_config"."form_id" IS '表单 ID';
COMMENT ON COLUMN "sys_data_push_config"."name" IS '规则名称';
COMMENT ON COLUMN "sys_data_push_config"."trigger_action" IS '触发动作';
COMMENT ON COLUMN "sys_data_push_config"."trigger_condition" IS '触发条件';
COMMENT ON COLUMN "sys_data_push_config"."url" IS '推送地址';
COMMENT ON COLUMN "sys_data_push_config"."field_maps" IS '字段映射';
COMMENT ON COLUMN "sys_data_push_config"."status" IS '开启状态';
COMMENT ON COLUMN "sys_data_push_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_push_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_push_config"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_data_push_config"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_data_push_config"."del_flag" IS '删除标志';
COMMENT ON TABLE "sys_data_push_config" IS '数据推送规则表';

-- ----------------------------
-- Records of SYS_DATA_PUSH_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_MAP_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_push_map_config";
CREATE TABLE "sys_data_push_map_config" (
  "id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "field_map" text NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_data_push_map_config"."id" IS 'ID';
COMMENT ON COLUMN "sys_data_push_map_config"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_data_push_map_config"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_data_push_map_config"."field_map" IS '映射关系';
COMMENT ON COLUMN "sys_data_push_map_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_push_map_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_push_map_config"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_data_push_map_config"."last_time" IS '修改时间';
COMMENT ON TABLE "sys_data_push_map_config" IS '表单全局字段映射';

-- ----------------------------
-- Records of SYS_DATA_PUSH_MAP_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_PUSH_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_push_record";
CREATE TABLE "sys_data_push_record" (
  "record_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "push_id" int8,
  "push_name" varchar(200),
  "url" varchar(200),
  "param" text,
  "http_status" varchar(8),
  "success" varchar(1),
  "result" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_data_push_record"."record_id" IS '数据推送拉取记录主键id';
COMMENT ON COLUMN "sys_data_push_record"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_data_push_record"."push_id" IS '推送规则id';
COMMENT ON COLUMN "sys_data_push_record"."push_name" IS '推送规则名称';
COMMENT ON COLUMN "sys_data_push_record"."url" IS 'API调用地址';
COMMENT ON COLUMN "sys_data_push_record"."param" IS '入参';
COMMENT ON COLUMN "sys_data_push_record"."http_status" IS 'http状态码';
COMMENT ON COLUMN "sys_data_push_record"."success" IS '标志';
COMMENT ON COLUMN "sys_data_push_record"."result" IS '返回结果';
COMMENT ON COLUMN "sys_data_push_record"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_push_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_push_record"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_push_record"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_data_push_record" IS '数据推送日志';

-- ----------------------------
-- Records of SYS_DATA_PUSH_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_SET_GROUP
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_set_group";
CREATE TABLE "sys_data_set_group" (
  "group_id" int8 NOT NULL,
  "group_name" varchar(32),
  "seq" int4,
  "group_icon" varchar(32),
  "group_icon_type" char(1),
  "group_type" char(1),
  "group_icon_color" varchar(32),
  "app_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_data_set_group"."group_id" IS '数据集分组id';
COMMENT ON COLUMN "sys_data_set_group"."group_name" IS '数据集分组名称';
COMMENT ON COLUMN "sys_data_set_group"."seq" IS '分组显示顺序';
COMMENT ON COLUMN "sys_data_set_group"."group_icon" IS '数据集分组图标';
COMMENT ON COLUMN "sys_data_set_group"."group_icon_type" IS '分组图标类型1：内置图标2：用户自定义';
COMMENT ON COLUMN "sys_data_set_group"."group_type" IS '分组类型1:默认分组2:普通分组';
COMMENT ON COLUMN "sys_data_set_group"."group_icon_color" IS '分组图标颜色';
COMMENT ON COLUMN "sys_data_set_group"."app_id" IS '数据集应用ID';
COMMENT ON COLUMN "sys_data_set_group"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_set_group"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_set_group"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_set_group"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_data_set_group" IS '数据集分组表';

-- ----------------------------
-- Records of SYS_DATA_SET_GROUP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DATA_SET_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_data_set_info";
CREATE TABLE "sys_data_set_info" (
  "data_set_id" int8 NOT NULL,
  "data_set_name" varchar(32),
  "data_set_code" varchar(64),
  "data_set_icon_type" varchar(32),
  "data_set_icon" varchar(32),
  "data_set_icon_color" varchar(32),
  "seq" int4,
  "data_set_desc" varchar(255),
  "data_source_id" int8,
  "data_source_name" varchar(32),
  "data_source_type" varchar(32),
  "group_id" int8,
  "app_id" int8,
  "data_set_type" char(1),
  "data" text,
  "del_flag" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_data_set_info"."data_set_id" IS '数据集ID';
COMMENT ON COLUMN "sys_data_set_info"."data_set_name" IS '数据集名称';
COMMENT ON COLUMN "sys_data_set_info"."data_set_code" IS '数据集标识';
COMMENT ON COLUMN "sys_data_set_info"."data_set_icon_type" IS '数据集图标类型';
COMMENT ON COLUMN "sys_data_set_info"."data_set_icon" IS '数据集图标';
COMMENT ON COLUMN "sys_data_set_info"."data_set_icon_color" IS '内置图标颜色';
COMMENT ON COLUMN "sys_data_set_info"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_data_set_info"."data_set_desc" IS '数据集描述';
COMMENT ON COLUMN "sys_data_set_info"."data_source_id" IS '数据源id';
COMMENT ON COLUMN "sys_data_set_info"."data_source_name" IS '数据源名称';
COMMENT ON COLUMN "sys_data_set_info"."data_source_type" IS '数据源类型';
COMMENT ON COLUMN "sys_data_set_info"."group_id" IS '数据集分组ID';
COMMENT ON COLUMN "sys_data_set_info"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_data_set_info"."data_set_type" IS '数据集类型';
COMMENT ON COLUMN "sys_data_set_info"."data" IS '数据集信息';
COMMENT ON COLUMN "sys_data_set_info"."del_flag" IS '需要逻辑删除的业务添加该字段';
COMMENT ON COLUMN "sys_data_set_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_data_set_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_data_set_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_data_set_info"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_data_set_info" IS '数据集信息表';

-- ----------------------------
-- Records of SYS_DATA_SET_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_DICT_GROUP
-- ----------------------------
DROP TABLE IF EXISTS "sys_dict_group";
CREATE TABLE "sys_dict_group" (
  "group_id" int8 NOT NULL,
  "parent_id" int8,
  "group_description" varchar(256),
  "range_type" varchar(256),
  "app_id" int8,
  "sort" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "bak_1" varchar(256),
  "bak_2" varchar(255),
  "bak_3" varchar(256)
)
;
COMMENT ON COLUMN "sys_dict_group"."group_id" IS '主键';
COMMENT ON COLUMN "sys_dict_group"."parent_id" IS '父ID';
COMMENT ON COLUMN "sys_dict_group"."group_description" IS '字典分组描述';
COMMENT ON COLUMN "sys_dict_group"."range_type" IS '编辑类型';
COMMENT ON COLUMN "sys_dict_group"."app_id" IS '所属应用id';
COMMENT ON COLUMN "sys_dict_group"."sort" IS '排序';
COMMENT ON COLUMN "sys_dict_group"."creator" IS '创建者';
COMMENT ON COLUMN "sys_dict_group"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_dict_group"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_dict_group"."last_time" IS '上次编辑时间';
COMMENT ON COLUMN "sys_dict_group"."bak_1" IS '备用字段1';
COMMENT ON COLUMN "sys_dict_group"."bak_2" IS '备用字段2';
COMMENT ON COLUMN "sys_dict_group"."bak_3" IS '备用字段3';
COMMENT ON TABLE "sys_dict_group" IS '字典分组表';

-- ----------------------------
-- Records of SYS_DICT_GROUP
-- ----------------------------
BEGIN;
INSERT INTO "sys_dict_group" ("group_id", "parent_id", "group_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450384393200865282, 11, '系统字典', 'sys', NULL, 1, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);
INSERT INTO "sys_dict_group" ("group_id", "parent_id", "group_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450384438474231809, 11, '业务字典', 'biz', NULL, 2, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_DICT_SINGLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_dict_single";
CREATE TABLE "sys_dict_single" (
  "dict_id" int8 NOT NULL,
  "type_id" int8,
  "value" varchar(128),
  "label" varchar(128),
  "app_id" int8,
  "sort" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "bak_1" varchar(256),
  "bak_2" varchar(256),
  "bak_3" varchar(256),
  "parent_id" int8
)
;
COMMENT ON COLUMN "sys_dict_single"."dict_id" IS '编号';
COMMENT ON COLUMN "sys_dict_single"."type_id" IS '类型(SYS_DICT_TYPE外键)';
COMMENT ON COLUMN "sys_dict_single"."value" IS '数据值';
COMMENT ON COLUMN "sys_dict_single"."label" IS '标签名';
COMMENT ON COLUMN "sys_dict_single"."app_id" IS '所属应用id';
COMMENT ON COLUMN "sys_dict_single"."sort" IS '排序';
COMMENT ON COLUMN "sys_dict_single"."creator" IS '创建者';
COMMENT ON COLUMN "sys_dict_single"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_dict_single"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_dict_single"."last_time" IS '上次编辑时间';
COMMENT ON COLUMN "sys_dict_single"."bak_1" IS '备用字段1';
COMMENT ON COLUMN "sys_dict_single"."bak_2" IS '备用字段2';
COMMENT ON COLUMN "sys_dict_single"."bak_3" IS '备用字段3';
COMMENT ON COLUMN "sys_dict_single"."parent_id" IS '父级主键ID';
COMMENT ON TABLE "sys_dict_single" IS '字典字段表';

-- ----------------------------
-- Records of SYS_DICT_SINGLE
-- ----------------------------
BEGIN;
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (517670394224975872, 517670295990181888, '1', '驳回', NULL, 1, 1450756958461300737, '2021-11-29 11:57:20', 1450756958461300737, '2021-11-29 11:57:20', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (517670664690475008, 517670295990181888, '2', '驳回，请重新申请', NULL, 2, 1450756958461300737, '2021-11-29 11:58:24', 1450756958461300737, '2021-11-29 11:58:24', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (517670721909170176, 517670295990181888, '3', '驳回至第一节点', NULL, 3, 1450756958461300737, '2021-11-29 11:58:38', 1450756958461300737, '2021-11-29 11:58:38', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (523443293179355136, 523443198920761344, '0', '内部组件', NULL, 1, NULL, '2021-12-15 10:16:46', NULL, '2021-12-15 10:16:46', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (523444544218603520, 523443198920761344, '1', '外部组件', NULL, 2, NULL, '2021-12-15 10:21:44', NULL, '2021-12-15 10:21:44', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (523444626317910016, 523443198920761344, '3', 'URL', NULL, 4, NULL, '2021-12-15 10:22:04', NULL, '2021-12-15 10:22:04', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (524165267232923648, 524165175805485056, '1', '公告', NULL, 1, 1450756958461300737, '2021-12-17 10:05:38', 1450756958461300737, '2021-12-17 10:05:38', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (524611884536832000, 524165175805485056, '2', '通知', NULL, 2, 1450756958461300737, '2021-12-18 15:40:20', 1450756958461300737, '2021-12-18 15:40:20', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586233816600027136, 586233551075418112, '1', '阿里云', NULL, 1, 1450756958461300737, '2022-06-06 16:43:54', 1450756958461300737, '2022-06-06 16:43:54', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586233852901728256, 586233551075418112, '2', '腾讯云', NULL, 2, 1450756958461300737, '2022-06-06 16:44:02', 1450756958461300737, '2022-06-06 16:44:02', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586260304451870654, 575022217952501760, '1', '待发送', NULL, 1, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586260304451870720, 575022217952501760, '2', '发送失败', NULL, 2, 1450756958461300737, '2022-06-06 18:29:09', 1450756958461300737, '2022-06-06 18:29:09', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586260336982892544, 575022217952501760, '3', '发送成功', NULL, 3, 1450756958461300737, '2022-06-06 18:29:17', 1450756958461300737, '2022-06-06 18:29:17', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586262527764340736, 586262390337970176, '1', '启用', NULL, 1, 1450756958461300737, '2022-06-06 18:37:59', 1450756958461300737, '2022-06-06 18:37:59', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586262557128663040, 586262390337970176, '0', '禁用', NULL, 2, 1450756958461300737, '2022-06-06 18:38:06', 1450756958461300737, '2022-06-06 18:38:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586658954864762880, 586658891807596544, '1', 'SMTP', NULL, 1, 1450756958461300737, '2022-06-07 20:53:14', 1450756958461300737, '2022-06-07 20:53:14', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586658992051462144, 586658891807596544, '2', 'EXCHANGE(微软)', NULL, 2, 1450756958461300737, '2022-06-07 20:53:23', 1450756958461300737, '2022-06-07 20:53:23', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586659341466345472, 586659288706195456, '1', 'SSL', NULL, 1, 1450756958461300737, '2022-06-07 20:54:47', 1450756958461300737, '2022-06-07 20:54:47', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (586659379760340992, 586659288706195456, '2', 'STARTTLS', NULL, 2, 1450756958461300737, '2022-06-07 20:54:56', 1450756958461300737, '2022-06-07 20:54:56', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587690415013240832, 587690275439386624, '0', 'App本身', NULL, 1, 1450756958461300737, '2022-06-10 17:11:54', 1450756958461300737, '2022-06-10 17:11:54', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587690459435114496, 587690275439386624, '1', '打开activity', NULL, 2, 1450756958461300737, '2022-06-10 17:12:04', 1450756958461300737, '2022-06-10 17:12:04', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587690502590308352, 587690275439386624, '2', '打开浏览器', NULL, 3, 1450756958461300737, '2022-06-10 17:12:15', 1450756958461300737, '2022-06-10 17:12:15', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587690549516181504, 587690275439386624, '3', '打开Intent', NULL, 4, 1450756958461300737, '2022-06-10 17:12:26', 1450756958461300737, '2022-06-10 17:12:26', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587956098712215552, 587955865517301760, '0', 'android', NULL, 1, 1450756958461300737, '2022-06-11 10:47:38', 1450756958461300737, '2022-06-11 10:47:38', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587956198599565312, 587955865517301760, '1', 'IOS', NULL, 2, 1450756958461300737, '2022-06-11 10:48:01', 1450756958461300737, '2022-06-11 10:48:01', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587956413003997184, 587955865517301760, '2', '安卓+IOS', NULL, 3, 1450756958461300737, '2022-06-11 10:48:53', 1450756958461300737, '2022-06-11 10:48:53', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587957011560538112, 587956910612029440, '0', '全部', NULL, 1, 1450756958461300737, '2022-06-11 10:51:15', 1450756958461300737, '2022-06-11 10:51:15', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (587957143559479296, 587956910612029440, '1', 'token', NULL, 2, 1450756958461300737, '2022-06-11 10:51:47', 1450756958461300737, '2022-06-11 10:51:47', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (591913513669369856, 591913311474556928, '5', '前5名', NULL, 1, 1450756958461300737, '2022-06-22 08:52:59', 1450756958461300737, '2022-06-22 08:52:59', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (591913605549793280, 591913311474556928, '10', '前10名', NULL, 2, 1450756958461300737, '2022-06-22 08:53:21', 1450756958461300737, '2022-06-22 08:53:21', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (591913706074677248, 591913311474556928, '15', '前15名', NULL, 3, 1450756958461300737, '2022-06-22 08:53:45', 1450756958461300737, '2022-06-22 08:53:45', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (591917296298237952, 591913311474556928, '20', '前20名', NULL, 4, 1450756958461300737, '2022-06-22 09:08:01', 1450756958461300737, '2022-06-22 09:08:01', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (608964020338434048, 608963936091643904, 'sms', '短信', NULL, 1, 1450756958461300737, '2022-08-08 10:05:36', 1450756958461300737, '2022-08-08 10:05:36', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (608964253302661120, 608963936091643904, 'mail', '邮件', NULL, 2, 1450756958461300737, '2022-08-08 10:06:32', 1450756958461300737, '2022-08-08 10:06:46', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (608964420399538176, 608963936091643904, 'wx_account', '微信公众号', NULL, 3, 1450756958461300737, '2022-08-08 10:07:12', 1450756958461300737, '2022-08-08 10:07:12', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (608964548640382976, 608963936091643904, 'app_push', 'APP通知', NULL, 4, 1450756958461300737, '2022-08-08 10:07:42', 1450756958461300737, '2022-08-08 10:09:24', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (608964730950000640, 608963936091643904, 'app_im', 'IM', NULL, 5, 1450756958461300737, '2022-08-08 10:08:26', 1450756958461300737, '2022-08-08 10:08:26', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (609025100737683456, 608963936091643904, 'notice', '内部通知', NULL, 6, 1450756958461300737, '2022-08-08 14:08:19', 1450756958461300737, '2022-08-08 14:08:19', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (673842271296430080, 673842175301394432, '2', '覆盖更新', NULL, 2, 1450756958461300737, '2023-02-03 10:48:37', 1450756958461300737, '2023-02-10 08:56:29', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676350515063562240, 673842175301394432, '1', '忽略导入', NULL, 1, 1450756958461300737, '2023-02-10 08:55:29', 1450756958461300737, '2023-02-14 15:16:44', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357019191746560, 676356930893258752, '1', '组织机构导入', NULL, 1, 1450756958461300737, '2023-02-10 09:21:19', 1450756958461300737, '2023-02-10 09:21:19', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357106202583040, 676356930893258752, '2', '用户人员导入', NULL, 2, 1450756958461300737, '2023-02-10 09:21:40', 1450756958461300737, '2023-02-10 09:21:40', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357106206842918, 676356930893258752, '3', '字典导入', NULL, 3, 1450756958461300737, '2023-06-09 10:21:40', 1450756958461300737, '2023-06-09 11:22:40', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357144312029184, 676356969782845440, '1', '组织机构导出', NULL, 1, 1450756958461300737, '2023-02-10 09:21:49', 1450756958461300737, '2023-02-10 09:21:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357177321201664, 676356969782845440, '2', '用户人员导出', NULL, 2, 1450756958461300737, '2023-02-10 09:21:57', 1450756958461300737, '2023-02-10 09:21:57', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (676357177321284927, 676356969782845440, '3', '字典导出', NULL, 3, 1450756958461300737, '2023-06-09 09:21:57', 1450756958461300737, '2023-06-09 10:21:57', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (677896054456459264, 673842175301394432, '4', '报错提醒', NULL, 4, 1450756958461300737, '2023-02-14 15:16:54', 1450756958461300737, '2023-02-14 15:16:54', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (686887028247502848, 686886958856937472, '1', '零代码', NULL, 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (686887115581300736, 686886958856937472, '2', '低代码', NULL, 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (686887316178083840, 686886958856937472, '3', '自建应用', NULL, 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (688027377053474816, 608963936091643904, 'cp', '企业微信', NULL, 7, 1450756958461300737, '2023-03-14 14:15:10', 1450756958461300737, '2023-03-14 14:15:10', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (696315839754018816, 696315722368032768, '0', '导入中', NULL, 1, NULL, '2023-04-06 11:10:33', NULL, '2023-04-06 11:10:33', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (696315890861613056, 696315722368032768, '4', '导入成功', NULL, 2, NULL, '2023-04-06 11:10:45', NULL, '2023-04-06 11:10:45', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (696315957861425152, 696315722368032768, '-1', '导入失败', NULL, 3, NULL, '2023-04-06 11:11:01', NULL, '2023-04-06 11:11:01', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (698464699389583360, 608963936091643904, 'dingTalk', '钉钉', NULL, 8, 1450756958461300737, '2023-04-12 09:29:21', 1450756958461300737, '2023-04-12 09:29:21', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (700277290533396480, 696315722368032768, '6', '导出成功', NULL, 4, NULL, '2023-04-17 09:31:57', NULL, '2023-04-17 09:31:57', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (714082823409246208, 714082718056718336, '1', '单行文本', NULL, 1, 1450756958461300737, '2023-03-11 10:43:49', 1450756958461300737, '2023-03-11 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (714082861522886656, 714082718056718336, '2', '多行文本', NULL, 2, 1450756958461300737, '2023-03-11 10:44:10', 1450756958461300737, '2023-03-11 10:44:10', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (714082900894818304, 714082718056718336, '3', '下拉选择', NULL, 3, 1450756958461300737, '2023-03-11 10:44:58', 1450756958461300737, '2023-03-11 10:44:58', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (736951458939019264, 736951385576448000, '0', '内部组件', NULL, 1, 1450756958461300737, '2023-07-27 14:22:00', 1450756958461300737, '2023-07-27 14:22:00', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (736951496494817280, 736951385576448000, '1', '外部组件', NULL, 2, 1450756958461300737, '2023-07-27 14:22:09', 1450756958461300737, '2023-07-27 14:22:09', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (737025783427768320, 737025163346059264, '1', '待办', NULL, 1, 1450756958461300737, '2023-07-27 19:17:20', 1450756958461300737, '2023-07-27 19:17:20', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (737025830928261120, 737025163346059264, '2', '日程', NULL, 2, 1450756958461300737, '2023-07-27 19:17:31', 1450756958461300737, '2023-07-27 19:17:31', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (737025877589893120, 737025163346059264, '3', '会议', NULL, 3, 1450756958461300737, '2023-07-27 19:17:42', 1450756958461300737, '2023-07-27 19:17:42', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (737025935500648448, 737025163346059264, '4', '其他', NULL, 4, 1450756958461300737, '2023-07-27 19:17:56', 1450756958461300737, '2023-07-27 19:17:56', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (795585252704919552, 794925156320681984, 'user', '用户', NULL, 1, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (806812606638858240, 676356930893258752, '4', '联系人导入', NULL, 4, 1450756958461300737, '2024-02-05 09:05:15', 1450756958461300737, '2024-02-05 09:05:15', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (811895839013478400, 811895718649536512, '0', '启用', NULL, 1, 1450756958461300737, '2024-02-19 09:44:12', 1450756958461300737, '2024-02-19 09:44:12', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (811895869715783680, 811895718649536512, '1', '停用', NULL, 2, 1450756958461300737, '2024-02-19 09:44:20', 1450756958461300737, '2024-02-19 09:44:20', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (811895903979053056, 811895803462557696, '0', '是', NULL, 1, 1450756958461300737, '2024-02-19 09:44:28', 1450756958461300737, '2024-02-19 09:44:28', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (811895928742223872, 811895803462557696, '1', '否', NULL, 2, 1450756958461300737, '2024-02-19 09:44:34', 1450756958461300737, '2024-02-19 09:44:34', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (812013673790054400, 794925156320681984, 'client', '客户', NULL, 2, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (812013805734469632, 794925156320681984, 'supplier', '供应商', NULL, 3, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561602, 1450742089372590096, '1', '系统级事件', NULL, 1, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561603, 1450742089372590093, '1', '部门经理', NULL, 1, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561604, 1450742089372590097, '1', '激活', NULL, 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561605, 1450742089372590088, '1', '全部可见', NULL, 1, NULL, '2021-03-04 14:29:11', NULL, '2021-03-04 14:29:11', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561606, 1450742089372590083, 'tab', '标签页', NULL, 1, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561607, 1450742089372590091, '70', '秘密', NULL, 3, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561608, 1450742089372590091, '71', '核心商业秘密', NULL, 2, NULL, '2021-04-26 11:18:31', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561609, 1450742089372590093, '2', '阿米巴负责人', NULL, 2, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561610, 1450742089372590083, 'left', '隐藏左侧', NULL, 3, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561611, 1450742089372590093, '4', '员工', NULL, 4, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561612, 1450742089372590087, '2', '驳回，请重新申请', NULL, 2, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561613, 1450742089372590082, 'res_btn', '接口资源', NULL, 2, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561614, 1450742089372590087, '3', '驳回至第一节点', NULL, 3, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561615, 1450742089372590096, '2', '业务级事件', NULL, 2, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561616, 1450742089372590094, 'holiday', '休', NULL, 2, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561617, 1450742089372590083, 'full', '新页面', NULL, 2, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561618, 1450742089372590088, '2', '所在部门及子级可见', NULL, 2, NULL, '2021-03-04 14:30:33', NULL, '2021-03-04 14:30:33', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561619, 1450742089372590094, 'notice', '通知', NULL, 3, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561620, 1450742089372590090, '0', '临时账号', NULL, 2, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561621, 1450742089372590088, '3', '仅所在部门可见', NULL, 3, NULL, '2021-03-04 14:30:45', NULL, '2021-03-04 14:30:45', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561622, 1450742089372590099, '1', '是', NULL, 1, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561623, 1450742089372590099, '0', '否', NULL, 2, NULL, '2018-04-11 14:19:43', NULL, '2018-04-11 14:19:43', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561624, 1450742089372590088, '4', '仅所属人可见', NULL, 4, NULL, '2021-03-04 14:30:58', NULL, '2021-03-04 14:30:58', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561625, 1450742089372590098, '2', '女', NULL, 10, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561626, 1450742089372590098, '1', '男', NULL, 1, NULL, '2018-04-11 14:19:46', NULL, '2018-04-11 14:19:46', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561627, 1450742089372590088, '5', '自定义可见范围', NULL, 5, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561628, 1450742089372590095, 'clbx', '差旅报销', NULL, 1, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561629, 1450742089372590097, '0', '锁定', NULL, 3, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:09', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561630, 1450742089372590090, '1', '长期账号', NULL, 1, NULL, '2020-04-09 08:52:55', NULL, '2020-04-17 07:56:50', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561631, 1450742089372590086, '0', '未审核', NULL, 2, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561632, 1450742089372590097, '3', '休眠', NULL, 2, NULL, '2020-04-09 08:51:14', NULL, '2020-04-17 07:56:14', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561633, 1450742089372590091, '61', '普通商业秘密', NULL, 4, NULL, '2021-04-26 11:19:18', NULL, '2021-04-26 11:19:14', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561634, 1450742089372590092, '80', '重要', NULL, 2, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561635, 1450742089372590091, '80', '机密', NULL, 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561636, 1450742089372590085, '0', '失败', NULL, 1, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561637, 1450742089372590094, 'work', '班', NULL, 1, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561638, 1450742089372590091, '60', '内部', NULL, 5, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561639, 1450742089372590086, '2', '驳回', NULL, 3, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561640, 1450742089372590089, '2', '人员', NULL, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561641, 1450742089372590082, 'res_menu', '页面资源', NULL, 1, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561642, 1450742089372590084, '1', '是', NULL, 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561643, 1450742089372590092, '90', '核心', NULL, 1, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561644, 1450742089372590095, 'xmgl', '项目管理', NULL, 2, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561645, 1450742089372590085, '1', '成功', NULL, 2, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561646, 1450742089372590086, '1', '通过', NULL, 1, NULL, '2018-04-14 13:39:16', NULL, '2018-04-18 09:57:14', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561647, 1450742089372590091, '50', '公开', NULL, 1, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561648, 1450742089372590089, '1', '角色', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561649, 1450742089372590084, '0', '否', NULL, 1, NULL, '2020-04-09 08:51:54', NULL, '2020-04-16 07:44:18', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561650, 1450742089372590087, '1', '驳回', NULL, 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561651, 1450742089372590092, '60', '非密', NULL, 4, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561652, 1450742089372590092, '70', '一般', NULL, 3, NULL, '2021-04-26 03:06:06', NULL, '2021-04-26 03:06:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561653, 1450742089372590093, '3', '项目经理', NULL, 3, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561654, 1450742089372590082, 'res_rights', '数据资源', NULL, 3, 1450756958461300737, '2022-11-11 10:07:39', 1450756958461300737, '2022-11-11 10:07:39', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561655, 517670295990181889, 'dialog', '弹窗', NULL, 1, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561656, 517670295990181889, 'browserTab', '浏览器页签', NULL, 2, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561657, 517670295990181889, 'tab', '系统内页签', NULL, 3, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561658, 517670295990181889, 'noCode', '零代码', NULL, 4, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1450742089393561660, 1450742089372590088, '6', '根据用户所属组织类型分级授予可见范围', NULL, 6, NULL, '2021-03-04 14:31:06', NULL, '2021-03-04 14:31:06', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482817, 714082718056718338, 'yyyy', '年', NULL, 11, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482818, 714082718056718338, 'yyyyMM', '年月', NULL, 12, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482819, 714082718056718338, 'yyyy-MM', '年-月', NULL, 13, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482820, 714082718056718338, 'yyyy/MM', '年/月', NULL, 14, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482821, 714082718056718338, 'yyyyMMdd', '年月日', NULL, 15, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482822, 714082718056718338, 'yyyy-MM-dd', '年-月-日', NULL, 16, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482823, 714082718056718338, 'yyyy/MM/dd', '年/月/日', NULL, 17, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482824, 714082718056718338, 'yyyyMMddHHmm', '年月日时分', NULL, 18, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482825, 714082718056718338, 'yyyyMMddHHmmss', '年月日时分秒', NULL, 19, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482826, 714082718056718338, 'MMdd', '月日', NULL, 20, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482827, 714082718056718338, 'MM-dd', '月-日', NULL, 21, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482828, 714082718056718338, 'MM/dd', '月/日', NULL, 22, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1683383216712482829, 714082718056718338, 'HHmmss', '时间', NULL, 23, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430081, 714082718056718337, '1', '不重置', NULL, 1, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430082, 714082718056718337, '2', '按年重置', NULL, 2, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430083, 714082718056718337, '3', '按季度重置', NULL, 3, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430084, 714082718056718337, '4', '按月重置', NULL, 4, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430085, 714082718056718337, '5', '按周重置', NULL, 5, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1684752048320430086, 714082718056718337, '6', '按日重置', NULL, 6, 1450756958461300737, '2023-07-28 10:43:49', 1450756958461300737, '2023-07-28 10:43:49', NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_single" ("dict_id", "type_id", "value", "label", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3", "parent_id") VALUES (1690913474055581697, 686886958856937472, '7', '微应用', NULL, 7, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_DICT_TYPE
-- ----------------------------
DROP TABLE IF EXISTS "sys_dict_type";
CREATE TABLE "sys_dict_type" (
  "type_id" int8 NOT NULL,
  "parent_id" int8,
  "type_name" varchar(128),
  "type_description" varchar(256),
  "range_type" varchar(256),
  "app_id" int8,
  "sort" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "bak_1" varchar(256),
  "bak_2" varchar(256),
  "bak_3" varchar(256)
)
;
COMMENT ON COLUMN "sys_dict_type"."type_id" IS '主键';
COMMENT ON COLUMN "sys_dict_type"."parent_id" IS '父ID';
COMMENT ON COLUMN "sys_dict_type"."type_name" IS '类别名';
COMMENT ON COLUMN "sys_dict_type"."type_description" IS '类别描述';
COMMENT ON COLUMN "sys_dict_type"."range_type" IS '编辑类型(系统sys/业务biz)';
COMMENT ON COLUMN "sys_dict_type"."app_id" IS '所属应用id';
COMMENT ON COLUMN "sys_dict_type"."sort" IS '排序';
COMMENT ON COLUMN "sys_dict_type"."creator" IS '创建者';
COMMENT ON COLUMN "sys_dict_type"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_dict_type"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_dict_type"."last_time" IS '上次编辑时间';
COMMENT ON COLUMN "sys_dict_type"."bak_1" IS '备用字段1';
COMMENT ON COLUMN "sys_dict_type"."bak_2" IS '备用字段2';
COMMENT ON COLUMN "sys_dict_type"."bak_3" IS '备用字段3';
COMMENT ON TABLE "sys_dict_type" IS '字典类型表';

-- ----------------------------
-- Records of SYS_DICT_TYPE
-- ----------------------------
BEGIN;
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (517670295990181888, 1450384438474231809, 'opinion_reject', '常用驳回意见', 'biz', NULL, 2, 1450756958461300737, '2021-11-29 11:56:56', 1450756958461300737, '2021-11-29 11:56:56', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (517670295990181889, 1450384438474231809, 'openType', '页面打开方式', 'biz', NULL, 45, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (523443198920761344, 1450384393200865282, 'res_strategy', '页面类型', 'sys', NULL, 41, NULL, '2021-12-15 10:16:24', NULL, '2021-12-15 10:16:24', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (524165175805485056, 1450384438474231809, 'noticeType', '公告类型', 'biz', NULL, 3, 1450756958461300737, '2021-12-17 10:05:16', 1450756958461300737, '2021-12-17 10:05:16', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (575022217952501760, 1450384438474231809, 'msg_send_status', '消息发送状态', 'biz', NULL, 4, 1450756958461300737, '2022-05-06 18:13:00', 1450756958461300737, '2022-06-06 18:28:47', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (586233551075418112, 1450384438474231809, 'sms_channel_type', '短信服务通道类型', 'biz', NULL, 5, 1450756958461300737, '2022-06-06 16:42:50', 1450756958461300737, '2022-06-06 16:42:50', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (586262390337970176, 1450384438474231809, 'msg_is_enable', '消息通用是否启用', 'biz', NULL, 6, 1450756958461300737, '2022-06-06 18:37:26', 1450756958461300737, '2022-06-06 18:41:39', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (586658891807596544, 1450384438474231809, 'mail_protocol', '邮箱协议', 'biz', NULL, 7, 1450756958461300737, '2022-06-07 20:52:59', 1450756958461300737, '2022-06-07 20:52:59', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (586659288706195456, 1450384438474231809, 'mail_safe_type', '邮箱安全类型', 'biz', NULL, 8, 1450756958461300737, '2022-06-07 20:54:34', 1450756958461300737, '2022-06-07 20:54:34', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (587690275439386624, 1450384438474231809, 'app_action_type', '消息推送动作类型', 'biz', NULL, 9, 1450756958461300737, '2022-06-10 17:11:20', 1450756958461300737, '2022-06-10 17:11:20', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (587955865517301760, 1450384438474231809, 'platform_type', '接收平台', 'biz', NULL, 10, 1450756958461300737, '2022-06-11 10:46:42', 1450756958461300737, '2022-06-11 10:46:42', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (587956910612029440, 1450384438474231809, 'push_scope', '推送范围', 'biz', NULL, 11, 1450756958461300737, '2022-06-11 10:50:51', 1450756958461300737, '2022-06-11 10:50:51', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (591913311474556928, 1450384438474231809, 'statistics_top', '统计排名数量', 'biz', NULL, 4, 1450756958461300737, '2022-06-22 08:52:11', 1450756958461300737, '2022-06-22 08:52:11', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (608963936091643904, 1450384438474231809, 'msg_service_type', '消息服务发送类型', 'biz', NULL, 12, 1450756958461300737, '2022-08-08 10:05:16', 1450756958461300737, '2022-08-08 10:05:16', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (673842175301394432, 1450384393200865282, 'encode_dup_pol', '机构编码重复策略', 'sys', NULL, 2, 1450756958461300737, '2023-02-03 10:48:14', 1450756958461300737, '2023-02-03 10:48:14', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (676356930893258752, 1450384393200865282, 'import_type', '导入类型', 'sys', NULL, 3, 1450756958461300737, '2023-02-10 09:20:58', 1450756958461300737, '2023-02-10 09:20:58', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (676356969782845440, 1450384393200865282, 'export_type', '导出类型', 'sys', NULL, 4, 1450756958461300737, '2023-02-10 09:21:08', 1450756958461300737, '2023-02-10 09:21:08', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (686886958856937472, 1450384438474231809, 'app_type', '应用类型', 'biz', NULL, 17, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (696315722368032768, 1450384393200865282, 'imp_exp_state', 'excel导入导出状态', 'sys', NULL, 43, NULL, '2023-04-06 11:10:05', NULL, '2023-04-06 11:10:05', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (714082718056718336, 1450384393200865282, 'res_expand_type', '资源类型扩展属性类型', 'sys', NULL, 42, 1450756958461300737, '2023-03-11 10:43:33', 1450756958461300737, '2023-03-11 10:43:33', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (714082718056718337, 1450384393200865282, 'reset_period', '重置周期', 'sys', NULL, 43, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (714082718056718338, 1450384393200865282, 'date_pattern', '日期格式', 'sys', NULL, 44, 1450756958461300737, '2023-07-28 10:43:33', 1450756958461300737, '2023-07-28 10:43:33', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (736951385576448000, 1450384393200865282, 'assembly_type', '组件类型', 'sys', NULL, 44, 1450756958461300737, '2023-07-27 14:21:42', 1450756958461300737, '2023-07-27 14:21:42', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (737025163346059264, 1450384438474231809, 'message_type', '消息类型', 'biz', NULL, 45, 1450756958461300737, '2023-07-27 19:14:52', 1450756958461300737, '2023-07-27 19:14:52', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (794925156320681984, 1450384438474231809, 'msg_contact_type', '消息服务联系人类型', 'biz', NULL, 46, NULL, '2024-01-03 13:48:46', NULL, '2024-01-03 13:48:46', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (811895718649536512, 1450384438474231809, 'advertisementStatus', '广告启用状态', 'biz', NULL, 46, 1450756958461300737, '2024-02-19 09:43:44', 1450756958461300737, '2024-02-19 09:43:44', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (811895803462557696, 1450384438474231809, 'yes_no_close', '横幅是否能关闭', 'biz', NULL, 47, 1450756958461300737, '2024-02-19 09:44:04', 1450756958461300737, '2024-02-19 09:44:04', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590082, 1450384393200865282, 'res_type', '资源类型', 'sys', NULL, 30, NULL, '2018-04-14 13:19:56', NULL, '2018-04-14 13:19:56', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590083, 1450384393200865282, 'menu_type', '菜单开发方式', 'sys', NULL, 35, NULL, '2019-01-30 10:54:41', NULL, '2019-01-30 10:54:41', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590084, 1450384393200865282, 'is_sys', '系统管理员', 'sys', NULL, 2, NULL, '2020-04-09 08:51:54', NULL, '2020-04-09 08:51:54', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590085, 1450384393200865282, 'success_fail', '成功失败', 'sys', NULL, 37, NULL, '2019-08-26 15:31:23', NULL, '2019-08-26 15:31:23', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590086, 1450384393200865282, 'user_role_review', '用户角色审核状态', 'sys', NULL, 31, NULL, '2018-04-14 13:39:16', NULL, '2018-04-14 13:39:16', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590087, 1450384438474231809, 'common_opinion', '常用意见', 'biz', NULL, 1, NULL, '2021-03-10 13:44:31', NULL, '2021-03-10 13:45:21', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590088, 1450384393200865282, 'data_scope_type', '数据权限类型', 'sys', NULL, 38, NULL, '2021-03-04 14:22:18', NULL, '2021-03-04 14:22:25', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590089, 1450384393200865282, 'type', '欢迎页配置对象类型', 'sys', NULL, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590090, 1450384393200865282, 'account_property', '账号属性', 'sys', NULL, 3, NULL, '2020-04-09 08:52:55', NULL, '2020-04-09 08:52:55', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590091, 1450384438474231809, 'security_level', '数据密级', 'biz', NULL, 15, NULL, '2021-03-16 08:56:13', NULL, '2021-03-16 08:56:13', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590092, 1450384438474231809, 'user_security_level', '用户密级', 'biz', NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590093, 1450384438474231809, 'staff_position', '人员职务', 'biz', NULL, 14, NULL, '2018-08-29 17:24:39', NULL, '2018-08-29 17:24:39', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590094, 1450384393200865282, 'calendar_event_type', '工作日历事件类型', 'sys', NULL, 36, NULL, '2019-02-25 15:38:06', NULL, '2019-02-25 15:38:06', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590095, 1450384438474231809, 'todo_type', '待办类型', 'biz', NULL, 13, NULL, '2018-04-20 18:25:36', NULL, '2018-04-20 18:25:36', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590096, 1450384393200865282, 'levelEvent', '系统/业务级事件', 'sys', NULL, 36, NULL, '2019-08-19 11:33:16', NULL, '2019-08-19 11:33:16', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590097, 1450384393200865282, 'account_state', '账户状态', 'sys', NULL, 1, NULL, '2020-04-09 08:51:14', NULL, '2020-04-16 12:17:51', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590098, 1450384393200865282, 'sex', '性别', 'sys', NULL, 18, NULL, '2018-04-11 14:10:07', NULL, '2018-04-11 14:10:07', NULL, NULL, NULL);
INSERT INTO "sys_dict_type" ("type_id", "parent_id", "type_name", "type_description", "range_type", "app_id", "sort", "creator", "create_time", "last_editor", "last_time", "bak_1", "bak_2", "bak_3") VALUES (1450742089372590099, 1450384393200865282, 'yes_no', '是/否', 'sys', NULL, 29, NULL, '2018-04-11 14:10:08', NULL, '2018-04-11 14:10:08', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_DONE
-- ----------------------------
DROP TABLE IF EXISTS "sys_done";
CREATE TABLE "sys_done" (
  "done_id" int8 NOT NULL,
  "send_user_id" int8,
  "send_user_name" varchar(32),
  "receive_user_id" int8,
  "receive_user_name" varchar(32),
  "organ_id" int8,
  "organ_name" varchar(32),
  "task_type_id" int8,
  "task_type_name" varchar(32),
  "task_detail" varchar(512),
  "task_id" int8,
  "business_id" int8,
  "flow_example_id" int8,
  "url" varchar(64),
  "receive_time" timestamp without time zone,
  "deal_time" timestamp without time zone,
  "bak1" varchar(64),
  "bak2" varchar(64),
  "done_name" varchar(128)
)
;
COMMENT ON COLUMN "sys_done"."done_id" IS '已办主键';
COMMENT ON COLUMN "sys_done"."send_user_id" IS '发送人编码';
COMMENT ON COLUMN "sys_done"."send_user_name" IS '发送人名称';
COMMENT ON COLUMN "sys_done"."receive_user_id" IS '接收人编码';
COMMENT ON COLUMN "sys_done"."receive_user_name" IS '接收人名称';
COMMENT ON COLUMN "sys_done"."organ_id" IS '发送人单位编码';
COMMENT ON COLUMN "sys_done"."organ_name" IS '发送人单位名称';
COMMENT ON COLUMN "sys_done"."task_type_id" IS '业务类型编码';
COMMENT ON COLUMN "sys_done"."task_type_name" IS '业务类型名称';
COMMENT ON COLUMN "sys_done"."task_detail" IS '已办详情';
COMMENT ON COLUMN "sys_done"."task_id" IS '流程任务主键';
COMMENT ON COLUMN "sys_done"."business_id" IS '对应业务主键';
COMMENT ON COLUMN "sys_done"."flow_example_id" IS '流程实例ID';
COMMENT ON COLUMN "sys_done"."url" IS '待办URL';
COMMENT ON COLUMN "sys_done"."receive_time" IS '签收时间';
COMMENT ON COLUMN "sys_done"."deal_time" IS '办理时间';
COMMENT ON COLUMN "sys_done"."bak1" IS '预留字段1';
COMMENT ON COLUMN "sys_done"."bak2" IS '预留字段2';
COMMENT ON COLUMN "sys_done"."done_name" IS '已办名称';
COMMENT ON TABLE "sys_done" IS '已办事项表';

-- ----------------------------
-- Records of SYS_DONE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_EIM_NEWS
-- ----------------------------
DROP TABLE IF EXISTS "sys_eim_news";
CREATE TABLE "sys_eim_news" (
  "news_id" int8 NOT NULL,
  "news_title" varchar(2048),
  "news_subtitle" varchar(2048),
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "creator_dept" int8,
  "creator_dept_name" varchar(255),
  "type_id" int8,
  "news_top" int2,
  "news_content" text,
  "url" varchar(255),
  "from_resource" int8,
  "news_type" int2,
  "read_count" int4,
  "show_type" int2,
  "seq" int4,
  "cover_image" int8,
  "publish_status" char(1),
  "publish_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_eim_news"."news_id" IS '消息ID';
COMMENT ON COLUMN "sys_eim_news"."news_title" IS '新闻标题';
COMMENT ON COLUMN "sys_eim_news"."news_subtitle" IS '副标题';
COMMENT ON COLUMN "sys_eim_news"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_eim_news"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_eim_news"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_eim_news"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_eim_news"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_eim_news"."del_flag" IS '是否删除';
COMMENT ON COLUMN "sys_eim_news"."creator_dept" IS '创建人部门id';
COMMENT ON COLUMN "sys_eim_news"."creator_dept_name" IS '创建人部门';
COMMENT ON COLUMN "sys_eim_news"."type_id" IS '类型id';
COMMENT ON COLUMN "sys_eim_news"."news_top" IS '是否置顶';
COMMENT ON COLUMN "sys_eim_news"."news_content" IS '新闻内容';
COMMENT ON COLUMN "sys_eim_news"."url" IS '外部链接';
COMMENT ON COLUMN "sys_eim_news"."from_resource" IS '新闻来源';
COMMENT ON COLUMN "sys_eim_news"."news_type" IS '新闻类型（0 普通新闻
1 图片新闻
2 视频新闻）';
COMMENT ON COLUMN "sys_eim_news"."read_count" IS '阅读次数';
COMMENT ON COLUMN "sys_eim_news"."show_type" IS '封面图展示方式';
COMMENT ON COLUMN "sys_eim_news"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_eim_news"."cover_image" IS '封面图';
COMMENT ON COLUMN "sys_eim_news"."publish_status" IS '发布状态';
COMMENT ON COLUMN "sys_eim_news"."publish_time" IS '发布时间';
COMMENT ON TABLE "sys_eim_news" IS '新闻资讯表';

-- ----------------------------
-- Records of SYS_EIM_NEWS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_FILE
-- ----------------------------
DROP TABLE IF EXISTS "sys_eim_news_file";
CREATE TABLE "sys_eim_news_file" (
  "file_id" int8 NOT NULL,
  "news_id" int8,
  "file_type" varchar(255),
  "file_name" varchar(255),
  "file_size" int4,
  "file_status" int4,
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "depict" text,
  "md5" varchar(50),
  "type" int4,
  "seq" int4
)
;
COMMENT ON COLUMN "sys_eim_news_file"."file_id" IS '文件id';
COMMENT ON COLUMN "sys_eim_news_file"."news_id" IS '新闻id';
COMMENT ON COLUMN "sys_eim_news_file"."file_type" IS '文件类型';
COMMENT ON COLUMN "sys_eim_news_file"."file_name" IS '文件名称';
COMMENT ON COLUMN "sys_eim_news_file"."file_size" IS '文件大小';
COMMENT ON COLUMN "sys_eim_news_file"."file_status" IS '文件状态';
COMMENT ON COLUMN "sys_eim_news_file"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_eim_news_file"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_eim_news_file"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_eim_news_file"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_eim_news_file"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_eim_news_file"."del_flag" IS '是否删除';
COMMENT ON COLUMN "sys_eim_news_file"."depict" IS '文件描述';
COMMENT ON COLUMN "sys_eim_news_file"."md5" IS 'MD5';
COMMENT ON COLUMN "sys_eim_news_file"."type" IS '类型';
COMMENT ON COLUMN "sys_eim_news_file"."seq" IS '显示顺序';
COMMENT ON TABLE "sys_eim_news_file" IS '新闻文件表';

-- ----------------------------
-- Records of SYS_EIM_NEWS_FILE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_FROMRESOURCE
-- ----------------------------
DROP TABLE IF EXISTS "sys_eim_news_fromresource";
CREATE TABLE "sys_eim_news_fromresource" (
  "news_source_id" int8 NOT NULL,
  "source_name" varchar(255),
  "source_url" varchar(255),
  "source_head" int8,
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "seq" int4,
  "depict" varchar(500)
)
;
COMMENT ON COLUMN "sys_eim_news_fromresource"."news_source_id" IS '新闻来源id';
COMMENT ON COLUMN "sys_eim_news_fromresource"."source_name" IS '来源名称';
COMMENT ON COLUMN "sys_eim_news_fromresource"."source_url" IS '链接地址';
COMMENT ON COLUMN "sys_eim_news_fromresource"."source_head" IS '图标base64';
COMMENT ON COLUMN "sys_eim_news_fromresource"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_eim_news_fromresource"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_eim_news_fromresource"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_eim_news_fromresource"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_eim_news_fromresource"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_eim_news_fromresource"."del_flag" IS '是否删除';
COMMENT ON COLUMN "sys_eim_news_fromresource"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_eim_news_fromresource"."depict" IS '简介';
COMMENT ON TABLE "sys_eim_news_fromresource" IS '新闻来源表';

-- ----------------------------
-- Records of SYS_EIM_NEWS_FROMRESOURCE
-- ----------------------------
BEGIN;
INSERT INTO "sys_eim_news_fromresource" ("news_source_id", "source_name", "source_url", "source_head", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq", "depict") VALUES (785085207605944320, '媒体记者', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:20', 1450756958461300737, '2023-12-07 10:08:20', '0', NULL, '');
INSERT INTO "sys_eim_news_fromresource" ("news_source_id", "source_name", "source_url", "source_head", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq", "depict") VALUES (785085248051617792, '专门机构', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:29', 1450756958461300737, '2023-12-07 10:08:29', '0', NULL, '');
INSERT INTO "sys_eim_news_fromresource" ("news_source_id", "source_name", "source_url", "source_head", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq", "depict") VALUES (785085280800743424, '公众个人', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:37', 1450756958461300737, '2023-12-07 10:08:37', '0', NULL, '');
INSERT INTO "sys_eim_news_fromresource" ("news_source_id", "source_name", "source_url", "source_head", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq", "depict") VALUES (785085317987442688, '其他媒体', '', NULL, 1450756958461300737, '超级管理员', '2023-12-07 10:08:46', 1450756958461300737, '2023-12-07 10:08:46', '0', NULL, '');
COMMIT;

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_READ
-- ----------------------------
DROP TABLE IF EXISTS "sys_eim_news_read";
CREATE TABLE "sys_eim_news_read" (
  "read_id" int8 NOT NULL,
  "news_id" int8,
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_eim_news_read"."read_id" IS '阅读记录id';
COMMENT ON COLUMN "sys_eim_news_read"."news_id" IS '新闻id';
COMMENT ON COLUMN "sys_eim_news_read"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_eim_news_read"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_eim_news_read"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_eim_news_read"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_eim_news_read"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_eim_news_read"."del_flag" IS '是否删除';
COMMENT ON TABLE "sys_eim_news_read" IS '新闻阅读量表';

-- ----------------------------
-- Records of SYS_EIM_NEWS_READ
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_EIM_NEWS_TYPE
-- ----------------------------
DROP TABLE IF EXISTS "sys_eim_news_type";
CREATE TABLE "sys_eim_news_type" (
  "news_type_id" int8 NOT NULL,
  "news_type" varchar(255),
  "creator" int8,
  "creator_name" varchar(255),
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "seq" int4
)
;
COMMENT ON COLUMN "sys_eim_news_type"."news_type_id" IS '新闻类型id';
COMMENT ON COLUMN "sys_eim_news_type"."news_type" IS '新闻类型';
COMMENT ON COLUMN "sys_eim_news_type"."creator" IS '创建人id';
COMMENT ON COLUMN "sys_eim_news_type"."creator_name" IS '创建人';
COMMENT ON COLUMN "sys_eim_news_type"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_eim_news_type"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_eim_news_type"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_eim_news_type"."del_flag" IS '是否删除';
COMMENT ON COLUMN "sys_eim_news_type"."seq" IS '显示顺序';
COMMENT ON TABLE "sys_eim_news_type" IS '新闻类型表';

-- ----------------------------
-- Records of SYS_EIM_NEWS_TYPE
-- ----------------------------
BEGIN;
INSERT INTO "sys_eim_news_type" ("news_type_id", "news_type", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq") VALUES (785085356717645824, '动态新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:08:55', 1450756958461300737, '2023-12-07 10:08:55', '0', NULL);
INSERT INTO "sys_eim_news_type" ("news_type_id", "news_type", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq") VALUES (785085393677852672, '综合新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:09:04', 1450756958461300737, '2023-12-07 10:09:04', '0', NULL);
INSERT INTO "sys_eim_news_type" ("news_type_id", "news_type", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq") VALUES (785085421486088192, '经验新闻', 1450756958461300737, '超级管理员', '2023-12-07 10:09:11', 1450756958461300737, '2023-12-07 10:09:11', '0', NULL);
INSERT INTO "sys_eim_news_type" ("news_type_id", "news_type", "creator", "creator_name", "create_time", "last_editor", "last_time", "del_flag", "seq") VALUES (785085448723898368, '新闻评述', 1450756958461300737, '超级管理员', '2023-12-07 10:09:17', 1450756958461300737, '2023-12-07 10:09:17', '0', NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_EXCEL_TASK
-- ----------------------------
DROP TABLE IF EXISTS "sys_excel_task";
CREATE TABLE "sys_excel_task" (
  "task_id" int8 NOT NULL,
  "excel_type" int4,
  "task_type" char(1),
  "task_status" int4,
  "task_file" int8,
  "file_name" varchar(255),
  "check_scenario" char(1),
  "check_file" int8,
  "check_result" varchar(500),
  "show_msg" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" varchar(255),
  "last_time" timestamp without time zone,
  "create_name" varchar(255),
  "data_total" int4,
  "data_success" int4,
  "data_error" int4,
  "error_file" varchar(255),
  "error_msg" text,
  "excel_name" varchar(255)
)
;
COMMENT ON COLUMN "sys_excel_task"."task_id" IS '任务ID';
COMMENT ON COLUMN "sys_excel_task"."excel_type" IS 'Excel业务类型：1.组织机构 2.人员 3.字典 4.联系人';
COMMENT ON COLUMN "sys_excel_task"."task_type" IS '任务类型: 1.导入 2.导出';
COMMENT ON COLUMN "sys_excel_task"."task_status" IS '任务状态: 1.校验中 2.校验通过 3.校验未通过  4.导入中  5.导入完成 6.导入失败 7.导出中 8.导出完成 9.导出失败';
COMMENT ON COLUMN "sys_excel_task"."task_file" IS '导入/导出文件oss地址';
COMMENT ON COLUMN "sys_excel_task"."file_name" IS '导入/导出文件名称';
COMMENT ON COLUMN "sys_excel_task"."check_scenario" IS '导入校验场景：1.新增数据 2.更新和新增数据';
COMMENT ON COLUMN "sys_excel_task"."check_file" IS '导入校验结果文件oss地址';
COMMENT ON COLUMN "sys_excel_task"."check_result" IS '导入校验结果';
COMMENT ON COLUMN "sys_excel_task"."show_msg" IS '导入校验未通过/导入失败/导出失败信息等展示信息';
COMMENT ON COLUMN "sys_excel_task"."creator" IS '创建者id';
COMMENT ON COLUMN "sys_excel_task"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_excel_task"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_excel_task"."last_time" IS '上次编辑时间';
COMMENT ON COLUMN "sys_excel_task"."create_name" IS '创建人姓名';
COMMENT ON COLUMN "sys_excel_task"."data_total" IS '数据总条数';
COMMENT ON COLUMN "sys_excel_task"."data_success" IS '校验成功条数';
COMMENT ON COLUMN "sys_excel_task"."data_error" IS '校验失败条数';
COMMENT ON COLUMN "sys_excel_task"."error_file" IS '校验错误文件下载地址';
COMMENT ON COLUMN "sys_excel_task"."error_msg" IS '错误原因';
COMMENT ON COLUMN "sys_excel_task"."excel_name" IS '文件名称';
COMMENT ON TABLE "sys_excel_task" IS 'EXCEL任务日志表';

-- ----------------------------
-- Records of SYS_EXCEL_TASK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FILE_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_file_info";
CREATE TABLE "sys_file_info" (
  "file_id" int8 NOT NULL,
  "attachment_name" varchar(256),
  "attachment_dir" varchar(512),
  "attachment_type" varchar(256),
  "attachment_size" int8,
  "upload_per" int8,
  "upload_date" timestamp without time zone,
  "business_id" int8,
  "file_type" varchar(32),
  "seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_file_info"."file_id" IS '主键';
COMMENT ON COLUMN "sys_file_info"."attachment_name" IS '附件名称';
COMMENT ON COLUMN "sys_file_info"."attachment_dir" IS '附件路径';
COMMENT ON COLUMN "sys_file_info"."attachment_type" IS '附件类型';
COMMENT ON COLUMN "sys_file_info"."attachment_size" IS '附件大小';
COMMENT ON COLUMN "sys_file_info"."upload_per" IS '上传人';
COMMENT ON COLUMN "sys_file_info"."upload_date" IS '上传时间';
COMMENT ON COLUMN "sys_file_info"."business_id" IS '业务ID  ';
COMMENT ON COLUMN "sys_file_info"."file_type" IS '类型';
COMMENT ON COLUMN "sys_file_info"."seq" IS '排序字段';
COMMENT ON COLUMN "sys_file_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_file_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_file_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_file_info"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_file_info" IS '附件信息表';

-- ----------------------------
-- Records of SYS_FILE_INFO
-- ----------------------------

ALTER TABLE "sys_file_info" ADD "attachment_owner_type" CHAR NULL;
ALTER TABLE "sys_file_info" add  "owning_organization" numeric(20) NULL;

BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FILE_RELATION
-- ----------------------------
DROP TABLE IF EXISTS "sys_file_relation";
CREATE TABLE "sys_file_relation" (
  "relation_id" int8 NOT NULL,
  "business_id" varchar(64),
  "file_id" int8 NOT NULL,
  "attachment_name" varchar(255),
  "attachment_type" varchar(255),
  "type" varchar(64),
  "seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_file_relation"."relation_id" IS '关联关系ID';
COMMENT ON COLUMN "sys_file_relation"."business_id" IS '业务ID';
COMMENT ON COLUMN "sys_file_relation"."file_id" IS '文件ID';
COMMENT ON COLUMN "sys_file_relation"."attachment_name" IS '附件名称';
COMMENT ON COLUMN "sys_file_relation"."attachment_type" IS '附件类型';
COMMENT ON COLUMN "sys_file_relation"."type" IS '分类类型';
COMMENT ON COLUMN "sys_file_relation"."seq" IS '排序字段';
COMMENT ON COLUMN "sys_file_relation"."creator" IS '创建人';
COMMENT ON COLUMN "sys_file_relation"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_file_relation"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_file_relation"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_file_relation" IS '附件关联关系表';

-- ----------------------------
-- Records of SYS_FILE_RELATION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM
-- ----------------------------
DROP TABLE IF EXISTS "sys_form";
CREATE TABLE "sys_form" (
  "form_id" int8 NOT NULL,
  "table_name" varchar(64),
  "form_name" varchar(64),
  "form_group_id" int8,
  "app_id" int8,
  "form_type" char(1),
  "form_icon_type" char(1),
  "form_icon" varchar(32),
  "form_icon_color" varchar(32),
  "form_status" char(1),
  "seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_form"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_form"."table_name" IS '表单表名';
COMMENT ON COLUMN "sys_form"."form_name" IS '表单名称';
COMMENT ON COLUMN "sys_form"."form_group_id" IS '表单分组';
COMMENT ON COLUMN "sys_form"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_form"."form_type" IS '表单类型 普通表单是0 流程表单是1';
COMMENT ON COLUMN "sys_form"."form_icon_type" IS '表单图标类型';
COMMENT ON COLUMN "sys_form"."form_icon" IS '表单图标';
COMMENT ON COLUMN "sys_form"."form_icon_color" IS '内置图标颜色';
COMMENT ON COLUMN "sys_form"."form_status" IS '表单状态';
COMMENT ON COLUMN "sys_form"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_form"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form"."del_flag" IS '需要逻辑删除的业务添加该字段';
COMMENT ON TABLE "sys_form" IS '表单表';

-- ----------------------------
-- Records of SYS_FORM
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_AUTHORIZE_ROLES
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_authorize_roles";
CREATE TABLE "sys_form_authorize_roles" (
  "form_role_id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8,
  "role_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_form_authorize_roles"."form_role_id" IS '主键';
COMMENT ON COLUMN "sys_form_authorize_roles"."app_id" IS '应用ID';
COMMENT ON COLUMN "sys_form_authorize_roles"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_form_authorize_roles"."role_id" IS '角色ID';
COMMENT ON COLUMN "sys_form_authorize_roles"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_authorize_roles"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_authorize_roles"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form_authorize_roles"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form_authorize_roles"."del_flag" IS '需要逻辑删除的业务添加该字段';
COMMENT ON TABLE "sys_form_authorize_roles" IS '表单可授访问权限的角色表';

-- ----------------------------
-- Records of SYS_FORM_AUTHORIZE_ROLES
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_CHECK_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_check_config";
CREATE TABLE "sys_form_check_config" (
  "check_config_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "check_config" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_form_check_config"."check_config_id" IS '校验配置主键id';
COMMENT ON COLUMN "sys_form_check_config"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_check_config"."check_config" IS '校验配置';
COMMENT ON COLUMN "sys_form_check_config"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_check_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_check_config"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form_check_config"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_form_check_config" IS '表单提交校验配置表';

-- ----------------------------
-- Records of SYS_FORM_CHECK_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_CONVERT_HISTORY
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_convert_history";
CREATE TABLE "sys_form_convert_history" (
  "convert_id" int8 NOT NULL,
  "form_id" int8 NOT NULL,
  "form_type" char(1) NOT NULL,
  "convert_type" char(1) NOT NULL,
  "operator" int8,
  "operation_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_form_convert_history"."convert_id" IS '表单转换历史记录主键';
COMMENT ON COLUMN "sys_form_convert_history"."form_id" IS '表单ID';
COMMENT ON COLUMN "sys_form_convert_history"."form_type" IS '表单类型';
COMMENT ON COLUMN "sys_form_convert_history"."convert_type" IS '表单转换后类型';
COMMENT ON COLUMN "sys_form_convert_history"."operator" IS '操作人';
COMMENT ON COLUMN "sys_form_convert_history"."operation_time" IS '操作时间';
COMMENT ON TABLE "sys_form_convert_history" IS '表单转换历史';

-- ----------------------------
-- Records of SYS_FORM_CONVERT_HISTORY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_GROUP
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_group";
CREATE TABLE "sys_form_group" (
  "group_id" int8 NOT NULL,
  "group_name" varchar(32),
  "seq" int4,
  "group_icon_type" char(1),
  "group_icon" varchar(32),
  "group_type" char(1),
  "group_icon_color" varchar(32),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "app_id" int8 NOT NULL
)
;
COMMENT ON COLUMN "sys_form_group"."group_id" IS '分组ID';
COMMENT ON COLUMN "sys_form_group"."group_name" IS '分组名称';
COMMENT ON COLUMN "sys_form_group"."seq" IS '分组显示顺序';
COMMENT ON COLUMN "sys_form_group"."group_icon_type" IS '分组图标类型
1：内置图标
2：用户自定义';
COMMENT ON COLUMN "sys_form_group"."group_icon" IS '分组图标
内置图标：图标标识
用户自定义：图片ID';
COMMENT ON COLUMN "sys_form_group"."group_type" IS '分组类型
1:默认分组
2:普通分组';
COMMENT ON COLUMN "sys_form_group"."group_icon_color" IS '内置图标颜色';
COMMENT ON COLUMN "sys_form_group"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_group"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_group"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form_group"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form_group"."app_id" IS '应用ID';
COMMENT ON TABLE "sys_form_group" IS '表单分组表';

-- ----------------------------
-- Records of SYS_FORM_GROUP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link";
CREATE TABLE "sys_form_link" (
  "link_id" int8 NOT NULL,
  "form_id" int8,
  "link_status" int4,
  "link_address" varchar(255),
  "link_short_address" varchar(255),
  "link_pass" varchar(255),
  "has_pass" int4,
  "wechat_status" int4,
  "wechat_type" int4,
  "wechat_submit_one" int4,
  "wechat_submit_remind" varchar(255),
  "has_ext_params" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "field_control" text,
  "result_page" text,
  "has_field_control" int4,
  "form_sheet" text
)
;
COMMENT ON COLUMN "sys_form_link"."link_id" IS '表单外链id';
COMMENT ON COLUMN "sys_form_link"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_link"."link_status" IS '表单外链状态';
COMMENT ON COLUMN "sys_form_link"."link_address" IS '表单外链地址';
COMMENT ON COLUMN "sys_form_link"."link_short_address" IS '短链接';
COMMENT ON COLUMN "sys_form_link"."link_pass" IS '表单外链密码';
COMMENT ON COLUMN "sys_form_link"."has_pass" IS '是否开启密码';
COMMENT ON COLUMN "sys_form_link"."wechat_status" IS '是否开启微信增强';
COMMENT ON COLUMN "sys_form_link"."wechat_type" IS '微信增强获取用户信息的方式';
COMMENT ON COLUMN "sys_form_link"."wechat_submit_one" IS '微信用户是否只能提交一次';
COMMENT ON COLUMN "sys_form_link"."wechat_submit_remind" IS '自定义提示语';
COMMENT ON COLUMN "sys_form_link"."has_ext_params" IS '是否有外链扩展';
COMMENT ON COLUMN "sys_form_link"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_link"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_link"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form_link"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form_link"."field_control" IS '字段控制配置';
COMMENT ON COLUMN "sys_form_link"."result_page" IS '结果页配置';
COMMENT ON COLUMN "sys_form_link"."has_field_control" IS '是否配置字段控制';
COMMENT ON COLUMN "sys_form_link"."form_sheet" IS '表单样式';
COMMENT ON TABLE "sys_form_link" IS '表单外链表';

-- ----------------------------
-- Records of SYS_FORM_LINK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK_EXTEND
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link_extend";
CREATE TABLE "sys_form_link_extend" (
  "extend_id" int8 NOT NULL,
  "link_id" int8,
  "extend_value" varchar(255),
  "link_address" varchar(255)
)
;
COMMENT ON COLUMN "sys_form_link_extend"."extend_id" IS '主键';
COMMENT ON COLUMN "sys_form_link_extend"."link_id" IS '外链id';
COMMENT ON COLUMN "sys_form_link_extend"."extend_value" IS '扩展值';
COMMENT ON COLUMN "sys_form_link_extend"."link_address" IS '扩展后的链接地址';
COMMENT ON TABLE "sys_form_link_extend" IS '表单外链扩展表';

-- ----------------------------
-- Records of SYS_FORM_LINK_EXTEND
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK_OPEN
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link_open";
CREATE TABLE "sys_form_link_open" (
  "link_id" int8 NOT NULL,
  "form_id" int8,
  "link_short_address" varchar(255),
  "link_address" varchar(255),
  "link_status" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "link_pass" varchar(255),
  "has_pass" int4,
  "link_query" text,
  "link_show" text,
  "link_title" varchar(255),
  "has_field_control" int4,
  "print_id_arr" text
)
;
COMMENT ON COLUMN "sys_form_link_open"."link_id" IS '主键id';
COMMENT ON COLUMN "sys_form_link_open"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_link_open"."link_short_address" IS '短链接';
COMMENT ON COLUMN "sys_form_link_open"."link_address" IS '外链地址';
COMMENT ON COLUMN "sys_form_link_open"."link_status" IS '表单外链状态';
COMMENT ON COLUMN "sys_form_link_open"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_link_open"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_link_open"."last_editor" IS '最后一次修改人  ';
COMMENT ON COLUMN "sys_form_link_open"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form_link_open"."link_pass" IS '链接密码';
COMMENT ON COLUMN "sys_form_link_open"."has_pass" IS '是否设置链接密码';
COMMENT ON COLUMN "sys_form_link_open"."link_query" IS '查询条件';
COMMENT ON COLUMN "sys_form_link_open"."link_show" IS '展示字段';
COMMENT ON COLUMN "sys_form_link_open"."link_title" IS '页面标题';
COMMENT ON COLUMN "sys_form_link_open"."has_field_control" IS '是否配置展示字段';
COMMENT ON COLUMN "sys_form_link_open"."print_id_arr" IS '打印模板id数组';
COMMENT ON TABLE "sys_form_link_open" IS '表单公开查询外链表';

-- ----------------------------
-- Records of SYS_FORM_LINK_OPEN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link_single";
CREATE TABLE "sys_form_link_single" (
  "link_id" int8 NOT NULL,
  "data_id" int8,
  "form_id" int8,
  "link_address" varchar(255),
  "link_short_address" varchar(255),
  "link_status" int4,
  "link_pass" varchar(255),
  "has_pass" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "expiry_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_form_link_single"."link_id" IS '主键id';
COMMENT ON COLUMN "sys_form_link_single"."data_id" IS '数据id';
COMMENT ON COLUMN "sys_form_link_single"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_link_single"."link_address" IS '外链地址';
COMMENT ON COLUMN "sys_form_link_single"."link_short_address" IS '短链接';
COMMENT ON COLUMN "sys_form_link_single"."link_status" IS '表单外链状态';
COMMENT ON COLUMN "sys_form_link_single"."link_pass" IS '外链密码';
COMMENT ON COLUMN "sys_form_link_single"."has_pass" IS '是否有密码';
COMMENT ON COLUMN "sys_form_link_single"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_link_single"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_link_single"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_form_link_single"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_form_link_single"."expiry_time" IS '过期时间';
COMMENT ON TABLE "sys_form_link_single" IS '表单单条数据外链表';

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE_INNER
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link_single_inner";
CREATE TABLE "sys_form_link_single_inner" (
  "link_id" int8 NOT NULL,
  "data_id" int8,
  "form_id" int8,
  "inner_params" text,
  "inner_short_address" varchar(255),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_form_link_single_inner"."link_id" IS '主键id';
COMMENT ON COLUMN "sys_form_link_single_inner"."data_id" IS '数据id';
COMMENT ON COLUMN "sys_form_link_single_inner"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_link_single_inner"."inner_params" IS '应用内链接参数';
COMMENT ON COLUMN "sys_form_link_single_inner"."inner_short_address" IS '应用内短链接';
COMMENT ON COLUMN "sys_form_link_single_inner"."creator" IS '创建人';
COMMENT ON COLUMN "sys_form_link_single_inner"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_form_link_single_inner"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_form_link_single_inner"."last_time" IS '修改时间';
COMMENT ON TABLE "sys_form_link_single_inner" IS '应用内单条数据分享链接';

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE_INNER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_LINK_SINGLE_STATUS
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_link_single_status";
CREATE TABLE "sys_form_link_single_status" (
  "single_id" int8 NOT NULL,
  "single_status" int4,
  "form_id" int8,
  "field_control" text,
  "has_field_control" int4,
  "form_sheet" text,
  "result_page" text,
  "print_id_arr" text
)
;
COMMENT ON COLUMN "sys_form_link_single_status"."single_id" IS '主键id';
COMMENT ON COLUMN "sys_form_link_single_status"."single_status" IS '表单单条数据外链状态';
COMMENT ON COLUMN "sys_form_link_single_status"."form_id" IS '表单id';
COMMENT ON COLUMN "sys_form_link_single_status"."field_control" IS '字段控制';
COMMENT ON COLUMN "sys_form_link_single_status"."has_field_control" IS '是否配置字段控制';
COMMENT ON COLUMN "sys_form_link_single_status"."form_sheet" IS '表单样式配置';
COMMENT ON COLUMN "sys_form_link_single_status"."result_page" IS '结果页配置';
COMMENT ON COLUMN "sys_form_link_single_status"."print_id_arr" IS '打印模板id数组';
COMMENT ON TABLE "sys_form_link_single_status" IS '表单单条数据外链状态表';

-- ----------------------------
-- Records of SYS_FORM_LINK_SINGLE_STATUS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_MSG_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_msg_config";
CREATE TABLE "sys_form_msg_config" (
  "id" int8 NOT NULL,
  "app_id" int8,
  "form_id" int8,
  "reminder_text" text,
  "trigger_type" varchar(255),
  "remind" varchar(255),
  "repeat_rule" varchar(255),
  "end_time" varchar(255),
  "trigger_condition" varchar(255),
  "reminders" varchar(255),
  "reminder_mode" varchar(255),
  "status" char(1),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;

-- ----------------------------
-- Records of SYS_FORM_MSG_CONFIG
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FORM_PUSH_TASK
-- ----------------------------
DROP TABLE IF EXISTS "sys_form_push_task";
CREATE TABLE "sys_form_push_task" (
  "id" int8 NOT NULL,
  "form_id" int8,
  "data_id" int8,
  "content" varchar(255),
  "first_reminder_time" int8,
  "next_reminder_time" int8,
  "repeat_rule" varchar(255),
  "end_time" int8,
  "reminders" varchar(255),
  "reminder_mode" varchar(36),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;

-- ----------------------------
-- Records of SYS_FORM_PUSH_TASK
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_FUNCTIONS
-- ----------------------------
DROP TABLE IF EXISTS "sys_functions";
CREATE TABLE "sys_functions" (
  "function_id" int8 NOT NULL,
  "function_code" varchar(128),
  "function_module_id" int8,
  "function_name" varchar(128),
  "default_resource_id" int8,
  "is_sys" char(1),
  "seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "application_id" int8
)
;
COMMENT ON COLUMN "sys_functions"."function_id" IS '主键ID';
COMMENT ON COLUMN "sys_functions"."function_code" IS '功能编号';
COMMENT ON COLUMN "sys_functions"."function_module_id" IS '功能模块ID';
COMMENT ON COLUMN "sys_functions"."function_name" IS '功能名称';
COMMENT ON COLUMN "sys_functions"."default_resource_id" IS '功能默认资源ID';
COMMENT ON COLUMN "sys_functions"."is_sys" IS '是否系统功能';
COMMENT ON COLUMN "sys_functions"."seq" IS '功能序号';
COMMENT ON COLUMN "sys_functions"."creator" IS '创建者';
COMMENT ON COLUMN "sys_functions"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_functions"."last_editor" IS '最后修改者';
COMMENT ON COLUMN "sys_functions"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_functions"."application_id" IS '所属应用的id，默认1：属于统一权限平台自身数据';
COMMENT ON TABLE "sys_functions" IS '功能表';

-- ----------------------------
-- Records of SYS_FUNCTIONS
-- ----------------------------
BEGIN;
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (518460834717114368, '0205', 523215083967619072, '客户端管理', 518451664789970944, '1', 6, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (520236482527764480, '0201', 523213269419433984, '插件管理', 520236254294712320, '1', 14, 1450756958461300737, '2021-12-06 13:54:03', 1450756958461300737, '2021-12-06 13:54:03', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (521404105277841408, '0202', 528155915363557376, '应用注册', 521403853758013440, '1', 1, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (522705551881412608, '0203', 521403976781144064, '我的待办', 522705027572441088, '1', 2, 1450756958461300737, '2021-12-13 09:25:15', 1450756958461300737, '2021-12-13 09:25:15', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523555260388876288, '0201', 521403976781144064, '我的已办', 523554762252361728, '1', 3, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523555376986333184, '0202', 521403976781144064, '我的传阅', 523555173533229056, '1', 4, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (526077556152344576, '0205', 526077391123259392, '我的公告', 526077294431969280, '1', 1, 1450756958461300737, '2021-12-22 16:44:23', 1450756958461300737, '2021-12-22 16:44:23', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (535768729024471040, '0205', 523215142994059264, '审计查阅', 535768620278751232, '1', 4, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (544469147921424384, '0201', 523213269419433984, '主题配置', 544468972511436800, '1', 15, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (544475707963875328, '0201', 523215083967619072, '任务管理', 544474404047036416, '1', 8, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (544475799542308864, '0202', 523215083967619072, '任务实例', 544475544734146560, '1', 9, 1450756958461300737, '2022-02-11 11:12:26', 1450756958461300737, '2022-02-11 11:12:26', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (545565036773646336, '0201', 545564987515740160, '统一日志', 545564853264457728, '1', 1, 1450756958461300737, '2022-02-14 11:20:41', 1450756958461300737, '2022-02-14 11:20:41', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (546343149988225024, '0201', 545564987515740160, '链路追踪', 546343017720848384, '1', 2, 1450756958461300737, '2022-02-16 14:52:38', 1450756958461300737, '2022-02-16 14:52:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (546347915988443136, '0202', 545564987515740160, '错误统计', 546346988292284416, '1', 3, 1450756958461300737, '2022-02-16 15:11:34', 1450756958461300737, '2022-02-16 15:11:34', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576438008606367744, '0205', 1450764807862095873, '委托已办', 576437892923269120, '1', 7, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447430137225216, '0203', 576447319827030016, '通道管理', 576444545517232128, '0', 1, 1450756958461300737, '2022-05-10 16:36:17', 1450756958461300737, '2022-05-13 20:15:33', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447488295444480, '0204', 576447319827030016, '签名管理', 576445297899872256, '0', 2, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447546457858048, '0205', 576447319827030016, '模板管理', 576445557296603136, '0', 3, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447608743272448, '0206', 576447319827030016, '发送测试', 576445740617048064, '0', 4, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447666205237248, '0207', 576447319827030016, '发送记录', 576445901988700160, '0', 5, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447721767182336, '0208', 576447319827030016, '发送统计', 576446061217062912, '0', 6, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576448277533433856, '0206', 1450764807862095873, '委托待办', 576425225089196032, '1', 6, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (577911233693622272, '0229', 577911145198002176, '通道管理', 577910957540646912, '0', 1, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (577920176742473728, '0230', 577911145198002176, '发送记录', 577920052196810752, '0', 6, 1450756958461300737, '2022-05-14 18:08:27', 1450756958461300737, '2022-05-15 11:19:58', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578179104113958912, '0231', 577911145198002176, '模板管理', 578178840069939200, '0', 2, 1450756958461300737, '2022-05-15 11:17:20', 1450756958461300737, '2022-05-15 11:19:41', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578179213245554688, '0232', 577911145198002176, '单发测试', 577951344581943296, '0', 3, 1450756958461300737, '2022-05-15 11:17:46', 1450756958461300737, '2022-05-15 11:34:45', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578179275791015936, '0233', 577911145198002176, '群发测试', 577951711264776192, '0', 4, 1450756958461300737, '2022-05-15 11:18:01', 1450756958461300737, '2022-05-15 14:02:18', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578179328681189376, '0234', 577911145198002176, '收件人管理', 577951935202861056, '0', 5, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:19:58', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578180115675226112, '0235', 577911145198002176, '发送统计', 578180013862690816, '0', 7, 1450756958461300737, '2022-05-15 11:21:22', 1450756958461300737, '2022-05-22 10:39:31', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578225632039936000, '0236', 578225558232768512, '通道管理', 578224814087741440, '0', 1, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578225680442204160, '0237', 578225558232768512, '模板管理', 578225070686871552, '0', 2, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578225755054678016, '0238', 578225558232768512, '发送测试', 578225260298772480, '0', 3, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578225803503083520, '0239', 578225558232768512, '发送记录', 578225470362099712, '0', 4, 1450756958461300737, '2022-05-15 14:22:54', 1450756958461300737, '2022-05-15 14:22:54', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579402490307682304, '0240', 579402387463348224, '通道管理', 579400593928626176, '0', 1, 1450756958461300737, '2022-05-18 20:18:38', 1450756958461300737, '2022-05-18 20:18:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579402568669863936, '0241', 579402387463348224, '发送测试', 579401699782041600, '0', 2, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579402651498979328, '0242', 579402387463348224, '发送统计', 579402283595603968, '0', 3, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579407434091864064, '0243', 579407339665498112, '通道管理', 579406581389860864, '0', 1, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579407499330068480, '0244', 579407339665498112, '发送测试', 579406782007615488, '0', 2, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579407703957577728, '0245', 579407339665498112, '发送记录', 579406956977201152, '0', 3, 1450756958461300737, '2022-05-18 20:39:21', 1450756958461300737, '2022-05-18 20:39:21', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579407758378672128, '0246', 579407339665498112, '发送统计', 579407194467082240, '0', 4, 1450756958461300737, '2022-05-18 20:39:34', 1450756958461300737, '2022-05-18 20:39:34', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579987015375003648, '0247', 579402387463348224, '发送记录', 579986784054943744, '0', 4, 1450756958461300737, '2022-05-20 11:01:20', 1450756958461300737, '2022-05-20 11:07:55', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581430666475085824, '0209', 587696011380793344, '流程概览', 564389067157151744, '1', 1, 1450756958461300737, '2022-05-24 10:37:53', 1450756958461300737, '2022-05-24 11:01:57', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581436854533103616, '0210', 587696011380793344, '流程状态分析', 581431768348106752, '1', 2, 1450756958461300737, '2022-05-24 11:02:29', 1450756958461300737, '2022-05-24 11:02:29', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581436941229367296, '0211', 587696011380793344, '流程参与者分析', 581432525403201536, '1', 3, 1450756958461300737, '2022-05-24 11:02:49', 1450756958461300737, '2022-05-24 11:02:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581436993427480576, '0212', 587696011380793344, '流程统计分析', 581434143087534080, '1', 4, 1450756958461300737, '2022-05-24 11:03:02', 1450756958461300737, '2022-05-24 11:03:02', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437139125018624, '0213', 587696011380793344, '热门流程分析', 581434493471301632, '1', 5, 1450756958461300737, '2022-05-24 11:03:37', 1450756958461300737, '2022-05-24 11:03:37', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437221161410560, '0214', 587696011380793344, '流程数量分析', 581434937987833856, '1', 6, 1450756958461300737, '2022-05-24 11:03:56', 1450756958461300737, '2022-05-24 11:03:56', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437297606795264, '0215', 587696011380793344, '用户流程分析', 581435215210356736, '1', 7, 1450756958461300737, '2022-05-24 11:04:14', 1450756958461300737, '2022-05-24 11:04:14', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437337255550976, '0216', 587696011380793344, '待办任务分析', 581435962006183936, '1', 8, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437337255550977, '0217', 587696011380793344, '流程驳回分析', 586205441340743680, '1', 9, 1450756958461300737, '2022-05-24 11:04:24', 1450756958461300737, '2022-05-24 11:04:24', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (581437382767943681, '0218', 587696011380793344, '流程耗时分析', 581436516656750592, '1', 10, 1450756958461300737, '2022-05-24 11:04:35', 1450756958461300737, '2022-05-24 11:04:35', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (582661445364490240, '0248', 578225558232768512, '发送统计', 582661309611646976, '0', 5, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (587709734606610432, '0250', 587709613621911552, '发送记录', 587709219764183040, '0', 2, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (587709787979128832, '0251', 587709613621911552, '发送统计', 587709399175536640, '0', 3, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (588042975440019456, '0252', 587709613621911552, '发送测试', 588042819223166976, '0', 4, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (592386778267394048, '0201', 592400770314543104, '告警设置', 592385945366700032, '1', 1, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (592391757124345856, '0202', 592400770314543104, '告警记录', 592391481915088896, '1', 2, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (595572331049656320, '0201', 595572248216346624, '首页配置', 595571989650087936, '1', 1, 1450756958461300737, '2022-07-02 11:11:49', 1450756958461300737, '2022-07-02 11:11:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (595572392424906752, '0202', 595572248216346624, '三方集成', 595572170466533376, '1', 2, 1450756958461300737, '2022-07-02 11:12:04', 1450756958461300737, '2022-07-02 11:12:04', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (596354099289792512, '0253', 596353922000756736, '应用管理', 596353576553684992, '0', 1, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (608974847288287232, '0205', 596353922000756736, '场景管理', 608974704010862592, '0', 2, 1450756958461300737, '2022-08-08 10:48:38', 1450756958461300737, '2022-08-08 11:21:18', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (641243926136889344, '0201', 641243779856343040, '数据导入', 641241962678329344, '1', 1, 1450756958461300737, '2022-11-05 11:54:26', 1450756958461300737, '2022-11-05 11:54:26', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (641244024103247872, '0202', 641243779856343040, '数据导出', 641241760202498048, '1', 2, 1450756958461300737, '2022-11-05 11:54:49', 1450756958461300737, '2022-11-05 11:54:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (673553074966765568, '0203', 1450764807862095875, '工作流配置项管理', 673551263069380608, '1', 6, 1450756958461300737, '2023-02-02 15:39:27', 1450756958461300737, '2023-02-02 16:21:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686147054220877824, '0201', 686146937447260160, '应用管理', 686146166286721024, '1', 1, 1450756958461300737, '2023-03-09 09:43:26', 1450756958461300737, '2023-03-09 09:43:26', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686147191273955328, '0202', 686146937447260160, '应用回收站', 686146454410240000, '1', 2, 1450756958461300737, '2023-03-09 09:43:58', 1450756958461300737, '2023-03-09 09:43:59', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686178119287316480, '0203', 686176268227715072, '通道管理', 686174839412891648, '0', 1, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686178183690854400, '0204', 686176268227715072, '发送测试', 686175350430113792, '0', 2, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686178259356098560, '0205', 686176268227715072, '发送记录', 686175659781005312, '0', 3, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686178312292409344, '0206', 686176268227715072, '发送统计', 686176030305820672, '0', 4, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (688350053471100928, '0203', 1450764807862095885, '岗位管理', 688348921973710848, '1', 7, 1450756958461300737, '2023-03-15 11:37:22', 1450756958461300737, '2023-03-15 14:05:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (697762187867070464, '0201', 697761878826557440, '通道管理', 697759569409220608, '0', 1, 1450756958461300737, '2023-04-10 10:57:49', 1450756958461300737, '2023-04-10 10:58:05', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (697762370797445120, '0202', 697761878826557440, '发送测试', 697760877801381888, '0', 2, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (697762455014875136, '0203', 697761878826557440, '发送记录', 697761225484017664, '0', 3, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (697762540020834304, '0204', 697761878826557440, '发送统计', 697761494317932544, '0', 4, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (713719009941659648, '0201', 523213321676267520, '资源类型维护', 713718642843590656, '1', 1, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (714425029546483712, '0203', 1450764807862095885, '岗位审核', 714424558668750848, '1', 8, 1450756958461300737, '2023-05-26 10:30:00', 1450756958461300737, '2023-05-26 11:01:14', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (714488057633710080, '0204', 1450764807862095884, '组织角色审核', 714487572214325248, '1', 4, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (714488196960100352, '0205', 1450764807862095884, '岗位角色审核', 714487820982689792, '1', 5, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (714498812294733824, '0206', 523198001884438528, '用户组织审核', 714498499575816192, '1', 4, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (714503247842516992, '0207', 523198001884438528, '用户岗位审核', 714503076626833408, '1', 5, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (729285499054989312, '0201', 686146937447260160, '分组管理', 729285380519763968, '1', 3, 1450756958461300737, '2023-07-06 10:40:13', 1450756958461300737, '2023-07-06 10:40:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (734833871224578048, '0202', 523209654097158144, '工作台banner', 734833718094733312, '1', 6, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (735799387355357184, '0203', 523209654097158144, '组件库维护', 735798877248299008, '1', 7, 1450756958461300737, '2023-07-24 10:04:04', 1450756958461300737, '2023-07-24 10:34:08', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (738862378363658240, '0201', 738862247950163968, '新闻资讯维护', 738861725461520384, '1', 1, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (738862450065285120, '0202', 738862247950163968, '新闻资讯列表', 738861909880872960, '1', 2, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (738864017908703232, '0203', 526077391123259392, '通知更多', 738863554568134656, '1', 1, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (738864188277137408, '0204', 526077391123259392, '消息更多', 738863796810162176, '1', 2, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811595871216214016, '000000000254', 811595767054868480, '通讯录', 811594293004476416, '0', 1, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811885124697464832, '000000000254', 523209654097158144, '广告位配置', 811884745641435136, '0', 8, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811885197636411392, '000000000255', 523209654097158144, '浏览量统计', 811884852453580800, '0', 9, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811885249842913280, '000000000256', 523209654097158144, '顶部横幅', 811884952051523584, '0', 10, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811885297653784576, '000000000257', 523209654097158144, '工具栏收纳', 811885051469111296, '0', 11, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (813348971400667136, '000000000254', 811595767054868480, '标签管理', 813348818371485696, '0', 2, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299398463660032, '000000000255', 815299121857699840, '人员管理功能', 815298988961177600, '0', 1, 1450756958461300737, '2024-02-28 19:08:44', 1450756958461300737, '2024-02-29 14:28:46', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299697123270656, '000000000256', 815299390616117248, '用户维护', 815298745012068352, '0', 1, 1450756958461300737, '2024-02-28 19:09:55', 1450756958461300737, '2024-02-29 15:02:43', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299769068167168, '000000000257', 815299436459859968, '角色维护', 815299064513175552, '0', 1, 1450756958461300737, '2024-02-28 19:10:12', 1450756958461300737, '2024-02-29 14:28:21', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815300362058866688, '000000000256', 815299096469577728, '组织管理功能', 815300265334022144, '0', 1, 1450756958461300737, '2024-02-28 19:12:34', 1450756958461300737, '2024-02-29 14:28:32', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815518987927691264, '000000000258', 815518957997137920, '分级管理', NULL, '1', 1, 1450756958461300737, '2024-02-29 09:41:18', 1450756958461300737, '2024-02-29 18:41:52', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (819883083649261568, '000000000254', 579402387463348224, '模板管理', 819881890768232448, '0', 5, 1450756958461300737, '2024-03-12 10:42:40', 1450756958461300737, '2024-03-12 10:42:40', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (819883155535437824, '000000000255', 579407339665498112, '模板管理', 819881531945525248, '0', 5, 1450756958461300737, '2024-03-12 10:42:57', 1450756958461300737, '2024-03-12 10:42:57', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (819883211101577216, '000000000256', 587709613621911552, '模板管理', 819882250383663104, '0', 5, 1450756958461300737, '2024-03-12 10:43:10', 1450756958461300737, '2024-03-12 10:43:10', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (819883304701665280, '000000000257', 686176268227715072, '模板管理', 819882466553896960, '0', 5, 1450756958461300737, '2024-03-12 10:43:33', 1450756958461300737, '2024-03-12 10:43:33', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (819883353598861312, '000000000258', 697761878826557440, '模板管理', 819882932406853632, '0', 5, 1450756958461300737, '2024-03-12 10:43:44', 1450756958461300737, '2024-03-12 10:43:44', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (825443949341843456, '000000000254', 686146937447260160, '个人环境管理', 825443817938493440, '0', 4, 679338378499727360, '2024-03-27 18:59:34', 679338378499727360, '2024-04-03 16:44:24', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (846427189661671424, '000000000255', 523215083967619072, '环境管理', 846426754422939648, '0', 11, 844891795166076928, '2024-05-24 16:39:28', 844891795166076928, '2024-05-24 16:39:28', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095892, '', 1450764807862095885, '机构维护', 1450765592889004198, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095893, '', 1450764807862095873, '我的传阅', 1450765592889004145, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:48', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095895, '', 523217792733028352, '性能监控', 1450765592889004388, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:36', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095898, '', 523215142994059264, '审计日志', 1450765592889004351, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095900, '', 523215083967619072, '解冻密码', 1450765592889004354, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095901, '', 523213321676267520, '资源管理', 1450765592889004220, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:05:43', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095902, '', 1450764807862095885, '类型定义', 1450765592889004075, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095904, '', 1450764807862095873, '我的催办', 1450765592889004453, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:38', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095905, '', 523215114078527488, '连接池监控', 1450765592889004221, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095908, '', 523198001884438528, '用户维护', 1450765592889004186, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:03:24', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095909, '', 1450764807862095884, '角色维护', 1450765592889004045, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095910, '0225', 523213321676267520, '功能管理', 1450765592889004239, '1', 6, NULL, '2021-06-21 14:33:49', 1450756958461300737, '2021-06-21 14:33:49', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095911, '', 523215083967619072, '重置密码', 1450765592889004407, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095913, '', 523215083967619072, '字典管理', 1450765592889004187, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095915, '', 1450764807862095885, '机构审核', 1450765592889004141, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095917, '', 523215314100690944, '可视化设计器', 1450765592889004274, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:47:02', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095920, '', 523215114078527488, '慢SQL诊断', 1450765592889004293, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095921, '', 523209654097158144, '菜单配置', 1450765592889004395, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095922, '', 1450764807862095885, '规则定义', 1450765592889004167, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095923, '', 523198001884438528, '用户审核', 1450765592889004179, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:05:08', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095924, '', 1450764807862095875, '任务管理', 1450765592889004226, '1', 4, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095925, '', 523215114078527488, '系统监控', 1450765592889004146, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095927, '', 523215114078527488, '在线用户', 1450765592889004414, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:21:39', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095928, '', 523209654097158144, '快捷功能配置', 1450765592889004507, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095929, '', 523215142994059264, '日志下载', 1450765592889004515, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095930, '', 1450764807862095885, '人员审核', 1450765592889004454, '1', 6, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095931, '', 1450764807862095885, '人员管理', 1450765592889004148, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 18:01:13', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095933, '', 1450764807862095875, '函数管理', 1450765592889004356, '1', 5, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095934, '', 523213802016350208, '自定义编码规则', 1450765592889004347, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095935, '', 1450764807862095873, '已办任务', 1450765592889004240, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:31', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095936, '', 523215083967619072, '工作日维护', 1450765592889004325, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:14:19', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095937, '', 1450764807862095875, '流程管理', 1450765592889004085, '1', 2, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095938, '', 523209654097158144, '框架页配置', 1450765592889004517, '1', 4, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095939, '', 1450764807862095884, '用户角色审核', 1450765592889004112, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:55', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095940, '', 523209654097158144, '登录页配置', 1450765592889004334, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 18:58:54', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095941, '', 1450764807862095873, '我的委托', 1450765592889004268, '1', 5, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:55', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095942, '', 523217792733028352, '内容监控', 1450765592889004479, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:24:51', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095943, '', 1450764807862095875, '实例管理', 1450765592889004474, '1', 3, NULL, '2021-06-20 14:39:28', 1450756958461300737, '2021-06-20 14:39:28', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095944, '', 523215142994059264, '在线历史记录', 1450765592889004495, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:25:56', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095945, '', 523213802016350208, '运行参数配置', 1450765592889004131, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095946, '', 1450764807862095884, '不相容角色集', 1450765592889004190, '1', 2, NULL, NULL, 1450756958461300737, '2021-12-14 19:29:46', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095947, '', 1450764807862095873, '待办任务', 1450765592889004229, '1', 1, NULL, NULL, 1450756958461300737, '2021-12-14 19:19:24', 1);
INSERT INTO "sys_functions" ("function_id", "function_code", "function_module_id", "function_name", "default_resource_id", "is_sys", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095949, '', 523213802016350208, '授权信息', 1450765592889004114, '1', 3, NULL, NULL, 1450756958461300737, '2021-12-14 19:31:43', 1);
COMMIT;

-- ----------------------------
-- Table structure for SYS_FUNCTION_MODULES
-- ----------------------------
DROP TABLE IF EXISTS "sys_function_modules";
CREATE TABLE "sys_function_modules" (
  "function_module_id" int8 NOT NULL,
  "function_module_name" varchar(128) NOT NULL,
  "function_module_code" varchar(32),
  "parent_module_id" int8,
  "seq" int4,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "application_id" int8
)
;
COMMENT ON COLUMN "sys_function_modules"."function_module_id" IS '功能模块ID';
COMMENT ON COLUMN "sys_function_modules"."function_module_name" IS '模块名称';
COMMENT ON COLUMN "sys_function_modules"."function_module_code" IS '模块编码';
COMMENT ON COLUMN "sys_function_modules"."parent_module_id" IS '上级模块ID';
COMMENT ON COLUMN "sys_function_modules"."seq" IS '模块排序';
COMMENT ON COLUMN "sys_function_modules"."creator" IS '创建人';
COMMENT ON COLUMN "sys_function_modules"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_function_modules"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_function_modules"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_function_modules"."application_id" IS '所属应用的id，默认1：属于统一权限平台自身数据';
COMMENT ON TABLE "sys_function_modules" IS '功能模块表';

-- ----------------------------
-- Records of SYS_FUNCTION_MODULES
-- ----------------------------
BEGIN;
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (521403976781144064, '统一待办', NULL, 1, 12, 1450756958461300737, '2021-12-09 19:13:15', 1450756958461300737, '2021-12-09 19:13:15', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523176320419766272, '组织权限中心', NULL, 1, 1, 1450756958461300737, '2021-12-14 16:35:55', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523198001884438528, '用户管理', NULL, 523176320419766272, 2, 1450756958461300737, '2021-12-14 18:02:04', 1450756958461300737, '2021-12-14 18:02:04', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523209654097158144, '门户配置中心', NULL, 1, 2, 1450756958461300737, '2021-12-14 18:48:22', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523213269419433984, '开发者中心', NULL, 1, 5, 1450756958461300737, '2021-12-14 19:02:44', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523213321676267520, '功能资源', NULL, 523176320419766272, 4, 1450756958461300737, '2021-12-14 19:02:57', 1450756958461300737, '2021-12-14 19:02:57', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523213802016350208, '系统参数', NULL, 523213269419433984, 3, 1450756958461300737, '2021-12-14 19:04:51', 1450756958461300737, '2021-12-14 19:04:51', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523215032922939392, '运维监控中心', NULL, 1, 6, 1450756958461300737, '2021-12-14 19:09:45', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523215083967619072, '运维工具', NULL, 523215032922939392, 1, 1450756958461300737, '2021-12-14 19:09:57', 1450756958461300737, '2021-12-14 19:09:57', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523215114078527488, '平台监控', NULL, 523215032922939392, 2, 1450756958461300737, '2021-12-14 19:10:04', 1450756958461300737, '2021-12-14 19:10:04', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523215142994059264, '平台日志', NULL, 523215032922939392, 3, 1450756958461300737, '2021-12-14 19:10:11', 1450756958461300737, '2021-12-14 19:10:11', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523215314100690944, '可视化设计器', NULL, 1, 4, 1450756958461300737, '2021-12-14 19:10:52', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (523217792733028352, '缓存监控', NULL, 523215114078527488, 1, 1450756958461300737, '2021-12-14 19:20:43', 1450756958461300737, '2021-12-14 19:20:43', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (526077391123259392, '公告', NULL, 1, 11, 1450756958461300737, '2021-12-22 16:43:44', 1450756958461300737, '2021-12-22 16:43:44', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (528155915363557376, '统一待办', NULL, 523213269419433984, 4, NULL, '2021-12-28 10:23:03', NULL, '2021-12-28 10:23:03', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (545564987515740160, '统一日志', NULL, 523215142994059264, 13, 1450756958461300737, '2022-07-01 11:20:41', 1450756958461300737, '2022-07-01 11:20:41', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576395008970858496, '消息中心', NULL, 1, 13, 1450756958461300737, '2022-05-10 13:07:59', 1450756958461300737, '2022-05-10 13:07:59', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (576447319827030016, '短信推送', NULL, 576395008970858496, 1, 1450756958461300737, '2022-05-10 16:35:51', 1450756958461300737, '2022-05-10 16:35:51', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (577911145198002176, '邮件推送', NULL, 576395008970858496, 2, 1450756958461300737, '2022-05-14 17:32:34', 1450756958461300737, '2022-05-14 17:32:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (578225558232768512, '微信公众号推送', NULL, 576395008970858496, 3, 1450756958461300737, '2022-05-15 14:21:56', 1450756958461300737, '2022-05-15 14:21:56', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579402387463348224, 'IM推送', NULL, 576395008970858496, 4, 1450756958461300737, '2022-05-18 20:18:14', 1450756958461300737, '2022-05-18 20:18:14', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (579407339665498112, 'APP通知推送', NULL, 576395008970858496, 5, 1450756958461300737, '2022-05-18 20:37:55', 1450756958461300737, '2022-05-18 20:37:55', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (587696011380793344, '流程分析', NULL, 1450764807862095875, 1, 1450756958461300737, '2022-06-10 17:34:08', 1450756958461300737, '2022-06-10 17:34:08', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (587709613621911552, '内部通知推送', NULL, 576395008970858496, 6, 1450756958461300737, '2022-06-10 18:28:11', 1450756958461300737, '2022-06-10 18:28:11', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (592400770314543104, '日志告警', NULL, 523215114078527488, 2, 1450756958461300737, '2022-06-23 09:09:10', 1450756958461300737, '2022-06-23 09:09:10', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (595572248216346624, '移动门户配置', NULL, 523209654097158144, 1, 1450756958461300737, '2022-07-02 11:11:29', 1450756958461300737, '2022-07-02 11:11:29', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (596353922000756736, '应用管理', NULL, 576395008970858496, 7, 1450756958461300737, '2022-07-04 14:57:35', 1450756958461300737, '2022-07-04 14:57:35', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (641243779856343040, '数据迁移', NULL, 523215032922939392, 4, 1450756958461300737, '2022-11-05 11:53:51', 1450756958461300737, '2022-11-05 11:53:51', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686146937447260160, '应用管理', NULL, 1, 14, 1450756958461300737, '2023-03-09 09:42:58', 1450756958461300737, '2023-03-09 09:42:58', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (686176268227715072, '企业微信推送', NULL, 576395008970858496, 8, 1450756958461300737, '2023-03-09 11:39:31', 1450756958461300737, '2023-03-09 11:39:31', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (697761878826557440, '钉钉推送', NULL, 576395008970858496, 9, 1450756958461300737, '2023-04-10 10:56:36', 1450756958461300737, '2023-04-10 10:56:36', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (738862247950163968, '新闻资讯', NULL, 1, 15, 1450756958461300737, '2023-08-01 20:54:47', 1450756958461300737, '2023-08-01 20:54:47', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (811595767054868480, '联系人管理', NULL, 576395008970858496, 10, 1450756958461300737, '2024-02-18 13:51:50', 1450756958461300737, '2024-02-18 13:51:50', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815286440933203968, '组织机构', NULL, 1, 16, 1450756958461300737, '2024-02-28 18:17:15', 1450756958461300737, '2024-02-28 18:17:15', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299096469577728, '组织管理', NULL, 815286440933203968, 1, 1450756958461300737, '2024-02-28 19:07:32', 1450756958461300737, '2024-02-28 19:07:32', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299121857699840, '人员管理', NULL, 815286440933203968, 2, 1450756958461300737, '2024-02-28 19:07:38', 1450756958461300737, '2024-02-28 19:07:38', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299390616117248, '用户管理', NULL, 1, 17, 1450756958461300737, '2024-02-28 19:08:42', 1450756958461300737, '2024-02-28 19:08:42', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815299436459859968, '角色管理', NULL, 1, 18, 1450756958461300737, '2024-02-28 19:08:53', 1450756958461300737, '2024-02-28 19:08:53', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (815518957997137920, '分级管理', NULL, 1, 19, 1450756958461300737, '2024-02-29 09:41:11', 1450756958461300737, '2024-02-29 09:41:11', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095873, '个人事项', '', 1, 9, NULL, NULL, 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095875, '流程中心', '', 1, 3, NULL, '2021-06-20 14:30:57', 1450756958461300737, '2021-12-14 19:11:34', 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095884, '角色管理', '', 523176320419766272, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "sys_function_modules" ("function_module_id", "function_module_name", "function_module_code", "parent_module_id", "seq", "creator", "create_time", "last_editor", "last_time", "application_id") VALUES (1450764807862095885, '组织机构', '', 523176320419766272, 1, NULL, NULL, NULL, NULL, 1);
COMMIT;

-- ----------------------------
-- Table structure for SYS_FUNCTION_RESOURCES
-- ----------------------------
DROP TABLE IF EXISTS "sys_function_resources";
CREATE TABLE "sys_function_resources" (
  "sfr_id" int8 NOT NULL,
  "function_id" int8 NOT NULL,
  "resource_id" int8 NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_function_resources"."sfr_id" IS '主键';
COMMENT ON COLUMN "sys_function_resources"."function_id" IS '功能id';
COMMENT ON COLUMN "sys_function_resources"."resource_id" IS '资源id';
COMMENT ON COLUMN "sys_function_resources"."creator" IS '创建人';
COMMENT ON COLUMN "sys_function_resources"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_function_resources"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_function_resources"."last_time" IS '最后修改时间';
COMMENT ON TABLE "sys_function_resources" IS '功能资源关系表';

-- ----------------------------
-- Records of SYS_FUNCTION_RESOURCES
-- ----------------------------
BEGIN;
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (32237820183288250, 518460834717114368, 518451664789970944, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (103839703909204940, 608974847288287232, 608974704010862592, 1450756958461300737, '2022-08-08 11:21:18', 1450756958461300737, '2022-08-08 11:21:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (120507322691962850, 1450764807862095909, 1450765592889004566, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (138426341898569840, 1450764807862095909, 654426928039862272, 1450756958461300737, '2022-12-11 20:59:25', 1450756958461300737, '2022-12-11 20:59:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (163060532147892830, 1450764807862095908, 1450765592889004060, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (214974206552515740, 1450764807862095909, 1450765592889004452, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (236330564504039000, 1450764807862095901, 1450765592889004397, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (246336600208762600, 578179328681189376, 577951935202861056, 1450756958461300737, '2022-05-15 11:18:14', 1450756958461300737, '2022-05-15 11:18:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (272000448824307070, 1450764807862095901, 1450765592889004465, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (294649254804114900, 1450764807862095908, 1450765592889004069, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (297370733459590800, 1450764807862095944, 1450765592889004175, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (297800635119875200, 1450764807862095925, 1450765592889004146, NULL, '2021-06-23 06:12:11', NULL, '2021-06-23 06:12:11');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (299149563277391300, 1450764807862095923, 1450765592889004406, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (300339249092257150, 1450764807862095913, 1450765592889004187, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (318047442350762900, 1450764807862095901, 1450765592889004404, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (339192713332864260, 578225680442204160, 578225070686871552, 1450756958461300737, '2022-05-15 14:22:25', 1450756958461300737, '2022-05-15 14:22:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (371741593868574400, 1450764807862095901, 638042415412027392, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (422025399679930100, 738862450065285120, 738861909880872960, 1450756958461300737, '2023-08-01 20:55:36', 1450756958461300737, '2023-08-01 20:55:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (434508535904026400, 641243926136889344, 641241962678329344, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (466427385931388540, 1450764807862095909, 1450765592889004364, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (491440583011017540, 1450764807862095892, 1585912363104722950, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (494169743728983600, 1450764807862095908, 1450765592889004152, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (508885334026323100, 1450764807862095908, 1450765592889004059, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (539874850424709500, 1450764807862095946, 1450765592889004092, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (550577406580406800, 729285499054989312, 729285380519763968, 1450756958461300737, '2023-07-06 10:40:13', 1450756958461300737, '2023-07-06 10:40:13');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (575357532137176200, 1450764807862095892, 1450765592889004295, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (610834561866679300, 1450764807862095933, 1450765592889004356, NULL, '2021-06-23 06:40:33', NULL, '2021-06-23 06:40:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (621819116948449000, 1450764807862095927, 1450765592889004414, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (623711529299158700, 581437221161410560, 581434937987833856, NULL, '2022-05-24 11:03:56', NULL, '2022-05-24 11:03:56');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (642422504664865500, 1450764807862095921, 1450765592889004487, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (652571499685910000, 714488057633710080, 714487572214325248, 1450756958461300737, '2023-05-26 14:40:27', 1450756958461300737, '2023-05-26 14:40:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (661080598474130600, 1450764807862095900, 1450765592889004354, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (690446705260763500, 1450764807862095919, 1450765592889004065, NULL, '2021-09-26 11:12:43', NULL, '2021-09-26 11:12:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (721537806603650200, 1450764807862095892, 1585912363037614086, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (724576808453237800, 697762540020834304, 697761494317932544, 1450756958461300737, '2023-04-10 10:59:13', 1450756958461300737, '2023-04-10 10:59:13');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046465, 686147054220877824, 1594592180406689798, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046466, 686147054220877824, 1594592180406689799, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046467, 686147054220877824, 1594592180406689800, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046468, 686147054220877824, 1594592180406689801, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046469, 686147054220877824, 1594592180406689802, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046470, 686147054220877824, 1594592180406689803, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (757637280986046471, 686147054220877824, 1594592180406689804, 1450756958461300737, '2023-09-22 16:20:04', 1450756958461300737, '2023-09-22 16:20:04');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (759512770441751700, 1450764807862095901, 1450765592889004101, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (778696738678466700, 1450764807862095909, 1450765592889004433, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811595871555952640, 811595871216214016, 811594293004476416, 1450756958461300737, '2024-02-18 13:52:14', 1450756958461300737, '2024-02-18 13:52:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885125355970560, 811885124697464832, 811884527244025856, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885125355970561, 811885124697464832, 811884745641435136, 1450756958461300737, '2024-02-19 09:01:38', 1450756958461300737, '2024-02-19 09:01:38');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885197766434816, 811885197636411392, 811884562585231360, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885197766434817, 811885197636411392, 811884852453580800, 1450756958461300737, '2024-02-19 09:01:55', 1450756958461300737, '2024-02-19 09:01:55');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885249972936704, 811885249842913280, 811884606541537280, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885249985519616, 811885249842913280, 811884952051523584, 1450756958461300737, '2024-02-19 09:02:08', 1450756958461300737, '2024-02-19 09:02:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885297775419392, 811885297653784576, 811884652779544576, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (811885297779613696, 811885297653784576, 811885051469111296, 1450756958461300737, '2024-02-19 09:02:19', 1450756958461300737, '2024-02-19 09:02:19');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (813348971945926656, 813348971400667136, 813348818371485696, 1450756958461300737, '2024-02-23 09:58:26', 1450756958461300737, '2024-02-23 09:58:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815322049257875000, 1450764807862095909, 1450765592889004311, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347264, 815299769068167168, 1450765592889004080, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347265, 815299769068167168, 1450765592889004144, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347266, 815299769068167168, 1450765592889004171, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347267, 815299769068167168, 1450765592889004189, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347268, 815299769068167168, 1450765592889004237, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347269, 815299769068167168, 1450765592889004269, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347270, 815299769068167168, 1450765592889004281, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347271, 815299769068167168, 1450765592889004330, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347272, 815299769068167168, 1450765592889004333, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347273, 815299769068167168, 1450765592889004391, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347274, 815299769068167168, 1450765592889004433, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347275, 815299769068167168, 1450765592889004452, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347276, 815299769068167168, 1450765592889004472, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347277, 815299769068167168, 1450765592889004501, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347278, 815299769068167168, 1450765592889004516, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347279, 815299769068167168, 1450765592889004566, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347280, 815299769068167168, 1450765592889004206, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347281, 815299769068167168, 1450765592889004536, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347282, 815299769068167168, 1450765592889004311, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347283, 815299769068167168, 1450765592889004064, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347284, 815299769068167168, 1450765592889004204, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347285, 815299769068167168, 1450765592889004062, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347286, 815299769068167168, 1450765592889004211, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347287, 815299769068167168, 1450765592889004149, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347288, 815299769068167168, 1450765592889004555, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347289, 815299769068167168, 1450765592889004432, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347290, 815299769068167168, 1450765592889004512, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347291, 815299769068167168, 1450765592889004422, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347292, 815299769068167168, 1450765592889004143, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347293, 815299769068167168, 1450765592889004368, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347294, 815299769068167168, 1450765592889004443, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347295, 815299769068167168, 1450765592889004183, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347296, 815299769068167168, 1450765592889004364, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347297, 815299769068167168, 1450765592889004417, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347298, 815299769068167168, 1450765592889004503, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347299, 815299769068167168, 642061362138456064, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347300, 815299769068167168, 657533259068219502, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347301, 815299769068167168, 657533259068219503, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347302, 815299769068167168, 651116365914316800, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347303, 815299769068167168, 651119173271035904, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347304, 815299769068167168, 654426928039862272, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591227998347305, 815299769068167168, 815299064513175552, 1450756958461300737, '2024-02-29 14:28:21', 1450756958461300737, '2024-02-29 14:28:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615936, 815300362058866688, 710441229837672448, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615937, 815300362058866688, 1450765592889004053, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615938, 815300362058866688, 1450765592889004161, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615939, 815300362058866688, 1450765592889004508, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615940, 815300362058866688, 1450765592889004124, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615941, 815300362058866688, 1450765592889004363, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615942, 815300362058866688, 1450765592889004539, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615943, 815300362058866688, 1450765592889004342, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615944, 815300362058866688, 1450765592889004208, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615945, 815300362058866688, 1450765592889004394, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615946, 815300362058866688, 1450765592889004265, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615947, 815300362058866688, 1450765592889004180, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615948, 815300362058866688, 1450765592889004073, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615949, 815300362058866688, 1450765592889004564, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615950, 815300362058866688, 1450765592889004223, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615951, 815300362058866688, 1450765592889004153, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615952, 815300362058866688, 1450765592889004502, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615953, 815300362058866688, 1450765592889004295, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615954, 815300362058866688, 1450765592889004134, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615955, 815300362058866688, 1450765592889004199, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615956, 815300362058866688, 1450765592889004521, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615957, 815300362058866688, 1585912362983088129, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615958, 815300362058866688, 1585912363037614082, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615959, 815300362058866688, 1585912363037614083, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615960, 815300362058866688, 1585912363037614084, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615961, 815300362058866688, 1585912363037614085, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615962, 815300362058866688, 1585912363037614086, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615963, 815300362058866688, 1585912363104722945, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615964, 815300362058866688, 1585912363104722946, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615965, 815300362058866688, 1585912363104722947, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615966, 815300362058866688, 1585912363104722948, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615967, 815300362058866688, 1585912363104722949, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615968, 815300362058866688, 1585912363104722950, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615969, 815300362058866688, 1585912363104722951, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273896615970, 815300362058866688, 1585912363104722952, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976064, 815300362058866688, 1585912363104722953, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976065, 815300362058866688, 1585912363104722954, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976066, 815300362058866688, 1585912363104722955, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976067, 815300362058866688, 1585912363104722956, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976068, 815300362058866688, 1585912363104722961, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976069, 815300362058866688, 643045022819950592, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976070, 815300362058866688, 651120420518633472, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976071, 815300362058866688, 707290343955243008, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976072, 815300362058866688, 707287408898778429, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976073, 815300362058866688, 707288922094575616, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273925976074, 815300362058866688, 707287408898744320, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591273930170368, 815300362058866688, 815300265334022144, 1450756958461300737, '2024-02-29 14:28:32', 1450756958461300737, '2024-02-29 14:28:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577536, 815299398463660032, 1450765592889004089, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577537, 815299398463660032, 1450765592889004302, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577538, 815299398463660032, 1450765592889004510, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577539, 815299398463660032, 1450765592889004118, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577540, 815299398463660032, 1450765592889004288, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577541, 815299398463660032, 1450765592889004427, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577542, 815299398463660032, 1450765592889004193, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577543, 815299398463660032, 1450765592889004122, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577544, 815299398463660032, 1450765592889004181, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577545, 815299398463660032, 1592792289372065793, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577546, 815299398463660032, 1592792289447563266, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577547, 815299398463660032, 1592792289447563267, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577548, 815299398463660032, 1592792289447563268, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577549, 815299398463660032, 1592792289447563269, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577550, 815299398463660032, 1592792289447563270, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577551, 815299398463660032, 1592792289447563271, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577552, 815299398463660032, 1592792289447563272, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577553, 815299398463660032, 1592792289447563273, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577554, 815299398463660032, 1592792289447563274, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577555, 815299398463660032, 1592792289447563275, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815591330624577556, 815299398463660032, 815298988961177600, 1450756958461300737, '2024-02-29 14:28:46', 1450756958461300737, '2024-02-29 14:28:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781888, 815299697123270656, 1450765592889004348, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781889, 815299697123270656, 1450765592889004152, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781890, 815299697123270656, 1450765592889004059, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781891, 815299697123270656, 1450765592889004222, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781892, 815299697123270656, 1450765592889004411, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781893, 815299697123270656, 1450765592889004121, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781894, 815299697123270656, 1450765592889004261, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781895, 815299697123270656, 1450765592889004409, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781896, 815299697123270656, 1450765592889004082, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781897, 815299697123270656, 1450765592889004069, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781898, 815299697123270656, 1450765592889004440, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781899, 815299697123270656, 1450765592889004571, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781900, 815299697123270656, 1450765592889004305, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781901, 815299697123270656, 1450765592889004533, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781902, 815299697123270656, 1450765592889004400, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781903, 815299697123270656, 1450765592889004060, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781904, 815299697123270656, 1450765592889004283, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781905, 815299697123270656, 1450765592889004160, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781906, 815299697123270656, 556508576777248768, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781907, 815299697123270656, 631784753686913024, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781908, 815299697123270656, 1592792289514672130, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781909, 815299697123270656, 1592792289514672131, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781910, 815299697123270656, 1592792289514672132, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781911, 815299697123270656, 1592792289514672133, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781912, 815299697123270656, 1592792289514672134, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781913, 815299697123270656, 1592792289514672135, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781914, 815299697123270656, 1592792289514672136, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781915, 815299697123270656, 1592792289514672137, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781916, 815299697123270656, 1592792289514672138, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781917, 815299697123270656, 1592792289514672139, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781918, 815299697123270656, 1592792289514672140, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781919, 815299697123270656, 1592792289514672141, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781920, 815299697123270656, 1592792289514672142, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781921, 815299697123270656, 1592792289514672143, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781922, 815299697123270656, 1592792289514672144, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781923, 815299697123270656, 1594592180406689797, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781924, 815299697123270656, 1594592180469604356, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781925, 815299697123270656, 707291432628789248, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781926, 815299697123270656, 707290869702897456, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781927, 815299697123270656, 707291241079119872, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781928, 815299697123270656, 707290869702860800, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781929, 815299697123270656, 665490432775692288, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (815599874895781930, 815299697123270656, 815298745012068352, 1450756958461300737, '2024-02-29 15:02:43', 1450756958461300737, '2024-02-29 15:02:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (819883084001583104, 819883083649261568, 819881890768232448, 1450756958461300737, '2024-03-12 10:42:40', 1450756958461300737, '2024-03-12 10:42:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (819883155770318848, 819883155535437824, 819881531945525248, 1450756958461300737, '2024-03-12 10:42:57', 1450756958461300737, '2024-03-12 10:42:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (819883211244183552, 819883211101577216, 819882250383663104, 1450756958461300737, '2024-03-12 10:43:10', 1450756958461300737, '2024-03-12 10:43:10');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (819883304802328576, 819883304701665280, 819882466553896960, 1450756958461300737, '2024-03-12 10:43:33', 1450756958461300737, '2024-03-12 10:43:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (819883353754050560, 819883353598861312, 819882932406853632, 1450756958461300737, '2024-03-12 10:43:44', 1450756958461300737, '2024-03-12 10:43:44');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (821056732582387715, 815518987927691264, 758695419206443008, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (821056732582387716, 815518987927691264, 758695918920015872, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (821056732582387717, 815518987927691264, 815518821438988288, 1450756958461300737, '2024-03-15 16:26:20', 1450756958461300737, '2024-03-15 16:26:20');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (827946650596286464, 825443949341843456, 825443817938493440, 679338378499727360, '2024-04-03 16:44:24', 679338378499727360, '2024-04-03 16:44:24');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417634, 815518987927691264, 831116364617097216, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417728, 811595871216214016, 830771482190946304, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417729, 811595871216214016, 830797745085489152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417730, 1450764807862095909, 829416135417143296, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417731, 1450764807862095909, 829418436286488576, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417732, 1450764807862095909, 829418705640497152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417733, 1450764807862095909, 829419102467792896, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417734, 1450764807862095909, 829419565481205760, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417735, 1450764807862095931, 829406184619646976, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417736, 1450764807862095931, 829405596385288192, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417737, 1450764807862095892, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417738, 1450764807862095892, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417739, 1450764807862095892, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417740, 1450764807862095908, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417741, 1450764807862095908, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417742, 1450764807862095908, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417840, 815299769068167168, 829416135417143296, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417841, 815299769068167168, 829418436286488576, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417842, 815299769068167168, 829418705640497152, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417843, 815299769068167168, 829419102467792896, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417844, 815299769068167168, 829419565481205760, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417845, 815299398463660032, 829406184619646976, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417846, 815299398463660032, 829405596385288192, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417847, 815300362058866688, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417848, 815300362058866688, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417849, 815300362058866688, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417850, 815299697123270656, 829396173050880000, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417851, 815299697123270656, 829397564452511744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207353417852, 815299697123270656, 829397905482981376, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (830801207357612032, 811595871216214016, 830797989605023744, 1450756958461300737, '2024-04-11 13:47:23', 1450756958461300737, '2024-04-11 13:47:23');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (833743802140467200, 688350053471100928, 829409027523092480, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (833743802165633024, 688350053471100928, 829409275322572800, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (833743802182410242, 688350053471100928, 829409533184188416, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (833743802207576065, 688350053471100928, 829409805990109184, 1450757642371981314, '2024-04-19 16:40:12', 1450757642371981314, '2024-04-19 16:40:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (841733583395585000, 1450764807862095909, 651119173271035904, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (846427193759506432, 846427189661671424, 846426754422939648, 844891795166076928, '2024-05-24 16:39:29', 844891795166076928, '2024-05-24 16:39:29');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (893715496294441100, 1450764807862095910, 1450765592889004239, NULL, '2021-06-23 05:47:40', NULL, '2021-06-23 05:47:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (908518490049388200, 641243926136889344, 657533259068219399, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (919415598507028000, 526077556152344576, 1450765592889004265, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (925046692895840500, 1450764807862095901, 1450765592889004309, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (960313442635173100, 641244024103247872, 657533259068219502, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (970684485714062500, 1450764807862095930, 1594592180406689793, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1024720445140427000, 1450764807862095901, 638045114752835584, 1450756958461300737, '2022-10-27 16:29:53', 1450756958461300737, '2022-10-27 16:29:53');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1024815990010686600, 1450764807862095892, 1450765592889004208, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1036890509374718700, 520236482527764480, 520236254294712320, 1450756958461300737, '2021-12-06 13:55:31', 1450756958461300737, '2021-12-06 13:55:31');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1055495791568105300, 713719009941659648, 713718642843590656, 1450756958461300737, '2023-04-03 13:38:45', 1450756958461300737, '2023-04-03 13:38:45');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1059682632397965300, 1450764807862095930, 1594592180326998018, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1059776616727542100, 1450764807862095892, 1585912363104722951, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1093900356360513200, 688350053471100928, 688348921973710848, 1450756958461300737, '2023-03-15 14:05:19', 1450756958461300737, '2023-03-15 14:05:19');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1127718932569314000, 1450764807862095892, 651120420518633472, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1146973097038787500, 1450764807862095937, 1450765592889004085, NULL, '2021-06-23 06:39:32', NULL, '2021-06-23 06:39:32');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1179074570130030800, 1450764807862095917, 1450765592889004274, NULL, '2021-08-31 16:20:43', NULL, '2021-08-31 16:20:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1183947773569380600, 1450764807862095931, 1450765592889004193, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1212672447438331000, 1450764807862095908, 1450765592889004440, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1326980394770590500, 1450764807862095923, 1450765592889004338, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1330650432024310800, 1450764807862095923, 1450765592889004213, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1422356362072164600, 1450764807862095934, 1450765592889004200, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1463283875112255000, 1450764807862095908, 1592792289514672132, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1465083453944791800, 577920176742473728, 577920052196810752, 1450756958461300737, '2022-05-15 11:13:59', 1450756958461300737, '2022-05-15 11:13:59');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1508557304661880000, 1450764807862095901, 1450765592889004544, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1510738435591924000, 1450764807862095902, 1450765592889004526, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1534132577012168200, 1450764807862095938, 1450765592889004517, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1535231780077067500, 1450764807862095901, 1450765592889004252, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1540487633956854800, 1450764807862095908, 1592792289514672136, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1541761665124456700, 526356620901621760, 526356511056994304, 1450756958461300737, '2021-12-23 11:13:18', 1450756958461300737, '2021-12-23 11:13:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1586597950604691000, 1450764807862095908, 1592792289514672133, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1598059929234802000, 1450764807862095902, 1450765592889004434, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1602700320237974300, 1450764807862095931, 1592792289447563267, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1609518816656995000, 1450764807862095909, 1450765592889004555, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1611428150808649200, 1450764807862095895, 1450765592889004258, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1623971115387953400, 1450764807862095927, 1450765592889004150, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1641743113031370800, 1450764807862095901, 1450765592889004567, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1651541065029988400, 686178119287316480, 686174839412891648, 1450756958461300737, '2023-03-09 11:46:52', 1450756958461300737, '2023-03-09 11:46:52');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1665473748921275000, 1450764807862095928, 1450765592889004507, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1702621000111275000, 1450764807862095930, 1450765592889004169, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1722420405944111400, 521404105277841408, 521403853758013440, 1450756958461300737, '2021-12-09 19:13:46', 1450756958461300737, '2021-12-09 19:13:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1760159323208247800, 1450764807862095909, 1450765592889004045, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1761078680350173000, 1450764807862095915, 1585912363104722958, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1764871510999710700, 641243926136889344, 657533259068219400, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1766802248873239600, 1450764807862095908, 1592792289514672139, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1794950929770545200, 1450764807862095909, 1450765592889004143, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1815740593570076000, 1450764807862095892, 1585912363104722948, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1816566663599248600, 1450764807862095901, 1450765592889004214, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1847283721174466000, 735799387355357184, 735798877248299008, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1855419488169778700, 1450764807862095923, 1450765592889004477, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1877268305086430700, 1450764807862095908, 1594592180469604356, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1892238538100658700, 1450764807862095936, 1450765592889004105, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1892684453589602300, 1450764807862095901, 1450765592889004460, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1897763020833517800, 1450764807862095931, 1450765592889004427, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1919847628360864300, 1450764807862095892, 1585912363037614083, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1935980527337025300, 1450764807862095901, 1450765592889004485, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1936536466301772800, 1450764807862095931, 1450765592889004510, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1949550274764263400, 706807627035975680, 706807241717850112, 707960023090995203, '2023-05-05 10:01:10', 707960023090995203, '2023-05-05 10:01:10');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1953231193054883000, 1450764807862095931, 1592792289447563269, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1971658812158312200, 1450764807862095909, 1450765592889004211, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1983410821071978500, 1450764807862095909, 1450765592889004237, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1984480780663197200, 1450764807862095938, 1450765592889004119, NULL, '2021-08-31 16:21:14', NULL, '2021-08-31 16:21:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (1994563151592332300, 1450764807862095908, 1592792289514672130, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2001752727345160200, 1450764807862095895, 1450765592889004088, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2030370999913044500, 1450764807862095892, 1585912363104722952, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2031345137601169000, 596354099289792512, 596353576553684992, 1450756958461300737, '2022-07-04 14:58:17', 1450756958461300737, '2022-07-04 14:58:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2046939736589787000, 1450764807862095892, 1585912363104722953, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2049273485948358000, 1450764807862095944, 1450765592889004495, NULL, '2021-06-23 05:50:35', NULL, '2021-06-23 05:50:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2053750865712595000, 1450764807862095901, 1450765592889004218, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2055963100124195000, 1450764807862095931, 1450765592889004148, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2079261246918037200, 1450764807862095936, 1450765592889004462, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2108797039676104200, 1450764807862095909, 1450765592889004503, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2136423814104587500, 1450764807862095942, 1450765592889004482, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2143435087777804300, 1450764807862095945, 1450765592889004263, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2171968905502825500, 1450764807862095936, 1450765592889004371, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2193320752628304100, 545565036773646336, 545564853264457728, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2203063968551473700, 1450764807862095936, 1450765592889004556, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2242213708910559500, 578180115675226112, 578180013862690816, 1450756958461300737, '2022-05-22 10:39:31', 1450756958461300737, '2022-05-22 10:39:31');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2247825399754617000, 1450764807862095908, 1450765592889004305, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2254196369901174000, 1450764807862095908, 1450765592889004082, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2261349797125141500, 1450764807862095902, 1450765592889004469, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2277101967303453700, 1450764807862095901, 1450765592889004292, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2350991115796637000, 1450764807862095892, 1450765592889004198, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2355149980597098000, 1450764807862095931, 1592792289447563272, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2379462716057134000, 1450764807862095892, 1585912363104722945, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2380387672070323700, 1450764807862095930, 1594592180406689795, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2399846630984819700, 578225803503083520, 578225470362099712, 1450756958461300737, '2022-05-15 14:22:55', 1450756958461300737, '2022-05-15 14:22:55');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2405765205128211500, 1450764807862095934, 1450765592889004493, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2466599334579421700, 1450764807862095892, 1585912363037614084, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2469917820659567600, 1450764807862095930, 1594592180406689794, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2492898248283624400, 1450764807862095892, 1585912363037614082, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2551110856072753000, 1450764807862095902, 1450765592889004332, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2581174052246643700, 1450764807862095934, 1450765592889004347, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2613100450870835000, 581436854533103616, 581431768348106752, NULL, '2022-05-24 11:02:29', NULL, '2022-05-24 11:02:29');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2639040774009679000, 1450764807862095922, 1450765592889004499, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2639106464661535000, 1450764807862095949, 1450765592889004416, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2675691861322455000, 1450764807862095892, 1450765592889004053, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2763711700881510000, 1450764807862095895, 1450765592889004115, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2790413979090824000, 1450764807862095946, 1450765592889004190, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2810431123129526000, 1450764807862095945, 1450765592889004131, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2845395767090039300, 588042975440019456, 588042819223166976, 1450756958461300737, '2022-06-11 16:32:51', 1450756958461300737, '2022-06-11 16:32:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2849541863202725000, 1450764807862095908, 1450765592889004160, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2873446997914837000, 581437297606795264, 581435215210356736, NULL, '2022-05-24 11:04:14', NULL, '2022-05-24 11:04:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2875241465125512000, 1450764807862095921, 1450765592889004297, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2892294995399143400, 641243926136889344, 657533259068219398, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2903139567504489000, 1450764807862095908, 1592792289514672143, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2910762183986358000, 1450764807862095909, 1450765592889004330, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (2926712170783723500, 1450764807862095927, 1450765592889004201, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3004160705449305600, 1450764807862095931, 1450765592889004181, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3018331592764750000, 641243926136889344, 657533259068219403, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3027745323871259000, 1450764807862095929, 1450765592889004285, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3059897388336372700, 1450764807862095936, 1450765592889004151, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3070615836658059300, 1450764807862095913, 1450765592889004286, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3134161000793497000, 1450764807862095892, 1585912363104722955, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3202338602762828000, 546347915988443136, 546346988292284416, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3271590496898312700, 1450764807862095921, 1450765592889004357, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3305574599699156500, 1450764807862095931, 1592792289447563266, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3323187159654631400, 1450764807862095930, 1450765592889004454, NULL, '2021-06-23 05:44:28', NULL, '2021-06-23 05:44:28');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3337785656271825000, 1450764807862095895, 1450765592889004545, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3342881980036192000, 1450764807862095923, 1450765592889004179, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3375109022411019000, 544475707963875328, 544474404047036416, 1450756958461300737, '2022-02-11 11:12:05', 1450756958461300737, '2022-02-11 11:12:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3394135695792329000, 1450764807862095908, 1450765592889004411, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3409225707786483700, 1450764807862095908, 665490432775692288, 1450756958461300737, '2023-05-08 11:38:45', 1450756958461300737, '2023-05-08 11:38:45');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3410009148122974700, 526077556152344576, 677910413299687424, 1450756958461300737, '2023-02-14 16:13:57', 1450756958461300737, '2023-02-14 16:13:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3415638094144259000, 1450764807862095939, 1450765592889004112, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3417138352541431000, 1450764807862095892, 643045022819950592, 1450756958461300737, '2022-11-10 11:11:59', 1450756958461300737, '2022-11-10 11:11:59');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3418857910558641700, 1450764807862095892, 1450765592889004342, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3430456294464035300, 1450764807862095936, 1450765592889004224, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3431550087968561000, 1450764807862095934, 1450765592889004509, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3452467247224488400, 1450764807862095946, 1450765592889004188, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3456659651549261300, 522705551881412608, 522705027572441088, 1450756958461300737, '2021-12-14 14:57:33', 1450756958461300737, '2021-12-14 14:57:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3471488454024111000, 1450764807862095923, 1450765592889004168, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3474746363408496000, 579407499330068480, 579406782007615488, 1450756958461300737, '2022-05-18 20:38:33', 1450756958461300737, '2022-05-18 20:38:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3488519505439757300, 578225755054678016, 578225260298772480, 1450756958461300737, '2022-05-15 14:22:43', 1450756958461300737, '2022-05-15 14:22:43');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3505141127397854000, 576447488295444480, 576445297899872256, 1450756958461300737, '2022-05-10 16:36:31', 1450756958461300737, '2022-05-10 16:36:31');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3514213070613710000, 641244024103247872, 657533259068219395, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3546198106165265400, 1450764807862095901, 1450765592889004572, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3547068516515780600, 1450764807862095895, 1450765592889004482, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3555724846944758300, 1450764807862095936, 1450765592889004061, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3572596697533797000, 1450764807862095901, 1450765592889004247, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3587792538161952000, 1450764807862095949, 1450765592889004114, NULL, '2021-06-23 06:04:33', NULL, '2021-06-23 06:04:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3589446535123804000, 1450764807862095943, 1450765592889004474, NULL, '2021-06-23 06:39:44', NULL, '2021-06-23 06:39:44');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3597641265790758000, 641244024103247872, 657533259068219501, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3655814096027428400, 673553074966765568, 673551263069380608, 1450756958461300737, '2023-02-02 16:21:38', 1450756958461300737, '2023-02-02 16:21:38');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3670961758260140000, 1450764807862095920, 1450765592889004293, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3716421673354175500, 1450764807862095913, 1450765592889004382, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3732572515607218700, 576447430137225216, 576444545517232128, 1450756958461300737, '2022-05-13 20:15:33', 1450756958461300737, '2022-05-13 20:15:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3742774354435161600, 1450764807862095929, 1450765592889004461, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3748595416472010000, 581437337255550976, 581435962006183936, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3780467269874520600, 1450764807862095909, 1450765592889004443, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3781178502812923000, 738862378363658240, 737341598572224512, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3789118980178759700, 1450764807862095921, 1450765592889004257, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3809106649826042000, 544469147921424384, 544468972511436800, 1450756958461300737, '2022-02-11 10:46:01', 1450756958461300737, '2022-02-11 10:46:01');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3818813244593985500, 1450764807862095931, 1450765592889004118, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3825440368558890500, 578179104113958912, 578178840069939200, 1450756958461300737, '2022-05-15 11:17:21', 1450756958461300737, '2022-05-15 11:17:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3863961531827612700, 1450764807862095892, 1450765592889004502, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3875512243111428000, 1450764807862095892, 1585912363104722946, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3882497652435606500, 1450764807862095908, 1450765592889004261, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3885274097593552000, 697762455014875136, 697761225484017664, 1450756958461300737, '2023-04-10 10:58:53', 1450756958461300737, '2023-04-10 10:58:53');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3892889728906122000, 714503247842516992, 714503076626833408, 1450756958461300737, '2023-05-26 15:40:49', 1450756958461300737, '2023-05-26 15:40:49');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3896273664635517000, 641243926136889344, 657533259068219401, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3919369046349748000, 1450764807862095901, 1450765592889004147, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3924859900707897000, 1450764807862095931, 1592792289447563274, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3978095210430011400, 1450764807862095901, 1450765592889004039, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3980414475721390600, 1450764807862095931, 1592792289447563270, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (3997485965338456600, 1450764807862095908, 1450765592889004283, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4002368119826934300, 1450764807862095921, 1450765592889004087, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4009278443153617000, 697762187867070464, 697759569409220608, 1450756958461300737, '2023-04-10 10:58:05', 1450756958461300737, '2023-04-10 10:58:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4033234240426174000, 1450764807862095921, 1450765592889004138, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4034857885755173400, 523555260388876288, 523554762252361728, 1450756958461300737, '2021-12-15 17:41:41', 1450756958461300737, '2021-12-15 17:41:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4035590223857203700, 1450764807862095923, 1450765592889004401, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4079944889739185700, 1450764807862095893, 1450765592889004145, NULL, '2021-06-23 06:14:22', NULL, '2021-06-23 06:14:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4081332833452350000, 738862378363658240, 738861725461520384, 1450756958461300737, '2023-08-01 20:55:18', 1450756958461300737, '2023-08-01 20:55:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4151834519846344000, 1450764807862095936, 1450765592889004325, NULL, '2021-06-23 06:04:20', NULL, '2021-06-23 06:04:20');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4154471216289108000, 641244024103247872, 641241760202498048, 1450756958461300737, '2022-11-05 14:02:42', 1450756958461300737, '2022-11-05 14:02:42');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4159744505923209700, 576447721767182336, 576446061217062912, 1450756958461300737, '2022-05-10 16:37:27', 1450756958461300737, '2022-05-10 16:37:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4164526487273307000, 1450764807862095931, 1592792289447563268, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4173951114598774000, 1450764807862095921, 1450765592889004047, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4179567030624378000, 1450764807862095936, 1450765592889004066, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4188983321143105500, 1450764807862095936, 1450765592889004466, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4200131811592521700, 1450764807862095898, 1450765592889004457, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4227335736397070000, 1450764807862095908, 1592792289514672134, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4228502463736115000, 1450764807862095942, 1450765592889004115, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4257282040156218400, 582661445364490240, 582661309611646976, 1450756958461300737, '2022-05-27 20:08:34', 1450756958461300737, '2022-05-27 20:08:34');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4258920424145072600, 1450764807862095901, 1450765592889004565, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4308021991970837500, 1450764807862095892, 1450765592889004521, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4316568325108646000, 1450764807862095941, 1450765592889004268, NULL, '2021-06-23 06:39:19', NULL, '2021-06-23 06:39:19');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4327413024116248000, 1450764807862095929, 1450765592889004515, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4334206056907582500, 1450764807862095946, 1450765592889004136, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4349178580745831000, 1450764807862095909, 642061362138456064, NULL, '2022-11-07 18:02:38', NULL, '2022-11-07 18:02:38');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4355312469684564000, 1450764807862095909, 1450765592889004080, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4375738080934397000, 1450764807862095909, 1450765592889004171, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4380869385156113000, 1450764807862095892, 1450765592889004180, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4413676370924454000, 1450764807862095908, 1592792289514672131, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4421242331761905000, 641243926136889344, 657533259068219406, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4429800302236255700, 641244024103247872, 657533259068219394, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4451344080343822000, 576447666205237248, 576445901988700160, 1450756958461300737, '2022-05-10 16:37:14', 1450756958461300737, '2022-05-10 16:37:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4470818163916753400, 1450764807862095920, 1450765592889004513, NULL, '2021-06-23 06:12:41', NULL, '2021-06-23 06:12:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4485649434350541000, 1450764807862095945, 1450765592889004042, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4488231002449490400, 1450764807862095909, 1450765592889004422, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4511432183335675400, 1450764807862095929, 1450765592889004522, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4532507165374261000, 1450764807862095940, 1450765592889004334, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4542974900865503000, 1450764807862095913, 1450765592889004178, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4559897181492803000, 1450764807862095908, 1592792289514672144, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4563519735709766700, 1450764807862095913, 1450765592889004277, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4576799101076076000, 1450764807862095892, 1450765592889004363, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4599933527961134600, 1450764807862095908, 1450765592889004348, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4661488089173200000, 1450764807862095902, 1450765592889004075, NULL, '2021-06-23 05:39:59', NULL, '2021-06-23 05:39:59');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4687047599491193000, 1450764807862095901, 1450765592889004156, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4730137761740278000, 1450764807862095895, 1450765592889004182, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4746012102747882000, 526077556152344576, 526077294431969280, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4835048994508317000, 1450764807862095892, 1450765592889004564, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4848715528255667000, 1450764807862095901, 1450765592889004329, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4877510692375325000, 1450764807862095908, 1592792289514672141, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4880598817213345000, 1450764807862095909, 1450765592889004333, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4885699579821889000, 1450764807862095946, 1450765592889004259, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4915610029454931000, 1450764807862095931, 1592792289372065793, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4944954171612911000, 546343149988225024, 546343017720848384, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4979109948089132000, 1450764807862095895, 1450765592889004479, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (4994826914933570000, 1450764807862095929, 1450765592889004067, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5022396851955762000, 714488196960100352, 714487820982689792, 1450756958461300737, '2023-05-26 14:41:01', 1450756958461300737, '2023-05-26 14:41:01');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5074963679667732000, 1450764807862095909, 1450765592889004472, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5083358887821602000, 1450764807862095913, 1450765592889004530, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5118955034316991000, 544475799542308864, 544475544734146560, 1450756958461300737, '2022-02-11 11:12:27', 1450756958461300737, '2022-02-11 11:12:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5119290133561532000, 1450764807862095892, 1450765592889004508, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5124600442603036000, 1450764807862095908, 1450765592889004186, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5134544632455492000, 1450764807862095895, 1450765592889004470, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5146478234549692000, 581437337255550977, 586205441340743680, NULL, '2022-05-24 11:04:24', NULL, '2022-05-24 11:04:24');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5166634273131023000, 738864017908703232, 738863554568134656, 1450756958461300737, '2023-08-01 21:01:49', 1450756958461300737, '2023-08-01 21:01:49');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5200507840943897000, 1450764807862095901, 1450765592889004473, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5203434114666971000, 1450764807862095913, 1450765592889004421, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5208171966855981000, 1450764807862095915, 1585912363104722960, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5279185567531117000, 1450764807862095909, 1450765592889004269, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5315053896876473000, 1450764807862095922, 1450765592889004270, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5327192801078872000, 1450764807862095908, 1594592180406689797, NULL, '2022-11-21 09:00:00', NULL, '2022-11-21 09:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5378786281442386000, 1450764807862095913, 1450765592889004310, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5386981152578304000, 1450764807862095927, 1450765592889004558, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5410124374581111000, 526077556152344576, 677910643386621952, 1450756958461300737, '2023-02-14 16:14:52', 1450756958461300737, '2023-02-14 16:14:52');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5437011344041815000, 1450764807862095945, 1450765592889004091, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5467505651327609000, 581437382767943681, 581436516656750592, NULL, '2022-05-24 11:04:35', NULL, '2022-05-24 11:04:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5495945351530107000, 579407703957577728, 579406956977201152, 1450756958461300737, '2022-05-18 20:39:22', 1450756958461300737, '2022-05-18 20:39:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5497885378355284000, 579402651498979328, 579402283595603968, 1450756958461300737, '2022-05-18 20:19:17', 1450756958461300737, '2022-05-18 20:19:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5537901247811356000, 1450764807862095913, 1450765592889004207, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5539196970889990000, 1450764807862095921, 1450765592889004437, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5566067783870530000, 578179275791015936, 577951711264776192, 1450756958461300737, '2022-05-15 14:02:19', 1450756958461300737, '2022-05-15 14:02:19');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5579798555817354000, 1450764807862095909, 1450765592889004432, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5592373173119617000, 577911233693622272, 577910957540646912, 1450756958461300737, '2022-05-14 17:32:55', 1450756958461300737, '2022-05-14 17:32:55');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5602501897192188000, 1450764807862095942, 1450765592889004470, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5614233490237816000, 641244024103247872, 657533259068219503, 1450756958461300737, '2022-11-05 14:03:05', 1450756958461300737, '2022-11-05 14:03:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5630037020813018000, 1450764807862095946, 1450765592889004339, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5653802213703863000, 587709734606610432, 587709219764183040, 1450756958461300737, '2022-06-10 18:28:40', 1450756958461300737, '2022-06-10 18:28:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5687797329544180000, 581436941229367296, 581432525403201536, NULL, '2022-05-24 11:02:49', NULL, '2022-05-24 11:02:49');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5738884712946972000, 641243926136889344, 657533259068219404, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5753118426347250000, 1450764807862095921, 1450765592889004395, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5770502655654679000, 579402568669863936, 579401699782041600, 1450756958461300737, '2022-05-18 20:18:57', 1450756958461300737, '2022-05-18 20:18:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5775284664514161000, 1450764807862095908, 1450765592889004571, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5775995092350120000, 576438008606367744, 576437892923269120, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5780367496094840000, 1450764807862095901, 1450765592889004488, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5810380497366262000, 587709681099874304, 587708514152226816, 1450756958461300737, '2022-06-10 18:28:27', 1450756958461300737, '2022-06-10 18:28:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5836318420422332000, 535768729024471040, 535768620278751232, 1450756958461300737, '2022-01-18 10:33:39', 1450756958461300737, '2022-01-18 10:33:39');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5893484724022913000, 1450764807862095909, 651116365914316800, 1450756958461300737, '2021-12-01 16:18:16', 1450756958461300737, '2021-12-01 16:18:16');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5903494431162094000, 579407434091864064, 579406581389860864, 1450756958461300737, '2022-05-18 20:38:17', 1450756958461300737, '2022-05-18 20:38:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5920334651818401000, 1450764807862095892, 1585912363037614085, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5932931091979795000, 1450764807862095923, 1450765592889004481, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5936510110699688000, 641243926136889344, 657533259068219405, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (5983524870074011000, 1450764807862095902, 1450765592889004378, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6029241791333300000, 1450764807862095892, 1585912363104722954, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6056936221124455000, 523555376986333184, 523555173533229056, 1450756958461300737, '2021-12-15 17:42:09', 1450756958461300737, '2021-12-15 17:42:09');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6058313304120828000, 1450764807862095946, 1450765592889004099, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6103173003479497000, 579402490307682304, 579400593928626176, 1450756958461300737, '2022-05-18 20:18:39', 1450756958461300737, '2022-05-18 20:18:39');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6126027114815556000, 1450764807862095892, 1450765592889004124, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6130125695772322000, 581436993427480576, 581434143087534080, NULL, '2022-05-24 11:03:02', NULL, '2022-05-24 11:03:02');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6133790374255563000, 1450764807862095909, 1450765592889004183, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6159300264044104000, 1450764807862095946, 1450765592889004317, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6165537920642976000, 1450764807862095931, 1450765592889004288, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6186062082179167000, 1450764807862095947, 1450765592889004229, NULL, '2021-06-23 06:13:45', NULL, '2021-06-23 06:13:45');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6194873429919035000, 738864188277137408, 738863796810162176, 1450756958461300737, '2023-08-01 21:02:30', 1450756958461300737, '2023-08-01 21:02:30');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6213297702754915000, 1450764807862095909, 1450765592889004516, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6254306082990807000, 581430666475085824, 564389067157151744, NULL, '2022-05-24 11:01:57', NULL, '2022-05-24 11:01:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6293763916192614000, 1450764807862095913, 1450765592889004212, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6312453972945452000, 578225632039936000, 578224814087741440, 1450756958461300737, '2022-05-15 14:22:14', 1450756958461300737, '2022-05-15 14:22:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6315047255856710000, 1450764807862095940, 1450765592889004119, NULL, '2021-08-31 16:21:03', NULL, '2021-08-31 16:21:03');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6343832864896635000, 714425029546483712, 714424558668750848, 1450756958461300737, '2023-05-26 11:01:14', 1450756958461300737, '2023-05-26 11:01:14');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6350019966416328000, 1450764807862095892, 1450765592889004161, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6403442468784465000, 1450764807862095901, 1450765592889004278, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6404024009937585000, 686178183690854400, 686175350430113792, 1450756958461300737, '2023-03-09 11:47:08', 1450756958461300737, '2023-03-09 11:47:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6404336320549082000, 1450764807862095900, 1450765592889004449, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6444057545505071000, 1450764807862095929, 1450765592889004235, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6452163899984276000, 1450764807862095901, 1450765592889004349, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6472680599435335000, 1450764807862095892, 1585912363104722947, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6479487786698256000, 1450764807862095921, 1450765592889004322, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6483501243502238000, 1450764807862095915, 1585912363104722957, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6484570126183945000, 1450764807862095945, 1450765592889004157, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6500307152796450000, 1450764807862095909, 1450765592889004512, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6519291138556986000, 734833871224578048, 734832488207360000, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6574268310044485000, 1450764807862095915, 1585912363104722959, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6580298633325908000, 1450764807862095915, 1450765592889004141, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6596951099630954000, 1450764807862095909, 1450765592889004281, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6611140817864900000, 1450764807862095901, 1450765592889004369, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6633164977338520000, 1450764807862095934, 1450765592889004445, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6639339325940522000, 641244024103247872, 657533259068219392, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6664171536439597000, 1450764807862095900, 1450765592889004413, NULL, '2021-06-23 06:03:12', NULL, '2021-06-23 06:03:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6666537997161930000, 1450764807862095898, 1450765592889004570, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6667030653375144000, 1450764807862095928, 1450765592889004119, NULL, '2021-08-31 16:21:31', NULL, '2021-08-31 16:21:31');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6686584550031459000, 1450764807862095921, 1450765592889004313, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6705684025738846000, 1450764807862095898, 1450765592889004351, NULL, '2021-06-23 05:50:57', NULL, '2021-06-23 05:50:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6717269891976873000, 1450764807862095892, 1450765592889004539, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6733810371215246000, 1450764807862095931, 1592792289447563273, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6770589361246581000, 1450764807862095935, 1450765592889004240, NULL, '2021-06-23 06:13:57', NULL, '2021-06-23 06:13:57');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6812247779918563000, 1450764807862095892, 1450765592889004394, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6851168973091814000, 1450764807862095901, 1450765592889004337, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6855754700695544000, 578179213245554688, 577951344581943296, 1450756958461300737, '2022-05-15 11:34:45', 1450756958461300737, '2022-05-15 11:34:45');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6858095515455579000, 1450764807862095901, 1450765592889004098, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6922950729674101000, 1450764807862095921, 1450765592889004120, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6978572709325975000, 1450764807862095892, 1585912363104722956, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6997203452672896000, 1450764807862095909, 1450765592889004062, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (6998904789688797000, 1450764807862095908, 1592792289514672138, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7035271792170924000, 641243926136889344, 657533259068219402, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7056570863506333000, 592391757124345856, 592391481915088896, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7067840957476540000, 1450764807862095945, 1450765592889004253, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7074915702170057000, 1450764807862095895, 1450765592889004403, NULL, '2021-06-23 06:09:46', NULL, '2021-06-23 06:09:46');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7141152941257222000, 1450764807862095915, 1450765592889004569, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7182817657769566000, 1450764807862095909, 1450765592889004368, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7193923514192867000, 1450764807862095946, 1450765592889004559, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7206064217642280000, 686147054220877824, 686146166286721024, 1450756958461300737, '2023-03-11 10:39:58', 1450756958461300737, '2023-03-11 10:39:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7228419466900020000, 1450764807862095931, 1450765592889004302, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7230387419835086000, 1450764807862095915, 1450765592889004486, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7256505380841301000, 1450764807862095909, 1450765592889004064, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7259306706210482000, 1450764807862095922, 1450765592889004167, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7276554236861184000, 1450764807862095931, 1592792289447563275, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7282220251011821000, 1450764807862095908, 1592792289514672140, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7283185533511604000, 526077556152344576, 1450765592889004432, 1450756958461300737, '2021-12-27 17:51:30', 1450756958461300737, '2021-12-27 17:51:30');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7295346128432285000, 1450764807862095929, 1450765592889004159, NULL, '2021-06-23 06:09:27', NULL, '2021-06-23 06:09:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7313600775117781000, 1450764807862095892, 1585912363104722961, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7316928202275750000, 641244024103247872, 657533259068219397, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7358975816373811000, 1450764807862095909, 1450765592889004144, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7362745921457370000, 1450764807862095931, 1592792289447563271, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7380330702691458000, 641244024103247872, 657533259068219396, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7385579669169596000, 1450764807862095909, 1450765592889004149, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7389982661807500000, 1450764807862095909, 1450765592889004391, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7394145152272608000, 1450764807862095909, 1450765592889004417, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7395345460225237000, 1450764807862095927, 1450765592889004456, NULL, '2021-06-23 05:49:35', NULL, '2021-06-23 05:49:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7412606610797002000, 734833871224578048, 734833718094733312, 1450756958461300737, '2023-07-21 18:07:27', 1450756958461300737, '2023-07-21 18:07:27');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7416473689547601000, 1450764807862095892, 1450765592889004134, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7457310851623937000, 686147191273955328, 686146454410240000, 1450756958461300737, '2023-03-11 10:40:12', 1450756958461300737, '2023-03-11 10:40:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7475121451587770000, 738862378363658240, 738862163959226368, 1450756958461300737, '2023-08-24 21:16:02', 1450756958461300737, '2023-08-24 21:16:02');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7492967573262157000, 1450764807862095946, 1450765592889004251, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7528114530474617000, 686178259356098560, 686175659781005312, 1450756958461300737, '2023-03-09 11:47:26', 1450756958461300737, '2023-03-09 11:47:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7545485682063677000, 1450764807862095931, 1450765592889004122, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7552550508999115000, 714498812294733824, 714498499575816192, 1450756958461300737, '2023-05-26 15:23:12', 1450756958461300737, '2023-05-26 15:23:12');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7559436617647481000, 1450764807862095901, 1450765592889004344, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7624259898376632000, 1450764807862095942, 1450765592889004258, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7626314151277643000, 1450764807862095946, 1450765592889004323, NULL, '2021-06-23 05:42:06', NULL, '2021-06-23 05:42:06');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7627685903194215000, 1450764807862095908, 1592792289514672135, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7649029061287673000, 1450764807862095909, 1450765592889004536, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7728658222107044000, 1450764807862095908, 1450765592889004121, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7796016520957238000, 1450764807862095909, 1450765592889004189, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7800586799341336000, 576448277533433856, 576425225089196032, NULL, '2022-05-10 00:00:00', NULL, '2022-05-10 00:00:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7827137275325588000, 735799387355357184, 735797215649603584, 1450756958461300737, '2023-07-24 10:34:08', 1450756958461300737, '2023-07-24 10:34:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7842911870199263000, 1450764807862095931, 1450765592889004089, NULL, '2021-06-23 05:40:51', NULL, '2021-06-23 05:40:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7848878822335752000, 1450764807862095901, 1450765592889004529, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7872406607107538000, 1450764807862095892, 1585912362983088129, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7877986980722596000, 1450764807862095913, 1450765592889004384, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7886632004074359000, 1450764807862095909, 1450765592889004206, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7888362631300701000, 1450764807862095923, 1450765592889004366, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7895079182739348000, 1450764807862095901, 1450765592889004052, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7899135802588070000, 1450764807862095904, 1450765592889004453, NULL, '2021-06-23 06:14:10', NULL, '2021-06-23 06:14:10');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7913802952827491000, 1450764807862095905, 1450765592889004221, NULL, '2021-06-23 06:12:26', NULL, '2021-06-23 06:12:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7926049218286810000, 641244024103247872, 657533259068219393, 1450756958461300737, '2022-12-20 10:42:25', 1450756958461300737, '2022-12-20 10:42:25');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (7938159816852189000, 1450764807862095913, 1450765592889004291, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8012986635398130000, 1450764807862095892, 1450765592889004199, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8014902152519676000, 587709787979128832, 587709399175536640, 1450756958461300737, '2022-06-10 18:28:53', 1450756958461300737, '2022-06-10 18:28:53');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8067857347671430000, 1450764807862095901, 1450765592889004307, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8094061504457990000, 1450764807862095908, 1450765592889004409, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8108511052112232000, 1450764807862095945, 1450765592889004551, NULL, '2021-06-23 06:07:18', NULL, '2021-06-23 06:07:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8118170614398197000, 1450764807862095909, 1450765592889004501, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8121326732469579000, 1450764807862095908, 1450765592889004222, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8159978062320227000, 1450764807862095934, 1450765592889004074, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8165649929085861000, 1450764807862095923, 1450765592889004037, NULL, '2021-06-23 05:45:21', NULL, '2021-06-23 05:45:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8178708544219443000, 1450764807862095901, 1450765592889004220, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8218994812766171000, 1450764807862095942, 1450765592889004182, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8229125286955673000, 592386778267394048, 592385945366700032, 1450756958461300737, '2022-07-11 15:04:41', 1450756958461300737, '2022-07-11 15:04:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8264447824536478000, 1450764807862095908, 1592792289514672142, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8313947228812567000, 576447608743272448, 576445740617048064, 1450756958461300737, '2022-05-10 16:37:00', 1450756958461300737, '2022-05-10 16:37:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8315259855418958000, 1450764807862095939, 1450765592889004519, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8330541447586468000, 1450764807862095892, 1585912363104722949, NULL, '2022-10-27 17:26:40', NULL, '2022-10-27 17:26:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8362261482291111000, 1450764807862095909, 1450765592889004204, NULL, '2021-06-23 05:41:51', NULL, '2021-06-23 05:41:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8414710152159558000, 1450764807862095908, 1450765592889004400, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8434139141342351000, 1450764807862095924, 1450765592889004226, NULL, '2021-06-23 06:40:15', NULL, '2021-06-23 06:40:15');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8439927452148045000, 1450764807862095892, 1450765592889004153, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8497553308423673000, 1450764807862095915, 1450765592889004390, NULL, '2021-06-23 05:43:41', NULL, '2021-06-23 05:43:41');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8504726317095393000, 1450764807862095942, 1450765592889004403, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8506041280497158000, 1450764807862095911, 1450765592889004407, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8508944291857246000, 1450764807862095911, 1450765592889004137, NULL, '2021-06-23 06:02:54', NULL, '2021-06-23 06:02:54');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8533345324068517000, 1450764807862095942, 1450765592889004545, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8534212407489383000, 697762370797445120, 697760877801381888, 1450756958461300737, '2023-04-10 10:58:33', 1450756958461300737, '2023-04-10 10:58:33');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8560989646778335000, 1450764807862095908, 1450765592889004533, NULL, '2021-06-23 05:41:35', NULL, '2021-06-23 05:41:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8587248683938692000, 1450764807862095936, 1450765592889004327, NULL, '2021-06-23 06:04:21', NULL, '2021-06-23 06:04:21');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8638460920863153000, 1450764807862095901, 1450765592889004230, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8650379455151402000, 579407758378672128, 579407194467082240, 1450756958461300737, '2022-05-18 20:39:35', 1450756958461300737, '2022-05-18 20:39:35');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8664349155821196000, 1450764807862095939, 1450765592889004173, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8681688362520987000, 1450764807862095942, 1450765592889004088, NULL, '2021-06-23 06:10:17', NULL, '2021-06-23 06:10:17');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8685902543222044000, 1450764807862095913, 1450765592889004563, NULL, '2021-06-23 05:48:26', NULL, '2021-06-23 05:48:26');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8704223561487048000, 1450764807862095939, 1450765592889004444, NULL, '2021-06-23 05:42:22', NULL, '2021-06-23 05:42:22');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8708869807021034000, 576447546457858048, 576445557296603136, 1450756958461300737, '2022-05-10 16:36:45', 1450756958461300737, '2022-05-10 16:36:45');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8710185231025143000, 1450764807862095934, 1450765592889004176, NULL, '2021-06-23 06:03:36', NULL, '2021-06-23 06:03:36');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8725110019329759000, 581437139125018624, 581434493471301632, NULL, '2022-05-24 11:03:37', NULL, '2022-05-24 11:03:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104081375053000, 1450764807862095892, 1450765592889004265, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087548157000, 1450764807862095892, 707290343955243008, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087548157001, 1450764807862095892, 707287408898778429, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087548157002, 1450764807862095892, 707288922094575616, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087548157003, 1450764807862095892, 707287408898744320, 1450756958461300737, '2023-05-08 14:39:05', 1450756958461300737, '2023-05-08 14:39:05');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856000, 1450764807862095908, 707291432628789248, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856001, 1450764807862095908, 707290869702897456, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856002, 1450764807862095908, 707291241079119872, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856003, 1450764807862095908, 707290869702860800, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856004, 1450764807862095913, 6069473931100219001, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856005, 1450764807862095913, 6069473931100219002, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856006, 1450764807862095913, 6069473931100219003, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856007, 1450764807862095913, 6069473931100219004, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856008, 1450764807862095892, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856009, 1450764807862095908, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8735104087574856010, 1450764807862095913, 710441229837672448, 1450756958461300737, '2023-05-08 14:38:51', 1450756958461300737, '2023-05-08 14:38:51');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8737063662919945000, 1450764807862095902, 1450765592889004546, NULL, '2021-06-23 05:40:00', NULL, '2021-06-23 05:40:00');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8752715398724330000, 1450764807862095908, 1592792289514672137, NULL, '2022-11-16 15:44:40', NULL, '2022-11-16 15:44:40');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8770056328260917000, 1450764807862095901, 1450765592889004410, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8785198093272620000, 1450764807862095921, 1450765592889004358, NULL, '2021-06-23 05:47:58', NULL, '2021-06-23 05:47:58');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8788881801441584000, 579987015375003648, 579986784054943744, 1450756958461300737, '2022-05-20 11:07:55', 1450756958461300737, '2022-05-20 11:07:55');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8863128065406379000, 1450764807862095892, 1450765592889004073, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8899633434905354000, 1450764807862095922, 1450765592889004383, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8918716561201663000, 1450764807862095901, 1450765592889004308, NULL, '2021-06-23 05:43:08', NULL, '2021-06-23 05:43:08');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8947485567372642000, 1450764807862095892, 1450765592889004223, NULL, '2021-06-23 05:40:37', NULL, '2021-06-23 05:40:37');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8954866636099882000, 1450764807862095922, 1450765592889004284, NULL, '2021-06-23 05:40:18', NULL, '2021-06-23 05:40:18');
INSERT INTO "sys_function_resources" ("sfr_id", "function_id", "resource_id", "creator", "create_time", "last_editor", "last_time") VALUES (8982688618777375000, 686178312292409344, 686176030305820672, 1450756958461300737, '2023-03-09 11:47:38', 1450756958461300737, '2023-03-09 11:47:38');
COMMIT;

-- ----------------------------
-- Table structure for SYS_GET_BACK_PASSWORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_get_back_password";
CREATE TABLE "sys_get_back_password" (
  "user_id" int8 NOT NULL,
  "p_ques" varchar(64),
  "p_key" varchar(64)
)
;
COMMENT ON COLUMN "sys_get_back_password"."user_id" IS '用户编码';
COMMENT ON COLUMN "sys_get_back_password"."p_ques" IS '找密码的问题';
COMMENT ON COLUMN "sys_get_back_password"."p_key" IS '找密码的答案';
COMMENT ON TABLE "sys_get_back_password" IS '账户密码找回表';

-- ----------------------------
-- Records of SYS_GET_BACK_PASSWORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HAND_SIGN
-- ----------------------------
DROP TABLE IF EXISTS "sys_hand_sign";
CREATE TABLE "sys_hand_sign" (
  "business_id" int8 NOT NULL,
  "user_id" int8,
  "image" text,
  "create_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_hand_sign"."business_id" IS '主键id';
COMMENT ON COLUMN "sys_hand_sign"."user_id" IS '用户id';
COMMENT ON COLUMN "sys_hand_sign"."image" IS '签名信息';
COMMENT ON COLUMN "sys_hand_sign"."create_time" IS '创建时间';

-- ----------------------------
-- Records of SYS_HAND_SIGN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_API_NAMING
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_api_naming";
CREATE TABLE "sys_he_api_naming" (
  "api_id" int8 NOT NULL,
  "business_type" varchar(32) NOT NULL,
  "business_id" varchar(512) NOT NULL,
  "service_id" int8,
  "server_type" varchar(16),
  "service_name" varchar(512),
  "tenant_id" varchar(32) NOT NULL,
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "is_new_version" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_he_api_naming"."api_id" IS 'API 短标识';
COMMENT ON COLUMN "sys_he_api_naming"."business_type" IS '业务类型标识';
COMMENT ON COLUMN "sys_he_api_naming"."business_id" IS '全长业务标识';
COMMENT ON COLUMN "sys_he_api_naming"."service_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_he_api_naming"."server_type" IS '节点/编排类型';
COMMENT ON COLUMN "sys_he_api_naming"."service_name" IS '节点/编排服务名';
COMMENT ON COLUMN "sys_he_api_naming"."tenant_id" IS '租户 ID';
COMMENT ON COLUMN "sys_he_api_naming"."data_status" IS '数据逻辑删除标识';
COMMENT ON COLUMN "sys_he_api_naming"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_api_naming"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_api_naming"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_api_naming"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_api_naming"."is_new_version" IS '是否新版本';
COMMENT ON COLUMN "sys_he_api_naming"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_he_api_naming" IS '接口详情表';

-- ----------------------------
-- Records of SYS_HE_API_NAMING
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_BPM_SERVICE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_bpm_service";
CREATE TABLE "sys_he_bpm_service" (
  "service_id" int8 NOT NULL,
  "service_action" varchar(64),
  "engine_name" varchar(64),
  "engine_service_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "data_status" varchar(2),
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_bpm_service"."service_id" IS '流程服务ID';
COMMENT ON COLUMN "sys_he_bpm_service"."service_action" IS '流程服务动作';
COMMENT ON COLUMN "sys_he_bpm_service"."engine_name" IS '引擎name';
COMMENT ON COLUMN "sys_he_bpm_service"."engine_service_id" IS '引擎业务id';
COMMENT ON COLUMN "sys_he_bpm_service"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_bpm_service"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_bpm_service"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_bpm_service"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_bpm_service"."data_status" IS '状态';
COMMENT ON COLUMN "sys_he_bpm_service"."tenant_id" IS '租户id';
COMMENT ON TABLE "sys_he_bpm_service" IS '工作流数据引擎';

-- ----------------------------
-- Records of SYS_HE_BPM_SERVICE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_CLASS_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_class_info";
CREATE TABLE "sys_he_class_info" (
  "class_id" int8 NOT NULL,
  "class_name" varchar(64),
  "class_path" varchar(256),
  "class_description" varchar(256),
  "in_use" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_he_class_info"."class_id" IS '类主键';
COMMENT ON COLUMN "sys_he_class_info"."class_name" IS '类名称';
COMMENT ON COLUMN "sys_he_class_info"."class_path" IS '类全路径';
COMMENT ON COLUMN "sys_he_class_info"."class_description" IS '类描述';
COMMENT ON COLUMN "sys_he_class_info"."in_use" IS '是否可用';
COMMENT ON COLUMN "sys_he_class_info"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_class_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_class_info"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_class_info"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_he_class_info" IS '编译类信息';

-- ----------------------------
-- Records of SYS_HE_CLASS_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_CLASS_METHOD
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_class_method";
CREATE TABLE "sys_he_class_method" (
  "method_id" int8 NOT NULL,
  "method_name" varchar(64),
  "version_id" int8,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_class_method"."method_id" IS '方法主键';
COMMENT ON COLUMN "sys_he_class_method"."method_name" IS '方法名称';
COMMENT ON COLUMN "sys_he_class_method"."version_id" IS '版本ID';
COMMENT ON COLUMN "sys_he_class_method"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_class_method" IS '编译类方法信息表';

-- ----------------------------
-- Records of SYS_HE_CLASS_METHOD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_CLASS_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_class_version";
CREATE TABLE "sys_he_class_version" (
  "version_id" int8 NOT NULL,
  "class_version" int4,
  "class_id" int8,
  "class_path" varchar(256),
  "class_type" varchar(2),
  "in_use" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_class_version"."version_id" IS '版本ID';
COMMENT ON COLUMN "sys_he_class_version"."class_version" IS '版本';
COMMENT ON COLUMN "sys_he_class_version"."class_id" IS '类ID';
COMMENT ON COLUMN "sys_he_class_version"."class_path" IS '类的全路径';
COMMENT ON COLUMN "sys_he_class_version"."class_type" IS '类的类型';
COMMENT ON COLUMN "sys_he_class_version"."in_use" IS '是否可用';
COMMENT ON COLUMN "sys_he_class_version"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_class_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_class_version"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_class_version"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_class_version"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_class_version" IS '编译类版本信息表';

-- ----------------------------
-- Records of SYS_HE_CLASS_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_AUTOCONF
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_dataservice_autoconf";
CREATE TABLE "sys_he_dataservice_autoconf" (
  "config_id" int8 NOT NULL,
  "dataservice_id" int8 NOT NULL,
  "column_id" int8 NOT NULL,
  "table_id" int8 NOT NULL,
  "put_type" varchar(2) NOT NULL,
  "dic_id" int8,
  "dict_code" int8,
  "input_where" varchar(2),
  "column_alias" varchar(512),
  "column_alias_defined" text,
  "connect_flag" varchar(16),
  "sort" int4,
  "tenant_id" varchar(32),
  "datasource_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."config_id" IS '主键';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."dataservice_id" IS '数据服务ID';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."column_id" IS '列ID';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."table_id" IS '表编号ID';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."put_type" IS '参数类型';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."dic_id" IS '特殊处理类型';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."dict_code" IS '特殊处理方式';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."input_where" IS '00：是更新条件输入';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."column_alias" IS '出入参别名';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."column_alias_defined" IS '用户自定义出入参别名';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."connect_flag" IS 'WHERE字段连接条件(AND或OR)';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."sort" IS '入参字段顺序';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."datasource_status" IS '数据源状态';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_dataservice_autoconf"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_he_dataservice_autoconf" IS '数据服务自动化配置表';

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_AUTOCONF
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_SQL
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_dataservice_sql";
CREATE TABLE "sys_he_dataservice_sql" (
  "sql_id" int8 NOT NULL,
  "dataservice_id" int8 NOT NULL,
  "dataservice_sql" text NOT NULL,
  "table_name" varchar(256),
  "where_sql" varchar(1024),
  "where_children" text,
  "tenant_id" varchar(32),
  "datasource_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_he_dataservice_sql"."sql_id" IS '主键';
COMMENT ON COLUMN "sys_he_dataservice_sql"."dataservice_id" IS '数据服务ID';
COMMENT ON COLUMN "sys_he_dataservice_sql"."dataservice_sql" IS 'SQL';
COMMENT ON COLUMN "sys_he_dataservice_sql"."table_name" IS '表名';
COMMENT ON COLUMN "sys_he_dataservice_sql"."where_sql" IS '条件';
COMMENT ON COLUMN "sys_he_dataservice_sql"."where_children" IS '查询WHERE 嵌套条件信息';
COMMENT ON COLUMN "sys_he_dataservice_sql"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_he_dataservice_sql"."datasource_status" IS '数据源状态';
COMMENT ON COLUMN "sys_he_dataservice_sql"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_dataservice_sql"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_dataservice_sql"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_dataservice_sql"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_he_dataservice_sql" IS '数据服务配置SQL存储表';

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_SQL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_DATASERVICE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_dataservice_table";
CREATE TABLE "sys_he_dataservice_table" (
  "dataservice_id" int8 NOT NULL,
  "datasource_id" int8,
  "mapper_type" varchar(64),
  "dataservice_name" varchar(256) NOT NULL,
  "dataservice_chname" varchar(256) NOT NULL,
  "dataservice_version" int8 NOT NULL,
  "dataservice_status" varchar(2),
  "oper_type" varchar(2),
  "result_type" varchar(2),
  "page_size" int4,
  "pagination" varchar(2),
  "remark" varchar(512),
  "datasource_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "rsv1" varchar(512),
  "rsv2" varchar(512),
  "model_id" int8,
  "master_dataservice_falg" varchar(2),
  "table_id" int8,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_dataservice_table"."dataservice_id" IS '数据服务ID';
COMMENT ON COLUMN "sys_he_dataservice_table"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "sys_he_dataservice_table"."mapper_type" IS 'SQL方式';
COMMENT ON COLUMN "sys_he_dataservice_table"."dataservice_name" IS '数据服务名称';
COMMENT ON COLUMN "sys_he_dataservice_table"."dataservice_chname" IS '数据服务中文名称';
COMMENT ON COLUMN "sys_he_dataservice_table"."dataservice_version" IS '服务版本号';
COMMENT ON COLUMN "sys_he_dataservice_table"."dataservice_status" IS '数据服务状态RN1：未配置（默认）RN2：已配置（可发布）RN3：已发布RN4：已升级（已升级的不可在升级）';
COMMENT ON COLUMN "sys_he_dataservice_table"."oper_type" IS '配置方式';
COMMENT ON COLUMN "sys_he_dataservice_table"."result_type" IS '返回类型，单条还是集合。00:单条,01:集合';
COMMENT ON COLUMN "sys_he_dataservice_table"."page_size" IS '分页显示条数';
COMMENT ON COLUMN "sys_he_dataservice_table"."pagination" IS '是否支持分页RN0：否；1：是';
COMMENT ON COLUMN "sys_he_dataservice_table"."remark" IS '备注';
COMMENT ON COLUMN "sys_he_dataservice_table"."datasource_status" IS '数据源状态';
COMMENT ON COLUMN "sys_he_dataservice_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_dataservice_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_dataservice_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_dataservice_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_dataservice_table"."rsv1" IS '预留1';
COMMENT ON COLUMN "sys_he_dataservice_table"."rsv2" IS '预留2';
COMMENT ON COLUMN "sys_he_dataservice_table"."model_id" IS '主从表模型ID';
COMMENT ON COLUMN "sys_he_dataservice_table"."master_dataservice_falg" IS '1：主从表管理主表发布的数据服务标志';
COMMENT ON COLUMN "sys_he_dataservice_table"."table_id" IS '主从模型从表ID';
COMMENT ON COLUMN "sys_he_dataservice_table"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_dataservice_table" IS '数据服务配置表';

-- ----------------------------
-- Records of SYS_HE_DATASERVICE_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_IMPLEMENTS_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_implements_table";
CREATE TABLE "sys_he_implements_table" (
  "imp_id" int8 NOT NULL,
  "imp_flag" varchar(256) NOT NULL,
  "imp_name" varchar(256) NOT NULL,
  "service_id" int8 NOT NULL,
  "url" varchar(512) NOT NULL,
  "request_type" varchar(64) NOT NULL,
  "imp_version" int8,
  "imp_status" varchar(2),
  "remark" varchar(256),
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "upt_version" int8,
  "rsv1" varchar(512),
  "rsv2" varchar(512),
  "release_source" varchar(2),
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_implements_table"."imp_id" IS '接口地址ID';
COMMENT ON COLUMN "sys_he_implements_table"."imp_flag" IS '接口标识';
COMMENT ON COLUMN "sys_he_implements_table"."imp_name" IS '接口名称';
COMMENT ON COLUMN "sys_he_implements_table"."service_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_he_implements_table"."url" IS '访问地址';
COMMENT ON COLUMN "sys_he_implements_table"."request_type" IS '访问方式';
COMMENT ON COLUMN "sys_he_implements_table"."imp_version" IS '接口版本号';
COMMENT ON COLUMN "sys_he_implements_table"."imp_status" IS '接口状态';
COMMENT ON COLUMN "sys_he_implements_table"."remark" IS '备注';
COMMENT ON COLUMN "sys_he_implements_table"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_implements_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_implements_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_implements_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_implements_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_implements_table"."upt_version" IS '更新版本号';
COMMENT ON COLUMN "sys_he_implements_table"."rsv1" IS '预留1';
COMMENT ON COLUMN "sys_he_implements_table"."rsv2" IS '预留2';
COMMENT ON COLUMN "sys_he_implements_table"."release_source" IS '发布来源：1-表管理；2-数据服务；3-业务服务';
COMMENT ON COLUMN "sys_he_implements_table"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_implements_table" IS '接口地址配置表';

-- ----------------------------
-- Records of SYS_HE_IMPLEMENTS_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_MASTERSLAVE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_masterslave_model";
CREATE TABLE "sys_he_masterslave_model" (
  "model_id" int8 NOT NULL,
  "model_name" varchar(256),
  "master_tableid" int8,
  "master_tablename" varchar(256),
  "model_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "rsv1" text,
  "rsv2" text,
  "model_info" text,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_masterslave_model"."model_id" IS '主键';
COMMENT ON COLUMN "sys_he_masterslave_model"."model_name" IS '主子表模型名称';
COMMENT ON COLUMN "sys_he_masterslave_model"."master_tableid" IS '主表ID';
COMMENT ON COLUMN "sys_he_masterslave_model"."master_tablename" IS '主表表名';
COMMENT ON COLUMN "sys_he_masterslave_model"."model_status" IS '模型状态：2-已配置；3-已发布';
COMMENT ON COLUMN "sys_he_masterslave_model"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_masterslave_model"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_masterslave_model"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_masterslave_model"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_masterslave_model"."rsv1" IS '预留';
COMMENT ON COLUMN "sys_he_masterslave_model"."rsv2" IS '预留';
COMMENT ON COLUMN "sys_he_masterslave_model"."model_info" IS '回显';
COMMENT ON COLUMN "sys_he_masterslave_model"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_masterslave_model" IS '主从模型';

-- ----------------------------
-- Records of SYS_HE_MASTERSLAVE_MODEL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_METADATA_DETAIL_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_metadata_detail_table";
CREATE TABLE "sys_he_metadata_detail_table" (
  "column_id" int8 NOT NULL,
  "table_id" int8 NOT NULL,
  "column_name" varchar(64) NOT NULL,
  "column_chname" varchar(64) NOT NULL,
  "column_comment" varchar(128) NOT NULL,
  "column_type" varchar(32) NOT NULL,
  "column_length" int8 NOT NULL,
  "point_length" int4,
  "is_pk" varchar(2) NOT NULL,
  "is_incre" varchar(2) NOT NULL,
  "is_required" varchar(2) NOT NULL,
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "default_value" varchar(128),
  "tenant_id" varchar(32),
  "purpose" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_id" IS '列ID';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."table_id" IS '表编号ID';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_name" IS '列名称';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_chname" IS '列中文名';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_comment" IS '列描述';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_type" IS '列类型';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."column_length" IS '列长度';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."point_length" IS '列小数点';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."is_pk" IS '是否主键';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."is_incre" IS '是否自增';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."is_required" IS '是否必填';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."default_value" IS '默认值';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_he_metadata_detail_table"."purpose" IS '字段用途 “createUser” 代表创建人   “createTime”代表创建时间   “updateUser”代表修改人“updateTime”  代表修改时间   “delDefFlag”代表删除标记';
COMMENT ON TABLE "sys_he_metadata_detail_table" IS '元数据表详情表';

-- ----------------------------
-- Records of SYS_HE_METADATA_DETAIL_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_METADATA_MANAGE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_metadata_manage_table";
CREATE TABLE "sys_he_metadata_manage_table" (
  "table_id" int8 NOT NULL,
  "table_name" varchar(125) NOT NULL,
  "table_chname" varchar(256),
  "table_comment" varchar(256),
  "count_column" int4 NOT NULL,
  "datasource_id" int8 NOT NULL,
  "character_set" varchar(64) NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "remark" varchar(200),
  "version" int8 NOT NULL,
  "data_status" varchar(2),
  "rsv1" varchar(64),
  "rsv2" varchar(64),
  "release_version" int8,
  "tenant_id" varchar(32),
  "view_flag" varchar(2),
  "view_sql" text
)
;
COMMENT ON COLUMN "sys_he_metadata_manage_table"."table_id" IS '表编号ID';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."table_name" IS '表英文名';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."table_chname" IS '表中文名';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."table_comment" IS '表描述';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."count_column" IS '字段数量';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."character_set" IS '字符集';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."remark" IS '备注';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."version" IS '更新版本号';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."rsv1" IS '预留1';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."rsv2" IS '预留2';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."release_version" IS '表一键发布的版本号';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."view_flag" IS '视图标志';
COMMENT ON COLUMN "sys_he_metadata_manage_table"."view_sql" IS '视图SQL';
COMMENT ON TABLE "sys_he_metadata_manage_table" IS '元数据表管理表';

-- ----------------------------
-- Records of SYS_HE_METADATA_MANAGE_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_RVM_CONTENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_rvm_content";
CREATE TABLE "sys_he_rvm_content" (
  "content_id" int8 NOT NULL,
  "ref_count" int8,
  "data" text
)
;
COMMENT ON COLUMN "sys_he_rvm_content"."content_id" IS '版本内容主键';
COMMENT ON COLUMN "sys_he_rvm_content"."ref_count" IS '数据引用计数';
COMMENT ON COLUMN "sys_he_rvm_content"."data" IS '版本内容数据';
COMMENT ON TABLE "sys_he_rvm_content" IS '版本内容信息表';

-- ----------------------------
-- Records of SYS_HE_RVM_CONTENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_RVM_RESOURCE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_rvm_resource";
CREATE TABLE "sys_he_rvm_resource" (
  "resource_id" int8 NOT NULL,
  "type" varchar(32) NOT NULL,
  "name" varchar(64) NOT NULL,
  "label" varchar(32) NOT NULL,
  "tenant_id" varchar(32) NOT NULL
)
;
COMMENT ON COLUMN "sys_he_rvm_resource"."resource_id" IS '业务服务id';
COMMENT ON COLUMN "sys_he_rvm_resource"."type" IS '资源类型标识';
COMMENT ON COLUMN "sys_he_rvm_resource"."name" IS '资源标识符';
COMMENT ON COLUMN "sys_he_rvm_resource"."label" IS '资源分支标签';
COMMENT ON COLUMN "sys_he_rvm_resource"."tenant_id" IS '租户 ID';
COMMENT ON TABLE "sys_he_rvm_resource" IS '版本资源信息表';

-- ----------------------------
-- Records of SYS_HE_RVM_RESOURCE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_RVM_VERSION
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_rvm_version";
CREATE TABLE "sys_he_rvm_version" (
  "version_id" int8 NOT NULL,
  "resource_id" int8 NOT NULL,
  "content_id" int8,
  "major" int4 NOT NULL,
  "minor" int4 NOT NULL,
  "patch" int4 NOT NULL,
  "description" varchar(256),
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_he_rvm_version"."version_id" IS '资源版本主键';
COMMENT ON COLUMN "sys_he_rvm_version"."resource_id" IS '从属资源主键';
COMMENT ON COLUMN "sys_he_rvm_version"."content_id" IS '对应资源内容引用';
COMMENT ON COLUMN "sys_he_rvm_version"."major" IS '大版本号';
COMMENT ON COLUMN "sys_he_rvm_version"."minor" IS '小版本号';
COMMENT ON COLUMN "sys_he_rvm_version"."patch" IS '修订版本号';
COMMENT ON COLUMN "sys_he_rvm_version"."description" IS '版本描述';
COMMENT ON COLUMN "sys_he_rvm_version"."data_status" IS '版本状态，0 正常，1 已删除';
COMMENT ON COLUMN "sys_he_rvm_version"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_rvm_version"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_rvm_version"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_rvm_version"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_he_rvm_version" IS '版本信息表';

-- ----------------------------
-- Records of SYS_HE_RVM_VERSION
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_DETAIL_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_service_detail_table";
CREATE TABLE "sys_he_service_detail_table" (
  "detail_id" int8 NOT NULL,
  "service_id" int8,
  "dataservice_id" int8,
  "sort_number" int4,
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "tree_sort" int4,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_service_detail_table"."detail_id" IS 'DETAIL_ID';
COMMENT ON COLUMN "sys_he_service_detail_table"."service_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_he_service_detail_table"."dataservice_id" IS '数据服务ID';
COMMENT ON COLUMN "sys_he_service_detail_table"."sort_number" IS '顺序号';
COMMENT ON COLUMN "sys_he_service_detail_table"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_service_detail_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_service_detail_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_service_detail_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_service_detail_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_service_detail_table"."tree_sort" IS '说明：组合与拆分配置时配置多个无关的树RN数据服务所属树的执行顺序';
COMMENT ON COLUMN "sys_he_service_detail_table"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_service_detail_table" IS '业务服务详细表';

-- ----------------------------
-- Records of SYS_HE_SERVICE_DETAIL_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_OUTPUT_INPUT
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_service_output_input";
CREATE TABLE "sys_he_service_output_input" (
  "relate_id" int8 NOT NULL,
  "service_id" int8 NOT NULL,
  "out_dataservice_id" int8 NOT NULL,
  "out_column_id" int8 NOT NULL,
  "in_dataservice_id" int8 NOT NULL,
  "in_column_id" int8 NOT NULL,
  "in_type" varchar(2),
  "in_size" int8,
  "tenant_id" varchar(32),
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_he_service_output_input"."relate_id" IS 'RELATE_ID';
COMMENT ON COLUMN "sys_he_service_output_input"."service_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_he_service_output_input"."out_dataservice_id" IS '出参数据服务ID';
COMMENT ON COLUMN "sys_he_service_output_input"."out_column_id" IS '数据服务出参列ID';
COMMENT ON COLUMN "sys_he_service_output_input"."in_dataservice_id" IS '入参数据服务ID';
COMMENT ON COLUMN "sys_he_service_output_input"."in_column_id" IS '数据服务入参参列ID';
COMMENT ON COLUMN "sys_he_service_output_input"."in_type" IS '入参类型：0-单条；1-集合';
COMMENT ON COLUMN "sys_he_service_output_input"."in_size" IS '入参长度';
COMMENT ON COLUMN "sys_he_service_output_input"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_he_service_output_input"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_service_output_input"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_service_output_input"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_service_output_input"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_service_output_input"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_he_service_output_input" IS '业务服务入出参字段对应关系表';

-- ----------------------------
-- Records of SYS_HE_SERVICE_OUTPUT_INPUT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_SERVICE_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_service_table";
CREATE TABLE "sys_he_service_table" (
  "service_id" int8 NOT NULL,
  "datasource_id" int8,
  "service_name" varchar(256) NOT NULL,
  "service_chname" varchar(512),
  "remark" varchar(512),
  "service_version" int8,
  "service_type" varchar(2),
  "service_statuts" varchar(2),
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "rsv1" varchar(512),
  "rsv2" varchar(512),
  "makeup_info" text,
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_service_table"."service_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_he_service_table"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "sys_he_service_table"."service_name" IS '业务名称';
COMMENT ON COLUMN "sys_he_service_table"."service_chname" IS '业务中文名称';
COMMENT ON COLUMN "sys_he_service_table"."remark" IS '备注';
COMMENT ON COLUMN "sys_he_service_table"."service_version" IS '版本号';
COMMENT ON COLUMN "sys_he_service_table"."service_type" IS '配置方式';
COMMENT ON COLUMN "sys_he_service_table"."service_statuts" IS '业务服务状态';
COMMENT ON COLUMN "sys_he_service_table"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_service_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_service_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_service_table"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_service_table"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_service_table"."rsv1" IS '预留1';
COMMENT ON COLUMN "sys_he_service_table"."rsv2" IS '预留2';
COMMENT ON COLUMN "sys_he_service_table"."makeup_info" IS '组合与拆分连线信息，用于拆分升级时回显';
COMMENT ON COLUMN "sys_he_service_table"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_service_table" IS '业务配置表';

-- ----------------------------
-- Records of SYS_HE_SERVICE_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HE_TABLE_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS "sys_he_table_relationship";
CREATE TABLE "sys_he_table_relationship" (
  "relation_id" int8 NOT NULL,
  "model_id" int8,
  "master_table_id" int8,
  "master_column_id" int8,
  "slave_table_id" int8,
  "slave_column_id" int8,
  "relation_type" int8,
  "data_status" varchar(2),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "rsv1" text,
  "rsv2" text,
  "table_name_alias" varchar(64),
  "tenant_id" varchar(32)
)
;
COMMENT ON COLUMN "sys_he_table_relationship"."relation_id" IS '列ID';
COMMENT ON COLUMN "sys_he_table_relationship"."model_id" IS '主从表主键ID';
COMMENT ON COLUMN "sys_he_table_relationship"."master_table_id" IS '主表ID';
COMMENT ON COLUMN "sys_he_table_relationship"."master_column_id" IS '主表字段ID';
COMMENT ON COLUMN "sys_he_table_relationship"."slave_table_id" IS '从表ID';
COMMENT ON COLUMN "sys_he_table_relationship"."slave_column_id" IS '从表字段ID';
COMMENT ON COLUMN "sys_he_table_relationship"."relation_type" IS '关系类型';
COMMENT ON COLUMN "sys_he_table_relationship"."data_status" IS '数据状态';
COMMENT ON COLUMN "sys_he_table_relationship"."creator" IS '创建人';
COMMENT ON COLUMN "sys_he_table_relationship"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_he_table_relationship"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_he_table_relationship"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_he_table_relationship"."rsv1" IS '预留1';
COMMENT ON COLUMN "sys_he_table_relationship"."rsv2" IS '预留2';
COMMENT ON COLUMN "sys_he_table_relationship"."table_name_alias" IS '1:N 时 OBJECT名称';
COMMENT ON COLUMN "sys_he_table_relationship"."tenant_id" IS '租户ID';
COMMENT ON TABLE "sys_he_table_relationship" IS '主从模型对应关系';

-- ----------------------------
-- Records of SYS_HE_TABLE_RELATIONSHIP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_API_PM
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_api_pm";
CREATE TABLE "sys_hpe_api_pm" (
  "parameter_id" int8 NOT NULL,
  "business_id" varchar(512),
  "in_params" text,
  "in_mapping" text,
  "out_params" text,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_api_pm"."parameter_id" IS '参数ID';
COMMENT ON COLUMN "sys_hpe_api_pm"."business_id" IS '接口全长业务标识';
COMMENT ON COLUMN "sys_hpe_api_pm"."in_params" IS '入参';
COMMENT ON COLUMN "sys_hpe_api_pm"."in_mapping" IS '入参映射';
COMMENT ON COLUMN "sys_hpe_api_pm"."out_params" IS '出参';
COMMENT ON COLUMN "sys_hpe_api_pm"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_api_pm"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_api_pm"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_api_pm"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_api_pm"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_api_pm"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_api_pm"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_api_pm" IS '接口参数表';

-- ----------------------------
-- Records of SYS_HPE_API_PM
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_AUTH_INTERFACE
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_auth_interface";
CREATE TABLE "sys_hpe_auth_interface" (
  "auth_rmi_id" int8 NOT NULL,
  "auth_code" varchar(64),
  "auth_rmi_name" varchar(64),
  "auth_rmi_code" varchar(64),
  "auth_rmi_uri" varchar(128),
  "auth_rmi_type" varchar(16),
  "request_type" varchar(16),
  "content_type" varchar(16),
  "retry_num" int2,
  "retry_interval" int2,
  "auth_class" varchar(512),
  "auth_method" varchar(255),
  "remark" varchar(2048),
  "http_config" text,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_rmi_id" IS '接口id';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_code" IS '认证标识';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_rmi_name" IS '接口名称';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_rmi_code" IS '接口标识';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_rmi_uri" IS '接口uri';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_rmi_type" IS '接口类型';
COMMENT ON COLUMN "sys_hpe_auth_interface"."request_type" IS '请求类型';
COMMENT ON COLUMN "sys_hpe_auth_interface"."content_type" IS '内容类型';
COMMENT ON COLUMN "sys_hpe_auth_interface"."retry_num" IS '重试次数';
COMMENT ON COLUMN "sys_hpe_auth_interface"."retry_interval" IS '重试间隔';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_class" IS '认证固化逻辑';
COMMENT ON COLUMN "sys_hpe_auth_interface"."auth_method" IS '认证固化方法名';
COMMENT ON COLUMN "sys_hpe_auth_interface"."remark" IS '接口描述';
COMMENT ON COLUMN "sys_hpe_auth_interface"."http_config" IS 'http配置';
COMMENT ON COLUMN "sys_hpe_auth_interface"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_auth_interface"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_auth_interface"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_auth_interface"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_auth_interface"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_auth_interface"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_auth_interface"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_auth_interface" IS '认证模板接口表';

-- ----------------------------
-- Records of SYS_HPE_AUTH_INTERFACE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_AUTH_TEMPLATE
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_auth_template";
CREATE TABLE "sys_hpe_auth_template" (
  "auth_id" int8 NOT NULL,
  "auth_name" varchar(64),
  "auth_method" varchar(32),
  "auth_code" varchar(64),
  "auth_type" varchar(32),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_auth_template"."auth_id" IS '认证id';
COMMENT ON COLUMN "sys_hpe_auth_template"."auth_name" IS '认证名称';
COMMENT ON COLUMN "sys_hpe_auth_template"."auth_method" IS '认证方式';
COMMENT ON COLUMN "sys_hpe_auth_template"."auth_code" IS '认证标识';
COMMENT ON COLUMN "sys_hpe_auth_template"."auth_type" IS '认证类型';
COMMENT ON COLUMN "sys_hpe_auth_template"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_auth_template"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_auth_template"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_auth_template"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_auth_template"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_auth_template"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_auth_template"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_auth_template" IS '认证模板';

-- ----------------------------
-- Records of SYS_HPE_AUTH_TEMPLATE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_BPM_PM
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_bpm_pm";
CREATE TABLE "sys_hpe_bpm_pm" (
  "bpm_pm_id" int8 NOT NULL,
  "bpm_pm_key" varchar(255),
  "bpm_pm_value" varchar(255),
  "node_id" int8,
  "node_name" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int8
)
;
COMMENT ON COLUMN "sys_hpe_bpm_pm"."bpm_pm_id" IS '工作流参数ID';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."bpm_pm_key" IS '工作流参数key';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."bpm_pm_value" IS '工作流参数value';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."node_id" IS '节点ID';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."node_name" IS '节点服务名称';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_bpm_pm"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_bpm_pm" IS '工作流参数表';

-- ----------------------------
-- Records of SYS_HPE_BPM_PM
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_DATASERVICE
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_dataservice";
CREATE TABLE "sys_hpe_dataservice" (
  "dataservice_id" int8 NOT NULL,
  "dataservice_type" int2,
  "unique_code" varchar(512),
  "class_name" varchar(255),
  "class_des" varchar(255),
  "method_name" varchar(255),
  "method_des" varchar(255),
  "xml_path" varchar(255),
  "service_type" char(1),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int8
)
;
COMMENT ON COLUMN "sys_hpe_dataservice"."dataservice_id" IS '固化服务ID';
COMMENT ON COLUMN "sys_hpe_dataservice"."dataservice_type" IS '固化类型(关系数据库 service 扩展 编排)';
COMMENT ON COLUMN "sys_hpe_dataservice"."unique_code" IS '方法唯一码l类名+方法名';
COMMENT ON COLUMN "sys_hpe_dataservice"."class_name" IS '固化服务bean名(编排类型为空)';
COMMENT ON COLUMN "sys_hpe_dataservice"."class_des" IS '固化服务bean描述(编排类型为空)';
COMMENT ON COLUMN "sys_hpe_dataservice"."method_name" IS '方法名/编排方法名';
COMMENT ON COLUMN "sys_hpe_dataservice"."method_des" IS '方法/编排方法说明';
COMMENT ON COLUMN "sys_hpe_dataservice"."xml_path" IS '编排xml路径(仅编排类型)';
COMMENT ON COLUMN "sys_hpe_dataservice"."service_type" IS '类型(链/单独)(仅编排类型)';
COMMENT ON COLUMN "sys_hpe_dataservice"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_dataservice"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_dataservice"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_dataservice"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_dataservice"."last_time" IS '修改时间';
COMMENT ON TABLE "sys_hpe_dataservice" IS '固化服务表';

-- ----------------------------
-- Records of SYS_HPE_DATASERVICE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_DATASERVICE_INOUT
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_dataservice_inout";
CREATE TABLE "sys_hpe_dataservice_inout" (
  "inout_id" int8 NOT NULL,
  "data_service_id" int8,
  "inout_type" varchar(4),
  "inout_java_type" varchar(512),
  "inout_alies" varchar(64),
  "order_row" int2,
  "inout_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int8
)
;
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."inout_id" IS '主键ID';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."data_service_id" IS '固化服务ID';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."inout_type" IS '出入参分类';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."inout_java_type" IS '参数类型';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."inout_alies" IS '形参名称';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."order_row" IS '顺序';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."inout_dec" IS '参数说明';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_dataservice_inout"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_dataservice_inout" IS '固化服务出入参表';

-- ----------------------------
-- Records of SYS_HPE_DATASERVICE_INOUT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_logic_business";
CREATE TABLE "sys_hpe_logic_business" (
  "business_id" int8 NOT NULL,
  "model_id" int8,
  "business_name" varchar(64),
  "xml_path" varchar(255),
  "execute_type" varchar(16),
  "business_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_logic_business"."business_id" IS '业务ID';
COMMENT ON COLUMN "sys_hpe_logic_business"."model_id" IS '模型id';
COMMENT ON COLUMN "sys_hpe_logic_business"."business_name" IS '业务服务名称';
COMMENT ON COLUMN "sys_hpe_logic_business"."xml_path" IS '编排xml路径';
COMMENT ON COLUMN "sys_hpe_logic_business"."execute_type" IS '执行类型(同步、异步、混合)';
COMMENT ON COLUMN "sys_hpe_logic_business"."business_dec" IS '业务服务说明';
COMMENT ON COLUMN "sys_hpe_logic_business"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_logic_business"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_logic_business"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_logic_business"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_logic_business"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_logic_business"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_logic_business"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_logic_business" IS '业务服务表';

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS_INOUT
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_logic_business_inout";
CREATE TABLE "sys_hpe_logic_business_inout" (
  "inout_id" int8 NOT NULL,
  "inout_type" varchar(4),
  "inout_java_type" varchar(255),
  "inout_alias" varchar(64),
  "order_row" int2,
  "business_id" int8,
  "is_entity" char(1),
  "is_page" char(1),
  "inout_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."inout_id" IS '出入参ID';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."inout_type" IS '出入参分类(入/出)';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."inout_java_type" IS '参数类型';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."inout_alias" IS '形参名称';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."order_row" IS '顺序';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."business_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."is_entity" IS '是否持久化数据';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."is_page" IS '是否分页';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."inout_dec" IS '参数说明';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_logic_business_inout"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_logic_business_inout" IS '业务服务出入参表(用来配置外层服务的出入参信息)';

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS_INOUT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_LOGIC_BUSINESS_PM
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_logic_business_pm";
CREATE TABLE "sys_hpe_logic_business_pm" (
  "parameter_id" int8 NOT NULL,
  "inout_id" int8,
  "business_id" int8,
  "parameter_type" varchar(16),
  "operator_type" varchar(16),
  "match_type" varchar(4),
  "order_type" varchar(8),
  "column_id" int8,
  "parameter_alias" varchar(64),
  "parameter_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."parameter_id" IS '属性ID';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."inout_id" IS '出入参ID';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."business_id" IS '业务服务ID';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."parameter_type" IS '参数类型(where,column,order,set,values)';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."operator_type" IS '运算符类型(where,values,set)';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."match_type" IS '连接类型(where[and  or])';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."order_type" IS '排序类型(order  [asc,desc])';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."column_id" IS '列id';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."parameter_alias" IS '参数名(属性名)';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."parameter_dec" IS '参数说明';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_logic_business_pm"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_logic_business_pm" IS '业务服务出入参属性表';

-- ----------------------------
-- Records of SYS_HPE_LOGIC_BUSINESS_PM
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_METADATA_COLUMN
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_metadata_column";
CREATE TABLE "sys_hpe_metadata_column" (
  "column_id" int8 NOT NULL,
  "column_name" varchar(255) NOT NULL,
  "column_alias" varchar(255),
  "column_comment" varchar(255),
  "table_id" int8,
  "jdbc_type" varchar(255),
  "java_type" varchar(255),
  "purpose" varchar(32),
  "table_name" varchar(255),
  "data_type" varchar(255),
  "primarys" varchar(8),
  "data_length" int8,
  "data_dot" int4,
  "data_default_value" text,
  "data_is_empty" int2,
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2,
  "purpose_rule" varchar(1024)
)
;
COMMENT ON COLUMN "sys_hpe_metadata_column"."column_id" IS '列id';
COMMENT ON COLUMN "sys_hpe_metadata_column"."column_name" IS '列名';
COMMENT ON COLUMN "sys_hpe_metadata_column"."column_alias" IS '列别名';
COMMENT ON COLUMN "sys_hpe_metadata_column"."column_comment" IS '列注释';
COMMENT ON COLUMN "sys_hpe_metadata_column"."table_id" IS '表id';
COMMENT ON COLUMN "sys_hpe_metadata_column"."jdbc_type" IS 'jdbc类型';
COMMENT ON COLUMN "sys_hpe_metadata_column"."java_type" IS 'java类型';
COMMENT ON COLUMN "sys_hpe_metadata_column"."purpose" IS '字段用途';
COMMENT ON COLUMN "sys_hpe_metadata_column"."table_name" IS '表名';
COMMENT ON COLUMN "sys_hpe_metadata_column"."data_type" IS '字段类型';
COMMENT ON COLUMN "sys_hpe_metadata_column"."primarys" IS '主键';
COMMENT ON COLUMN "sys_hpe_metadata_column"."data_length" IS '字段长度';
COMMENT ON COLUMN "sys_hpe_metadata_column"."data_dot" IS '字段精度';
COMMENT ON COLUMN "sys_hpe_metadata_column"."data_default_value" IS '默认值';
COMMENT ON COLUMN "sys_hpe_metadata_column"."data_is_empty" IS '是否空值';
COMMENT ON COLUMN "sys_hpe_metadata_column"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_metadata_column"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_metadata_column"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_metadata_column"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_metadata_column"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_metadata_column"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_metadata_column"."hpe_version" IS '版本标识';
COMMENT ON COLUMN "sys_hpe_metadata_column"."purpose_rule" IS '特殊字段值规则';
COMMENT ON TABLE "sys_hpe_metadata_column" IS '元数据列信息';

-- ----------------------------
-- Records of SYS_HPE_METADATA_COLUMN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_METADATA_TABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_metadata_table";
CREATE TABLE "sys_hpe_metadata_table" (
  "table_id" int8 NOT NULL,
  "table_name" varchar(255),
  "table_alias" varchar(255),
  "table_dec" varchar(255),
  "table_type" varchar(32),
  "datasource_id" int8,
  "poll_name" varchar(64),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_metadata_table"."table_id" IS '表id';
COMMENT ON COLUMN "sys_hpe_metadata_table"."table_name" IS '表名';
COMMENT ON COLUMN "sys_hpe_metadata_table"."table_alias" IS '表别名';
COMMENT ON COLUMN "sys_hpe_metadata_table"."table_dec" IS '说明';
COMMENT ON COLUMN "sys_hpe_metadata_table"."table_type" IS '表类型系统表/业务表';
COMMENT ON COLUMN "sys_hpe_metadata_table"."datasource_id" IS '数据源ID';
COMMENT ON COLUMN "sys_hpe_metadata_table"."poll_name" IS 'pollName';
COMMENT ON COLUMN "sys_hpe_metadata_table"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_metadata_table"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_metadata_table"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_metadata_table"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_metadata_table"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_metadata_table"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_metadata_table"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_metadata_table" IS '元数据表信息';

-- ----------------------------
-- Records of SYS_HPE_METADATA_TABLE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_COLUMNS
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_model_columns";
CREATE TABLE "sys_hpe_model_columns" (
  "model_column_id" int8 NOT NULL,
  "column_id" int8,
  "column_name" varchar(100),
  "column_alias" varchar(100),
  "related_id" int8,
  "tfmodel_column_id" varchar(64),
  "tfmodel_id" varchar(64),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2,
  "column_remark" varchar(100)
)
;
COMMENT ON COLUMN "sys_hpe_model_columns"."model_column_id" IS '模型元数据列ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."column_id" IS '元数据列的ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."column_name" IS '列名';
COMMENT ON COLUMN "sys_hpe_model_columns"."column_alias" IS '列别名';
COMMENT ON COLUMN "sys_hpe_model_columns"."related_id" IS '模型与元数据关联ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."tfmodel_column_id" IS '天斧模型列ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."tfmodel_id" IS '天斧模型ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_model_columns"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_model_columns"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_model_columns"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_model_columns"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_model_columns"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_model_columns"."hpe_version" IS '版本标识';
COMMENT ON COLUMN "sys_hpe_model_columns"."column_remark" IS '字段备注';
COMMENT ON TABLE "sys_hpe_model_columns" IS '元数据列信息';

-- ----------------------------
-- Records of SYS_HPE_MODEL_COLUMNS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_COLUMNS_RULES
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_model_columns_rules";
CREATE TABLE "sys_hpe_model_columns_rules" (
  "rule_id" int8 NOT NULL,
  "tfmodel_id" varchar(64),
  "rule_type" char(1),
  "related_id" int8,
  "model_column_id" int8,
  "column_name" varchar(100),
  "column_alias" varchar(100),
  "rule_content" text,
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."rule_id" IS '规则ID';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."tfmodel_id" IS '天斧模型ID';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."rule_type" IS '1:脱敏 2:字段翻译';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."related_id" IS '模型与元数据关联ID';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."model_column_id" IS '模型列ID';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."column_name" IS '列名';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."column_alias" IS '列别名';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."rule_content" IS '类型是脱敏,存储脱敏表达式;类型是字段翻译,存储翻译的json结构';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_model_columns_rules"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_model_columns_rules" IS '模型字段字典规则';

-- ----------------------------
-- Records of SYS_HPE_MODEL_COLUMNS_RULES
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_MODEL_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_model_relationship";
CREATE TABLE "sys_hpe_model_relationship" (
  "related_id" int8 NOT NULL,
  "tfmodel_id" varchar(64),
  "tfmodel_name" varchar(100),
  "type" varchar(16),
  "parent_path" text,
  "table_id" int8,
  "relation" varchar(16),
  "param_name" varchar(100),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_model_relationship"."related_id" IS '主键ID';
COMMENT ON COLUMN "sys_hpe_model_relationship"."tfmodel_id" IS '天斧模型的ID';
COMMENT ON COLUMN "sys_hpe_model_relationship"."tfmodel_name" IS '天斧的模型名';
COMMENT ON COLUMN "sys_hpe_model_relationship"."type" IS '类型分为:单表(single)，主子表(master),单表流程(singleflow),主子表流程(masterflow),api模型（api）';
COMMENT ON COLUMN "sys_hpe_model_relationship"."parent_path" IS '父路径';
COMMENT ON COLUMN "sys_hpe_model_relationship"."table_id" IS '表ID';
COMMENT ON COLUMN "sys_hpe_model_relationship"."relation" IS '关系1-1 1-N N-1';
COMMENT ON COLUMN "sys_hpe_model_relationship"."param_name" IS '表别名';
COMMENT ON COLUMN "sys_hpe_model_relationship"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_model_relationship"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_model_relationship"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_model_relationship"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_model_relationship"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_model_relationship"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_model_relationship"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_model_relationship" IS '模型信息';

-- ----------------------------
-- Records of SYS_HPE_MODEL_RELATIONSHIP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_node_business";
CREATE TABLE "sys_hpe_node_business" (
  "node_id" int8 NOT NULL,
  "model_id" int8,
  "node_name" varchar(512),
  "action_name" varchar(64),
  "node_dec" varchar(255),
  "data_service_code" varchar(255),
  "data_service_action_name" varchar(255),
  "node_type" varchar(16),
  "node_class" varchar(100),
  "business_code" varchar(100),
  "in_params" text,
  "in_mapping" text,
  "json_params" text,
  "out_params" text,
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_node_business"."node_id" IS '节点ID';
COMMENT ON COLUMN "sys_hpe_node_business"."model_id" IS '表/模型id';
COMMENT ON COLUMN "sys_hpe_node_business"."node_name" IS '节点服务名称';
COMMENT ON COLUMN "sys_hpe_node_business"."action_name" IS '方法名称';
COMMENT ON COLUMN "sys_hpe_node_business"."node_dec" IS '服务说明';
COMMENT ON COLUMN "sys_hpe_node_business"."data_service_code" IS '固化服务CODE';
COMMENT ON COLUMN "sys_hpe_node_business"."data_service_action_name" IS '固化服务方法名';
COMMENT ON COLUMN "sys_hpe_node_business"."node_type" IS '节点类型（single:单表 master:主子 flow:工作流）';
COMMENT ON COLUMN "sys_hpe_node_business"."node_class" IS '逻辑单元标识';
COMMENT ON COLUMN "sys_hpe_node_business"."business_code" IS '业务方法标识（发布是流程时使用）';
COMMENT ON COLUMN "sys_hpe_node_business"."in_params" IS '节点入参';
COMMENT ON COLUMN "sys_hpe_node_business"."in_mapping" IS '入参映射';
COMMENT ON COLUMN "sys_hpe_node_business"."json_params" IS '入参格式json';
COMMENT ON COLUMN "sys_hpe_node_business"."out_params" IS '节点出参';
COMMENT ON COLUMN "sys_hpe_node_business"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_node_business"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_node_business"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_node_business"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_node_business"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_node_business"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_node_business"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_node_business" IS '节点业务服务表';

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS_INOUT
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_node_business_inout";
CREATE TABLE "sys_hpe_node_business_inout" (
  "inout_id" int8 NOT NULL,
  "inout_type" varchar(4),
  "inout_java_type" varchar(255),
  "inout_alias" varchar(64),
  "order_row" int2,
  "node_id" int8,
  "is_entity" char(1),
  "is_page" char(1),
  "inout_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_node_business_inout"."inout_id" IS '出入参ID';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."inout_type" IS '出入参分类(入/出)';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."inout_java_type" IS '参数类型';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."inout_alias" IS '形参名称';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."order_row" IS '顺序';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."node_id" IS '结点服务ID';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."is_entity" IS '是否持久化数据(0:非持久化 1:持久化数据)';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."is_page" IS '是否分页';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."inout_dec" IS '参数说明';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_node_business_inout"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_node_business_inout" IS '节点业务服务出入参表(用来配置出入参信息)';

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS_INOUT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_NODE_BUSINESS_PM
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_node_business_pm";
CREATE TABLE "sys_hpe_node_business_pm" (
  "parameter_id" int8 NOT NULL,
  "inout_id" int8,
  "node_id" int8,
  "parameter_type" varchar(16),
  "operator_type" varchar(16),
  "match_type" varchar(4),
  "order_type" varchar(8),
  "column_id" int8,
  "parameter_alias" varchar(64),
  "parameter_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2,
  "parent_id" int8
)
;
COMMENT ON COLUMN "sys_hpe_node_business_pm"."parameter_id" IS '属性ID';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."inout_id" IS '出入参ID';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."node_id" IS '节点业务服务ID';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."parameter_type" IS '参数类型(where,column,order,set,values)';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."operator_type" IS '运算符类型(where,values,set)';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."match_type" IS '连接类型(where[and  or])';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."order_type" IS '排序类型(order  [asc,desc])';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."column_id" IS '列id';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."parameter_alias" IS '参数名(属性名)';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."parameter_dec" IS '参数说明';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."hpe_version" IS '版本标识';
COMMENT ON COLUMN "sys_hpe_node_business_pm"."parent_id" IS '父级ID';
COMMENT ON TABLE "sys_hpe_node_business_pm" IS '节点业务服务出入参属性表';

-- ----------------------------
-- Records of SYS_HPE_NODE_BUSINESS_PM
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_PUB_VAR
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_pub_var";
CREATE TABLE "sys_hpe_pub_var" (
  "pub_var_id" int8 NOT NULL,
  "belong_id" int8,
  "belong_type" varchar(16),
  "pub_var_express" varchar(128),
  "pub_var_name" varchar(64),
  "pub_var_key" varchar(64),
  "pub_var_value" varchar(512),
  "is_built_in" char(1),
  "expire_time" timestamp without time zone,
  "app_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_pub_var"."pub_var_id" IS '公共变量id';
COMMENT ON COLUMN "sys_hpe_pub_var"."belong_id" IS '所属id';
COMMENT ON COLUMN "sys_hpe_pub_var"."belong_type" IS '所属类型';
COMMENT ON COLUMN "sys_hpe_pub_var"."pub_var_express" IS '公共变量表达式';
COMMENT ON COLUMN "sys_hpe_pub_var"."pub_var_name" IS '公共变量名称';
COMMENT ON COLUMN "sys_hpe_pub_var"."pub_var_key" IS '公共变量key';
COMMENT ON COLUMN "sys_hpe_pub_var"."pub_var_value" IS '公共变量value';
COMMENT ON COLUMN "sys_hpe_pub_var"."is_built_in" IS '是否内置';
COMMENT ON COLUMN "sys_hpe_pub_var"."expire_time" IS '失效时间';
COMMENT ON COLUMN "sys_hpe_pub_var"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_hpe_pub_var"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_pub_var"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_pub_var"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_pub_var"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_pub_var"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_pub_var"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_pub_var"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_pub_var" IS '公共变量表';

-- ----------------------------
-- Records of SYS_HPE_PUB_VAR
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RECYCLE_BIN
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_recycle_bin";
CREATE TABLE "sys_hpe_recycle_bin" (
  "mc_id" int8 NOT NULL,
  "table_id" int8,
  "model_id" int8,
  "table_name" varchar(255),
  "column_name" varchar(255),
  "column_json" text,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_hpe_recycle_bin"."mc_id" IS '主键';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."table_id" IS '元数据表ID';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."model_id" IS '模型ID';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."table_name" IS '表名';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."column_name" IS '列名';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."column_json" IS '删除的列JSON';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_hpe_recycle_bin"."last_time" IS '最后一次修改时间';
COMMENT ON TABLE "sys_hpe_recycle_bin" IS '列回收站信息表';

-- ----------------------------
-- Records of SYS_HPE_RECYCLE_BIN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_relationship";
CREATE TABLE "sys_hpe_relationship" (
  "model_id" int8 NOT NULL,
  "model_name" varchar(255),
  "model_dec" varchar(255),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2,
  "master_table_id" int8
)
;
COMMENT ON COLUMN "sys_hpe_relationship"."model_id" IS '模型id';
COMMENT ON COLUMN "sys_hpe_relationship"."model_name" IS '模型名称';
COMMENT ON COLUMN "sys_hpe_relationship"."model_dec" IS '模型说明';
COMMENT ON COLUMN "sys_hpe_relationship"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_relationship"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_relationship"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_relationship"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_relationship"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_relationship"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_relationship"."hpe_version" IS '版本标识';
COMMENT ON COLUMN "sys_hpe_relationship"."master_table_id" IS '主表表ID';
COMMENT ON TABLE "sys_hpe_relationship" IS '元数据主从关联关系信息表';

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP_JOIN
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_relationship_join";
CREATE TABLE "sys_hpe_relationship_join" (
  "join_id" int8 NOT NULL,
  "model_id" int8,
  "left_table_id" int8,
  "right_table_id" int8,
  "join_type" varchar(32),
  "param_name" varchar(255),
  "relation" varchar(16),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_relationship_join"."join_id" IS 'JOIN关系id';
COMMENT ON COLUMN "sys_hpe_relationship_join"."model_id" IS '关联关系模型id';
COMMENT ON COLUMN "sys_hpe_relationship_join"."left_table_id" IS '左表id';
COMMENT ON COLUMN "sys_hpe_relationship_join"."right_table_id" IS '右表id';
COMMENT ON COLUMN "sys_hpe_relationship_join"."join_type" IS '连接条件';
COMMENT ON COLUMN "sys_hpe_relationship_join"."param_name" IS '关联列属性名';
COMMENT ON COLUMN "sys_hpe_relationship_join"."relation" IS '关系1-1 1-N N-1';
COMMENT ON COLUMN "sys_hpe_relationship_join"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_relationship_join"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_relationship_join"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_relationship_join"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_relationship_join"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_relationship_join"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_relationship_join"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_relationship_join" IS '元数据主从关联关系JOIN表';

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP_JOIN
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RELATIONSHIP_ON
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_relationship_on";
CREATE TABLE "sys_hpe_relationship_on" (
  "on_id" int8 NOT NULL,
  "join_id" int8 NOT NULL,
  "left_column_id" int8,
  "right_column_id" int8,
  "operator_type" varchar(32),
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_relationship_on"."on_id" IS '连接条件id';
COMMENT ON COLUMN "sys_hpe_relationship_on"."join_id" IS 'JOIN关系id';
COMMENT ON COLUMN "sys_hpe_relationship_on"."left_column_id" IS '左表列id';
COMMENT ON COLUMN "sys_hpe_relationship_on"."right_column_id" IS '右表列id';
COMMENT ON COLUMN "sys_hpe_relationship_on"."operator_type" IS '连接运算符';
COMMENT ON COLUMN "sys_hpe_relationship_on"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_relationship_on"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_relationship_on"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_relationship_on"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_relationship_on"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_relationship_on"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_relationship_on"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_relationship_on" IS '元数据主从关联关系ON表';

-- ----------------------------
-- Records of SYS_HPE_RELATIONSHIP_ON
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RMI_CONNECTOR
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_rmi_connector";
CREATE TABLE "sys_hpe_rmi_connector" (
  "connector_id" int8 NOT NULL,
  "connector_name" varchar(64),
  "connector_code" varchar(64),
  "connector_type" varchar(16),
  "is_auth" char(1),
  "auth_code" varchar(64),
  "host_url" varchar(128),
  "protocol" varchar(16),
  "remark" varchar(255),
  "connector_status" char(1),
  "app_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_rmi_connector"."connector_id" IS '连接器id';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."connector_name" IS '连接器名称';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."connector_code" IS '连接器标识';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."connector_type" IS '连接器类型';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."is_auth" IS '是否认证';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."auth_code" IS '认证模板';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."host_url" IS '主机地址/域名';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."protocol" IS '协议';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."remark" IS '连接器描述';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."connector_status" IS '连接器状态(0未启用,1启用,2禁用)';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_rmi_connector"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_rmi_connector" IS 'API连接器信息表';

-- ----------------------------
-- Records of SYS_HPE_RMI_CONNECTOR
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_RMI_INTERFACE
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_rmi_interface";
CREATE TABLE "sys_hpe_rmi_interface" (
  "rmi_id" int8 NOT NULL,
  "connector_code" varchar(64),
  "rmi_name" varchar(128),
  "rmi_code" varchar(128),
  "rmi_uri" varchar(128),
  "rmi_classify" varchar(16),
  "rmi_class" varchar(512),
  "rmi_method" varchar(255),
  "rmi_status" char(1),
  "request_type" varchar(16),
  "content_type" varchar(16),
  "is_auth" char(1),
  "remark" varchar(2048),
  "app_id" int8,
  "in_params" text,
  "out_params" text,
  "http_config" text,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1),
  "tenant_id" int8,
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_id" IS '接口id';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."connector_code" IS '连接器标识';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_name" IS '接口名称';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_code" IS '接口标识';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_uri" IS '接口URI';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_classify" IS '接口分类';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_class" IS '接口固化逻辑';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_method" IS '接口固化方法名';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."rmi_status" IS '接口状态(0未启用,1启用,2禁用)';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."request_type" IS '请求类型';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."content_type" IS '内容类型';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."is_auth" IS '是否认证';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."remark" IS '接口描述';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."app_id" IS '应用id';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."in_params" IS '接口入参';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."out_params" IS '接口出参';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."http_config" IS 'http配置';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_hpe_rmi_interface"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_rmi_interface" IS 'API连接器接口信息表';

-- ----------------------------
-- Records of SYS_HPE_RMI_INTERFACE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_HPE_UPGRADE_RECORD
-- ----------------------------
DROP TABLE IF EXISTS "sys_hpe_upgrade_record";
CREATE TABLE "sys_hpe_upgrade_record" (
  "upgrade_id" int8 NOT NULL,
  "version" varchar(50),
  "success" int2,
  "exception" text,
  "tenant_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "hpe_version" int2
)
;
COMMENT ON COLUMN "sys_hpe_upgrade_record"."upgrade_id" IS '主键ID';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."version" IS '版本号';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."success" IS '是否成功：0失败；1成功';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."exception" IS '异常信息';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."creator" IS '创建人';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_hpe_upgrade_record"."hpe_version" IS '版本标识';
COMMENT ON TABLE "sys_hpe_upgrade_record" IS '升级记录表';

-- ----------------------------
-- Records of SYS_HPE_UPGRADE_RECORD
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_IDTABLE
-- ----------------------------
DROP TABLE IF EXISTS "sys_idtable";
CREATE TABLE "sys_idtable" (
  "id_id" int8 NOT NULL,
  "id_value" int4,
  "table_name" varchar(64),
  "field_name" varchar(64),
  "id_desc" varchar(64),
  "cache_size" int4,
  "id_prefix" varchar(10),
  "is_prefix" char(1),
  "id_length" int4,
  "is_suffix" char(1),
  "id_suffix" varchar(16),
  "is_global" char(1),
  "is_level" varchar(1),
  "is_sys" varchar(1),
  "last_date" varchar(8),
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone
)
;
COMMENT ON COLUMN "sys_idtable"."id_id" IS '主键ID';
COMMENT ON COLUMN "sys_idtable"."id_value" IS '当前编号';
COMMENT ON COLUMN "sys_idtable"."table_name" IS '业务表名';
COMMENT ON COLUMN "sys_idtable"."field_name" IS '业务名称';
COMMENT ON COLUMN "sys_idtable"."id_desc" IS '业务中文描述';
COMMENT ON COLUMN "sys_idtable"."cache_size" IS '缓存大小';
COMMENT ON COLUMN "sys_idtable"."id_prefix" IS '前缀';
COMMENT ON COLUMN "sys_idtable"."is_prefix" IS '是否使用前缀';
COMMENT ON COLUMN "sys_idtable"."id_length" IS '编号长度';
COMMENT ON COLUMN "sys_idtable"."is_suffix" IS '是否使用后缀';
COMMENT ON COLUMN "sys_idtable"."id_suffix" IS '后缀';
COMMENT ON COLUMN "sys_idtable"."is_global" IS '是否全局流水';
COMMENT ON COLUMN "sys_idtable"."is_level" IS '是否层级码';
COMMENT ON COLUMN "sys_idtable"."is_sys" IS '是否系统编码';
COMMENT ON COLUMN "sys_idtable"."last_date" IS '为特殊规则前缀时\\"YYYY\\"码表最后日期';
COMMENT ON COLUMN "sys_idtable"."creator" IS '创建者';
COMMENT ON COLUMN "sys_idtable"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_idtable"."last_editor" IS '上次编辑者';
COMMENT ON COLUMN "sys_idtable"."last_time" IS '上次编辑时间';
COMMENT ON TABLE "sys_idtable" IS '最大号表';

-- ----------------------------
-- Records of SYS_IDTABLE
-- ----------------------------
BEGIN;
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (622468560387842048, 0, 'SYS_ORGAN', 'ORGAN_CODE_4', '组织机构编码生成规则', 1, NULL, '0', 11, '0', NULL, '0', '0', '1', NULL, NULL, '2020-08-10 20:42:42', NULL, NULL);
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (624170019827490816, 0, 'SYS_STAFF', 'STAFF_CODE', '人员编码生成规则', 1, NULL, '0', 11, '0', NULL, '0', '0', '1', NULL, NULL, '2020-08-10 19:42:42', NULL, NULL);
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (686205562077323264, 0, 'SYS_APPLICATION', 'APP_CODE', '应用编码', 1, '', '0', 10, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (713774538961461248, 0, 'SYS_RESOURCE_TYPE', 'RESOURCE_TYPE_CODE', '资源类型编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (713774739046539264, 0, 'SYS_RESOURCE_TYPE_EXPAND', 'RESOURCE_TYPE_EXPAND_CODE', '资源类型拓展属性编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, '2023-03-09 13:35:55', 1450756958461300737, '2023-03-10 15:59:40');
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (1450754032317640706, 214, 'SYS_RESOURCE_MODULES', 'MODULE_CODE', '模块编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 18:42:42', NULL, NULL);
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (1450754032317640708, 500, 'SYS_RESOURCES', 'RESOURCE_CODE', '资源编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 16:42:42', NULL, NULL);
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (1450754032317640713, 200, 'SYS_FUNCTIONS', 'FUNCTION_CODE', '功能编码', 1, ' ', '0', 4, '0', ' ', '0', '1', '1', NULL, NULL, '2020-08-10 13:42:42', NULL, NULL);
INSERT INTO "sys_idtable" ("id_id", "id_value", "table_name", "field_name", "id_desc", "cache_size", "id_prefix", "is_prefix", "id_length", "is_suffix", "id_suffix", "is_global", "is_level", "is_sys", "last_date", "creator", "create_time", "last_editor", "last_time") VALUES (1450754032317640717, 18, 'SYS_FUNCTION_MODULES', 'FUNCTION_MODULE_CODE', '功能模块编码', 1, NULL, '0', 4, '0', NULL, '0', '1', '1', NULL, NULL, '2020-08-10 11:40:42', NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for SYS_IDTABLE_INFO
-- ----------------------------
DROP TABLE IF EXISTS "sys_idtable_info";
CREATE TABLE "sys_idtable_info" (
  "info_id" int8 NOT NULL,
  "idtable_id" int8,
  "id_value" varchar(32),
  "parent_number" varchar(32)
)
;
COMMENT ON COLUMN "sys_idtable_info"."info_id" IS '主键';
COMMENT ON COLUMN "sys_idtable_info"."idtable_id" IS '字典表主键';
COMMENT ON COLUMN "sys_idtable_info"."id_value" IS '当前值';
COMMENT ON COLUMN "sys_idtable_info"."parent_number" IS '父级id';
COMMENT ON TABLE "sys_idtable_info" IS '最大号表信息表';

-- ----------------------------
-- Records of SYS_IDTABLE_INFO
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_ID_CONVERTS
-- ----------------------------
DROP TABLE IF EXISTS "sys_id_converts";
CREATE TABLE "sys_id_converts" (
  "num_id" int8 NOT NULL,
  "str_id" varchar(36) NOT NULL,
  "iam_user" int8 NOT NULL
)
;
COMMENT ON COLUMN "sys_id_converts"."num_id" IS '数字型id';
COMMENT ON COLUMN "sys_id_converts"."str_id" IS '字符串型id';
COMMENT ON COLUMN "sys_id_converts"."iam_user" IS 'IAM用户id';
COMMENT ON TABLE "sys_id_converts" IS 'uuid对应的long类型的id';

-- ----------------------------
-- Records of SYS_ID_CONVERTS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_INTERFACE_USER
-- ----------------------------
DROP TABLE IF EXISTS "sys_interface_user";
CREATE TABLE "sys_interface_user" (
  "user_id" int8 NOT NULL,
  "user_name" varchar(32),
  "is_lock" varchar(1),
  "sys_name" varchar(64),
  "sys_url" varchar(256),
  "token_status" varchar(1),
  "token_start_time" timestamp without time zone,
  "token_end_time" timestamp without time zone,
  "connect_num" int4,
  "last_time" timestamp without time zone,
  "token_value" varchar(512)
)
;
COMMENT ON COLUMN "sys_interface_user"."user_id" IS '接口用户ID';
COMMENT ON COLUMN "sys_interface_user"."user_name" IS '接口用户名称';
COMMENT ON COLUMN "sys_interface_user"."is_lock" IS '是否锁定';
COMMENT ON COLUMN "sys_interface_user"."sys_name" IS '用户名称';
COMMENT ON COLUMN "sys_interface_user"."sys_url" IS '应用系统地址';
COMMENT ON COLUMN "sys_interface_user"."token_status" IS 'token状态';
COMMENT ON COLUMN "sys_interface_user"."token_start_time" IS 'token获取时间';
COMMENT ON COLUMN "sys_interface_user"."token_end_time" IS 'token失效时间';
COMMENT ON COLUMN "sys_interface_user"."connect_num" IS 'token连接次数';
COMMENT ON COLUMN "sys_interface_user"."last_time" IS '应用系统地址';
COMMENT ON COLUMN "sys_interface_user"."token_value" IS 'token值';
COMMENT ON TABLE "sys_interface_user" IS '接口表';

-- ----------------------------
-- Records of SYS_INTERFACE_USER
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_LOGIN_USER_IDENTITY
-- ----------------------------
DROP TABLE IF EXISTS "sys_login_user_identity";
CREATE TABLE "sys_login_user_identity" (
  "identity_id" int8 NOT NULL,
  "user_id" int8,
  "staff_id" int8,
  "stru_id" int8,
  "post_id" int8,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" varchar(1)
)
;
COMMENT ON COLUMN "sys_login_user_identity"."identity_id" IS '主键';
COMMENT ON COLUMN "sys_login_user_identity"."user_id" IS '用户ID';
COMMENT ON COLUMN "sys_login_user_identity"."staff_id" IS '人员ID';
COMMENT ON COLUMN "sys_login_user_identity"."stru_id" IS '组织ID';
COMMENT ON COLUMN "sys_login_user_identity"."post_id" IS '岗位ID';
COMMENT ON COLUMN "sys_login_user_identity"."creator" IS '创建人';
COMMENT ON COLUMN "sys_login_user_identity"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_login_user_identity"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_login_user_identity"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_login_user_identity"."del_flag" IS '是否已删除(0 正常 1 已删除)';
COMMENT ON TABLE "sys_login_user_identity" IS '登录用户身份信息表';

-- ----------------------------
-- Records of SYS_LOGIN_USER_IDENTITY
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_LOG_WARN_RULE
-- ----------------------------
DROP TABLE IF EXISTS "sys_log_warn_rule";
CREATE TABLE "sys_log_warn_rule" (
  "rule_id" int8 NOT NULL,
  "rule_name" varchar(128) NOT NULL,
  "server_name" varchar(128) NOT NULL,
  "server_env" varchar(64),
  "class_name" varchar(512),
  "error_num" int4 NOT NULL,
  "time_interval" int4 NOT NULL,
  "warn_client" varchar(32) NOT NULL,
  "webhook_url" varchar(1024),
  "receiver" text,
  "rule_status" char(1),
  "remark" varchar(512),
  "tenant_id" int8,
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_log_warn_rule"."rule_id" IS '规则id';
COMMENT ON COLUMN "sys_log_warn_rule"."rule_name" IS '规则名称';
COMMENT ON COLUMN "sys_log_warn_rule"."server_name" IS '服务名称';
COMMENT ON COLUMN "sys_log_warn_rule"."server_env" IS '服务环境';
COMMENT ON COLUMN "sys_log_warn_rule"."class_name" IS '模块名称(类路径)';
COMMENT ON COLUMN "sys_log_warn_rule"."error_num" IS '错误数量';
COMMENT ON COLUMN "sys_log_warn_rule"."time_interval" IS '时间间隔';
COMMENT ON COLUMN "sys_log_warn_rule"."warn_client" IS '告警平台';
COMMENT ON COLUMN "sys_log_warn_rule"."webhook_url" IS '钩子地址';
COMMENT ON COLUMN "sys_log_warn_rule"."receiver" IS '接收人';
COMMENT ON COLUMN "sys_log_warn_rule"."rule_status" IS '规则状态(0开启，1关闭)';
COMMENT ON COLUMN "sys_log_warn_rule"."remark" IS '备注';
COMMENT ON COLUMN "sys_log_warn_rule"."tenant_id" IS '租户id';
COMMENT ON COLUMN "sys_log_warn_rule"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_log_warn_rule"."creator" IS '创建人';
COMMENT ON COLUMN "sys_log_warn_rule"."last_time" IS '修改时间';
COMMENT ON COLUMN "sys_log_warn_rule"."last_editor" IS '修改人';
COMMENT ON COLUMN "sys_log_warn_rule"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_log_warn_rule" IS '日志告警规则表';

-- ----------------------------
-- Records of SYS_LOG_WARN_RULE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_MENU
-- ----------------------------
DROP TABLE IF EXISTS "sys_menu";
CREATE TABLE "sys_menu" (
  "menu_id" int8 NOT NULL,
  "menu_text" varchar(64),
  "menu_alias" varchar(64),
  "function_module_id" int8,
  "function_id" int8,
  "parent_id" int8,
  "seq" int4,
  "is_leaf" char(1),
  "target" varchar(32),
  "icons" varchar(255),
  "open_type" varchar(16),
  "path" varchar(1024),
  "component" varchar(1024),
  "menu_type" char(1),
  "creator" int8,
  "create_time" date,
  "last_editor" int8,
  "last_time" date,
  "open_mode" varchar(2),
  "is_sys" char(1)
)
;
COMMENT ON COLUMN "sys_menu"."menu_id" IS '菜单id';
COMMENT ON COLUMN "sys_menu"."menu_text" IS '菜单编码';
COMMENT ON COLUMN "sys_menu"."menu_alias" IS '菜单别名';
COMMENT ON COLUMN "sys_menu"."function_module_id" IS '功能模块ID';
COMMENT ON COLUMN "sys_menu"."function_id" IS '功能ID';
COMMENT ON COLUMN "sys_menu"."parent_id" IS '父菜单';
COMMENT ON COLUMN "sys_menu"."seq" IS '显示顺序';
COMMENT ON COLUMN "sys_menu"."is_leaf" IS '是否是叶子节点';
COMMENT ON COLUMN "sys_menu"."target" IS '菜单目标';
COMMENT ON COLUMN "sys_menu"."icons" IS '菜单图标';
COMMENT ON COLUMN "sys_menu"."open_type" IS '打开方式';
COMMENT ON COLUMN "sys_menu"."path" IS '组件根路径';
COMMENT ON COLUMN "sys_menu"."component" IS '组件引入路径';
COMMENT ON COLUMN "sys_menu"."menu_type" IS '区分菜单';
COMMENT ON COLUMN "sys_menu"."creator" IS '创建人';
COMMENT ON COLUMN "sys_menu"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_menu"."last_editor" IS '最后修改人';
COMMENT ON COLUMN "sys_menu"."last_time" IS '最后修改时间';
COMMENT ON COLUMN "sys_menu"."open_mode" IS '打开方式 0系统内 1系统外';
COMMENT ON COLUMN "sys_menu"."is_sys" IS '是否是系统菜单';
COMMENT ON TABLE "sys_menu" IS '系统菜单';

-- ----------------------------
-- Records of SYS_MENU
-- ----------------------------
BEGIN;
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (510398063710576640, '开发者中心', '开发者中心', -1, -1, 1, 5, '0', '', 'bpm-platform-management', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (510503960046739456, '运维工具', '运维工具', -1, -1, 1450764807862096012, 10, '0', '', 'icon-left-operation-and-maintenance', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (510505261149200384, '平台监控', '平台监控', -1, -1, 1450764807862096012, 11, '0', '', 'icon-left-monitor', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (510506323742564352, '平台日志', '平台日志', -1, -1, 1450764807862096012, 12, '0', '', 'icon-left-log', 'inside', '', '', '0', 1450756958461300737, '2021-11-09', -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (518461064346869760, '客户端管理', '客户端管理', NULL, 518460834717114368, 510503960046739456, 8, '1', NULL, 'left-secondary-menu', 'inside', '/authClientModel', '', '0', 1450756958461300737, '2021-12-01', 1450756958461300737, '2021-12-01', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (520237348433436672, '插件管理', '插件管理', NULL, 520236482527764480, 510398063710576640, 6, '1', NULL, 'left-level-menu', 'inside', '/plugin/pluginList', '', '0', 1450756958461300737, '2021-12-06', 1450756958461300737, '2021-12-06', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (521279919444205568, '组织机构', '组织机构', NULL, NULL, 1450764807862095980, 1, '0', NULL, 'icon-left-organ', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (521280546094194688, '用户管理', '用户管理', NULL, NULL, 1450764807862095980, 2, '0', NULL, 'icon-left-user-manage', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (521288179740057600, '功能资源', '功能资源', NULL, NULL, 1450764807862095980, 4, '0', NULL, 'module', 'inside', '', '', '0', 1450756958461300737, '2021-12-09', 1450756958461300737, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (523160324178976768, '统一待办', '统一待办', NULL, NULL, 1, 12, '0', NULL, 'caidan_tongyidaiban', 'inside', '', '', '1', 1450756958461300737, '2021-12-14', 1450756958461300737, '2021-12-14', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (523160531927048192, '我的待办', '我的待办', NULL, 522705551881412608, 523160324178976768, 1, '1', NULL, 'caidan_wodedaiban', 'inside', '/unifiedtodoToDoTask', '', '1', 1450756958461300737, '2021-12-14', 1450756958461300737, '2021-12-14', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (523564187033804800, '我的已办', '我的已办', NULL, 523555260388876288, 523160324178976768, 2, '1', NULL, 'caidan_wodeyiban', 'inside', '/unifiedtodoDoneTask', '', '1', 1450756958461300737, '2021-12-15', 1450756958461300737, '2021-12-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (523564256034299904, '我的传阅', '我的传阅', NULL, 523555376986333184, 523160324178976768, 3, '1', NULL, 'caidan_wodechaosong', 'inside', '/unifiedtodoCcTask', '', '1', 1450756958461300737, '2021-12-15', 1450756958461300737, '2021-12-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (525236738705334272, '统一待办', '统一待办', NULL, NULL, 510398063710576640, 5, '0', NULL, 'unifiedtodo', 'inside', '', '', '0', 1450756958461300737, '2021-12-20', 1450756958461300737, '2021-12-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (525237452181610496, '应用注册', '应用注册', NULL, 521404105277841408, 525236738705334272, 1, '1', NULL, 'left-secondary-menu', 'inside', '/unifiedtodoSystem', '', '0', 1450756958461300737, '2021-12-20', 1450756958461300737, '2021-12-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (526077936101761024, '我的公告', '我的公告', -1, 526077556152344576, 1450764807862095952, 6, '1', '', 'caidan_wodegonggao', 'inside', '/noticeList', '', '1', 1450756958461300737, '2021-12-22', -1, '2021-12-22', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (535768937116475392, '审计查阅', '审计查阅', NULL, 535768729024471040, 510506323742564352, 4, '1', NULL, 'left-secondary-menu', 'inside', '/auditAccess', '', '0', 1450756958461300737, '2022-01-18', 1450756958461300737, '2022-01-18', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (544469385839124480, '主题配置', '主题配置', NULL, 544469147921424384, 510398063710576640, 7, '1', NULL, 'icon-left-theme', 'inside', '/themeConfig', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-02-11', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (544475935899131904, '任务管理', '任务管理', NULL, 544475707963875328, 551360495878414336, 2, '1', NULL, 'left-secondary-menu', 'inside', '/scheduleManagement', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-03-02', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (544476053125734400, '任务实例', '任务实例', NULL, 544475799542308864, 551360495878414336, 3, '1', NULL, 'left-secondary-menu', 'inside', '/scheduleInstance', '', '0', 1450756958461300737, '2022-02-11', 1450756958461300737, '2022-03-02', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (545575465642106880, '统一日志', '统一日志', NULL, 545565036773646336, 592306184481153024, 1, '1', NULL, 'left-secondary-menu', 'inside', '/unifiedLog', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (546343278384259072, '链路追踪', '链路追踪', NULL, 546343149988225024, 592306184481153024, 2, '1', NULL, 'left-secondary-menu', 'inside', '/linkTracking', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (546348182481936384, '错误统计', '错误统计', NULL, 546347915988443136, 592306184481153024, 3, '1', NULL, 'left-secondary-menu', 'inside', '/errorStatistics', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (551360495878414336, '任务调度', '任务调度', -1, -1, 510503960046739456, 10, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-03-02', -1, '2022-03-02', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576395294317748224, '消息中心', '消息中心', NULL, NULL, 1, 13, '0', NULL, 'xiaoxipingtai_xiaoxitongzhi_xiaoxifuwu-01', 'inside', '', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576446459680137216, '短信推送', '短信推送', NULL, NULL, 576395294317748224, 2, '0', NULL, 'xiaoxi-duanxinfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576448392889376768, '委托待办', '委托待办', NULL, 576448277533433856, 579974742292045824, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustTodoList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576448474900602880, '委托已办', '委托已办', NULL, 576438008606367744, 579974742292045824, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustDoneList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576450856640323584, '通道管理', '通道管理', NULL, 576447430137225216, 576446459680137216, 1, '1', '', 'left-secondary-menu', 'inside', '/smsService/Channel', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-13', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576450925435297792, '签名管理', '签名管理', NULL, 576447488295444480, 576446459680137216, 2, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/signature', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576450990023385088, '模板管理', '模板管理', NULL, 576447546457858048, 576446459680137216, 3, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/template', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576451066137419776, '发送测试', '发送测试', NULL, 576447608743272448, 576446459680137216, 4, '1', '', 'left-secondary-menu', 'inside', '/smsService/SendSMS', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576451140942831616, '发送记录', '发送记录', NULL, 576447666205237248, 576446459680137216, 5, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/sendRecord', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (576451207187668992, '发送统计', '发送统计', NULL, 576447721767182336, 576446459680137216, 6, '1', '', 'left-secondary-menu', 'inside', '/smsService/sendRateReport', '', '0', 1450756958461300737, '2022-05-10', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (577911561352650752, '邮件推送', '邮件推送', NULL, NULL, 576395294317748224, 3, '0', NULL, 'xiaoxi-youjianfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-05-14', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (577911671788675072, '通道管理', '通道管理', NULL, 577911233693622272, 577911561352650752, 1, '1', '', 'left-secondary-menu', 'inside', '/mailService/mChannel', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (577920288222879744, '发送记录', '发送记录', NULL, 577920176742473728, 577911561352650752, 6, '1', '', 'left-secondary-menu', 'inside', '/mailService/mailSendRecord', '', '0', 1450756958461300737, '2022-05-14', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578180907635318784, '模板管理', '模板管理', NULL, 578179104113958912, 577911561352650752, 2, '1', NULL, 'left-secondary-menu', 'inside', '/mailService/mTemplate', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578183012341260288, '单发测试', '单发测试', NULL, 578179213245554688, 577911561352650752, 4, '1', '', 'left-secondary-menu', 'inside', '/mailService/mSendTest', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578185499647418368, '群发测试', '群发测试', NULL, 578179275791015936, 577911561352650752, 5, '1', '', 'left-secondary-menu', 'inside', '/mailService/groupHair', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578185579053981696, '收件人管理', '收件人管理', NULL, 578179328681189376, 577911561352650752, 3, '1', '', 'left-secondary-menu', 'inside', '/mailService/recipient', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-23', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578185686646267904, '发送统计', '发送统计', NULL, 578180115675226112, 577911561352650752, 7, '1', '', 'left-secondary-menu', 'inside', '/mailService/readedStatistics', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578225925171453952, '微信公众号推送', '微信公众号推送', NULL, NULL, 576395294317748224, 4, '0', NULL, 'xiaoxi-weixingongzhonghaofuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578226039885668352, '通道管理', '通道管理', NULL, 578225632039936000, 578225925171453952, 1, '1', '', 'left-secondary-menu', 'inside', '/mpService/111publicAccount', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578226124077932544, '模板管理', '模板管理', NULL, 578225680442204160, 578225925171453952, 2, '1', '', 'left-secondary-menu', 'inside', '/mpService/mpTemplate', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-05-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578226212909096960, '发送测试', '发送测试', NULL, 578225755054678016, 578225925171453952, 3, '1', '', 'left-secondary-menu', 'inside', '/mpService/messageTesting', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (578226283117551616, '发送记录', '发送记录', NULL, 578225803503083520, 578225925171453952, 4, '1', '', 'left-secondary-menu', 'inside', '/mpService/pushRecord', '', '0', 1450756958461300737, '2022-05-15', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579402999395524608, 'IM推送', 'IM推送', NULL, NULL, 576395294317748224, 5, '0', NULL, 'xiaoxi-Applmfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579403112276828160, '通道管理', '通道管理', NULL, 579402490307682304, 579402999395524608, 1, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImChannel', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579403203670712320, '发送测试', '发送测试', NULL, 579402568669863936, 579402999395524608, 3, '1', NULL, 'left-secondary-menu', 'inside', '/appImService/appImSendTest', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579403287988805632, '发送统计', '发送统计', NULL, 579402651498979328, 579402999395524608, 5, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImDataStatistics', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579408006685663232, 'APP通知推送', 'APP通知推送', NULL, NULL, 576395294317748224, 6, '0', NULL, 'xiaoxi-APPtuisongfuwu', 'inside', '', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579408141658365952, '通道管理', '通道管理', NULL, 579407434091864064, 579408006685663232, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appPushService/appPushChannel', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-05-18', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579408250869653504, '发送测试', '发送测试', NULL, 579407499330068480, 579408006685663232, 3, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushTest', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579408319811428352, '发送记录', '发送记录', NULL, 579407703957577728, 579408006685663232, 4, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushReecorded', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579408390443507712, '发送统计', '发送统计', NULL, 579407758378672128, 579408006685663232, 5, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushStatistics', '', '0', 1450756958461300737, '2022-05-18', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579974742292045824, '流程委托', '流程委托', NULL, NULL, 1450764807862095952, 6, '0', NULL, 'caidan_liuchengweituo', 'inside', '/entrustDoneList', '', '1', NULL, '2022-05-10', NULL, '2022-05-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (579987145213878272, '发送记录', '发送记录', NULL, 579987015375003648, 579402999395524608, 4, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImSendRecord', '', '0', 1450756958461300737, '2022-05-20', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581430140240928768, '流程分析', '流程分析', NULL, NULL, 1450764807862095963, 11, '0', '', 'icon-left-monitor', 'inside', '', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437577991823360, '流程概览', '流程概览', NULL, 581430666475085824, 581430140240928768, 1, '1', '', 'left-secondary-menu', 'inside', '/bpa/view', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437646807769088, '流程状态分析', '流程状态分析', NULL, 581436854533103616, 581430140240928768, 2, '1', '', 'left-secondary-menu', 'inside', '/bpa/view/processStatus', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437695180677120, '流程参与者分析', '流程参与者分析', NULL, 581436941229367296, 581430140240928768, 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAssignee', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437747630448640, '流程统计分析', '流程统计分析', NULL, 581436993427480576, 581430140240928768, 4, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessStatistics', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437791045689344, '数量分析', '数量分析', NULL, NULL, 581430140240928768, 5, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437856728489984, '热门流程分析', '热门流程分析', NULL, 581437139125018624, 581437791045689344, 1, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaHotProcess', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437898885439488, '流程数量分析', '流程数量分析', NULL, 581437221161410560, 581437791045689344, 2, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAmount', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437940299997184, '用户流程分析', '用户流程分析', NULL, 581437297606795264, 581437791045689344, 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessUser', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581437985619451904, '待办任务分析', '待办任务分析', NULL, 581437337255550976, 581437791045689344, 4, '1', '', 'left-secondary-menu', 'inside', '/todoTaskAnalysis', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (581438095157895168, '流程耗时分析', '流程耗时分析', NULL, 581437382767943681, 581430140240928768, 6, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/processConsumeTime', '', '0', 1450756958461300737, '2022-05-24', 1450756958461300737, '2022-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (582661624251555840, '发送统计', '发送统计', NULL, 582661445364490240, 578225925171453952, 5, '1', '', 'left-secondary-menu', 'inside', '/mpService/sendStatistics', '', '0', 1450756958461300737, '2022-05-27', 1450756958461300737, '2022-06-20', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (586248796225413120, '流程驳回分析', '流程驳回分析', NULL, 581437337255550977, 581437791045689344, 5, '1', NULL, 'left-secondary-menu', 'inside', '/processRejectionAnalysis', '', '0', 1450756958461300737, '2022-06-06', 1450756958461300737, '2022-06-06', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (586944248251949056, '内部通知推送', '内部通知推送', NULL, NULL, 576395294317748224, 7, '0', NULL, 'xiaoxi-neibutongzhifuwu', 'inside', '', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (587710302741864448, '发送测试', '发送测试', NULL, 588042975440019456, 586944248251949056, 1, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticePushTest', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (587710386070102016, '发送记录', '发送记录', NULL, 587709734606610432, 586944248251949056, 3, '1', NULL, 'left-secondary-menu', 'inside', '/noticeService/noticeSendRecord', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (587710464084156416, '发送统计', '发送统计', NULL, 587709787979128832, 586944248251949056, 4, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticeStatistics', '', '0', 1450756958461300737, '2022-06-10', 1450756958461300737, '2022-06-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (592306184481153024, '统一日志', '统一日志', NULL, NULL, 510506323742564352, 6, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (592401069905289216, '日志告警', '日志告警', NULL, NULL, 510505261149200384, 6, '0', '', 'left-secondary-menu', 'inside', '', '', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (592401214583611392, '告警设置', '告警设置', NULL, 592386778267394048, 592401069905289216, 1, '1', '', 'left-secondary-menu', 'inside', '/logSet', '@/views/logWarn/logSet', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (592401334532317184, '告警记录', '告警记录', NULL, 592391757124345856, 592401069905289216, 2, '1', '', 'left-secondary-menu', 'inside', '/logRecord', '@/views/logWarn/logRecord', '0', 1450756958461300737, '2022-07-01', 1450756958461300737, '2022-07-01', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (595572492354199552, '移动门户配置', '移动门户配置', NULL, NULL, 1450764807862095954, 11, '0', NULL, 'left-mobile-office', 'inside', '', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-02', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (595572608519643136, '首页配置', '首页配置', NULL, 595572331049656320, 595572492354199552, 1, '1', '', 'left-secondary-menu', 'inside', '/portalConfiguration', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-11', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (595572683195031552, '三方集成', '三方集成', NULL, 595572392424906752, 595572492354199552, 2, '1', '', 'left-secondary-menu', 'inside', '/tripartiteIntegration', '', '0', 1450756958461300737, '2022-07-02', 1450756958461300737, '2022-07-11', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (596354392677163008, '应用管理', '应用管理', NULL, NULL, 576395294317748224, 8, '0', NULL, 'icon-left-application-manage', 'inside', '', '', '0', 1450756958461300737, '2022-07-04', 1450756958461300737, '2022-07-04', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (596354710630572032, '应用管理', '应用管理', NULL, 596354099289792512, 596354392677163008, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appService/appManage', '', '0', 1450756958461300737, '2022-07-04', 1450756958461300737, '2022-07-04', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (608975106760515584, '场景管理', '场景管理', NULL, 608974847288287232, 596354392677163008, 2, '1', '', 'left-secondary-menu', 'inside', '/appService/sceneManage', '', '0', 1450756958461300737, '2022-08-08', 1450756958461300737, '2022-08-08', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (641242930610446336, '数据迁移', '数据迁移', NULL, NULL, 1450764807862096012, 13, '0', NULL, 'shujuqianyi', 'inside', '', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (641244185470705664, '数据导入', '数据导入', NULL, 641243926136889344, 641242930610446336, 1, '1', '', 'left-secondary-menu', 'inside', '/migrationLoad', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (641244243347906560, '数据导出', '数据导出', NULL, 641244024103247872, 641242930610446336, 2, '1', '', 'left-secondary-menu', 'inside', '/migrationDump', '', '0', 1450756958461300737, '2022-11-05', 1450756958461300737, '2022-11-05', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (673554222872272896, '配置项管理', '配置项管理', NULL, 673553074966765568, 1450764807862095963, 12, '1', '', 'caidan-shezhi1', 'inside', '/bpmConfig', '', '0', 1450756958461300737, '2023-02-02', 1450756958461300737, '2023-02-02', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686144725505548288, '应用管理', '应用管理', NULL, NULL, 1, 14, '0', NULL, 'hussar_application', 'inside', '', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686147400720719872, '应用管理', '应用管理', NULL, 686147054220877824, 686144725505548288, 1, '1', NULL, 'caidan_appManagement', 'inside', '/appManage', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686147588675870720, '应用回收站', '应用回收站', NULL, 686147191273955328, 686144725505548288, 2, '1', NULL, 'caidan_recycleBin', 'inside', '/RecycleBin', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686178606145347584, '企业微信推送', '企业微信推送', NULL, NULL, 576395294317748224, 9, '0', '', 'a-qingqibing_xiaoxizhong-qiyeweixintuisong', 'inside', '', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686178943606464512, '通道管理', '通道管理', NULL, 686178119287316480, 686178606145347584, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomChannel', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686179008337158144, '发送测试', '发送测试', NULL, 686178183690854400, 686178606145347584, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendedTested', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686179079862624256, '发送记录', '发送记录', NULL, 686178259356098560, 686178606145347584, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendRecord', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (686179134522793984, '发送统计', '发送统计', NULL, 686178312292409344, 686178606145347584, 5, '1', '', 'caidan-3Jmoren', 'inside', '/wecomService/wecomDataStatistics', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (688350240998432768, '岗位管理', '岗位管理', NULL, 688350053471100928, 521279919444205568, 3, '1', '', 'caidan-3Jmoren', 'inside', '', '', '0', 1450756958461300737, '2023-03-15', 1450756958461300737, '2023-03-15', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (697755930116497408, '钉钉推送', '钉钉推送', NULL, NULL, 576395294317748224, 10, '0', NULL, 'qingqibing_xiaoxipingtai-dingdingtuisong', 'inside', '', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (697762708677992448, '通道管理', '通道管理', NULL, 697762187867070464, 697755930116497408, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/channel', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (697762824432394240, '发送测试', '发送测试', NULL, 697762370797445120, 697755930116497408, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendTest', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (697762900781309952, '发送记录', '发送记录', NULL, 697762455014875136, 697755930116497408, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendRecord', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (697762974726889472, '发送统计', '发送统计', NULL, 697762540020834304, 697755930116497408, 5, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalkService/sendCount', '', '0', 1450756958461300737, '2023-04-10', 1450756958461300737, '2023-04-10', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (706807802378854400, '表单维护', '表单维护', NULL, 706807627035975680, 1450764807862095963, 14, '1', NULL, 'caidan-2Jmoren', 'inside', '/formManager', '', '0', 1450756958461300737, '2023-05-05', 1450756958461300737, '2023-05-05', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (713719440226918400, '资源类型管理', '资源类型管理', NULL, 713719009941659648, 521288179740057600, 3, '1', '', 'caidan-3Jmoren', 'inside', '/resourceTypeManage', '', '0', 1450756958461300737, '2023-04-03', 1450756958461300737, '2023-04-03', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (714433614208835584, '岗位审核', '岗位审核', NULL, 714425029546483712, 521279919444205568, 9, '1', NULL, 'caidan-3Jmoren', 'inside', '/postAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (714488330313801728, '组织角色审核', '组织角色审核', NULL, 714488057633710080, 1450764807862095998, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/struRoleVerify', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (714488433812447232, '岗位角色审核', '岗位角色审核', NULL, 714488196960100352, 1450764807862095998, 5, '1', NULL, 'caidan-3Jmoren', 'inside', '/postRoleAudit', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (714502153053675520, '用户组织审核', '用户组织审核', NULL, 714498812294733824, 521280546094194688, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/userOrganizationAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (714503357229965312, '用户岗位审核', '用户岗位审核', NULL, 714503247842516992, 521280546094194688, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/userPositionAudit/index', '', '0', 1450756958461300737, '2023-05-26', 1450756958461300737, '2023-05-26', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (729285621608357888, '分组管理', '分组管理', NULL, 729285499054989312, 686144725505548288, 3, '1', NULL, 'caidan-2Jmoren', 'inside', '/appGroupManage', '', '0', 1450756958461300737, '2023-07-06', 1450756958461300737, '2023-07-06', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (734834444426551296, '工作台banner', '工作台banner', NULL, 734833871224578048, 1450764807862095954, 12, '1', NULL, 'caidan_work_banner', 'inside', '/bannerManage', '', '0', 1450756958461300737, '2023-07-21', 1450756958461300737, '2023-07-21', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (735799904773087232, '组件库维护', '组件库维护', NULL, 735799387355357184, 1450764807862095954, 13, '1', NULL, 'caidan_work_assembly', 'inside', '/componentsLibrary', '', '0', 1450756958461300737, '2023-07-24', 1450756958461300737, '2023-07-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811594821746827264, '联系人管理', '联系人管理', NULL, NULL, 576395294317748224, 11, '0', '', 'caidan-liucheng4', 'inside', '', '', '0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811596001818451968, '通讯录', '通讯录', NULL, 811595871216214016, 811594821746827264, 1, '1', '', 'caidan-3Jmoren', 'inside', '/contactService/ContactManage', '', '0', 1450756958461300737, '2024-02-18', 1450756958461300737, '2024-02-18', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811885400942714880, '工具栏横幅', '工具栏横幅', NULL, 811885124697464832, 820247769980870656, 3, '1', '', 'caidan-3Jmoren', 'inside', '/advertisementSet', '', '0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811885462225690624, '浏览量统计', '浏览量统计', NULL, 811885197636411392, 820247769980870656, 1, '1', '', 'caidan-3Jmoren', 'inside', '/advertisementStatistics', '', '0', 1450756958461300737, '2024-02-19', 1450756958461300737, '2024-03-15', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811885505712234496, '顶部横幅', '顶部横幅', NULL, 811885249842913280, 820247769980870656, 2, '1', '', 'caidan-3Jmoren', 'inside', '/bannerSet', '', '0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (811885550977163264, '工具栏收纳', '工具栏收纳', NULL, 811885297653784576, 820247769980870656, 4, '1', '', 'caidan-3Jmoren', 'inside', '/storageSet', '', '0', 1450756958461300737, '2024-02-19', 1994060001, '2024-03-15', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (813349058159845376, '标签管理', '标签管理', NULL, 813348971400667136, 811594821746827264, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/contactService/TagManage', '', '0', 1450756958461300737, '2024-02-23', 1450756958461300737, '2024-02-23', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815268878975508480, '组织机构', '组织机构', NULL, NULL, 1, 16, '0', '', 'caidan_liuchengweituo', 'inside', '', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815268966238003200, '组织管理', '组织管理', NULL, 815300362058866688, 815268878975508480, 1, '1', '', 'caidan-2Jmoren', 'inside', '/organMaintenance1', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815283974485319680, '用户管理', '用户管理', NULL, NULL, 1, 17, '0', NULL, 'caidan-renyuanguanli2', 'inside', '', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815284118417055744, '用户维护', '用户维护', NULL, 815299697123270656, 815283974485319680, 1, '1', '', 'caidan-2Jmoren', 'inside', '/szslUsermanage', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815284389633335296, '角色管理', '角色管理', NULL, NULL, 1, 18, '0', NULL, 'caidan-liucheng3', 'inside', '', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815284458273120256, '角色维护', '角色维护', NULL, 815299769068167168, 815284389633335296, 1, '1', '', 'caidan-2Jmoren', 'inside', '/szslManageRole', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (815284741749350400, '人员管理', '人员管理', NULL, 815299398463660032, 815268878975508480, 2, '1', '', 'caidan-2Jmoren', 'inside', '/staffManageAdmin', '', '1', 1450756958461300737, '2024-02-28', 1450756958461300737, '2024-02-28', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (819883465473531904, '模板管理', '模板管理', NULL, 819883083649261568, 579402999395524608, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/appImService/appImTemplate', '', '0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (819883548935987200, '模板管理', '模板管理', NULL, 819883155535437824, 579408006685663232, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/appPushService/appPushTemplate', '', '0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (819883588052066304, '模板管理', '模板管理', NULL, 819883211101577216, 586944248251949056, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/noticeService/noticeSendTemplate', '', '0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (819883633023393792, '模板管理', '模板管理', NULL, 819883304701665280, 686178606145347584, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomTemplate', '', '0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (819883670151372800, '模板管理', '模板管理', NULL, 819883353598861312, 697755930116497408, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalk/DingTalkTemplate', '', '0', 1450756958461300737, '2024-03-12', 1450756958461300737, '2024-03-12', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (820247769980870656, '广告位配置', '广告位配置', NULL, NULL, 1450764807862095954, 18, '0', '', 'caidan_guanggao', 'inside', '', '', '0', 1450756958461300737, '2024-03-13', 1450756958461300737, '2024-03-13', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (825444013086875648, '个人环境管理', '个人环境管理', NULL, 825443949341843456, 686144725505548288, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/personalEnvManagement', '', '0', 679338378499727360, '2024-03-27', 679338378499727360, '2024-03-27', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (846427851380236288, '环境管理', '环境管理', NULL, 846427189661671424, 510503960046739456, 11, '1', NULL, 'caidan-3Jmoren', 'inside', '/environment', '', '0', 844891795166076928, '2024-05-24', 844891795166076928, '2024-05-24', '0', '0');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095951, '组织管理', '组织管理', -1, 1450764807862095892, 521279919444205568, 1, '1', '', 'left-secondary-menu', 'inside', '/OrganMaintenance', '@/views/organ/OrganMaintenance', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095952, '个人事项', '个人事项', 1450764807862095873, NULL, 1, 10, '0', NULL, 'caidan_gerenshixiang', '', '/toDoManage', '@/views/layout/layout', '1', NULL, NULL, 1450756958461300737, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095953, '我的传阅', '我的传阅', NULL, 1450764807862095893, 1450764807862095952, 4, '1', NULL, 'caidan_wodechaosong', '', '/ccList', '@/views/taskmanage/ccList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095954, '门户配置', '门户配置', 1450764807862095874, -1, 1, 2, '0', '', 'bpm-portal-configuration-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095959, '审计日志', '审计日志', -1, 1450764807862095898, 510506323742564352, 1, '1', '', 'left-secondary-menu', 'inside', '/auditlog', '@/views/system/auditlog/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095961, '解冻密码', '解冻密码', NULL, 1450764807862095900, 510503960046739456, 3, '1', NULL, 'left-secondary-menu', 'tab', '/thawcode', '@/views/system/thawcode/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095962, '资源管理', '资源管理', -1, 1450764807862095901, 521288179740057600, 1, '1', '', 'left-secondary-menu', 'inside', '/resourceManage', '@/views/permit/resourceManage/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095963, '流程中心', '流程中心', 1450764807862095875, -1, 1, 3, '0', '', 'bpm-process-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095965, '类型定义', '类型定义', -1, 1450764807862095902, 521279919444205568, 4, '1', '', 'left-secondary-menu', 'inside', '/SysOrgType', '@/views/organ/SysOrgType', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095967, '我的催办', '我的催办', NULL, 1450764807862095904, 1450764807862095952, 3, '1', NULL, 'caidan_wodecuiban', '', '/urgeList', '@/views/taskmanage/urgeList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095968, '连接池监控', '连接池监控', -1, 1450764807862095905, 510505261149200384, 3, '1', '', 'left-secondary-menu', 'inside', '/poolMonitor', '@/views/service/poolMonitor/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095972, '用户维护', '用户维护', -1, 1450764807862095908, 521280546094194688, 1, '1', '', 'left-secondary-menu', 'inside', '/usermanage', '@/views/permit/usermanage/user', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095974, '角色维护', '角色维护', -1, 1450764807862095909, 1450764807862095998, 1, '1', '', 'left-secondary-menu', 'inside', '/role', '@/views/permit/rolemanage/role/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095975, '重置密码', '重置密码', NULL, 1450764807862095911, 510503960046739456, 2, '1', NULL, 'left-secondary-menu', NULL, '/resetpassword', '@/views/system/resetpassword/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095978, '字典管理', '字典管理', NULL, 1450764807862095913, 510503960046739456, 1, '1', '', 'left-secondary-menu', '', '/dictionary', '@/views/system/dictionary/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095980, '组织权限', '组织权限', 523176320419766272, -1, 1, 1, '0', '', 'bpm-organization-authority-center', 'inside', '', '', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095982, '组织审核', '组织审核', -1, 1450764807862095915, 521279919444205568, 6, '1', '', 'left-secondary-menu', 'tab', '/organAudit', '@/views/permit/auditManage/organAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095984, '设计器', '设计器', -1, 1450764807862095917, 1, 4, '1', '', 'bpm-visual-designer', 'outside', '/static/formdesign/index.html', '', '0', -1, NULL, -1, '2021-11-09', '1', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095986, '系统参数', '系统参数', 523213802016350208, -1, 510398063710576640, 4, '0', '', 'icon-left-system-params', 'inside', '/system', '@/views/layout/layout', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095987, '慢SQL诊断', '慢SQL诊断', -1, 1450764807862095920, 510505261149200384, 5, '1', '', 'left-secondary-menu', 'inside', '/slowsql', '@/views/service/slowsql/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095988, '菜单配置', '菜单配置', -1, 1450764807862095921, 1450764807862095954, 3, '1', '', 'left-menu-manage', 'inside', '/menumaintain', '@/views/menumaintain/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095990, '规则定义', '规则定义', -1, 1450764807862095922, 521279919444205568, 5, '1', '', 'left-secondary-menu', 'inside', '/SysOrgRule', '@/views/organ/SysOrgRule', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095991, '用户审核', '用户审核', -1, 1450764807862095923, 521280546094194688, 2, '1', '', 'left-secondary-menu', 'tab', '/userAudit', '@/views/permit/auditManage/userAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095993, '任务管理', '任务管理', -1, 1450764807862095924, 1450764807862095963, 9, '1', '', 'icon-left-task-manage', 'inside', '/bpmTask', '@/bpm/views/taskManagement/task', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095995, '系统监控', '系统监控', -1, 1450764807862095925, 510505261149200384, 4, '1', '', 'left-secondary-menu', 'inside', '/systemMonitor', '@/views/service/systemMonitor/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095997, '在线用户', '在线用户', -1, 1450764807862095927, 510505261149200384, 1, '1', '', 'left-secondary-menu', 'inside', '/onlineUser', '@/views/system/onlineuser/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095998, '角色管理', '角色管理', 1450764807862095884, -1, 1450764807862095980, 3, '0', '', 'left-role-manage', 'inside', '/roleManage', '@/views/permit/rolemanage/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862095999, '快捷功能配置', '快捷功能配置', -1, 1450764807862095928, 1450764807862095954, 4, '1', '', 'left-shortcut-config', 'inside', '/shortCutConf', '@/views/personalizedConf/shortCutConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096000, '日志下载', '日志下载', -1, 1450764807862095929, 510506323742564352, 2, '1', '', 'left-secondary-menu', 'inside', '/logdownload', '@/views/service/logdownload/index', '0', -1, NULL, 1450756958461300737, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096001, '人员审核', '人员审核', -1, 1450764807862095930, 521279919444205568, 7, '1', '', 'left-secondary-menu', 'tab', '/staffAudit', '@/views/permit/auditManage/staffAudit/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096002, '人员管理', '人员管理', -1, 1450764807862095931, 521279919444205568, 2, '1', '', 'left-secondary-menu', 'inside', '/StaffManage', '@/views/organ/StaffManage', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096004, '函数管理', '函数管理', -1, 1450764807862095933, 1450764807862095963, 10, '1', '', 'icon-left-function-manage', 'inside', '/bpmFunction', '@/bpm/views/function/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096005, '自定义编码规则', '自定义编码规则', -1, 1450764807862095934, 1450764807862095986, 5, '1', '', 'left-secondary-menu', 'inside', '/maximumTable', '@/views/system/maximumTable/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096007, '已办任务', '已办任务', NULL, 1450764807862095935, 1450764807862095952, 2, '1', NULL, 'caidan_yibanrenwu', '', '/doneList', '@/views/taskmanage/doneList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096008, '工作日维护', '工作日维护', -1, 1450764807862095936, 510503960046739456, 6, '1', '', 'left-secondary-menu', 'inside', '/workcalendar', '@/views/system/workcalendar/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096010, '流程管理', '流程管理', -1, 1450764807862095937, 1450764807862095963, 2, '1', '', 'icon-left-process-manage', 'inside', '/bpmModelEdit', '@/bpm/views/modeling/modelEdit', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096011, '框架页配置', '框架页配置', -1, 1450764807862095938, 1450764807862095954, 8, '1', '', 'left-layout-config', 'inside', '/layoutConf', '@/views/personalizedConf/layoutConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096012, '运维监控', '运维监控', 1450764807862095887, -1, 1, 6, '0', '', 'bpm-operation-and-maintenance-monitoring-center', 'inside', '/service', '@/views/layout/layout', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096014, '用户角色审核', '用户角色审核', -1, 1450764807862095939, 1450764807862095998, 3, '1', '', 'left-secondary-menu', 'inside', '/userRoleVerify', '@/views/permit/rolemanage/userRoleVerify/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096015, '登录页配置', '登录页配置', -1, 1450764807862095940, 1450764807862095954, 7, '1', '', 'left-login-config', 'inside', '/loginConf', '@/views/personalizedConf/loginConf', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096016, '我的委托', '我的委托', NULL, 1450764807862095941, 579974742292045824, 1, '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustList', '@/views/taskmanage/entrustList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096019, '实例管理', '实例管理', -1, 1450764807862095943, 1450764807862095963, 8, '1', '', 'icon-left-instance-manage', 'inside', '/bpmProcess', '@/bpm/views/processinst/process', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096020, '在线历史记录', '在线历史记录', -1, 1450764807862095944, 510506323742564352, 3, '1', '', 'left-secondary-menu', 'inside', '/onlinehis', '@/views/system/onlinehistory/index', '0', -1, NULL, -1, '2021-11-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096021, '运行参数配置', '运行参数配置', NULL, 1450764807862095945, 1450764807862095986, 3, '1', '', 'left-secondary-menu', 'tab', '/baseConfig', '@/views/system/baseConfig/index', '0', NULL, NULL, 1450756958461300737, '2021-11-11', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096022, '功能管理', '功能管理', -1, 1450764807862095910, 521288179740057600, 2, '1', '', 'left-secondary-menu', 'inside', '/functionManage', '@/pages/console/views/permit/functionManage/index', '0', -1, '2021-06-21', -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096023, '不相容角色集', '不相容角色集', -1, 1450764807862095946, 1450764807862095998, 2, '1', '', 'left-secondary-menu', 'inside', '/alienRole', '@/views/permit/rolemanage/alienRole/index', '0', -1, NULL, -1, '2021-12-09', '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096024, '待办任务', '待办任务', NULL, 1450764807862095947, 1450764807862095952, 1, '1', NULL, 'caidan_daibanrenwu', '', '/toDoList', '@/views/taskmanage/todoList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "sys_menu" ("menu_id", "menu_text", "menu_alias", "function_module_id", "function_id", "parent_id", "seq", "is_leaf", "target", "icons", "open_type", "path", "component", "menu_type", "creator", "create_time", "last_editor", "last_time", "open_mode", "is_sys") VALUES (1450764807862096026, '授权信息', '授权信息', NULL, 1450764807862095949, 1450764807862095986, 9, '1', NULL, 'left-secondary-menu', NULL, '/license', '@/views/system/license/index', '0', NULL, NULL, 1450756958461300737, '2021-11-11', '0', '1');
COMMIT;

-- ----------------------------
-- Table structure for SYS_MESSAGE
-- ----------------------------
DROP TABLE IF EXISTS "sys_message";
CREATE TABLE "sys_message" (
  "message_id" int8 NOT NULL,
  "message_type_id" int8,
  "message_title" varchar(2048),
  "approver_id" int8,
  "release_date" timestamp without time zone,
  "create_time" timestamp without time zone,
  "message_content" text,
  "department_id" varchar(1024),
  "post_id" varchar(1024),
  "role_id" varchar(1024),
  "user_id" varchar(1024),
  "creatoe_department_id" int8,
  "message_issue" varchar(128),
  "creator" int8,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "dept_role_name" varchar(255),
  "business_address" varchar(512),
  "mobile_business_address" varchar(512),
  "open_way" char(1)
)
;
COMMENT ON COLUMN "sys_message"."message_id" IS '消息ID';
COMMENT ON COLUMN "sys_message"."message_type_id" IS '消息类型ID';
COMMENT ON COLUMN "sys_message"."message_title" IS '消息标题';
COMMENT ON COLUMN "sys_message"."approver_id" IS '审批人ID';
COMMENT ON COLUMN "sys_message"."release_date" IS '发布日期';
COMMENT ON COLUMN "sys_message"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_message"."message_content" IS '消息内容';
COMMENT ON COLUMN "sys_message"."department_id" IS '发布范围(部门ID)';
COMMENT ON COLUMN "sys_message"."post_id" IS '发布范围(岗位id)';
COMMENT ON COLUMN "sys_message"."role_id" IS '发布范围(角色ID)';
COMMENT ON COLUMN "sys_message"."user_id" IS '发布范围(用户id)';
COMMENT ON COLUMN "sys_message"."creatoe_department_id" IS '创建者部门ID';
COMMENT ON COLUMN "sys_message"."message_issue" IS '发布者(公司或部门名称)';
COMMENT ON COLUMN "sys_message"."creator" IS '消息创建者(ID)';
COMMENT ON COLUMN "sys_message"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_message"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_message"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_message"."dept_role_name" IS '发布范围名称';
COMMENT ON COLUMN "sys_message"."business_address" IS '业务地址';
COMMENT ON COLUMN "sys_message"."mobile_business_address" IS '移动端业务地址';
COMMENT ON COLUMN "sys_message"."open_way" IS '打开方式';
COMMENT ON TABLE "sys_message" IS '消息表';

-- ----------------------------
-- Records of SYS_MESSAGE
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_MESSAGE_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS "sys_message_attachment";
CREATE TABLE "sys_message_attachment" (
  "message_att_id" int8 NOT NULL,
  "message_id" int8 NOT NULL,
  "message_attachment_url" varchar(512) NOT NULL,
  "message_attachment_title" varchar(512) NOT NULL,
  "creator" int8,
  "create_time" timestamp without time zone,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1)
)
;
COMMENT ON COLUMN "sys_message_attachment"."message_att_id" IS '消息与附件关系id';
COMMENT ON COLUMN "sys_message_attachment"."message_id" IS '消息id';
COMMENT ON COLUMN "sys_message_attachment"."message_attachment_url" IS '附件地址';
COMMENT ON COLUMN "sys_message_attachment"."message_attachment_title" IS '附件名称';
COMMENT ON COLUMN "sys_message_attachment"."creator" IS '	创建人';
COMMENT ON COLUMN "sys_message_attachment"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_message_attachment"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_message_attachment"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_message_attachment"."del_flag" IS '删除标识';
COMMENT ON TABLE "sys_message_attachment" IS '消息附件关系';

-- ----------------------------
-- Records of SYS_MESSAGE_ATTACHMENT
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_MESSAGE_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS "sys_message_detail";
CREATE TABLE "sys_message_detail" (
  "message_detail_id" int8 NOT NULL,
  "message_id" int8 NOT NULL,
  "message_type_id" int8,
  "message_title" varchar(2048),
  "approver_id" int8,
  "release_date" timestamp without time zone,
  "create_time" timestamp without time zone,
  "message_content" text,
  "department_id" varchar(1024),
  "role_id" varchar(1024),
  "user_id" varchar(32),
  "creatoe_department_id" int8,
  "message_issue" varchar(128),
  "creator" int8,
  "last_editor" int8,
  "last_time" timestamp without time zone,
  "del_flag" char(1),
  "dept_role_name" varchar(255),
  "business_address" varchar(512),
  "read_flag" char(1),
  "open_way" char(1),
  "people_id" int8,
  "mobile_business_address" varchar(512)
)
;
COMMENT ON COLUMN "sys_message_detail"."message_detail_id" IS '消息详情id';
COMMENT ON COLUMN "sys_message_detail"."message_id" IS '消息ID';
COMMENT ON COLUMN "sys_message_detail"."message_type_id" IS '消息类型ID';
COMMENT ON COLUMN "sys_message_detail"."message_title" IS '消息标题';
COMMENT ON COLUMN "sys_message_detail"."approver_id" IS '审批人ID';
COMMENT ON COLUMN "sys_message_detail"."release_date" IS '发布日期';
COMMENT ON COLUMN "sys_message_detail"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_message_detail"."message_content" IS '消息内容';
COMMENT ON COLUMN "sys_message_detail"."department_id" IS '发布范围(部门ID)';
COMMENT ON COLUMN "sys_message_detail"."role_id" IS '发布范围(角色ID)';
COMMENT ON COLUMN "sys_message_detail"."user_id" IS '用户id';
COMMENT ON COLUMN "sys_message_detail"."creatoe_department_id" IS '创建者部门ID';
COMMENT ON COLUMN "sys_message_detail"."message_issue" IS '发布者(公司或部门名称)';
COMMENT ON COLUMN "sys_message_detail"."creator" IS '消息创建者(ID)';
COMMENT ON COLUMN "sys_message_detail"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_message_detail"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_message_detail"."del_flag" IS '删除标识';
COMMENT ON COLUMN "sys_message_detail"."dept_role_name" IS '发布范围名称';
COMMENT ON COLUMN "sys_message_detail"."business_address" IS '业务地址';
COMMENT ON COLUMN "sys_message_detail"."read_flag" IS '消息状态（1：已读 0：未读）';
COMMENT ON COLUMN "sys_message_detail"."open_way" IS '打开方式';
COMMENT ON COLUMN "sys_message_detail"."people_id" IS '个人id';
COMMENT ON COLUMN "sys_message_detail"."mobile_business_address" IS '移动端业务地址';
COMMENT ON TABLE "sys_message_detail" IS '消息详情';

-- ----------------------------
-- Records of SYS_MESSAGE_DETAIL
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for SYS_MICRO_APPLICATION_CONF
-- ----------------------------
DROP TABLE IF EXISTS "sys_micro_application_conf";
CREATE TABLE "sys_micro_application_conf" (
  "ma_id" int8 NOT NULL,
  "ma_active_rule" varchar(128),
  "ma_preload" char(1),
  "need_vfg" char(1),
  "create_time" timestamp without time zone,
  "creator" int8,
  "last_time" timestamp without time zone,
  "last_editor" int8,
  "ma_status" char(1),
  "ma_name" varchar(64),
  "app_id" int8,
  "ma_entry" varchar(128),
  "ma_container" varchar(64)
)
;
COMMENT ON COLUMN "sys_micro_application_conf"."ma_active_rule" IS '匹配路由';
COMMENT ON COLUMN "sys_micro_application_conf"."ma_preload" IS '是否一登录就加载子应用(0代表不开启预加载，1代表开启,默认是1)';
COMMENT ON COLUMN "sys_micro_application_conf"."need_vfg" IS '是否需要可视化设计器0代表不需要，1代表需要,默认是1';
COMMENT ON COLUMN "sys_micro_application_conf"."create_time" IS '创建时间';
COMMENT ON COLUMN "sys_micro_application_conf"."creator" IS '创建人ID';
COMMENT ON COLUMN "sys_micro_application_conf"."last_time" IS '最后一次修改时间';
COMMENT ON COLUMN "sys_micro_application_conf"."last_editor" IS '最后一次修改人';
COMMENT ON COLUMN "sys_micro_application_conf"."ma_status" IS '配置状态：0，禁用1启用,默认是1';
COMMENT ON COLUMN "sys_micro_application_conf"."ma_name" IS '微应用标识';
COMMENT ON COLUMN "sys_micro_application_conf"."app_id" IS '所属应用';
COMMENT ON COLUMN "sys