-- ----------------------------
-- Table structure for SYS_AD_IGNORE_SHOW
-- ----------------------------

CREATE TABLE "SYS_AD_IGNORE_SHOW" (
  "IGNORE_ID" NUMBER(20,0) NOT NULL,
  "AD_ID" NUMBER(20,0)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."IGNORE_ID" IS 'id';
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."AD_ID" IS '横幅主键';
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_AD_IGNORE_SHOW"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_AD_IGNORE_SHOW" IS '横幅关闭记录表';
ALTER TABLE "SYS_AD_IGNORE_SHOW" ADD CONSTRAINT "SYS_C00699997" PRIMARY KEY ("IGNORE_ID");
-- ----------------------------
-- Table structure for SYS_BUSINESS_CONFIG
-- ----------------------------
CREATE TABLE "SYS_BUSINESS_CONFIG" (
  "CONFIG_ID" NUMBER(20,0)  NOT NULL,
  "CONFIG_NAME" VARCHAR2(765)  DEFAULT NULL,
  "CONFIG_SCENE" VARCHAR2(765)  DEFAULT NULL,
  "CONFIG_TAG" VARCHAR2(765)  DEFAULT NULL,
  "CONFIG_TYPE" NUMBER(10,0)  DEFAULT NULL,
  "PERMISSION_RULE" CLOB  DEFAULT NULL,
  "CONFIG_KEY" VARCHAR2(765)  DEFAULT NULL,
  "CONFIG_VALUE" CLOB  DEFAULT NULL,
  "REMARK1" VARCHAR2(765)  DEFAULT NULL,
  "REMARK2" VARCHAR2(765)  DEFAULT NULL,
  "REMARK3" VARCHAR2(765)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "DEL_FLAG" CHAR(1)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_ID" IS '业务主键';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_NAME" IS '配置名称';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_SCENE" IS '场景';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_TAG" IS '标签';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_TYPE" IS '配置类型（0系统：所有人可见，1个人：创建者可见）';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."PERMISSION_RULE" IS '自定义配置规则';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_KEY" IS '配置key';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CONFIG_VALUE" IS '配置值';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."REMARK1" IS '扩展字段1（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."REMARK2" IS '扩展字段2（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."REMARK3" IS '扩展字段3（是否默认、排序权重等通过扩展字段配置）';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_BUSINESS_CONFIG"."DEL_FLAG" IS '是否删除';
COMMENT ON TABLE "SYS_BUSINESS_CONFIG" IS '业务配置管理';
ALTER TABLE "SYS_BUSINESS_CONFIG" ADD CONSTRAINT "SYS_C00699993" PRIMARY KEY ("CONFIG_ID");

-- ----------------------------
-- Table structure for SYS_COMMONLY_USE_ORGAN_USER
-- ----------------------------
CREATE TABLE "SYS_COMMONLY_USE_ORGAN_USER" (
  "COMMONLY_USE_ID" NUMBER(20,0)  NOT NULL,
  "COMMONLY_USE_TYPE" NUMBER(10,0)  DEFAULT NULL,
  "ORGAN_USER_ID" NUMBER(20,0)  DEFAULT NULL,
  "USE_COUNT" NUMBER(10,0)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATOR_NAME" VARCHAR2(765)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "DEL_FLAG" CHAR(1)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."COMMONLY_USE_ID" IS '主键id';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."COMMONLY_USE_TYPE" IS '类型(0：部门，1：用户)';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."ORGAN_USER_ID" IS '部门/用户id';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."USE_COUNT" IS '使用次数';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."CREATOR" IS '创建人id';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."CREATOR_NAME" IS '创建人';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_COMMONLY_USE_ORGAN_USER"."DEL_FLAG" IS '是否删除';
COMMENT ON TABLE "SYS_COMMONLY_USE_ORGAN_USER" IS '常用选人选部门';
ALTER TABLE "SYS_COMMONLY_USE_ORGAN_USER" ADD CONSTRAINT "SYS_C00699994" PRIMARY KEY ("COMMONLY_USE_ID");
-- ----------------------------
-- Table structure for SYS_DATA_SET_GROUP
-- ----------------------------
CREATE TABLE "SYS_DATA_SET_GROUP" (
  "GROUP_ID" NUMBER(20,0)  NOT NULL,
  "GROUP_NAME" VARCHAR2(96)  DEFAULT NULL,
  "SEQ" NUMBER(10,0)  DEFAULT NULL,
  "GROUP_ICON" VARCHAR2(96)  DEFAULT NULL,
  "GROUP_ICON_TYPE" CHAR(1)  DEFAULT NULL,
  "GROUP_TYPE" CHAR(1)  DEFAULT NULL,
  "GROUP_ICON_COLOR" VARCHAR2(96)  DEFAULT NULL,
  "APP_ID" NUMBER(20,0)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_ID" IS '数据集分组id';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_NAME" IS '数据集分组名称';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."SEQ" IS '分组显示顺序';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_ICON" IS '数据集分组图标';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_ICON_TYPE" IS '分组图标类型1：内置图标2：用户自定义';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_TYPE" IS '分组类型1:默认分组2:普通分组';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."GROUP_ICON_COLOR" IS '分组图标颜色';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."APP_ID" IS '数据集应用ID';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_DATA_SET_GROUP"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_DATA_SET_GROUP" IS '数据集分组表';

ALTER TABLE "SYS_DATA_SET_GROUP" ADD CONSTRAINT "SYS_C00699995" PRIMARY KEY ("GROUP_ID");
-- ----------------------------
-- Table structure for SYS_DATA_SET_INFO
-- ----------------------------
CREATE TABLE "SYS_DATA_SET_INFO" (
  "DATA_SET_ID" NUMBER(20,0)  NOT NULL,
  "DATA_SET_NAME" VARCHAR2(192)  DEFAULT NULL,
  "DATA_SET_CODE" VARCHAR2(192)  DEFAULT NULL,
  "DATA_SET_ICON_TYPE" VARCHAR2(96)  DEFAULT NULL,
  "DATA_SET_ICON" VARCHAR2(96)  DEFAULT NULL,
  "DATA_SET_ICON_COLOR" VARCHAR2(96)  DEFAULT NULL,
  "SEQ" NUMBER(10,0)  DEFAULT NULL,
  "DATA_SET_DESC" VARCHAR2(765)  DEFAULT NULL,
  "DATA_SOURCE_ID" NUMBER(20,0)  DEFAULT NULL,
  "DATA_SOURCE_NAME" VARCHAR2(96)  DEFAULT NULL,
  "DATA_SOURCE_TYPE" VARCHAR2(96)  DEFAULT NULL,
  "GROUP_ID" NUMBER(20,0)  DEFAULT NULL,
  "APP_ID" NUMBER(20,0)  DEFAULT NULL,
  "DATA_SET_TYPE" CHAR(1)  DEFAULT NULL,
  "DATA" CLOB  DEFAULT NULL,
  "DEL_FLAG" CHAR(1)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_ID" IS '数据集ID';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_NAME" IS '数据集名称';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_CODE" IS '数据集标识';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_ICON_TYPE" IS '数据集图标类型';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_ICON" IS '数据集图标';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_ICON_COLOR" IS '内置图标颜色';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."SEQ" IS '显示顺序';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_DESC" IS '数据集描述';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SOURCE_ID" IS '数据源id';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SOURCE_NAME" IS '数据源名称';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SOURCE_TYPE" IS '数据源类型';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."GROUP_ID" IS '数据集分组ID';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."APP_ID" IS '应用ID';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA_SET_TYPE" IS '数据集类型';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DATA" IS '数据集信息';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."DEL_FLAG" IS '需要逻辑删除的业务添加该字段';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_DATA_SET_INFO"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_DATA_SET_INFO" IS '数据集信息表';

ALTER TABLE "SYS_DATA_SET_INFO" ADD CONSTRAINT "SYS_C00699996" PRIMARY KEY ("DATA_SET_ID");
-- ----------------------------
-- Table structure for SYS_CUSTOMIZED_COMPONENT
-- ----------------------------
CREATE TABLE "SYS_CUSTOMIZED_COMPONENT" (
  "CUSTOMIZED_COMPONENT_ID" NUMBER(20)  NOT NULL ,
  "CSS_FILE" CLOB  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."CUSTOMIZED_COMPONENT_ID" IS '主键';
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."CSS_FILE" IS 'css文件';
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_CUSTOMIZED_COMPONENT"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_CUSTOMIZED_COMPONENT" IS '定制化组件信息表';
ALTER TABLE "SYS_CUSTOMIZED_COMPONENT" ADD CONSTRAINT "SYS_C00699884" PRIMARY KEY ("CUSTOMIZED_COMPONENT_ID");
-- ----------------------------
-- Table structure for SYS_SORT_CONDITION_INFO
-- ----------------------------
CREATE TABLE "SYS_SORT_CONDITION_INFO" (
  "SORT_ID" NUMBER(20)  NOT NULL ,
  "USER_ID" NUMBER(20)  NOT NULL,
  "PAGE_ID" VARCHAR2(108)  DEFAULT NULL,
  "COMPONENT_ID" VARCHAR2(108)  DEFAULT NULL,
  "SORT_CONDITION_INFO" CLOB  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "IS_DEFAULT" CHAR(1)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."SORT_ID" IS '主键';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."PAGE_ID" IS '页面ID';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."COMPONENT_ID" IS '组件ID';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."SORT_CONDITION_INFO" IS '排序条件';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_SORT_CONDITION_INFO"."IS_DEFAULT" IS '是否默认，默认为1';
COMMENT ON TABLE "SYS_SORT_CONDITION_INFO" IS '排序条件信息表';
ALTER TABLE "SYS_SORT_CONDITION_INFO" ADD CONSTRAINT "SYS_C00699874" PRIMARY KEY ("SORT_ID");
-- ----------------------------
-- Table structure for SYS_TREE_RECORD
-- ----------------------------
CREATE TABLE "SYS_TREE_RECORD" (
  "TREE_RECORD_ID" NUMBER(20)  NOT NULL ,
  "USER_ID" NUMBER(20)  NOT NULL,
  "PAGE_ID" VARCHAR2(108)  DEFAULT NULL,
  "COMPONENT_ID" VARCHAR2(108)  DEFAULT NULL,
  "TREE_RECORD_INFO" CLOB  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_TREE_RECORD"."TREE_RECORD_ID" IS '主键';
COMMENT ON COLUMN "SYS_TREE_RECORD"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_TREE_RECORD"."PAGE_ID" IS '页面ID';
COMMENT ON COLUMN "SYS_TREE_RECORD"."COMPONENT_ID" IS '组件ID';
COMMENT ON COLUMN "SYS_TREE_RECORD"."TREE_RECORD_INFO" IS '历史记录信息';
COMMENT ON COLUMN "SYS_TREE_RECORD"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_TREE_RECORD"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_TREE_RECORD"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_TREE_RECORD"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_TREE_RECORD" IS '树形控件历史记录表';
ALTER TABLE "SYS_TREE_RECORD" ADD CONSTRAINT "SYS_C00697791" PRIMARY KEY ("TREE_RECORD_ID");

CREATE TABLE "SYS_QUERY_CONDITION_INFO" (
  "CONDITION_ID" NUMBER(20)  NOT NULL ,
  "USER_ID" NUMBER(20)  NOT NULL,
  "PAGE_ID" VARCHAR2(108)  DEFAULT NULL,
  "COMPONENT_ID" VARCHAR2(108)  DEFAULT NULL,
  "QUERY_CONDITION_INFO" CLOB  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "IS_DEFAULT" CHAR(1)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."CONDITION_ID" IS '主键';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."PAGE_ID" IS '页面ID';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."COMPONENT_ID" IS '组件ID';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."QUERY_CONDITION_INFO" IS '查询条件';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_QUERY_CONDITION_INFO"."IS_DEFAULT" IS '是否默认，默认为1';
COMMENT ON TABLE "SYS_QUERY_CONDITION_INFO" IS '查询条件信息表';
ALTER TABLE "SYS_QUERY_CONDITION_INFO" ADD CONSTRAINT "SYS_C00697789" PRIMARY KEY ("CONDITION_ID");
-- ----------------------------
-- Table structure for SYS_CUSTOM_LIST_FIELD_INFO
-- ----------------------------

CREATE TABLE "SYS_CUSTOM_LIST_FIELD_INFO" (
  "INFO_ID" NUMBER(20)  NOT NULL ,
  "USER_ID" NUMBER(20)  NOT NULL,
  "PAGE_ID" VARCHAR2(108)  DEFAULT NULL,
  "COMPONENT_ID" VARCHAR2(108)  DEFAULT NULL,
  "COMPONENT_INFO" CLOB  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "DEL_FLAG" CHAR(1)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."INFO_ID" IS '主键';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."PAGE_ID" IS '页面ID';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."COMPONENT_ID" IS '组件ID';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."COMPONENT_INFO" IS '组件信息';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_CUSTOM_LIST_FIELD_INFO"."DEL_FLAG" IS '删除标识';
COMMENT ON TABLE "SYS_CUSTOM_LIST_FIELD_INFO" IS '自定义字段信息表';
ALTER TABLE "SYS_CUSTOM_LIST_FIELD_INFO" ADD CONSTRAINT "SYS_C00697788" PRIMARY KEY ("INFO_ID");
-- ----------------------------
-- Table structure for SYS_APP_MENU_RESOURCE
-- ----------------------------

CREATE TABLE "SYS_APP_MENU_RESOURCE" (
  "APP_NAME" VARCHAR2(108)  DEFAULT NULL,
  "PAGE_ID" VARCHAR2(108)  DEFAULT NULL,
  "RELATION_ID" NUMBER(20)  DEFAULT NULL,
  "RELATION_REF_ID" NUMBER(20)  DEFAULT NULL,
  "RELATION_TYPE" VARCHAR2(3)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."APP_NAME" IS '应用名称';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."PAGE_ID" IS '应用下的页面Id，用于应用页面菜单和资源的自动绑定';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."RELATION_ID" IS '关联Id;菜单Id或资源Id';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."RELATION_REF_ID" IS '功能Id;当应用关联菜单时有值;用于自动关联功能和资源';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."RELATION_TYPE" IS '1=应用关联的菜单；2=应用关联的资源';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_APP_MENU_RESOURCE"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_APP_MENU_RESOURCE" IS '应用与菜单及资源的关联关系表';

-- ----------------------------
-- Table structure for SYS_AGENDA
-- ----------------------------

CREATE TABLE "SYS_AGENDA" (
  "AGENDA_ID" NUMBER(20)  NOT NULL ,
  "AGENDA_TITLE" VARCHAR2(96)  NOT NULL,
  "AGENDA_TYPE" CHAR(1)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "AGENDA_CONTENT" VARCHAR2(3072) DEFAULT NULL,
  "PLACE" VARCHAR2(376)  DEFAULT NULL,
  "START_TIME" TIMESTAMP(6)  NOT NULL,
  "END_TIME" TIMESTAMP(6)  NOT NULL
);
COMMENT ON COLUMN "SYS_AGENDA"."AGENDA_ID" IS '日程id';
COMMENT ON COLUMN "SYS_AGENDA"."AGENDA_TITLE" IS '日程标题';
COMMENT ON COLUMN "SYS_AGENDA"."AGENDA_TYPE" IS '日程类型';
COMMENT ON COLUMN "SYS_AGENDA"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_AGENDA"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_AGENDA"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_AGENDA"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_AGENDA"."AGENDA_CONTENT" IS '日程内容';
COMMENT ON COLUMN "SYS_AGENDA"."PLACE" IS '地点';
COMMENT ON COLUMN "SYS_AGENDA"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "SYS_AGENDA"."END_TIME" IS '结束时间';
COMMENT ON TABLE "SYS_AGENDA" IS '日程管理表';
-- ----------------------------
-- Table structure for SYS_BASE_CONFIG
-- ----------------------------

CREATE TABLE "SYS_BASE_CONFIG" (
  "CONFIG_ID" NUMBER(20)  NOT NULL ,
  "NAME" VARCHAR2(96)  DEFAULT NULL,
  "CONFIG_KEY" VARCHAR2(96)  DEFAULT NULL,
  "CONFIG_VALUE" VARCHAR2(4000)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "EXAMPLE" CLOB  ,
  "PARENT_ID" NUMBER(20)  DEFAULT NULL,
  "CONFIG_RULE" VARCHAR2(150)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CONFIG_ID" IS '主键';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."NAME" IS '描述';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CONFIG_KEY" IS '键';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CONFIG_VALUE" IS '值';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."EXAMPLE" IS '示例';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."PARENT_ID" IS '上级id';
COMMENT ON COLUMN "SYS_BASE_CONFIG"."CONFIG_RULE" IS '校验规则';
COMMENT ON TABLE "SYS_BASE_CONFIG" IS '平台基础配置表';

-- ----------------------------
-- Records of "SYS_BASE_CONFIG"
-- ----------------------------
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('111', '账户配置', 'account_config', NULL, NULL, NULL, NULL, NULL, '账户配置项，在账户未登录天数超过配置时，账户状态会变为休眠，若没有再次被激活，则会被自动注销，账户状态变化和自动注销前都会给账户配置的邮箱发送提示短信', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('222', '登录失败配置', 'login_fail_config', NULL, NULL, NULL, NULL, NULL, '密码输入错误相关配置，在连续失败时间内达到了配置连续失败次数时，会对账号按锁定时间进行锁定，若配置了失败消息接收邮箱，会发送邮件提醒', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('333', '登录时间配置', 'login_time_config', NULL, NULL, NULL, NULL, NULL, '登录时间配置，开启后只有在允许的时间段内登录系统', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('444', '登录ip配置', 'login_ip_config', NULL, NULL, NULL, NULL, NULL, '登录ip配置，配置允许或禁止某些ip地址登录系统，限制外的ip地址登录时会发送邮件提醒', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('666', '密码配置', 'password_config', NULL, NULL, NULL, NULL, NULL, '用户密码配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('777', '创建用户配置', 'user_create_config', NULL, NULL, NULL, NULL, NULL, '创建用户配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('888', '页面配置', 'theme_config', NULL, NULL, NULL, NULL, NULL, '页面参数配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('999', '审核配置', 'audit_config', NULL, NULL, NULL, NULL, NULL, '审核配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1111', '未登录天数', 'nologin_day', '-1', NULL, NULL, NULL, NULL, '单位天。超过配置天数账号会休眠，-1为不休眠', '111', 'checkNumber');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1112', '账户状态', 'user_account_status', '3', NULL, NULL, NULL, NULL, '单选框。休眠', '111', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1113', '休眠提醒邮件标题', 'status_change_email_title', '账户状态变更提醒', NULL, NULL, NULL, NULL, '自动休眠提醒邮件标题', '111', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1114', '休眠提醒邮件内容', 'status_change_email', '您的账号:#{user_account},由于超过#{nologin_day}天未登录，账户已被#{user_account_status}。</br>如要继续使用，请联系管理员', NULL, NULL, NULL, NULL, '自动休眠提醒邮件模版', '111', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1115', '休眠多久自动注销', 'logout_day', '365', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：365', '111', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1116', '注销前多久发送邮件', 'email_before_logout_day', '5', NULL, NULL, NULL, NULL, '正整数，单位天。示例 ：5', '111', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1117', '注销提醒邮件标题', 'logout_warn_email_title', '账户注销提醒', NULL, NULL, NULL, NULL, '自动注销提醒邮件标题', '111', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1118', '注销提醒邮件内容', 'logout_warn_email', '您的账号:#{user_account},将在#{email_before_logout_day}天后注销。</br>如要继续使用，请尽快联系管理员', NULL, NULL, NULL, NULL, '自动注销提醒邮件模板', '111', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2221', '连续失败时间', 'fail_time', '1', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例：3', '222', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2222', '连续失败次数', 'fail_number', '5', NULL, NULL, NULL, NULL, '正整数。示例 ：3', '222', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2223', '连续失败锁定时间', 'fail_lock_time', '2', NULL, NULL, NULL, NULL, '正整数，单位：分钟，示例 ：60', '222', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2224', '失败消息接收邮箱', 'fail_email_box', NULL, NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', '222', 'checkEmails');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2225', '失败邮件标题', 'fail_email_title', '账号连续登录失败提醒', NULL, NULL, NULL, NULL, '账户锁定邮件标题', '222', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2226', '失败邮件内容', 'fail_email', '用户账号:#{user_account}密码连续输入错误#{fail_number}次，账号已被锁定', NULL, NULL, NULL, NULL, '账户锁定邮件模板', '222', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('3331', '登录时间限制', 'login_time_limit', '1', NULL, NULL, NULL, NULL, '登录限制开关', '333', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('3332', '允许登录开始时间', 'login_start_time', '08:00:00', NULL, NULL, NULL, NULL, '允许登录开始时间', '333', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('3333', '允许登录结束时间', 'login_end_time', '20:00:00', NULL, NULL, NULL, NULL, '允许登录结束时间', '333', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4441', '登录ip限制', 'login_ip_limit', '1', NULL, NULL, NULL, NULL, 'ip限制开关', '444', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4442', '允许登录ip', 'allow_login_ip', NULL, NULL, NULL, NULL, NULL, '允许访问系统的ip,ip之间英文逗号分隔，不填写不生效', '444', 'checkIPs');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4443', '禁止登录ip', 'forbid_login_ip', NULL, NULL, NULL, NULL, NULL, '禁止访问系统的ip,ip之间英文逗号分隔，不填写不生效', '444', 'checkIPs');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4444', 'ip预警接收邮箱', 'ip_warn_email_box', NULL, NULL, NULL, NULL, NULL, '管理员邮箱，邮箱间英文逗号分隔，不填写不发送', '444', 'checkEmails');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4445', 'ip预警邮件标题', 'ip_warn_email_title', 'ip登录预警', NULL, NULL, NULL, NULL, 'ip预警邮件标题', '444', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('4446', 'ip预警邮件模板', 'ip_warn_email', '存在未经允许的ip登录系统，ip地址：#{ip_address}</br>用户名称：#{user_name}</br>用户账号：#{user_account}', NULL, NULL, NULL, NULL, 'ip预警邮件模板', '444', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('5551', '会话限制', 'session_limit', '0', NULL, NULL, NULL, NULL, '默认开启', '555', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('5552', '最大会话数', 'max_session_num', '1000000', NULL, NULL, NULL, NULL, '系统最大会话数，同时开启session_limit和kickout_after时才生效，配置为-1为不限制会话数量', '555', 'checkNumber');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('5553', '会话超出限制时，踢出后者', 'kickout_after', '0', NULL, NULL, NULL, NULL, '开启时剔除后者即新登录用户不能登录，关闭时剔除最先登录的', '555', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6661', '系统缺省密码规则', 'pwd_rule', '8,16,3', NULL, NULL, NULL, NULL, '系统缺省密码规则（"最小长度，最大长度，密码强度"）,缺省规则是( 8,16,3 )最小不能小于8位，最大不能大于16位，强度为3
密码强度规则分1-3级，各级的含义如下：
级别1：如果密码只由数字、小写字母、大写字母或其它特殊符号当中的一种组成,则认为这是一个弱密码.
级别2：如果密码由数字、小写字母、大写字母或其它特殊符号当中的两种组成,则认为这是一个中度安全的密码
级别3：如果密码由数字、小写字母、大写字母或其它特殊符号当中的三种以上组成,则认为这是一个比较安全的密码.', '666', 'checkStrengthRule');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6663', '自定义密码复杂度', 'pwd_rule_custom', '1', NULL, NULL, NULL, NULL, '开启自定义时,pwd_complexity_regular 自定义正则表达式，unmatched_hint 自定义返回消息；不开启时使用平台自带规则', '666', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6664', '密码复杂度正则', 'pwd_complexity_regular', '/^[\S]{6,12}$/', NULL, NULL, NULL, NULL, '正则校验密码规则', '666', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG" ("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES (6665, '自定义返回消息', 'unmatched_hint', '新密码不符合密码规则！', NULL, NULL, NULL, NULL, '修改密码时的自定义返回消息，开启自定义密码复杂度时生效', 666, 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6666', '强制修改密码', 'force_change_pwd', '0', NULL, NULL, NULL, NULL, '是否在第一次登录或一段时间后强制用户修改密码', '666', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6667', '密码生命周期', 'password_hist', '90', NULL, NULL, NULL, NULL, '正整数，多少天后强制修改密码  单位（天）', '666', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('6668', '密码重复次数', 'pwd_repeat_time', '2', NULL, NULL, NULL, NULL, '正整数，密码不能和前几次相同', '666', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('7771', '创建用户时发送邮件', 'create_user_send_email', '1', NULL, NULL, NULL, NULL, '创建用户时发送邮件开关', '777', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('7772', '创建用户时使用默认密码', 'create_user_use_default_pass', '0', NULL, NULL, NULL, NULL, '创建用户是否使用默认密码，开启时使用默认密码，不开启时使用密码规则生成的密码。为防止生成的密码无法得知，当create_user_send_email关闭时也使用默认密码', '777', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('7773', '用户默认密码', 'default_password', '123456', NULL, NULL, NULL, NULL, '用户默认密码，可输入数字、大写字母、小写字母、英文特殊字符（`~!@#$%^&*()_|+<>?:"{},./;''[]-）', '777', 'checkdefultpw');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('7775', '操作人员同时操作用户', 'operate_staff_with_user', '1', NULL, NULL, NULL, NULL, '开启时操作人员同时操作用户（新增、修改、删除、转移）', '777', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('8883', '标签页切换刷新', 'tab_switchover', '0', NULL, NULL, NULL, NULL, '标签页切换刷新开关，重新登录后生效', '888', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9991', '关键操作审核', 'critical_operations_audit', '1', NULL, NULL, NULL, NULL, '关键操作是否需要审核，总开关，只有开启后，下面几个开关才分别生效', '999', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9992', '组织机构审核', 'organ_audit', '0', NULL, NULL, NULL, NULL, '组织机构操作审核开关', '999', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9993', '用户审核', 'user_audit', '0', NULL, NULL, NULL, NULL, '用户操作审核开关', '999', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9994', '用户角色审核', 'role_audit', '0', NULL, NULL, NULL, NULL, '用户角色操作审核开关', '999', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9996', '登录页背景图', 'login_view_background', NULL, NULL, NULL, NULL, NULL, '登录页背景图', '202020', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9997', '登录框背景图', 'login_view_innerBackground', NULL, NULL, NULL, NULL, NULL, '登录框背景图', '202020', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('9998', '浏览器页签图标的配置项', 'relation_icon', NULL, NULL, NULL, NULL, NULL, '浏览器页签图标的配置项', '212121', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('101010', '异常报警配置', 'exception_config', NULL, NULL, NULL, NULL, NULL, '异常报警配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('121212', '登录配置', 'login_config', NULL, NULL, NULL, NULL, NULL, '登录配置', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('202020', '登录页可视化配置', 'login_view_config', NULL, NULL, NULL, NULL, NULL, '门户登录页可视化配置', '2', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('212121', '首页可视化配置', 'home_page', NULL, NULL, NULL, NULL, NULL, '首页可视化配置', '2', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1010101', '审计日志报警条数', 'securitylog_count_alert', '100000', NULL, NULL, NULL, NULL, '超过此条数时报警，只能输入正整数，默认不发送，配置后才发送', '101010', 'checkPositiveNum');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1010102', '异常报警', 'exception_alert', '1', NULL, NULL, NULL, NULL, '异常报警开关，权限异常时会发送告警邮件', '101010', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1010103', '异常报警接收邮件邮箱', 'exception_alert_email', NULL, NULL, NULL, NULL, NULL, '多个邮箱使用,隔开', '101010', 'checkEmails');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1212121', '区分登录账号大小写', 'login_upper_open', '0', NULL, NULL, NULL, NULL, '区分登录账号大小写开关', '121212', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1212122', '登录验证码', 'kaptcha_open', '1', NULL, NULL, NULL, NULL, 'console端登录验证码开关。如需配置门户验证码开关，请前往门户配置中心-登录页配置-配置项。', '121212', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1212123', '登录时动态密码验证', 'totp_open', '1', NULL, NULL, NULL, NULL, '登录动态密码验证开关', '121212', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('1212124', '动态密码验证允许时间偏差', 'totp_offset_min', '2', NULL, NULL, NULL, NULL, '单位 min 分钟， 默认0，无偏差验证，必须保证手机端和服务器时间误差在30s之内才能准确验证', '121212', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020201', '登录布局', 'login_view_type', '1', NULL, NULL, NULL, NULL, '登录页面布局', '202020', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020202', '系统名称', 'login_view_sysname', '统一门户', NULL, NULL, NULL, NULL, '登录页面显示的系统名称', '202020', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020203', '系统LOGO', 'login_view_logo', NULL, NULL, NULL, NULL, NULL, '登录页面显示的系统logo', '202020', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020204', '版权所有', 'login_view_copyright', NULL, NULL, NULL, NULL, NULL, '登录页面显示的版权所有信息', '202020', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020205', '验证码', 'login_view_kaptcha', '1', NULL, NULL, NULL, NULL, '登录时是否进行验证码验证', '202020', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2020206', '记住密码', 'login_rememberpwd', '1', NULL, NULL, NULL, NULL, '登录时是否记住密码', '202020', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2121211', '首页布局类型', 'home_page_type', '0', NULL, NULL, NULL, NULL, '首页布局类型', '212121', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2121212', '首页系统名称', 'home_page_sysname', '统一门户', NULL, NULL, NULL, NULL, '首页显示系统名称', '212121', 'checkNotEmpty');
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('2121213', '首页系统LOGO', 'home_page_logo', NULL, NULL, NULL, NULL, NULL, '首页显示系统LOGO', '212121', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('202202170', '主题权限配置', 'theme_config_edit', '1', NULL, NULL, NULL, NULL, '主题权限配置，是否启用主题配置编辑功能', '1', NULL);
INSERT INTO "SYS_BASE_CONFIG"("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES ('202202171', '主题权限配置', 'enable_theme_config_edit', '1', NULL, NULL, NULL, NULL, '是否启用主题配置编辑功能', '202202170', 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG" ("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES (99910, '岗位审核', 'post_audit', '0', NULL, NULL, 1450756958461300737, TO_DATE('2023-05-26 10:03:27','SYYYY-MM-DD HH24:MI:SS'), '岗位操作审核开关', 999, 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG" ("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES (99911, '人员审核', 'staff_audit', '0', NULL, NULL, 1450756958461300737, TO_DATE('2023-05-26 10:03:27','SYYYY-MM-DD HH24:MI:SS'), '人员操作审核开关', 999, 'checkRadio');
INSERT INTO "SYS_BASE_CONFIG" ("CONFIG_ID", "NAME", "CONFIG_KEY", "CONFIG_VALUE", "CREATE_TIME", "CREATOR", "LAST_EDITOR", "LAST_TIME", "EXAMPLE", "PARENT_ID", "CONFIG_RULE") VALUES (1212125, '令牌有效时间', 'access_token_valid_time', '1800', NULL, NULL, 1450756958461300737, TO_DATE('2023-07-20 19:30:43','SYYYY-MM-DD HH24:MI:SS'), '令牌有效时间，单位秒。', 121212, 'checkTokenValidTime');

-- ----------------------------
-- Table structure for SYS_CALENDAR
-- ----------------------------

CREATE TABLE "SYS_CALENDAR" (
  "CALENDAR_ID" NUMBER(20)  NOT NULL ,
  "TITLE" VARCHAR2(96)  DEFAULT NULL,
  "START_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "END_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "CLASS_NAME" VARCHAR2(96)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "REMARK" VARCHAR2(768)  DEFAULT NULL,
  "STATUS" CHAR(1)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_CALENDAR"."CALENDAR_ID" IS '主键';
COMMENT ON COLUMN "SYS_CALENDAR"."TITLE" IS '事件标题';
COMMENT ON COLUMN "SYS_CALENDAR"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "SYS_CALENDAR"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "SYS_CALENDAR"."CLASS_NAME" IS '事件的样式';
COMMENT ON COLUMN "SYS_CALENDAR"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_CALENDAR"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_CALENDAR"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_CALENDAR"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON COLUMN "SYS_CALENDAR"."REMARK" IS '备注';
COMMENT ON COLUMN "SYS_CALENDAR"."STATUS" IS '状态';
COMMENT ON TABLE "SYS_CALENDAR" IS '工作日历表';

-- ----------------------------
-- Records of "SYS_CALENDAR"
-- ----------------------------
INSERT INTO "SYS_CALENDAR"("CALENDAR_ID", "TITLE", "START_TIME", "END_TIME", "CLASS_NAME", "CREATOR", "LAST_EDITOR", "CREATE_TIME", "LAST_TIME", "REMARK", "STATUS") VALUES ('1450383908880433153', '班', TO_DATE('2018-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, 'work', NULL, NULL, TO_DATE('2018-05-22 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_CALENDAR"("CALENDAR_ID", "TITLE", "START_TIME", "END_TIME", "CLASS_NAME", "CREATOR", "LAST_EDITOR", "CREATE_TIME", "LAST_TIME", "REMARK", "STATUS") VALUES ('1450384023288541185', '休', TO_DATE('2018-05-04 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, 'holiday', NULL, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_CONF_ROLES
-- ----------------------------

CREATE TABLE "SYS_CONF_ROLES" (
  "SCR_ID" NUMBER(20,0) NOT NULL,
  "ROLE_ID" NUMBER(20,0)  DEFAULT NULL,
  "SET_ID" NUMBER(20,0)  DEFAULT NULL,
  "SYS_SET_ID" NUMBER(20,0)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_CONF_ROLES"."SCR_ID" IS '主键';
COMMENT ON COLUMN "SYS_CONF_ROLES"."ROLE_ID" IS '角色编码';
COMMENT ON COLUMN "SYS_CONF_ROLES"."SET_ID" IS '不相容角色集编码';
COMMENT ON COLUMN "SYS_CONF_ROLES"."SYS_SET_ID" IS '不相容角色集编码';
COMMENT ON TABLE "SYS_CONF_ROLES" IS '不相容角色';
-- ----------------------------
-- Table structure for SYS_CONF_ROLESET
-- ----------------------------

CREATE TABLE "SYS_CONF_ROLESET" (
  "SET_ID" NUMBER(20)  NOT NULL ,
  "SET_NAME" VARCHAR2(96)  DEFAULT NULL,
  "CARDINALITY" NUMBER(10)  DEFAULT NULL,
  "CORPORATION_ID" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "ROLESET_REMARK" VARCHAR2(384)
)
;
COMMENT ON COLUMN "SYS_CONF_ROLESET"."SET_ID" IS '不相容角色集编码';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."SET_NAME" IS '不相容角色集名称';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."CARDINALITY" IS '基数';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."CORPORATION_ID" IS '所属公司结构编码';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."LAST_TIME" IS '最后一次更新时间';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."LAST_EDITOR" IS '最后一次更新人';
COMMENT ON COLUMN "SYS_CONF_ROLESET"."ROLESET_REMARK" IS '描述';
COMMENT ON TABLE "SYS_CONF_ROLESET" IS '不相容角色集';


-- ----------------------------
-- Table structure for SYS_DICT_GROUP
-- ----------------------------

CREATE TABLE "SYS_DICT_GROUP" (
  "GROUP_ID" NUMBER(20)  NOT NULL ,
  "PARENT_ID" NUMBER(20)  DEFAULT NULL,
  "GROUP_DESCRIPTION" VARCHAR2(768)  DEFAULT NULL,
  "RANGE_TYPE" VARCHAR2(768)  DEFAULT NULL,
  "SORT" NUMBER(11)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "BAK_1" VARCHAR2(768)  DEFAULT NULL,
  "BAK_2" VARCHAR2(765)  DEFAULT NULL,
  "BAK_3" VARCHAR2(768)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_DICT_GROUP"."GROUP_ID" IS '主键';
COMMENT ON COLUMN "SYS_DICT_GROUP"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "SYS_DICT_GROUP"."GROUP_DESCRIPTION" IS '字典分组描述';
COMMENT ON COLUMN "SYS_DICT_GROUP"."RANGE_TYPE" IS '编辑类型';
COMMENT ON COLUMN "SYS_DICT_GROUP"."SORT" IS '排序';
COMMENT ON COLUMN "SYS_DICT_GROUP"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_DICT_GROUP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_DICT_GROUP"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_DICT_GROUP"."LAST_TIME" IS '上次编辑时间';
COMMENT ON COLUMN "SYS_DICT_GROUP"."BAK_1" IS '备用字段1';
COMMENT ON COLUMN "SYS_DICT_GROUP"."BAK_2" IS '备用字段2';
COMMENT ON COLUMN "SYS_DICT_GROUP"."BAK_3" IS '备用字段3';
COMMENT ON TABLE "SYS_DICT_GROUP" IS '字典分组表';

-- ----------------------------
-- Records of "SYS_DICT_GROUP"
-- ----------------------------
INSERT INTO "SYS_DICT_GROUP"("GROUP_ID", "PARENT_ID", "GROUP_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450384393200865282', '11', '系统字典', 'sys', '1', NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_GROUP"("GROUP_ID", "PARENT_ID", "GROUP_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450384438474231809', '11', '业务字典', 'biz', '2', NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
-- ----------------------------
-- Table structure for SYS_DICT_SINGLE
-- ----------------------------

CREATE TABLE "SYS_DICT_SINGLE" (
  "DICT_ID" NUMBER(20)  NOT NULL ,
  "TYPE_ID" NUMBER(20)  DEFAULT NULL,
  "VALUE" VARCHAR2(384)  DEFAULT NULL,
  "LABEL" VARCHAR2(384)  DEFAULT NULL,
  "SORT" NUMBER(11)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "BAK_1" VARCHAR2(768)  DEFAULT NULL,
  "BAK_2" VARCHAR2(768)  DEFAULT NULL,
  "BAK_3" VARCHAR2(768)  DEFAULT NULL,
  "PARENT_ID" NUMBER(20)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_DICT_SINGLE"."DICT_ID" IS '编号';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."TYPE_ID" IS '类型(SYS_DICT_TYPE外键)';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."VALUE" IS '数据值';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."LABEL" IS '标签名';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."SORT" IS '排序';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."LAST_TIME" IS '上次编辑时间';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."BAK_1" IS '备用字段1';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."BAK_2" IS '备用字段2';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."BAK_3" IS '备用字段3';
COMMENT ON COLUMN "SYS_DICT_SINGLE"."PARENT_ID" IS '父级主键ID';
COMMENT ON TABLE "SYS_DICT_SINGLE" IS '字典字段表';

-- ----------------------------
-- Records of "SYS_DICT_SINGLE"
-- ----------------------------
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1450742089393561655, 517670295990181889, 'dialog', '弹窗', 1, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1450742089393561656, 517670295990181889, 'browserTab', '浏览器页签', 2, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1450742089393561657, 517670295990181889, 'tab', '系统内页签', 3, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1450742089393561658, 517670295990181889, 'noCode', '零代码', 4, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (795585252704919552, 794925156320681984, 'user', '用户', 1, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (812013673790054400, 794925156320681984, 'client', '客户', 2, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (812013805734469632, 794925156320681984, 'supplier', '供应商', 3, 1450756958461300737, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (806812606638858240, 676356930893258752, '4', '联系人导入', 4, 1450756958461300737, TO_DATE('2024-02-05 09:05:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-05 09:05:15','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357144312029184, 676356969782845440, '1', '组织机构导出', 1, 1450756958461300737, TO_DATE('2023-02-10 09:21:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:21:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357177321201664, 676356969782845440, '2', '用户人员导出', 2, 1450756958461300737, TO_DATE('2023-02-10 09:21:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:21:57','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357019191746560, 676356930893258752, '1', '组织机构导入', 1, 1450756958461300737, TO_DATE('2023-02-10 09:21:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:21:19','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357106202583040, 676356930893258752, '2', '用户人员导入', 2, 1450756958461300737, TO_DATE('2023-02-10 09:21:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:21:40','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357106206842918, 676356930893258752, '3', '字典导入', 3, 1450756958461300737, TO_DATE('2023-06-09 10:21:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-06-09 11:22:40','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676357177321284927, 676356969782845440, '3', '字典导出', 3, 1450756958461300737, TO_DATE('2023-06-09 09:21:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-06-09 10:21:57','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (696315839754018816, 696315722368032768, '0', '导入中', 1, NULL, TO_DATE('2023-04-06 11:10:33','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2023-04-06 11:10:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (696315890861613056, 696315722368032768, '4', '导入成功', 2, NULL, TO_DATE('2023-04-06 11:10:45','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2023-04-06 11:10:45','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (696315957861425152, 696315722368032768, '-1', '导入失败', 3, NULL, TO_DATE('2023-04-06 11:11:01','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2023-04-06 11:11:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (700277290533396480, 696315722368032768, '6', '导出成功', 4, NULL, TO_DATE('2023-04-17 09:31:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2023-04-17 09:31:57','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (673842271296430080, 673842175301394432, '2', '覆盖更新', 2, 1450756958461300737, TO_DATE('2023-02-03 10:48:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 08:56:29','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (676350515063562240, 673842175301394432, '1', '忽略导入', 1, 1450756958461300737, TO_DATE('2023-02-10 08:55:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-14 15:16:44','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (677896054456459264, 673842175301394432, '4', '报错提醒', 4, 1450756958461300737, TO_DATE('2023-02-14 15:16:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-14 15:16:54','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('517670394224975872', '517670295990181888', '1', '驳回', '1', '1450756958461300737', TO_DATE('2021-11-29 11:57:20', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-29 11:57:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('517670664690475008', '517670295990181888', '2', '驳回，请重新申请', '2', '1450756958461300737', TO_DATE('2021-11-29 11:58:24', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-29 11:58:24', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('517670721909170176', '517670295990181888', '3', '驳回至第一节点', '3', '1450756958461300737', TO_DATE('2021-11-29 11:58:38', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-29 11:58:38', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('523443293179355136', '523443198920761344', '0', '内部组件', '1', NULL, TO_DATE('2021-12-15 10:16:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 10:16:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('523444544218603520', '523443198920761344', '1', '外部组件', '2', NULL, TO_DATE('2021-12-15 10:21:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 10:21:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('523444626317910016', '523443198920761344', '3', 'URL', '4', NULL, TO_DATE('2021-12-15 10:22:04', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 10:22:04', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('524165267232923648', '524165175805485056', '1', '公告', '1', '1450756958461300737', TO_DATE('2021-12-17 10:05:38', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-17 10:05:38', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('524611884536832000', '524165175805485056', '2', '通知', '2', '1450756958461300737', TO_DATE('2021-12-18 15:40:20', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-18 15:40:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561602', '1450742089372590096', '1', '系统级事件', '1', NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561603', '1450742089372590093', '1', '部门经理', '1', NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561604', '1450742089372590097', '1', '激活', '1', NULL, TO_DATE('2020-04-09 08:51:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-17 07:56:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561605', '1450742089372590088', '1', '全部可见', '1', NULL, TO_DATE('2021-03-04 14:29:11', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:29:11', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561606', '1450742089372590083', 'tab', '标签页', '1', NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561607', '1450742089372590091', '70', '秘密', '3', NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561608', '1450742089372590091', '71', '核心商业秘密', '2', NULL, TO_DATE('2021-04-26 11:18:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561609', '1450742089372590093', '2', '阿米巴负责人', '2', NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561610', '1450742089372590083', 'left', '隐藏左侧', '3', NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561611', '1450742089372590093', '4', '员工', '4', NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561612', '1450742089372590087', '2', '驳回，请重新申请', '2', NULL, TO_DATE('2021-03-10 13:44:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-10 13:45:21', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561613', '1450742089372590082', 'res_btn', '接口资源', '2', NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561614', '1450742089372590087', '3', '驳回至第一节点', '3', NULL, TO_DATE('2021-03-10 13:44:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-10 13:45:21', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561615', '1450742089372590096', '2', '业务级事件', '2', NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561616', '1450742089372590094', 'holiday', '休', '2', NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561617', '1450742089372590083', 'full', '新页面', '2', NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561618', '1450742089372590088', '2', '所在部门及子级可见', '2', NULL, TO_DATE('2021-03-04 14:30:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:30:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561619', '1450742089372590094', 'notice', '通知', '3', NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561620', '1450742089372590090', '0', '临时账号', '2', NULL, TO_DATE('2020-04-09 08:52:55', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-17 07:56:50', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561621', '1450742089372590088', '3', '仅所在部门可见', '3', NULL, TO_DATE('2021-03-04 14:30:45', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:30:45', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561622', '1450742089372590099', '1', '是', '1', NULL, TO_DATE('2018-04-11 14:19:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:19:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561623', '1450742089372590099', '0', '否', '2', NULL, TO_DATE('2018-04-11 14:19:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:19:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561624', '1450742089372590088', '4', '仅所属人可见', '4', NULL, TO_DATE('2021-03-04 14:30:58', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:30:58', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561625', '1450742089372590098', '2', '女', '10', NULL, TO_DATE('2018-04-11 14:19:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:19:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561626', '1450742089372590098', '1', '男', '1', NULL, TO_DATE('2018-04-11 14:19:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:19:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561627', '1450742089372590088', '5', '自定义可见范围', '5', NULL, TO_DATE('2021-03-04 14:31:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:31:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561628', '1450742089372590095', 'clbx', '差旅报销', '1', NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561629', '1450742089372590097', '0', '锁定', '3', NULL, TO_DATE('2020-04-09 08:51:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-17 07:56:09', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561630', '1450742089372590090', '1', '长期账号', '1', NULL, TO_DATE('2020-04-09 08:52:55', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-17 07:56:50', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561631', '1450742089372590086', '0', '未审核', '2', NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561632', '1450742089372590097', '3', '休眠', '2', NULL, TO_DATE('2020-04-09 08:51:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-17 07:56:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561633', '1450742089372590091', '61', '普通商业秘密', '4', NULL, TO_DATE('2021-04-26 11:19:18', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-04-26 11:19:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561634', '1450742089372590092', '80', '重要', '2', NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561635', '1450742089372590091', '80', '机密', '1', NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561636', '1450742089372590085', '0', '失败', '1', NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561637', '1450742089372590094', 'work', '班', '1', NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561638', '1450742089372590091', '60', '内部', '5', NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561639', '1450742089372590086', '2', '驳回', '3', NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561640', '1450742089372590089', '2', '人员', '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561641', '1450742089372590082', 'res_menu', '页面资源', '1', NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561642', '1450742089372590084', '1', '是', '2', NULL, TO_DATE('2020-04-09 08:51:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-16 07:44:18', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561643', '1450742089372590092', '90', '核心', '1', NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561644', '1450742089372590095', 'xmgl', '项目管理', '2', NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561645', '1450742089372590085', '1', '成功', '2', NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561646', '1450742089372590086', '1', '通过', '1', NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-18 09:57:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561647', '1450742089372590091', '50', '公开', '1', NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561648', '1450742089372590089', '1', '角色', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561649', '1450742089372590084', '0', '否', '1', NULL, TO_DATE('2020-04-09 08:51:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-16 07:44:18', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561650', '1450742089372590087', '1', '驳回', '1', NULL, TO_DATE('2021-03-10 13:44:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-10 13:45:21', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561651', '1450742089372590092', '60', '非密', '4', NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561652', '1450742089372590092', '70', '一般', '3', NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-04-26 03:06:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES ('1450742089393561653', '1450742089372590093', '3', '项目经理', '3', NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (591917296298237952, 591913311474556928, '20', '前20名', 4, 1450756958461300737, TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'), '1450756958461300737', TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'));
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (591913706074677248, 591913311474556928, '15', '前15名', 3, 1450756958461300737, TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'), '1450756958461300737', TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'));
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (591913605549793280, 591913311474556928, '10', '前10名', 2, 1450756958461300737, TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'), '1450756958461300737', TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'));
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (591913513669369856, 591913311474556928, '5', '前5名', 1, 1450756958461300737, TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'), '1450756958461300737', TO_TIMESTAMP('2022-06-22 09:08:01.648000', 'SYYYY-MM-DD HH24:MI:SS:FF6'));
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586233816600027136, 586233551075418112, '1', '阿里云', 1, 1450756958461300737, TO_DATE('2022-06-06 16:43:54', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 16:43:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586233852901728256, 586233551075418112, '2', '腾讯云', 2, 1450756958461300737, TO_DATE('2022-06-06 16:44:02', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 16:44:02', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586260304451870720, 575022217952501760, '2', '发送失败', 2, 1450756958461300737, TO_DATE('2022-06-06 18:29:09', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:29:09', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586260336982892544, 575022217952501760, '3', '发送成功', 3, 1450756958461300737, TO_DATE('2022-06-06 18:29:17', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:29:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586262527764340736, 586262390337970176, '1', '启用', 1, 1450756958461300737, TO_DATE('2022-06-06 18:37:59', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:37:59', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586262557128663040, 586262390337970176, '0', '禁用', 2, 1450756958461300737, TO_DATE('2022-06-06 18:38:06', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586658954864762880, 586658891807596544, '1', 'SMTP', 1, 1450756958461300737, TO_DATE('2022-06-07 20:53:14', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:53:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586658992051462144, 586658891807596544, '2', 'EXCHANGE(微软)', 2, 1450756958461300737, TO_DATE('2022-06-07 20:53:23', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:53:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586659341466345472, 586659288706195456, '1', 'SSL', 1, 1450756958461300737, TO_DATE('2022-06-07 20:54:47', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:54:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586659379760340992, 586659288706195456, '2', 'STARTTLS', 2, 1450756958461300737, TO_DATE('2022-06-07 20:54:56', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:54:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587690415013240832, 587690275439386624, '0', 'App本身', 1, 1450756958461300737, TO_DATE('2022-06-10 17:11:54', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 17:11:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587690459435114496, 587690275439386624, '1', '打开activity', 2, 1450756958461300737, TO_DATE('2022-06-10 17:12:04', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 17:12:04', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587690502590308352, 587690275439386624, '2', '打开浏览器', 3, 1450756958461300737, TO_DATE('2022-06-10 17:12:15', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 17:12:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587690549516181504, 587690275439386624, '3', '打开Intent', 4, 1450756958461300737, TO_DATE('2022-06-10 17:12:26', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 17:12:26', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587956098712215552, 587955865517301760, '0', 'android', 1, 1450756958461300737, TO_DATE('2022-06-11 10:47:38', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:47:38', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587956198599565312, 587955865517301760, '1', 'IOS', 2, 1450756958461300737, TO_DATE('2022-06-11 10:48:01', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:48:01', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587956413003997184, 587955865517301760, '2', '安卓+IOS', 3, 1450756958461300737, TO_DATE('2022-06-11 10:48:53', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:48:53', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587957011560538112, 587956910612029440, '0', '全部', 1, 1450756958461300737, TO_DATE('2022-06-11 10:51:15', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:51:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (587957143559479296, 587956910612029440, '1', 'token', 2, 1450756958461300737, TO_DATE('2022-06-11 10:51:47', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:51:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (608964020338434048, 608963936091643904, 'sms', '短信', 1, 1450756958461300737,TO_DATE('2022-08-08 10:05:36', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:05:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (608964253302661120, 608963936091643904, 'mail', '邮件', 2, 1450756958461300737,TO_DATE('2022-08-08 10:06:32', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:06:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (608964420399538176, 608963936091643904, 'wx_account', '微信公众号', 3, 1450756958461300737,TO_DATE('2022-08-08 10:07:12', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:07:12', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (608964548640382976, 608963936091643904, 'app_push', 'APP通知', 4, 1450756958461300737,TO_DATE('2022-08-08 10:07:42', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:09:24', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (608964730950000640, 608963936091643904, 'app_im', 'IM', 5, 1450756958461300737,TO_DATE('2022-08-08 10:08:26', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:08:26', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (609025100737683456, 608963936091643904, 'notice', '内部通知', 6, 1450756958461300737, TO_DATE('2022-08-08 14:08:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-08-08 14:08:19','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (586260304451870654, 575022217952501760, '1', '待发送', 1, 1450756958461300737, TO_DATE('2022-06-06 18:29:09', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:29:09', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID","TYPE_ID","VALUE","LABEL","SORT","CREATE_TIME","LAST_TIME") VALUES (1450742089393561654,1450742089372590082,'res_rights','数据资源',3,TO_DATE('2022-11-11 10:07:39', 'SYYYY-MM-DD HH24:MI:SS'),TO_DATE('2022-11-11 10:07:39', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID","TYPE_ID","VALUE","LABEL","SORT","CREATOR","CREATE_TIME","LAST_EDITOR","LAST_TIME","BAK_1","BAK_2","BAK_3","PARENT_ID") VALUES (688027377053474816,608963936091643904,'cp','企业微信',7,1450756958461300737,'2023-03-14 14:15:10',1450756958461300737,'2023-03-14 14:15:10',NULL,NULL,NULL,NULL);
INSERT INTO "SYS_DICT_SINGLE"("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES(698464699389583360,608963936091643904,'dingTalk','钉钉',8,1450756958461300737,TO_DATE('2023-04-10 11:54:26', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10 11:54:26', 'SYYYY-MM-DD HH24:MI:SS'),NULL,NULL,NULL,NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (714082823409246208, 714082718056718336, '1', '单行文本', 1, 1450756958461300737, TO_DATE('2023-03-11 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (714082861522886656, 714082718056718336, '2', '多行文本', 2, 1450756958461300737, TO_DATE('2023-03-11 10:44:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:44:10','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (714082900894818304, 714082718056718336, '3', '下拉选择', 3, 1450756958461300737, TO_DATE('2023-03-11 10:44:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:44:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (686887028247502848, 686886958856937472, '1', '零代码', 1, 1450756958461300737, TO_DATE('2023-03-11 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (686887115581300736, 686886958856937472, '2', '低代码', 2, 1450756958461300737, TO_DATE('2023-03-11 10:44:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:44:10','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (686887316178083840, 686886958856937472, '3', '自建应用', 3, 1450756958461300737, TO_DATE('2023-03-11 10:44:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:44:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430081, 714082718056718337, '1', '不重置', 1, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430082, 714082718056718337, '2', '按年重置', 2, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430083, 714082718056718337, '3', '按季度重置', 3, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430084, 714082718056718337, '4', '按月重置', 4, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430085, 714082718056718337, '5', '按周重置', 5, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1684752048320430086, 714082718056718337, '6', '按日重置', 6, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482817, 714082718056718338, 'yyyy', '年', 11, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482818, 714082718056718338, 'yyyyMM', '年月', 12, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482819, 714082718056718338, 'yyyy-MM', '年-月', 13, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482820, 714082718056718338, 'yyyy/MM', '年/月', 14, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482821, 714082718056718338, 'yyyyMMdd', '年月日', 15, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482822, 714082718056718338, 'yyyy-MM-dd', '年-月-日', 16, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482823, 714082718056718338, 'yyyy/MM/dd', '年/月/日', 17, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482824, 714082718056718338, 'yyyyMMddHHmm', '年月日时分', 18, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482825, 714082718056718338, 'yyyyMMddHHmmss', '年月日时分秒', 19, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482826, 714082718056718338, 'MMdd', '月日', 20, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482827, 714082718056718338, 'MM-dd', '月-日', 21, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482828, 714082718056718338, 'MM/dd', '月/日', 22, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1683383216712482829, 714082718056718338, 'HHmmss', '时间', 23, 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (736951458939019264, 736951385576448000, '0', '内部组件', 1, 1450756958461300737, TO_DATE('2023-07-27 14:22:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 14:22:00','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (736951496494817280, 736951385576448000, '1', '外部组件', 2, 1450756958461300737, TO_DATE('2023-07-27 14:22:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 14:22:09','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (737025783427768320, 737025163346059264, '1', '待办', 1, 1450756958461300737, TO_DATE('2023-07-27 19:17:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 19:17:20','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (737025830928261120, 737025163346059264, '2', '日程', 2, 1450756958461300737, TO_DATE('2023-07-27 19:17:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 19:17:31','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (737025877589893120, 737025163346059264, '3', '会议', 3, 1450756958461300737, TO_DATE('2023-07-27 19:17:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 19:17:42','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (737025935500648448, 737025163346059264, '4', '其他', 4, 1450756958461300737, TO_DATE('2023-07-27 19:17:56','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 19:17:56','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1690913474055581697, 686886958856937472, '7', '微应用', 7, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (1450742089393561660, 1450742089372590088, '6', '根据用户所属组织类型分级授予可见范围', 6, NULL, TO_DATE('2021-03-04 14:31:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:31:06','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (811895928742223872, 811895803462557696, '1', '否', 2, 1450756958461300737, TO_DATE('2024-02-19 09:44:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:44:34','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (811895903979053056, 811895803462557696, '0', '是', 1, 1450756958461300737, TO_DATE('2024-02-19 09:44:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:44:28','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (811895869715783680, 811895718649536512, '1', '停用', 2, 1450756958461300737, TO_DATE('2024-02-19 09:44:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:44:20','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_SINGLE" ("DICT_ID", "TYPE_ID", "VALUE", "LABEL", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3", "PARENT_ID") VALUES (811895839013478400, 811895718649536512, '0', '启用', 1, 1450756958461300737, TO_DATE('2024-02-19 09:44:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:44:12','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for SYS_DICT_TYPE
-- ----------------------------

CREATE TABLE "SYS_DICT_TYPE" (
  "TYPE_ID" NUMBER(20)  NOT NULL ,
  "PARENT_ID" NUMBER(20)  DEFAULT NULL,
  "TYPE_NAME" VARCHAR2(384)  DEFAULT NULL,
  "TYPE_DESCRIPTION" VARCHAR2(768)  DEFAULT NULL,
  "RANGE_TYPE" VARCHAR2(768)  DEFAULT NULL,
  "SORT" NUMBER(11)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "BAK_1" VARCHAR2(768)  DEFAULT NULL,
  "BAK_2" VARCHAR2(768)  DEFAULT NULL,
  "BAK_3" VARCHAR2(768)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_DICT_TYPE"."TYPE_ID" IS '主键';
COMMENT ON COLUMN "SYS_DICT_TYPE"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "SYS_DICT_TYPE"."TYPE_NAME" IS '类别名';
COMMENT ON COLUMN "SYS_DICT_TYPE"."TYPE_DESCRIPTION" IS '类别描述';
COMMENT ON COLUMN "SYS_DICT_TYPE"."RANGE_TYPE" IS '编辑类型(系统sys/业务biz)';
COMMENT ON COLUMN "SYS_DICT_TYPE"."SORT" IS '排序';
COMMENT ON COLUMN "SYS_DICT_TYPE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_DICT_TYPE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_DICT_TYPE"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_DICT_TYPE"."LAST_TIME" IS '上次编辑时间';
COMMENT ON COLUMN "SYS_DICT_TYPE"."BAK_1" IS '备用字段1';
COMMENT ON COLUMN "SYS_DICT_TYPE"."BAK_2" IS '备用字段2';
COMMENT ON COLUMN "SYS_DICT_TYPE"."BAK_3" IS '备用字段3';
COMMENT ON TABLE "SYS_DICT_TYPE" IS '字典类型表';

-- ----------------------------
-- Records of "SYS_DICT_TYPE"
-- ----------------------------
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (517670295990181889, 1450384438474231809, 'openType', '页面打开方式', 'biz', 45, 1450756958461300737, NULL, 1450756958461300737, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (794925156320681984, 1450384438474231809, 'msg_contact_type', '消息服务联系人类型', 'biz', 46, NULL, TO_DATE('2024-01-03 13:48:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2024-01-03 13:48:46','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (696315722368032768, 1450384438474231809, 'imp_exp_state', 'excel导入导出状态', 'sys', 43, NULL, TO_DATE('2023-04-06 11:10:05','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2023-04-06 11:10:05','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (673842175301394432, 1450384393200865282, 'encode_dup_pol', '机构编码重复策略', 'sys', 2, 1450756958461300737, TO_DATE('2023-02-03 10:48:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-03 10:48:14','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (676356930893258752, 1450384393200865282, 'import_type', '导入类型', 'sys', 3, 1450756958461300737, TO_DATE('2023-02-10 09:20:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:20:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (676356969782845440, 1450384393200865282, 'export_type', '导出类型', 'sys', 4, 1450756958461300737, TO_DATE('2023-02-10 09:21:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-10 09:21:08','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('517670295990181888', '1450384438474231809', 'opinion_reject', '常用驳回意见', 'biz', '2', '1450756958461300737', TO_DATE('2021-11-29 11:56:56', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-29 11:56:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('523443198920761344', '1450384393200865282', 'res_strategy', '页面类型', 'sys', '41', NULL, TO_DATE('2021-12-15 10:16:24', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 10:16:24', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('524165175805485056', '1450384438474231809', 'noticeType', '公告类型', 'biz', '3', '1450756958461300737', TO_DATE('2021-12-17 10:05:16', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-17 10:05:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590082', '1450384393200865282', 'res_type', '资源类型', 'sys', '30', NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:19:56', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590083', '1450384393200865282', 'menu_type', '菜单开发方式', 'sys', '35', NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-01-30 10:54:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590084', '1450384393200865282', 'is_sys', '系统管理员', 'sys', '2', NULL, TO_DATE('2020-04-09 08:51:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-09 08:51:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590085', '1450384393200865282', 'success_fail', '成功失败', 'sys', '37', NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 15:31:23', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590086', '1450384393200865282', 'user_role_review', '用户角色审核状态', 'sys', '31', NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-14 13:39:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590087', '1450384438474231809', 'common_opinion', '常用意见', 'biz', '1', NULL, TO_DATE('2021-03-10 13:44:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-10 13:45:21', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590088', '1450384393200865282', 'data_scope_type', '数据权限类型', 'sys', '38', NULL, TO_DATE('2021-03-04 14:22:18', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-04 14:22:25', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590089', '1450384393200865282', 'type', '欢迎页配置对象类型', 'sys', '34', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590090', '1450384393200865282', 'account_property', '账号属性', 'sys', '3', NULL, TO_DATE('2020-04-09 08:52:55', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-09 08:52:55', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590091', '1450384438474231809', 'security_level', '数据密级', 'biz', '15', NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-03-16 08:56:13', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590092', '1450384438474231809', 'user_security_level', '用户密级', 'biz', '16', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590093', '1450384438474231809', 'staff_position', '人员职务', 'biz', '14', NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-08-29 17:24:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590094', '1450384393200865282', 'calendar_event_type', '工作日历事件类型', 'sys', '36', NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-02-25 15:38:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590095', '1450384438474231809', 'todo_type', '待办类型', 'biz', '13', NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-20 18:25:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590096', '1450384393200865282', 'levelEvent', '系统/业务级事件', 'sys', '36', NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-19 11:33:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590097', '1450384393200865282', 'account_state', '账户状态', 'sys', '1', NULL, TO_DATE('2020-04-09 08:51:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-04-16 12:17:51', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590098', '1450384393200865282', 'sex', '性别', 'sys', '18', NULL, TO_DATE('2018-04-11 14:10:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:10:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE"("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES ('1450742089372590099', '1450384393200865282', 'yes_no', '是/否', 'sys', '29', NULL, TO_DATE('2018-04-11 14:10:08', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-11 14:10:08', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (591913311474556928, 1450384438474231809, 'statistics_top', '统计排名数量', 'biz', 4, 1450756958461300737, TO_TIMESTAMP('2022-06-22 08:52:11.000000', 'SYYYY-MM-DD HH24:MI:SS:FF6'), '1450756958461300737', TO_TIMESTAMP('2022-06-22 08:52:11.000000', 'SYYYY-MM-DD HH24:MI:SS:FF6'));
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (575022217952501760, 1450384438474231809, 'msg_send_status', '消息发送状态', 'biz', 4, 1450756958461300737, TO_DATE('2022-05-06 18:13:00', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:28:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (586233551075418112, 1450384438474231809, 'sms_channel_type', '短信服务通道类型', 'biz', 5, 1450756958461300737, TO_DATE('2022-06-06 16:42:50', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 16:42:50', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (586262390337970176, 1450384438474231809, 'msg_is_enable', '消息通用是否启用', 'biz', 6, 1450756958461300737, TO_DATE('2022-06-06 18:37:26', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:41:39', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (586658891807596544, 1450384438474231809, 'mail_protocol', '邮箱协议', 'biz', 7, 1450756958461300737, TO_DATE('2022-06-07 20:52:59', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:52:59', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (586659288706195456, 1450384438474231809, 'mail_safe_type', '邮箱安全类型', 'biz', 8, 1450756958461300737, TO_DATE('2022-06-07 20:54:34', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-07 20:54:34', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (587690275439386624, 1450384438474231809, 'app_action_type', '消息推送动作类型', 'biz', 9, 1450756958461300737, TO_DATE('2022-06-10 17:11:20', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 17:11:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (587955865517301760, 1450384438474231809, 'platform_type', '接收平台', 'biz', 10, 1450756958461300737, TO_DATE('2022-06-11 10:46:42', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (587956910612029440, 1450384438474231809, 'push_scope', '推送范围', 'biz', 11, 1450756958461300737, TO_DATE('2022-06-11 10:50:51', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 10:50:51', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (608963936091643904, 1450384438474231809, 'msg_service_type', '消息服务发送类型', 'biz', 12, 1450756958461300737,TO_DATE('2022-08-08 10:05:16', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737,TO_DATE('2022-08-08 10:05:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (714082718056718336, 1450384393200865282, 'res_expand_type', '资源类型扩展属性类型', 'sys', 42, 1450756958461300737, TO_DATE('2023-03-11 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:43:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (686886958856937472, 1450384438474231809, 'app_type', '应用类型', 'biz', 17, 1450756958461300737, TO_DATE('2023-03-11 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-11 10:43:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (714082718056718337, 1450384393200865282, 'reset_period', '重置周期', 'sys', 43, 1450756958461300737, TO_DATE('2023-07-28 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (714082718056718338, 1450384393200865282, 'date_pattern', '日期格式', 'sys', 44, 1450756958461300737, TO_DATE('2023-07-28 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-28 10:43:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (736951385576448000, 1450384393200865282, 'assembly_type', '组件类型', 'sys', 44, 1450756958461300737, TO_DATE('2023-07-27 14:21:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 14:21:42','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (737025163346059264, 1450384438474231809, 'message_type', '消息类型', 'biz', 45, 1450756958461300737, TO_DATE('2023-07-27 19:14:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-27 19:14:52','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (811895803462557696, 1450384438474231809, 'yes_no_close', '横幅是否能关闭', 'biz', 47, 1450756958461300737, TO_DATE('2024-02-19 09:44:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:44:04','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);
INSERT INTO "SYS_DICT_TYPE" ("TYPE_ID", "PARENT_ID", "TYPE_NAME", "TYPE_DESCRIPTION", "RANGE_TYPE", "SORT", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "BAK_1", "BAK_2", "BAK_3") VALUES (811895718649536512, 1450384438474231809, 'advertisementStatus', '广告启用状态', 'biz', 46, 1450756958461300737, TO_DATE('2024-02-19 09:43:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:43:44','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, NULL);


-- ----------------------------
-- Table structure for SYS_FILE_INFO
-- ----------------------------

CREATE TABLE "SYS_FILE_INFO" (
  "FILE_ID" NUMBER(20)  NOT NULL ,
  "ATTACHMENT_NAME" VARCHAR2(768)  DEFAULT NULL,
  "ATTACHMENT_DIR" VARCHAR2(1536)  DEFAULT NULL,
  "ATTACHMENT_TYPE" VARCHAR2(768)  DEFAULT NULL,
  "UPLOAD_PER" NUMBER(20)  DEFAULT NULL,
  "UPLOAD_DATE" TIMESTAMP(6)  DEFAULT NULL,
  "BUSINESS_ID" NUMBER(20)  DEFAULT NULL,
  "FILE_TYPE" VARCHAR2(150)  DEFAULT NULL,
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "CREATOR" NUMBER(20) DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP (6) DEFAULT NULL,
  "LAST_EDITOR" NUMBER DEFAULT NULL,
  "LAST_TIME" TIMESTAMP (6) DEFAULT NULL
)
;
COMMENT ON TABLE SYS_FILE_INFO IS '附件信息表';
COMMENT ON COLUMN SYS_FILE_INFO.FILE_ID IS '主键';
COMMENT ON COLUMN SYS_FILE_INFO.ATTACHMENT_NAME IS '附件名称';
COMMENT ON COLUMN SYS_FILE_INFO.ATTACHMENT_DIR IS '附件路径';
COMMENT ON COLUMN SYS_FILE_INFO.ATTACHMENT_TYPE IS '附件类型';
COMMENT ON COLUMN SYS_FILE_INFO.UPLOAD_PER IS '上传人';
COMMENT ON COLUMN SYS_FILE_INFO.UPLOAD_DATE IS '上传时间';
COMMENT ON COLUMN SYS_FILE_INFO.BUSINESS_ID IS '业务ID  ';
COMMENT ON COLUMN SYS_FILE_INFO.FILE_TYPE IS '类型';
COMMENT ON COLUMN SYS_FILE_INFO.SEQ IS '排序字段';
COMMENT ON COLUMN SYS_FILE_INFO.CREATOR IS '创建人';
COMMENT ON COLUMN SYS_FILE_INFO.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN SYS_FILE_INFO.LAST_EDITOR IS '最后一次更新人';
COMMENT ON COLUMN SYS_FILE_INFO.LAST_TIME IS '最后一次更新时间';
-- ----------------------------
-- Table structure for SYS_FILE_RELATION
-- ----------------------------

CREATE TABLE "SYS_FILE_RELATION" (
  "RELATION_ID" NUMBER(20) NOT NULL ,
  "BUSINESS_ID" VARCHAR2(192) DEFAULT NULL ,
  "FILE_ID" NUMBER(20) NOT NULL ,
  "ATTACHMENT_NAME" VARCHAR2(255) DEFAULT NULL,
  "ATTACHMENT_TYPE" VARCHAR2(255) DEFAULT NULL,
  "TYPE" VARCHAR2(64) DEFAULT NULL,
  "SEQ" NUMBER(10) DEFAULT NULL,
  "CREATOR" NUMBER(20) DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6) DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20) DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6) DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_FILE_RELATION"."RELATION_ID" IS '关联关系ID';
COMMENT ON COLUMN "SYS_FILE_RELATION"."BUSINESS_ID" IS '业务ID';
COMMENT ON COLUMN "SYS_FILE_RELATION"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "SYS_FILE_RELATION"."ATTACHMENT_NAME" IS '附件名称';
COMMENT ON COLUMN "SYS_FILE_RELATION"."ATTACHMENT_TYPE" IS '附件类型';
COMMENT ON COLUMN "SYS_FILE_RELATION"."TYPE" IS '分类类型';
COMMENT ON COLUMN "SYS_FILE_RELATION"."SEQ" IS '排序字段';
COMMENT ON COLUMN "SYS_FILE_RELATION"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_FILE_RELATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_FILE_RELATION"."LAST_EDITOR" IS '最后一次修改人';
COMMENT ON COLUMN "SYS_FILE_RELATION"."LAST_TIME" IS '最后一次修改时间';
COMMENT ON TABLE "SYS_FILE_RELATION" IS '附件关联关系表';

-- ----------------------------
-- Primary Key structure for table SYS_FILE_RELATION
-- ----------------------------
ALTER TABLE "SYS_FILE_RELATION" ADD CONSTRAINT "SYS_C00179352" PRIMARY KEY ("RELATION_ID");

-- ----------------------------
-- Checks structure for table SYS_FILE_RELATION
-- ----------------------------
ALTER TABLE "SYS_FILE_RELATION" ADD CONSTRAINT "SYS_C00179350" CHECK ("RELATION_ID" IS NOT NULL) ;
ALTER TABLE "SYS_FILE_RELATION" ADD CONSTRAINT "SYS_C00179351" CHECK ("FILE_ID" IS NOT NULL) ;
-- ----------------------------
-- Table structure for SYS_FUNCTION_MODULES
-- ----------------------------

CREATE TABLE "SYS_FUNCTION_MODULES" (
  "FUNCTION_MODULE_ID" NUMBER(20)  NOT NULL ,
  "FUNCTION_MODULE_NAME" VARCHAR2(384)  NOT NULL ,
  "FUNCTION_MODULE_CODE" VARCHAR2(96)  DEFAULT NULL,
  "PARENT_MODULE_ID" NUMBER(20)  DEFAULT NULL,
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "APPLICATION_ID" NUMBER(20,0) DEFAULT 1
);
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."FUNCTION_MODULE_ID" IS '功能模块ID';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."FUNCTION_MODULE_NAME" IS '模块名称';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."FUNCTION_MODULE_CODE" IS '模块编码';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."PARENT_MODULE_ID" IS '上级模块ID';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."SEQ" IS '模块排序';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."LAST_EDITOR" IS '最后修改人';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_FUNCTION_MODULES"."APPLICATION_ID" IS '所属应用的id，默认1：属于平台自身数据';
COMMENT ON TABLE "SYS_FUNCTION_MODULES" IS '功能模块表';

-- ----------------------------
-- Records of "SYS_FUNCTION_MODULES"
-- ----------------------------
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686146937447260160, '应用管理', NULL, 1, 14, 1450756958461300737, TO_DATE('2023-03-09 09:42:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:42:58','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811595767054868480, '联系人管理', NULL, 576395008970858496, 10, 1450756958461300737, TO_DATE('2024-02-18 13:51:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-18 13:51:50','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('521403976781144064', '统一待办', NULL, '1', '12', '1450756958461300737', TO_DATE('2021-12-09 19:13:15', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-09 19:13:15', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523176320419766272', '组织权限中心', NULL, '1', '1', '1450756958461300737', TO_DATE('2021-12-14 16:35:55', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523198001884438528', '用户管理', NULL, '523176320419766272', '2', '1450756958461300737', TO_DATE('2021-12-14 18:02:04', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 18:02:04', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523209654097158144', '门户配置中心', NULL, '1', '2', '1450756958461300737', TO_DATE('2021-12-14 18:48:22', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523213269419433984', '开发者中心', NULL, '1', '5', '1450756958461300737', TO_DATE('2021-12-14 19:02:44', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523213321676267520', '功能资源', NULL, '523176320419766272', '4', '1450756958461300737', TO_DATE('2021-12-14 19:02:57', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:02:57', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523213802016350208', '系统参数', NULL, '523213269419433984', '3', '1450756958461300737', TO_DATE('2021-12-14 19:04:51', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:04:51', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523215032922939392', '运维监控中心', NULL, '1', '6', '1450756958461300737', TO_DATE('2021-12-14 19:09:45', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523215083967619072', '运维工具', NULL, '523215032922939392', '1', '1450756958461300737', TO_DATE('2021-12-14 19:09:57', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:09:57', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523215114078527488', '平台监控', NULL, '523215032922939392', '2', '1450756958461300737', TO_DATE('2021-12-14 19:10:04', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:10:04', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523215142994059264', '平台日志', NULL, '523215032922939392', '3', '1450756958461300737', TO_DATE('2021-12-14 19:10:11', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:10:11', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('523217792733028352', '缓存监控', NULL, '523215114078527488', '1', '1450756958461300737', TO_DATE('2021-12-14 19:20:43', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:20:43', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('526077391123259392', '公告', NULL, '1', '11', '1450756958461300737', TO_DATE('2021-12-22 16:43:44', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-22 16:43:44', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('528155915363557376', '统一待办', NULL, '523213269419433984', '4', NULL, TO_DATE('2021-12-28 10:23:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-28 10:23:03', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450764807862095873', '个人事项', NULL, '1', '9', NULL, NULL, '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450764807862095875', '流程中心', NULL, '1', '3', NULL, TO_DATE('2021-06-20 14:30:57', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 19:11:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450764807862095884', '角色管理', NULL, '523176320419766272', '3', NULL, NULL, NULL, NULL);
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450764807862095885', '组织机构', NULL, '523176320419766272', '1', NULL, NULL, NULL, NULL);
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('587696011380793344', '流程分析', NULL, '1450764807862095875', '1', '1450756958461300737', TO_DATE('2021-04-07 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-04-07 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('545564987515740160', '统一日志', NULL, '523215142994059264', '13', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('592400770314543104', '日志告警', NULL, '523215114078527488', '2', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('595572248216346624', '移动门户配置', NULL, '523209654097158144', '1', '1450756958461300737',TO_DATE('2022-07-02 11:20:29', 'SYYYY-MM-DD HH24:MI:SS'),'1450756958461300737',TO_DATE('2022-07-02 11:20:29', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576395008970858496, '消息中心', NULL, 1, 13, 1450756958461300737, TO_DATE('2022-05-10 13:07:59', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 13:07:59', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447319827030016, '短信推送', NULL, 576395008970858496, 1, 1450756958461300737, TO_DATE('2022-05-10 16:35:51', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:35:51', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (577911145198002176, '邮件推送', NULL, 576395008970858496, 2, 1450756958461300737, TO_DATE('2022-05-14 17:32:34', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-14 17:32:34', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578225558232768512, '微信公众号推送', NULL, 576395008970858496, 3, 1450756958461300737, TO_DATE('2022-05-15 14:21:56', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:21:56', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579402387463348224, 'IM推送', NULL, 576395008970858496, 4, 1450756958461300737, TO_DATE('2022-05-18 20:18:14', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:18:14', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579407339665498112, 'APP通知推送', NULL, 576395008970858496, 5, 1450756958461300737, TO_DATE('2022-05-18 20:37:55', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:37:55', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (596353922000756736, '应用管理', NULL, 576395008970858496, 7, 1450756958461300737, TO_DATE('2022-07-04 14:57:35', 'SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-04 14:57:35', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (587709613621911552, '内部通知推送', NULL, 576395008970858496, 6, 1450756958461300737, TO_DATE('2022-06-10 18:28:11','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:11','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('641243779856343040', '数据迁移', NULL, '523215032922939392', '4', '1450756958461300737', TO_DATE('2022-11-05 11:53:51', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-11-05 11:53:51', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686176268227715072, '企业微信推送', null, 576395008970858496, 8, 1450756958461300737, '2023-03-09 11:39:31', 1450756958461300737, '2023-03-09 11:39:31');
INSERT INTO "SYS_FUNCTION_MODULES"("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (697761878826557440,'钉钉推送',NULL,576395008970858496,9,1450756958461300737,TO_DATE('2023-04-10 11:54:26', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10 11:54:26', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738862247950163968, '新闻资讯', NULL, 1, 15, 1450756958461300737, TO_DATE('2023-08-01 20:54:47','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:54:47','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815518957997137920, '分级管理', NULL, 1, 19, 1450756958461300737, TO_DATE('2024-02-29 09:41:11','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 09:41:11','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299436459859968, '角色管理', NULL, 1, 18, 1450756958461300737, TO_DATE('2024-02-28 19:08:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:08:53','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299390616117248, '用户管理', NULL, 1, 17, 1450756958461300737, TO_DATE('2024-02-28 19:08:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:08:42','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299121857699840, '人员管理', NULL, 815286440933203968, 2, 1450756958461300737, TO_DATE('2024-02-28 19:07:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:07:38','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299096469577728, '组织管理', NULL, 815286440933203968, 1, 1450756958461300737, TO_DATE('2024-02-28 19:07:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:07:32','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTION_MODULES" ("FUNCTION_MODULE_ID", "FUNCTION_MODULE_NAME", "FUNCTION_MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815286440933203968, '组织机构', NULL, 1, 16, 1450756958461300737, TO_DATE('2024-02-28 18:17:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 18:17:15','SYYYY-MM-DD HH24:MI:SS'), 1);

-- ----------------------------
-- Table structure for SYS_FUNCTION_RESOURCES
-- ----------------------------

CREATE TABLE "SYS_FUNCTION_RESOURCES" (
  "SFR_ID" NUMBER(20,0)  NOT NULL,
  "FUNCTION_ID" NUMBER(20,0)  DEFAULT NULL,
  "RESOURCE_ID" NUMBER(20,0)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."SFR_ID" IS '主键';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."FUNCTION_ID" IS '功能id';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."RESOURCE_ID" IS '资源id';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."LAST_EDITOR" IS '最后修改人';
COMMENT ON COLUMN "SYS_FUNCTION_RESOURCES"."LAST_TIME" IS '最后修改时间';
COMMENT ON TABLE "SYS_FUNCTION_RESOURCES" IS '功能资源关系表';

-- ----------------------------
-- Records of "SYS_FUNCTION_RESOURCES"
-- ----------------------------
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (833743802140467200, 688350053471100928, 829409027523092480, 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'), 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (833743802165633024, 688350053471100928, 829409275322572800, 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'), 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (833743802182410242, 688350053471100928, 829409533184188416, 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'), 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (833743802207576065, 688350053471100928, 829409805990109184, 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'), 1450757642371981314, TO_DATE('2024-04-19 16:40:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417729, 811595871216214016, 830797745085489152, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417728, 811595871216214016, 830771482190946304, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207357612032, 811595871216214016, 830797989605023744, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (819883353754050560, 819883353598861312, 819882932406853632, 1450756958461300737, TO_DATE('2024-03-12 10:43:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:44','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (819883304802328576, 819883304701665280, 819882466553896960, 1450756958461300737, TO_DATE('2024-03-12 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (819883211244183552, 819883211101577216, 819882250383663104, 1450756958461300737, TO_DATE('2024-03-12 10:43:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:10','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (819883155770318848, 819883155535437824, 819881531945525248, 1450756958461300737, TO_DATE('2024-03-12 10:42:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:42:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (819883084001583104, 819883083649261568, 819881890768232448, 1450756958461300737, TO_DATE('2024-03-12 10:42:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:42:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (813348971945926656, 813348971400667136, 813348818371485696, 1450756958461300737, TO_DATE('2024-02-23 09:58:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-23 09:58:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811595871555952640, 811595871216214016, 811594293004476416, 1450756958461300737, TO_DATE('2024-02-18 13:52:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-18 13:52:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (32237820183288250, 518460834717114368, 518451664789970944, 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1722420405944111400, 521404105277841408, 521403853758013440, 1450756958461300737, TO_DATE('2021-12-09 19:13:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-09 19:13:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3456659651549261300, 522705551881412608, 522705027572441088, 1450756958461300737, TO_DATE('2021-12-14 14:57:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 14:57:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4034857885755173400, 523555260388876288, 523554762252361728, 1450756958461300737, TO_DATE('2021-12-15 17:41:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:41:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6056936221124455000, 523555376986333184, 523555173533229056, 1450756958461300737, TO_DATE('2021-12-15 17:42:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:42:09','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2675691861322455000, 1450764807862095892, 1450765592889004053, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8863128065406379000, 1450764807862095892, 1450765592889004073, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6126027114815556000, 1450764807862095892, 1450765592889004124, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7416473689547601000, 1450764807862095892, 1450765592889004134, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8439927452148045000, 1450764807862095892, 1450765592889004153, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6350019966416328000, 1450764807862095892, 1450765592889004161, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4380869385156113000, 1450764807862095892, 1450765592889004180, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2350991115796637000, 1450764807862095892, 1450765592889004198, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8012986635398130000, 1450764807862095892, 1450765592889004199, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1024815990010686600, 1450764807862095892, 1450765592889004208, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8947485567372642000, 1450764807862095892, 1450765592889004223, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104081375053000, 1450764807862095892, 1450765592889004265, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (575357532137176200, 1450764807862095892, 1450765592889004295, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3418857910558641700, 1450764807862095892, 1450765592889004342, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4576799101076076000, 1450764807862095892, 1450765592889004363, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6812247779918563000, 1450764807862095892, 1450765592889004394, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3863961531827612700, 1450764807862095892, 1450765592889004502, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5119290133561532000, 1450764807862095892, 1450765592889004508, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4308021991970837500, 1450764807862095892, 1450765592889004521, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6717269891976873000, 1450764807862095892, 1450765592889004539, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4835048994508317000, 1450764807862095892, 1450765592889004564, NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4079944889739185700, 1450764807862095893, 1450765592889004145, NULL, TO_DATE('2021-06-23 06:14:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:14:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2001752727345160200, 1450764807862095895, 1450765592889004088, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2763711700881510000, 1450764807862095895, 1450765592889004115, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4730137761740278000, 1450764807862095895, 1450765592889004182, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1611428150808649200, 1450764807862095895, 1450765592889004258, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7074915702170057000, 1450764807862095895, 1450765592889004403, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5134544632455492000, 1450764807862095895, 1450765592889004470, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4979109948089132000, 1450764807862095895, 1450765592889004479, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3547068516515780600, 1450764807862095895, 1450765592889004482, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3337785656271825000, 1450764807862095895, 1450765592889004545, NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6705684025738846000, 1450764807862095898, 1450765592889004351, NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4200131811592521700, 1450764807862095898, 1450765592889004457, NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6666537997161930000, 1450764807862095898, 1450765592889004570, NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:50:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (661080598474130600, 1450764807862095900, 1450765592889004354, NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6664171536439597000, 1450764807862095900, 1450765592889004413, NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6404336320549082000, 1450764807862095900, 1450765592889004449, NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3978095210430011400, 1450764807862095901, 1450765592889004039, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7895079182739348000, 1450764807862095901, 1450765592889004052, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6858095515455579000, 1450764807862095901, 1450765592889004098, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (759512770441751700, 1450764807862095901, 1450765592889004101, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3919369046349748000, 1450764807862095901, 1450765592889004147, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4687047599491193000, 1450764807862095901, 1450765592889004156, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1816566663599248600, 1450764807862095901, 1450765592889004214, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2053750865712595000, 1450764807862095901, 1450765592889004218, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8178708544219443000, 1450764807862095901, 1450765592889004220, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8638460920863153000, 1450764807862095901, 1450765592889004230, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3572596697533797000, 1450764807862095901, 1450765592889004247, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1535231780077067500, 1450764807862095901, 1450765592889004252, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6403442468784465000, 1450764807862095901, 1450765592889004278, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2277101967303453700, 1450764807862095901, 1450765592889004292, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8067857347671430000, 1450764807862095901, 1450765592889004307, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8918716561201663000, 1450764807862095901, 1450765592889004308, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (925046692895840500, 1450764807862095901, 1450765592889004309, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4848715528255667000, 1450764807862095901, 1450765592889004329, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6851168973091814000, 1450764807862095901, 1450765592889004337, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7559436617647481000, 1450764807862095901, 1450765592889004344, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6452163899984276000, 1450764807862095901, 1450765592889004349, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6611140817864900000, 1450764807862095901, 1450765592889004369, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (236330564504039000, 1450764807862095901, 1450765592889004397, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (318047442350762900, 1450764807862095901, 1450765592889004404, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8770056328260917000, 1450764807862095901, 1450765592889004410, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1892684453589602300, 1450764807862095901, 1450765592889004460, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (272000448824307070, 1450764807862095901, 1450765592889004465, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5200507840943897000, 1450764807862095901, 1450765592889004473, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1935980527337025300, 1450764807862095901, 1450765592889004485, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5780367496094840000, 1450764807862095901, 1450765592889004488, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7848878822335752000, 1450764807862095901, 1450765592889004529, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1508557304661880000, 1450764807862095901, 1450765592889004544, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4258920424145072600, 1450764807862095901, 1450765592889004565, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1641743113031370800, 1450764807862095901, 1450765592889004567, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3546198106165265400, 1450764807862095901, 1450765592889004572, NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4661488089173200000, 1450764807862095902, 1450765592889004075, NULL, TO_DATE('2021-06-23 05:39:59','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:39:59','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2551110856072753000, 1450764807862095902, 1450765592889004332, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5983524870074011000, 1450764807862095902, 1450765592889004378, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1598059929234802000, 1450764807862095902, 1450765592889004434, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2261349797125141500, 1450764807862095902, 1450765592889004469, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1510738435591924000, 1450764807862095902, 1450765592889004526, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8737063662919945000, 1450764807862095902, 1450765592889004546, NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7899135802588070000, 1450764807862095904, 1450765592889004453, NULL, TO_DATE('2021-06-23 06:14:10','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:14:10','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7913802952827491000, 1450764807862095905, 1450765592889004221, NULL, TO_DATE('2021-06-23 06:12:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:12:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (508885334026323100, 1450764807862095908, 1450765592889004059, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (163060532147892830, 1450764807862095908, 1450765592889004060, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (294649254804114900, 1450764807862095908, 1450765592889004069, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2254196369901174000, 1450764807862095908, 1450765592889004082, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7728658222107044000, 1450764807862095908, 1450765592889004121, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (494169743728983600, 1450764807862095908, 1450765592889004152, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2849541863202725000, 1450764807862095908, 1450765592889004160, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5124600442603036000, 1450764807862095908, 1450765592889004186, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8121326732469579000, 1450764807862095908, 1450765592889004222, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3882497652435606500, 1450764807862095908, 1450765592889004261, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3997485965338456600, 1450764807862095908, 1450765592889004283, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2247825399754617000, 1450764807862095908, 1450765592889004305, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4599933527961134600, 1450764807862095908, 1450765592889004348, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8414710152159558000, 1450764807862095908, 1450765592889004400, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8094061504457990000, 1450764807862095908, 1450765592889004409, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3394135695792329000, 1450764807862095908, 1450765592889004411, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1212672447438331000, 1450764807862095908, 1450765592889004440, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8560989646778335000, 1450764807862095908, 1450765592889004533, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5775284664514161000, 1450764807862095908, 1450765592889004571, NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1760159323208247800, 1450764807862095909, 1450765592889004045, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6997203452672896000, 1450764807862095909, 1450765592889004062, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7256505380841301000, 1450764807862095909, 1450765592889004064, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4355312469684564000, 1450764807862095909, 1450765592889004080, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1794950929770545200, 1450764807862095909, 1450765592889004143, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7358975816373811000, 1450764807862095909, 1450765592889004144, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7385579669169596000, 1450764807862095909, 1450765592889004149, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4375738080934397000, 1450764807862095909, 1450765592889004171, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6133790374255563000, 1450764807862095909, 1450765592889004183, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7796016520957238000, 1450764807862095909, 1450765592889004189, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8362261482291111000, 1450764807862095909, 1450765592889004204, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7886632004074359000, 1450764807862095909, 1450765592889004206, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1971658812158312200, 1450764807862095909, 1450765592889004211, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1983410821071978500, 1450764807862095909, 1450765592889004237, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5279185567531117000, 1450764807862095909, 1450765592889004269, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6596951099630954000, 1450764807862095909, 1450765592889004281, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815322049257875000, 1450764807862095909, 1450765592889004311, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2910762183986358000, 1450764807862095909, 1450765592889004330, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4880598817213345000, 1450764807862095909, 1450765592889004333, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (466427385931388540, 1450764807862095909, 1450765592889004364, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7182817657769566000, 1450764807862095909, 1450765592889004368, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7389982661807500000, 1450764807862095909, 1450765592889004391, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7394145152272608000, 1450764807862095909, 1450765592889004417, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4488231002449490400, 1450764807862095909, 1450765592889004422, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5579798555817354000, 1450764807862095909, 1450765592889004432, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (778696738678466700, 1450764807862095909, 1450765592889004433, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3780467269874520600, 1450764807862095909, 1450765592889004443, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (214974206552515740, 1450764807862095909, 1450765592889004452, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5074963679667732000, 1450764807862095909, 1450765592889004472, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8118170614398197000, 1450764807862095909, 1450765592889004501, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2108797039676104200, 1450764807862095909, 1450765592889004503, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6500307152796450000, 1450764807862095909, 1450765592889004512, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6213297702754915000, 1450764807862095909, 1450765592889004516, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7649029061287673000, 1450764807862095909, 1450765592889004536, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1609518816656995000, 1450764807862095909, 1450765592889004555, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (120507322691962850, 1450764807862095909, 1450765592889004566, NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:41:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (893715496294441100, 1450764807862095910, 1450765592889004239, NULL, TO_DATE('2021-06-23 05:47:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8508944291857246000, 1450764807862095911, 1450765592889004137, NULL, TO_DATE('2021-06-23 06:02:54','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:02:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8506041280497158000, 1450764807862095911, 1450765592889004407, NULL, TO_DATE('2021-06-23 06:02:54','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:02:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4542974900865503000, 1450764807862095913, 1450765592889004178, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (300339249092257150, 1450764807862095913, 1450765592889004187, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5537901247811356000, 1450764807862095913, 1450765592889004207, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6293763916192614000, 1450764807862095913, 1450765592889004212, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4563519735709766700, 1450764807862095913, 1450765592889004277, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3070615836658059300, 1450764807862095913, 1450765592889004286, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7938159816852189000, 1450764807862095913, 1450765592889004291, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5378786281442386000, 1450764807862095913, 1450765592889004310, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3716421673354175500, 1450764807862095913, 1450765592889004382, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7877986980722596000, 1450764807862095913, 1450765592889004384, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5203434114666971000, 1450764807862095913, 1450765592889004421, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5083358887821602000, 1450764807862095913, 1450765592889004530, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8685902543222044000, 1450764807862095913, 1450765592889004563, NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:48:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6580298633325908000, 1450764807862095915, 1450765592889004141, NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8497553308423673000, 1450764807862095915, 1450765592889004390, NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7230387419835086000, 1450764807862095915, 1450765592889004486, NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7141152941257222000, 1450764807862095915, 1450765592889004569, NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:43:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1179074570130030800, 1450764807862095917, 1450765592889004274, NULL, TO_DATE('2021-08-31 16:20:43','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:20:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (690446705260763500, 1450764807862095919, 1450765592889004065, NULL, TO_DATE('2021-09-26 11:12:43','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-09-26 11:12:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3670961758260140000, 1450764807862095920, 1450765592889004293, NULL, TO_DATE('2021-06-23 06:12:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:12:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4470818163916753400, 1450764807862095920, 1450765592889004513, NULL, TO_DATE('2021-06-23 06:12:41','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:12:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4173951114598774000, 1450764807862095921, 1450765592889004047, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4002368119826934300, 1450764807862095921, 1450765592889004087, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6922950729674101000, 1450764807862095921, 1450765592889004120, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4033234240426174000, 1450764807862095921, 1450765592889004138, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3789118980178759700, 1450764807862095921, 1450765592889004257, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2875241465125512000, 1450764807862095921, 1450765592889004297, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6686584550031459000, 1450764807862095921, 1450765592889004313, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6479487786698256000, 1450764807862095921, 1450765592889004322, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3271590496898312700, 1450764807862095921, 1450765592889004357, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8785198093272620000, 1450764807862095921, 1450765592889004358, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5753118426347250000, 1450764807862095921, 1450765592889004395, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5539196970889990000, 1450764807862095921, 1450765592889004437, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (642422504664865500, 1450764807862095921, 1450765592889004487, NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:47:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7259306706210482000, 1450764807862095922, 1450765592889004167, NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5315053896876473000, 1450764807862095922, 1450765592889004270, NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8954866636099882000, 1450764807862095922, 1450765592889004284, NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8899633434905354000, 1450764807862095922, 1450765592889004383, NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2639040774009679000, 1450764807862095922, 1450765592889004499, NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8165649929085861000, 1450764807862095923, 1450765592889004037, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3471488454024111000, 1450764807862095923, 1450765592889004168, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3342881980036192000, 1450764807862095923, 1450765592889004179, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1330650432024310800, 1450764807862095923, 1450765592889004213, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1326980394770590500, 1450764807862095923, 1450765592889004338, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7888362631300701000, 1450764807862095923, 1450765592889004366, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4035590223857203700, 1450764807862095923, 1450765592889004401, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (299149563277391300, 1450764807862095923, 1450765592889004406, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1855419488169778700, 1450764807862095923, 1450765592889004477, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5932931091979795000, 1450764807862095923, 1450765592889004481, NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:45:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8434139141342351000, 1450764807862095924, 1450765592889004226, NULL, TO_DATE('2021-06-23 06:40:15','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:40:15','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (297800635119875200, 1450764807862095925, 1450765592889004146, NULL, TO_DATE('2021-06-23 06:12:11','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:12:11','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1623971115387953400, 1450764807862095927, 1450765592889004150, NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2926712170783723500, 1450764807862095927, 1450765592889004201, NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (621819116948449000, 1450764807862095927, 1450765592889004414, NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7395345460225237000, 1450764807862095927, 1450765592889004456, NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5386981152578304000, 1450764807862095927, 1450765592889004558, NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:49:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6667030653375144000, 1450764807862095928, 1450765592889004119, NULL, TO_DATE('2021-08-31 16:21:31','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1665473748921275000, 1450764807862095928, 1450765592889004507, NULL, TO_DATE('2021-08-31 16:21:31','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4994826914933570000, 1450764807862095929, 1450765592889004067, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7295346128432285000, 1450764807862095929, 1450765592889004159, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6444057545505071000, 1450764807862095929, 1450765592889004235, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3027745323871259000, 1450764807862095929, 1450765592889004285, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3742774354435161600, 1450764807862095929, 1450765592889004461, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4327413024116248000, 1450764807862095929, 1450765592889004515, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4511432183335675400, 1450764807862095929, 1450765592889004522, NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:09:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1702621000111275000, 1450764807862095930, 1450765592889004169, NULL, TO_DATE('2021-06-23 05:44:28','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:44:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3323187159654631400, 1450764807862095930, 1450765592889004454, NULL, TO_DATE('2021-06-23 05:44:28','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:44:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7842911870199263000, 1450764807862095931, 1450765592889004089, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3818813244593985500, 1450764807862095931, 1450765592889004118, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7545485682063677000, 1450764807862095931, 1450765592889004122, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2055963100124195000, 1450764807862095931, 1450765592889004148, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3004160705449305600, 1450764807862095931, 1450765592889004181, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1183947773569380600, 1450764807862095931, 1450765592889004193, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6165537920642976000, 1450764807862095931, 1450765592889004288, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7228419466900020000, 1450764807862095931, 1450765592889004302, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1897763020833517800, 1450764807862095931, 1450765592889004427, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1936536466301772800, 1450764807862095931, 1450765592889004510, NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:40:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (610834561866679300, 1450764807862095933, 1450765592889004356, NULL, TO_DATE('2021-06-23 06:40:33','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:40:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8159978062320227000, 1450764807862095934, 1450765592889004074, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8710185231025143000, 1450764807862095934, 1450765592889004176, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1422356362072164600, 1450764807862095934, 1450765592889004200, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2581174052246643700, 1450764807862095934, 1450765592889004347, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6633164977338520000, 1450764807862095934, 1450765592889004445, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2405765205128211500, 1450764807862095934, 1450765592889004493, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3431550087968561000, 1450764807862095934, 1450765592889004509, NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:03:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6770589361246581000, 1450764807862095935, 1450765592889004240, NULL, TO_DATE('2021-06-23 06:13:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:13:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3555724846944758300, 1450764807862095936, 1450765592889004061, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4179567030624378000, 1450764807862095936, 1450765592889004066, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1892238538100658700, 1450764807862095936, 1450765592889004105, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3059897388336372700, 1450764807862095936, 1450765592889004151, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3430456294464035300, 1450764807862095936, 1450765592889004224, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4151834519846344000, 1450764807862095936, 1450765592889004325, NULL, TO_DATE('2021-06-23 06:04:20','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:20','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8587248683938692000, 1450764807862095936, 1450765592889004327, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2171968905502825500, 1450764807862095936, 1450765592889004371, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2079261246918037200, 1450764807862095936, 1450765592889004462, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4188983321143105500, 1450764807862095936, 1450765592889004466, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2203063968551473700, 1450764807862095936, 1450765592889004556, NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1146973097038787500, 1450764807862095937, 1450765592889004085, NULL, TO_DATE('2021-06-23 06:39:32','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:39:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1984480780663197200, 1450764807862095938, 1450765592889004119, NULL, TO_DATE('2021-08-31 16:21:14','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1534132577012168200, 1450764807862095938, 1450765592889004517, NULL, TO_DATE('2021-08-31 16:21:14','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3415638094144259000, 1450764807862095939, 1450765592889004112, NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8664349155821196000, 1450764807862095939, 1450765592889004173, NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8704223561487048000, 1450764807862095939, 1450765592889004444, NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8315259855418958000, 1450764807862095939, 1450765592889004519, NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6315047255856710000, 1450764807862095940, 1450765592889004119, NULL, TO_DATE('2021-08-31 16:21:03','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:03','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4532507165374261000, 1450764807862095940, 1450765592889004334, NULL, TO_DATE('2021-08-31 16:21:03','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-08-31 16:21:03','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4316568325108646000, 1450764807862095941, 1450765592889004268, NULL, TO_DATE('2021-06-23 06:39:19','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:39:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8681688362520987000, 1450764807862095942, 1450765592889004088, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4228502463736115000, 1450764807862095942, 1450765592889004115, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8218994812766171000, 1450764807862095942, 1450765592889004182, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7624259898376632000, 1450764807862095942, 1450765592889004258, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8504726317095393000, 1450764807862095942, 1450765592889004403, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5602501897192188000, 1450764807862095942, 1450765592889004470, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2136423814104587500, 1450764807862095942, 1450765592889004482, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8533345324068517000, 1450764807862095942, 1450765592889004545, NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:10:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3589446535123804000, 1450764807862095943, 1450765592889004474, NULL, TO_DATE('2021-06-23 06:39:44','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:39:44','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (297370733459590800, 1450764807862095944, 1450765592889004175, NULL, TO_DATE('2021-06-23 05:50:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:50:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2049273485948358000, 1450764807862095944, 1450765592889004495, NULL, TO_DATE('2021-06-23 05:50:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:50:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4485649434350541000, 1450764807862095945, 1450765592889004042, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5437011344041815000, 1450764807862095945, 1450765592889004091, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2810431123129526000, 1450764807862095945, 1450765592889004131, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6484570126183945000, 1450764807862095945, 1450765592889004157, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7067840957476540000, 1450764807862095945, 1450765592889004253, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2143435087777804300, 1450764807862095945, 1450765592889004263, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8108511052112232000, 1450764807862095945, 1450765592889004551, NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:07:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (539874850424709500, 1450764807862095946, 1450765592889004092, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6058313304120828000, 1450764807862095946, 1450765592889004099, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4334206056907582500, 1450764807862095946, 1450765592889004136, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3452467247224488400, 1450764807862095946, 1450765592889004188, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2790413979090824000, 1450764807862095946, 1450765592889004190, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7492967573262157000, 1450764807862095946, 1450765592889004251, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4885699579821889000, 1450764807862095946, 1450765592889004259, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6159300264044104000, 1450764807862095946, 1450765592889004317, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7626314151277643000, 1450764807862095946, 1450765592889004323, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5630037020813018000, 1450764807862095946, 1450765592889004339, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7193923514192867000, 1450764807862095946, 1450765592889004559, NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 05:42:06','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6186062082179167000, 1450764807862095947, 1450765592889004229, NULL, TO_DATE('2021-06-23 06:13:45','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:13:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3587792538161952000, 1450764807862095949, 1450765592889004114, NULL, TO_DATE('2021-06-23 06:04:33','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2639106464661535000, 1450764807862095949, 1450765592889004416, NULL, TO_DATE('2021-06-23 06:04:33','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-06-23 06:04:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1541761665124456700, 526356620901621760, 526356511056994304, 1450756958461300737, TO_DATE('2021-12-23 11:13:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-23 11:13:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4746012102747882000, 526077556152344576, 526077294431969280, 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5836318420422332000, 535768729024471040, 535768620278751232, 1450756958461300737, TO_DATE('2022-01-18 10:33:39','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-01-18 10:33:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7283185533511604000, 526077556152344576, 1450765592889004432, 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (919415598507028000, 526077556152344576, 1450765592889004265, 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-27 17:51:30','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3809106649826042000, 544469147921424384, 544468972511436800, 1450756958461300737, TO_DATE('2022-02-11 10:46:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 10:46:01','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5775995092350120000, 576438008606367744, 576437892923269120, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7800586799341336000, 576448277533433856, 576425225089196032, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6254306082990807000, 581430666475085824, 564389067157151744, NULL, TO_DATE('2022-05-24 11:01:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:01:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2613100450870835000, 581436854533103616, 581431768348106752, NULL, TO_DATE('2022-05-24 11:02:29','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:02:29','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5687797329544180000, 581436941229367296, 581432525403201536, NULL, TO_DATE('2022-05-24 11:02:49','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:02:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6130125695772322000, 581436993427480576, 581434143087534080, NULL, TO_DATE('2022-05-24 11:03:02','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:03:02','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8725110019329759000, 581437139125018624, 581434493471301632, NULL, TO_DATE('2022-05-24 11:03:37','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:03:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (623711529299158700, 581437221161410560, 581434937987833856, NULL, TO_DATE('2022-05-24 11:03:56','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:03:56','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2873446997914837000, 581437297606795264, 581435215210356736, NULL, TO_DATE('2022-05-24 11:04:14','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:04:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3748595416472010000, 581437337255550976, 581435962006183936, NULL, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5467505651327609000, 581437382767943681, 581436516656750592, NULL, TO_DATE('2022-05-24 11:04:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:04:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5146478234549692000, 581437337255550977, 586205441340743680, NULL, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7056570863506333000, 592391757124345856, 592391481915088896, 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8229125286955673000, 592386778267394048, 592385945366700032, 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2193320752628304100, 545565036773646336, 545564853264457728, 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4944954171612911000, 546343149988225024, 546343017720848384, 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3202338602762828000, 546347915988443136, 546346988292284416, 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-11 15:04:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3732572515607218700, 576447430137225216, 576444545517232128, 1450756958461300737, TO_DATE('2022-05-13 20:15:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-13 20:15:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3505141127397854000, 576447488295444480, 576445297899872256, 1450756958461300737, TO_DATE('2022-05-10 16:36:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:36:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8708869807021034000, 576447546457858048, 576445557296603136, 1450756958461300737, TO_DATE('2022-05-10 16:36:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:36:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8313947228812567000, 576447608743272448, 576445740617048064, 1450756958461300737, TO_DATE('2022-05-10 16:37:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4451344080343822000, 576447666205237248, 576445901988700160, 1450756958461300737, TO_DATE('2022-05-10 16:37:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4159744505923209700, 576447721767182336, 576446061217062912, 1450756958461300737, TO_DATE('2022-05-10 16:37:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5592373173119617000, 577911233693622272, 577910957540646912, 1450756958461300737, TO_DATE('2022-05-14 17:32:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-14 17:32:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1465083453944791800, 577920176742473728, 577920052196810752, 1450756958461300737, TO_DATE('2022-05-15 11:13:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:13:59','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3825440368558890500, 578179104113958912, 578178840069939200, 1450756958461300737, TO_DATE('2022-05-15 11:17:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:17:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6855754700695544000, 578179213245554688, 577951344581943296, 1450756958461300737, TO_DATE('2022-05-15 11:34:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:34:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5566067783870530000, 578179275791015936, 577951711264776192, 1450756958461300737, TO_DATE('2022-05-15 14:02:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:02:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (246336600208762600, 578179328681189376, 577951935202861056, 1450756958461300737, TO_DATE('2022-05-15 11:18:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:18:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2242213708910559500, 578180115675226112, 578180013862690816, 1450756958461300737, TO_DATE('2022-05-22 10:39:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-22 10:39:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6312453972945452000, 578225632039936000, 578224814087741440, 1450756958461300737, TO_DATE('2022-05-15 14:22:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (339192713332864260, 578225680442204160, 578225070686871552, 1450756958461300737, TO_DATE('2022-05-15 14:22:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3488519505439757300, 578225755054678016, 578225260298772480, 1450756958461300737, TO_DATE('2022-05-15 14:22:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2399846630984819700, 578225803503083520, 578225470362099712, 1450756958461300737, TO_DATE('2022-05-15 14:22:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6103173003479497000, 579402490307682304, 579400593928626176, 1450756958461300737, TO_DATE('2022-05-18 20:18:39','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:18:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5770502655654679000, 579402568669863936, 579401699782041600, 1450756958461300737, TO_DATE('2022-05-18 20:18:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:18:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5497885378355284000, 579402651498979328, 579402283595603968, 1450756958461300737, TO_DATE('2022-05-18 20:19:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:19:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5903494431162094000, 579407434091864064, 579406581389860864, 1450756958461300737, TO_DATE('2022-05-18 20:38:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:38:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3474746363408496000, 579407499330068480, 579406782007615488, 1450756958461300737, TO_DATE('2022-05-18 20:38:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:38:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5495945351530107000, 579407703957577728, 579406956977201152, 1450756958461300737, TO_DATE('2022-05-18 20:39:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:39:22','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8650379455151402000, 579407758378672128, 579407194467082240, 1450756958461300737, TO_DATE('2022-05-18 20:39:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:39:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8788881801441584000, 579987015375003648, 579986784054943744, 1450756958461300737, TO_DATE('2022-05-20 11:07:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-20 11:07:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4257282040156218400, 582661445364490240, 582661309611646976, 1450756958461300737, TO_DATE('2022-05-27 20:08:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-27 20:08:34','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5810380497366262000, 587709681099874304, 587708514152226816, 1450756958461300737, TO_DATE('2022-06-10 18:28:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2031345137601169000, 596354099289792512, 596353576553684992, 1450756958461300737, TO_DATE('2022-07-04 14:58:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-04 14:58:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (103839703909204940, 608974847288287232, 608974704010862592, 1450756958461300737, TO_DATE('2022-08-08 11:21:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-08-08 11:21:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5653802213703863000, 587709734606610432, 587709219764183040, 1450756958461300737, TO_DATE('2022-06-10 18:28:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8014902152519676000, 587709787979128832, 587709399175536640, 1450756958461300737, TO_DATE('2022-06-10 18:28:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2845395767090039300, 588042975440019456, 588042819223166976, 1450756958461300737, TO_DATE('2022-06-11 16:32:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 16:32:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1024720445140427000, 1450764807862095901, 638045114752835584, 1450756958461300737, TO_DATE('2022-10-27 16:29:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-10-27 16:29:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (371741593868574400, 1450764807862095901, 638042415412027392, 1450756958461300737, TO_DATE('2022-10-27 16:29:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-10-27 16:29:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7872406607107538000, 1450764807862095892, 1585912362983088129, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2492898248283624400, 1450764807862095892, 1585912363037614082, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1919847628360864300, 1450764807862095892, 1585912363037614083, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2466599334579421700, 1450764807862095892, 1585912363037614084, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5920334651818401000, 1450764807862095892, 1585912363037614085, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (721537806603650200, 1450764807862095892, 1585912363037614086, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2379462716057134000, 1450764807862095892, 1585912363104722945, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3875512243111428000, 1450764807862095892, 1585912363104722946, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6472680599435335000, 1450764807862095892, 1585912363104722947, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1815740593570076000, 1450764807862095892, 1585912363104722948, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8330541447586468000, 1450764807862095892, 1585912363104722949, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (491440583011017540, 1450764807862095892, 1585912363104722950, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1059776616727542100, 1450764807862095892, 1585912363104722951, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2030370999913044500, 1450764807862095892, 1585912363104722952, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2046939736589787000, 1450764807862095892, 1585912363104722953, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6029241791333300000, 1450764807862095892, 1585912363104722954, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3134161000793497000, 1450764807862095892, 1585912363104722955, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6978572709325975000, 1450764807862095892, 1585912363104722956, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6483501243502238000, 1450764807862095915, 1585912363104722957, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1761078680350173000, 1450764807862095915, 1585912363104722958, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6574268310044485000, 1450764807862095915, 1585912363104722959, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5208171966855981000, 1450764807862095915, 1585912363104722960, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7313600775117781000, 1450764807862095892, 1585912363104722961, NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-10-27 17:26:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4349178580745831000, 1450764807862095909, 642061362138456064, NULL, TO_DATE('2022-11-07 18:02:38','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-07 18:02:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3417138352541431000, 1450764807862095892, 643045022819950592, 1450756958461300737, TO_DATE('2022-11-10 11:11:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-10 11:11:59','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1127718932569314000, 1450764807862095892, 651120420518633472, 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5893484724022913000, 1450764807862095909, 651116365914316800, 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (841733583395585000, 1450764807862095909, 651119173271035904, 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (138426341898569840, 1450764807862095909, 654426928039862272, 1450756958461300737, TO_DATE('2022-12-11 20:59:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-11 20:59:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4915610029454931000, 1450764807862095931, 1592792289372065793, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3305574599699156500, 1450764807862095931, 1592792289447563266, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1602700320237974300, 1450764807862095931, 1592792289447563267, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4164526487273307000, 1450764807862095931, 1592792289447563268, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1953231193054883000, 1450764807862095931, 1592792289447563269, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3980414475721390600, 1450764807862095931, 1592792289447563270, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7362745921457370000, 1450764807862095931, 1592792289447563271, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2355149980597098000, 1450764807862095931, 1592792289447563272, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6733810371215246000, 1450764807862095931, 1592792289447563273, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3924859900707897000, 1450764807862095931, 1592792289447563274, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7276554236861184000, 1450764807862095931, 1592792289447563275, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1994563151592332300, 1450764807862095908, 1592792289514672130, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4413676370924454000, 1450764807862095908, 1592792289514672131, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1463283875112255000, 1450764807862095908, 1592792289514672132, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1586597950604691000, 1450764807862095908, 1592792289514672133, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4227335736397070000, 1450764807862095908, 1592792289514672134, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7627685903194215000, 1450764807862095908, 1592792289514672135, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1540487633956854800, 1450764807862095908, 1592792289514672136, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8752715398724330000, 1450764807862095908, 1592792289514672137, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6998904789688797000, 1450764807862095908, 1592792289514672138, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1766802248873239600, 1450764807862095908, 1592792289514672139, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7282220251011821000, 1450764807862095908, 1592792289514672140, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4877510692375325000, 1450764807862095908, 1592792289514672141, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8264447824536478000, 1450764807862095908, 1592792289514672142, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2903139567504489000, 1450764807862095908, 1592792289514672143, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4559897181492803000, 1450764807862095908, 1592792289514672144, NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-16 15:44:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1059682632397965300, 1450764807862095930, 1594592180326998018, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (970684485714062500, 1450764807862095930, 1594592180406689793, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2469917820659567600, 1450764807862095930, 1594592180406689794, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2380387672070323700, 1450764807862095930, 1594592180406689795, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5327192801078872000, 1450764807862095908, 1594592180406689797, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1877268305086430700, 1450764807862095908, 1594592180469604356, NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-11-21 09:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4154471216289108000, 641244024103247872, 641241760202498048, 1450756958461300737, TO_DATE('2022-11-05 14:02:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 14:02:42','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (434508535904026400, 641243926136889344, 641241962678329344, 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6639339325940522000, 641244024103247872, 657533259068219392, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7926049218286810000, 641244024103247872, 657533259068219393, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4429800302236255700, 641244024103247872, 657533259068219394, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3514213070613710000, 641244024103247872, 657533259068219395, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7380330702691458000, 641244024103247872, 657533259068219396, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7316928202275750000, 641244024103247872, 657533259068219397, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (2892294995399143400, 641243926136889344, 657533259068219398, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (908518490049388200, 641243926136889344, 657533259068219399, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1764871510999710700, 641243926136889344, 657533259068219400, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3896273664635517000, 641243926136889344, 657533259068219401, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7035271792170924000, 641243926136889344, 657533259068219402, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3018331592764750000, 641243926136889344, 657533259068219403, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5738884712946972000, 641243926136889344, 657533259068219404, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5936510110699688000, 641243926136889344, 657533259068219405, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4421242331761905000, 641243926136889344, 657533259068219406, 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-12-20 10:42:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3597641265790758000, 641244024103247872, 657533259068219501, 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (960313442635173100, 641244024103247872, 657533259068219502, 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5614233490237816000, 641244024103247872, 657533259068219503, 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 14:03:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3410009148122974700, 526077556152344576, 677910413299687424, 1450756958461300737, TO_DATE('2023-02-14 16:13:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-14 16:13:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5410124374581111000, 526077556152344576, 677910643386621952, 1450756958461300737, TO_DATE('2023-02-14 16:14:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-14 16:14:52','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1651541065029988400, 686178119287316480, 686174839412891648, 1450756958461300737, TO_DATE('2023-03-09 11:46:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:46:52','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6404024009937585000, 686178183690854400, 686175350430113792, 1450756958461300737, TO_DATE('2023-03-09 11:47:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7528114530474617000, 686178259356098560, 686175659781005312, 1450756958461300737, TO_DATE('2023-03-09 11:47:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8982688618777375000, 686178312292409344, 686176030305820672, 1450756958461300737, TO_DATE('2023-03-09 11:47:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4009278443153617000, 697762187867070464, 697759569409220608, 1450756958461300737, TO_DATE('2023-04-10 10:58:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8534212407489383000, 697762370797445120, 697760877801381888, 1450756958461300737, TO_DATE('2023-04-10 10:58:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3885274097593552000, 697762455014875136, 697761225484017664, 1450756958461300737, TO_DATE('2023-04-10 10:58:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (724576808453237800, 697762540020834304, 697761494317932544, 1450756958461300737, TO_DATE('2023-04-10 10:59:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:59:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3655814096027428400, 673553074966765568, 673551263069380608, 1450756958461300737, TO_DATE('2023-02-02 16:21:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-02 16:21:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1093900356360513200, 688350053471100928, 688348921973710848, 1450756958461300737, TO_DATE('2023-03-15 14:05:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-15 14:05:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3409225707786483700, 1450764807862095908, 665490432775692288, 1450756958461300737, TO_DATE('2023-05-08 11:38:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 11:38:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1055495791568105300, 713719009941659648, 713718642843590656, 1450756958461300737, TO_DATE('2023-04-03 13:38:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-03 13:38:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6343832864896635000, 714425029546483712, 714424558668750848, 1450756958461300737, TO_DATE('2023-05-26 11:01:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 11:01:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (652571499685910000, 714488057633710080, 714487572214325248, 1450756958461300737, TO_DATE('2023-05-26 14:40:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:40:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5022396851955762000, 714488196960100352, 714487820982689792, 1450756958461300737, TO_DATE('2023-05-26 14:41:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:41:01','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7552550508999115000, 714498812294733824, 714498499575816192, 1450756958461300737, TO_DATE('2023-05-26 15:23:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:23:12','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3892889728906122000, 714503247842516992, 714503076626833408, 1450756958461300737, TO_DATE('2023-05-26 15:40:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:40:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1949550274764263400, 706807627035975680, 706807241717850112, 707960023090995203, TO_DATE('2023-05-05 10:01:10','SYYYY-MM-DD HH24:MI:SS'), 707960023090995203, TO_DATE('2023-05-05 10:01:10','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6194873429919035000, 738864188277137408, 738863796810162176, 1450756958461300737, TO_DATE('2023-08-01 21:02:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 21:02:30','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5166634273131023000, 738864017908703232, 738863554568134656, 1450756958461300737, TO_DATE('2023-08-01 21:01:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 21:01:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (422025399679930100, 738862450065285120, 738861909880872960, 1450756958461300737, TO_DATE('2023-08-01 20:55:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:55:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (4081332833452350000, 738862378363658240, 738861725461520384, 1450756958461300737, TO_DATE('2023-08-01 20:55:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:55:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (6519291138556986000, 734833871224578048, 734832488207360000, 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7412606610797002000, 734833871224578048, 734833718094733312, 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7827137275325588000, 735799387355357184, 735797215649603584, 1450756958461300737, TO_DATE('2023-07-24 10:34:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-24 10:34:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1847283721174466000, 735799387355357184, 735798877248299008, 1450756958461300737, TO_DATE('2023-07-24 10:34:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-24 10:34:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3781178502812923000, 738862378363658240, 737341598572224512, 1450756958461300737, TO_DATE('2023-08-24 21:16:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-24 21:16:02','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (7475121451587770000, 738862378363658240, 738862163959226368, 1450756958461300737, TO_DATE('2023-08-24 21:16:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-24 21:16:02','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087548157000, 1450764807862095892, 707290343955243008, 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087548157001, 1450764807862095892, 707287408898778429, 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087548157002, 1450764807862095892, 707288922094575616, 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087548157003, 1450764807862095892, 707287408898744320, 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:39:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856000, 1450764807862095908, 707291432628789248, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856001, 1450764807862095908, 707290869702897456, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856002, 1450764807862095908, 707291241079119872, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856003, 1450764807862095908, 707290869702860800, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856004, 1450764807862095913, 6069473931100219001, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856005, 1450764807862095913, 6069473931100219002, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856006, 1450764807862095913, 6069473931100219003, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856007, 1450764807862095913, 6069473931100219004, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856008, 1450764807862095892, 710441229837672448, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856009, 1450764807862095908, 710441229837672448, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (8735104087574856010, 1450764807862095913, 710441229837672448, 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 14:38:51','SYYYY-MM-DD HH24:MI:SS'));

INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (5118955034316991000, 544475799542308864, 544475544734146560, 1450756958461300737, TO_DATE('2022-02-11 11:12:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:12:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (3375109022411019000, 544475707963875328, 544474404047036416, 1450756958461300737, TO_DATE('2022-02-11 11:12:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:12:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (821056732582387715, 815518987927691264, 758695419206443008, 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (821056732582387716, 815518987927691264, 758695918920015872, 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (821056732582387717, 815518987927691264, 815518821438988288, 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-15 16:26:20','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781888, 815299697123270656, 1450765592889004348, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781889, 815299697123270656, 1450765592889004152, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781890, 815299697123270656, 1450765592889004059, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781891, 815299697123270656, 1450765592889004222, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781892, 815299697123270656, 1450765592889004411, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781893, 815299697123270656, 1450765592889004121, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781894, 815299697123270656, 1450765592889004261, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781895, 815299697123270656, 1450765592889004409, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781896, 815299697123270656, 1450765592889004082, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781897, 815299697123270656, 1450765592889004069, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781898, 815299697123270656, 1450765592889004440, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781899, 815299697123270656, 1450765592889004571, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781900, 815299697123270656, 1450765592889004305, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781901, 815299697123270656, 1450765592889004533, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781902, 815299697123270656, 1450765592889004400, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781903, 815299697123270656, 1450765592889004060, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781904, 815299697123270656, 1450765592889004283, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781905, 815299697123270656, 1450765592889004160, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781906, 815299697123270656, 556508576777248768, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781907, 815299697123270656, 631784753686913024, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781908, 815299697123270656, 1592792289514672130, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781909, 815299697123270656, 1592792289514672131, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781910, 815299697123270656, 1592792289514672132, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781911, 815299697123270656, 1592792289514672133, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781912, 815299697123270656, 1592792289514672134, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781913, 815299697123270656, 1592792289514672135, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781914, 815299697123270656, 1592792289514672136, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781915, 815299697123270656, 1592792289514672137, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781916, 815299697123270656, 1592792289514672138, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781917, 815299697123270656, 1592792289514672139, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781918, 815299697123270656, 1592792289514672140, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781919, 815299697123270656, 1592792289514672141, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781920, 815299697123270656, 1592792289514672142, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781921, 815299697123270656, 1592792289514672143, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781922, 815299697123270656, 1592792289514672144, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781923, 815299697123270656, 1594592180406689797, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781924, 815299697123270656, 1594592180469604356, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781925, 815299697123270656, 707291432628789248, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781926, 815299697123270656, 707290869702897456, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781927, 815299697123270656, 707291241079119872, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781928, 815299697123270656, 707290869702860800, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781929, 815299697123270656, 665490432775692288, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815599874895781930, 815299697123270656, 815298745012068352, 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577536, 815299398463660032, 1450765592889004089, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577537, 815299398463660032, 1450765592889004302, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577538, 815299398463660032, 1450765592889004510, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577539, 815299398463660032, 1450765592889004118, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577540, 815299398463660032, 1450765592889004288, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577541, 815299398463660032, 1450765592889004427, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577542, 815299398463660032, 1450765592889004193, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577543, 815299398463660032, 1450765592889004122, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577544, 815299398463660032, 1450765592889004181, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577545, 815299398463660032, 1592792289372065793, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577546, 815299398463660032, 1592792289447563266, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577547, 815299398463660032, 1592792289447563267, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577548, 815299398463660032, 1592792289447563268, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577549, 815299398463660032, 1592792289447563269, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577550, 815299398463660032, 1592792289447563270, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577551, 815299398463660032, 1592792289447563271, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577552, 815299398463660032, 1592792289447563272, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577553, 815299398463660032, 1592792289447563273, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577554, 815299398463660032, 1592792289447563274, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577555, 815299398463660032, 1592792289447563275, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591330624577556, 815299398463660032, 815298988961177600, 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615936, 815300362058866688, 710441229837672448, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615937, 815300362058866688, 1450765592889004053, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615938, 815300362058866688, 1450765592889004161, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615939, 815300362058866688, 1450765592889004508, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615940, 815300362058866688, 1450765592889004124, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615941, 815300362058866688, 1450765592889004363, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615942, 815300362058866688, 1450765592889004539, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615943, 815300362058866688, 1450765592889004342, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615944, 815300362058866688, 1450765592889004208, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615945, 815300362058866688, 1450765592889004394, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615946, 815300362058866688, 1450765592889004265, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615947, 815300362058866688, 1450765592889004180, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615948, 815300362058866688, 1450765592889004073, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615949, 815300362058866688, 1450765592889004564, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615950, 815300362058866688, 1450765592889004223, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615951, 815300362058866688, 1450765592889004153, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615952, 815300362058866688, 1450765592889004502, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615953, 815300362058866688, 1450765592889004295, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615954, 815300362058866688, 1450765592889004134, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615955, 815300362058866688, 1450765592889004199, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615956, 815300362058866688, 1450765592889004521, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615957, 815300362058866688, 1585912362983088129, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615958, 815300362058866688, 1585912363037614082, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615959, 815300362058866688, 1585912363037614083, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615960, 815300362058866688, 1585912363037614084, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615961, 815300362058866688, 1585912363037614085, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615962, 815300362058866688, 1585912363037614086, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615963, 815300362058866688, 1585912363104722945, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615964, 815300362058866688, 1585912363104722946, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615965, 815300362058866688, 1585912363104722947, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615966, 815300362058866688, 1585912363104722948, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615967, 815300362058866688, 1585912363104722949, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615968, 815300362058866688, 1585912363104722950, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615969, 815300362058866688, 1585912363104722951, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273896615970, 815300362058866688, 1585912363104722952, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976064, 815300362058866688, 1585912363104722953, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976065, 815300362058866688, 1585912363104722954, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976066, 815300362058866688, 1585912363104722955, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976067, 815300362058866688, 1585912363104722956, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976068, 815300362058866688, 1585912363104722961, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976069, 815300362058866688, 643045022819950592, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976070, 815300362058866688, 651120420518633472, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976071, 815300362058866688, 707290343955243008, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976072, 815300362058866688, 707287408898778429, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976073, 815300362058866688, 707288922094575616, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273925976074, 815300362058866688, 707287408898744320, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591273930170368, 815300362058866688, 815300265334022144, 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347264, 815299769068167168, 1450765592889004080, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347265, 815299769068167168, 1450765592889004144, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347266, 815299769068167168, 1450765592889004171, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347267, 815299769068167168, 1450765592889004189, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347268, 815299769068167168, 1450765592889004237, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347269, 815299769068167168, 1450765592889004269, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347270, 815299769068167168, 1450765592889004281, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347271, 815299769068167168, 1450765592889004330, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347272, 815299769068167168, 1450765592889004333, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347273, 815299769068167168, 1450765592889004391, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347274, 815299769068167168, 1450765592889004433, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347275, 815299769068167168, 1450765592889004452, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347276, 815299769068167168, 1450765592889004472, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347277, 815299769068167168, 1450765592889004501, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347278, 815299769068167168, 1450765592889004516, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347279, 815299769068167168, 1450765592889004566, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347280, 815299769068167168, 1450765592889004206, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347281, 815299769068167168, 1450765592889004536, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347282, 815299769068167168, 1450765592889004311, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347283, 815299769068167168, 1450765592889004064, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347284, 815299769068167168, 1450765592889004204, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347285, 815299769068167168, 1450765592889004062, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347286, 815299769068167168, 1450765592889004211, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347287, 815299769068167168, 1450765592889004149, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347288, 815299769068167168, 1450765592889004555, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347289, 815299769068167168, 1450765592889004432, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347290, 815299769068167168, 1450765592889004512, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347291, 815299769068167168, 1450765592889004422, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347292, 815299769068167168, 1450765592889004143, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347293, 815299769068167168, 1450765592889004368, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347294, 815299769068167168, 1450765592889004443, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347295, 815299769068167168, 1450765592889004183, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347296, 815299769068167168, 1450765592889004364, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347297, 815299769068167168, 1450765592889004417, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347298, 815299769068167168, 1450765592889004503, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347299, 815299769068167168, 642061362138456064, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347300, 815299769068167168, 657533259068219502, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347301, 815299769068167168, 657533259068219503, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347302, 815299769068167168, 651116365914316800, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347303, 815299769068167168, 651119173271035904, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347304, 815299769068167168, 654426928039862272, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (815591227998347305, 815299769068167168, 815299064513175552, 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885297775419392, 811885297653784576, 811884652779544576, 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885297779613696, 811885297653784576, 811885051469111296, 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885249972936704, 811885249842913280, 811884606541537280, 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885249985519616, 811885249842913280, 811884952051523584, 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885197766434816, 811885197636411392, 811884562585231360, 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885197766434817, 811885197636411392, 811884852453580800, 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885125355970560, 811885124697464832, 811884527244025856, 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (811885125355970561, 811885124697464832, 811884745641435136, 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417634, 815518987927691264, 831116364617097216, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417730, 1450764807862095909, 829416135417143296, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417731, 1450764807862095909, 829418436286488576, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417732, 1450764807862095909, 829418705640497152, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417733, 1450764807862095909, 829419102467792896, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417734, 1450764807862095909, 829419565481205760, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417735, 1450764807862095931, 829406184619646976, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417736, 1450764807862095931, 829405596385288192, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417737, 1450764807862095892, 829396173050880000, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417738, 1450764807862095892, 829397564452511744, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417739, 1450764807862095892, 829397905482981376, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417740, 1450764807862095908, 829396173050880000, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417741, 1450764807862095908, 829397564452511744, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417742, 1450764807862095908, 829397905482981376, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417840, 815299769068167168, 829416135417143296, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417841, 815299769068167168, 829418436286488576, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417842, 815299769068167168, 829418705640497152, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417843, 815299769068167168, 829419102467792896, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417844, 815299769068167168, 829419565481205760, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417845, 815299398463660032, 829406184619646976, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417846, 815299398463660032, 829405596385288192, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417847, 815300362058866688, 829396173050880000, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417848, 815300362058866688, 829397564452511744, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417849, 815300362058866688, 829397905482981376, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417850, 815299697123270656, 829396173050880000, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417851, 815299697123270656, 829397564452511744, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTION_RESOURCES" ("SFR_ID", "FUNCTION_ID", "RESOURCE_ID", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (830801207353417852, 815299697123270656, 829397905482981376, 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:47:23','SYYYY-MM-DD HH24:MI:SS'));

-- ----------------------------
-- Table structure for SYS_FUNCTIONS
-- ----------------------------

CREATE TABLE "SYS_FUNCTIONS" (
  "FUNCTION_ID" NUMBER(20)  NOT NULL ,
  "FUNCTION_CODE" VARCHAR2(384)  DEFAULT NULL,
  "FUNCTION_MODULE_ID" NUMBER(20)  DEFAULT NULL,
  "FUNCTION_NAME" VARCHAR2(384)  DEFAULT NULL,
  "DEFAULT_RESOURCE_ID" NUMBER(20)  DEFAULT NULL,
  "IS_SYS" CHAR(1)  DEFAULT '0',
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "APPLICATION_ID" NUMBER(20,0) DEFAULT 1
);
COMMENT ON COLUMN "SYS_FUNCTIONS"."FUNCTION_ID" IS '主键ID';
COMMENT ON COLUMN "SYS_FUNCTIONS"."FUNCTION_CODE" IS '功能编号';
COMMENT ON COLUMN "SYS_FUNCTIONS"."FUNCTION_MODULE_ID" IS '功能模块ID';
COMMENT ON COLUMN "SYS_FUNCTIONS"."FUNCTION_NAME" IS '功能名称';
COMMENT ON COLUMN "SYS_FUNCTIONS"."DEFAULT_RESOURCE_ID" IS '功能默认资源ID';
COMMENT ON COLUMN "SYS_FUNCTIONS"."IS_SYS" IS '是否系统功能';
COMMENT ON COLUMN "SYS_FUNCTIONS"."SEQ" IS '功能序号';
COMMENT ON COLUMN "SYS_FUNCTIONS"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_FUNCTIONS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_FUNCTIONS"."LAST_EDITOR" IS '最后修改者';
COMMENT ON COLUMN "SYS_FUNCTIONS"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_FUNCTIONS"."APPLICATION_ID" IS '所属应用的id，默认1：属于平台自身数据';
COMMENT ON TABLE "SYS_FUNCTIONS" IS '功能表';

-- ----------------------------
-- Records of SYS_FUNCTIONS
-- ----------------------------
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686147054220877824, '0201', 686146937447260160, '应用管理', 686146166286721024, '1', 1, 1450756958461300737, TO_DATE('2023-03-09 09:43:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:43:26','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686147191273955328, '0202', 686146937447260160, '应用回收站', 686146454410240000, '1', 2, 1450756958461300737, TO_DATE('2023-03-09 09:43:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:43:59','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (729285499054989312, '0201', 686146937447260160, '分组管理', 729285380519763968, '1', 3, 1450756958461300737, TO_DATE('2023-07-06 10:40:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-06 10:40:13','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450764807862095905, '', 523215114078527488, '连接池监控', 1450765592889004221, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:21:39','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (819883353598861312, '000000000258', 697761878826557440, '模板管理', 819882932406853632, '0', 5, 1450756958461300737, TO_DATE('2024-03-12 10:43:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:44','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (819883304701665280, '000000000257', 686176268227715072, '模板管理', 819882466553896960, '0', 5, 1450756958461300737, TO_DATE('2024-03-12 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:33','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (819883211101577216, '000000000256', 587709613621911552, '模板管理', 819882250383663104, '0', 5, 1450756958461300737, TO_DATE('2024-03-12 10:43:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:43:10','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (819883155535437824, '000000000255', 579407339665498112, '模板管理', 819881531945525248, '0', 5, 1450756958461300737, TO_DATE('2024-03-12 10:42:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:42:57','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (819883083649261568, '000000000254', 579402387463348224, '模板管理', 819881890768232448, '0', 5, 1450756958461300737, TO_DATE('2024-03-12 10:42:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:42:40','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (813348971400667136, '000000000254', 811595767054868480, '标签管理', 813348818371485696, '0', 2, 1450756958461300737, TO_DATE('2024-02-23 09:58:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-23 09:58:26','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811595871216214016, '000000000254', 811595767054868480, '通讯录', 811594293004476416, '0', 1, 1450756958461300737, TO_DATE('2024-02-18 13:52:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-18 13:52:14','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (518460834717114368, '0205', 523215083967619072, '客户端管理', 518451664789970944, '1', 6, 1450756958461300737, TO_DATE('2021-12-01 16:18:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 19:14:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095892, '', 1450764807862095885, '机构维护', 1450765592889004198, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095893, '', 1450764807862095873, '我的传阅', 1450765592889004145, '1', 4, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:19:48','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095895, '', 523217792733028352, '性能监控', 1450765592889004388, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:24:36','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095898, '', 523215142994059264, '审计日志', 1450765592889004351, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:25:56','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095900, '', 523215083967619072, '解冻密码', 1450765592889004354, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:14:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095901, '', 523213321676267520, '资源管理', 1450765592889004220, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:05:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095902, '', 1450764807862095885, '类型定义', 1450765592889004075, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095904, '', 1450764807862095873, '我的催办', 1450765592889004453, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:19:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095908, '', 523198001884438528, '用户维护', 1450765592889004186, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:03:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095909, '', 1450764807862095884, '角色维护', 1450765592889004045, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:29:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095910, '0225', 523213321676267520, '功能管理', 1450765592889004239, '1', 6, NULL, TO_DATE('2021-06-21 14:33:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-06-21 14:33:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095911, '', 523215083967619072, '重置密码', 1450765592889004407, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:14:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095913, '', 523215083967619072, '字典管理', 1450765592889004187, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:14:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095915, '', 1450764807862095885, '机构审核', 1450765592889004141, '1', 5, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095920, '', 523215114078527488, '慢SQL诊断', 1450765592889004293, '1', 4, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:21:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095921, '', 523209654097158144, '菜单配置', 1450765592889004395, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:58:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095922, '', 1450764807862095885, '规则定义', 1450765592889004167, '1', 4, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095923, '', 523198001884438528, '用户审核', 1450765592889004179, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:05:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095924, '', 1450764807862095875, '任务管理', 1450765592889004226, '1', 4, NULL, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095925, '', 523215114078527488, '系统监控', 1450765592889004146, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:21:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095927, '', 523215114078527488, '在线用户', 1450765592889004414, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:21:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095928, '', 523209654097158144, '快捷功能配置', 1450765592889004507, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:58:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095929, '', 523215142994059264, '日志下载', 1450765592889004515, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:25:56','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095930, '', 1450764807862095885, '人员审核', 1450765592889004454, '1', 6, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095931, '', 1450764807862095885, '人员管理', 1450765592889004148, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:01:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095933, '', 1450764807862095875, '函数管理', 1450765592889004356, '1', 5, NULL, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095934, '', 523213802016350208, '自定义编码规则', 1450765592889004347, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:31:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095935, '', 1450764807862095873, '已办任务', 1450765592889004240, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:19:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095936, '', 523215083967619072, '工作日维护', 1450765592889004325, '1', 5, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:14:19','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095937, '', 1450764807862095875, '流程管理', 1450765592889004085, '1', 2, NULL, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095938, '', 523209654097158144, '框架页配置', 1450765592889004517, '1', 4, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:58:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095939, '', 1450764807862095884, '用户角色审核', 1450765592889004112, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:29:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095940, '', 523209654097158144, '登录页配置', 1450765592889004334, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 18:58:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095941, '', 1450764807862095873, '我的委托', 1450765592889004268, '1', 5, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:19:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095942, '', 523217792733028352, '内容监控', 1450765592889004479, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:24:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095943, '', 1450764807862095875, '实例管理', 1450765592889004474, '1', 3, NULL, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-06-20 14:39:28','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095944, '', 523215142994059264, '在线历史记录', 1450765592889004495, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:25:56','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095945, '', 523213802016350208, '运行参数配置', 1450765592889004131, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:31:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095946, '', 1450764807862095884, '不相容角色集', 1450765592889004190, '1', 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:29:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095947, '', 1450764807862095873, '待办任务', 1450765592889004229, '1', 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:19:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (1450764807862095949, '', 523213802016350208, '授权信息', 1450765592889004114, '1', 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 19:31:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (521404105277841408, '0202', 528155915363557376, '应用注册', 521403853758013440, '1', 1, 1450756958461300737, TO_DATE('2021-12-09 19:13:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-09 19:13:46','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (522705551881412608, '0203', 521403976781144064, '我的待办', 522705027572441088, '1', 2, 1450756958461300737, TO_DATE('2021-12-13 09:25:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-13 09:25:15','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (523555260388876288, '0201', 521403976781144064, '我的已办', 523554762252361728, '1', 3, 1450756958461300737, TO_DATE('2021-12-15 17:41:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:41:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (523555376986333184, '0202', 521403976781144064, '我的传阅', 523555173533229056, '1', 4, 1450756958461300737, TO_DATE('2021-12-15 17:42:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:42:09','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (526077556152344576, '0205', 526077391123259392, '我的公告', 526077294431969280, '1', 1, 1450756958461300737, TO_DATE('2021-12-22 16:44:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-22 16:44:23','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (535768729024471040, '0205', 523215142994059264, '审计查阅', 535768620278751232, '1', 4, 1450756958461300737, TO_DATE('2022-01-18 10:33:39','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-01-18 10:33:39','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (544469147921424384, '0201', 523213269419433984, '主题配置', 544468972511436800, '1', 15, 1450756958461300737, TO_DATE('2022-02-11 10:46:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 10:46:01','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576438008606367744, '0205', 1450764807862095873, '委托已办', 576437892923269120, '1', 7, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576448277533433856, '0206', 1450764807862095873, '委托待办', 576425225089196032, '1', 6, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581430666475085824, '0209', 587696011380793344, '流程概览', 564389067157151744, '1', 1, 1450756958461300737, TO_DATE('2022-05-24 10:37:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:01:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581436854533103616, '0210', 587696011380793344, '流程状态分析', 581431768348106752, '1', 2, 1450756958461300737, TO_DATE('2022-05-24 11:02:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:02:29','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581436941229367296, '0211', 587696011380793344, '流程参与者分析', 581432525403201536, '1', 3, 1450756958461300737, TO_DATE('2022-05-24 11:02:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:02:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581436993427480576, '0212', 587696011380793344, '流程统计分析', 581434143087534080, '1', 4, 1450756958461300737, TO_DATE('2022-05-24 11:03:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:03:02','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437139125018624, '0213', 587696011380793344, '热门流程分析', 581434493471301632, '1', 5, 1450756958461300737, TO_DATE('2022-05-24 11:03:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:03:37','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437221161410560, '0214', 587696011380793344, '流程数量分析', 581434937987833856, '1', 6, 1450756958461300737, TO_DATE('2022-05-24 11:03:56','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:03:56','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437297606795264, '0215', 587696011380793344, '用户流程分析', 581435215210356736, '1', 7, 1450756958461300737, TO_DATE('2022-05-24 11:04:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:04:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437337255550976, '0216', 587696011380793344, '待办任务分析', 581435962006183936, '1', 8, 1450756958461300737, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437337255550977, '0217', 587696011380793344, '流程驳回分析', 586205441340743680, '1', 9, 1450756958461300737, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:04:24','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (581437382767943681, '0218', 587696011380793344, '流程耗时分析', 581436516656750592, '1', 10, 1450756958461300737, TO_DATE('2022-05-24 11:04:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 11:04:35','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (545565036773646336, '0201', 545564987515740160, '统一日志', 545564853264457728, '1', 1, 1450756958461300737, TO_DATE('2022-02-14 11:20:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-14 11:20:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (546343149988225024, '0201', 545564987515740160, '链路追踪', 546343017720848384, '1', 2, 1450756958461300737, TO_DATE('2022-02-16 14:52:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-16 14:52:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (546347915988443136, '0202', 545564987515740160, '错误统计', 546346988292284416, '1', 3, 1450756958461300737, TO_DATE('2022-02-16 15:11:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-16 15:11:34','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (592386778267394048, '0201', 592400770314543104, '告警设置', 592385945366700032, '1', 1, 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (592391757124345856, '0202', 592400770314543104, '告警记录', 592391481915088896, '1', 2, 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (595572331049656320, '0201', 595572248216346624, '首页配置', 595571989650087936, '1', 1, 1450756958461300737, TO_DATE('2022-07-02 11:11:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-02 11:11:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (595572392424906752, '0202', 595572248216346624, '三方集成', 595572170466533376, '1', 2, 1450756958461300737, TO_DATE('2022-07-02 11:12:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-02 11:12:04','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447430137225216, '0203', 576447319827030016, '通道管理', 576444545517232128, '0', 1, 1450756958461300737, TO_DATE('2022-05-10 16:36:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-13 20:15:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447488295444480, '0204', 576447319827030016, '签名管理', 576445297899872256, '0', 2, 1450756958461300737, TO_DATE('2022-05-10 16:36:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:36:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447546457858048, '0205', 576447319827030016, '模板管理', 576445557296603136, '0', 3, 1450756958461300737, TO_DATE('2022-05-10 16:36:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:36:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447608743272448, '0206', 576447319827030016, '发送测试', 576445740617048064, '0', 4, 1450756958461300737, TO_DATE('2022-05-10 16:37:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:00','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447666205237248, '0207', 576447319827030016, '发送记录', 576445901988700160, '0', 5, 1450756958461300737, TO_DATE('2022-05-10 16:37:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (576447721767182336, '0208', 576447319827030016, '发送统计', 576446061217062912, '0', 6, 1450756958461300737, TO_DATE('2022-05-10 16:37:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:37:27','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (577911233693622272, '0229', 577911145198002176, '通道管理', 577910957540646912, '0', 1, 1450756958461300737, TO_DATE('2022-05-14 17:32:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-14 17:32:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (577920176742473728, '0230', 577911145198002176, '发送记录', 577920052196810752, '0', 6, 1450756958461300737, TO_DATE('2022-05-14 18:08:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:19:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578179104113958912, '0231', 577911145198002176, '模板管理', 578178840069939200, '0', 2, 1450756958461300737, TO_DATE('2022-05-15 11:17:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:19:41','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578179213245554688, '0232', 577911145198002176, '单发测试', 577951344581943296, '0', 3, 1450756958461300737, TO_DATE('2022-05-15 11:17:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:34:45','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578179275791015936, '0233', 577911145198002176, '群发测试', 577951711264776192, '0', 4, 1450756958461300737, TO_DATE('2022-05-15 11:18:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:02:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578179328681189376, '0234', 577911145198002176, '收件人管理', 577951935202861056, '0', 5, 1450756958461300737, TO_DATE('2022-05-15 11:18:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 11:19:58','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578180115675226112, '0235', 577911145198002176, '发送统计', 578180013862690816, '0', 7, 1450756958461300737, TO_DATE('2022-05-15 11:21:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-22 10:39:31','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578225632039936000, '0236', 578225558232768512, '通道管理', 578224814087741440, '0', 1, 1450756958461300737, TO_DATE('2022-05-15 14:22:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:14','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578225680442204160, '0237', 578225558232768512, '模板管理', 578225070686871552, '0', 2, 1450756958461300737, TO_DATE('2022-05-15 14:22:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:25','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578225755054678016, '0238', 578225558232768512, '发送测试', 578225260298772480, '0', 3, 1450756958461300737, TO_DATE('2022-05-15 14:22:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:43','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (578225803503083520, '0239', 578225558232768512, '发送记录', 578225470362099712, '0', 4, 1450756958461300737, TO_DATE('2022-05-15 14:22:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:22:54','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (582661445364490240, '0248', 578225558232768512, '发送统计', 582661309611646976, '0', 5, 1450756958461300737, TO_DATE('2022-05-27 20:08:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-27 20:08:34','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579402490307682304, '0240', 579402387463348224, '通道管理', 579400593928626176, '0', 1, 1450756958461300737, TO_DATE('2022-05-18 20:18:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:18:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579402568669863936, '0241', 579402387463348224, '发送测试', 579401699782041600, '0', 2, 1450756958461300737, TO_DATE('2022-05-18 20:18:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:18:57','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579402651498979328, '0242', 579402387463348224, '发送统计', 579402283595603968, '0', 3, 1450756958461300737, TO_DATE('2022-05-18 20:19:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:19:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579987015375003648, '0247', 579402387463348224, '发送记录', 579986784054943744, '0', 4, 1450756958461300737, TO_DATE('2022-05-20 11:01:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-20 11:07:55','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579407434091864064, '0243', 579407339665498112, '通道管理', 579406581389860864, '0', 1, 1450756958461300737, TO_DATE('2022-05-18 20:38:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:38:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579407499330068480, '0244', 579407339665498112, '发送测试', 579406782007615488, '0', 2, 1450756958461300737, TO_DATE('2022-05-18 20:38:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:38:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579407703957577728, '0245', 579407339665498112, '发送记录', 579406956977201152, '0', 3, 1450756958461300737, TO_DATE('2022-05-18 20:39:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:39:21','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (579407758378672128, '0246', 579407339665498112, '发送统计', 579407194467082240, '0', 4, 1450756958461300737, TO_DATE('2022-05-18 20:39:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:39:34','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (596354099289792512, '0253', 596353922000756736, '应用管理', 596353576553684992, '0', 1, 1450756958461300737, TO_DATE('2022-07-04 14:58:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-04 14:58:17','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (608974847288287232, '0205', 596353922000756736, '场景管理', 608974704010862592, '0', 2, 1450756958461300737, TO_DATE('2022-08-08 10:48:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-08-08 11:21:18','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (587709734606610432, '0250', 587709613621911552, '发送记录', 587709219764183040, '0', 2, 1450756958461300737, TO_DATE('2022-06-10 18:28:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (587709787979128832, '0251', 587709613621911552, '发送统计', 587709399175536640, '0', 3, 1450756958461300737, TO_DATE('2022-06-10 18:28:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:28:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (588042975440019456, '0252', 587709613621911552, '发送测试', 588042819223166976, '0', 4, 1450756958461300737, TO_DATE('2022-06-11 16:32:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 16:32:51','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (641243926136889344, '0201', 641243779856343040, '数据导入', 641241962678329344, '1', 1, 1450756958461300737, TO_DATE('2022-11-05 11:54:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 11:54:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (641244024103247872, '0202', 641243779856343040, '数据导出', 641241760202498048, '1', 2, 1450756958461300737, TO_DATE('2022-11-05 11:54:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 11:54:49','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686178119287316480, '0203', 686176268227715072, '通道管理', 686174839412891648, '0', 1, 1450756958461300737, TO_DATE('2023-03-09 11:46:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:46:52','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686178183690854400, '0204', 686176268227715072, '发送测试', 686175350430113792, '0', 2, 1450756958461300737, TO_DATE('2023-03-09 11:47:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:08','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686178259356098560, '0205', 686176268227715072, '发送记录', 686175659781005312, '0', 3, 1450756958461300737, TO_DATE('2023-03-09 11:47:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686178312292409344, '0206', 686176268227715072, '发送统计', 686176030305820672, '0', 4, 1450756958461300737, TO_DATE('2023-03-09 11:47:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:47:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (697762187867070464, '0201', 697761878826557440, '通道管理', 697759569409220608, '0', 1, 1450756958461300737, TO_DATE('2023-04-10 10:57:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (697762370797445120, '0202', 697761878826557440, '发送测试', 697760877801381888, '0', 2, 1450756958461300737, TO_DATE('2023-04-10 10:58:33','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:33','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (697762455014875136, '0203', 697761878826557440, '发送记录', 697761225484017664, '0', 3, 1450756958461300737, TO_DATE('2023-04-10 10:58:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:58:53','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (697762540020834304, '0204', 697761878826557440, '发送统计', 697761494317932544, '0', 4, 1450756958461300737, TO_DATE('2023-04-10 10:59:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:59:13','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (673553074966765568, '0203', 1450764807862095875, '工作流配置项管理', 673551263069380608, '1', 6, 1450756958461300737, TO_DATE('2023-02-02 15:39:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-02 16:21:38','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (688350053471100928, '0203', 1450764807862095885, '岗位管理', 688348921973710848, '1', 7, 1450756958461300737, TO_DATE('2023-03-15 11:37:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-15 14:05:19','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (713719009941659648, '0201', 523213321676267520, '资源类型维护', 713718642843590656, '1', 1, 1450756958461300737, TO_DATE('2023-04-03 13:38:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-03 13:38:45','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714425029546483712, '0203', 1450764807862095885, '岗位审核', 714424558668750848, '1', 8, 1450756958461300737, TO_DATE('2023-05-26 10:30:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 11:01:14','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714488057633710080, '0204', 1450764807862095884, '组织角色审核', 714487572214325248, '1', 4, 1450756958461300737, TO_DATE('2023-05-26 14:40:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:40:27','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714488196960100352, '0205', 1450764807862095884, '岗位角色审核', 714487820982689792, '1', 5, 1450756958461300737, TO_DATE('2023-05-26 14:41:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:41:01','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714498812294733824, '0206', 523198001884438528, '用户组织审核', 714498499575816192, '1', 4, 1450756958461300737, TO_DATE('2023-05-26 15:23:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:23:12','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714503247842516992, '0207', 523198001884438528, '用户岗位审核', 714503076626833408, '1', 5, 1450756958461300737, TO_DATE('2023-05-26 15:40:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:40:49','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738864188277137408, '0204', 526077391123259392, '消息更多', 738863796810162176, '1', 2, 1450756958461300737, TO_DATE('2023-08-01 21:02:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 21:02:30','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738864017908703232, '0203', 526077391123259392, '通知更多', 738863554568134656, '1', 1, 1450756958461300737, TO_DATE('2023-08-01 21:01:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 21:01:49','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738862450065285120, '0202', 738862247950163968, '新闻资讯列表', 738861909880872960, '1', 2, 1450756958461300737, TO_DATE('2023-08-01 20:55:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:55:36','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738862378363658240, '0201', 738862247950163968, '新闻资讯维护', 738861725461520384, '1', 1, 1450756958461300737, TO_DATE('2023-08-01 20:55:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:55:18','SYYYY-MM-DD HH24:MI:SS'), 1);

INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (734833871224578048, '0202', 523209654097158144, '工作台banner', 734833718094733312, '1', 6, 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 18:07:27','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (735799387355357184, '0203', 523209654097158144, '组件库维护', 735798877248299008, '1', 7, 1450756958461300737, TO_DATE('2023-07-24 10:04:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-24 10:34:08','SYYYY-MM-DD HH24:MI:SS'), 1);

INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (544475799542308864, '0202', 523215083967619072, '任务实例', 544475544734146560, '1', 9, 1450756958461300737, TO_DATE('2022-02-11 11:12:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:12:26','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (544475707963875328, '0201', 523215083967619072, '任务管理', 544474404047036416, '1', 8, 1450756958461300737, TO_DATE('2022-02-11 11:12:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:12:05','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815518987927691264, '000000000258', 815518957997137920, '分级管理', NULL, '1', 1, 1450756958461300737, TO_DATE('2024-02-29 09:41:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 18:41:52','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815300362058866688, '000000000256', 815299096469577728, '组织管理功能', 815300265334022144, '0', 1, 1450756958461300737, TO_DATE('2024-02-28 19:12:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:32','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299769068167168, '000000000257', 815299436459859968, '角色维护', 815299064513175552, '0', 1, 1450756958461300737, TO_DATE('2024-02-28 19:10:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:21','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299697123270656, '000000000256', 815299390616117248, '用户维护', 815298745012068352, '0', 1, 1450756958461300737, TO_DATE('2024-02-28 19:09:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 15:02:43','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815299398463660032, '000000000255', 815299121857699840, '人员管理功能', 815298988961177600, '0', 1, 1450756958461300737, TO_DATE('2024-02-28 19:08:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 14:28:46','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811885297653784576, '000000000257', 523209654097158144, '工具栏收纳', 811885051469111296, '0', 11, 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:19','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811885249842913280, '000000000256', 523209654097158144, '顶部横幅', 811884952051523584, '0', 10, 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:02:08','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811885197636411392, '000000000255', 523209654097158144, '浏览量统计', 811884852453580800, '0', 9, 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:55','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_FUNCTIONS" ("FUNCTION_ID", "FUNCTION_CODE", "FUNCTION_MODULE_ID", "FUNCTION_NAME", "DEFAULT_RESOURCE_ID", "IS_SYS", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811885124697464832, '000000000254', 523209654097158144, '广告位配置', 811884745641435136, '0', 8, 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 09:01:38','SYYYY-MM-DD HH24:MI:SS'), 1);

-- ----------------------------
-- Table structure for SYS_GET_BACK_PASSWORD
-- ----------------------------

CREATE TABLE "SYS_GET_BACK_PASSWORD" (
  "USER_ID" NUMBER(20)  NOT NULL ,
  "P_QUES" VARCHAR2(192)  DEFAULT NULL,
  "P_KEY" VARCHAR2(192)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_GET_BACK_PASSWORD"."USER_ID" IS '用户编码';
COMMENT ON COLUMN "SYS_GET_BACK_PASSWORD"."P_QUES" IS '找密码的问题';
COMMENT ON COLUMN "SYS_GET_BACK_PASSWORD"."P_KEY" IS '找密码的答案';
COMMENT ON TABLE "SYS_GET_BACK_PASSWORD" IS '账户密码找回表';
-- ----------------------------
-- Table structure for SYS_IDTABLE
-- ----------------------------

CREATE TABLE "SYS_IDTABLE" (
  "ID_ID" NUMBER(20)  NOT NULL ,
  "ID_VALUE" NUMBER(10) DEFAULT NULL ,
  "TABLE_NAME" VARCHAR2(192)  DEFAULT NULL,
  "FIELD_NAME" VARCHAR2(192) DEFAULT NULL ,
  "ID_DESC" VARCHAR2(192)  DEFAULT NULL,
  "CACHE_SIZE" NUMBER(10) DEFAULT NULL ,
  "ID_PREFIX" VARCHAR2(30) DEFAULT NULL ,
  "IS_PREFIX" CHAR(1)  DEFAULT NULL,
  "ID_LENGTH" NUMBER(10) DEFAULT NULL ,
  "IS_SUFFIX" CHAR(1)  DEFAULT NULL,
  "ID_SUFFIX" VARCHAR2(48)  DEFAULT NULL,
  "IS_GLOBAL" CHAR(1) DEFAULT NULL ,
  "IS_LEVEL" VARCHAR2(3)  DEFAULT NULL,
  "IS_SYS" VARCHAR2(3) DEFAULT NULL ,
  "LAST_DATE" VARCHAR2(24)  DEFAULT NULL ,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_IDTABLE"."ID_ID" IS '主键ID';
COMMENT ON COLUMN "SYS_IDTABLE"."ID_VALUE" IS '当前编号';
COMMENT ON COLUMN "SYS_IDTABLE"."TABLE_NAME" IS '业务表名';
COMMENT ON COLUMN "SYS_IDTABLE"."FIELD_NAME" IS '业务名称';
COMMENT ON COLUMN "SYS_IDTABLE"."ID_DESC" IS '业务中文描述';
COMMENT ON COLUMN "SYS_IDTABLE"."CACHE_SIZE" IS '缓存大小';
COMMENT ON COLUMN "SYS_IDTABLE"."ID_PREFIX" IS '前缀';
COMMENT ON COLUMN "SYS_IDTABLE"."IS_PREFIX" IS '是否使用前缀';
COMMENT ON COLUMN "SYS_IDTABLE"."ID_LENGTH" IS '编号长度';
COMMENT ON COLUMN "SYS_IDTABLE"."IS_SUFFIX" IS '是否使用后缀';
COMMENT ON COLUMN "SYS_IDTABLE"."ID_SUFFIX" IS '后缀';
COMMENT ON COLUMN "SYS_IDTABLE"."IS_GLOBAL" IS '是否全局流水';
COMMENT ON COLUMN "SYS_IDTABLE"."IS_LEVEL" IS '是否层级码';
COMMENT ON COLUMN "SYS_IDTABLE"."IS_SYS" IS '是否系统编码';
COMMENT ON COLUMN "SYS_IDTABLE"."LAST_DATE" IS '为特殊规则前缀时"YYYY"码表最后日期';
COMMENT ON COLUMN "SYS_IDTABLE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_IDTABLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_IDTABLE"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_IDTABLE"."LAST_TIME" IS '上次编辑时间';
COMMENT ON TABLE "SYS_IDTABLE" IS '最大号表';

-- ----------------------------
-- Records of "SYS_IDTABLE"
-- ----------------------------
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450754032317640706', '214', 'SYS_RESOURCE_MODULES', 'MODULE_CODE', '模块编码', '1', ' ', '0', '4', '0', ' ', '0', '1', '1', NULL, NULL, TO_DATE('2020-08-10 18:42:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450754032317640708', '500', 'SYS_RESOURCES', 'RESOURCE_CODE', '资源编码', '1', ' ', '0', '4', '0', ' ', '0', '1', '1', NULL, NULL, TO_DATE('2020-08-10 16:42:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450754032317640713', '200', 'SYS_FUNCTIONS', 'FUNCTION_CODE', '功能编码', '1', ' ', '0', '4', '0', ' ', '0', '1', '1', NULL, NULL, TO_DATE('2020-08-10 13:42:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('1450754032317640717', '18', 'SYS_FUNCTION_MODULES', 'FUNCTION_MODULE_CODE', '功能模块编码', '1', NULL, '0', '4', '0', NULL, '0', '1', '1', NULL, NULL, TO_DATE('2020-08-10 11:40:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('622468560387842048', '0', 'SYS_ORGAN', 'ORGAN_CODE_4', '组织机构编码生成规则', '1', NULL, '0', '11', '0', NULL, '0', '0', '1', NULL, NULL, TO_DATE('2020-08-10 20:42:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE"("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES ('624170019827490816', '0', 'SYS_STAFF', 'STAFF_CODE', '人员编码生成规则', '1', NULL, '0', '11', '0', NULL, '0', '0', '1', NULL, NULL, TO_DATE('2020-08-10 19:42:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, NULL);
INSERT INTO "SYS_IDTABLE" ("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (686205562077323264, 0, 'SYS_APPLICATION', 'APP_CODE', '应用编码', 1, '', '0', 10, '0', '', '0', '0', '1', NULL, 1450756958461300737, TO_DATE('2023-03-09 13:35:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-10 15:59:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_IDTABLE" ("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (713774538961461248, 0, 'SYS_RESOURCE_TYPE', 'RESOURCE_TYPE_CODE', '资源类型编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, TO_DATE('2023-03-09 13:35:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-10 15:59:40','SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "SYS_IDTABLE" ("ID_ID", "ID_VALUE", "TABLE_NAME", "FIELD_NAME", "ID_DESC", "CACHE_SIZE", "ID_PREFIX", "IS_PREFIX", "ID_LENGTH", "IS_SUFFIX", "ID_SUFFIX", "IS_GLOBAL", "IS_LEVEL", "IS_SYS", "LAST_DATE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME") VALUES (713774739046539264, 0, 'SYS_RESOURCE_TYPE_EXPAND', 'RESOURCE_TYPE_EXPAND_CODE', '资源类型拓展属性编码', 1, '', '0', 4, '0', '', '0', '0', '1', NULL, 1450756958461300737, TO_DATE('2023-03-09 13:35:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-10 15:59:40','SYYYY-MM-DD HH24:MI:SS'));
-- ----------------------------
-- Table structure for SYS_IDTABLE_INFO
-- ----------------------------

CREATE TABLE "SYS_IDTABLE_INFO" (
  "INFO_ID" NUMBER(20)  NOT NULL ,
  "IDTABLE_ID" NUMBER(20)  DEFAULT NULL,
  "ID_VALUE" VARCHAR2(96) DEFAULT NULL ,
  "PARENT_NUMBER" VARCHAR2(96)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_IDTABLE_INFO"."INFO_ID" IS '主键';
COMMENT ON COLUMN "SYS_IDTABLE_INFO"."IDTABLE_ID" IS '字典表主键';
COMMENT ON COLUMN "SYS_IDTABLE_INFO"."ID_VALUE" IS '当前值';
COMMENT ON COLUMN "SYS_IDTABLE_INFO"."PARENT_NUMBER" IS '父级id';
COMMENT ON TABLE "SYS_IDTABLE_INFO" IS '最大号表信息表';
-- ----------------------------
-- Table structure for SYS_INTERFACE_USER
-- ----------------------------

CREATE TABLE "SYS_INTERFACE_USER" (
  "USER_ID" NUMBER(20)  NOT NULL ,
  "USER_NAME" VARCHAR2(96) DEFAULT NULL ,
  "IS_LOCK" VARCHAR2(3) DEFAULT NULL ,
  "SYS_NAME" VARCHAR2(192) DEFAULT NULL ,
  "SYS_URL" VARCHAR2(768) DEFAULT NULL ,
  "TOKEN_STATUS" VARCHAR2(3)  DEFAULT NULL,
  "TOKEN_START_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "TOKEN_END_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "CONNECT_NUM" NUMBER(10)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6) DEFAULT NULL ,
  "TOKEN_VALUE" VARCHAR2(1536)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_INTERFACE_USER"."USER_ID" IS '接口用户ID';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."USER_NAME" IS '接口用户名称';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."IS_LOCK" IS '是否锁定';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."SYS_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."SYS_URL" IS '应用系统地址';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."TOKEN_STATUS" IS 'token状态';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."TOKEN_START_TIME" IS 'token获取时间';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."TOKEN_END_TIME" IS 'token失效时间';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."CONNECT_NUM" IS 'token连接次数';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."LAST_TIME" IS '应用系统地址';
COMMENT ON COLUMN "SYS_INTERFACE_USER"."TOKEN_VALUE" IS 'token值';
COMMENT ON TABLE "SYS_INTERFACE_USER" IS '接口表';

-- ----------------------------
-- Table structure for SYS_MENU
-- ----------------------------

CREATE TABLE "SYS_MENU" (
  "MENU_ID" NUMBER(20)  NOT NULL ,
  "MENU_TEXT" VARCHAR2(192)  DEFAULT NULL,
  "MENU_ALIAS" VARCHAR2(192) DEFAULT NULL ,
  "FUNCTION_MODULE_ID" NUMBER(20)  DEFAULT NULL,
  "FUNCTION_ID" NUMBER(20) DEFAULT NULL ,
  "PARENT_ID" NUMBER(20)  DEFAULT NULL,
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "IS_LEAF" CHAR(1)  DEFAULT NULL,
  "TARGET" VARCHAR2(96)  DEFAULT NULL,
  "ICONS" VARCHAR2(1000) DEFAULT NULL ,
  "OPEN_TYPE" VARCHAR2(48) DEFAULT NULL ,
  "PATH" VARCHAR2(1000)  DEFAULT NULL,
  "COMPONENT" VARCHAR2(1000) DEFAULT NULL,
  "MENU_TYPE" CHAR(1)  DEFAULT NULL,
   "CREATOR" NUMBER(20) DEFAULT NULL ,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "OPEN_MODE" VARCHAR2(6) DEFAULT NULL ,
  "IS_SYS" CHAR(1) DEFAULT '0'
);
COMMENT ON COLUMN "SYS_MENU"."MENU_ID" IS '菜单id';
COMMENT ON COLUMN "SYS_MENU"."MENU_TEXT" IS '菜单编码';
COMMENT ON COLUMN "SYS_MENU"."MENU_ALIAS" IS '菜单别名';
COMMENT ON COLUMN "SYS_MENU"."FUNCTION_MODULE_ID" IS '功能模块ID';
COMMENT ON COLUMN "SYS_MENU"."FUNCTION_ID" IS '功能ID';
COMMENT ON COLUMN "SYS_MENU"."PARENT_ID" IS '父菜单';
COMMENT ON COLUMN "SYS_MENU"."SEQ" IS '显示顺序';
COMMENT ON COLUMN "SYS_MENU"."IS_LEAF" IS '是否是叶子节点';
COMMENT ON COLUMN "SYS_MENU"."TARGET" IS '菜单目标';
COMMENT ON COLUMN "SYS_MENU"."ICONS" IS '菜单图标';
COMMENT ON COLUMN "SYS_MENU"."OPEN_TYPE" IS '打开方式';
COMMENT ON COLUMN "SYS_MENU"."PATH" IS '组件根路径';
COMMENT ON COLUMN "SYS_MENU"."COMPONENT" IS '组件引入路径';
COMMENT ON COLUMN "SYS_MENU"."MENU_TYPE" IS '区分菜单';
COMMENT ON COLUMN "SYS_MENU"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_MENU"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_MENU"."LAST_EDITOR" IS '最后修改人';
COMMENT ON COLUMN "SYS_MENU"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_MENU"."OPEN_MODE" IS '打开方式 0系统内 1系统外';
COMMENT ON COLUMN "SYS_MENU"."IS_SYS" IS '是否是系统菜单';
COMMENT ON TABLE "SYS_MENU" IS '系统菜单';

-- ----------------------------
-- Records of "SYS_MENU"
-- ----------------------------
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686144725505548288, '应用管理', '应用管理', NULL, NULL, 1, 14, '0', NULL, 'hussar_application', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686147400720719872, '应用管理', '应用管理', NULL, 686147054220877824, 686144725505548288, 1, '1', NULL, 'caidan_appManagement', 'inside', '/appManage', '', '0', 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686147588675870720, '应用回收站', '应用回收站', NULL, 686147191273955328, 686144725505548288, 2, '1', NULL, 'caidan_recycleBin', 'inside', '/RecycleBin', '', '0', 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-03-09','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (729285621608357888, '分组管理', '分组管理', NULL, 729285499054989312, 686144725505548288, 3, '1', NULL, 'caidan-2Jmoren', 'inside', '/appGroupManage', '', '0', 1450756958461300737, TO_DATE('2023-07-06','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-07-06','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (1450764807862095968, '连接池监控', '连接池监控', -1, 1450764807862095905, 510505261149200384, 3, '1', '', 'left-secondary-menu', 'inside', '/poolMonitor', '@/views/service/poolMonitor/index', '0', -1, NULL, -1, TO_DATE('2021-11-09','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (819883465473531904, '模板管理', '模板管理', NULL, 819883083649261568, 579402999395524608, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/appImService/appImTemplate', '', '0', 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (819883548935987200, '模板管理', '模板管理', NULL, 819883155535437824, 579408006685663232, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/appPushService/appPushTemplate', '', '0', 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (819883588052066304, '模板管理', '模板管理', NULL, 819883211101577216, 586944248251949056, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/noticeService/noticeSendTemplate', '', '0', 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (819883633023393792, '模板管理', '模板管理', NULL, 819883304701665280, 686178606145347584, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/wecomService/wecomTemplate', '', '0', 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (819883670151372800, '模板管理', '模板管理', NULL, 819883353598861312, 697755930116497408, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/dingTalk/DingTalkTemplate', '', '0', 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-12','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (813349058159845376, '标签管理', '标签管理', NULL, 813348971400667136, 811594821746827264, 2, '1', NULL, 'caidan-3Jmoren', 'inside', '/contactService/TagManage', '', '0', 1450756958461300737, TO_DATE('2024-02-23','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-23','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811594821746827264, '联系人管理', '联系人管理', NULL, NULL, 576395294317748224, 11, '0', '', 'caidan-liucheng4', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2024-02-18','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-18','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811596001818451968, '通讯录', '通讯录', NULL, 811595871216214016, 811594821746827264, 1, '1', '', 'caidan-3Jmoren', 'inside', '/contactService/ContactManage', '', '0', 1450756958461300737, TO_DATE('2024-02-18','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-18','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('510398063710576640', '开发者中心', '开发者中心', '-1', '-1', '1', '5', '0', NULL, 'bpm-platform-management', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('510503960046739456', '运维工具', '运维工具', '-1', '-1', '1450764807862096012', '10', '0', NULL, 'icon-left-operation-and-maintenance', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('510505261149200384', '平台监控', '平台监控', '-1', '-1', '1450764807862096012', '11', '0', NULL, 'icon-left-monitor', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('510506323742564352', '平台日志', '平台日志', '-1', '-1', '1450764807862096012', '12', '0', NULL, 'icon-left-log', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('518461064346869760', '客户端管理', '客户端管理', NULL, '518460834717114368', '510503960046739456', '8', '1', NULL, 'left-secondary-menu', 'inside', '/authClientModel', NULL, '0', '1450756958461300737', TO_DATE('2021-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('520237348433436672', '插件管理', '插件管理', NULL, '520236482527764480', '510398063710576640', '6', '1', NULL, 'left-level-menu', 'inside', '/plugin/pluginList', NULL, '0', '1450756958461300737', TO_DATE('2021-12-06 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-06 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('521279919444205568', '组织机构', '组织机构', NULL, NULL, '1450764807862095980', '1', '0', NULL, 'icon-left-organ', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('521280546094194688', '用户管理', '用户管理', NULL, NULL, '1450764807862095980', '2', '0', NULL, 'icon-left-user-manage', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('521288179740057600', '功能资源', '功能资源', NULL, NULL, '1450764807862095980', '4', '0', NULL, 'module', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('523160324178976768', '统一待办', '统一待办', NULL, NULL, '1', '12', '0', NULL, 'caidan_tongyidaiban', 'inside', NULL, NULL, '1', '1450756958461300737', TO_DATE('2021-12-14 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('523160531927048192', '我的待办', '我的待办', NULL, '522705551881412608', '523160324178976768', '1', '1', NULL, 'caidan_wodedaiban', 'inside', '/unifiedtodoToDoTask', NULL, '1', '1450756958461300737', TO_DATE('2021-12-14 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-14 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('523564187033804800', '我的已办', '我的已办', NULL, '523555260388876288', '523160324178976768', '2', '1', NULL, 'caidan_wodeyiban', 'inside', '/unifiedtodoDoneTask', NULL, '1', '1450756958461300737', TO_DATE('2021-12-15 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-15 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('523564256034299904', '我的传阅', '我的传阅', NULL, '523555376986333184', '523160324178976768', '3', '1', NULL, 'caidan_wodechaosong', 'inside', '/unifiedtodoCcTask', NULL, '1', '1450756958461300737', TO_DATE('2021-12-15 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-15 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('525236738705334272', '统一待办', '统一待办', NULL, NULL, '510398063710576640', '5', '0', NULL, 'unifiedtodo', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2021-12-20 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-20 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('525237452181610496', '应用注册', '应用注册', NULL, '521404105277841408', '525236738705334272', '1', '1', NULL, 'left-secondary-menu', 'inside', '/unifiedtodoSystem', NULL, '0', '1450756958461300737', TO_DATE('2021-12-20 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-12-20 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('526077936101761024', '我的公告', '我的公告', '-1', '526077556152344576', '1450764807862095952', '6', '1', NULL, 'caidan_wodegonggao', 'inside', '/noticeList', NULL, '1', '1450756958461300737', TO_DATE('2021-12-22 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-12-22 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('535768937116475392', '审计查阅', '审计查阅', NULL, '535768729024471040', '510506323742564352', '4', '1', NULL, 'left-secondary-menu', 'inside', '/auditAccess', NULL, '0', '1450756958461300737', TO_DATE('2022-01-18 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-01-18 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('544469385839124480', '主题配置', '主题配置', NULL, '544469147921424384', '510398063710576640', '7', '1', NULL, 'icon-left-theme', 'inside', '/themeConfig', NULL, '0', '1450756958461300737', TO_DATE('2022-02-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-02-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095951', '组织管理', '组织管理', '-1', '1450764807862095892', '521279919444205568', '1', '1', NULL, 'left-secondary-menu', 'inside', '/OrganMaintenance', '@/views/organ/OrganMaintenance', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095952', '个人事项', '个人事项', '1450764807862095873', NULL, '1', '10', '0', NULL, 'caidan_gerenshixiang', NULL, '/toDoManage', '@/views/layout/layout', '1', NULL, NULL, '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095953', '我的传阅', '我的传阅', NULL, '1450764807862095893', '1450764807862095952', '4', '1', NULL, 'caidan_wodechaosong', NULL, '/ccList', '@/views/taskmanage/ccList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095954', '门户配置', '门户配置', '1450764807862095874', '-1', '1', '2', '0', NULL, 'bpm-portal-configuration-center', 'inside', NULL, NULL, '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095959', '审计日志', '审计日志', '-1', '1450764807862095898', '510506323742564352', '1', '1', NULL, 'left-secondary-menu', 'inside', '/auditlog', '@/views/system/auditlog/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095961', '解冻密码', '解冻密码', NULL, '1450764807862095900', '510503960046739456', '3', '1', NULL, 'left-secondary-menu', 'tab', '/thawcode', '@/views/system/thawcode/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095962', '资源管理', '资源管理', '-1', '1450764807862095901', '521288179740057600', '1', '1', NULL, 'left-secondary-menu', 'inside', '/resourceManage', '@/views/permit/resourceManage/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095963', '流程中心', '流程中心', '1450764807862095875', '-1', '1', '3', '0', NULL, 'bpm-process-center', 'inside', NULL, NULL, '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095965', '类型定义', '类型定义', '-1', '1450764807862095902', '521279919444205568', '4', '1', NULL, 'left-secondary-menu', 'inside', '/SysOrgType', '@/views/organ/SysOrgType', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095967', '我的催办', '我的催办', NULL, '1450764807862095904', '1450764807862095952', '3', '1', NULL, 'caidan_wodecuiban', NULL, '/urgeList', '@/views/taskmanage/urgeList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095972', '用户维护', '用户维护', '-1', '1450764807862095908', '521280546094194688', '1', '1', NULL, 'left-secondary-menu', 'inside', '/usermanage', '@/views/permit/usermanage/user', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095974', '角色维护', '角色维护', '-1', '1450764807862095909', '1450764807862095998', '1', '1', NULL, 'left-secondary-menu', 'inside', '/role', '@/views/permit/rolemanage/role/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095975', '重置密码', '重置密码', NULL, '1450764807862095911', '510503960046739456', '2', '1', NULL, 'left-secondary-menu', NULL, '/resetpassword', '@/views/system/resetpassword/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095978', '字典管理', '字典管理', NULL, '1450764807862095913', '510503960046739456', '1', '1', NULL, 'left-secondary-menu', NULL, '/dictionary', '@/views/system/dictionary/index', '0', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095980', '组织权限', '组织权限', '523176320419766272', '-1', '1', '1', '0', NULL, 'bpm-organization-authority-center', 'inside', NULL, NULL, '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095982', '组织审核', '组织审核', '-1', '1450764807862095915', '521279919444205568', '6', '1', NULL, 'left-secondary-menu', 'tab', '/organAudit', '@/views/permit/auditManage/organAudit/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095986', '系统参数', '系统参数', '523213802016350208', '-1', '510398063710576640', '4', '0', NULL, 'icon-left-system-params', 'inside', '/system', '@/views/layout/layout', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095987', '慢SQL诊断', '慢SQL诊断', '-1', '1450764807862095920', '510505261149200384', '5', '1', NULL, 'left-secondary-menu', 'inside', '/slowsql', '@/views/service/slowsql/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095988', '菜单配置', '菜单配置', '-1', '1450764807862095921', '1450764807862095954', '3', '1', NULL, 'left-menu-manage', 'inside', '/menumaintain', '@/views/menumaintain/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095990', '规则定义', '规则定义', '-1', '1450764807862095922', '521279919444205568', '5', '1', NULL, 'left-secondary-menu', 'inside', '/SysOrgRule', '@/views/organ/SysOrgRule', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095991', '用户审核', '用户审核', '-1', '1450764807862095923', '521280546094194688', '2', '1', NULL, 'left-secondary-menu', 'tab', '/userAudit', '@/views/permit/auditManage/userAudit/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095993', '任务管理', '任务管理', '-1', '1450764807862095924', '1450764807862095963', '9', '1', NULL, 'icon-left-task-manage', 'inside', '/bpmTask', '@/bpm/views/taskManagement/task', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095995', '系统监控', '系统监控', '-1', '1450764807862095925', '510505261149200384', '4', '1', NULL, 'left-secondary-menu', 'inside', '/systemMonitor', '@/views/service/systemMonitor/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095997', '在线用户', '在线用户', '-1', '1450764807862095927', '510505261149200384', '1', '1', NULL, 'left-secondary-menu', 'inside', '/onlineUser', '@/views/system/onlineuser/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095998', '角色管理', '角色管理', '1450764807862095884', '-1', '1450764807862095980', '3', '0', NULL, 'left-role-manage', 'inside', '/roleManage', '@/views/permit/rolemanage/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862095999', '快捷功能配置', '快捷功能配置', '-1', '1450764807862095928', '1450764807862095954', '4', '1', NULL, 'left-shortcut-config', 'inside', '/shortCutConf', '@/views/personalizedConf/shortCutConf', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096000', '日志下载', '日志下载', '-1', '1450764807862095929', '510506323742564352', '2', '1', NULL, 'left-secondary-menu', 'inside', '/logdownload', '@/views/service/logdownload/index', '0', '-1', NULL, '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096001', '人员审核', '人员审核', '-1', '1450764807862095930', '521279919444205568', '7', '1', NULL, 'left-secondary-menu', 'tab', '/staffAudit', '@/views/permit/auditManage/staffAudit/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096002', '人员管理', '人员管理', '-1', '1450764807862095931', '521279919444205568', '2', '1', NULL, 'left-secondary-menu', 'inside', '/StaffManage', '@/views/organ/StaffManage', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096004', '函数管理', '函数管理', '-1', '1450764807862095933', '1450764807862095963', '10', '1', NULL, 'icon-left-function-manage', 'inside', '/bpmFunction', '@/bpm/views/function/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096005', '自定义编码规则', '自定义编码规则', '-1', '1450764807862095934', '1450764807862095986', '5', '1', NULL, 'left-secondary-menu', 'inside', '/maximumTable', '@/views/system/maximumTable/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096007', '已办任务', '已办任务', NULL, '1450764807862095935', '1450764807862095952', '2', '1', NULL, 'caidan_yibanrenwu', NULL, '/doneList', '@/views/taskmanage/doneList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096008', '工作日维护', '工作日维护', '-1', '1450764807862095936', '510503960046739456', '6', '1', NULL, 'left-secondary-menu', 'inside', '/workcalendar', '@/views/system/workcalendar/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096010', '流程管理', '流程管理', '-1', '1450764807862095937', '1450764807862095963', '2', '1', NULL, 'icon-left-process-manage', 'inside', '/bpmModelEdit', '@/bpm/views/modeling/modelEdit', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096011', '框架页配置', '框架页配置', '-1', '1450764807862095938', '1450764807862095954', '8', '1', NULL, 'left-layout-config', 'inside', '/layoutConf', '@/views/personalizedConf/layoutConf', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096012', '运维监控', '运维监控', '1450764807862095887', '-1', '1', '6', '0', NULL, 'bpm-operation-and-maintenance-monitoring-center', 'inside', '/service', '@/views/layout/layout', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096014', '用户角色审核', '用户角色审核', '-1', '1450764807862095939', '1450764807862095998', '3', '1', NULL, 'left-secondary-menu', 'inside', '/userRoleVerify', '@/views/permit/rolemanage/userRoleVerify/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096015', '登录页配置', '登录页配置', '-1', '1450764807862095940', '1450764807862095954', '7', '1', NULL, 'left-login-config', 'inside', '/loginConf', '@/views/personalizedConf/loginConf', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096016', '我的委托', '我的委托', NULL, '1450764807862095941', '579974742292045824', '1', '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustList', '@/views/taskmanage/entrustList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096019', '实例管理', '实例管理', '-1', '1450764807862095943', '1450764807862095963', '8', '1', NULL, 'icon-left-instance-manage', 'inside', '/bpmProcess', '@/bpm/views/processinst/process', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096020', '在线历史记录', '在线历史记录', '-1', '1450764807862095944', '510506323742564352', '3', '1', NULL, 'left-secondary-menu', 'inside', '/onlinehis', '@/views/system/onlinehistory/index', '0', '-1', NULL, '-1', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096021', '运行参数配置', '运行参数配置', NULL, '1450764807862095945', '1450764807862095986', '3', '1', NULL, 'left-secondary-menu', 'tab', '/baseConfig', '@/views/system/baseConfig/index', '0', NULL, NULL, '1450756958461300737', TO_DATE('2021-11-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096022', '功能管理', '功能管理', '-1', '1450764807862095910', '521288179740057600', '2', '1', NULL, 'left-secondary-menu', 'inside', '/functionManage', '@/pages/console/views/permit/functionManage/index', '0', '-1', TO_DATE('2021-06-21 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096023', '不相容角色集', '不相容角色集', '-1', '1450764807862095946', '1450764807862095998', '2', '1', NULL, 'left-secondary-menu', 'inside', '/alienRole', '@/views/permit/rolemanage/alienRole/index', '0', '-1', NULL, '-1', TO_DATE('2021-12-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096024', '待办任务', '待办任务', NULL, '1450764807862095947', '1450764807862095952', '1', '1', NULL, 'caidan_daibanrenwu', NULL, '/toDoList', '@/views/taskmanage/todoList', '1', NULL, NULL, NULL, NULL, '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('1450764807862096026', '授权信息', '授权信息', NULL, '1450764807862095949', '1450764807862095986', '9', '1', NULL, 'left-secondary-menu', NULL, '/license', '@/views/system/license/index', '0', NULL, NULL, '1450756958461300737', TO_DATE('2021-11-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('576448392889376768', '委托待办', '委托待办', NULL, '576448277533433856', '579974742292045824', '2', '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustTodoList', '', '1', NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('576448474900602880', '委托已办', '委托已办', NULL, '576438008606367744', '579974742292045824', '3', '1', NULL, 'caidan-3Jmoren', 'inside', '/entrustDoneList', '', '1', NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('579974742292045824', '流程委托', '流程委托', NULL, NULL, '1450764807862095952', '6', '0', NULL, 'caidan_liuchengweituo', 'inside', '/entrustDoneList', '', '1', NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581430140240928768', '流程分析', '流程分析', NULL, NULL, '1450764807862095963', 11, '0', '', 'icon-left-monitor', 'inside', '', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437577991823360', '流程概览', '流程概览', NULL, '581430666475085824', '581430140240928768', 1, '1', '', 'left-secondary-menu', 'inside', '/bpa/view', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437646807769088', '流程状态分析', '流程状态分析', NULL, '581436854533103616', '581430140240928768', 2, '1', '', 'left-secondary-menu', 'inside', '/bpa/view/processStatus', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437695180677120', '流程参与者分析', '流程参与者分析', NULL, '581436941229367296', '581430140240928768', 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAssignee', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437747630448640', '流程统计分析', '流程统计分析', NULL, '581436993427480576', '581430140240928768', 4, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessStatistics', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437791045689344', '数量分析', '数量分析', NULL, NULL, '581430140240928768', 5, '0', '', 'left-secondary-menu', 'inside', '', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437856728489984', '热门流程分析', '热门流程分析', NULL, '581437139125018624', '581437791045689344', 1, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaHotProcess', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437898885439488', '流程数量分析', '流程数量分析', NULL, '581437221161410560', '581437791045689344', 2, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessAmount', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437940299997184', '用户流程分析', '用户流程分析', NULL, '581437297606795264', '581437791045689344', 3, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/bpaProcessUser', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581437985619451904', '待办任务分析', '待办任务分析', NULL, '581437337255550976', '581437791045689344', 4, '1', '', 'left-secondary-menu', 'inside', '/todoTaskAnalysis', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('581438095157895168', '流程耗时分析', '流程耗时分析', NULL, '581437382767943681', '581430140240928768', 6, '1', NULL, 'left-secondary-menu', 'inside', '/bpa/view/processConsumeTime', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('586248796225413120', '流程驳回分析', '流程驳回分析', NULL, '581437337255550977', '581437791045689344', 5, '1', NULL, 'left-secondary-menu', 'inside', '/processRejectionAnalysis', '', '0', '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-05-24 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES('545575465642106880', '统一日志', '统一日志', NULL, '545565036773646336', '592306184481153024', '1', '1', NULL, 'left-secondary-menu', 'inside', '/unifiedLog', '', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES('546343278384259072', '链路追踪', '链路追踪', NULL, '546343149988225024', '592306184481153024', '2', '1', NULL, 'left-secondary-menu', 'inside', '/linkTracking', '', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES('546348182481936384', '错误统计', '错误统计', NULL, '546347915988443136', '592306184481153024', '3', '1', NULL, 'left-secondary-menu', 'inside', '/errorStatistics', '', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES('592306184481153024', '统一日志', '统一日志', NULL, NULL, '510506323742564352', '6', '0', '', 'left-secondary-menu', 'inside', '', '', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('592401069905289216', '日志告警', '日志告警', NULL, NULL, '510505261149200384', '6', '0', '', 'left-secondary-menu', 'inside', '', '', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('592401214583611392', '告警设置', '告警设置', NULL, '592386778267394048', '592401069905289216', '1', '1', '', 'left-secondary-menu', 'inside', '/logSet', '@/views/logWarn/logSet', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('592401334532317184', '告警记录', '告警记录', NULL, '592391757124345856', '592401069905289216', '2', '1', '', 'left-secondary-menu', 'inside', '/logRecord', '@/views/logWarn/logRecord', '0', '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-07-01 10:43:46','SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('595572492354199552', '移动门户配置', '移动门户配置', NULL, NULL, '1450764807862095954', '11', '0', NULL, 'left-mobile-office', 'inside', '', '', '0', '1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'0','0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('595572608519643136', '首页配置', '首页配置', NULL, '595572331049656320', '595572492354199552', '1', '1', '', 'left-secondary-menu', 'inside', '/portalConfiguration', '', '0', '1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'0','0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('595572683195031552', '三方集成', '三方集成', NULL, '595572392424906752', '595572492354199552', '2', '1', '', 'left-secondary-menu', 'inside', '/tripartiteIntegration', '', '0', '1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'1450756958461300737',TO_DATE('2022-07-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'),'0','0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576395294317748224, '消息中心', '消息中心', NULL, NULL, 1, 13, '0', NULL, 'xiaoxipingtai_xiaoxitongzhi_xiaoxifuwu-01', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576446459680137216, '短信推送', '短信推送', NULL, NULL, 576395294317748224, 2, '0', NULL, 'xiaoxi-duanxinfuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (577911561352650752, '邮件推送', '邮件推送', NULL, NULL, 576395294317748224, 3, '0', NULL, 'xiaoxi-youjianfuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-14', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-14', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578225925171453952, '微信公众号推送', '微信公众号推送', NULL, NULL, 576395294317748224, 4, '0', NULL, 'xiaoxi-weixingongzhonghaofuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579402999395524608, 'IM推送', 'IM推送', NULL, NULL, 576395294317748224, 5, '0', NULL, 'xiaoxi-Applmfuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579408006685663232, 'APP通知推送', 'APP通知推送', NULL, NULL, 576395294317748224, 6, '0', NULL, 'xiaoxi-APPtuisongfuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (596354392677163008, '应用管理', '应用管理', NULL, NULL, 576395294317748224, 8, '0', NULL, 'icon-left-application-manage', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-07-04', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-07-04', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576450856640323584, '通道管理', '通道管理', NULL, 576447430137225216, 576446459680137216, 1, '1', '', 'left-secondary-menu', 'inside', '/smsService/Channel', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-13', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576450925435297792, '签名管理', '签名管理', NULL, 576447488295444480, 576446459680137216, 2, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/signature', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576450990023385088, '模板管理', '模板管理', NULL, 576447546457858048, 576446459680137216, 3, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/template', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576451066137419776, '发送测试', '发送测试', NULL, 576447608743272448, 576446459680137216, 4, '1', '', 'left-secondary-menu', 'inside', '/smsService/SendSMS', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576451140942831616, '发送记录', '发送记录', NULL, 576447666205237248, 576446459680137216, 5, '1', NULL, 'left-secondary-menu', 'inside', '/smsService/sendRecord', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (576451207187668992, '发送统计', '发送统计', NULL, 576447721767182336, 576446459680137216, 6, '1', '', 'left-secondary-menu', 'inside', '/smsService/sendRateReport', '', '0', 1450756958461300737, TO_DATE('2022-05-10', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (577911671788675072, '通道管理', '通道管理', NULL, 577911233693622272, 577911561352650752, 1, '1', '', 'left-secondary-menu', 'inside', '/mailService/mChannel', '', '0', 1450756958461300737, TO_DATE('2022-05-14', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (577920288222879744, '发送记录', '发送记录', NULL, 577920176742473728, 577911561352650752, 6, '1', '', 'left-secondary-menu', 'inside', '/mailService/mailSendRecord', '', '0', 1450756958461300737, TO_DATE('2022-05-14', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578180907635318784, '模板管理', '模板管理', NULL, 578179104113958912, 577911561352650752, 2, '1', NULL, 'left-secondary-menu', 'inside', '/mailService/mTemplate', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578183012341260288, '单发测试', '单发测试', NULL, 578179213245554688, 577911561352650752, 4, '1', '', 'left-secondary-menu', 'inside', '/mailService/mSendTest', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578185499647418368, '群发测试', '群发测试', NULL, 578179275791015936, 577911561352650752, 5, '1', '', 'left-secondary-menu', 'inside', '/mailService/groupHair', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578185579053981696, '收件人管理', '收件人管理', NULL, 578179328681189376, 577911561352650752, 3, '1', '', 'left-secondary-menu', 'inside', '/mailService/recipient', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-23', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578185686646267904, '发送统计', '发送统计', NULL, 578180115675226112, 577911561352650752, 7, '1', '', 'left-secondary-menu', 'inside', '/mailService/readedStatistics', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578226039885668352, '通道管理', '通道管理', NULL, 578225632039936000, 578225925171453952, 1, '1', '', 'left-secondary-menu', 'inside', '/mpService/111publicAccount', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578226124077932544, '模板管理', '模板管理', NULL, 578225680442204160, 578225925171453952, 2, '1', '', 'left-secondary-menu', 'inside', '/mpService/mpTemplate', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578226212909096960, '发送测试', '发送测试', NULL, 578225755054678016, 578225925171453952, 3, '1', '', 'left-secondary-menu', 'inside', '/mpService/messageTesting', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (578226283117551616, '发送记录', '发送记录', NULL, 578225803503083520, 578225925171453952, 4, '1', '', 'left-secondary-menu', 'inside', '/mpService/pushRecord', '', '0', 1450756958461300737, TO_DATE('2022-05-15', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579403112276828160, '通道管理', '通道管理', NULL, 579402490307682304, 579402999395524608, 1, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImChannel', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579403203670712320, '发送测试', '发送测试', NULL, 579402568669863936, 579402999395524608, 3, '1', NULL, 'left-secondary-menu', 'inside', '/appImService/appImSendTest', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579403287988805632, '发送统计', '发送统计', NULL, 579402651498979328, 579402999395524608, 5, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImDataStatistics', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579408141658365952, '通道管理', '通道管理', NULL, 579407434091864064, 579408006685663232, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appPushService/appPushChannel', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579408250869653504, '发送测试', '发送测试', NULL, 579407499330068480, 579408006685663232, 3, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushTest', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579408319811428352, '发送记录', '发送记录', NULL, 579407703957577728, 579408006685663232, 4, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushReecorded', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579408390443507712, '发送统计', '发送统计', NULL, 579407758378672128, 579408006685663232, 5, '1', '', 'left-secondary-menu', 'inside', '/appPushService/appPushStatistics', '', '0', 1450756958461300737, TO_DATE('2022-05-18', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (579987145213878272, '发送记录', '发送记录', NULL, 579987015375003648, 579402999395524608, 4, '1', '', 'left-secondary-menu', 'inside', '/appImService/appImSendRecord', '', '0', 1450756958461300737, TO_DATE('2022-05-20', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (582661624251555840, '发送统计', '发送统计', NULL, 582661445364490240, 578225925171453952, 5, '1', '', 'left-secondary-menu', 'inside', '/mpService/sendStatistics', '', '0', 1450756958461300737, TO_DATE('2022-05-27', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-06-20', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (596354710630572032, '应用管理', '应用管理', NULL, 596354099289792512, 596354392677163008, 1, '1', NULL, 'left-secondary-menu', 'inside', '/appService/appManage', '', '0', 1450756958461300737, TO_DATE('2022-07-04', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-07-04', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (608975106760515584, '场景管理', '场景管理', NULL, 608974847288287232, 596354392677163008, 2, '1', '', 'left-secondary-menu', 'inside', '/appService/sceneManage', '', '0', 1450756958461300737, TO_DATE('2022-08-08', 'SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2022-08-08', 'SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (587710302741864448, '发送测试', '发送测试', NULL, 588042975440019456, 586944248251949056, 1, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticePushTest', '', '0', 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (587710386070102016, '发送记录', '发送记录', NULL, 587709734606610432, 586944248251949056, 3, '1', NULL, 'left-secondary-menu', 'inside', '/noticeService/noticeSendRecord', '', '0', 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (587710464084156416, '发送统计', '发送统计', NULL, 587709787979128832, 586944248251949056, 4, '1', '', 'left-secondary-menu', 'inside', '/noticeService/noticeStatistics', '', '0', 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (586944248251949056, '内部通知推送', '内部通知推送', NULL, NULL, 576395294317748224, 7, '0', NULL, 'xiaoxi-neibutongzhifuwu', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:40:42','SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('641244243347906560', '数据导出', '数据导出', NULL, '641244024103247872', '641242930610446336', '2', '1', '', 'left-secondary-menu', 'inside', '/migrationDump', '', '0', '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('641244185470705664', '数据导入', '数据导入', NULL, '641243926136889344', '641242930610446336', '1', '1', '', 'left-secondary-menu', 'inside', '/migrationLoad', '', '0', '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('641242930610446336', '数据迁移', '数据迁移', NULL, NULL, '1450764807862096012', '13', '0', NULL, 'shujuqianyi', 'inside', '', '', '0', '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2022-11-05', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686178606145347584, '企业微信推送', '企业微信推送', null, null, 576395294317748224, 9, '0', '', 'a-qingqibing_xiaoxizhong-qiyeweixintuisong', 'inside', '', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686178943606464512, '通道管理', '通道管理', null, 686178119287316480, 686178606145347584, 1, '1', null, 'caidan-3Jmoren', 'inside', '/wecomService/wecomChannel', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686179008337158144, '发送测试', '发送测试', null, 686178183690854400, 686178606145347584, 3, '1', null, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendedTested', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686179079862624256, '发送记录', '发送记录', null, 686178259356098560, 686178606145347584, 4, '1', null, 'caidan-3Jmoren', 'inside', '/wecomService/wecomSendRecord', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (686179134522793984, '发送统计', '发送统计', null, 686178312292409344, 686178606145347584, 5, '1', '', 'caidan-3Jmoren', 'inside', '/wecomService/wecomDataStatistics', '', '0', 1450756958461300737, '2023-03-09', 1450756958461300737, '2023-03-09', '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (697755930116497408,'钉钉推送','钉钉推送',NULL,NULL,576395294317748224,10,'0',NULL,'qingqibing_xiaoxipingtai-dingdingtuisong','inside','','','0',1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),'0','1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (697762708677992448,'通道管理','通道管理',NULL,697762187867070464,697755930116497408,1,'1',NULL,'caidan-3Jmoren','inside','/dingTalkService/channel','','0',1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),'0','1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (697762824432394240,'发送测试','发送测试',NULL,697762370797445120,697755930116497408,3,'1',NULL,'caidan-3Jmoren','inside','/dingTalkService/sendTest','','0',1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),'0','1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (697762900781309952,'发送记录','发送记录',NULL,697762455014875136,697755930116497408,4,'1',NULL,'caidan-3Jmoren','inside','/dingTalkService/sendRecord','','0',1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),'0','1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (697762974726889472,'发送统计','发送统计',NULL,697762540020834304,697755930116497408,5,'1',NULL,'caidan-3Jmoren','inside','/dingTalkService/sendCount','','0',1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),1450756958461300737,TO_DATE('2023-04-10', 'SYYYY-MM-DD HH24:MI:SS'),'0','1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('673554222872272896', '配置项管理', '配置项管理', NULL, '673553074966765568', '1450764807862095963', 12, '1', '', 'caidan-shezhi1', 'inside', '/bpmConfig', '', '0', '1450756958461300737', TO_DATE('2023-02-02', 'SYYYY-MM-DD'), '1450756958461300737', TO_DATE('2023-02-02', 'SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (688350240998432768, '岗位管理', '岗位管理', NULL, 688350053471100928, 521279919444205568, 3, '1', '', 'caidan-3Jmoren', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2023-03-15','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-03-15','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (713719440226918400, '资源类型管理', '资源类型管理', NULL, 713719009941659648, 521288179740057600, 3, '1', '', 'caidan-3Jmoren', 'inside', '/resourceTypeManage', '', '0', 1450756958461300737, TO_DATE('2023-04-03','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-04-03','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (714433614208835584, '岗位审核', '岗位审核', NULL, 714425029546483712, 521279919444205568, 9, '1', NULL, 'caidan-3Jmoren', 'inside', '/postAudit/index', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (714488330313801728, '组织角色审核', '组织角色审核', NULL, 714488057633710080, 1450764807862095998, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/struRoleVerify', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (714488433812447232, '岗位角色审核', '岗位角色审核', NULL, 714488196960100352, 1450764807862095998, 5, '1', NULL, 'caidan-3Jmoren', 'inside', '/postRoleAudit', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (714502153053675520, '用户组织审核', '用户组织审核', NULL, 714498812294733824, 521280546094194688, 3, '1', NULL, 'caidan-3Jmoren', 'inside', '/userOrganizationAudit/index', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (714503357229965312, '用户岗位审核', '用户岗位审核', NULL, 714503247842516992, 521280546094194688, 4, '1', NULL, 'caidan-3Jmoren', 'inside', '/userPositionAudit/index', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '1');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (706807802378854400, '表单维护', '表单维护', NULL, 706807627035975680, 1450764807862095963, 14, '1', NULL, 'caidan-2Jmoren', 'inside', '/formManager', '', '0', 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-05-26','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (734834444426551296, '工作台banner', '工作台banner', NULL, 734833871224578048, 1450764807862095954, 12, '1', NULL, 'caidan_work_banner', 'inside', '/bannerManage', '', '0', 1450756958461300737, TO_DATE('2023-07-21','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-07-21','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (735799904773087232, '组件库维护', '组件库维护', NULL, 735799387355357184, 1450764807862095954, 13, '1', NULL, 'caidan_work_assembly', 'inside', '/componentsLibrary', '', '0', 1450756958461300737, TO_DATE('2023-07-24','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2023-07-24','SYYYY-MM-DD'), '0', '0');

INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES  ('551360495878414336', '任务调度', '任务调度', '-1', '-1', '510503960046739456', '10', '0', NULL, 'left-secondary-menu', 'inside', NULL, NULL, '0', '1450756958461300737', TO_DATE('2022-03-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '-1', TO_DATE('2022-03-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('544476053125734400', '任务实例', '任务实例', NULL, '544475799542308864', '551360495878414336', '3', '1', NULL, 'left-secondary-menu', 'inside', '/scheduleInstance', '', '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU"("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES ('544475935899131904', '任务管理', '任务管理', NULL, '544475707963875328', '551360495878414336', '2', '1', NULL, 'left-secondary-menu', 'inside', '/scheduleManagement', '', '0', '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1450756958461300737', TO_DATE('2021-11-09 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815268878975508480, '组织机构', '组织机构', NULL, NULL, 1, 16, '0', '', 'caidan_liuchengweituo', 'inside', '', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815268966238003200, '组织管理', '组织管理', NULL, 815300362058866688, 815268878975508480, 1, '1', '', 'caidan-2Jmoren', 'inside', '/organMaintenance1', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815283974485319680, '用户管理', '用户管理', NULL, NULL, 1, 17, '0', NULL, 'caidan-renyuanguanli2', 'inside', '', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815284118417055744, '用户维护', '用户维护', NULL, 815299697123270656, 815283974485319680, 1, '1', '', 'caidan-2Jmoren', 'inside', '/szslUsermanage', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815284389633335296, '角色管理', '角色管理', NULL, NULL, 1, 18, '0', NULL, 'caidan-liucheng3', 'inside', '', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815284458273120256, '角色维护', '角色维护', NULL, 815299769068167168, 815284389633335296, 1, '1', '', 'caidan-2Jmoren', 'inside', '/szslManageRole', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (815284741749350400, '人员管理', '人员管理', NULL, 815299398463660032, 815268878975508480, 2, '1', '', 'caidan-2Jmoren', 'inside', '/staffManageAdmin', '', '1', 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-02-28','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811885400942714880, '工具栏横幅', '工具栏横幅', NULL, 811885124697464832, 820247769980870656, 3, '1', '', 'caidan-3Jmoren', 'inside', '/advertisementSet', '', '0', 1450756958461300737, TO_DATE('2024-02-19','SYYYY-MM-DD'), 1994060001, TO_DATE('2024-03-15','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811885462225690624, '浏览量统计', '浏览量统计', NULL, 811885197636411392, 820247769980870656, 1, '1', '', 'caidan-3Jmoren', 'inside', '/advertisementStatistics', '', '0', 1450756958461300737, TO_DATE('2024-02-19','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-15','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811885505712234496, '顶部横幅', '顶部横幅', NULL, 811885249842913280, 820247769980870656, 2, '1', '', 'caidan-3Jmoren', 'inside', '/bannerSet', '', '0', 1450756958461300737, TO_DATE('2024-02-19','SYYYY-MM-DD'), 1994060001, TO_DATE('2024-03-15','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (811885550977163264, '工具栏收纳', '工具栏收纳', NULL, 811885297653784576, 820247769980870656, 4, '1', '', 'caidan-3Jmoren', 'inside', '/storageSet', '', '0', 1450756958461300737, TO_DATE('2024-02-19','SYYYY-MM-DD'), 1994060001, TO_DATE('2024-03-15','SYYYY-MM-DD'), '0', '0');
INSERT INTO "SYS_MENU" ("MENU_ID", "MENU_TEXT", "MENU_ALIAS", "FUNCTION_MODULE_ID", "FUNCTION_ID", "PARENT_ID", "SEQ", "IS_LEAF", "TARGET", "ICONS", "OPEN_TYPE", "PATH", "COMPONENT", "MENU_TYPE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "OPEN_MODE", "IS_SYS") VALUES (820247769980870656, '广告位配置', '广告位配置', NULL, NULL, 1450764807862095954, 18, '0', '', 'caidan_guanggao', 'inside', '', '', '0', 1450756958461300737, TO_DATE('2024-03-13','SYYYY-MM-DD'), 1450756958461300737, TO_DATE('2024-03-13','SYYYY-MM-DD'), '0', '1');

-- ----------------------------
-- Table structure for SYS_OFFICE
-- ----------------------------

CREATE TABLE "SYS_OFFICE" (
  "OFFICE_ID" NUMBER(20)  NOT NULL ,
  "STRU_ID" NUMBER(20) DEFAULT NULL ,
  "OFFICE_ALIAS" VARCHAR2(768)  DEFAULT NULL,
  "OFFICE_ADDRESS" VARCHAR2(768)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_OFFICE"."OFFICE_ID" IS '组织机构id';
COMMENT ON COLUMN "SYS_OFFICE"."STRU_ID" IS '对应的组织结构id（注：不是所属）';
COMMENT ON COLUMN "SYS_OFFICE"."OFFICE_ALIAS" IS '组织机构描述';
COMMENT ON COLUMN "SYS_OFFICE"."OFFICE_ADDRESS" IS '联系地址';
COMMENT ON TABLE "SYS_OFFICE" IS '组织机构扩展表';

-- ----------------------------
-- Records of "SYS_OFFICE"
-- ----------------------------
INSERT INTO "SYS_OFFICE"("OFFICE_ID", "STRU_ID", "OFFICE_ALIAS", "OFFICE_ADDRESS") VALUES ('1', '1', NULL, NULL);

-- ----------------------------
-- Table structure for SYS_OFFICE_AUDIT
-- ----------------------------

CREATE TABLE "SYS_OFFICE_AUDIT" (
  "OFFICE_ID" NUMBER(20)  NOT NULL ,
  "STRU_ID" NUMBER(20)  DEFAULT NULL,
  "OFFICE_ALIAS" CLOB  DEFAULT NULL,
  "OFFICE_ADDRESS" CLOB  DEFAULT NULL,
  "REAL_OFFICE_ID" NUMBER(20)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_OFFICE_AUDIT"."OFFICE_ID" IS '组织机构id';
COMMENT ON COLUMN "SYS_OFFICE_AUDIT"."STRU_ID" IS '对应的组织结构id（注：不是所属）';
COMMENT ON COLUMN "SYS_OFFICE_AUDIT"."OFFICE_ALIAS" IS '组织机构描述';
COMMENT ON COLUMN "SYS_OFFICE_AUDIT"."OFFICE_ADDRESS" IS '联系地址';
COMMENT ON COLUMN "SYS_OFFICE_AUDIT"."REAL_OFFICE_ID" IS '关联SYS_OFFICE表OFFICE_ID';
COMMENT ON TABLE "SYS_OFFICE_AUDIT" IS '组织机构扩展表审核表';
-- ----------------------------
-- Table structure for SYS_ONLINE
-- ----------------------------

CREATE TABLE "SYS_ONLINE" (
  "SESSION_ID" NUMBER(20)  NOT NULL ,
  "USER_ID" NUMBER(20) DEFAULT NULL ,
  "USER_NAME" VARCHAR2(96)  DEFAULT NULL,
  "CORPORATION_ID" NUMBER(20) DEFAULT NULL ,
  "CORPORATION_NAME" VARCHAR2(384)  DEFAULT NULL,
  "LOGIN_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LOGOFF_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "REMOTEADDR" VARCHAR2(384) DEFAULT NULL ,
  "REMOTEHOST" VARCHAR2(384)  DEFAULT NULL,
  "REMOTEPORT" VARCHAR2(24)  DEFAULT NULL,
  "BROWSER_TYPE" VARCHAR2(384)  DEFAULT NULL,
  "USER_ACCOUNT" VARCHAR2(96)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_ONLINE"."SESSION_ID" IS '会话标识';
COMMENT ON COLUMN "SYS_ONLINE"."USER_ID" IS '用户账户';
COMMENT ON COLUMN "SYS_ONLINE"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ONLINE"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ONLINE"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ONLINE"."LOGIN_TIME" IS '登录时间';
COMMENT ON COLUMN "SYS_ONLINE"."LOGOFF_TIME" IS '注销时间';
COMMENT ON COLUMN "SYS_ONLINE"."REMOTEADDR" IS '客户端地址';
COMMENT ON COLUMN "SYS_ONLINE"."REMOTEHOST" IS '客户端主机名';
COMMENT ON COLUMN "SYS_ONLINE"."REMOTEPORT" IS '客户端端口号';
COMMENT ON COLUMN "SYS_ONLINE"."BROWSER_TYPE" IS '浏览器类型';
COMMENT ON COLUMN "SYS_ONLINE"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON TABLE "SYS_ONLINE" IS '在线用户';
-- ----------------------------
-- Table structure for SYS_ONLINE_HIST
-- ----------------------------

CREATE TABLE "SYS_ONLINE_HIST" (
  "HIS_ID" NUMBER(20)  NOT NULL ,
  "TOKEN_ID" VARCHAR2(384)  NOT NULL ,
  "USER_ID" NUMBER(20)  DEFAULT NULL,
  "USER_NAME" VARCHAR2(96)  DEFAULT NULL,
  "CORPORATION_ID" NUMBER(20)  DEFAULT NULL,
  "CORPORATION_NAME" VARCHAR2(384)  DEFAULT NULL,
  "LOGIN_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LOGOFF_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "REMOTEADDR" VARCHAR2(384)  DEFAULT NULL,
  "REMOTEHOST" VARCHAR2(384)  DEFAULT NULL,
  "REMOTEPORT" VARCHAR2(24)  DEFAULT NULL,
  "BROWSER_TYPE" VARCHAR2(384)  DEFAULT NULL,
  "USER_ACCOUNT" VARCHAR2(768)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_ONLINE_HIST"."HIS_ID" IS '主键';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."TOKEN_ID" IS '令牌标识';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."LOGIN_TIME" IS '登录时间';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."LOGOFF_TIME" IS '注销时间';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."REMOTEADDR" IS '客户端地址';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."REMOTEHOST" IS '客户端主机名';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."REMOTEPORT" IS '客户端端口号';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."BROWSER_TYPE" IS '浏览器类型';
COMMENT ON COLUMN "SYS_ONLINE_HIST"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON TABLE "SYS_ONLINE_HIST" IS '在线用户历史';
-- ----------------------------
-- Table structure for SYS_ORGAN
-- ----------------------------

-- ----------------------------
-- Table structure for SYS_ORGAN
-- ----------------------------

CREATE TABLE "SYS_ORGAN" (
  "ORGAN_ID" NUMBER(20)  NOT NULL ,
  "ORGAN_CODE" VARCHAR2(96)  DEFAULT NULL,
  "ORGAN_NAME" VARCHAR2(384)  DEFAULT NULL,
  "ORGAN_FCODE" VARCHAR2(3072)  DEFAULT NULL,
  "ORGAN_FNAME" VARCHAR2(3072)  DEFAULT NULL,
  "SHORT_NAME" VARCHAR2(192)  DEFAULT NULL,
  "ORGAN_TYPE" VARCHAR2(96)  DEFAULT NULL,
  "WORKPLACE_ID" VARCHAR2(96)  DEFAULT NULL,
  "BEGIN_DATE" CHAR(10)  DEFAULT NULL,
  "END_DATE" CHAR(10)  DEFAULT NULL,
  "SCN" NUMBER(10)  DEFAULT NULL,
  "DEL_FLAG" CHAR(1)  DEFAULT NULL,
  "CREATOR" NUMBER(20) DEFAULT NULL ,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "PARENT_TYPE_CODE" VARCHAR2(768)  DEFAULT NULL,
  "ORGAN_PROPERTY" CHAR(1) DEFAULT '0',
  "VALID_TIME_LIMIT_TYPE" CHAR(1) DEFAULT '0',
  "ORGAN_NAME_PINYIN_FULL" VARCHAR2(600)  DEFAULT NULL,
  "ORGAN_NAME_PINYIN_INITIAL" VARCHAR2(600)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_ID" IS '组织编码';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_CODE" IS '组织代码';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_NAME" IS '组织名称';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_FCODE" IS '全机构编码';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_FNAME" IS '全路径';
COMMENT ON COLUMN "SYS_ORGAN"."SHORT_NAME" IS '组织简称';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_TYPE" IS '组织类型编码';
COMMENT ON COLUMN "SYS_ORGAN"."WORKPLACE_ID" IS '工作地点编码';
COMMENT ON COLUMN "SYS_ORGAN"."BEGIN_DATE" IS '记录生效日期';
COMMENT ON COLUMN "SYS_ORGAN"."END_DATE" IS '记录失效日期';
COMMENT ON COLUMN "SYS_ORGAN"."SCN" IS '对应的系统更改号';
COMMENT ON COLUMN "SYS_ORGAN"."DEL_FLAG" IS '使用标识';
COMMENT ON COLUMN "SYS_ORGAN"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_ORGAN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ORGAN"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_ORGAN"."LAST_TIME" IS '上次编辑时间';
COMMENT ON COLUMN "SYS_ORGAN"."PARENT_TYPE_CODE" IS '不同组织机构类型编码';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_PROPERTY" IS '组织属性： 0 公司内部组织 1 公司外部组织';
COMMENT ON COLUMN "SYS_ORGAN"."VALID_TIME_LIMIT_TYPE" IS '组织时效类型：0 长期组织 1 临时组织';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_NAME_PINYIN_FULL" IS '组织结构名称全拼';
COMMENT ON COLUMN "SYS_ORGAN"."ORGAN_NAME_PINYIN_INITIAL" IS '组织结构称首字母拼音';
COMMENT ON TABLE "SYS_ORGAN" IS '组织机构';


-- ----------------------------
-- Records of "SYS_ORGAN"
-- ----------------------------
INSERT INTO "SYS_ORGAN" ("ORGAN_ID", "ORGAN_CODE", "ORGAN_NAME", "ORGAN_FCODE", "ORGAN_FNAME", "SHORT_NAME", "ORGAN_TYPE", "WORKPLACE_ID", "BEGIN_DATE", "END_DATE", "SCN", "DEL_FLAG", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "PARENT_TYPE_CODE", "ORGAN_NAME_PINYIN_FULL", "ORGAN_NAME_PINYIN_INITIAL") VALUES (1, '1', '金现代信息产业股份有限公司', '/1/', '/金现代信息产业股份有限公司', '金现代', '1', '1', '2018-03-19', '2019-03-19', -1, '0', NULL, NULL, NULL, NULL, NULL, 'jinxiandaixinxichanyegufenyouxiangongsi', 'jxdxxcygfyxgs');

-- ----------------------------
-- Table structure for SYS_ASYNC_EVENT
-- ----------------------------

CREATE TABLE "SYS_ASYNC_EVENT" (
  "SYS_ASYNC_EVENT_ID" NUMBER(20,0) NOT NULL,
  "EVENT_TYPE" VARCHAR2(765)  DEFAULT NULL,
  "EVENT" VARCHAR2(2048)  DEFAULT NULL,
  "STATUS" CHAR(2)  DEFAULT NULL,
  "RETRY_NUM" NUMBER(10,0)  DEFAULT NULL,
  "ERROR_MSG" CLOB  DEFAULT NULL,
  "CLASS_NAME" VARCHAR2(765)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."SYS_ASYNC_EVENT_ID" IS '事件表主键';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."EVENT_TYPE" IS '事件类型';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."EVENT" IS '事件内容';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."STATUS" IS '事件状态，0未消费，1以消费，2消费失败';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."RETRY_NUM" IS '重试次数，默认为0';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."ERROR_MSG" IS '消费失败原因';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."CLASS_NAME" IS '实体类名称';
COMMENT ON COLUMN "SYS_ASYNC_EVENT"."CREATE_TIME" IS '事件创建时间';
COMMENT ON TABLE "SYS_ASYNC_EVENT" IS '事件记录表';
-- ----------------------------
-- Table structure for SYS_ORGAN_AUDIT
-- ----------------------------

CREATE TABLE "SYS_ORGAN_AUDIT" (
  "ORGAN_ID" NUMBER(20)  NOT NULL ,
  "ORGAN_CODE" VARCHAR2(96)  DEFAULT NULL,
  "ORGAN_NAME" VARCHAR2(384)  DEFAULT NULL,
  "ORGAN_FCODE" VARCHAR2(3072)  DEFAULT NULL,
  "ORGAN_FNAME" VARCHAR2(3072)  DEFAULT NULL,
  "SHORT_NAME" VARCHAR2(192)  DEFAULT NULL,
  "ORGAN_TYPE" VARCHAR2(96)  DEFAULT NULL,
  "WORKPLACE_ID" VARCHAR2(96)  DEFAULT NULL,
  "BEGIN_DATE" CHAR(10)  DEFAULT NULL,
  "END_DATE" CHAR(10)  DEFAULT NULL,
  "SCN" NUMBER(10)  DEFAULT NULL,
  "IN_USE" CHAR(1)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "PARENT_TYPE_CODE" VARCHAR2(96)  DEFAULT NULL,
  "REAL_ORGAN_ID" NUMBER(20)  DEFAULT NULL,
  "ORGAN_PROPERTY" CHAR(1) DEFAULT '0',
  "VALID_TIME_LIMIT_TYPE" CHAR(1) DEFAULT '0'
)
;
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_ID" IS '组织编码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_CODE" IS '组织代码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_NAME" IS '组织名称';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_FCODE" IS '全机构编码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_FNAME" IS '全路径';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."SHORT_NAME" IS '组织简称';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_TYPE" IS '组织类型编码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."WORKPLACE_ID" IS '工作地点编码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."BEGIN_DATE" IS '记录生效日期';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."END_DATE" IS '记录失效日期';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."SCN" IS '对应的系统更改号';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."IN_USE" IS '使用标识';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."LAST_EDITOR" IS '最后修改者';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."PARENT_TYPE_CODE" IS '上级类型编码';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."REAL_ORGAN_ID" IS '关联SYS_ORGAN表organ_id';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."ORGAN_PROPERTY" IS '组织属性： 0 公司内部组织 1 公司外部组织';
COMMENT ON COLUMN "SYS_ORGAN_AUDIT"."VALID_TIME_LIMIT_TYPE" IS '组织时效类型：0 长期组织 1 临时组织';
COMMENT ON TABLE "SYS_ORGAN_AUDIT" IS '组织机构审核表';

-- ----------------------------
-- Table structure for SYS_ORGAN_TYPE
-- ----------------------------

CREATE TABLE "SYS_ORGAN_TYPE" (
  "TYPE_ID" NUMBER(20)  NOT NULL ,
  "ORGAN_TYPE" VARCHAR2(32)  NOT NULL ,
  "TYPE_NAME" VARCHAR2(192)  DEFAULT NULL,
  "PARENT_TYPE" VARCHAR2(32)  DEFAULT NULL,
  "IN_USE" CHAR(1) DEFAULT NULL ,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "IS_SYSTEM" CHAR(1) DEFAULT NULL ,
  "IMG_URL" VARCHAR2(4000)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."TYPE_ID" IS '主键';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."ORGAN_TYPE" IS '组织类型编码';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."TYPE_NAME" IS '组织类型名称';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."PARENT_TYPE" IS '上级组织类型';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."IN_USE" IS '使用标识';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."LAST_EDITOR" IS '上次编辑者';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."LAST_TIME" IS '上次编辑时间';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."IS_SYSTEM" IS '是否系统标识';
COMMENT ON COLUMN "SYS_ORGAN_TYPE"."IMG_URL" IS '图片url';
COMMENT ON TABLE "SYS_ORGAN_TYPE" IS '组织类型';

-- ----------------------------
-- Records of "SYS_ORGAN_TYPE"
-- ----------------------------
INSERT INTO "SYS_ORGAN_TYPE"("TYPE_ID","ORGAN_TYPE", "TYPE_NAME", "PARENT_TYPE", "IN_USE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "IS_SYSTEM", "IMG_URL") VALUES (1, '1', '单位', '0', '1', NULL, TO_DATE('2018-02-27 13:20:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-08 15:48:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', 'tree-department');
INSERT INTO "SYS_ORGAN_TYPE"("TYPE_ID","ORGAN_TYPE", "TYPE_NAME", "PARENT_TYPE", "IN_USE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "IS_SYSTEM", "IMG_URL") VALUES (2, '2', '部门', '1', '1', NULL, TO_DATE('2018-03-13 09:55:00', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-03-19 14:27:27', 'SYYYY-MM-DD HH24:MI:SS'), '1', 'unit');

-- ----------------------------
-- Table structure for SYS_PASSWORD_HIST
-- ----------------------------

CREATE TABLE "SYS_PASSWORD_HIST" (
  "SPH_ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0)  DEFAULT NULL,
  "PASSWORD" VARCHAR2(384)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "CREATOR" NUMBER(20,0)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20,0)  DEFAULT NULL
)
;
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."SPH_ID" IS '主键';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."PASSWORD" IS '密码';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."LAST_TIME" IS '最后一次更新时间';
COMMENT ON COLUMN "SYS_PASSWORD_HIST"."LAST_EDITOR" IS '最后一次更新人';
COMMENT ON TABLE "SYS_PASSWORD_HIST" IS '密码生命周期';
-- ----------------------------
-- Table structure for SYS_RES_TYPE
-- ----------------------------

CREATE TABLE "SYS_RES_TYPE" (
  "RES_TYPE_ID" NUMBER(20)  NOT NULL ,
  "RES_TYPE_NAME" VARCHAR2(192)  DEFAULT NULL
);
COMMENT ON COLUMN "SYS_RES_TYPE"."RES_TYPE_ID" IS '资源操作类型编码';
COMMENT ON COLUMN "SYS_RES_TYPE"."RES_TYPE_NAME" IS '资源操作类型名称';
COMMENT ON TABLE "SYS_RES_TYPE" IS '功能资源类型';

-- ----------------------------
-- Records of "SYS_RES_TYPE"
-- ----------------------------
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('1', '新增');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('2', '删除');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('3', '修改');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('4', '查询');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('5', '登入');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('6', '登出');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('7', '登录异常');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('8', '异常日志');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('9', '配置定制');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('10', '审计日志维护');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('11', '密码重置');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('12', '连接超时');
INSERT INTO "SYS_RES_TYPE"("RES_TYPE_ID", "RES_TYPE_NAME") VALUES ('13', '文件上传');
-- ----------------------------
-- Table structure for SYS_RESOURCE_MODULES
-- ----------------------------

CREATE TABLE "SYS_RESOURCE_MODULES" (
  "MODULE_ID" NUMBER(20)  NOT NULL ,
  "MODULE_NAME" VARCHAR2(384)  DEFAULT NULL,
  "MODULE_CODE" VARCHAR2(96)  DEFAULT NULL,
  "PARENT_MODULE_ID" NUMBER(20)  DEFAULT NULL,
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "APPLICATION_ID" NUMBER(20,0) DEFAULT 1
);
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."MODULE_ID" IS '模块ID';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."MODULE_NAME" IS '模块名称';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."MODULE_CODE" IS '模块编码';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."PARENT_MODULE_ID" IS '上级模块ID';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."SEQ" IS '模块排序';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."CREATOR" IS '创建人';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."LAST_EDITOR" IS '最后修改人';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_RESOURCE_MODULES"."APPLICATION_ID" IS '所属应用的id，默认1：属于平台自身数据';
COMMENT ON TABLE "SYS_RESOURCE_MODULES" IS '资源模块表';

-- ----------------------------
-- Records of "SYS_RESOURCE_MODULES"
-- ----------------------------
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686145111138246656, '应用管理', '0215', 1, 19, 1450756958461300737, TO_DATE('2023-03-09 09:35:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:35:43','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686145219900743680, '应用管理', '0216', 686145111138246656, 1, 1450756958461300737, TO_DATE('2023-03-09 09:36:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:36:09','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686145307951767552, '应用回收站', '0217', 686145111138246656, 2, 1450756958461300737, TO_DATE('2023-03-09 09:36:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 09:36:30','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523159524811743232, '连接池监控', '0231', 523151528153063424, 3, 1450756958461300737, TO_DATE('2021-12-14 15:29:11','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 15:29:11','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (829675912349197984, '租户服务注册', '000000000275', 677468378591666176, 3, 1450756958461300737, TO_DATE('2024-04-08 11:15:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 11:15:52','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (581434239535554561, '数量分析', '0239', 564389571845169152, 1, 1450756958461300737, TO_DATE('2022-05-24 10:52:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 10:52:05','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (830015977810042880, '流程概览', '000000000273', 564389571845169152, 2, 1450756958461300737, TO_DATE('2024-04-09 09:47:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:47:10','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (830016425195479040, '流程状态分析', '000000000274', 564389571845169152, 3, 1450756958461300737, TO_DATE('2024-04-09 09:48:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:48:57','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (830016458288537600, '流程参与者分析', '000000000275', 564389571845169152, 4, 1450756958461300737, TO_DATE('2024-04-09 09:49:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:49:05','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (830016495609454592, '流程统计分析', '000000000276', 564389571845169152, 5, 1450756958461300737, TO_DATE('2024-04-09 09:49:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:49:14','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (830016532078927872, '流程耗时分析', '000000000277', 564389571845169152, 6, 1450756958461300737, TO_DATE('2024-04-09 09:49:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:49:22','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811594090851606528, '联系人管理', '000000000273', 576393382897917952, 11, 1450756958461300737, TO_DATE('2024-02-18 13:45:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-18 13:45:10','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (812025848596275200, 'REST_API', '000000000274', 576393382897917952, 11, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (518447803329159168, '客户端管理', '0225', 523151462587703296, 6, 1450756958461300737, TO_DATE('2021-12-01 15:26:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 15:26:29','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (520204840551587840, '插件管理', '0215', 523073800708038656, 11, 1450756958461300737, TO_DATE('2021-12-06 11:48:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 10:00:09','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (521403268396752896, '统一待办', '0220', 1, 8, 1450756958461300737, TO_DATE('2021-12-09 19:10:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-09 19:10:26','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523064495887884288, '机构审核', '0216', 1450765592889004587, 5, 1450756958461300737, TO_DATE('2021-12-14 09:11:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:11:34','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523064540137791488, '人员审核', '0217', 1450765592889004587, 6, 1450756958461300737, TO_DATE('2021-12-14 09:11:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:11:44','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523073800708038656, '开发者中心', '0219', 1, 5, 1450756958461300737, TO_DATE('2021-12-14 09:48:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:48:32','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523073886045347840, '功能资源', '0220', 1450765592889004643, 4, 1450756958461300737, TO_DATE('2021-12-14 09:48:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:48:53','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523074819135381504, '功能管理', '0221', 523073886045347840, 4, 1450756958461300737, TO_DATE('2021-12-14 09:52:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:52:35','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523075074186813440, '系统参数', '0222', 523073800708038656, 3, 1450756958461300737, TO_DATE('2021-12-14 09:53:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:53:36','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523151199034417152, '运维监控中心', '0224', 1, 6, 1450756958461300737, TO_DATE('2021-12-14 14:56:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 14:56:06','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523151462587703296, '运维工具', '0225', 523151199034417152, 1, 1450756958461300737, TO_DATE('2021-12-14 14:57:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 14:57:08','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523151528153063424, '平台监控', '0226', 523151199034417152, 2, 1450756958461300737, TO_DATE('2021-12-14 14:57:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 14:57:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523151563456520192, '平台日志', '0227', 523151199034417152, 3, 1450756958461300737, TO_DATE('2021-12-14 14:57:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 14:57:32','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523156050359361536, '缓存监控', '0229', 523151528153063424, 2, 1450756958461300737, TO_DATE('2021-12-14 15:15:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 15:15:22','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523159993936257024, '慢SQL诊断', '0232', 523151528153063424, 5, 1450756958461300737, TO_DATE('2021-12-14 15:31:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 15:31:02','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523176962186027008, '流程中心', '0233', 1, 3, 1450756958461300737, TO_DATE('2021-12-14 16:38:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:38:28','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523177185453023232, '流程管理', '0234', 523176962186027008, 1, 1450756958461300737, TO_DATE('2021-12-14 16:39:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:39:21','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523177216750919680, '实例管理', '0235', 523176962186027008, 2, 1450756958461300737, TO_DATE('2021-12-14 16:39:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:39:29','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523177259834810368, '任务管理', '0236', 523176962186027008, 3, 1450756958461300737, TO_DATE('2021-12-14 16:39:39','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:39:39','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523177287164895232, '函数管理', '0237', 523176962186027008, 4, 1450756958461300737, TO_DATE('2021-12-14 16:39:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:39:45','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (523182161856307200, '系统资源', '0238', 1, 9, 1450756958461300737, TO_DATE('2021-12-14 16:59:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 16:59:08','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (528148114998304768, '统一待办', '0215', 523073800708038656, 4, NULL, TO_DATE('2021-12-28 09:52:03','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-28 09:52:03','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (528148369617723392, '应用注册', '0217', 528148114998304768, 1, NULL, TO_DATE('2021-12-28 09:53:04','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-28 09:53:04','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004578, '人员管理', '103', 1450765592889004587, 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:10:05','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004583, '日志监控', '日志监控', 1450765592889004609, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004587, '组织机构', '0140', 1450765592889004643, 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:05:49','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004593, '字典管理', '字典管理', 523151462587703296, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004597, '我的催办', '00250094', 1450765592889004662, 3, NULL, TO_DATE('2020-08-12 01:53:41','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004598, '待办事件', '00250012', 1450765592889004662, 1, NULL, TO_DATE('2018-04-20 18:02:26','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-06-11 18:19:18','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004599, '个人信息', '208', 1450765592889004738, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004602, '重置密码', '207', 523151462587703296, 2, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004603, '已办事件', '00250013', 1450765592889004662, 2, NULL, TO_DATE('2018-04-20 18:04:04','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004609, '日志下载', '0143', 523151563456520192, 2, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004610, '自定义编码规则', '10001', 523075074186813440, 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:56:33','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004611, '工作日维护', 'null0034', 523151462587703296, 5, NULL, TO_DATE('2018-05-17 15:24:50','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004614, '附件监控', '附件监控', 1450765592889004661, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004616, '菜单配置', '菜单维护', 1450765592889004633, 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:30:56','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004621, '性能监控', '性能监控', 523156050359361536, 2, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-15 11:21:07','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004623, '快捷功能配置', '02010208', 1450765592889004633, 2, NULL, TO_DATE('2021-06-23 11:37:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:29:59','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004628, '角色管理', '0144', 1450765592889004643, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004630, '资源管理', '资源维护', 523073886045347840, 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:50:25','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004631, '授权信息', '00700078', 523075074186813440, 3, NULL, TO_DATE('2018-06-26 08:54:37','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004632, '我的委托', '00250093', 1450765592889004662, 5, NULL, TO_DATE('2020-10-30 13:02:28','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004633, '门户配置中心', '0201', 1, 2, NULL, TO_DATE('2021-06-23 11:10:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:30:42','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004643, '组织权限中心', '0001', 1, 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:05:20','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004651, '用户审核', '00760090', 1450765592889004753, 2, NULL, TO_DATE('2019-08-16 10:12:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:17:37','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004653, '类型定义', '101', 1450765592889004587, 3, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:06:21','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004658, '运行参数配置', '00040094', 523075074186813440, 1, NULL, TO_DATE('2019-08-16 10:28:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-14 09:55:10','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004660, '系统监控', '00260016', 523151528153063424, 4, NULL, TO_DATE('2018-04-23 13:32:11','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004661, '附件监控', '0146', 1450765592889004663, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004662, '个人事项', '0025', 1, 7, NULL, TO_DATE('2018-04-20 18:02:13','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-06-11 18:19:09','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004663, '服务治理', '0005', 523182161856307200, 9, NULL, NULL, NULL, TO_DATE('2018-10-25 14:56:45','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004670, '欢迎页配置', '02010207', 1450765592889004633, 5, NULL, TO_DATE('2021-06-23 11:37:35','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004671, '系统管理', '0004', 523182161856307200, 8, NULL, NULL, NULL, TO_DATE('2018-10-25 14:56:26','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004686, '权限管理', '0002', 523182161856307200, 7, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:48:23','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004689, '登录页配置', '02010203', 1450765592889004633, 3, NULL, TO_DATE('2021-06-23 11:36:30','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004693, '机构维护', '102', 1450765592889004587, 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:08:11','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004698, '规则定义', '104', 1450765592889004587, 4, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:06:33','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004699, '用户角色审核', '204', 1450765592889004628, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004700, '在线用户', '505', 523151528153063424, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004701, '日志下载', 'null0078', 1450765592889004609, 2, NULL, TO_DATE('2018-08-29 19:05:39','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004711, '我的传阅', '00250095', 1450765592889004662, 4, NULL, TO_DATE('2020-08-12 01:55:18','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004718, '在线历史记录', '506', 523151563456520192, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004725, '不相容角色集', '203', 1450765592889004628, 2, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004726, '欢迎页配置', '00040084', 1450765592889004671, 7, NULL, TO_DATE('2018-10-25 15:01:51','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004732, '框架页配置', '02010204', 1450765592889004633, 4, NULL, TO_DATE('2021-06-23 11:36:51','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004735, '修改密码', '206', 1450765592889004738, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004737, '用户维护', '201', 1450765592889004753, 1, NULL, NULL, 1450756958461300737, TO_DATE('2021-12-14 09:15:35','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004738, '自助服务', '0147', 1450765592889004686, 3, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004740, '角色维护', '202', 1450765592889004628, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004746, '解冻密码', 'null0139', 523151462587703296, 3, NULL, TO_DATE('2019-02-21 16:01:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-02-21 16:03:21','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004753, '用户管理', '0142', 1450765592889004643, 2, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (1450765592889004756, '审计日志', '507', 523151563456520192, 1, NULL, NULL, NULL, NULL, 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (526435626275577856, '我的公告', '0237', 1450765592889004662, 6, 525273972338860032, TO_DATE('2021-12-23 16:27:14','SYYYY-MM-DD HH24:MI:SS'), 525273972338860032, TO_DATE('2021-12-23 16:27:14','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (526116987680858112, '跳转', '0234', 1, 17, 1450756958461300737, TO_DATE('2021-12-22 19:21:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-22 19:23:03','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (526117093318598656, '跳转', '0236', 526116987680858112, 1, 1450756958461300737, TO_DATE('2021-12-22 19:21:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-22 19:21:30','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (535768124604293120, '审计查阅', '0227', 523151563456520192, 4, 1450756958461300737, TO_DATE('2022-01-18 10:31:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-01-18 10:31:15','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (544468727815741440, '主题配置', '0215', 523073800708038656, 12, 1450756958461300737, TO_DATE('2022-02-11 10:44:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 10:44:20','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (544474526055145472, '任务管理', '0221', 523151462587703296, 8, 1450756958461300737, TO_DATE('2022-02-11 11:07:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:07:23','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (544474679767998464, '任务实例', '0222', 523151462587703296, 9, 1450756958461300737, TO_DATE('2022-02-11 11:08:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 11:08:00','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (546336605821214720, '应用管理', '0216', 523151462587703296, 10, 1450756958461300737, TO_DATE('2022-02-16 14:26:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-16 14:26:37','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (564389571845169152, '流程分析', '0215', 523176962186027008, 5, 1450756958461300737, TO_DATE('2022-04-07 10:02:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-04-07 10:02:40','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (576437727940321280, '委托已办', '0269', 1450765592889004662, 8, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (576446323717578752, '委托待办', '0272', 1450765592889004662, 7, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (581434239535554560, '数量分析', '0239', 564389571845169152, 1, 1450756958461300737, TO_DATE('2022-05-24 10:52:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-24 10:52:05','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (545564576406839296, '统一日志', '0215', 523151563456520192, 18, 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-01 11:20:41','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (592385645452992512, '日志告警', '0217', 523151528153063424, 6, 1450756958461300737, TO_DATE('2022-06-23 09:04:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-23 09:04:45','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (595571579120001024, '移动门户配置', '0215', 1450765592889004633, 7, 1450756958461300737, TO_DATE('2022-07-02 11:08:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-02 11:08:50','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (576393382897917952, '消息中心', '0217', 1, 18, 1450756958461300737, TO_DATE('2022-05-10 13:01:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 13:01:31','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (576443985825112064, '短信推送', '0220', 576393382897917952, 1, 1450756958461300737, TO_DATE('2022-05-10 16:22:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-10 16:22:36','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (576919005307346944, '邮件推送', '0222', 576393382897917952, 2, 1450756958461300737, TO_DATE('2022-05-11 23:50:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-11 23:50:10','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (578221171997417472, '微信公众号推送', '0227', 576393382897917952, 3, 1450756958461300737, TO_DATE('2022-05-15 14:04:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-15 14:04:30','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (579399930809163776, 'IM推送', '0228', 576393382897917952, 4, 1450756958461300737, TO_DATE('2022-05-18 20:08:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:08:28','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (579405620386734080, 'APP通知推送', '0229', 576393382897917952, 5, 1450756958461300737, TO_DATE('2022-05-18 20:31:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-18 20:31:05','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (587706862284316672, '内部通知推送', '0236', 576393382897917952, 6, 1450756958461300737, TO_DATE('2022-06-10 18:17:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-10 18:17:15','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (587942618739253248, '统一接口', '0237', 576393382897917952, 7, 1450756958461300737, TO_DATE('2022-06-11 09:54:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-11 09:54:04','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (596352625377812480, '应用管理', '0249', 576393382897917952, 8, 1450756958461300737, TO_DATE('2022-07-04 14:52:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-07-04 14:52:26','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (641241402218651648, '数据迁移', '0216', 523151199034417152, 4, 1450756958461300737, TO_DATE('2022-11-05 11:44:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-11-05 11:44:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (686174195188768768, '企业微信推送', '0220', 576393382897917952, 9, 1450756958461300737, TO_DATE('2023-03-09 11:31:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 11:31:17','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707894950096019456, '组件高级功能', '0217', 523073800708038656, 13, 1450756958461300737, TO_DATE('2023-05-08 10:01:48','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:01:48','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896268520955904, '数据表格', '0221', 707894950096019456, 1, 1450756958461300737, TO_DATE('2023-05-08 10:07:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:02','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896359877091328, '自定义显示方案', '0222', 707896268520955904, 1, 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896444421677056, '筛选方案', '0223', 707896268520955904, 2, 1450756958461300737, TO_DATE('2023-05-08 10:07:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:44','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (697758207757787136, '钉钉推送', '0215', 576393382897917952, 10, 1450756958461300737, TO_DATE('2023-04-10 10:42:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-10 10:42:00','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (673548858558783488, '工作流配置项管理', '0218', 523176962186027008, 6, 1450756958461300737, TO_DATE('2023-02-02 15:22:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-02-02 15:22:42','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (688348352496279552, '岗位管理', '0218', 1450765592889004587, 7, 1450756958461300737, TO_DATE('2023-03-15 11:30:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-15 11:30:36','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714502896477282304, '用户岗位审核', '0225', 1450765592889004753, 1, 1450756958461300737, TO_DATE('2023-05-26 15:39:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:39:25','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714498130460286976, '用户组织审核', '0222', 1450765592889004753, 1, 1450756958461300737, TO_DATE('2023-05-26 15:20:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 15:20:29','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714487678439268352, '岗位角色审核', '0221', 1450765592889004628, 1, 1450756958461300737, TO_DATE('2023-05-26 14:38:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:38:57','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (714486973070581760, '组织角色审核', '0220', 1450765592889004628, 1, 1450756958461300737, TO_DATE('2023-05-26 14:36:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-26 14:36:28','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (688348425015795712, '岗位审核', '0219', 1450765592889004587, 8, 1450756958461300737, TO_DATE('2023-03-15 11:30:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-15 11:30:53','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (713718810095656960, '资源类型管理', '0225', 523073886045347840, 5, 1450756958461300737, TO_DATE('2023-06-15 18:57:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-06-15 18:57:40','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (706807109840543744, '表单维护', '0215', 523176962186027008, 8, 1450756958461300737, TO_DATE('2023-05-05 09:59:07','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-05 09:59:07','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896268520955910, '树形控件', '0221', 707894950096019456, 1, 1450756958461300737, TO_DATE('2023-05-08 10:07:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:02','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896359877091330, '历史记录信息方案', '0222', 707896268520955910, 1, 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (738861534167703552, '新闻资讯', '0216', 1, 20, 1450756958461300737, TO_DATE('2023-08-01 20:51:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-08-01 20:51:57','SYYYY-MM-DD HH24:MI:SS'), 1);

INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (734832488207360000, '工作台banner', '0223', 1450765592889004633, 8, 1450756958461300737, TO_DATE('2023-07-21 18:01:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 18:01:58','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (735797215649603584, '组件库维护', '0224', 1450765592889004633, 9, 1450756958461300737, TO_DATE('2023-07-24 09:55:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-24 09:55:27','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (707896359877091375, '排序方案', '0224', 707896268520955904, 1, 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:07:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815518757266137088, '分级管理', '000000000281', 1, 24, 1450756958461300737, TO_DATE('2024-02-29 09:40:23','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-29 09:40:23','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815298858337968128, '人员管理', '000000000280', 815285382546726912, 2, 1450756958461300737, TO_DATE('2024-02-28 19:06:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:06:35','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815298825416876032, '组织管理', '000000000279', 815285382546726912, 1, 1450756958461300737, TO_DATE('2024-02-28 19:06:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:06:27','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815298111118516224, '角色维护', '000000000278', 815297624935768064, 1, 1450756958461300737, TO_DATE('2024-02-28 19:03:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:03:37','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815298075383046144, '用户维护', '000000000277', 815289996381790208, 1, 1450756958461300737, TO_DATE('2024-02-28 19:03:29','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:03:29','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815297624935768064, '角色管理', '000000000276', 1, 23, 1450756958461300737, TO_DATE('2024-02-28 19:01:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 19:01:41','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815289996381790208, '用户管理', '000000000275', 1, 22, 1450756958461300737, TO_DATE('2024-02-28 18:31:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 18:31:22','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (815285382546726912, '组织机构', '000000000274', 1, 21, 1450756958461300737, TO_DATE('2024-02-28 18:13:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-28 18:13:02','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811884652779544576, '工具栏收纳', '000000000276', 1450765592889004633, 13, 1450756958461300737, TO_DATE('2024-02-19 08:59:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 08:59:45','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811884606541537280, '顶部横幅', '000000000275', 1450765592889004633, 12, 1450756958461300737, TO_DATE('2024-02-19 08:59:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 08:59:34','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811884562585231360, '浏览量统计', '000000000274', 1450765592889004633, 11, 1450756958461300737, TO_DATE('2024-02-19 08:59:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 08:59:24','SYYYY-MM-DD HH24:MI:SS'), 1);
INSERT INTO "SYS_RESOURCE_MODULES" ("MODULE_ID", "MODULE_NAME", "MODULE_CODE", "PARENT_MODULE_ID", "SEQ", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "APPLICATION_ID") VALUES (811884527244025856, '广告位配置', '000000000273', 1450765592889004633, 10, 1450756958461300737, TO_DATE('2024-02-19 08:59:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-19 08:59:15','SYYYY-MM-DD HH24:MI:SS'), 1);

-- ----------------------------
-- Table structure for SYS_RESOURCES
-- ----------------------------

CREATE TABLE "SYS_RESOURCES" (
  "RESOURCE_ID" NUMBER(20)  NOT NULL ,
  "RESOURCE_NAME" VARCHAR2(384)  DEFAULT NULL,
  "RESOURCE_ALIAS" VARCHAR2(384)  DEFAULT NULL,
  "MODULE_ID" NUMBER(20)  DEFAULT NULL,
  "PATH" VARCHAR2(3072)  DEFAULT NULL,
  "COMPONENT" VARCHAR2(768) DEFAULT NULL ,
  "IS_AUDIT" CHAR(1)  DEFAULT NULL,
  "RES_TYPE_ID" VARCHAR2(96)  DEFAULT NULL,
  "SEQ" NUMBER(10)  DEFAULT NULL,
  "IS_REPEAT_AUTHENTICATE" CHAR(1)  DEFAULT NULL,
  "STRATEGY" VARCHAR2(10)  DEFAULT NULL,
  "KEEP_ALIVE" CHAR(1)  DEFAULT NULL,
   "CREATOR" NUMBER(20)  DEFAULT NULL,
  "CREATE_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "LAST_EDITOR" NUMBER(20)  DEFAULT NULL,
  "LAST_TIME" TIMESTAMP(6)  DEFAULT NULL,
  "RESOURCE_CODE" VARCHAR2(96)  DEFAULT NULL,
  "URL_NAMES" VARCHAR2(3072)  DEFAULT NULL,
  "PERMISSIONS" VARCHAR2(3072)  DEFAULT NULL,
  "IS_SYS" CHAR(1) DEFAULT '0',
  "SERVICE_NAME" VARCHAR2(192)  DEFAULT NULL,
  "USER_RIGHTS" VARCHAR2(96) DEFAULT NULL,
  "DEPT_RIGHTS" VARCHAR2(96) DEFAULT NULL,
  "MAPPER" VARCHAR2(3072) DEFAULT NULL,
  "APPLICATION_ID" NUMBER(20,0) DEFAULT 1,
  "PARENT_RESOURCE_ID" NUMBER(20,0) DEFAULT NULL
);
COMMENT ON COLUMN "SYS_RESOURCES"."RESOURCE_ID" IS '资源编码';
COMMENT ON COLUMN "SYS_RESOURCES"."RESOURCE_NAME" IS '资源英文名称';
COMMENT ON COLUMN "SYS_RESOURCES"."RESOURCE_ALIAS" IS '资源业务语义';
COMMENT ON COLUMN "SYS_RESOURCES"."MODULE_ID" IS '所属模块ID';
COMMENT ON COLUMN "SYS_RESOURCES"."PATH" IS '组件根路径';
COMMENT ON COLUMN "SYS_RESOURCES"."COMPONENT" IS '组件引入路径';
COMMENT ON COLUMN "SYS_RESOURCES"."IS_AUDIT" IS '是否执行审计操作';
COMMENT ON COLUMN "SYS_RESOURCES"."RES_TYPE_ID" IS '资源操作类型编码';
COMMENT ON COLUMN "SYS_RESOURCES"."SEQ" IS '资源排序';
COMMENT ON COLUMN "SYS_RESOURCES"."IS_REPEAT_AUTHENTICATE" IS '是否二次验证';
COMMENT ON COLUMN "SYS_RESOURCES"."STRATEGY" IS '使用场景（-1：重启，3：预览，2：生产）';
COMMENT ON COLUMN "SYS_RESOURCES"."KEEP_ALIVE" IS '页面激活状态';
COMMENT ON COLUMN "SYS_RESOURCES"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYS_RESOURCES"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_RESOURCES"."LAST_EDITOR" IS '最后修改者';
COMMENT ON COLUMN "SYS_RESOURCES"."LAST_TIME" IS '最后修改时间';
COMMENT ON COLUMN "SYS_RESOURCES"."RESOURCE_CODE" IS '资源编码';
COMMENT ON COLUMN "SYS_RESOURCES"."URL_NAMES" IS 'URL名称';
COMMENT ON COLUMN "SYS_RESOURCES"."PERMISSIONS" IS '权限标识';
COMMENT ON COLUMN "SYS_RESOURCES"."IS_SYS" IS '是否是系统资源';
COMMENT ON COLUMN "SYS_RESOURCES"."SERVICE_NAME" IS '服务标识';
COMMENT ON COLUMN "SYS_RESOURCES"."USER_RIGHTS" IS '用户权限字段';
COMMENT ON COLUMN "SYS_RESOURCES"."DEPT_RIGHTS" IS '部门权限字段';
COMMENT ON COLUMN "SYS_RESOURCES"."MAPPER" IS '数据查询方法';
COMMENT ON COLUMN "SYS_RESOURCES"."APPLICATION_ID" IS '所属应用的id，默认1：属于平台自身数据';
COMMENT ON COLUMN "SYS_RESOURCES"."PARENT_RESOURCE_ID" IS '上级资源id';
COMMENT ON TABLE "SYS_RESOURCES" IS '功能资源';

-- ----------------------------
-- Records of "SYS_RESOURCES"
-- ----------------------------
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (707898381187686401, '设置默认', '设置默认', 707896444421677056, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2023-05-08 10:15:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:15:26','SYYYY-MM-DD HH24:MI:SS'), '02230506', '/hussarBase/queryInfoTable/defaultCondition', 'hussarBase:queryInfoTable:defaultCondition', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (707899978189905921, '取消默认', '取消默认', 707896444421677056, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2023-05-08 10:21:47','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-08 10:21:47','SYYYY-MM-DD HH24:MI:SS'), '02230507', '/hussarBase/queryInfoTable/cancel', 'hussarBase:queryInfoTable:cancel', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004221, '连接池监控', '连接池监控', 523159524811743232, '/poolMonitor', 'HussarOperations/src/views/service/poolMonitor/index', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-04-24 08:58:15','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '002600170044', '/druid', 'druid:druid', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (686146166286721024, '应用管理', '应用管理', 686145219900743680, '/appManage', 'HussarApplication/src/views/appManagement', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, TO_DATE('2023-03-09 09:39:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 13:47:19','SYYYY-MM-DD HH24:MI:SS'), '02160502', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (686146454410240000, '应用回收站', '应用回收站', 686145307951767552, '/RecycleBin', 'HussarApplication/src/views/recycleBin', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, TO_DATE('2023-03-09 09:41:03','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-03-09 13:47:34','SYYYY-MM-DD HH24:MI:SS'), '02170503', '', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689798, '新增微应用配置', '新增微应用配置', 686145219900743680, '', '', '0', 'res_btn', 4, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160509', '/hussarBase/application/micro/addConf', 'hussarBase:application:micro:addConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689799, '修改微应用配置', '修改微应用配置', 686145219900743680, '', '', '0', 'res_btn', 5, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160510', '/hussarBase/application/micro/editConf', 'hussarBase:application:micro:editConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689800, '查询微应用配置', '查询微应用配置', 686145219900743680, '', '', '0', 'res_btn', 6, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160511', '/hussarBase/application/micro/searchConf', 'hussarBase:application:micro:searchConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689801, '删除微应用配置', '删除微应用配置', 686145219900743680, '', '', '0', 'res_btn', 7, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160512', '/hussarBase/application/micro/deleteConf', 'hussarBase:application:micro:deleteConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689802, '查看微应用配置', '查看微应用配置', 686145219900743680, '', '', '0', 'res_btn', 8, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160513', '/hussarBase/application/micro/viewConf', 'hussarBase:application:micro:viewConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689803, '永久删除微应用配置', '永久删除微应用配置', 686145219900743680, '', '', '0', 'res_btn', 9, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160514', '/hussarBase/application/micro/deleteCOnfForever', 'hussarBase:application:micro:deleteCOnfForever', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1594592180406689804, '新增操作记录', '新增操作记录', 686145219900743680, '', '', '0', 'res_btn', 10, '0', '0', NULL, 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-07-21 10:42:25','SYYYY-MM-DD HH24:MI:SS'), '02160515', '/hussarBase/application/micro/addRecord', 'hussarBase:application:micro:addRecord', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (832213263382224896, '人员流程图表查询', '人员流程图表查询', 581434239535554561, '', '', '0', 'res_btn', 15, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-15 11:18:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-15 11:18:24','SYYYY-MM-DD HH24:MI:SS'), '0239000005070154', '/bpm/processCount/queryMultiPersonProcessList', 'bpm:processCount:queryMultiPersonProcessList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (832213414490415104, '人员下钻到对应的流程', '人员下钻到对应的流程', 581434239535554561, '', '', '0', 'res_btn', 16, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-15 11:19:00','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-15 11:19:00','SYYYY-MM-DD HH24:MI:SS'), '0239000005070155', '/bpm/processCount/querySinglePersonProcessList', 'bpm:processCount:querySinglePersonProcessList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (832213491925655552, '流程下钻到节点的审批数和撤回数', '流程下钻到节点的审批数和撤回数', 581434239535554561, '', '', '0', 'res_btn', 17, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-15 11:19:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-15 11:19:18','SYYYY-MM-DD HH24:MI:SS'), '0239000005070156', '/bpm/processCount/querySinglePersonProcessTaskList', 'bpm:processCount:querySinglePersonProcessTaskList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);

INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (831116364617097216, '模糊查询机构列表', '模糊查询机构列表', 815518757266137088, '', '', '0', 'res_rights', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-12 10:39:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-12 10:39:43','SYYYY-MM-DD HH24:MI:SS'), '000000000281000005070248', '', '', '0', '', 'data_holder', 'str.STRU_ID', 'com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper.searchOrganization', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830797989605023744, '删除联系人', '删除联系人', 811594090851606528, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-11 13:34:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:34:36','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070156', '/msg/contact/deleteMsgContact', 'msg:contact:deleteMsgContact', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830797745085489152, '修改联系人', '修改联系人', 811594090851606528, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-11 13:33:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 13:33:38','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070155', '/msg/contact/updateMsgContact', 'msg:contact:updateMsgContact', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830771482190946304, '新增联系人', '新增联系人', 811594090851606528, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-11 11:49:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-11 11:49:16','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070154', '/msg/contact/addMsgContact', 'msg:contact:addMsgContact', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829396173050880000, 'excel导出导入记录保存', 'excel导出导入记录保存', 1450765592889004693, '', '', '0', 'res_btn', 29, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 16:44:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 16:44:17','SYYYY-MM-DD HH24:MI:SS'), '102000005070156', '/hussarBase/excel/newExcelTask', 'hussarBase:excel:newExcelTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829397564452511744, '获取导入导出信息列表', '获取导入导出信息列表', 1450765592889004693, '', '', '0', 'res_btn', 30, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 16:49:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 16:49:49','SYYYY-MM-DD HH24:MI:SS'), '102000005070157', '/hussarBase/excel/searchExcelTask', 'hussarBase:excel:searchExcelTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829397905482981376, 'excel文件下载', 'excel文件下载', 1450765592889004693, '', '', '0', 'res_btn', 31, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 16:51:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 16:51:10','SYYYY-MM-DD HH24:MI:SS'), '102000005070158', '/hussarBase/excel/downloadExcelFile', 'hussarBase:excel:downloadExcelFile', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829405596385288192, '分页查询人员列表(表格)', '分页查询人员列表(表格)', 1450765592889004578, '', '', '0', 'res_btn', 23, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:21:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:21:44','SYYYY-MM-DD HH24:MI:SS'), '103000005070161', '/hussarBase/authorization/staff/list', 'hussarBase:authorization:staff:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829406184619646976, '保存人员排序', '保存人员排序', 1450765592889004578, '', '', '0', 'res_btn', 24, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:24:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:24:04','SYYYY-MM-DD HH24:MI:SS'), '103000005070162', '/hussarBase/authorization/staff/sortUnifyStaff', 'hussarBase:authorization:staff:sortUnifyStaff', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829409027523092480, '查询岗位列表数据', '查询岗位列表数据', 688348352496279552, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:35:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:35:22','SYYYY-MM-DD HH24:MI:SS'), '0218000005070163', '/hussarBase/authorization/post/pageList', 'hussarBase:authorization:post:pageList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829409275322572800, '新增岗位', '新增岗位', 688348352496279552, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:36:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:36:21','SYYYY-MM-DD HH24:MI:SS'), '0218000005070164', '/hussarBase/authorization/post/add', 'hussarBase:authorization:post:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829409533184188416, '修改岗位', '修改岗位', 688348352496279552, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:37:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:37:22','SYYYY-MM-DD HH24:MI:SS'), '0218000005070165', '/hussarBase/authorization/post/edit', 'hussarBase:authorization:post:edit', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829409805990109184, '删除岗位', '删除岗位', 688348352496279552, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 17:38:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 17:38:27','SYYYY-MM-DD HH24:MI:SS'), '0218000005070166', '/hussarBase/authorization/post/delete', 'hussarBase:authorization:post:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829416135417143296, '保存角色岗位', '保存角色岗位', 1450765592889004740, '', '', '0', 'res_btn', 26, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:03:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:03:36','SYYYY-MM-DD HH24:MI:SS'), '202000005070167', '/hussarBase/authorization/permit/role/savePost', 'hussarBase:authorization:permit:role:savePost', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829418436286488576, '保存角色组织', '保存角色组织', 1450765592889004740, '', '', '0', 'res_btn', 27, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:12:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:12:45','SYYYY-MM-DD HH24:MI:SS'), '202000005070168', '/hussarBase/authorization/permit/role/saveOrgan', 'hussarBase:authorization:permit:role:saveOrgan', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829418705640497152, '角色关联用户批量查询', '角色关联用户批量查询', 1450765592889004740, '', '', '0', 'res_btn', 28, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:13:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:13:49','SYYYY-MM-DD HH24:MI:SS'), '202000005070169', '/roleManagerFront/searchUserListBatch', 'roleManagerFront:searchUserListBatch', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829419102467792896, '保存角色功能', '保存角色功能', 1450765592889004740, '', '', '0', 'res_btn', 29, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:15:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:15:24','SYYYY-MM-DD HH24:MI:SS'), '202000005070170', '/roleManagerFront/saveFunction', 'roleManagerFront:saveFunction', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829419565481205760, '保存角色资源', '保存角色资源', 1450765592889004740, '', '', '0', 'res_btn', 30, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:17:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:17:14','SYYYY-MM-DD HH24:MI:SS'), '202000005070171', '/roleManagerFront/saveRealResource', 'roleManagerFront:saveRealResource', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829420846300012544, '保存或修改功能模块', '保存或修改功能模块', 523074819135381504, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:22:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:22:20','SYYYY-MM-DD HH24:MI:SS'), '0221000005070172', '/resourceFront/saveFunModule', 'resourceFront:saveFunModule', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829421115242979328, '保存或修改功能和功能资源关联', '保存或修改功能和功能资源关联', 523074819135381504, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:23:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:23:24','SYYYY-MM-DD HH24:MI:SS'), '0221000005070173', '/resourceFront/saveFunRes', 'resourceFront:saveFunRes', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829421306264166400, '功能模块下级排序', '功能模块下级排序', 523074819135381504, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:24:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:24:09','SYYYY-MM-DD HH24:MI:SS'), '0221000005070174', '/resourceFront/functionModuleTreeOrder', 'resourceFront:functionModuleTreeOrder', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829421877826166784, '删除功能模块', '删除功能模块', 523074819135381504, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-07 18:26:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-07 18:26:26','SYYYY-MM-DD HH24:MI:SS'), '0221000005070175', '/resourceFront/delFunctionModules', 'resourceFront:delFunctionModules', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829640021417140224, '新增快捷方式分组', '新增快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 08:53:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 08:53:15','SYYYY-MM-DD HH24:MI:SS'), '02010208000005070176', '/shortcutGroupConfig/add', 'shortcutGroupConfig:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829643935965257728, '修改快捷方式分组', '修改快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:08:48','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:08:48','SYYYY-MM-DD HH24:MI:SS'), '02010208000005070177', '/shortcutGroupConfig/update', 'shortcutGroupConfig:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829644343521583104, '删除快捷方式分组', '删除快捷方式分组', 1450765592889004623, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:10:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:10:26','SYYYY-MM-DD HH24:MI:SS'), '02010208000005070178', '/shortcutGroupConfig/delete', 'shortcutGroupConfig:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829644682744307712, '控制台保存新增的快捷入口', '控制台保存新增的快捷入口', 1450765592889004623, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:11:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:11:46','SYYYY-MM-DD HH24:MI:SS'), '02010208000005070179', '/shortcutConfig/add', 'shortcutConfig:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829644897207459840, '删除快捷入口', '删除快捷入口', 1450765592889004623, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:12:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:12:38','SYYYY-MM-DD HH24:MI:SS'), '02010208000005070180', '/shortcutConfig/delete', 'shortcutConfig:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829645143585071104, '修改登录页/欢迎页可视化配置信息', '修改登录页/欢迎页可视化配置信息', 1450765592889004689, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:13:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:13:36','SYYYY-MM-DD HH24:MI:SS'), '02010203000005070181', '/sysBaseConfigFront/viewUpdate', 'sysBaseConfigFront:viewUpdate', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829645533818920960, '添加应用', '添加应用', 595571579120001024, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:15:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:15:09','SYYYY-MM-DD HH24:MI:SS'), '0215000005070182', '/mobile/application/addApp', 'mobile:application:addApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829646158434672640, '修改应用', '修改应用', 595571579120001024, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:17:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:17:38','SYYYY-MM-DD HH24:MI:SS'), '0215000005070183', '/mobile/application/updateApp', 'mobile:application:updateApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829646695037149184, '删除应用', '删除应用', 595571579120001024, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:19:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:19:46','SYYYY-MM-DD HH24:MI:SS'), '0215000005070184', '/mobile/application/deleteApp', 'mobile:application:deleteApp', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829646829514924032, '添加或修改分组', '添加或修改分组', 595571579120001024, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:20:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:20:18','SYYYY-MM-DD HH24:MI:SS'), '0215000005070185', '/mobile/application/group/insertOrUpdateGroup', 'mobile:application:group:insertOrUpdateGroup', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829647470169694208, '保存三方集成配置信息', '保存三方集成配置信息', 595571579120001024, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:22:51','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:22:51','SYYYY-MM-DD HH24:MI:SS'), '0215000005070186', '/mobile/external/saveConfig', 'mobile:external:saveConfig', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829648871130144768, '删除分组', '删除分组', 595571579120001024, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:28:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:28:25','SYYYY-MM-DD HH24:MI:SS'), '0215000005070187', '/mobile/application/group/delete', 'mobile:application:group:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829649753250996224, '查询流程管理页面', '查询流程管理页面', 523177185453023232, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:31:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:31:55','SYYYY-MM-DD HH24:MI:SS'), '0234000005070188', '/bpm/model/modelQuery', 'bpm:model:modelQuery', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829650049343692800, '展示流程定义列表', '展示流程定义列表', 523177185453023232, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:33:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:33:06','SYYYY-MM-DD HH24:MI:SS'), '0234000005070189', '/bpm/processDefinition/queryProcessDefinitionsList', 'bpm:processDefinition:queryProcessDefinitionsList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829650386460876800, '设置主版本', '设置主版本', 523177185453023232, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:34:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:34:26','SYYYY-MM-DD HH24:MI:SS'), '0234000005070190', '/bpm/processDefinition/setMain', 'bpm:processDefinition:setMain', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829650645429788672, '取消主版本', '取消主版本', 523177185453023232, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:35:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:35:28','SYYYY-MM-DD HH24:MI:SS'), '0234000005070191', '/bpm/processDefinition/cancelMain', 'bpm:processDefinition:cancelMain', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829650996014882816, '删除流程模型', '删除流程模型', 523177185453023232, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:36:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:36:52','SYYYY-MM-DD HH24:MI:SS'), '0234000005070192', '/bpm/model/deleteModel', 'bpm:model:deleteModel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829651441592573952, '删除流程定义', '删除流程定义', 523177185453023232, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:38:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:38:38','SYYYY-MM-DD HH24:MI:SS'), '0234000005070193', '/bpm/model/deleteModelWithVersion', 'bpm:model:deleteModelWithVersion', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829652277517361152, '展示流程实例列表', '展示流程实例列表', 523177216750919680, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:41:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:41:57','SYYYY-MM-DD HH24:MI:SS'), '0235000005070194', '/bpm/processInst/getProcessList', 'bpm:processInst:getProcessList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829652497630240768, '查询意见列表', '查询意见列表', 523177216750919680, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:42:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:42:50','SYYYY-MM-DD HH24:MI:SS'), '0235000005070195', '/bpm/processInst/getProcessDetailList', 'bpm:processInst:getProcessDetailList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829653024451600384, '修改意见', '修改意见', 523177216750919680, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:44:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:44:55','SYYYY-MM-DD HH24:MI:SS'), '0235000005070196', '/bpm/processInst/updateComments', 'bpm:processInst:updateComments', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829653344305029120, '重启流程到目标节点', '重启流程到目标节点', 523177216750919680, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:46:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:46:12','SYYYY-MM-DD HH24:MI:SS'), '0235000005070197', '/bpm/processInst/reStartProcess', 'bpm:processInst:reStartProcess', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829653604154744832, '挂起流程实例', '挂起流程实例', 523177216750919680, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:47:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:47:13','SYYYY-MM-DD HH24:MI:SS'), '0235000005070198', '/bpm/processInst/suspendProcessById', 'bpm:processInst:suspendProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829654027020279808, '终结流程实例', '终结流程实例', 523177216750919680, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:48:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:48:54','SYYYY-MM-DD HH24:MI:SS'), '0235000005070199', '/bpm/processInst/endProcessByProcessInsId', 'bpm:processInst:endProcessByProcessInsId', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829654374266707968, '删除选中的流程实例', '删除选中的流程实例', 523177216750919680, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:50:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:50:17','SYYYY-MM-DD HH24:MI:SS'), '0235000005070200', '/bpm/processInst/deleteProcessById', 'bpm:processInst:deleteProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829654700084436992, '激活流程实例', '激活流程实例', 523177216750919680, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:51:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:51:35','SYYYY-MM-DD HH24:MI:SS'), '0235000005070201', '/bpm/processInst/activateProcessById', 'bpm:processInst:activateProcessById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829655545685483520, '查询流程任务', '查询流程任务', 523177259834810368, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:54:56','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:54:56','SYYYY-MM-DD HH24:MI:SS'), '0236000005070202', '/bpm/taskManager/getTaskManager', 'bpm:taskManager:getTaskManager', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829655991439335424, '直接审批', '直接审批', 523177259834810368, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:56:43','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:56:43','SYYYY-MM-DD HH24:MI:SS'), '0236000005070203', '/bpm/taskManager/completeTask', 'bpm:taskManager:completeTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829656306565783552, '修改参与者', '修改参与者', 523177259834810368, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 09:57:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 09:57:58','SYYYY-MM-DD HH24:MI:SS'), '0236000005070204', '/bpm/taskManager/entrustTaskByTaskId', 'bpm:taskManager:entrustTaskByTaskId', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829656910411341824, '自由跳转', '自由跳转', 523177259834810368, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:00:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:00:22','SYYYY-MM-DD HH24:MI:SS'), '0236000005070206', '/bpm/taskManager/freeJump', 'bpm:taskManager:freeJump', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829656993349509120, '自由驳回', '自由驳回', 523177259834810368, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:00:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:00:42','SYYYY-MM-DD HH24:MI:SS'), '0236000005070207', '/bpm/taskManager/rejectToLastTask', 'bpm:taskManager:rejectToLastTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829657336850423808, '催办', '催办', 523177259834810368, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:02:03','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:02:03','SYYYY-MM-DD HH24:MI:SS'), '0236000005070208', '/bpm/taskManager/urgeTask', 'bpm:taskManager:urgeTask', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829657750480101376, '挂起', '挂起', 523177259834810368, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:03:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:03:42','SYYYY-MM-DD HH24:MI:SS'), '0236000005070209', '/bpm/taskManager/suspendTaskById', 'bpm:taskManager:suspendTaskById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829658073546366976, '激活', '激活', 523177259834810368, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:04:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:04:59','SYYYY-MM-DD HH24:MI:SS'), '0236000005070210', '/bpm/taskManager/activateTaskById', 'bpm:taskManager:activateTaskById', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829661188479787008, '获取函数列表', '获取函数列表', 523177287164895232, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:17:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:17:22','SYYYY-MM-DD HH24:MI:SS'), '0237000005070211', '/bpm/function/getList', 'bpm:function:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829662709275697152, '新增函数', '新增函数', 523177287164895232, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:23:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:23:24','SYYYY-MM-DD HH24:MI:SS'), '0237000005070212', '/bpm/function/add', 'bpm:function:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829662870085312512, '修改函数', '修改函数', 523177287164895232, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:24:03','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:24:03','SYYYY-MM-DD HH24:MI:SS'), '0237000005070213', '/bpm/function/update', 'bpm:function:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829663227851055104, '删除函数', '删除函数', 523177287164895232, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:25:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:25:28','SYYYY-MM-DD HH24:MI:SS'), '0237000005070214', '/bpm/function/delete', 'bpm:function:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829663627639529472, '工作流配置列表查询', '工作流配置列表查询', 673548858558783488, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:27:03','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:27:03','SYYYY-MM-DD HH24:MI:SS'), '0218000005070215', '/bpmConfigFront/getList', 'bpmConfigFront:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829663972935606272, '获取所属配置项', '获取所属配置项', 673548858558783488, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:28:26','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:28:26','SYYYY-MM-DD HH24:MI:SS'), '0218000005070216', '/bpmConfigFront/configList', 'bpmConfigFront:configList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829664147154411520, '修改配置', '修改配置', 673548858558783488, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:29:07','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:29:07','SYYYY-MM-DD HH24:MI:SS'), '0218000005070217', '/bpmConfigFront/update', 'bpmConfigFront:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829664689603747840, '表单查询', '表单查询', 706807109840543744, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:31:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:31:16','SYYYY-MM-DD HH24:MI:SS'), '0215000005070218', '/bpm/formInfo/queryCustomFormByName', 'bpm:formInfo:queryCustomFormByName', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829664987747459072, '分类树查询', '分类树查询', 706807109840543744, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:32:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:32:28','SYYYY-MM-DD HH24:MI:SS'), '0215000005070219', '/bpm/category/categoryTree', 'bpm:category:categoryTree', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829665433849438208, '新增分类', '新增分类', 706807109840543744, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:34:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:34:14','SYYYY-MM-DD HH24:MI:SS'), '0215000005070220', '/bpm/category/add', 'bpm:category:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829666039490158592, '修改分类', '修改分类', 706807109840543744, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:36:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:36:38','SYYYY-MM-DD HH24:MI:SS'), '0215000005070221', '/bpm/category/update', 'bpm:category:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829666121014845440, '删除分类', '删除分类', 706807109840543744, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:36:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:36:58','SYYYY-MM-DD HH24:MI:SS'), '0215000005070222', '/bpm/category/delete', 'bpm:category:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829666955555512320, '新增表单', '新增表单', 706807109840543744, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:40:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:40:17','SYYYY-MM-DD HH24:MI:SS'), '0215000005070223', '/bpm/formInfo/add', 'bpm:formInfo:add', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829667053261824000, '修改表单', '修改表单', 706807109840543744, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:40:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:40:40','SYYYY-MM-DD HH24:MI:SS'), '0215000005070224', '/bpm/formInfo/update', 'bpm:formInfo:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829667187232088064, '删除表单', '删除表单', 706807109840543744, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:41:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:41:12','SYYYY-MM-DD HH24:MI:SS'), '0215000005070225', '/bpm/formInfo/delete', 'bpm:formInfo:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829667364462403584, '表单详情', '表单详情', 706807109840543744, '', '', '0', 'res_btn', 10, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:41:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:41:54','SYYYY-MM-DD HH24:MI:SS'), '0215000005070226', '/bpm/formInfo/detail', 'bpm:formInfo:detail', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829669690359160832, '设置是否灰屏', '设置是否灰屏', 544468727815741440, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:51:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:51:09','SYYYY-MM-DD HH24:MI:SS'), '0215000005070227', '/themeConfig/updateGreyScreenApplication', 'themeConfig:updateGreyScreenApplication', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829670011496046592, '导入主题', '导入主题', 544468727815741440, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:52:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:52:25','SYYYY-MM-DD HH24:MI:SS'), '0215000005070228', '/themeConfig/importTheme', 'themeConfig:importTheme', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829670236050694144, '根据主题ID更换当前主题', '根据主题ID更换当前主题', 544468727815741440, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 10:53:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 10:53:19','SYYYY-MM-DD HH24:MI:SS'), '0215000005070229', '/themeConfig/updateThemeCurrentApplication', 'themeConfig:updateThemeCurrentApplication', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829682927825854464, '获取所有字典列表', '获取所有字典列表', 1450765592889004593, '', '', '0', 'res_btn', 21, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 11:43:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 11:43:45','SYYYY-MM-DD HH24:MI:SS'), '字典管理000005070241', '/dicFront/getList', 'dicFront:getList', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829685650679930880, '修改字典类别', '修改字典类别', 1450765592889004593, '', '', '0', 'res_btn', 22, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 11:54:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 14:28:56','SYYYY-MM-DD HH24:MI:SS'), '字典管理000005070243', '/dicFront/update', 'dict:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829713899439005696, '获取冻结密码的缓存列表', '获取冻结密码的缓存列表', 1450765592889004746, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 13:46:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 13:46:49','SYYYY-MM-DD HH24:MI:SS'), 'null0139000005070246', '/hussarBase/operations/secure/getFreezeList', 'hussarBase:operations:secure:getFreezeList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829714279975624704, '解冻密码', '解冻密码', 1450765592889004746, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 13:48:20','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 13:48:20','SYYYY-MM-DD HH24:MI:SS'), 'null0139000005070248', '/hussarBase/operations/secure/unfreezeSecureUser', 'hussarBase:operations:secure:unfreezeSecureUser', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829717443915292672, '客户端修改保存', '客户端修改保存', 518447803329159168, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 14:00:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 14:00:54','SYYYY-MM-DD HH24:MI:SS'), '0225000005070249', '/hussarBase/client/update', 'hussarBase:client:update', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829717560286257152, '客户端新增保存', '客户端新增保存', 518447803329159168, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 14:01:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 14:01:22','SYYYY-MM-DD HH24:MI:SS'), '0225000005070250', '/hussarBase/client/save', 'hussarBase:client:save', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829717677168926720, '客户端删除', '客户端删除', 518447803329159168, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 14:01:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 14:01:50','SYYYY-MM-DD HH24:MI:SS'), '0225000005070251', '/hussarBase/client/delete', 'hussarBase:client:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004022730825728, '应用信息分页查询', '应用信息分页查询', 546336605821214720, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 08:59:40','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 08:59:40','SYYYY-MM-DD HH24:MI:SS'), '0216000005070173', '/appInfo/page', 'appInfo:page', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004144281755648, '新增应用', '新增应用', 546336605821214720, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:00:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:00:09','SYYYY-MM-DD HH24:MI:SS'), '0216000005070174', '/appInfo/save', 'appInfo:save', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004255158181888, '删除应用', '删除应用', 546336605821214720, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:00:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:00:35','SYYYY-MM-DD HH24:MI:SS'), '0216000005070175', '/appInfo/delete', 'appInfo:delete', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004361634783232, '验证应用', '验证应用', 546336605821214720, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:01:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:01:01','SYYYY-MM-DD HH24:MI:SS'), '0216000005070176', '/appInfo/assert', 'appInfo:assert', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004507340709888, '查询应用列表', '查询应用列表', 544474526055145472, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:01:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:01:35','SYYYY-MM-DD HH24:MI:SS'), '0221000005070177', '/appInfo/list', 'appInfo:list', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830004656615989248, '验证appName的可用性', '验证appName的可用性', 544474526055145472, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:02:11','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:02:11','SYYYY-MM-DD HH24:MI:SS'), '0221000005070178', '/server/assert', 'server:assert', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830005036611543040, '分页查询任务列表', '分页查询任务列表', 544474526055145472, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:03:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:03:41','SYYYY-MM-DD HH24:MI:SS'), '0221000005070179', '/job/list', 'job:list', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830005823991455744, '保存任务', '保存任务', 544474526055145472, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:06:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:06:49','SYYYY-MM-DD HH24:MI:SS'), '0221000005070180', '/job/save', 'job:save', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830005916287115264, '运行任务', '运行任务', 544474526055145472, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:07:11','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:07:11','SYYYY-MM-DD HH24:MI:SS'), '0221000005070181', '/job/run', 'job:run', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830005995823702016, '验证时间表达式是否正确', '验证时间表达式是否正确', 544474526055145472, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:07:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:07:30','SYYYY-MM-DD HH24:MI:SS'), '0221000005070182', '/validate/timeExpression', 'validate:timeExpression', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006117668233216, '停止任务', '停止任务', 544474526055145472, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:07:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:08:13','SYYYY-MM-DD HH24:MI:SS'), '0221000005070183', '/job/disable', 'job:disable', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006238078312448, '删除任务', '删除任务', 544474526055145472, '', '', '0', 'res_btn', 9, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:08:28','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:08:28','SYYYY-MM-DD HH24:MI:SS'), '0221000005070184', '/job/delete', 'job:delete', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006404764147712, '查询任务实例列表', '查询任务实例列表', 544474679767998464, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:09:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:09:08','SYYYY-MM-DD HH24:MI:SS'), '0222000005070185', '/instance/list', 'instance:list', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006476339945472, '重试任务实例', '重试任务实例', 544474679767998464, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:09:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:09:25','SYYYY-MM-DD HH24:MI:SS'), '0222000005070186', '/instance/retry', 'instance:retry', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006610553479168, '停止任务实例', '停止任务实例', 544474679767998464, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:09:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:09:57','SYYYY-MM-DD HH24:MI:SS'), '0222000005070187', '/instance/stop', 'instance:stop', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830006682578067456, '查询任务实例详情', '查询任务实例详情', 544474679767998464, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 09:10:14','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 09:10:14','SYYYY-MM-DD HH24:MI:SS'), '0222000005070188', '/instance/detail', 'instance:detail', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829755619782434816, '人员审核列表', '人员审核列表', 523064540137791488, '', '', '0', 'res_btn', 23, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:32:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:32:36','SYYYY-MM-DD HH24:MI:SS'), '0217000005070154', '/hussarBase/authorization/staffAudit/list', 'hussarBase:authorization:staffAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829756888681029632, '人员审核详情接口', '人员审核详情接口', 523064540137791488, '', '', '0', 'res_btn', 24, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:37:38','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:37:38','SYYYY-MM-DD HH24:MI:SS'), '0217000005070155', '/hussarBase/authorization/staffAudit/detail', 'hussarBase:authorization:staffAudit:detail', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829757218558844928, '人员审核通过', '人员审核通过', 523064540137791488, '', '', '0', 'res_btn', 25, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:38:57','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:38:57','SYYYY-MM-DD HH24:MI:SS'), '0217000005070156', '/hussarBase/authorization/staffAudit/pass', 'hussarBase:authorization:staffAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829757625855123456, '岗位审核列表', '岗位审核列表', 688348425015795712, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:40:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:40:34','SYYYY-MM-DD HH24:MI:SS'), '0219000005070157', '/hussarBase/authorization/postAudit/list', 'hussarBase:authorization:postAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829757993632669696, '获取岗位审核信息详情', '获取岗位审核信息详情', 688348425015795712, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:42:02','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:42:02','SYYYY-MM-DD HH24:MI:SS'), '0219000005070158', '/hussarBase/authorization/postAudit/detail', 'hussarBase:authorization:postAudit:detail', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829759282911387648, '用户组织审核列表', '用户组织审核列表', 714498130460286976, '', '', '0', 'res_btn', 17, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:47:09','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:47:09','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070159', '/hussarBase/authorization/struUserAudit/list', 'hussarBase:authorization:struUserAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829759667151577088, '用户组织审核通过', '用户组织审核通过', 714498130460286976, '', '', '0', 'res_btn', 18, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:48:41','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:48:41','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070160', '/hussarBase/authorization/struUserAudit/pass', 'hussarBase:authorization:struUserAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829759771719770112, '用户组织审核驳回', '用户组织审核驳回', 714498130460286976, '', '', '0', 'res_btn', 19, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:49:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:49:06','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070161', '/hussarBase/authorization/struUserAudit/reject', 'hussarBase:authorization:struUserAudit:reject', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829761477207662592, '用户岗位审核列表', '用户岗位审核列表', 714502896477282304, '', '', '0', 'res_btn', 20, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:55:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:55:52','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070162', '/hussarBase/authorization/userPostAudit/list', 'hussarBase:authorization:userPostAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829761610313900032, '用户岗位审核通过', '用户岗位审核通过', 714502896477282304, '', '', '0', 'res_btn', 21, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:56:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:56:24','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070163', '/hussarBase/authorization/userPostAudit/pass', 'hussarBase:authorization:userPostAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829761705788841984, '用户岗位审核驳回', '用户岗位审核驳回', 714502896477282304, '', '', '0', 'res_btn', 22, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 16:56:47','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 16:56:47','SYYYY-MM-DD HH24:MI:SS'), '00760090000005070164', '/hussarBase/authorization/userPostAudit/reject', 'hussarBase:authorization:userPostAudit:reject', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829763516436324352, '组织角色审核列表', '组织角色审核列表', 714486973070581760, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:03:59','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:03:59','SYYYY-MM-DD HH24:MI:SS'), '0220000005070165', '/hussarBase/authorization/struRoleAudit/list', 'hussarBase:authorization:struRoleAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829763853897441280, '组织角色审核通过', '组织角色审核通过', 714486973070581760, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:05:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:05:19','SYYYY-MM-DD HH24:MI:SS'), '0220000005070166', '/hussarBase/authorization/struRoleAudit/pass', 'hussarBase:authorization:struRoleAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829763981664329728, '组织角色审核驳回', '组织角色审核驳回', 714486973070581760, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:05:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:05:50','SYYYY-MM-DD HH24:MI:SS'), '0220000005070167', '/hussarBase/authorization/struRoleAudit/reject', 'hussarBase:authorization:struRoleAudit:reject', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829764556023930880, '岗位角色审核列表', '岗位角色审核列表', 714487678439268352, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:08:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:08:06','SYYYY-MM-DD HH24:MI:SS'), '0221000005070168', '/hussarBase/authorization/postRoleAudit/list', 'hussarBase:authorization:postRoleAudit:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829764670033502208, '岗位角色审核通过', '岗位角色审核通过', 714487678439268352, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:08:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:08:34','SYYYY-MM-DD HH24:MI:SS'), '0221000005070169', '/hussarBase/authorization/postRoleAudit/pass', 'hussarBase:authorization:postRoleAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829764752225083392, '岗位角色审核驳回', '岗位角色审核驳回', 714487678439268352, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:08:53','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:08:53','SYYYY-MM-DD HH24:MI:SS'), '0221000005070170', '/hussarBase/authorization/postRoleAudit/reject', 'hussarBase:authorization:postRoleAudit:reject', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829765472026370048, '岗位审核驳回', '岗位审核驳回', 688348425015795712, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:11:45','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:11:45','SYYYY-MM-DD HH24:MI:SS'), '0219000005070171', '/hussarBase/authorization/postAudit/reject', 'hussarBase:authorization:postAudit:reject', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (829765606491561984, '岗位审核通过', '岗位审核通过', 688348425015795712, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-08 17:12:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-08 17:12:17','SYYYY-MM-DD HH24:MI:SS'), '0219000005070172', '/hussarBase/authorization/postAudit/pass', 'hussarBase:authorization:postAudit:pass', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021062573170688, '获取各种流程信息数据', '获取各种流程信息数据', 830015977810042880, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:07:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:07:44','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070189', '/bpm/processCount/queryProcessCountModel', 'bpm:processCount:queryProcessCountModel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021376315498496, '统计最近7天每天新增及完成的任务实例数量', '统计最近7天每天新增及完成的任务实例数量', 830015977810042880, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:08:37','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:08:37','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070190', '/bpm/processCount/getDayChangeCountModel', 'bpm:processCount:getDayChangeCountModel', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021462655246336, '获取所有流程实例相关统计数量', '获取所有流程实例相关统计数量', 830015977810042880, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:08:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:08:58','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070191', '/bpm/processCount/queryAllProcessCountMsg', 'bpm:processCount:queryAllProcessCountMsg', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021550685298688, '流程统计明细', '流程统计明细', 830015977810042880, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:09:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:09:19','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070192', '/bpm/processCount/queryProcessInstanceDetail', 'bpm:processCount:queryProcessInstanceDetail', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021682168340480, '获取流程树', '获取流程树', 830016425195479040, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:09:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:09:50','SYYYY-MM-DD HH24:MI:SS'), '000000000274000005070193', '/bpm/processCount/queryProcessTree', 'bpm:processCount:queryProcessTree', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021803991900160, '获取流程实例状态', '获取流程实例状态', 830016425195479040, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:10:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:10:19','SYYYY-MM-DD HH24:MI:SS'), '000000000274000005070194', '/bpm/processCount/queryProcessStatusForChart', 'bpm:processCount:queryProcessStatusForChart', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021917498155008, '查询流程实例状态列表接口', '查询流程实例状态列表接口', 830016425195479040, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:10:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:10:46','SYYYY-MM-DD HH24:MI:SS'), '000000000274000005070195', '/bpm/processCount/queryProcessStatusForList', 'bpm:processCount:queryProcessStatusForList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830021996233629696, '流程状态分析,运行实例数下钻接口', '流程状态分析,运行实例数下钻接口', 830016425195479040, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:11:05','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:11:05','SYYYY-MM-DD HH24:MI:SS'), '000000000274000005070196', '/bpm/processCount/queryProcessTaskStatusList', 'bpm:processCount:queryProcessTaskStatusList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022191411372032, '参与者流程查询柱状图、折线图接口', '参与者流程查询柱状图、折线图接口', 830016458288537600, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:11:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:11:52','SYYYY-MM-DD HH24:MI:SS'), '000000000275000005070197', '/bpm/processCount/queryParticipateProcessForChart', 'bpm:processCount:queryParticipateProcessForChart', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022276195033088, '参与者流程查询列表接口', '参与者流程查询列表接口', 830016458288537600, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:12:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:12:12','SYYYY-MM-DD HH24:MI:SS'), '000000000275000005070198', '/bpm/processCount/queryParticipateProcessForList', 'bpm:processCount:queryParticipateProcessForList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022372546584576, '参与者流程查询,实例数下钻接口', '参与者流程查询,实例数下钻接口', 830016458288537600, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:12:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:12:35','SYYYY-MM-DD HH24:MI:SS'), '000000000275000005070199', '/bpm/processCount/queryParticipateProcessNumberDrill', 'bpm:processCount:queryParticipateProcessNumberDrill', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022480885456896, '流程参与者分析:操作数下钻接口', '流程参与者分析:操作数下钻接口', 830016458288537600, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:13:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:13:01','SYYYY-MM-DD HH24:MI:SS'), '000000000275000005070200', '/bpm/processCount/queryParticipateTaskNumberDrill', 'bpm:processCount:queryParticipateTaskNumberDrill', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022620929073152, '流程统计查询列表接口', '流程统计查询列表接口', 830016495609454592, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:13:34','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:13:34','SYYYY-MM-DD HH24:MI:SS'), '000000000276000005070201', '/bpm/processCount/queryProcessStatisticForList', 'bpm:processCount:queryProcessStatisticForList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022710133530624, '流程统计查询柱状图接口', '流程统计查询柱状图接口', 830016495609454592, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:13:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:13:55','SYYYY-MM-DD HH24:MI:SS'), '000000000276000005070202', '/bpm/processCount/queryProcessStatisticForChart', 'bpm:processCount:queryProcessStatisticForChart', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830022940199493632, '热门流程查询', '热门流程查询', 581434239535554561, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:14:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:14:50','SYYYY-MM-DD HH24:MI:SS'), '0239000005070203', '/bpm/processCount/queryHotProcess', 'bpm:processCount:queryHotProcess', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023058038464512, '流程数量查询接口', '流程数量查询接口', 581434239535554561, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:15:18','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:15:18','SYYYY-MM-DD HH24:MI:SS'), '0239000005070204', '/bpm/processCount/queryProcessNumberList', 'bpm:processCount:queryProcessNumberList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023536881180672, '待办任务分析', '待办任务分析', 581434239535554561, '', '', '0', 'res_btn', 11, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:17:12','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:17:12','SYYYY-MM-DD HH24:MI:SS'), '0239000005070208', '/bpm/processCount/queryInstanceTodoTaskCount', 'bpm:processCount:queryInstanceTodoTaskCount', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023676643778560, '待办任务分析下钻节点待办数量', '待办任务分析下钻节点待办数量', 581434239535554561, '', '', '0', 'res_btn', 12, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:17:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:17:46','SYYYY-MM-DD HH24:MI:SS'), '0239000005070209', '/bpm/processCount/queryInstanceTodoTaskCountByProcessKey', 'bpm:processCount:queryInstanceTodoTaskCountByProcessKey', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023767886667776, '驳回次数排行流程列表', '驳回次数排行流程列表', 581434239535554561, '', '', '0', 'res_btn', 13, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:18:07','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:18:07','SYYYY-MM-DD HH24:MI:SS'), '0239000005070210', '/bpm/processCount/queryHotRejectProcessList', 'bpm:processCount:queryHotRejectProcessList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023867467833344, '查询任务节点驳回次数排行', '查询任务节点驳回次数排行', 581434239535554561, '', '', '0', 'res_btn', 14, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:18:31','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:18:31','SYYYY-MM-DD HH24:MI:SS'), '0239000005070211', '/bpm/processCount/queryNodeRejectCount', 'bpm:processCount:queryNodeRejectCount', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830023991669563392, '统计特定时间段内，平均流程完成时间', '统计特定时间段内，平均流程完成时间', 830016532078927872, '', '', '0', 'res_btn', 1, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:19:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:19:01','SYYYY-MM-DD HH24:MI:SS'), '000000000277000005070212', '/bpm/processCount/queryProcessConsumeTime', 'bpm:processCount:queryProcessConsumeTime', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830024090978099200, '统计特定时间段内指定流程各节点耗时', '统计特定时间段内指定流程各节点耗时', 830016532078927872, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:19:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:19:24','SYYYY-MM-DD HH24:MI:SS'), '000000000277000005070213', '/bpm/processCount/queryNodeConsumeTimeByProcessKey', 'bpm:processCount:queryNodeConsumeTimeByProcessKey', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830025119551463424, '查询在线用户列表', '查询在线用户列表', 1450765592889004700, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:23:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:23:30','SYYYY-MM-DD HH24:MI:SS'), '505000005070215', '/onlineFront/getList', 'onlineFront:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830025211385749504, '获取系统审计日志列表', '获取系统审计日志列表', 1450765592889004700, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:23:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:23:52','SYYYY-MM-DD HH24:MI:SS'), '505000005070216', '/baseAuditLog/getAuditLogList', 'baseAuditLog:getAuditLogList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830025591993671680, '系统监控', '系统监控', 1450765592889004660, '', '', '0', 'res_btn', 2, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:25:22','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:25:22','SYYYY-MM-DD HH24:MI:SS'), '00260016000005070218', '/monitor', 'monitor', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830025762240471040, '慢SQL监控列表', '慢SQL监控列表', 523159993936257024, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:26:03','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:26:03','SYYYY-MM-DD HH24:MI:SS'), '0232000005070219', '/sqlMonitorFront/getList', 'sqlMonitorFront:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830025936044040192, '获取日志开关状态', '获取日志开关状态', 592385645452992512, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:26:44','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:26:44','SYYYY-MM-DD HH24:MI:SS'), '0217000005070220', '/getLogConfig/isLogOpen', 'getLogConfig:isLogOpen', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026026829750272, '分页查询日志告警规则', '分页查询日志告警规则', 592385645452992512, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:27:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:27:06','SYYYY-MM-DD HH24:MI:SS'), '0217000005070221', '/logWarnRule/list', 'logWarnRule:list', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026147629899776, '保存日志告警规则', '保存日志告警规则', 592385645452992512, '', '', '0', 'res_btn', 5, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:27:35','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:27:35','SYYYY-MM-DD HH24:MI:SS'), '0217000005070222', '/logWarnRule/save', 'logWarnRule:save', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026229305581568, '删除日志告警规则', '删除日志告警规则', 592385645452992512, '', '', '0', 'res_btn', 6, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:27:54','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:27:54','SYYYY-MM-DD HH24:MI:SS'), '0217000005070223', '/logWarnRule/delete', 'logWarnRule:delete', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026325371920384, '查询', '查询', 592385645452992512, '', '', '0', 'res_btn', 7, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:28:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:28:17','SYYYY-MM-DD HH24:MI:SS'), '0217000005070224', '/hussarUnifiedLog/query', 'hussarUnifiedLog:query', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026403285311488, '清空记录', '清空记录', 592385645452992512, '', '', '0', 'res_btn', 8, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:28:36','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:28:36','SYYYY-MM-DD HH24:MI:SS'), '0217000005070225', '/hussarUnifiedLog/deleteIndex', 'hussarUnifiedLog:deleteIndex', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830026567542644736, '获取日志信息', '获取日志信息', 1450765592889004756, '', '', '0', 'res_btn', 4, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:29:15','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:29:15','SYYYY-MM-DD HH24:MI:SS'), '507000005070226', '/baseAuditLog/getAuditLogInfo', 'baseAuditLog:getAuditLogInfo', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (830030534867689472, '查询在线用户历史记录列表', '查询在线用户历史记录列表', 1450765592889004718, '', '', '0', 'res_btn', 3, '0', '0', '0', 1450756958461300737, TO_DATE('2024-04-09 10:45:01','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-04-09 10:45:01','SYYYY-MM-DD HH24:MI:SS'), '506000005070230', '/onlineHistFront/getList', 'onlineHistFront:getList', '1', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (819882932406853632, '模板管理', '模板管理', 697758207757787136, '/dingTalk/DingTalkTemplate', 'HussarMessage/src/views/dingTalk/DingTalkTemplate', '0', 'res_menu', 5, '0', '1', '0', 1450756958461300737, TO_DATE('2024-03-12 10:42:04','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:42:04','SYYYY-MM-DD HH24:MI:SS'), '0215000005070161', '', 'dingTalk::DingTalkTemplate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (819882466553896960, '模板管理', '模板管理', 686174195188768768, '/wecomService/wecomTemplate', 'HussarMessage/src/views/wecomService/WecomTemplate', '0', 'res_menu', 5, '0', '1', '0', 1450756958461300737, TO_DATE('2024-03-12 10:40:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:41:12','SYYYY-MM-DD HH24:MI:SS'), '0220000005070158', '', 'wecomService:wecomTemplate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (819882250383663104, '模板管理', '模板管理', 587706862284316672, '/noticeService/noticeSendTemplate', 'HussarMessage/src/views/noticeService/NoticeSendTemplate', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, TO_DATE('2024-03-12 10:39:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:39:21','SYYYY-MM-DD HH24:MI:SS'), '0236000005070157', '', 'noticeService:noticeSendTemplate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (819881890768232448, '模板管理', '模板管理', 579399930809163776, '/appImService/appImTemplate', 'HussarMessage/src/views/appImService/AppImTemplate', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, TO_DATE('2024-03-12 10:37:55','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:37:55','SYYYY-MM-DD HH24:MI:SS'), '0228000005070156', '', 'appImService:appImTemplate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (819881531945525248, '模板管理', '模板管理', 579405620386734080, '/appPushService/appPushTemplate', 'HussarMessage/src/views/appPushService/AppPushTemplate', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, TO_DATE('2024-03-12 10:36:30','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-12 10:36:30','SYYYY-MM-DD HH24:MI:SS'), '0229000005070155', '', 'appPushService:appPushTemplate', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (825417701370634240, '统一接口推送', '统一接口推送', 587942618739253248, '', '', '0', 'res_open_interface', 23, '0', '0', '0', 1450756958461300737, TO_DATE('2024-03-27 17:15:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-03-27 17:15:16','SYYYY-MM-DD HH24:MI:SS'), '0237000005070154', '/msg/unity/send', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (813348818371485696, '标签管理', '标签管理', 811594090851606528, '/contactService/TagManage', 'HussarMessage/src/views/contactService/TagManage', '0', 'res_menu', 2, '0', '1', '0', 1450756958461300737, TO_DATE('2024-02-23 09:57:50','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-23 10:29:52','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070155', '', 'contactService:TagManage', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (811594293004476416, '通讯录', '通讯录', 811594090851606528, '/contactService/ContactManage', 'HussarMessage/src/views/contactService/ContactManage', '0', 'res_menu', 1, '0', '1', '0', 1450756958461300737, TO_DATE('2024-02-18 13:45:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2024-02-18 14:08:07','SYYYY-MM-DD HH24:MI:SS'), '000000000273000005070154', '', 'contactService:ContactManage', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (812026141606158336, '批量添加联系人', '批量添加联系人', 812025848596275200, '', '', '0', 'res_open_interface', 1, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070155', '/msg/public/contact/addMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (812026329171238912, '批量更新并新增', '批量更新并新增', 812025848596275200, '', '', '0', 'res_open_interface', 2, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070156', '/msg/public/contact/updateMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (812026421143937024, '批量删除联系人', '批量删除联系人', 812025848596275200, '', '', '0', 'res_open_interface', 3, '0', '0', '0', NULL, NULL, NULL, NULL, '000000000274000005070157', '/msg/public/contact/delMsgContactRestApi', '', '0', '', 'data_holder', 'data_organ', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (518451664789970944, '客户端管理', '客户端管理', 518447803329159168, '/authClientModel', 'HussarClient/src/views/client/client', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2021-12-01 15:41:49','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-01 15:41:49','SYYYY-MM-DD HH24:MI:SS'), '02250002', '/authClientModel', 'authClientModel:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (521403853758013440, '应用注册', '应用注册', 528148369617723392, '/unifiedtodoSystem', 'HussarUnifiedtodo/src/views/system/unifiedtodoSystem', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2021-12-09 19:12:46','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-09 19:12:46','SYYYY-MM-DD HH24:MI:SS'), '02200001', '/unifiedtodoSystem', 'unifiedtodoSystem:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (522705027572441088, '我的待办', '我的待办', 521403268396752896, '/unifiedtodoToDoTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoToDoTask', '0', 'res_menu', 2, '0', '1', NULL, 1450756958461300737, TO_DATE('2021-12-13 09:23:10','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-13 09:23:10','SYYYY-MM-DD HH24:MI:SS'), '02200005', '/unifiedtodoToDoTask', 'unifiedtodoToDoTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (523554762252361728, '我的已办', '我的已办', 521403268396752896, '/unifiedtodoDoneTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoDoneTask', '0', 'res_menu', 3, '0', '1', NULL, 1450756958461300737, TO_DATE('2021-12-15 17:39:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:39:42','SYYYY-MM-DD HH24:MI:SS'), '02200001', '/unifiedtodoDoneTask', 'unifiedtodoDoneTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (523555173533229056, '我的传阅', '我的传阅', 521403268396752896, '/unifiedtodoCcTask', 'HussarUnifiedtodo/src/views/toDoTask/unifiedtodoCcTask', '0', 'res_menu', 4, '0', '1', NULL, 1450756958461300737, TO_DATE('2021-12-15 17:41:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-15 17:41:21','SYYYY-MM-DD HH24:MI:SS'), '02200002', '/unifiedtodoCcTask', 'unifiedtodoCcTask:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (526077294431969280, '我的公告', '我的公告', 526435626275577856, '/noticeList', 'HussarNotice/src/views/notice/list', '0', 'res_menu', 1, '0', '1', NULL, 1450756958461300737, TO_DATE('2021-12-22 16:43:21','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-22 16:43:21','SYYYY-MM-DD HH24:MI:SS'), '02310008', '/noticeList', 'notice:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (526117603765395456, '公告列表跳转', '公告列表跳转', 526117093318598656, '/myNotice/list', '', '0', 'res_btn', 1, '0', '1', NULL, 1450756958461300737, TO_DATE('2021-12-22 19:23:32','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2021-12-22 19:23:32','SYYYY-MM-DD HH24:MI:SS'), '02360002', '/myNotice/list', 'myNotice:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (535768620278751232, '审计查阅', '审计查阅', 535768124604293120, '/auditAccess', 'HussarAudit/src/views/system/auditAccess/index', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2022-01-18 10:33:13','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-01-18 10:33:13','SYYYY-MM-DD HH24:MI:SS'), '02270001', '/auditAccess', 'auditAccess:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (544468972511436800, '主题配置', '主题配置', 544468727815741440, '/themeConfig', 'HussarThemeConfig/src/views/themeConf/ThemeConf', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2022-02-11 10:45:19','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-02-11 10:45:19','SYYYY-MM-DD HH24:MI:SS'), '02150001', '/themeConfig', '', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (556508576777248768, '休眠用户', '休眠用户', 1450765592889004737, '/userFront/dormancy', '', '0', 'res_btn', 20, '0', '1', NULL, 1450756958461300737, TO_DATE('2022-03-16 16:06:24','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-03-16 16:06:24','SYYYY-MM-DD HH24:MI:SS'), '2010001', '/userFront/dormancy', 'userFront:dormancy', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004036, '修改密码', '修改密码', 1450765592889004735, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:36:24','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2060257', '/userFront/updatePwd', 'userFront:updatePwd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004037, '用户审核修改通过', '用户审核修改通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:21:44','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900196', '/sysUsersAuditFront/passEdit', 'sysUsersAuditFront:passEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004039, '功能下级排序', '功能下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:23:35','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0206', '/resourceFront/functionTreeOrder', 'resourceFront:functionTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004042, '新增基础配置', '新增基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'sbc000000001', '/sysBaseConfig/add', 'sysBaseConfig:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004045, '角色维护页面', '角色维护页面', 1450765592889004740, '/manageRole', 'HussarAuthorization/src/views/permit/rolemanage/role/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000003', '/roleManager/view', 'roleManager:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004047, '菜单转移', '菜单树转移', 1450765592889004616, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 14:55:52','SYYYY-MM-DD HH24:MI:SS'), '000000000004', '/frontMenu/menuTreeChange', 'frontMenu:menuTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004052, '功能修改', '功能修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 09:44:15','SYYYY-MM-DD HH24:MI:SS'), '00002', '/resource/functionEdit', 'resource:functionEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004053, '根据组织机构类型获取下属单位组织机构类型', '根据组织机构类型获取下属单位组织机构类型', 1450765592889004693, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'org000000003', '/orgMainFront/getOrgRoleByCode', 'orgMainFront:getOrgRoleByCode', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004059, '删除用户', '删除用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000005', '/userFront/delete', 'userFront:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004060, '激活用户', '激活用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, TO_DATE('2021-01-14 16:06:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '201019201', '/userFront/unlockUser', 'userFront:unlockUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004061, '工作日历批量新增', '工作日历新增', 1450765592889004611, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:41:03','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 13:36:20','SYYYY-MM-DD HH24:MI:SS'), 'null00340224', '/calendarFront/addEvent', 'calendar:addEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004062, '删除角色分组', '删除角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, NULL, NULL, NULL, '2020022', '/roleManagerFront/delGroup', 'roleManagerFront:delGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004064, '新增角色分组', '新增角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:58','SYYYY-MM-DD HH24:MI:SS'), '2020019', '/roleManagerFront/saveGroup', 'roleManagerFront:saveGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004066, '日历维护权限', '日历维护权限', 1450765592889004611, NULL, NULL, '0', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-02-18 10:57:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00340316', '/calendar/operate', 'calendar:operate', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004067, '日志文件下载', '日志文件下载', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logD00000003', '/logDownloadFront/download', 'logDownload:download', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004069, '用户数据导出', '用户数据导出', 1450765592889004737, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, TO_DATE('2020-03-12 06:03:02','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010178', '/userFront/exportData', 'userFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004073, '组织机构数据导入', '组织机构数据导入', 1450765592889004693, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, TO_DATE('2020-03-11 06:45:50','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020174', '/orgMainFront/importData', 'orgMainFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004074, '导出', '编码规则导出', 1450765592889004610, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:37:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 20:15:35','SYYYY-MM-DD HH24:MI:SS'), '100010223', '/idtableFront/exportData', 'idtable:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004075, '定义组织类型', '定义组织类型', 1450765592889004653, '/SysOrgType', 'HussarAuthorization/src/views/organ/SysOrgType', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000007', '/orgType/view', 'orgType:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004080, '新增角色分组页面', '新增角色分组页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000009', '/roleManager/roleAddGroupPage', 'roleManager:roleAddGroupPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004082, '用户数据导入', '用户数据导入', 1450765592889004737, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2020-03-12 06:02:34','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010177', '/userFront/importData', 'userFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004085, '流程管理', '流程管理', 523177185453023232, '/bpmModelEdit', 'BpmManageServer/src/views/modeling/modelEdit', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-07 13:38:06','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020202010502', '/bpmModelEdit/view', 'bpmModelEdit:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004087, '菜单导入', '菜单导入', 1450765592889004616, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-26 10:38:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 19:46:48','SYYYY-MM-DD HH24:MI:SS'), '菜单维护0215', '/frontMenu/importData', 'frontMenu:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004088, '获取所有的ehcache缓存名', '获取所有的ehcache缓存名', 1450765592889004621, NULL, NULL, '0', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:09:18','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '缓存监控0179', '/ehcacheFront/getAllCacheName', 'ehcache:getAllCacheName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004089, '指定机构人员树', '指定机构人员树', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'emp000000002', '/employeeFront/employeeTreeById', 'employeeFront:employeeTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004090, '版本管理', '版本管理', NULL, '/bpmVersion', '@/bpm/views/modeling/index', '0', 'res_menu', 2, '0', '1', '1', NULL, TO_DATE('2021-06-07 13:39:47','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020202010503', '/version/view', 'version:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004091, '删除基础配置', '删除基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'sbc000000002', '/sysBaseConfig/delete', 'sysBaseConfig:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004092, '增加不相容角色集', '增加不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000009', '/incompatibleRolesFront/addRole', 'incompatibleRolesFront:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004096, '组织机构用户树', '组织机构用户树', 1450765592889004599, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'user00000001', '/userFront/userTree', 'userFront:userTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004098, '模块修改', '模块修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-20 17:12:58','SYYYY-MM-DD HH24:MI:SS'), '3333', '/resource/moduleEdit', 'resourceFront:moduleEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004099, '获取不相容角色集信息', '获取不相容角色集信息', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'inco00000002', '/incompatibleRolesFront/selectInRole', 'incompatibleRoles:selectInRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004101, '资源删除', '资源删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-26 09:37:43','SYYYY-MM-DD HH24:MI:SS'), '000000000012', '/resourceFront/delResource', 'resourceFront:delResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004105, '批量新增事件页面', '批量新增事件页面', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'cal000000001', '/calendar/addView', 'calendar:addView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004110, '删除附件', '删除附件', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000003', '/attachment/delete', 'attachment:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004112, '用户角色审核页面', '用户角色审核页面', 1450765592889004699, '/userRoleVerify', 'HussarAuthorization/src/views/permit/rolemanage/userRoleVerify/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000013', '/userRoleReview/view', 'userRoleReview:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004114, '授权信息', '授权信息', 1450765592889004631, '/license', 'HussarOperations/src/views/system/license/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-06-26 08:57:20','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 13:44:09','SYYYY-MM-DD HH24:MI:SS'), '007000780149', '/licenseFront/view', 'license:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004115, ' 获取当前数据库内存使用大小情况', ' 获取当前数据库内存使用大小情况', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000003', '/redis/getMemeryInfo', 'redis:getMemeryInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004118, '删除', '员工删除', 1450765592889004578, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000014', '/employeeFront/delEmployeeById', 'employeeFront:delEmployeeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004119, '个性化配置快捷方式菜单树', '个性化配置快捷方式菜单树', 1450765592889004623, NULL, NULL, '0', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2021-07-29 14:20:21','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '0501', '/frontMenu/shortCutMenuTree', 'frontMenu:shortCutMenuTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004120, '增加下级', '增加下级', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-26 19:46:33','SYYYY-MM-DD HH24:MI:SS'), '0008', '/menu/menuAdd', 'menu:menuAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004121, '用户排序', '用户排序', 1450765592889004737, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000015', '/userFront/saveUserOrder', 'userFront:saveUserOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004122, '人员数据导出', '人员数据导出', 1450765592889004578, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2020-03-11 10:25:37','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1030175', '/employeeFront/exportData', 'employeeFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004124, '组织机构修改', '组织机构修改', 1450765592889004693, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2019-08-26 17:17:57','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-27 09:31:25','SYYYY-MM-DD HH24:MI:SS'), '1020237', '/orgMainFront/orgInfoEditSave', 'orgMainFront:orgInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004131, '基础配置', '基础配置', 1450765592889004658, '/baseConfig', 'HussarConfig/src/views/system/baseConfig/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2019-08-16 10:28:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 13:59:10','SYYYY-MM-DD HH24:MI:SS'), '000400940168', '/sysBaseConfig/view', 'sysBaseConfig:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004134, '根据ID获取转移组织机构树', '根据ID获取转移组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'org000000004', '/orgMainFront/orgChangeById', 'orgMainFront:orgChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004136, '不相容角色集查询', '不相容角色集查询', 1450765592889004725, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:10:54','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2030204', '/incompatibleRolesFront/list', 'incompatibleRolesFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004137, '重置密码', '重置密码', 1450765592889004602, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-21 17:09:59','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 20:06:24','SYYYY-MM-DD HH24:MI:SS'), '2070173', '/userFront/resetAllPwd', 'userFront:resetAllPwd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004138, '加载菜单树', '加载菜单树', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'menu00000001', '/frontMenu/menuTree', 'frontMenu:menuTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004141, '组织机构审核页面', '组织机构审核页面', 523064495887884288, '/organAudit', 'HussarAuthorization/src/views/organAudit/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2019-08-16 10:24:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-23 09:56:47','SYYYY-MM-DD HH24:MI:SS'), '007600900165', '/sysStruAudit/view', 'sysStruAudit:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004143, '加载角色树', '加载角色树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 15, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:45:07','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020170', '/roleManagerFront/getUserRole', 'roleManager:getUserRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004144, '角色关联用户查看树', '角色关联用户查看树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000010', '/roleManagerFront/roleUserTreeView', 'roleManagerFront:roleUserTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004145, '我的传阅', '我的传阅', 1450765592889004711, '/ccList', 'HussarPersonalMatters/src/views/taskmanage/ccList', '0', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2020-08-12 01:55:43','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '002500950193', '/ccTask/view', 'ccTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004146, '系统监控页面', '系统监控页面', 1450765592889004660, '/systemMonitor', 'HussarOperations/src/views/service/systemMonitor/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-04-23 13:34:18','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '002600160043', '/smon?action=monitor', 'smon:monitor', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004147, '模块查看', '模块查看', 1450765592889004630, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2018-04-20 16:57:04','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0033', '/resource/moduleView', 'resource:moduleView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004148, '员工维护', '员工维护', 1450765592889004578, '/StaffManage', 'HussarAuthorization/src/views/staffManage/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000017', '/employee/employeeList', 'employee:employeeList', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004149, '角色分组排序', '角色分组排序', 1450765592889004740, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:43:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020202', '/roleManagerFront/saveGroupOrder', 'roleManagerFront:saveGroupOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004150, '会话追踪列表', '会话追踪列表', 1450765592889004700, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-26 20:00:41','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '5050245', '/securityLogFront/list', 'securityLogFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004151, '工作日历修改', '工作日历修改', 1450765592889004611, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:38:11','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00340227', '/calendarFront/editEvent', 'calendar:editEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004152, '修改用户', '修改用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000018', '/userFront/edit', 'userFront:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004153, '获取本组织机构及直属组织机构', '获取本组织机构及直属组织机构', 1450765592889004693, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:37:22','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020189', '/commonOrgan/directOrgList', 'commonOrgan:searchDirectOrgList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004156, '模块转移', '模块转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:29:42','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 09:30:33','SYYYY-MM-DD HH24:MI:SS'), '资源维护0210', '/resourceFront/moduleTreeChange', 'resourceFront:moduleTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004157, '基础配置详情', '基础配置详情', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'sbc000000003', '/sysBaseConfigFront/detail', 'sysBaseConfig:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004159, '系统日志查询', '系统日志查询', 1450765592889004583, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'log000000001', '/logMongo/find', 'logMongo:find', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004160, '保存用户数据权限', '保存用户数据权限', 1450765592889004737, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, TO_DATE('2021-03-05 10:05:28','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010503', '/userFront/saveDataScope', 'userFront:saveDataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004161, '新增', '组织机构新增', 1450765592889004693, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:19','SYYYY-MM-DD HH24:MI:SS'), '0006', '/orgMainFront/orgInfoSave', 'orgMainFront:orgInfoSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004167, '组织机构规则页面', '组织机构规则页面', 1450765592889004698, '/SysOrgRule', 'HussarAuthorization/src/views/organ/SysOrgRule', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000019', '/orgRule/view', 'orgRule:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004168, '用户审核新增通过', '用户审核新增通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:20:59','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900195', '/sysUsersAuditFront/passAdd', 'sysUsersAuditFront:passAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004169, '人员审核列表', '人员审核列表', 523064540137791488, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:50:49','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900191', '/sysStaffAuditFront/list', 'sysStaffAudit:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004171, '增加角色', '增加角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:49','SYYYY-MM-DD HH24:MI:SS'), '000000000020', '/roleManagerFront/addRole', 'roleManagerFront:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004173, '角色审核', '角色审核', 1450765592889004699, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000021', '/userRoleReviewFront/reviewSubmit', 'userRoleReviewFront:reviewSubmit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004175, '在线用户历史记录列表', '在线用户历史记录列表', 1450765592889004718, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'online000002', '/onlineHistFront/list', 'onlineHist:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004176, '删除', '编码规则删除', 1450765592889004610, '', '', '1', 'res_btn', 3, '0', '1', '', NULL, NULL, 1450756958461300737, TO_DATE('2023-05-06 15:50:35','SYYYY-MM-DD HH24:MI:SS'), '000000000022', '/codeRuleService/deleteCodeRule', 'codeRuleService:deleteCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004178, '字段修改', '字段修改', 1450765592889004593, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:07:52','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0219', '/dicFront/update_single', 'dict:update_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004179, '用户审核', '用户审核', 1450765592889004651, '/userAudit', 'HussarAuthorization/src/views/permit/auditManage/userAudit/index', '1', 'res_menu', 7, '0', '1', '1', NULL, TO_DATE('2019-08-16 10:24:22','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900166', '/user/audit', 'user:audit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004180, '组织机构数据导出', '组织机构数据导出', 1450765592889004693, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2020-03-11 06:44:58','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020173', '/orgMainFront/exportData', 'orgMainFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004181, '人员数据导入', '人员数据导入', 1450765592889004578, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2020-03-11 10:26:17','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1030176', '/employeeFront/importData', 'employeeFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004182, ' redis管理页面', ' redis管理页面', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000004', '/redis/manageView', 'redis:manageView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004183, '添加删除用户角色', '添加删除用户角色', 1450765592889004740, NULL, NULL, '0', 'res_btn', 18, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:12:28','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020182', 'roleManagerFront/addOrDelUserRole', 'roleManagerFront:addOrDelUserRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004186, '用户管理页面', '用户管理页面', 1450765592889004737, '/usermanage', 'HussarAuthorization/src/views/userManager/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000024', '/user/view', 'user:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004187, '字典管理', '字典管理页面', 1450765592889004593, '/dictionary', 'HussarGeneral/src/views/system/dictionary/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, TO_DATE('2019-08-26 10:43:39','SYYYY-MM-DD HH24:MI:SS'), '000000000025', '/sys/dic/', 'dict:dic', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004188, '获取穿梭框的数据', '获取穿梭框的数据', 1450765592889004725, NULL, NULL, '0', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:42:22','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-06-05 06:43:17','SYYYY-MM-DD HH24:MI:SS'), '2030169', '/incompatibleRolesFront/transferData', 'incompatibleRoles:transferData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004189, '角色关联用户修改树', '角色关联用户修改树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000011', '/roleManagerFront/roleUserTreeEdit', 'roleManager:roleUserTreeEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004190, '不相容角色集页面', '不相容角色集页面', 1450765592889004725, '/alienRole', 'HussarAuthorization/src/views/permit/rolemanage/alienRole/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000026', '/incompatibleRoles/view', 'incompatibleRoles:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004193, '转移', '人员转移', 1450765592889004578, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:39:54','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1030189', '/employeeFront/staffTransfer', 'employeeFront:staffTransfer', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004198, '组织机构维护页面', '组织机构维护页面', 1450765592889004693, '/OrganMaintenance', 'HussarAuthorization/src/views/organMaintenance/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, TO_DATE('2019-08-23 10:05:02','SYYYY-MM-DD HH24:MI:SS'), '000000000027', '/orgMain/orgList', 'orgMain:orgList', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004199, '组织机构查看', '组织机构查看', 1450765592889004693, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:25:04','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020250', '/orgMainFront/orgInfo', 'orgMainFront:orgInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004200, '编码规则列表', '编码规则列表', 1450765592889004610, '', '', '1', 'res_btn', 7, '0', '1', '', NULL, TO_DATE('2019-08-27 16:43:25','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-05-06 15:49:48','SYYYY-MM-DD HH24:MI:SS'), '100010260', '/codeRuleService/listCodeRules', 'codeRuleService:listCodeRules', '1', '', '', '', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004201, '会话追踪', '会话追踪', 1450765592889004700, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000028', '/securityLog/view2', 'securityLog:view2', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004202, '批量下载', '批量下载', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000004', '/attachment/BatchDownload', 'attachment:BatchDownload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004204, '修改角色分组', '修改角色分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:32:02','SYYYY-MM-DD HH24:MI:SS'), '2020021', '/roleManagerFront/editGroup', 'roleManagerFront:editGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004206, '修改角色', '修改角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:53','SYYYY-MM-DD HH24:MI:SS'), '000000000029', '/roleManagerFront/editRole', 'roleManagerFront:editRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004207, '字典导入', '字典导入', 1450765592889004593, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-26 19:54:07','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0243', '/dicFront/importData', 'dict:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004208, '组织机构上移/下移', '组织机构上移/下移', 1450765592889004693, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:12:48','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020187', '/orgMainFront/singleMove', 'orgMain:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004211, '角色分组信息查看', '角色分组信息查看', 1450765592889004740, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:41:09','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020201', '/roleManagerFront/roleGroupViewPage', 'roleManagerFront:roleGroupViewPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004212, '字段添加', '字段添加', 1450765592889004593, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:06:58','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 18:01:45','SYYYY-MM-DD HH24:MI:SS'), '字典管理0218', '/dicFront/add_single', 'dict:add_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004213, '用户注销审核通过', '用户注销审核通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, TO_DATE('2019-08-26 17:36:15','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900241', '/sysUsersAuditFront/passCalcel', 'sysUsersAuditFront:passCalcel', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004214, '资源转移', '资源转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:32:21','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0212', '/resourceFront/resourceTreeChange', 'resourceFront:resourceTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004218, '资源回收', '资源回收', 1450765592889004630, NULL, NULL, '1', 'res_btn', 25, '0', '1', NULL, NULL, TO_DATE('2020-02-18 06:37:13','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0169', '/resourceFront/retrieveResource', 'resourceFront:retrieveResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004220, '资源维护页面', '资源维护页面', 1450765592889004630, '/resourceManage', 'HussarAuthorization/src/views/permit/resourceManage/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, TO_DATE('2019-08-26 09:18:55','SYYYY-MM-DD HH24:MI:SS'), '000000000031', '/resource/resList', 'resource:resList', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004222, '变更所属部门', '变更所属部门', 1450765592889004737, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000032', '/user/changeOrg', 'user:changeOrg', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004223, '获取负责人列表', '获取负责人列表', 1450765592889004693, NULL, NULL, '0', 'res_btn', 15, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:39:23','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020167', '/orgMainFront/principalSelect', 'orgMainFront:principalSelect', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004224, '批量新增事件页面', '批量新增事件页面', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'cal000000002', '/calendar/deleteView', 'calendar:deleteView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004226, '任务管理', '任务管理', 523177259834810368, '/bpmTask', 'BpmManageServer/src/views/taskManagement/task', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-07 13:43:12','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020202030505', '/bpmTask/view', 'bpmTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004229, '待办任务', '待办任务', 1450765592889004598, '/toDoList', 'HussarPersonalMatters/src/views/taskmanage/todoList', '1', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2018-04-20 18:05:34','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-06-11 18:19:34','SYYYY-MM-DD HH24:MI:SS'), '002500120034', '/sysTodo/view', 'sysTodo:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004230, '模块删除', '模块删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-26 09:36:46','SYYYY-MM-DD HH24:MI:SS'), '000000000033', '/resourceFront/delModule', 'resourceFront:delModule', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004235, '系统日志下载', '系统日志下载', 1450765592889004583, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'log000000002', '/logMongo/dowlond', 'logMongo:dowlond', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004237, '角色关联用户新增树', '角色关联用户新增树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000012', '/roleManagerFront/roleUserTreeAdd', 'roleManager:roleUserTreeAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004239, '功能管理', '功能管理', 523074819135381504, '/functionManage', 'HussarAuthorization/src/views/permit/functionManage/index', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-21 14:30:47','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '00020513', '/function/manage', 'function:manage', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004240, '已办任务', '已办任务', 1450765592889004603, '/doneList', 'HussarPersonalMatters/src/views/taskmanage/doneList', '1', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2018-04-20 18:06:21','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2018-04-23 10:01:57','SYYYY-MM-DD HH24:MI:SS'), '002500130035', '/sysDone/view', 'sysDone:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004247, '功能删除', '功能删除', 1450765592889004630, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 09:44:48','SYYYY-MM-DD HH24:MI:SS'), '00003', '/resourceFront/delFunction', 'resourceFront:delFunction', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004251, '查看不相容角色集', '查看不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'inco00000003', '/incompatibleRolesFront/roleView', 'incompatibleRolesFront:roleView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004252, '功能新增', '功能新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 09:43:47','SYYYY-MM-DD HH24:MI:SS'), '00001', '/resourceFront/functionAdd', 'resourceFront:functionAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004253, '下级配置项', '下级配置项', 1450765592889004658, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2021-01-18 15:46:13','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-18 15:48:21','SYYYY-MM-DD HH24:MI:SS'), '000400940193', '/sysBaseConfigFront/configList', 'sysBaseConfigFront:configList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004257, '菜单详情页面', '菜单详情页面', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'menu00000002', '/frontMenu/menuInfo', 'frontMenu:menuInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004258, ' 获取当前数据库中所有db的map', ' 获取当前数据库中所有db的map', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000005', '/redisFront/getAllRedisDatabaseList', 'redis:getAllRedisDatabaseList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004259, '修改不相容角色集', '修改不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000034', '/incompatibleRolesFront/editRole', 'incompatibleRolesFront:editRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004261, '用户详情', '用户详情', 1450765592889004737, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:35:25','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010200', '/userFront/userInfo', 'userFront:userInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004263, '修改基础配置', '修改基础配置', 1450765592889004658, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-21 16:58:52','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 13:57:16','SYYYY-MM-DD HH24:MI:SS'), '000400940171', '/sysBaseConfigFront/update', 'sysBaseConfigFront:update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004265, '获取组织机构树', '获取组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, TO_DATE('2020-01-13 15:46:29','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020327', '/orgMainFront/orgTree', 'orgMainFront:orgTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004268, '我的委托', '我的委托', 1450765592889004632, '/entrustList', 'HussarPersonalMatters/src/views/taskmanage/entrustList', '0', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2020-10-09 06:46:02','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-10-09 07:06:39','SYYYY-MM-DD HH24:MI:SS'), '002501010225', '/entrustTask/view', 'entrustTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004269, '保存资源', '保存资源', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000002', '/roleManagerFront/saveResource', 'roleManager:saveResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004270, '修改', '组织规则修改', 1450765592889004698, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000035', '/orgRuleFront/edit', 'orgRule:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004277, '字典新增', '字典新增', 1450765592889004593, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2020-11-04 03:21:19','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2020-11-04 03:28:30','SYYYY-MM-DD HH24:MI:SS'), '字典管理0205', '/dicFront/addGroup', 'dict:addGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004278, '模块新增', '模块新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-20 17:00:18','SYYYY-MM-DD HH24:MI:SS'), '122222', '/resource/moduleAdd', 'resourceFront:moduleAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004281, '角色新增关联用户保存', '角色新增关联用户保存', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000013', '/roleManagerFront/saveRoleUserAdd', 'roleManager:saveRoleUserAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004283, '获取用户数据权限', '获取用户数据权限', 1450765592889004737, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, TO_DATE('2021-03-05 10:04:30','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010502', '/userFront/dataScope', 'userFront:dataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004284, '新增', '组织规则新增', 1450765592889004698, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000037', '/orgRuleFront/add', 'orgRule:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004285, '日志监控', '日志监控', 1450765592889004583, NULL, NULL, '1', 'res_btn', 1, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000038', '/logMongo', 'logMongo:index', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004286, '字典上移/下移', '字典上移/下移', 1450765592889004593, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:32:15','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0254', '/dicFront/singleMove', 'dicFront:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004288, '修改', '员工修改', 1450765592889004578, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 10:56:37','SYYYY-MM-DD HH24:MI:SS'), '00011', '/employeeFront/employeeEdit', 'employeeFront:emplInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004291, '删除字典类别', '删除字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2018-04-20 13:58:30','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 11:01:29','SYYYY-MM-DD HH24:MI:SS'), '字典管理0030', '/dicFront/delete', 'dict:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004292, '资源导入', '资源导入', 1450765592889004630, NULL, NULL, '1', 'res_btn', 22, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:27:34','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0208', '/resourceFront/importData', 'resourceFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004293, '慢SQL诊断', '慢SQL诊断', 523159993936257024, '/slowsql', 'HussarOperations/src/views/service/slowsql/index', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-09-28 13:59:56','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '002600170152', '/SqlMonitor/sql', 'SqlMonitor:sql', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004295, '获取本组织机构及所有下属组织机构', '获取本组织机构及所有下属组织机构', 1450765592889004693, NULL, NULL, '1', 'res_btn', 18, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:39:02','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020191', '/commonOrgan/list', 'commonOrgan:searchList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004297, '菜单修改', '菜单修改', 1450765592889004616, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 17:31:39','SYYYY-MM-DD HH24:MI:SS'), '0009', '/frontMenu/menuInfoEditSave', 'frontMenu:menuInfoEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004302, '新增', '员工新增', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-24 09:04:23','SYYYY-MM-DD HH24:MI:SS'), '00010', '/employeeFront/employeeAdd', 'employeeFront:employeeAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004305, '获取本组织机构直属上级组织机构用户', '获取本组织机构直属上级组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:41:26','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010194', '/commonUser/superiorUserList', 'commonUser:superiorUserList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004307, '只加载当前角色的资源树', '只加载当前角色的资源树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 31, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:13:55','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0184', 'resourceFront/selfResourceTree', 'resourceFront:selfResourceTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004308, '新增资源关联角色保存', '新增资源关联角色保存', 1450765592889004630, NULL, NULL, '0', 'res_btn', 34, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:16:23','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0187', 'resourceFront/resourceAddSaveRole', 'resourceFront:resourceAddSaveRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004309, '模块转移树', '模块转移树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 26, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:50:04','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0174', 'resourceFront/moduleChangeById', 'resourceFront:moduleChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004310, '字典导出', '字典导出', 1450765592889004593, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2019-08-26 19:54:50','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0244', '/dicFront/exportDict', 'dict:exportDict', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004311, '回收权限', '回收权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000039', '/roleManagerFront/reclaimPerm', 'roleManagerFront:reclaimPerm', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004313, '菜单导出', '菜单导出', 1450765592889004616, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2019-08-26 10:38:52','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 19:46:51','SYYYY-MM-DD HH24:MI:SS'), '菜单维护0216', '/frontMenu/exportMenu', 'frontMenu:exportMenu', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004317, '删除不相容角色集', '删除不相容角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000041', '/incompatibleRolesFront/delRole', 'incompatibleRolesFront:delRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004320, '用户排序树', '用户排序树', 1450765592889004599, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'user00000002', '/userFront/orderTree', 'userFront:orderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004322, '菜单删除', '菜单删除', 1450765592889004616, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 14:55:45','SYYYY-MM-DD HH24:MI:SS'), '000000000042', '/frontMenu/delMenuById', 'frontMenu:delMenuById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004323, '查询是否已有角色集', '查询是否已有角色集', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'inco00000004', '/incompatibleRoles/sameRolesName', 'incompatibleRoles:sameRolesName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004325, '工作日历页面', '工作日历页面', 1450765592889004611, '/workcalendar', 'HussarGeneral/src/views/system/workcalendar/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-05-17 15:26:04','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 11:39:37','SYYYY-MM-DD HH24:MI:SS'), 'null00340107', '/calendar/view', 'calendar:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004327, '工作日历批量删除', '工作日历批量删除', 1450765592889004611, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:39:22','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00340228', '/calendarFront/delEvent', 'calendar:delEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004328, '角色欢迎页新增', '角色欢迎页新增', 1450765592889004726, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:49:26','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '000400840231', '/sysWelcome/addRole', 'sysWelcome:addRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004329, '检验是否已存在URL', '是否已存在URL', 1450765592889004630, NULL, NULL, '0', 'res_btn', 32, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:14:41','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0185', 'resourceFront/sameUrl', 'resource:sameUrl', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004330, '角色修改关联用户保存', '角色修改关联用户保存', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000014', '/roleManagerFront/saveRoleUserEdit', 'roleManager:saveRoleUserEdit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004332, '删除', '组织类型删除', 1450765592889004653, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:05','SYYYY-MM-DD HH24:MI:SS'), '000000000043', '/sysOrganFront/delByIds', 'sysOrganFront:delByIds', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004333, '查询是否已有角色', '查询是否已有角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000003', '/roleManagerFront/sameRoleName', 'roleManagerFront:sameRoleName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004334, '登录页配置', '登录页配置', 1450765592889004689, '/loginConf', 'HussarConfig/src/views/personalizedConf/loginConf', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-23 11:38:52','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020102030504', '/personalizedConf/loginConf', 'personalizedConf:loginConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004336, '删除欢迎页', '删除欢迎页', 1450765592889004726, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:50:16','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '000400840232', '/sysWelcome/delete', 'sysWelcome:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004337, '获取资源转移树', '获取资源转移树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 27, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:03:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0175', 'resourceFront/resourceChangeById', 'resourceFront:resourceChangeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004338, '用户审核转移通过', '用户审核转移通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:23:32','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900198', '/sysUsersAuditFront/passTrans', 'sysUsersAuditFront:passTrans', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004339, '操作', '添加不相容角色', 1450765592889004725, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '2030023', '/incompatibleRolesFront/saveInRoles', 'incompatibleRolesFront:saveInRoles', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004342, '组织机构转移', '组织机构转移', 1450765592889004693, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:09:20','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020186', '/orgMainFront/orgTreeChange', 'orgMainFront:orgTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004344, '资源保存', '资源保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 10:41:19','SYYYY-MM-DD HH24:MI:SS'), '0005', '/resource/resourceEditSave', 'resourceFront:resourceSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004345, '文件下载', '文件下载', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000005', '/attachment/fileDownload', 'attachment:fileDownload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004347, '编码规则维护页面', '编码规则维护页面', 1450765592889004610, '/customCodingRules', 'HussarCodePlus/src/views/customCodingRules/index', '1', 'res_menu', 2, '0', '1', '1', NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2023-04-28 11:30:15','SYYYY-MM-DD HH24:MI:SS'), 'id0000000001', '', 'idtable:idtableManage', '0', '', '', '', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004348, '新增用户', '新增用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000044', '/userFront/add', 'userFront:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004349, '获取某个资源关联的角色树', '获取某个资源关联的角色树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 33, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:15:29','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0186', 'resourceFront/roleTreeView', 'resourceFront:roleTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004351, '审计日志页面', '审计日志页面', 1450765592889004756, '/auditlog', 'HussarAudit/src/views/system/auditlog/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000045', '/securityLog/view', 'securityLog:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004354, '解冻密码', '解冻密码', 1450765592889004746, '/thawcode', 'HussarOperations/src/views/system/thawcode/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2019-02-21 16:02:11','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 11:27:00','SYYYY-MM-DD HH24:MI:SS'), 'null01390318', '/thawPwd/view', 'thawPwd:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004356, '函数管理', '函数管理', 523177287164895232, '/bpmFunction', 'BpmManageServer/src/views/function/index', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-07 13:54:48','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020202040507', '/bpmFunction/view', 'bpmFunction:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004357, '下级排序', '菜单树下级排序', 1450765592889004616, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-26 19:46:36','SYYYY-MM-DD HH24:MI:SS'), '000000000046', '/frontMenu/menuTreeOrder', 'frontMenu:menuTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004358, '根据父ID获取下级菜单树', '根据父ID获取下级菜单树', 1450765592889004616, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'menu00000003', '/frontMenu/menuTreeById', 'frontMenu:menuTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004363, '组织机构修改页面', '组织机构修改页面', 1450765592889004693, NULL, NULL, '0', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 17:21:47','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020239', '/orgMainFront/orgInfoEdit', 'orgMain:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004364, '检查重复权限', '检查重复权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 19, '0', '1', NULL, NULL, TO_DATE('2021-01-18 17:57:02','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020194', '/roleManagerFront/checkResource', 'roleManagerFront:checkResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004366, '用户审核详情', '用户审核详情', 1450765592889004651, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:17:32','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900192', '/sysUsersAuditFront/detail', 'sysUsersAuditFront:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004368, '懒加载获取角色用户树', '懒加载获取角色用户树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 16, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:10:24','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '202018002', 'roleManagerFront/lazyRoleUserTreeView', 'roleManager:lazyRoleUserTreeView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004369, '根据模块ID获取下级功能树', '根据模块ID获取下级功能树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 29, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:47:14','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020171', 'resourceFront/functionTreeById', 'resourceFront:functionTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004371, '获取日历事件类型下拉框', '获取日历事件类型下拉框', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'cal000000003', '/calendar/calendarEventTypeOption', 'calendar:calendarEventTypeOption', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004378, '新增', '组织类型新增', 1450765592889004653, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:30:59','SYYYY-MM-DD HH24:MI:SS'), '000000000049', '/sysOrganFront/add', 'sysOrganFront:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004380, '显示图片', '显示图片', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000001', '/attachment/showPicture', 'attachment:showPicture', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004382, '新增字典类别', '新增字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2018-04-20 13:55:35','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 18:02:32','SYYYY-MM-DD HH24:MI:SS'), '字典管理0027', '/dicFront/add', 'dict:add', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004383, '查询', '组织规则查询', 1450765592889004698, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000050', '/orgRuleFront/list', 'orgRule:search', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004384, '字典修改', '字典修改', 1450765592889004593, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, TO_DATE('2020-11-04 13:43:57','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0206', '/dicFront/editGroup', 'dict:editGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004390, '组织机构操作审核详情', '组织机构操作审核详情', 523064495887884288, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900182', '/sysStruAuditFront/detail', 'sysStruAudit:detail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004391, '查询是否已有分组', '查询是否已有分组', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000004', '/roleManagerFront/sameGroupName', 'roleManagerFront:sameGroupName', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004393, '文件上传回显', '文件上传回显', 1450765592889004614, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2020-12-07 11:36:05','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '附件监控0201', '/attachment/uploadFileQuery', 'attachment:uploadFileQuery', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004394, '组织机构排序', '组织机构人员排序', 1450765592889004693, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:13:54','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-23 10:41:54','SYYYY-MM-DD HH24:MI:SS'), '1020188', '/orgMainFront/orgTreeOrder', 'orgMainFront:orgTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004395, '菜单维护', '菜单维护', 1450765592889004616, '/menumaintain', 'HussarAuthorization/src/views/menumaintain/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000052', '/menu/menuList', 'menu:menuList', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004397, '资源下级排序', '资源下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:24:59','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0207', '/resourceFront/resourceTreeOrder', 'resourceFront:resourceTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004400, '获取本级用户列表', '获取本级用户列表', 1450765592889004737, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, TO_DATE('2021-01-14 16:05:52','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-14 16:08:13','SYYYY-MM-DD HH24:MI:SS'), '2010191', '/userFront/accountList', 'userFront:accountList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004401, '用户审核修改详情', '用户审核修改详情', 1450765592889004651, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:18:53','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900193', '/sysUsersAuditFront/editDetail', 'sysUsersAuditFront:editDetail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004403, ' 删除redis key', ' 删除redis key', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000007', '/redisFront/deleteNoSQLKeys', 'redis:deleteNoSQLKeys', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004404, '资源新增', '资源新增', 1450765592889004630, NULL, NULL, '1', 'res_btn', 16, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-26 09:37:18','SYYYY-MM-DD HH24:MI:SS'), '000000000053', '/resourceFront/resourceAdd', 'resourceFront:resourceAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004406, '用户审核删除通过', '用户审核删除通过', 1450765592889004651, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:23:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900197', '/sysUsersAuditFront/passDel', 'sysUsersAuditFront:passDel', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004407, '重置密码页面', '重置密码页面', 1450765592889004602, '/resetpassword', 'HussarOperations/src/views/system/resetpassword/index', '1', 'res_menu', 2, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000054', '/user/pageResetAllPwd', 'user:pageResetAllPwd', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004409, '注销用户', '注销用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 9, '0', '1', NULL, NULL, TO_DATE('2019-08-26 16:59:51','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010236', '/userFront/cancelUser', 'userFront:cancelUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004410, '根据功能ID获取资源树', '根据功能ID获取资源树', 1450765592889004630, NULL, NULL, '0', 'res_btn', 28, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:48:03','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020172', 'resourceFront/resourceTreeById', 'resourceFront:resourceTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004411, '角色复制', '角色复制', 1450765592889004737, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000055', '/userFront/copyRole', 'userFront:copyRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004413, '解冻', '删除缓存', 1450765592889004746, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:28:11','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-27 17:51:38','SYYYY-MM-DD HH24:MI:SS'), 'null01390221', '/ehcacheFront/deleteByKeys', 'ehcache:deleteByKeys', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004414, '在线用户页面', '在线用户页面', 1450765592889004700, '/onlineuser', 'HussarAudit/src/views/system/onlineuser/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000056', '/online/view', 'online:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004416, '授权文件上传', '授权文件上传', 1450765592889004631, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'lic000000001', '/licenseFront/upload', 'license:upload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004417, '获取角色数据权限', '获取角色数据权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 20, '0', '1', NULL, NULL, TO_DATE('2021-03-05 11:30:07','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020504', '/roleManagerFront/dataScope', 'roleManager:dataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004421, '字段删除', '字段删除', 1450765592889004593, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:11:48','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '字典管理0220', '/dicFront/delete_single', 'dict:delete_single', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004422, '角色数据导入', '角色数据导入', 1450765592889004740, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, TO_DATE('2020-03-13 10:02:32','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '202018001', '/roleManagerFront/importData', 'roleManagerFront:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004427, '查看', '员工查看', 1450765592889004578, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000057', '/employeeFront/employeeInfo', 'employeeFront:employeeInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004429, '多文件上传', '多文件上传', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000006', '/attachment/uploadfilewithdrag', 'attachment:uploadfilewithdrag', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004432, '加载角色树', '加载角色树', 1450765592889004740, NULL, NULL, '0', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2020-01-13 15:45:06','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020326', '/roleManagerFront/roleTree', 'roleManagerFront:roleTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004433, '查询角色分组下的角色', '查询角色分组下的角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000005', '/roleManagerFront/searchRoleToGroup', 'roleManagerFront:searchRoleToGroup', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004434, '修改', '组织类型修改', 1450765592889004653, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2019-08-27 09:31:03','SYYYY-MM-DD HH24:MI:SS'), '000000000058', '/sysOrganFront/edit', 'sysOrganFront:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004437, '菜单新增', '菜单新增', 1450765592889004616, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-26 19:50:14','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 19:52:05','SYYYY-MM-DD HH24:MI:SS'), '菜单维护0242', '/frontMenu/menuInfoSave', 'frontMenu:menuInfoSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004440, '根据组织机构的stru_id ，获取本组织机构用户', '根据组织机构的stru_id ，获取本组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:40:16','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '201019202', '/commonUser/userList', 'commonUser:userList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004443, '获取当前部门下的用户关联角色的信息', '获取当前部门下的用户关联角色的信息', 1450765592889004740, NULL, NULL, '0', 'res_btn', 17, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:11:14','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020181', 'roleManagerFront/getRoleOrgUser', 'roleManagerFront:getRoleOrgUser', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004444, '用户角色列表', '用户角色列表', 1450765592889004699, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:28:36','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2040252', '/userRoleReviewFront/list', 'userRoleReviewFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004445, '新增', '编码规则新增', 1450765592889004610, '', '', '1', 'res_btn', 2, '0', '1', '', NULL, NULL, 1450756958461300737, TO_DATE('2023-05-06 15:50:01','SYYYY-MM-DD HH24:MI:SS'), '000000000061', '/codeRuleService/saveCodeRule', 'codeRuleService:saveCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004449, '解冻密码列表', '获取缓存列表', 1450765592889004746, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:42:04','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-27 16:59:03','SYYYY-MM-DD HH24:MI:SS'), 'null01390259', '/ehcacheFront/list', 'ehcache:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004450, '重置密码用户列表', '重置密码用户列表', 1450765592889004735, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-27 16:40:39','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2060258', '/userFront/userList', 'userFront:userList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004452, '加载角色分组排序树', '加载角色分组排序树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000015', '/roleManagerFront/groupOrderTree', 'roleManager:groupOrderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004453, '我的催办', '我的催办', 1450765592889004597, '/urgeList', 'HussarPersonalMatters/src/views/taskmanage/urgeList', '0', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2020-08-12 01:55:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '002500940192', '/sysActUrgeTask/view', 'sysActUrgeTask:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004454, '人员审核', '人员审核页面', 523064540137791488, '/staffAudit', 'HussarAuthorization/src/views/staffAudit/index', '1', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2019-08-16 10:25:03','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-23 11:12:26','SYYYY-MM-DD HH24:MI:SS'), '007600900167', '/sysStaffAuditFront/view', 'sysStaffAudit:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004456, '在线用户列表', '在线用户列表', 1450765592889004700, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'online000001', '/onlineFront/list', 'online:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004457, '审计日志明细', '审计日志明细', 1450765592889004756, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000062', '/securityLogFront/cmdDetail', 'securityLogFront:cmdDetail', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004460, '资源导出', '资源导出', 1450765592889004630, NULL, NULL, '1', 'res_btn', 23, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:28:06','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0209', '/resourceFront/exportRes', 'resourceFront:exportRes', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004461, '获取日志目录树', '获取日志目录树', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logD00000001', '/logDownloadFront/logTree', 'logDownload:logTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004462, '获取日历事件', '获取日历事件', 1450765592889004611, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'cal000000004', '/calendarFront/list', 'calendar:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004464, '欢迎页列表权限', '欢迎页列表权限', 1450765592889004726, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:52:18','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '000400840234', '/sysWelcome/list', 'sysWelcome:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004465, '修改资源关联角色保存', '修改资源关联角色保存', 1450765592889004630, NULL, NULL, '0', 'res_btn', 35, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:17:09','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0188', 'resourceFront/resourceEditSaveRole', 'resourceFront:resourceEditSaveRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004466, '工作日历单日删除', '工作日历单日删除', 1450765592889004611, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:40:36','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00340229', '/calendarFront/delOneEvent', 'calendar:delOneEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004469, '组织类型列表', '组织类型列表', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'orgtype00001', '/orgType/orgTypeOption', 'orgType:orgTypeOption', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004470, '  清空日志', '  清空日志', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000001', '/redis/logEmpty', 'redis:logEmpty', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004472, '角色查看页面', '角色查看页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000006', '/roleManager/roleViewPage', 'roleManager:roleViewPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004473, '资源下放', '资源下放', 1450765592889004630, NULL, NULL, '1', 'res_btn', 24, '0', '1', NULL, NULL, TO_DATE('2020-02-18 06:36:11','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0168', '/resourceFront/delegateResource', 'resourceFront:delegateResource', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004474, '实例管理', '实例管理', 523177216750919680, '/bpmProcess', 'BpmManageServer/src/views/processinst/process', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-07 13:42:36','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020202020504', '/bpmProcess/view', 'bpmProcess:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004477, '用户审核驳回', '用户审核驳回', 1450765592889004651, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:24:16','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900199', '/sysUsersAuditFront/reject', 'sysUsersAuditFront:reject', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004481, '用户审核列表', '用户审核列表', 1450765592889004651, NULL, NULL, '1', 'res_btn', 10, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:19:52','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900194', '/sysUsersAuditFront/listAudit', 'sysUsersAuditFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004482, ' 模糊查询', ' 模糊查询', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000006', '/redisFront/showRedisDBValue', 'redis:showRedisDBValue', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004485, '功能查看', '功能查看', 1450765592889004630, NULL, NULL, '1', 'res_btn', 12, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:35:34','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0213', '/resourceFront/functionView', 'resourceFront:functionView', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004486, '组织机构操作审核列表', '组织机构操作审核列表', 523064495887884288, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 10:00:11','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900185', '/sysStruAuditFront/list', 'sysStruAudit:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004487, '菜单上移/下移', '菜单上移/下移', 1450765592889004616, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, TO_DATE('2019-08-27 14:55:08','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-27 19:12:56','SYYYY-MM-DD HH24:MI:SS'), '菜单维护0249', '/frontMenu/singleMove', 'frontMenu:singleMove', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004488, '功能转移', '功能转移', 1450765592889004630, NULL, NULL, '1', 'res_btn', 14, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:31:32','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0211', '/resourceFront/functionTreeChange', 'resourceFront:functionTreeChange', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004492, '文件上传', '文件上传', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000007', '/attachment/attachment:upload', 'attachment:upload', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004493, '修改', '编码规则修改', 1450765592889004610, '', '', '1', 'res_btn', 4, '0', '1', '', NULL, NULL, 1450756958461300737, TO_DATE('2023-05-06 15:50:14','SYYYY-MM-DD HH24:MI:SS'), '000000000064', '/codeRuleService/updateCodeRule', 'codeRuleService:updateCodeRule', '1', '', '', '', '', 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004495, '在线历史记录页面', '在线历史记录页面', 1450765592889004718, '/onlinehistory', 'HussarAudit/src/views/system/onlinehistory/index', '1', 'res_menu', 1, '0', '1', '1', NULL, NULL, NULL, NULL, '000000000065', '/onlineHist/view', 'onlineHist:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004497, '修改用户欢迎页配置', '修改用户欢迎页配置', 1450765592889004726, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'wel000000002', '/sysWelcome/sysWelcome_update', 'sysWelcome:sysWelcome_update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004499, '删除', '组织规则删除', 1450765592889004698, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000066', '/orgRuleFront/delete', 'orgRule:delete', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004501, '加载角色排序树', '加载角色排序树', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000016', '/roleManagerFront/roleOrderTree', 'roleManagerFront:roleOrderTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004502, '获取本组织机构所有下属组织机构的用户', '获取本组织机构所有下属组织机构的用户', 1450765592889004693, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:38:09','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020190', '/commonOrgan/directList', 'commonOrgan:searchDirectList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004503, '保存角色数据权限', '保存角色数据权限', 1450765592889004740, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, TO_DATE('2021-03-05 11:31:07','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020505', '/roleManagerFront/saveDataScope', 'roleManager:saveDataScope', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004507, '快捷入口配置', '快捷入口配置', 1450765592889004623, '/shortCutConf', 'HussarConfig/src/views/personalizedConf/shortCutConf', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-23 11:54:08','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020102080510', '/personalizedConf/shortCurConf', 'personalizedConf:shortCutConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004508, '组织机构新增页面', '组织机构新增页面', 1450765592889004693, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-27 09:28:18','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020247', '/orgMainFront/orgInfoAdd', 'orgMainFront:orgInfoAdd', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004509, '导入', '编码规则导入', 1450765592889004610, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2019-08-26 11:36:14','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 20:14:40','SYYYY-MM-DD HH24:MI:SS'), '100010222', '/idtableFront/importData', 'idtable:importData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004510, '组织机构人员树', '组织机构人员树', 1450765592889004578, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'emp000000001', '/employeeFront/employeeTree', 'employeeFront:employeeTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004512, '角色数据导出', '角色数据导出', 1450765592889004740, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, TO_DATE('2020-03-13 10:02:05','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020179', '/roleManagerFront/exportData', 'roleManagerFront:exportData', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004513, '慢SQL列表', '慢SQL列表', 523159993936257024, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'sql000000001', '/sqlMonitorFront/list', 'SqlMonitor:list', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004514, '附件信息列表', '附件信息列表', 1450765592889004614, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'atta00000002', '/attachment/getAttachmentList', 'attachment:getAttachmentList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004515, '日志下载', '日志下载', 1450765592889004701, '/logdownload', 'HussarOperations/src/views/service/logdownload/index', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2018-08-29 19:09:12','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00780148', '/logDownload/view', 'logDownload:view', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004516, '角色新增页面', '角色新增页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000007', '/roleManager/roleAddPage', 'roleManager:roleAddPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004517, '框架页配置', '框架页配置', 1450765592889004732, '/layoutConf', 'HussarConfig/src/views/personalizedConf/layoutConf', '0', 'res_menu', 1, '0', '1', '1', NULL, TO_DATE('2021-06-23 11:40:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '020102040506', '/personalizedConf/layoutConf', 'personalizedConf:layoutConf', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004519, '驳回', '角色审核驳回', 1450765592889004699, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, NULL, NULL, NULL, '2040024', '/userRoleReviewFront/refuseSubmit', 'userRoleReviewFront:refuseSubmit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004521, '组织机构ID获取组织机构树', '组织机构ID获取组织机构树', 1450765592889004693, NULL, NULL, '1', 'res_btn', 21, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'org000000002', '/orgMainFront/orgTreeById', 'orgMainFront:orgTreeById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004522, '获取日志文件列表', '获取日志文件列表', 1450765592889004701, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logD00000002', '/logDownloadFront/logTable', 'logDownload:logTable', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004526, '查询', '组织类型查询', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000067', '/sysOrganFront/list', 'sysOrganFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004529, '资源修改', '资源修改', 1450765592889004630, NULL, NULL, '1', 'res_btn', 17, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-27 16:19:47','SYYYY-MM-DD HH24:MI:SS'), '000034', '/resource/resourceEdit', 'resourceFront:resourceEditSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004530, '字典下级排序', '字典下级排序', 1450765592889004593, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2018-04-20 13:59:43','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 11:04:57','SYYYY-MM-DD HH24:MI:SS'), '字典管理0031', '/dicFront/sort', 'dicFront:sort', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004533, '当前用户所在的组织机构', '当前用户所在的组织机构', 1450765592889004737, NULL, NULL, '1', 'res_btn', 15, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:42:50','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010195', '/commonUser/currentUserInfo', 'commonUser:currentUserInfo', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004536, '删除角色', '删除角色', 1450765592889004740, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000068', '/roleManagerFront/delRole', 'roleManagerFront:delRole', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004539, '删除', '组织机构删除', 1450765592889004693, NULL, NULL, '1', 'res_btn', 7, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000069', '/orgMainFront/delOrgById', 'orgMainFront:delOrgById', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004544, '模块保存', '模块保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 6, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-20 17:05:49','SYYYY-MM-DD HH24:MI:SS'), 'mod401370313', '/resourceFront/moduleSave', 'resourceFront:moduleSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004545, ' 获取当前数据库中key的数量', ' 获取当前数据库中key的数量', 1450765592889004621, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'logR00000002', '/redisFront/getKeysSize', 'redis:getKeysSize', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004546, '组织类型详情', '组织类型详情', 1450765592889004653, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'orgtype00002', '/sysOrganFront/selectOrg', 'sysOrganFront:selectOrg', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004551, '基础配置列表权限', '基础配置列表权限', 1450765592889004658, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:58:06','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '000400940235', '/sysBaseConfigFront/list', 'sysBaseConfigFront:getList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004554, '修改欢迎页', '修改欢迎页', 1450765592889004726, NULL, NULL, '1', 'res_btn', 5, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:51:01','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '000400840233', '/sysWelcome/update', 'sysWelcome:update', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004555, '角色排序', '角色排序', 1450765592889004740, NULL, NULL, '1', 'res_btn', 11, '0', '1', NULL, NULL, TO_DATE('2019-08-23 11:46:02','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2020203', '/roleManagerFront/saveRoleOrder', 'roleManagerFront:saveRoleOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004556, '工作日历单日新增', '工作日历单日新增', 1450765592889004611, NULL, NULL, '1', 'res_btn', 4, '0', '1', NULL, NULL, TO_DATE('2019-08-26 13:36:50','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'null00340226', '/calendarFront/addOneEvent', 'calendar:addOneEvent', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004558, '终止会话', '终止会话', 1450765592889004700, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, NULL, NULL, NULL, '000000000002', '/onlineFront/stopSession', 'online:stopSession', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004559, '获取不相容角色资源', '获取不相容角色资源', 1450765592889004725, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'inco00000001', '/incompatibleRolesFront/selectInRoles', 'incompatibleRoles:selectInRoles', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004563, '修改字典类别', '修改字典类别', 1450765592889004593, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2018-04-20 13:57:13','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 10:58:24','SYYYY-MM-DD HH24:MI:SS'), '字典管理0029', '/dicFront/edit', 'dict:edit', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004564, '查询回收下放树', '查询回收下放树', 1450765592889004693, NULL, NULL, '0', 'res_btn', 14, '0', '1', NULL, NULL, TO_DATE('2020-06-05 06:36:52','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '1020166', '/orgMainFront/getDelegateRetrieveTree', 'orgMainFront:getDeReTree', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004565, '根据code获取字典', '根据code获取字典', 1450765592889004630, NULL, NULL, '0', 'res_btn', 30, '0', '1', NULL, NULL, TO_DATE('2020-06-05 07:07:33','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0177', '/dicFront/getDictByCode', 'dict:getDictByCode', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004566, '角色修改页面', '角色修改页面', 1450765592889004740, NULL, NULL, '1', 'res_btn', 2, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:44:27','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, 'role00000008', '/roleManager/roleEditPage', 'roleManager:roleEditPage', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004567, '模块下级排序', '资源模块下级排序', 1450765592889004630, NULL, NULL, '1', 'res_btn', 8, '0', '1', NULL, NULL, TO_DATE('2019-08-26 09:22:21','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '资源维护0205', '/resourceFront/moduleTreeOrder', 'resourceFront:moduleTreeOrder', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004569, '组织机构操作审核', '组织机构操作审核', 523064495887884288, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2019-08-23 09:43:51','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '007600900181', '/sysStruAuditFront/verify', 'sysStruAudit:verify', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004570, '登陆统计', '登陆统计页面', 1450765592889004756, NULL, NULL, '1', 'res_btn', 3, '0', '1', NULL, NULL, TO_DATE('2018-09-28 14:15:44','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2019-08-26 11:20:23','SYYYY-MM-DD HH24:MI:SS'), '5070153', '/loginStatistics/view', 'loginStatistics:view', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004571, '获取本组织机构直接下级组织机构用户', '获取本组织机构直接下级组织机构用户', 1450765592889004737, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, TO_DATE('2020-12-02 14:40:48','SYYYY-MM-DD HH24:MI:SS'), NULL, NULL, '2010193', '/commonUser/juniorUserList', 'commonUser:juniorUserList', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (1450765592889004572, '功能保存', '功能保存', 1450765592889004630, NULL, NULL, '1', 'res_btn', 13, '0', '1', NULL, NULL, NULL, NULL, TO_DATE('2018-04-23 09:51:51','SYYYY-MM-DD HH24:MI:SS'), '00012', '/resourceFront/functionSave', 'resourceFront:functionSave', '1', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581431768348106752, '流程状态分析', '流程状态分析', 564389571845169152, '/processStatus', 'BpmBPA/src/views/processAnalysis/processStatus', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:42:16','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-26 15:55:09','SYYYY-MM-DD HH24:MI:SS'), '02150540', '', 'bpa:processStatus', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581432525403201536, '流程参与者分析', '流程参与者分析', 564389571845169152, '/processParticipantAnalysis', 'BpmBPA/src/views/processAnalysis/processParticipantAnalysis', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:45:17','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-31 15:07:23','SYYYY-MM-DD HH24:MI:SS'), '02150542', '', 'bpa:processParticipantAnalysis', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581434143087534080, '流程统计分析', '流程统计分析', 564389571845169152, '/processStatisticalAnalysis', 'BpmBPA/src/views/processAnalysis/processStatisticalAnalysis', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:51:42','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-02 09:06:32','SYYYY-MM-DD HH24:MI:SS'), '02150544', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581434493471301632, '热门流程分析', '热门流程分析', 581434239535554560, '/popularProcessAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/popularProcessAnalysis', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:53:06','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-26 15:55:20','SYYYY-MM-DD HH24:MI:SS'), '02390545', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581434937987833856, '流程数量分析', '流程数量分析', 581434239535554560, '/processQuantityAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processQuantityAnalysis', '0', 'res_menu', 2, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:54:52','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 14:07:46','SYYYY-MM-DD HH24:MI:SS'), '02390548', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581435215210356736, '用户流程分析', '用户流程分析', 581434239535554560, '/personProcessAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/personProcessAnalysis', '0', 'res_menu', 3, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:55:58','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-31 16:48:16','SYYYY-MM-DD HH24:MI:SS'), '02390550', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581435962006183936, '待办任务分析', '待办任务分析', 581434239535554560, '/todoTaskAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/todoTaskAnalysis', '0', 'res_menu', 4, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 10:58:56','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-01 17:02:52','SYYYY-MM-DD HH24:MI:SS'), '02390551', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (581436516656750592, '流程耗时分析', '流程耗时分析', 564389571845169152, '/processTimeAnalysis', 'BpmBPA/src/views/processAnalysis/timeAnalysis/processTimeAnalysis', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, TO_DATE('2022-05-24 11:01:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-02 09:58:19','SYYYY-MM-DD HH24:MI:SS'), '02400554', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (586205441340743680, '流程驳回分析', '流程驳回分析', 581434239535554560, '/processRejectAnalysis', 'BpmBPA/src/views/processAnalysis/quantitativeAnalysis/processRejectAnalysis', '0', 'res_menu', 5, '0', '1', '1', 1450756958461300737, TO_DATE('2022-06-06 14:51:08','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-06-06 18:01:02','SYYYY-MM-DD HH24:MI:SS'), '02390555', '', '', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (564389067157151744, '流程概览', '流程概览', 564389571845169152, '/processOverview', 'BpmBPA/src/views/processAnalysis/processOverview', '0', 'res_menu', 1, '0', '1', '1', 1450756958461300737, TO_DATE('2022-04-07 10:00:39','SYYYY-MM-DD HH24:MI:SS'), 1450756958461300737, TO_DATE('2022-05-26 15:51:56','SYYYY-MM-DD HH24:MI:SS'), '02340002', '', 'bpa:view', '0', '', NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (576425225089196032, '委托待办', '委托待办', 576446323717578752, '/entrustTodoList', 'HussarPersonalMatters/src/views/taskmanage/entrustTodoList', '1', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), '00250645', '/entrustTodo', 'entrustTodo:list', '0', NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO "SYS_RESOURCES" ("RESOURCE_ID", "RESOURCE_NAME", "RESOURCE_ALIAS", "MODULE_ID", "PATH", "COMPONENT", "IS_AUDIT", "RES_TYPE_ID", "SEQ", "IS_REPEAT_AUTHENTICATE", "STRATEGY", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "LAST_EDITOR", "LAST_TIME", "RESOURCE_CODE", "URL_NAMES", "PERMISSIONS", "IS_SYS", "SERVICE_NAME", "USER_RIGHTS", "DEPT_RIGHTS", "MAPPER", "APPLICATION_ID", "PARENT_RESOURCE_ID") VALUES (576437892923269120, '委托已办', '委托已办', 576437727940321280, '/entrustDoneList', 'HussarPersonalMatters/src/views/taskmanage/entrustDoneList', '1', 'res_menu', 1, '0', '1', NULL, NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-10 00:00:00','SYYYY-MM-DD HH24:MI:SS'), '02690646', '/entrustDone', 'entrustDone:list', '0', NULL, NULL, NULL, NUL