/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.DataSourceProperties;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.EncrypDes;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.dto.TenantPermissonDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceDynamicService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.DataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.datasource.service.impl.sysDataSourceServiceImpl")
@HussarTransactional
public class SysDataSourceServiceImpl
extends HussarServiceImpl<SysDataSourceMapper, SysDataSource>
implements SysDataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(SysDataSourceServiceImpl.class);
    @Resource
    private SysDataSourceMapper sysDataSourceMapper;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private ServerProperties serverProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private SysDataSourceDynamicService sysDataSourceDynamicService;
    @Resource
    private DatasourceService datasourceService;
    @Resource
    private DataSource dataSource;
    private static final Long MASTER_DS = 1450384273189240833L;
    private static final String ERROR_MESSAGE_TEMPLATE = "errorMessage:{}";
    @Resource
    private HussarTenantProperties hussarTenantProperties;

    public List<SysDataSource> list() {
        LambdaQueryWrapper exWrapper;
        List exList;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (this.hussarTenantProperties.isEnabled()) {
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            if (HussarUtils.isNotBlank((CharSequence)tenantCode) && !tenantCode.equals("master")) {
                queryWrapper.eq(SysDataSource::getTenantCode, (Object)tenantCode);
            } else {
                queryWrapper.eq(SysDataSource::getTenantCode, (Object)"0");
            }
            return this.list((Wrapper)queryWrapper);
        }
        ArrayList<SysDataSource> result = new ArrayList<SysDataSource>();
        SysDataSource master = (SysDataSource)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)"master"), false);
        if (HussarUtils.isNotEmpty((Object)master)) {
            result.add(master);
        }
        if (HussarUtils.isNotEmpty((Object)(exList = this.list((Wrapper)(exWrapper = (LambdaQueryWrapper)queryWrapper.eq(SysDataSource::getDatasourceType, (Object)"2")))))) {
            result.addAll(exList);
        }
        return result;
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId) {
        SysDataSourceDto sysDataSourceDto = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dbId)));
        return ApiResponse.success((Object)sysDataSourceDto);
    }

    @Deprecated
    public IPage<SysDataSource> getListUncorrelated(Page<SysDataSource> page) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.notInSql(SysDataSource::getId, "SELECT DB_ID from SYS_TENANT  where DEL_FLAG = '0' ");
        IPage dataSourceIpage = this.sysDataSourceMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return dataSourceIpage;
    }

    public IPage<SysDataSource> listDataSource(Page<SysDataSource> page, SysDataSource sysDataSource) {
        return this.datasourceService.listDataSource(page, sysDataSource);
    }

    @Deprecated
    public ApiResponse<SysDataSource> saveDatasource(SysDataSourceDto sysDataSource) {
        String validate = this.validateAddDataSource((SysDataSource)sysDataSource);
        if (ToolUtil.isNotEmpty((Object)validate)) {
            throw new DataSourceException(validate);
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException e) {
            logger.error(ERROR_MESSAGE_TEMPLATE, (Object)e.getMessage(), (Object)e);
        }
        if (!super.save((BaseEntity)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        Connection conn = null;
        try {
            ApiResponse<?> result;
            conn = this.dynamicDataSourceService.getConnection(sysDataSource.getPermitUrl(), sysDataSource.getPermitUserName(), sysDataSource.getPermitPassword());
            String driverName = conn.getMetaData().getDriverName();
            if (driverName.toUpperCase().contains("MYSQL")) {
                result = this.isMysql(conn, (SysDataSource)sysDataSource);
            } else if (driverName.toUpperCase().contains("OSCAR")) {
                result = this.isOscar(conn, (SysDataSource)sysDataSource);
            } else if (driverName.toUpperCase().contains("ORACLE")) {
                result = this.isOracle(conn, (SysDataSource)sysDataSource);
            } else if (driverName.toUpperCase().contains("DM")) {
                result = this.isDm(conn, (SysDataSource)sysDataSource);
            } else if (driverName.toUpperCase().contains("POSTGRESQL")) {
                result = this.isPostgresql(conn, (SysDataSource)sysDataSource);
            } else {
                throw new BaseException("\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
            }
            if (ResultCode.SUCCESS.getCode() == result.getCode()) {
                ApiResponse apiResponse = ApiResponse.success((Object)sysDataSource);
                return apiResponse;
            }
            try {
                throw new DataSourceException(result.getMsg());
            }
            catch (SQLException e) {
                logger.error(ERROR_MESSAGE_TEMPLATE, (Object)e.getMessage(), (Object)e);
                throw new BaseException("\u6570\u636e\u5e93\u5f02\u5e38!");
            }
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error(ERROR_MESSAGE_TEMPLATE, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public ApiResponse<SysDataSource> saveDataSourceWithCheck(SysDataSourceDto sysDataSource, boolean isCheck) {
        return this.datasourceService.saveDataSourceWithCheck(sysDataSource, isCheck);
    }

    @Deprecated
    public Boolean checkTableExist(SysDataSource sysDataSource) {
        this.addDataSource(sysDataSource);
        return this.sysDataSourceDynamicService.checkTableExist(sysDataSource.getConnName(), sysDataSource);
    }

    private String validateAddDataSource(SysDataSource sysDataSource) {
        ApiResponse<SysDataSource> dbNameResult = this.checkDbName(sysDataSource.getDbName());
        if (ResultCode.SUCCESS.getCode() != dbNameResult.getCode()) {
            return dbNameResult.getMsg();
        }
        ApiResponse<Boolean> connNameResult = this.checkConnName(sysDataSource.getConnName());
        if (((Boolean)connNameResult.getData()).booleanValue()) {
            return "\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01";
        }
        SysDataSourceDto sysDataSourceDto = (SysDataSourceDto)sysDataSource;
        sysDataSourceDto.setPrint(false);
        ApiResponse<String> connResult = this.tryConnection(sysDataSourceDto);
        if (ResultCode.SUCCESS.getCode() == connResult.getCode()) {
            return "\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff01";
        }
        if (sysDataSource.getJdbcUrl().toUpperCase().contains("POSTGRESQL") && !connResult.isSuccess()) {
            return "\u6570\u636e\u5e93\u6216\u89d2\u8272\u5df2\u5b58\u5728\uff01";
        }
        return null;
    }

    public ApiResponse<SysDataSource> updateDatasource(SysDataSource sysDataSource) {
        SysDataSourceDto sysDataSourceDto = new SysDataSourceDto();
        CopyPropertieUtils.copyProperties((Object)sysDataSourceDto, (Object)sysDataSource);
        this.datasourceService.updateDatasource(sysDataSourceDto);
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<SysDataSource> deleteDataSourceByLongIds(List<Long> ids) {
        List strIds = ids.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        this.datasourceService.deleteDataSource(strIds);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Deprecated
    public ApiResponse<SysDataSource> deleteDataSource(List<String> ids) {
        List<Long> cdids = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.deleteDataSourceByLongIds(cdids);
    }

    @Deprecated
    public ApiResponse<SysDataSource> checkDbName(String dbName) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(SysDataSource::getDbName, (Object)dbName)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        Long count = this.sysDataSourceMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        return ApiResponse.success((String)ResultCode.SUCCESS.getMessage());
    }

    public SysDataSource getByTenantCode(String tenantCode) {
        if (ToolUtil.isEmpty((Object)tenantCode)) {
            throw new BaseException("\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        return this.sysDataSourceMapper.getByTenantCode(tenantCode);
    }

    public SysDataSource getByTenantCodeAndPwd(String tenantCode) {
        if (ToolUtil.isEmpty((Object)tenantCode)) {
            throw new BaseException("\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        SysDataSource tenantDataSource = this.sysDataSourceMapper.getByTenantCodeAndPwd(tenantCode);
        try {
            EncrypDes encrypDes = new EncrypDes();
            tenantDataSource.setPassword(encrypDes.encrypt(tenantDataSource.getPassword()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tenantDataSource;
    }

    @Deprecated
    public ApiResponse<Boolean> checkConnName(String connName) {
        return ApiResponse.success((Object)this.datasourceService.checkConnName(connName, false));
    }

    public SysDataSource getByConnName(String connName) {
        return this.datasourceService.getDataSourceByConnName(connName);
    }

    public void addDataSourceByConnName(String connName) {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)this.dynamicDataSourceService.getDataSource(connName))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            SysDataSource sysDataSource = this.getByConnName(connName);
            DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
            dynamicDataSourceDto.setPoolName(sysDataSource.getConnName());
            dynamicDataSourceDto.setDriverClassName(sysDataSource.getDriverClass());
            dynamicDataSourceDto.setUrl(sysDataSource.getJdbcUrl());
            dynamicDataSourceDto.setUserName(sysDataSource.getUserName());
            dynamicDataSourceDto.setPassword(sysDataSource.getPassword());
            dynamicDataSourceDto.setDbMode(sysDataSource.getDbMode());
            this.dynamicDataSourceService.addDataSource(dynamicDataSourceDto);
        }
    }

    private void addDataSource(SysDataSource sysDataSource) {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)this.dynamicDataSourceService.getDataSource(sysDataSource.getConnName()))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
            dynamicDataSourceDto.setPoolName(sysDataSource.getConnName());
            dynamicDataSourceDto.setDriverClassName(sysDataSource.getDriverClass());
            dynamicDataSourceDto.setUrl(sysDataSource.getJdbcUrl());
            dynamicDataSourceDto.setUserName(sysDataSource.getUserName());
            dynamicDataSourceDto.setPassword(sysDataSource.getPassword());
            dynamicDataSourceDto.setDbMode(sysDataSource.getDbMode());
            this.dynamicDataSourceService.addDataSource(dynamicDataSourceDto);
        }
    }

    @Deprecated
    public ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        if (ToolUtil.isEmpty((Object)sysDataSourceDto) || ToolUtil.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || ToolUtil.isEmpty((Object)sysDataSourceDto.getUserName())) {
            throw new BaseException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a");
        }
        Connection conn = null;
        try {
            conn = this.dynamicDataSourceService.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
            String driverName = conn.getMetaData().getDriverName();
            ApiResponse apiResponse = ApiResponse.success((String)driverName.toUpperCase());
            return apiResponse;
        }
        catch (Exception e) {
            if (sysDataSourceDto.getPrint()) {
                logger.error(ERROR_MESSAGE_TEMPLATE, (Object)e.getMessage(), (Object)e);
            }
            throw new BaseException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Deprecated
    public ApiResponse<?> isMysql(String username, String password, String driverClassName, String url, String code) {
        String str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
        String dsName = str.substring(str.indexOf("/") + 1);
        String newUrl = url.replace(dsName, code);
        SysDataSource sysDataSource = new SysDataSource();
        sysDataSource.setDbName(code);
        sysDataSource.setConnName("tenant" + code);
        sysDataSource.setDriverClass(driverClassName);
        sysDataSource.setJdbcUrl(newUrl);
        sysDataSource.setUserName(username);
        sysDataSource.setPassword(password);
        if (!super.save((BaseEntity)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(newUrl);
        dataSourceProperties.setUsername(username);
        dataSourceProperties.setPassword(password);
        dataSourceProperties.setDriverClassName(driverClassName);
        dataSourceProperties.setDbName(code);
        dataSourceProperties.setPoolName(sysDataSource.getConnName());
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isMysql(Connection conn, SysDataSource dataSource) {
        String url = dataSource.getJdbcUrl();
        String dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
        dsName = dsName.substring(dsName.indexOf("/") + 1);
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(url);
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(dataSource.getDriverClass());
        dataSourceProperties.setDbName(dsName);
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return this.createDataSource(conn, dataSourceProperties);
    }

    @Deprecated
    public ApiResponse<?> isOscar(String driverClassName, String url, String code) {
        return this.verifyDsType(driverClassName, url, code);
    }

    private ApiResponse<?> isOscar(Connection conn, SysDataSource dataSource) {
        return this.verifyDsType(conn, dataSource);
    }

    @Deprecated
    public ApiResponse<?> isOracle(String driverClassName, String url, String code) {
        return this.verifyDsType(driverClassName, url, code);
    }

    private ApiResponse<?> isOracle(Connection conn, SysDataSource dataSource) {
        return this.verifyDsType(conn, dataSource);
    }

    private ApiResponse<?> createDataSource(Connection conn, DataSourceProperties dataSourceProperties) {
        boolean isCreate = true;
        if (!"2".equals(this.hussarBaseProperties.getTenantLevel()) && !"3".equals(this.hussarBaseProperties.getTenantLevel())) {
            isCreate = false;
        }
        if (isCreate) {
            return ApiResponse.status((boolean)true);
        }
        throw new DataSourceException("\u6570\u636e\u5e93\u521b\u5efa\u5931\u8d25\uff01");
    }

    private SysDataSource getDataSourceLikeOracle(String driverClassName, String url, String code) {
        String userName = "USER" + code;
        String password = "PWD" + code;
        if (url.contains("jdbc:postgresql")) {
            String str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
            String dsName = str.substring(str.indexOf("/") + 1);
            url = url.replace(dsName, userName);
        }
        SysDataSource sysDataSource = new SysDataSource();
        sysDataSource.setDbName(code);
        sysDataSource.setConnName("tenant" + code);
        sysDataSource.setDriverClass(driverClassName);
        sysDataSource.setJdbcUrl(url);
        sysDataSource.setUserName(userName);
        sysDataSource.setPassword(password);
        return sysDataSource;
    }

    private DataSourceProperties getPropertiesLikeOracle(String driverClassName, String url, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(url);
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(driverClassName);
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return dataSourceProperties;
    }

    private DataSourceProperties getPropertiesByDataSource(SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(dataSource.getJdbcUrl());
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(dataSource.getDriverClass());
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return dataSourceProperties;
    }

    @Deprecated
    public ApiResponse<?> isDm(String driverClassName, String url, String code) {
        return this.verifyDsType(driverClassName, url, code);
    }

    private ApiResponse<?> isDm(Connection conn, SysDataSource dataSource) {
        return this.verifyDsType(conn, dataSource);
    }

    @Deprecated
    @HussarTransactional
    public ApiResponse<?> isPostgresql(String username, String password, String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((BaseEntity)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isPostgresql(Connection conn, SysDataSource dataSource) {
        return this.verifyDsType(conn, dataSource);
    }

    @Deprecated
    public ApiResponse<String> execSqlFile(String dbId, String isBpmType, String tenantId) {
        if (ToolUtil.isEmpty((Object)dbId)) {
            throw new BaseException("dbId\u4e3a\u7a7a");
        }
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceMapper.selectById((Serializable)((Object)dbId));
        String url = sysDataSource.getJdbcUrl();
        String userName = sysDataSource.getUserName();
        String password = sysDataSource.getPassword();
        Connection conn = null;
        try {
            conn = this.dynamicDataSourceService.getConnection(url, userName, password);
            String driverName = conn.getMetaData().getDriverName();
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUrl(url);
            dataSourceProperties.setUsername(userName);
            dataSourceProperties.setPassword(password);
            ApiResponse<String> apiResponse = this.excuteSql(isBpmType, driverName, dataSourceProperties);
            return apiResponse;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DataSourceException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ApiResponse<String> execSqlFile(DataSourceProperties dataSourceProperties, String initPath, String updatePath, String bpmPath) {
        return ApiResponse.status((boolean)true);
    }

    private ApiResponse<String> execSqlFile(DataSourceProperties dataSourceProperties, String initPath, String updatePath) {
        return ApiResponse.status((boolean)true);
    }

    @Deprecated
    public String getIP() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    public ApiResponse<TenantPermissonDto> getTenantPermission() {
        String tenantLevel = this.hussarBaseProperties.getTenantLevel();
        if (ToolUtil.isEmpty((Object)tenantLevel)) {
            throw new BaseException("\u79df\u6237\u7b49\u7ea7\u4e3a\u7a7a");
        }
        boolean isAdmin = BaseSecurityUtil.isAdmin();
        TenantPermissonDto tenantPermissonDto = new TenantPermissonDto();
        tenantPermissonDto.setTenantLevel(tenantLevel);
        tenantPermissonDto.setIsAdmin(isAdmin);
        return ApiResponse.success((Object)tenantPermissonDto);
    }

    public List<SysDataSource> getAllTenantDataSource() {
        return this.sysDataSourceMapper.getAllTenantDataSource();
    }

    public List<SysDataSource> getAllDataSource() {
        ArrayList<SysDataSource> externalDataSources = new ArrayList<SysDataSource>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)securityUser)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237");
        }
        String connName = (String)securityUser.getExtendUserMap("connName");
        if (HussarUtils.isBlank((CharSequence)connName)) {
            connName = "master";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysDataSource::getConnName, (Object)connName);
        SysDataSource currentDataSource = (SysDataSource)this.sysDataSourceMapper.selectOne((Wrapper)queryWrapper);
        queryWrapper.clear();
        if (ToolUtil.isNotEmpty((Object)currentDataSource)) {
            externalDataSources.add(currentDataSource);
        }
        externalDataSources.addAll(this.sysDataSourceMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0")).eq(SysDataSource::getDatasourceType, (Object)"2")).orderByDesc(HussarBaseEntity::getCreateTime)));
        return externalDataSources;
    }

    public SysDataSource getMasterDataSource() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dsDataSource = ds.getDataSource("master");
        SysDataSource sysDataSource = new SysDataSource();
        if (dsDataSource instanceof AbstractHussarDataSource) {
            AbstractHussarDataSource itemDataSource = (AbstractHussarDataSource)dsDataSource;
            sysDataSource.setId(MASTER_DS);
            sysDataSource.setConnName(itemDataSource.getPoolName());
            sysDataSource.setDbName(itemDataSource.getPoolName());
            sysDataSource.setJdbcUrl(itemDataSource.getUrl());
            sysDataSource.setUserName(itemDataSource.getUsername());
            sysDataSource.setPassword(itemDataSource.getPassword());
            sysDataSource.setDriverClass(itemDataSource.getDriverClassName());
            sysDataSource.setInstantName(this.getMasterInstantName(sysDataSource));
            sysDataSource.setRemark("\u9ed8\u8ba4\u6570\u636e\u8fde\u63a5");
            sysDataSource.setDelFlag("0");
        }
        return sysDataSource;
    }

    private String getMasterInstantName(SysDataSource dataSource) {
        String instantName = null;
        String jdbcUrl = dataSource.getJdbcUrl();
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            instantName = this.getMysqlInstantName(jdbcUrl);
        } else if (jdbcUrl.startsWith("jdbc:oracle")) {
            instantName = dataSource.getUserName();
        }
        return instantName;
    }

    private String getMysqlInstantName(String jdbcUrl) {
        String str = jdbcUrl.substring(jdbcUrl.indexOf("/") + 2, jdbcUrl.indexOf("?"));
        return str.substring(str.indexOf("/") + 1);
    }

    public List<SysDataSource> list(Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            ArrayList<SysDataSource> list = new ArrayList<SysDataSource>();
            list.add(this.getMasterDataSource());
            return list;
        }
        return super.list();
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return ApiResponse.success((Object)this.getMasterDataSource());
        }
        return this.getDatasourceById(dbId);
    }

    public SysDataSource getByTenantCode(String tenantCode, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByTenantCode(tenantCode);
    }

    public SysDataSource getByConnName(String connName, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByConnName(connName);
    }

    public Page<SysDataSource> getList(Page<SysDataSource> page, QueryWrapper<SysDataSource> queryWrapper) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        Page sysDataSourcePage = (Page)this.sysDataSourceMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = sysDataSourcePage.getRecords();
        if (records != null && records.size() > 0) {
            for (int i = 0; i < records.size(); ++i) {
                ((SysDataSource)records.get(i)).setPassword("");
            }
        }
        return sysDataSourcePage;
    }

    private ApiResponse<String> excuteSql(String isBpmType, String driverName, DataSourceProperties dataSourceProperties) {
        if ("1".equals(isBpmType)) {
            if (driverName.toUpperCase().contains("MYSQL")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/mysql/HUSSAR_V8_MYSQL.sql", "tenantsql/mysql/HUSSAR_V8_MYSQL_UPDATE.sql", "tenantsql/mysql/BPM_MYSQL.sql");
            }
            if (driverName.toUpperCase().contains("OSCAR")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/oscar/HUSSAR_V8_OSCAR.sql", "tenantsql/oscar/HUSSAR_V8_OSCAR_UPDATE.sql", "tenantsql/oscar/BPM_OSCAR.sql");
            }
            if (driverName.toUpperCase().contains("ORACLE")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/oracle/HUSSAR_V8_ORACLE.sql", "tenantsql/oracle/HUSSAR_V8_ORACLE_UPDATE.sql", "tenantsql/oracle/BPM_ORACLE.sql");
            }
            if (driverName.toUpperCase().contains("DM")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/dm/HUSSAR_V8_DM.sql", "tenantsql/dm/HUSSAR_V8_DM_UPDATE.sql", "tenantsql/dm/BPM_DM.sql");
            }
            return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
        }
        if (driverName.toUpperCase().contains("MYSQL")) {
            return this.execSqlFile(dataSourceProperties, "tenantsql/mysql/HUSSAR_V8_MYSQL.sql", "tenantsql/mysql/HUSSAR_V8_MYSQL_UPDATE.sql");
        }
        if (driverName.toUpperCase().contains("OSCAR")) {
            return this.execSqlFile(dataSourceProperties, "tenantsql/oscar/HUSSAR_V8_OSCAR.sql", "tenantsql/oscar/HUSSAR_V8_OSCAR_UPDATE.sql");
        }
        if (driverName.toUpperCase().contains("ORACLE")) {
            return this.execSqlFile(dataSourceProperties, "tenantsql/oracle/HUSSAR_V8_ORACLE.sql", "tenantsql/oracle/HUSSAR_V8_ORACLE_UPDATE.sql");
        }
        if (driverName.toUpperCase().contains("DM")) {
            return this.execSqlFile(dataSourceProperties, "tenantsql/dm/HUSSAR_V8_DM.sql", "tenantsql/dm/HUSSAR_V8_DM_UPDATE.sql");
        }
        if (driverName.toUpperCase().contains("POSTGRESQL")) {
            return this.execSqlFile(dataSourceProperties, "tenantsql/postgresql/HUSSAR_V8_PGSQL.sql", "tenantsql/postgresql/HUSSAR_V8_PGSQL_UPDATE.sql");
        }
        return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
    }

    private ApiResponse<?> verifyDsType(Connection conn, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = this.getPropertiesByDataSource(dataSource);
        return this.createDataSource(conn, dataSourceProperties);
    }

    private ApiResponse<?> verifyDsType(String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((BaseEntity)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }
}

