/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.impl.AbstractDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.sqlserverDatabaseOperateServiceImpl")
public class SqlserverDatabaseOperateServiceImpl
extends AbstractDatabaseOperateService
implements InitializingBean {
    private static Pattern dropTablePattern = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);
    private static Pattern dropViewPattern = Pattern.compile("\\bDROP\\s+VIEW\\b", 8);

    @HussarDs(value="master")
    public SysDataSourceDto createSchema(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException {
        String sql = "CREATE DATABASE " + sysDataSourceDto.getDbName();
        this.execute(sql);
        return sysDataSourceDto;
    }

    public Resource[] getInitExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/init/sqlserver/*.sql");
        return resources;
    }

    public Resource[] getUpgradeExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/upgrade/sqlserver/*.sql");
        return resources;
    }

    public void setParametersByMaster(SysDataSourceDto sysDataSourceDto) {
        String str = sysDataSourceDto.getJdbcUrl();
        String[] split = str.split(";");
        String dsName = "";
        for (String s : split) {
            String[] arr;
            if (!HussarUtils.isNotBlank((CharSequence)s) || (arr = s.split("=")).length != 2 || !"DATABASENAME".equals(arr[0].trim().toUpperCase())) continue;
            dsName = arr[1].trim();
            break;
        }
        if (HussarUtils.isBlank((CharSequence)dsName)) {
            throw new BaseException("\u89e3\u6790sqlserver\u6570\u636e\u5e93\u540d\u79f0\u5931\u8d25");
        }
        String newUrl = sysDataSourceDto.getJdbcUrl().replace(dsName, sysDataSourceDto.getDbName());
        sysDataSourceDto.setJdbcUrl(newUrl);
    }

    public void afterPropertiesSet() throws Exception {
        DatabaseFactory.add((String)DbType.SQL_SERVER.getDb(), (IHussarBaseDatabaseOperateService)this);
    }

    public List<String> preTreatment(Connection connection, Resource resource, boolean drop) throws IOException, ScriptException {
        List lines = IOUtils.readLines((InputStream)resource.getInputStream(), (String)"UTF-8");
        StringBuilder stringBuilder = new StringBuilder("");
        for (String line : lines) {
            if (StringUtils.isNotBlank((CharSequence)line) && line.trim().equalsIgnoreCase("GO")) {
                stringBuilder.append(";").append("\n");
                continue;
            }
            stringBuilder.append(line).append("\n");
        }
        ArrayList<String> result = new ArrayList<String>();
        byte[] bytes = stringBuilder.toString().getBytes("UTF-8");
        List statements = HussarTenantScriptUtils.getSplitSqlScript((InputStream)new ByteArrayInputStream(bytes));
        if (drop) {
            return statements;
        }
        for (String statement : statements) {
            String temp;
            if (!StringUtils.isNotBlank((CharSequence)statement) || dropTablePattern.matcher(temp = statement.trim().toUpperCase()).find() || dropViewPattern.matcher(temp).find()) continue;
            result.add(statement);
        }
        return result;
    }
}

