/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.impl.AbstractDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.oceanBaseOperateServiceImpl")
public class OceanBaseOperateServiceImpl
extends AbstractDatabaseOperateService
implements InitializingBean {
    private static Pattern dropTablePattern = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);
    private static Pattern dropViewPattern = Pattern.compile("\\bDROP\\s+VIEW\\b", 8);

    public SysDataSourceDto createSchema(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException, SQLException {
        ArrayList sqls = Lists.newArrayList((Object[])new String[]{"CREATE DATABASE IF NOT EXISTS " + sysDataSourceDto.getDbName() + " DEFAULT CHARACTER SET = utf8mb4 DEFAULT COLLATE = utf8mb4_general_ci", "CREATE USER IF NOT EXISTS " + sysDataSourceDto.getDbName() + " IDENTIFIED BY '" + sysDataSourceDto.getPassword() + "'", "GRANT ALL PRIVILEGES ON " + sysDataSourceDto.getDbName() + ".* TO " + sysDataSourceDto.getDbName() + ""});
        this.executeMoreSql(sqls);
        return sysDataSourceDto;
    }

    public Resource[] getInitExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/init/mysql/*.sql");
        return resources;
    }

    public Resource[] getUpgradeExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/upgrade/mysql/*.sql");
        return resources;
    }

    public void setParametersByMaster(SysDataSourceDto sysDataSourceDto) {
        String str = sysDataSourceDto.getJdbcUrl().substring(sysDataSourceDto.getJdbcUrl().indexOf("/") + 2, sysDataSourceDto.getJdbcUrl().indexOf("?"));
        String replaceStr = str.substring(0, str.indexOf("/") + 1) + sysDataSourceDto.getDbName();
        String newUrl = sysDataSourceDto.getJdbcUrl().replace(str, replaceStr);
        sysDataSourceDto.setJdbcUrl(newUrl);
        String username = sysDataSourceDto.getUserName();
        String obTenantCluster = username.substring(username.indexOf("@"));
        sysDataSourceDto.setUserName(sysDataSourceDto.getDbName() + obTenantCluster);
    }

    public List<String> preTreatment(Connection connection, Resource resource, boolean drop) throws IOException, ScriptException {
        InputStream inputStream = resource.getInputStream();
        List statements = HussarTenantScriptUtils.getSplitSqlScript((InputStream)inputStream);
        if (drop) {
            return statements;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String statement : statements) {
            String temp;
            if (!StringUtils.isNotBlank((CharSequence)statement) || dropTablePattern.matcher(temp = statement.trim().toUpperCase()).find() || dropViewPattern.matcher(temp).find()) continue;
            result.add(statement);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        DatabaseFactory.add((String)DbType.OCEAN_BASE.getDb(), (IHussarBaseDatabaseOperateService)this);
    }
}

