/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dto.DbTestConnectionDto;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.datasource.service.impl.hussarBaseSQLExecutorImpl")
public class HussarBaseSQLExecutorImpl
implements IHussarBaseSQLExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseSQLExecutorImpl.class);
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private DatasourceService datasourceService;

    private void logError(Exception e) {
        LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
    }

    public void execTenantSqlFile(String connName, String dbType, Resource[] scripts) throws BaseException, IOException, SQLException, InterruptedException, UncategorizedScriptException {
        this.execTenantSqlFile(connName, dbType, scripts, false);
    }

    private Connection getConnectionByConnName(String connName) throws SQLException {
        Connection connection = null;
        ItemDataSource currentDatasource = this.dynamicDataSourceService.getDatasourceByPoolName(connName);
        if (!connName.equals(currentDatasource.getName())) {
            throw new BaseException("\u5f53\u524d\u6570\u636e\u6e90\u4e0e\u8981\u5347\u7ea7\u7684\u79df\u6237\u6570\u636e\u6e90\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u4fe1\u606f");
        }
        if (currentDatasource.getUrl() != null && currentDatasource.getUsername() != null && currentDatasource.getPassword() != null) {
            if (currentDatasource.getUrl().startsWith("jdbc:oscar")) {
                try {
                    Class.forName("com.oscar.Driver");
                }
                catch (ClassNotFoundException var5) {
                    var5.printStackTrace();
                }
            }
            connection = DriverManager.getConnection(currentDatasource.getUrl(), currentDatasource.getUsername(), currentDatasource.getPassword());
        }
        return connection;
    }

    public void execTenantSqlFile(String connName, String dbType, Resource[] scripts, boolean drop) throws BaseException, IOException, SQLException, InterruptedException, UncategorizedScriptException {
        if (ToolUtil.isEmpty((Object)connName)) {
            throw new BaseException("\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90");
        }
        Connection connection = null;
        try {
            connection = this.getConnectionByConnName(connName);
            if (HussarUtils.isNotEmpty((Object[])scripts)) {
                for (Resource script : scripts) {
                    InputStream inputStream = script.getInputStream();
                    if (inputStream.available() <= 0 && inputStream.read() == -1) {
                        throw new BaseException("\u521d\u59cb\u5316\u811a\u672c\u5185\u5bb9\u4e3a\u7a7a");
                    }
                    Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
                    HussarTenantScriptUtils.executeSqlScript((Connection)connection, (String)dbType, (Resource)script, (boolean)drop, (Executor)asyncExecutor);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new BaseException("\u65e0\u6cd5\u83b7\u53d6\u94fe\u63a5\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    public void execTenantSqlFile(String connName, String dbType, Resource script, boolean drop) throws BaseException, IOException, SQLException, InterruptedException, UncategorizedScriptException {
        Resource[] scripts = new Resource[]{script};
        this.execTenantSqlFile(connName, dbType, scripts, drop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExist(String connName, String tablename) {
        ItemDataSource datasourceByPoolName = this.dynamicDataSourceService.getDatasourceByPoolName(connName);
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            DatabaseMetaData meta;
            if (HussarUtils.isNotEmpty((Object)datasourceByPoolName) && (resultSet = (meta = (connection = datasourceByPoolName.getConnection()).getMetaData()).getTables(connection.getCatalog(), null, tablename.toUpperCase(), null)).next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            this.logError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
        }
        return false;
    }

    public boolean checkDbConnection(DbTestConnectionDto dbTestConnectionDto) {
        if (null == dbTestConnectionDto) {
            return false;
        }
        SysDataSourceDto sysDataSourceDto = (SysDataSourceDto)BeanUtil.copy((Object)dbTestConnectionDto, SysDataSourceDto.class);
        if (null != sysDataSourceDto) {
            sysDataSourceDto.setThrowWhenConnNameExist(false);
            sysDataSourceDto.setIsUpdate("0");
            sysDataSourceDto.setConnName("password");
            sysDataSourceDto.setCurrentSchema(dbTestConnectionDto.getPattern());
        }
        return this.datasourceService.saveDataSourceWithCheck(sysDataSourceDto, true).isSuccess();
    }
}

