/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.controller;

import com.jxdinfo.hussar.datasource.dto.SysDataSourceFeignDto;
import com.jxdinfo.hussar.datasource.feign.RemoteSysDataSourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@HussarDs
@Api(tags={"Feign\u6570\u636e\u6e90\u7ba1\u7406"})
public class RemoteSysDataSourceController
implements RemoteSysDataSourceService {
    @Resource
    SysDataSourceService sysDataSourceService;

    @ApiOperation(value="\u901a\u8fc7\u79df\u6237\u7f16\u7801\u83b7\u53d6\u6570\u636e\u6e90", notes="\u901a\u8fc7\u79df\u6237\u7f16\u7801\u83b7\u53d6\u6570\u636e\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantCode", value="\u79df\u6237\u7f16\u7801", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u901a\u8fc7\u79df\u6237\u7f16\u7801\u83b7\u53d6\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public SysDataSource getByTenantCode(String tenantCode) {
        return this.sysDataSourceService.getByTenantCode(tenantCode);
    }

    @ApiOperation(value="\u6570\u636e\u6e90\u8be6\u60c5", notes="\u6570\u636e\u6e90\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dbId", value="\u6570\u636e\u6e90id", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u6570\u636e\u6e90\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> getDatasourceById(String dbId) {
        return this.sysDataSourceService.getDatasourceById(dbId);
    }

    @ApiOperation(value="\u901a\u8fc7\u8fde\u63a5\u540d\u67e5\u8be2\u6570\u636e\u6e90", notes="\u901a\u8fc7\u8fde\u63a5\u540d\u67e5\u8be2\u6570\u636e\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="connName", value="\u8fde\u63a5\u540d\u79f0", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u901a\u8fc7\u8fde\u63a5\u540d\u67e5\u8be2\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public SysDataSource getByConnName(String connName) {
        return this.sysDataSourceService.getByConnName(connName);
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6e90\uff08\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", notes="\u65b0\u589e\u6570\u636e\u6e90\uff08\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysDataSource", value="\u6570\u636e\u6e90", required=true, paramType="query"), @ApiImplicitParam(name="isCheck", value="isCheck", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u6570\u636e\u6e90\uff08\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> saveDataSourceWithCheck(@RequestBody SysDataSourceFeignDto sysDataSourceFeignDto) {
        return this.sysDataSourceService.saveDataSourceWithCheck(sysDataSourceFeignDto.getSysDataSourceDto(), sysDataSourceFeignDto.getCheck().booleanValue());
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", notes="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> deleteDataSource(List<Long> ids) {
        return this.sysDataSourceService.deleteDataSourceByLongIds(ids);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5b9e\u4f53\u7c7b", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> updateDatasource(@RequestBody SysDataSource sysDataSource) {
        return this.sysDataSourceService.updateDatasource(sysDataSource);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u6e90\u5217\u8868")
    @AuditLog(moduleName="Feign\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<SysDataSource> list() {
        return this.sysDataSourceService.list();
    }
}

