/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDatabaseOperateService
implements IHussarBaseDatabaseOperateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDatabaseOperateService.class);
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="master")
    public void executeMoreSql(List<String> sqls) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dynamicDataSourceService.getDatasourceByPoolName("master").getConnection();
            statement = connection.createStatement();
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
        }
    }

    private void logError(SQLException e) {
        LOGGER.error("errorMessage:{}", (Object)e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="master")
    public void execute(String createSql) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dynamicDataSourceService.getCurrentDatasource().getConnection();
            statement = connection.createStatement();
            statement.executeUpdate(createSql);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryConnection(SysDataSourceDto sysDataSourceDto) {
        boolean flag = false;
        if (!(HussarUtils.isEmpty((Object)sysDataSourceDto) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName()))) {
            Connection conn = null;
            try {
                conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
                flag = true;
            }
            catch (SQLException var13) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException var12) {
                    LOGGER.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)var12);
                }
            }
        }
        return flag;
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException var5) {
                var5.printStackTrace();
            }
        }
        return DriverManager.getConnection(url, username, password);
    }
}

