/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.local.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.dto.TenantPermissonDto;
import com.jxdinfo.hussar.datasource.local.dao.LocalSysDataSourceMapper;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service
@HussarTransactional
public class LocalDataSourceServiceImpl
extends HussarServiceImpl<LocalSysDataSourceMapper, SysDataSource>
implements SysDataSourceService {
    @Resource
    private DataSource dataSource;
    private static final Long MASTER_DS = 1450384273189240833L;

    public List<SysDataSource> list() {
        ArrayList<SysDataSource> dataSourceList = new ArrayList<SysDataSource>();
        SysDataSource sysDataSource = this.getMasterDataSource();
        dataSourceList.add(sysDataSource);
        return dataSourceList;
    }

    public SysDataSource getMasterDataSource() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dsDataSource = ds.getDataSource("master");
        SysDataSource sysDataSource = new SysDataSource();
        if (dsDataSource instanceof AbstractHussarDataSource) {
            AbstractHussarDataSource itemDataSource = (AbstractHussarDataSource)dsDataSource;
            sysDataSource.setId(MASTER_DS);
            sysDataSource.setConnName(itemDataSource.getPoolName());
            sysDataSource.setDbName(itemDataSource.getPoolName());
            sysDataSource.setJdbcUrl(itemDataSource.getUrl());
            sysDataSource.setUserName(itemDataSource.getUsername());
            sysDataSource.setPassword(itemDataSource.getPassword());
            sysDataSource.setDriverClass(itemDataSource.getDriverClassName());
            sysDataSource.setInstantName(this.getMasterInstantName(sysDataSource));
            sysDataSource.setRemark("\u9ed8\u8ba4\u6570\u636e\u8fde\u63a5");
            sysDataSource.setDelFlag("0");
        }
        return sysDataSource;
    }

    private String getMasterInstantName(SysDataSource dataSource) {
        String instantName = null;
        String jdbcUrl = dataSource.getJdbcUrl();
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            instantName = this.getMysqlInstantName(jdbcUrl);
        } else if (jdbcUrl.startsWith("jdbc:oracle")) {
            instantName = dataSource.getUserName();
        }
        return instantName;
    }

    private String getMysqlInstantName(String jdbcUrl) {
        String str = jdbcUrl.substring(jdbcUrl.indexOf("/") + 2, jdbcUrl.indexOf("?"));
        return str.substring(str.indexOf("/") + 1);
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId) {
        return ApiResponse.success((Object)this.getMasterDataSource());
    }

    public IPage<SysDataSource> listDataSource(Page<SysDataSource> page, SysDataSource sysDataSource) {
        return null;
    }

    public IPage<SysDataSource> getListUncorrelated(Page<SysDataSource> page) {
        return null;
    }

    public ApiResponse<SysDataSource> saveDatasource(SysDataSourceDto sysDataSource) {
        return null;
    }

    public ApiResponse<SysDataSource> saveDataSourceWithCheck(SysDataSourceDto sysDataSource, boolean isCheck) {
        return null;
    }

    public Boolean checkTableExist(SysDataSource sysDataSource) {
        return false;
    }

    public ApiResponse<SysDataSource> updateDatasource(SysDataSource sysDataSource) {
        return null;
    }

    public ApiResponse<SysDataSource> deleteDataSourceByLongIds(List<Long> ids) {
        return null;
    }

    public ApiResponse<SysDataSource> deleteDataSource(List<String> ids) {
        return null;
    }

    public ApiResponse<SysDataSource> checkDbName(String dbName) {
        return null;
    }

    public SysDataSource getByTenantCode(String tenantCode) {
        return this.getMasterDataSource();
    }

    public SysDataSource getByTenantCodeAndPwd(String tenantCode) {
        return null;
    }

    public ApiResponse<?> isMysql(String username, String password, String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isOscar(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isOracle(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isDm(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isPostgresql(String username, String password, String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse execSqlFile(String dbId, String isBpmType, String tenantId) {
        return null;
    }

    public ApiResponse<Boolean> checkConnName(String connName) {
        return null;
    }

    public SysDataSource getByConnName(String connName) {
        return this.getMasterDataSource();
    }

    public void addDataSourceByConnName(String connName) {
    }

    public ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        return null;
    }

    public String getIP() {
        return null;
    }

    public ApiResponse<TenantPermissonDto> getTenantPermission() {
        return null;
    }

    public List<SysDataSource> getAllTenantDataSource() {
        return Collections.emptyList();
    }

    public List<SysDataSource> getAllDataSource() {
        return Collections.emptyList();
    }

    public List<SysDataSource> list(Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            ArrayList<SysDataSource> list = new ArrayList<SysDataSource>();
            list.add(this.getMasterDataSource());
            return list;
        }
        return super.list();
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return ApiResponse.success((Object)this.getMasterDataSource());
        }
        return this.getDatasourceById(dbId);
    }

    public SysDataSource getByTenantCode(String tenantCode, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByTenantCode(tenantCode);
    }

    public SysDataSource getByConnName(String connName, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByConnName(connName);
    }

    public Page<SysDataSource> getList(Page<SysDataSource> page, QueryWrapper<SysDataSource> queryWrapper) {
        return null;
    }
}

