/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HussarTenantScriptUtils {
    private static Pattern createTablePattern = Pattern.compile("\\bCREATE\\s+TABLE\\b", 8);
    private static Pattern createViewPattern = Pattern.compile("\\bCREATE\\s(.*)VIEW\\b", 8);
    private static Pattern dropViewPattern = Pattern.compile("\\bDROP\\s+VIEW\\b", 8);
    private static Pattern declarePattern = Pattern.compile("\\bDECLARE\\s+@SCHEMA\\b", 8);
    private static Pattern commentPattern = Pattern.compile("\\bCOMMENT\\s+ON\\b", 8);
    private static Pattern alterTablePattern = Pattern.compile("\\bALTER\\s+TABLE\\b", 8);
    private static Pattern indexPattern = Pattern.compile("\\bCREATE\\s(.*)INDEX\\b", 32);
    private static Pattern sequencePattern = Pattern.compile("\\bCREATE\\s(.*)SEQUENCE\\b", 8);
    private static Pattern setNamesPattern = Pattern.compile("^SET\\s(.*)NAMES\\b", 8);
    private static Pattern set0Pattern = Pattern.compile("^SET\\s(.*)FOREIGN_KEY_CHECKS(.*)0\\b", 8);
    private static Pattern set1Pattern = Pattern.compile("^SET\\s(.*)FOREIGN_KEY_CHECKS(.*)1\\b", 8);
    private static Pattern dropTablePattern = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);
    private static List<String> shareTables = Lists.newArrayList((Object[])new String[]{"SYS_DATASOURCE", "SYS_DATASOURCE_CONFIG", "UNDO_LOG"});
    private static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    private static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    private static final int DEFAULT_BATSIZE = 1000;
    private static final String EOF_STATEMENT_SEPARATOR = "^^^ END OF SCRIPT ^^^";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    private static final String[] DEFAULT_COMMENT_PREFIXES = new String[]{"--"};
    private static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    private static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";
    private static final Logger logger = LoggerFactory.getLogger(HussarTenantScriptUtils.class);

    private HussarTenantScriptUtils() {
    }

    public static void splitSqlScript(String script, char separator, List<String> statements) throws ScriptException {
        HussarTenantScriptUtils.splitSqlScript(script, String.valueOf(separator), statements);
    }

    public static void splitSqlScript(String script, String separator, List<String> statements) throws ScriptException {
        HussarTenantScriptUtils.splitSqlScript(null, script, separator, DEFAULT_COMMENT_PREFIX, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER, statements);
    }

    public static void splitSqlScript(@Nullable EncodedResource resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Assert.hasText((String)commentPrefix, (String)"'commentPrefix' must not be null or empty");
        ScriptUtils.splitSqlScript((EncodedResource)resource, (String)script, (String)separator, (String[])new String[]{commentPrefix}, (String)blockCommentStartDelimiter, (String)blockCommentEndDelimiter, statements);
    }

    static String readScript(EncodedResource resource) throws IOException {
        return HussarTenantScriptUtils.readScript(resource, DEFAULT_COMMENT_PREFIXES, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    private static String readScript(EncodedResource resource, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(resource.getReader());){
            String string = HussarTenantScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
            return string;
        }
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String lineCommentPrefix, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String[] stringArray;
        if (lineCommentPrefix != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lineCommentPrefix;
        } else {
            stringArray = null;
        }
        String[] lineCommentPrefixes = stringArray;
        return HussarTenantScriptUtils.readScript(lineNumberReader, lineCommentPrefixes, separator, blockCommentEndDelimiter);
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String[] lineCommentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || lineCommentPrefixes != null && !HussarTenantScriptUtils.startsWithAny(currentStatement, lineCommentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        HussarTenantScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, @Nullable String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void executeSqlScript(Connection connection, String dbType, Resource resource, boolean drop, Executor executor) throws InterruptedException, UncategorizedScriptException {
        HussarTenantScriptUtils.executeSqlScript(connection, dbType, resource, drop, executor, 1000);
    }

    public static void executeSqlScript(Connection connection, String dbType, Resource resource, boolean drop, Executor executor, int batSize) throws InterruptedException, UncategorizedScriptException {
        HussarTenantScriptUtils.executeSqlScript(connection, dbType, new EncodedResource(resource), drop, executor, batSize);
    }

    public static void executeSqlScript(Connection connection, String dbType, EncodedResource resource, boolean drop, Executor executor, int batSize) throws InterruptedException, UncategorizedScriptException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing SQL script from {}", (Object)resource);
            }
            long startTime = System.currentTimeMillis();
            List<String> statements = DatabaseFactory.get(dbType).preTreatment(connection, resource.getResource(), drop);
            int stmtNumber = 0;
            ArrayList<List<String>> parallelSqlList = new ArrayList<List<String>>();
            ArrayList<String> otherSqlList = new ArrayList<String>();
            ArrayList<String> viewSqlList = new ArrayList<String>();
            parallelSqlList.add(otherSqlList);
            ArrayList<String> tableSqlList = new ArrayList<String>();
            for (String statement : statements) {
                String temp = statement.toUpperCase().trim();
                boolean matchCreate = HussarTenantScriptUtils.filterCreateTableSql(connection, dbType, statement, tableSqlList);
                boolean isView = HussarTenantScriptUtils.filterViewSql(viewSqlList, statement, temp, matchCreate);
                boolean other = !matchCreate && !isView;
                if (!other) continue;
                if (++stmtNumber % batSize == 0) {
                    otherSqlList = new ArrayList();
                    parallelSqlList.add(otherSqlList);
                    otherSqlList.add(statement);
                    continue;
                }
                otherSqlList.add(statement);
            }
            HussarTenantScriptUtils.executeCreateTableSql(connection, tableSqlList);
            connection.setAutoCommit(false);
            HussarTenantScriptUtils.processParallelSql(connection, executor, parallelSqlList);
            HussarTenantScriptUtils.processViewSql(connection, viewSqlList, dbType);
            connection.commit();
            connection.setAutoCommit(true);
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.info("Executed SQL script from {} in {} ms.", (Object)resource, (Object)elapsedTime);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + resource + "]", ex.getCause());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqlex) {
                    logger.error("\u4e0d\u80fd\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5: {}", (Object)sqlex.toString());
                }
            }
        }
    }

    private static boolean filterViewSql(List<String> viewSqlList, String statement, String temp, boolean matchCreate) {
        boolean isView;
        boolean bl = isView = !matchCreate && (dropViewPattern.matcher(temp).find() || createViewPattern.matcher(temp).find() || set1Pattern.matcher(temp).find());
        if (isView) {
            viewSqlList.add(statement);
        }
        return isView;
    }

    private static boolean filterCreateTableSql(Connection connection, String dbType, String statement, List<String> tableSqlList) throws SQLException {
        boolean matchCreate;
        String temp = statement.toUpperCase().trim();
        boolean bl = matchCreate = setNamesPattern.matcher(temp).find() || set0Pattern.matcher(temp).find() || dropTablePattern.matcher(temp).find() || createTablePattern.matcher(temp).find() || declarePattern.matcher(temp).find() || commentPattern.matcher(temp).find() || alterTablePattern.matcher(temp).find() || indexPattern.matcher(temp).find() || sequencePattern.matcher(temp).find();
        if (matchCreate && HussarTenantScriptUtils.canAddStatement(dbType, connection, temp)) {
            tableSqlList.add(statement);
        }
        return matchCreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canAddStatement(String dbType, Connection connection, String statement) throws SQLException {
        for (String table : shareTables) {
            if (!statement.contains(table)) continue;
            String sql = "";
            sql = dbType.equals(DbType.POSTGRE_SQL.getDb()) || dbType.equals("gauss") || dbType.equals(DbType.HIGH_GO.getDb()) ? "SELECT * FROM " + table.toLowerCase() + " WHERE 1<0 " : "SELECT * FROM " + table.toUpperCase() + " WHERE 1<0 ";
            try (Statement statementTemp = null;){
                statementTemp = connection.createStatement();
                statementTemp.execute(sql);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private static void processViewSql(Connection connection, List<String> viewSqlList, String dbType) {
        if (viewSqlList.size() > 0) {
            try (Statement stmtView = connection.createStatement();){
                if ("sqlserver".equals(dbType)) {
                    for (String sql : viewSqlList) {
                        stmtView.executeUpdate(sql);
                    }
                } else {
                    for (String sql : viewSqlList) {
                        stmtView.addBatch(sql);
                    }
                    stmtView.executeBatch();
                }
                connection.commit();
                stmtView.closeOnCompletion();
            }
            catch (SQLException e) {
                throw new BaseException("\u6267\u884c\u89c6\u56fesql\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    private static void processParallelSql(Connection connection, Executor executor, List<List<String>> parallelSqlList) throws InterruptedException, ExecutionException {
        if (parallelSqlList.size() > 0) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (List<String> group : parallelSqlList) {
                CompletableFuture<Void> voidCompletableFuture = CompletableFuture.runAsync(() -> {
                    try (Statement stmtOther = connection.createStatement();){
                        for (String sql : group) {
                            stmtOther.addBatch(sql);
                        }
                        stmtOther.executeBatch();
                        connection.commit();
                        stmtOther.closeOnCompletion();
                    }
                    catch (SQLException e) {
                        throw new BaseException("\u6267\u884c\u5e76\u884csql\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }, executor);
                futures.add(voidCompletableFuture);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }
    }

    private static void executeCreateTableSql(Connection connection, List<String> tableSqlList) {
        if (tableSqlList.size() > 0) {
            try {
                HussarTenantScriptUtils.executeSqlScript(connection, tableSqlList);
            }
            catch (Exception e) {
                throw new BaseException("\u6267\u884c\u521b\u5efa\u8868\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static String readScript(InputStream resource) throws IOException {
        return HussarTenantScriptUtils.readScript(resource, DEFAULT_COMMENT_PREFIXES, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    private static String readScript(InputStream resource, String[] commentPrefixes, String separator, String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader(resource, "UTF-8"));){
            String string = HussarTenantScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
            return string;
        }
    }

    public static List<String> getSplitSqlScript(InputStream resource) throws IOException, ScriptException {
        String script = HussarTenantScriptUtils.readScript(resource);
        ArrayList<String> statements = new ArrayList<String>();
        String[] commentPrefixes = DEFAULT_COMMENT_PREFIXES;
        String separator = DEFAULT_STATEMENT_SEPARATOR;
        String blockCommentEndDelimiter = DEFAULT_BLOCK_COMMENT_END_DELIMITER;
        if (!EOF_STATEMENT_SEPARATOR.equals(separator) && !HussarTenantScriptUtils.containsSqlScriptDelimiters(script, separator)) {
            separator = FALLBACK_STATEMENT_SEPARATOR;
        }
        if (!EOF_STATEMENT_SEPARATOR.equals(separator) && !HussarTenantScriptUtils.containsSqlScriptDelimiters(script, separator)) {
            separator = FALLBACK_STATEMENT_SEPARATOR;
        }
        ScriptUtils.splitSqlScript((EncodedResource)new EncodedResource((Resource)new InputStreamResource(resource)), (String)script, (String)separator, (String[])commentPrefixes, (String)blockCommentEndDelimiter, (String)blockCommentEndDelimiter, statements);
        return statements;
    }

    public static void executeSqlScript(Connection connection, List<String> statements) throws SQLException {
        int stmtNumber = 0;
        try (Statement stmt = connection.createStatement();){
            for (String statement : statements) {
                ++stmtNumber;
                try {
                    stmt.execute(statement);
                    stmt.getUpdateCount();
                }
                catch (Exception ex) {
                    logger.error("\u5f02\u5e38 SQL:\u3010 {}}\u3011\u5f02\u5e38\u539f\u56e0\uff1a{}\n", (Object)statement, (Object)ExceptionUtil.getExceptionAllinformation((Throwable)ex));
                }
            }
        }
    }
}

