/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.dataset.cnst.FileConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FileUtil
extends FileConstant {
    private static final boolean IS_WINDOWS = "\\".equals(File.separator);

    private FileUtil() {
    }

    public static String posixPath(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    public static String posixPathByOldWay(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        StringBuilder sb = new StringBuilder();
        for (String segment : segments) {
            String[] parts;
            if (segment == null || segment.isEmpty()) continue;
            for (String part : parts = segment.split("[/\\\\]", -1)) {
                if (part.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(part);
            }
        }
        String path = sb.toString();
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    public static String systemPath(String ... segments) {
        boolean leadingSlash;
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingUnc = IS_WINDOWS && segments[0].startsWith("\\\\");
        boolean bl = leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        String prefix = leadingUnc ? "\\\\" : (leadingSlash ? File.separator : "");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String suffix = trailingSlash ? File.separator : "";
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining(File.separator));
        return path.isEmpty() && !prefix.isEmpty() && !suffix.isEmpty() ? prefix : prefix + path + suffix;
    }

    public static String systemPathByOldWay(String ... segments) {
        boolean leadingSlash;
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingUnc = IS_WINDOWS && segments[0].startsWith("\\\\");
        boolean bl = leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        String prefix = leadingUnc ? "\\\\" : (leadingSlash ? File.separator : "");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String suffix = trailingSlash ? File.separator : "";
        StringBuilder sb = new StringBuilder();
        for (String segment : segments) {
            String[] parts;
            if (segment == null || segment.isEmpty()) continue;
            for (String part : parts = segment.split("[/\\\\]", -1)) {
                if (part.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(File.separator);
                }
                sb.append(part);
            }
        }
        String path = sb.toString();
        if (path.isEmpty() && !prefix.isEmpty() && !suffix.isEmpty()) {
            return prefix;
        }
        return prefix + path + suffix;
    }

    public static String packagePath(String ... segments) {
        return (segments = FileUtil.preprocessPathSegments(segments)).length == 0 ? "" : Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[./\\\\]", -1))).filter(segment -> !segment.isEmpty()).map(String::toLowerCase).collect(Collectors.joining("."));
    }

    private static String[] preprocessPathSegments(String[] segments) {
        if (segments == null) {
            return new String[0];
        }
        ArrayList<String> filteredSegments = new ArrayList<String>();
        for (String segment : segments) {
            if (segment == null || segment.isEmpty()) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments.toArray(new String[0]);
    }

    public static String removePathPrefix(String prefix, String path) {
        try {
            if (ToolUtil.isEmpty((Object)path)) {
                return path;
            }
            prefix = FileUtil.systemPathByOldWay(prefix);
            String relative = FileUtil.getRelativePath(path = FileUtil.systemPathByOldWay(path), prefix, File.separator);
            if (relative.startsWith(".." + File.separator)) {
                throw new IllegalArgumentException("not prefix: '" + prefix + "' to '" + path + "'");
            }
            return StringUtils.removeStart((String)relative, (String)("." + File.separator));
        }
        catch (Exception e) {
            System.err.println("removePathPrefix: prefix=" + prefix + ", path = " + path);
            e.printStackTrace();
            throw e;
        }
    }

    public static String removePathPrefixAndConvertPosix(String prefix, String path) {
        return ToolUtil.isEmpty((Object)path) ? path : FileUtil.posixPath(FileUtil.removePathPrefix(prefix, path));
    }

    public static String getRelativeModule(String targetPath, String basePath, String pathSeparator) {
        String relativePath = FileUtil.getRelativePath(targetPath, basePath, pathSeparator);
        return relativePath.lastIndexOf("/") == -1 ? relativePath : relativePath.substring(0, relativePath.lastIndexOf("/"));
    }

    private static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else {
            if (!pathSeparator.equals("\\")) {
                throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
            }
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex]).append(pathSeparator);
        }
        if (commonIndex == 0) {
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append("..").append(pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    public static String addSuffix(String str) {
        if (ToolUtil.isNotEmpty((Object)str)) {
            String suffix = str.substring(str.length() - 1);
            return !suffix.equals("/") && !suffix.equals("\\") ? str + File.separator : str;
        }
        return "";
    }

    public static String removePrefix(String prefix, String path) {
        prefix = FilenameUtils.normalize((String)prefix);
        path = FilenameUtils.normalize((String)path);
        if (ToolUtil.isNotEmpty((Object)prefix) && prefix.equals(path.substring(0, prefix.length()))) {
            path = path.substring(prefix.length());
        }
        return path;
    }

    public static String complementFilePath(String path) {
        boolean isModulePathEndWithSeparator = path.endsWith(File.separator);
        if (!isModulePathEndWithSeparator) {
            path = path + File.separator;
        }
        return path;
    }

    public static String modularizationPath(String path, String prefix) {
        String[] str;
        for (String s : str = path.split(",")) {
            String[] configPath = s.split(":");
            if (ToolUtil.isEmpty((Object)configPath) || configPath.length <= 1 || !HussarUtils.equals((Object)configPath[0], (Object)prefix)) continue;
            return configPath[1];
        }
        return "";
    }

    public static String readFileToString(String filePath) {
        try {
            return !new File(filePath).exists() ? null : FileUtil.readFileToString(new File(filePath), "UTF-8");
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static String readFileToString(File file, String charsetName) throws IOException {
        return FileUtil.readFileToString(file, Charsets.toCharset((String)charsetName));
    }

    public static String readFileToString(File file, Charset charsetName) throws IOException {
        return IOUtils.toString(() -> Files.newInputStream(file.toPath(), new OpenOption[0]), (Charset)Charsets.toCharset((Charset)charsetName));
    }
}

