/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.factory.DbDataTypeStrategyFactory;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.SqlField1;
import com.jxdinfo.hussar.dataset.service.IDataTypeStrategy;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class DataSetParamUtil {
    public static SqlConfigSchema1 packageDataSetParam(DsTableInfo tableInfo, Long dataSourceId, String dataSourceName) {
        SqlConfigSchema1 dataSetParam = new SqlConfigSchema1();
        String sql = String.format("select * from %s", tableInfo.getName());
        dataSetParam.setSql(sql);
        dataSetParam.setProjection(DataSetParamUtil.getProjection(dataSourceId, tableInfo.getName(), dataSourceName));
        return dataSetParam;
    }

    public static List<SqlField1> getProjection(Long datasourceId, String tableName, String dataSourceName) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableName), (Integer)DataSetErrorCodeEnum.DATASET_TABLENAME_ISNULL.getCode(), (String)DataSetErrorCodeEnum.DATASET_TABLENAME_ISNULL.getMessage());
        List<DsTableField> fields = DataSetParamUtil.getFields(datasourceId, tableName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty(fields), (Integer)DataSetErrorCodeEnum.DATASET_FIELD_NOT_EXISTS.getCode(), (String)String.format("\u8868\u3010%s\u3011\u4e2d\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728!", tableName));
        try {
            return fields.stream().map(field -> {
                SqlField1 sqlField = (SqlField1)HussarUtils.copyProperties((Object)field, SqlField1.class);
                sqlField.setField(field.getName());
                sqlField.setTable(field.getTableName());
                sqlField.setComment(field.getComment());
                sqlField.setFieldAlias(field.getName());
                String jdbcType = field.getType().toUpperCase();
                sqlField.setType(jdbcType);
                IDataTypeStrategy IDataTypeStrategy2 = DbDataTypeStrategyFactory.getStrategy(dataSourceName);
                sqlField.setDataType(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
                sqlField.setDataTypeConversion(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
                sqlField.setRename(HussarUtils.isNotEmpty((Object)field.getComment()) ? field.getComment() : field.getName());
                return sqlField;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_FIELD_TOSHOW_EXCEPTION.getCode()), String.format("DB\u6570\u636e\u96c6\u6570\u636e\u8868\u3010%s\u3011\u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38\uff01", tableName), (Throwable)e);
        }
    }

    public static List<DsTableField> getFields(Long datasourceId, String tableName) {
        try {
            DatasourceDataService datasourceDataService = (DatasourceDataService)SpringContextHolder.getBean(DatasourceDataService.class);
            List fields = datasourceDataService.getTableFieldByTableName(datasourceId, tableName.toUpperCase());
            return fields;
        }
        catch (DataSourceException e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_DATASOURCE_NOT_EXISTS.getCode()), DataSetErrorCodeEnum.DATASET_DATASOURCE_NOT_EXISTS.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_IO_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_IO_EXCEPTION.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_FIELD_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_FIELD_EXCEPTION.getMessage(), (Throwable)e);
        }
    }
}

