/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.strategy.dataset;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetOperationDto;
import com.jxdinfo.hussar.dataset.dto.HttpDataDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.enums.ParamTypeEnum;
import com.jxdinfo.hussar.dataset.model.ApiDataStructure;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.service.IDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.DataSetCommonProcessor;
import com.jxdinfo.hussar.dataset.util.DataSetParamUtil;
import com.jxdinfo.hussar.dataset.util.HttpUrlRegexUtil;
import com.jxdinfo.hussar.dataset.util.JsonSchemaUtil;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiConnectorService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.ConnectorTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.ParamScope;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiClassifyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiStatusEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.dataset.strategy.ApiDataSetProcessor")
public class ApiDataSetProcessor
extends DataSetCommonProcessor
implements IDataSetProcessor {
    private static final Logger log = LoggerFactory.getLogger(ApiDataSetProcessor.class);
    @Value(value="${data-set.api-url:http://127.0.0.1:9502/hussarApi}")
    private String apiUrl;

    public Long save(DataSetInfoDto dataSetInfoDto) {
        DataSetInfoDto newDataSetInfoDto = super.copyNewDataSetInfoDto(dataSetInfoDto);
        DataSetConfigInfoDto dataSetConfigInfoDto = super.getDataSetConfigInfoDto(newDataSetInfoDto);
        this.processInterface(dataSetConfigInfoDto);
        newDataSetInfoDto.setData(JsonUtil.toJson((Object)dataSetConfigInfoDto));
        return this.insertDbSetToDb(newDataSetInfoDto);
    }

    @Override
    public SqlDataSetVo preivewDataBySql(SqlDataSetDto sqlDataSetDto) {
        return super.preivewDataBySql(sqlDataSetDto);
    }

    @Override
    public void editModel(DataSetInfoDto dataSetInfoDto) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)dataSetInfoDto.getData(), DataSetConfigInfoDto.class);
        Map<Object, Object> dataSets = new HashMap();
        if (HussarUtils.isNotEmpty((Object)dataSetConfigInfoDto.getDataSets())) {
            dataSets = dataSetConfigInfoDto.getDataSets().stream().collect(Collectors.toMap(ApiDataStructure::getId, dataSet -> dataSet));
        }
        HashMap finalDataSets = dataSets;
        dataSetConfigInfoDto.getOperations().stream().forEach(operation -> {
            RmiConnector rmiConnector = this.updateRmiConnector(operation.getRmiConnectorId(), (DataSetOperationDto)operation);
            RmiInterface rmiInterface = this.updateRmiInterface(operation.getRmiInterfaceId(), (DataSetOperationDto)operation, finalDataSets, rmiConnector.getConnectorCode());
            this.publishApi(rmiInterface, rmiConnector.getConnectorId());
        });
    }

    public void delete(DataSetInfoDto dataSetInfoDto) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)dataSetInfoDto.getData(), DataSetConfigInfoDto.class);
        if (HussarUtils.isEmpty((Object)dataSetConfigInfoDto)) {
            return;
        }
        List operationDtos = dataSetConfigInfoDto.getOperations();
        if (HussarUtils.isEmpty((Object)operationDtos)) {
            return;
        }
        operationDtos.stream().forEach(operation -> {
            String dataSetId = dataSetInfoDto.getDataSetId().toString();
            this.deleteNodeBusiness(dataSetId);
            this.deleteApiNaming(dataSetId);
            this.deleteRmiInterface(operation.getRmiInterfaceId());
            this.deleteRmiConnector(operation.getRmiConnectorId());
        });
    }

    private RmiConnector updateRmiConnector(String rmiConnectorId, DataSetOperationDto operation) {
        String dataSetId;
        LambdaQueryWrapper wrapper;
        RmiConnectorService rmiConnectorService = (RmiConnectorService)SpringContextHolder.getBean(RmiConnectorService.class);
        RmiConnector oldRmiConnector = (RmiConnector)rmiConnectorService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiConnector::getConnectorName, (Object)(dataSetId = operation.getDataSetId()))));
        if (HussarUtils.isNotEmpty((Object)oldRmiConnector)) {
            RmiConnector rmiConnector = this.initRmiConnector(operation);
            rmiConnector.setConnectorId(oldRmiConnector.getConnectorId());
            rmiConnector.setConnectorStatus(oldRmiConnector.getConnectorStatus());
            try {
                rmiConnectorService.updateById((Object)rmiConnector);
            }
            catch (Exception e) {
                throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_UPDATABLE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiConnectorUpdateAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_UPDATABLE_EXCEPTION.getMessage()), (Throwable)e);
            }
            return rmiConnector;
        }
        return this.processRmiConnector(operation);
    }

    private RmiInterface updateRmiInterface(String rmiInterfaceId, DataSetOperationDto operation, Map<String, ApiDataStructure> respDatas, String rmiConnectorCode) {
        String dataSetId;
        LambdaQueryWrapper wrapper;
        RmiInterfaceService rmiInterfaceService = (RmiInterfaceService)SpringContextHolder.getBean(RmiInterfaceService.class);
        RmiInterface oldRmiInterface = (RmiInterface)rmiInterfaceService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getConnectorCode, (Object)(dataSetId = operation.getDataSetId()))));
        if (HussarUtils.isNotEmpty((Object)oldRmiInterface)) {
            RmiInterface rmiInterface = this.initRmiInterface(operation, respDatas, rmiConnectorCode);
            rmiInterface.setRmiId(oldRmiInterface.getRmiId());
            rmiInterface.setRmiStatus(oldRmiInterface.getRmiStatus());
            try {
                rmiInterfaceService.updateById((Object)rmiInterface);
            }
            catch (Exception e) {
                throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_UPDATE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfaceUpdateAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_UPDATE_EXCEPTION.getMessage()), (Throwable)e);
            }
            return rmiInterface;
        }
        return this.saveRmiInterface(operation, respDatas, rmiConnectorCode);
    }

    private List<RmiInterface> processInterface(DataSetConfigInfoDto dataSetConfigInfoDto) {
        List operations = dataSetConfigInfoDto.getOperations();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)operations), (Integer)DataSetErrorCodeEnum.DATASET_API_INTERFACE_ISNULL.getCode(), (String)TranslateUtil.getTranslateName((String)"dataset.apiDatasetRequestConnInfoEmpty", (String)"API\u6570\u636e\u96c6\u8bf7\u6c42\u8fde\u63a5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Map<Object, Object> dataSets = new HashMap();
        if (HussarUtils.isNotEmpty((Object)dataSetConfigInfoDto.getDataSets())) {
            dataSets = dataSetConfigInfoDto.getDataSets().stream().collect(Collectors.toMap(ApiDataStructure::getId, dataSet -> dataSet));
        }
        HashMap finalDataSets = dataSets;
        return operations.stream().map(operation -> {
            operation.setDataSetId(dataSetConfigInfoDto.getDataSetId());
            RmiConnector rmiConnector = this.processRmiConnector((DataSetOperationDto)operation);
            operation.setRmiConnectorId(rmiConnector.getConnectorId().toString());
            RmiInterface rmiInterface = this.saveRmiInterface((DataSetOperationDto)operation, finalDataSets, rmiConnector.getConnectorCode());
            operation.setRmiInterfaceId(rmiInterface.getRmiId().toString());
            this.publishApi(rmiInterface, rmiConnector.getConnectorId());
            return rmiInterface;
        }).collect(Collectors.toList());
    }

    private RmiConnector processRmiConnector(DataSetOperationDto operation) {
        RmiConnector rmiConnector = this.initRmiConnector(operation);
        try {
            RmiConnectorService rmiConnectorService = (RmiConnectorService)SpringContextHolder.getBean(RmiConnectorService.class);
            rmiConnector.setConnectorStatus(RmiStatusEnum.IN_USE.getValue());
            rmiConnectorService.saveRmiConnector(rmiConnector);
            return rmiConnector;
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiConnectorSaveAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private RmiConnector initRmiConnector(DataSetOperationDto operation) {
        RmiConnector rmiConnector = new RmiConnector();
        rmiConnector.setConnectorType(ConnectorTypeEnum.API.getType());
        rmiConnector.setConnectorCode(operation.getDataSetId());
        HussarConfigApi hussarConfigApi = (HussarConfigApi)SpringContextHolder.getBean(HussarConfigApi.class);
        ConfigInfoEntity configInfoEntity = hussarConfigApi.getConfigInfo(operation.getHostPortConfigCode());
        String configValue = null;
        if (HussarUtils.isEmpty((Object)configInfoEntity)) {
            configValue = this.apiUrl;
            log.error("API\u6570\u636e\u96c6\u8bf7\u6c42\u8fde\u63a5HOST\u4fe1\u606f\u5728\u914d\u7f6e\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a{}", (Object)this.apiUrl);
        } else {
            configValue = configInfoEntity.getConfigValue();
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)configValue), (Integer)DataSetErrorCodeEnum.DATASET_API_HOST_ISNULL.getCode(), (String)TranslateUtil.getTranslateName((String)"dataset.apiDatasetRequestConnHostEmpty", (String)"API\u6570\u636e\u96c6\u8bf7\u6c42\u8fde\u63a5HOST\u4fe1\u606f\u4e3a\u7a7a\uff01"));
        HttpDataDto httpDataDto = HttpUrlRegexUtil.getHttpDataDto(configValue);
        rmiConnector.setProtocol(httpDataDto.getProtocol());
        rmiConnector.setHostUrl(String.format("%s:%s", httpDataDto.getIpAddress(), httpDataDto.getPort()));
        operation.setPrefixUrl(httpDataDto.getPath());
        rmiConnector.setConnectorName(rmiConnector.getConnectorCode());
        if (HussarUtils.isEmpty((Object)configInfoEntity)) {
            rmiConnector.setRemark(null);
        } else {
            rmiConnector.setRemark(configInfoEntity.getConfigDesc());
        }
        rmiConnector.setIsAuth("0");
        return rmiConnector;
    }

    private RmiInterface saveRmiInterface(DataSetOperationDto operation, Map<String, ApiDataStructure> respDatas, String rmiConnectorCode) {
        RmiInterface rmiInterface = this.initRmiInterface(operation, respDatas, rmiConnectorCode);
        try {
            RmiInterfaceService rmiInterfaceService = (RmiInterfaceService)SpringContextHolder.getBean(RmiInterfaceService.class);
            rmiInterface.setRmiStatus(RmiStatusEnum.IN_USE.getValue());
            rmiInterfaceService.save((Object)rmiInterface);
            return rmiInterface;
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_SAVE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfaceSaveAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_SAVE_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private RmiInterface initRmiInterface(DataSetOperationDto operation, Map<String, ApiDataStructure> respDatas, String rmiConnectorCode) {
        RmiInterface rmiInterface = new RmiInterface();
        rmiInterface.setConnectorCode(rmiConnectorCode);
        rmiInterface.setRmiName(operation.getName());
        rmiInterface.setRemark(operation.getComment());
        rmiInterface.setRmiUri(String.format("%s%s", operation.getPrefixUrl(), operation.getUrl()));
        rmiInterface.setRmiCode(operation.getDataSetId());
        rmiInterface.setRequestType(operation.getRequestMode().toLowerCase());
        String contentType = HussarUtils.isEmpty((Object)operation.getContentType()) || "none".equalsIgnoreCase(operation.getContentType()) ? HttpBodyEnum.JSON.getType() : operation.getContentType();
        rmiInterface.setContentType(contentType);
        rmiInterface.setRmiClassify(RmiClassifyEnum.NORMAL.getType());
        rmiInterface.setRmiMethod("invokeUrl");
        rmiInterface.setRmiClass("com.jxdinfo.hussar.support.engine.plugin.rmi.service.impl.rmiClientServiceImpl");
        rmiInterface.setIsAuth("0");
        rmiInterface.setHttpConfig(JSONObject.toJSONString(this.processHttpConfig(operation)));
        rmiInterface.setOutParams(JsonSchemaUtil.generateJsonSchema(operation.getReturnValue()));
        return rmiInterface;
    }

    private Map<String, Object> processHttpConfig(DataSetOperationDto operation) {
        HashMap<String, Object> httpConfig = new HashMap<String, Object>();
        try {
            Map<String, Object> headerMap = this.processHeader(operation.getHeaders());
            httpConfig.put(ParamScope.HEADER.getScope(), headerMap);
            Map<String, Object> queryMap = this.processQuery(operation.getQuery());
            httpConfig.put(ParamScope.QUERY.getScope(), queryMap);
            Map<String, Object> bodyMap = this.processBody(operation.getBody(), operation.getContentType());
            httpConfig.put(ParamScope.BODY.getScope(), bodyMap);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_PARAM_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfaceParamProcessAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_PARAM_EXCEPTION.getMessage()), (Throwable)e);
        }
        return httpConfig;
    }

    private Map<String, Object> processHeader(List<ApiDataStructure> headers) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(headers)) {
            headers.forEach(header -> headerMap.put(header.getName(), String.format("${param.%s}", header.getName())));
        }
        return headerMap;
    }

    private Map<String, Object> processQuery(List<ApiDataStructure> query) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(query)) {
            Map<String, Object> params = query.stream().collect(Collectors.toMap(ApiDataStructure::getName, param -> String.format("${param.%s}", param.getName())));
            queryMap.putAll(params);
        }
        return queryMap;
    }

    private Map<String, Object> processBody(List<ApiDataStructure> body, String contentType) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(body)) {
            HashMap bodyParam = new HashMap();
            body.forEach(param -> bodyParam.putAll(this.paramTypeProcess((ApiDataStructure)param)));
            if (HttpBodyEnum.JSON.getType().equalsIgnoreCase(contentType)) {
                String bodyStr = JSONObject.toJSONString(bodyParam);
                bodyMap.put(HttpBodyEnum.JSON.getType(), bodyStr);
            } else {
                bodyMap.putAll(bodyParam);
            }
        }
        return bodyMap;
    }

    private Map<String, Object> paramTypeProcess(ApiDataStructure param) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        ParamTypeEnum paramTypeEnum = ParamTypeEnum.fromValue(param.getDataType());
        switch (paramTypeEnum) {
            case ARRAY_OBJECT: {
                ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
                array.add(this.recusionBody(param));
                bodyMap.put(param.getName(), array);
                break;
            }
            case OBJECT: {
                bodyMap.put(param.getName(), this.recusionBody(param));
                break;
            }
            default: {
                bodyMap.put(param.getName(), String.format("${param.%s}", param.getName()));
            }
        }
        return bodyMap;
    }

    private Map<String, Object> recusionBody(ApiDataStructure param) {
        HashMap<String, Object> currentMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)param.getProperties())) {
            param.getProperties().forEach(property -> currentMap.putAll(this.paramTypeProcess((ApiDataStructure)property)));
        } else {
            currentMap.put(param.getName(), String.format("${param.%s}", param.getName()));
        }
        return currentMap;
    }

    private void publishApi(RmiInterface rmiInterface, Long connectorId) {
        PushBackCtx pushBackCtx = new PushBackCtx();
        ApiNamingDto apiNaming = new ApiNamingDto();
        apiNaming.setId(EngineUtil.getId());
        apiNaming.setBusinessId(rmiInterface.getRmiCode());
        apiNaming.setBusinessType(ConnectorTypeEnum.API.getType());
        apiNaming.setServiceName(rmiInterface.getRmiCode());
        apiNaming.setBusinessName(rmiInterface.getRmiName());
        pushBackCtx.addApiNaming(apiNaming);
        NodeBusinessDto nodeBusinessDto = new NodeBusinessDto();
        nodeBusinessDto.setNodeId(EngineUtil.getId());
        nodeBusinessDto.setModelId(connectorId);
        nodeBusinessDto.setNodeName(apiNaming.getServiceName());
        nodeBusinessDto.setNodeDec(apiNaming.getBusinessName());
        nodeBusinessDto.setDataServiceCode(rmiInterface.getRmiCode());
        nodeBusinessDto.setDataServiceActionName("com.jxdinfo.hussar.support.engine.plugin.rmi.support.solidorg.RmiGainDataGhServiceImpl");
        nodeBusinessDto.setNodeType(apiNaming.getBusinessType());
        pushBackCtx.addNodeBusiness((NodeBusiness)nodeBusinessDto);
        try {
            EngineBussnessdataConfigService engineBussnessdataConfigService = (EngineBussnessdataConfigService)SpringContextHolder.getBean(EngineBussnessdataConfigService.class);
            engineBussnessdataConfigService.pushApi(pushBackCtx);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_PUBLISH_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfacePublishAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_PUBLISH_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private void deleteNodeBusiness(String nodeName) {
        if (HussarUtils.isEmpty((Object)nodeName)) {
            return;
        }
        try {
            NodeBusinessService nodeBusinessService = (NodeBusinessService)SpringContextHolder.getBean(NodeBusinessService.class);
            LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(NodeBusiness.class).eq(NodeBusiness::getNodeName, (Object)nodeName);
            List nodeBusinesses = nodeBusinessService.list((Wrapper)query);
            if (HussarUtils.isNotEmpty((Object)nodeBusinesses)) {
                Set nodeBusinessIds = nodeBusinesses.stream().map(NodeBusiness::getNodeId).collect(Collectors.toSet());
                nodeBusinessService.removeByIds(nodeBusinessIds);
            }
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_NOBUSINESS_DELETE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiNodeBusinessDeleteAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_NOBUSINESS_DELETE_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private void deleteApiNaming(String busniessId) {
        if (HussarUtils.isEmpty((Object)busniessId)) {
            return;
        }
        try {
            ApiNamingService apiNamingService = (ApiNamingService)SpringContextHolder.getBean(ApiNamingService.class);
            LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(ApiNaming.class).eq(ApiNaming::getBusinessId, (Object)busniessId);
            List apiNamings = apiNamingService.list((Wrapper)query);
            if (HussarUtils.isNotEmpty((Object)apiNamings)) {
                Set apiNamingIds = apiNamings.stream().map(ApiNaming::getId).collect(Collectors.toSet());
                apiNamingService.removeByIds(apiNamingIds);
            }
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_APINAMING_DELETE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfaceNameDeleteAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_APINAMING_DELETE_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private void deleteRmiConnector(String rmiConnectorId) {
        if (HussarUtils.isEmpty((Object)rmiConnectorId)) {
            return;
        }
        try {
            RmiConnectorService rmiConnectorService = (RmiConnectorService)SpringContextHolder.getBean(RmiConnectorService.class);
            rmiConnectorService.removeById((Serializable)((Object)rmiConnectorId));
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_DELETE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiConnectorDeleteAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_CONNECTOR_DELETE_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    private void deleteRmiInterface(String rmiInterfaceId) {
        if (HussarUtils.isEmpty((Object)rmiInterfaceId)) {
            return;
        }
        try {
            RmiInterfaceService rmiInterfaceService = (RmiInterfaceService)SpringContextHolder.getBean(RmiInterfaceService.class);
            rmiInterfaceService.removeById((Serializable)((Object)rmiInterfaceId));
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_DELETE_EXCEPTION.getCode()), TranslateUtil.getTranslateName((String)"dataset.apiDatasetRmiInterfaceInfoDeleteAbnormal", (String)DataSetErrorCodeEnum.DATASET_RMI_INTERFACE_DELETE_EXCEPTION.getMessage()), (Throwable)e);
        }
    }

    public SqlConfigSchema1 packageDataSetParam(DsTableInfo tableInfo, Long dataSourceId, String dataSourceName) {
        return DataSetParamUtil.packageDataSetParam(tableInfo, dataSourceId, dataSourceName);
    }

    public static void main(String[] args) {
        String str = "{\"id\":\"08bf4e30-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"\",\"type\":\"\",\"comment\":\"\",\"url\":\"dad\",\"requestMode\":\"GET\",\"query\":[],\"body\":[{\"id\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"body\",\"comment\":\"body\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[{\"id\":\"169b4770-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"id\",\"comment\":\"id\",\"dataType\":\"string\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"\",\"parentId\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\",\"defaultValue\":\"2\"},{\"id\":\"1d9be1b0-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"data\",\"comment\":\"data\",\"dataType\":\"array\",\"objectType\":\"\",\"properties\":[{\"id\":\"248b3de0-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"name\",\"comment\":\"name\",\"dataType\":\"string\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"\",\"parentId\":\"1d9be1b0-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\",\"defaultValue\":\"1\"}],\"baseDataType\":\"\",\"parentId\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\"}],\"baseDataType\":\"\",\"parentId\":\"\",\"reference\":\"\"}],\"returnValue\":{\"objectType\":\"object\",\"properties\":[]},\"nodePath\":\"\",\"hostPortConfigCode\":\"report.API_LOCAL\"}";
    }
}

