/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.dataset.dao.DataSetTableNameMapper;
import com.jxdinfo.hussar.dataset.dto.DataSetColumnNameDto;
import com.jxdinfo.hussar.dataset.dto.DataSetTableNameDto;
import com.jxdinfo.hussar.dataset.factory.DbDataTypeStrategyFactory;
import com.jxdinfo.hussar.dataset.model.DataSetColumnName;
import com.jxdinfo.hussar.dataset.model.DataSetTableName;
import com.jxdinfo.hussar.dataset.service.IDataSetColumnNameService;
import com.jxdinfo.hussar.dataset.service.IDataSetTableNameService;
import com.jxdinfo.hussar.dataset.service.IDataTypeStrategy;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetTableNameServiceImpl
extends HussarServiceImpl<DataSetTableNameMapper, DataSetTableName>
implements IDataSetTableNameService {
    private static Logger logger = LoggerFactory.getLogger(DataSetTableNameServiceImpl.class);
    @Resource
    private DatasourceDataService datasourceDataService;
    @Resource
    private DataSetTableNameMapper dataSetTableNameMapper;
    @Resource
    private IDataSetColumnNameService dataSetColumnNameService;
    @Resource
    private SysDataSourceService sysDataSourceService;

    public void flushed(Long dataSourceId) {
        this.flushed(dataSourceId, false);
    }

    public void flushed(Long dataSourceId, boolean queryField) {
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)dataSourceId);
        this.syncTable(sysDataSource, queryField);
    }

    public List<DataSetTableName> getDataSetTableName(Long dataSourceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(HussarUtils.isNotEmpty((Object)dataSourceId), DataSetTableName::getDbId, (Object)dataSourceId);
        return this.dataSetTableNameMapper.selectList((Wrapper)queryWrapper);
    }

    public List<DataSetTableNameDto> getTableInfoListByDataSourceId(Long datasourceId) {
        List<DataSetColumnNameDto> dataSetColumnNameDtos = this.dataSetTableNameMapper.getTableInfoListByDataSourceId(datasourceId);
        if (HussarUtils.isNotEmpty(dataSetColumnNameDtos)) {
            HashMap<String, DataSetTableNameDto> tableMap = new HashMap<String, DataSetTableNameDto>();
            String tableName = "";
            for (DataSetColumnNameDto dsColumnNameDto : dataSetColumnNameDtos) {
                if (!tableName.equalsIgnoreCase(dsColumnNameDto.getTableName())) {
                    DataSetTableNameDto dataSetTable = (DataSetTableNameDto)HussarUtils.copyProperties((Object)dsColumnNameDto, DataSetTableNameDto.class);
                    dataSetTable.setColumns(new ArrayList());
                    tableMap.put(dsColumnNameDto.getTableName(), dataSetTable);
                }
                ((DataSetTableNameDto)tableMap.get(dsColumnNameDto.getTableName())).getColumns().add(dsColumnNameDto);
            }
            return (List)tableMap.values();
        }
        return new ArrayList<DataSetTableNameDto>();
    }

    public List<DataSetColumnNameDto> getColumnByTableName(Long dataSourceId, String tableName) {
        return this.dataSetColumnNameService.getColumnByTableName(dataSourceId, tableName);
    }

    public List<DataSetTableNameDto> getTableInfoByDataSourceId(Long datasourceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(HussarUtils.isNotEmpty((Object)datasourceId), DataSetTableName::getDbId, (Object)datasourceId);
        List tableNames = this.dataSetTableNameMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)tableNames)) {
            return tableNames.stream().map(table -> (DataSetTableNameDto)HussarUtils.copyProperties((Object)table, DataSetTableNameDto.class)).collect(Collectors.toList());
        }
        return new ArrayList<DataSetTableNameDto>();
    }

    public List<DsTableInfo> getTablesByDb(SysDataSource sysDataSource, Boolean queryField) {
        List<DsTableInfo> tableInfoList = queryField != false ? this.getDsTableInfoByDb(sysDataSource) : this.getDsTableInfoNoColumnByDb(sysDataSource);
        return tableInfoList;
    }

    @HussarTransactional
    public void syncTable(SysDataSource sysDataSource, Boolean queryField) {
        try {
            this.syncProcess(sysDataSource, queryField);
        }
        catch (HussarException e) {
            String message = HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage();
            logger.error("\u6570\u636e\u6e90\u3010{}\u3011\u540c\u6b65\u8868\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a", (Object)sysDataSource.getDbName(), (Object)message);
            throw new HussarException(String.format(TranslateUtil.getTranslateName((String)"dataset.syncDataSourceTableInfoFail", (String)"\u6570\u636e\u6e90\u3010%s\u3011\u540c\u6b65\u8868\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s"), sysDataSource.getDbName(), message), (Throwable)e);
        }
    }

    private List<DsTableInfo> getDsTableInfoByDb(SysDataSource sysDataSource) {
        try {
            return this.datasourceDataService.getTableInfoWithFieldInfo(sysDataSource, "ALL");
        }
        catch (Exception e) {
            String message = HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage();
            throw new HussarException(message, (Throwable)e);
        }
    }

    private List<DsTableInfo> getDsTableInfoNoColumnByDb(SysDataSource sysDataSource) {
        try {
            return this.datasourceDataService.getTableInfoWithoutFiled(sysDataSource, "ALL");
        }
        catch (Exception e) {
            String message = HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage();
            throw new HussarException(message, (Throwable)e);
        }
    }

    private DataSetTableName dsTableToDataSetTableName(DsTableInfo dsTableInfo, Long dataSourceId) {
        DataSetTableName tableName = new DataSetTableName();
        tableName.setId(EngineUtil.getId());
        tableName.setTableName(dsTableInfo.getName());
        tableName.setTableType(dsTableInfo.getType());
        tableName.setTableComment(dsTableInfo.getComment());
        tableName.setDbId(dataSourceId);
        return tableName;
    }

    private List<DataSetColumnName> dsTableFieldToColumnName(List<DsTableField> dsTableFields, Long tableId, String dataSourceName) {
        if (HussarUtils.isEmpty(dsTableFields)) {
            return new ArrayList<DataSetColumnName>();
        }
        IDataTypeStrategy dataTypeStrategy = DbDataTypeStrategyFactory.getStrategy(dataSourceName);
        return dsTableFields.stream().map(tableField -> {
            DataSetColumnName columnName = new DataSetColumnName();
            columnName.setTableId(tableId);
            columnName.setColumnName(tableField.getName());
            columnName.setColumnComment(tableField.getComment());
            columnName.setDataDot(Integer.valueOf(tableField.getDataDot()));
            columnName.setDataLength(Long.valueOf(tableField.getDataLength()));
            columnName.setDataType(tableField.getType());
            columnName.setPrimarys(tableField.getPrimarys());
            columnName.setDataIsEmpty(Integer.valueOf(tableField.getDataIsEmpty() ? 1 : 0));
            columnName.setJdbcType(tableField.getType());
            columnName.setJavaType(dataTypeStrategy.convertJdbcToJava(tableField.getType()));
            return columnName;
        }).collect(Collectors.toList());
    }

    private void syncProcess(SysDataSource sysDataSource, Boolean queryField) {
        List<DataSetTableName> tables;
        List<DsTableInfo> tableInfoList = this.getTablesByDb(sysDataSource, queryField);
        Map<String, Object> result = this.compareDsTableAndTableName(tableInfoList, tables = this.getDataSetTableName(sysDataSource.getId()), sysDataSource);
        if (result.containsKey("addList")) {
            List addList = (List)result.get("addList");
            this.saveBatch(addList);
        }
        if (result.containsKey("columnNames")) {
            List columnNames = (List)result.get("columnNames");
            this.dataSetColumnNameService.saveBatch(columnNames);
        }
        if (result.containsKey("removeList")) {
            List tableNameIds = (List)result.get("removeList");
            this.removeBatchByIds(tableNameIds);
            this.dataSetColumnNameService.deleteByTableIds(tableNameIds);
        }
    }

    private Map<String, Object> compareDsTableAndTableName(List<DsTableInfo> tableInfoList, List<DataSetTableName> tables, SysDataSource sysDataSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long dataSourceId = sysDataSource.getId();
        String dataSourceName = sysDataSource.getDbName();
        ArrayList<DataSetTableName> addList = new ArrayList<DataSetTableName>();
        ArrayList<DataSetColumnName> columnNames = new ArrayList<DataSetColumnName>();
        if (HussarUtils.isEmpty(tables)) {
            for (DsTableInfo tableInfo : tableInfoList) {
                DataSetTableName dataSetTableName = this.dsTableToDataSetTableName(tableInfo, dataSourceId);
                addList.add(dataSetTableName);
                columnNames.addAll(this.dsTableFieldToColumnName(tableInfo.getFields(), dataSetTableName.getId(), dataSourceName));
            }
        } else {
            Map<String, DataSetTableName> tableMap = tables.stream().collect(Collectors.toMap(DataSetTableName::getTableName, obj -> obj));
            for (DsTableInfo dsTableInfo : tableInfoList) {
                if (tableMap.containsKey(dsTableInfo.getName())) {
                    tableMap.remove(dsTableInfo.getName());
                    continue;
                }
                DataSetTableName dataSetTableName = this.dsTableToDataSetTableName(dsTableInfo, dataSourceId);
                addList.add(dataSetTableName);
                columnNames.addAll(this.dsTableFieldToColumnName(dsTableInfo.getFields(), dataSetTableName.getId(), dataSourceName));
            }
            if (HussarUtils.isNotEmpty(tableMap)) {
                List tableNameIds = tableMap.values().stream().map(DataSetTableName::getId).collect(Collectors.toList());
                result.put("removeList", tableNameIds);
            }
        }
        result.put("addList", addList);
        result.put("columnNames", columnNames);
        return result;
    }
}

