/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum PgDataTypeEnum {
    INT("INT", JdbcType.INTEGER.name(), Integer.class, "int"),
    INTEGER("INTEGER", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGINT("BIGINT", JdbcType.BIGINT.name(), Long.class, "long"),
    SMALLINT("SMALLINT", JdbcType.SMALLINT.name(), Integer.class, "int"),
    TINYINT("TINYINT", JdbcType.TINYINT.name(), Integer.class, "int"),
    NUMERIC("NUMERIC", JdbcType.NUMERIC.name(), Double.class, "double"),
    REAL("REAL", JdbcType.REAL.name(), Double.class, "double"),
    DOUBLE("DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    FLOAT("FLOAT", JdbcType.FLOAT.name(), Double.class, "double"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    VARCHAR("VARCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    TEXT("TEXT", JdbcType.CLOB.name(), String.class, "string"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "timestamp"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    TIME("TIME", JdbcType.TIME.name(), Time.class, "time"),
    BOOLEAN("BOOLEAN", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    BOOL("BOOL", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    OTHER("OTHER", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private PgDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static PgDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (PgDataTypeEnum value : PgDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

