/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum DmDataTypeEnum {
    SMALLINT("SMALLINT", JdbcType.SMALLINT.name(), Integer.class, "int"),
    INT("INT", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGINT("BIGINT", JdbcType.BIGINT.name(), Long.class, "long"),
    DECIMAL("DECIMAL", JdbcType.DECIMAL.name(), Double.class, "double"),
    NUMERIC("NUMERIC", JdbcType.DECIMAL.name(), Double.class, "double"),
    REAL("REAL", JdbcType.REAL.name(), Double.class, "double"),
    SMALLSERIAL("SMALLSERIAL", JdbcType.SMALLINT.name(), Integer.class, "int"),
    SERIAL("SERIAL", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGSERIAL("BIGSERIAL", JdbcType.BIGINT.name(), Long.class, "long"),
    DOUBLE("DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    MONEY("MONEY", JdbcType.OTHER.name(), String.class, "string"),
    VARCHAR("VARCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    TEXT("TEXT", JdbcType.CLOB.name(), String.class, "string"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "timestamp"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    TIME("TIME", JdbcType.TIME.name(), Time.class, "time"),
    INTERVAL("INTERVAL", JdbcType.OTHER.name(), String.class, "string"),
    BOOLEAN("BOOLEAN", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    OTHER("OTHER", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private DmDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static DmDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (DmDataTypeEnum value : DmDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

