/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.utils;

import com.jxdinfo.hussar.dataset.dto.HttpDataDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpUrlRegexUtil {
    public static HttpDataDto getHttpDataDto(String url) {
        String regex = "^(\\w+):\\/\\/(?:[^/@:]+(?::[^/@:]*)?@)?([^/:]+)(?::(\\d+))?([^?#]*)?(?:\\?([^#]*))?(?:#(.*))?$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String protocol = matcher.group(1);
            String ipAddress = matcher.group(2);
            String port = matcher.group(3);
            if (HussarUtils.isEmpty((Object)port)) {
                port = "80";
            }
            String path = matcher.group(4);
            return new HttpDataDto(protocol, ipAddress, port, path);
        }
        throw new HussarException(String.format("\u4e0d\u6ee1\u8db3\u8bf7\u6c42\u670d\u52a1\u5730\u5740\u7684\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5[%s]\uff01", url));
    }

    public static void main(String[] args) {
        HttpDataDto httpDataDto = HttpUrlRegexUtil.getHttpDataDto("https://lbs.amap.com/");
        System.out.println(httpDataDto.getProtocol());
        System.out.println(httpDataDto.getIpAddress());
        System.out.println(httpDataDto.getPort());
        System.out.println(httpDataDto.getPath());
    }
}

