/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datapush.listener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datapush.bo.HttpRequestBO;
import com.jxdinfo.hussar.datapush.properties.UnifiedTodoPushProperty;
import com.jxdinfo.hussar.datapush.utils.HttpURLConnectionUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushAbstractListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnifiedTodoPushListener
extends DataPushAbstractListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedTodoPushListener.class);
    private static final String APPLY_NODE = "\u7533\u8bf7";
    private static final String END_NODE = "\u7ed3\u675f";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UnifiedTodoPushProperty iamDataPushProperty;

    public void addTask(DataPush dataPush) {
        if (APPLY_NODE.equals(dataPush.getTaskDefinitionName())) {
            return;
        }
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", this.iamDataPushProperty.getSysCode());
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        try {
            JsonNode formUriNode = this.objectMapper.readTree(dataPush.getUrl());
            reqBody.put("pcurl", this.getWebFormUrl(formUriNode.get("web").asText()));
            reqBody.put("appurl", formUriNode.get("mobile").asText());
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        reqBody.put("creator", dataPush.getStartUserId());
        reqBody.put("createdatetime", dataPush.getStartDate().getTime());
        reqBody.put("receiver", dataPush.getUserId());
        reqBody.put("receivedatetime", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO receiveTodoRequest = new HttpRequestBO.HttpRequestBOBuilder().url(this.iamDataPushProperty.getReceiveTodoRequestUrl()).requestBody(reqBody).request();
        HttpURLConnectionUtil.sendPost(receiveTodoRequest);
        LOGGER.info("====================\u63a8\u9001\u5f85\u529e\u53c2\u6570====================\n{}", (Object)receiveTodoRequest);
    }

    public void completeTask(DataPush dataPush) {
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", this.iamDataPushProperty.getSysCode());
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        reqBody.put("receiver", dataPush.getUserId());
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO processDoneRequest = new HttpRequestBO.HttpRequestBOBuilder().url(this.iamDataPushProperty.getProcessDoneRequestUrl()).requestBody(reqBody).request();
        HttpURLConnectionUtil.sendPost(processDoneRequest);
        LOGGER.info("====================\u63a8\u9001\u5df2\u529e\u53c2\u6570====================\n{}", (Object)processDoneRequest);
        super.completeTask(dataPush);
    }

    public void deleteTask(DataPush dataPush) {
        super.deleteTask(dataPush);
    }

    public void entrustTask(DataPush dataPush) {
        super.entrustTask(dataPush);
    }

    public void transferUserTask(DataPush dataPush) {
        super.transferUserTask(dataPush);
    }

    public void rejectTask(DataPush dataPush) {
        super.rejectTask(dataPush);
    }

    public void revokeTask(DataPush dataPush) {
        super.revokeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        super.freeJumpTask(dataPush);
    }

    public void addUser(DataPush dataPush) {
        super.addUser(dataPush);
    }

    public void deleteMultiTask(DataPush dataPush) {
        super.deleteMultiTask(dataPush);
    }

    public void addCcTask(DataPush dataPush) {
        super.addCcTask(dataPush);
    }

    public void addCcTask(List<DataPush> dataPushList) {
        super.addCcTask(dataPushList);
    }

    public void readCcTask(DataPush dataPush) {
        super.readCcTask(dataPush);
    }

    public void deleteCcTask(DataPush dataPush) {
        super.deleteCcTask(dataPush);
    }

    public void addUrgeTask(DataPush dataPush) {
        super.addUrgeTask(dataPush);
    }

    public void endProcess(DataPush dataPush) {
        super.endProcess(dataPush);
    }

    public void transferTask(DataPush dataPush) {
        super.transferTask(dataPush);
    }

    public void reTransferTask(DataPush dataPush) {
        super.reTransferTask(dataPush);
    }

    public void changeProcessState(DataPush dataPush) {
        super.changeProcessState(dataPush);
    }

    public void addStartProcess(DataPush dataPush) {
        super.addStartProcess(dataPush);
    }

    public void updateStartProcess(DataPush dataPush) {
        super.updateStartProcess(dataPush);
    }

    public void deleteStartProcess(DataPush dataPush) {
        super.deleteStartProcess(dataPush);
    }

    public void updateBusinessInfo(DataPush dataPush) {
        super.updateBusinessInfo(dataPush);
    }

    public void changeProcessNode(DataPush dataPush) {
        if (!END_NODE.equals(dataPush.getProcessNode())) {
            super.changeProcessNode(dataPush);
            return;
        }
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", this.iamDataPushProperty.getSysCode());
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        reqBody.put("receiver", dataPush.getUserId());
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO processOverRequest = new HttpRequestBO.HttpRequestBOBuilder().url(this.iamDataPushProperty.getProcessOverRequestUrl()).requestBody(reqBody).request();
        HttpURLConnectionUtil.sendPost(processOverRequest);
        LOGGER.info("====================\u63a8\u9001\u6d41\u7a0b\u5b8c\u7ed3\u53c2\u6570====================\n{}", (Object)processOverRequest);
    }

    public void processChange(ProcessDataPush processDataPush) {
        super.processChange(processDataPush);
    }

    public void processChangeList(List<ProcessDataPush> processDataPushList) {
        super.processChangeList(processDataPushList);
    }

    private String getWebFormUrl(String webUri) {
        StringBuilder webFormUrl = new StringBuilder();
        return webFormUrl.toString();
    }
}

